/*
 * Decompiled with CFR 0.152.
 */
package com.ailiwean.core.zxing.core.aztec.decoder;

import com.ailiwean.core.zxing.core.FormatException;
import com.ailiwean.core.zxing.core.aztec.AztecDetectorResult;
import com.ailiwean.core.zxing.core.common.BitMatrix;
import com.ailiwean.core.zxing.core.common.DecoderResult;
import com.ailiwean.core.zxing.core.common.DetectorResult;
import com.ailiwean.core.zxing.core.common.reedsolomon.GenericGF;
import com.ailiwean.core.zxing.core.common.reedsolomon.ReedSolomonDecoder;
import com.ailiwean.core.zxing.core.common.reedsolomon.ReedSolomonException;
import java.util.Arrays;

public final class Decoder {
    private static final String[] DIGIT_TABLE;
    private static final String[] LOWER_TABLE;
    private static final String[] MIXED_TABLE;
    private static final String[] PUNCT_TABLE;
    private static final String[] UPPER_TABLE;
    private AztecDetectorResult ddata;

    static {
        UPPER_TABLE = new String[]{"CTRL_PS", " ", "A", "B", "C", "D", "E", "F", "G", "H", "I", "J", "K", "L", "M", "N", "O", "P", "Q", "R", "S", "T", "U", "V", "W", "X", "Y", "Z", "CTRL_LL", "CTRL_ML", "CTRL_DL", "CTRL_BS"};
        LOWER_TABLE = new String[]{"CTRL_PS", " ", "a", "b", "c", "d", "e", "f", "g", "h", "i", "j", "k", "l", "m", "n", "o", "p", "q", "r", "s", "t", "u", "v", "w", "x", "y", "z", "CTRL_US", "CTRL_ML", "CTRL_DL", "CTRL_BS"};
        MIXED_TABLE = new String[]{"CTRL_PS", " ", "\u0001", "\u0002", "\u0003", "\u0004", "\u0005", "\u0006", "\u0007", "\b", "\t", "\n", "\u000b", "\f", "\r", "\u001b", "\u001c", "\u001d", "\u001e", "\u001f", "@", "\\", "^", "_", "`", "|", "~", "\u007f", "CTRL_LL", "CTRL_UL", "CTRL_PL", "CTRL_BS"};
        PUNCT_TABLE = new String[]{"", "\r", "\r\n", ". ", ", ", ": ", "!", "\"", "#", "$", "%", "&", "'", "(", ")", "*", "+", ",", "-", ".", "/", ":", ";", "<", "=", ">", "?", "[", "]", "{", "}", "CTRL_UL"};
        DIGIT_TABLE = new String[]{"CTRL_PS", " ", "0", "1", "2", "3", "4", "5", "6", "7", "8", "9", ",", ".", "CTRL_UL", "CTRL_US"};
    }

    static byte[] convertBoolArrayToByteArray(boolean[] blArray) {
        byte[] byArray = new byte[(blArray.length + 7) / 8];
        for (int i3 = 0; i3 < byArray.length; ++i3) {
            byArray[i3] = Decoder.readByte(blArray, i3 * 8);
        }
        return byArray;
    }

    private boolean[] correctBits(boolean[] object) throws FormatException {
        block19: {
            int n2;
            int n3;
            GenericGF genericGF;
            int n4 = this.ddata.getNbLayers();
            int n5 = 8;
            if (n4 <= 2) {
                n5 = 6;
                genericGF = GenericGF.AZTEC_DATA_6;
            } else if (this.ddata.getNbLayers() <= 8) {
                genericGF = GenericGF.AZTEC_DATA_8;
            } else if (this.ddata.getNbLayers() <= 22) {
                n5 = 10;
                genericGF = GenericGF.AZTEC_DATA_10;
            } else {
                n5 = 12;
                genericGF = GenericGF.AZTEC_DATA_12;
            }
            int n6 = this.ddata.getNbDatablocks();
            int n7 = ((boolean[])object).length / n5;
            if (n7 < n6) break block19;
            n4 = ((boolean[])object).length;
            int[] nArray = new int[n7];
            n4 %= n5;
            int n8 = 0;
            while (n8 < n7) {
                nArray[n8] = Decoder.readCode(object, n4, n5);
                ++n8;
                n4 += n5;
            }
            try {
                object = new ReedSolomonDecoder;
                object(genericGF);
                object.decode(nArray, n7 - n6);
                n3 = (1 << n5) - 1;
                n4 = 0;
            }
            catch (ReedSolomonException reedSolomonException) {
                throw FormatException.getFormatInstance(reedSolomonException);
            }
            for (n8 = 0; n8 < n6; ++n8) {
                block20: {
                    block22: {
                        block21: {
                            n2 = nArray[n8];
                            if (n2 == 0 || n2 == n3) break block20;
                            if (n2 == 1) break block21;
                            n7 = n4;
                            if (n2 != n3 - 1) break block22;
                        }
                        n7 = n4 + 1;
                    }
                    n4 = n7;
                    continue;
                }
                throw FormatException.getFormatInstance();
            }
            object = new boolean[n6 * n5 - n4];
            n4 = 0;
            for (n7 = 0; n7 < n6; ++n7) {
                boolean bl;
                int n9 = nArray[n7];
                if (n9 != 1 && n9 != n3 - 1) {
                    n2 = n5 - 1;
                    while (true) {
                        n8 = ++n4;
                        if (n2 >= 0) {
                            bl = (1 << n2 & n9) != 0;
                            object[n4] = bl;
                            --n2;
                            continue;
                        }
                        break;
                    }
                } else {
                    bl = n9 > 1;
                    Arrays.fill(object, n4, n4 + n5 - 1, bl);
                    n8 = n4 + (n5 - 1);
                }
                n4 = n8;
            }
            return object;
        }
        throw FormatException.getFormatInstance();
    }

    private boolean[] extractBits(BitMatrix bitMatrix) {
        int n2;
        int n3;
        int n4;
        boolean bl = this.ddata.isCompact();
        int n5 = this.ddata.getNbLayers();
        int n6 = bl ? 11 : 14;
        int n7 = n6 + n5 * 4;
        int[] nArray = new int[n7];
        boolean[] blArray = new boolean[Decoder.totalBitsInLayer(n5, bl)];
        if (bl) {
            for (n6 = 0; n6 < nArray.length; ++n6) {
                nArray[n6] = n6;
            }
        } else {
            n4 = n7 / 2;
            n3 = (n7 + 1 + (n4 - 1) / 15 * 2) / 2;
            for (n6 = 0; n6 < n4; ++n6) {
                n2 = n6 / 15 + n6;
                nArray[n4 - n6 - 1] = n3 - n2 - 1;
                nArray[n4 + n6] = n2 + n3 + 1;
            }
        }
        n3 = 0;
        for (n6 = 0; n6 < n5; ++n6) {
            n4 = bl ? 9 : 12;
            int n8 = (n5 - n6) * 4 + n4;
            int n9 = n6 * 2;
            int n10 = n7 - 1 - n9;
            for (n4 = 0; n4 < n8; ++n4) {
                int n11 = n4 * 2;
                for (n2 = 0; n2 < 2; ++n2) {
                    int n12 = n9 + n2;
                    int n13 = nArray[n12];
                    int n14 = n9 + n4;
                    blArray[n3 + n11 + n2] = bitMatrix.get(n13, nArray[n14]);
                    n14 = nArray[n14];
                    n13 = n10 - n2;
                    blArray[n8 * 2 + n3 + n11 + n2] = bitMatrix.get(n14, nArray[n13]);
                    n13 = nArray[n13];
                    n14 = n10 - n4;
                    blArray[n8 * 4 + n3 + n11 + n2] = bitMatrix.get(n13, nArray[n14]);
                    blArray[n8 * 6 + n3 + n11 + n2] = bitMatrix.get(nArray[n14], nArray[n12]);
                }
            }
            n3 += n8 * 8;
        }
        return blArray;
    }

    private static String getCharacter(Table table, int n2) {
        int n3 = 1.$SwitchMap$com$ailiwean$core$zxing$core$aztec$decoder$Decoder$Table[table.ordinal()];
        if (n3 != 1) {
            if (n3 != 2) {
                if (n3 != 3) {
                    if (n3 != 4) {
                        if (n3 == 5) {
                            return DIGIT_TABLE[n2];
                        }
                        throw new IllegalStateException("Bad table");
                    }
                    return PUNCT_TABLE[n2];
                }
                return MIXED_TABLE[n2];
            }
            return LOWER_TABLE[n2];
        }
        return UPPER_TABLE[n2];
    }

    /*
     * Enabled aggressive block sorting
     */
    private static String getEncodedData(boolean[] blArray) {
        int n2 = blArray.length;
        Table table = Table.UPPER;
        Table table2 = Table.UPPER;
        StringBuilder stringBuilder = new StringBuilder(20);
        int n3 = 0;
        while (n3 < n2) {
            block10: {
                int n4;
                int n5;
                block12: {
                    block11: {
                        int n6;
                        if (table2 != Table.BINARY) break block11;
                        if (n2 - n3 < 5) {
                            return stringBuilder.toString();
                        }
                        n5 = Decoder.readCode(blArray, n3, 5);
                        n3 = n6 = n3 + 5;
                        n4 = n5;
                        if (n5 == 0) {
                            if (n2 - n6 < 11) {
                                return stringBuilder.toString();
                            }
                            n4 = Decoder.readCode(blArray, n6, 11) + 31;
                            n3 = n6 + 11;
                        }
                        break block12;
                    }
                    n4 = table2 == Table.DIGIT ? 4 : 5;
                    if (n2 - n3 < n4) {
                        return stringBuilder.toString();
                    }
                    n5 = Decoder.readCode(blArray, n3, n4);
                    n3 += n4;
                    String string2 = Decoder.getCharacter(table2, n5);
                    if (string2.startsWith("CTRL_")) {
                        Table table3 = Decoder.getTable(string2.charAt(5));
                        if (string2.charAt(6) == 'L') {
                            table = table3;
                            break block10;
                        } else {
                            table = table2;
                            table2 = table3;
                            continue;
                        }
                    }
                    stringBuilder.append(string2);
                    break block10;
                }
                for (n5 = 0; n5 < n4; n3 += 8, ++n5) {
                    if (n2 - n3 < 8) {
                        n3 = n2;
                        break;
                    }
                    stringBuilder.append((char)Decoder.readCode(blArray, n3, 8));
                }
            }
            table2 = table;
        }
        return stringBuilder.toString();
    }

    private static Table getTable(char c3) {
        if (c3 != 'B') {
            if (c3 != 'D') {
                if (c3 != 'P') {
                    if (c3 != 'L') {
                        if (c3 != 'M') {
                            return Table.UPPER;
                        }
                        return Table.MIXED;
                    }
                    return Table.LOWER;
                }
                return Table.PUNCT;
            }
            return Table.DIGIT;
        }
        return Table.BINARY;
    }

    public static String highLevelDecode(boolean[] blArray) {
        return Decoder.getEncodedData(blArray);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static byte readByte(boolean[] blArray, int n2) {
        int n3 = blArray.length - n2;
        if (n3 >= 8) {
            n2 = Decoder.readCode(blArray, n2, 8);
            return (byte)n2;
        }
        n2 = Decoder.readCode(blArray, n2, n3) << 8 - n3;
        return (byte)n2;
    }

    private static int readCode(boolean[] blArray, int n2, int n3) {
        int n4 = 0;
        for (int i3 = n2; i3 < n2 + n3; ++i3) {
            int n5;
            n4 = n5 = n4 << 1;
            if (!blArray[i3]) continue;
            n4 = n5 | 1;
        }
        return n4;
    }

    private static int totalBitsInLayer(int n2, boolean bl) {
        int n3 = bl ? 88 : 112;
        return (n3 + n2 * 16) * n2;
    }

    public DecoderResult decode(AztecDetectorResult object) throws FormatException {
        this.ddata = object;
        boolean[] blArray = this.correctBits(this.extractBits(((DetectorResult)object).getBits()));
        object = new DecoderResult(Decoder.convertBoolArrayToByteArray(blArray), Decoder.getEncodedData(blArray), null, null);
        ((DecoderResult)object).setNumBits(blArray.length);
        return object;
    }

    private static enum Table {
        UPPER,
        LOWER,
        MIXED,
        DIGIT,
        PUNCT,
        BINARY;

    }
}

