/*
 * Decompiled with CFR 0.152.
 */
package com.ailiwean.core.zxing.core.aztec;

import com.ailiwean.core.zxing.core.BarcodeFormat;
import com.ailiwean.core.zxing.core.EncodeHintType;
import com.ailiwean.core.zxing.core.Writer;
import com.ailiwean.core.zxing.core.aztec.encoder.AztecCode;
import com.ailiwean.core.zxing.core.aztec.encoder.Encoder;
import com.ailiwean.core.zxing.core.common.BitMatrix;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Map;

public final class AztecWriter
implements Writer {
    private static BitMatrix encode(String charSequence, BarcodeFormat barcodeFormat, int n2, int n3, Charset charset, int n4, int n5) {
        if (barcodeFormat == BarcodeFormat.AZTEC) {
            return AztecWriter.renderResult(Encoder.encode(((String)charSequence).getBytes(charset), n4, n5), n2, n3);
        }
        charSequence = new StringBuilder();
        ((StringBuilder)charSequence).append("Can only encode AZTEC, but got ");
        ((StringBuilder)charSequence).append((Object)barcodeFormat);
        throw new IllegalArgumentException(((StringBuilder)charSequence).toString());
    }

    private static BitMatrix renderResult(AztecCode object, int n2, int n3) {
        BitMatrix bitMatrix = ((AztecCode)object).getMatrix();
        if (bitMatrix != null) {
            int n4 = bitMatrix.getWidth();
            int n5 = bitMatrix.getHeight();
            n2 = Math.max(n2, n4);
            int n6 = Math.max(n3, n5);
            int n7 = Math.min(n2 / n4, n6 / n5);
            int n8 = (n2 - n4 * n7) / 2;
            n3 = (n6 - n5 * n7) / 2;
            object = new BitMatrix(n2, n6);
            n2 = 0;
            while (n2 < n5) {
                n6 = n8;
                int n9 = 0;
                while (n9 < n4) {
                    if (bitMatrix.get(n9, n2)) {
                        ((BitMatrix)object).setRegion(n6, n3, n7, n7);
                    }
                    ++n9;
                    n6 += n7;
                }
                ++n2;
                n3 += n7;
            }
            return object;
        }
        throw new IllegalStateException();
    }

    @Override
    public BitMatrix encode(String string2, BarcodeFormat barcodeFormat, int n2, int n3) {
        return this.encode(string2, barcodeFormat, n2, n3, null);
    }

    @Override
    public BitMatrix encode(String string2, BarcodeFormat barcodeFormat, int n2, int n3, Map<EncodeHintType, ?> object) {
        int n4;
        int n5;
        block4: {
            block5: {
                Charset charset;
                block2: {
                    block3: {
                        charset = StandardCharsets.ISO_8859_1;
                        n5 = 33;
                        if (object == null) break block2;
                        if (object.containsKey((Object)EncodeHintType.CHARACTER_SET)) {
                            charset = Charset.forName(object.get((Object)EncodeHintType.CHARACTER_SET).toString());
                        }
                        if (object.containsKey((Object)EncodeHintType.ERROR_CORRECTION)) {
                            n5 = Integer.parseInt(object.get((Object)EncodeHintType.ERROR_CORRECTION).toString());
                        }
                        if (!object.containsKey((Object)EncodeHintType.AZTEC_LAYERS)) break block3;
                        n4 = Integer.parseInt(object.get((Object)EncodeHintType.AZTEC_LAYERS).toString());
                        object = charset;
                        break block4;
                    }
                    object = charset;
                    break block5;
                }
                object = charset;
                n5 = 33;
            }
            n4 = 0;
        }
        return AztecWriter.encode(string2, barcodeFormat, n2, n3, (Charset)object, n5, n4);
    }
}

