/*
 * Decompiled with CFR 0.152.
 */
package com.ailiwean.core.zxing.core;

import com.ailiwean.core.zxing.core.BarcodeFormat;
import com.ailiwean.core.zxing.core.ResultMetadataType;
import com.ailiwean.core.zxing.core.ResultPoint;
import java.util.EnumMap;
import java.util.Map;

public final class Result {
    private final BarcodeFormat format;
    private final int numBits;
    private final byte[] rawBytes;
    private Map<ResultMetadataType, Object> resultMetadata;
    private ResultPoint[] resultPoints;
    private final String text;
    private final long timestamp;

    public Result(String string2, byte[] byArray, int n2, ResultPoint[] resultPointArray, BarcodeFormat barcodeFormat, long l3) {
        this.text = string2;
        this.rawBytes = byArray;
        this.numBits = n2;
        this.resultPoints = resultPointArray;
        this.format = barcodeFormat;
        this.resultMetadata = null;
        this.timestamp = l3;
    }

    public Result(String string2, byte[] byArray, ResultPoint[] resultPointArray, BarcodeFormat barcodeFormat) {
        this(string2, byArray, resultPointArray, barcodeFormat, System.currentTimeMillis());
    }

    public Result(String string2, byte[] byArray, ResultPoint[] resultPointArray, BarcodeFormat barcodeFormat, long l3) {
        int n2 = byArray == null ? 0 : byArray.length * 8;
        this(string2, byArray, n2, resultPointArray, barcodeFormat, l3);
    }

    public void addResultPoints(ResultPoint[] resultPointArray) {
        ResultPoint[] resultPointArray2 = this.resultPoints;
        if (resultPointArray2 == null) {
            this.resultPoints = resultPointArray;
        } else if (resultPointArray != null && resultPointArray.length > 0) {
            ResultPoint[] resultPointArray3 = new ResultPoint[resultPointArray2.length + resultPointArray.length];
            System.arraycopy(resultPointArray2, 0, resultPointArray3, 0, resultPointArray2.length);
            System.arraycopy(resultPointArray, 0, resultPointArray3, resultPointArray2.length, resultPointArray.length);
            this.resultPoints = resultPointArray3;
        }
    }

    public BarcodeFormat getBarcodeFormat() {
        return this.format;
    }

    public int getNumBits() {
        return this.numBits;
    }

    public byte[] getRawBytes() {
        return this.rawBytes;
    }

    public Map<ResultMetadataType, Object> getResultMetadata() {
        return this.resultMetadata;
    }

    public ResultPoint[] getResultPoints() {
        return this.resultPoints;
    }

    public String getText() {
        return this.text;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public void putAllMetadata(Map<ResultMetadataType, Object> map) {
        if (map != null) {
            Map<ResultMetadataType, Object> map2 = this.resultMetadata;
            if (map2 == null) {
                this.resultMetadata = map;
            } else {
                map2.putAll(map);
            }
        }
    }

    public void putMetadata(ResultMetadataType resultMetadataType, Object object) {
        if (this.resultMetadata == null) {
            this.resultMetadata = new EnumMap<ResultMetadataType, Object>(ResultMetadataType.class);
        }
        this.resultMetadata.put(resultMetadataType, object);
    }

    public String toString() {
        return this.text;
    }
}

