/*
 * Decompiled with CFR 0.152.
 */
package com.ailiwean.core.zxing.core;

import com.ailiwean.core.zxing.core.LuminanceSource;

public final class RGBLuminanceSource
extends LuminanceSource {
    private final int dataHeight;
    private final int dataWidth;
    private final int left;
    private final byte[] luminances;
    private final int top;

    public RGBLuminanceSource(int n2, int n3, int[] nArray) {
        super(n2, n3);
        this.dataWidth = n2;
        this.dataHeight = n3;
        int n4 = 0;
        this.left = 0;
        this.top = 0;
        n3 = n2 * n3;
        this.luminances = new byte[n3];
        for (n2 = n4; n2 < n3; ++n2) {
            n4 = nArray[n2];
            this.luminances[n2] = (byte)(((n4 >> 16 & 0xFF) + (n4 >> 7 & 0x1FE) + (n4 & 0xFF)) / 4);
        }
    }

    public RGBLuminanceSource(byte[] byArray, int n2, int n3, int n4, int n5, int n6, int n7) {
        super(n6, n7);
        if (n6 + n4 <= n2 && n7 + n5 <= n3) {
            this.luminances = byArray;
            this.dataWidth = n2;
            this.dataHeight = n3;
            this.left = n4;
            this.top = n5;
            return;
        }
        throw new IllegalArgumentException("Crop rectangle does not fit within image data.");
    }

    @Override
    public LuminanceSource crop(int n2, int n3, int n4, int n5) {
        return new RGBLuminanceSource(this.luminances, this.dataWidth, this.dataHeight, this.left + n2, this.top + n3, n4, n5);
    }

    @Override
    public byte[] getMatrix() {
        int n2 = this.getWidth();
        int n3 = this.getHeight();
        if (n2 == this.dataWidth && n3 == this.dataHeight) {
            return this.luminances;
        }
        int n4 = n2 * n3;
        byte[] byArray = new byte[n4];
        int n5 = this.top;
        int n6 = this.dataWidth;
        int n7 = n5 * n6 + this.left;
        n5 = n7;
        if (n2 == n6) {
            System.arraycopy(this.luminances, n7, byArray, 0, n4);
            return byArray;
        }
        for (int i3 = 0; i3 < n3; ++i3) {
            System.arraycopy(this.luminances, n5, byArray, i3 * n2, n2);
            n5 += this.dataWidth;
        }
        return byArray;
    }

    @Override
    public byte[] getRow(int n2, byte[] object) {
        block2: {
            Object object2;
            int n3;
            block4: {
                block3: {
                    if (n2 < 0 || n2 >= this.getHeight()) break block2;
                    n3 = this.getWidth();
                    if (object == null) break block3;
                    object2 = object;
                    if (((Object)object).length >= n3) break block4;
                }
                object2 = new byte[n3];
            }
            int n4 = this.top;
            int n5 = this.dataWidth;
            int n6 = this.left;
            System.arraycopy(this.luminances, (n2 + n4) * n5 + n6, object2, 0, n3);
            return object2;
        }
        object = new StringBuilder();
        ((StringBuilder)object).append("Requested row is outside the image: ");
        ((StringBuilder)object).append(n2);
        throw new IllegalArgumentException(((StringBuilder)object).toString());
    }

    @Override
    public boolean isCropSupported() {
        return true;
    }
}

