/*
 * Decompiled with CFR 0.152.
 */
package com.ailiwean.core.zxing.core;

import android.text.TextUtils;
import com.ailiwean.core.zxing.core.Binarizer;
import com.ailiwean.core.zxing.core.LuminanceSource;
import com.ailiwean.core.zxing.core.PlanarYUVLuminanceSourceRotate;
import com.ailiwean.core.zxing.core.common.HybridBinarizer;
import com.ailiwean.core.zxing.core.common.HybridBinarizerCrude;

public final class PlanarYUVLuminanceSource
extends LuminanceSource {
    private int dataHeight;
    private int dataWidth;
    Binarizer hybridBinary;
    Binarizer hybridBinaryCurde;
    private int left;
    private byte[] matrix;
    String tagId;
    private int top;

    public PlanarYUVLuminanceSource(byte[] byArray, int n2, int n3) {
        super(n2, n3);
        this.matrix = byArray;
    }

    public PlanarYUVLuminanceSource(byte[] byArray, int n2, int n3, int n4, int n5, int n6, int n7) {
        super(n6, n7);
        if (n6 + n4 <= n2 && n7 + n5 <= n3) {
            this.dataWidth = n2;
            this.dataHeight = n3;
            this.left = n4;
            this.top = n5;
            this.matrix = this.getGlobeMatrix(byArray);
            return;
        }
        this.dataHeight = 0;
        this.dataWidth = 0;
        this.left = 0;
        this.top = 0;
    }

    public PlanarYUVLuminanceSource copyAll() {
        return new PlanarYUVLuminanceSource((byte[])this.matrix.clone(), this.getWidth(), this.getHeight());
    }

    @Override
    public LuminanceSource crop(int n2, int n3, int n4, int n5) {
        return this;
    }

    public byte[] getGlobeMatrix(byte[] byArray) {
        int n2 = this.getWidth();
        int n3 = this.getHeight();
        if (n2 == this.dataWidth && n3 == this.dataHeight) {
            return byArray;
        }
        int n4 = n2 * n3;
        byte[] byArray2 = new byte[n4];
        int n5 = this.top;
        int n6 = this.dataWidth;
        int n7 = n5 * n6 + this.left;
        n5 = n7;
        if (n2 == n6) {
            System.arraycopy(byArray, n7, byArray2, 0, n4);
            return byArray2;
        }
        for (int i3 = 0; i3 < n3; ++i3) {
            System.arraycopy(byArray, n5, byArray2, i3 * n2, n2);
            n5 += this.dataWidth;
        }
        return byArray2;
    }

    public Binarizer getHybridBinary() {
        if (this.hybridBinary == null) {
            this.hybridBinary = new HybridBinarizer(this);
        }
        return this.hybridBinary;
    }

    public Binarizer getHybridBinaryCurde() {
        if (this.hybridBinaryCurde == null) {
            this.hybridBinaryCurde = new HybridBinarizerCrude(this);
        }
        return this.hybridBinaryCurde;
    }

    @Override
    public byte[] getMatrix() {
        return this.matrix;
    }

    @Override
    public byte[] getRow(int n2, byte[] object) {
        block2: {
            Object object2;
            int n3;
            block4: {
                block3: {
                    if (n2 < 0 || n2 >= this.getHeight()) break block2;
                    n3 = this.getWidth();
                    if (object == null) break block3;
                    object2 = object;
                    if (((Object)object).length >= n3) break block4;
                }
                object2 = new byte[n3];
            }
            System.arraycopy(this.matrix, n2 * n3, object2, 0, n3);
            return object2;
        }
        object = new StringBuilder();
        ((StringBuilder)object).append("Requested row is outside the image: ");
        ((StringBuilder)object).append(n2);
        throw new IllegalArgumentException(((StringBuilder)object).toString());
    }

    public String getTagId() {
        if (TextUtils.isEmpty((CharSequence)this.tagId)) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(System.currentTimeMillis());
            stringBuilder.append("");
            this.tagId = stringBuilder.toString();
        }
        return this.tagId;
    }

    @Override
    public boolean isCropSupported() {
        return true;
    }

    public PlanarYUVLuminanceSourceRotate onlyCopyWarpRotate() {
        return new PlanarYUVLuminanceSourceRotate(this.matrix, this.getWidth(), this.getHeight());
    }
}

