/*
 * Decompiled with CFR 0.152.
 */
package com.ailiwean.core.zxing.core;

import com.ailiwean.core.zxing.core.BarcodeFormat;
import com.ailiwean.core.zxing.core.BinaryBitmap;
import com.ailiwean.core.zxing.core.DecodeHintType;
import com.ailiwean.core.zxing.core.NotFoundException;
import com.ailiwean.core.zxing.core.Reader;
import com.ailiwean.core.zxing.core.ReaderException;
import com.ailiwean.core.zxing.core.Result;
import com.ailiwean.core.zxing.core.aztec.AztecReader;
import com.ailiwean.core.zxing.core.datamatrix.DataMatrixReader;
import com.ailiwean.core.zxing.core.maxicode.MaxiCodeReader;
import com.ailiwean.core.zxing.core.oned.MultiFormatOneDReader;
import com.ailiwean.core.zxing.core.pdf417.PDF417Reader;
import com.ailiwean.core.zxing.core.qrcode.QRCodeReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;

public final class MultiFormatReader
implements Reader {
    private static final Reader[] EMPTY_READER_ARRAY = new Reader[0];
    private Map<DecodeHintType, ?> hints;
    private Reader[] readers;

    private Result decodeInternal(BinaryBitmap binaryBitmap) throws NotFoundException {
        Reader[] readerArray = this.readers;
        if (readerArray != null) {
            for (Reader object : readerArray) {
                try {
                    Result result = object.decode(binaryBitmap, this.hints);
                    return result;
                }
                catch (ReaderException readerException) {
                }
            }
        }
        throw NotFoundException.getNotFoundInstance();
    }

    @Override
    public Result decode(BinaryBitmap binaryBitmap) throws NotFoundException {
        this.setHints(null);
        return this.decodeInternal(binaryBitmap);
    }

    @Override
    public Result decode(BinaryBitmap binaryBitmap, Map<DecodeHintType, ?> map) throws NotFoundException {
        this.setHints(map);
        return this.decodeInternal(binaryBitmap);
    }

    public Result decodeWithState(BinaryBitmap binaryBitmap) throws NotFoundException {
        if (this.readers == null) {
            this.setHints(null);
        }
        return this.decodeInternal(binaryBitmap);
    }

    @Override
    public void reset() {
        Reader[] readerArray = this.readers;
        if (readerArray != null) {
            int n2 = readerArray.length;
            for (int i3 = 0; i3 < n2; ++i3) {
                readerArray[i3].reset();
            }
        }
    }

    public void setHints(Map<DecodeHintType, ?> map) {
        this.hints = map;
        boolean bl = true;
        boolean bl2 = map != null && map.containsKey((Object)DecodeHintType.TRY_HARDER);
        Collection collection = map == null ? null : (Collection)map.get((Object)DecodeHintType.POSSIBLE_FORMATS);
        ArrayList<Reader> arrayList = new ArrayList<Reader>();
        if (collection != null) {
            boolean bl3 = bl;
            if (!collection.contains((Object)BarcodeFormat.UPC_A)) {
                bl3 = bl;
                if (!collection.contains((Object)BarcodeFormat.UPC_E)) {
                    bl3 = bl;
                    if (!collection.contains((Object)BarcodeFormat.EAN_13)) {
                        bl3 = bl;
                        if (!collection.contains((Object)BarcodeFormat.EAN_8)) {
                            bl3 = bl;
                            if (!collection.contains((Object)BarcodeFormat.CODABAR)) {
                                bl3 = bl;
                                if (!collection.contains((Object)BarcodeFormat.CODE_39)) {
                                    bl3 = bl;
                                    if (!collection.contains((Object)BarcodeFormat.CODE_93)) {
                                        bl3 = bl;
                                        if (!collection.contains((Object)BarcodeFormat.CODE_128)) {
                                            bl3 = bl;
                                            if (!collection.contains((Object)BarcodeFormat.ITF)) {
                                                bl3 = bl;
                                                if (!collection.contains((Object)BarcodeFormat.RSS_14)) {
                                                    bl3 = collection.contains((Object)BarcodeFormat.RSS_EXPANDED) ? bl : false;
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
            if (bl3 && !bl2) {
                arrayList.add(new MultiFormatOneDReader(map));
            }
            if (collection.contains((Object)BarcodeFormat.QR_CODE)) {
                arrayList.add(new QRCodeReader());
            }
            if (collection.contains((Object)BarcodeFormat.DATA_MATRIX)) {
                arrayList.add(new DataMatrixReader());
            }
            if (collection.contains((Object)BarcodeFormat.AZTEC)) {
                arrayList.add(new AztecReader());
            }
            if (collection.contains((Object)BarcodeFormat.PDF_417)) {
                arrayList.add(new PDF417Reader());
            }
            if (collection.contains((Object)BarcodeFormat.MAXICODE)) {
                arrayList.add(new MaxiCodeReader());
            }
            if (bl3 && bl2) {
                arrayList.add(new MultiFormatOneDReader(map));
            }
        }
        if (arrayList.isEmpty()) {
            if (!bl2) {
                arrayList.add(new MultiFormatOneDReader(map));
            }
            arrayList.add(new QRCodeReader());
            arrayList.add(new DataMatrixReader());
            arrayList.add(new AztecReader());
            arrayList.add(new PDF417Reader());
            arrayList.add(new MaxiCodeReader());
            if (bl2) {
                arrayList.add(new MultiFormatOneDReader(map));
            }
        }
        this.readers = arrayList.toArray(EMPTY_READER_ARRAY);
    }
}

