/*
 * Decompiled with CFR 0.152.
 */
package com.ailiwean.core.zxing;

import com.ailiwean.core.Config;
import com.ailiwean.core.zxing.QRTypeConfig;
import com.ailiwean.core.zxing.ScanTypeConfig;
import com.ailiwean.core.zxing.core.BarcodeFormat;
import com.ailiwean.core.zxing.core.BinaryBitmap;
import com.ailiwean.core.zxing.core.DecodeHintType;
import com.ailiwean.core.zxing.core.NotFoundException;
import com.ailiwean.core.zxing.core.Reader;
import com.ailiwean.core.zxing.core.ReaderException;
import com.ailiwean.core.zxing.core.Result;
import com.ailiwean.core.zxing.core.aztec.AztecReader;
import com.ailiwean.core.zxing.core.datamatrix.DataMatrixReader;
import com.ailiwean.core.zxing.core.maxicode.MaxiCodeReader;
import com.ailiwean.core.zxing.core.oned.MultiFormatOneDReader;
import com.ailiwean.core.zxing.core.pdf417.PDF417Reader;
import com.ailiwean.core.zxing.core.qrcode.QRCodeReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;

public class CustomMultiFormatReader
implements Reader {
    static CustomMultiFormatReader customMultiFormatReader;
    private Map<DecodeHintType, ?> hints;
    private ScanTypeConfig mBarcodeType;
    private Reader[] readers;

    private CustomMultiFormatReader() {
        this.setType(Config.scanTypeConfig, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Result decodeInternal(BinaryBitmap binaryBitmap) {
        Reader[] readerArray = this.readers;
        Object object = null;
        Object object2 = null;
        if (readerArray == null) return object;
        int n2 = readerArray.length;
        int n3 = 0;
        while (true) {
            object = object2;
            if (n3 >= n2) {
                return object;
            }
            Object object3 = readerArray[n3];
            object = object2;
            try {
                object3 = object3.decode(binaryBitmap, this.hints);
                if (object3 != null) {
                    object2 = object3;
                }
                object = object2;
                if (object3 != null) {
                    object = object2;
                    object3 = ((Result)object3).getText();
                    object = object2;
                    if (object3 != null) {
                        return object2;
                    }
                }
            }
            catch (ReaderException | Exception exception) {}
            ++n3;
            object2 = object;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static CustomMultiFormatReader getInstance() {
        if (customMultiFormatReader != null) return customMultiFormatReader;
        synchronized (CustomMultiFormatReader.class) {
            CustomMultiFormatReader customMultiFormatReader;
            if (CustomMultiFormatReader.customMultiFormatReader != null) return CustomMultiFormatReader.customMultiFormatReader;
            CustomMultiFormatReader.customMultiFormatReader = customMultiFormatReader = new CustomMultiFormatReader();
            return CustomMultiFormatReader.customMultiFormatReader;
        }
    }

    @Override
    public Result decode(BinaryBitmap binaryBitmap) {
        return this.decodeInternal(binaryBitmap);
    }

    @Override
    public Result decode(BinaryBitmap binaryBitmap, Map<DecodeHintType, ?> map) throws NotFoundException {
        return this.decodeInternal(binaryBitmap);
    }

    public Result decodeWithState(BinaryBitmap binaryBitmap) throws NotFoundException {
        if (this.readers == null) {
            this.setHints(null);
        }
        return this.decodeInternal(binaryBitmap);
    }

    @Override
    public void reset() {
        Reader[] readerArray = this.readers;
        if (readerArray != null) {
            int n2 = readerArray.length;
            for (int i3 = 0; i3 < n2; ++i3) {
                readerArray[i3].reset();
            }
        }
    }

    public void setHints(Map<DecodeHintType, ?> map) {
        this.hints = map;
        boolean bl = true;
        boolean bl2 = map != null && map.containsKey((Object)DecodeHintType.TRY_HARDER);
        Collection collection = map == null ? null : (Collection)map.get((Object)DecodeHintType.POSSIBLE_FORMATS);
        ArrayList<Reader> arrayList = new ArrayList<Reader>();
        if (collection != null) {
            boolean bl3 = bl;
            if (!collection.contains((Object)BarcodeFormat.UPC_A)) {
                bl3 = bl;
                if (!collection.contains((Object)BarcodeFormat.UPC_E)) {
                    bl3 = bl;
                    if (!collection.contains((Object)BarcodeFormat.EAN_13)) {
                        bl3 = bl;
                        if (!collection.contains((Object)BarcodeFormat.EAN_8)) {
                            bl3 = bl;
                            if (!collection.contains((Object)BarcodeFormat.CODABAR)) {
                                bl3 = bl;
                                if (!collection.contains((Object)BarcodeFormat.CODE_39)) {
                                    bl3 = bl;
                                    if (!collection.contains((Object)BarcodeFormat.CODE_93)) {
                                        bl3 = bl;
                                        if (!collection.contains((Object)BarcodeFormat.CODE_128)) {
                                            bl3 = bl;
                                            if (!collection.contains((Object)BarcodeFormat.ITF)) {
                                                bl3 = bl;
                                                if (!collection.contains((Object)BarcodeFormat.RSS_14)) {
                                                    bl3 = collection.contains((Object)BarcodeFormat.RSS_EXPANDED) ? bl : false;
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
            if (bl3 && !bl2) {
                arrayList.add(new MultiFormatOneDReader(map));
            }
            if (collection.contains((Object)BarcodeFormat.QR_CODE)) {
                arrayList.add(new QRCodeReader());
            }
            if (collection.contains((Object)BarcodeFormat.DATA_MATRIX)) {
                arrayList.add(new DataMatrixReader());
            }
            if (collection.contains((Object)BarcodeFormat.AZTEC)) {
                arrayList.add(new AztecReader());
            }
            if (collection.contains((Object)BarcodeFormat.PDF_417)) {
                arrayList.add(new PDF417Reader());
            }
            if (collection.contains((Object)BarcodeFormat.MAXICODE)) {
                arrayList.add(new MaxiCodeReader());
            }
            if (bl3 && bl2) {
                arrayList.add(new MultiFormatOneDReader(map));
            }
        }
        if (arrayList.isEmpty()) {
            if (!bl2) {
                arrayList.add(new MultiFormatOneDReader(map));
            }
            arrayList.add(new QRCodeReader());
            arrayList.add(new DataMatrixReader());
            arrayList.add(new AztecReader());
            arrayList.add(new PDF417Reader());
            arrayList.add(new MaxiCodeReader());
            if (bl2) {
                arrayList.add(new MultiFormatOneDReader(map));
            }
        }
        this.readers = arrayList.toArray(new Reader[arrayList.size()]);
    }

    public void setType(ScanTypeConfig scanTypeConfig, Map<DecodeHintType, Object> map) {
        this.mBarcodeType = scanTypeConfig;
        this.hints = map;
        if (scanTypeConfig == ScanTypeConfig.CUSTOM && (map == null || map.isEmpty())) {
            throw new RuntimeException("barcodeType \u4e3a BarcodeType.CUSTOM \u65f6 hintMap \u4e0d\u80fd\u4e3a\u7a7a");
        }
        this.setupReader();
    }

    protected void setupReader() {
        if (this.mBarcodeType == ScanTypeConfig.ONE_DIMENSION) {
            this.setHints(QRTypeConfig.ONE_DIMENSION_HINT_MAP);
        } else if (this.mBarcodeType == ScanTypeConfig.TWO_DIMENSION) {
            this.setHints(QRTypeConfig.TWO_DIMENSION_HINT_MAP);
        } else if (this.mBarcodeType == ScanTypeConfig.ONLY_QR_CODE) {
            this.setHints(QRTypeConfig.QR_CODE_HINT_MAP);
        } else if (this.mBarcodeType == ScanTypeConfig.ONLY_CODE_128) {
            this.setHints(QRTypeConfig.CODE_128_HINT_MAP);
        } else if (this.mBarcodeType == ScanTypeConfig.ONLY_EAN_13) {
            this.setHints(QRTypeConfig.EAN_13_HINT_MAP);
        } else if (this.mBarcodeType == ScanTypeConfig.HIGH_FREQUENCY) {
            this.setHints(QRTypeConfig.HIGH_FREQUENCY_HINT_MAP);
        } else if (this.mBarcodeType == ScanTypeConfig.CUSTOM) {
            this.setHints(this.hints);
        } else {
            this.setHints(QRTypeConfig.ALL_HINT_MAP);
        }
    }
}

