/*
 * Decompiled with CFR 0.152.
 */
package com.ailiwean.core.view.style1;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.Rect;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import com.ailiwean.core.view.style1._$$Lambda$MaskView$HPFJ__ZgRmQl9bOM4116f6YsMG8;
import com.google.android.cameraview.R;

public class MaskView
extends View {
    private int bgColor;
    private Rect clearRect = new Rect();
    private Rect[] drawRects;
    private int id;
    private float margin_bottom;
    private float margin_left;
    private float margin_right;
    private float margin_top;
    private Paint paint;

    public MaskView(Context context) {
        this(context, null);
    }

    public MaskView(Context context, AttributeSet attributeSet) {
        this(context, attributeSet, 0);
    }

    public MaskView(Context context, AttributeSet attributeSet, int n2) {
        super(context, attributeSet, n2);
        this.initPaint();
        context = context.obtainStyledAttributes(attributeSet, R.styleable.MaskView);
        this.id = context.getResourceId(R.styleable.MaskView_camera_clearById, 0);
        this.margin_left = context.getDimension(R.styleable.MaskView_camera_clear_margin_left, 0.0f);
        this.margin_top = context.getDimension(R.styleable.MaskView_camera_clear_margin_top, 0.0f);
        this.margin_right = context.getDimension(R.styleable.MaskView_camera_clear_margin_right, 0.0f);
        this.margin_bottom = context.getDimension(R.styleable.MaskView_camera_clear_margin_bottom, 0.0f);
        this.bgColor = context.getColor(R.styleable.MaskView_camera_maskBgColor, Color.parseColor((String)"#1f000000"));
        this.paint.setColor(this.bgColor);
        context.recycle();
    }

    private Rect[] clearRect2Rect() {
        return new Rect[]{new Rect(0, 0, this.getMeasuredWidth(), this.clearRect.top), new Rect(0, this.clearRect.top, this.clearRect.left, this.clearRect.bottom), new Rect(this.clearRect.right, this.clearRect.top, this.getMeasuredWidth(), this.clearRect.bottom), new Rect(0, this.clearRect.bottom, this.getMeasuredWidth(), this.getMeasuredHeight())};
    }

    public void initPaint() {
        this.paint = new Paint();
        this.paint.setStyle(Paint.Style.FILL);
    }

    public /* synthetic */ void lambda$onMeasure$0$MaskView() {
        ViewGroup viewGroup = (ViewGroup)this.getParent();
        View view = viewGroup.findViewById(this.id);
        if (view != null) {
            int[] nArray = new int[2];
            view.getLocationOnScreen(nArray);
            int[] nArray2 = new int[2];
            viewGroup.getLocationInWindow(nArray2);
            viewGroup = this.clearRect;
            viewGroup.left = nArray[0] - nArray2[0];
            viewGroup.top = nArray[1] - nArray2[1];
            viewGroup.right = nArray[0] - nArray2[0] + view.getMeasuredWidth();
            this.clearRect.bottom = nArray[1] - nArray2[1] + view.getMeasuredHeight();
        } else {
            view = this.clearRect;
            view.left = (int)this.margin_left;
            view.top = (int)this.margin_top;
            view.right = (int)((float)this.getMeasuredWidth() - this.margin_right);
            this.clearRect.bottom = (int)((float)this.getMeasuredHeight() - this.margin_bottom);
        }
        this.drawRects = this.clearRect2Rect();
        this.invalidate();
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        if (this.clearRect == null) {
            return;
        }
        Rect[] rectArray = this.drawRects;
        if (rectArray != null) {
            int n2 = rectArray.length;
            for (int i3 = 0; i3 < n2; ++i3) {
                canvas.drawRect(rectArray[i3], this.paint);
            }
        }
    }

    protected void onMeasure(int n2, int n3) {
        super.onMeasure(n2, n3);
        this.post(new _$$Lambda$MaskView$HPFJ__ZgRmQl9bOM4116f6YsMG8(this));
    }

    public void setClearRect(Rect rect) {
        this.clearRect = rect;
        this.invalidate();
    }

    public void setMaskingColor(int n2) {
        this.paint.setColor(n2);
        this.invalidate();
    }
}

