/*
 * Decompiled with CFR 0.152.
 */
package com.ailiwean.core.helper;

import android.content.Context;
import android.media.AudioAttributes;
import android.media.SoundPool;
import android.os.Build;
import android.os.VibrationEffect;
import android.os.Vibrator;
import com.ailiwean.core.Utils;
import com.google.android.cameraview.R;

public class VibrateHelper {
    private static final float BEEP_VOLUME = 0.5f;
    private static final int VIBRATE_DURATION = 10;
    private static SoundPool soundPool;
    private static int voiceId;

    public static void playBeep() {
        SoundPool soundPool = VibrateHelper.soundPool;
        if (soundPool != null) {
            soundPool.play(voiceId, 1.0f, 1.0f, 1, 0, 1.0f);
        }
    }

    public static void playInit() {
        SoundPool soundPool = VibrateHelper.soundPool;
        if (soundPool != null) {
            soundPool.release();
        }
        if (Build.VERSION.SDK_INT >= 21) {
            SoundPool.Builder builder = new SoundPool.Builder();
            builder.setMaxStreams(1);
            soundPool = new AudioAttributes.Builder();
            soundPool.setLegacyStreamType(3);
            builder.setAudioAttributes(soundPool.build());
            VibrateHelper.soundPool = builder.build();
        } else {
            VibrateHelper.soundPool = new SoundPool(1, 3, 0);
        }
        voiceId = VibrateHelper.soundPool.load(Utils.INSTANCE.getContext(), R.raw.scan, 1);
    }

    public static void playVibrate() {
        if (Utils.INSTANCE.getContext() != null) {
            RxVibrateTool.vibrateOnce(Utils.INSTANCE.getContext(), 10);
        }
    }

    private static class RxVibrateTool {
        private static Vibrator vibrator;

        private RxVibrateTool() {
        }

        public static void vibrateComplicated(Context context, long[] lArray, int n2) {
            vibrator = (Vibrator)context.getSystemService("vibrator");
            vibrator.vibrate(lArray, n2);
        }

        static void vibrateOnce(Context context, int n2) {
            vibrator = (Vibrator)context.getSystemService("vibrator");
            if (Build.VERSION.SDK_INT >= 26) {
                vibrator.vibrate(VibrationEffect.createOneShot((long)n2, (int)25));
            } else {
                vibrator.vibrate((long)n2);
            }
        }

        public static void vibrateStop() {
            Vibrator vibrator = RxVibrateTool.vibrator;
            if (vibrator != null) {
                vibrator.cancel();
            }
        }
    }
}

