/*
 * Decompiled with CFR 0.152.
 */
package com.ailiwean.core.helper;

import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.text.TextUtils;
import com.ailiwean.core.zxing.core.BarcodeFormat;
import com.ailiwean.core.zxing.core.EncodeHintType;
import com.ailiwean.core.zxing.core.MultiFormatWriter;
import com.ailiwean.core.zxing.core.common.BitMatrix;
import com.ailiwean.core.zxing.core.qrcode.decoder.ErrorCorrectionLevel;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Map;

public class QRCodeEncoder {
    public static final Map<EncodeHintType, Object> HINTS = new EnumMap<EncodeHintType, Object>(EncodeHintType.class);

    static {
        HINTS.put(EncodeHintType.CHARACTER_SET, "utf-8");
        HINTS.put(EncodeHintType.ERROR_CORRECTION, (Object)ErrorCorrectionLevel.H);
        HINTS.put(EncodeHintType.MARGIN, 0);
    }

    private QRCodeEncoder() {
    }

    private static Bitmap addLogoToQRCode(Bitmap bitmap2, Bitmap bitmap3) {
        if (bitmap2 != null && bitmap3 != null) {
            int n2 = bitmap2.getWidth();
            int n3 = bitmap2.getHeight();
            int n4 = bitmap3.getWidth();
            int n5 = bitmap3.getHeight();
            float f3 = (float)n2 * 1.0f / 5.0f / (float)n4;
            Bitmap bitmap4 = Bitmap.createBitmap((int)n2, (int)n3, (Bitmap.Config)Bitmap.Config.ARGB_8888);
            try {
                Canvas canvas = new Canvas(bitmap4);
                canvas.drawBitmap(bitmap2, 0.0f, 0.0f, null);
                canvas.scale(f3, f3, (float)(n2 / 2), (float)(n3 / 2));
                canvas.drawBitmap(bitmap3, (float)((n2 - n4) / 2), (float)((n3 - n5) / 2), null);
                canvas.save();
                canvas.restore();
                bitmap2 = bitmap4;
            }
            catch (Exception exception) {
                exception.printStackTrace();
                bitmap2 = null;
            }
            return bitmap2;
        }
        return bitmap2;
    }

    private static Bitmap showContent(Bitmap bitmap2, String string2, int n2) {
        if (!TextUtils.isEmpty((CharSequence)string2) && bitmap2 != null) {
            Paint paint = new Paint();
            paint.setColor(-16777216);
            paint.setAntiAlias(true);
            paint.setStyle(Paint.Style.FILL);
            paint.setTextSize((float)n2);
            paint.setTextAlign(Paint.Align.CENTER);
            int n3 = (int)paint.measureText(string2);
            Paint.FontMetrics fontMetrics = paint.getFontMetrics();
            n2 = (int)(fontMetrics.bottom - fontMetrics.top);
            float f3 = (float)bitmap2.getWidth() * 1.0f / (float)n3;
            if (f3 < 1.0f) {
                paint.setTextScaleX(f3);
            }
            n3 = bitmap2.getHeight();
            Bitmap bitmap3 = Bitmap.createBitmap((int)bitmap2.getWidth(), (int)(bitmap2.getHeight() + n2 * 2), (Bitmap.Config)Bitmap.Config.ARGB_4444);
            fontMetrics = new Canvas();
            fontMetrics.drawColor(-1);
            fontMetrics.setBitmap(bitmap3);
            fontMetrics.drawBitmap(bitmap2, 0.0f, 0.0f, null);
            fontMetrics.drawText(string2, (float)(bitmap2.getWidth() / 2), (float)(n3 + n2), paint);
            fontMetrics.save();
            fontMetrics.restore();
            return bitmap3;
        }
        return null;
    }

    public static Bitmap syncEncodeBarcode(String string2, int n2, int n3, int n4) {
        Object object;
        block8: {
            if (TextUtils.isEmpty((CharSequence)string2)) {
                return null;
            }
            object = new HashMap<EncodeHintType, Object>();
            object.put(EncodeHintType.CHARACTER_SET, "utf-8");
            object.put(EncodeHintType.ERROR_CORRECTION, ErrorCorrectionLevel.H);
            object.put(EncodeHintType.MARGIN, 0);
            Object object2 = new MultiFormatWriter();
            object2 = ((MultiFormatWriter)object2).encode(string2, BarcodeFormat.CODE_128, n2, n3, (Map<EncodeHintType, ?>)object);
            object = new int[n2 * n3];
            for (int i3 = 0; i3 < n3; ++i3) {
                for (int i4 = 0; i4 < n2; ++i4) {
                    object[i3 * n2 + i4] = ((BitMatrix)object2).get(i4, i3) ? (Object)-16777216 : (Object)-1;
                }
            }
            try {
                object2 = Bitmap.createBitmap((int)n2, (int)n3, (Bitmap.Config)Bitmap.Config.ARGB_8888);
                object2.setPixels((int[])object, 0, n2, 0, 0, n2, n3);
                object = object2;
                if (n4 <= 0) break block8;
            }
            catch (Exception exception) {
                exception.printStackTrace();
                return null;
            }
            object = QRCodeEncoder.showContent((Bitmap)object2, string2, n4);
        }
        return object;
    }

    public static Bitmap syncEncodeQRCode(String string2, int n2) {
        return QRCodeEncoder.syncEncodeQRCode(string2, n2, -16777216, -1, null);
    }

    public static Bitmap syncEncodeQRCode(String string2, int n2, int n3) {
        return QRCodeEncoder.syncEncodeQRCode(string2, n2, n3, -1, null);
    }

    public static Bitmap syncEncodeQRCode(String object, int n2, int n3, int n4, Bitmap bitmap2) {
        Object object2 = new MultiFormatWriter();
        object2 = ((MultiFormatWriter)object2).encode((String)object, BarcodeFormat.QR_CODE, n2, n2, HINTS);
        object = new int[n2 * n2];
        for (int i3 = 0; i3 < n2; ++i3) {
            for (int i4 = 0; i4 < n2; ++i4) {
                object[i3 * n2 + i4] = ((BitMatrix)object2).get(i4, i3) ? (Object)n3 : (Object)n4;
            }
        }
        try {
            object2 = Bitmap.createBitmap((int)n2, (int)n2, (Bitmap.Config)Bitmap.Config.ARGB_8888);
            object2.setPixels((int[])object, 0, n2, 0, 0, n2, n2);
            object = QRCodeEncoder.addLogoToQRCode((Bitmap)object2, bitmap2);
            return object;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public static Bitmap syncEncodeQRCode(String string2, int n2, int n3, Bitmap bitmap2) {
        return QRCodeEncoder.syncEncodeQRCode(string2, n2, n3, -1, bitmap2);
    }
}

