/*
 * Decompiled with CFR 0.152.
 */
package com.ailiwean.core.helper;

import android.graphics.Rect;
import android.hardware.Camera;
import android.hardware.camera2.CameraCharacteristics;
import android.media.Image;
import android.media.ImageReader;
import android.os.Build;

public class CameraHelper {
    static long startTime;

    public static boolean checkAutoFocus(CameraCharacteristics cameraCharacteristics) {
        int[] nArray = new int[]{};
        if (Build.VERSION.SDK_INT >= 21) {
            nArray = (int[])cameraCharacteristics.get(CameraCharacteristics.CONTROL_AF_AVAILABLE_MODES);
        }
        return nArray.length != 0 && (nArray.length != 1 || nArray[0] != 0);
        {
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static byte[] getByteFromImage(Image image) {
        byte[] byArray = null;
        byte[] byArray2 = null;
        byte[] byArray3 = byArray;
        try {
            if (Build.VERSION.SDK_INT < 19) {
                return null;
            }
            byte[] byArray4 = byArray2;
            if (image == null) return byArray4;
            byArray4 = byArray2;
            byArray3 = byArray;
            if (image.getPlanes() == null) return byArray4;
            byArray3 = byArray;
            if (image.getPlanes().length == 0) {
                return byArray2;
            }
            byArray3 = byArray;
            Image.Plane[] planeArray = image.getPlanes();
            byArray3 = byArray;
            int n2 = planeArray[0].getBuffer().remaining();
            byArray3 = byArray;
            int n3 = planeArray[2].getBuffer().remaining();
            byArray3 = byArray;
            int n4 = image.getWidth();
            byArray3 = byArray;
            int n5 = image.getHeight();
            byArray3 = byArray;
            byArray2 = new byte[n2];
            byArray3 = byArray;
            byte[] byArray5 = new byte[n3];
            byArray3 = byArray;
            byArray3 = byArray = new byte[n4 * n5 * 3 / 2];
            planeArray[0].getBuffer().get(byArray2);
            byArray3 = byArray;
            planeArray[2].getBuffer().get(byArray5);
            n2 = 0;
            while (true) {
                byArray4 = byArray;
                if (n2 >= n5) return byArray4;
                byArray3 = byArray;
                System.arraycopy(byArray2, planeArray[0].getRowStride() * n2, byArray, n4 * n2, n4);
                byArray3 = byArray;
                if (n2 <= image.getHeight() / 2) {
                    n3 = (n5 + n2) * n4;
                    byArray3 = byArray;
                    if (n3 + n4 < byArray.length) {
                        byArray3 = byArray;
                        System.arraycopy(byArray5, planeArray[2].getRowStride() * n2, byArray, n3, n4);
                    }
                }
                ++n2;
            }
        }
        catch (Exception exception) {
            return byArray3;
        }
    }

    public static Float getMaxZoom(CameraCharacteristics cameraCharacteristics) {
        Float f3;
        Float f4 = f3 = null;
        try {
            if (Build.VERSION.SDK_INT >= 21) {
                f4 = (Float)cameraCharacteristics.get(CameraCharacteristics.SCALER_AVAILABLE_MAX_DIGITAL_ZOOM);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            f4 = f3;
        }
        return f4;
    }

    public static Float getMinimumFocusDistance(CameraCharacteristics cameraCharacteristics) {
        Float f3;
        Float f4 = f3 = null;
        try {
            if (Build.VERSION.SDK_INT >= 21) {
                f4 = (Float)cameraCharacteristics.get(CameraCharacteristics.LENS_INFO_MINIMUM_FOCUS_DISTANCE);
            }
        }
        catch (NullPointerException nullPointerException) {
            nullPointerException.printStackTrace();
            f4 = f3;
        }
        return f4;
    }

    public static Rect getZoomRect(CameraCharacteristics object, float f3) {
        Float f4 = CameraHelper.getMaxZoom(object);
        float f5 = f3 == 0.0f ? 1.0f : f3 * f4.floatValue() + 1.0f;
        f3 = f5;
        if (f5 > f4.floatValue()) {
            f3 = f4.floatValue();
        }
        f5 = f3;
        if (f3 < 1.0f) {
            f5 = 1.0f;
        }
        if ((object = Build.VERSION.SDK_INT >= 21 ? (Rect)object.get(CameraCharacteristics.SENSOR_INFO_ACTIVE_ARRAY_SIZE) : null) == null) {
            return null;
        }
        f3 = 1.0f / f5;
        try {
            int n2 = object.width() - Math.round((float)object.width() * f3);
            int n3 = object.height() - Math.round((float)object.height() * f3);
            f4 = new Rect(n2 / 2, n3 / 2, object.width() - n2 / 2, object.height() - n3 / 2);
            object = f4;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            object = null;
        }
        return object;
    }

    public static boolean matchCameraDirection(CameraCharacteristics object, int n2) {
        object = Build.VERSION.SDK_INT >= 21 ? (Integer)object.get(CameraCharacteristics.LENS_FACING) : null;
        boolean bl = object != null && (Integer)object == n2;
        return bl;
    }

    public static byte[] readYuv(ImageReader imageReader) {
        if (Build.VERSION.SDK_INT < 19) {
            return null;
        }
        if ((imageReader = imageReader.acquireLatestImage()) == null) {
            return null;
        }
        byte[] byArray = CameraHelper.getByteFromImage((Image)imageReader);
        imageReader.close();
        return byArray;
    }

    public static void setZoom(float f3, Camera camera) {
        int n2;
        if (camera == null) {
            return;
        }
        Camera.Parameters parameters = camera.getParameters();
        if (parameters == null) {
            return;
        }
        if (!parameters.isZoomSupported()) {
            return;
        }
        int n3 = n2 = (int)(f3 * (float)parameters.getMaxZoom());
        if (n2 < 1) {
            n3 = 1;
        }
        parameters.setZoom(n3);
        camera.setParameters(parameters);
    }

    public void checkFocusMode(CameraCharacteristics cameraCharacteristics) {
        int n2 = 0;
        int[] nArray = new int[]{};
        if (Build.VERSION.SDK_INT >= 21) {
            nArray = (int[])cameraCharacteristics.get(CameraCharacteristics.CONTROL_AF_AVAILABLE_MODES);
        }
        if (nArray == null) {
            nArray = new int[]{};
        }
        int n3 = nArray.length;
        while (n2 < n3) {
            int n4 = nArray[n2];
            if (n4 == 0 || n4 == 2) {
                // empty if block
            }
            ++n2;
        }
    }
}

