/*
 * Decompiled with CFR 0.152.
 */
package com.ailiwean.core;

import com.ailiwean.core.Config;
import com.ailiwean.core.ExecutorEnd;
import com.ailiwean.core.RespectScalePool;
import com.ailiwean.core.RespectScaleQueue;
import com.ailiwean.core.TypeRunnable;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;

public class WorkThreadServer
implements ExecutorEnd {
    private static final int CPU_COUNT = Runtime.getRuntime().availableProcessors();
    private static final int corePoolSize;
    private static final int keepAliveTime = 30;
    private static final int maximumPoolSize;
    private static final int queueMaxSize;
    private ThreadPoolExecutor executor;
    private final Map<String, Packing> packingMap = new HashMap<String, Packing>();

    static {
        maximumPoolSize = corePoolSize = Math.max(2, CPU_COUNT / 2);
        queueMaxSize = Math.max(4, maximumPoolSize);
    }

    private WorkThreadServer() {
        if (!Config.hasDepencidesScale()) {
            this.executor = new ThreadPoolExecutor(corePoolSize, maximumPoolSize, 30L, TimeUnit.SECONDS, new ArrayBlockingQueue<Runnable>(queueMaxSize, true), new ThreadPoolExecutor.DiscardOldestPolicy());
        } else {
            int n2 = corePoolSize;
            int n3 = maximumPoolSize;
            TimeUnit timeUnit = TimeUnit.SECONDS;
            int n4 = queueMaxSize;
            this.executor = new RespectScalePool(n2, n3, 30L, timeUnit, RespectScaleQueue.create(n4, n4), new RespectScalePool.RespectScalePolicy(this), this);
        }
    }

    public static WorkThreadServer createInstance() {
        return new WorkThreadServer();
    }

    public void clear() {
        ThreadPoolExecutor threadPoolExecutor = this.executor;
        if (threadPoolExecutor != null) {
            threadPoolExecutor.getQueue().clear();
        }
    }

    @Override
    public void executorEnd(TypeRunnable object) {
        if (((TypeRunnable)object).type == 1) {
            return;
        }
        if (this.packingMap.size() == 0) {
            return;
        }
        object = this.packingMap.get(((TypeRunnable)object).tagId);
        if (object == null) {
            return;
        }
        if (((Packing)object).completeNum.decrementAndGet() == 0) {
            ((Packing)object).postListBack.run();
            Packing.access$102((Packing)object, null);
        }
    }

    public void post(TypeRunnable typeRunnable) {
        ThreadPoolExecutor threadPoolExecutor = this.executor;
        if (threadPoolExecutor != null) {
            threadPoolExecutor.execute(typeRunnable);
        }
    }

    public void quit() {
        ThreadPoolExecutor threadPoolExecutor = this.executor;
        if (threadPoolExecutor != null) {
            threadPoolExecutor.shutdownNow();
            this.executor.getQueue().clear();
            this.executor = null;
        }
    }

    public void regPostListBack(String string2, int n2, Runnable runnable) {
        this.packingMap.put(string2, new Packing(string2, n2, runnable));
    }

    private static class Packing {
        private AtomicInteger completeNum;
        private Runnable postListBack;
        private String tagId;

        public Packing(String string2, int n2, Runnable runnable) {
            this.tagId = string2;
            this.completeNum = new AtomicInteger(n2);
            this.postListBack = runnable;
        }

        static /* synthetic */ Runnable access$102(Packing packing, Runnable runnable) {
            packing.postListBack = runnable;
            return runnable;
        }
    }
}

