/*
 * Decompiled with CFR 0.152.
 */
package com.ailiwean.core;

import com.ailiwean.core.TypeRunnable;
import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;

class RespectScaleQueue<T extends TypeRunnable>
implements BlockingQueue<T>,
Serializable {
    int elementIndex = 0;
    ArrayBlockingQueue<T> normalQueue;
    int peekIndex = 0;
    int pollIndex = 0;
    int ratio;
    int removeIndex = 0;
    ArrayBlockingQueue<T> scaleQueue;
    int takeIndex = 0;

    private RespectScaleQueue(int n2, int n3) {
        this.normalQueue = new ArrayBlockingQueue(n2, true);
        this.scaleQueue = new ArrayBlockingQueue(n3, true);
        this.ratio = (n2 + n3) / n3;
    }

    public static RespectScaleQueue<TypeRunnable> create(int n2, int n3) {
        return new RespectScaleQueue<TypeRunnable>(n2, n3);
    }

    private boolean isNormal(Collection<?> object) {
        boolean bl;
        object = object.iterator();
        boolean bl2 = object.hasNext();
        boolean bl3 = bl = false;
        if (bl2) {
            object = object.next();
            bl3 = bl;
            if (object instanceof TypeRunnable) {
                bl3 = bl;
                if (((TypeRunnable)object).getType() == 0) {
                    bl3 = true;
                }
            }
        }
        return bl3;
    }

    @Override
    public boolean add(T t2) {
        if (((TypeRunnable)t2).getType() == 0) {
            return this.normalQueue.add(t2);
        }
        return this.scaleQueue.add(t2);
    }

    @Override
    public boolean addAll(Collection<? extends T> collection) {
        if (this.isNormal(collection)) {
            return this.normalQueue.addAll(collection);
        }
        return this.scaleQueue.addAll(collection);
    }

    @Override
    public void clear() {
        this.normalQueue.clear();
        this.scaleQueue.clear();
    }

    @Override
    public boolean contains(Object object) {
        if (object instanceof TypeRunnable) {
            if (((TypeRunnable)object).getType() == 0) {
                return this.normalQueue.contains(object);
            }
            return this.scaleQueue.contains(object);
        }
        boolean bl = this.normalQueue.contains(object) || this.scaleQueue.contains(object);
        return bl;
    }

    @Override
    public boolean containsAll(Collection<?> collection) {
        boolean bl = this.normalQueue.containsAll(collection) || this.scaleQueue.containsAll(collection);
        return bl;
    }

    @Override
    public int drainTo(Collection<? super T> collection) {
        if (this.isNormal(collection)) {
            return this.normalQueue.drainTo(collection);
        }
        return this.scaleQueue.drainTo(collection);
    }

    @Override
    public int drainTo(Collection<? super T> collection, int n2) {
        if (this.isNormal(collection)) {
            return this.normalQueue.drainTo(collection, n2);
        }
        return this.scaleQueue.drainTo(collection, n2);
    }

    @Override
    public T element() {
        int n2 = this.elementIndex;
        this.elementIndex = n2 + 1;
        if (n2 % this.ratio == 0) {
            return (T)((TypeRunnable)this.scaleQueue.peek());
        }
        return (T)((TypeRunnable)this.normalQueue.peek());
    }

    @Override
    public boolean isEmpty() {
        boolean bl = this.normalQueue.isEmpty() && this.scaleQueue.isEmpty();
        return bl;
    }

    @Override
    public Iterator<T> iterator() {
        ArrayBlockingQueue<T> arrayBlockingQueue = new ArrayBlockingQueue<T>(this.normalQueue.size() + this.scaleQueue.size(), true);
        arrayBlockingQueue.addAll(this.normalQueue);
        arrayBlockingQueue.addAll(this.scaleQueue);
        return arrayBlockingQueue.iterator();
    }

    @Override
    public boolean offer(T t2) {
        if (((TypeRunnable)t2).getType() == 0) {
            return this.normalQueue.offer(t2);
        }
        return this.scaleQueue.offer(t2);
    }

    @Override
    public boolean offer(T t2, long l3, TimeUnit timeUnit) throws InterruptedException {
        if (((TypeRunnable)t2).getType() == 0) {
            return this.normalQueue.offer(t2, l3, timeUnit);
        }
        return this.scaleQueue.offer(t2, l3, timeUnit);
    }

    @Override
    public T peek() {
        int n2 = this.peekIndex;
        this.peekIndex = n2 + 1;
        if (n2 % this.ratio == 0) {
            return (T)((TypeRunnable)this.normalQueue.peek());
        }
        return (T)((TypeRunnable)this.scaleQueue.peek());
    }

    @Override
    public T poll() {
        int n2 = this.pollIndex;
        this.pollIndex = n2 + 1;
        if (n2 % this.ratio == 0) {
            return (T)((TypeRunnable)this.scaleQueue.poll());
        }
        return (T)((TypeRunnable)this.normalQueue.poll());
    }

    public T poll(int n2) {
        if (n2 != 0) {
            if (n2 == 1) {
                for (TypeRunnable typeRunnable : this.scaleQueue) {
                    if (typeRunnable.isImportant()) continue;
                    this.scaleQueue.remove(typeRunnable);
                    return (T)typeRunnable;
                }
            }
        } else {
            for (TypeRunnable typeRunnable : this.normalQueue) {
                if (typeRunnable.isImportant()) continue;
                this.normalQueue.remove(typeRunnable);
                return (T)typeRunnable;
            }
        }
        if (n2 == 0) {
            return (T)((TypeRunnable)this.normalQueue.poll());
        }
        return (T)((TypeRunnable)this.scaleQueue.poll());
    }

    @Override
    public T poll(long l3, TimeUnit timeUnit) throws InterruptedException {
        int n2 = this.pollIndex;
        this.pollIndex = n2 + 1;
        if (n2 % this.ratio != 0) {
            return (T)((TypeRunnable)this.normalQueue.poll(l3, timeUnit));
        }
        return (T)((TypeRunnable)this.scaleQueue.poll(l3, timeUnit));
    }

    @Override
    public void put(T t2) throws InterruptedException {
        if (((TypeRunnable)t2).getType() == 0) {
            this.normalQueue.put(t2);
        } else {
            this.scaleQueue.put(t2);
        }
    }

    @Override
    public int remainingCapacity() {
        return this.normalQueue.remainingCapacity() + this.scaleQueue.remainingCapacity();
    }

    @Override
    public T remove() {
        int n2 = this.removeIndex;
        this.removeIndex = n2 + 1;
        if (n2 % this.ratio == 0) {
            return (T)((TypeRunnable)this.scaleQueue.remove());
        }
        return (T)((TypeRunnable)this.normalQueue.remove());
    }

    @Override
    public boolean remove(Object object) {
        if (object instanceof TypeRunnable) {
            if (((TypeRunnable)object).getType() == 0) {
                return this.normalQueue.remove(object);
            }
            return this.scaleQueue.remove(object);
        }
        boolean bl = this.normalQueue.remove(object) || this.scaleQueue.remove(object);
        return bl;
    }

    @Override
    public boolean removeAll(Collection<?> collection) {
        if (this.isNormal(collection)) {
            return this.normalQueue.removeAll(collection);
        }
        return this.scaleQueue.removeAll(collection);
    }

    @Override
    public boolean retainAll(Collection<?> collection) {
        if (this.isNormal(collection)) {
            return this.normalQueue.retainAll(collection);
        }
        return this.scaleQueue.retainAll(collection);
    }

    @Override
    public int size() {
        return this.normalQueue.size() + this.scaleQueue.size();
    }

    @Override
    public T take() throws InterruptedException {
        int n2 = this.takeIndex;
        this.takeIndex = n2 + 1;
        int n3 = this.ratio;
        TypeRunnable typeRunnable = null;
        TypeRunnable typeRunnable2 = null;
        if (n2 % n3 != 0) {
            if (this.normalQueue.size() != 0) {
                typeRunnable2 = (TypeRunnable)this.normalQueue.take();
            } else if (this.scaleQueue.size() != 0) {
                typeRunnable2 = (TypeRunnable)this.scaleQueue.take();
            }
            return (T)typeRunnable2;
        }
        if (this.scaleQueue.size() != 0) {
            typeRunnable2 = (TypeRunnable)this.scaleQueue.take();
        } else {
            typeRunnable2 = typeRunnable;
            if (this.normalQueue.size() != 0) {
                typeRunnable2 = (TypeRunnable)this.normalQueue.take();
            }
        }
        return (T)typeRunnable2;
    }

    @Override
    public Object[] toArray() {
        ArrayBlockingQueue<T> arrayBlockingQueue = new ArrayBlockingQueue<T>(this.normalQueue.size() + this.scaleQueue.size(), true);
        arrayBlockingQueue.addAll(this.normalQueue);
        arrayBlockingQueue.addAll(this.scaleQueue);
        return arrayBlockingQueue.toArray();
    }

    @Override
    public <T1> T1[] toArray(T1[] T1Array) {
        if (T1Array.length == 0) {
            return T1Array;
        }
        T1[] T1Array2 = T1Array;
        if (T1Array[0] instanceof TypeRunnable) {
            if (((TypeRunnable)T1Array[0]).getType() == 0) {
                return this.normalQueue.toArray(T1Array);
            }
            T1Array2 = this.scaleQueue.toArray(T1Array);
        }
        return T1Array2;
    }
}

