/*
 * Decompiled with CFR 0.152.
 */
package com.ailiwean.core;

import com.ailiwean.core.ExecutorEnd;
import com.ailiwean.core.RespectScaleQueue;
import com.ailiwean.core.TypeRunnable;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

class RespectScalePool
extends ThreadPoolExecutor {
    private ExecutorEnd runEnd;

    public RespectScalePool(int n2, int n3, long l3, TimeUnit timeUnit, BlockingQueue<? extends Runnable> blockingQueue, RejectedExecutionHandler rejectedExecutionHandler, ExecutorEnd executorEnd) {
        super(n2, n3, l3, timeUnit, blockingQueue, rejectedExecutionHandler);
        this.runEnd = executorEnd;
    }

    @Override
    protected void afterExecute(Runnable runnable, Throwable object) {
        super.afterExecute(runnable, (Throwable)object);
        if (runnable instanceof TypeRunnable && (object = this.runEnd) != null) {
            object.executorEnd((TypeRunnable)runnable);
        }
    }

    public static class RespectScalePolicy
    extends ThreadPoolExecutor.DiscardOldestPolicy {
        private final ExecutorEnd runEnd;

        public RespectScalePolicy(ExecutorEnd executorEnd) {
            this.runEnd = executorEnd;
        }

        @Override
        public void rejectedExecution(Runnable runnable, ThreadPoolExecutor threadPoolExecutor) {
            if (threadPoolExecutor.isShutdown()) {
                return;
            }
            if (runnable instanceof TypeRunnable && threadPoolExecutor instanceof RespectScalePool) {
                ExecutorEnd executorEnd;
                if (!(threadPoolExecutor.getQueue() instanceof RespectScaleQueue)) {
                    super.rejectedExecution(runnable, threadPoolExecutor);
                    return;
                }
                TypeRunnable typeRunnable = (TypeRunnable)runnable;
                typeRunnable = ((RespectScaleQueue)threadPoolExecutor.getQueue()).poll(typeRunnable.type);
                if (typeRunnable != null && (executorEnd = this.runEnd) != null) {
                    executorEnd.executorEnd(typeRunnable);
                }
                threadPoolExecutor.execute(runnable);
                return;
            }
            super.rejectedExecution(runnable, threadPoolExecutor);
        }
    }
}

