--
-- PostgreSQL database dump
--

-- Dumped from database version 10.10 (Ubuntu 10.10-0ubuntu0.18.04.1)
-- Dumped by pg_dump version 10.10 (Ubuntu 10.10-0ubuntu0.18.04.1)

SET statement_timeout = 0;
SET lock_timeout = 0;
SET idle_in_transaction_session_timeout = 0;
SET client_encoding = 'UTF8';
SET standard_conforming_strings = on;
SELECT pg_catalog.set_config('search_path', '', false);
SET check_function_bodies = false;
SET xmloption = content;
SET client_min_messages = warning;
SET row_security = off;

--
-- Name: plpgsql; Type: EXTENSION; Schema: -; Owner: 
--

CREATE EXTENSION IF NOT EXISTS plpgsql WITH SCHEMA pg_catalog;


--
-- Name: EXTENSION plpgsql; Type: COMMENT; Schema: -; Owner: 
--

COMMENT ON EXTENSION plpgsql IS 'PL/pgSQL procedural language';


--
-- Name: academic_season; Type: TYPE; Schema: public; Owner: postgres
--

CREATE TYPE public.academic_season AS ENUM (
    'winter',
    'spring'
);


ALTER TYPE public.academic_season OWNER TO postgres;

--
-- Name: course_dependency_mode_type; Type: TYPE; Schema: public; Owner: postgres
--

CREATE TYPE public.course_dependency_mode_type AS ENUM (
    'required',
    'recommended'
);


ALTER TYPE public.course_dependency_mode_type OWNER TO postgres;

--
-- Name: levels; Type: TYPE; Schema: public; Owner: postgres
--

CREATE TYPE public.levels AS ENUM (
    'A',
    'B',
    'C',
    'D'
);


ALTER TYPE public.levels OWNER TO postgres;

--
-- Name: rank; Type: TYPE; Schema: public; Owner: postgres
--

CREATE TYPE public.rank AS ENUM (
    'full',
    'associate',
    'assistant',
    'lecture'
);


ALTER TYPE public.rank OWNER TO postgres;

--
-- Name: register_status; Type: TYPE; Schema: public; Owner: postgres
--

CREATE TYPE public.register_status AS ENUM (
    'proposed',
    'requested',
    'approved',
    'rejected',
    'pass',
    'fail'
);


ALTER TYPE public.register_status OWNER TO postgres;

--
-- Name: semester_season_type; Type: TYPE; Schema: public; Owner: postgres
--

CREATE TYPE public.semester_season_type AS ENUM (
    'winter',
    'spring'
);


ALTER TYPE public.semester_season_type OWNER TO postgres;

--
-- Name: semester_status; Type: TYPE; Schema: public; Owner: postgres
--

CREATE TYPE public.semester_status AS ENUM (
    'past',
    'present',
    'future'
);


ALTER TYPE public.semester_status OWNER TO postgres;

--
-- Name: auto_insert_courserun_grades(); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION public.auto_insert_courserun_grades() RETURNS void
    LANGUAGE plpgsql
    AS $$
BEGIN
  --update exam
  UPDATE "Register"
  SET exam_grade = cast(random() * (10 - 1) + 1 AS INT)
  FROM "CourseRun", "Semester"
  WHERE
    "Register".course_run_id = "CourseRun".serial_number AND "CourseRun".ruinsin_semester = "Semester".semester_id AND exam_grade is NULL AND
    "Register".register_status = 'approved' AND "Semester".semester_status = 'present';

  --update lab
  UPDATE "Register"
  SET lab_grade = cast(random() * (10 - 1) + 1 AS INT)
  FROM "CourseRun", "Semester", "Course"
  WHERE "Register".course_run_id = "CourseRun".serial_number
        AND "CourseRun".ruinsin_semester = "Semester".semester_id AND lab_grade is NULL
        AND "CourseRun".implements_course = "Course".course_code AND "Register".register_status = 'approved' AND
        "Semester".semester_status = 'present' AND
        "Course".lab_hours > 0;

  --update Exam grade with lab hours and lab < MIN_LAB
  UPDATE "Register"
  SET exam_grade = 0
  FROM "CourseRun", "Semester", "Course"
  WHERE "Register".course_run_id = "CourseRun".serial_number
        AND "CourseRun".ruinsin_semester = "Semester".semester_id AND exam_grade is NULL
        AND "CourseRun".implements_course = "Course".course_code AND "Register".register_status = 'approved' AND
        "Semester".semester_status = 'present' AND "Course".lab_hours > 0 AND
        "Register".lab_grade < "CourseRun".lab_min;

  --update Final grade without lab hours OR  with lab hours and lab < MIN_LAB OR with exam_grade<EXAM_MIN
  UPDATE "Register"
  SET final_grade = exam_grade
  FROM "CourseRun", "Semester", "Course"
  WHERE "Register".course_run_id = "CourseRun".serial_number
        AND "CourseRun".ruinsin_semester = "Semester".semester_id AND final_grade is NULL
        AND "CourseRun".implements_course = "Course".course_code AND "Register".register_status = 'approved' AND
        "Semester".semester_status = 'present' AND
        ("Course".lab_hours = 0 OR "Register".lab_grade < "CourseRun".lab_min OR
         "Register".exam_grade < "CourseRun".exam_min);

  --update Final grade with lab hours and lab_grade>LAB_MIN AND
  UPDATE "Register"
  SET final_grade = (exam_grade * "CourseRun".exam_percentage + lab_grade * (100 - "CourseRun".exam_percentage)) / 100
  FROM "CourseRun", "Semester", "Course"
  WHERE "Register".course_run_id = "CourseRun".serial_number
        AND "CourseRun".ruinsin_semester = "Semester".semester_id AND final_grade is NULL
        AND "CourseRun".implements_course = "Course".course_code AND "Register".register_status = 'approved' AND
        "Semester".semester_status = 'present' AND
        "Course".lab_hours > 0 AND "Register".lab_grade >= "CourseRun".lab_min AND
        "Register".exam_grade >= "CourseRun".exam_min;
END;
$$;


ALTER FUNCTION public.auto_insert_courserun_grades() OWNER TO postgres;

--
-- Name: calcgrade(); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION public.calcgrade() RETURNS TABLE(am character, grade integer)
    LANGUAGE plpgsql
    AS $$
BEGIN
  RETURN QUERY
  SELECT am,sum(final_grade * weight) as grade
  FROM "Course"
    JOIN "CourseRun" ON "Course".course_code = "CourseRun".implements_course
    JOIN "Register" ON "CourseRun".serial_number = "Register".course_run_id
    JOIN "Students" ON "Register".student_amka = "Students".amka
    JOIN "Semester" ON "CourseRun".ruinsin_semester = "Semester".semester_id
  WHERE "Course".typical_year = (("Semester".start_date :: DATE - "Students".entry_date :: DATE) / 365)
  GROUP BY am,final_grade;
END
$$;


ALTER FUNCTION public.calcgrade() OWNER TO postgres;

--
-- Name: check_acceptable_registers(); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION public.check_acceptable_registers() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
DECLARE
  regNumber       INT;
  courseHasDepend CHAR(7);
  dependInpassed  REGISTER_STATUS;
BEGIN
  --CREATE TRIGGER check_acceptable_registers
  --AFTER UPDATE ON "Register"
  --FOR EACH ROW EXECUTE PROCEDURE check_acceptable_registers();

  regNumber:=(
    --check how many approved courses this student has
    SELECT count(*) regisnum
    FROM "Students"
      JOIN "Register" ON "Students".amka = "Register".student_amka
      JOIN "CourseRun" ON "Register".course_run_id = "CourseRun".serial_number
      JOIN "Course" ON "CourseRun".implements_course = "Course".course_code
      JOIN "Semester" ON "CourseRun".ruinsin_semester = "Semester".semester_id
    WHERE semester_status = 'present' AND register_status = 'approved' AND "Students".amka = NEW.student_amka);

  --check if student has required
  --courseHasDepend:=(SELECT "Course_depends".main depends
  --               FROM "Course_depends"
  --                   JOIN "Course" ON "Course_depends".dependent = "Course".course_code
  --                   JOIN "CourseRun" ON "Course".course_code = "CourseRun".implements_course
  --                    JOIN "Register" ON "CourseRun".serial_number = "Register".course_run_id
  --                  WHERE "Course_depends".mode = 'required' AND
  --                       register_status = 'approved' AND "CourseRun".serial_number = NEW.course_run_id AND
  --                       student_amka = NEW.student_amka);


  courseHasDepend:=(SELECT "Course_depends".main
                    FROM "Register"
                      JOIN "CourseRun" ON "Register".course_run_id = "CourseRun".serial_number
                      JOIN "Course_depends" ON "CourseRun".implements_course = "Course_depends".dependent
                    WHERE "Course_depends".mode = 'required' AND
                          "CourseRun".serial_number = NEW.course_run_id
                    LIMIT 1);

  --check if required course is passed
  dependInpassed:=(SELECT register_status
                   FROM "Course"
                     JOIN "CourseRun" ON "Course".course_code = "CourseRun".implements_course
                     JOIN "Register" ON "CourseRun".serial_number = "Register".course_run_id
                     JOIN "Semester" ON "CourseRun".ruinsin_semester = "Semester".semester_id
                   WHERE ("Course".course_code IN (courseHasDepend)) AND student_amka = NEW.student_amka
                   ORDER BY "Semester".start_date DESC
                   LIMIT 1);

  IF ((OLD.register_status = 'proposed' OR OLD.register_status = 'requested') AND
      NEW.register_status = 'approved')
  THEN
    IF (regNumber > 9)
    THEN
      NEW.register_status = 'rejected';
    ELSE
      IF (courseHasDepend IS NOT NULL)
      THEN
        IF ((dependInpassed IS NULL) OR (dependInpassed <> 'pass'))
        THEN
          NEW.register_status = 'rejected';
        END IF;
      END IF;
    END IF;
  END IF;
  RETURN new;
END;
$$;


ALTER FUNCTION public.check_acceptable_registers() OWNER TO postgres;

--
-- Name: course_run_end_generate_grades(); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION public.course_run_end_generate_grades() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
BEGIN
  --CREATE TRIGGER course_run_end_generate_grades
  --BEFORE UPDATE ON "Semester"
  --FOR EACH ROW EXECUTE PROCEDURE course_run_end_generate_grades();
  
  IF NEW.semester_status = 'past' AND old.semester_status = 'present'
  THEN
    --update exam
    UPDATE "Register"
    SET exam_grade = cast(random() * (10 - 1) + 1 AS INT)
    FROM "CourseRun", "Semester"
    WHERE
      "Register".course_run_id = "CourseRun".serial_number AND "CourseRun".ruinsin_semester = "Semester".semester_id AND
      exam_grade IS NULL AND
      "Register".register_status = 'approved' AND "Semester".semester_status = 'present';

    --update lab
    UPDATE "Register"
    SET lab_grade = cast(random() * (10 - 1) + 1 AS INT)
    FROM "CourseRun", "Semester", "Course"
    WHERE "Register".course_run_id = "CourseRun".serial_number
          AND "CourseRun".ruinsin_semester = "Semester".semester_id AND lab_grade IS NULL
          AND "CourseRun".implements_course = "Course".course_code AND "Register".register_status = 'approved' AND
          "Semester".semester_status = 'present' AND
          "Course".lab_hours > 0;

    --update Exam grade with lab hours and lab < MIN_LAB
    UPDATE "Register"
    SET exam_grade = 0
    FROM "CourseRun", "Semester", "Course"
    WHERE "Register".course_run_id = "CourseRun".serial_number
          AND "CourseRun".ruinsin_semester = "Semester".semester_id AND exam_grade IS NULL
          AND "CourseRun".implements_course = "Course".course_code AND "Register".register_status = 'approved' AND
          "Semester".semester_status = 'present' AND "Course".lab_hours > 0 AND
          "Register".lab_grade < "CourseRun".lab_min;

    --update Final grade without lab hours OR  with lab hours and lab < MIN_LAB OR with exam_grade<EXAM_MIN
    UPDATE "Register"
    SET final_grade = exam_grade
    FROM "CourseRun", "Semester", "Course"
    WHERE "Register".course_run_id = "CourseRun".serial_number
          AND "CourseRun".ruinsin_semester = "Semester".semester_id AND final_grade IS NULL
          AND "CourseRun".implements_course = "Course".course_code AND "Register".register_status = 'approved' AND
          "Semester".semester_status = 'present' AND
          ("Course".lab_hours = 0 OR "Register".lab_grade < "CourseRun".lab_min OR
           "Register".exam_grade < "CourseRun".exam_min);

    --update Final grade with lab hours and lab_grade>LAB_MIN AND
    UPDATE "Register"
    SET final_grade = (exam_grade * "CourseRun".exam_percentage + lab_grade * (100 - "CourseRun".exam_percentage)) / 100
    FROM "CourseRun", "Semester", "Course"
    WHERE "Register".course_run_id = "CourseRun".serial_number
          AND "CourseRun".ruinsin_semester = "Semester".semester_id AND final_grade IS NULL
          AND "CourseRun".implements_course = "Course".course_code AND "Register".register_status = 'approved' AND
          "Semester".semester_status = 'present' AND
          "Course".lab_hours > 0 AND "Register".lab_grade >= "CourseRun".lab_min AND
          "Register".exam_grade >= "CourseRun".exam_min;
    
    UPDATE "Register"
    SET register_status = 'pass'
    WHERE final_grade >= 5;

    UPDATE "Register"
    SET register_status = 'fail'
    WHERE final_grade < 5;
  END IF;
  RETURN new;
END;
$$;


ALTER FUNCTION public.course_run_end_generate_grades() OWNER TO postgres;

--
-- Name: create_all_basic_tables_and_types(); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION public.create_all_basic_tables_and_types() RETURNS void
    LANGUAGE plpgsql
    AS $$
BEGIN

  DROP VIEW vie_data;
  DROP TABLE IF EXISTS "Register";
  DROP TABLE IF EXISTS "Supports";
  DROP TABLE IF EXISTS "Teaches";
  DROP TABLE IF EXISTS "CourseRun";
  DROP TABLE IF EXISTS "Semester";
  DROP TABLE IF EXISTS "Committee";
  DROP TABLE IF EXISTS "Diplomas";
  DROP TABLE IF EXISTS "Directs";
  DROP TABLE IF EXISTS "Labstaff";
  DROP TABLE IF EXISTS "Students";
  DROP TABLE IF EXISTS "Professors";
  DROP TABLE IF EXISTS "Person";
  DROP TABLE IF EXISTS "Graduation_rules";

  DROP TYPE IF EXISTS REGISTER_STATUS;
  DROP TYPE IF EXISTS ACADEMIC_SEASON;
  DROP TYPE IF EXISTS SEMESTER_STATUS;
  DROP TYPE IF EXISTS LEVELS;
  DROP TYPE IF EXISTS RANK;

  CREATE TABLE "Graduation_rules" (
    min_courses SMALLINT NOT NULL,
    min_units   SMALLINT NOT NULL,
    year        DATE,
    PRIMARY KEY (year)
  );

  CREATE TABLE "Person" (
    amka        CHAR(10),
    email       CHAR(50) NOT NULL,
    fname       CHAR(50) NOT NULL,
    father_name CHAR(50),
    surname     CHAR(50) NOT NULL,
    PRIMARY KEY (amka),
    UNIQUE (email)
  );

  --CREATE TYPE RANK AS ENUM ('full', 'associate', 'assistant', 'lecture');
  CREATE TABLE "Professors" (
    rank      RANK NOT NULL,
    amka      CHAR(10) REFERENCES "Person" (amka) ON DELETE CASCADE ON UPDATE NO ACTION,
    joins_lab INT  NOT NULL REFERENCES "Lab" (lab_code),
    PRIMARY KEY (amka)
  );

  CREATE TABLE "Students" (
    entry_date DATE     NOT NULL,
    am         CHAR(10) NOT NULL,
    amka       CHAR(10) REFERENCES "Person" (amka) ON DELETE CASCADE ON UPDATE NO ACTION,
    UNIQUE (am),
    PRIMARY KEY (amka)
  );

  --CREATE TYPE LEVELS AS ENUM ('A', 'B', 'C', 'D');
  CREATE TABLE "Labstaff" (
    levels    LEVELS NOT NULL,
    amka      CHAR(10) REFERENCES "Person" (amka) ON DELETE CASCADE ON UPDATE NO ACTION,
    works_Lab INT    NOT NULL REFERENCES "Lab" (lab_code),
    PRIMARY KEY (amka)
  );
  ----------------------------------------------------------------

  CREATE TABLE "Directs" (
    directs_professor_amka CHAR(10) REFERENCES "Professors" (amka) ON DELETE CASCADE ON UPDATE NO ACTION,
    directs_lab_code       INT NOT NULL REFERENCES "Lab" (lab_code) ON DELETE CASCADE ON UPDATE NO ACTION
  );

  CREATE TABLE "Diplomas" (
    thesis_grade          SMALLINT,
    thesis_title          CHAR(100) NOT NULL,
    diploma_grade         SMALLINT,
    graduation_date       DATE,
    diploma_num           SERIAL    NOT NULL UNIQUE,
    graduate_student_amka CHAR(10)  NOT NULL REFERENCES "Students" (amka) ON DELETE CASCADE ON UPDATE NO ACTION,
    UNIQUE (graduate_student_amka)
  );

  CREATE TABLE "Committee" (
    supervisor  CHAR(10) NOT NULL REFERENCES "Professors" (amka) ON DELETE CASCADE ON UPDATE NO ACTION,
    professor2  CHAR(10) NOT NULL REFERENCES "Professors" (amka) ON DELETE CASCADE ON UPDATE NO ACTION,
    professor3  CHAR(10) NOT NULL REFERENCES "Professors" (amka) ON DELETE CASCADE ON UPDATE NO ACTION,
    diploma_num INT      NOT NULL REFERENCES "Diplomas" (diploma_num) ON DELETE CASCADE ON UPDATE NO ACTION
  );

  CREATE TYPE ACADEMIC_SEASON AS ENUM ('winter', 'spring');
  CREATE TYPE SEMESTER_STATUS AS ENUM ('past', 'present', 'future');
  CREATE TABLE "Semester" (
    semester_id     SERIAL,
    start_date      DATE            NOT NULL,
    end_date        DATE            NOT NULL,
    semester_status SEMESTER_STATUS NOT NULL,
    academic_season ACADEMIC_SEASON,
    academic_year   INT,
    PRIMARY KEY (semester_id)
  );

  CREATE TABLE "CourseRun" (
    serial_number     SERIAL,
    exam_percentage   SMALLINT NOT NULL,
    lab_min           SMALLINT NOT NULL,
    exam_min          SMALLINT NOT NULL,
    ruinsIn_Semester  INT      NOT NULL REFERENCES "Semester" (semester_id),
    uses_Lab          INT REFERENCES "Lab" (lab_code),
    implements_Course CHAR(7)  NOT NULL REFERENCES "Course" (course_code) ON DELETE CASCADE ON UPDATE NO ACTION,
    PRIMARY KEY (serial_number)
  );

  CREATE TABLE "Teaches" (
    teaches_professor1      CHAR(10) NOT NULL REFERENCES "Professors" (amka) ON DELETE CASCADE ON UPDATE NO ACTION,
    teaches_professor2      CHAR(10) REFERENCES "Professors" (amka) ON DELETE CASCADE ON UPDATE NO ACTION,
    courseRun_serial_number INT      NOT NULL REFERENCES "CourseRun" (serial_number) ON DELETE CASCADE ON UPDATE NO ACTION
  );

  CREATE TABLE "Supports" (
    courseRun_serial_number INT REFERENCES "CourseRun" (serial_number) ON DELETE CASCADE ON UPDATE NO ACTION,
    labstaff_amka           CHAR(10) REFERENCES "Labstaff" (amka) ON DELETE CASCADE ON UPDATE NO ACTION
  );

  CREATE TYPE REGISTER_STATUS AS ENUM ('proposed', 'requested', 'approved', 'rejected', 'pass', 'fail');
  CREATE TABLE "Register" (
    register_status REGISTER_STATUS NOT NULL,
    exam_grade      SMALLINT,
    lab_grade       SMALLINT,
    final_grade     SMALLINT,
    course_run_id   INT REFERENCES "CourseRun" (serial_number) ON DELETE CASCADE ON UPDATE NO ACTION,
    student_amka    CHAR(10) REFERENCES "Students" (amka) ON DELETE CASCADE ON UPDATE NO ACTION
  );
END;
$$;


ALTER FUNCTION public.create_all_basic_tables_and_types() OWNER TO postgres;

--
-- Name: create_am(integer, date); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION public.create_am(integer, date) RETURNS TABLE(rand_am character, idd integer)
    LANGUAGE plpgsql
    AS $_$
DECLARE
  counter INTEGER;
  tam    INTEGER;
BEGIN
  CREATE TABLE temp_am (
    am CHAR(10) UNIQUE,
    id INT
  );

  counter:=1;
  tam:=100000;
  LOOP
    INSERT INTO temp_am (am,id) SELECT cast(to_char($2, 'YYYY') || tam AS CHAR(10)),counter;
    counter:=counter + 1;
    tam:=tam + 1;
    EXIT WHEN counter > $1;
  END LOOP;

  RETURN QUERY
  SELECT am,id
  FROM temp_am;

  DROP TABLE temp_am;

END;
$_$;


ALTER FUNCTION public.create_am(integer, date) OWNER TO postgres;

--
-- Name: create_amka(integer); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION public.create_amka(integer) RETURNS TABLE(idd integer, ramka character)
    LANGUAGE plpgsql
    AS $_$
DECLARE
  counter  INTEGER;
  teamka   CHAR(10);
  exitcase BOOLEAN;
BEGIN
  CREATE TABLE temp_amka (
    id   INTEGER,
    amka CHAR(10) UNIQUE
  );

  counter:=1;
  LOOP
    exitcase:=FALSE;
    LOOP
      teamka:=(cast(random() * (9999999999 - 1000000000) + 1000000000 AS CHAR(10)));
      IF (teamka NOT IN (SELECT amka
                         FROM "Person") AND teamka NOT IN (SELECT amka
                                                           FROM "temp_amka"))
      THEN
        exitcase:= TRUE;
      END IF;
      EXIT WHEN exitcase = TRUE;
    END LOOP;
    INSERT INTO temp_amka (SELECT
                             counter,
                             teamka);
    counter:=counter + 1;
    EXIT WHEN counter > $1;
  END LOOP;

  RETURN QUERY
  SELECT
    id,
    amka
  FROM temp_amka;

  DROP TABLE temp_amka;

END;
$_$;


ALTER FUNCTION public.create_amka(integer) OWNER TO postgres;

--
-- Name: create_course_runs_for_semester(integer); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION public.create_course_runs_for_semester(semid integer) RETURNS void
    LANGUAGE plpgsql
    AS $_$
DECLARE
  cors_c CHAR(7);
BEGIN
  IF (SELECT "Semester".semester_status
      FROM "Semester"
      WHERE "Semester".semester_id = $1) = 'future'
  THEN

    CREATE TABLE temp_course_run (
      coImp CHAR(7) UNIQUE,
      examM SMALLINT,
      labM  SMALLINT,
      exPe  SMALLINT,
      lab   INTEGER,
      semR  INTEGER
    );
    DELETE FROM temp_course_run;

    CREATE TABLE cpt (
      ccod CHAR(7)
    );
    DELETE FROM cpt;

    IF (SELECT "Semester".academic_season
        FROM "Semester"
        WHERE "Semester".semester_id = semid) = 'winter'
    THEN
      INSERT INTO temp_course_run (coImp,semR) (
        SELECT course_code,$1
        FROM "Course"
        WHERE typical_season = 'winter');
    ELSE
      INSERT INTO temp_course_run (coImp,semR) (
        SELECT course_code,$1
        FROM "Course"
        WHERE typical_season = 'spring');
    END IF;

    CREATE TABLE tabl (
      exmM SMALLINT,
      laM  SMALLINT,
      ePe  SMALLINT,
      lb   INTEGER
    );

    FOR i IN 0..(SELECT count(coImp)
                 FROM temp_course_run) LOOP


      --Take temp course code
      SELECT coImp
      FROM temp_course_run
      OFFSET i
      LIMIT 1
      INTO cors_c;

      DELETE FROM tabl;

      INSERT INTO tabl (ePe,laM,exmM,lb) (SELECT
                             exam_percentage,
                             lab_min,
                             exam_min,
                             uses_lab
                           FROM "CourseRun"
                             JOIN "Semester"
                               ON "CourseRun".ruinsin_semester =
                                  "Semester".semester_id
                           WHERE implements_course = (cors_c)
                           ORDER BY "Semester".start_date DESC
                           LIMIT 1);

      UPDATE temp_course_run
      SET examM = tabl.exmM,
        labM    = tabl.laM,
        exPe    = tabl.ePe,
        lab     = tabl.lb
      FROM tabl
      WHERE temp_course_run.coImp =cors_c;

    END LOOP;

    --Set null values
    UPDATE temp_course_run
    SET exPe = cast(random() * (100 - 0) + 0 AS INT),
      examM  = cast(random() * (10 - 0) + 0 AS INT),
      labM   = cast(random() * (10 - 0) + 0 AS INT)
    WHERE (exPe IS NULL);

    --Fix null labs
    UPDATE temp_course_run
    SET lab = cast(random() * (10 - 1) + 1 AS INT)
    WHERE (lab IS NULL);

    --insert into CourseRun
    INSERT INTO "CourseRun" (implements_course, exam_percentage, exam_min, lab_min, uses_lab, ruinsin_semester)
      (SELECT
         coImp,
         exPe,
         examM,
         labM,
         lab,
         semR
       FROM temp_course_run);

    DROP TABLE cpt;
    DROP TABLE temp_course_run;
    DROP TABLE tabl;
  END IF;
END;
$_$;


ALTER FUNCTION public.create_course_runs_for_semester(semid integer) OWNER TO postgres;

--
-- Name: create_diploma(character, character, character, character, character); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION public.create_diploma(supervisor character, professor2 character, professor3 character, student character, diploma_title character) RETURNS void
    LANGUAGE plpgsql
    AS $$
BEGIN

  WITH ret AS (
    INSERT INTO "Diplomas" (thesis_title, graduate_student_amka)
      (SELECT
         diploma_title,
         "Students".amka
       FROM "Students"
       WHERE am = student)
       RETURNING diploma_num
      )
    INSERT INTO "Committee"
    SELECT
    supervisor,
    professor2,
    professor3,
    diploma_num
    FROM ret;

END;
$$;


ALTER FUNCTION public.create_diploma(supervisor character, professor2 character, professor3 character, student character, diploma_title character) OWNER TO postgres;

--
-- Name: create_diploma_for_5_year_students(); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION public.create_diploma_for_5_year_students() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
DECLARE
  temp_am CHAR(10);
BEGIN
  --                  JUST TO REMEMBER
  --CREATE TRIGGER create_diploma_for_5_year_students
  --BEFORE UPDATE ON "Semester"
  --FOR EACH ROW EXECUTE PROCEDURE create_diploma_for_5_year_students();

  IF (OLD.semester_status = 'future' AND NEW.semester_status = 'present')
  THEN
    CREATE TABLE IF NOT EXISTS students_temp (
      amka CHAR(10) UNIQUE
    );
    DELETE FROM students_temp;
    INSERT INTO students_temp (amka) (
      SELECT "Students".amka
      FROM "Students", "Semester"
      WHERE "Semester".start_date - "Students".entry_date >= 5 * 365
            AND "Semester".semester_id = NEW.semester_id
      EXCEPT
      SELECT "Diplomas".graduate_student_amka
      FROM "Diplomas");

    CREATE TABLE IF NOT EXISTS stud_temp (
      am CHAR(10) UNIQUE
    );
    DELETE FROM stud_temp;

    INSERT INTO stud_temp (am) (SELECT am
                                FROM "Students" st, students_temp
                                WHERE st.amka=students_temp.amka);

    FOR i IN 1..(SELECT count(am)
                 FROM stud_temp) LOOP
      SELECT am
      FROM stud_temp
      OFFSET i
      LIMIT 1
      INTO temp_am;

      PERFORM *
      FROM create_diploma_for_student(temp_am);
    END LOOP;

    DROP TABLE students_temp;
    DROP TABLE stud_temp;
  END IF;
  RETURN NEW;

END;
$$;


ALTER FUNCTION public.create_diploma_for_5_year_students() OWNER TO postgres;

--
-- Name: create_diploma_for_student(character); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION public.create_diploma_for_student(am_ character) RETURNS void
    LANGUAGE plpgsql
    AS $_$
BEGIN
  -----------------------SUPERVISOR--------------------------
  CREATE TABLE IF NOT EXISTS temp_professors_diplomas_su (
    amka   CHAR(10) UNIQUE,
    supNum INTEGER
  );
  DELETE FROM temp_professors_diplomas_su;

  INSERT INTO temp_professors_diplomas_su (amka, supNum)
    (SELECT
       "Professors".amka sup,
       count(su.supervisor)
     FROM ("Professors"
       LEFT JOIN "Committee" su ON "Professors".amka = su.supervisor)
     GROUP BY "Professors".amka);
  -------------------------PROFESSOR 2-------------------------------------
  CREATE TABLE IF NOT EXISTS temp_professors_diplomas_p1 (
    amka CHAR(10) UNIQUE,
    p1   INTEGER
  );
  DELETE FROM temp_professors_diplomas_p1;

  INSERT INTO temp_professors_diplomas_p1 (amka, p1)
    (SELECT
       "Professors".amka,
       count(pr1.professor2)
     FROM ("Professors"
       LEFT JOIN "Committee" pr1 ON "Professors".amka = pr1.professor2)
     GROUP BY "Professors".amka);
  -------------------------PROFESSOR 3--------------------------------------------------
  CREATE TABLE IF NOT EXISTS temp_professors_diplomas_p2 (
    amka CHAR(10) UNIQUE,
    p2   INTEGER
  );
  DELETE FROM temp_professors_diplomas_p2;

  INSERT INTO temp_professors_diplomas_p2 (amka, p2)
    (SELECT
       "Professors".amka,
       count(pr2.professor3)
     FROM ("Professors"
       LEFT JOIN "Committee" pr2 ON "Professors".amka = pr2.professor3)
     GROUP BY "Professors".amka);
  ---------------------------DIPLOMAS FOR EACH PROFESSOR---------------------
  CREATE TABLE IF NOT EXISTS temp_professors_diplomas (
    amka CHAR(10) UNIQUE,
    sum  INTEGER
  );
  DELETE FROM temp_professors_diplomas;

  INSERT INTO temp_professors_diplomas (amka, sum)
    (SELECT
       sup.amka,
       sup.supNum + prof.p1 + prof2.p2
     FROM temp_professors_diplomas_su sup
       JOIN temp_professors_diplomas_p1 prof ON sup.amka = prof.amka
       JOIN temp_professors_diplomas_p2 prof2 ON prof2.amka = prof.amka);

  DROP TABLE temp_professors_diplomas_su, temp_professors_diplomas_p2, temp_professors_diplomas_p1;

  ----------------------------NEED ROW FIX-------------------------------------
  CREATE TABLE IF NOT EXISTS temp (
    amka CHAR(10) UNIQUE,
    sum  INTEGER
  );
  DELETE FROM temp;
  INSERT INTO temp (amka, sum)
    (SELECT
       amka,
       sum
     FROM temp_professors_diplomas
     ORDER BY sum
     LIMIT 3);
  DROP TABLE temp_professors_diplomas;
  ----------------------------REVERSE TABLE-----------------------------------
  CREATE TABLE IF NOT EXISTS reverse_professors_for_diplomas (
    amka   CHAR(10) UNIQUE,
    sum    INTEGER,
    row_nu INTEGER
  );
  DELETE FROM reverse_professors_for_diplomas;
  INSERT INTO reverse_professors_for_diplomas (amka, sum, row_nu)
    (SELECT
       amka,
       sum,
       row_number()
       OVER () :: INTEGER
     FROM temp);
  DROP TABLE temp;
  ----------------------------END TABLE-----------------------------------
  CREATE TABLE IF NOT EXISTS professors_for_diplomas (
    super CHAR(10) UNIQUE,
    prof1 CHAR(10) UNIQUE,
    prof2 CHAR(10) UNIQUE,
    row_n INTEGER
  );

  INSERT INTO professors_for_diplomas (super, row_n) (SELECT
                                                        amka,
                                                        row_nu
                                                      FROM reverse_professors_for_diplomas
                                                      WHERE row_nu = 1);
  UPDATE professors_for_diplomas
  SET prof1 = amka
  FROM reverse_professors_for_diplomas
  WHERE row_nu = 2;

  UPDATE professors_for_diplomas
  SET prof2 = amka
  FROM reverse_professors_for_diplomas
  WHERE row_nu = 3;

  DROP TABLE reverse_professors_for_diplomas;
  ----------------------------INSERT DIPLOMA-----------------------------------
  PERFORM create_diploma(pd.super, pd.prof1, pd.prof2, $1, concat('Διπλωματική εργασία', ' ',
                                                                 "Person".surname, "Person".fname))
  FROM professors_for_diplomas pd, "Students"
    JOIN "Person" USING (amka)
  WHERE am = $1;

  DROP TABLE professors_for_diplomas;
END;
$_$;


ALTER FUNCTION public.create_diploma_for_student(am_ character) OWNER TO postgres;

--
-- Name: create_email(character, character); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION public.create_email(character, character) RETURNS TABLE(email character)
    LANGUAGE plpgsql
    AS $_$
BEGIN
  RETURN QUERY
  SELECT cast ((left($1, 1) || left($2, 3) || '_' || cast(random()*(100000-1000) AS CHAR(5)) || '@isc.tuc.gr') AS CHAR(50));
END;
$_$;


ALTER FUNCTION public.create_email(character, character) OWNER TO postgres;

--
-- Name: create_labsta_lev(integer); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION public.create_labsta_lev(integer) RETURNS TABLE(lev public.levels, idd integer)
    LANGUAGE plpgsql
    AS $_$
DECLARE
  counter INT;
BEGIN
  CREATE TABLE temp_po (
    le levels,
    id INT
  );

  counter:=1;
  LOOP
    INSERT INTO temp_po (le,id) SELECT (SELECT unnest(enum_range(NULL :: levels))
       ORDER BY random()
       LIMIT 1),counter;
    counter:=counter + 1;
    EXIT WHEN counter > $1;
  END LOOP;

  RETURN QUERY
  SELECT le,id
  FROM temp_po;

  DROP TABLE temp_po;

END;
$_$;


ALTER FUNCTION public.create_labsta_lev(integer) OWNER TO postgres;

--
-- Name: create_prof_ra(integer); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION public.create_prof_ra(integer) RETURNS TABLE(ran public.rank, idd integer)
    LANGUAGE plpgsql
    AS $_$
DECLARE
  counter INT;
BEGIN
  CREATE TABLE temp_po (
    pos rank,
    id INT
  );

  counter:=1;
  LOOP
    INSERT INTO temp_po (pos,id) SELECT (SELECT unnest(enum_range(NULL :: RANK))
       ORDER BY random()
       LIMIT 1),counter;
    counter:=counter + 1;
    EXIT WHEN counter > $1;
  END LOOP;

  RETURN QUERY
  SELECT pos,id
  FROM temp_po;

  DROP TABLE temp_po;

END;
$_$;


ALTER FUNCTION public.create_prof_ra(integer) OWNER TO postgres;

--
-- Name: diploma_grade_auto_insert(); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION public.diploma_grade_auto_insert() RETURNS void
    LANGUAGE plpgsql
    AS $$
BEGIN
  UPDATE "Diplomas"
  SET thesis_grade = cast(random() * (10 - 5) + 5 AS INT)
  FROM "Diplomas" di
    JOIN "Students" st ON di.graduate_student_amka = st.amka
    , "Semester"
  WHERE "Semester".semester_status = 'present' AND (di.thesis_grade IS NULL) AND
        (("Semester".start_date :: DATE - st.entry_date :: DATE)>= 5 * 365);
END;
$$;


ALTER FUNCTION public.diploma_grade_auto_insert() OWNER TO postgres;

--
-- Name: fix_surname(character, character); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION public.fix_surname(surname character, sex character) RETURNS TABLE(sur character)
    LANGUAGE plpgsql
    AS $$
BEGIN
  IF (sex = 'F')
  THEN
    RETURN QUERY
    SELECT cast(left(surname, length(surname) - 1) AS CHAR(50));
  ELSE
    RETURN QUERY
    SELECT surname;
  END IF;
END;
$$;


ALTER FUNCTION public.fix_surname(surname character, sex character) OWNER TO postgres;

--
-- Name: future_sem(); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION public.future_sem() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
BEGIN
  
  --CREATE TRIGGER future_sem
  --BEFORE INSERT ON "Semester"
  --FOR EACH ROW EXECUTE PROCEDURE future_sem();
  
  IF NEW.end_date > NEW.start_date AND NEW.start_date - (SELECT "Semester".end_date
                                                         FROM "Semester"
                                                         WHERE "Semester".semester_status = 'present') > 0
  THEN
    NEW.semester_status:='future';
    NEW.academic_year:=to_char(NEW.start_date, 'YYYY') :: INT;
    IF (SELECT "Semester".academic_season
        FROM "Semester"
        WHERE "Semester".semester_status = 'present') = 'winter'
    THEN
      NEW.academic_season:='spring';
    ELSE
      NEW.academic_season:='winter';
    END IF;
    RETURN new;
  ELSE
    RETURN NULL;
  END IF;
END;
$$;


ALTER FUNCTION public.future_sem() OWNER TO postgres;

--
-- Name: get_all_main_courses_depend_on_this(character); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION public.get_all_main_courses_depend_on_this(co character) RETURNS TABLE(mai character, ti character)
    LANGUAGE plpgsql
    AS $_$
BEGIN
  RETURN QUERY
SELECT
  "Course_depends".main,
  "Course".course_title
FROM "Course_depends", "Course"
WHERE "Course_depends".main = "Course".course_code AND "Course_depends".dependent = $1;
END;
$_$;


ALTER FUNCTION public.get_all_main_courses_depend_on_this(co character) OWNER TO postgres;

--
-- Name: get_all_names_and_positions(); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION public.get_all_names_and_positions() RETURNS TABLE(fname character, surname character, amka character, positio text)
    LANGUAGE plpgsql
    AS $$
BEGIN
  RETURN QUERY
  SELECT
    "Person".fname,
    "Person".surname,
    "Person".amka,
    'Professor'
  FROM "Person"  JOIN  "Professors" USING (amka)
  UNION
  SELECT
    "Person".fname,
    "Person".surname,
    "Person".amka,
    'Labstaff'
  FROM "Person" JOIN "Labstaff" USING (amka)
  UNION
  SELECT
    "Person".fname,
    "Person".surname,
    "Person".amka,
    'Students'
  FROM "Person" JOIN  "Students" USING (amka);
END;
$$;


ALTER FUNCTION public.get_all_names_and_positions() OWNER TO postgres;

--
-- Name: get_am_students_going_to_graduate(); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION public.get_am_students_going_to_graduate() RETURNS TABLE(am_ character)
    LANGUAGE plpgsql
    AS $$
BEGIN
  RETURN QUERY
  SELECT obli.am
  FROM (SELECT
          count(*)   obc,
          am,
          sum(units) un
        FROM "Students"
          JOIN "Register" ON "Students".amka = "Register".student_amka
          JOIN "CourseRun" ON "Register".course_run_id = "CourseRun".serial_number
          JOIN "Course" ON "CourseRun".implements_course = "Course".course_code
        WHERE register_status = 'pass' AND obligatory = TRUE
        GROUP BY am
       ) AS obli LEFT OUTER JOIN (SELECT
                                    count(*)   notobli,
                                    am,
                                    sum(units) un
                                  FROM "Students"
                                    JOIN "Register" ON "Students".amka = "Register".student_amka
                                    JOIN "CourseRun" ON "Register".course_run_id = "CourseRun".serial_number
                                    JOIN "Course" ON "CourseRun".implements_course = "Course".course_code
                                  WHERE register_status = 'pass' AND obligatory = FALSE
                                  GROUP BY am) AS notObli USING (am)
    , ("Students"
      JOIN "Graduation_rules"
        ON (to_char("Graduation_rules".year, 'YYYY') = to_char("Students".entry_date, 'YYYY'))) AS gra
    , (SELECT count(*) needed
       FROM "Course"
       WHERE obligatory = TRUE
      ) AS ned
    ,
    "Diplomas"
  WHERE obli.am = gra.am AND obli.obc >= ned.needed AND notobli.notobli >= gra.min_courses - ned.needed AND
        (obli.un + notObli) >= gra.min_units AND graduate_student_amka=amka AND (graduation_date IS NULL);
END;
$$;


ALTER FUNCTION public.get_am_students_going_to_graduate() OWNER TO postgres;

--
-- Name: get_courses_a_student_need_to_pass(character); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION public.get_courses_a_student_need_to_pass(amka character) RETURNS TABLE(code character)
    LANGUAGE plpgsql
    AS $_$
BEGIN
  RETURN QUERY
  SELECT c1.course_code
  FROM "Course" c1
  WHERE c1.obligatory = TRUE AND c1.course_code
                                 NOT IN (
                                   SELECT course_code
                                   FROM "Students" s
                                     INNER JOIN "Register" r ON (s.amka = r.student_amka)
                                     INNER JOIN "CourseRun" cr ON (r.course_run_id = cr.serial_number)
                                     INNER JOIN "Course" c ON (cr.implements_Course = c.course_code)
                                   WHERE r.register_status = 'pass' AND s.amka = $1
                                 );
END;
$_$;


ALTER FUNCTION public.get_courses_a_student_need_to_pass(amka character) OWNER TO postgres;

--
-- Name: get_lab_hours_for_labstaf(); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION public.get_lab_hours_for_labstaf() RETURNS TABLE(amka character, sur character, fn character, lhou integer)
    LANGUAGE plpgsql
    AS $$
BEGIN
  RETURN QUERY
  SELECT
    "Person".amka,
    "Person".surname,
    "Person".fname,
    sum("Course".lab_hours)::integer
  FROM "Person"
    JOIN "Labstaff" ON "Person".amka = "Labstaff".amka
    JOIN "Supports" ON "Labstaff".amka = "Supports".labstaff_amka
    JOIN "CourseRun" ON "Supports".courserun_serial_number = "CourseRun".serial_number
    JOIN "Course" ON "CourseRun".implements_course = "Course".course_code
  GROUP BY "Person".amka;
END;
$$;


ALTER FUNCTION public.get_lab_hours_for_labstaf() OWNER TO postgres;

--
-- Name: get_random_father_names(integer); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION public.get_random_father_names(num integer) RETURNS TABLE(fname character, idd integer)
    LANGUAGE plpgsql
    AS $$
BEGIN
  RETURN QUERY
  SELECT
    na.name,
    row_number()
    OVER () :: INTEGER
  FROM (SELECT
          n.name
        FROM "Name" n,"Name" b
        WHERE n.sex = 'M'
        ORDER BY random()
        LIMIT num) AS na;
END;
$$;


ALTER FUNCTION public.get_random_father_names(num integer) OWNER TO postgres;

--
-- Name: get_random_names(integer); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION public.get_random_names(num integer) RETURNS TABLE(name character, sex character, idd integer)
    LANGUAGE plpgsql
    AS $$
BEGIN
  RETURN QUERY
  SELECT
    p.name,
    p.sex,
    row_number()
    OVER () :: INTEGER
  FROM (SELECT
          a.name,
          a.sex
        FROM "Name" a,"Name" b
        ORDER BY random()
        LIMIT num) AS p;
END;
$$;


ALTER FUNCTION public.get_random_names(num integer) OWNER TO postgres;

--
-- Name: get_random_surnames(integer); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION public.get_random_surnames(num integer) RETURNS TABLE(surname character, idd integer)
    LANGUAGE plpgsql
    AS $$
BEGIN
	RETURN QUERY
	SELECT sn.surname, row_number() OVER ()::integer
	FROM (SELECT s1.surname
	      FROM "Surname" s1
	      WHERE right(s1.surname,2)='ΗΣ'
	      ORDER BY random() LIMIT num) as sn;
END;
$$;


ALTER FUNCTION public.get_random_surnames(num integer) OWNER TO postgres;

--
-- Name: insert_graduation_grade_and_data(date); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION public.insert_graduation_grade_and_data(dat date) RETURNS void
    LANGUAGE plpgsql
    AS $$DECLARE
  temp_am CHAR(10);
  Oblig   INT;
  NotObli INT;
BEGIN

  CREATE TABLE am (
    am CHAR(10)
  );
  INSERT INTO am (am) (SELECT *
                       FROM get_am_students_going_to_graduate());

  CREATE TABLE tem (
    av INT
  );

  FOR i IN 0..(SELECT count(am)
               FROM am) LOOP

    DELETE FROM tem;

    SELECT am
    FROM am
    OFFSET 0
    LIMIT 1
    INTO temp_am;

    SELECT sum(final_grade * weight) sum
    FROM (SELECT
            final_grade,
            weight
          FROM "Students"
            JOIN "Register" ON "Students".amka = "Register".student_amka
            JOIN "CourseRun" ON "Register".course_run_id = "CourseRun".serial_number
            JOIN "Course" ON "CourseRun".implements_course = "Course".course_code
          WHERE register_status = 'pass' AND obligatory = TRUE AND am = temp_am) AS obl
    INTO Oblig;

    SELECT sum(final_grade * weight) sum
    FROM (
           SELECT
             final_grade,
             weight
           FROM "Students"
             JOIN "Register" ON "Students".amka = "Register".student_amka
             JOIN "CourseRun" ON "Register".course_run_id = "CourseRun".serial_number
             JOIN "Course" ON "CourseRun".implements_course = "Course".course_code
           WHERE register_status = 'pass' AND obligatory = FALSE AND am = temp_am
           ORDER BY final_grade DESC
           LIMIT 14) AS noto
    INTO NotObli;


    INSERT INTO  tem(av) ((SELECT (((thesis_grade) * 0, 2) + (0, 8 * ((Oblig + NotObli) / 49))) ave
          FROM "Diplomas"
            JOIN "Students" ON "Students".amka = "Diplomas".graduate_student_amka
          WHERE am = temp_am));

    UPDATE "Diplomas"
    SET graduation_date = dat,
      diploma_grade     = tem.av
      FROM "Diplomas" di JOIN "Students" ON di.graduate_student_amka = "Students".amka
    WHERE am=temp_am;
  END LOOP;
  DROP TABLE am;
  DROP TABLE tem;
END;
$$;


ALTER FUNCTION public.insert_graduation_grade_and_data(dat date) OWNER TO postgres;

--
-- Name: insert_people(integer, integer, integer, date); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION public.insert_people(prof integer, lab integer, stud integer, da date) RETURNS TABLE(value character)
    LANGUAGE plpgsql
    AS $$
BEGIN
  CREATE TABLE temp_amka_new (
    t_amka CHAR(10) UNIQUE,
    id     INTEGER
  );
  DELETE FROM temp_amka_new;

  INSERT INTO "temp_amka_new" (t_amka, id) SELECT
                                             am.ramka,
                                             am.idd
                                           FROM create_amka(stud) am;

  INSERT INTO "Person"
    SELECT
      t_amka,
      create_email(n.name, sn.surname),
      n.name,
      fname,
      fix_surname(sn.surname, sex)
    FROM "temp_amka_new"
      JOIN get_random_names(stud) n ON (id = n.idd)
      JOIN get_random_surnames(stud) sn USING (idd)
      JOIN get_random_father_names(stud) fn USING (idd);

  INSERT INTO "Students"
    SELECT
      da,
      am.rand_am,
      t_amka
    FROM "temp_amka_new"
      JOIN create_am(stud, da) am ON (id = am.idd);
--------------------------------------------------------------------
  DELETE FROM temp_amka_new;

  INSERT INTO "temp_amka_new" (t_amka, id) SELECT
                                             am.ramka,
                                             am.idd
                                           FROM create_amka(lab) am;

  INSERT INTO "Person"
    SELECT
      t_amka,
      create_email(n.name, sn.surname),
      n.name,
      fname,
      fix_surname(sn.surname, sex)
    FROM "temp_amka_new"
      JOIN get_random_names(lab) n ON (id = n.idd)
      JOIN get_random_surnames(lab) sn USING (idd)
      JOIN get_random_father_names(lab) fn USING (idd);

  INSERT INTO "Labstaff"
    SELECT
      lev,
      t_amka,
      cast(random() * (10 - 1) + 1 AS INT)
    FROM "temp_amka_new" JOIN create_labsta_lev(lab) po ON po.idd=id;
--------------------------------------------------------------------------------------
  DELETE FROM temp_amka_new;

  INSERT INTO "temp_amka_new" (t_amka, id) SELECT
                                             am.ramka,
                                             am.idd
                                           FROM create_amka(prof) am;

  INSERT INTO "Person"
    SELECT
      t_amka,
      create_email(n.name, sn.surname),
      n.name,
      fname,
      fix_surname(sn.surname, sex)
    FROM "temp_amka_new"
      JOIN get_random_names(prof) n ON (id = n.idd)
      JOIN get_random_surnames(prof) sn USING (idd)
      JOIN get_random_father_names(prof) fn USING (idd);

  INSERT INTO "Professors"
    SELECT
      ran,
      t_amka,
      cast(random() * (10 - 1) + 1 AS INT)
    FROM "temp_amka_new" JOIN create_prof_ra(prof) po ON po.idd=id;

  DROP TABLE temp_amka_new;
END;
$$;


ALTER FUNCTION public.insert_people(prof integer, lab integer, stud integer, da date) OWNER TO postgres;

--
-- Name: make_graduated_students(date); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION public.make_graduated_students(da date) RETURNS void
    LANGUAGE plpgsql
    AS $$
DECLARE
  t_am        CHAR(10);
  oblAver     INT;
  NotOblAver  INT;
  totalWeight INT;
BEGIN
  totalWeight:=71.5; --(31 Obl + 14 Not )*1.5 +4 Engl

  CREATE TABLE tm (
    am CHAR(10) UNIQUE
  );
  INSERT INTO tm (am) (SELECT *
                       FROM get_am_students_going_to_graduate());


  FOR i IN 0..(SELECT count(am)
               FROM tm) LOOP

    SELECT am
    FROM tm
    OFFSET i
    LIMIT 1
    INTO t_am;

    oblAver:=(SELECT sum(weight * final_grade)
              FROM "Students"
                JOIN "Register" ON "Students".amka = "Register".student_amka
                JOIN "CourseRun" ON "Register".course_run_id = "CourseRun".serial_number
                JOIN "Course" ON "Course".course_code = "CourseRun".implements_course
              WHERE obligatory = TRUE AND "Register".register_status = 'pass' AND am = t_am);

    NotOblAver:=(SELECT sum(weight * final_grade) su
                 FROM "Students"
                   JOIN "Register" ON "Students".amka = "Register".student_amka
                   JOIN "CourseRun" ON "Register".
                                       course_run_id = "CourseRun".serial_number
                   JOIN "Course" ON "Course"
                                    .course_code =
                                    "CourseRun".implements_course
                 WHERE obligatory = FALSE AND "Register".register_status = 'pass' AND am = t_am);

    UPDATE "Diplomas"
    SET graduation_date = da,
      diploma_grade     = ((((oblAver + NotOblAver) / totalWeight) * 0.8) + (di.thesis_grade * 0.2))
    FROM "Diplomas" di
      JOIN "Students" ON "Students".amka = di.graduate_student_amka
    WHERE "Students".am = t_am;
  END LOOP;
  DROP TABLE tm;
END;
$$;


ALTER FUNCTION public.make_graduated_students(da date) OWNER TO postgres;

--
-- Name: only_highest_professors(); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION public.only_highest_professors() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
BEGIN
  --CREATE TRIGGER only_highest_professors
  --BEFORE INSERT ON "Directs"
  --FOR EACH ROW EXECUTE PROCEDURE only_highest_professors();
  IF ((SELECT rank
      FROM "Professors"
      WHERE NEW.directs_professor_amka = "Professors".amka) = 'full'::rank)
  THEN
    RETURN NEW;
  ELSE
    RETURN null;
  END IF;

END;
$$;


ALTER FUNCTION public.only_highest_professors() OWNER TO postgres;

--
-- Name: present_to_past_sem(); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION public.present_to_past_sem() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
BEGIN
  --CREATE TRIGGER present_to_past_sem
  --BEFORE UPDATE ON "Semester"
  --FOR EACH ROW EXECUTE PROCEDURE present_to_past_sem();
  IF NEW.semester_status = 'present' AND old.semester_status = 'future'
  THEN
    IF NEW.start_date - (SELECT "Semester".end_date
                         FROM "Semester"
                         WHERE semester_status = 'present') > 0
    THEN
      UPDATE "Semester"
      SET semester_status = 'past'
      WHERE semester_status = 'present';

    END IF;
  END IF;
  RETURN new;
END;
$$;


ALTER FUNCTION public.present_to_past_sem() OWNER TO postgres;

--
-- Name: propose_courses_to_all(); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION public.propose_courses_to_all() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
DECLARE
  temp_amka CHAR(10);
BEGIN
  --CREATE TRIGGER propose_courses_to_all
  --AFTER UPDATE ON "Semester"
  --FOR EACH ROW EXECUTE PROCEDURE propose_courses_to_all();

  IF OLD.semester_status = 'future' AND NEW.semester_status = 'present'
  THEN
    FOR i IN 0.. (SELECT count(amka)
                  FROM "Students") LOOP
      SELECT amka
      FROM "Students"
      OFFSET i
      LIMIT 1
      INTO temp_amka;

      PERFORM *
      FROM propose_courses_to_student(temp_amka);
    END LOOP;
  END IF;
RETURN NEW;
END;
$$;


ALTER FUNCTION public.propose_courses_to_all() OWNER TO postgres;

--
-- Name: propose_courses_to_student(character); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION public.propose_courses_to_student(am character) RETURNS void
    LANGUAGE plpgsql
    AS $_$
BEGIN

INSERT INTO "Register" (course_run_id, register_status, student_amka) (
  SELECT
    gb.cs,
    'proposed',
    $1
  FROM (SELECT DISTINCT "CourseRun".serial_number cs
        FROM "CourseRun"
          JOIN "Semester" ON "CourseRun".ruinsin_semester = "Semester".semester_id
          , ((---ALL AVAILABLE COURSES
               SELECT DISTINCT course_code cc
               FROM "Course"
                 JOIN "CourseRun" ON "Course".course_code = "CourseRun".implements_course
                 JOIN "Semester" ON "CourseRun".ruinsin_semester = "Semester".semester_id
                 , "Students"
               WHERE
                 semester_status='present' AND amka = $1 AND
                 "Course".typical_year :: INT <= (("Semester".start_date :: DATE -
                                                   "Students".entry_date :: DATE)
                                                  /
                                                  365) + 1 :: INT)
             EXCEPT
             --EXCEPT PASSED COURSES
             (SELECT implements_course
              FROM "Students"
                JOIN "Register" ON "Students".amka = "Register".student_amka
                JOIN "CourseRun" ON "Register".course_run_id = "CourseRun".serial_number
              WHERE register_status = 'pass' AND student_amka = $1)) AS cou
        WHERE "Semester".semester_status = 'present' AND "CourseRun".implements_course = cou.cc) as gb);

END;
$_$;


ALTER FUNCTION public.propose_courses_to_student(am character) OWNER TO postgres;

--
-- Name: search_student_personal_data(character); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION public.search_student_personal_data(am character) RETURNS TABLE(amka character, email character, fname character, father_name character, surname character)
    LANGUAGE plpgsql
    AS $_$
BEGIN
  RETURN QUERY
  SELECT
    "Person".amka,
    "Person".email,
    "Person".fname,
    "Person".father_name,
    "Person".surname
  FROM "Person" JOIN "Students" ON "Person".amka = "Students".amka
  WHERE  "Students".am = $1;
END;
$_$;


ALTER FUNCTION public.search_student_personal_data(am character) OWNER TO postgres;

--
-- Name: section_with_max_diploma(); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION public.section_with_max_diploma() RETURNS TABLE(re character)
    LANGUAGE plpgsql
    AS $$
BEGIN

  CREATE TABLE "tmp_data" (
    sum   INT,
    title CHAR(100)
  );

  INSERT INTO "tmp_data" (
    SELECT
      count(*) :: INT                   AS sectCou,
      "Sector".sector_title :: CHAR(50) AS title
    FROM "Sector"
      JOIN "Lab" ON "Sector".sector_code = "Lab".sector_code
      JOIN "Professors" ON "Lab".lab_code = "Professors".joins_lab
      JOIN "Committee" ON "Professors".amka = "Committee".supervisor
      JOIN "Diplomas" ON "Committee".diploma_num = "Diplomas".diploma_num
    WHERE graduation_date IS NOT NULL
    GROUP BY "Sector".sector_title);

RETURN QUERY(
  SELECT title
  FROM "tmp_data"
  WHERE sum = (SELECT max(sum)
               FROM "tmp_data"));

  DROP TABLE "tmp_data";
END;
$$;


ALTER FUNCTION public.section_with_max_diploma() OWNER TO postgres;

--
-- Name: students_registered_on_this_semester_specific_course(character); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION public.students_registered_on_this_semester_specific_course(course_code character) RETURNS TABLE(fname character, surname character, am character)
    LANGUAGE plpgsql
    AS $_$
BEGIN
  
--CREATE INDEX register_student_index on "Register" (student_amka);
--CREATE INDEX register_courseRun_index on "Register"(course_run_id);
--CREATE INDEX courseRun_ruinsSeme_index on "CourseRun"(ruinsin_semester);
--CREATE INDEX courseRun_implemCou_index on "CourseRun"(implements_course);
--CREATE INDEX register_status_index on "Register"(register_status);
  RETURN QUERY
  SELECT "Person".fname,
  "Person".surname,
  "Students".am
  FROM "Person"
    JOIN "Students" ON "Person".amka = "Students".amka
    JOIN "Register" ON "Students".amka = "Register".student_amka
    JOIN "CourseRun" ON "CourseRun".serial_number = "Register".course_run_id
    JOIN "Semester" ON "CourseRun".ruinsin_semester = "Semester".semester_id
    JOIN "Course" ON "CourseRun".implements_course = "Course".course_code
  WHERE "Register".register_status = 'approved'
        AND "Semester".semester_status = 'present'
        AND "Course".course_code = $1;
END;
$_$;


ALTER FUNCTION public.students_registered_on_this_semester_specific_course(course_code character) OWNER TO postgres;

--
-- Name: view_prepare(); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION public.view_prepare() RETURNS TABLE(_am character, _surname character, _fname character, _grade integer, _year integer)
    LANGUAGE plpgsql
    AS $$
DECLARE

BEGIN

CREATE TABLE temp_people (
  am      CHAR(10),
  surname CHAR(50),
  fname   CHAR(50),
  grade   INT,
  year    INTEGER
);
INSERT INTO temp_people (am, surname, fname, year) (SELECT
                                                      am,
                                                      surname,
                                                      fname,
                                                      (SELECT (("Semester".start_date :: DATE -
                                                                "Students".entry_date :: DATE) / 365) + 1) AS year
                                                    FROM "Students"
                                                      JOIN "Person" USING (amka)
                                                      , "Semester"
                                                    WHERE "semester_status" = 'present');


for i in 0..(Select count(am) from temp_people) loop
end loop;
END;
$$;


ALTER FUNCTION public.view_prepare() OWNER TO postgres;

SET default_tablespace = '';

SET default_with_oids = false;

--
-- Name: Committee; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public."Committee" (
    supervisor character(10) NOT NULL,
    professor2 character(10) NOT NULL,
    professor3 character(10) NOT NULL,
    diploma_num integer NOT NULL
);


ALTER TABLE public."Committee" OWNER TO postgres;

--
-- Name: Course; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public."Course" (
    course_code character(7) NOT NULL,
    course_title character(100) NOT NULL,
    units smallint NOT NULL,
    ects smallint NOT NULL,
    weight real NOT NULL,
    lecture_hours smallint NOT NULL,
    tutorial_hours smallint NOT NULL,
    lab_hours smallint NOT NULL,
    typical_year smallint NOT NULL,
    typical_season public.semester_season_type NOT NULL,
    obligatory boolean NOT NULL
);


ALTER TABLE public."Course" OWNER TO postgres;

--
-- Name: CourseRun; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public."CourseRun" (
    serial_number integer NOT NULL,
    exam_percentage smallint NOT NULL,
    lab_min smallint NOT NULL,
    exam_min smallint NOT NULL,
    ruinsin_semester integer NOT NULL,
    uses_lab integer,
    implements_course character(7) NOT NULL
);


ALTER TABLE public."CourseRun" OWNER TO postgres;

--
-- Name: CourseRun_serial_number_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public."CourseRun_serial_number_seq"
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public."CourseRun_serial_number_seq" OWNER TO postgres;

--
-- Name: CourseRun_serial_number_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public."CourseRun_serial_number_seq" OWNED BY public."CourseRun".serial_number;


--
-- Name: Course_depends; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public."Course_depends" (
    dependent character(7) NOT NULL,
    main character(7) NOT NULL,
    mode public.course_dependency_mode_type
);


ALTER TABLE public."Course_depends" OWNER TO postgres;

--
-- Name: Course_description; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public."Course_description" (
    course_code character(7) NOT NULL,
    course_description character varying NOT NULL
);


ALTER TABLE public."Course_description" OWNER TO postgres;

--
-- Name: Diplomas; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public."Diplomas" (
    thesis_grade smallint,
    thesis_title character(100) NOT NULL,
    diploma_grade smallint,
    graduation_date date,
    diploma_num integer NOT NULL,
    graduate_student_amka character(10) NOT NULL
);


ALTER TABLE public."Diplomas" OWNER TO postgres;

--
-- Name: Diplomas_diploma_num_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public."Diplomas_diploma_num_seq"
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public."Diplomas_diploma_num_seq" OWNER TO postgres;

--
-- Name: Diplomas_diploma_num_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public."Diplomas_diploma_num_seq" OWNED BY public."Diplomas".diploma_num;


--
-- Name: Directs; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public."Directs" (
    directs_professor_amka character(10),
    directs_lab_code integer NOT NULL
);


ALTER TABLE public."Directs" OWNER TO postgres;

--
-- Name: Fields; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public."Fields" (
    field_code character(3) NOT NULL,
    field character(100) NOT NULL
);


ALTER TABLE public."Fields" OWNER TO postgres;

--
-- Name: Graduation_rules; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public."Graduation_rules" (
    min_courses smallint NOT NULL,
    min_units smallint NOT NULL,
    year date NOT NULL
);


ALTER TABLE public."Graduation_rules" OWNER TO postgres;

--
-- Name: Lab; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public."Lab" (
    lab_code integer NOT NULL,
    sector_code integer NOT NULL,
    lab_title character(100) NOT NULL,
    lab_description character varying
);


ALTER TABLE public."Lab" OWNER TO postgres;

--
-- Name: Lab_fields; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public."Lab_fields" (
    lab_code integer NOT NULL,
    field_code character(3) NOT NULL
);


ALTER TABLE public."Lab_fields" OWNER TO postgres;

--
-- Name: Labstaff; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public."Labstaff" (
    levels public.levels NOT NULL,
    amka character(10) NOT NULL,
    works_lab integer NOT NULL
);


ALTER TABLE public."Labstaff" OWNER TO postgres;

--
-- Name: Name; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public."Name" (
    name character(30) NOT NULL,
    sex character(1) NOT NULL
);


ALTER TABLE public."Name" OWNER TO postgres;

--
-- Name: Person; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public."Person" (
    amka character(10) NOT NULL,
    email character(50) NOT NULL,
    fname character(50) NOT NULL,
    father_name character(50),
    surname character(50) NOT NULL
);


ALTER TABLE public."Person" OWNER TO postgres;

--
-- Name: Professors; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public."Professors" (
    rank public.rank NOT NULL,
    amka character(10) NOT NULL,
    joins_lab integer NOT NULL
);


ALTER TABLE public."Professors" OWNER TO postgres;

--
-- Name: Register; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public."Register" (
    register_status public.register_status NOT NULL,
    exam_grade smallint,
    lab_grade smallint,
    final_grade smallint,
    course_run_id integer,
    student_amka character(10)
);


ALTER TABLE public."Register" OWNER TO postgres;

--
-- Name: Sector; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public."Sector" (
    sector_code integer NOT NULL,
    sector_title character(100) NOT NULL,
    sector_description character varying
);


ALTER TABLE public."Sector" OWNER TO postgres;

--
-- Name: Semester; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public."Semester" (
    semester_id integer NOT NULL,
    start_date date NOT NULL,
    end_date date NOT NULL,
    semester_status public.semester_status NOT NULL,
    academic_season public.academic_season,
    academic_year integer
);


ALTER TABLE public."Semester" OWNER TO postgres;

--
-- Name: Semester_semester_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public."Semester_semester_id_seq"
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public."Semester_semester_id_seq" OWNER TO postgres;

--
-- Name: Semester_semester_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public."Semester_semester_id_seq" OWNED BY public."Semester".semester_id;


--
-- Name: Students; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public."Students" (
    entry_date date NOT NULL,
    am character(10) NOT NULL,
    amka character(10) NOT NULL
);


ALTER TABLE public."Students" OWNER TO postgres;

--
-- Name: Supports; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public."Supports" (
    courserun_serial_number integer,
    labstaff_amka character(10)
);


ALTER TABLE public."Supports" OWNER TO postgres;

--
-- Name: Surname; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public."Surname" (
    surname character(50) NOT NULL
);


ALTER TABLE public."Surname" OWNER TO postgres;

--
-- Name: Teaches; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public."Teaches" (
    teaches_professor1 character(10) NOT NULL,
    teaches_professor2 character(10),
    courserun_serial_number integer NOT NULL
);


ALTER TABLE public."Teaches" OWNER TO postgres;

--
-- Name: phase2_materialized; Type: MATERIALIZED VIEW; Schema: public; Owner: postgres
--

CREATE MATERIALIZED VIEW public.phase2_materialized AS
 SELECT "Students".am,
    "Students".amka,
    "Person".fname,
    "Person".surname,
    count("Register".register_status) AS count,
    sum("Course".units) AS sum
   FROM ((((public."Students"
     JOIN public."Person" USING (amka))
     JOIN public."Register" ON (("Students".amka = "Register".student_amka)))
     JOIN public."CourseRun" ON (("Register".course_run_id = "CourseRun".serial_number)))
     JOIN public."Course" ON (("CourseRun".implements_course = "Course".course_code)))
  WHERE (("Person".surname ~~ '%ΑΛ%'::text) AND ("Register".register_status = 'approved'::public.register_status))
  GROUP BY "Students".am, "Students".amka, "Person".fname, "Person".surname
  WITH NO DATA;


ALTER TABLE public.phase2_materialized OWNER TO postgres;

--
-- Name: phase2_view; Type: VIEW; Schema: public; Owner: postgres
--

CREATE VIEW public.phase2_view AS
 SELECT "Students".am,
    "Students".amka,
    "Person".fname,
    "Person".surname,
    count("Register".register_status) AS count,
    sum("Course".units) AS sum
   FROM ((((public."Students"
     JOIN public."Person" USING (amka))
     JOIN public."Register" ON (("Students".amka = "Register".student_amka)))
     JOIN public."CourseRun" ON (("Register".course_run_id = "CourseRun".serial_number)))
     JOIN public."Course" ON (("CourseRun".implements_course = "Course".course_code)))
  WHERE (("Person".surname ~~ '%ΑΛ%'::text) AND ("Register".register_status = 'approved'::public.register_status))
  GROUP BY "Students".am, "Students".amka, "Person".fname, "Person".surname;


ALTER TABLE public.phase2_view OWNER TO postgres;

--
-- Name: temp_people; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.temp_people (
    am character(10),
    surname character(50),
    fname character(50),
    grade integer,
    year integer
);


ALTER TABLE public.temp_people OWNER TO postgres;

--
-- Name: tessera_duo; Type: VIEW; Schema: public; Owner: postgres
--

CREATE VIEW public.tessera_duo AS
 SELECT pers.am,
    pers.surname,
    pers.fname,
    compls.grade,
    compls.yea
   FROM (( SELECT obl.am AS am_,
            (obl.pas + notobl.pas) AS passed,
            ((obl.gra + notobl.gra) / (obl.wei + notobl.wei)) AS grade,
            (obl.tyea + 1) AS yea
           FROM (( SELECT "Students".am,
                    count("Register".register_status) AS pas,
                    sum((("Register".final_grade)::double precision * "Course".weight)) AS gra,
                    sum("Course".weight) AS wei,
                    "Course".typical_year AS tyea
                   FROM (((((public."Students"
                     JOIN public."Person" USING (amka))
                     JOIN public."Register" ON (("Students".amka = "Register".student_amka)))
                     JOIN public."CourseRun" ON (("Register".course_run_id = "CourseRun".serial_number)))
                     JOIN public."Course" ON (("CourseRun".implements_course = "Course".course_code)))
                     JOIN public."Semester" ON (("CourseRun".ruinsin_semester = "Semester".semester_id)))
                  WHERE ("Course".obligatory AND ("Register".register_status = 'pass'::public.register_status) AND ("Course".typical_year = (("Semester".start_date - "Students".entry_date) / 365)))
                  GROUP BY "Students".am, "Register".register_status, "Course".typical_year) obl
             JOIN ( SELECT "Students".am,
                    count("Register".register_status) AS pas,
                    sum((("Register".final_grade)::double precision * "Course".weight)) AS gra,
                    sum("Course".weight) AS wei,
                    "Course".typical_year AS tyea
                   FROM (((((public."Students"
                     JOIN public."Person" USING (amka))
                     JOIN public."Register" ON (("Students".amka = "Register".student_amka)))
                     JOIN public."CourseRun" ON (("Register".course_run_id = "CourseRun".serial_number)))
                     JOIN public."Course" ON (("CourseRun".implements_course = "Course".course_code)))
                     JOIN public."Semester" ON (("CourseRun".ruinsin_semester = "Semester".semester_id)))
                  WHERE ((NOT "Course".obligatory) AND ("Register".register_status = 'pass'::public.register_status) AND ("Course".typical_year = (("Semester".start_date - "Students".entry_date) / 365)))
                  GROUP BY "Students".am, "Register".register_status, "Course".typical_year) notobl USING (am))) compls
     JOIN ( SELECT "Students".am,
            "Person".surname,
            "Person".fname
           FROM (public."Students"
             JOIN public."Person" USING (amka))) pers ON ((pers.am = compls.am_)));


ALTER TABLE public.tessera_duo OWNER TO postgres;

--
-- Name: vie_data; Type: VIEW; Schema: public; Owner: postgres
--

CREATE VIEW public.vie_data AS
 SELECT "Course".course_code AS code,
    "Course".course_title AS title,
    concat(p1.fname, '', p1.surname, '', p2.fname, '', p2.surname) AS pr
   FROM (((((((public."Course"
     JOIN public."CourseRun" ON (("Course".course_code = "CourseRun".implements_course)))
     JOIN public."Semester" ON (("CourseRun".ruinsin_semester = "Semester".semester_id)))
     JOIN public."Teaches" ON (("CourseRun".serial_number = "Teaches".courserun_serial_number)))
     JOIN public."Professors" pr1 ON (("Teaches".teaches_professor1 = pr1.amka)))
     JOIN public."Professors" pr2 ON (("Teaches".teaches_professor2 = pr2.amka)))
     JOIN public."Person" p1 ON ((pr1.amka = p1.amka)))
     JOIN public."Person" p2 ON ((pr2.amka = p2.amka)))
  WHERE ("Semester".semester_status = 'present'::public.semester_status)
UNION
 SELECT "Course".course_code AS code,
    "Course".course_title AS title,
    concat("Person".fname, '', "Person".surname, '', '', '', '') AS pr
   FROM (((((public."Course"
     JOIN public."CourseRun" ON (("Course".course_code = "CourseRun".implements_course)))
     JOIN public."Semester" ON (("CourseRun".ruinsin_semester = "Semester".semester_id)))
     JOIN public."Teaches" ON (("CourseRun".serial_number = "Teaches".courserun_serial_number)))
     JOIN public."Professors" ON (("Teaches".teaches_professor1 = "Professors".amka)))
     JOIN public."Person" ON (("Professors".amka = "Person".amka)))
  WHERE (("Semester".semester_status = 'present'::public.semester_status) AND ("Teaches".teaches_professor2 IS NULL));


ALTER TABLE public.vie_data OWNER TO postgres;

--
-- Name: CourseRun serial_number; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public."CourseRun" ALTER COLUMN serial_number SET DEFAULT nextval('public."CourseRun_serial_number_seq"'::regclass);


--
-- Name: Diplomas diploma_num; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public."Diplomas" ALTER COLUMN diploma_num SET DEFAULT nextval('public."Diplomas_diploma_num_seq"'::regclass);


--
-- Name: Semester semester_id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public."Semester" ALTER COLUMN semester_id SET DEFAULT nextval('public."Semester_semester_id_seq"'::regclass);


--
-- Data for Name: Committee; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public."Committee" (supervisor, professor2, professor3, diploma_num) FROM stdin;
6987140272	7594565848	3415024983	1
4489572669	8109804948	4129539301	2
4139655001	1889286193	1457362138	3
6987140272	7594565848	3415024983	4
4489572669	8109804948	4129539301	5
4139655001	1889286193	1457362138	6
6987140272	7594565848	3415024983	7
\.


--
-- Data for Name: Course; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public."Course" (course_code, course_title, units, ects, weight, lecture_hours, tutorial_hours, lab_hours, typical_year, typical_season, obligatory) FROM stdin;
ΗΡΥ 101	Λογική Σχεδίαση                                                                                     	4	6	1.5	4	1	2	1	winter	t
ΜΑΘ 101	Μαθηματικά Ι                                                                                        	4	6	1.5	3	1	0	1	winter	t
ΜΑΘ 201	Γραμμική Άλγεβρα                                                                                    	4	6	1.5	3	1	0	1	winter	t
ΜΑΘ 208	Διακριτά Μαθηματικά                                                                                 	3	5	1.5	3	0	0	1	winter	f
ΠΛΗ 101	Εισαγωγή στους Ηλεκτρονικούς Υπολογιστές και την Πληροφορική                                        	4	6	1.5	3	2	1	1	winter	t
ΦΥΣ 101	Φυσική (Μηχανική – Στοιχεία Θερμότητας)                                                             	4	5	1.5	2	1	2	1	winter	f
ΧΗΜ 101	Γενική Χημεία                                                                                       	3	5	1.5	3	0	0	1	winter	f
ΑΓΓ 102	Αγγλικά ΙΙ                                                                                          	2	3	1	4	0	0	1	spring	t
ΗΡΥ 102	Βασική Θεωρία Κυκλωμάτων                                                                            	4	6	1.5	2	2	2	1	spring	t
ΜΑΘ 102	Μαθηματικά ΙΙ                                                                                       	4	6	1.5	3	1	0	1	spring	t
ΜΑΘ 202	Αριθμητική Ανάλυση                                                                                  	4	5	1.5	3	1	0	1	spring	f
ΠΛΗ 102	Δομημένος Προγραμματισμός                                                                           	4	6	1.5	3	2	1	1	spring	t
ΠΛΗ 111	Συμβολικές και Διακριτές Δομές                                                                      	4	5	1.5	3	1	0	1	spring	f
ΦΥΣ 102	Φυσική (Ηλεκτρομαγνητισμός)                                                                         	4	6	1.5	2	1	2	1	spring	t
ΑΓΓ 201	Αγγλικά ΙΙΙ                                                                                         	2	4	1	4	0	0	2	winter	t
ΗΡΥ 201	Ψηφιακοί Υπολογιστές                                                                                	4	6	1.5	2	2	2	2	winter	t
ΗΡΥ 202	Ανάλυση Ηλεκτρικών Κυκλωμάτων                                                                       	4	6	1.5	2	2	2	2	winter	t
ΜΑΘ 107	Θεωρία Πιθανοτήτων – Στατιστική                                                                     	3	6	1.5	2	1	0	2	winter	t
ΠΛΗ 201	Σχεδίαση και Ανάπτυξη Πληροφοριακών Συστημάτων                                                      	4	6	1.5	3	1	2	2	winter	t
ΠΛΗ 211	Εργαλεία Ανάπτυξης Λογισμικού και Προγραμματισμός Συστημάτων                                        	4	5	1.5	3	1	2	2	winter	f
ΤΗΛ 201	Σήματα και Συστήματα                                                                                	4	6	1.5	3	2	1	2	winter	t
ΑΓΓ 202	Αγγλικά ΙV                                                                                          	2	4	1	4	0	0	2	spring	t
ΗΡΥ 203	Προχωρημένη Λογική Σχεδίαση                                                                         	4	6	1.5	3	2	2	2	spring	t
ΗΡΥ 204	Ηλεκτρονική Ι                                                                                       	4	6	1.5	3	2	2	2	spring	t
ΗΡΥ 211	Ηλεκτρονικά – Ηλεκτροτεχνικά Υλικά                                                                  	4	5	1.5	3	2	0	2	spring	f
ΠΛΗ 202	Δομές Δεδομένων και Αρχείων                                                                         	4	6	1.5	3	2	1	2	spring	t
ΤΗΛ 202	Πιθανότητες και Τυχαία Σήματα                                                                       	4	6	1.5	3	2	1	2	spring	t
ΤΗΛ 211	Διάδοση Ηλεκτρομαγνητικών Κυμάτων και Στοιχεία Κεραιών                                              	4	5	1.5	3	1	2	2	spring	f
ΗΡΥ 301	Ηλεκτρονική ΙΙ                                                                                      	4	6	1.5	3	2	2	3	winter	t
ΚΕΠ 101	Κοινωνιολογία                                                                                       	3	5	1.5	3	0	0	3	winter	f
ΚΕΠ 203	Φιλοσοφία και Ιστορία Επιστημών                                                                     	3	5	1.5	3	0	0	3	winter	f
ΚΕΠ 301	Τέχνη και Τεχνολογία                                                                                	3	5	1.5	3	0	0	3	winter	f
ΜΠΔ 501	Προσομοίωση                                                                                         	4	5	1.5	4	0	2	3	winter	f
ΠΛΗ 301	Λειτουργικά Συστήματα                                                                               	4	6	1.5	3	1	2	3	winter	t
ΤΗΛ 301	Τηλεπικοινωνιακά Συστήματα Ι                                                                        	4	6	1.5	3	2	1	3	winter	t
ΤΗΛ 311	Στατιστική Μοντελοποίηση και Αναγνώριση Προτύπων                                                    	4	5	1.5	3	2	1	3	winter	f
ΕΝΕ 301	Εισαγωγή στα Συστήματα Ηλεκτρικής Ενέργειας                                                         	4	6	1.5	3	1	2	3	spring	t
ΗΡΥ 302	Οργάνωση Υπολογιστών                                                                                	4	6	1.5	3	2	2	3	spring	t
ΚΕΠ 102	Πολιτική Οικονομία                                                                                  	3	5	1.5	3	0	0	3	spring	f
ΚΕΠ 104	Εισαγωγή στη Φιλοσοφία                                                                              	3	5	1.5	3	0	0	3	spring	f
ΚΕΠ 202	Ιστορία του Πολιτισμού                                                                              	3	5	1.5	3	0	0	3	spring	f
ΜΑΘ 203	Διαφορικές Εξισώσεις                                                                                	3	5	1.5	2	1	0	3	spring	f
ΜΑΘ 302	Εφαρμοσμένα Μαθηματικά                                                                              	3	5	1.5	3	0	0	3	spring	f
ΤΗΛ 303	Τηλεπικοινωνιακά Συστήματα ΙΙ                                                                       	4	6	1.5	3	1	2	3	spring	t
ΤΗΛ 312	Ψηφιακή Επεξεργασία Εικόνας                                                                         	4	5	1.5	3	1	3	3	spring	f
ΤΗΛ 313	Επεξεργασία Ήχου και Μουσικής                                                                       	4	5	1.5	3	1	2	3	spring	f
ΕΚΠ 412	Επικοινωνία Ανθρώπων – Υπολογιστών                                                                  	4	5	1.5	3	1	2	4	winter	f
ΕΚΠ 413	Μέθοδοι Διαχείρισης Πολυμέσων                                                                       	4	5	1.5	3	1	2	4	winter	f
ΕΚΠ 414	Μηχανική Όραση                                                                                      	4	5	1.5	3	1	2	4	winter	f
ΕΝΕ 401	Παραγωγή και Διανομή Ηλεκτρικής Ενέργειας                                                           	4	6	1.5	3	1	2	4	winter	t
ΗΡΥ 411	Ενσωματωμένα Συστήματα Μικροεπεξεργαστών                                                            	4	5	1.5	3	2	2	4	winter	f
ΗΡΥ 412	Οπτοηλεκτρονική                                                                                     	4	5	1.5	3	0	3	4	winter	f
ΚΕΠ 201	Μικρο- και Μακρο- Οικονομική Ανάλυση                                                                	3	5	1.5	3	0	0	4	winter	f
ΚΕΠ 204	Στοιχεία Δικαίου και Τεχνικής Νομοθεσίας                                                            	4	5	1.5	3	0	0	4	winter	f
ΠΛΗ 401	Αλγόριθμοι και Πολυπλοκότητα                                                                        	4	6	1.5	3	3	0	4	winter	t
ΠΛΗ 411	Αρχές Γλωσσών Προγραμματισμού                                                                       	4	5	1.5	3	1	2	4	winter	f
ΣΥΣ 401	Γραμμικά Συστήματα                                                                                  	4	6	1.5	3	2	3	4	winter	t
ΣΥΣ 411	Τεχνολογία και Εφαρμογές Ασαφούς Λογικής                                                            	4	5	1.5	3	1	3	4	winter	f
ΤΗΛ 401	Δίκτυα Υπολογιστών Ι                                                                                	4	6	1.5	3	1	2	4	winter	t
ΤΗΛ 411	Εισαγωγή στην Επεξεργασία Φωνής                                                                     	4	5	1.5	3	1	2	4	winter	f
ΤΗΛ 412	Ανάλυση και Σχεδίαση (Σύνθεση) Τηλεπικοινωνιακών Διατάξεων                                          	4	5	1.5	3	1	3	4	winter	f
ΤΗΛ 413	Κυρτή Βελτιστοποίηση                                                                                	4	5	1.5	3	2	0	4	winter	f
ΤΗΛ 417	Ασύρματες Επικοινωνίες                                                                              	4	5	1.5	3	2	0	4	winter	f
HPY 416	Σχεδίαση Αναλογικών Κυκλωμάτων CMOS                                                                 	4	5	1.5	3	2	2	4	spring	f
ΕΚΠ 419	Ανάπτυξη Εφαρμογών Πληροφοριακών Συστημάτων στο Διαδίκτυο                                           	4	5	1.5	3	1	2	4	spring	f
ΕΝΕ 411	Ηλεκτρολογικό Σχέδιο και Ηλεκτρικές Εγκαταστάσεις                                                   	4	5	1.5	3	1	2	4	spring	f
ΕΝΕ 412	Ανάλυση Συστημάτων Ηλεκτρικής Ενέργειας                                                             	4	5	1.5	3	1	2	4	spring	f
ΗΡΥ 414	Ηλεκτρικές Μετρήσεις και Αισθητήρες                                                                 	4	5	1.5	3	1	2	4	spring	f
ΗΡΥ 415	Αρχιτεκτονική Ηλεκτρονικών Υπολογιστών                                                              	4	5	1.5	3	2	2	4	spring	f
ΗΡΥ 417	Υλοποίηση Μικροηλεκτρονικών Συστημάτων                                                              	4	5	1.5	3	1	2	4	spring	f
ΗΡΥ 418	Αρχιτεκτονική Παράλληλων και Κατανεμημένων Υπολογιστών                                              	4	5	1.5	3	1	2	4	spring	f
ΗΡΥ 419	Ηλεκτρονικά Ισχύος                                                                                  	4	5	1.5	3	1	2	4	spring	f
ΚΕΠ 302	Βιομηχανική Κοινωνιολογία                                                                           	3	5	1.5	3	0	0	4	spring	f
ΜΑΘ 411	Μαθηματική Βιολογία                                                                                 	4	5	1.5	3	1	2	4	spring	f
ΜΠΔ 425	Δυναμικός Προγραμματισμός                                                                           	3	5	1.5	2	1	2	4	spring	f
ΜΠΔ 433	Μικρομεσαίες Επιχειρήσεις και Καινοτομία                                                            	3	5	1.5	2	0	2	4	spring	f
ΠΛΗ 402	Θεωρία Υπολογισμού                                                                                  	4	6	1.5	3	2	1	4	spring	t
ΠΛΗ 415	Προχωρημένα Θέματα Βάσεων Δεδομένων                                                                 	4	5	1.5	3	1	2	4	spring	f
ΠΛΗ 416	Υπολογιστική Γεωμετρία                                                                              	4	5	1.5	3	1	2	4	spring	f
ΠΛΗ 417	Τεχνητή Νοημοσύνη                                                                                   	4	5	1.5	3	1	2	4	spring	f
ΠΛΗ 418	Γραφική                                                                                             	4	5	1.5	3	2	1	4	spring	f
ΠΛΗ 420	Αρχές Κατανεμημένων Συστημάτων Λογισμικού                                                           	4	5	1.5	3	1	2	4	spring	f
ΠΛΗ 421	Τυχαιοποιημένοι Αλγόριθμοι                                                                          	4	5	1.5	3	1	2	4	spring	f
ΠΛΗ 422	Διδακτική της Πληροφορικής                                                                          	4	5	1.5	3	1	2	4	spring	f
ΠΛΗ 423	Μεταγλωττιστές                                                                                      	4	5	1.5	3	1	2	4	spring	f
ΣΥΣ 402	Θεωρία και Εφαρμογές Αυτομάτου Ελέγχου                                                              	4	6	1.5	3	2	3	4	spring	t
ΣΥΣ 412	Σύγχρονα Θέματα Αυτομάτου Ελέγχου                                                                   	4	5	1.5	3	1	2	4	spring	f
ΣΥΣ 413	Βιομηχανικά Συστήματα Αυτομάτου Ελέγχου                                                             	4	5	1.5	3	1	2	4	spring	f
ΣΥΣ 414	Νευρωνικά Δίκτυα και Εφαρμογές                                                                      	4	5	1.5	3	1	2	4	spring	f
ΤΗΛ 415	Στατιστική Επεξεργασία Σήματος για Τηλεπικοινωνίες                                                  	4	5	1.5	3	1	2	4	spring	f
ΤΗΛ 416	Θεωρία Πληροφορίας και Κωδικοποίηση                                                                 	4	5	1.5	3	2	1	4	spring	f
ΤΗΛ 418	Δίκτυα Υπολογιστών ΙΙ                                                                               	4	5	1.5	3	1	2	4	spring	f
ΤΗΛ 419	Συστήματα Επεξεργασίας Φυσικής Γλώσσας                                                              	4	5	1.5	3	1	2	4	spring	f
ΤΗΛ 420	Ευρυζωνικά Δίκτυα Επικοινωνιών                                                                      	4	5	1.5	3	3	0	4	spring	f
ΕΚΠ 512	Ανάπτυξη Υπηρεσιών Διαδικτύου και Αρχιτεκτονική Επιχειρήσεων                                        	4	5	1.5	3	1	2	5	winter	f
ΕΚΠ 514	Η Οικονομία της Κοινωνίας της Πληροφορίας                                                           	4	5	1.5	3	1	2	5	winter	f
ΕΝΕ 511	Ανανεώσιμες Πηγές Ενέργειας                                                                         	4	5	1.5	2	2	2	5	winter	f
ΕΝΕ 512	Προχωρημένα Θέματα Συστημάτων Ηλεκτρικής Ενέργειας                                                  	4	5	1.5	3	1	2	5	winter	f
ΗΡΥ 511	Σχεδιασμός Συστημάτων VLSI και ASIC                                                                 	4	5	1.5	3	2	2	5	winter	f
ΗΡΥ 512	Δοκιμή Ηλεκτρονικών Συστημάτων                                                                      	4	5	1.5	3	2	2	5	winter	f
ΗΡΥ 513	Βιοϊατρική Τεχνολογία                                                                               	4	5	1.5	3	0	3	5	winter	f
ΗΡΥ 514	Σχεδίαση και Προγραμματισμός Εξειδικευμένων Αρχιτεκτονικών Υπολογιστών                              	4	5	1.5	4	0	2	5	winter	f
ΠΛΗ 511	Μηχανική Ανάπτυξης Συστημάτων Λογισμικού                                                            	4	5	1.5	3	1	2	5	winter	f
ΠΛΗ 513	Αυτόνομοι Πράκτορες                                                                                 	4	5	1.5	3	1	2	5	winter	f
ΠΛΗ 516	Επεξεργασία και Διαχείριση Δεδομένων σε Δίκτυα Αισθητήρων                                           	4	5	1.5	3	1	2	5	winter	f
ΠΛΗ 517	Πολυπρακτορικά Συστήματα                                                                            	4	5	1.5	3	2	1	5	winter	f
ΣΥΣ 511	Βέλτιστος Έλεγχος                                                                                   	4	5	1.5	3	1	3	5	winter	f
ΣΥΣ 512	Ρομποτική                                                                                           	4	5	1.5	3	0	3	5	winter	f
ΣΥΣ 513	Σχεδίαση Συστημάτων Αυτομάτου Ελέγχου                                                               	4	5	1.5	3	1	2	5	winter	f
ΣΥΣ 514	Εφαρμογές Νευρωνικών Δικτύων και Ασαφούς Λογικής σε Συστήματα Αυτοματισμών                          	4	5	1.5	3	1	2	5	winter	f
ΤΗΛ 414	Μοντελοποίηση και Ανάλυση Απόδοσης Δικτύων Επικοινωνιών                                             	4	5	1.5	3	1	2	5	winter	f
ΤΗΛ 511	Ασύρματα Τηλεπικοινωνιακά Συστήματα και Δίκτυα                                                      	4	5	1.5	3	1	2	5	winter	f
ΠΛΗ 302	Βάσεις Δεδομένων                                                                                    	4	6	1.5	3	2	1	3	spring	t
ΤΗΛ 302	Ψηφιακή Επεξεργασία Σήματος                                                                         	4	6	1.5	3	1	3	3	winter	t
ΑΓΓ 101	Αγγλικά Ι                                                                                           	2	3	1	4	0	0	1	winter	t
\.


--
-- Data for Name: CourseRun; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public."CourseRun" (serial_number, exam_percentage, lab_min, exam_min, ruinsin_semester, uses_lab, implements_course) FROM stdin;
169	66	1	4	5	3	ΑΓΓ 102
170	5	9	9	5	5	ΗΡΥ 102
171	1	1	7	5	9	ΜΑΘ 102
172	79	10	0	5	7	ΜΑΘ 202
173	23	0	10	5	5	ΠΛΗ 102
174	61	6	9	5	2	ΠΛΗ 111
175	57	10	8	5	2	ΦΥΣ 102
176	14	7	1	5	6	ΑΓΓ 202
177	96	2	1	5	3	ΗΡΥ 203
178	61	5	6	5	3	ΗΡΥ 204
179	67	9	5	5	8	ΗΡΥ 211
180	53	8	1	5	8	ΠΛΗ 202
181	67	6	2	5	7	ΤΗΛ 202
182	64	6	2	5	6	ΤΗΛ 211
183	66	6	10	5	2	ΕΝΕ 301
184	25	5	2	5	10	ΗΡΥ 302
185	24	2	8	5	6	ΚΕΠ 102
186	91	3	4	5	10	ΚΕΠ 104
187	7	4	5	5	9	ΚΕΠ 202
188	58	10	5	5	4	ΜΑΘ 203
189	53	5	1	5	1	ΜΑΘ 302
190	34	6	8	5	8	ΤΗΛ 303
191	90	8	3	5	6	ΤΗΛ 312
192	48	0	10	5	4	ΤΗΛ 313
193	4	0	6	5	6	HPY 416
194	51	2	3	5	1	ΕΚΠ 419
195	74	1	5	5	5	ΕΝΕ 411
196	5	5	8	5	9	ΕΝΕ 412
197	43	0	7	5	1	ΗΡΥ 414
198	40	5	8	5	4	ΗΡΥ 415
199	86	6	3	5	5	ΗΡΥ 417
200	47	4	9	5	4	ΗΡΥ 418
201	27	8	2	5	8	ΗΡΥ 419
202	28	7	1	5	3	ΚΕΠ 302
203	29	4	6	5	10	ΜΑΘ 411
204	52	7	6	5	3	ΜΠΔ 425
205	59	2	1	5	4	ΜΠΔ 433
206	6	10	9	5	2	ΠΛΗ 402
207	8	7	9	5	8	ΠΛΗ 415
208	62	4	4	5	7	ΠΛΗ 416
209	26	8	8	5	3	ΠΛΗ 417
210	70	6	6	5	5	ΠΛΗ 418
211	46	9	1	5	5	ΠΛΗ 420
212	21	10	4	5	10	ΠΛΗ 421
213	58	6	6	5	1	ΠΛΗ 422
214	23	2	9	5	5	ΠΛΗ 423
215	44	3	5	5	10	ΣΥΣ 402
216	41	2	0	5	7	ΣΥΣ 412
217	8	2	1	5	5	ΣΥΣ 413
218	52	5	2	5	9	ΣΥΣ 414
219	29	3	8	5	10	ΤΗΛ 415
220	94	9	1	5	5	ΤΗΛ 416
221	80	0	8	5	7	ΤΗΛ 418
222	78	4	2	5	6	ΤΗΛ 419
223	34	0	4	5	8	ΤΗΛ 420
224	53	10	0	5	3	ΠΛΗ 302
225	3	2	6	6	8	ΗΡΥ 101
226	42	6	7	6	6	ΜΑΘ 101
227	68	3	10	6	5	ΜΑΘ 201
228	4	6	9	6	4	ΜΑΘ 208
229	66	3	0	6	8	ΠΛΗ 101
230	4	8	3	6	8	ΦΥΣ 101
231	50	8	3	6	4	ΧΗΜ 101
232	95	4	2	6	2	ΑΓΓ 201
233	39	4	1	6	9	ΗΡΥ 201
234	22	10	8	6	7	ΗΡΥ 202
235	44	6	10	6	4	ΜΑΘ 107
236	2	3	10	6	2	ΠΛΗ 201
237	37	2	4	6	7	ΠΛΗ 211
238	93	2	1	6	4	ΤΗΛ 201
239	24	2	1	6	1	ΗΡΥ 301
240	4	5	8	6	7	ΚΕΠ 101
241	86	8	8	6	1	ΚΕΠ 203
242	30	0	3	6	9	ΚΕΠ 301
243	72	2	3	6	9	ΜΠΔ 501
244	72	9	7	6	7	ΠΛΗ 301
245	32	9	9	6	2	ΤΗΛ 301
246	59	9	3	6	8	ΤΗΛ 311
247	82	3	4	6	7	ΕΚΠ 412
248	99	4	7	6	8	ΕΚΠ 413
249	19	5	7	6	5	ΕΚΠ 414
250	69	3	9	6	3	ΕΝΕ 401
251	46	2	9	6	9	ΗΡΥ 411
252	47	5	8	6	5	ΗΡΥ 412
253	63	8	1	6	4	ΚΕΠ 201
254	57	5	8	6	2	ΚΕΠ 204
255	48	3	5	6	9	ΠΛΗ 401
256	37	7	8	6	1	ΠΛΗ 411
257	68	0	4	6	7	ΣΥΣ 401
258	7	8	3	6	4	ΣΥΣ 411
259	60	4	2	6	4	ΤΗΛ 401
260	92	3	4	6	5	ΤΗΛ 411
261	8	2	1	6	3	ΤΗΛ 412
262	58	0	6	6	8	ΤΗΛ 413
263	36	1	1	6	6	ΤΗΛ 417
264	81	9	7	6	2	ΕΚΠ 512
265	15	4	3	6	5	ΕΚΠ 514
266	83	3	7	6	9	ΕΝΕ 511
267	85	7	1	6	2	ΕΝΕ 512
268	61	10	8	6	2	ΗΡΥ 511
269	2	2	9	6	3	ΗΡΥ 512
270	32	6	5	6	3	ΗΡΥ 513
271	54	8	4	6	9	ΗΡΥ 514
272	56	4	5	6	3	ΠΛΗ 511
273	67	4	0	6	1	ΠΛΗ 513
274	58	1	4	6	8	ΠΛΗ 516
275	2	3	2	6	9	ΠΛΗ 517
276	31	1	4	6	2	ΣΥΣ 511
277	3	2	2	6	6	ΣΥΣ 512
278	1	10	0	6	6	ΣΥΣ 513
279	22	8	7	6	9	ΣΥΣ 514
280	87	3	7	6	2	ΤΗΛ 414
281	64	7	10	6	8	ΤΗΛ 511
282	100	1	5	6	8	ΤΗΛ 302
283	40	2	1	6	6	ΑΓΓ 101
284	1	1	7	7	9	ΜΑΘ 102
285	57	10	8	7	2	ΦΥΣ 102
286	67	9	5	7	8	ΗΡΥ 211
287	66	6	10	7	2	ΕΝΕ 301
288	7	4	5	7	9	ΚΕΠ 202
289	90	8	3	7	6	ΤΗΛ 312
290	74	1	5	7	5	ΕΝΕ 411
291	86	6	3	7	5	ΗΡΥ 417
292	29	4	6	7	10	ΜΑΘ 411
293	8	7	9	7	8	ΠΛΗ 415
294	46	9	1	7	5	ΠΛΗ 420
295	44	3	5	7	10	ΣΥΣ 402
296	29	3	8	7	10	ΤΗΛ 415
297	34	0	4	7	8	ΤΗΛ 420
298	23	0	10	7	5	ΠΛΗ 102
299	67	6	2	7	7	ΤΗΛ 202
300	53	5	1	7	1	ΜΑΘ 302
301	43	0	7	7	1	ΗΡΥ 414
302	59	2	1	7	4	ΜΠΔ 433
303	58	6	6	7	1	ΠΛΗ 422
304	80	0	8	7	7	ΤΗΛ 418
305	96	2	1	7	3	ΗΡΥ 203
306	4	0	6	7	6	HPY 416
307	26	8	8	7	3	ΠΛΗ 417
308	66	1	4	7	3	ΑΓΓ 102
309	27	8	2	7	8	ΗΡΥ 419
310	24	2	8	7	6	ΚΕΠ 102
311	8	2	1	7	5	ΣΥΣ 413
312	36	9	1	7	1	ΗΡΥ 102
313	70	5	1	7	6	ΜΑΘ 202
314	87	9	5	7	4	ΠΛΗ 111
315	93	5	2	7	8	ΑΓΓ 202
316	7	4	7	7	3	ΗΡΥ 204
317	24	6	8	7	10	ΠΛΗ 202
318	25	8	6	7	7	ΤΗΛ 211
319	38	7	4	7	1	ΗΡΥ 302
320	30	3	0	7	3	ΚΕΠ 104
321	11	1	1	7	7	ΜΑΘ 203
322	100	2	6	7	9	ΤΗΛ 303
323	52	3	10	7	5	ΤΗΛ 313
324	46	7	7	7	1	ΕΚΠ 419
325	94	10	5	7	3	ΕΝΕ 412
326	29	6	5	7	4	ΗΡΥ 415
327	88	4	5	7	2	ΗΡΥ 418
328	70	1	8	7	10	ΚΕΠ 302
329	44	5	0	7	7	ΜΠΔ 425
330	77	6	4	7	2	ΠΛΗ 402
331	87	7	7	7	7	ΠΛΗ 416
332	4	3	8	7	6	ΠΛΗ 418
333	30	2	8	7	8	ΠΛΗ 421
334	5	9	3	7	7	ΠΛΗ 423
335	3	4	8	7	9	ΣΥΣ 412
336	68	9	7	7	9	ΣΥΣ 414
337	12	4	0	7	6	ΤΗΛ 416
338	21	1	9	7	2	ΤΗΛ 419
339	73	2	6	7	2	ΠΛΗ 302
340	3	2	6	8	8	ΗΡΥ 101
341	66	3	0	8	8	ΠΛΗ 101
342	39	4	1	8	9	ΗΡΥ 201
343	37	2	4	8	7	ΠΛΗ 211
344	86	8	8	8	1	ΚΕΠ 203
345	32	9	9	8	2	ΤΗΛ 301
346	19	5	7	8	5	ΕΚΠ 414
347	63	8	1	8	4	ΚΕΠ 201
348	68	0	4	8	7	ΣΥΣ 401
349	8	2	1	8	3	ΤΗΛ 412
350	15	4	3	8	5	ΕΚΠ 514
351	2	2	9	8	3	ΗΡΥ 512
352	67	4	0	8	1	ΠΛΗ 513
353	3	2	2	8	6	ΣΥΣ 512
354	64	7	10	8	8	ΤΗΛ 511
355	68	3	10	8	5	ΜΑΘ 201
356	44	6	10	8	4	ΜΑΘ 107
357	72	2	3	8	9	ΜΠΔ 501
358	46	2	9	8	9	ΗΡΥ 411
359	60	4	2	8	4	ΤΗΛ 401
360	85	7	1	8	2	ΕΝΕ 512
361	2	3	2	8	9	ΠΛΗ 517
362	40	2	1	8	6	ΑΓΓ 101
363	24	2	1	8	1	ΗΡΥ 301
364	48	3	5	8	9	ΠΛΗ 401
365	54	8	4	8	9	ΗΡΥ 514
366	50	8	3	8	4	ΧΗΜ 101
367	36	1	1	8	6	ΤΗΛ 417
368	82	3	4	8	7	ΕΚΠ 412
369	22	8	7	8	9	ΣΥΣ 514
370	83	2	2	8	2	ΜΑΘ 101
371	13	8	2	8	1	ΜΑΘ 208
372	9	0	0	8	3	ΦΥΣ 101
373	30	1	7	8	7	ΑΓΓ 201
374	73	9	4	8	1	ΗΡΥ 202
375	3	1	4	8	4	ΠΛΗ 201
376	73	0	5	8	4	ΤΗΛ 201
377	29	7	6	8	6	ΚΕΠ 101
378	23	4	4	8	6	ΚΕΠ 301
379	31	0	3	8	5	ΠΛΗ 301
380	54	2	4	8	5	ΤΗΛ 311
381	32	4	2	8	3	ΕΚΠ 413
382	33	5	3	8	1	ΕΝΕ 401
383	39	2	4	8	7	ΗΡΥ 412
384	29	6	7	8	3	ΚΕΠ 204
385	35	0	4	8	8	ΠΛΗ 411
386	37	5	5	8	4	ΣΥΣ 411
387	7	1	2	8	10	ΤΗΛ 411
388	47	5	5	8	2	ΤΗΛ 413
389	48	7	7	8	3	ΕΚΠ 512
390	68	1	0	8	2	ΕΝΕ 511
391	12	3	6	8	6	ΗΡΥ 511
392	59	6	9	8	5	ΗΡΥ 513
393	77	0	2	8	8	ΠΛΗ 511
394	37	7	6	8	5	ΠΛΗ 516
395	40	2	9	8	1	ΣΥΣ 511
396	92	6	2	8	6	ΣΥΣ 513
397	3	8	6	8	5	ΤΗΛ 414
398	51	3	7	8	8	ΤΗΛ 302
543	66	3	0	10	8	ΠΛΗ 101
544	39	4	1	10	9	ΗΡΥ 201
545	37	2	4	10	7	ΠΛΗ 211
546	63	8	1	10	4	ΚΕΠ 201
547	68	0	4	10	7	ΣΥΣ 401
548	8	2	1	10	3	ΤΗΛ 412
549	15	4	3	10	5	ΕΚΠ 514
550	2	2	9	10	3	ΗΡΥ 512
551	3	2	2	10	6	ΣΥΣ 512
552	2	2	9	10	5	ΤΗΛ 511
553	68	3	10	10	5	ΜΑΘ 201
554	44	6	10	10	4	ΜΑΘ 107
555	72	2	3	10	9	ΜΠΔ 501
556	60	4	2	10	4	ΤΗΛ 401
557	2	3	2	10	9	ΠΛΗ 517
558	40	2	1	10	6	ΑΓΓ 101
559	24	2	1	10	1	ΗΡΥ 301
560	54	8	4	10	9	ΗΡΥ 514
561	50	8	3	10	4	ΧΗΜ 101
562	82	3	4	10	7	ΕΚΠ 412
563	1	10	0	10	3	ΗΡΥ 101
564	70	5	1	10	9	ΚΕΠ 203
565	44	3	5	10	8	ΤΗΛ 301
566	24	6	8	10	6	ΕΚΠ 414
567	2	3	2	10	9	ΠΛΗ 513
568	64	7	10	10	10	ΗΡΥ 411
569	27	8	2	10	7	ΕΝΕ 512
570	87	9	5	10	7	ΠΛΗ 401
571	58	6	6	10	5	ΤΗΛ 417
572	67	4	0	10	7	ΣΥΣ 514
573	88	0	9	10	3	ΜΑΘ 101
574	51	2	9	10	8	ΜΑΘ 208
575	82	6	10	10	4	ΦΥΣ 101
576	25	2	6	10	5	ΑΓΓ 201
577	26	4	1	10	7	ΗΡΥ 202
578	4	6	8	10	3	ΠΛΗ 201
579	19	6	1	10	3	ΤΗΛ 201
399	61	10	8	9	8	ΣΥΣ 413
400	2	2	9	9	5	ΤΗΛ 511
401	32	6	5	9	1	ΠΛΗ 111
402	54	8	4	9	6	ΤΗΛ 313
580	73	7	2	10	6	ΚΕΠ 101
581	20	4	7	10	6	ΚΕΠ 301
582	69	10	7	10	2	ΠΛΗ 301
583	70	8	4	10	6	ΤΗΛ 311
584	94	8	3	10	9	ΕΚΠ 413
585	51	7	8	10	8	ΕΝΕ 401
586	69	3	6	10	7	ΗΡΥ 412
587	9	3	9	10	5	ΚΕΠ 204
588	71	1	1	10	7	ΠΛΗ 411
589	28	2	2	10	3	ΣΥΣ 411
590	95	4	4	10	5	ΤΗΛ 411
591	36	1	1	10	6	ΤΗΛ 413
592	33	8	3	10	8	ΕΚΠ 512
593	17	2	10	10	5	ΕΝΕ 511
594	93	5	7	10	8	ΗΡΥ 511
595	65	3	6	10	8	ΗΡΥ 513
596	94	9	1	10	2	ΠΛΗ 511
597	29	8	8	10	4	ΠΛΗ 516
598	39	10	9	10	7	ΣΥΣ 511
599	54	2	6	10	2	ΣΥΣ 513
600	94	5	9	10	1	ΤΗΛ 414
601	99	6	9	10	4	ΤΗΛ 302
532	26	8	8	9	\N	ΗΡΥ 203
602	1	10	0	10	3	ΗΡΥ 101
603	66	3	0	10	8	ΠΛΗ 101
604	39	4	1	10	9	ΗΡΥ 201
605	37	2	4	10	7	ΠΛΗ 211
606	70	5	1	10	9	ΚΕΠ 203
607	44	3	5	10	8	ΤΗΛ 301
608	24	6	8	10	6	ΕΚΠ 414
609	63	8	1	10	4	ΚΕΠ 201
610	68	0	4	10	7	ΣΥΣ 401
611	8	2	1	10	3	ΤΗΛ 412
612	15	4	3	10	5	ΕΚΠ 514
613	2	2	9	10	3	ΗΡΥ 512
614	2	3	2	10	9	ΠΛΗ 513
615	3	2	2	10	6	ΣΥΣ 512
616	2	2	9	10	5	ΤΗΛ 511
617	68	3	10	10	5	ΜΑΘ 201
618	44	6	10	10	4	ΜΑΘ 107
619	72	2	3	10	9	ΜΠΔ 501
620	64	7	10	10	10	ΗΡΥ 411
621	60	4	2	10	4	ΤΗΛ 401
622	27	8	2	10	7	ΕΝΕ 512
623	2	3	2	10	9	ΠΛΗ 517
624	40	2	1	10	6	ΑΓΓ 101
625	24	2	1	10	1	ΗΡΥ 301
626	87	9	5	10	7	ΠΛΗ 401
627	54	8	4	10	9	ΗΡΥ 514
628	50	8	3	10	4	ΧΗΜ 101
629	58	6	6	10	5	ΤΗΛ 417
630	82	3	4	10	7	ΕΚΠ 412
631	67	4	0	10	7	ΣΥΣ 514
632	77	4	1	10	9	ΜΑΘ 101
633	10	3	7	10	4	ΜΑΘ 208
634	20	2	2	10	10	ΦΥΣ 101
635	39	2	7	10	9	ΑΓΓ 201
497	56	4	5	9	\N	ΗΡΥ 302
498	67	4	0	9	\N	ΣΥΣ 514
499	58	1	4	9	\N	ΠΛΗ 402
500	2	3	2	9	\N	ΠΛΗ 513
501	31	1	4	9	\N	ΗΡΥ 204
502	3	2	2	9	\N	ΗΡΥ 203
503	1	10	0	9	\N	ΗΡΥ 101
504	22	8	7	9	\N	ΑΓΓ 102
505	87	3	7	9	\N	ΜΑΘ 203
506	64	7	10	9	\N	ΗΡΥ 411
507	100	1	5	9	\N	ΜΠΔ 425
508	40	2	1	9	\N	ΜΑΘ 101
509	1	1	7	9	\N	ΜΑΘ 302
510	57	10	8	9	\N	ΜΑΘ 411
511	67	9	5	9	\N	ΤΗΛ 414
512	66	6	10	9	\N	ΤΗΛ 302
513	7	4	5	9	\N	ΤΗΛ 311
514	90	8	3	9	\N	ΚΕΠ 301
515	74	1	5	9	\N	ΚΕΠ 204
516	86	6	3	9	\N	ΠΛΗ 411
517	29	4	6	9	\N	HPY 416
518	8	7	9	9	\N	ΠΛΗ 102
519	46	9	1	9	\N	ΠΛΗ 418
520	44	3	5	9	\N	ΤΗΛ 301
521	29	3	8	9	\N	ΗΡΥ 418
522	34	0	4	9	\N	ΠΛΗ 415
523	23	0	10	9	\N	ΚΕΠ 102
524	67	6	2	9	\N	ΚΕΠ 202
525	53	5	1	9	\N	ΤΗΛ 415
526	43	0	7	9	\N	ΤΗΛ 419
527	59	2	1	9	\N	ΕΝΕ 301
528	58	6	6	9	\N	ΤΗΛ 417
529	80	0	8	9	\N	ΗΡΥ 102
530	96	2	1	9	\N	ΤΗΛ 416
531	4	0	6	9	\N	ΗΡΥ 415
533	66	1	4	9	\N	ΤΗΛ 411
534	27	8	2	9	\N	ΕΝΕ 512
535	24	2	8	9	\N	ΗΡΥ 419
536	8	2	1	9	\N	ΜΑΘ 102
537	36	9	1	9	\N	ΕΝΕ 411
538	70	5	1	9	\N	ΚΕΠ 203
539	87	9	5	9	\N	ΠΛΗ 401
540	93	5	2	9	\N	ΣΥΣ 414
541	7	4	7	9	\N	ΤΗΛ 413
542	24	6	8	9	\N	ΕΚΠ 414
636	21	9	7	10	3	ΗΡΥ 202
637	29	8	0	10	4	ΠΛΗ 201
638	33	4	7	10	7	ΤΗΛ 201
639	9	7	10	10	1	ΚΕΠ 101
640	12	9	4	10	5	ΚΕΠ 301
641	50	7	3	10	9	ΠΛΗ 301
642	88	8	9	10	9	ΤΗΛ 311
643	15	5	7	10	3	ΕΚΠ 413
644	36	7	8	10	10	ΕΝΕ 401
645	61	4	10	10	3	ΗΡΥ 412
646	52	1	3	10	9	ΚΕΠ 204
647	28	1	6	10	5	ΠΛΗ 411
648	67	8	8	10	2	ΣΥΣ 411
649	36	8	2	10	1	ΤΗΛ 411
650	21	2	3	10	1	ΤΗΛ 413
651	94	5	4	10	5	ΕΚΠ 512
652	78	4	9	10	7	ΕΝΕ 511
653	29	0	8	10	8	ΗΡΥ 511
654	2	8	9	10	3	ΗΡΥ 513
655	46	7	3	10	3	ΠΛΗ 511
656	58	1	9	10	3	ΠΛΗ 516
657	73	6	4	10	6	ΣΥΣ 511
658	54	5	7	10	9	ΣΥΣ 513
659	34	7	4	10	6	ΤΗΛ 414
660	50	10	7	10	3	ΤΗΛ 302
661	1	10	0	12	3	ΗΡΥ 101
662	66	3	0	12	8	ΠΛΗ 101
663	39	4	1	12	9	ΗΡΥ 201
664	37	2	4	12	7	ΠΛΗ 211
665	70	5	1	12	9	ΚΕΠ 203
666	44	3	5	12	8	ΤΗΛ 301
667	24	6	8	12	6	ΕΚΠ 414
668	63	8	1	12	4	ΚΕΠ 201
669	68	0	4	12	7	ΣΥΣ 401
670	8	2	1	12	3	ΤΗΛ 412
671	15	4	3	12	5	ΕΚΠ 514
672	2	2	9	12	3	ΗΡΥ 512
673	2	3	2	12	9	ΠΛΗ 513
674	3	2	2	12	6	ΣΥΣ 512
675	2	2	9	12	5	ΤΗΛ 511
676	68	3	10	12	5	ΜΑΘ 201
677	44	6	10	12	4	ΜΑΘ 107
678	72	2	3	12	9	ΜΠΔ 501
679	64	7	10	12	10	ΗΡΥ 411
680	60	4	2	12	4	ΤΗΛ 401
681	27	8	2	12	7	ΕΝΕ 512
682	2	3	2	12	9	ΠΛΗ 517
683	40	2	1	12	6	ΑΓΓ 101
684	24	2	1	12	1	ΗΡΥ 301
685	87	9	5	12	7	ΠΛΗ 401
686	54	8	4	12	9	ΗΡΥ 514
687	50	8	3	12	4	ΧΗΜ 101
688	58	6	6	12	5	ΤΗΛ 417
689	82	3	4	12	7	ΕΚΠ 412
690	67	4	0	12	7	ΣΥΣ 514
691	50	6	6	12	9	ΜΑΘ 101
692	74	7	9	12	3	ΜΑΘ 208
693	63	9	4	12	7	ΦΥΣ 101
694	52	10	1	12	4	ΑΓΓ 201
695	63	9	7	12	7	ΗΡΥ 202
696	24	8	2	12	5	ΠΛΗ 201
697	41	8	5	12	5	ΤΗΛ 201
698	28	3	3	12	9	ΚΕΠ 101
699	73	1	10	12	1	ΚΕΠ 301
700	29	1	4	12	2	ΠΛΗ 301
701	84	6	4	12	7	ΤΗΛ 311
702	57	6	9	12	4	ΕΚΠ 413
703	47	10	7	12	8	ΕΝΕ 401
704	44	1	3	12	9	ΗΡΥ 412
705	34	7	8	12	9	ΚΕΠ 204
706	16	10	5	12	5	ΠΛΗ 411
707	100	5	7	12	7	ΣΥΣ 411
708	30	8	1	12	4	ΤΗΛ 411
709	41	8	4	12	9	ΤΗΛ 413
710	47	2	1	12	7	ΕΚΠ 512
711	8	7	4	12	4	ΕΝΕ 511
712	63	6	2	12	4	ΗΡΥ 511
713	62	3	8	12	9	ΗΡΥ 513
714	71	6	3	12	9	ΠΛΗ 511
715	45	4	7	12	3	ΠΛΗ 516
716	42	9	0	12	2	ΣΥΣ 511
717	90	6	2	12	7	ΣΥΣ 513
718	70	7	2	12	9	ΤΗΛ 414
719	49	1	5	12	7	ΤΗΛ 302
\.


--
-- Data for Name: Course_depends; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public."Course_depends" (dependent, main, mode) FROM stdin;
ΗΡΥ 203	ΗΡΥ 101	required
ΗΡΥ 202	ΗΡΥ 102	required
ΗΡΥ 204	ΗΡΥ 102	required
ΠΛΗ 301	ΗΡΥ 201	required
ΕΝΕ 301	ΗΡΥ 202	required
ΗΡΥ 302	ΗΡΥ 203	required
ΗΡΥ 301	ΗΡΥ 204	required
ΤΗΛ 201	ΜΑΘ 101	required
ΤΗΛ 202	ΜΑΘ 101	required
ΤΗΛ 401	ΜΑΘ 107	required
ΗΡΥ 201	ΠΛΗ 101	required
ΠΛΗ 201	ΠΛΗ 102	required
ΠΛΗ 202	ΠΛΗ 102	required
ΠΛΗ 302	ΠΛΗ 201	required
ΠΛΗ 401	ΠΛΗ 202	required
ΤΗΛ 302	ΤΗΛ 201	required
ΤΗΛ 303	ΤΗΛ 201	required
ΑΓΓ 102	ΑΓΓ 101	recommended
ΑΓΓ 201	ΑΓΓ 102	recommended
ΑΓΓ 202	ΑΓΓ 201	recommended
ΕΚΠ 512	ΕΚΠ 419	recommended
ΕΝΕ 401	ΕΝΕ 301	recommended
ΕΝΕ 411	ΕΝΕ 301	recommended
ΕΝΕ 412	ΕΝΕ 301	recommended
ΕΝΕ 511	ΕΝΕ 301	recommended
ΕΝΕ 512	ΕΝΕ 301	recommended
ΕΝΕ 411	ΕΝΕ 401	recommended
ΕΝΕ 412	ΕΝΕ 401	recommended
ΕΝΕ 512	ΕΝΕ 401	recommended
ΗΡΥ 201	ΗΡΥ 101	recommended
ΗΡΥ 302	ΗΡΥ 201	recommended
ΗΡΥ 301	ΗΡΥ 202	recommended
ΤΗΛ 412	ΗΡΥ 202	recommended
HPY 416	ΗΡΥ 204	recommended
ΗΡΥ 414	ΗΡΥ 204	recommended
ΗΡΥ 513	ΗΡΥ 204	recommended
HPY 416	ΗΡΥ 301	recommended
ΗΡΥ 412	ΗΡΥ 301	recommended
ΗΡΥ 414	ΗΡΥ 301	recommended
ΗΡΥ 419	ΗΡΥ 301	recommended
ΗΡΥ 511	ΗΡΥ 301	recommended
ΗΡΥ 411	ΗΡΥ 302	recommended
ΗΡΥ 415	ΗΡΥ 302	recommended
ΗΡΥ 417	ΗΡΥ 302	recommended
ΗΡΥ 418	ΗΡΥ 302	recommended
ΗΡΥ 511	ΗΡΥ 302	recommended
ΗΡΥ 512	ΗΡΥ 302	recommended
ΗΡΥ 102	ΜΑΘ 101	recommended
ΜΑΘ 102	ΜΑΘ 101	recommended
ΜΑΘ 302	ΜΑΘ 101	recommended
ΦΥΣ 102	ΜΑΘ 101	recommended
ΕΝΕ 301	ΜΑΘ 102	recommended
ΤΗΛ 201	ΜΑΘ 102	recommended
ΤΗΛ 211	ΜΑΘ 102	recommended
ΤΗΛ 301	ΜΑΘ 102	recommended
ΤΗΛ 311	ΜΑΘ 102	recommended
ΠΛΗ 513	ΜΑΘ 107	recommended
ΤΗΛ 202	ΜΑΘ 107	recommended
ΤΗΛ 414	ΜΑΘ 107	recommended
ΤΗΛ 416	ΜΑΘ 107	recommended
ΜΑΘ 202	ΜΑΘ 201	recommended
ΜΑΘ 203	ΜΑΘ 201	recommended
ΜΑΘ 302	ΜΑΘ 201	recommended
ΤΗΛ 201	ΜΑΘ 201	recommended
ΤΗΛ 413	ΜΑΘ 201	recommended
ΤΗΛ 415	ΜΑΘ 201	recommended
ΗΡΥ 514	ΠΛΗ 101	recommended
ΠΛΗ 102	ΠΛΗ 101	recommended
ΤΗΛ 201	ΠΛΗ 101	recommended
ΗΡΥ 201	ΠΛΗ 102	recommended
ΠΛΗ 211	ΠΛΗ 102	recommended
ΤΗΛ 412	ΠΛΗ 102	recommended
ΕΚΠ 412	ΠΛΗ 201	recommended
ΠΛΗ 202	ΠΛΗ 201	recommended
ΠΛΗ 418	ΠΛΗ 201	recommended
ΠΛΗ 511	ΠΛΗ 201	recommended
ΕΚΠ 413	ΠΛΗ 202	recommended
ΠΛΗ 301	ΠΛΗ 202	recommended
ΠΛΗ 302	ΠΛΗ 202	recommended
ΠΛΗ 411	ΠΛΗ 202	recommended
ΠΛΗ 416	ΠΛΗ 202	recommended
ΠΛΗ 417	ΠΛΗ 202	recommended
ΠΛΗ 418	ΠΛΗ 202	recommended
ΠΛΗ 423	ΠΛΗ 202	recommended
ΠΛΗ 511	ΠΛΗ 202	recommended
ΗΡΥ 411	ΠΛΗ 301	recommended
ΗΡΥ 415	ΠΛΗ 301	recommended
ΗΡΥ 418	ΠΛΗ 301	recommended
ΠΛΗ 302	ΠΛΗ 301	recommended
ΠΛΗ 420	ΠΛΗ 301	recommended
ΕΚΠ 413	ΠΛΗ 302	recommended
ΕΚΠ 419	ΠΛΗ 302	recommended
ΕΚΠ 512	ΠΛΗ 302	recommended
ΠΛΗ 415	ΠΛΗ 302	recommended
ΠΛΗ 416	ΠΛΗ 302	recommended
ΠΛΗ 516	ΠΛΗ 302	recommended
ΠΛΗ 402	ΠΛΗ 401	recommended
ΠΛΗ 416	ΠΛΗ 401	recommended
ΠΛΗ 417	ΠΛΗ 401	recommended
ΠΛΗ 421	ΠΛΗ 401	recommended
ΠΛΗ 423	ΠΛΗ 411	recommended
ΠΛΗ 513	ΠΛΗ 417	recommended
ΣΥΣ 402	ΣΥΣ 401	recommended
ΣΥΣ 412	ΣΥΣ 401	recommended
ΣΥΣ 512	ΣΥΣ 401	recommended
ΣΥΣ 513	ΣΥΣ 401	recommended
ΣΥΣ 514	ΣΥΣ 401	recommended
ΣΥΣ 511	ΣΥΣ 402	recommended
ΣΥΣ 513	ΣΥΣ 402	recommended
ΣΥΣ 513	ΣΥΣ 411	recommended
ΣΥΣ 514	ΣΥΣ 412	recommended
ΣΥΣ 513	ΣΥΣ 413	recommended
ΣΥΣ 513	ΣΥΣ 414	recommended
ΣΥΣ 401	ΤΗΛ 201	recommended
ΤΗΛ 202	ΤΗΛ 201	recommended
ΤΗΛ 301	ΤΗΛ 201	recommended
ΤΗΛ 411	ΤΗΛ 201	recommended
ΤΗΛ 412	ΤΗΛ 201	recommended
ΤΗΛ 303	ΤΗΛ 202	recommended
ΤΗΛ 401	ΤΗΛ 202	recommended
ΤΗΛ 411	ΤΗΛ 202	recommended
ΤΗΛ 415	ΤΗΛ 202	recommended
ΤΗΛ 416	ΤΗΛ 202	recommended
ΤΗΛ 303	ΤΗΛ 301	recommended
ΤΗΛ 416	ΤΗΛ 301	recommended
ΤΗΛ 417	ΤΗΛ 301	recommended
ΤΗΛ 511	ΤΗΛ 301	recommended
ΤΗΛ 411	ΤΗΛ 302	recommended
ΤΗΛ 415	ΤΗΛ 303	recommended
ΕΚΠ 414	ΤΗΛ 312	recommended
ΤΗΛ 414	ΤΗΛ 401	recommended
ΤΗΛ 418	ΤΗΛ 401	recommended
ΤΗΛ 420	ΤΗΛ 401	recommended
ΤΗΛ 511	ΤΗΛ 401	recommended
ΤΗΛ 419	ΤΗΛ 411	recommended
ΗΡΥ 211	ΦΥΣ 101	recommended
ΦΥΣ 102	ΦΥΣ 101	recommended
ΕΝΕ 301	ΦΥΣ 102	recommended
ΗΡΥ 211	ΦΥΣ 102	recommended
ΤΗΛ 211	ΦΥΣ 102	recommended
\.


--
-- Data for Name: Course_description; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public."Course_description" (course_code, course_description) FROM stdin;
ΑΓΓ 101	Γραμματικά φαινόμενα και ανάπτυξη γραπτών και λεξιλογικών δεξιοτήτων στην Αγγλική σε επίπεδο Β2. 
ΠΛΗ 101	Η επιστήμη της πληροφορικής στις μέρες μας. Εισαγωγή σε αλγόριθμους και προγράμματα, δομημένος προγραμματισμός, ανάπτυξη σωστών αλγορίθμων, ανάπτυξη γρήγορων αλγορίθμων, χαρακτηριστικά προχωρημένων γλωσσών προγραμματισμού. Εισαγωγή στο διαδικαστικό προγραμματισμό χρησιμοποιώντας τη γλώσσα C. Κύκλος εκτέλεσης προγραμμάτων. Συντακτικοί και λεκτικοί κανόνες της C. Βασικοί τύποι δεδομένων. Δηλώσεις μεταβλητών και σταθερών. Τελεστές και εκφράσεις. Εντολές ελέγχου ροής. Συναρτήσεις εισόδου-εξόδου. Συναρτήσεις που ορίζονται από τον προγραμματιστή. Πίνακες. Δομές. Δείκτες. Διαχείριση αρχείων.
ΜΑΘ 101	Συναρτήσεις μιας μεταβλητής. Όρια και συνέχεια συναρτήσεων. Παράγωγος συνάρτησης. Γεωμετρική ερμηνεία της έννοιας της παραγώγου. Διαφορικά συναρτήσεων. Εφαρμογές των παραγώγων στη μελέτη συναρτήσεων (μονοτονία, κυρτότητα, ακρότατα συναρτήσεων). Θεώρημα μέσης τιμής. Κανόνας του L’ Hopital. Ολοκληρώματα συναρτήσεων μιας μεταβλητής. Ορισμένο ολοκλήρωμα. Θεμελιώδη θεωρήματα ολοκληρωτικού λογισμού. Υπολογισμός εμβαδών και όγκων. Εφαρμογές στη Φυσική. Εκθετικές συναρτήσεις. Αντίστροφες συναρτήσεις. Υπερβολικές συναρτήσεις. Τεχνικές ολοκλήρωσης. Καταχρηστικά ολοκληρώματα. Ακολουθίες και σειρές (κριτήρια σύγκλισης). Δυναμοσειρές και σειρές Taylor.
ΗΡΥ 101	Δυαδική αναπαράσταση αριθμών, δυαδικό/οκταδικό/δεκαεξαδικό σύστημα αναπαράστασης, κώδικες. Άλγεβρα Boole, λογικές πύλες, συνδυαστική λογική δύο επιπέδων. Απλοποίηση συναρτήσεων μίας και πολλών μεταβλητών, πίνακες Karnaugh, ελαχιστοποίηση McCluskey. Αριθμητικά κυκλώματα, αθροιστές/αφαιρέτες. Σχεδίαση συνδυαστικών κυκλωμάτων με ολοκληρωμένα κυκλώματα TTL, αποκωδικοποιητές, πολυπλέκτες, συγκριτές,. Ακολουθιακή λογική, μανδαλωτές, καταχωρητές (flip-flop), μετρητές, σχεδίαση και ανάλυση ακολουθιακών κυκλωμάτων, σχεδίαση μηχανών πεπερασμένων καταστάσεων. Διατάξεις προγραμματιζόμενης λογικής (PLA, PAL, GAL), εισαγωγή σε γλώσσες περιγραφής υλικού.
ΜΑΘ 201	Γραμμικοί χώροι, υποχώροι, βάση και διάσταση γραμμικού χώρου, χώροι εσωτερικού γινομένου, ορθογωνιότητα, πίνακες, τάξη πίνακα, χώροι στηλών - γραμμών πίνακα, τα θεμελιώδη προβλήματα της γραμμικής άλγεβρας, συστήματα γραμμικών εξισώσεων, ορίζουσες, γραμμικές απεικονίσεις, πίνακες γραμμικών απεικονίσεων, ιδιοτιμές και ιδιοδιανύσματα, ιδιοχώροι, τετραγωνικές μορφές, θετικά ορισμένοι πίνακες, παραδείγματα από εφαρμογές της γραμμικής άλγεβρας.
ΜΑΘ 208	Στοιχειώδης συνδυαστική: κανόνες αθροίσματος γινομένου, μεταθέσεις, συνδυασμοί, συνδυασμοί με επανάληψη, δυωνυμικό / πολυωνυμικό θεώρημα, συντελεστές πολυωνύμων. Στοιχεία μαθηματικής λογικής: προτάσεις, λογικές πράξεις, αληθοπίνακες, άλγεβρα προτάσεων, ποσοτικοποιητές, συμπερασματικοί κανόνες. Θεωρία συνόλων: πράξεις, άλγεβρα συνόλων και δυϊκότητα, πεπερασμένα, άπειρα, αριθμήσιμα σύνολα. Θεωρία αριθμών και μαθηματική επαγωγή: ιδιότητες ακεραίων, θεωρήματα μαθηματικής επαγωγής, αλγόριθμος διαίρεσης, διαιρετότητα, πρώτοι αριθμοί, θεώρημα μέγιστου κοινού διαιρέτη, θεμελιώδες θεώρημα της αριθμητικής. Σχέσεις και συναρτήσεις: είδη σχέσεων, σύνθεση, σχέσεις ισοδυναμίας / μερικής διάταξης, συναρτήσεις ως σχέσεις, ένα προς ένα, επί και αντιστρεπτές συναρτήσεις. Γλώσσες: αλφάβητο, λέξεις, γλώσσες (συνολοθεωρία των λέξεων). Πεπερασμένα αυτόματα: ντετερμινιστικά και μη, συσχέτιση με γλώσσες, σχέσεις και συναρτήσεις. Βασικές έννοιες θεωρίας γραφημάτων: κατευθυνόμενα ή μη, συσχέτιση με σχέσεις, αναπαράσταση, διασχίσεις. 
ΦΥΣ 102	Εισαγωγή στην ηλεκτροστατική: Ηλεκτρικό φορτίο, νόμος του Coulomb, έννοια του ηλεκτροστατικού πεδίου και του δυναμικού, κίνηση φορτίου σε ηλεκτρικό πεδίο. Νόμος Gauss και εφαρμογές. Ηλεκτρικό δυναμικό, διαφορά ηλεκτρικού δυναμικού, ηλεκτρικό δίπολο, ηλεκτρική δυναμική ενέργεια, προσδιορισμός ηλεκτροστατικού πεδίου από μετρήσεις του δυναμικού. Ηλεκτρικές ιδιότητες της ύλης: Διηλεκτρικά και αγωγοί. Νόμος Biot-Savart. Μαγνητική επαγωγή, μαγνητική ροή, μαγνητικό διπολικό πεδίο, βαθμωτό μαγνητικό δυναμικό, πεδία μαγνητισμένης ύλης, μαγνήτιση, ένταση και εξισώσεις μαγνητικού πεδίου, υστέρηση, διαμαγνητισμός, παραμαγνητισμός, σιδηρομαγνητισμός, αντισιδηρομαγνητισμός, νόμος Ampere, ρευματοφόροι αγωγοί, σωληνοειδές. Επαγωγικά ρεύματα, χρονικά μεταβαλλόμενη μαγνητική ροή, νόμος Faraday, νόμος Lenz, συντελεστής αυτεπαγωγής L, Κύκλωμα LR. Ενέργεια σε ηλεκτρικό και μαγνητικό πεδίο, ηλεκτρομαγνητικές ταλαντώσεις συστήματος LC, φθίνουσες και εξαναγκασμένες ταλαντώσεις, συντονισμός σε κύκλωμα LCR. Κυματικές έννοιες, αρχή δημιουργίας ηλεκτρομαγνητικού κύματος, ενέργεια και ένταση ΗΜ κύματος, ηλεκτρικό δίπολο, πόλωση, διηλεκτρικά. Διάνυσμα Poynting, επαγωγικά μαγνητικά πεδία, ρεύμα μετατόπισης, εξισώσεις Maxwell, διάδοση ΗΜ κυμάτων στο κενό και στην ύλη, εύρος ΗΜ φάσματος, γραμμές μεταφοράς, κυματοδηγοί, αλληλεπίδραση ΗΜ κυμάτων με την ύλη: Απορρόφηση, σκέδαση, ανάκλαση, συμβολή, περίθλαση, φωτοηλεκτρικό φαινόμενο. 
ΑΓΓ 102	Ανάπτυξη των γραμματικών και λεξιλογικών δεξιοτήτων στην Αγγλική σε επίπεδο Γ2 με επιπρόσθετη έμφαση στις δεξιότητες ανάγνωσης και γραφής ακαδημαϊκού λόγου.
ΦΥΣ 101	Ευθύγραμμη κίνηση, κίνηση στο επίπεδο, διανύσματα, νόμοι του Newton, βαρυτικές δυνάμεις, προσδιορισμός επιτάχυνσης βαρύτητας με ελεύθερη πτώση, δυνάμεις τριβών, προσδιορισμός συντελεστή τριβής επιφανειών σε επαφή. Ορμή, διατήρηση ορμής, κέντρο μάζας. Κινητική και δυναμική ενέργεια, νόμος διατήρησης ενέργειας, έργο, ισχύς, συντηρητικές δυνάμεις, σχέση μεταξύ δύναμης και δυναμικής ενέργειας. Περιστροφική κίνηση σημείου και σώματος, προσδιορισμός γωνιακής επιτάχυνσης, ροπής αδράνειας και ροπής τριβών ομαλά περιστρεφόμενου στερεού, γενική συνθήκη μηχανικής ισορροπίας. Στροφορμή σημείου και στερεού, νόμος διατήρησης στροφορμής, μετάπτωση. Απλός αρμονικός ταλαντωτής, απλό, σύνθετο και στροφικό εκκρεμές, προσδιορισμός σταθεράς ελατηρίου, επιτάχυνσης βαρύτητας με το απλό εκκρεμές και ροπής αδράνειας στερεού με το δινηματικό εκκρεμές. Κίνηση υπό περιορισμούς, γενικευμένες συντεταγμένες, εξισώσεις κίνησης του Hamilton. Θερμότητα, προσδιορισμός συντελεστή θερμικής αγωγιμότητας, εντροπία, νόμοι θερμοδυναμικής. 
ΧΗΜ 101	Δομή του ατόμου. Κβαντομηχανική προσέγγιση ατομικής δόμησης. Ατομικά πρότυπα. Ατομικά τροχιακά. Ηλεκτρονιακή διαμόρφωση των στοιχείων. Περιοδικός πίνακας και περιοδικές ιδιότητες των στοιχείων. Ιοντικός δεσμός. Ομοιοπολικός δεσμός. Μοριακή Γεωμετρία. Θεωρία δεσμού σθένους. Υβριδισμός και υβριδικά τροχιακά. Θεωρία μοριακών τροχιακών. Διαμοριακές δυνάμεις. Μεταλλικός δεσμός (ιδιότητες μετάλλων, καθαροί ημιαγωγοί πυριτίου και ημιαγωγοί πρόσμιξης, εφαρμογές ημιαγωγών, φωτοβολταϊκά στοιχεία, δίοδοι p-n). Εισαγωγικά θέματα Φυσικοχημείας (είδη χημικών αντιδράσεων, ισορροπία χημικών αντιδράσεων, χημική κινητική). Διαλύματα. Οξέα. Βάσεις. Άλατα. Οξειδοαναγωγή. Ηλεκτροχημεία. Σύγχρονες μέθοδοι επιφανειακής και δομικής ανάλυσης υλικών μικροηλεκτρονικής. Τεχνική της περίθλασης ακτίνων-Χ (ΧRD). Φασματοσκοπία φωτοηλεκτρονίων (XPS). Φασματοσκοπία ηλεκτρονίων Auger (ΑES). Φασματοσκοπία φθορισμού ακτίνων-Χ (XRF). Φασματοσκοπία υπερύθρου (IR).
ΗΡΥ 102	Συγκεντρωμένα στοιχεία και κυκλώματα, θεμελιώδη στοιχεία των κυκλωμάτων (αντιστάτες, πυκνωτές, πηνία, ανεξάρτητες πηγές τάσης και ρεύματος), ιδανικά στοιχεία, προσεγγίσεις, παρασιτικά φαινόμενα, ισοδύναμα κυκλώματα, συσχετισμένη φορά αναφοράς, παθητικά και ενεργά στοιχεία, γραμμικότητα, μεταβλητές - παράμετροι - στιγμιαίες τιμές, χαρακτηριστικές καμπύλες, ισχύς και ενέργεια. Απλά κυκλώματα, νόμοι του Kirchhoff, θεώρημα Tellegen, συνδεσμολογίες στοιχείων, γέφυρα αντιστατών, κλιμακωτό δίκτυο, ευαισθησία σε μικρές μεταβολές, βασικές κυματομορφές σημάτων, ανάλυση μικρού σήματος, εισαγωγή στα γραμμικά χρονικά αμετάβλητα κυκλώματα, ανάλυση κυκλωμάτων 1ης, 2ης και μεγαλύτερης τάξης (διαφορικές εξισώσεις, απόκριση μηδενικής εισόδου και μηδενικής κατάστασης, πλήρης απόκριση, μεταβατική και μόνιμη κατάσταση, βηματική και κρουστική απόκριση), βασικές αρχές των μεθόδων κόμβων και βρόχων για ανάλυση γραμμικών ηλεκτρικών κυκλωμάτων, εξισώσεις κατάστασης, μετασχηματισμός Laplace (ορισμός, θεωρητική ανάλυση, ιδιότητες, επίλυση διαφορικών εξισώσεων, ενδεικτικές εφαρμογές), συναρτήσεις μεταφοράς (διαγράμματα Bode, πόλοι-μηδενικά, φυσικές συχνότητες, εφαρμογή στο σχεδιασμό ταλαντωτή και στο σχεδιασμό φίλτρων).
ΠΛΗ 102	Σύνθετες εφαρμογές δεικτών στη γλώσσα C. Δείκτες σε δείκτες. Αναδρομή. Εισαγωγή σε Java και αφαίρεση στον οντοκεντρικό προγραμματισμό. Η έννοια της κλάσης και του αντικειμένου. Είσοδος / έξοδος, πέρασμα παραμέτρων σε μεθόδους, επίπεδα πρόσβασης μεταβλητών / μεθόδων / κλάσεων, υπερφορτισμός, κληρονομικότητα, πολυμορφισμός, αφηρημένες κλάσεις. Αφηρημένοι τύποι δεδομένων (abstract data types). Παραδείγματα αφηρημένων τύπων δεδομένων και προγραμματισμού των. Λίστες και παραλλαγές τους (απλά / διπλά διασυνδεδεμένες λίστες, κυκλικές λίστες). Ουρές και στοίβες. Τύποι δεδομένων βασισμένοι σε δενδρική οργάνωση. Δυαδικά δένδρα αναζήτησης. Δομές βασισμένες σε κατακερματισμό. Εφαρμογές με απλούς αλγόριθμους αναζήτησης.
ΜΑΘ 102	Βασικές έννοιες διαφορικών εξισώσεων. Το πρόβλημα των αρχικών τιμών. Πρωτοτάξιες διαφορικές εξισώσεις: Διαφορικές εξισώσεις χωριζόμενων μεταβλητών. Γραμμικές διαφορικές εξισώσεις - η μέθοδος του ολοκληρωτικού παράγοντα. Γραμμικές διαφορικές εξισώσεις ανώτερης τάξης. Εφαρμογές διαφορικών εξισώσεων - κυκλώματα RLC. Μετασχηματισμός Laplace. Ιδιότητες. Επίλυση γραμμικών διαφορικών εξισώσεων με χρήση μετασχηματισμού Laplace. Συναρτήσεις πολλών μεταβλητών. Επιφάνειες δεύτερου βαθμού. Πολικές, κυλινδρικές και σφαιρικές συντεταγμένες. Καμπύλες και μήκος τόξου. Εσωτερικό και εξωτερικό γινόμενο διανυσμάτων. Μερικές παράγωγοι συναρτήσεων πολλών μεταβλητών. Διανυσματικά πεδία, div, grad, curl. Θεώρημα Taylor. Ακρότατα συναρτήσεων πολλών μεταβλητών, πολλαπλασιαστές Lagrange. Επικαμπύλια ολοκληρώματα. Διπλά, τριπλά και επιφανειακά ολοκληρώματα. Εφαρμογές στη ροή των ρευστών.
ΠΛΗ 111	Λογική: προτασιακός λογισμός, κατηγορηματικός λογισμός πρώτης τάξης, αξιωματικά συστήματα, σημασιολογικά μοντέλα, ταυτότητες, κανόνες συναγωγής, αποδείξεις, ορθότητα και πληρότητα. Tεχνικές αποδείξεων: ευθεία απόδειξη, αντιθετοαντιστροφή, εις άτοπο απαγωγή, μαθηματική επαγωγή, γενικευμένη επαγωγή και αναδρομή. Σχεσιακός λογισμός, σχεσιακές άλγεβρες. Τυπικές θεωρίες, ορθά διατυπωμένες εκφράσεις, αριθμητική πρώτης τάξης. Ακολουθίες: ασυμπτωτική συμπεριφορά των ακολουθιών, γεννήτριες συναρτήσεις, αναδρομικές σχέσεις, γραμμικές αναδρομικές σχέσεις με σταθερούς συντελεστές, ομογενείς λύσεις, ειδικές λύσεις, ολικές λύσεις, λύση με τη μέθοδο των γεννητριών συναρτήσεων, αθροίσματα.
ΜΑΘ 202	Αριθμοί κινητής υποδιαστολής, αριθμοί μηχανής, σφάλματα στρογγύλευσης στους υπολογισμούς. Επίλυση Αλγεβρικών Εξισώσεων: Μέθοδος Διχοτόμησης και Εσφαλμένης Θέσης, Τροποποιημένες μέθοδοι αγκυλών (Illinois, υβριδικές), Επαναληπτική Μέθοδος Σταθερού Σημείου, Μέθοδος Newton-Raphson και Τέμνουσας, Επιτάχυνση Aitken και η μέθοδος του Steffensen, Μέθοδος Muller. Μη-γραμμικά Συστήματα Εξισώσεων. Πολυωνυμική Παρεμβολή: Παρεμβολή Lagrange, Πολυώνυμα Newton και Διηρημένες Διαφορές, Παρεμβολή Hermite, Ομοιόμορφες Διαμερίσεις και το φαινόμενο Runge, Κόμβοι Chebyshev, Παρεμβολή με Splines - Γραμμικές Splines, Κυβικές Splines, Κυβικές Hermite Splines και Διευρυμένες Διηρημένες Διαφορές. Διακριτά Ελάχιστα Τετράγωνα: Η Γραμμή των Ελαχίστων Τετραγώνων, Το Πολυώνυμο m-βαθμού των Ελαχίστων Τετραγώνων, Το γενικό Γραμμικό Πρόβλημα των Ελαχίστων Τετραγώνων, Κανονικές Εξισώσεις, Μη-Γραμμικά Ελάχιστα Τετράγωνα, Γραμμοποίηση. Αριθμητική Παραγώγιση: Έμπροσθεν και Όπισθεν Πεπερασμένες Διαφορές Πρώτης Τάξης, Κεντρικές Πεπερασμένες Διαφορές Δευτέρας Τάξης, Παρεκβολή Richardson για υψηλής τάξης Πεπερασμένες Διαφορές. Αριθμητική Ολοκλήρωση: Αθροίσματα Riemann, Κανόνες Newton-Cotes, Κανόνες Τραπεζίου και Simpson, Σύνθετοι Κανόνες, Ολοκλήρωση Romberg, Ολοκλήρωση Gauss-Legendre. Επίλυση Προβλημάτων Αρχικών Τιμών: Η Μέθοδος του Euler, Σύγκλιση και Ευστάθεια, Η μέθοδος του Heun, Μέθοδοι Taylor, Μέθοδοι Runge-Kutta.
ΗΡΥ 201	Βασική οργάνωση υπολογιστή: επεξεργαστής, μνήμη και περιφερειακά, γλώσσα μηχανής, γλώσσα συμβολομεταφραστή (assembly) και προγραμματισμός με αυτή. Μοντέλο προγραμματισμού επεξεργαστή, εντολές και σύνολα εντολών, μέθοδοι καθορισμού διευθύνσεων (addressing modes), διακοπές και εξαιρέσεις. Ψηφιακή αναπαράσταση αριθμών (ακεραίων και κινητής υποδιαστολής), αριθμητικές πράξεις: προσθαφαίρεση, πολλαπλασιασμός, διαίρεση. Συστήματα μνήμης υπολογιστών, στοίβες. Εργαστήρια με χρήση μικρο-επεξεργαστή,η προσομοιωτή.
ΗΡΥ 202	Ημιτονοειδής Μόνιμη Κατάσταση, μιγαδικοί αριθμοί, θεωρήματα και λήμματα για την ΗΜΚ, παραστατικοί μιγάδες, ημιτονοειδής διέγερση (μερική λύση και πλήρης απόκριση), σύνθετη αντίσταση - σύνθετη αγωγιμότητα, κυκλώματα συντονισμού RLC σε σειρά και παράλληλα, συχνότητα συντονισμού, υπέρρευμα και υπέρταση, συντελεστής ποιότητας, συναρτήσεις δικτύου, τα decibel, απόκριση συχνότητας, φίλτρα, πραγματική ή μέση ισχύς, μιγαδική ισχύς, άεργη ισχύς, συντελεστής ισχύος, ενεργές ή μέσες τετραγωνικές τιμές, θεώρημα μέγιστης μεταφοράς ισχύος. Συζευγμένα πηνία, μετασχηματιστές, συντελεστής σύζευξης, μετασχηματιστές πολλών τυλιγμάτων, ιδανικός μετασχηματιστής, ισοδύναμο του μετασχηματιστή, ελεγχόμενες ή εξαρτημένες πηγές τάσης και ρεύματος, σύζευξη μεταξύ κλάδων, ισχύς μετασχηματιστών και εξαρτημένων πηγών. Γράφοι δικτύων, υπογράφος, προσανατολισμένος γράφος, συνδεμένος γράφος, πίνακας πρόσπτωσης, σύνολο αποκοπής, κλειστή διαδρομή. Ανάλυση κόμβων και βρόχων, κατάστρωση των εξισώσεων δικτύου, μετασχηματισμοί πηγών και κλάδων, επίπεδος γράφος, βρόχος, εξωτερικός βρόχος, δυαδικοί γράφοι και δυαδικά δίκτυα. Θεωρήματα Δικτύων, θεώρημα της αντικατάστασης, θεώρημα της υπέρθεσης, θεώρημα Thevenin - Norton, θεώρημα της αμοιβαιότητας. Δίθυρα δίκτυα, δίπολο ή μονόθυρο δίκτυο, τετράπολο δίκτυο, τερματισμένα δίθυρα, παράμετροι ανοικτοκύκλωσης ή σύνθετης αντίστασης ή Z, παράμετροι βραχυκύκλωσης ή σύνθετης αγωγιμότητας ή Y, υβριδικές H παράμετροι, υβριδικές G παράμετροι, παράμετροι μετάδοσης ή ABCD, αντίστροφες παράμετροι μετάδοσης, ανάλυση μικρού σήματος.
ΠΛΗ 201	Το μάθημα παρουσιάζει μία εισαγωγή σε βασικές αρχές για ανάλυση απαιτήσεων, σχεδιασμό και υλοποίηση μεγάλων εφαρμογών λογισμικού χρησιμοποιώντας μεθόδους και πρότυπα οντοκεντρικής μοντελοποίησης και ανάπτυξης. Επισκόπηση της μεθοδολογίας ανάπτυξης λογισμικού. Ανάλυση απαιτήσεων, σχεδιασμός, testing, συντήρηση. Εξαγωγή απαιτήσεων, ανάλυση, καταγραφή, στόχοι, πρωτότυπα, use cases. Μοντελοποίηση, οντοκεντρικές μεθοδολογίες μοντελοποίησης, γλώσσες μοντελοποίησης, UML. Μοντελοποίηση δομής, συμπεριφοράς, δραστηριοτήτων, καταστάσεων, περιορισμών σε UML. Επεκτασιμότητα της γλώσσας. Μεθοδολογίες ανάπτυξης, waterfall models, το μοντέλο των rational, agile μεθοδολογιών. H μεθοδολογία ICONIX. Μεθοδολογίες επισκόπησης απαιτήσεων, σχεδιασμού, λεπτομερούς σχεδιασμού. Μοτίβα ανάπτυξης οντοκεντρικών συστημάτων όπως observer, decorator, factory και άλλα. Το μάθημα περιλαμβάνει ανάπτυξη προχωρημένων εφαρμογών σε java όπως εφαρμογές με threads, exceptions, files, event processing, και διαπροσωπιών (user interfaces).
ΚΕΠ 301	Η τεχνολογία και η τέχνη στη διάρθρωση της κοινωνίας. Η τεχνολογία ως αντικειμενοποίηση, ως πλαίσιο επενέργειας του ανθρώπου στη φύση και σχέσεων μεταξύ των ανθρώπων, ως προτρέχουσα σύλληψη-γνώση και ως όργανο επενέργειας στη φύση. Η ιδιοτυπία του αισθητικού. Το αισθητικό ως εξειδικευμένη ενασχόληση στον καταμερισμό της εργασίας (τέχνη). Βασικές αισθητικές κατηγορίες. Οι κοινωνικές λειτουργίες της τέχνης. Τέχνη και τεχνολογία στην ιστορία του πολιτισμού. Το ανυπόστατο της μεταφυσικής αντιδιαστολής «απολλώνιου» και «διονυσιακού». Η συνθετική διάσταση της δημιουργικότητας.
ΤΗΛ 201	Σήμα, σύστημα, επεξεργασία σήματος, σήματα συνεχούς και διακριτού χρόνου, διαχωρισμός σημάτων σε περιοδικά-απεριοδικά και σήματα ενέργειας-ισχύος. Συστήματα συνεχούς και διακριτού χρόνου, ανάλυση γραμμικών χρονικά αμετάβλητων συστημάτων, συνέλιξη, ευστάθεια εισόδου-εξόδου (BIBO). Μελέτη σημάτων και συστημάτων με τη χρήση του MATLAB. Ημιτονοειδή σήματα, αρμονικά συνδεδεμένα σήματα, σειρά Fourier περιοδικού σήματος. Μετασχηματισμός Fourier σήματος συνεχούς χρόνου, ιδιότητες και εφαρμογές μετασχηματισμού Fourier, μετασχηματισμός Fourier περιοδικού σήματος συνεχούς χρόνου, μετασχηματισμός Fourier σήματος διακριτού χρόνου, θεώρημα δειγματοληψίας Nyquist. Διαμόρφωση πλάτους, πολυπλεξία στο πεδίο των συχνοτήτων, διαμόρφωση γωνίας, εφαρμογές διαμόρφωσης στα τηλεπικοινωνιακά συστήματα, διαμόρφωση AM και FM. Μετασχηματισμός Laplace, περιοχή σύγκλισης, αντίστροφος μετασχηματισμός Laplace, ιδιότητες και εφαρμογές μετασχηματισμού Laplace.
ΜΑΘ 107	Πείραμα τύχης. Δειγματοχώρος πειράματος τύχης. Κλασσικός ορισμός Πιθανότητας. Στατιστικός ορισμός Πιθανότητας. Αξιωματικός ορισμός Πιθανότητας. Συνδυαστική. Δεσμευμένη Πιθανότητα. Ανεξαρτησία γεγονότων. Τυχαίες μεταβλητές. Κατανομή τυχαίας μεταβλητής. Διωνυμική κατανομή. Κατανομή Poisson. Κανονική κατανομή. Αρνητική εκθετική κατανομή. Μέση τιμή τ.μ. Ροπές τ.μ. Διασπορά τ.μ. Ανισότητα Chebyshev. Νόμος Μεγάλων Αριθμών. Κεντρικό Οριακό Θεώρημα. Περιγραφική Στατιστική.
ΑΓΓ 201	Πρόγραμμα αυτόνομης εκμάθησης Αγγλικής στο Κέντρο Γλωσσικών Ερευνών και Πόρων με υλικό που στοχεύει να βελτιώσει τις γλωσσικές και γραπτές δεξιότητες, αλλά και τις δεξιότητες κατανόησης. 
ΠΛΗ 211	Βασικά εργαλεία ανάπτυξης λογισμικού: διαδικασία μεταγλώττισης, σύνδεση, φόρτωση. Διαχείριση και έλεγχος εκδόσεων πηγαίου κώδικα (version control). Αυτοματοποίηση μεταγλώττισης (build management). Εργαλεία εκσφαλμάτωσης (debugging), δοκιμής ενοτήτων (unit testing) και απεικόνισης εκτέλεσης (profiling). Αναμόρφωση κώδικα (refactoring). Το περιβάλλον προγραμματισμού του Unix: κελύφη και βοηθητικά προγράμματα (shells and utilities), σύστημα αρχείων, ανακατεύθυνση εισόδου/εξόδου και σωληνώσεις, έλεγχος εργασιών (job control). Προγραμματισμός κελύφους. Προγραμματισμός συστήματος. Προγραμματισμός με scripting: εισαγωγή στη γλώσσα Python, τύποι δεδομένων και οργάνωση κώδικα. Εφαρμογές επεξεργασίας κειμένου: βασικές λειτουργίες, κανονικές εκφράσεις, βασική θεωρία κανονικών γλωσσών, υλοποίηση επεξεργασίας κειμένων σε Python, παραδείγματα και εφαρμογές.
ΗΡΥ 203	Εισαγωγή σε γλώσσες περιγραφής υλικού (HDL). Μοντέλα συμπεριφοράς και δομής, σχεδιασμός με σχηματικά διαγράμματα, προσομοίωση, επιβεβαίωση σωστής λειτουργίας και ανάλυση χρονισμού κυκλωμάτων. Προχωρημένη λογική σχεδίαση, κωδικοποίηση one-hot, σχεδίαση με αλγοριθμικές μεθόδους. Υπολογισμοί fan-in, fan-out, critical path. Χωρική και χρονική πολυπλοκότητα και υπολογισμός συναρτήσεων πολυπλοκότητας Ο( ) για λογικά κυκλώματα. Λογική σχεδίαση datapath και control path. Μηχανές πεπερασμένων καταστάσεων, βελτιστοποίηση καταστάσεων. Γρήγορα κυκλώματα αριθμητικών πράξεων, αθροιστές: carry look-ahead, carry select, carry-save, πολλαπλασιαστές, διαιρέτες. Αριθμητική σταθερής και κινητής υποδιαστολής. Σύνθεση ψηφιακών κυκλωμάτων.
ΗΡΥ 204	Φυσική ημιαγωγών, δίοδος p-n, ειδικές δίοδοι, (φωτοεκπέμπουσα δίοδος (LED), δίοδοι Schottky, δίοδος μεταβλητής χωρητικότητας, δίοδοι Zener), εφαρμογές διόδων (ανορθωτές-σταθεροποιητές-πολλαπλασιαστές τάσης, λογικές πύλες), διπολικά transistors (BJT), συνδεσμολογίες κοινού εκπομπού, κοινής βάσης, κοινού συλλέκτη, υβριδικά ισοδύναμα transistor, χαρακτηριστικές και πόλωση transistor, βασικοί ενισχυτές, transistor JFET, MOSFET, τεχνολογία CMOS, θερμική ανάλυση ημιαγώγιμων στοιχείων, εισαγωγή στους τελεστικούς ενισχυτές και βασικές εφαρμογές τους, τεχνολογίες κατασκευής ολοκληρωμένων κυκλωμάτων.
ΜΑΘ 302	Συναρτήσεις μιγαδικής μεταβλητής. Παράγωγοι. Συνθήκες Cauchy/Reimann. Αναλυτικές συναρτήσεις. Αρμονικές συναρτήσεις. Εκθετικές τριγωνομετρικές, υπερβολικές συναρτήσεις και μετασχηματισμοί. Γραμμικοί μετασχηματισμοί και μετασχηματισμοί Moebius. Σύμμορφες απεικονίσεις. Επικαμπύλια ολοκληρώματα. Θεώρημα Cauchy/Goursat. Ολοκληρωτικοί τύποι Cauchy. Σειρές Taylor. Σειρές Laurent. Υπολογισμός ορισμένων (καταχρηστικών) ολοκληρωμάτων. Ολοκλήρωση γύρω από σημείο διακλάδωσης. Εφαρμογές σε μετασχηματισμούς Fourier και Laplace. Γραμμικοί χώροι μιγαδικών συναρτήσεων. Βάσεις, ορθογωνιότητα, πληρότητα.
ΠΛΗ 202	Αφαιρετικοί τύποι δεδομένων Α.Τ.Δ. (abstract data types). Πολυπλοκότητα αλγορίθμων, ανάλυση απόδοσης αλγορίθμων (Συμβολισμοί Όμικρον και Ωμέγα). Ταξινόμηση στην κεντρική μνήμη και το δίσκο. Δένδρα (trees), δυαδικά δένδρα έρευνας (binary search trees). Εφαρμογές, κώδικες Huffman, σωροί (heaps). Γράφοι (graphs), προβλήματα με γράφους και εφαρμογές (minimum spanning tree, shortest path). Αναζήτηση (searching) στην κεντρική μνήμη και το δίσκο, σειριακή και δεικτοδοτημένη αναζήτηση, ανάλυση απόδοσης αναζήτησης. Ιεραρχημένη αναζήτηση με δένδρα, δένδρα στην κεντρική μνήμη (binary search trees, AVL trees, optimal trees, splay trees), ανάλυση απόδοσης. Δένδρα στη δευτερεύουσα μνήμη (multi-way search trees, B-trees, B+-trees). Tries, digital search trees, text tries, Patricia tries, κωδικοποίηση Lempel-Ziv. Μη ιεραρχημένη αναζήτηση, κατακερματισμός (hashing) στην κεντρική μνήμη, μέθοδοι αντιμετώπισης συγκρούσεων (collision resolution), ανοικτή διευθυνσιοδότηση (open addressing), χωριστές αλυσίδες (separate chaining), ανάλυση πολυπλοκότητας αναζήτησης. Κατακερματισμός (hashing) στο δίσκο (dynamic hashing, extendible hashing, linear hashing), ανάλυση απόδοσης αναζήτησης.
ΤΗΛ 202	Σύντομη εισαγωγή στην θεωρία πιθανοτήτων (σύνολα, μοντέλα πιθανοτήτων, αξιωματικός ορισμός, δεσμευμένη πιθανότητα, κύρια θεωρήματα, ανεξαρτησία). Τυχαίες μεταβλητές – τ.μ. (ορισμός και βασικές έννοιες, διακριτές τ.μ.: συναρτήσεις μάζας πιθανότητας, συναρτήσεις τ.μ., μέση τιμή και διασπορά, από κοινού συνάρτηση μάζας πιθανότητας πολλαπλών τ.μ., δέσμευση, ανεξαρτησία, συνεχείς τ.μ.: συνάρτηση πυκνότητας πιθανότητας, αθροιστική συνάρτηση κατανομής, κανονικές τ.μ., δεσμευμένη συνάρτηση πυκνότητας πιθανότητας από ένα γεγονός, πολλαπλές συνεχείς τ.μ., κατανομές συναρτήσεων τ.μ.). Επιπλέον έννοιες τ.μ. (αθροίσματα ανεξάρτητων τ.μ. συνέλιξη, περισσότερα για δεσμευμένη μέση τιμή και διασπορά, άθροισμα τυχαίου αριθμού ανεξάρτητων τ.μ., συνδιασπορά και συσχέτιση. Εισαγωγή στις στοχαστικές διαδικασίες Bernoulli και Poisson. Πολυδιάστατες κανονικές κατανομές. Τυχαία σήματα: ορισμός, ερμηνεία, ειδικές περιπτώσεις. Αναμενόμενες τιμές και συνάρτηση αυτοσυσχέτισης τυχαίων σημάτων. Στασιμότητα. Πυκνότητα φάσματος ισχύος. Απόκριση γραμμικών, χρονικά-αναλλοίωτων συστημάτων σε τυχαία σήματα. 
ΑΓΓ 202	Μελέτη κειμένων και λεξιλογίου χρησιμοποιώντας τεχνικό υλικό για Μηχανικούς.
ΗΡΥ 211	Ατομική και μοριακή δομή, χημικοί δεσμοί, στοιχεία κρυσταλλικής δομής, πηγάδι δυναμικού-εξίσωση Schrödinger, φωνόνια, ελεύθερα ηλεκτρόνια, ενεργειακές ζώνες: ζώνες του Brillouin, μέταλλα, ημιαγωγοί και μονωτές, ενεργός μάζα, πυκνότητα των ενεργειακών καταστάσεων σε μία ενεργειακή ζώνη, ειδική ηλεκτρική αγωγιμότητα, ηλεκτρονικά φαινόμενα μεταφοράς: ειδική ηλεκτρική αγωγιμότητα, διάχυση, αγωγιμότητα, φαινόμενο HALL, θερμοηλεκτρική εκπομπή, φαινόμενο Schottky, ενδογενής και εξωγενής ημιαγωγός, υπεραγωγιμότητα. Μαγνητικές ιδιότητες της ύλης: βασικές έννοιες, ορισμοί, ταξινόμηση των τύπων μαγνητισμού, σιδηρομαγνητισμός, αντιφερρομαγνητισμός, φερρομαγνητισμός, μαγνητικές περιοχές, το διάγραμμα Β-Η. Διηλεκτρικές ιδιότητες της ύλης: σχετική διηλεκτρική σταθερά, πόλωση σε εναλλασσόμενο πεδίο, διηλεκτρική αντοχή και μηχανισμοί διάσπασης, διηλεκτρική συμπεριφορά των αερίων, φερροηλεκτρισμός, πιεζοηλεκτρισμός, φυσικοί, ανόργανοι και οργανικοί μονωτές.
ΤΗΛ 211	Χρονικά Μεταβαλλόμενα Πεδία (εξισώσεις Maxwell, εξίσωση κύματος, βαθμωτά και διανυσματικά δυναμικά, θεώρημα του Poynting). Επίπεδο Η/Μ κύμα (διάδοση επιπέδου κύματος σε μη αγώγιμα μέσα, πόλωση επιπέδου κύματος, διάδοση επιπέδου κύματος σε μη τέλεια μονωτικά μέσα, το πεδίο μέσα σε αγώγιμα μέσα, εξίσωση διάχυσης, διάδοση επιπέδου κύματος σε τυχούσα διεύθυνση, ταχύτητα ομάδας, θεώρημα της αμοιβαιότητας). Ανάκλαση και διάθλαση επιπέδου κύματος (νόμοι, εξισώσεις Fresnel, ολική ανάκλαση, ενεργειακοί συντελεστές ανάκλασης και διάθλασης, κάθετη και πλάγια πρόσπτωση σε μέσα με απώλειες, στάσιμα κύματα, πρόσπτωση σε διηλεκτρική πλάκα, πίεση ακτινοβολίας, σκέδαση Η/Μ κύματος). Διπολικές γραμμικές κεραίες, κατευθυντικότητα και κέρδος κεραιών, παραδείγματα εφαρμογής. Ομοιόμορφες και Ανομοιόμορφες Στοιχειοκεραίες, Στοιχειοκεραία Yagi-Uda, παραδείγματα εφαρμογής. Κεραίες επιφανείας και κεραίες λήψεως (κεραία σαν δέκτης, ενεργός επιφάνεια κεραίας). Εξίσωση του Friis, εξίσωση Radar, θερμοκρασία κεραίας. Διάδοση στο γήινο χώρο (τροποσφαιρική διάδοση και διάθλαση, φαινόμενα διαλείψεων, ιονοσφαιρική διάδοση, παραδείγματα εφαρμογής).
ΚΕΠ 102	Σύντομη ανασκόπηση της οικονομικής ιστορίας με ιδιαίτερη αναφορά στη διαδοχή των διαφόρων τρόπων παραγωγής και τις σημερινές αναπτυξιακές τάσεις. Η εξέλιξη της οικονομικής σκέψης (θεωρίας) μέχρι σήμερα. Στοιχεία μίκρο- και μάκρο- οικονομικής ανάλυσης.
ΚΕΠ 104	Σύντομη αναδρομή στην ιστορία της φιλοσοφίας. Βασικές φιλοσοφικές κατηγορίες και νόμοι της διαλεκτικής στις περιοχές της θεωρίας της γνώσης, της «οντολογίας» και της λογικής (τυπικής και διαλεκτικής). Στοιχεία κοινωνικής φιλοσοφίας: η δομή της κοινωνίας ως οργανικό όλο, το κοινωνικό συνειδέναι και οι μορφές του. Το φιλοσοφείν ως αυτογνωσία και αυτοσυνειδησία της εκάστοτε εποχής.
ΗΡΥ 301	Τελεστικοί ενισχυτές (ΤΕ), χαρακτηριστικά, απόκριση συχνότητας. Γραμμικά κυκλώματα με ΤΕ, κυκλώματα αθροιστών, διαφοριστών, ολοκληρωτών, φίλτρα. Μη γραμμικά κυκλώματα με ΤΕ, λογαριθμικός ενισχυτής, ανορθωτές. Περιορισμοί των ΤΕ. Λειτουργία των διπολικών τρανζίστορ και τρανζίστορ MOS σε υψηλή συχνότητα. Ανάλυση και σχεδίαση ενισχυτών με τρανζίστορ (ανάδραση, αντιστάθμιση συχνότητας, αντίσταση εισόδου – εξόδου). Διαφορικοί ενισχυτές, διαφορικό ζεύγος. Καθρέπτες ρεύματος, πηγές ρεύματος και τάσης. Ενισχυτές πολλών βαθμίδων. Ενισχυτές ισχύος. Ευστάθεια κυκλωμάτων. Αρμονικοί ταλαντωτές, πολυδονητές, κυκλώματα χρονισμού, συγκριτές. Διαμορφωτές, αποδιαμορφωτές, ανιχνευτές φάσης, VCO, PLL, αναλογικοί διακόπτες, κυκλώματα δειγματοληψίας και συγκράτησης. Οικογένειες ψηφιακών κυκλωμάτων με διπολικά τρανζίστορ (DTL, TTL, ECL) και MOS τρανζίστορ (CMOS). Ολοκληρωμένα κυκλώματα ειδικών συναρτήσεων.
ΠΛΗ 301	Ιστορία και εξέλιξη των λειτουργικών συστημάτων. Ανασκόπηση της οργάνωσης υπολογιστών: CPU, καταχωρητές, MMU, διακοπές, εκτέλεση επί στοίβας. Διεργασίες: ορισμοί, κατάσταση διεργασίας, νήματα, πόροι. Έλεγχος διεργασιών στο Unix. Πίνακας διεργασιών, PCBs, νήματα POSIX. Πολυπρογραμματισμός: ορισμοί, επανεισχωρήσιμος κώδικας. Monitors, έννοιες και υλοποίηση. Semaphores, κλείδωμα αναγνωστών-συγγραφέων, παραγωγοί/καταναλωτές και buffers. Αδιέξοδα. Δρομολόγηση διεργασιών. Διαχείριση μνήμης: ιεραρχία μνήμης, τοπικότητα, caching και προανάκτηση, κατακερματισμός. Δέσμευση μνήμης. Φόρτωση προγραμμάτων. Τμηματοποίηση, σελιδοποίηση. Διαχείριση μνήμης στην αρχιτεκτονική i386. Απεικόνιση μνήμης, copy-on-write. Ιδεατή μνήμη, πολιτικές αντικατάστασης. Είσοδος/Έξοδος (Ε/Ε). Επικοινωνία διεργασιών: ροές και Ε/Ε ροών. Pipes, sockets. Τερματικά. Συσκευές δικτύου και δίσκου. Οδηγοί συσκευών, αρχιτεκτονική. Προγραμματισμός Ε/Ε με polling, νήματα, οδηγούμενος από συμβάντα. Εξωτερική μνήμη: συστήματα αρχείων. Διαχείριση αρχείων και καταλόγων. Μαγνητικοί δίσκοι, μοντέλο απόδοσης, διαμόρφωση, δρομολόγηση Ε/Ε. RAID. Οργάνωση συστήματος αρχείων. Μεταδεδομένα, τήρηση ημερολογίου. Εφεδρικά αντίγραφα. Ασφάλεια: εξουσιοδότηση στο Unix, access control lists. Ταυτοποίηση χρήστη. Κρυπτογραφία, συμμετρικοί και ασύμμετροι κώδικες, RSA.
ΤΗΛ 301	Σύντομη επανάληψη βασικών εννοιών σημάτων και συστημάτων: συνέλιξη, δειγματοληψία. Από δείγματα σε bits – σύντομη περιγραφή ομοιόμορφης κβάντισης, Pulse Code Modulation (PCM). Χώροι συναρτήσεων: γεωμετρική αναπαράσταση του χώρου σημάτων εκπομπής, διάσταση χώρου, συναρτήσεις βάσης, ορθοκανονικές συναρτήσεις, προβολές. Από bits σε κυματομορφές – γραμμική διαμόρφωση – διαμόρφωση PΑΜ, QAM. Ορθοκανονικότητα παλμών – Κριτήριο Nyquist - Παλμοί raised cosine, square-root raised cosine. Επανάληψη βασικών στοιχείων Θεωρίας Πιθανοτήτων. Διακριτά κανάλια: απόφαση ελάχιστης πιθανότητας σφάλματος, κανόνες απόφασης Maximum A Posteriori (MAP), Maximum Likelihood (ML). Σύντομη επανάληψη στοιχείων στοχαστικών διαδικασιών (στασιμότητα, κυκλοστασιμότητα) - συνάρτηση αυτοσυσχέτισης - φασματική πυκνότητα ισχύος - (κυκλο)στάσιμες στοχαστικές διαδικασίες και γραμμικά χρονικά αμετάβλητα συστήματα (περιγραφή στο χρόνο και στις συχνότητες). Ενέργεια, ισχύς και φασματική πυκνότητα ισχύος κυματομορφών PAM και QAM. Σύντομη επανάληψη Gaussian τυχαίας μεταβλητής. Έλεγχος δυαδικής υπόθεσης (binary hypothesis testing) – ανίχνευση ελάχιστης πιθανότητας σφάλματος – κανόνας maximum a posteriori (MAP) - κανόνας μεγίστης πιθανοφάνειας (maximum likelihood) - πιθανότητα σφάλματος δυαδικής ανίχνευσης. Δυαδικά σήματα σε λευκό Gaussian θόρυβο - κανόνας απόφασης MAP - κανόνας ML (κανόνας εγγύτερου γείτονα) - πιθανότητα σφάλματος. Έλεγχος δυαδικής υπόθεσης σε διανυσματικά δεδομένα - κανόνες απόφασης MAP, ML - πιθανότητα σφάλματος. Έλεγχος M-αδικής υπόθεσης (M-ary hypothesis testing) - κανόνες απόφασης MAP, ML – εφαρμογή σε διαμόρφωση 4-PAM, πιθανότητα σφάλματος, 4-QAM, πιθανότητα σφάλματος, 8-PSK, πιθανότητα σφάλματος, φράγμα ένωσης (union bound). Ανίχνευση σημάτων σε κυματομορφές PAM and QAM με λευκό προσθετικό θόρυβο. Σύγκριση διαμορφώσεων - σύγκριση 4-PAM με 4-QAM, 4-QAM με 4-PSK, 16-QAM με 16-PSK, σύγκριση με περιορισμό στην ισχύ εκπομπής, σύγκριση με περιορισμό στο εύρος φάσματος.
ΤΗΛ 311	Εισαγωγή στη στατιστική. Θεωρία απόφασης Bayes, μέθοδοι εκμάθησης με μεγιστοποίηση πιθανότητας (maximum likelihood), εκτίμηση πιθανότητας με την μέθοδο Bayes, expectation maximization algorithm, κρυφά μοντέλα Markov. Γραμμικοί Ταξινομητές, Επιλογή χαρακτηριστικών μοντελοποίησης. Εκμάθηση χωρίς επίβλεψη, αλγόριθμος απόφασης κοντινότερου γείτονα, k-means clustering. Μη γραμμικοί ταξινομητές, αλγόριθμος perceptron, πολυστρωματικά νευρωνικά δίκτυα. Μη μετρικές μέθοδοι ταξινόμησης, δέντρα ταξινόμησης (classification and regression trees). Μετασχηματισμοί χαρακτηριστικών, ανάλυση πρωτευόντων συνιστωσών (PCA). Μοντέλα γράφων (Bayesian networks), μη παραμετρικές μέθοδοι (Parzen windows), support vector machines.
ΜΠΔ 501	Προσομοίωση συστημάτων παραγωγής και γραμμών αναμονής, μοντελοποίηση συστημάτων διακεκριμένων γεγονότων, στατιστικές τεχνικές εκτίμησης μέτρων απόδοσης και σύγκρισης συστημάτων, τεχνικές ελάττωσης της διασποράς, εισαγωγή στην ανάλυση διαταραχών και στη βελτιστοποίηση συστημάτων αναμονής.
ΚΕΠ 101	Εισαγωγή στην Κοινωνιολογία. Αναλυτική και συνθετική μελέτη εννοιών που αφορούν το κοινωνικό πλαίσιο μέσα στο οποίο πραγματοποιείται η παραγωγική δραστηριότητα του ανθρώπου: κοινωνία, κοινωνικές θέσεις και ρόλοι, κοινωνική αλλαγή, κοινωνική διαστρωμάτωση και κινητικότητα, κοινωνικές κατηγορίες και τάξεις, κοινωνικο-πολιτικοί θεσμοί, κοινωνικο-οικονομικοί θεσμοί και μετασχηματισμοί.
ΚΕΠ 203	Η επιστήμη ως κοινωνικο-πολιτισμικό φαινόμενο. Η θέση και ο ρόλος της επιστήμης στη διάρθρωση της κοινωνίας. Ζητήματα θεωρίας της γνώσης, λογικής και μεθοδολογίας στην επιστημονική έρευνα. Οι επιστήμες στην ιστορία. Διαφοροποίηση, ολοκλήρωση της επιστήμης και διεπιστημονικότητα. Νεωτερισμοί και παραδόσεις στην ανάπτυξη της επιστήμης. Το υποκείμενο της επιστημονικής δραστηριότητας. Θεωρίες, κατευθύνσεις, τάσεις και προσεγγίσεις στη φιλοσοφία της επιστήμης.
ΕΝΕ 301	Ανασκόπηση των τρόπων παραγωγής ηλεκτρικής ενέργειας και των συστημάτων μεταφοράς και διανομής. Το Ελληνικό ηλεκτρικό σύστημα, ποσοτικά στοιχεία. Τριφασικά συστήματα (αρχές, σύνδεση αστέρα και τριγώνου). Το σύστημα ανά μονάδα (per-unit). Μονογραμμικό διάγραμμα, μονοφασικό ισοδύναμο. Μαγνητικά πεδία και μαγνητικά κυκλώματα. Μετασχηματιστές ισχύος (αρχές λειτουργίας, ισοδύναμο κύκλωμα, αναγωγή σε πρωτεύον και δευτερεύον). Ηλεκτρομηχανική μετατροπή μηχανικής ενέργειας σε ηλεκτρική. Περιγραφή μηχανών εναλλασσομένου ρεύματος, παλλόμενο και στρεφόμενο μαγνητικό πεδίο, αριθμός πόλων και σύγχρονη ταχύτητα. Σύγχρονες μηχανές (διανυσματικό διάγραμμα και ισοδύναμο κύκλωμα, γωνία ροπής και χαρακτηριστική ενεργού ισχύος, ρεύμα και ΗΕΔ διέγερσης, καταστάσεις λειτουργίας). Επαγωγικές μηχανές (ισοδύναμο κύκλωμα, καμπύλη ροπής-ολίσθησης, λειτουργία κινητήρα και γεννήτριας, εκκίνηση, ρύθμιση στροφών, επίδραση της αντίστασης δρομέα, λειτουργία πέδης). Ροή φορτίου (διατύπωση εξισώσεων και θεμελίωση του προβλήματος, τύποι ζυγών, μέθοδοι επίλυσης).
ΗΡΥ 302	Εισαγωγή στην τεχνολογία υλοποίησης υπολογιστών, η γλώσσα μηχανής ως διεπαφή υλικού και λογισμικού. Εσωτερική οργάνωση επεξεργαστή. Υλοποίηση επεξεργαστή από απλούς δομικούς λίθους (καταχωρητές, πολυπλέκτες, λογικές πύλες). Σχεδίαση datapath και μονάδας ελέγχου. Διακοπές και υποστήριξή τους στη μονάδα ελέγχου. Κρυφές μνήμες (cache memories), εικονική μνήμη. Σύγχρονες υλοποιήσεις επεξεργαστών βασισμένων στη μέθοδο pipelining.
ΤΗΛ 303	Μετατροπή πληροφορίας σε bits:εισαγωγή στη θεωρία κβάντισης και κωδικοποίησης πηγής. Τηλεπικοινωνιακά Συστήματα υπό περιορισμό ισχύος, σύμφωνη και ασύμφωνη διαμόρφωση συχνότητας. Σύγκριση Τηλεπικοινωνιακών Συστημάτων υπό περιορισμό εύρους ζώνης ή υπό περιορισμό ισχύος. Η σημασία της γραμμικότητας των τηλεπικοινωνιακών ηλεκτρονικών. Παράδειγμα σχεδίασης Τηλεπικοινωνιακού Συστήματος με βάση την πιθανότητα σφάλματος, την φασματική πυκνότητα ισχύος και την γραμμικότητα: το κινητό μας τηλέφωνο. Συγχρονισμός συμβόλου (ενέργειας ή με πιλοτικά σύμβολα εκπαίδευσης). Εκτίμηση και γραμμική ισοστάθμιση καναλιού (μέθοδος ελαχίστων τετραγώνων). Εκτίμηση και διόρθωση φέροντος. Εισαγωγή στη Θεωρία Πληροφορίας και νόμος του Shannon. Πολυπλεξία OFDMA και CDMA. Τεχνολογία (Α)DSL. Εξάσκηση σε εργαστηριακή ψηφιακή ζεύξη.
ΤΗΛ 312	Γενικές αρχές και μαθηματική περιγραφή ψηφιακής εικόνας. Αντίληψη εικόνας και αναπαράσταση χρώματος. Δειγματοληψία, μετασχηματισμός Fourier και άλλοι μετασχηματισμοί δύο διαστάσεων. Περιγραφή εικόνας με χρήση ανυσμάτων και τελεστών. Μέθοδοι βελτίωσης εικόνας: ιστόγραμμα, ομαλοποίηση και αύξηση contrast, χαμηλοπερατά και υψιπερατά φίλτρα 2 διαστάσεων. Ανακατασκευή εικόνας με αλγεβρικές και στοχαστικές μεθόδους. Βέλτιστα φίλτρα, σύγκριση και εφαρμογές. Αρχές συμπίεσης και κωδικοποίησης εικόνας. Αρχές ανάλυσης εικόνας και μέθοδοι τμηματοποίησης.
ΤΗΛ 313	Το μάθημα είναι μια εισαγωγή στους τομείς της επεξεργασίας ήχου (audio processing) και επεξεργασίας μουσικής (music processing) για το μηχανικό. H περιοχή της επεξεργασίας ήχου και μουσικής είναι διεπιστημονικές και περιλαμβάνουν: μαθηματικά (θεωρία μουσικής), φυσική της παραγωγής και μετάδοσης ήχου, αντίληψη μουσικής από τον άνθρωπο (perception, cognition), και, κυρίως, επεξεργασία σήματος και αναγνώριση προτύπων. Το μάθημα ξεκινά με μια εισαγωγή στα μαθηματικά της μουσικής (μουσική θεωρία). Η μουσική θεωρία εξηγείται γνωστικά (θεωρία μουσικής αντίληψης, δηλαδή, πώς το αυτί και ο εγκέφαλος αντιλαμβάνεται τη μουσική). Στη συνέχεια παρουσιάζουμε την φυσική της παραγωγής μουσικής και της διάδοσης ήχου (η φυσική των μουσικών οργάνων καλύπτεται επιφανειακά, εδώ). Τα κύρια εργαλεία ανάλυσης και μοντελοποίησης που χρησιμοποιούνται στο μάθημα είναι: μετασχηματισμός Fourier, σχεδιασμός φίλτρων, ταξινόμηση, μείγμα Gaussian μοντέλων (GMM) και κρυφά μοντέλα Markov (HMM). Οι κύριοι τομείς επεξεργασίας μουσικής που καλύπτονται στο μάθημα είναι: μουσική ανάλυση (τα συστατικά της μουσικής, θεμελιώδης συχνότητα), μουσικοί χάρτες (music maps), κωδικοποίησης ήχου / μουσικής (PAC, mp3), αναγνώριση μουσικής (μετατροπή από ήχο σε παρτιτούρα), μουσική σύνθεση (από παρτιτούρα σε ήχο), ηχητικά εφέ. Οι τομείς της μουσικής σύνθεσης (composition) και παραγωγής μουσικής περιγράφονται εν συντομία. Οι κύριες εφαρμογές επεξεργασίας ήχου με πολλαπλά μικρόφωνα που παρουσιάζονται στο μάθημα: ακύρωσης ηχούς (echo cancellation), dereverberation, blind source separation. Το μάθημα ολοκληρώνεται με την παρουσίαση εφαρμογών μουσικής και ήχου, εφαρμογές στο διαδίκτυο (π.χ., ανάκτηση μουσικής πληροφορίας) και συστήματα επεξεργασίας ήχου.
ΜΑΘ 203	Μη γραμμικές διαφορικές εξισώσεις πρώτης τάξης και εφαρμογές. Μέθοδοι επίλυσης γραμμικών διαφορικών εξισώσεων ανώτερης τάξης (προσδιοριστέων συντελεστών, μεταβολής των παραμέτρων.) Συστήματα γραμμικών διαφορικών εξισώσεων. Επίλυση με διαγωνιοποίηση πινάκων. Ιδιοδιανύσματα, ιδιοτιμές. Μελέτη ευστάθειας - διαγράμματα φάσης. Μη γραμμικά πρωτοτάξια συστήματα διαφορικών εξισώσεων, ευστάθεια των σημείων ισορροπίας. Επίλυση γραμμικών διαφορικών εξισώσεων με τη μέθοδο των δυναμοσειρών.
ΚΕΠ 202	Εισαγωγή σε βασικές έννοιες σχετικές με τον Πολιτισμό, προερχόμενες από επιμέρους κλάδους των κοινωνικών επιστημών (κοινωνιολογία, ανθρωπολογία, φιλοσοφία, ιστορία). Περαιτέρω αναλυτική και συνθετική προσέγγιση ζητημάτων που αφορούν την ιστορία του πολιτισμού γενικά και ειδικότερα ορισμένες κρίσιμες περιόδους: Ανατολικές δεσποτείες, Αρχαία Ελλάδα, Δυτικοευρωπαϊκός Μεσαίωνας, Αναγέννηση κ.α. Κριτική ανασκόπηση θεωριών που επιχειρούν να ερμηνεύσουν το σύγχρονο πολιτισμό: συμπεριφορισμός, μεταμοντερνισμός, κλπ.
ΕΝΕ 401	Ατμοηλεκτρικοί σταθμοί παραγωγής (αναθέρμανση, υπερθέρμανση). Αεριοστρόβιλοι. Υδροηλεκτρικοί σταθμοί παραγωγής (καμπύλη διάρκειας παροχής, τύποι υδροστροβίλων, υδροηλεκτρικά έργα). Εισαγωγή στις μηχανές εσωτερικής καύσης. Μονάδες συνδυασμένου κύκλου. Διεσπαρμένη παραγωγή. Περιβαλλοντικές επιπτώσεις. Μεταφορά και διανομή ηλεκτρικής ενέργειας (αρχές λειτουργίας, τύποι δικτύων, ροή φορτίου, ρύθμιση συχνότητας/τάσης και αντιστάθμιση άεργου ισχύος, εξοπλισμός και κατασκευή). Κέντρα ελέγχου ενέργειας (βασικές αρχές βιομηχανικού αυτοματισμούς, συστήματα εποπτικού ελέγχου και συλλογής δεδομένων (SCADA), αξιοπιστία και ευστάθεια ηλεκτρικών συστημάτων ενέργειας). Ηλεκτρική οικονομία (κοστολόγηση και τιμολόγηση ηλεκτρικής ενέργειας).
ΠΛΗ 401	Μοντέλα και έννοιες πολυπλοκότητας. Εισαγωγή στα διακριτά μαθηματικά για ανάλυση αλγορίθμων. Ασυμπτωτικό κόστος. Αναδρομή και αναδρομικές εξισώσεις, λύση με επαγωγή, master theorem. Θεμελιώδεις αναδρομικοί αλγόριθμοι: πολλαπλασιασμός, αλγόριθμος Karatsuba, FFT. Στατιστικές τάξης. Δυναμικός προγραμματισμός, απομνημόνευση. Το πρόβλημα Knapsack. Μη-ντετερμινισμός, θεώρημα του Cook, οι κλάσεις P και NP, NP-πληρότητα. Επιμερισμένη πολυπλοκότητα, επιμερισμένο κόστος σε βασικές δομές δεδομένων. Αναζήτηση εύρους σε διατεταγμένα σύνολα, δομές δεδομένων για πολυδιάστατη αναζήτηση εύρους. Εισαγωγή στη θεωρία γράφων. Δομές δεδομένων για αναπαράσταση γράφων. Διασχίσεις γράφων, κατά βάθος και κατά πλάτος διάσχιση, διάσχιση άκυκλων κατευθυνόμενων γράφων, τοπολογική ταξινόμηση. Συνδεδεμένα τμήματα. Βεβαρυμένοι γράφοι. Ελάχιστα επικαλύπτοντα δέντρα, αλγόριθμοι των Prim και Kruskal. Το πρόβλημα ένωσης-αναζήτησης. Η συνάρτηση του Ackerman. Συντομότερα μονοπάτια και μετρικές απόστασης. Τριγωνική ανισότητα. Αναπαράσταση συντομότερων μονοπατιών από πηγή και όλων των ζευγών. Ο αλγόριθμος Bellman-Ford. Ο αλγόριθμος του Dijkstra. Μεταβατική κλειστότητα. Ο αλγόριθμος του Johnson. Ο αλγόριθμος των Floyd-Warshall.
ΕΚΠ 413	Eπεξεργασία, αρχειοθέτηση και αναζήτηση πολυμεσικής (multimedia) πληροφορίας κειμένου, μονοδιάστατου σήματος, στατικής και κινούμενης εικόνας (video) σε πληροφοριακά συστήματα και το διαδίκτυο. Κλασικά μοντέλα ανάκτησης πληροφορίας (δυαδικό, σχεσιακό, πιθανοτικό). Ομαδοποίηση πληροφορίας (clustering), αλγόριθμοι ομαδοποίησης (διαιρετικοί, ιεραρχικοί, υβριδικοί αλγόριθμοι), εφαρμογές ομαδοποίησης σε συλλογές κειμένων. Παράσταση περιεχομένου μονοδιάστατων σημάτων και εικόνας σε συστήματα πολυμέσων. Εξαγωγή χαρακτηριστικών και παράσταση περιεχομένου χρώματος, υφής, σχήματος και χωρικών σχέσεων σε εικόνες. Μέθοδοι ανάκτησης για μονοδιάστατα σήματα και εικόνα, σύστημα QBIC. Τεχνικές δεικτοδότησης (indexing) σε πληροφοριακά συστήματα για κείμενο και πολυμεσική πληροφορία (ανεστραμμένα αρχεία, k-d-Trees, Grid files, R-trees, fractals), μείωση χώρου διαστάσεων (dimensionality reduction), τεχνικές Karhunen-Lowe (K-L), singular value decomposition (SVD), FastMap. Σχεδιασμός πληροφοριακών συστημάτων στο διαδίκτυο, διαχείριση και ανάλυση πληροφορίας στο διαδίκτυο (μέθοδοι PageRank, HITS). Σημασιολογικός ιστός, οντολογίες και σχετικές τεχνολογίες (RDF, OWL), εφαρμογές σε πληροφοριακά συστήματα (ιατρικές εφαρμογές, οντολογίες πολυμέσων), ανάκτηση με χρήση σημασιολογίας πληροφορίας και σημασιολογική ομοιότητα, λεξικά WordNet, UMLS Semantic Network/MeSH. Βασικές τεχνικές επεξεργασίας και ανάλυσης στατικής και κινούμενης εικόνας (video) σε πληροφοριακά συστήματα. Τεχνικές συμπίεσης (compression) JPEG, πρότυπα MPEG-1, 2, 4, 7.
ΣΥΣ 401	Εισαγωγή στη θεωρία γραμμικών συστημάτων, μελέτη και μοντελοποίηση συστημάτων με βάση το χώρο καταστάσεων, παραδείγματα από επεξεργασία σημάτων, εικόνες, κ.λπ. Εφαρμογές σε συστήματα συνεχούς και διακριτού χρόνου, μέθοδοι ανάλυσης, ελεγξιμότητα και παρατηρησιμότητα, μέθοδοι πραγματώσεως (realization) ελάχιστης διάστασης, στοιχεία από μεθόδους σχεδίασης γραμμικών συστημάτων. Μοντελοποίηση δυναμικών συστημάτων. Μεταβατική απόκριση συστημάτων (transient response analysis). Βασικές δράσεις ελέγχου και απόκριση συστημάτων ελέγχου (basic control actions and response of control systems). Ανάλυση με την μέθοδο του γεωμετρικού τόπου (root locus analysis). Σχεδίαση συστημάτων με την μέθοδο του γεωμετρικού τόπου. Ανάλυση με την μέθοδο της απόκρισης συχνότητας. Σχεδίαση με την μέθοδο της απόκρισης συχνότητας.
ΤΗΛ 401	Εισαγωγή στον τρόπο λειτουργίας των δικτύων επικοινωνίας υπολογιστών. Αρχές σχεδιασμού δικτύων επικοινωνίας υπολογιστών (αρχιτεκτονική και υπηρεσίες δικτύου, κατηγορίες υπηρεσιών επικοινωνίας, μεταγωγή και πολύπλεξη, το πρότυπο OSI). Φυσικό επίπεδο: Ανίχνευση και διόρθωση σφαλμάτων. Επίπεδο ζεύξης δεδομένων: Πρωτόκολλα ζεύξης δεδομένων, πρωτόκολλο εναλλασσόμενου bit, πρωτόκολλο επιλεκτικής επανάληψης, πρωτόκολλο οπισθοχώρησης κατά Ν, μελέτη απόδοσης των πρωτοκόλλων. Τοπικά δίκτυα – υποεπίπεδο ελέγχου προσπέλασης μέσου: Πρωτόκολλο ALOHA, Ethernet, δίκτυα δακτυλίου με κουπόνι, αλγόριθμος δέντρου. Επίπεδο δικτύου: Δρομολόγηση, έλεγχος συμφόρησης, επίπεδο δικτύου στο Internet – πρωτόκολλο ΙΡ, διευθύνσεις ΙP. 
ΗΡΥ 411	Ενσωματωμένες εφαρμογές, παραδείγματα από τη σύγχρονη αγορά (φρένα ABS, κινητά τηλέφωνα, οικιακές συσκευές κ.λπ.). Μέθοδοι σχεδίασης ενσωματωμένων συστημάτων. Προγραμματισμός Κινητών τηλεφώνων (iPhone και Android). Τεχνολογικός χώρος σχεδίασης, θέματα κατανάλωσης ισχύος και μέθοδοι διαχείρισης ισχύος, συστήματα τροφοδοσίας με μπαταρίες, υπολογισμός αυτονομίας συστήματος. Μέθοδοι συσχεδίασης υλικού-λογισμικού, μοντελοποίηση συστήματος. Ασφάλεια ενσωματωμένων συστημάτων. Μέθοδοι αλλαγής προγράμματος ενσωματωμένων συστημάτων. Σχεδίαση και υλοποίηση ενσωματωμένων συστημάτων σε αναδιατασσόμενη λογική.
ΗΡΥ 412	Φύση και διάδοση του φωτός και στοιχεία οπτικής (ανάκλαση, διάθλαση, περίθλαση, φακοί κάτοπτρα γεωμετρική οπτική, πόλωση), οπτικοί διαμορφωτές (ηλεκτροοπτικό φαινόμενο, ηλεκτροοπτικός διαμορφωτής Pockels, διαμορφωτής kerr, μαγνητο-οπτικές διατάξεις, ακουστο-οπτικός διαμορφωτής), οθόνες (φωταύγεια, οθόνες LED, LCD, πλάσματος, λειτουργικά χαρακτηριστικά οθονών, αναδυόμενες τεχνολογίες οθονών), lasers (ακτινοβολία μέλανος σώματος, θερμοδυναμική προσέγγιση Einstein, αντιστροφή πληθυσμών, κατασκευαστικά και λειτουργικά χαρακτηριστικά laser, άντληση, οπτικό αντηχείο, χαρακτηριστικά δέσμης laser, απώλειες, παράγοντας Q, μετατροπή παράγοντα Q, εγκλείδωση τρόπου ταλάντωσης, παλμική και συνεχής λειτουργία laser, είδη laser, βιοϊατρικές και βιομηχανικές εφαρμογές laser), φωτοανιχνευτές (χαρακτηριστικές λειτουργικές παράμετροι, θερμικοί αισθητήρες/κάμερες,, φωτοκύτταρα, φωτοπολλαπλασιαστές, ενισχυτές απεικονιστικού σήματος, φωτοδίοδος, φωτοτρανζίστορ, απεικονιστικές διατάξεις συζευγμένου φορτίου (CCD) και σχετικές αρχιτεκτονικές, ψηφιακές κάμερες, οπτικές ίνες (οπτικοί κυματοδηγοί επίπεδης και κυλινδρικής γεωμετρίας, διασπορά και απώλειες σε οπτικές ίνες, κατασκευή οπτικών ινών, νέες τεχνολογίες οπτικών ινών, κοπή και συγκόλληση οπτικών ινών), τηλεπικοινωνίες οπτικών ινών (δομή τηλεπικοινωνιακού δικτύου, διακλάδωση, πολυπλεξία/αποπολυπλεξία, οπτικοί ενισχυτές, ανάταξη διασποράς, αρχιτεκτονικές/τοπολογίες τηλεπικοινωνιακών συστημάτων οπτικών ινών, παράγοντες αξιολόγησης οπτικών τηλεπικοινωνιακών συστημάτων).
ΠΛΗ 411	Ανάπτυξη γλωσσών προγραμματισμού. Προσδιορισμός σύνταξης (syntax specification), type systems, type interface, χειρισμός εξαιρέσεων (exception handling), απόκρυψη πληροφορίας (information hiding), δομημένη αναδρομή (structural recursion), διαχείριση και αποθήκευση δεδομένων προγράμματος (run-time storage management). Μη δομημένος προγραμματισμός, όπως συναρτησιακός προγραμματισμός με Lisp, Scheme, ML και λογικός προγραμματισμός με Prolog.
ΕΚΠ 412	Το μάθημα είναι μία εισαγωγή σε αρχές αλληλοεπίδρασης ανθρώπων και υπολογιστών και της χρήσης της για σχεδιασμό και αξιολόγηση των διαπροσωπιών (interfaces) των εφαρμογών. Επισκόπηση της αρχής των αλληλοεπιδράσεων, το Memex, graphic pen, mouse, “the demo that changed the world”, έρευνα σε SRI, Xerox PARC και Apple. Ψυχολογία της αλληλοεπίδρασης με αντικείμενα, νοητικά μοντέλα, λογικά μοντέλα, μεταφορές. Ο ανθρώπινος επεξεργαστής, μοντέλα για αντίληψη (perception), κατάληψη (cognition), μνήμη, μηχανική κίνηση, GOMS. Μοντέλα γιά σχεδιασμό και αξιολόγηση διαπροσωπιών εφαρμογών. Σχεδιασμός επικεντρωμένος σε tasks. Χρηστικότητα (usability), εκτίμηση χρηστικότητας. Usability testing, think aloud, usability inspection, heuristic evaluation, cognitive walkthroughs. Σχεδιασμός και δημιουργικότητα. Brainstorming, personas, wireframing, storyboarding, paper prototyping, software prototyping. Αρχές οπτικοποίησης της πληροφορίας (visualization).
ΣΥΣ 414	Εισαγωγή στα νευρωνικά δίκτυα. Multilayered Feedforward νευρωνικά δίκτυα. Ο αλγόριθμος Back Propagation. Recurrent νευρωνικά δίκτυα. Self Organizing νευρωνικά δίκτυα. Συσχετιστικές μνήμες. Παραδείγματα ολοκληρωμένης σχεδίασης ευφυών συστημάτων με νευρωνικά δίκτυα. 
ΕΚΠ 414	Βασικές αρχές και μεθοδολογία της μηχανικής όρασης με έμφαση σε αλγορίθμους και εφαρμογές της μηχανικής όρασης. Σχηματισμός εικόνας (image formation), μαθηματικό, γεωμετρικό, χρωματικό, συχνοτικό, διακριτό μοντέλο. Βασικές τεχνικές επεξεργασίας εικόνας (φιλτράρισμα, ενίσχυση, ομαλοποίηση). Υπολογισμός ακμών (edge detection), τελεστές πρώτης και δευτέρας παραγώγου. Κατάτμηση εικόνας (image segmentation), μέθοδοι κατάτμησης περιοχών και ακμών, ενίσχυση ακμών και περιοχών, τεχνικές κατωφλίου. Προχωρημένες τεχνικές κατάτμησης (συγχώνευση και διάσπαση περιοχών και ακμών, χαλαρωτική ταξινόμηση, τεχνική Hough). Τεχνικές επεξεργασίας δυαδικών (binary) εικόνων, μετασχηματισμοί απόστασης, μορφολογικοί τελεστές, ταυτοποίηση περιοχών (labeling). Ανάλυση, αναπαράσταση και αναγνώριση εικόνων. Παραστάσεις χρώματος, υφής ακμών και περιοχών, παράσταση και αναγνώριση σχημάτων, παράσταση και αναγνώριση δομικού περιεχομένου εικόνων. Ανάλυση και αναγνώριση υφής, δομικές και στατιστικές μέθοδοι. Δυναμική όραση, υπολογισμός κίνησης, οπτικής ροής και τροχιές. Βασικές τεχνικές επεξεργασίας και ανάλυσης στατικής και κινούμενης εικόνας (video) σε πληροφοριακά συστήματα. Τεχνικές συμπίεσης (compression) jpeg, πρότυπα mpeg-1,2,4,7.
ΣΥΣ 411	Εισαγωγή στα ασαφή σύνολα και στην ασαφή λογική, ασαφείς συσχετίσεις, θεωρία προσεγγιστικού συλλογισμού, συστήματα βασισμένα σε ασαφείς κανόνες, μηχανισμοί ασαφών αποφάσεων, εφαρμογές ασαφούς λογικής σε αυτόματο έλεγχο, αναγνώριση προτύπων.
ΤΗΛ 411	Ανάλυση φωνής. Ψηφιακό μοντέλο παραγωγής φωνής. Μετασχηματισμός Fourier βραχέως χρόνου. Ανάλυση γραμμικής πρόβλεψης. Σύγχρονες τεχνικές κωδικοποίησης φωνής και διεθνή πρότυπα ψηφιακής και κινητής τηλεφωνίας. Σύνθεση φωνής. Εισαγωγή στην αναγνώριση φωνής και τα κρυφά Μαρκοβιανά μοντέλα. Στατιστικά γλωσσικά μοντέλα. Εφαρμογές αναγνώρισης και σύνθεσης φωνής και η γλώσσα VoiceXML.
ΣΥΣ 513	Μοντέλα διαδικασιών. Κριτήρια συμπεριφοράς. Περιορισμοί ασφαλούς λειτουργίας. Προδιαγραφές ποιότητας. Συναρτήσεις σφαλμάτων. Θεωρητικά όρια απόδοσης. Γραμμικοί ελεγκτές. PID ελεγκτές. Model-based ελεγκτές. Ρύθμιση ελεγκτών (controller tuning). Μέθοδοι Μέθοδοι χειροκίνητης ρύθμισης. Αυτόματη ρύθμιση και προσαρμογή. Στοιχεία μη γραμμικών ελεγκτών. Παραδείγματα σχεδίασης συστημάτων ελέγχου.
ΤΗΛ 412	Σύνδεση, Σύνθεση & Συμπλήρωση (3Σ) βασικών θεωρητικών γνώσεων τηλεπικοινωνιακού μηχανικού, με ταυτόχρονη πειραματική εξάσκηση σε πραγματικό περιβάλλον. Στοιχεία πομποδεκτών και παράμετροι συστήματος. Παράμετροι δέκτη: noise figure, compression point (IP2), intermodulation and third-order intercept point (IP3), spurious receiver response. Παράμετροι πομπού: frequency stability and spurious signals, output power efficiency, intermodulation. Αρχιτεκτονικές δεκτών: ετερόδυνοι, ομόδυνοι, δέκτες υποδειγματοληψίας. Πομποδέκτες ελεγχόμενοι από λογισμικό (SDR): βασικά χαρακτηριστικά και περιορισμοί. Στοιχεία θεωρίας κυμάτων, γραμμών μεταφοράς και κεραιών. Σύνθεση τηλεπικοινωνιακών διατάξεων: υπερ-ετερόδυνος δέκτης σε διάγραμμα συστήματος και σε κυκλωματικό επίπεδο ηλεκτρονικών. Εργαστηριακή εξάσκηση: υλοποίηση χαμηλού κόστους, υψηλής απόδοσης ψηφιακού link ελεγχόμενου από λογισμικό (embedded SDR), υλοποίηση δικτύου, τυπωμένο κύκλωμα (PCB), project εξαμήνου.
ΤΗΛ 413	Διανύσματα, ευθείες, επίπεδα, καμπύλες, επιφάνειες. Συναρτήσεις πολλών μεταβλητών: ορισμός, γράφημα, ισο-υψείς επιφάνειες, μερικές παράγωγοι, κλίση (gradient), παράγωγος κατά κατεύθυνση, εφαπτόμενο επίπεδο, δεύτερη παράγωγος (Hessian), προσεγγίσεις Taylor. Κυρτά σύνολα (ορισμός, βασικές ιδιότητες, παραδείγματα). Κυρτές συναρτήσεις (ορισμός, βασικές ιδιότητες, παραδείγματα). Προβλήματα κυρτής βελτιστοποίησης: χαρακτηρισμός βέλτιστων λύσεων, Λήμμα Farkas, εξισώσεις Fritz John (FJ), εξισώσεις Karush-Kuhn-Tucker (KKT). Βελτιστοποίηση χωρίς περιορισμούς: χαρακτηρισμός βέλτιστων λύσεων, αλγόριθμοι υπολογισμού βέλτιστων λύσεων: αλγόριθμος gradient, προβλήματα ελαχίστων τετραγώνων, αλγόριθμος Newton, ταχύτητα σύγκλισης, αριθμητική πολυπλοκότητα αλγορίθμων. Βελτιστοποίηση με περιορισμούς γραμμικών ισοτήτων, συνθήκες KKT, τετραγωνικό πρόβλημα με περιορισμούς γραμμικών ισοτήτων, αλγόριθμοι τύπου Newton για την ελαχιστοποίηση κυρτής συνάρτησης υπό γραμμικούς περιορισμούς ισοτήτων. Βελτιστοποίηση με περιορισμούς “κυρτών” ανισοτήτων, συνθήκες ΚΚΤ, συνάρτηση logarithmic barrier, μέθοδος εσωτερικού σημείου (interior point). Βελτιστοποίηση με περιορισμούς γραμμικών ισοτήτων και “κυρτών” ανισοτήτων. Δυϊκότητα κατά Lagrange. Εφαρμογές.
ΤΗΛ 417	Σύντομη ιστορική αναδρομή ασύρματων επικοινωνιών. Μοντέλα ασύρματων καναλιών: διάδοση σε ελεύθερο χώρο, ασύρματα κανάλια 2-ακτίνων, M-ακτίνων, εμπειρικά μοντέλα path loss (Okumura, Hata), σκίαση, μοντέλο χρονικά μεταβαλλόμενου γραμμικού συστήματος, επίπεδο κανάλι στενής ζώνης, μοντέλα Rayleigh, Rice, κανάλι ευρείας ζώνης (επιλογής συχνοτήτων). Υπολογισμός μέσης πιθανότητας σφάλματος σε επίπεδα κανάλια διαλείψεων. Διαφοροποίηση στο χρόνο, στο χώρο, στις συχνότητες, υπολογισμός μέσης πιθανότητας σφάλματος. Στοιχεία Code Division Multiple Access (CDMA). Στοιχεία Orthogonal Frequency Division Multiplexing (OFDM). Στοιχεία GSM, IS-95.
ΚΕΠ 201	Ανάλυση της προσφοράς-ζήτησης εμπορευμάτων, η θεωρία του καταναλωτή και της επιχείρησης. Θέματα μακροοικονομίας για τον προσδιορισμό του εισοδήματος και της απασχόλησης, το ρόλο των επενδύσεων και την επίδραση των διεθνών συναλλαγών.
ΚΕΠ 204	Γενική εισαγωγή στο δίκαιο, βασικές διακρίσεις δικαίου, στοιχεία δημοσίου δικαίου και ευρωπαϊκού κοινοτικού δικαίου. Στοιχεία αστικού δικαίου (γενικές αρχές, ενοχικό δίκαιο, εμπράγματο δίκαιο). Στοιχεία εργατικού δικαίου, εμπορικού δικαίου, βιομηχανική ιδιοκτησία (σήμα, ευρεσιτεχνία), πνευματική ιδιοκτησία, στοιχεία δικαίου του περιβάλλοντος. Στοιχεία δικαίου των δημοσίων έργων (η ανάθεση και εκπόνηση μελετών δημοσίων έργων, η ανάθεση και κατασκευή δημοσίων έργων, το εργολαβικό αντάλλαγμα, η παραλαβή του δημοσίου έργου, η συμβατική ευθύνη των μερών, η διοικητική και δικαστική επίλυση των διαφορών, η οργάνωση των εργοληπτών δημοσίων έργων)
ΠΛΗ 402	Σύνολα, σχέσεις, αλφάβητα, γλώσσες. Πεπερασμένα αυτόματα, κανονικές εκφράσεις, κανονικές γλώσσες. Ισοδυναμία πεπερασμένων αυτομάτων και κανονικών εκφράσεων. Ελαχιστοποίηση αυτομάτων. Λεκτική ανάλυση. Αυτόματα στοίβας, γραμματικές χωρίς συμφραζόμενα, γλώσσες χωρίς συμφραζόμενα. Ισοδυναμία αυτομάτων στοίβας και γραμματικών χωρίς συμφραζόμενα. Συντακτική ανάλυση. Μηχανές Turing και επεκτάσεις τους, γραμματικές χωρίς περιορισμούς, αναδρομικές γλώσσες. Μη ντετερμινισμός, μη ντετερμινιστικές μηχανές Turing, αναδρομικά απαριθμήσιμες γλώσσες. Ιεραρχία γλωσσών. Αποφασισιμότητα, υπολογισιμότητα, μη επιλυσιμότητα. Η θέση των Church και Turing. Καθολικές μηχανές Turing, αναγωγές. Το θεώρημα του Rice. Υπολογιστική πολυπλοκότητα και κλάσεις πολυπλοκότητας. NP-πληρότητα και πολυωνυμικές αναγωγές. Το θεώρημα του Cook. Αντιμετώπιση NP-πληρότητας. Εφαρμογή στο πρόβλημα της μεταγλώττισης και εργαστηριακή διδασκαλία των εργαλείων flex, bison, JavaCC.
ΣΥΣ 514	Προβλήματα χρονοπρογραμματισμού (scheduling) και δρομολόγησης (routing). Βιομηχανική βελτιστοποίηση. Έλεγχος QoS control για εφαρμογές πολυμέσων. Έλεγχος κυκλοφορίας σε δίκτυα ATM. Ισοστάθμιση και ανάθεση καναλιών. Νευρωνικά δίκτυα για αναγνώριση χαρακτήρων και ανάλυση εγγράφων. 
ΣΥΣ 402	Εισαγωγή και μελέτη των κλασσικών συστημάτων ελέγχου, μοντελοποίηση συστημάτων με βάση τη συνάρτηση μεταφοράς, ανάλυση και σύνθεση των συστημάτων με τη βοήθεια κλασσικών μεθόδων, εφαρμογή των διαγραμμάτων Bode, Nyquist, Nichols για τη σχεδίαση αντισταθμιστών, παραδείγματα εφαρμογών σε έλεγχο πλοίων, αεροσκαφών, κλπ. Χρήση πακέτων λογισμικού που έχουν αναπτυχθεί για τον έλεγχο συστημάτων. Ο ελεγκτής PID και εισαγωγή στον εύρρωστο έλεγχο. Ανάλυση των συστημάτων ελέγχου στον χώρο των καταστάσεων. Σχεδίαση συστημάτων στον χώρο των καταστάσεων. 
ΕΝΕ 411	Σχεδίαση ηλεκτρολογικών δικτύων, κάτοψη ηλεκτρολογικού δικτύου, ανάπτυγμα ηλεκτρικού πίνακα. Ηλεκτρικές εγκαταστάσεις κτιρίων, βιομηχανίας και εξοπλισμού χαμηλής και μέσης τάσης. Κανονισμοί και ασφάλεια ατόμων και εξοπλισμού. Σχεδιασμός με χρήση πακέτων λογισμικού. Γειώσεις (ορισμοί, σχεδιασμός, υπολογισμοί).
ΕΝΕ 412	Μεταβατικά μοντέλα και αντιστάσεις ακολουθίας γεννητριών, μετασχηματιστών και επαγωγικών κινητήρων. Μεταβατικές και υπομεταβατικές αντιδράσεις και χρονικές σταθερές. Μετασχηματισμός Park. Ακολουθιακά κυκλώματα – σχέση φασικού διανύσματος και ανάλυση dq0 συνιστωσών. Ασύμμετρα τριφασικά συστήματα. Ισχύς βραχυκύκλωσης δικτύων. Υπολογισμοί ρευμάτων και τάσεων βραχυκυκλωμάτων (τριφασικά, διφασικά, διφασικά ως προς γη, μονοφασικά). Ποιότητα ισχύος (ορισμός σχετικών προβλημάτων, μέθοδοι εκτίμησης και υπολογισμού, διατάξεις περιορισμού τέτοιου είδους προβλημάτων).
ΗΡΥ 414	Αρχές ηλεκτρικών μετρήσεων. Αναλογική επεξεργασία σήματος (ενίσχυση, περιορισμός, φιλτράρισμα, γραμμικοποίηση, μετατόπιση στάθμης, συσχετισμός, απόρριψη κοινού σήματος, γαλβανική απομόνωση, δειγματοληψία, συγκράτηση, συμπίεση, κλπ.). Εξουδετέρωση επιδράσεων (θερμοκρασίας, υγρασίας, θορύβου, θερμοηλεκτρικού φαινομένου, ηλεκτρομαγνητικής, επαγωγικής, χωρητικής, βρόχου γείωσης, κλπ.). Μετατροπή ψηφιακού σήματος σε αναλογικό (D/A), μετατροπή αναλογικού σήματος σε ψηφιακό (A/D). Επεξεργασία του ψηφιακού σήματος με μP, PC ή DSP). Μετατροπείς και είδη μετατροπέων (μετατόπισης, δύναμης, ταχύτητας, επιτάχυνσης, ισχύος, έντασης μαγνητικού πεδίου, συχνότητας, στάθμης υγρών, παροχής, πίεσης ρευστών, κ.λπ.). Αισθητήρες και είδη αισθητήρων (θερμοκρασίας, διεύθυνσης-ταχύτητας ανέμου, υγρασίας, βαρομετρικής πίεσης, κ.λπ.). Ανιχνευτές και είδη ανιχνευτών (προσέγγισης, μικροκυμάτων, φωτός, καπνού, πυρός, κ.λπ.). Ενεργοποιητές και είδη ενεργοποιητών. Μετατροπείς στην βιοϊατρική, μικροαισθητήρες, διατάξεις αισθητήρων, δίκτυα αισθητήρων, ευφυείς αισθητήρες. Συστήματα διεπικοινωνίας αισθητήρων με υπολογιστή, παράλληλη και σειριακή διεπικοινωνία, διεπικοινωνία με USB, DMA, το πρότυπο IEEE488 (GPIB), το πρότυπο I2C, το πρότυπο CAN, διεπικοινωνία μέσω modem, διεπικοινωνία μέσω Ethernet, διεπικοινωνία μέσω Internet. Αναλογικοί και ψηφιακοί πολυπλέκτες. Συλλογή και καταγραφή μετρήσεων. Αυτοματοποιημένες μετρήσεις. Συστήματα ελέγχου με αισθητήρες. Θεωρία σφαλμάτων των μετρήσεων.
ΗΡΥ 415	Αρχές σχεδίασης υπολογιστικών συστημάτων, αρχιτεκτονική συνόλου εντολών: κόστος, επιδόσεις, συχνότητα χρήσης, τύποι συνόλου εντολών. Ποσοτική αξιολόγηση επιδόσεων υπολογιστών μέσω μετροπρογραμμάτων (benchmark). Ομοχειρία (pipeline) σταθερού και μεταβλητού μήκους: χρήση πόρων υλικού, αλληλεξαρτήσεις, προσπέρασμα (bypassing), καθυστερημένες διακλαδώσεις, πρόβλεψη διακλαδώσεων, διακοπές/εξαιρέσεις. Εκτέλεση πολλαπλών εντολών ανά κύκλο - υπερβαθμωτοί υπολογιστές, εκτέλεση εκτός σειράς, ομοχειρία λογισμικού. Συστήματα μνήμης: κρυφή μνήμη (cache), οι παράμετροί της και η επίδρασή τους στην επίδοση, εικονική (virtual) μνήμη, μετάφραση διευθύνσεων, προστασία, TLB. Πολυπύρινοι επεξεργαστές. Συστήματα εισόδου/εξόδου.
ΗΡΥ 417	Μέθοδοι υλοποίησης, ταχεία ανάπτυξη συστημάτων (RSP), το μοντέλο του καταρράκτη. Διαχείριση έργου με PERT Charts, υπολογισμός κόστους συστημάτων, θέματα χρόνου ανάπτυξης (time to market). Σχεδίαση με αποσύνθεση και κατάτμηση συστημάτων, top down και bottom up σχεδιαστικές μέθοδοι. Επαναχρησιμοποιησιμότητα υποσυστημάτων, εξειδικευμένες αρχιτεκτονικές, τεχνολογική απεικόνιση (technology mapping). Ανάλυση ισχύος, θερμική ανάλυση, σχεδίαση για αξιοπιστία. Προστασία πνευματικής ιδιοκτησίας, πατέντες, trade secrets. Μηχανισμοί προώθησης καινοτομικών ιδεών στην αγορά (εταιρίες startup, κ.λπ.).
ΗΡΥ 418	Εισαγωγή στις παράλληλες αρχιτεκτονικές υπολογιστών: μοντέλα εκτέλεσης SIMD, MIMD, κοινόχρηστη μνήμη, επικοινωνία με μηνύματα, δίκτυα διασύνδεσης υπολογιστών. Αρχιτεκτονικές κοινόχρηστης μνήμης, caching, τεχνικές πλεονασμού, συνοχή μνημών cache (coherence), τεχνικές snooping και directory. Μοντέλα συνέπειας μνήμης (Memory consistency). Δίκτυα και συμπλέγματα σταθμών εργασίας ως παράλληλοι υπολογιστές (Networks/Clusters of Workstations). Συστήματα εισόδου/εξόδου για παράλληλους υπολογιστές.
ΗΡΥ 419	Εισαγωγή, thyristors, triacs, power transistors, power MOSFETs, GTO thyristors, IGBT transistors. Ανορθωτές (μονοφασικοί, τριφασικοί, ελεγχόμενοι, κλπ.), μετατροπείς DC–DC (converters), μετατροπείς DC–AC (inverters), cycloconverters, τεχνολογίες συσσωρευτών και μέθοδοι φόρτισης. Μεγιστοποίηση ισχύος (MPPT), σύζευξη σε υψηλές συχνότητες (high–frequency link), snubbers, ειδικά πηνία και μετασχηματιστές. Τροφοδοτικές διατάξεις (γραμμικές, διακοπτικές, αδιάλειπτης ισχύος, ρύθμισης ισχύος). Απαγωγή θερμότητας, αρμονικές, ηλεκτρομαγνητική συμβατότητα, προστασία. Εφαρμογές στα ηλεκτρικά κινητήρια συστήματα, στα ενεργειακά ηλεκτρικά συστήματα και στα συστήματα συγκομιδής ενέργειας (energy harvesting).
ΠΛΗ 415	Συντονισμός και επαναφορά σε λειτουργία συστημάτων διαχείρισης βάσεων δεδομένων. Κατανεμημένες βάσεις δεδομένων και προβλήματα λειτουργίας τους. Νέο standard SQL-3. Μηχανές βάσεων δεδομένων. Προχωρημένα συστήματα και εφαρμογές βάσεων δεδομένων (αντικειμενοστρεφείς, χρονικές, ενεργές, χωρικές βάσεις δεδομένων, αποθήκες βάσεων δεδομένων). Συσχέτιση μαθηματικής λογικής και βάσεων δεδομένων (επαγωγικές βάσεις δεδομένων).
ΠΛΗ 416	Πολυδιάστατα δεδομένα: αναπαράσταση με πίνακες (raster) και διανύσματα (vectors), αφηρημένοι τύποι δεδομένων, κωδικοποίηση και πρότυπα. Θέματα απόδοσης για προσπέλαση και επεξεργασία μαζικών δεδομένων. Αποθήκευση και ανάκτηση δεδομένων σε κυρίως μνήμη και δίσκους. Βασικές εφαρμογές: γεωγραφικά πληροφοριακά συστήματα, συστήματα CAD, γραφική. Εισαγωγή στις γεωγραφικές και χρονικές βάσεις δεδομένων, μοντέλα δεδομένων, γλώσσες για χωρικές, τοπολογικές και χρονικές επερωτήσεις. Βασική γεωμετρία σε 2 και 3 διαστάσεις, συστήματα συντεταγμένων, βασικές έννοιες χαρτογραφίας. Υπολογιστική γεωμετρία, αλγόριθμοι κυρτού κελύφους, τριγωνοποίησης, εντοπισμού σημείου, διασταύρωσης τμημάτων. Γεωμετρικές δομές δεδομένων, ερωτήματα εύρους, εγγύτερου γείτονα, ειδικά προβλήματα, δομές εξωτερικής μήμης, κατανεμημένες δομές. Αλγόριθμοι υπολογισμού επερωτήσεων. Επεξεργασία δεδομένων υψηλής διάστασης, μετρικοί χώροι, μετρικές ομοιότητας, προβλήματα βελτιστοποίησης, γραμμικός προγραμματισμός. 
ΠΛΗ 417	Θεμελίωση και ιστορία της Τεχνητής Νοημοσύνης. Ευφυείς πράκτορες και περιβάλλοντα. Μέθοδοι απληροφόρητης, πληροφορημένης, ευριστικής συστηματικής αναζήτησης. Μέθοδοι τοπικής αναζήτησης. Προβλήματα ικανοποίησης περιορισμών και αλγόριθμοι επίλυσής τους. Βασική θεωρία παιγνίων και αναζήτηση υπό αντιπαλότητα. Προτασιακή λογική, λογική πρώτης τάξης, συλλογιστική, αλγόριθμοι συμπερασμού. Αναπαράσταση γνώσης και βάσεις γνώσης. Συστήματα συλλογιστικής, αποδείκτες θεωρημάτων, λογικός προγραμματισμός. Σχεδιασμός (planning) και αλγόριθμοι σχεδιασμού. Σχεδιασμός στον πραγματικό κόσμο και πολυπρακτορικός σχεδιασμός.
ΠΛΗ 418	Βασικές τεχνικές γραφικής. Χρήσιμες μαθηματικές μέθοδοι. Μετασχηματισμοί (μετατόπιση, περιστροφή, αλλαγή κλίμακας). Εξισώσεις σχεδιασμού. Τοπικά και ολικά μοντέλα διάχυτης και κατοπτρικής ακτινοβολούμενης ενέργειας. Αλγόριθμοι φωτορεαλισμού. Θεωρία χρώματος σε οθόνη. Περιφερειακά εισόδου-εξόδου και εικονικής πραγματικότητας. Κρυφές επιφάνειες και τεχνικές σκίασης. Άλλα θέματα (ray tracing, color theory, antialiasing, animation, visualization). Βελτιστοποιήσεις αλγορίθμων βασισμένων σε μοντέλα αντίληψης. Υπολογιστικά μέτρα πιστότητας.
ΤΗΛ 415	Ανασκόπηση στοιχείων γραμμικής άλγεβρας: βαθμός πίνακα, υποχώρος στηλών, μηδενικός υποχώρος, η ανισότητα του Sylvester, ανάλυση σε ιδιοτιμές–ιδιοανύσματα γενικών, τετράγωνων και Hermitian πινάκων, singular value decomposition, ιδιότητες και εφαρμογές. Το πηλίκο του Rayleigh, τετραγωνική ελαχιστοποίηση, το λήμμα αντιστροφής πινάκων. Φασματική ανάλυση: φασματική πυκνότητα ισχύος, περιοδόγραμμα και στατιστικές ιδιότητες. Εκτίμηση φασματικών γραμμών, παραμετρικές μέθοδοι και εφαρμογές σε ασύρματες επικοινωνίες και συστήματα πολλαπλών κεραιών. Προσαρμοστικά φίλτρα: Gradient descent, LMS, RLS και ανάλυση σύγκλισης. Εφαρμογές προσαρμοστικών φίλτρων σε ισοστάθμιση καναλιού.
ΕΚΠ 419	Ανάλυση, σχεδιασμός και υλοποίηση μεγάλων συστημάτων λογισμικού, State of the Art. Η σημασία των διεθνών προτύπων στον παγκόσμιο ιστό. HTML, XML, HTTP, Web browsers, web servers, J2EE. Η σημασία της πρόσβασης σε βάσεις δεδομένων οργανισμών και επιχειρήσεων από το web. Βασικές συνιστώσες της αρχιτεκτονικής των εφαρμογών στο web: βάσεις δεδομένων, κανόνες λειτουργίας επιχειρήσεων (business logic), διαπροσωπίες (interfaces). Μονολιθικές (single tier), client-server, multi-user αρχιτεκτονικές. Πλεονεκτήματα και μειονεκτήματα. Βασικά εργαλεία ανάπτυξης εφαρμογών στο διαδίκτυο και διασύνδεσης με βάσεις δεδομένων: ODBC, JDBC, dynamic HTML, Javascripts, Java Server Pages. Προχωρημένες τεχνικές ανάπτυξης αλληλεπιδραστικών διαδικτυακών εφαρμογών με τη χρήση Ajax. Τεχνολογίες Web 2.0. Μεθοδολογίες ανάλυσης, σχεδιασμού και υλοποίησης εφαρμογών χρησιμοποιώντας το οντοκεντρικό μοντέλο: Use Cases, CRC cards. Επισκόπηση της UML: Class, Sequence, Collaboration, State, Activity, Component, Deployment Diagrams, Stereotypes, Constraints, OCL. Ανάπτυξη δομημένων εφαρμογών με χρήση και εφαρμογή μοτίβων σχεδιασμού εφαρμογών διαδικτύου (Web design patterns). BCED Architecture pattern, Control Layer patterns, MVC, Application Controller Pattern, Event Interface Pattern, Data Base Interface patterns, Data Access Object, CRUD Framework. Σχεδιασμός και ανάπτυξη διαπροσωπειών χρήστη (User Interfaces) στο διαδίκτυο. Οργάνωση και παρουσίαση πληροφορίας στο Διαδίκτυο: Document Object Model (DOM), Cascading Style Sheets (CSS). Αρχές και οδηγίες κατασκευής διαπροσωπειών. Σύντομοι και λεπτομερείς κανόνες, σχεδιασμός διαπροσωπειών ειδικού τύπου (menus, forms, κ.λ.π.). Επιλογή χρωμάτων, βοήθεια στους χρήστες. Βασικά λάθη σχεδιασμού διαπροσωπειών στο διαδίκτυο. Μεθοδολογίες ανάλυσης της χρηστικότητας των εφαρμογών και χρήση τους σε διάφορα στάδια της ανάπτυξης. Interface mockup, prototypes, interface flow diagrams. Ανάλυση απόδοσης από ομάδες, experts και χρήστες με μεθοδολογίες usability evaluation. Μεθοδολογίες για την αύξηση της χρηστικότητας των εφαρμογών, usability engineering. Μεθοδολογίες απεικόνισης του Οντοκεντρικού μοντέλου της UML στο Σχεσιακό Μοντέλο. Μεθοδολογίες για τη συνολική ανάπτυξη εφαρμογών και η εφαρμογή τους στο διαδίκτυο: Waterfall Model, Unified Process, ICONIX. Ταυτόχρονη χρήση πολλαπλών εργαλείων, παράλληλη και συγχρονισμένη ανάπτυξη διαπροσωπειών.
ΠΛΗ 420	Μοντέλα και μηχανισμοί επικοινωνίας διεργασιών: sockets, shared memory, ομαδική επικοινωνία, απομακρυσμένες κλήσεις, κατανεμημένα αντικείμενα. Βασικός προγραμματισμός δικτύων. Συνεδρίες. Πρωτόκολλα. Αρχιτεκτονικές κατανεμημένων συστημάτων: πελατών-υπηρετών, πολυεπίπεδη αρχιτεκτονική, διαμεσολαβητές, αποδημία κώδικα, συστήματα πρακτόρων, δίκτυα ομοβάθμων. Ανασκόπηση της αρχιτεκτονικής CORBA, χρήση της CORBA IDL. Ονοματισμός και διευθυνσιοδότηση: Ονόματα, φυσικές και λογικές διευθύνσεις, υπηρεσίες ονομάτων, DNS. Υπηρεσίες καταλόγου, LDAP. Υπηρεσιοστραφής αρχιτεκτονική. Κατανεμημένοι αλγόριθμοι: Μοντέλα. Αλγόριθμο με συντονιστή. Ο χρόνος σε κατανεμημένα συστήματα. Αιτιότητα. Το θεώρημα του Lamport. Ρολόγια Lamport. Ανυσματικά ρολόγια. Καθολική κατάσταση και στιγμιότυπα. Βασικοί αλγόριθμοι χωρίς συντονιστή: Εκλογή ηγέτη, Αμοιβαίος αποκλεισμός, Βυζαντινή συμφωνία. Αλγόριθμοι αναζήτησης: Κατανεμημένες δομές δεδομένων, αναζήτηση σε peer-to-peer networks, distributed hash tables. Αξιοπιστία: Ανοχή σε σφάλματα, εφεδρικά συστήματα, πολλαπλά αντίγραφα. Κατανεμημένες συναλλαγές (transactions), πρωτόκολλα 2 και 3 φάσεων. Ασφάλεια: Ταυτοποίηση (authentication) και εξουσιοδότηση (authorization). Στοιχεία κρυπτογραφίας. Συμμετρική και ασύμμετρη κρυπτογραφία. Ψηφιακές υπογραφές και PKI. Το πρωτόκολλο SSL. Το σύστημα Kerberos.
ΠΛΗ 422	Η Πληροφορική στην εκπαίδευση. Πολιτική και βαθμός ενσωμάτωσης της πληροφορικής στην εκπαίδευση στην Ελλάδα και άλλες Ευρωπαϊκές χώρες. Αναλυτικά προγράμματα διδασκαλίας πληροφορικής στην δευτεροβάθμια εκπαίδευση. Γενικές έννοιες διδακτικής και εφαρμογές στις θετικές επιστήμες. Στόχοι και περιεχόμενο μαθημάτων πληροφορικής. Σχεδιασμός ύλης. Μεθοδολογίες αξιολόγησης. Σχεδιασμός και αξιολόγηση γραπτών ασκήσεων. Σχεδιασμός και αξιολόγηση εργαστηριακών ασκήσεων. Η χρήση νέων τεχνολογιών στη διδασκαλία της πληροφορικής προγραμματισμού (εκπαιδευτικό λογισμικό, διαδικτυακοί τόποι, πολυμέσα). Μάθηση από απόσταση. Διδασκαλία πληροφορικής σε ενηλίκους και σε άτομα με ειδικές ανάγκες.
ΠΛΗ 423	Εισαγωγή στους μεταγλωττιστές. Υλοποίηση ενός απλού μεταγλωττιστή σε C. Λεκτική ανάλυση, κανονικές εκφράσεις και γλώσσες, υλοποίηση λεκτικών αναλυτών χρησιμοποιώντας lex/flex. Συντακτική ανάλυση, top-down και bottom-up parsing, υλοποίηση συντακτικών αναλυτών χρησιμοποιώντας yacc/bison. Σημασιολογική ανάλυση. Παραγωγή ενδιάμεσου κώδικα. Οργάνωση μνήμης και περιβάλλον εκτέλεσης (run-time environment) ενός προγράμματος. Παραγωγή και βελτιστοποίηση τελικού εκτελέσιμου κώδικα. Υλοποίηση ενός μεταγλωττιστή για μια απλή γλώσσα προγραμματισμού.
ΣΥΣ 412	Εισαγωγή στα νευρωνικά δίκτυα, βασικές αρχές, γραμμική διαχωρισιμότητα, μάθηση και νόμοι μάθησης, το δίκτυο Backpropagation, το δίκτυο Hopfield, επιβλεπόμενοι και μη επιβλεπόμενοι αλγόριθμοι, simulated annealing, εφαρμογές σε αναγνώριση προτύπων, δυναμικά νευρωνικά δίκτυα, εφαρμογές σε αναγνώριση και έλεγχο δυναμικών συστημάτων. Εισαγωγή στην ασαφή λογική, συστήματα ασαφούς λογικής, ελεγκτές, βιομηχανικές εφαρμογές. Εισαγωγή στον προσαρμοστικό έλεγχο. Έλεγχος συστημάτων μέσω DSP.
ΣΥΣ 413	Εισαγωγή σε αυτόματο έλεγχο των βιομηχανικών συστημάτων παραγωγής. Χρονοπρογραμματισμός και έλεγχος. Μείωση και βελτιστοποίηση κόστους με ταυτόχρονη βελτίωση ποιότητας. Έλεγχος για την ποιότητα σε πραγματικό χρόνο. Μέθοδοι συνεχούς βελτίωσης της ποιότητας. Εισαγωγή σε προγράμματα προσομοίωσης που χρησιμοποιούνται για βελτιστοποίηση. Το σύστημα SIMPLE++. Ευριστικές και μη ευριστικές μέθοδοι βελτιστοποίησης. Αυτοπροσαρμοζόμενες μέθοδοι βελτιστοποίησης. Εκτεταμένη συμμετοχή των φοιτητών σε βιομηχανικές εφαρμογές. Στα πλαίσια του μαθήματος θα γίνεται εξάσκηση στην τοπική βιομηχανία. Έλεγχος διακριτής λογικής (discrete logic control). Ελεγκτές προγραμματιζόμενης λογικής (PLC). Συστήματα παραγωγής. Έλεγχος παραγωγής.
ΤΗΛ 416	Επανάληψη στη θεωρία πιθανοτήτων και τυχαίων μεταβλητών. Κωδικοποίηση πηγής, πηγή πληροφορίας χωρίς μνήμη, εντροπία, συνδυασμένη και δεσμευμένη εντροπία, πηγή πληροφορίας με μνήμη, ρυθμός εντροπίας, θεώρημα κωδικοποίησης πηγής. Κώδικες πηγής σταθερού και μεταβλητού μήκους, ορολογία και ταξινόμηση κωδίκων, ανισότητα Kraft, κώδικες Shannon, Huffman, Fano, Shannon-Fano-Elias, και Lempel-Ziv, αριθμητικός κώδικας. Εφαρμογές κωδίκων πηγής στη συμπίεση δεδομένων, zip, bzip, pkzip, gzip, 7zip. Κωδικοποίηση διαύλου, αμοιβαία πληροφορία μεταξύ διακριτών τυχαίων μεταβλητών, ανισότητα επεξεργασίας δεδομένων, διαφορική εντροπία, κατανομές μέγιστης διαφορικής εντροπίας, αμοιβαία πληροφορία μεταξύ συνεχών τυχαίων μεταβλητών, χωρητικότητα διαύλου επικοινωνίας, υπολογισμός χωρητικότητας απλών διαύλων, χωρητικότητα διαύλου με Gaussian θόρυβο και διακριτή ή συνεχή είσοδο, θεώρημα κωδικοποίησης διαύλου. Κώδικες διαύλων, γραμμικοί κώδικες ομάδας, κώδικες Hamming, Hadamard, Golay, και LDPC, βέλτιστη (soft) και αλγεβρική αποκωδικοποίηση γραμμικών κωδίκων ομάδας και επίδοση αυτών, αποκάλυψη και διόρθωση σφαλμάτων, κυκλικοί κώδικες, υλοποίηση κυκλικών κωδίκων, κώδικες BCH και Reed-Solomon, συνελικτικοί κώδικες και βέλτιστη αποκωδικοποίηση αυτών, αλγόριθμος Viterbi και επίδοση αυτού, αλγόριθμος BCJR, αλυσιδωτοί κώδικες, κώδικας Turbo. Εφαρμογές κωδίκων διαύλων στην εγγραφή και μετάδοση δεδομένων, CD/DVD, dial-up modem, UMTS, DSL, DVB, WiFi, WiMAX. 
ΤΗΛ 418	Εισαγωγή σε δίκτυα υπολογιστών και στο Διαδίκτυο. Επίπεδο εφαρμογής: αρχές δικτυακών εφαρμογών, παραδείγματα εφαρμογών και των πρωτοκόλλων τους (Web και το πρωτόκολλο HTTP, μεταφορά αρχείων και πρωτόκολλο FTP, ηλεκτρονικό ταχυδρομείο και υπηρεσία καταλόγου του Διαδικτύου και το πρωτόκολλο DNS). Επίπεδο μεταφοράς: αρχές και υπηρεσίες, μεταφορά χωρίς σύνδεση και το πρωτόκολλο UDP, αρχές αξιόπιστης μεταφοράς δεδομένων, μεταφορά με σύνδεση και το πρωτόκολλο TCP, αρχές ελέγχου συμφόρησης, έλεγχος συμφόρησης στο TCP. Επίπεδο δικτύου: μοντέλα υπηρεσιών δικτύου, αρχές δρομολόγησης και αρχιτεκτονική δρομολογητών, ιεραρχική δρομολόγηση και το πρωτόκολλο IP, αλγόριθμοι unicast δρομολόγησης στο Διαδίκτυο, δρομολόγηση multicast στο Διαδίκτυο, υποστήριξη κινητικότητας και το πρωτόκολλο Mobile IP. Νέες τάσεις σε θέματα ποιότητας υπηρεσιών (QoS) και active queue management (αλγόριθμοι RED και FQ). Στοιχεία θεωρίας ουρών και το θεώρημα Little. Εισαγωγή σε Ασφάλεια στα δίκτυα υπολογιστών: ορισμός, αρχές κρυπτογραφίας (κρυπτογραφία συμμετρικού κλειδιού και δημόσιου κλειδιού), πιστοποίηση, ακεραιότητα δεδομένων, διανομή και πιστοποίηση κλειδιού, έλεγχος πρόσβασης (firewalls), επιθέσεις και αντίμετρα, ασφαλές Email και κρυπτογράφηση PGP. Εργαστηριακή εξάσκηση σε δικτυακά εργαλεία (tcpdump, traceroute, netstat) και δικτυακό προσομοιωτή (ns2).
ΤΗΛ 419	Βασικές έννοιες της υπολογιστικής γλωσσολογίας: μορφολογία της γλώσσας, φωνολογία, συντακτικό και ανάλυση σύνταξης, σημασιολογία, πραγματολογία και διάλογος. Βασικά εργαλεία επεξεργασίας γλώσσας: κανονικές εκφράσεις, μηχανές πεπερασμένης κατάστασης, γλωσσικά μοντέλα ν-γραμμάτων, γραμματικές χωρίς συμφραζόμενα, δενδρικά μοντέλα απόφασης, στατιστικά μοντέλα συντακτικής ανάλυσης, στατιστικά μοντέλα σημασιολογικής ανάλυσης, κατηγορικός λογισμός πρώτης τάξης, μοντέλα διαλόγου και στατιστικά μοντέλα μετάφρασης. Βασικές εφαρμογές: ορθογράφοι, μοντελοποίηση μορφολογίας, μοντελοποίηση γλώσσας, μοντελοποίηση προφοράς, αναγνώριση μέρους του λόγου, συντακτική ανάλυση, κατανόηση φυσικής γλώσσας, συστήματα διαλόγου, πολυτροπικά συστήματα, κατηγοριοποίηση διαλογικών πράξεων, αυτόματη μετάφραση.
ΤΗΛ 420	Εισαγωγή στην μοντελοποίηση και ανάλυση δικτύων επικοινωνιών με τη βοήθεια της θεωρίας ουρών αναμονής: θεώρημα Little, βασικές ουρές αναμονής (Μ/Μ/1, Μ /Μ/m και M/G/1), εκτίμηση παραμέτρων σε μοντέλα ουρών αναμονής. Ψηφιακά Δίκτυα Ενοποιημένων Υπηρεσιών, μεταγωγή κυκλώματος και πακέτου, ο Ασύγχρονος Τρόπος Μεταφοράς (ΑΤΜ). Χαρακτηρισμός πηγών κίνησης σε ΑΤΜ δίκτυα: μετρικές ποιότητας παρεχόμενων υπηρεσιών. Συμφόρηση σε δίκτυα μεταγωγής πακέτων. Απαιτήσεις για έλεγχο κίνησης και συμφόρησης σε ΑΤΜ δίκτυα. Πλαίσιο διαχείρισης και ελέγχου κίνησης: έλεγχος εισόδου νέων συνδέσεων, αστυνόμευση κίνησης και ο αλγόριθμος Leaky Bucket, αναδραστικοί μηχανισμοί ελέγχου συμφόρησης. Τοπικά Δίκτυα Υψηλών Ταχυτήτων: Fast Ethernet, Gigabit Ethernet, 10-Gigabit Ethernet, ATM LANs. Ασύρματα Ευρυζωνικά Δίκτυα: ασύρματα τοπικά δίκτυα (IEEE 802.11, WiMax), πρωτόκολλα χρονοπρογραμματισμού μεταδόσεων σε ασύρματα ευρυζωνικά δίκτυα ενοποιημένων υπηρεσιών αρχιτεκτονικής κυψέλης.
ΜΠΔ 425	Εισαγωγή. Συνδυαστικά προβλήματα. Βέλτιστος έλεγχος διακριτού χρόνου. Βέλτιστος έλεγχος συνεχούς χρόνου. Εφαρμογές. Παραλλαγμένοι αλγόριθμοι δυναμικού προγραμματισμού. Στοχαστικός δυναμικός προγραμματισμός. Εφαρμογές στοχαστικού δυναμικού προγραμματισμού. Επιλογές πρακτικής εφαρμογής.
ΜΠΔ 433	Μικρομεσαίες επιχειρήσεις. Οργάνωση και Διοίκηση ΜΜΕ. Νομοθεσία ΜΜΕ, Επιχειρηματικές πρωτοβουλίες, Δημιουργία νέων επιχειρήσεων, εκπόνηση επιχειρηματικών σχεδίων, Διαχείριση έργων και πόρων, Μοντέλα ανάπτυξης ΜΜΕ, Χρηματοδότηση ΜΜΕ, Βιωσιμότητα ΜΜΕ, Ηγεσία, Καινοτομία και ΜΜΕ, Καινοτόμες ιδέες, Δημιουργικότητα, Ανταγωνισμός, Τμηματοποίηση αγορών, Σχεδίαση και ανάπτυξη νέων προϊόντων, προώθηση πωλήσεων, Αξιολόγηση ΜΜΕ, Αξιολόγηση επενδύσεων, Χρηματοοικονιμική ανάλυση επενδύσεων, Εργαστήρια. 
ΠΛΗ 511	Διαδικασίες παραγωγής λογισμικού (software processes). Διαχείριση διαδικασιών κατασκευής μεγάλων συστημάτων λογισμικού. Ανάλυση και διαχείριση κινδύνου. Θέματα οργάνωσης και επάνδρωσης. Ανάλυση και καθορισμός απαιτήσεων (requirements). Τεχνικές ανάπτυξης λογισμικού με έμφαση σε οντοκεντρικές μεθόδους και τη γλώσσα UML. Μοτίβα και πλαίσια σχεδίασης. Διαχείριση αντιγράφων (version control). Έλεγχος (testing) συστημάτων λογισμικού. Πιστοποίηση (quality assurance). Συντήρηση λογισμικού και στρατηγικές παράδοσης προϊόντων.
ΚΕΠ 302	Αρχικά εξετάζονται βασικές έννοιες της Κοινωνιολογίας της Εργασίας και της Ανάπτυξης, με άξονα τις αλλαγές των παραγωγικών συστημάτων γενικά και ειδικότερα στον κλάδο της μεταποίησης (βιοτεχνία, βιομηχανία), σε συνδυασμό με συναφείς κλάδους της παραγωγικής καθώς και της επιστημονικής δραστηριότητας. Περαιτέρω προσεγγίζονται αναλυτικά και συνθετικά, σε διάφορες κλίμακες (διεθνή, εθνική, τοπική-περιφερειακή), ζητήματα που αφορούν: τις εργασιακές σχέσεις, τις παραγωγικές διαδικασίες, την έρευνα και ανάπτυξη (R&D), τις τεχνογνωσίες, τη βιομηχανική πολιτική, τις διακλαδικές και διαβιομηχανικές σχέσεις.
ΕΝΕ 511	Εισαγωγή στο ενεργειακό πρόβλημα. Κατηγορίες ανανεώσιμων πηγών ενέργειας. Αιολική ενέργεια (μέτρηση ταχύτητας ανέμου, εκτίμηση παραμέτρων κατανομής Weibull, τύποι και αρχές λειτουργίας ανεμογεννητριών, τύποι ηλεκτρογεννητριών, διασύνδεση με το ηλεκτρικό δίκτυο, αυτόνομη λειτουργία, μεγιστοποίηση απορροφούμενης ισχύος). Ηλιακή ενέργεια, θερμικά ηλιακά συστήματα, παθητικά ηλιακά συστήματα. Φωτοβολταϊκές διατάξεις (αρχές λειτουργίας, τύποι φωτοβολταϊκών, διασύνδεση με το δίκτυο, αυτόνομη λειτουργία, ηλεκτρονικά ισχύος και μεγιστοποίηση ισχύος). Μικρά υδροηλεκτρικά. Αποθήκευση ενέργειας (συσσωρευτές, υδροηλεκτρικά συστήματα άντλησης - ταμίευσης, κυψελίδες καυσίμου κλπ.). Γεωθερμία. Βιομάζα. Ενέργεια από τα κύματα. Εφαρμογές των ΑΠΕ. Νομοθετικό πλαίσιο των ΑΠΕ, περιβαλλοντικές επιπτώσεις των ΑΠΕ.
ΕΝΕ 512	Εκτίμηση ζήτησης και παραγωγής από στοχαστικές πηγές παραγωγής. Το πρόβλημα ένταξης και οικονομικής κατανομής των μονάδων παραγωγής με έμφαση στην απελευθερωμένη αγορά ηλεκτρικής ενέργειας. Κέντρα ελέγχου ενέργειας. Βασικά ζητήματα ευστάθειας δικτύων ιδιαίτερα σε αυτόνομα δίκτυα (όριο διείσδυσης ενέργειας από ΑΠΕ, ζητήματα τάσης). Εφαρμογή πιθανοτικών τεχνικών σε συστήματα ηλεκτρικής ενέργειας.
ΗΡΥ 511	Τεχνολογία ανάπτυξης κυκλωμάτων VLSI, η λειτουργία των FET, επεξεργασία, σχεδιασμός υπό κλίμακα, σχεδιαστικές ροές, κανόνες σχεδιασμού. Λογική βασισμένη σε λόγους (ratioed logic). Λογικά κυκλώματα με πλήρως συμπληρωματικές διατάξεις CMOS, pass–transistors, transmission gates. Μεθοδολογίες σχεδιασμού κυκλωμάτων εξειδικευμένων εφαρμογών (ASIC) και κανόνες σχεδιασμού συστημάτων. Δυναμική λογική. Τεχνικές προφόρτισης για επιτάχυνση κυκλωμάτων. Ακολουθιακά κυκλώματα, διφασικά (πολυφασικά) ρολόγια. Σχεδιασμός datapath. Στατικές και δυναμικές μνήμες. Διανομή ρολογιού και τροφοδοσίας. Δοκιμή συστημάτων VLSI. Οικονομική ανάλυση.
ΗΡΥ 512	Σφάλματα και η μοντελοποίησή τους, εξοπλισμός ελέγχου κυκλωμάτων, αλγόριθμοι γέννησης εισόδων ελέγχου συνδυαστικών και ακολουθιακών κυκλωμάτων,προσομοίωση σφαλμάτων, έλεγχος μνημών και επεξεργαστών, τεχνικές σχεδιασμού για έλεγχο κυκλωμάτων, ενσωματωμένος αυτοέλεγχος (BIST), boundary scan, τεχνικές προσδιορισμού θέσης σφαλμάτων.
ΗΡΥ 513	Εισαγωγική/ιστορική αναδρομή στην βιοϊατρική τεχνολογία. Βιοαισθητήρες και μεταλλάκτες. Συσκευές καταγραφής ηλεκτρο-φυσιολογικών σημάτων. Ανάλυση ηλεκτρικών βιο-σημάτων. Ιατρικές απεικονιστικές διατάξεις. Επεξεργασία ιατρικών εικόνων. Φυσική των laser. Ιατρικές εφαρμογές των laser. Μικροελεγκτές και συστήματα αναδιατασσόμενης λογικής στη βιο-ιατρική τεχνολογία. Παράλληλα συστήματα για βιολογικές εφαρμογές. Σχεδίαση ηλεκτρονικών ιατρικών συσκευών. Ιατρικές Βάσεις δεδομένων. Τεχνολογίες αιχμής στη βιοϊατρική οπτική απεικόνιση. 
ΗΡΥ 514	Προχωρημένα θέματα μικροαρχιτεκτονικών. Το πρόγραμμα (κώδικας μηχανής) ως ενδιάμεση μορφή αναπαράστασης. Αρχιτεκτονικές VLIW, super-scalar, decoupled access-execute, πολυνηματικής και ταυτόχρονης πολυνηματικής επεξεργασίας. Πρόβλεψη διακλαδώσεων και δεδομένων. Κρυφές μνήμες ίχνους, αρχιτεκτονικές με clusters. Software pipelining. Οργάνωση μνημών υψηλών επιδόσεων. Αρχιτεκτονικές μειωμένης ισχύος/κατανάλωσης ενέργειας. Μελέτη και σύγκριση τελευταίων επεξεργαστών (case study). Σύγχρονα θέματα από πρόσφατες δημοσιεύσεις.
ΣΥΣ 511	Εισαγωγή στο λογισμό των μεταβολών, αρχή του βέλτιστου του Pontryagin (maximum principle). Εφαρμογή της μεθόδου για την εύρεση λύσης στο πρόβλημα βελτιστοποίησης ντετερμινιστικού και στοχαστικού δυναμικού συστήματος και κατάστρωση του μοντέλου των οριακών συνθηκών για τις μερικές διαφορικές εξισώσεις. Εφαρμογές βέλτιστου ελέγχου σε πρακτικά προβλήματα, όπως ελάχιστη κατανάλωση καυσίμου πλοίων και αεροπλάνων, εφαρμογές σε βιολογικά συστήματα, εφαρμογές σε οικονομικά μοντέλα.
ΕΚΠ 512	Θέματα ολοκλήρωσης πληροφορικών συστημάτων και διαδικτυακών υπηρεσιών με τις ανάγκες ενός οργανισμού ή επιχείρησης. Ολοκλήρωση πληροφορίας στο διαδίκτυο. Ημιδομημένα δεδομένα και διαχείριση δεδομένων ΧΜL (XML Schema, XSL, XQUERY). Αρχιτεκτονικές λογισμικού. Ολοκλήρωση εφαρμογών διαδικτύου και ενδιάμεσο λογισμικό. Ολοκλήρωση εφαρμογών με τεχνολογίες υπηρεσιών διαδικτύου. Υπηρεσίες διαδικτύου βασισμένες σε SOAP, WSDL, UTTP, οργάνωση και σύνθεση. Υπηρεσίες διαδικτύου βασισμένες σε RESTfull services, mashups και widgets. Ολοκλήρωση πληροφορικών διαδικτυακών συστημάτων με τις ανάγκες επιχειρήσεων: μοντέλα επιχειρήσεων, διαδικασίες επιχειρήσεων, analytics και dashboards. Αρχιτεκτονική και συστήματα επιχειρήσεων (ERPs, CRMs).
ΠΛΗ 513	Πράκτορες και περιβάλλοντα, αβεβαιότητα και πιθανότητες, πιθανοτική συλλογιστική. Δίκτυα Bayes, ακριβής και προσεγγιστικός συμπερασμός σε δίκτυα Bayes, αλγόριθμοι απαρίθμησης και δειγματοληψίας. Πιθανοτική συλλογιστική στο χρόνο (φιλτράρισμα, πρόβλεψη, εξομάλυνση, εύρεση πιθανότερης ακολουθίας), δυναμικά δίκτυα Bayes. Πλοήγηση κινητών ρομπότ, έλεγχος κίνησης, σχεδιασμός διαδρομής, εντοπισμός, χαρτογράφηση, SLAM. Λήψη αποφάσεων υπό αβεβαιότητα, Μαρκωβιανές διεργασίες απόφασης, βέλτιστες πολιτικές, επανάληψη αξιών, επανάληψη πολιτικών, μερική παρατηρησιμότητα. Ενισχυτική μάθηση, πρόβλεψη και έλεγχος, βασικοί και προηγμένοι αλγόριθμοι ενισχυτικής μάθησης. Προσεγγιστικές μέθοδοι για πολυδιάστατους και συνεχείς χώρους. Ανταγωνιστικοί πράκτορες, σχεδιασμός και μάθηση σε Μαρκωβιανά παίγνια. Πολυπρακτορικός συντονισμός με δημοπρασίες. Εφαρμογές σε αυτόνομους ρομποτικούς πράκτορες και εργαστηριακή διδασκαλία εργαλείων προγραμματισμού ρομποτικών συστημάτων.
ΕΚΠ 514	Η βιομηχανία της Κοινωνίας της Πληροφορίας και οι βασικές αρχές για την έναρξη και τη λειτουργία επιτυχών επιχειρήσεων στην περιοχή αυτή. Το περιβάλλον των βιομηχανιών υψηλής τεχνολογίας και το περιβάλλον της βιομηχανίας της πληροφορίας. Βασικές αρχές και διαδικασίες για την δημιουργία μιας μικρής αναπτυσσόμενης επιχείρησης στην περιοχή αυτή, δίνοντας έμφαση στη δημιουργικότητα και την τεχνολογική καινοτομία, εστίαση σε στόχους, ευκαιρία και χρονισμό, ανάπτυξη τεχνολογίας, διαφήμιση, χρηματοδότηση, δημιουργία συνεργασιών. Η οικονομία της πληροφορίας, το κόστος της πληροφορίας, η κοστολόγηση της πληροφορίας, επιχειρησιακός σχεδιασμος, χρηματοδοτήσεις, πηγές ευκαιριών, σχεδιασμός αγοράς, σχεδιασμός προϊόντων, διαχείριση έρευνας και ανάπτυξης, διαφήμιση, διαχείριση πωλήσεων, νομική κάλυψη για πνευματικά δικαιώματα στην πληροφορία, διοίκηση και οργάνωση ανθρώπινου δυναμικού για την παραγωγή προϊόντων και υπηρεσιών. Η επιρροή του Διαδικτύου στη βιομηχανία της πληροφορίας. Μοντέλα αγοράς για την παραγωγή και διάθεση προϊόντων στην αγορά.
ΠΛΗ 516	Αισθητήρες κόμβοι: χαρακτηριστικά, περιορισμοί. Εφαρμογές δικτύων αισθητήρων. Κατανεμημένη επεξεργασία πληροφορίας σε δίκτυα αισθητήρων. Συνεχείς επερωτήσεις. Είδη συνεχών επερωτήσεων και χαρακτηριστικά. Γλώσσες επερωτήσεων. Τρόποι συλλογής πληροφοριών. Αποθήκευση, δεικτοδότηση και αναζήτηση πληροφορίας. Δέντρο συνάθροισης. Συγχρονισμός και μετάδοση δεδομένων. Μέθοδοι κατασκευής δέντρου συνάθροισης. Κατανεμημένη οργάνωση αισθητήρων, επισκόπηση πληροφορίας. Προσεγγιστικές επερωτήσεις σε δίκτυα αισθητήρων. Παρακολούθηση κινούμενων αντικειμένων. Προβλήματα απώλειας και πολλαπλού υπολογισμού της πληροφορίας, τρόποι αντιμετώπισης. Ποιότητα μετρήσεων αισθητήρων. Τρόποι αναγνώρισης και απομόνωσης λανθασμένων μετρήσεων.
ΠΛΗ 517	Χαρακτηριστικά και τύποι πρακτόρων. Πολυπρακτορικά συστήματα και αλληλεπιδράσεις πρακτόρων. Σχέση με Θεωρία Παιγνίων και Τεχνητή Νοημοσύνη. Έμφαση σε “οικονομικά σκεπτόμενους” (rational utility maximizers) πράκτορες. Έμφαση σε πολυπρακτορικά συστήματα και αλληλεπιδράσεις πρακτόρων. Έμφαση σε συλλογιστικές διαδικασίες που χρησιμοποιούν Θεωρία Χρησιμότητας (Utility Theory), Λήψη Αποφάσεων υπό Αβεβαιότητα (Decision Theory) και Θεωρία Παιγνίων. Προτιμήσεις, συναρτήσεις ωφέλειας, μεγιστοποίηση οφέλους, οικονομικο-κεντρική λογική (rationality). Στρατηγική λήψη αποφάσεων. Στατικά και επαναλαμβανόμενα στρατηγικά παίγνια. Κατάσταση ισορροπίας Nash, Pareto-βέλτιστες λύσεις, και άλλες έννοιες παιγνιο-θεωρητικών λύσεων. Επιλογή μεταξύ καταστάσεων ισορροπίας. Κατανεμημένη λύση προβλημάτων. Δημιουργία συνασπισμών από συνεργατικούς και μή πράκτορες. Εφαρμογές δημιουργίας συνασπισμών (ηλεκτρονικό εμπόριο, τηλεπικοινωνιακά δίκτυα, αποκεντροποιημένη αγορά ενέργειας και έξυπνο ηλεκτρικό δίκτυο). Εμπιστοσύνη και Φήμη Πρακτόρων. Διαπραγματεύσεις. Δημοπρασίες και Σχεδίαση Μηχανισμών. Εφαρμογές δημοπρασιών και σχεδίασης μηχανισμών (ηλεκτρονικές δημοπρασίες, δημοπρασίες για διαφημιστικό χώρο σε σελίδες περιγραφής αποτελεσμάτων αναζήτησης). Μοντελοποίηση αντιπάλων και μάθηση σε παίγνια. Σχέσεις με Μηχανική Μάθηση. Αντιμετώπιση αβεβαιότητας. Εφαρμογές πολυπρακτορικών συστημάτων: πράκτορες σε τηλεπικοινωνιακά/ad-hoc ασύρματα/peer-to-peer δίκτυα, πράκτορες σε δίκτυα αισθητήρων, πράκτορες στο έξυπνο δίκτυο ηλεκτροδότησης.
ΤΗΛ 511	Εισαγωγή στις τεχνολογίες ασύρματων δικτύων. Αρχιτεκτονικές ασύρματων δικτύων. Ασύρματα πρωτόκολλα προσπέλασης μέσου. Ασύρματα δίκτυα ευρείας περιοχής: αρχές κυψελωτών δικτύων (κυψελωτή δομή, επαναχρησιμοποίηση συχνοτήτων, διαχείριση κινητικότητας), συστήματα δεύτερης γενιάς (GSM, GPRS), συστήματα τρίτης γενιάς (UMTS). Κινητικότητα σε δίκτυα IP (Mobile IP, WAP). Ασύρματα αστικά, τοπικά και προσωπικά δίκτυα: WiMax και το πρότυπο ΙΕΕΕ 802.16 (αρχιτεκτονική δικτύου, αρχιτεκτονική πρωτοκόλλων, επίπεδο MAC, φυσικό επίπεδο), WiFi και το πρότυπο IEEE 802.11 (αρχιτεκτονική δικτύου, αρχιτεκτονική πρωτοκόλλων, επίπεδο MAC, φυσικό επίπεδο), Bluetooth και το πρότυπο ΙΕΕΕ 802.15, ασύρματα ad hoc δίκτυα και ασύρματα δίκτυα αισθητήρων (αρχιτεκτονική, πρωτόκολλα, αλγόριθμοι δρομολόγησης).
ΤΗΛ 414	Μοντελοποίηση δικτύων επικοινωνιών με την βοήθεια στοχαστικών διαδικασιών: σύντομη επανάληψη διακριτών τυχαίων μεταβλητών, η στοχαστική διαδικασία Bernoulli και αθροίσματα ανεξάρτητων τυχαίων μεταβλητών, η στοχαστική διαδικασία Poisson και οι κύριες ιδιότητες της, διακριτές αλυσίδες Markov (ιδιότητες, κατηγοριοποίηση καταστάσεων, οριακή συμπεριφορά). Μοντελοποίηση δικτύων επικοινωνιών με τη βοήθεια της θεωρίας ουρών αναμονής (Θεώρημα Little, οι Μαρκοβιανές ουρές αναμονής M/M/1,M/M/m/m, η ουρά αναμονής M/G/1 με γενικευμένη κατανομή χρόνων εξυπηρέτησης, ουρά αναμονής M/G/1 με περιόδους διακοπής του εξυπηρετητή, ουρές αναμονής με προτεραιότητες). Σχεδίαση, μοντελοποίηση και ανάλυση απόδοσης πρωτοκόλλων προσπέλασης μέσου και χρονοπρογραμματισμού μεταδόσεων για ραδιοδίκτυα μετάδοσης πακέτων και για ασύρματα δίκτυα ενοποιημένων υπηρεσιών.
HPY 416	Εισαγωγή στη σχεδίαση αναλογικών VLSI κυκλωμάτων με τεχνολογία CMOS. Βασικές δομές: MOSFET, δίοδοι, αντιστάσεις, πυκνωτές poly και ΜΙΜ, MOS varactors. Φυσική των MOS τρανζίστορ, μοντέλο ελέγχου φορτίων. Τρόποι λειτουργίας του MOSFET, ασθενή, μέτρια και ισχυρή αναστροφή, κορεσμός και μη-κορεσμός. Ιδανικό συμμετρικό μοντέλο σχεδίασης. Μοντέλο διαγωγιμοτήτων και χωρητικοτήτων. Ισοδύναμο κύκλωμα ασθενούς σήματος σε χαμηλές, μεσαίες και υψηλές συχνότητες. Επίδραση θερμοκρασίας, θερμικός και flicker θόρυβος. Φαινόμενα μικρού μήκους καναλιού. Παρασιτικά φαινόμενα αντίστασης, χωρητικότητας, ρεύμα διαρροής και λειτουργία compatible bipolar. Layout, στατιστική συμπεριφορά και ταίριασμα (matching). Δείκτης αναστροφής (IC), αρχές σχεδίασης βασισμένη σε δείκτη αναστροφής και μήκος καναλιού: DC κέρδος, μεταβατική συχνότητα, θόρυβος, τάση κορεσμού, DC ταίριασμα. Βιβλιοθήκες σχεδίασης κυκλωμάτων σε εργαλεία SPICE. Μοντέλο EKV του MOS τρανζίστορ. Βασικές δομές αναλογικών CMOS κυκλωμάτων. Καθρέπτες ρεύματος, πηγές ρεύματος και τάσης. Βασικά δομικά στοιχεία ενισχυτών. Διαφορικό ζεύγος, διαφορικός ενισχυτής. Σχεδίαση τελεστικών ενισχυτών OpAmps και ΟΤΑ. Ειδικά εργαλεία CAD σχεδίασης αναλογικών CMOS κυκλωμάτων.
ΠΛΗ 421	Διακριτές τυχαίες μεταβλητές: Bernoulli, διωνυμική, γεωμετρική, Poisson. Ανισότητες Markov, Chebyshev, Chernoff, Hoeffding-Azuma. Υπό-συνθήκη μέση τιμή. Martingales. Αλγόριθμοι επιβεβαίωσης ταυτοτήτων. Το πρόβλημα συλλογής κουπονιών. Το πρόβλημα τοποθέτησης μπαλών σε κάδους. Πιθανοτικοί αλγόριθμοι ταξινόμησης (Quick-sort, Bucket-sort). Τυχαία γραφήματα: χρωματικοί αριθμοί, κύκλοι Hamilton. Δρομολόγηση πακέτων σε αραιά δίκτυα. Τυχαιοποιημένοι αλγόριθμοι για τα προβλήματα 2-Ικανοποιησιμότητας, 3-Ικανοποιησιμότητας. Ταίριασμα προτύπων
ΜΑΘ 411	--
ΣΥΣ 512	--
ΠΛΗ 302	Μοντελοποίηση ως μηχανισμός αφαίρεσης. Οντότητες, σχέσεις μεταξύ οντοτήτων, περιορισμοί, περιορισμοί πληθικότητας, περιορισμοί ύπαρξης, συναρτησιακές εξαρτήσεις. Το Μοντέλο Περιγραφής Οντοτήτων-Σχέσεων. Ανάλυση και καταγραφή αναγκών χρησιμοποιώντας το Μοντέλο Οντοτήτων-Σχέσεων. Τα λογικά μοντέλα των Βάσεων Δεδομένων. Το σχεσιακό μοντέλο. Μετατροπή του μοντέλου Οντοτήτων-Σχέσεων στο Σχεσιακό Μοντέλο. Γλώσσες ανάκτησης πληροφορίας από το Σχεσιακό μοντέλο. Ορθός σχεδιασμός εφαρμογών βάσεων δεδομένων στο σχεσιακό μοντέλο. Προβλήματα σχεδιασμού. Συναρτησιακές εξαρτήσεις και η χρήση τους. Κανονικοποίηση της πληροφορίας. Κανονικές μορφές. Τα πρότυπα SQL-92, SQL-99. Υποστήριξη για views. Ενσωματωμένη SQL. Γλώσσες βασισμένες σε γραφική απεικόνιση. Query by example. Θέματα Απόδοσης των Βάσεων Δεδομένων. Κόστος ανάληψης από δευτερεύουσα μνήμη, ανάγκη ανάληψης σε blocks, επιλογή του μεγέθους του block. Μέθοδοι προσπέλασης της πληροφορίας στους πίνακες. Το πρόβλημα της επιλογής καλών δεικτών. Άλλες μέθοδοι βελτιστοποίησης απόδοσης: οριζόντια/κάθετη τμηματοποίηση, οριζόντια/κάθετη ομαδοποίηση, κλπ. Η αναγκαιότητα του βελτιστοποιητή ερωτήσεων στις σχεσιακές βάσεις. Ευριστική βελτιστοποίηση ερωτήσεων. Στατιστική βελτιστοποίηση ερωτήσεων και επιλογή της κατάλληλης μεθόδου προσπέλασης. Το πρόβλημα της ταυτόχρονης προσπέλασης πολλαπλών χρηστών στη βάση. Προβλήματα χαμένων ενημερώσεων, ασυνεπών διαβασμάτων, κ.λπ. Το σύστημα ελέγχου ταυτοχρονισμού. Συνδιαλλαγές, ανάμειξη των εντολών από διαφορετικές συνδιαλλαγές, σειριοποιησιμότητα. Πρωτόκολλα υποστήριξης ταυτοχρονισμού. Υποστήριξη ανάνηψης της Βάσης σε περίπτωση προβλημάτων. Ο μηχανισμός ανάνηψης. Το μάθημα είναι ισχυρά κατευθυνόμενο προς το σχεδιασμό και την υλοποίηση εφαρμογών πάνω σε Συστήματα Βάσεων Δεδομένων καθώς και τη βελτιστοποίηση της απόδοσης του συστήματος και κατά δεύτερο λόγο στην υλοποίηση των Συστημάτων Βάσεων Δεδομένων. Μια μεγάλη εφαρμογή βάσεων δεδομένων αναλύεται, σχεδιάζεται και υλοποιείται σε φάσεις στη διάρκεια του μαθήματος.
ΤΗΛ 302	Δειγματοληψία, ανακατασκευή και αλλαγή συχνότητας δειγματοληψίας. Επεξεργασία αναλογικού σήματος με διακριτά συστήματα. Χαρακτηρισμός και ανάλυση διακριτών συστημάτων στο πεδίο της συχνότητας. Συστήματα γραμμικής και ελάχιστης φάσης. Μετασχηματισμός Ζ και σχέση με μετασχηματισμό Fourier διακριτού χρόνου. Δομές φίλτρων διακριτού χρόνου. Σχεδίαση και υλοποίηση αναδρομικών και μη αναδρομικών φίλτρων. Μέθοδοι μετασχηματισμού και παραθυροποίησης στη σχεδίαση φίλτρων πεπερασμένου μήκους. Υλοποίηση DFT και επίδραση στην κυκλική συνέλιξη.
\.


--
-- Data for Name: Diplomas; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public."Diplomas" (thesis_grade, thesis_title, diploma_grade, graduation_date, diploma_num, graduate_student_amka) FROM stdin;
\N	Διπλωματική εργασία ΣΑΛΑΠΑΝΗ                                          ΗΡΩ                           	1	2017-05-05	1	3391566195
\N	Διπλωματική εργασία ΦΩΤΕΙΑΔΗ                                          ΜΕΝΕΞΙΑ                       	1	2017-05-05	2	9825289323
\N	Διπλωματική εργασία ΒΙΤΑΝΙΔΗΣ                                         ΛΑΜΠΡΑΚΗΣ                     	1	2017-05-05	3	5243886166
\N	Διπλωματική εργασία ΧΛΙΟΥΝΑΚΗ                                         ΑΛΚΙΣΤΗ                       	1	2017-05-05	4	5589427861
\N	Διπλωματική εργασία ΜΥΛΩΝΗ                                            ΘΕΜΙΣ                         	1	2017-05-05	5	5081927005
\N	Διπλωματική εργασία ΓΚΟΥΝΖΑΜΑΝΗ                                       ΑΓΑΘΟΥΛΑ                      	1	2017-05-05	6	1077861304
4	Διπλωματική εργασία ΤΖΑΛΗ                                             ΓΡΑΜΜΑΤΙΑ                     	1	2017-05-05	7	1006258297
\.


--
-- Data for Name: Directs; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public."Directs" (directs_professor_amka, directs_lab_code) FROM stdin;
7594565848	2
\.


--
-- Data for Name: Fields; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public."Fields" (field_code, field) FROM stdin;
ΑΓΓ	Αγγλική Γλώσσα                                                                                      
ΕΚΠ	Εφαρμογές Κοινωνίας της Πληροφορίας                                                                 
ΕΝΕ	Ενεργειακά Συστήματα                                                                                
ΗΜΥ	Επιστήμη Η.Μ.Μ.Υ.                                                                                   
ΗΡΥ	Ηλεκτρονική και Αρχιτεκτονική Υπολογιστών                                                           
ΚΕΠ	Κοινωνία, Επιστήμη, Πολιτισμός                                                                      
ΜΑΘ	Μαθηματικά                                                                                          
ΜΠΔ	Παραγωγή και Διοίκηση                                                                               
ΠΛΗ	Πληροφορική                                                                                         
ΣΥΣ	Συστήματα                                                                                           
ΤΗΛ	Τηλεπικοινωνίες                                                                                     
ΦΥΣ	Φυσική                                                                                              
ΧΗΜ	Χημεία                                                                                              
\.


--
-- Data for Name: Graduation_rules; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public."Graduation_rules" (min_courses, min_units, year) FROM stdin;
20	100	2012-05-01
\.


--
-- Data for Name: Lab; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public."Lab" (lab_code, sector_code, lab_title, lab_description) FROM stdin;
1	3	Εργαστήριο Αυτοματισμού                                                                             	Το εργαστήριο ανήκει στον Τομέα Συστημάτων και Ενέργειας και εξυπηρετεί τις εκπαιδευτικές και ερευνητικές ανάγκες στο γνωστικό αντικείμενο της Θεωρίας Συστημάτων και του Αυτόματου Ελέγχου. Ερευνητικές περιοχές: Θεωρία Αυτόματου ελέγχου. Ευφυής Ελεγχος. Βιομηχανικοί Ελεγκτές. Νευρωνικά Δίκτυα. Αναγνώριση και Αυτόματη Αποκατάσταση Βλαβών. Διαγνωστικά Συστήματα στην Iατρική. Βιοϊατρικά Συστήματα. Ρομποτική. Εφαρμογές Ρομποτικής στην Ιατρική. Ελεγχος Βιομηχανικών Διεργασιών. Χρονοπρογραμματισμός Συστημάτων Παραγωγής.
2	1	Εργαστήριο Διανεμημένων Πληροφορικών Συστημάτων και Εφαρμογών                                       	Το εργαστήριο ιδρύθηκε το 1990 και ανήκει στον Τομέα Πληροφορικής. Είναι ένα κέντρο έρευνας και ανάπτυξης στις περιοχές των διανεμημένων πληροφορικών συστημάτων, των πολυμέσων, της γραφικής, της αλληλεπίδρασης ανθρώπων και υπολογιστών, και της συστηματικής ανάπτυξης μεγάλων εφαρμογών πληροφορικών συστημάτων και εφαρμογών επιχειρήσεων στο Διαδίκτυο. Ερευνητικές περιοχές: Συστήματα ανάκτησης πληροφοριών. Μηχανές ανεύρεσης στο Διαδίκτυο και τεχνολογίες πρακτόρων. Ψηφιακές βιβλιοθήκες. Επικοινωνιακά συστήματα πολυμέσων. Κατανεμημένα περιβάλλοντα συνεργασίας και διαχείρισης ροής εργασιών. Αλληλεπίδραση ανθρώπου-υπολογιστή. Εφαρμογές στον τουρισμό και στον πολιτισμό, στο ηλεκτρονικό εμπόριο, στην Τηλεκπαίδευση. 13 Αυτοματισμός γραφείου, αυτοματισμός εταιρειών. Διανεμημένα πληροφοριακά συστήματα πολυμέσων. Ανάπτυξη εφαρμογών και υπηρεσιών στο Διαδίκτυο. Κοινωνία πληροφοριών. Βάσεις δεδομένων. Τρισδιάστατα υπολογιστικά γραφικά, τεχνολογίες προσομοιώσεων, οπτικοποίηση, ιατρικές εφαρμογές.
3	5	Εργαστήριο Ηλεκτρικών Κυκλωμάτων και Ανανεώσιμων Πηγών Ενέργειας                                    	Το εργαστήριο ανήκει στον Τομέα Ηλεκτρονικής και Αρχιτεκτονικής Υπολογιστών και δραστηριοποιείται στο χώρο των ηλεκτρικών κυκλωμάτων και των ανανεώσιμων πηγών ενέργειας. Ο ερευνητικός εξοπλισμός του περιλαμβάνει παλμογράφους, γεννήτριες και πολύμετρα μεγάλης ακριβείας, αναλυτή ποιότητας ηλεκτρικής ενέργειας, μετρητές διαφόρων μεγεθών και αναπτυξιακά συστήματα μικροεπεξεργαστών, DSPs και FPGAs, καθώς και ανεμογεννήτρια, φωτοβολταϊκή διάταξη και μετεωρολογικό σταθμό μέτρησης των σχετικών μεγεθών με σύστημα αποθήκευσης και επεξεργασίας δεδομένων. Ερευνητικές περιοχές: Αισθητήρες και διατάξεις μετρήσεων. Ανάπτυξη τοπικών δικτύων διασύνδεσης αισθητήρων, ενεργοποιητών και υπολογιστών. Ανάπτυξη ηλεκτρονικών διατάξεων ελέγχου βασισμένες σε ασαφή λογική και νευρωνικά δίκτυα. Συστήματα αποφάσεων για βιομηχανικές εφαρμογές. Αιολικά συστήματα. Εφαρμογές φωτοβολταϊκών διατάξεων. Διαχείριση και λειτουργία ηλεκτρικών σταθμών παραγωγής. Διαχείριση και βελτιστοποίηση σε συστήματα με ανανεώσιμες πηγές ενέργειας. Εξυπνα συστήματα διαχείρισης ενέργειας σε κτίρια. Εφαρμογές με έξυπνες κάρτες σε θέματα υγείας, ασφάλειας, χρέωσης, πρόσβασης, εξοικονόμησης ενέργειας. Βιοϊατρικές και εμβιομηχανικές διατάξεις. Ανάπτυξη ελεγχόμενων μεταλλακτών και μετατροπέων ηλεκτρικής ισχύος 
4	2	Εργαστήριο Ηλεκτρονικής                                                                             	Το εργαστήριο ανήκει στον Τομέα Ηλεκτρονικής και Αρχιτεκτονικής Υπολογιστών και οι δραστηριότητές του περιλαμβάνουν έρευνα, ανάπτυξη, εκπαίδευση και μεταφορά τεχνολογίας στα πεδία της οπτοηλεκτρονικής και μικρο- νανο- ηλεκτρονικής. Το Εργαστήριο Ηλεκτρονικής είναι εξοπλισμένο με εργαλεία για σχεδίαση, προσομοίωση, διάταξη, ανάπτυξη πρωτοτύπων, χαρακτηρισμό και έλεγχο οπτοηλεκτρονικών και μικροηλεκτρονικών συστημάτων και διατάξεων. Ερευνητικές περιοχές: Ανάπτυξη συστημάτων και ανάλυση δεδομένων Υπερ-Φασματικής απεικόνισης. Οπτική μοριακή απεικόνιση. Βιοφωτονικά ιατρικά διαγνωστικά όργανα. Μικροηλεκτρονική υψηλών συχνοτήτων. Σχεδίαση και μοντελοποίηση CMOS διατάξεων και κυκλωμάτων. Μελέτη, σχεδιασμός και αξιολόγηση κυκλωμάτων πολύ υψηλής κλίμακας ολοκλήρωσης (VLSI). Οπτοηλεκτρονικές διατάξεις και εφαρμογές τους. Ανάπτυξη συστημάτων βέλτιστης διαχείρισης ενέργειας μπαταριών, μετατροπής τάσης και αδιάλειπτης παροχής ηλεκτρικής ενέργειας (UPS) 
5	2	Εργαστήριο Μικροεπεξεργαστών και Υλικού                                                             	Το εργαστήριο ιδρύθηκε το 1990 και ανήκει στον Τομέα Ηλεκτρονικής και Αρχιτεκτονικής Υπολογιστών. Οι δραστηριότητές του στρέφονται γύρω από θέματα αρχιτεκτονικής και υλικού υπολογιστών και ενσωματωμένων συστημάτων. Το εργαστήριο είναι πλήρως εξοπλισμένο με εργαστηριακά όργανα (παλμογράφους, λογικούς αναλυτές, κ.α.) και δεκάδες συστήματα ανάπτυξης ψηφιακών κυκλωμάτων ή/και ενσωματωμένων διατάξεων βασισμένα σε αναδιατασσόμενη λογική, καθώς και τέσσερα από τα μεγαλύτερα υπερυπολογιστικά συστήματα που είναι διαθέσιμα παγκοσμίως και βασίζονται σε συνδυασμό πολυπύρηνων επεξεργαστών και κυκλωμάτων αναδιατασσόμενης λογικής (FPGA). Το εργαστήριο είναι μέλος της ακαδημαϊκής και ερευνητικής κοινοπραξίας EUROPRACTICE. 14 Ερευνητικές περιοχές: Αρχιτεκτονική και υλικό υπολογιστικών συστημάτων. Αναδιατασσόμενα και ενσωματωμένα συστήματα. Σχεδίαση και υλοποίηση αποδοτικών συστημάτων (υψηλών επιδόσεων, χαμηλού κόστους, χαμηλής κατανάλωσης ενέργειας, κ.α.). Επιτάχυνση εφαρμογών με εξειδικευμένες αρχιτεκτονικές. Ανάπτυξη εργαλείων σχεδίασης ψηφιακών συστημάτων με υπολογιστή (CAD). Σχεδίαση και προγραμματισμός παράλληλων συστημάτων. 
6	4	Εργαστήριο Πληροφορίας και Δικτύων                                                                  	Το εργαστήριο ανήκει στον Τομέα Τηλεπικοινωνιών και δραστηριοποιείται στους χώρους των Δικτύων Επικοινωνιών και της Θεωρίας Πληροφοριών και Κωδίκων με εφαρμογές σε Δίκτυα Επικοινωνιών. Ερευνητικές περιοχές: Σχεδιασμός, μοντελοποίηση και ανάλυση απόδοσης δικτύων επικοινωνίας υπολογιστών. Ασύρματα κινητά δίκτυα ενοποιημένων υπηρεσιών. Τηλεπικοινωνιακά δίκτυα πολλαπλής πρόσβασης. Ευρυζωνικά δίκτυα υψηλής ταχύτητας, τοπικής και μητροπολιτικής εμβέλειας. Κεντρικοποιημένα και κατανεμημένα συστήματα διανομής πληροφορίας πολυμέσων. Μέθοδοι χρόνο- προγραμματισμού για εξυπηρετητές πολυμέσων και για μετάδοση πληροφορίας δεδομένων σε ασύρματα δίκτυα. Αναγνώριση φωνής. Κωδικοποίηση φωνής. Ακουστική και γλωσσική μοντελοποίηση. Εύρωστη αναγνώριση φωνής και προσαρμογή. Τηλεφωνικές και διαδικτυακές εφαρμογές της αναγνώρισης φωνής 
7	1	Εργαστήριο Προγραμματισμού και Τεχνολογίας Ευφυών Συστημάτων                                        	Το εργαστήριο ιδρύθηκε το 2001 και ανήκει στον Τομέα Πληροφορικής. Οι τρέχουσες ερευνητικές δραστηριότητες καλύπτουν διάφορα θέματα Τεχνητής Νοημοσύνης, Ευφυών Πρακτόρων, Βιοπληροφορικής, Ανάκτησης Πληροφορίας, Μηχανικής Μάθησης, Πολυπρακτορικών Συστημάτων, και Ρομποτικής. Ο εξοπλισμός του εργαστηρίου περιλαμβάνει τετράποδα ρομπότ Sony Aibο και δίποδα ανθρωποειδή ρομπότ Aldebaran Nao που συνιστούν την ομάδα ρομποτικού ποδοσφαίρου «Κουρήτες». Ερευνητικές περιοχές: Τεχνητή Νοημοσύνη. Αναπαράσταση Γνώσης. Προβλήματα Ικανοποίησης Περιορισμών. Λογικός Προγραμματισμός και Προγραμματισμός με Περιορισμούς. Διαχείριση Πολυμέσων. Πληροφοριακά Συστήματα στο Διαδίκτυο. Ανάκτηση Πληροφορίας. Ηλεκτρονικό Εμπόριο. Σημασιολογικό Διαδίκτυο. Αυτόνομοι Πράκτορες. Πολυπρακτορικά Συστήματα. Θεωρία Παιγνίων. Μηχανική Μάθηση. Ρομποτική. Βιοπληροφορική. Μηχανική Οραση. Αναγνώριση Προτύπων. Κατανόηση Εικόνας 
8	1	Εργαστήριο Τεχνολογίας Συστημάτων Λογισμικού και Δικτυακών Εφαρμογών                                	Το εργαστήριο ανήκει στον Τομέα Πληροφορικής και είναι ένα κέντρο έρευνας και διδασκαλίας τεχνολογιών συστημάτων λογισμικού και δικτυακών εφαρμογών. Οι ερευνητικές και διδακτικές δραστηριότητες του εργαστηρίου περιλαμβάνουν λειτουργικά και κατανεμημένα συστήματα, συστήματα δικτύων αισθητήρων, συνεχείς ροές δεδομένων, μεγάλες και κατανεμημένες βάσεις δεδομένων και θέματα αλγορίθμων και πολυπλοκότητας. Ερευνητικές περιοχές: Συλλογή και Διανομή Περιεχομένου στο Διαδίκτυο. Διάχυση ροών video στο Διαδίκτυο. Συνεργαζόμενες Κρυφές Μνήμες. Αρχιτεκτονικές peer-to-peer για μεγάλης κλίμακας αποθήκευση και διανομή περιεχομένου. Εξυπνα συστήματα αποθήκευσης πληροφορίας. Μοντελοποίηση απόδοσης συσκευών. Αποταμίευση και προανάκτηση σε ιεραρχικούς διακομιστές. Χρόνο-προγραμματισμός αιτήσεων πρόσβασης. Κατανεμημένα συστήματα διαχείρισης πληροφορίας (αποταμίευση, προανάκτηση, διαχείριση αντιγράφων, ανεκτικότητα σε λάθη, ανάνηψη, κ.λπ.). 15 Συστήματα διαχείρισης αρχείων. Συστήματα βάσεων δεδομένων. Ανάπτυξη εφαρμογών για ηλεκτρονικό εμπόριο 
9	4	Εργαστήριο Τηλεπικοινωνιών                                                                          	Το εργαστήριο ανήκει στον Τομέα Τηλεπικοινωνιών και δραστηριοποιείται στο χώρο των Τηλεπικοινωνιών. Ερευνητικές περιοχές: Επεξεργασία σήματος με χρήση τεχνικών κυρτής βελτιστοποίησης και φίλτρων σωματιδίων. Επεξεργασία σήματος με χρονομεταβλητή ανάλυση φάσματος. Τυφλή ισοστάθμιση καναλιού. Τεχνικές υποχώρου, ανάλυση ευαισθησίας. Ανάκτηση παραμέτρων πολυδιάστατων αρμονικών, εύρεση κατεύθυνσης και μορφοποίηση λοβού σε συστήματα πολλαπλών κεραιών εκπομπής-λήψης. Εκτίμηση θέσης κόμβων σε δίκτυα αισθητήρων. Πρωτόκολλα προσπέλασης μέσου, αλληλεπίδραση ουρών αναμονής και ευστάθεια. Θεωρία μοναδικής σύνθεσης. Σχεδίαση πομποδεκτών, αποκωδικοποίηση, μοντελοποίηση και χαρακτηρισμός δια-παρεμβολής σε συστήματα πολλαπλών γραμμών ψηφιακού συνδρομητικού βρόχου. Χωρητικότητα καναλιού. Μείωση χωρητικότητας λόγω λανθασμένης εκτίμησης καναλιού. Σχεδιασμός κωδίκων DS-CDMA με παράλληλη ανάπτυξη και χρήση φραγμάτων τύπου Welch. Σχεδιασμός δεκτών DS-CDMA. Εκτίμηση και ισοστάθμιση καναλιού 
10	4	Εργαστήριο Ψηφιακής Επεξεργασίας Σήματος και Εικόνας                                                	Το εργαστήριο ανήκει στον Τομέα Τηλεπικοινωνιών και δραστηριοποιείται σε εφαρμογές που άπτονται της λήψης και αναγνώρισης σήματος, καθώς και της διάγνωσης λειτουργικών προβλημάτων που αποτυπώνονται στα σήματα αυτά, με εφαρμογές στις Τηλεπικοινωνίες, Βιομηχανία, και Βιοϊατρική. Ερευνητικές περιοχές: Επεξεργασία βιοϊατρικών σημάτων και εικόνων. Μηχανική όραση και μη- επεμβατικοί μέθοδοι διάγνωσης βλαβών. Μέθοδοι αναζήτησης σε βάσεις εικόνων και video. Επεξεργασία, ανάλυση και συμπίεση video. Μη-γραμμική μοντελοποίηση συστημάτων με μεθόδους τεχνητής νοημοσύνης. Νευρωνικά δίκτυα και συστήματα ασαφούς λογικής. Επεξεργασία χρονοσειρών 
\.


--
-- Data for Name: Lab_fields; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public."Lab_fields" (lab_code, field_code) FROM stdin;
1	ΑΓΓ
1	ΜΑΘ
1	ΜΠΔ
1	ΣΥΣ
2	ΑΓΓ
2	ΕΚΠ
2	ΗΜΥ
2	ΚΕΠ
2	ΜΑΘ
2	ΠΛΗ
3	ΑΓΓ
3	ΕΝΕ
3	ΗΜΥ
3	ΜΑΘ
3	ΦΥΣ
4	ΑΓΓ
4	ΗΜΥ
4	ΗΡΥ
4	ΜΑΘ
4	ΦΥΣ
5	ΑΓΓ
5	ΗΜΥ
5	ΗΡΥ
5	ΜΑΘ
6	ΑΓΓ
6	ΗΜΥ
6	ΚΕΠ
6	ΜΑΘ
6	ΤΗΛ
7	ΑΓΓ
7	ΕΚΠ
7	ΗΜΥ
7	ΚΕΠ
7	ΜΑΘ
7	ΠΛΗ
7	ΤΗΛ
8	ΑΓΓ
8	ΕΚΠ
8	ΗΜΥ
8	ΚΕΠ
8	ΜΑΘ
8	ΠΛΗ
9	ΑΓΓ
9	ΗΜΥ
9	ΚΕΠ
9	ΜΑΘ
9	ΤΗΛ
9	ΦΥΣ
10	ΑΓΓ
10	ΗΜΥ
10	ΚΕΠ
10	ΜΑΘ
10	ΣΥΣ
10	ΤΗΛ
\.


--
-- Data for Name: Labstaff; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public."Labstaff" (levels, amka, works_lab) FROM stdin;
B	9237022162	3
C	5016674518	10
A	4244532307	5
D	2809479422	5
C	5671479585	6
C	1007060797	7
D	1525346765	1
B	2922934324	2
D	4537508183	8
D	3770027735	2
C	1722013912	3
C	4396969433	4
C	5113980593	5
C	7208091686	8
D	2251361154	5
B	8257350009	8
B	1317009026	7
A	9264263922	1
A	3599046570	7
C	5805429749	7
C	5714303328	9
D	4394391742	2
B	9983481564	10
A	3641959911	1
A	9388483454	8
A	1222679393	6
B	5627860785	4
A	3175341684	10
B	5294679305	9
C	4070566984	5
C	9762608642	3
C	5776308272	9
A	4238000193	4
B	2395076474	5
B	9973902126	6
B	5344490147	3
A	5347910311	2
D	7061852022	2
D	9543741137	2
C	5458344170	10
B	3653674706	5
A	1265755050	4
A	8855313603	4
C	7767655300	9
B	7473846737	2
A	1106674759	7
D	6025005311	7
B	7790855763	8
C	9370938681	7
C	8624051886	4
B	3596285513	6
A	5085242010	6
A	3018443629	5
C	3579767082	5
B	7727201926	7
B	2406927085	3
B	3802446476	10
C	3355062713	9
D	4582268774	3
C	8097125781	9
B	6425629697	5
B	4344877417	5
C	3873434055	8
C	9663629895	8
B	5739953896	8
A	3847336182	4
D	5008120044	10
D	1087864209	10
A	9909188205	6
D	4551861182	2
C	5546208379	10
D	3562862913	10
C	4817616232	5
B	4401521984	3
C	1330518214	9
B	2291462970	6
A	4508196743	10
D	6355523530	6
A	9082318738	4
A	3879135430	7
B	4979575418	9
A	2678604252	8
C	7964377440	3
D	6998019048	4
D	5258371335	4
A	5691579368	9
C	8404946138	6
C	8060817812	3
B	8046642081	8
C	2987214913	7
D	6157943595	3
C	4472271784	3
D	6332092331	2
B	9031377650	10
A	4135901681	10
C	2072046228	9
A	2878713838	4
A	8144021725	10
D	2159910442	9
D	2787902044	9
A	2695882908	1
D	6706118821	8
B	5350764961	8
B	6513499141	5
D	1107640811	2
D	5681283176	8
C	7804962112	10
D	4615837554	1
C	2036806708	4
B	6887280851	4
\.


--
-- Data for Name: Name; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public."Name" (name, sex) FROM stdin;
ΑΒΕΡΚΙΟΣ                      	M
ΑΒΡΑΑΜ                        	M
ΑΓΑΘΗ                         	F
ΑΓΑΘΟΚΛΗΣ                     	M
ΑΓΑΘΟΝΙΚΗ                     	F
ΑΓΑΘΟΥΛΑ                      	F
ΑΓΑΜΕΜΝΩΝ                     	M
ΑΓΑΠΗ                         	F
ΑΓΑΠΙΟΣ                       	M
ΑΓΓΕΛΑ                        	F
ΑΓΓΕΛΗΣ                       	M
ΑΓΓΕΛΙΚΗ                      	F
ΑΓΓΕΛΙΚΟΥΛΑ                   	F
ΑΓΓΕΛΙΝΑ                      	F
ΑΓΓΕΛΟΣ                       	M
ΑΓΗΣΙΛΑΟΣ                     	M
ΑΓΛΑΪΑ                        	F
ΑΓΝΗ                          	F
ΑΓΟΡΑΣΤΗ                      	F
ΑΓΟΡΗ                         	F
ΑΓΟΡΙΤΣΑ                      	F
ΑΓΟΡΟΥΛΑ                      	F
ΑΔΑΜ                          	M
ΑΔΕΛΑΪΔΑ                      	F
ΑΔΡΙΑΝΟΣ                      	M
ΑΘΑΝΑΣΙΑ                      	F
ΑΘΑΝΑΣΙΟΣ                     	M
ΑΘΗΝΑ                         	F
ΑΘΗΝΟΔΩΡΟΣ                    	M
ΑΘΗΝΟΥΛΑ                      	F
ΑΙΓΛΗ                         	F
ΑΙΚΑΤΕΡΙΝΑ                    	F
ΑΙΚΑΤΕΡΙΝΗ                    	F
ΑΙΜΙΛΙΑ                       	F
ΑΙΜΙΛΙΟΣ                      	M
ΑΚΡΙΒΗ                        	F
ΑΚΡΙΒΟΥΛΑ                     	F
ΑΛΒΕΡΤΟΣ                      	M
ΑΛΕΚΑ                         	F
ΑΛΕΞΑΝΔΡΑ                     	F
ΑΛΕΞΑΝΔΡΟΣ                    	M
ΑΛΕΞΙΑ                        	F
ΑΛΕΞΙΟΣ                       	M
ΑΛΙΚΗ                         	F
ΑΛΚΗΣ                         	M
ΑΛΚΗΣΤΙΣ                      	F
ΑΛΚΙΒΙΑΔΗΣ                    	M
ΑΛΚΙΝΟΗ                       	F
ΑΛΚΙΝΟΟΣ                      	M
ΑΛΚΙΣΤΗ                       	F
ΑΛΚΜΗΝΗ                       	F
ΑΛΤΑΝΗ                        	F
ΑΜΑΛΙΑ                        	F
ΑΜΑΡΥΛΛΙΣ                     	F
ΑΜΥΓΔΑΛΙΑ                     	F
ΑΜΦΙΤΡΙΤΗ                     	F
ΑΝΑΡΓΥΡΟΣ                     	M
ΑΝΑΣΤΑ                        	F
ΑΝΑΣΤΑΣΙΑ                     	F
ΑΝΑΣΤΑΣΙΟΣ                    	M
ΑΝΑΤΟΛΗ                       	F
ΑΝΔΡΕΑΝΑ                      	F
ΑΝΔΡΕΑΝΝΑ                     	F
ΑΝΔΡΕΑΣ                       	M
ΑΝΔΡΙΑΝΑ                      	F
ΑΝΔΡΙΑΝΗ                      	F
ΑΝΔΡΙΑΝΝΑ                     	F
ΑΝΔΡΙΑΝΟΣ                     	M
ΑΝΔΡΟΚΛΗΣ                     	M
ΑΝΔΡΟΜΑΧΗ                     	F
ΑΝΔΡΟΝΙΚΗ                     	F
ΑΝΔΡΟΝΙΚΟΣ                    	M
ΑΝΔΡΟΥΛΑ                      	F
ΑΝΕΖΑ                         	F
ΑΝΕΣΤΗΣ                       	M
ΑΝΕΤΑ                         	F
ΑΝΘΗ                          	F
ΑΝΘΙΑ                         	F
ΑΝΘΙΜΟΣ                       	M
ΑΝΘΙΠΠΗ                       	F
ΑΝΘΟΥΛΑ                       	F
ΑΝΙΤΑ                         	F
ΑΝΝΑ                          	F
ΑΝΝΕΤΑ                        	F
ΑΝΝΗ                          	F
ΑΝΝΙΤΑ                        	F
ΑΝΤΖΕΛΑ                       	F
ΑΝΤΙΓΟΝΗ                      	F
ΑΝΤΙΟΠΗ                       	F
ΑΝΤΡΕΑ                        	F
ΑΝΤΡΙΑΝΑ                      	F
ΑΝΤΩΝΙΑ                       	F
ΑΝΤΩΝΙΝΑ                      	F
ΑΝΤΩΝΙΟΣ                      	M
ΑΝΥΣΙΑ                        	F
ΑΠΟΛΛΩΝ                       	M
ΑΠΟΣΤΟΛΙΑ                     	F
ΑΠΟΣΤΟΛΙΝΑ                    	F
ΑΠΟΣΤΟΛΟΣ                     	M
ΑΡΓΥΡΗ                        	F
ΑΡΓΥΡΙΑ                       	F
ΑΡΓΥΡΙΟΣ                      	M
ΑΡΓΥΡΟΥΛΑ                     	F
ΑΡΓΥΡΩ                        	F
ΑΡΕΤΗ                         	F
ΑΡΗΣ                          	M
ΑΡΙΑΔΝΗ                       	F
ΑΡΙΑΝ                         	M
ΑΡΙΣΤΕΑ                       	F
ΑΡΙΣΤΕΙΔΗΣ                    	M
ΑΡΙΣΤΗ                        	F
ΑΡΙΣΤΟΓΕΙΤΩΝ                  	M
ΑΡΙΣΤΟΜΕΝΗΣ                   	M
ΑΡΙΣΤΟΣ                       	M
ΑΡΙΣΤΟΤΕΛΗΣ                   	M
ΑΡΙΣΤΟΥΛΑ                     	F
ΑΡΙΣΤΟΦΑΝΗΣ                   	M
ΑΡΣΕΝΙΑ                       	F
ΑΡΣΕΝΙΟΣ                      	M
ΑΡΣΙΝΟΗ                       	F
ΑΡΤΕΜΗΣΙΑ                     	F
ΑΡΤΕΜΙΟΣ                      	M
ΑΡΤΕΜΙΣ                       	F
ΑΡΧΙΜΗΔΗΣ                     	M
ΑΡΧΟΝΤΗ                       	F
ΑΡΧΟΝΤΙΑ                      	F
ΑΡΧΟΝΤΙΣΣΑ                    	F
ΑΡΧΟΝΤΟΥΛΑ                    	F
ΑΡΧΟΝΤΩ                       	F
ΑΣΗΜΑΚΗΣ                      	M
ΑΣΗΜΕΝΗ                       	F
ΑΣΗΜΕΝΙΑ                      	F
ΑΣΗΜΙΝΑ                       	F
ΑΣΗΜΟΥΛΑ                      	F
ΑΣΗΜΩ                         	F
ΑΣΠΑΣΙΑ                       	F
ΑΣΤΕΡΙΑ                       	F
ΑΣΤΕΡΙΟΣ                      	M
ΑΣΤΕΡΩ                        	F
ΑΣΤΡΙΝΙΑ                      	F
ΑΣΤΡΙΝΟΣ                      	M
ΑΤΑΛΑΝΤΗ                      	F
ΑΥΓΕΡΙΝΟΣ                     	M
ΑΥΓΗ                          	F
ΑΥΓΟΥΣΤΙΝΑ                    	F
ΑΥΓΟΥΣΤΙΝΗ                    	F
ΑΥΓΟΥΣΤΙΝΟΣ                   	M
ΑΥΡΑ                          	F
ΑΦΕΝΔΡΑ                       	F
ΑΦΕΝΤΟΥΛΑ                     	F
ΑΦΘΟΝΙΑ                       	F
ΑΦΡΟΔΙΤΗ                      	F
ΑΧΙΛΛΕΑΣ                      	M
ΑΧΜΕΤ                         	M
ΒΑΓΙΑ                         	F
ΒΑΓΙΟΥΛΑ                      	F
ΒΑΪΑ                          	F
ΒΑΪΟΣ                         	M
ΒΑΪΤΣΑ                        	F
ΒΑΚΙΝΑ                        	F
ΒΑΛΑΝΤΗΣ                      	M
ΒΑΛΑΣΙΑ                       	F
ΒΑΛΕΝΤΙΝΑ                     	F
ΒΑΛΕΝΤΙΝΗ                     	F
ΒΑΛΕΝΤΙΝΟΣ                    	M
ΒΑΛΣΑΜΗΣ                      	M
ΒΑΡΒΑΡΑ                       	F
ΒΑΣΙΛΕΙΑ                      	F
ΒΑΣΙΛΕΙΟΣ                     	M
ΒΑΣΙΛΙΚΗ                      	F
ΒΑΣΟΥΛΑ                       	F
ΒΑΣΩ                          	F
ΒΕΑΤΡΙΚΗ                      	F
ΒΕΛΙΣΣΑΡΙΑ                    	F
ΒΕΛΙΣΣΑΡΙΟΣ                   	M
ΒΕΛΟΥΔΩ                       	F
ΒΕΝΕΤΑ                        	F
ΒΕΝΕΤΙΑ                       	F
ΒΕΝΕΤΤΑ                       	F
ΒΕΝΙΑΜΙΝ                      	M
ΒΕΡΑ                          	F
ΒΕΡΓΟΣ                        	M
ΒΕΡΟΝΙΚΑ                      	F
ΒΕΡΟΝΙΚΗ                      	F
ΒΗΘΛΕΕΜ                       	F
ΒΗΣΣΑΡΙΑ                      	F
ΒΗΣΣΑΡΙΟΣ                     	M
ΒΗΣΣΑΡΙΩΝ                     	M
ΒΙΚΕΝΤΙΑ                      	F
ΒΙΚΤΩΡ                        	M
ΒΙΚΤΩΡΙΑ                      	F
ΒΙΚΥ                          	F
ΒΙΛΕΛΜΙΝΗ                     	F
ΒΙΟΛΕΤΤΑ                      	F
ΒΙΡΓΙΝΙΑ                      	F
ΒΛΑΔΙΜΗΡΟΣ                    	M
ΒΛΑΣΙΑ                        	F
ΒΛΑΣΙΟΣ                       	M
ΒΥΡΩΝ                         	M
ΓΑΒΡΙΗΛ                       	M
ΓΑΛΑΤΕΙΑ                      	F
ΓΑΛΗΝΗ                        	F
ΓΑΡΟΥΦΑΛΙΑ                    	F
ΓΑΡΥΦΑΛΙΑ                     	F
ΓΑΡΥΦΑΛΛΙΑ                    	F
ΓΕΝΟΒΕΦΑ                      	F
ΓΕΡΑΚΙΝΑ                      	F
ΓΕΡΑΣΙΜΗ                      	F
ΓΕΡΑΣΙΜΙΑ                     	F
ΓΕΡΑΣΙΜΙΝΑ                    	F
ΓΕΡΑΣΙΜΟΣ                     	M
ΓΕΡΑΣΙΜΟΥΛΑ                   	F
ΓΕΣΘΗΜΑΝΗ                     	F
ΓΕΩΡΓΙΑ                       	F
ΓΕΩΡΓΙΟΣ                      	M
ΓΙΑΣΕΜΗ                       	F
ΓΙΟΛΑΝΤΑ                      	F
ΓΙΟΥΛΑ                        	F
ΓΚΟΛΦΩ                        	F
ΓΛΥΚΕΡΙΑ                      	F
ΓΟΥΛΙΕΛΜΟΣ                    	M
ΓΡΑΜΜΑΤΗ                      	F
ΓΡΑΜΜΑΤΙΑ                     	F
ΓΡΑΜΜΑΤΙΚΗ                    	F
ΓΡΑΜΜΑΤΟΥΛΑ                   	F
ΓΡΗΓΟΡΙΑ                      	F
ΓΡΗΓΟΡΙΟΣ                     	M
ΔΑΜΙΑΝΟΣ                      	M
ΔΑΝΑΗ                         	F
ΔΑΝΙΕΛΑ                       	F
ΔΑΝΙΗΛ                        	M
ΔΑΥΪΔ                         	M
ΔΑΦΝΗ                         	F
ΔΕΣΠΟΙΝΑ                      	F
ΔΕΣΠΩ                         	F
ΔΗΜΗΤΡΑ                       	F
ΔΗΜΗΤΡΙΑ                      	F
ΔΗΜΗΤΡΙΟΣ                     	M
ΔΗΜΟΚΡΙΤΟΣ                    	M
ΔΗΜΟΣ                         	M
ΔΗΜΟΥΛΑ                       	F
ΔΙΑΛΕΚΤΗ                      	F
ΔΙΑΛΕΧΤΗ                      	F
ΔΙΑΜΑΝΤΗ                      	F
ΔΙΑΜΑΝΤΗΣ                     	M
ΔΙΑΜΑΝΤΙΝΑ                    	F
ΔΙΑΜΑΝΤΟΥΛΑ                   	F
ΔΙΑΜΑΝΤΩ                      	F
ΔΙΑΝΑ                         	F
ΔΙΚΑΙΑ                        	F
ΔΙΟΓΕΝΗΣ                      	M
ΔΙΟΜΗ                         	F
ΔΙΟΝΥΣΙΑ                      	F
ΔΙΟΝΥΣΙΟΣ                     	M
ΔΟΜΗΝΙΚΗ                      	F
ΔΟΜΝΑ                         	F
ΔΟΜΝΙΚΗ                       	F
ΔΟΝΑΤΟΣ                       	M
ΔΟΞΑ                          	F
ΔΟΥΚΙΣΣΑ                      	F
ΔΡΟΣΙΑ                        	F
ΔΡΟΣΟΣ                        	M
ΔΡΟΣΟΥΛΑ                      	F
ΔΩΡΟΘΕΑ                       	F
ΕΔΟΥΑΡΔΟΣ                     	M
ΕΙΡΗΝΑΙΟΣ                     	M
ΕΙΡΗΝΗ                        	F
ΕΚΤΩΡ                         	M
ΕΛΒΙΡΑ                        	F
ΕΛΕΑΝΑ                        	F
ΕΛΕΑΝΝΑ                       	F
ΕΛΕΝΑ                         	F
ΕΛΕΝΗ                         	F
ΕΛΕΟΝΩΡΑ                      	F
ΕΛΕΥΘΕΡΙΑ                     	F
ΕΛΕΥΘΕΡΙΟΣ                    	M
ΕΛΕΩΝΟΡΑ                      	F
ΕΛΙΑ                          	F
ΕΛΙΖΑ                         	F
ΕΛΙΝΑ                         	F
ΕΛΙΣΑΒΕΤ                      	F
ΕΛΙΣΣΑΙΟΣ                     	M
ΕΛΛΑΔΑ                        	F
ΕΛΛΗ                          	F
ΕΛΠΙΔΑ                        	F
ΕΛΠΙΝΙΚΗ                      	F
ΕΜΜΑΝΟΥΕΛΑ                    	F
ΕΜΜΑΝΟΥΗΛ                     	M
ΕΜΜΕΛΕΙΑ                      	F
ΕΜΟΡΦΙΑ                       	F
ΕΜΟΡΦΙΛΗ                      	F
ΕΠΑΜΕΙΝΩΝΔΑΣ                  	M
ΕΠΙΣΤΗΜΗ                      	F
ΕΡΑΣΜΙΑ                       	F
ΕΡΑΤΩ                         	F
ΕΡΗ                           	F
ΕΡΙΦΙΛΗ                       	F
ΕΡΙΦΥΛΗ                       	F
ΕΡΙΦΥΛΛΗ                      	F
ΕΡΜΙΝΑ                        	F
ΕΡΜΙΟΝΗ                       	F
ΕΡΜΟΛΑΟΣ                      	M
ΕΡΡΙΚΑ                        	F
ΕΡΡΙΚΟΣ                       	M
ΕΡΣΗ                          	F
ΕΡΩΦΙΛΗ                       	F
ΕΥΑ                           	F
ΕΥΑΓΓΕΛΗ                      	F
ΕΥΑΓΓΕΛΙΑ                     	F
ΕΥΑΓΓΕΛΟΣ                     	M
ΕΥΑΝΘΙΑ                       	F
ΕΥΒΟΙΑ                        	F
ΕΥΓΕΝΙΑ                       	F
ΕΥΓΕΝΙΟΣ                      	M
ΕΥΔΟΚΙΑ                       	F
ΕΥΔΟΞΙΑ                       	F
ΕΥΔΟΞΙΟΣ                      	M
ΕΥΘΑΛΕΙΑ                      	F
ΕΥΘΑΛΙΑ                       	F
ΕΥΘΥΜΙΑ                       	F
ΕΥΘΥΜΙΟΣ                      	M
ΕΥΚΛΕΙΑ                       	F
ΕΥΛΑΒΙΑ                       	F
ΕΥΛΑΛΙΑ                       	F
ΕΥΛΑΜΠΙΑ                      	F
ΕΥΜΟΡΦΙΑ                      	F
ΕΥΜΟΡΦΙΛΗ                     	F
ΕΥΠΡΑΞΙΑ                      	F
ΕΥΡΙΔΙΚΗ                      	F
ΕΥΡΙΚΛΕΙΑ                     	F
ΕΥΡΙΠΙΔΗΣ                     	M
ΕΥΡΥΔΙΚΗ                      	F
ΕΥΡΥΚΛΕΙΑ                     	F
ΕΥΡΩΠΗ                        	F
ΕΥΣΕΒΕΙΑ                      	F
ΕΥΣΕΒΙΑ                       	F
ΕΥΣΤΑΘΙΑ                      	F
ΕΥΣΤΑΘΙΟΣ                     	M
ΕΥΣΤΡΑΤΙΑ                     	F
ΕΥΣΤΡΑΤΙΟΣ                    	M
ΕΥΤΕΡΠΗ                       	F
ΕΥΤΥΧΙΑ                       	F
ΕΥΤΥΧΙΟΣ                      	M
ΕΥΦΗΜΙΑ                       	F
ΕΥΦΡΑΞΙΑ                      	F
ΕΥΦΡΟΣΥΝΗ                     	F
ΕΥΧΑΡΙΣ                       	F
ΕΦΗ                           	F
ΖΑΪΡΑ                         	F
ΖΑΚΕΛΙΝΑ                      	F
ΖΑΚΛΙΝ                        	F
ΖΑΜΠΕΤΑ                       	F
ΖΑΜΠΙΑ                        	F
ΖΑΝΝΗΣ                        	M
ΖΑΡΙΦΗΣ                       	M
ΖΑΦΕΙΡΑ                       	F
ΖΑΦΕΙΡΙΑ                      	F
ΖΑΦΕΙΡΙΟΣ                     	M
ΖΑΦΕΙΡΟΥΛΑ                    	F
ΖΑΦΕΙΡΩ                       	F
ΖΑΧΑΡΕΝΙΑ                     	F
ΖΑΧΑΡΙΑΣ                      	M
ΖΑΧΑΡΟΥΛΑ                     	F
ΖΑΧΑΡΩ                        	F
ΖΗΝΟΒΙΑ                       	F
ΖΗΝΩΝ                         	M
ΖΗΣΗΣ                         	M
ΖΗΣΙΜΟΣ                       	M
ΖΟΥΜΠΟΥΛΙΑ                    	F
ΖΩΓΡΑΦΙΑ                      	F
ΖΩΓΡΑΦΩ                       	F
ΖΩΗ                           	F
ΗΒΗ                           	F
ΗΛΕΚΤΡΑ                       	F
ΗΛΙΑ                          	F
ΗΛΙΑΔΑ                        	F
ΗΛΙΑΝΑ                        	F
ΗΛΙΑΝΗ                        	F
ΗΛΙΑΝΝΑ                       	F
ΗΛΙΑΣ                         	M
ΗΡΑ                           	F
ΗΡΑΚΛΗΣ                       	M
ΗΡΩ                           	F
ΗΣΑΪΑ                         	F
ΘΑΛΕΙΑ                        	F
ΘΕΑΝΩ                         	F
ΘΕΚΛΑ                         	F
ΘΕΛΞΙΟΠΗ                      	F
ΘΕΜΙΣ                         	F
ΘΕΜΙΣΤΟΚΛΗΣ                   	M
ΘΕΟΓΝΩΣΙΑ                     	F
ΘΕΟΔΟΣΙΑ                      	F
ΘΕΟΔΟΣΙΟΣ                     	M
ΘΕΟΔΟΤΑ                       	F
ΘΕΟΔΟΤΗ                       	F
ΘΕΟΔΟΥΛΑ                      	F
ΘΕΟΔΟΥΛΗ                      	F
ΘΕΟΔΩΡΑ                       	F
ΘΕΟΔΩΡΟΣ                      	M
ΘΕΟΔΩΡΟΥΛΑ                    	F
ΘΕΟΚΛΕΙΑ                      	F
ΘΕΟΚΛΗΤΟΣ                     	M
ΘΕΟΚΤΙΣΤΗ                     	F
ΘΕΟΛΟΓΙΑ                      	F
ΘΕΟΛΟΓΟΣ                      	M
ΘΕΟΝΙΑ                        	F
ΘΕΟΝΙΤΣΑ                      	F
ΘΕΟΝΥΜΦΗ                      	F
ΘΕΟΠΙΣΤΗ                      	F
ΘΕΟΠΟΥΛΑ                      	F
ΘΕΟΦΑΝΕΙΑ                     	F
ΘΕΟΦΑΝΗ                       	F
ΘΕΟΦΑΝΗΣ                      	M
ΘΕΟΦΑΝΙΑ                      	F
ΘΕΟΦΑΝΩ                       	F
ΘΕΟΦΙΛΗ                       	F
ΘΕΟΦΙΛΟΣ                      	M
ΘΕΟΦΥΛΑΚΤΟΣ                   	M
ΘΕΟΧΑΡΗ                       	F
ΘΕΟΧΑΡΗΣ                      	M
ΘΕΟΧΑΡΙΣ                      	F
ΘΕΟΧΑΡΟΥΛΑ                    	F
ΘΕΣΣΑΛΟΝΙΚΗ                   	F
ΘΕΩΝΗ                         	F
ΘΗΡΕΣΙΑ                       	F
ΘΙΣΒΗ                         	F
ΘΡΑΣΥΒΟΥΛΟΣ                   	M
ΘΩΜΑΗ                         	F
ΘΩΜΑΪΣ                        	F
ΘΩΜΑΣ                         	M
ΘΩΜΗ                          	F
ΙΑΚΩΒΟΣ                       	M
ΙΑΝΘΗ                         	F
ΙΑΣΩΝ                         	M
ΙΒΕΛΙΝΑ                       	F
ΙΓΝΑΤΙΑ                       	F
ΙΓΝΑΤΙΟΣ                      	M
ΙΕΡΟΘΕΟΣ                      	M
ΙΚΑΡΟΣ                        	M
ΙΛΕΑΝΑ                        	F
ΙΛΙΑΔΑ                        	F
ΙΛΙΑΝΑ                        	F
ΙΟΚΑΣΤΗ                       	F
ΙΟΡΔΑΝΑ                       	F
ΙΟΡΔΑΝΗΣ                      	M
ΙΟΥΛΙΑ                        	F
ΙΟΥΛΙΟΣ                       	M
ΙΟΥΛΙΤΤΑ                      	F
ΙΠΠΟΚΡΑΤΗΣ                    	M
ΙΠΠΟΛΥΤΗ                      	F
ΙΡΙΣ                          	F
ΙΣΑΑΚ                         	M
ΙΣΑΒΕΛΛΑ                      	F
ΙΣΙΔΩΡΑ                       	F
ΙΣΙΔΩΡΟΣ                      	M
ΙΣΜΗΝΗ                        	F
ΙΦΙΓΕΝΕΙΑ                     	F
ΙΩΑΚΕΙΜ                       	M
ΙΩΑΝΝΑ                        	F
ΙΩΑΝΝΗΣ                       	M
ΙΩΝ                           	M
ΙΩΣΗΦ                         	M
ΚΑΔΙΑΝΗ                       	F
ΚΑΘΟΛΙΚΗ                      	F
ΚΑΙΤΗ                         	F
ΚΑΛΗ                          	F
ΚΑΛΛΙΑΝΘΗ                     	F
ΚΑΛΛΙΝΑ                       	F
ΚΑΛΛΙΟΠΗ                      	F
ΚΑΛΛΙΡΡΟΗ                     	F
ΚΑΛΛΙΣΘΕΝΗ                    	F
ΚΑΛΟΜΟΙΡΑ                     	F
ΚΑΛΟΥΔΑ                       	F
ΚΑΛΥΨΩ                        	F
ΚΑΝΕΛΛΑ                       	F
ΚΑΝΕΛΛΟΣ                      	M
ΚΑΡΜΕΝ                        	F
ΚΑΡΟΛΙΝΑ                      	F
ΚΑΡΟΛΟΣ                       	M
ΚΑΡΥΟΦΥΛΛΗΣ                   	M
ΚΑΡΥΟΦΥΛΛΙΑ                   	F
ΚΑΣΣΑΝΔΡΑ                     	F
ΚΑΣΣΙΑΝΗ                      	F
ΚΑΤΙΝΑ                        	F
ΚΕΡΑΣΑ                        	F
ΚΕΡΑΣΙΑ                       	F
ΚΕΡΑΣΙΝΑ                      	F
ΚΕΡΑΣΟΥΛΑ                     	F
ΚΗΡΥΚΟΣ                       	M
ΚΙΚΗ                          	F
ΚΙΜΩΝ                         	M
ΚΛΑΙΡΗ                        	F
ΚΛΕΑΝΘΗ                       	F
ΚΛΕΑΝΘΗΣ                      	M
ΚΛΕΑΡΧΟΣ                      	M
ΚΛΕΙΩ                         	F
ΚΛΕΟΒΟΥΛΟΣ                    	M
ΚΛΕΟΜΕΝΗΣ                     	M
ΚΛΕΟΝΙΚΗ                      	F
ΚΛΕΟΠΑΤΡΑ                     	F
ΚΛΕΩΝ                         	M
ΚΛΗΜΕΝΤΙΝΗ                    	F
ΚΛΗΜΗΣ                        	M
ΚΛΥΤΑΙΜΝΗΣΤΡΑ                 	F
ΚΟΜΝΗΝΟΣ                      	M
ΚΟΜΝΩ                         	F
ΚΟΝΔΥΛΕΝΙΑ                    	F
ΚΟΝΔΥΛΙΑ                      	F
ΚΟΝΔΥΛΙΑ ΜΑΡΙΑ                	F
ΚΟΡΑΛΙΑ                       	F
ΚΟΡΙΝΑ                        	F
ΚΟΡΙΝΝΑ                       	F
ΚΟΡΝΗΛΙΑ                      	F
ΚΟΡΝΗΛΙΟΣ                     	M
ΚΟΣΜΑΣ                        	M
ΚΡΙΣΤΙ                        	F
ΚΡΟΥΣΤΑΛΕΝΙΑ                  	F
ΚΡΥΣΤΑΛΙΑ                     	F
ΚΡΥΣΤΑΛΛΕΝΙΑ                  	F
ΚΡΥΣΤΑΛΛΗ                     	F
ΚΡΥΣΤΑΛΛΙΑ                    	F
ΚΡΥΣΤΑΛΛΩ                     	F
ΚΥΒΕΛΗ                        	F
ΚΥΠΑΡΙΣΣΙΑ                    	F
ΚΥΡΑ                          	F
ΚΥΡΑΝΝΑ                       	F
ΚΥΡΑΤΣΩ                       	F
ΚΥΡΙΑΖΗΣ                      	M
ΚΥΡΙΑΚΗ                       	F
ΚΥΡΙΑΚΟΣ                      	M
ΚΥΡΙΛΛΟΣ                      	M
ΚΥΡΟΣ                         	M
ΚΩΝΣΤΑΝΤΙΑ                    	F
ΚΩΝΣΤΑΝΤΙΝΑ                   	F
ΚΩΝΣΤΑΝΤΙΝΗ                   	F
ΚΩΝΣΤΑΝΤΙΝΙΑ                  	F
ΚΩΝΣΤΑΝΤΙΝΟΣ                  	M
ΚΩΝΣΤΑΝΤΟΥΛΑ                  	F
ΚΩΣΤΟΥΛΑ                      	F
ΛΑΖΑΡΟΣ                       	M
ΛΑΜΠΡΑΚΗΣ                     	M
ΛΑΜΠΡΙΑΝΑ                     	F
ΛΑΜΠΡΙΝΗ                      	F
ΛΑΜΠΡΟΣ                       	M
ΛΑΟΥΡΑ                        	F
ΛΑΣΚΑΡΙΝΑ                     	F
ΛΑΥΡΕΝΤΙΑ                     	F
ΛΑΥΡΕΝΤΙΟΣ                    	M
ΛΕΑΝΔΡΟΣ                      	M
ΛΕΪΛΑ                         	F
ΛΕΛΟΥΔΑ                       	F
ΛΕΜΟΝΙΑ                       	F
ΛΕΟΝΑΡΔΟΣ                     	M
ΛΕΥΚΗ                         	F
ΛΕΥΚΟΘΕΑ                      	F
ΛΕΩΝΙΔΑΣ                      	M
ΛΗΔΑ                          	F
ΛΗΤΩ                          	F
ΛΙΛΙΑΝΑ                       	F
ΛΙΝΑ                          	F
ΛΟΥΪΖΑ                        	F
ΛΟΥΚΑΣ                        	M
ΛΟΥΚΙΑ                        	F
ΛΟΥΛΟΥΔΙΑ                     	F
ΛΥΓΕΡΗ                        	F
ΛΥΔΙΑ                         	F
ΛΥΚΟΥΡΓΟΣ                     	M
ΜΑΓΔΑΛΗΝΗ                     	F
ΜΑΓΙΟΥΛΑ                      	F
ΜΑΙΡΗ                         	F
ΜΑΚΑΡΙΟΣ                      	M
ΜΑΚΡΙΝΑ                       	F
ΜΑΛΑΜΑ                        	F
ΜΑΛΑΜΑΤΕΝΙΑ                   	F
ΜΑΛΑΜΑΤΗ                      	F
ΜΑΛΑΜΩ                        	F
ΜΑΛΒΙΝΑ                       	F
ΜΑΝΘΑ                         	F
ΜΑΝΙΑ                         	F
ΜΑΝΟΥΕΛΑ                      	F
ΜΑΝΟΥΣΟΣ                      	M
ΜΑΝΩΛΙΑ                       	F
ΜΑΡΓΑΡΙΤΑ                     	F
ΜΑΡΓΑΡΙΤΗΣ                    	M
ΜΑΡΓΑΡΩ                       	F
ΜΑΡΓΙΤΣΑ                      	F
ΜΑΡΘΑ                         	F
ΜΑΡΙ                          	F
ΜΑΡΙΑ                         	F
ΜΑΡΙΓΟΥΛΑ                     	F
ΜΑΡΙΓΩ                        	F
ΜΑΡΙΕΤΤΑ                      	F
ΜΑΡΙΚΑ                        	F
ΜΑΡΙΛΕΝΑ                      	F
ΜΑΡΙΝΑ                        	F
ΜΑΡΙΝΟΣ                       	M
ΜΑΡΙΟ                         	M
ΜΑΡΙΟΣ                        	M
ΜΑΡΚΕΛΛΑ                      	F
ΜΑΡΚΟΣ                        	M
ΜΑΡΟΥΔΑ                       	F
ΜΑΡΟΥΔΙΑ                      	F
ΜΑΡΟΥΛΑ                       	F
ΜΑΡΟΥΛΗ                       	F
ΜΑΡΟΥΛΙΑ                      	F
ΜΑΡΟΥΛΙΩ                      	F
ΜΑΡΟΥΣΑ                       	F
ΜΑΡΩ                          	F
ΜΑΤΘΑΙΟΣ                      	M
ΜΑΤΙΝΑ                        	F
ΜΑΤΟΥΛΑ                       	F
ΜΑΥΡΑ                         	F
ΜΑΥΡΕΤΑ                       	F
ΜΑΥΡΟΥΔΗΣ                     	M
ΜΕΛΑΝΘΙΑ                      	F
ΜΕΛΑΝΙΑ                       	F
ΜΕΛΑΧΡΟΙΝΗ                    	F
ΜΕΛΕΤΙΟΣ                      	M
ΜΕΛΙΝΑ                        	F
ΜΕΛΠΟΜΕΝΗ                     	F
ΜΕΝΕΛΑΟΣ                      	M
ΜΕΝΕΞΙΑ                       	F
ΜΕΡΚΟΥΡΙΟΣ                    	M
ΜΕΡΟΠΗ                        	F
ΜΕΡΣΙΝΑ                       	F
ΜΕΡΣΙΝΗ                       	F
ΜΕΤΑΜΟΡΦΗ                     	F
ΜΕΤΑΞΕΝΙΑ                     	F
ΜΕΤΑΞΙΑ                       	F
ΜΕΤΑΞΟΥΛΑ                     	F
ΜΗΛΙΑ                         	F
ΜΗΝΑ                          	F
ΜΗΝΑΣ                         	M
ΜΗΤΡΟΔΩΡΑ                     	F
ΜΙΚΑΕΛΑ                       	F
ΜΙΛΤΙΑΔΗΣ                     	M
ΜΙΝΑ                          	F
ΜΙΡΑΝΤΑ                       	F
ΜΙΧΑΕΛΑ                       	F
ΜΙΧΑΗΛ                        	M
ΜΙΧΑΛΙΑ                       	F
ΜΙΧΑΛΙΤΣΑ                     	F
ΜΟΝΙΚΑ                        	F
ΜΟΡΦΟΥΛΑ                      	F
ΜΟΣΧΟΣ                        	M
ΜΟΣΧΟΥΛΑ                      	F
ΜΠΕΤΙΝΑ                       	F
ΜΥΡΟΠΗ                        	F
ΜΥΡΟΦΟΡΑ                      	F
ΜΥΡΣΙΝΗ                       	F
ΜΥΡΤΩ                         	F
ΜΥΡΩΝ                         	M
ΜΩΥΣΗΣ                        	M
ΝΑΚΟΣ                         	M
ΝΑΝΤΙΑ                        	F
ΝΑΟΥΜ                         	M
ΝΑΠΟΛΕΩΝ                      	M
ΝΑΤΑΛΙΑ                       	F
ΝΑΤΑΣΑ                        	F
ΝΑΥΣΙΚΑ                       	F
ΝΕΚΤΑΡΙΑ                      	F
ΝΕΚΤΑΡΙΟΣ                     	M
ΝΕΟΚΛΗΣ                       	M
ΝΕΟΦΥΤΟΣ                      	M
ΝΕΡΑΝΤΖΟΥΛΑ                   	F
ΝΕΣΤΟΡΑΣ                      	M
ΝΕΣΤΩΡ                        	M
ΝΕΦΕΛΗ                        	F
ΝΙΚΗ                          	F
ΝΙΚΗΤΑΣ                       	M
ΝΙΚΟΔΗΜΟΣ                     	M
ΝΙΚΟΛ                         	F
ΝΙΚΟΛΑΟΣ                      	M
ΝΙΚΟΛΕΤΑ                      	F
ΝΙΚΟΛΕΤΤΑ                     	F
ΝΙΚΟΛΙΑ                       	F
ΝΙΚΟΛΙΝΑ                      	F
ΝΙΚΟΛΙΤΣΑ                     	F
ΝΙΝΑ                          	F
ΝΙΟΒΗ                         	F
ΝΟΜΙΚΗ                        	F
ΝΟΡΑ                          	F
ΝΤΙΑΝΑ                        	F
ΝΤΙΝΑ                         	F
ΞΑΚΟΥΣΤΗ                      	F
ΞΑΝΘΗ                         	F
ΞΑΝΘΙΠΠΗ                      	F
ΞΑΝΘΟΥΛΑ                      	F
ΞΕΝΗ                          	F
ΞΕΝΙΑ                         	F
ΞΕΝΟΦΩΝ                       	M
ΟΔΥΣΣΕΑΣ                      	M
ΟΘΩΝ                          	M
ΟΛΓΑ                          	F
ΟΛΥΜΠΙΑ                       	F
ΟΜΗΡΟΣ                        	M
ΟΜΟΡΦΟΥΛΑ                     	F
ΟΝΟΥΦΡΙΟΣ                     	M
ΟΡΕΣΤΗΣ                       	M
ΟΡΣΑΛΙΑ                       	F
ΟΡΣΙΑ                         	F
ΟΡΧΑΝ                         	M
ΟΣΙΑ                          	F
ΟΥΡΑΝΙΑ                       	F
ΠΑΓΩΝΑ                        	F
ΠΑΪΚΟΣ                        	M
ΠΑΪΣΙΟΣ                       	M
ΠΑΝΑΓΙΟΥΛΑ                    	F
ΠΑΝΑΓΙΩ                       	F
ΠΑΝΑΓΙΩΤΑ                     	F
ΠΑΝΑΓΙΩΤΗΣ                    	M
ΠΑΝΑΓΟΥΛΑ                     	F
ΠΑΝΔΩΡΑ                       	F
ΠΑΝΤΑΖΗΣ                      	M
ΠΑΝΤΕΛΗΣ                      	M
ΠΑΝΤΕΛΙΑ                      	F
ΠΑΝΤΕΛΙΤΣΑ                    	F
ΠΑΝΤΩ                         	F
ΠΑΝΩΡΑΙΑ                      	F
ΠΑΝΩΡΕΑ                       	F
ΠΑΡΑΣΚΕΥΑΣ                    	M
ΠΑΡΑΣΚΕΥΗ                     	F
ΠΑΡΑΣΧΟΣ                      	M
ΠΑΡΕΣΑ                        	F
ΠΑΡΘΕΝΑ                       	F
ΠΑΡΘΕΝΙΑ                      	F
ΠΑΡΘΕΝΟΠΗ                     	F
ΠΑΡΙΣ                         	M
ΠΑΡΜΕΝΙΩΝ                     	M
ΠΑΣΧΑΛΗΣ                      	M
ΠΑΣΧΑΛΙΑ                      	F
ΠΑΣΧΑΛΙΝΑ                     	F
ΠΑΣΧΑΛΙΩ                      	F
ΠΑΤΡΑ                         	F
ΠΑΤΡΙΤΣΙΑ                     	F
ΠΑΤΡΟΚΛΟΣ                     	M
ΠΑΤΡΟΥΛΑ                      	F
ΠΑΥΛΙΝΑ                       	F
ΠΑΥΛΟΣ                        	M
ΠΕΛΑΓΙΑ                       	F
ΠΕΛΟΠΙΔΑΣ                     	M
ΠΕΡΙΚΛΗΣ                      	M
ΠΕΡΙΣΤΕΡΑ                     	F
ΠΕΡΣΑ                         	F
ΠΕΡΣΕΦΟΝΗ                     	F
ΠΕΤΡΙΝΑ                       	F
ΠΕΤΡΙΝΗ                       	F
ΠΕΤΡΟΣ                        	M
ΠΕΤΡΟΥΛΑ                      	F
ΠΗΓΗ                          	F
ΠΗΝΕΛΟΠΗ                      	F
ΠΙΠΙΝΑ                        	F
ΠΙΠΙΤΣΑ                       	F
ΠΛΟΥΜΙΣΤΗ                     	F
ΠΟΘΗΤΗ                        	F
ΠΟΛΥΒΙΟΣ                      	M
ΠΟΛΥΔΩΡΟΣ                     	M
ΠΟΛΥΖΩΗΣ                      	M
ΠΟΛΥΚΑΡΠΟΣ                    	M
ΠΟΛΥΜΝΙΑ                      	F
ΠΟΛΥΝΕΙΚΗΣ                    	M
ΠΟΛΥΝΙΚΗ                      	F
ΠΟΛΥΞΕΝΗ                      	F
ΠΟΛΥΤΙΜΗ                      	F
ΠΟΛΥΧΡΟΝΗΣ                    	M
ΠΟΛΥΧΡΟΝΙΑ                    	F
ΠΟΥΛΙΑ                        	F
ΠΟΥΛΧΕΡΙΑ                     	F
ΠΡΕΣΒΕΙΑ                      	F
ΠΡΟΔΡΟΜΟΣ                     	M
ΠΡΟΚΟΠΙΟΣ                     	M
ΠΥΘΑΓΟΡΑΣ                     	M
ΠΥΡΡΟΣ                        	M
ΠΩΛΙΝΑ                        	F
ΡΑΛΛΗΣ                        	M
ΡΑΛΛΟΥ                        	F
ΡΑΦΑΕΛΑ                       	F
ΡΑΦΑΗΛ                        	M
ΡΑΧΗΛ                         	F
ΡΕΑ                           	F
ΡΕΒΕΚΚΑ                       	F
ΡΕΓΓΙΝΑ                       	F
ΡΕΝΑ                          	F
ΡΗΓΑΣ                         	M
ΡΗΓΙΝΑ                        	F
ΡΙΖΟΣ                         	M
ΡΟΒΕΡΤΟΣ                      	M
ΡΟΔΑΜΑΝΘΗ                     	F
ΡΟΔΑΝΘΗ                       	F
ΡΟΔΗ                          	F
ΡΟΔΙΑ                         	F
ΡΟΔΟΘΕΑ                       	F
ΡΟΔΟΠΗ                        	F
ΡΟΔΟΥΛΑ                       	F
ΡΟΖΑ                          	F
ΡΟΖΑΛΙΑ                       	F
ΡΟΖΑΝΑ                        	F
ΡΟΖΑΝΝΑ                       	F
ΡΟΖΙΝΑ                        	F
ΡΟΪΔΩ                         	F
ΡΟΥΛΑ                         	F
ΡΟΥΜΠΙΝΑ                      	F
ΡΟΥΜΠΙΝΗ                      	F
ΡΟΥΣΑ                         	F
ΡΩΞΑΝΗ                        	F
ΣΑΒΒΑΣ                        	M
ΣΑΒΒΑΤΟΥΛΑ                    	F
ΣΑΒΒΑΤΩ                       	F
ΣΑΒΒΙΝΑ                       	F
ΣΑΒΒΟΥΛΑ                      	F
ΣΑΒΙΝΑ                        	F
ΣΑΛΩΜΗ                        	F
ΣΑΜΨΩΝ                        	M
ΣΑΠΦΩ                         	F
ΣΑΡΑ                          	F
ΣΕΒΑΣΜΙΑ                      	F
ΣΕΒΑΣΤΗ                       	F
ΣΕΒΑΣΤΙΑ                      	F
ΣΕΛΗΝΗ                        	F
ΣΕΜΕΛΗ                        	F
ΣΕΡΑΦΕΙΜ                      	M
ΣΕΡΓΙΟΣ                       	M
ΣΗΜΕΛΑ                        	F
ΣΙΔΕΡΗ                        	F
ΣΙΔΕΡΟΥΛΑ                     	F
ΣΙΛΒΕΣΤΡΟΣ                    	M
ΣΙΜΕΛΑ                        	F
ΣΙΜΟΝΗ                        	F
ΣΙΜΩΝ                         	M
ΣΙΝΑΝ                         	M
ΣΜΑΡΑΓΔΑ                      	F
ΣΜΑΡΑΓΔΗ                      	F
ΣΜΑΡΑΓΔΩ                      	F
ΣΜΑΡΟΥΛΑ                      	F
ΣΜΑΡΩ                         	F
ΣΟΛΩΝ                         	M
ΣΟΝΙΑ                         	F
ΣΟΥΖΑΝΑ                       	F
ΣΟΥΛΤΑΝΑ                      	F
ΣΟΥΜΕΛΑ                       	F
ΣΟΥΣΑΝΑ                       	F
ΣΟΥΣΑΝΝΑ                      	F
ΣΟΥΣΣΑΝΑ                      	F
ΣΟΦΙΑ                         	F
ΣΟΦΟΚΛΗΣ                      	M
ΣΠΗΛΙΟΣ                       	M
ΣΠΥΡΙΔΟΥΛΑ                    	F
ΣΠΥΡΙΔΩΝ                      	M
ΣΤΑΘΟΥΛΑ                      	F
ΣΤΑΜΑΤΑ                       	F
ΣΤΑΜΑΤΕΛΛΑ                    	F
ΣΤΑΜΑΤΙΑ                      	F
ΣΤΑΜΑΤΙΚΗ                     	F
ΣΤΑΜΑΤΙΝΑ                     	F
ΣΤΑΜΑΤΙΟΣ                     	M
ΣΤΑΜΑΤΟΥΛΑ                    	F
ΣΤΑΜΟΥΛΗΣ                     	M
ΣΤΑΜΩ                         	F
ΣΤΑΣΙΝΗ                       	F
ΣΤΑΥΡΙΑΝΗ                     	F
ΣΤΑΥΡΙΤΣΑ                     	F
ΣΤΑΥΡΟΣ                       	M
ΣΤΑΥΡΟΥΛΑ                     	F
ΣΤΕΛΛΑ                        	F
ΣΤΕΡΓΙΑ                       	F
ΣΤΕΡΓΙΑΝΗ                     	F
ΣΤΕΡΓΙΑΝΝΗ                    	F
ΣΤΕΡΓΙΟΣ                      	M
ΣΤΕΡΓΟΥΛΑ                     	F
ΣΤΕΡΙΑΝΗ                      	F
ΣΤΕΦΑΝΙΑ                      	F
ΣΤΕΦΑΝΟΣ                      	M
ΣΤΡΑΤΗΓΟΥΛΑ                   	F
ΣΤΥΛΙΑΝΗ                      	F
ΣΤΥΛΙΑΝΟΣ                     	M
ΣΥΛΒΑΝΑ                       	F
ΣΥΛΒΙΑ                        	F
ΣΥΜΕΛΑ                        	F
ΣΥΜΕΩΝ                        	M
ΣΥΝΟΔΗ                        	F
ΣΥΡΜΑΤΕΝΙΑ                    	F
ΣΥΡΜΟΥΛΑ                      	F
ΣΥΡΜΩ                         	F
ΣΩΖΙΑ                         	F
ΣΩΚΡΑΤΗΣ                      	M
ΣΩΣΑΝΑ                        	F
ΣΩΣΑΝΝΑ                       	F
ΣΩΤΗΡΑ                        	F
ΣΩΤΗΡΙΑ                       	F
ΣΩΤΗΡΙΟΣ                      	M
ΣΩΦΡΟΝΙΑ                      	F
ΤΑΜΑΡΑ                        	F
ΤΑΝΙΑ                         	F
ΤΑΞΙΑΡΧΗΣ                     	M
ΤΑΞΙΑΡΧΟΥΛΑ                   	F
ΤΑΡΣΙΤΣΑ                      	F
ΤΑΤΙΑΝΑ                       	F
ΤΑΤΙΑΝΗ                       	F
ΤΕΡΕΖΑ                        	F
ΤΕΡΨΙΘΕΑ                      	F
ΤΕΡΨΙΧΟΡΗ                     	F
ΤΖΕΝΗ                         	F
ΤΖΟΓΙΑ                        	F
ΤΖΟΥΛΙΑ                       	F
ΤΗΛΕΜΑΧΟΣ                     	M
ΤΙΜΟΘΕΟΣ                      	M
ΤΙΜΟΛΕΩΝ                      	M
ΤΙΤΙΚΑ                        	F
ΤΙΤΟΣ                         	M
ΤΟΥΛΑ                         	F
ΤΡΑΪΑΝΗ                       	F
ΤΡΙΑΔΑ                        	F
ΤΡΙΑΝΤΑΦΥΛΛΗ                  	F
ΤΡΙΑΝΤΑΦΥΛΛΙΑ                 	F
ΤΡΙΑΝΤΑΦΥΛΛΟΣ                 	M
ΤΡΙΓΩΝΑ                       	F
ΤΡΙΣΕΥΓΕΝΗ                    	F
ΤΡΥΓΩΝΑ                       	F
ΤΡΥΦΩΝ                        	M
ΤΣΑΜΠΙΚΑ                      	F
ΤΣΑΜΠΙΚΟΣ                     	M
ΥΠΑΠΑΝΤΗ                      	F
ΥΠΑΤΙΑ                        	F
ΦΑΙΔΡΑ                        	F
ΦΑΙΔΩΝ                        	M
ΦΑΝΗ                          	F
ΦΑΝΟΥΛΑ                       	F
ΦΑΝΟΥΡΙΟΣ                     	M
ΦΕΒΡΩΝΙΑ                      	F
ΦΕΡΕΝΙΚΗ                      	F
ΦΙΛΑΝΘΗ                       	F
ΦΙΛΑΡΕΤΗ                      	F
ΦΙΛΗΜΩΝ                       	M
ΦΙΛΙΑ                         	F
ΦΙΛΙΠΠΙΑ                      	F
ΦΙΛΙΠΠΟΣ                      	M
ΦΙΛΙΣΙΑ                       	F
ΦΙΛΙΤΣΑ                       	F
ΦΙΛΙΩ                         	F
ΦΙΛΟΘΕΗ                       	F
ΦΙΛΟΜΕΝΗ                      	F
ΦΙΛΟΜΗΛΑ                      	F
ΦΙΛΟΠΟΙΜΗΝ                    	M
ΦΛΩΡΑ                         	F
ΦΛΩΡΕΝΤΙΑ                     	F
ΦΛΩΡΙΝΑ                       	F
ΦΟΙΒΗ                         	F
ΦΟΙΒΟΣ                        	M
ΦΡΑΓΚΙΣΚΟΣ                    	M
ΦΡΑΝΤΖΕΣΚΑ                    	F
ΦΡΑΝΤΖΕΣΚΟΣ                   	M
ΦΡΑΝΤΣΕΣΚΑ                    	F
ΦΡΕΙΔΕΡΙΚΗ                    	F
ΦΩΚΙΩΝ                        	M
ΦΩΤΕΙΝΗ                       	F
ΦΩΤΕΙΝΟΣ                      	M
ΦΩΤΙΟΣ                        	M
ΦΩΤΟΥΛΑ                       	F
ΦΩΤΩ                          	F
ΧΑΪΔΕΜΕΝΗ                     	F
ΧΑΪΔΩ                         	F
ΧΑΜΑΪΔΗ                       	F
ΧΑΡΑ                          	F
ΧΑΡΑΛΑΜΠΙΑ                    	F
ΧΑΡΑΛΑΜΠΟΣ                    	M
ΧΑΡΗΣ                         	M
ΧΑΡΙΔΗΜΟΣ                     	M
ΧΑΡΙΚΛΕΙΑ                     	F
ΧΑΡΙΛΑΟΣ                      	M
ΧΑΡΙΣ                         	F
ΧΑΡΙΤΙΝΗ                      	F
ΧΑΡΙΤΟΥΛΑ                     	F
ΧΑΡΙΤΩ                        	F
ΧΑΡΙΤΩΜΕΝΗ                    	F
ΧΑΡΟΥΛΑ                       	F
ΧΙΟΝΑ                         	F
ΧΙΟΝΙΑ                        	F
ΧΙΤΟΠΟΥΛΑ                     	F
ΧΡΗΣΤΟΣ                       	M
ΧΡΙΣΤΙΑΝΑ                     	F
ΧΡΙΣΤΙΑΝΝΑ                    	F
ΧΡΙΣΤΙΝΑ                      	F
ΧΡΙΣΤΙΝΗ                      	F
ΧΡΙΣΤΟΔΟΥΛΑ                   	F
ΧΡΙΣΤΟΔΟΥΛΟΣ                  	M
ΧΡΙΣΤΟΘΕΑ                     	F
ΧΡΙΣΤΟΥΛΑ                     	F
ΧΡΙΣΤΟΦΙΛΗ                    	F
ΧΡΙΣΤΟΦΟΡΟΣ                   	M
ΧΡΟΝΗΣ                        	M
ΧΡΥΣΑ                         	F
ΧΡΥΣΑΝΑ                       	F
ΧΡΥΣΑΝΘΗ                      	F
ΧΡΥΣΑΥΓΗ                      	F
ΧΡΥΣΑΦΩ                       	F
ΧΡΥΣΗ                         	F
ΧΡΥΣΟΒΑΛΑΝΤΗ                  	F
ΧΡΥΣΟΒΑΛΑΝΤΗΣ                 	M
ΧΡΥΣΟΒΑΛΑΝΤΙΟΣ                	M
ΧΡΥΣΟΒΑΛΑΝΤΟΥ                 	F
ΧΡΥΣΟΒΑΛΑΝΤΩ                  	F
ΧΡΥΣΟΒΕΡΓΗΣ                   	M
ΧΡΥΣΟΘΕΑ                      	F
ΧΡΥΣΟΠΗΓΗ                     	F
ΧΡΥΣΟΣΤΟΜΗ                    	F
ΧΡΥΣΟΣΤΟΜΟΣ                   	M
ΧΡΥΣΟΥΛΑ                      	F
ΧΡΥΣΩ                         	F
ΩΡΑΙΑ                         	F
ΩΡΑΙΟΖΗΛΗ                     	F
\.


--
-- Data for Name: Person; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public."Person" (amka, email, fname, father_name, surname) FROM stdin;
9825289323	ΜΦΩΤ_90322@isc.tuc.gr                             	ΜΕΝΕΞΙΑ                                           	ΟΡΕΣΤΗΣ                                           	ΦΩΤΕΙΑΔΗ                                          
5243886166	ΛΒΙΤ_19962@isc.tuc.gr                             	ΛΑΜΠΡΑΚΗΣ                                         	ΚΥΡΙΑΚΟΣ                                          	ΒΙΤΑΝΙΔΗΣ                                         
5589427861	ΑΧΛΙ_7078.@isc.tuc.gr                             	ΑΛΚΙΣΤΗ                                           	ΟΔΥΣΣΕΑΣ                                          	ΧΛΙΟΥΝΑΚΗ                                         
5081927005	ΘΜΥΛ_30990@isc.tuc.gr                             	ΘΕΜΙΣ                                             	ΔΑΥΪΔ                                             	ΜΥΛΩΝΗ                                            
3391566195	ΗΣΑΛ_12907@isc.tuc.gr                             	ΗΡΩ                                               	ΑΥΓΕΡΙΝΟΣ                                         	ΣΑΛΑΠΑΝΗ                                          
8163254157	ΑΔΩΜ_20015@isc.tuc.gr                             	ΑΓΓΕΛΗΣ                                           	ΑΧΙΛΛΕΑΣ                                          	ΔΩΜΑΤΙΩΤΗΣ                                        
1077861304	ΑΓΚΟ_5246.@isc.tuc.gr                             	ΑΓΑΘΟΥΛΑ                                          	ΙΩΝ                                               	ΓΚΟΥΝΖΑΜΑΝΗ                                       
1006258297	ΓΤΖΑ_72554@isc.tuc.gr                             	ΓΡΑΜΜΑΤΙΑ                                         	ΦΡΑΝΤΖΕΣΚΟΣ                                       	ΤΖΑΛΗ                                             
9237022162	ΑΚΑΛ_13199@isc.tuc.gr                             	ΑΥΓΗ                                              	ΧΑΡΗΣ                                             	ΚΑΛΛΗΜΑΝΗ                                         
5016674518	ΕΠΕΡ_57117@isc.tuc.gr                             	ΕΡΙΦΙΛΗ                                           	ΤΗΛΕΜΑΧΟΣ                                         	ΠΕΡΙΣΑΝΙΔΗ                                        
4244532307	ΓΤΣΑ_7358.@isc.tuc.gr                             	ΓΟΥΛΙΕΛΜΟΣ                                        	ΚΥΡΟΣ                                             	ΤΣΑΜΟΥΡΛΙΔΗΣ                                      
2809479422	ΑΑΓΑ_90969@isc.tuc.gr                             	ΑΡΙΑΝ                                             	ΑΡΙΑΝ                                             	ΑΓΑΤΣΙΩΤΗΣ                                        
5671479585	ΑΓΚΟ_50511@isc.tuc.gr                             	ΑΥΓΟΥΣΤΙΝΟΣ                                       	ΛΕΩΝΙΔΑΣ                                          	ΓΚΟΥΓΚΩΤΗΣ                                        
1007060797	ΝΚΟΣ_108.2@isc.tuc.gr                             	ΝΑΤΑΣΑ                                            	ΔΗΜΟΣ                                             	ΚΟΣΒΟΓΙΑΝΝΗ                                       
1525346765	ΒΣΓΟ_74072@isc.tuc.gr                             	ΒΗΣΣΑΡΙΑ                                          	ΒΑΪΟΣ                                             	ΣΓΟΥΡΟΜΑΛΙΔΗ                                      
2922934324	ΚΜΠΟ_45438@isc.tuc.gr                             	ΚΥΒΕΛΗ                                            	ΜΕΝΕΛΑΟΣ                                          	ΜΠΟΥΝΤΑΓΙΔΗ                                       
4537508183	ΡΖΙΩ_8579.@isc.tuc.gr                             	ΡΟΔΟΘΕΑ                                           	ΕΜΜΑΝΟΥΗΛ                                         	ΖΙΩΓΑΚΗ                                           
3770027735	ΓΠΕΤ_48291@isc.tuc.gr                             	ΓΡΑΜΜΑΤΗ                                          	ΜΥΡΩΝ                                             	ΠΕΤΙΝΑΡΗ                                          
8109804948	ΘΜΑΛ_22011@isc.tuc.gr                             	ΘΕΟΚΛΕΙΑ                                          	ΓΕΡΑΣΙΜΟΣ                                         	ΜΑΛΑΝΤΗ                                           
3415024983	ΕΤΡΥ_68594@isc.tuc.gr                             	ΕΜΟΡΦΙΛΗ                                          	ΒΕΝΙΑΜΙΝ                                          	ΤΡΥΠΑΛΙΤΑΚΗ                                       
1457362138	ΙΓΚΟ_72023@isc.tuc.gr                             	ΙΩΝ                                               	ΘΕΟΦΙΛΟΣ                                          	ΓΚΟΤΣΗΣ                                           
6987140272	ΜΚΑΡ_34564@isc.tuc.gr                             	ΜΙΧΑΛΙΑ                                           	ΝΕΣΤΟΡΑΣ                                          	ΚΑΡΑΜΑΓΚΑΛΗ                                       
4129539301	ΦΜΠΑ_60708@isc.tuc.gr                             	ΦΙΛΙΤΣΑ                                           	ΔΑΜΙΑΝΟΣ                                          	ΜΠΑΚΛΑΤΖΗ                                         
4139655001	ΜΚΑΝ_80459@isc.tuc.gr                             	ΜΑΓΙΟΥΛΑ                                          	ΣΠΥΡΙΔΩΝ                                          	ΚΑΝΤΖΙΜΠΑΤΖΑΚΗ                                    
4489572669	ΤΓΑΡ_29576@isc.tuc.gr                             	ΤΡΙΑΝΤΑΦΥΛΛΟΣ                                     	ΜΑΥΡΟΥΔΗΣ                                         	ΓΑΡΓΑΝΗΣ                                          
7594565848	ΕΜΟΥ_67336@isc.tuc.gr                             	ΕΥΓΕΝΙΑ                                           	ΚΗΡΥΚΟΣ                                           	ΜΟΥΡΟΥΛΗ                                          
1889286193	ΑΚΥΠ_73394@isc.tuc.gr                             	ΑΛΒΕΡΤΟΣ                                          	ΜΙΧΑΗΛ                                            	ΚΥΠΤΗΣ                                            
6052931528	ΑΚΟΝ_63024@isc.tuc.gr                             	ΑΛΚΙΣΤΗ                                           	ΑΙΜΙΛΙΟΣ                                          	ΚΟΝΤΟΕΙΔΗ                                         
7242749087	ΟΓΕΛ_32410@isc.tuc.gr                             	ΟΥΡΑΝΙΑ                                           	ΣΤΥΛΙΑΝΟΣ                                         	ΓΕΛΑΣΑΚΗ                                          
6023433046	ΕΖΑΧ_66334@isc.tuc.gr                             	ΕΡΙΦΥΛΗ                                           	ΑΛΚΗΣ                                             	ΖΑΧΑΡΟΥΔΑΚΗ                                       
3911487577	ΙΚΛΙ_97548@isc.tuc.gr                             	ΙΑΚΩΒΟΣ                                           	ΕΛΕΥΘΕΡΙΟΣ                                        	ΚΛΙΝΑΚΗΣ                                          
9980820595	ΑΜΑΛ_32333@isc.tuc.gr                             	ΑΡΙΣΤΗ                                            	ΡΗΓΑΣ                                             	ΜΑΛΑΤΙΔΗ                                          
9544567295	ΚΠΕΡ_83182@isc.tuc.gr                             	ΚΡΥΣΤΑΛΛΕΝΙΑ                                      	ΜΕΝΕΛΑΟΣ                                          	ΠΕΡΤΣΙΝΑΚΗ                                        
1292902580	ΑΚΑΛ_92830@isc.tuc.gr                             	ΑΡΓΥΡΟΥΛΑ                                         	ΑΓΑΠΙΟΣ                                           	ΚΑΛΗΣΠΑΘΗ                                         
3207392350	ΤΓΟΥ_3039.@isc.tuc.gr                             	ΤΑΤΙΑΝΑ                                           	ΕΛΙΣΣΑΙΟΣ                                         	ΓΟΥΡΔΟΥΒΕΛΗ                                       
2563337837	ΑΚΑΛ_14208@isc.tuc.gr                             	ΑΙΚΑΤΕΡΙΝΗ                                        	ΑΔΡΙΑΝΟΣ                                          	ΚΑΛΑΤΖΙΔΗ                                         
6123973547	ΒΤΣΙ_15452@isc.tuc.gr                             	ΒΑΣΙΛΕΙΟΣ                                         	ΓΑΒΡΙΗΛ                                           	ΤΣΙΛΙΩΝΗΣ                                         
8048161591	ΑΚΑΦ_71866@isc.tuc.gr                             	ΑΥΓΟΥΣΤΙΝΟΣ                                       	ΧΑΡΙΛΑΟΣ                                          	ΚΑΦΑΣΗΣ                                           
3885371670	ΡΠΕΝ_70828@isc.tuc.gr                             	ΡΟΖΙΝΑ                                            	ΚΛΕΑΝΘΗΣ                                          	ΠΕΝΚΙΔΗ                                           
1677623273	ΑΓΚΑ_61632@isc.tuc.gr                             	ΑΓΓΕΛΙΚΟΥΛΑ                                       	ΚΥΡΟΣ                                             	ΓΚΑΣΠΑΡΗ                                          
7412729163	ΗΜΠΑ_73254@isc.tuc.gr                             	ΗΒΗ                                               	ΑΡΓΥΡΙΟΣ                                          	ΜΠΑΚΑΛΙΔΗ                                         
1908920784	ΜΒΟΡ_61497@isc.tuc.gr                             	ΜΑΡΙΓΟΥΛΑ                                         	ΑΒΡΑΑΜ                                            	ΒΟΡΓΙΑΖΙΔΗ                                        
7604634123	ΘΚΟΥ_61348@isc.tuc.gr                             	ΘΕΟΦΑΝΗΣ                                          	ΜΕΝΕΛΑΟΣ                                          	ΚΟΥΤΟΥΣΗΣ                                         
2678213354	ΜΜΠΑ_41323@isc.tuc.gr                             	ΜΑΡΙΝΟΣ                                           	ΑΒΡΑΑΜ                                            	ΜΠΑΚΡΥΝΙΩΤΗΣ                                      
8140626094	ΤΝΤΟ_80064@isc.tuc.gr                             	ΤΙΜΟΛΕΩΝ                                          	ΖΗΣΗΣ                                             	ΝΤΟΚΟΖΗΣ                                          
9262628998	ΧΖΟΥ_46808@isc.tuc.gr                             	ΧΑΡΑΛΑΜΠΟΣ                                        	ΣΟΦΟΚΛΗΣ                                          	ΖΟΥΝΑΗΣ                                           
6368086134	ΧΚΟΥ_80411@isc.tuc.gr                             	ΧΡΙΣΤΟΥΛΑ                                         	ΣΤΑΜΟΥΛΗΣ                                         	ΚΟΥΛΙΚΛΙΔΗ                                        
4141651461	ΑΖΕΜ_33445@isc.tuc.gr                             	ΑΣΠΑΣΙΑ                                           	ΧΡΟΝΗΣ                                            	ΖΕΜΕΛΗ                                            
7611391463	ΠΓΚΙ_85196@isc.tuc.gr                             	ΠΑΣΧΑΛΗΣ                                          	ΣΙΜΩΝ                                             	ΓΚΙΝΗΣ                                            
1002017775	ΕΜΠΟ_59086@isc.tuc.gr                             	ΕΙΡΗΝΗ                                            	ΑΣΗΜΑΚΗΣ                                          	ΜΠΟΥΣΜΑΛΗ                                         
2127379383	ΚΠΡΩ_28386@isc.tuc.gr                             	ΚΕΡΑΣΙΝΑ                                          	ΠΑΪΣΙΟΣ                                           	ΠΡΩΤΟΓΕΡΙΔΗ                                       
5383048297	ΠΠΟΛ_28534@isc.tuc.gr                             	ΠΑΣΧΑΛΗΣ                                          	ΦΑΝΟΥΡΙΟΣ                                         	ΠΟΛΑΤΣΙΔΗΣ                                        
2456626264	ΑΜΙΓ_85488@isc.tuc.gr                             	ΑΓΑΘΗ                                             	ΧΑΡΑΛΑΜΠΟΣ                                        	ΜΙΓΓΙΔΗ                                           
5027772807	ΠΑΛΟ_15384@isc.tuc.gr                             	ΠΗΝΕΛΟΠΗ                                          	ΠΥΡΡΟΣ                                            	ΑΛΟΙΔΗ                                            
2539403312	ΣΤΟΥ_66084@isc.tuc.gr                             	ΣΤΑΜΑΤΑ                                           	ΜΕΡΚΟΥΡΙΟΣ                                        	ΤΟΥΡΑΚΗ                                           
3466969247	ΚΒΑΡ_17345@isc.tuc.gr                             	ΚΟΝΔΥΛΙΑ ΜΑΡΙΑ                                    	ΦΡΑΓΚΙΣΚΟΣ                                        	ΒΑΡΑΛΕΞΗ                                          
5404276104	ΝΣΟΡ_57947@isc.tuc.gr                             	ΝΟΜΙΚΗ                                            	ΠΥΘΑΓΟΡΑΣ                                         	ΣΟΡΟΛΗ                                            
5298653978	ΦΣΟΚ_2692.@isc.tuc.gr                             	ΦΕΡΕΝΙΚΗ                                          	ΣΕΡΓΙΟΣ                                           	ΣΟΚΟΡΗ                                            
8519900776	ΑΖΕΝ_80369@isc.tuc.gr                             	ΑΣΗΜΟΥΛΑ                                          	ΦΩΤΙΟΣ                                            	ΖΕΝΤΕΛΗ                                           
2647025193	ΕΣΥΝ_90357@isc.tuc.gr                             	ΕΥΓΕΝΙΟΣ                                          	ΧΡΥΣΟΒΕΡΓΗΣ                                       	ΣΥΝΑΝΗΣ                                           
1322087026	ΧΤΕΚ_69026@isc.tuc.gr                             	ΧΑΡΙΛΑΟΣ                                          	ΕΥΣΤΑΘΙΟΣ                                         	ΤΕΚΟΥΣΗΣ                                          
2431388358	ΕΦΟΡ_78918@isc.tuc.gr                             	ΕΛΕΝΗ                                             	ΚΛΗΜΗΣ                                            	ΦΟΡΤΟΜΑΡΗ                                         
2627845789	ΔΚΟΥ_23690@isc.tuc.gr                             	ΔΙΑΝΑ                                             	ΧΑΡΙΛΑΟΣ                                          	ΚΟΥΤΣΟΥΜΠΑΡΗ                                      
9866654321	ΗΠΟΙ_53209@isc.tuc.gr                             	ΗΛΙΑΔΑ                                            	ΑΝΕΣΤΗΣ                                           	ΠΟΙΜΕΝΑΚΗ                                         
2724290938	ΚΤΖΕ_72748@isc.tuc.gr                             	ΚΑΛΟΜΟΙΡΑ                                         	ΧΑΡΙΛΑΟΣ                                          	ΤΖΕΡΑΒΙΝΗ                                         
4835238140	ΣΝΤΟ_26730@isc.tuc.gr                             	ΣΑΒΒΑΤΩ                                           	ΑΛΚΙΝΟΟΣ                                          	ΝΤΟΥΡΑΝΙΔΗ                                        
2429992163	ΕΤΑΤ_67418@isc.tuc.gr                             	ΕΛΙΣΣΑΙΟΣ                                         	ΚΥΡΙΑΚΟΣ                                          	ΤΑΤΑΡΟΥΝΗΣ                                        
7848264486	ΗΡΟΥ_88201@isc.tuc.gr                             	ΗΡΩ                                               	ΚΗΡΥΚΟΣ                                           	ΡΟΥΒΑΚΗ                                           
2883399736	ΧΤΣΑ_98596@isc.tuc.gr                             	ΧΡΥΣΟΣΤΟΜΗ                                        	ΒΕΛΙΣΣΑΡΙΟΣ                                       	ΤΣΑΡΙΚΤΣΗ                                         
5315363834	ΒΜΠΑ_39246@isc.tuc.gr                             	ΒΛΑΣΙΑ                                            	ΜΕΛΕΤΙΟΣ                                          	ΜΠΑΤΣΑΝΗ                                          
8525887759	ΑΔΕΛ_50833@isc.tuc.gr                             	ΑΙΚΑΤΕΡΙΝΗ                                        	ΦΩΤΕΙΝΟΣ                                          	ΔΕΛΗΓΚΙΟΖΗ                                        
9296128900	ΔΚΟΥ_72851@isc.tuc.gr                             	ΔΟΜΗΝΙΚΗ                                          	ΜΩΥΣΗΣ                                            	ΚΟΥΖΟΥΚΙΔΗ                                        
6224284619	ΣΚΟΥ_1743.@isc.tuc.gr                             	ΣΤΕΡΙΑΝΗ                                          	ΚΟΡΝΗΛΙΟΣ                                         	ΚΟΥΤΗΦΑΡΗ                                         
6130521884	ΙΓΚΟ_13181@isc.tuc.gr                             	ΙΟΡΔΑΝΑ                                           	ΦΩΚΙΩΝ                                            	ΓΚΟΛΟΗ                                            
1974342255	ΧΠΟΡ_15174@isc.tuc.gr                             	ΧΡΥΣΟΒΑΛΑΝΤΩ                                      	ΟΡΧΑΝ                                             	ΠΟΡΛΙΤΗ                                           
4364910715	ΕΣΙΧ_81808@isc.tuc.gr                             	ΕΛΒΙΡΑ                                            	ΒΑΣΙΛΕΙΟΣ                                         	ΣΙΧΛΙΜΟΙΡΗ                                        
5393150884	ΘΑΚΩ_59990@isc.tuc.gr                             	ΘΗΡΕΣΙΑ                                           	ΟΡΧΑΝ                                             	ΑΚΩΝΗ                                             
7342428390	ΧΠΟΥ_95585@isc.tuc.gr                             	ΧΑΡΙΤΩ                                            	ΒΕΡΓΟΣ                                            	ΠΟΥΛΚΑΡΗ                                          
7506562181	ΚΜΑΤ_16253@isc.tuc.gr                             	ΚΥΠΑΡΙΣΣΙΑ                                        	ΘΕΟΛΟΓΟΣ                                          	ΜΑΤΘΑΙΑΚΗ                                         
3004542348	ΑΦΟΡ_46186@isc.tuc.gr                             	ΑΝΕΖΑ                                             	ΤΙΜΟΛΕΩΝ                                          	ΦΟΡΝΕΖΗ                                           
7344446165	ΑΜΑΥ_55672@isc.tuc.gr                             	ΑΝΤΩΝΙΟΣ                                          	ΜΕΝΕΛΑΟΣ                                          	ΜΑΥΡΟΒΑΣΙΛΗΣ                                      
8633941564	ΕΣΠΙ_44640@isc.tuc.gr                             	ΕΥΘΥΜΙΑ                                           	ΣΤΑΜΑΤΙΟΣ                                         	ΣΠΙΝΙΑΔΑΚΗ                                        
7387590646	ΙΤΣΙ_74720@isc.tuc.gr                             	ΙΣΙΔΩΡΑ                                           	ΦΑΙΔΩΝ                                            	ΤΣΙΑΜΠΑΚΑΡΗ                                       
8801072434	ΑΡΑΚ_42160@isc.tuc.gr                             	ΑΚΡΙΒΗ                                            	ΒΕΛΙΣΣΑΡΙΟΣ                                       	ΡΑΚΙΤΖΗ                                           
3661714372	ΑΘΡΑ_60024@isc.tuc.gr                             	ΑΙΓΛΗ                                             	ΑΛΚΙΝΟΟΣ                                          	ΘΡΑΜΠΟΥΛΙΔΗ                                       
8926993958	ΜΞΥΜ_41804@isc.tuc.gr                             	ΜΑΛΑΜΑΤΕΝΙΑ                                       	ΜΥΡΩΝ                                             	ΞΥΜΙΝΗ                                            
2268041682	ΒΜΠΟ_59505@isc.tuc.gr                             	ΒΕΡΟΝΙΚΑ                                          	ΧΑΡΗΣ                                             	ΜΠΟΥΡΕΛΑΚΗ                                        
8065990477	ΜΤΑΤ_18971@isc.tuc.gr                             	ΜΑΤΟΥΛΑ                                           	ΑΝΔΡΟΝΙΚΟΣ                                        	ΤΑΤΑΒΛΑΛΗ                                         
4225647938	ΔΑΡΜ_44497@isc.tuc.gr                             	ΔΕΣΠΟΙΝΑ                                          	ΘΕΟΚΛΗΤΟΣ                                         	ΑΡΜΥΡΙΩΤΗ                                         
9787942463	ΖΚΛΟ_40875@isc.tuc.gr                             	ΖΩΓΡΑΦΙΑ                                          	ΝΕΟΚΛΗΣ                                           	ΚΛΟΥΤΣΟΥΝΙΩΤΗ                                     
9713015670	ΚΜΠΑ_10329@isc.tuc.gr                             	ΚΡΥΣΤΑΛΛΗ                                         	ΜΑΝΟΥΣΟΣ                                          	ΜΠΑΡΜΠΑΔΗ                                         
4547734968	ΕΒΑΡ_14524@isc.tuc.gr                             	ΕΛΙΣΣΑΙΟΣ                                         	ΑΡΤΕΜΙΟΣ                                          	ΒΑΡΛΑΜΗΣ                                          
2219330822	ΑΠΟΥ_20793@isc.tuc.gr                             	ΑΘΗΝΑ                                             	ΒΥΡΩΝ                                             	ΠΟΥΡΓΑΝΗ                                          
2340861465	ΑΒΥΖ_34020@isc.tuc.gr                             	ΑΛΙΚΗ                                             	ΔΑΥΪΔ                                             	ΒΥΖΟΥΚΑΚΗ                                         
4414389290	ΠΚΑΡ_67733@isc.tuc.gr                             	ΠΑΡΘΕΝΙΑ                                          	ΝΕΚΤΑΡΙΟΣ                                         	ΚΑΡΟΥΚΗ                                           
3943621761	ΜΠΑΠ_93542@isc.tuc.gr                             	ΜΑΛΒΙΝΑ                                           	ΑΡΓΥΡΙΟΣ                                          	ΠΑΠΑΡΟΜΠΟΛΗ                                       
6176099606	ΡΜΑΝ_60750@isc.tuc.gr                             	ΡΟΔΑΜΑΝΘΗ                                         	ΑΡΙΑΝ                                             	ΜΑΝΤΟΥΔΑΚΗ                                        
5844381454	ΧΒΕΛ_36151@isc.tuc.gr                             	ΧΡΥΣΟΣΤΟΜΟΣ                                       	ΕΡΜΟΛΑΟΣ                                          	ΒΕΛΑΕΤΗΣ                                          
1791886249	ΚΕΜΜ_82743@isc.tuc.gr                             	ΚΕΡΑΣΟΥΛΑ                                         	ΝΑΠΟΛΕΩΝ                                          	ΕΜΜΑΝΩΗΛΙΔΗ                                       
8059499343	ΚΚΡΙ_60346@isc.tuc.gr                             	ΚΑΝΕΛΛΑ                                           	ΟΡΕΣΤΗΣ                                           	ΚΡΙΤΣΑΝΙΔΗ                                        
1159745290	ΕΦΟΙ_75398@isc.tuc.gr                             	ΕΠΙΣΤΗΜΗ                                          	ΔΑΥΪΔ                                             	ΦΟΙΝΙΚΙΑΝΑΚΗ                                      
9317774013	ΜΚΑΛ_34577@isc.tuc.gr                             	ΜΑΝΟΥΕΛΑ                                          	ΒΛΑΔΙΜΗΡΟΣ                                        	ΚΑΛΛΗΔΟΝΑΚΗ                                       
7355628244	ΒΔΕΛ_34198@isc.tuc.gr                             	ΒΙΡΓΙΝΙΑ                                          	ΣΤΕΡΓΙΟΣ                                          	ΔΕΛΗΘΟΔΩΡΗ                                        
6384029909	ΛΣΕΛ_77141@isc.tuc.gr                             	ΛΗΔΑ                                              	ΝΙΚΟΛΑΟΣ                                          	ΣΕΛΑΜΣΙΔΗ                                         
5448295898	ΒΜΑΛ_47758@isc.tuc.gr                             	ΒΙΚΤΩΡ                                            	ΑΛΚΙΒΙΑΔΗΣ                                        	ΜΑΛΑΜΑΤΙΝΗΣ                                       
8329970500	ΕΜΑΝ_49372@isc.tuc.gr                             	ΕΡΙΦΥΛΛΗ                                          	ΜΑΡΙΟΣ                                            	ΜΑΝΑΝΗ                                            
9748940629	ΚΚΟΝ_59950@isc.tuc.gr                             	ΚΛΕΑΝΘΗ                                           	ΚΑΡΟΛΟΣ                                           	ΚΟΝΤΟΜΑΡΗ                                         
9841446787	ΑΒΑΚ_8748.@isc.tuc.gr                             	ΑΣΗΜΙΝΑ                                           	ΣΤΕΦΑΝΟΣ                                          	ΒΑΚΥΡΤΣΗ                                          
5672398895	ΖΤΣΙ_45958@isc.tuc.gr                             	ΖΑΦΕΙΡΙΟΣ                                         	ΜΩΥΣΗΣ                                            	ΤΣΙΤΙΜΑΚΗΣ                                        
7255502811	ΧΖΑΡ_76204@isc.tuc.gr                             	ΧΡΥΣΑΝΘΗ                                          	ΑΒΡΑΑΜ                                            	ΖΑΡΚΑΝΙΩΤΗ                                        
2845989136	ΚΚΑΓ_54935@isc.tuc.gr                             	ΚΟΡΙΝΝΑ                                           	ΙΕΡΟΘΕΟΣ                                          	ΚΑΓΑΣΙΔΗ                                          
3016845062	ΕΑΓΓ_2631.@isc.tuc.gr                             	ΕΥΜΟΡΦΙΛΗ                                         	ΖΗΝΩΝ                                             	ΑΓΓΕΛΟΝΙΔΗ                                        
5889444376	ΡΑΛΕ_21844@isc.tuc.gr                             	ΡΑΦΑΕΛΑ                                           	ΣΙΛΒΕΣΤΡΟΣ                                        	ΑΛΕΚΟΖΙΔΗ                                         
9233579786	ΜΚΕΡ_30655@isc.tuc.gr                             	ΜΑΡΓΙΤΣΑ                                          	ΘΩΜΑΣ                                             	ΚΕΡΔΗ                                             
1817917498	ΦΓΑΡ_44791@isc.tuc.gr                             	ΦΑΝΟΥΛΑ                                           	ΕΥΣΤΑΘΙΟΣ                                         	ΓΑΡΑΜΑΝΙΔΗ                                        
8551158753	ΓΦΥΣ_81869@isc.tuc.gr                             	ΓΡΑΜΜΑΤΙΑ                                         	ΜΑΚΑΡΙΟΣ                                          	ΦΥΣΣΑΡΑΚΗ                                         
8160573746	ΑΚΟΥ_72459@isc.tuc.gr                             	ΑΦΕΝΔΡΑ                                           	ΕΥΣΤΑΘΙΟΣ                                         	ΚΟΥΝΤΟΥΡΗ                                         
3085959185	ΑΚΑΓ_5297.@isc.tuc.gr                             	ΑΡΙΣΤΟΣ                                           	ΑΣΤΡΙΝΟΣ                                          	ΚΑΓΛΑΝΤΖΗΣ                                        
6617149232	ΕΑΛΙ_1841.@isc.tuc.gr                             	ΕΛΕΩΝΟΡΑ                                          	ΙΣΙΔΩΡΟΣ                                          	ΑΛΙΜΠΕΡΤΗ                                         
2386221689	ΝΝΤΡ_17957@isc.tuc.gr                             	ΝΙΚΟΛΕΤΤΑ                                         	ΜΑΚΑΡΙΟΣ                                          	ΝΤΡΙΣΤΗ                                           
2873901649	ΡΚΑΒ_46173@isc.tuc.gr                             	ΡΑΦΑΕΛΑ                                           	ΑΡΙΑΝ                                             	ΚΑΒΑΚΑΚΗ                                          
6330164908	ΡΚΟΛ_12171@isc.tuc.gr                             	ΡΑΛΛΟΥ                                            	ΕΜΜΑΝΟΥΗΛ                                         	ΚΟΛΟΖΗ                                            
5933956657	ΚΠΙΤ_32481@isc.tuc.gr                             	ΚΟΣΜΑΣ                                            	ΜΕΡΚΟΥΡΙΟΣ                                        	ΠΙΤΚΑΡΗΣ                                          
4093232471	ΘΓΕΡ_66967@isc.tuc.gr                             	ΘΕΟΦΑΝΩ                                           	ΣΠΥΡΙΔΩΝ                                          	ΓΕΡΟΝΤΙΝΗ                                         
7671026373	ΛΓΑΒ_46191@isc.tuc.gr                             	ΛΑΥΡΕΝΤΙΑ                                         	ΤΗΛΕΜΑΧΟΣ                                         	ΓΑΒΡΙΗΛΑΚΗ                                        
9348345948	ΟΠΟΛ_1214.@isc.tuc.gr                             	ΟΡΣΙΑ                                             	ΖΗΣΙΜΟΣ                                           	ΠΟΛΥΒΑΚΙΔΗ                                        
7036854232	ΒΜΠΑ_61510@isc.tuc.gr                             	ΒΑΓΙΟΥΛΑ                                          	ΛΑΜΠΡΑΚΗΣ                                         	ΜΠΑΝΤΣΗ                                           
1722013912	ΠΤΣΕ_89159@isc.tuc.gr                             	ΠΕΡΣΕΦΟΝΗ                                         	ΔΡΟΣΟΣ                                            	ΤΣΕΣΜΕΤΣΗ                                         
4396969433	ΠΙΓΓ_79001@isc.tuc.gr                             	ΠΕΛΟΠΙΔΑΣ                                         	ΡΑΦΑΗΛ                                            	ΙΓΓΙΛΙΔΗΣ                                         
5113980593	ΕΠΑΤ_94467@isc.tuc.gr                             	ΕΛΠΙΔΑ                                            	ΔΗΜΟΚΡΙΤΟΣ                                        	ΠΑΤΖΑΡΤΖΗ                                         
7208091686	ΑΚΟΝ_75753@isc.tuc.gr                             	ΑΙΚΑΤΕΡΙΝΗ                                        	ΠΟΛΥΧΡΟΝΗΣ                                        	ΚΟΝΤΕΣΙΔΗ                                         
2251361154	ΕΣΦΕ_90654@isc.tuc.gr                             	ΕΦΗ                                               	ΚΛΕΟΜΕΝΗΣ                                         	ΣΦΕΔΑΝΗ                                           
8257350009	ΒΓΚΟ_98032@isc.tuc.gr                             	ΒΛΑΣΙΑ                                            	ΖΗΣΗΣ                                             	ΓΚΟΜΟΣΙΔΗ                                         
1317009026	ΘΧΡΥ_28883@isc.tuc.gr                             	ΘΙΣΒΗ                                             	ΕΛΙΣΣΑΙΟΣ                                         	ΧΡΥΣΟΣΤΡΑΤΗ                                       
9264263922	ΣΡΟΥ_50227@isc.tuc.gr                             	ΣΟΥΛΤΑΝΑ                                          	ΜΕΡΚΟΥΡΙΟΣ                                        	ΡΟΥΜΑΝΙΩΤΗ                                        
3599046570	ΣΚΛΑ_69485@isc.tuc.gr                             	ΣΤΕΡΓΙΑΝΝΗ                                        	ΑΘΑΝΑΣΙΟΣ                                         	ΚΛΑΤΖΙΔΗ                                          
5805429749	ΓΚΑΛ_41550@isc.tuc.gr                             	ΓΕΡΑΣΙΜΗ                                          	ΑΒΕΡΚΙΟΣ                                          	ΚΑΛΛΙΟΥΝΤΖΗ                                       
5714303328	ΠΠΙΤ_87863@isc.tuc.gr                             	ΠΟΥΛΙΑ                                            	ΠΥΘΑΓΟΡΑΣ                                         	ΠΙΤΣΙΚΑΛΗ                                         
4394391742	ΠΣΕΚ_35843@isc.tuc.gr                             	ΠΕΛΟΠΙΔΑΣ                                         	ΠΡΟΚΟΠΙΟΣ                                         	ΣΕΚΡΗΣ                                            
9983481564	ΡΓΙΑ_64531@isc.tuc.gr                             	ΡΟΥΣΑ                                             	ΒΛΑΔΙΜΗΡΟΣ                                        	ΓΙΑΓΟΠΙΔΗ                                         
3641959911	ΒΓΚΙ_60033@isc.tuc.gr                             	ΒΕΝΙΑΜΙΝ                                          	ΕΥΤΥΧΙΟΣ                                          	ΓΚΙΡΛΗΣ                                           
9388483454	ΘΠΑΥ_57965@isc.tuc.gr                             	ΘΕΟΦΑΝΕΙΑ                                         	ΑΥΓΕΡΙΝΟΣ                                         	ΠΑΥΛΟΥΔΑΚΗ                                        
1222679393	ΒΚΙΡ_97075@isc.tuc.gr                             	ΒΑΣΩ                                              	ΑΝΑΡΓΥΡΟΣ                                         	ΚΙΡΤΣΙΜΠΑΣΗ                                       
5627860785	ΜΛΙΑ_7145.@isc.tuc.gr                             	ΜΑΡΙΚΑ                                            	ΧΑΡΗΣ                                             	ΛΙΑΠΙΔΗ                                           
3175341684	ΑΓΟΡ_66768@isc.tuc.gr                             	ΑΝΤΡΙΑΝΑ                                          	ΠΑΤΡΟΚΛΟΣ                                         	ΓΟΡΔΟΜΙΧΑΛΗ                                       
5294679305	ΦΜΑΝ_15184@isc.tuc.gr                             	ΦΡΑΝΤΣΕΣΚΑ                                        	ΑΓΑΜΕΜΝΩΝ                                         	ΜΑΝΔΡΙΔΗ                                          
4070566984	ΑΜΑΛ_14294@isc.tuc.gr                             	ΑΠΟΛΛΩΝ                                           	ΔΙΑΜΑΝΤΗΣ                                         	ΜΑΛΑΝΔΡΕΝΙΩΤΗΣ                                    
9762608642	ΦΚΟΡ_75963@isc.tuc.gr                             	ΦΙΛΙΤΣΑ                                           	ΦΑΙΔΩΝ                                            	ΚΟΡΤΣΟΥΔΑΚΗ                                       
5776308272	ΑΞΕΦ_94864@isc.tuc.gr                             	ΑΓΟΡΟΥΛΑ                                          	ΜΩΥΣΗΣ                                            	ΞΕΦΤΕΡΗ                                           
4238000193	ΑΡΑΣ_59540@isc.tuc.gr                             	ΑΛΚΗΣ                                             	ΕΠΑΜΕΙΝΩΝΔΑΣ                                      	ΡΑΣΙΔΑΚΗΣ                                         
2395076474	ΦΧΑΒ_77472@isc.tuc.gr                             	ΦΑΝΟΥΛΑ                                           	ΡΗΓΑΣ                                             	ΧΑΒΕΛΗ                                            
9973902126	ΑΘΕΟ_42005@isc.tuc.gr                             	ΑΙΜΙΛΙΑ                                           	ΜΕΛΕΤΙΟΣ                                          	ΘΕΟΦΑΝΕΛΗ                                         
5344490147	ΚΓΑΛ_43526@isc.tuc.gr                             	ΚΛΕΟΜΕΝΗΣ                                         	ΧΡΥΣΟΒΑΛΑΝΤΗΣ                                     	ΓΑΛΥΠΙΑΝΑΚΗΣ                                      
5347910311	ΜΞΥΛ_2671.@isc.tuc.gr                             	ΜΑΡΟΥΔΑ                                           	ΜΑΡΚΟΣ                                            	ΞΥΛΙΚΑΚΗ                                          
7061852022	ΕΓΙΑ_72448@isc.tuc.gr                             	ΕΡΑΤΩ                                             	ΑΛΕΞΙΟΣ                                           	ΓΙΑΤΡΑΚΗ                                          
9543741137	ΣΚΑΝ_67058@isc.tuc.gr                             	ΣΤΕΡΓΙΟΣ                                          	ΦΙΛΗΜΩΝ                                           	ΚΑΝΑΣΗΣ                                           
5458344170	ΠΚΩΣ_78477@isc.tuc.gr                             	ΠΟΛΥΜΝΙΑ                                          	ΑΔΡΙΑΝΟΣ                                          	ΚΩΣΤΑΜΠΑΡΗ                                        
3653674706	ΘΜΟΥ_71089@isc.tuc.gr                             	ΘΕΟΧΑΡΗ                                           	ΧΑΡΙΛΑΟΣ                                          	ΜΟΥΣΑΡΑΚΗ                                         
1265755050	ΣΘΕΟ_57217@isc.tuc.gr                             	ΣΤΑΥΡΟΣ                                           	ΑΡΙΣΤΟΤΕΛΗΣ                                       	ΘΕΟΔΩΣΟΥΛΑΚΗΣ                                     
8855313603	ΕΜΕΓ_58479@isc.tuc.gr                             	ΕΥΤΥΧΙΑ                                           	ΕΥΣΤΡΑΤΙΟΣ                                        	ΜΕΓΚΗ                                             
7767655300	ΜΣΠΑ_66557@isc.tuc.gr                             	ΜΑΡΙ                                              	ΣΟΛΩΝ                                             	ΣΠΑΡΤΑΛΗ                                          
7473846737	ΑΚΑΛ_33971@isc.tuc.gr                             	ΑΝΕΖΑ                                             	ΕΥΘΥΜΙΟΣ                                          	ΚΑΛΦΑΓΙΩΡΓΗ                                       
1106674759	ΜΤΡΙ_50133@isc.tuc.gr                             	ΜΙΡΑΝΤΑ                                           	ΠΡΟΚΟΠΙΟΣ                                         	ΤΡΙΚΙΛΙΔΗ                                         
6025005311	ΜΜΙΝ_65589@isc.tuc.gr                             	ΜΠΕΤΙΝΑ                                           	ΚΩΝΣΤΑΝΤΙΝΟΣ                                      	ΜΙΝΤΣΙΩΚΗ                                         
7790855763	ΜΑΛΙ_62854@isc.tuc.gr                             	ΜΕΡΟΠΗ                                            	ΙΩΑΚΕΙΜ                                           	ΑΛΙΣΑΒΑΚΗ                                         
9370938681	ΑΣΑΜ_1360.@isc.tuc.gr                             	ΑΝΔΡΟΝΙΚΟΣ                                        	ΔΗΜΟΣ                                             	ΣΑΜΑΡΑΔΕΛΛΗΣ                                      
8624051886	ΣΔΕΛ_36074@isc.tuc.gr                             	ΣΑΜΨΩΝ                                            	ΠΟΛΥΝΕΙΚΗΣ                                        	ΔΕΛΟΥΣΗΣ                                          
3596285513	ΑΜΑΖ_5405.@isc.tuc.gr                             	ΑΡΓΥΡΟΥΛΑ                                         	ΛΥΚΟΥΡΓΟΣ                                         	ΜΑΖΝΙΚΗ                                           
5085242010	ΚΑΚΡ_89224@isc.tuc.gr                             	ΚΡΥΣΤΑΛΛΙΑ                                        	ΑΡΙΣΤΟΓΕΙΤΩΝ                                      	ΑΚΡΙΜΗ                                            
3018443629	ΑΠΑΠ_71918@isc.tuc.gr                             	ΑΘΗΝΟΔΩΡΟΣ                                        	ΑΙΜΙΛΙΟΣ                                          	ΠΑΠΑΤΡΑΓΙΑΝΝΗΣ                                    
3579767082	ΚΧΑΛ_69936@isc.tuc.gr                             	ΚΑΣΣΙΑΝΗ                                          	ΑΓΓΕΛΟΣ                                           	ΧΑΛΒΑΤΖΙΔΑΚΗ                                      
7727201926	ΡΦΡΟ_50257@isc.tuc.gr                             	ΡΩΞΑΝΗ                                            	ΠΑΝΤΑΖΗΣ                                          	ΦΡΟΥΜΗ                                            
2406927085	ΒΠΟΛ_30883@isc.tuc.gr                             	ΒΙΡΓΙΝΙΑ                                          	ΑΧΜΕΤ                                             	ΠΟΛΛΑΚΗ                                           
3802446476	ΡΒΑΔ_68012@isc.tuc.gr                             	ΡΑΛΛΗΣ                                            	ΕΥΣΤΡΑΤΙΟΣ                                        	ΒΑΔΕΒΟΥΛΗΣ                                        
3355062713	ΠΛΑΨ_57402@isc.tuc.gr                             	ΠΑΡΘΕΝΙΑ                                          	ΘΕΟΦΑΝΗΣ                                          	ΛΑΨΑΝΙΔΗ                                          
4582268774	ΣΖΥΓ_97651@isc.tuc.gr                             	ΣΙΔΕΡΟΥΛΑ                                         	ΑΔΡΙΑΝΟΣ                                          	ΖΥΓΚΟΣΤΙΩΤΗ                                       
8097125781	ΒΚΕΡ_83197@isc.tuc.gr                             	ΒΙΚΥ                                              	ΠΑΡΙΣ                                             	ΚΕΡΜΕΛΗ                                           
6425629697	ΑΔΖΟ_71697@isc.tuc.gr                             	ΑΣΤΕΡΙΑ                                           	ΜΙΧΑΗΛ                                            	ΔΖΟΥΒΕΛΕΙΔΗ                                       
4344877417	ΦΝΤΕ_74615@isc.tuc.gr                             	ΦΩΤΟΥΛΑ                                           	ΒΑΣΙΛΕΙΟΣ                                         	ΝΤΕΡΝΕΚΤΣΗ                                        
3873434055	ΙΚΑΛ_79061@isc.tuc.gr                             	ΙΛΕΑΝΑ                                            	ΚΟΜΝΗΝΟΣ                                          	ΚΑΛΗΜΑΝΤΖΑΛΗ                                      
9663629895	ΡΧΡΗ_32238@isc.tuc.gr                             	ΡΟΔΑΜΑΝΘΗ                                         	ΚΥΡΙΑΚΟΣ                                          	ΧΡΗΣΤΙΝΙΔΗ                                        
5739953896	ΚΚΕΡ_53087@isc.tuc.gr                             	ΚΑΡΥΟΦΥΛΛΙΑ                                       	ΝΙΚΟΔΗΜΟΣ                                         	ΚΕΡΛΗ                                             
3847336182	ΒΔΟΥ_22067@isc.tuc.gr                             	ΒΑΛΑΝΤΗΣ                                          	ΣΤΑΥΡΟΣ                                           	ΔΟΥΡΔΑΛΗΣ                                         
5008120044	ΡΚΑΛ_75764@isc.tuc.gr                             	ΡΑΧΗΛ                                             	ΡΗΓΑΣ                                             	ΚΑΛΟΤΟΥΔΗ                                         
1087864209	ΘΓΚΑ_55759@isc.tuc.gr                             	ΘΕΛΞΙΟΠΗ                                          	ΘΕΟΚΛΗΤΟΣ                                         	ΓΚΑΣΔΑΓΛΗ                                         
9909188205	ΘΧΑΛ_94516@isc.tuc.gr                             	ΘΕΟΦΑΝΕΙΑ                                         	ΣΟΦΟΚΛΗΣ                                          	ΧΑΛΛΗ                                             
4551861182	ΕΣΑΚ_43822@isc.tuc.gr                             	ΕΛΕΥΘΕΡΙΟΣ                                        	ΑΛΕΞΙΟΣ                                           	ΣΑΚΑΝΤΑΜΗΣ                                        
5546208379	ΦΣΙΔ_35237@isc.tuc.gr                             	ΦΑΙΔΡΑ                                            	ΧΡΥΣΟΒΕΡΓΗΣ                                       	ΣΙΔΟΡΑΚΗ                                          
3562862913	ΦΤΑΣ_66606@isc.tuc.gr                             	ΦΑΙΔΡΑ                                            	ΟΜΗΡΟΣ                                            	ΤΑΣΤΣΗ                                            
4817616232	ΘΤΥΡ_2040.@isc.tuc.gr                             	ΘΑΛΕΙΑ                                            	ΠΑΪΚΟΣ                                            	ΤΥΡΑΝΝΙΔΗ                                         
4401521984	ΣΑΣΦ_93716@isc.tuc.gr                             	ΣΕΒΑΣΤΙΑ                                          	ΕΠΑΜΕΙΝΩΝΔΑΣ                                      	ΑΣΦΑΛΤΙΔΗ                                         
1330518214	ΑΒΑΡ_34163@isc.tuc.gr                             	ΑΛΚΙΣΤΗ                                           	ΔΑΜΙΑΝΟΣ                                          	ΒΑΡΔΑΛΑΚΗ                                         
2291462970	ΒΤΑΝ_36012@isc.tuc.gr                             	ΒΑΛΑΣΙΑ                                           	ΔΡΟΣΟΣ                                            	ΤΑΝΑΝΗ                                            
4508196743	ΚΣΑΡ_44850@isc.tuc.gr                             	ΚΙΜΩΝ                                             	ΑΝΤΩΝΙΟΣ                                          	ΣΑΡΗΤΣΕΣΜΕΛΗΣ                                     
6355523530	ΚΖΑΠ_752.4@isc.tuc.gr                             	ΚΛΗΜΕΝΤΙΝΗ                                        	ΜΥΡΩΝ                                             	ΖΑΠΑΝΔΙΩΤΗ                                        
9082318738	ΛΚΑΖ_98867@isc.tuc.gr                             	ΛΥΓΕΡΗ                                            	ΜΥΡΩΝ                                             	ΚΑΖΙΛΙΕΡΗ                                         
3879135430	ΩΦΕΙ_46211@isc.tuc.gr                             	ΩΡΑΙΑ                                             	ΣΤΥΛΙΑΝΟΣ                                         	ΦΕΙΔΗ                                             
4979575418	ΔΠΛΙ_36827@isc.tuc.gr                             	ΔΟΝΑΤΟΣ                                           	ΠΡΟΚΟΠΙΟΣ                                         	ΠΛΙΑΜΕΡΗΣ                                         
2678604252	ΕΚΡΕ_5272.@isc.tuc.gr                             	ΕΥΑΝΘΙΑ                                           	ΟΔΥΣΣΕΑΣ                                          	ΚΡΕΒΒΑΘΙΑΝΑΚΗ                                     
7964377440	ΜΠΛΑ_36435@isc.tuc.gr                             	ΜΕΛΑΝΙΑ                                           	ΒΕΛΙΣΣΑΡΙΟΣ                                       	ΠΛΑΦΑΔΕΛΛΗ                                        
6998019048	ΣΜΙΤ_9745.@isc.tuc.gr                             	ΣΤΕΦΑΝΟΣ                                          	ΑΘΗΝΟΔΩΡΟΣ                                        	ΜΙΤΖΟΛΗΣ                                          
5258371335	ΒΣΚΟ_75209@isc.tuc.gr                             	ΒΑΡΒΑΡΑ                                           	ΠΑΤΡΟΚΛΟΣ                                         	ΣΚΟΥΛΑΡΙΩΤΗ                                       
5691579368	ΓΜΠΙ_86692@isc.tuc.gr                             	ΓΕΡΑΣΙΜΙΝΑ                                        	ΡΗΓΑΣ                                             	ΜΠΙΛΙΤΣΑΚΗ                                        
8404946138	ΑΜΙΣ_40629@isc.tuc.gr                             	ΑΛΒΕΡΤΟΣ                                          	ΚΟΣΜΑΣ                                            	ΜΙΣΟΧΩΡΙΤΗΣ                                       
8060817812	ΙΜΗΤ_44222@isc.tuc.gr                             	ΙΣΜΗΝΗ                                            	ΚΑΡΟΛΟΣ                                           	ΜΗΤΡΟΦΑΝΑΚΗ                                       
8046642081	ΑΚΟΛ_45095@isc.tuc.gr                             	ΑΝΝΗ                                              	ΠΟΛΥΒΙΟΣ                                          	ΚΟΛΙΟΥΣΗ                                          
2987214913	ΑΜΠΟ_39281@isc.tuc.gr                             	ΑΝΔΡΟΝΙΚΗ                                         	ΚΥΡΙΑΖΗΣ                                          	ΜΠΟΥΣΜΑΛΗ                                         
6157943595	ΓΤΖΑ_28419@isc.tuc.gr                             	ΓΑΛΗΝΗ                                            	ΕΥΣΤΑΘΙΟΣ                                         	ΤΖΑΤΖΗ                                            
4472271784	ΤΣΚΕ_17793@isc.tuc.gr                             	ΤΕΡΨΙΧΟΡΗ                                         	ΣΤΑΥΡΟΣ                                           	ΣΚΕΠΕΤΑΡΗ                                         
6332092331	ΧΒΟΥ_14896@isc.tuc.gr                             	ΧΡΟΝΗΣ                                            	ΒΛΑΣΙΟΣ                                           	ΒΟΥΝΟΥΣΑΚΗΣ                                       
9031377650	ΑΚΟΚ_8481.@isc.tuc.gr                             	ΑΦΘΟΝΙΑ                                           	ΜΑΡΙΝΟΣ                                           	ΚΟΚΟΛΤΣΗ                                          
4135901681	ΣΒΑΛ_50031@isc.tuc.gr                             	ΣΙΛΒΕΣΤΡΟΣ                                        	ΚΛΕΑΡΧΟΣ                                          	ΒΑΛΙΡΗΣ                                           
2072046228	ΤΜΠΟ_67984@isc.tuc.gr                             	ΤΑΤΙΑΝΗ                                           	ΑΡΓΥΡΙΟΣ                                          	ΜΠΟΥΝΤΑΛΑΚΗ                                       
2878713838	ΜΙΟΥ_30548@isc.tuc.gr                             	ΜΕΛΑΝΙΑ                                           	ΙΩΣΗΦ                                             	ΙΟΥΛΙΔΗ                                           
8144021725	ΕΠΕΝ_26795@isc.tuc.gr                             	ΕΥΤΕΡΠΗ                                           	ΕΥΘΥΜΙΟΣ                                          	ΠΕΝΤΕΖΙΔΗ                                         
2159910442	ΧΖΕΓ_24743@isc.tuc.gr                             	ΧΡΥΣΟΒΕΡΓΗΣ                                       	ΠΑΡΑΣΧΟΣ                                          	ΖΕΓΓΕΛΗΣ                                          
2787902044	ΖΜΩΡ_26064@isc.tuc.gr                             	ΖΑΪΡΑ                                             	ΠΑΡΙΣ                                             	ΜΩΡΟΥΔΗ                                           
2695882908	ΑΛΩΛ_70618@isc.tuc.gr                             	ΑΛΚΗΣ                                             	ΧΑΡΙΛΑΟΣ                                          	ΛΩΛΙΑΚΗΣ                                          
6706118821	ΗΜΟΥ_59980@isc.tuc.gr                             	ΗΛΙΑ                                              	ΦΑΙΔΩΝ                                            	ΜΟΥΡΒΑΚΗ                                          
5350764961	ΓΚΟΥ_92671@isc.tuc.gr                             	ΓΡΑΜΜΑΤΟΥΛΑ                                       	ΣΤΑΜΟΥΛΗΣ                                         	ΚΟΥΦΙΩΤΗ                                          
6513499141	ΝΓΚΕ_72658@isc.tuc.gr                             	ΝΕΦΕΛΗ                                            	ΒΕΝΙΑΜΙΝ                                          	ΓΚΕΖΕΡΗ                                           
1107640811	ΦΚΑΡ_54697@isc.tuc.gr                             	ΦΙΛΙΤΣΑ                                           	ΤΙΤΟΣ                                             	ΚΑΡΑΚΑΣΙΑΔΗ                                       
5681283176	ΡΚΟΛ_27834@isc.tuc.gr                             	ΡΟΥΜΠΙΝΗ                                          	ΠΡΟΚΟΠΙΟΣ                                         	ΚΟΛΙΑΚΟΥΔΑΚΗ                                      
7804962112	ΒΓΟΛ_9671.@isc.tuc.gr                             	ΒΙΚΤΩΡ                                            	ΦΡΑΓΚΙΣΚΟΣ                                        	ΓΟΛΕΜΑΤΗΣ                                         
4615837554	ΣΜΗΤ_547.5@isc.tuc.gr                             	ΣΙΝΑΝ                                             	ΛΟΥΚΑΣ                                            	ΜΗΤΣΙΜΠΟΝΗΣ                                       
2036806708	ΠΣΤΟ_28586@isc.tuc.gr                             	ΠΕΤΡΟΣ                                            	ΛΕΑΝΔΡΟΣ                                          	ΣΤΟΥΡΑΙΤΗΣ                                        
6887280851	ΔΦΙΡ_9538.@isc.tuc.gr                             	ΔΙΑΜΑΝΤΩ                                          	ΑΧΜΕΤ                                             	ΦΙΡΟΓΕΝΗ                                          
7607734949	ΚΔΑΝ_55741@isc.tuc.gr                             	ΚΕΡΑΣΟΥΛΑ                                         	ΧΑΡΙΔΗΜΟΣ                                         	ΔΑΝΟΥΔΗ                                           
3083104459	ΠΓΙΟ_21476@isc.tuc.gr                             	ΠΑΝΤΕΛΙΤΣΑ                                        	ΔΙΟΓΕΝΗΣ                                          	ΓΙΟΥΜΟΥΞΟΥΖΗ                                      
2008078418	ΤΚΑΡ_49853@isc.tuc.gr                             	ΤΑΤΙΑΝΑ                                           	ΑΝΔΡΟΚΛΗΣ                                         	ΚΑΡΑΓΚΙΩΤΗ                                        
9918324559	ΔΤΡΙ_26779@isc.tuc.gr                             	ΔΗΜΟΚΡΙΤΟΣ                                        	ΠΟΛΥΝΕΙΚΗΣ                                        	ΤΡΙΜΠΟΛΙΤΣΩΤΗΣ                                    
5870380496	ΜΜΠΙ_28515@isc.tuc.gr                             	ΜΕΤΑΞΕΝΙΑ                                         	ΤΡΙΑΝΤΑΦΥΛΛΟΣ                                     	ΜΠΙΧΑΚΗ                                           
4597473567	ΝΓΚΡ_57733@isc.tuc.gr                             	ΝΕΟΚΛΗΣ                                           	ΙΑΣΩΝ                                             	ΓΚΡΟΥΤΣΗΣ                                         
8876016074	ΔΚΟΥ_60919@isc.tuc.gr                             	ΔΟΜΗΝΙΚΗ                                          	ΚΟΣΜΑΣ                                            	ΚΟΥΡΙΑΝΤΑΚΗ                                       
1430797699	ΧΜΟΥ_3297.@isc.tuc.gr                             	ΧΑΡΙΤΩ                                            	ΛΟΥΚΑΣ                                            	ΜΟΥΡΛΙΑΚΗ                                         
7027191671	ΘΜΠΑ_45927@isc.tuc.gr                             	ΘΕΚΛΑ                                             	ΤΙΜΟΛΕΩΝ                                          	ΜΠΑΙΝΑΚΤΑΡΗ                                       
7070085071	ΜΚΡΥ_8697.@isc.tuc.gr                             	ΜΑΡΟΥΔΑ                                           	ΚΛΗΜΗΣ                                            	ΚΡΥΑΔΗ                                            
7693733892	ΣΒΑΒ_80461@isc.tuc.gr                             	ΣΠΥΡΙΔΟΥΛΑ                                        	ΛΥΚΟΥΡΓΟΣ                                         	ΒΑΒΟΥΛΑΡΗ                                         
8608394441	ΣΜΕΣ_65354@isc.tuc.gr                             	ΣΙΜΟΝΗ                                            	ΙΩΝ                                               	ΜΕΣΗΜΕΡΤΣΗ                                        
8856253742	ΜΧΑΛ_3999.@isc.tuc.gr                             	ΜΠΕΤΙΝΑ                                           	ΑΝΔΡΟΚΛΗΣ                                         	ΧΑΛΚΟΠΙΑΔΗ                                        
8460800810	ΔΚΕΡ_19396@isc.tuc.gr                             	ΔΑΥΪΔ                                             	ΦΑΙΔΩΝ                                            	ΚΕΡΑΜΙΤΖΙΔΗΣ                                      
8476400978	ΜΜΠΟ_63155@isc.tuc.gr                             	ΜΙΧΑΕΛΑ                                           	ΠΟΛΥΚΑΡΠΟΣ                                        	ΜΠΟΜΠΟΤΣΑΡΗ                                       
8594980898	ΖΠΛΑ_23046@isc.tuc.gr                             	ΖΑΦΕΙΡΙΟΣ                                         	ΣΤΑΜΑΤΙΟΣ                                         	ΠΛΑΙΤΗΣ                                           
7645609660	ΚΤΣΕ_75676@isc.tuc.gr                             	ΚΛΕΑΡΧΟΣ                                          	ΙΓΝΑΤΙΟΣ                                          	ΤΣΕΠΙΛΗΣ                                          
2480017687	ΚΚΕΚ_23010@isc.tuc.gr                             	ΚΑΡΜΕΝ                                            	ΙΩΣΗΦ                                             	ΚΕΚΕΔΑΚΗ                                          
8203822212	ΟΜΟΛ_83392@isc.tuc.gr                             	ΟΡΣΑΛΙΑ                                           	ΑΧΙΛΛΕΑΣ                                          	ΜΟΛΥΒΙΑΤΗ                                         
6447532092	ΑΓΙΑ_15258@isc.tuc.gr                             	ΑΙΜΙΛΙΟΣ                                          	ΘΡΑΣΥΒΟΥΛΟΣ                                       	ΓΙΑΓΚΟΥΝΙΔΗΣ                                      
1058130124	ΑΜΑΓ_22826@isc.tuc.gr                             	ΑΝΔΡΙΑΝΗ                                          	ΜΑΡΓΑΡΙΤΗΣ                                        	ΜΑΓΚΑΝΙΑΡΗ                                        
8438962809	ΗΔΕΔ_19897@isc.tuc.gr                             	ΗΛΙΑΝΗ                                            	ΠΑΝΤΑΖΗΣ                                          	ΔΕΔΕΤΖΗ                                           
4827331705	ΜΜΕΓ_86211@isc.tuc.gr                             	ΜΑΡΙΚΑ                                            	ΒΑΣΙΛΕΙΟΣ                                         	ΜΕΓΛΕΝΗ                                           
8487670874	ΕΒΟΣ_75523@isc.tuc.gr                             	ΕΥΡΥΔΙΚΗ                                          	ΝΙΚΟΛΑΟΣ                                          	ΒΟΣΔΟΓΑΛΗ                                         
3220741072	ΑΤΟΥ_59315@isc.tuc.gr                             	ΑΝΘΙΠΠΗ                                           	ΣΤΕΡΓΙΟΣ                                          	ΤΟΥΛΓΑΡΙΔΗ                                        
5594663495	ΤΠΑΝ_65892@isc.tuc.gr                             	ΤΑΜΑΡΑ                                            	ΝΙΚΟΛΑΟΣ                                          	ΠΑΝΑΡΗ                                            
6123994037	ΑΜΙΚ_75421@isc.tuc.gr                             	ΑΘΗΝΑ                                             	ΚΟΡΝΗΛΙΟΣ                                         	ΜΙΚΙΑΛΗ                                           
2852842767	ΜΣΤΡ_65749@isc.tuc.gr                             	ΜΑΡΚΕΛΛΑ                                          	ΤΙΜΟΘΕΟΣ                                          	ΣΤΡΟΥΒΕΛΗ                                         
6067640737	ΩΤΑΓ_912.4@isc.tuc.gr                             	ΩΡΑΙΑ                                             	ΑΡΙΣΤΕΙΔΗΣ                                        	ΤΑΓΚΙΝΗ                                           
9086761662	ΔΣΑΜ_375.1@isc.tuc.gr                             	ΔΟΜΝΙΚΗ                                           	ΑΛΒΕΡΤΟΣ                                          	ΣΑΜΑΡΙΔΗ                                          
5420704236	ΚΤΣΙ_62588@isc.tuc.gr                             	ΚΙΜΩΝ                                             	ΣΤΕΦΑΝΟΣ                                          	ΤΣΙΜΠΛΙΔΗΣ                                        
3675375688	ΟΦΥΝ_56654@isc.tuc.gr                             	ΟΛΓΑ                                              	ΑΛΕΞΙΟΣ                                           	ΦΥΝΤΡΙΛΑΚΗ                                        
2169866123	ΕΤΥΜ_21851@isc.tuc.gr                             	ΕΛΕΥΘΕΡΙΑ                                         	ΦΙΛΟΠΟΙΜΗΝ                                        	ΤΥΜΠΑΝΗ                                           
6428782655	ΠΓΚΥ_13442@isc.tuc.gr                             	ΠΑΝΑΓΟΥΛΑ                                         	ΣΙΜΩΝ                                             	ΓΚΥΡΗ                                             
3593700253	ΖΣΑΛ_83433@isc.tuc.gr                             	ΖΩΗ                                               	ΛΑΜΠΡΟΣ                                           	ΣΑΛΚΕΤΖΗ                                          
7040246623	ΕΤΖΟ_50367@isc.tuc.gr                             	ΕΡΣΗ                                              	ΚΑΡΥΟΦΥΛΛΗΣ                                       	ΤΖΟΥΝΤΖΟΥΡΗ                                       
1026256227	ΡΤΣΙ_71175@isc.tuc.gr                             	ΡΙΖΟΣ                                             	ΒΙΚΤΩΡ                                            	ΤΣΙΡΟΦΙΔΗΣ                                        
2469716328	ΘΣΟΥ_45352@isc.tuc.gr                             	ΘΩΜΑΗ                                             	ΑΡΙΣΤΟΤΕΛΗΣ                                       	ΣΟΥΝΤΡΗ                                           
7471044323	ΓΠΑΛ_53664@isc.tuc.gr                             	ΓΕΡΑΣΙΜΗ                                          	ΙΩΑΚΕΙΜ                                           	ΠΑΛΑΙΟΧΟΡΛΙΔΗ                                     
7053447899	ΛΟΣΜ_18103@isc.tuc.gr                             	ΛΕΥΚΗ                                             	ΑΣΤΡΙΝΟΣ                                          	ΟΣΜΑΝΛΙΔΗ                                         
8539801400	ΣΓΡΟ_54049@isc.tuc.gr                             	ΣΑΠΦΩ                                             	ΛΕΟΝΑΡΔΟΣ                                         	ΓΡΟΖΗ                                             
5164778216	ΣΒΡΑ_35126@isc.tuc.gr                             	ΣΤΑΣΙΝΗ                                           	ΤΙΜΟΘΕΟΣ                                          	ΒΡΑΣΤΑΛΗ                                          
5661842345	ΙΒΟΥ_83457@isc.tuc.gr                             	ΙΟΥΛΙΑ                                            	ΟΔΥΣΣΕΑΣ                                          	ΒΟΥΒΗ                                             
7396055144	ΕΜΗΤ_58049@isc.tuc.gr                             	ΕΡΜΟΛΑΟΣ                                          	ΑΓΗΣΙΛΑΟΣ                                         	ΜΗΤΙΔΗΣ                                           
3625579032	ΕΝΤΕ_54523@isc.tuc.gr                             	ΕΡΜΙΟΝΗ                                           	ΘΩΜΑΣ                                             	ΝΤΕΡΜΑΝΑΚΗ                                        
4138243325	ΕΓΙΑ_47613@isc.tuc.gr                             	ΕΛΕΑΝΝΑ                                           	ΦΡΑΝΤΖΕΣΚΟΣ                                       	ΓΙΑΒΡΟΥΜΗ                                         
5991036043	ΒΓΚΟ_81096@isc.tuc.gr                             	ΒΑΣΩ                                              	ΔΑΜΙΑΝΟΣ                                          	ΓΚΟΥΤΟΥΛΟΥΔΗ                                      
1271188694	ΜΚΟΥ_31199@isc.tuc.gr                             	ΜΑΡΚΟΣ                                            	ΛΕΑΝΔΡΟΣ                                          	ΚΟΥΛΜΑΣΗΣ                                         
5618261013	ΕΚΙΡ_70623@isc.tuc.gr                             	ΕΜΜΕΛΕΙΑ                                          	ΑΝΑΣΤΑΣΙΟΣ                                        	ΚΙΡΜΠΟΥΓΙΟΥΚΗ                                     
4194858257	ΙΚΑΜ_65488@isc.tuc.gr                             	ΙΣΑΑΚ                                             	ΧΡΙΣΤΟΦΟΡΟΣ                                       	ΚΑΜΑΛΕΔΑΚΗΣ                                       
6718720787	ΔΠΕΛ_46457@isc.tuc.gr                             	ΔΗΜΗΤΡΙΑ                                          	ΟΘΩΝ                                              	ΠΕΛΕΚΟΥΔΗ                                         
5676391141	ΒΚΑΡ_93450@isc.tuc.gr                             	ΒΙΚΕΝΤΙΑ                                          	ΣΤΑΜΟΥΛΗΣ                                         	ΚΑΡΑΒΛΙΔΗ                                         
2633821068	ΣΡΟΠ_85385@isc.tuc.gr                             	ΣΩΤΗΡΙΑ                                           	ΕΥΑΓΓΕΛΟΣ                                         	ΡΟΠΑΛΙΔΗ                                          
1546052493	ΛΤΕΡ_33669@isc.tuc.gr                             	ΛΕΩΝΙΔΑΣ                                          	ΑΛΚΙΒΙΑΔΗΣ                                        	ΤΕΡΓΑΖΗΣ                                          
4164062017	ΣΞΕΝ_69974@isc.tuc.gr                             	ΣΙΜΟΝΗ                                            	ΠΑΤΡΟΚΛΟΣ                                         	ΞΕΝΕΔΑΚΗ                                          
4854562140	ΕΜΑΝ_45700@isc.tuc.gr                             	ΕΥΣΤΡΑΤΙΟΣ                                        	ΑΒΕΡΚΙΟΣ                                          	ΜΑΝΑΤΙΔΗΣ                                         
6140715988	ΝΚΑΡ_562.5@isc.tuc.gr                             	ΝΕΚΤΑΡΙΟΣ                                         	ΜΕΡΚΟΥΡΙΟΣ                                        	ΚΑΡΑΜΑΤΖΑΚΗΣ                                      
9288056055	ΘΡΟΠ_46395@isc.tuc.gr                             	ΘΕΟΧΑΡΗΣ                                          	ΧΑΡΑΛΑΜΠΟΣ                                        	ΡΟΠΑΙΤΗΣ                                          
6707404907	ΠΜΠΑ_12450@isc.tuc.gr                             	ΠΑΝΤΕΛΗΣ                                          	ΟΝΟΥΦΡΙΟΣ                                         	ΜΠΑΜΠΟΥΣΚΑΚΗΣ                                     
2208356727	ΦΤΑΠ_1475.@isc.tuc.gr                             	ΦΑΝΟΥΛΑ                                           	ΜΑΡΙΟ                                             	ΤΑΠΛΑΤΖΙΔΗ                                        
8374817722	ΚΝΟΤ_46771@isc.tuc.gr                             	ΚΟΜΝΩ                                             	ΕΡΡΙΚΟΣ                                           	ΝΟΤΗ                                              
2128109149	ΒΜΠΟ_75039@isc.tuc.gr                             	ΒΛΑΣΙΟΣ                                           	ΙΟΥΛΙΟΣ                                           	ΜΠΟΥΗΣ                                            
4883732420	ΓΚΟΥ_58129@isc.tuc.gr                             	ΓΡΑΜΜΑΤΙΑ                                         	ΚΛΕΟΒΟΥΛΟΣ                                        	ΚΟΥΘΑΡΗ                                           
9544683845	ΜΓΑΟ_68622@isc.tuc.gr                             	ΜΑΝΟΥΣΟΣ                                          	ΙΑΚΩΒΟΣ                                           	ΓΑΟΥΤΣΗΣ                                          
7556891804	ΜΚΡΙ_88481@isc.tuc.gr                             	ΜΑΚΡΙΝΑ                                           	ΧΡΙΣΤΟΔΟΥΛΟΣ                                      	ΚΡΙΝΗ                                             
7477432674	ΑΧΟΥ_42562@isc.tuc.gr                             	ΑΦΕΝΔΡΑ                                           	ΠΟΛΥΧΡΟΝΗΣ                                        	ΧΟΥΜΟΥΡΙΤΗ                                        
6584930470	ΑΜΠΟ_19990@isc.tuc.gr                             	ΑΝΕΤΑ                                             	ΛΑΖΑΡΟΣ                                           	ΜΠΟΡΙΔΗ                                           
7583148032	ΠΚΟΚ_60656@isc.tuc.gr                             	ΠΑΡΕΣΑ                                            	ΠΑΝΤΑΖΗΣ                                          	ΚΟΚΟΡΔΕΛΗ                                         
8947149003	ΣΑΝΔ_87914@isc.tuc.gr                             	ΣΩΖΙΑ                                             	ΚΙΜΩΝ                                             	ΑΝΔΡΙΤΣΑΚΗ                                        
4055974798	ΧΛΑΒ_73655@isc.tuc.gr                             	ΧΡΙΣΤΟΘΕΑ                                         	ΗΡΑΚΛΗΣ                                           	ΛΑΒΡΑΝΤΑΚΗ                                        
4636595937	ΟΖΕΪ_78760@isc.tuc.gr                             	ΟΡΣΙΑ                                             	ΙΟΡΔΑΝΗΣ                                          	ΖΕΪΜΠΕΚΗ                                          
7486950409	ΚΜΕΜ_42964@isc.tuc.gr                             	ΚΥΡΙΑΚΟΣ                                          	ΚΑΡΟΛΟΣ                                           	ΜΕΜΟΥΡΗΣ                                          
8220753015	ΚΜΑΝ_9781.@isc.tuc.gr                             	ΚΩΝΣΤΑΝΤΙΝΑ                                       	ΑΝΕΣΤΗΣ                                           	ΜΑΝΙΣΑΛΗ                                          
9298438282	ΑΓΚΟ_63217@isc.tuc.gr                             	ΑΡΙΣΤΗ                                            	ΠΥΘΑΓΟΡΑΣ                                         	ΓΚΟΚΤΣΗ                                           
4883005554	ΠΣΥΛ_2013.@isc.tuc.gr                             	ΠΑΣΧΑΛΗΣ                                          	ΟΡΧΑΝ                                             	ΣΥΛΙΒΡΗΣ                                          
1846332049	ΝΜΑΝ_64304@isc.tuc.gr                             	ΝΕΣΤΟΡΑΣ                                          	ΕΥΓΕΝΙΟΣ                                          	ΜΑΝΙΑΤΗΣ                                          
3436681608	ΑΒΟΥ_11831@isc.tuc.gr                             	ΑΛΚΙΒΙΑΔΗΣ                                        	ΘΕΟΦΥΛΑΚΤΟΣ                                       	ΒΟΥΡΤΖΟΥΜΗΣ                                       
9874041602	ΚΣΟΚ_83109@isc.tuc.gr                             	ΚΩΝΣΤΑΝΤΟΥΛΑ                                      	ΠΑΡΙΣ                                             	ΣΟΚΟΛΙΔΗ                                          
2117520743	ΝΜΑΤ_95504@isc.tuc.gr                             	ΝΙΚΟΛΕΤΑ                                          	ΘΕΜΙΣΤΟΚΛΗΣ                                       	ΜΑΤΖΟΥΡΗ                                          
8054942621	ΜΜΗΤ_82455@isc.tuc.gr                             	ΜΑΡΙΟ                                             	ΠΑΡΑΣΧΟΣ                                          	ΜΗΤΡΑΚΑΚΗΣ                                        
4068899861	ΜΜΠΟ_49597@isc.tuc.gr                             	ΜΑΚΡΙΝΑ                                           	ΦΑΙΔΩΝ                                            	ΜΠΟΥΓΙΟΥΚΛΙΔΗ                                     
7836241530	ΧΑΓΙ_42961@isc.tuc.gr                             	ΧΡΥΣΑΝΘΗ                                          	ΝΕΣΤΟΡΑΣ                                          	ΑΓΙΟΠΕΤΡΙΤΗ                                       
3731333764	ΑΧΟΥ_76906@isc.tuc.gr                             	ΑΓΑΘΟΥΛΑ                                          	ΙΩΝ                                               	ΧΟΥΣΟΥΡΙΔΗ                                        
5702720933	ΕΣΚΟ_35983@isc.tuc.gr                             	ΕΡΜΟΛΑΟΣ                                          	ΔΙΟΝΥΣΙΟΣ                                         	ΣΚΟΥΒΑΚΗΣ                                         
8382294023	ΚΜΠΕ_76631@isc.tuc.gr                             	ΚΡΥΣΤΑΛΛΙΑ                                        	ΖΗΣΗΣ                                             	ΜΠΕΛΑΛΗ                                           
6895395786	ΑΚΡΑ_47880@isc.tuc.gr                             	ΑΡΙΣΤΟΣ                                           	ΚΟΜΝΗΝΟΣ                                          	ΚΡΑΣΝΙΔΗΣ                                         
9557283074	ΣΚΡΙ_81684@isc.tuc.gr                             	ΣΟΥΛΤΑΝΑ                                          	ΠΑΝΤΕΛΗΣ                                          	ΚΡΙΕΚΟΥΚΗ                                         
4523010013	ΖΜΠΑ_77194@isc.tuc.gr                             	ΖΑΚΕΛΙΝΑ                                          	ΑΝΔΡΟΚΛΗΣ                                         	ΜΠΑΤΣΑΡΗ                                          
6183451842	ΣΚΑΛ_94276@isc.tuc.gr                             	ΣΤΑΜΑΤΟΥΛΑ                                        	ΓΟΥΛΙΕΛΜΟΣ                                        	ΚΑΛΛΙΕΡΗ                                          
6264687986	ΚΣΕΡ_94135@isc.tuc.gr                             	ΚΑΛΛΙΟΠΗ                                          	ΡΟΒΕΡΤΟΣ                                          	ΣΕΡΕΜΕΛΗ                                          
5731366745	ΠΤΖΟ_78669@isc.tuc.gr                             	ΠΙΠΙΤΣΑ                                           	ΕΥΓΕΝΙΟΣ                                          	ΤΖΟΥΝΗ                                            
4558269566	ΒΑΝΑ_42047@isc.tuc.gr                             	ΒΑΣΟΥΛΑ                                           	ΠΟΛΥΝΕΙΚΗΣ                                        	ΑΝΑΣΤΑΣΙΔΗ                                        
7392797136	ΙΛΥΡ_70174@isc.tuc.gr                             	ΙΟΚΑΣΤΗ                                           	ΜΙΛΤΙΑΔΗΣ                                         	ΛΥΡΙΩΤΑΚΗ                                         
9615099166	ΘΠΑΠ_37798@isc.tuc.gr                             	ΘΕΟΓΝΩΣΙΑ                                         	ΕΥΓΕΝΙΟΣ                                          	ΠΑΠΑΖΑΠΡΑΙΔΗ                                      
4102953417	ΕΚΟΥ_11670@isc.tuc.gr                             	ΕΥΤΕΡΠΗ                                           	ΑΣΤΡΙΝΟΣ                                          	ΚΟΥΡΟΥΓΙΑΝΝΙΔΗ                                    
4949688942	ΑΚΕΧ_59656@isc.tuc.gr                             	ΑΝΕΤΑ                                             	ΤΣΑΜΠΙΚΟΣ                                         	ΚΕΧΡΙΔΑΚΗ                                         
7092531841	ΔΓΟΥ_80360@isc.tuc.gr                             	ΔΗΜΗΤΡΙΑ                                          	ΘΕΟΦΥΛΑΚΤΟΣ                                       	ΓΟΥΔΑΝΑΚΗ                                         
9687883887	ΚΞΕΡ_31660@isc.tuc.gr                             	ΚΟΝΔΥΛΕΝΙΑ                                        	ΤΗΛΕΜΑΧΟΣ                                         	ΞΕΡΟΥΛΗ                                           
2532836980	ΑΤΑΜ_21313@isc.tuc.gr                             	ΑΘΗΝΑ                                             	ΑΡΙΣΤΕΙΔΗΣ                                        	ΤΑΜΠΗ                                             
6039680846	ΓΚΩΣ_69275@isc.tuc.gr                             	ΓΡΑΜΜΑΤΗ                                          	ΠΑΪΣΙΟΣ                                           	ΚΩΣΤΑΝΙΔΗ                                         
\.


--
-- Data for Name: Professors; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public."Professors" (rank, amka, joins_lab) FROM stdin;
assistant	8109804948	4
full	3415024983	5
assistant	1457362138	4
lecture	6987140272	3
lecture	4129539301	2
lecture	4139655001	4
assistant	4489572669	6
full	7594565848	7
full	1889286193	7
associate	7607734949	10
full	3083104459	4
assistant	2008078418	8
assistant	9918324559	2
assistant	5870380496	7
full	4597473567	5
assistant	8876016074	6
lecture	1430797699	7
associate	7027191671	6
full	7070085071	6
assistant	7693733892	8
assistant	8608394441	3
lecture	8856253742	6
full	8460800810	7
full	8476400978	3
full	8594980898	7
full	7645609660	9
lecture	2480017687	1
assistant	8203822212	4
associate	6447532092	6
full	1058130124	6
associate	8438962809	6
associate	4827331705	9
lecture	8487670874	6
assistant	3220741072	7
assistant	5594663495	9
full	6123994037	7
full	2852842767	7
full	6067640737	5
lecture	9086761662	9
associate	5420704236	8
associate	3675375688	5
full	2169866123	3
assistant	6428782655	6
assistant	3593700253	5
lecture	7040246623	9
lecture	1026256227	2
lecture	2469716328	1
lecture	7471044323	6
lecture	7053447899	7
full	8539801400	6
associate	5164778216	4
associate	5661842345	9
lecture	7396055144	2
assistant	3625579032	1
lecture	4138243325	1
lecture	5991036043	8
assistant	1271188694	9
lecture	5618261013	2
associate	4194858257	2
assistant	6718720787	5
full	5676391141	7
assistant	2633821068	7
lecture	1546052493	5
lecture	4164062017	3
full	4854562140	3
associate	6140715988	3
lecture	9288056055	8
associate	6707404907	10
lecture	2208356727	7
lecture	8374817722	7
lecture	2128109149	7
lecture	4883732420	2
assistant	9544683845	9
lecture	7556891804	4
full	7477432674	6
lecture	6584930470	7
full	7583148032	4
lecture	8947149003	6
full	4055974798	3
full	4636595937	1
assistant	7486950409	3
lecture	8220753015	6
assistant	9298438282	9
assistant	4883005554	4
lecture	1846332049	6
associate	3436681608	9
assistant	9874041602	2
assistant	2117520743	5
associate	8054942621	1
full	4068899861	3
full	7836241530	10
associate	3731333764	7
lecture	5702720933	8
assistant	8382294023	4
full	6895395786	9
associate	9557283074	2
full	4523010013	7
assistant	6183451842	7
lecture	6264687986	1
lecture	5731366745	4
assistant	4558269566	4
associate	7392797136	8
assistant	9615099166	4
assistant	4102953417	3
lecture	4949688942	1
full	7092531841	10
full	9687883887	9
lecture	2532836980	4
associate	6039680846	6
\.


--
-- Data for Name: Register; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public."Register" (register_status, exam_grade, lab_grade, final_grade, course_run_id, student_amka) FROM stdin;
approved	\N	\N	\N	593	8163254157
approved	\N	\N	\N	558	8163254157
approved	\N	\N	\N	177	1006258297
approved	\N	\N	\N	605	5243886166
approved	\N	\N	\N	618	5243886166
rejected	\N	\N	\N	604	5243886166
approved	\N	\N	\N	612	5243886166
approved	\N	\N	\N	588	5243886166
approved	\N	\N	\N	593	3391566195
approved	\N	\N	\N	558	3391566195
approved	\N	\N	\N	554	3391566195
approved	\N	\N	\N	648	3391566195
rejected	\N	\N	\N	601	3391566195
approved	\N	\N	\N	647	3391566195
approved	\N	\N	\N	573	3391566195
approved	\N	\N	\N	551	3391566195
approved	\N	\N	\N	609	3391566195
approved	\N	\N	\N	627	3391566195
approved	\N	\N	\N	574	3391566195
rejected	\N	\N	\N	636	3391566195
approved	\N	\N	\N	571	3391566195
approved	\N	\N	\N	630	3391566195
approved	\N	\N	\N	656	3391566195
rejected	\N	\N	\N	559	3391566195
rejected	\N	\N	\N	625	3391566195
approved	\N	\N	\N	595	3391566195
approved	\N	\N	\N	645	3391566195
approved	\N	\N	\N	597	3391566195
rejected	\N	\N	\N	577	3391566195
approved	\N	\N	\N	606	3391566195
approved	\N	\N	\N	651	3391566195
approved	\N	\N	\N	550	3391566195
approved	\N	\N	\N	581	3391566195
approved	\N	\N	\N	599	3391566195
approved	\N	\N	\N	622	3391566195
approved	\N	\N	\N	598	3391566195
approved	\N	\N	\N	600	3391566195
approved	\N	\N	\N	567	3391566195
approved	\N	\N	\N	563	3391566195
approved	\N	\N	\N	649	3391566195
rejected	\N	\N	\N	660	3391566195
approved	\N	\N	\N	640	3391566195
approved	\N	\N	\N	658	3391566195
approved	\N	\N	\N	653	3391566195
approved	\N	\N	\N	634	3391566195
approved	\N	\N	\N	654	3391566195
approved	\N	\N	\N	631	3391566195
approved	\N	\N	\N	659	3391566195
approved	\N	\N	\N	585	3391566195
approved	\N	\N	\N	576	3391566195
approved	\N	\N	\N	586	3391566195
approved	\N	\N	\N	633	3391566195
approved	\N	\N	\N	590	3391566195
approved	\N	\N	\N	623	3391566195
approved	\N	\N	\N	620	3391566195
rejected	\N	\N	\N	579	3391566195
approved	\N	\N	\N	549	3391566195
approved	\N	\N	\N	589	3391566195
approved	\N	\N	\N	584	3391566195
approved	\N	\N	\N	643	3391566195
approved	\N	\N	\N	613	3391566195
approved	\N	\N	\N	624	3391566195
rejected	\N	\N	\N	641	3391566195
approved	\N	\N	\N	602	3391566195
approved	\N	\N	\N	616	3391566195
approved	\N	\N	\N	646	3391566195
approved	\N	\N	\N	635	3391566195
rejected	\N	\N	\N	570	3391566195
rejected	\N	\N	\N	626	3391566195
approved	\N	\N	\N	583	3391566195
approved	\N	\N	\N	561	3391566195
approved	\N	\N	\N	580	3391566195
approved	\N	\N	\N	615	3391566195
approved	\N	\N	\N	657	3391566195
pass	10	\N	10	665	6052931528
pass	7	\N	7	705	5243886166
approved	\N	\N	\N	639	3391566195
approved	\N	\N	\N	650	3391566195
approved	\N	\N	\N	628	3391566195
approved	\N	\N	\N	564	3391566195
approved	\N	\N	\N	568	3391566195
approved	\N	\N	\N	644	3391566195
approved	\N	\N	\N	555	3391566195
approved	\N	\N	\N	552	3391566195
approved	\N	\N	\N	591	3391566195
rejected	\N	\N	\N	544	3391566195
approved	\N	\N	\N	575	3391566195
approved	\N	\N	\N	557	3391566195
approved	\N	\N	\N	546	3391566195
approved	\N	\N	\N	592	3391566195
approved	\N	\N	\N	560	3391566195
approved	\N	\N	\N	569	3391566195
approved	\N	\N	\N	614	3391566195
approved	\N	\N	\N	619	3391566195
approved	\N	\N	\N	596	3391566195
approved	\N	\N	\N	547	3391566195
approved	\N	\N	\N	603	3391566195
approved	\N	\N	\N	594	3391566195
rejected	\N	\N	\N	621	3391566195
rejected	\N	\N	\N	637	3391566195
approved	\N	\N	\N	562	3391566195
approved	\N	\N	\N	545	3391566195
rejected	\N	\N	\N	578	3391566195
approved	\N	\N	\N	608	3391566195
approved	\N	\N	\N	655	3391566195
rejected	\N	\N	\N	556	3391566195
rejected	\N	\N	\N	638	3391566195
approved	\N	\N	\N	617	3391566195
approved	\N	\N	\N	553	3391566195
approved	\N	\N	\N	572	3391566195
approved	\N	\N	\N	566	3391566195
approved	\N	\N	\N	642	3391566195
approved	\N	\N	\N	607	3391566195
approved	\N	\N	\N	632	3391566195
approved	\N	\N	\N	652	3391566195
approved	\N	\N	\N	565	3391566195
rejected	\N	\N	\N	582	3391566195
approved	\N	\N	\N	543	3391566195
approved	\N	\N	\N	611	3391566195
approved	\N	\N	\N	610	3391566195
approved	\N	\N	\N	629	3391566195
approved	\N	\N	\N	587	3391566195
approved	\N	\N	\N	548	3391566195
approved	\N	\N	\N	605	3391566195
approved	\N	\N	\N	618	3391566195
rejected	\N	\N	\N	604	3391566195
approved	\N	\N	\N	612	3391566195
approved	\N	\N	\N	588	3391566195
approved	\N	\N	\N	554	8163254157
approved	\N	\N	\N	648	8163254157
rejected	\N	\N	\N	601	8163254157
approved	\N	\N	\N	647	8163254157
approved	\N	\N	\N	573	8163254157
approved	\N	\N	\N	551	8163254157
approved	\N	\N	\N	609	8163254157
approved	\N	\N	\N	627	8163254157
approved	\N	\N	\N	574	8163254157
rejected	\N	\N	\N	636	8163254157
approved	\N	\N	\N	571	8163254157
approved	\N	\N	\N	593	9825289323
approved	\N	\N	\N	558	9825289323
approved	\N	\N	\N	554	9825289323
approved	\N	\N	\N	648	9825289323
rejected	\N	\N	\N	601	9825289323
approved	\N	\N	\N	647	9825289323
approved	\N	\N	\N	573	9825289323
approved	\N	\N	\N	551	9825289323
approved	\N	\N	\N	609	9825289323
approved	\N	\N	\N	627	9825289323
approved	\N	\N	\N	574	9825289323
rejected	\N	\N	\N	636	9825289323
approved	\N	\N	\N	571	9825289323
approved	\N	\N	\N	630	9825289323
approved	\N	\N	\N	656	9825289323
rejected	\N	\N	\N	559	9825289323
rejected	\N	\N	\N	625	9825289323
approved	\N	\N	\N	595	9825289323
approved	\N	\N	\N	645	9825289323
approved	\N	\N	\N	597	9825289323
rejected	\N	\N	\N	577	9825289323
approved	\N	\N	\N	606	9825289323
approved	\N	\N	\N	651	9825289323
approved	\N	\N	\N	550	9825289323
approved	\N	\N	\N	581	9825289323
approved	\N	\N	\N	599	9825289323
approved	\N	\N	\N	622	9825289323
approved	\N	\N	\N	598	9825289323
approved	\N	\N	\N	600	9825289323
approved	\N	\N	\N	567	9825289323
approved	\N	\N	\N	563	9825289323
approved	\N	\N	\N	649	9825289323
rejected	\N	\N	\N	660	9825289323
approved	\N	\N	\N	640	9825289323
approved	\N	\N	\N	658	9825289323
approved	\N	\N	\N	653	9825289323
approved	\N	\N	\N	634	9825289323
approved	\N	\N	\N	654	9825289323
approved	\N	\N	\N	631	9825289323
approved	\N	\N	\N	659	9825289323
approved	\N	\N	\N	585	9825289323
approved	\N	\N	\N	576	9825289323
approved	\N	\N	\N	586	9825289323
approved	\N	\N	\N	633	9825289323
approved	\N	\N	\N	590	9825289323
approved	\N	\N	\N	623	9825289323
approved	\N	\N	\N	620	9825289323
rejected	\N	\N	\N	579	9825289323
approved	\N	\N	\N	549	9825289323
approved	\N	\N	\N	589	9825289323
approved	\N	\N	\N	584	9825289323
approved	\N	\N	\N	643	9825289323
approved	\N	\N	\N	613	9825289323
approved	\N	\N	\N	624	9825289323
rejected	\N	\N	\N	641	9825289323
approved	\N	\N	\N	602	9825289323
approved	\N	\N	\N	616	9825289323
approved	\N	\N	\N	646	9825289323
approved	\N	\N	\N	635	9825289323
rejected	\N	\N	\N	570	9825289323
rejected	\N	\N	\N	626	9825289323
approved	\N	\N	\N	583	9825289323
approved	\N	\N	\N	561	9825289323
approved	\N	\N	\N	580	9825289323
approved	\N	\N	\N	615	9825289323
approved	\N	\N	\N	657	9825289323
approved	\N	\N	\N	639	9825289323
approved	\N	\N	\N	650	9825289323
approved	\N	\N	\N	628	9825289323
approved	\N	\N	\N	564	9825289323
approved	\N	\N	\N	568	9825289323
approved	\N	\N	\N	644	9825289323
approved	\N	\N	\N	555	9825289323
approved	\N	\N	\N	552	9825289323
approved	\N	\N	\N	591	9825289323
rejected	\N	\N	\N	544	9825289323
approved	\N	\N	\N	575	9825289323
approved	\N	\N	\N	557	9825289323
approved	\N	\N	\N	546	9825289323
approved	\N	\N	\N	592	9825289323
approved	\N	\N	\N	560	9825289323
approved	\N	\N	\N	569	9825289323
approved	\N	\N	\N	614	9825289323
approved	\N	\N	\N	619	9825289323
approved	\N	\N	\N	596	9825289323
approved	\N	\N	\N	547	9825289323
approved	\N	\N	\N	603	9825289323
approved	\N	\N	\N	594	9825289323
rejected	\N	\N	\N	621	9825289323
rejected	\N	\N	\N	637	9825289323
approved	\N	\N	\N	562	9825289323
approved	\N	\N	\N	545	9825289323
rejected	\N	\N	\N	578	9825289323
approved	\N	\N	\N	608	9825289323
approved	\N	\N	\N	655	9825289323
rejected	\N	\N	\N	556	9825289323
rejected	\N	\N	\N	638	9825289323
approved	\N	\N	\N	617	9825289323
approved	\N	\N	\N	553	9825289323
approved	\N	\N	\N	572	9825289323
approved	\N	\N	\N	566	9825289323
approved	\N	\N	\N	642	9825289323
approved	\N	\N	\N	607	9825289323
approved	\N	\N	\N	632	9825289323
approved	\N	\N	\N	652	9825289323
approved	\N	\N	\N	565	9825289323
rejected	\N	\N	\N	582	9825289323
approved	\N	\N	\N	543	9825289323
approved	\N	\N	\N	611	9825289323
approved	\N	\N	\N	610	9825289323
approved	\N	\N	\N	629	9825289323
approved	\N	\N	\N	587	9825289323
approved	\N	\N	\N	548	9825289323
approved	\N	\N	\N	605	9825289323
approved	\N	\N	\N	618	9825289323
rejected	\N	\N	\N	604	9825289323
approved	\N	\N	\N	612	9825289323
approved	\N	\N	\N	588	9825289323
approved	\N	\N	\N	593	5243886166
approved	\N	\N	\N	558	5243886166
approved	\N	\N	\N	554	5243886166
approved	\N	\N	\N	648	5243886166
rejected	\N	\N	\N	601	5243886166
approved	\N	\N	\N	647	5243886166
approved	\N	\N	\N	573	5243886166
approved	\N	\N	\N	551	5243886166
approved	\N	\N	\N	609	5243886166
approved	\N	\N	\N	627	5243886166
approved	\N	\N	\N	574	5243886166
rejected	\N	\N	\N	636	5243886166
approved	\N	\N	\N	571	5243886166
approved	\N	\N	\N	630	5243886166
approved	\N	\N	\N	656	5243886166
rejected	\N	\N	\N	559	5243886166
rejected	\N	\N	\N	625	5243886166
approved	\N	\N	\N	595	5243886166
approved	\N	\N	\N	645	5243886166
approved	\N	\N	\N	597	5243886166
rejected	\N	\N	\N	577	5243886166
approved	\N	\N	\N	606	5243886166
approved	\N	\N	\N	651	5243886166
approved	\N	\N	\N	550	5243886166
approved	\N	\N	\N	581	5243886166
approved	\N	\N	\N	599	5243886166
approved	\N	\N	\N	622	5243886166
approved	\N	\N	\N	598	5243886166
approved	\N	\N	\N	600	5243886166
approved	\N	\N	\N	567	5243886166
approved	\N	\N	\N	563	5243886166
approved	\N	\N	\N	649	5243886166
rejected	\N	\N	\N	660	5243886166
approved	\N	\N	\N	533	8163254157
approved	\N	\N	\N	532	1006258297
approved	\N	\N	\N	640	5243886166
approved	\N	\N	\N	658	5243886166
approved	\N	\N	\N	653	5243886166
approved	\N	\N	\N	634	5243886166
approved	\N	\N	\N	654	5243886166
approved	\N	\N	\N	631	5243886166
approved	\N	\N	\N	659	5243886166
approved	\N	\N	\N	585	5243886166
approved	\N	\N	\N	576	5243886166
approved	\N	\N	\N	586	5243886166
approved	\N	\N	\N	633	5243886166
approved	\N	\N	\N	590	5243886166
approved	\N	\N	\N	623	5243886166
approved	\N	\N	\N	620	5243886166
rejected	\N	\N	\N	579	5243886166
approved	\N	\N	\N	549	5243886166
approved	\N	\N	\N	589	5243886166
approved	\N	\N	\N	584	5243886166
approved	\N	\N	\N	643	5243886166
approved	\N	\N	\N	613	5243886166
approved	\N	\N	\N	624	5243886166
rejected	\N	\N	\N	641	5243886166
approved	\N	\N	\N	602	5243886166
approved	\N	\N	\N	616	5243886166
approved	\N	\N	\N	646	5243886166
approved	\N	\N	\N	635	5243886166
rejected	\N	\N	\N	570	5243886166
rejected	\N	\N	\N	626	5243886166
approved	\N	\N	\N	583	5243886166
approved	\N	\N	\N	561	5243886166
approved	\N	\N	\N	580	5243886166
approved	\N	\N	\N	615	5243886166
approved	\N	\N	\N	657	5243886166
approved	\N	\N	\N	639	5243886166
approved	\N	\N	\N	650	5243886166
approved	\N	\N	\N	628	5243886166
approved	\N	\N	\N	564	5243886166
approved	\N	\N	\N	568	5243886166
approved	\N	\N	\N	644	5243886166
approved	\N	\N	\N	555	5243886166
approved	\N	\N	\N	552	5243886166
approved	\N	\N	\N	591	5243886166
rejected	\N	\N	\N	544	5243886166
approved	\N	\N	\N	575	5243886166
approved	\N	\N	\N	557	5243886166
approved	\N	\N	\N	546	5243886166
approved	\N	\N	\N	592	5243886166
approved	\N	\N	\N	560	5243886166
approved	\N	\N	\N	569	5243886166
approved	\N	\N	\N	614	5243886166
approved	\N	\N	\N	619	5243886166
approved	\N	\N	\N	596	5243886166
approved	\N	\N	\N	547	5243886166
approved	\N	\N	\N	603	5243886166
approved	\N	\N	\N	594	5243886166
rejected	\N	\N	\N	621	5243886166
rejected	\N	\N	\N	637	5243886166
approved	\N	\N	\N	562	5243886166
approved	\N	\N	\N	545	5243886166
rejected	\N	\N	\N	578	5243886166
approved	\N	\N	\N	608	5243886166
approved	\N	\N	\N	655	5243886166
rejected	\N	\N	\N	556	5243886166
rejected	\N	\N	\N	638	5243886166
approved	\N	\N	\N	617	5243886166
approved	\N	\N	\N	553	5243886166
approved	\N	\N	\N	572	5243886166
approved	\N	\N	\N	566	5243886166
approved	\N	\N	\N	642	5243886166
approved	\N	\N	\N	607	5243886166
approved	\N	\N	\N	632	5243886166
approved	\N	\N	\N	652	5243886166
approved	\N	\N	\N	565	5243886166
rejected	\N	\N	\N	582	5243886166
approved	\N	\N	\N	543	5243886166
approved	\N	\N	\N	611	5243886166
approved	\N	\N	\N	610	5243886166
approved	\N	\N	\N	629	5243886166
approved	\N	\N	\N	587	5243886166
approved	\N	\N	\N	548	5243886166
approved	\N	\N	\N	630	8163254157
approved	\N	\N	\N	656	8163254157
rejected	\N	\N	\N	559	8163254157
rejected	\N	\N	\N	625	8163254157
approved	\N	\N	\N	595	8163254157
approved	\N	\N	\N	645	8163254157
approved	\N	\N	\N	597	8163254157
rejected	\N	\N	\N	577	8163254157
approved	\N	\N	\N	651	8163254157
approved	\N	\N	\N	550	8163254157
approved	\N	\N	\N	581	8163254157
approved	\N	\N	\N	599	8163254157
approved	\N	\N	\N	622	8163254157
approved	\N	\N	\N	598	8163254157
approved	\N	\N	\N	600	8163254157
approved	\N	\N	\N	567	8163254157
approved	\N	\N	\N	563	8163254157
approved	\N	\N	\N	649	8163254157
rejected	\N	\N	\N	660	8163254157
approved	\N	\N	\N	640	8163254157
approved	\N	\N	\N	658	8163254157
approved	\N	\N	\N	653	8163254157
approved	\N	\N	\N	634	8163254157
approved	\N	\N	\N	610	8163254157
approved	\N	\N	\N	654	8163254157
approved	\N	\N	\N	629	8163254157
approved	\N	\N	\N	631	8163254157
approved	\N	\N	\N	659	8163254157
approved	\N	\N	\N	587	8163254157
approved	\N	\N	\N	548	8163254157
approved	\N	\N	\N	585	8163254157
approved	\N	\N	\N	576	8163254157
approved	\N	\N	\N	605	8163254157
approved	\N	\N	\N	586	8163254157
approved	\N	\N	\N	633	8163254157
approved	\N	\N	\N	618	8163254157
rejected	\N	\N	\N	604	8163254157
approved	\N	\N	\N	590	8163254157
approved	\N	\N	\N	623	8163254157
approved	\N	\N	\N	620	8163254157
approved	\N	\N	\N	612	8163254157
rejected	\N	\N	\N	579	8163254157
approved	\N	\N	\N	588	8163254157
approved	\N	\N	\N	549	8163254157
approved	\N	\N	\N	589	8163254157
approved	\N	\N	\N	584	8163254157
approved	\N	\N	\N	643	8163254157
approved	\N	\N	\N	613	8163254157
approved	\N	\N	\N	624	8163254157
rejected	\N	\N	\N	641	8163254157
approved	\N	\N	\N	602	8163254157
approved	\N	\N	\N	616	8163254157
approved	\N	\N	\N	646	8163254157
approved	\N	\N	\N	635	8163254157
approved	\N	\N	\N	583	8163254157
approved	\N	\N	\N	561	8163254157
approved	\N	\N	\N	580	8163254157
approved	\N	\N	\N	615	8163254157
approved	\N	\N	\N	657	8163254157
approved	\N	\N	\N	639	8163254157
approved	\N	\N	\N	628	8163254157
approved	\N	\N	\N	568	8163254157
approved	\N	\N	\N	644	8163254157
approved	\N	\N	\N	555	8163254157
approved	\N	\N	\N	552	8163254157
rejected	\N	\N	\N	544	8163254157
approved	\N	\N	\N	575	8163254157
approved	\N	\N	\N	557	8163254157
approved	\N	\N	\N	546	8163254157
approved	\N	\N	\N	592	8163254157
approved	\N	\N	\N	560	8163254157
approved	\N	\N	\N	569	8163254157
approved	\N	\N	\N	614	8163254157
approved	\N	\N	\N	619	8163254157
approved	\N	\N	\N	596	8163254157
approved	\N	\N	\N	547	8163254157
approved	\N	\N	\N	603	8163254157
approved	\N	\N	\N	594	8163254157
rejected	\N	\N	\N	621	8163254157
rejected	\N	\N	\N	637	8163254157
approved	\N	\N	\N	562	8163254157
approved	\N	\N	\N	545	8163254157
rejected	\N	\N	\N	578	8163254157
approved	\N	\N	\N	655	8163254157
rejected	\N	\N	\N	556	8163254157
rejected	\N	\N	\N	638	8163254157
approved	\N	\N	\N	617	8163254157
approved	\N	\N	\N	553	8163254157
approved	\N	\N	\N	572	8163254157
approved	\N	\N	\N	642	8163254157
approved	\N	\N	\N	607	8163254157
approved	\N	\N	\N	632	8163254157
approved	\N	\N	\N	652	8163254157
approved	\N	\N	\N	565	8163254157
rejected	\N	\N	\N	582	8163254157
approved	\N	\N	\N	543	8163254157
approved	\N	\N	\N	611	8163254157
approved	\N	\N	\N	593	1077861304
approved	\N	\N	\N	558	1077861304
approved	\N	\N	\N	554	1077861304
approved	\N	\N	\N	648	1077861304
rejected	\N	\N	\N	601	1077861304
approved	\N	\N	\N	647	1077861304
approved	\N	\N	\N	573	1077861304
approved	\N	\N	\N	551	1077861304
approved	\N	\N	\N	609	1077861304
approved	\N	\N	\N	627	1077861304
approved	\N	\N	\N	574	1077861304
rejected	\N	\N	\N	636	1077861304
approved	\N	\N	\N	571	1077861304
approved	\N	\N	\N	630	1077861304
approved	\N	\N	\N	656	1077861304
rejected	\N	\N	\N	559	1077861304
rejected	\N	\N	\N	625	1077861304
approved	\N	\N	\N	595	1077861304
approved	\N	\N	\N	645	1077861304
approved	\N	\N	\N	597	1077861304
rejected	\N	\N	\N	577	1077861304
approved	\N	\N	\N	606	1077861304
approved	\N	\N	\N	651	1077861304
approved	\N	\N	\N	550	1077861304
approved	\N	\N	\N	581	1077861304
approved	\N	\N	\N	599	1077861304
approved	\N	\N	\N	622	1077861304
approved	\N	\N	\N	598	1077861304
approved	\N	\N	\N	600	1077861304
approved	\N	\N	\N	567	1077861304
approved	\N	\N	\N	563	1077861304
approved	\N	\N	\N	649	1077861304
rejected	\N	\N	\N	660	1077861304
approved	\N	\N	\N	640	1077861304
approved	\N	\N	\N	658	1077861304
approved	\N	\N	\N	653	1077861304
approved	\N	\N	\N	634	1077861304
approved	\N	\N	\N	654	1077861304
approved	\N	\N	\N	631	1077861304
approved	\N	\N	\N	659	1077861304
approved	\N	\N	\N	585	1077861304
approved	\N	\N	\N	576	1077861304
approved	\N	\N	\N	586	1077861304
approved	\N	\N	\N	633	1077861304
approved	\N	\N	\N	590	1077861304
approved	\N	\N	\N	623	1077861304
approved	\N	\N	\N	620	1077861304
rejected	\N	\N	\N	579	1077861304
approved	\N	\N	\N	549	1077861304
approved	\N	\N	\N	589	1077861304
approved	\N	\N	\N	584	1077861304
approved	\N	\N	\N	643	1077861304
approved	\N	\N	\N	613	1077861304
approved	\N	\N	\N	624	1077861304
rejected	\N	\N	\N	641	1077861304
approved	\N	\N	\N	602	1077861304
approved	\N	\N	\N	616	1077861304
approved	\N	\N	\N	646	1077861304
approved	\N	\N	\N	635	1077861304
rejected	\N	\N	\N	570	1077861304
rejected	\N	\N	\N	626	1077861304
approved	\N	\N	\N	583	1077861304
approved	\N	\N	\N	561	1077861304
approved	\N	\N	\N	580	1077861304
approved	\N	\N	\N	615	1077861304
approved	\N	\N	\N	657	1077861304
approved	\N	\N	\N	639	1077861304
approved	\N	\N	\N	650	1077861304
approved	\N	\N	\N	628	1077861304
approved	\N	\N	\N	564	1077861304
approved	\N	\N	\N	568	1077861304
approved	\N	\N	\N	644	1077861304
approved	\N	\N	\N	555	1077861304
approved	\N	\N	\N	552	1077861304
approved	\N	\N	\N	591	1077861304
rejected	\N	\N	\N	544	1077861304
approved	\N	\N	\N	575	1077861304
approved	\N	\N	\N	557	1077861304
approved	\N	\N	\N	546	1077861304
approved	\N	\N	\N	592	1077861304
approved	\N	\N	\N	560	1077861304
approved	\N	\N	\N	569	1077861304
approved	\N	\N	\N	614	1077861304
approved	\N	\N	\N	619	1077861304
approved	\N	\N	\N	596	1077861304
approved	\N	\N	\N	547	1077861304
approved	\N	\N	\N	603	1077861304
approved	\N	\N	\N	594	1077861304
rejected	\N	\N	\N	621	1077861304
rejected	\N	\N	\N	637	1077861304
approved	\N	\N	\N	562	1077861304
approved	\N	\N	\N	545	1077861304
rejected	\N	\N	\N	578	1077861304
approved	\N	\N	\N	608	1077861304
approved	\N	\N	\N	655	1077861304
rejected	\N	\N	\N	556	1077861304
rejected	\N	\N	\N	638	1077861304
approved	\N	\N	\N	617	1077861304
approved	\N	\N	\N	553	1077861304
approved	\N	\N	\N	572	1077861304
approved	\N	\N	\N	566	1077861304
approved	\N	\N	\N	642	1077861304
approved	\N	\N	\N	607	1077861304
approved	\N	\N	\N	632	1077861304
approved	\N	\N	\N	652	1077861304
approved	\N	\N	\N	565	1077861304
rejected	\N	\N	\N	582	1077861304
approved	\N	\N	\N	543	1077861304
approved	\N	\N	\N	611	1077861304
approved	\N	\N	\N	610	1077861304
approved	\N	\N	\N	629	1077861304
approved	\N	\N	\N	587	1077861304
approved	\N	\N	\N	548	1077861304
approved	\N	\N	\N	605	1077861304
approved	\N	\N	\N	618	1077861304
rejected	\N	\N	\N	604	1077861304
approved	\N	\N	\N	612	1077861304
approved	\N	\N	\N	588	1077861304
approved	\N	\N	\N	593	1006258297
approved	\N	\N	\N	558	1006258297
approved	\N	\N	\N	554	1006258297
approved	\N	\N	\N	648	1006258297
rejected	\N	\N	\N	601	1006258297
approved	\N	\N	\N	647	1006258297
approved	\N	\N	\N	573	1006258297
approved	\N	\N	\N	551	1006258297
approved	\N	\N	\N	609	1006258297
approved	\N	\N	\N	627	1006258297
approved	\N	\N	\N	574	1006258297
rejected	\N	\N	\N	636	1006258297
approved	\N	\N	\N	571	1006258297
approved	\N	\N	\N	630	1006258297
approved	\N	\N	\N	656	1006258297
rejected	\N	\N	\N	559	1006258297
rejected	\N	\N	\N	625	1006258297
approved	\N	\N	\N	595	1006258297
approved	\N	\N	\N	645	1006258297
approved	\N	\N	\N	597	1006258297
rejected	\N	\N	\N	577	1006258297
approved	\N	\N	\N	606	1006258297
approved	\N	\N	\N	651	1006258297
approved	\N	\N	\N	550	1006258297
approved	\N	\N	\N	581	1006258297
approved	\N	\N	\N	599	1006258297
approved	\N	\N	\N	622	1006258297
approved	\N	\N	\N	598	1006258297
approved	\N	\N	\N	600	1006258297
approved	\N	\N	\N	567	1006258297
approved	\N	\N	\N	563	1006258297
approved	\N	\N	\N	649	1006258297
rejected	\N	\N	\N	660	1006258297
approved	\N	\N	\N	640	1006258297
approved	\N	\N	\N	658	1006258297
approved	\N	\N	\N	653	1006258297
approved	\N	\N	\N	634	1006258297
approved	\N	\N	\N	654	1006258297
approved	\N	\N	\N	631	1006258297
approved	\N	\N	\N	659	1006258297
approved	\N	\N	\N	585	1006258297
approved	\N	\N	\N	576	1006258297
approved	\N	\N	\N	586	1006258297
approved	\N	\N	\N	633	1006258297
approved	\N	\N	\N	590	1006258297
approved	\N	\N	\N	623	1006258297
approved	\N	\N	\N	620	1006258297
rejected	\N	\N	\N	579	1006258297
approved	\N	\N	\N	549	1006258297
approved	\N	\N	\N	589	1006258297
approved	\N	\N	\N	584	1006258297
approved	\N	\N	\N	643	1006258297
approved	\N	\N	\N	613	1006258297
approved	\N	\N	\N	624	1006258297
rejected	\N	\N	\N	641	1006258297
approved	\N	\N	\N	602	1006258297
approved	\N	\N	\N	616	1006258297
approved	\N	\N	\N	646	1006258297
approved	\N	\N	\N	635	1006258297
rejected	\N	\N	\N	570	1006258297
rejected	\N	\N	\N	626	1006258297
approved	\N	\N	\N	583	1006258297
approved	\N	\N	\N	561	1006258297
approved	\N	\N	\N	580	1006258297
approved	\N	\N	\N	615	1006258297
approved	\N	\N	\N	657	1006258297
approved	\N	\N	\N	639	1006258297
approved	\N	\N	\N	650	1006258297
approved	\N	\N	\N	628	1006258297
approved	\N	\N	\N	564	1006258297
approved	\N	\N	\N	568	1006258297
approved	\N	\N	\N	644	1006258297
approved	\N	\N	\N	555	1006258297
approved	\N	\N	\N	552	1006258297
approved	\N	\N	\N	591	1006258297
rejected	\N	\N	\N	544	1006258297
approved	\N	\N	\N	575	1006258297
approved	\N	\N	\N	557	1006258297
approved	\N	\N	\N	546	1006258297
approved	\N	\N	\N	592	1006258297
approved	\N	\N	\N	560	1006258297
approved	\N	\N	\N	569	1006258297
approved	\N	\N	\N	614	1006258297
approved	\N	\N	\N	619	1006258297
approved	\N	\N	\N	596	1006258297
approved	\N	\N	\N	547	1006258297
approved	\N	\N	\N	603	1006258297
approved	\N	\N	\N	594	1006258297
rejected	\N	\N	\N	621	1006258297
rejected	\N	\N	\N	637	1006258297
approved	\N	\N	\N	562	1006258297
approved	\N	\N	\N	545	1006258297
rejected	\N	\N	\N	578	1006258297
approved	\N	\N	\N	608	1006258297
approved	\N	\N	\N	655	1006258297
rejected	\N	\N	\N	556	1006258297
rejected	\N	\N	\N	638	1006258297
approved	\N	\N	\N	617	1006258297
approved	\N	\N	\N	553	1006258297
approved	\N	\N	\N	572	1006258297
approved	\N	\N	\N	566	1006258297
approved	\N	\N	\N	642	1006258297
approved	\N	\N	\N	607	1006258297
approved	\N	\N	\N	632	1006258297
approved	\N	\N	\N	652	1006258297
approved	\N	\N	\N	565	1006258297
rejected	\N	\N	\N	582	1006258297
approved	\N	\N	\N	543	1006258297
approved	\N	\N	\N	611	1006258297
approved	\N	\N	\N	610	1006258297
approved	\N	\N	\N	629	1006258297
approved	\N	\N	\N	587	1006258297
approved	\N	\N	\N	548	1006258297
approved	\N	\N	\N	605	1006258297
approved	\N	\N	\N	618	1006258297
rejected	\N	\N	\N	604	1006258297
approved	\N	\N	\N	612	1006258297
approved	\N	\N	\N	588	1006258297
approved	\N	\N	\N	593	5589427861
approved	\N	\N	\N	558	5589427861
approved	\N	\N	\N	554	5589427861
approved	\N	\N	\N	648	5589427861
rejected	\N	\N	\N	601	5589427861
approved	\N	\N	\N	647	5589427861
approved	\N	\N	\N	573	5589427861
approved	\N	\N	\N	551	5589427861
approved	\N	\N	\N	609	5589427861
approved	\N	\N	\N	627	5589427861
approved	\N	\N	\N	574	5589427861
rejected	\N	\N	\N	636	5589427861
approved	\N	\N	\N	571	5589427861
approved	\N	\N	\N	630	5589427861
approved	\N	\N	\N	656	5589427861
rejected	\N	\N	\N	559	5589427861
rejected	\N	\N	\N	625	5589427861
approved	\N	\N	\N	595	5589427861
approved	\N	\N	\N	645	5589427861
approved	\N	\N	\N	597	5589427861
rejected	\N	\N	\N	577	5589427861
approved	\N	\N	\N	606	5589427861
approved	\N	\N	\N	651	5589427861
approved	\N	\N	\N	550	5589427861
approved	\N	\N	\N	581	5589427861
approved	\N	\N	\N	599	5589427861
approved	\N	\N	\N	622	5589427861
approved	\N	\N	\N	598	5589427861
approved	\N	\N	\N	600	5589427861
approved	\N	\N	\N	567	5589427861
approved	\N	\N	\N	563	5589427861
approved	\N	\N	\N	649	5589427861
rejected	\N	\N	\N	660	5589427861
approved	\N	\N	\N	640	5589427861
approved	\N	\N	\N	658	5589427861
approved	\N	\N	\N	653	5589427861
approved	\N	\N	\N	634	5589427861
approved	\N	\N	\N	654	5589427861
approved	\N	\N	\N	631	5589427861
approved	\N	\N	\N	659	5589427861
approved	\N	\N	\N	585	5589427861
approved	\N	\N	\N	576	5589427861
approved	\N	\N	\N	586	5589427861
approved	\N	\N	\N	633	5589427861
approved	\N	\N	\N	590	5589427861
approved	\N	\N	\N	623	5589427861
approved	\N	\N	\N	620	5589427861
rejected	\N	\N	\N	579	5589427861
approved	\N	\N	\N	549	5589427861
approved	\N	\N	\N	589	5589427861
approved	\N	\N	\N	584	5589427861
approved	\N	\N	\N	643	5589427861
approved	\N	\N	\N	613	5589427861
approved	\N	\N	\N	624	5589427861
rejected	\N	\N	\N	641	5589427861
approved	\N	\N	\N	602	5589427861
approved	\N	\N	\N	616	5589427861
approved	\N	\N	\N	646	5589427861
approved	\N	\N	\N	635	5589427861
rejected	\N	\N	\N	570	5589427861
rejected	\N	\N	\N	626	5589427861
approved	\N	\N	\N	583	5589427861
approved	\N	\N	\N	561	5589427861
approved	\N	\N	\N	580	5589427861
approved	\N	\N	\N	615	5589427861
approved	\N	\N	\N	657	5589427861
approved	\N	\N	\N	639	5589427861
approved	\N	\N	\N	650	5589427861
approved	\N	\N	\N	628	5589427861
approved	\N	\N	\N	564	5589427861
approved	\N	\N	\N	568	5589427861
approved	\N	\N	\N	644	5589427861
approved	\N	\N	\N	555	5589427861
approved	\N	\N	\N	552	5589427861
approved	\N	\N	\N	591	5589427861
rejected	\N	\N	\N	544	5589427861
approved	\N	\N	\N	575	5589427861
approved	\N	\N	\N	557	5589427861
approved	\N	\N	\N	546	5589427861
approved	\N	\N	\N	592	5589427861
approved	\N	\N	\N	560	5589427861
approved	\N	\N	\N	569	5589427861
approved	\N	\N	\N	614	5589427861
approved	\N	\N	\N	619	5589427861
approved	\N	\N	\N	596	5589427861
approved	\N	\N	\N	547	5589427861
approved	\N	\N	\N	603	5589427861
approved	\N	\N	\N	594	5589427861
rejected	\N	\N	\N	621	5589427861
rejected	\N	\N	\N	637	5589427861
approved	\N	\N	\N	562	5589427861
approved	\N	\N	\N	545	5589427861
rejected	\N	\N	\N	578	5589427861
approved	\N	\N	\N	608	5589427861
approved	\N	\N	\N	655	5589427861
rejected	\N	\N	\N	556	5589427861
rejected	\N	\N	\N	638	5589427861
approved	\N	\N	\N	617	5589427861
approved	\N	\N	\N	553	5589427861
approved	\N	\N	\N	572	5589427861
approved	\N	\N	\N	566	5589427861
approved	\N	\N	\N	642	5589427861
approved	\N	\N	\N	607	5589427861
approved	\N	\N	\N	632	5589427861
approved	\N	\N	\N	652	5589427861
approved	\N	\N	\N	565	5589427861
rejected	\N	\N	\N	582	5589427861
approved	\N	\N	\N	543	5589427861
approved	\N	\N	\N	611	5589427861
approved	\N	\N	\N	610	5589427861
approved	\N	\N	\N	629	5589427861
approved	\N	\N	\N	587	5589427861
approved	\N	\N	\N	548	5589427861
approved	\N	\N	\N	605	5589427861
approved	\N	\N	\N	618	5589427861
rejected	\N	\N	\N	604	5589427861
approved	\N	\N	\N	612	5589427861
approved	\N	\N	\N	588	5589427861
approved	\N	\N	\N	593	5081927005
approved	\N	\N	\N	558	5081927005
approved	\N	\N	\N	554	5081927005
approved	\N	\N	\N	648	5081927005
rejected	\N	\N	\N	601	5081927005
approved	\N	\N	\N	647	5081927005
approved	\N	\N	\N	573	5081927005
approved	\N	\N	\N	551	5081927005
approved	\N	\N	\N	609	5081927005
approved	\N	\N	\N	627	5081927005
approved	\N	\N	\N	574	5081927005
rejected	\N	\N	\N	636	5081927005
approved	\N	\N	\N	571	5081927005
approved	\N	\N	\N	630	5081927005
approved	\N	\N	\N	656	5081927005
rejected	\N	\N	\N	559	5081927005
rejected	\N	\N	\N	625	5081927005
approved	\N	\N	\N	595	5081927005
approved	\N	\N	\N	645	5081927005
approved	\N	\N	\N	597	5081927005
rejected	\N	\N	\N	577	5081927005
approved	\N	\N	\N	606	5081927005
approved	\N	\N	\N	651	5081927005
approved	\N	\N	\N	550	5081927005
approved	\N	\N	\N	581	5081927005
approved	\N	\N	\N	599	5081927005
approved	\N	\N	\N	622	5081927005
approved	\N	\N	\N	598	5081927005
approved	\N	\N	\N	600	5081927005
approved	\N	\N	\N	567	5081927005
approved	\N	\N	\N	563	5081927005
approved	\N	\N	\N	649	5081927005
rejected	\N	\N	\N	660	5081927005
approved	\N	\N	\N	640	5081927005
approved	\N	\N	\N	658	5081927005
approved	\N	\N	\N	653	5081927005
approved	\N	\N	\N	634	5081927005
approved	\N	\N	\N	654	5081927005
approved	\N	\N	\N	631	5081927005
approved	\N	\N	\N	659	5081927005
approved	\N	\N	\N	585	5081927005
approved	\N	\N	\N	576	5081927005
approved	\N	\N	\N	586	5081927005
approved	\N	\N	\N	633	5081927005
approved	\N	\N	\N	590	5081927005
approved	\N	\N	\N	623	5081927005
approved	\N	\N	\N	620	5081927005
rejected	\N	\N	\N	579	5081927005
approved	\N	\N	\N	549	5081927005
approved	\N	\N	\N	589	5081927005
approved	\N	\N	\N	584	5081927005
approved	\N	\N	\N	643	5081927005
approved	\N	\N	\N	613	5081927005
approved	\N	\N	\N	624	5081927005
rejected	\N	\N	\N	641	5081927005
approved	\N	\N	\N	602	5081927005
approved	\N	\N	\N	616	5081927005
approved	\N	\N	\N	646	5081927005
approved	\N	\N	\N	635	5081927005
rejected	\N	\N	\N	570	5081927005
rejected	\N	\N	\N	626	5081927005
approved	\N	\N	\N	583	5081927005
approved	\N	\N	\N	561	5081927005
approved	\N	\N	\N	580	5081927005
approved	\N	\N	\N	615	5081927005
approved	\N	\N	\N	657	5081927005
approved	\N	\N	\N	639	5081927005
approved	\N	\N	\N	650	5081927005
approved	\N	\N	\N	628	5081927005
approved	\N	\N	\N	564	5081927005
approved	\N	\N	\N	568	5081927005
approved	\N	\N	\N	644	5081927005
approved	\N	\N	\N	555	5081927005
approved	\N	\N	\N	552	5081927005
approved	\N	\N	\N	591	5081927005
rejected	\N	\N	\N	544	5081927005
approved	\N	\N	\N	575	5081927005
approved	\N	\N	\N	557	5081927005
approved	\N	\N	\N	546	5081927005
approved	\N	\N	\N	592	5081927005
approved	\N	\N	\N	560	5081927005
approved	\N	\N	\N	569	5081927005
approved	\N	\N	\N	614	5081927005
approved	\N	\N	\N	619	5081927005
approved	\N	\N	\N	596	5081927005
approved	\N	\N	\N	547	5081927005
approved	\N	\N	\N	603	5081927005
approved	\N	\N	\N	594	5081927005
rejected	\N	\N	\N	621	5081927005
rejected	\N	\N	\N	637	5081927005
approved	\N	\N	\N	562	5081927005
approved	\N	\N	\N	545	5081927005
rejected	\N	\N	\N	578	5081927005
approved	\N	\N	\N	608	5081927005
approved	\N	\N	\N	655	5081927005
rejected	\N	\N	\N	556	5081927005
rejected	\N	\N	\N	638	5081927005
approved	\N	\N	\N	617	5081927005
approved	\N	\N	\N	553	5081927005
approved	\N	\N	\N	572	5081927005
approved	\N	\N	\N	566	5081927005
approved	\N	\N	\N	642	5081927005
approved	\N	\N	\N	607	5081927005
approved	\N	\N	\N	632	5081927005
approved	\N	\N	\N	652	5081927005
approved	\N	\N	\N	565	5081927005
rejected	\N	\N	\N	582	5081927005
approved	\N	\N	\N	543	5081927005
approved	\N	\N	\N	611	5081927005
approved	\N	\N	\N	610	5081927005
approved	\N	\N	\N	629	5081927005
approved	\N	\N	\N	587	5081927005
approved	\N	\N	\N	548	5081927005
approved	\N	\N	\N	605	5081927005
approved	\N	\N	\N	618	5081927005
rejected	\N	\N	\N	604	5081927005
approved	\N	\N	\N	612	5081927005
approved	\N	\N	\N	588	5081927005
approved	\N	\N	\N	633	6052931528
approved	\N	\N	\N	603	6052931528
approved	\N	\N	\N	558	6052931528
approved	\N	\N	\N	575	6052931528
approved	\N	\N	\N	574	6052931528
approved	\N	\N	\N	632	6052931528
approved	\N	\N	\N	617	6052931528
approved	\N	\N	\N	563	6052931528
approved	\N	\N	\N	624	6052931528
approved	\N	\N	\N	602	6052931528
approved	\N	\N	\N	573	6052931528
approved	\N	\N	\N	543	6052931528
approved	\N	\N	\N	553	6052931528
approved	\N	\N	\N	561	6052931528
approved	\N	\N	\N	634	6052931528
approved	\N	\N	\N	628	6052931528
approved	\N	\N	\N	633	7242749087
approved	\N	\N	\N	603	7242749087
approved	\N	\N	\N	558	7242749087
approved	\N	\N	\N	575	7242749087
approved	\N	\N	\N	574	7242749087
approved	\N	\N	\N	632	7242749087
approved	\N	\N	\N	617	7242749087
approved	\N	\N	\N	563	7242749087
approved	\N	\N	\N	624	7242749087
approved	\N	\N	\N	602	7242749087
approved	\N	\N	\N	573	7242749087
approved	\N	\N	\N	543	7242749087
approved	\N	\N	\N	553	7242749087
approved	\N	\N	\N	561	7242749087
approved	\N	\N	\N	634	7242749087
approved	\N	\N	\N	628	7242749087
approved	\N	\N	\N	633	6023433046
approved	\N	\N	\N	603	6023433046
approved	\N	\N	\N	558	6023433046
approved	\N	\N	\N	575	6023433046
approved	\N	\N	\N	574	6023433046
approved	\N	\N	\N	632	6023433046
approved	\N	\N	\N	617	6023433046
approved	\N	\N	\N	563	6023433046
approved	\N	\N	\N	624	6023433046
approved	\N	\N	\N	602	6023433046
approved	\N	\N	\N	573	6023433046
approved	\N	\N	\N	543	6023433046
approved	\N	\N	\N	553	6023433046
approved	\N	\N	\N	561	6023433046
approved	\N	\N	\N	634	6023433046
approved	\N	\N	\N	628	6023433046
approved	\N	\N	\N	633	3911487577
approved	\N	\N	\N	603	3911487577
approved	\N	\N	\N	558	3911487577
approved	\N	\N	\N	575	3911487577
approved	\N	\N	\N	574	3911487577
approved	\N	\N	\N	632	3911487577
approved	\N	\N	\N	617	3911487577
approved	\N	\N	\N	563	3911487577
approved	\N	\N	\N	624	3911487577
approved	\N	\N	\N	602	3911487577
approved	\N	\N	\N	573	3911487577
approved	\N	\N	\N	543	3911487577
approved	\N	\N	\N	553	3911487577
approved	\N	\N	\N	561	3911487577
approved	\N	\N	\N	634	3911487577
approved	\N	\N	\N	628	3911487577
approved	\N	\N	\N	633	9980820595
approved	\N	\N	\N	603	9980820595
approved	\N	\N	\N	558	9980820595
approved	\N	\N	\N	575	9980820595
approved	\N	\N	\N	574	9980820595
approved	\N	\N	\N	632	9980820595
approved	\N	\N	\N	617	9980820595
approved	\N	\N	\N	563	9980820595
approved	\N	\N	\N	624	9980820595
approved	\N	\N	\N	602	9980820595
approved	\N	\N	\N	573	9980820595
approved	\N	\N	\N	543	9980820595
approved	\N	\N	\N	553	9980820595
approved	\N	\N	\N	561	9980820595
approved	\N	\N	\N	634	9980820595
approved	\N	\N	\N	628	9980820595
approved	\N	\N	\N	633	9544567295
approved	\N	\N	\N	603	9544567295
approved	\N	\N	\N	558	9544567295
approved	\N	\N	\N	575	9544567295
approved	\N	\N	\N	574	9544567295
approved	\N	\N	\N	632	9544567295
approved	\N	\N	\N	617	9544567295
approved	\N	\N	\N	563	9544567295
approved	\N	\N	\N	624	9544567295
approved	\N	\N	\N	602	9544567295
approved	\N	\N	\N	573	9544567295
approved	\N	\N	\N	543	9544567295
approved	\N	\N	\N	553	9544567295
approved	\N	\N	\N	561	9544567295
approved	\N	\N	\N	634	9544567295
approved	\N	\N	\N	628	9544567295
approved	\N	\N	\N	633	1292902580
approved	\N	\N	\N	603	1292902580
approved	\N	\N	\N	558	1292902580
approved	\N	\N	\N	575	1292902580
approved	\N	\N	\N	574	1292902580
approved	\N	\N	\N	632	1292902580
approved	\N	\N	\N	617	1292902580
approved	\N	\N	\N	563	1292902580
approved	\N	\N	\N	624	1292902580
approved	\N	\N	\N	602	1292902580
approved	\N	\N	\N	573	1292902580
approved	\N	\N	\N	543	1292902580
approved	\N	\N	\N	553	1292902580
approved	\N	\N	\N	561	1292902580
approved	\N	\N	\N	634	1292902580
approved	\N	\N	\N	628	1292902580
approved	\N	\N	\N	633	3207392350
approved	\N	\N	\N	603	3207392350
approved	\N	\N	\N	558	3207392350
approved	\N	\N	\N	575	3207392350
approved	\N	\N	\N	574	3207392350
approved	\N	\N	\N	632	3207392350
approved	\N	\N	\N	617	3207392350
approved	\N	\N	\N	563	3207392350
approved	\N	\N	\N	624	3207392350
approved	\N	\N	\N	602	3207392350
approved	\N	\N	\N	573	3207392350
approved	\N	\N	\N	543	3207392350
approved	\N	\N	\N	553	3207392350
approved	\N	\N	\N	561	3207392350
approved	\N	\N	\N	634	3207392350
approved	\N	\N	\N	628	3207392350
approved	\N	\N	\N	633	2563337837
approved	\N	\N	\N	603	2563337837
approved	\N	\N	\N	558	2563337837
approved	\N	\N	\N	575	2563337837
approved	\N	\N	\N	574	2563337837
approved	\N	\N	\N	632	2563337837
approved	\N	\N	\N	617	2563337837
approved	\N	\N	\N	563	2563337837
approved	\N	\N	\N	624	2563337837
approved	\N	\N	\N	602	2563337837
approved	\N	\N	\N	573	2563337837
approved	\N	\N	\N	543	2563337837
approved	\N	\N	\N	553	2563337837
approved	\N	\N	\N	561	2563337837
approved	\N	\N	\N	634	2563337837
approved	\N	\N	\N	628	2563337837
approved	\N	\N	\N	633	6123973547
approved	\N	\N	\N	603	6123973547
approved	\N	\N	\N	558	6123973547
approved	\N	\N	\N	575	6123973547
approved	\N	\N	\N	574	6123973547
approved	\N	\N	\N	632	6123973547
approved	\N	\N	\N	617	6123973547
approved	\N	\N	\N	563	6123973547
approved	\N	\N	\N	624	6123973547
approved	\N	\N	\N	602	6123973547
approved	\N	\N	\N	573	6123973547
approved	\N	\N	\N	543	6123973547
approved	\N	\N	\N	553	6123973547
approved	\N	\N	\N	561	6123973547
approved	\N	\N	\N	634	6123973547
approved	\N	\N	\N	628	6123973547
approved	\N	\N	\N	633	8048161591
approved	\N	\N	\N	603	8048161591
approved	\N	\N	\N	558	8048161591
approved	\N	\N	\N	575	8048161591
approved	\N	\N	\N	574	8048161591
approved	\N	\N	\N	632	8048161591
approved	\N	\N	\N	617	8048161591
approved	\N	\N	\N	563	8048161591
approved	\N	\N	\N	624	8048161591
approved	\N	\N	\N	602	8048161591
approved	\N	\N	\N	573	8048161591
approved	\N	\N	\N	543	8048161591
approved	\N	\N	\N	553	8048161591
approved	\N	\N	\N	561	8048161591
approved	\N	\N	\N	634	8048161591
approved	\N	\N	\N	628	8048161591
approved	\N	\N	\N	633	3885371670
approved	\N	\N	\N	603	3885371670
approved	\N	\N	\N	558	3885371670
approved	\N	\N	\N	575	3885371670
approved	\N	\N	\N	574	3885371670
approved	\N	\N	\N	632	3885371670
approved	\N	\N	\N	617	3885371670
approved	\N	\N	\N	563	3885371670
approved	\N	\N	\N	624	3885371670
approved	\N	\N	\N	602	3885371670
approved	\N	\N	\N	573	3885371670
approved	\N	\N	\N	543	3885371670
approved	\N	\N	\N	553	3885371670
approved	\N	\N	\N	561	3885371670
approved	\N	\N	\N	634	3885371670
approved	\N	\N	\N	628	3885371670
approved	\N	\N	\N	633	1677623273
approved	\N	\N	\N	603	1677623273
approved	\N	\N	\N	558	1677623273
approved	\N	\N	\N	575	1677623273
approved	\N	\N	\N	574	1677623273
approved	\N	\N	\N	632	1677623273
approved	\N	\N	\N	617	1677623273
approved	\N	\N	\N	563	1677623273
approved	\N	\N	\N	624	1677623273
approved	\N	\N	\N	602	1677623273
approved	\N	\N	\N	573	1677623273
approved	\N	\N	\N	543	1677623273
approved	\N	\N	\N	553	1677623273
approved	\N	\N	\N	561	1677623273
approved	\N	\N	\N	634	1677623273
approved	\N	\N	\N	628	1677623273
approved	\N	\N	\N	633	7412729163
approved	\N	\N	\N	603	7412729163
approved	\N	\N	\N	558	7412729163
approved	\N	\N	\N	575	7412729163
approved	\N	\N	\N	574	7412729163
approved	\N	\N	\N	632	7412729163
approved	\N	\N	\N	617	7412729163
approved	\N	\N	\N	563	7412729163
approved	\N	\N	\N	624	7412729163
approved	\N	\N	\N	602	7412729163
approved	\N	\N	\N	573	7412729163
approved	\N	\N	\N	543	7412729163
approved	\N	\N	\N	553	7412729163
approved	\N	\N	\N	561	7412729163
approved	\N	\N	\N	634	7412729163
approved	\N	\N	\N	628	7412729163
approved	\N	\N	\N	633	1908920784
approved	\N	\N	\N	603	1908920784
approved	\N	\N	\N	558	1908920784
approved	\N	\N	\N	575	1908920784
approved	\N	\N	\N	574	1908920784
approved	\N	\N	\N	632	1908920784
approved	\N	\N	\N	617	1908920784
approved	\N	\N	\N	563	1908920784
approved	\N	\N	\N	624	1908920784
approved	\N	\N	\N	602	1908920784
approved	\N	\N	\N	573	1908920784
approved	\N	\N	\N	543	1908920784
approved	\N	\N	\N	553	1908920784
approved	\N	\N	\N	561	1908920784
approved	\N	\N	\N	634	1908920784
approved	\N	\N	\N	628	1908920784
approved	\N	\N	\N	633	7604634123
approved	\N	\N	\N	603	7604634123
approved	\N	\N	\N	558	7604634123
approved	\N	\N	\N	575	7604634123
approved	\N	\N	\N	574	7604634123
approved	\N	\N	\N	632	7604634123
approved	\N	\N	\N	617	7604634123
approved	\N	\N	\N	563	7604634123
approved	\N	\N	\N	624	7604634123
approved	\N	\N	\N	602	7604634123
approved	\N	\N	\N	573	7604634123
approved	\N	\N	\N	543	7604634123
approved	\N	\N	\N	553	7604634123
approved	\N	\N	\N	561	7604634123
approved	\N	\N	\N	634	7604634123
approved	\N	\N	\N	628	7604634123
approved	\N	\N	\N	633	2678213354
approved	\N	\N	\N	603	2678213354
approved	\N	\N	\N	558	2678213354
approved	\N	\N	\N	575	2678213354
approved	\N	\N	\N	574	2678213354
approved	\N	\N	\N	632	2678213354
approved	\N	\N	\N	617	2678213354
approved	\N	\N	\N	563	2678213354
approved	\N	\N	\N	624	2678213354
approved	\N	\N	\N	602	2678213354
approved	\N	\N	\N	573	2678213354
approved	\N	\N	\N	543	2678213354
approved	\N	\N	\N	553	2678213354
approved	\N	\N	\N	561	2678213354
approved	\N	\N	\N	634	2678213354
approved	\N	\N	\N	628	2678213354
approved	\N	\N	\N	633	8140626094
approved	\N	\N	\N	603	8140626094
approved	\N	\N	\N	558	8140626094
approved	\N	\N	\N	575	8140626094
approved	\N	\N	\N	574	8140626094
approved	\N	\N	\N	632	8140626094
approved	\N	\N	\N	617	8140626094
approved	\N	\N	\N	563	8140626094
approved	\N	\N	\N	624	8140626094
approved	\N	\N	\N	602	8140626094
approved	\N	\N	\N	573	8140626094
approved	\N	\N	\N	543	8140626094
approved	\N	\N	\N	553	8140626094
approved	\N	\N	\N	561	8140626094
approved	\N	\N	\N	634	8140626094
approved	\N	\N	\N	628	8140626094
approved	\N	\N	\N	633	9262628998
approved	\N	\N	\N	603	9262628998
approved	\N	\N	\N	558	9262628998
approved	\N	\N	\N	575	9262628998
approved	\N	\N	\N	574	9262628998
approved	\N	\N	\N	632	9262628998
approved	\N	\N	\N	617	9262628998
approved	\N	\N	\N	563	9262628998
approved	\N	\N	\N	624	9262628998
approved	\N	\N	\N	602	9262628998
approved	\N	\N	\N	573	9262628998
approved	\N	\N	\N	543	9262628998
approved	\N	\N	\N	553	9262628998
approved	\N	\N	\N	561	9262628998
approved	\N	\N	\N	634	9262628998
approved	\N	\N	\N	628	9262628998
approved	\N	\N	\N	633	6368086134
approved	\N	\N	\N	603	6368086134
approved	\N	\N	\N	558	6368086134
approved	\N	\N	\N	575	6368086134
approved	\N	\N	\N	574	6368086134
approved	\N	\N	\N	632	6368086134
approved	\N	\N	\N	617	6368086134
approved	\N	\N	\N	563	6368086134
approved	\N	\N	\N	624	6368086134
approved	\N	\N	\N	602	6368086134
approved	\N	\N	\N	573	6368086134
approved	\N	\N	\N	543	6368086134
approved	\N	\N	\N	553	6368086134
approved	\N	\N	\N	561	6368086134
approved	\N	\N	\N	634	6368086134
approved	\N	\N	\N	628	6368086134
approved	\N	\N	\N	633	4141651461
approved	\N	\N	\N	603	4141651461
approved	\N	\N	\N	558	4141651461
approved	\N	\N	\N	575	4141651461
approved	\N	\N	\N	574	4141651461
approved	\N	\N	\N	632	4141651461
approved	\N	\N	\N	617	4141651461
approved	\N	\N	\N	563	4141651461
approved	\N	\N	\N	624	4141651461
approved	\N	\N	\N	602	4141651461
approved	\N	\N	\N	573	4141651461
approved	\N	\N	\N	543	4141651461
approved	\N	\N	\N	553	4141651461
approved	\N	\N	\N	561	4141651461
approved	\N	\N	\N	634	4141651461
approved	\N	\N	\N	628	4141651461
approved	\N	\N	\N	633	7611391463
approved	\N	\N	\N	603	7611391463
approved	\N	\N	\N	558	7611391463
approved	\N	\N	\N	575	7611391463
approved	\N	\N	\N	574	7611391463
approved	\N	\N	\N	632	7611391463
approved	\N	\N	\N	617	7611391463
approved	\N	\N	\N	563	7611391463
approved	\N	\N	\N	624	7611391463
approved	\N	\N	\N	602	7611391463
approved	\N	\N	\N	573	7611391463
approved	\N	\N	\N	543	7611391463
approved	\N	\N	\N	553	7611391463
approved	\N	\N	\N	561	7611391463
approved	\N	\N	\N	634	7611391463
approved	\N	\N	\N	628	7611391463
approved	\N	\N	\N	633	1002017775
approved	\N	\N	\N	603	1002017775
approved	\N	\N	\N	558	1002017775
approved	\N	\N	\N	575	1002017775
approved	\N	\N	\N	574	1002017775
approved	\N	\N	\N	632	1002017775
approved	\N	\N	\N	617	1002017775
approved	\N	\N	\N	563	1002017775
approved	\N	\N	\N	624	1002017775
approved	\N	\N	\N	602	1002017775
approved	\N	\N	\N	573	1002017775
approved	\N	\N	\N	543	1002017775
approved	\N	\N	\N	553	1002017775
approved	\N	\N	\N	561	1002017775
approved	\N	\N	\N	634	1002017775
approved	\N	\N	\N	628	1002017775
approved	\N	\N	\N	633	2127379383
approved	\N	\N	\N	603	2127379383
approved	\N	\N	\N	558	2127379383
approved	\N	\N	\N	575	2127379383
approved	\N	\N	\N	574	2127379383
approved	\N	\N	\N	632	2127379383
approved	\N	\N	\N	617	2127379383
approved	\N	\N	\N	563	2127379383
approved	\N	\N	\N	624	2127379383
approved	\N	\N	\N	602	2127379383
approved	\N	\N	\N	573	2127379383
approved	\N	\N	\N	543	2127379383
approved	\N	\N	\N	553	2127379383
approved	\N	\N	\N	561	2127379383
approved	\N	\N	\N	634	2127379383
approved	\N	\N	\N	628	2127379383
approved	\N	\N	\N	633	5383048297
approved	\N	\N	\N	603	5383048297
approved	\N	\N	\N	558	5383048297
approved	\N	\N	\N	575	5383048297
approved	\N	\N	\N	574	5383048297
approved	\N	\N	\N	632	5383048297
approved	\N	\N	\N	617	5383048297
approved	\N	\N	\N	563	5383048297
approved	\N	\N	\N	624	5383048297
approved	\N	\N	\N	602	5383048297
approved	\N	\N	\N	573	5383048297
approved	\N	\N	\N	543	5383048297
approved	\N	\N	\N	553	5383048297
approved	\N	\N	\N	561	5383048297
approved	\N	\N	\N	634	5383048297
approved	\N	\N	\N	628	5383048297
approved	\N	\N	\N	633	2456626264
approved	\N	\N	\N	603	2456626264
approved	\N	\N	\N	558	2456626264
approved	\N	\N	\N	575	2456626264
approved	\N	\N	\N	574	2456626264
approved	\N	\N	\N	632	2456626264
approved	\N	\N	\N	617	2456626264
approved	\N	\N	\N	563	2456626264
approved	\N	\N	\N	624	2456626264
approved	\N	\N	\N	602	2456626264
approved	\N	\N	\N	573	2456626264
approved	\N	\N	\N	543	2456626264
approved	\N	\N	\N	553	2456626264
approved	\N	\N	\N	561	2456626264
approved	\N	\N	\N	634	2456626264
approved	\N	\N	\N	628	2456626264
approved	\N	\N	\N	633	5027772807
approved	\N	\N	\N	603	5027772807
approved	\N	\N	\N	558	5027772807
approved	\N	\N	\N	575	5027772807
approved	\N	\N	\N	574	5027772807
approved	\N	\N	\N	632	5027772807
approved	\N	\N	\N	617	5027772807
approved	\N	\N	\N	563	5027772807
approved	\N	\N	\N	624	5027772807
approved	\N	\N	\N	602	5027772807
approved	\N	\N	\N	573	5027772807
approved	\N	\N	\N	543	5027772807
approved	\N	\N	\N	553	5027772807
approved	\N	\N	\N	561	5027772807
approved	\N	\N	\N	634	5027772807
approved	\N	\N	\N	628	5027772807
approved	\N	\N	\N	633	2539403312
approved	\N	\N	\N	603	2539403312
approved	\N	\N	\N	558	2539403312
approved	\N	\N	\N	575	2539403312
approved	\N	\N	\N	574	2539403312
approved	\N	\N	\N	632	2539403312
approved	\N	\N	\N	617	2539403312
approved	\N	\N	\N	563	2539403312
approved	\N	\N	\N	624	2539403312
approved	\N	\N	\N	602	2539403312
approved	\N	\N	\N	573	2539403312
approved	\N	\N	\N	543	2539403312
approved	\N	\N	\N	553	2539403312
approved	\N	\N	\N	561	2539403312
approved	\N	\N	\N	634	2539403312
approved	\N	\N	\N	628	2539403312
approved	\N	\N	\N	633	3466969247
approved	\N	\N	\N	603	3466969247
approved	\N	\N	\N	558	3466969247
approved	\N	\N	\N	575	3466969247
approved	\N	\N	\N	574	3466969247
approved	\N	\N	\N	632	3466969247
approved	\N	\N	\N	617	3466969247
approved	\N	\N	\N	563	3466969247
approved	\N	\N	\N	624	3466969247
approved	\N	\N	\N	602	3466969247
approved	\N	\N	\N	573	3466969247
approved	\N	\N	\N	543	3466969247
approved	\N	\N	\N	553	3466969247
approved	\N	\N	\N	561	3466969247
approved	\N	\N	\N	634	3466969247
approved	\N	\N	\N	628	3466969247
approved	\N	\N	\N	633	5404276104
approved	\N	\N	\N	603	5404276104
approved	\N	\N	\N	558	5404276104
approved	\N	\N	\N	575	5404276104
approved	\N	\N	\N	574	5404276104
approved	\N	\N	\N	632	5404276104
approved	\N	\N	\N	617	5404276104
approved	\N	\N	\N	563	5404276104
approved	\N	\N	\N	624	5404276104
approved	\N	\N	\N	602	5404276104
approved	\N	\N	\N	573	5404276104
approved	\N	\N	\N	543	5404276104
approved	\N	\N	\N	553	5404276104
approved	\N	\N	\N	561	5404276104
approved	\N	\N	\N	634	5404276104
approved	\N	\N	\N	628	5404276104
approved	\N	\N	\N	633	5298653978
approved	\N	\N	\N	603	5298653978
approved	\N	\N	\N	558	5298653978
approved	\N	\N	\N	575	5298653978
approved	\N	\N	\N	574	5298653978
approved	\N	\N	\N	632	5298653978
approved	\N	\N	\N	617	5298653978
approved	\N	\N	\N	563	5298653978
approved	\N	\N	\N	624	5298653978
approved	\N	\N	\N	602	5298653978
approved	\N	\N	\N	573	5298653978
approved	\N	\N	\N	543	5298653978
approved	\N	\N	\N	553	5298653978
approved	\N	\N	\N	561	5298653978
approved	\N	\N	\N	634	5298653978
approved	\N	\N	\N	628	5298653978
approved	\N	\N	\N	633	8519900776
approved	\N	\N	\N	603	8519900776
approved	\N	\N	\N	558	8519900776
approved	\N	\N	\N	575	8519900776
approved	\N	\N	\N	574	8519900776
approved	\N	\N	\N	632	8519900776
approved	\N	\N	\N	617	8519900776
approved	\N	\N	\N	563	8519900776
approved	\N	\N	\N	624	8519900776
approved	\N	\N	\N	602	8519900776
approved	\N	\N	\N	573	8519900776
approved	\N	\N	\N	543	8519900776
approved	\N	\N	\N	553	8519900776
approved	\N	\N	\N	561	8519900776
approved	\N	\N	\N	634	8519900776
approved	\N	\N	\N	628	8519900776
approved	\N	\N	\N	633	2647025193
approved	\N	\N	\N	603	2647025193
approved	\N	\N	\N	558	2647025193
approved	\N	\N	\N	575	2647025193
approved	\N	\N	\N	574	2647025193
approved	\N	\N	\N	632	2647025193
approved	\N	\N	\N	617	2647025193
approved	\N	\N	\N	563	2647025193
approved	\N	\N	\N	624	2647025193
approved	\N	\N	\N	602	2647025193
approved	\N	\N	\N	573	2647025193
approved	\N	\N	\N	543	2647025193
approved	\N	\N	\N	553	2647025193
approved	\N	\N	\N	561	2647025193
approved	\N	\N	\N	634	2647025193
approved	\N	\N	\N	628	2647025193
approved	\N	\N	\N	633	1322087026
approved	\N	\N	\N	603	1322087026
approved	\N	\N	\N	558	1322087026
approved	\N	\N	\N	575	1322087026
approved	\N	\N	\N	574	1322087026
approved	\N	\N	\N	632	1322087026
approved	\N	\N	\N	617	1322087026
approved	\N	\N	\N	563	1322087026
approved	\N	\N	\N	624	1322087026
approved	\N	\N	\N	602	1322087026
approved	\N	\N	\N	573	1322087026
approved	\N	\N	\N	543	1322087026
approved	\N	\N	\N	553	1322087026
approved	\N	\N	\N	561	1322087026
approved	\N	\N	\N	634	1322087026
approved	\N	\N	\N	628	1322087026
approved	\N	\N	\N	633	2431388358
approved	\N	\N	\N	603	2431388358
approved	\N	\N	\N	558	2431388358
approved	\N	\N	\N	575	2431388358
approved	\N	\N	\N	574	2431388358
approved	\N	\N	\N	632	2431388358
approved	\N	\N	\N	617	2431388358
approved	\N	\N	\N	563	2431388358
approved	\N	\N	\N	624	2431388358
approved	\N	\N	\N	602	2431388358
approved	\N	\N	\N	573	2431388358
approved	\N	\N	\N	543	2431388358
approved	\N	\N	\N	553	2431388358
approved	\N	\N	\N	561	2431388358
approved	\N	\N	\N	634	2431388358
approved	\N	\N	\N	628	2431388358
approved	\N	\N	\N	633	2627845789
approved	\N	\N	\N	603	2627845789
approved	\N	\N	\N	558	2627845789
approved	\N	\N	\N	575	2627845789
approved	\N	\N	\N	574	2627845789
approved	\N	\N	\N	632	2627845789
approved	\N	\N	\N	617	2627845789
approved	\N	\N	\N	563	2627845789
approved	\N	\N	\N	624	2627845789
approved	\N	\N	\N	602	2627845789
approved	\N	\N	\N	573	2627845789
approved	\N	\N	\N	543	2627845789
approved	\N	\N	\N	553	2627845789
approved	\N	\N	\N	561	2627845789
approved	\N	\N	\N	634	2627845789
approved	\N	\N	\N	628	2627845789
approved	\N	\N	\N	633	9866654321
approved	\N	\N	\N	603	9866654321
approved	\N	\N	\N	558	9866654321
approved	\N	\N	\N	575	9866654321
approved	\N	\N	\N	574	9866654321
approved	\N	\N	\N	632	9866654321
approved	\N	\N	\N	617	9866654321
approved	\N	\N	\N	563	9866654321
approved	\N	\N	\N	624	9866654321
approved	\N	\N	\N	602	9866654321
approved	\N	\N	\N	573	9866654321
approved	\N	\N	\N	543	9866654321
approved	\N	\N	\N	553	9866654321
approved	\N	\N	\N	561	9866654321
approved	\N	\N	\N	634	9866654321
approved	\N	\N	\N	628	9866654321
approved	\N	\N	\N	633	2724290938
approved	\N	\N	\N	603	2724290938
approved	\N	\N	\N	558	2724290938
approved	\N	\N	\N	575	2724290938
approved	\N	\N	\N	574	2724290938
approved	\N	\N	\N	632	2724290938
approved	\N	\N	\N	617	2724290938
approved	\N	\N	\N	563	2724290938
approved	\N	\N	\N	624	2724290938
approved	\N	\N	\N	602	2724290938
approved	\N	\N	\N	573	2724290938
approved	\N	\N	\N	543	2724290938
approved	\N	\N	\N	553	2724290938
approved	\N	\N	\N	561	2724290938
approved	\N	\N	\N	634	2724290938
approved	\N	\N	\N	628	2724290938
approved	\N	\N	\N	633	4835238140
approved	\N	\N	\N	603	4835238140
approved	\N	\N	\N	558	4835238140
approved	\N	\N	\N	575	4835238140
approved	\N	\N	\N	574	4835238140
approved	\N	\N	\N	632	4835238140
approved	\N	\N	\N	617	4835238140
approved	\N	\N	\N	563	4835238140
approved	\N	\N	\N	624	4835238140
approved	\N	\N	\N	602	4835238140
approved	\N	\N	\N	573	4835238140
approved	\N	\N	\N	543	4835238140
approved	\N	\N	\N	553	4835238140
approved	\N	\N	\N	561	4835238140
approved	\N	\N	\N	634	4835238140
approved	\N	\N	\N	628	4835238140
approved	\N	\N	\N	633	2429992163
approved	\N	\N	\N	603	2429992163
approved	\N	\N	\N	558	2429992163
approved	\N	\N	\N	575	2429992163
approved	\N	\N	\N	574	2429992163
approved	\N	\N	\N	632	2429992163
approved	\N	\N	\N	617	2429992163
approved	\N	\N	\N	563	2429992163
approved	\N	\N	\N	624	2429992163
approved	\N	\N	\N	602	2429992163
approved	\N	\N	\N	573	2429992163
approved	\N	\N	\N	543	2429992163
approved	\N	\N	\N	553	2429992163
approved	\N	\N	\N	561	2429992163
approved	\N	\N	\N	634	2429992163
approved	\N	\N	\N	628	2429992163
approved	\N	\N	\N	633	7848264486
approved	\N	\N	\N	603	7848264486
approved	\N	\N	\N	558	7848264486
approved	\N	\N	\N	575	7848264486
approved	\N	\N	\N	574	7848264486
approved	\N	\N	\N	632	7848264486
approved	\N	\N	\N	617	7848264486
approved	\N	\N	\N	563	7848264486
approved	\N	\N	\N	624	7848264486
approved	\N	\N	\N	602	7848264486
approved	\N	\N	\N	573	7848264486
approved	\N	\N	\N	543	7848264486
approved	\N	\N	\N	553	7848264486
approved	\N	\N	\N	561	7848264486
approved	\N	\N	\N	634	7848264486
approved	\N	\N	\N	628	7848264486
approved	\N	\N	\N	633	2883399736
approved	\N	\N	\N	603	2883399736
approved	\N	\N	\N	558	2883399736
approved	\N	\N	\N	575	2883399736
approved	\N	\N	\N	574	2883399736
approved	\N	\N	\N	632	2883399736
approved	\N	\N	\N	617	2883399736
approved	\N	\N	\N	563	2883399736
approved	\N	\N	\N	624	2883399736
approved	\N	\N	\N	602	2883399736
approved	\N	\N	\N	573	2883399736
approved	\N	\N	\N	543	2883399736
approved	\N	\N	\N	553	2883399736
approved	\N	\N	\N	561	2883399736
approved	\N	\N	\N	634	2883399736
approved	\N	\N	\N	628	2883399736
approved	\N	\N	\N	633	5315363834
approved	\N	\N	\N	603	5315363834
approved	\N	\N	\N	558	5315363834
approved	\N	\N	\N	575	5315363834
approved	\N	\N	\N	574	5315363834
approved	\N	\N	\N	632	5315363834
approved	\N	\N	\N	617	5315363834
approved	\N	\N	\N	563	5315363834
approved	\N	\N	\N	624	5315363834
approved	\N	\N	\N	602	5315363834
approved	\N	\N	\N	573	5315363834
approved	\N	\N	\N	543	5315363834
approved	\N	\N	\N	553	5315363834
approved	\N	\N	\N	561	5315363834
approved	\N	\N	\N	634	5315363834
approved	\N	\N	\N	628	5315363834
approved	\N	\N	\N	633	8525887759
approved	\N	\N	\N	603	8525887759
approved	\N	\N	\N	558	8525887759
approved	\N	\N	\N	575	8525887759
approved	\N	\N	\N	574	8525887759
approved	\N	\N	\N	632	8525887759
approved	\N	\N	\N	617	8525887759
approved	\N	\N	\N	563	8525887759
approved	\N	\N	\N	624	8525887759
approved	\N	\N	\N	602	8525887759
approved	\N	\N	\N	573	8525887759
approved	\N	\N	\N	543	8525887759
approved	\N	\N	\N	553	8525887759
approved	\N	\N	\N	561	8525887759
approved	\N	\N	\N	634	8525887759
approved	\N	\N	\N	628	8525887759
approved	\N	\N	\N	633	9296128900
approved	\N	\N	\N	603	9296128900
approved	\N	\N	\N	558	9296128900
approved	\N	\N	\N	575	9296128900
approved	\N	\N	\N	574	9296128900
approved	\N	\N	\N	632	9296128900
approved	\N	\N	\N	617	9296128900
approved	\N	\N	\N	563	9296128900
approved	\N	\N	\N	624	9296128900
approved	\N	\N	\N	602	9296128900
approved	\N	\N	\N	573	9296128900
approved	\N	\N	\N	543	9296128900
approved	\N	\N	\N	553	9296128900
approved	\N	\N	\N	561	9296128900
approved	\N	\N	\N	634	9296128900
approved	\N	\N	\N	628	9296128900
approved	\N	\N	\N	633	6224284619
approved	\N	\N	\N	603	6224284619
approved	\N	\N	\N	558	6224284619
approved	\N	\N	\N	575	6224284619
approved	\N	\N	\N	574	6224284619
approved	\N	\N	\N	632	6224284619
approved	\N	\N	\N	617	6224284619
approved	\N	\N	\N	563	6224284619
approved	\N	\N	\N	624	6224284619
approved	\N	\N	\N	602	6224284619
approved	\N	\N	\N	573	6224284619
approved	\N	\N	\N	543	6224284619
approved	\N	\N	\N	553	6224284619
approved	\N	\N	\N	561	6224284619
approved	\N	\N	\N	634	6224284619
approved	\N	\N	\N	628	6224284619
approved	\N	\N	\N	633	6130521884
approved	\N	\N	\N	603	6130521884
approved	\N	\N	\N	558	6130521884
approved	\N	\N	\N	575	6130521884
approved	\N	\N	\N	574	6130521884
approved	\N	\N	\N	632	6130521884
approved	\N	\N	\N	617	6130521884
approved	\N	\N	\N	563	6130521884
approved	\N	\N	\N	624	6130521884
approved	\N	\N	\N	602	6130521884
approved	\N	\N	\N	573	6130521884
approved	\N	\N	\N	543	6130521884
approved	\N	\N	\N	553	6130521884
approved	\N	\N	\N	561	6130521884
approved	\N	\N	\N	634	6130521884
approved	\N	\N	\N	628	6130521884
approved	\N	\N	\N	633	1974342255
approved	\N	\N	\N	603	1974342255
approved	\N	\N	\N	558	1974342255
approved	\N	\N	\N	575	1974342255
approved	\N	\N	\N	574	1974342255
approved	\N	\N	\N	632	1974342255
approved	\N	\N	\N	617	1974342255
approved	\N	\N	\N	563	1974342255
approved	\N	\N	\N	624	1974342255
approved	\N	\N	\N	602	1974342255
approved	\N	\N	\N	573	1974342255
approved	\N	\N	\N	543	1974342255
approved	\N	\N	\N	553	1974342255
approved	\N	\N	\N	561	1974342255
approved	\N	\N	\N	634	1974342255
approved	\N	\N	\N	628	1974342255
approved	\N	\N	\N	633	4364910715
approved	\N	\N	\N	603	4364910715
approved	\N	\N	\N	558	4364910715
approved	\N	\N	\N	575	4364910715
approved	\N	\N	\N	574	4364910715
approved	\N	\N	\N	632	4364910715
approved	\N	\N	\N	617	4364910715
approved	\N	\N	\N	563	4364910715
approved	\N	\N	\N	624	4364910715
approved	\N	\N	\N	602	4364910715
approved	\N	\N	\N	573	4364910715
approved	\N	\N	\N	543	4364910715
approved	\N	\N	\N	553	4364910715
approved	\N	\N	\N	561	4364910715
approved	\N	\N	\N	634	4364910715
approved	\N	\N	\N	628	4364910715
approved	\N	\N	\N	633	5393150884
approved	\N	\N	\N	603	5393150884
approved	\N	\N	\N	558	5393150884
approved	\N	\N	\N	575	5393150884
approved	\N	\N	\N	574	5393150884
approved	\N	\N	\N	632	5393150884
approved	\N	\N	\N	617	5393150884
approved	\N	\N	\N	563	5393150884
approved	\N	\N	\N	624	5393150884
approved	\N	\N	\N	602	5393150884
approved	\N	\N	\N	573	5393150884
approved	\N	\N	\N	543	5393150884
approved	\N	\N	\N	553	5393150884
approved	\N	\N	\N	561	5393150884
approved	\N	\N	\N	634	5393150884
approved	\N	\N	\N	628	5393150884
approved	\N	\N	\N	633	7342428390
approved	\N	\N	\N	603	7342428390
approved	\N	\N	\N	558	7342428390
approved	\N	\N	\N	575	7342428390
approved	\N	\N	\N	574	7342428390
approved	\N	\N	\N	632	7342428390
approved	\N	\N	\N	617	7342428390
approved	\N	\N	\N	563	7342428390
approved	\N	\N	\N	624	7342428390
approved	\N	\N	\N	602	7342428390
approved	\N	\N	\N	573	7342428390
approved	\N	\N	\N	543	7342428390
approved	\N	\N	\N	553	7342428390
approved	\N	\N	\N	561	7342428390
approved	\N	\N	\N	634	7342428390
approved	\N	\N	\N	628	7342428390
approved	\N	\N	\N	633	7506562181
approved	\N	\N	\N	603	7506562181
approved	\N	\N	\N	558	7506562181
approved	\N	\N	\N	575	7506562181
approved	\N	\N	\N	574	7506562181
approved	\N	\N	\N	632	7506562181
approved	\N	\N	\N	617	7506562181
approved	\N	\N	\N	563	7506562181
approved	\N	\N	\N	624	7506562181
approved	\N	\N	\N	602	7506562181
approved	\N	\N	\N	573	7506562181
approved	\N	\N	\N	543	7506562181
approved	\N	\N	\N	553	7506562181
approved	\N	\N	\N	561	7506562181
approved	\N	\N	\N	634	7506562181
approved	\N	\N	\N	628	7506562181
approved	\N	\N	\N	633	3004542348
approved	\N	\N	\N	603	3004542348
approved	\N	\N	\N	558	3004542348
approved	\N	\N	\N	575	3004542348
approved	\N	\N	\N	574	3004542348
approved	\N	\N	\N	632	3004542348
approved	\N	\N	\N	617	3004542348
approved	\N	\N	\N	563	3004542348
approved	\N	\N	\N	624	3004542348
approved	\N	\N	\N	602	3004542348
approved	\N	\N	\N	573	3004542348
approved	\N	\N	\N	543	3004542348
approved	\N	\N	\N	553	3004542348
approved	\N	\N	\N	561	3004542348
approved	\N	\N	\N	634	3004542348
approved	\N	\N	\N	628	3004542348
approved	\N	\N	\N	633	7344446165
approved	\N	\N	\N	603	7344446165
approved	\N	\N	\N	558	7344446165
approved	\N	\N	\N	575	7344446165
approved	\N	\N	\N	574	7344446165
approved	\N	\N	\N	632	7344446165
approved	\N	\N	\N	617	7344446165
approved	\N	\N	\N	563	7344446165
approved	\N	\N	\N	624	7344446165
approved	\N	\N	\N	602	7344446165
approved	\N	\N	\N	573	7344446165
approved	\N	\N	\N	543	7344446165
approved	\N	\N	\N	553	7344446165
approved	\N	\N	\N	561	7344446165
approved	\N	\N	\N	634	7344446165
approved	\N	\N	\N	628	7344446165
approved	\N	\N	\N	633	8633941564
approved	\N	\N	\N	603	8633941564
approved	\N	\N	\N	558	8633941564
approved	\N	\N	\N	575	8633941564
approved	\N	\N	\N	574	8633941564
approved	\N	\N	\N	632	8633941564
approved	\N	\N	\N	617	8633941564
approved	\N	\N	\N	563	8633941564
approved	\N	\N	\N	624	8633941564
approved	\N	\N	\N	602	8633941564
approved	\N	\N	\N	573	8633941564
approved	\N	\N	\N	543	8633941564
approved	\N	\N	\N	553	8633941564
approved	\N	\N	\N	561	8633941564
approved	\N	\N	\N	634	8633941564
approved	\N	\N	\N	628	8633941564
approved	\N	\N	\N	633	7387590646
approved	\N	\N	\N	603	7387590646
approved	\N	\N	\N	558	7387590646
approved	\N	\N	\N	575	7387590646
approved	\N	\N	\N	574	7387590646
approved	\N	\N	\N	632	7387590646
approved	\N	\N	\N	617	7387590646
approved	\N	\N	\N	563	7387590646
approved	\N	\N	\N	624	7387590646
approved	\N	\N	\N	602	7387590646
approved	\N	\N	\N	573	7387590646
approved	\N	\N	\N	543	7387590646
approved	\N	\N	\N	553	7387590646
approved	\N	\N	\N	561	7387590646
approved	\N	\N	\N	634	7387590646
approved	\N	\N	\N	628	7387590646
approved	\N	\N	\N	633	8801072434
approved	\N	\N	\N	603	8801072434
approved	\N	\N	\N	558	8801072434
approved	\N	\N	\N	575	8801072434
approved	\N	\N	\N	574	8801072434
approved	\N	\N	\N	632	8801072434
approved	\N	\N	\N	617	8801072434
approved	\N	\N	\N	563	8801072434
approved	\N	\N	\N	624	8801072434
approved	\N	\N	\N	602	8801072434
approved	\N	\N	\N	573	8801072434
approved	\N	\N	\N	543	8801072434
approved	\N	\N	\N	553	8801072434
approved	\N	\N	\N	561	8801072434
approved	\N	\N	\N	634	8801072434
approved	\N	\N	\N	628	8801072434
approved	\N	\N	\N	633	3661714372
approved	\N	\N	\N	603	3661714372
approved	\N	\N	\N	558	3661714372
approved	\N	\N	\N	575	3661714372
approved	\N	\N	\N	574	3661714372
approved	\N	\N	\N	632	3661714372
approved	\N	\N	\N	617	3661714372
approved	\N	\N	\N	563	3661714372
approved	\N	\N	\N	624	3661714372
approved	\N	\N	\N	602	3661714372
approved	\N	\N	\N	573	3661714372
approved	\N	\N	\N	543	3661714372
approved	\N	\N	\N	553	3661714372
approved	\N	\N	\N	561	3661714372
approved	\N	\N	\N	634	3661714372
approved	\N	\N	\N	628	3661714372
approved	\N	\N	\N	633	8926993958
approved	\N	\N	\N	603	8926993958
approved	\N	\N	\N	558	8926993958
approved	\N	\N	\N	575	8926993958
approved	\N	\N	\N	574	8926993958
approved	\N	\N	\N	632	8926993958
approved	\N	\N	\N	617	8926993958
approved	\N	\N	\N	563	8926993958
approved	\N	\N	\N	624	8926993958
approved	\N	\N	\N	602	8926993958
approved	\N	\N	\N	573	8926993958
approved	\N	\N	\N	543	8926993958
approved	\N	\N	\N	553	8926993958
approved	\N	\N	\N	561	8926993958
approved	\N	\N	\N	634	8926993958
approved	\N	\N	\N	628	8926993958
approved	\N	\N	\N	633	2268041682
approved	\N	\N	\N	603	2268041682
approved	\N	\N	\N	558	2268041682
approved	\N	\N	\N	575	2268041682
approved	\N	\N	\N	574	2268041682
approved	\N	\N	\N	632	2268041682
approved	\N	\N	\N	617	2268041682
approved	\N	\N	\N	563	2268041682
approved	\N	\N	\N	624	2268041682
approved	\N	\N	\N	602	2268041682
approved	\N	\N	\N	573	2268041682
approved	\N	\N	\N	543	2268041682
approved	\N	\N	\N	553	2268041682
approved	\N	\N	\N	561	2268041682
approved	\N	\N	\N	634	2268041682
approved	\N	\N	\N	628	2268041682
approved	\N	\N	\N	633	8065990477
approved	\N	\N	\N	603	8065990477
approved	\N	\N	\N	558	8065990477
approved	\N	\N	\N	575	8065990477
approved	\N	\N	\N	574	8065990477
approved	\N	\N	\N	632	8065990477
approved	\N	\N	\N	617	8065990477
approved	\N	\N	\N	563	8065990477
approved	\N	\N	\N	624	8065990477
approved	\N	\N	\N	602	8065990477
approved	\N	\N	\N	573	8065990477
approved	\N	\N	\N	543	8065990477
approved	\N	\N	\N	553	8065990477
approved	\N	\N	\N	561	8065990477
approved	\N	\N	\N	634	8065990477
approved	\N	\N	\N	628	8065990477
approved	\N	\N	\N	633	4225647938
approved	\N	\N	\N	603	4225647938
approved	\N	\N	\N	558	4225647938
approved	\N	\N	\N	575	4225647938
approved	\N	\N	\N	574	4225647938
approved	\N	\N	\N	632	4225647938
approved	\N	\N	\N	617	4225647938
approved	\N	\N	\N	563	4225647938
approved	\N	\N	\N	624	4225647938
approved	\N	\N	\N	602	4225647938
approved	\N	\N	\N	573	4225647938
approved	\N	\N	\N	543	4225647938
approved	\N	\N	\N	553	4225647938
approved	\N	\N	\N	561	4225647938
approved	\N	\N	\N	634	4225647938
approved	\N	\N	\N	628	4225647938
approved	\N	\N	\N	633	9787942463
approved	\N	\N	\N	603	9787942463
approved	\N	\N	\N	558	9787942463
approved	\N	\N	\N	575	9787942463
approved	\N	\N	\N	574	9787942463
approved	\N	\N	\N	632	9787942463
approved	\N	\N	\N	617	9787942463
approved	\N	\N	\N	563	9787942463
approved	\N	\N	\N	624	9787942463
approved	\N	\N	\N	602	9787942463
approved	\N	\N	\N	573	9787942463
approved	\N	\N	\N	543	9787942463
approved	\N	\N	\N	553	9787942463
approved	\N	\N	\N	561	9787942463
approved	\N	\N	\N	634	9787942463
approved	\N	\N	\N	628	9787942463
approved	\N	\N	\N	633	9713015670
approved	\N	\N	\N	603	9713015670
approved	\N	\N	\N	558	9713015670
approved	\N	\N	\N	575	9713015670
approved	\N	\N	\N	574	9713015670
approved	\N	\N	\N	632	9713015670
approved	\N	\N	\N	617	9713015670
approved	\N	\N	\N	563	9713015670
approved	\N	\N	\N	624	9713015670
approved	\N	\N	\N	602	9713015670
approved	\N	\N	\N	573	9713015670
approved	\N	\N	\N	543	9713015670
approved	\N	\N	\N	553	9713015670
approved	\N	\N	\N	561	9713015670
approved	\N	\N	\N	634	9713015670
approved	\N	\N	\N	628	9713015670
approved	\N	\N	\N	633	4547734968
approved	\N	\N	\N	603	4547734968
approved	\N	\N	\N	558	4547734968
approved	\N	\N	\N	575	4547734968
approved	\N	\N	\N	574	4547734968
approved	\N	\N	\N	632	4547734968
approved	\N	\N	\N	617	4547734968
approved	\N	\N	\N	563	4547734968
approved	\N	\N	\N	624	4547734968
approved	\N	\N	\N	602	4547734968
approved	\N	\N	\N	573	4547734968
approved	\N	\N	\N	543	4547734968
approved	\N	\N	\N	553	4547734968
approved	\N	\N	\N	561	4547734968
approved	\N	\N	\N	634	4547734968
approved	\N	\N	\N	628	4547734968
approved	\N	\N	\N	633	2219330822
approved	\N	\N	\N	603	2219330822
approved	\N	\N	\N	558	2219330822
approved	\N	\N	\N	575	2219330822
approved	\N	\N	\N	574	2219330822
approved	\N	\N	\N	632	2219330822
approved	\N	\N	\N	617	2219330822
approved	\N	\N	\N	563	2219330822
approved	\N	\N	\N	624	2219330822
approved	\N	\N	\N	602	2219330822
approved	\N	\N	\N	573	2219330822
approved	\N	\N	\N	543	2219330822
approved	\N	\N	\N	553	2219330822
approved	\N	\N	\N	561	2219330822
approved	\N	\N	\N	634	2219330822
approved	\N	\N	\N	628	2219330822
approved	\N	\N	\N	633	2340861465
approved	\N	\N	\N	603	2340861465
approved	\N	\N	\N	558	2340861465
approved	\N	\N	\N	575	2340861465
approved	\N	\N	\N	574	2340861465
approved	\N	\N	\N	632	2340861465
approved	\N	\N	\N	617	2340861465
approved	\N	\N	\N	563	2340861465
approved	\N	\N	\N	624	2340861465
approved	\N	\N	\N	602	2340861465
approved	\N	\N	\N	573	2340861465
approved	\N	\N	\N	543	2340861465
approved	\N	\N	\N	553	2340861465
approved	\N	\N	\N	561	2340861465
approved	\N	\N	\N	634	2340861465
approved	\N	\N	\N	628	2340861465
approved	\N	\N	\N	633	4414389290
approved	\N	\N	\N	603	4414389290
approved	\N	\N	\N	558	4414389290
approved	\N	\N	\N	575	4414389290
approved	\N	\N	\N	574	4414389290
approved	\N	\N	\N	632	4414389290
approved	\N	\N	\N	617	4414389290
approved	\N	\N	\N	563	4414389290
approved	\N	\N	\N	624	4414389290
approved	\N	\N	\N	602	4414389290
approved	\N	\N	\N	573	4414389290
approved	\N	\N	\N	543	4414389290
approved	\N	\N	\N	553	4414389290
approved	\N	\N	\N	561	4414389290
approved	\N	\N	\N	634	4414389290
approved	\N	\N	\N	628	4414389290
approved	\N	\N	\N	633	3943621761
approved	\N	\N	\N	603	3943621761
approved	\N	\N	\N	558	3943621761
approved	\N	\N	\N	575	3943621761
approved	\N	\N	\N	574	3943621761
approved	\N	\N	\N	632	3943621761
approved	\N	\N	\N	617	3943621761
approved	\N	\N	\N	563	3943621761
approved	\N	\N	\N	624	3943621761
approved	\N	\N	\N	602	3943621761
approved	\N	\N	\N	573	3943621761
approved	\N	\N	\N	543	3943621761
approved	\N	\N	\N	553	3943621761
approved	\N	\N	\N	561	3943621761
approved	\N	\N	\N	634	3943621761
approved	\N	\N	\N	628	3943621761
approved	\N	\N	\N	633	6176099606
approved	\N	\N	\N	603	6176099606
approved	\N	\N	\N	558	6176099606
approved	\N	\N	\N	575	6176099606
approved	\N	\N	\N	574	6176099606
approved	\N	\N	\N	632	6176099606
approved	\N	\N	\N	617	6176099606
approved	\N	\N	\N	563	6176099606
approved	\N	\N	\N	624	6176099606
approved	\N	\N	\N	602	6176099606
approved	\N	\N	\N	573	6176099606
approved	\N	\N	\N	543	6176099606
approved	\N	\N	\N	553	6176099606
approved	\N	\N	\N	561	6176099606
approved	\N	\N	\N	634	6176099606
approved	\N	\N	\N	628	6176099606
approved	\N	\N	\N	633	5844381454
approved	\N	\N	\N	603	5844381454
approved	\N	\N	\N	558	5844381454
approved	\N	\N	\N	575	5844381454
approved	\N	\N	\N	574	5844381454
approved	\N	\N	\N	632	5844381454
approved	\N	\N	\N	617	5844381454
approved	\N	\N	\N	563	5844381454
approved	\N	\N	\N	624	5844381454
approved	\N	\N	\N	602	5844381454
approved	\N	\N	\N	573	5844381454
approved	\N	\N	\N	543	5844381454
approved	\N	\N	\N	553	5844381454
approved	\N	\N	\N	561	5844381454
approved	\N	\N	\N	634	5844381454
approved	\N	\N	\N	628	5844381454
approved	\N	\N	\N	633	1791886249
approved	\N	\N	\N	603	1791886249
approved	\N	\N	\N	558	1791886249
approved	\N	\N	\N	575	1791886249
approved	\N	\N	\N	574	1791886249
approved	\N	\N	\N	632	1791886249
approved	\N	\N	\N	617	1791886249
approved	\N	\N	\N	563	1791886249
approved	\N	\N	\N	624	1791886249
approved	\N	\N	\N	602	1791886249
approved	\N	\N	\N	573	1791886249
approved	\N	\N	\N	543	1791886249
approved	\N	\N	\N	553	1791886249
approved	\N	\N	\N	561	1791886249
approved	\N	\N	\N	634	1791886249
approved	\N	\N	\N	628	1791886249
approved	\N	\N	\N	633	8059499343
approved	\N	\N	\N	603	8059499343
approved	\N	\N	\N	558	8059499343
approved	\N	\N	\N	575	8059499343
approved	\N	\N	\N	574	8059499343
approved	\N	\N	\N	632	8059499343
approved	\N	\N	\N	617	8059499343
approved	\N	\N	\N	563	8059499343
approved	\N	\N	\N	624	8059499343
approved	\N	\N	\N	602	8059499343
approved	\N	\N	\N	573	8059499343
approved	\N	\N	\N	543	8059499343
approved	\N	\N	\N	553	8059499343
approved	\N	\N	\N	561	8059499343
approved	\N	\N	\N	634	8059499343
approved	\N	\N	\N	628	8059499343
approved	\N	\N	\N	633	1159745290
approved	\N	\N	\N	603	1159745290
approved	\N	\N	\N	558	1159745290
approved	\N	\N	\N	575	1159745290
approved	\N	\N	\N	574	1159745290
approved	\N	\N	\N	632	1159745290
approved	\N	\N	\N	617	1159745290
approved	\N	\N	\N	563	1159745290
approved	\N	\N	\N	624	1159745290
approved	\N	\N	\N	602	1159745290
approved	\N	\N	\N	573	1159745290
approved	\N	\N	\N	543	1159745290
approved	\N	\N	\N	553	1159745290
approved	\N	\N	\N	561	1159745290
approved	\N	\N	\N	634	1159745290
approved	\N	\N	\N	628	1159745290
approved	\N	\N	\N	633	9317774013
approved	\N	\N	\N	603	9317774013
approved	\N	\N	\N	558	9317774013
approved	\N	\N	\N	575	9317774013
approved	\N	\N	\N	574	9317774013
approved	\N	\N	\N	632	9317774013
approved	\N	\N	\N	617	9317774013
approved	\N	\N	\N	563	9317774013
approved	\N	\N	\N	624	9317774013
approved	\N	\N	\N	602	9317774013
approved	\N	\N	\N	573	9317774013
approved	\N	\N	\N	543	9317774013
approved	\N	\N	\N	553	9317774013
approved	\N	\N	\N	561	9317774013
approved	\N	\N	\N	634	9317774013
approved	\N	\N	\N	628	9317774013
approved	\N	\N	\N	633	7355628244
approved	\N	\N	\N	603	7355628244
approved	\N	\N	\N	558	7355628244
approved	\N	\N	\N	575	7355628244
approved	\N	\N	\N	574	7355628244
approved	\N	\N	\N	632	7355628244
approved	\N	\N	\N	617	7355628244
approved	\N	\N	\N	563	7355628244
approved	\N	\N	\N	624	7355628244
approved	\N	\N	\N	602	7355628244
approved	\N	\N	\N	573	7355628244
approved	\N	\N	\N	543	7355628244
approved	\N	\N	\N	553	7355628244
approved	\N	\N	\N	561	7355628244
approved	\N	\N	\N	634	7355628244
approved	\N	\N	\N	628	7355628244
approved	\N	\N	\N	633	6384029909
approved	\N	\N	\N	603	6384029909
approved	\N	\N	\N	558	6384029909
approved	\N	\N	\N	575	6384029909
approved	\N	\N	\N	574	6384029909
approved	\N	\N	\N	632	6384029909
approved	\N	\N	\N	617	6384029909
approved	\N	\N	\N	563	6384029909
approved	\N	\N	\N	624	6384029909
approved	\N	\N	\N	602	6384029909
approved	\N	\N	\N	573	6384029909
approved	\N	\N	\N	543	6384029909
approved	\N	\N	\N	553	6384029909
approved	\N	\N	\N	561	6384029909
approved	\N	\N	\N	634	6384029909
approved	\N	\N	\N	628	6384029909
approved	\N	\N	\N	633	5448295898
approved	\N	\N	\N	603	5448295898
approved	\N	\N	\N	558	5448295898
approved	\N	\N	\N	575	5448295898
approved	\N	\N	\N	574	5448295898
approved	\N	\N	\N	632	5448295898
approved	\N	\N	\N	617	5448295898
approved	\N	\N	\N	563	5448295898
approved	\N	\N	\N	624	5448295898
approved	\N	\N	\N	602	5448295898
approved	\N	\N	\N	573	5448295898
approved	\N	\N	\N	543	5448295898
approved	\N	\N	\N	553	5448295898
approved	\N	\N	\N	561	5448295898
approved	\N	\N	\N	634	5448295898
approved	\N	\N	\N	628	5448295898
approved	\N	\N	\N	633	8329970500
approved	\N	\N	\N	603	8329970500
approved	\N	\N	\N	558	8329970500
approved	\N	\N	\N	575	8329970500
approved	\N	\N	\N	574	8329970500
approved	\N	\N	\N	632	8329970500
approved	\N	\N	\N	617	8329970500
approved	\N	\N	\N	563	8329970500
approved	\N	\N	\N	624	8329970500
approved	\N	\N	\N	602	8329970500
approved	\N	\N	\N	573	8329970500
approved	\N	\N	\N	543	8329970500
approved	\N	\N	\N	553	8329970500
approved	\N	\N	\N	561	8329970500
approved	\N	\N	\N	634	8329970500
approved	\N	\N	\N	628	8329970500
approved	\N	\N	\N	633	9748940629
approved	\N	\N	\N	603	9748940629
approved	\N	\N	\N	558	9748940629
approved	\N	\N	\N	575	9748940629
approved	\N	\N	\N	574	9748940629
approved	\N	\N	\N	632	9748940629
approved	\N	\N	\N	617	9748940629
approved	\N	\N	\N	563	9748940629
approved	\N	\N	\N	624	9748940629
approved	\N	\N	\N	602	9748940629
approved	\N	\N	\N	573	9748940629
approved	\N	\N	\N	543	9748940629
approved	\N	\N	\N	553	9748940629
approved	\N	\N	\N	561	9748940629
approved	\N	\N	\N	634	9748940629
approved	\N	\N	\N	628	9748940629
approved	\N	\N	\N	633	9841446787
approved	\N	\N	\N	603	9841446787
approved	\N	\N	\N	558	9841446787
approved	\N	\N	\N	575	9841446787
approved	\N	\N	\N	574	9841446787
approved	\N	\N	\N	632	9841446787
approved	\N	\N	\N	617	9841446787
approved	\N	\N	\N	563	9841446787
approved	\N	\N	\N	624	9841446787
approved	\N	\N	\N	602	9841446787
approved	\N	\N	\N	573	9841446787
approved	\N	\N	\N	543	9841446787
approved	\N	\N	\N	553	9841446787
approved	\N	\N	\N	561	9841446787
approved	\N	\N	\N	634	9841446787
approved	\N	\N	\N	628	9841446787
approved	\N	\N	\N	633	5672398895
approved	\N	\N	\N	603	5672398895
approved	\N	\N	\N	558	5672398895
approved	\N	\N	\N	575	5672398895
approved	\N	\N	\N	574	5672398895
approved	\N	\N	\N	632	5672398895
approved	\N	\N	\N	617	5672398895
approved	\N	\N	\N	563	5672398895
approved	\N	\N	\N	624	5672398895
approved	\N	\N	\N	602	5672398895
approved	\N	\N	\N	573	5672398895
approved	\N	\N	\N	543	5672398895
approved	\N	\N	\N	553	5672398895
approved	\N	\N	\N	561	5672398895
approved	\N	\N	\N	634	5672398895
approved	\N	\N	\N	628	5672398895
approved	\N	\N	\N	633	7255502811
approved	\N	\N	\N	603	7255502811
approved	\N	\N	\N	558	7255502811
approved	\N	\N	\N	575	7255502811
approved	\N	\N	\N	574	7255502811
approved	\N	\N	\N	632	7255502811
approved	\N	\N	\N	617	7255502811
approved	\N	\N	\N	563	7255502811
approved	\N	\N	\N	624	7255502811
approved	\N	\N	\N	602	7255502811
approved	\N	\N	\N	573	7255502811
approved	\N	\N	\N	543	7255502811
approved	\N	\N	\N	553	7255502811
approved	\N	\N	\N	561	7255502811
approved	\N	\N	\N	634	7255502811
approved	\N	\N	\N	628	7255502811
approved	\N	\N	\N	633	2845989136
approved	\N	\N	\N	603	2845989136
approved	\N	\N	\N	558	2845989136
approved	\N	\N	\N	575	2845989136
approved	\N	\N	\N	574	2845989136
approved	\N	\N	\N	632	2845989136
approved	\N	\N	\N	617	2845989136
approved	\N	\N	\N	563	2845989136
approved	\N	\N	\N	624	2845989136
approved	\N	\N	\N	602	2845989136
approved	\N	\N	\N	573	2845989136
approved	\N	\N	\N	543	2845989136
approved	\N	\N	\N	553	2845989136
approved	\N	\N	\N	561	2845989136
approved	\N	\N	\N	634	2845989136
approved	\N	\N	\N	628	2845989136
approved	\N	\N	\N	633	3016845062
approved	\N	\N	\N	603	3016845062
approved	\N	\N	\N	558	3016845062
approved	\N	\N	\N	575	3016845062
approved	\N	\N	\N	574	3016845062
approved	\N	\N	\N	632	3016845062
approved	\N	\N	\N	617	3016845062
approved	\N	\N	\N	563	3016845062
approved	\N	\N	\N	624	3016845062
approved	\N	\N	\N	602	3016845062
approved	\N	\N	\N	573	3016845062
approved	\N	\N	\N	543	3016845062
approved	\N	\N	\N	553	3016845062
approved	\N	\N	\N	561	3016845062
approved	\N	\N	\N	634	3016845062
approved	\N	\N	\N	628	3016845062
approved	\N	\N	\N	633	5889444376
approved	\N	\N	\N	603	5889444376
approved	\N	\N	\N	558	5889444376
approved	\N	\N	\N	575	5889444376
approved	\N	\N	\N	574	5889444376
approved	\N	\N	\N	632	5889444376
approved	\N	\N	\N	617	5889444376
approved	\N	\N	\N	563	5889444376
approved	\N	\N	\N	624	5889444376
approved	\N	\N	\N	602	5889444376
approved	\N	\N	\N	573	5889444376
approved	\N	\N	\N	543	5889444376
approved	\N	\N	\N	553	5889444376
approved	\N	\N	\N	561	5889444376
approved	\N	\N	\N	634	5889444376
approved	\N	\N	\N	628	5889444376
approved	\N	\N	\N	633	9233579786
approved	\N	\N	\N	603	9233579786
approved	\N	\N	\N	558	9233579786
approved	\N	\N	\N	575	9233579786
approved	\N	\N	\N	574	9233579786
approved	\N	\N	\N	632	9233579786
approved	\N	\N	\N	617	9233579786
approved	\N	\N	\N	563	9233579786
approved	\N	\N	\N	624	9233579786
approved	\N	\N	\N	602	9233579786
approved	\N	\N	\N	573	9233579786
approved	\N	\N	\N	543	9233579786
approved	\N	\N	\N	553	9233579786
approved	\N	\N	\N	561	9233579786
approved	\N	\N	\N	634	9233579786
approved	\N	\N	\N	628	9233579786
approved	\N	\N	\N	633	1817917498
approved	\N	\N	\N	603	1817917498
approved	\N	\N	\N	558	1817917498
approved	\N	\N	\N	575	1817917498
approved	\N	\N	\N	574	1817917498
approved	\N	\N	\N	632	1817917498
approved	\N	\N	\N	617	1817917498
approved	\N	\N	\N	563	1817917498
approved	\N	\N	\N	624	1817917498
approved	\N	\N	\N	602	1817917498
approved	\N	\N	\N	573	1817917498
approved	\N	\N	\N	543	1817917498
approved	\N	\N	\N	553	1817917498
approved	\N	\N	\N	561	1817917498
approved	\N	\N	\N	634	1817917498
approved	\N	\N	\N	628	1817917498
approved	\N	\N	\N	633	8551158753
approved	\N	\N	\N	603	8551158753
approved	\N	\N	\N	558	8551158753
approved	\N	\N	\N	575	8551158753
approved	\N	\N	\N	574	8551158753
approved	\N	\N	\N	632	8551158753
approved	\N	\N	\N	617	8551158753
approved	\N	\N	\N	563	8551158753
approved	\N	\N	\N	624	8551158753
approved	\N	\N	\N	602	8551158753
approved	\N	\N	\N	573	8551158753
approved	\N	\N	\N	543	8551158753
approved	\N	\N	\N	553	8551158753
approved	\N	\N	\N	561	8551158753
approved	\N	\N	\N	634	8551158753
approved	\N	\N	\N	628	8551158753
approved	\N	\N	\N	633	8160573746
approved	\N	\N	\N	603	8160573746
approved	\N	\N	\N	558	8160573746
approved	\N	\N	\N	575	8160573746
approved	\N	\N	\N	574	8160573746
approved	\N	\N	\N	632	8160573746
approved	\N	\N	\N	617	8160573746
approved	\N	\N	\N	563	8160573746
approved	\N	\N	\N	624	8160573746
approved	\N	\N	\N	602	8160573746
approved	\N	\N	\N	573	8160573746
approved	\N	\N	\N	543	8160573746
approved	\N	\N	\N	553	8160573746
approved	\N	\N	\N	561	8160573746
approved	\N	\N	\N	634	8160573746
approved	\N	\N	\N	628	8160573746
approved	\N	\N	\N	633	3085959185
approved	\N	\N	\N	603	3085959185
approved	\N	\N	\N	558	3085959185
approved	\N	\N	\N	575	3085959185
approved	\N	\N	\N	574	3085959185
approved	\N	\N	\N	632	3085959185
approved	\N	\N	\N	617	3085959185
approved	\N	\N	\N	563	3085959185
approved	\N	\N	\N	624	3085959185
approved	\N	\N	\N	602	3085959185
approved	\N	\N	\N	573	3085959185
approved	\N	\N	\N	543	3085959185
approved	\N	\N	\N	553	3085959185
approved	\N	\N	\N	561	3085959185
approved	\N	\N	\N	634	3085959185
approved	\N	\N	\N	628	3085959185
approved	\N	\N	\N	633	6617149232
approved	\N	\N	\N	603	6617149232
approved	\N	\N	\N	558	6617149232
approved	\N	\N	\N	575	6617149232
approved	\N	\N	\N	574	6617149232
approved	\N	\N	\N	632	6617149232
approved	\N	\N	\N	617	6617149232
approved	\N	\N	\N	563	6617149232
approved	\N	\N	\N	624	6617149232
approved	\N	\N	\N	602	6617149232
approved	\N	\N	\N	573	6617149232
approved	\N	\N	\N	543	6617149232
approved	\N	\N	\N	553	6617149232
approved	\N	\N	\N	561	6617149232
approved	\N	\N	\N	634	6617149232
approved	\N	\N	\N	628	6617149232
approved	\N	\N	\N	633	2386221689
approved	\N	\N	\N	603	2386221689
approved	\N	\N	\N	558	2386221689
approved	\N	\N	\N	575	2386221689
approved	\N	\N	\N	574	2386221689
approved	\N	\N	\N	632	2386221689
approved	\N	\N	\N	617	2386221689
approved	\N	\N	\N	563	2386221689
approved	\N	\N	\N	624	2386221689
approved	\N	\N	\N	602	2386221689
approved	\N	\N	\N	573	2386221689
approved	\N	\N	\N	543	2386221689
approved	\N	\N	\N	553	2386221689
approved	\N	\N	\N	561	2386221689
approved	\N	\N	\N	634	2386221689
approved	\N	\N	\N	628	2386221689
approved	\N	\N	\N	633	2873901649
approved	\N	\N	\N	603	2873901649
approved	\N	\N	\N	558	2873901649
approved	\N	\N	\N	575	2873901649
approved	\N	\N	\N	574	2873901649
approved	\N	\N	\N	632	2873901649
approved	\N	\N	\N	617	2873901649
approved	\N	\N	\N	563	2873901649
approved	\N	\N	\N	624	2873901649
approved	\N	\N	\N	602	2873901649
approved	\N	\N	\N	573	2873901649
approved	\N	\N	\N	543	2873901649
approved	\N	\N	\N	553	2873901649
approved	\N	\N	\N	561	2873901649
approved	\N	\N	\N	634	2873901649
approved	\N	\N	\N	628	2873901649
approved	\N	\N	\N	633	6330164908
approved	\N	\N	\N	603	6330164908
approved	\N	\N	\N	558	6330164908
approved	\N	\N	\N	575	6330164908
approved	\N	\N	\N	574	6330164908
approved	\N	\N	\N	632	6330164908
approved	\N	\N	\N	617	6330164908
approved	\N	\N	\N	563	6330164908
approved	\N	\N	\N	624	6330164908
approved	\N	\N	\N	602	6330164908
approved	\N	\N	\N	573	6330164908
approved	\N	\N	\N	543	6330164908
approved	\N	\N	\N	553	6330164908
approved	\N	\N	\N	561	6330164908
approved	\N	\N	\N	634	6330164908
approved	\N	\N	\N	628	6330164908
approved	\N	\N	\N	633	5933956657
approved	\N	\N	\N	603	5933956657
approved	\N	\N	\N	558	5933956657
approved	\N	\N	\N	575	5933956657
approved	\N	\N	\N	574	5933956657
approved	\N	\N	\N	632	5933956657
approved	\N	\N	\N	617	5933956657
approved	\N	\N	\N	563	5933956657
approved	\N	\N	\N	624	5933956657
approved	\N	\N	\N	602	5933956657
approved	\N	\N	\N	573	5933956657
approved	\N	\N	\N	543	5933956657
approved	\N	\N	\N	553	5933956657
approved	\N	\N	\N	561	5933956657
approved	\N	\N	\N	634	5933956657
approved	\N	\N	\N	628	5933956657
approved	\N	\N	\N	633	4093232471
approved	\N	\N	\N	603	4093232471
approved	\N	\N	\N	558	4093232471
approved	\N	\N	\N	575	4093232471
approved	\N	\N	\N	574	4093232471
approved	\N	\N	\N	632	4093232471
approved	\N	\N	\N	617	4093232471
approved	\N	\N	\N	563	4093232471
approved	\N	\N	\N	624	4093232471
approved	\N	\N	\N	602	4093232471
approved	\N	\N	\N	573	4093232471
approved	\N	\N	\N	543	4093232471
approved	\N	\N	\N	553	4093232471
approved	\N	\N	\N	561	4093232471
approved	\N	\N	\N	634	4093232471
approved	\N	\N	\N	628	4093232471
approved	\N	\N	\N	633	7671026373
approved	\N	\N	\N	603	7671026373
approved	\N	\N	\N	558	7671026373
approved	\N	\N	\N	575	7671026373
approved	\N	\N	\N	574	7671026373
approved	\N	\N	\N	632	7671026373
approved	\N	\N	\N	617	7671026373
approved	\N	\N	\N	563	7671026373
approved	\N	\N	\N	624	7671026373
approved	\N	\N	\N	602	7671026373
approved	\N	\N	\N	573	7671026373
approved	\N	\N	\N	543	7671026373
approved	\N	\N	\N	553	7671026373
approved	\N	\N	\N	561	7671026373
approved	\N	\N	\N	634	7671026373
approved	\N	\N	\N	628	7671026373
approved	\N	\N	\N	633	9348345948
approved	\N	\N	\N	603	9348345948
approved	\N	\N	\N	558	9348345948
approved	\N	\N	\N	575	9348345948
approved	\N	\N	\N	574	9348345948
approved	\N	\N	\N	632	9348345948
approved	\N	\N	\N	617	9348345948
approved	\N	\N	\N	563	9348345948
approved	\N	\N	\N	624	9348345948
approved	\N	\N	\N	602	9348345948
approved	\N	\N	\N	573	9348345948
approved	\N	\N	\N	543	9348345948
approved	\N	\N	\N	553	9348345948
approved	\N	\N	\N	561	9348345948
approved	\N	\N	\N	634	9348345948
approved	\N	\N	\N	628	9348345948
approved	\N	\N	\N	633	7036854232
approved	\N	\N	\N	603	7036854232
approved	\N	\N	\N	558	7036854232
approved	\N	\N	\N	575	7036854232
approved	\N	\N	\N	574	7036854232
approved	\N	\N	\N	632	7036854232
approved	\N	\N	\N	617	7036854232
approved	\N	\N	\N	563	7036854232
approved	\N	\N	\N	624	7036854232
approved	\N	\N	\N	602	7036854232
approved	\N	\N	\N	573	7036854232
approved	\N	\N	\N	543	7036854232
approved	\N	\N	\N	553	7036854232
approved	\N	\N	\N	561	7036854232
approved	\N	\N	\N	634	7036854232
approved	\N	\N	\N	628	7036854232
pass	8	\N	8	541	8163254157
pass	5	7	5	540	8163254157
pass	9	6	6	542	8163254157
pass	5	1	5	532	8163254157
pass	8	\N	8	536	8163254157
pass	8	2	8	537	8163254157
pass	7	\N	7	538	8163254157
pass	5	\N	5	539	8163254157
pass	8	5	5	531	8163254157
pass	8	10	9	535	8163254157
pass	8	3	8	661	9825289323
pass	5	8	5	661	5933956657
pass	6	4	6	661	9348345948
pass	5	6	5	661	9233579786
pass	6	9	6	661	2845989136
pass	6	7	6	661	5672398895
pass	6	2	6	661	9748940629
pass	7	9	7	661	8329970500
pass	10	5	10	661	7355628244
pass	9	3	9	661	9317774013
pass	7	3	7	661	1159745290
pass	9	6	9	661	5844381454
pass	5	3	5	661	4414389290
pass	10	1	10	661	2340861465
pass	10	2	10	661	4547734968
pass	8	1	8	661	4225647938
pass	9	2	9	661	8065990477
pass	5	4	5	661	8926993958
pass	9	6	9	661	7387590646
pass	7	8	7	661	7344446165
pass	5	8	5	661	3004542348
pass	6	2	6	661	7506562181
pass	8	2	8	661	5393150884
pass	9	5	9	661	1974342255
pass	10	9	10	661	6130521884
pass	9	4	9	661	9296128900
pass	9	7	9	661	8525887759
pass	8	7	8	661	5315363834
pass	10	6	10	661	7848264486
pass	7	4	7	661	2429992163
pass	8	6	8	661	2627845789
pass	5	2	5	661	8519900776
pass	9	7	9	661	5298653978
pass	8	5	8	661	3466969247
pass	8	5	8	661	2127379383
pass	7	7	7	661	7611391463
pass	6	3	6	661	9262628998
pass	5	7	5	661	8140626094
pass	6	3	6	661	7604634123
pass	9	3	9	661	7412729163
pass	5	2	5	661	1677623273
pass	10	2	10	661	8048161591
pass	5	9	5	661	6123973547
pass	8	5	8	661	3207392350
pass	6	1	6	661	1292902580
pass	6	3	6	661	9980820595
pass	8	6	8	661	3911487577
pass	8	2	8	661	7242749087
pass	8	9	8	661	5589427861
pass	6	9	6	661	1077861304
pass	8	2	8	661	5243886166
pass	8	4	8	661	2386221689
pass	6	2	6	661	6617149232
pass	7	8	7	661	8160573746
pass	5	9	5	661	8551158753
pass	5	1	5	664	9713015670
pass	10	1	10	664	8525887759
pass	8	1	8	664	5315363834
pass	9	1	9	664	5383048297
pass	10	1	10	664	7604634123
pass	7	1	7	664	7412729163
pass	9	\N	9	665	6023433046
pass	9	\N	9	665	3911487577
pass	6	\N	6	665	9980820595
pass	7	\N	7	665	9544567295
pass	9	\N	9	665	1292902580
pass	5	\N	5	665	3207392350
pass	7	\N	7	665	2563337837
pass	6	\N	6	665	6123973547
pass	8	\N	8	665	3885371670
pass	6	\N	6	665	1908920784
pass	7	\N	7	665	7604634123
pass	7	\N	7	665	2678213354
pass	6	\N	6	665	8140626094
pass	5	\N	5	665	4141651461
pass	8	\N	8	665	7611391463
pass	7	\N	7	665	2456626264
pass	6	\N	6	665	2539403312
pass	7	\N	7	665	5298653978
pass	6	\N	6	665	2647025193
pass	9	\N	9	665	2431388358
pass	8	\N	8	665	2429992163
pass	5	\N	5	665	7848264486
pass	9	\N	9	665	2883399736
pass	5	\N	5	665	8525887759
pass	6	\N	6	665	9296128900
pass	5	\N	5	665	6130521884
pass	6	\N	6	665	1974342255
pass	5	\N	5	665	5393150884
pass	9	\N	9	665	7342428390
pass	5	\N	5	665	7506562181
pass	6	\N	6	665	3004542348
pass	7	\N	7	665	7344446165
pass	7	\N	7	665	8633941564
pass	7	\N	7	665	7387590646
pass	5	\N	5	665	8801072434
pass	9	\N	9	665	8926993958
pass	7	\N	7	665	8065990477
pass	5	\N	5	665	4225647938
pass	6	\N	6	665	9713015670
pass	6	\N	6	665	2219330822
pass	8	\N	8	665	2340861465
pass	9	\N	9	665	3943621761
pass	5	\N	5	665	6176099606
pass	6	\N	6	665	5844381454
pass	10	\N	10	665	1791886249
pass	10	\N	10	665	9317774013
pass	10	\N	10	665	6384029909
pass	10	\N	10	665	5448295898
pass	7	\N	7	665	8329970500
pass	7	\N	7	665	9748940629
pass	9	\N	9	665	9841446787
pass	7	\N	7	665	7255502811
pass	10	\N	10	665	2845989136
pass	6	\N	6	665	5889444376
pass	7	\N	7	665	9233579786
pass	5	\N	5	665	1817917498
pass	5	\N	5	665	8551158753
pass	5	\N	5	665	8160573746
pass	9	\N	9	665	3085959185
pass	6	\N	6	665	2873901649
pass	8	\N	8	665	6330164908
pass	9	\N	9	665	5933956657
pass	7	\N	7	665	4093232471
pass	9	\N	9	665	7036854232
pass	8	\N	8	665	9348345948
pass	8	2	8	666	2386221689
pass	9	1	9	666	3943621761
pass	5	1	5	666	9713015670
pass	5	1	5	666	5393150884
pass	5	2	5	666	8525887759
pass	6	1	6	666	9866654321
pass	6	2	6	666	6368086134
pass	9	1	9	666	7604634123
pass	6	\N	6	676	5889444376
pass	8	\N	8	676	9233579786
pass	6	\N	6	676	1817917498
pass	5	\N	5	676	8551158753
pass	5	\N	5	676	8160573746
pass	9	\N	9	676	6617149232
pass	7	\N	7	676	2386221689
pass	8	\N	8	676	2873901649
pass	5	\N	5	676	7671026373
pass	8	\N	8	676	7036854232
pass	8	\N	8	676	6052931528
pass	5	\N	5	676	6023433046
pass	7	\N	7	676	9980820595
pass	9	\N	9	676	9544567295
pass	9	\N	9	676	1292902580
pass	8	\N	8	676	3207392350
pass	8	\N	8	676	2563337837
pass	8	\N	8	676	6123973547
pass	6	\N	6	676	8048161591
pass	8	\N	8	676	1677623273
pass	9	\N	9	676	7604634123
pass	8	\N	8	676	9262628998
pass	9	\N	9	676	6368086134
pass	10	\N	10	676	7611391463
pass	7	\N	7	676	2127379383
pass	7	\N	7	676	2456626264
rejected	\N	\N	\N	714	9825289323
rejected	\N	\N	\N	675	9825289323
rejected	\N	\N	\N	696	9825289323
rejected	\N	\N	\N	715	9825289323
rejected	\N	\N	\N	684	9825289323
rejected	\N	\N	\N	670	9825289323
rejected	\N	\N	\N	704	9825289323
rejected	\N	\N	\N	712	9825289323
rejected	\N	\N	\N	683	9825289323
rejected	\N	\N	\N	709	9825289323
rejected	\N	\N	\N	680	9825289323
rejected	\N	\N	\N	682	9825289323
rejected	\N	\N	\N	689	9825289323
rejected	\N	\N	\N	718	9825289323
rejected	\N	\N	\N	708	9825289323
rejected	\N	\N	\N	685	9825289323
rejected	\N	\N	\N	690	9825289323
rejected	\N	\N	\N	673	9825289323
rejected	\N	\N	\N	688	9825289323
rejected	\N	\N	\N	697	9825289323
rejected	\N	\N	\N	663	9825289323
rejected	\N	\N	\N	662	9825289323
rejected	\N	\N	\N	692	9825289323
rejected	\N	\N	\N	665	9825289323
rejected	\N	\N	\N	674	9825289323
rejected	\N	\N	\N	706	9825289323
rejected	\N	\N	\N	693	9825289323
rejected	\N	\N	\N	694	9825289323
rejected	\N	\N	\N	678	9825289323
rejected	\N	\N	\N	672	9825289323
rejected	\N	\N	\N	698	9825289323
rejected	\N	\N	\N	711	9825289323
rejected	\N	\N	\N	695	9825289323
rejected	\N	\N	\N	679	9825289323
rejected	\N	\N	\N	699	9825289323
rejected	\N	\N	\N	703	9825289323
rejected	\N	\N	\N	667	9825289323
rejected	\N	\N	\N	687	9825289323
rejected	\N	\N	\N	676	9825289323
rejected	\N	\N	\N	700	9825289323
rejected	\N	\N	\N	717	9825289323
rejected	\N	\N	\N	671	9825289323
rejected	\N	\N	\N	710	9825289323
rejected	\N	\N	\N	691	9825289323
rejected	\N	\N	\N	716	9825289323
rejected	\N	\N	\N	668	9825289323
rejected	\N	\N	\N	713	9825289323
rejected	\N	\N	\N	702	9825289323
rejected	\N	\N	\N	719	9825289323
rejected	\N	\N	\N	714	5243886166
rejected	\N	\N	\N	675	5243886166
rejected	\N	\N	\N	696	5243886166
rejected	\N	\N	\N	715	5243886166
rejected	\N	\N	\N	684	5243886166
rejected	\N	\N	\N	670	5243886166
rejected	\N	\N	\N	704	5243886166
rejected	\N	\N	\N	712	5243886166
rejected	\N	\N	\N	683	5243886166
rejected	\N	\N	\N	709	5243886166
rejected	\N	\N	\N	680	5243886166
rejected	\N	\N	\N	682	5243886166
rejected	\N	\N	\N	689	5243886166
rejected	\N	\N	\N	718	5243886166
rejected	\N	\N	\N	708	5243886166
rejected	\N	\N	\N	685	5243886166
rejected	\N	\N	\N	690	5243886166
rejected	\N	\N	\N	673	5243886166
rejected	\N	\N	\N	688	5243886166
rejected	\N	\N	\N	697	5243886166
rejected	\N	\N	\N	663	5243886166
rejected	\N	\N	\N	662	5243886166
rejected	\N	\N	\N	692	5243886166
rejected	\N	\N	\N	665	5243886166
rejected	\N	\N	\N	674	5243886166
rejected	\N	\N	\N	706	5243886166
rejected	\N	\N	\N	693	5243886166
rejected	\N	\N	\N	694	5243886166
rejected	\N	\N	\N	678	5243886166
rejected	\N	\N	\N	672	5243886166
rejected	\N	\N	\N	698	5243886166
rejected	\N	\N	\N	711	5243886166
rejected	\N	\N	\N	695	5243886166
rejected	\N	\N	\N	679	5243886166
rejected	\N	\N	\N	699	5243886166
rejected	\N	\N	\N	703	5243886166
rejected	\N	\N	\N	667	5243886166
rejected	\N	\N	\N	687	5243886166
rejected	\N	\N	\N	676	5243886166
rejected	\N	\N	\N	700	5243886166
rejected	\N	\N	\N	717	5243886166
rejected	\N	\N	\N	671	5243886166
rejected	\N	\N	\N	710	5243886166
rejected	\N	\N	\N	691	5243886166
rejected	\N	\N	\N	716	5243886166
rejected	\N	\N	\N	668	5243886166
rejected	\N	\N	\N	713	5243886166
rejected	\N	\N	\N	702	5243886166
rejected	\N	\N	\N	719	5243886166
rejected	\N	\N	\N	714	3391566195
rejected	\N	\N	\N	675	3391566195
rejected	\N	\N	\N	696	3391566195
rejected	\N	\N	\N	715	3391566195
rejected	\N	\N	\N	684	3391566195
rejected	\N	\N	\N	670	3391566195
rejected	\N	\N	\N	704	3391566195
rejected	\N	\N	\N	712	3391566195
rejected	\N	\N	\N	683	3391566195
rejected	\N	\N	\N	709	3391566195
rejected	\N	\N	\N	680	3391566195
rejected	\N	\N	\N	682	3391566195
rejected	\N	\N	\N	689	3391566195
rejected	\N	\N	\N	718	3391566195
rejected	\N	\N	\N	708	3391566195
rejected	\N	\N	\N	685	3391566195
rejected	\N	\N	\N	690	3391566195
rejected	\N	\N	\N	673	3391566195
rejected	\N	\N	\N	688	3391566195
rejected	\N	\N	\N	697	3391566195
rejected	\N	\N	\N	663	3391566195
rejected	\N	\N	\N	662	3391566195
rejected	\N	\N	\N	692	3391566195
rejected	\N	\N	\N	665	3391566195
rejected	\N	\N	\N	674	3391566195
rejected	\N	\N	\N	706	3391566195
rejected	\N	\N	\N	693	3391566195
rejected	\N	\N	\N	694	3391566195
rejected	\N	\N	\N	678	3391566195
rejected	\N	\N	\N	672	3391566195
rejected	\N	\N	\N	698	3391566195
rejected	\N	\N	\N	711	3391566195
rejected	\N	\N	\N	695	3391566195
rejected	\N	\N	\N	679	3391566195
rejected	\N	\N	\N	699	3391566195
rejected	\N	\N	\N	703	3391566195
rejected	\N	\N	\N	667	3391566195
rejected	\N	\N	\N	687	3391566195
rejected	\N	\N	\N	676	3391566195
rejected	\N	\N	\N	700	3391566195
rejected	\N	\N	\N	717	3391566195
rejected	\N	\N	\N	671	3391566195
rejected	\N	\N	\N	710	3391566195
rejected	\N	\N	\N	691	3391566195
rejected	\N	\N	\N	716	3391566195
rejected	\N	\N	\N	668	3391566195
rejected	\N	\N	\N	713	3391566195
rejected	\N	\N	\N	702	3391566195
rejected	\N	\N	\N	719	3391566195
rejected	\N	\N	\N	714	8163254157
rejected	\N	\N	\N	675	8163254157
rejected	\N	\N	\N	696	8163254157
rejected	\N	\N	\N	715	8163254157
rejected	\N	\N	\N	684	8163254157
rejected	\N	\N	\N	670	8163254157
rejected	\N	\N	\N	704	8163254157
rejected	\N	\N	\N	712	8163254157
rejected	\N	\N	\N	683	8163254157
rejected	\N	\N	\N	680	8163254157
rejected	\N	\N	\N	682	8163254157
rejected	\N	\N	\N	689	8163254157
rejected	\N	\N	\N	718	8163254157
rejected	\N	\N	\N	708	8163254157
rejected	\N	\N	\N	690	8163254157
rejected	\N	\N	\N	673	8163254157
rejected	\N	\N	\N	688	8163254157
rejected	\N	\N	\N	697	8163254157
rejected	\N	\N	\N	663	8163254157
rejected	\N	\N	\N	662	8163254157
rejected	\N	\N	\N	692	8163254157
rejected	\N	\N	\N	674	8163254157
rejected	\N	\N	\N	713	8163254157
rejected	\N	\N	\N	702	8163254157
rejected	\N	\N	\N	719	8163254157
rejected	\N	\N	\N	706	8163254157
rejected	\N	\N	\N	693	8163254157
rejected	\N	\N	\N	694	8163254157
rejected	\N	\N	\N	678	8163254157
rejected	\N	\N	\N	672	8163254157
rejected	\N	\N	\N	698	8163254157
rejected	\N	\N	\N	711	8163254157
rejected	\N	\N	\N	695	8163254157
rejected	\N	\N	\N	679	8163254157
rejected	\N	\N	\N	699	8163254157
rejected	\N	\N	\N	703	8163254157
rejected	\N	\N	\N	687	8163254157
rejected	\N	\N	\N	676	8163254157
rejected	\N	\N	\N	700	8163254157
rejected	\N	\N	\N	717	8163254157
rejected	\N	\N	\N	671	8163254157
rejected	\N	\N	\N	710	8163254157
rejected	\N	\N	\N	691	8163254157
rejected	\N	\N	\N	716	8163254157
rejected	\N	\N	\N	668	8163254157
rejected	\N	\N	\N	714	1077861304
rejected	\N	\N	\N	675	1077861304
rejected	\N	\N	\N	696	1077861304
rejected	\N	\N	\N	715	1077861304
rejected	\N	\N	\N	684	1077861304
rejected	\N	\N	\N	670	1077861304
rejected	\N	\N	\N	704	1077861304
rejected	\N	\N	\N	712	1077861304
rejected	\N	\N	\N	683	1077861304
rejected	\N	\N	\N	709	1077861304
rejected	\N	\N	\N	680	1077861304
rejected	\N	\N	\N	682	1077861304
rejected	\N	\N	\N	689	1077861304
rejected	\N	\N	\N	718	1077861304
rejected	\N	\N	\N	708	1077861304
rejected	\N	\N	\N	685	1077861304
rejected	\N	\N	\N	690	1077861304
rejected	\N	\N	\N	673	1077861304
rejected	\N	\N	\N	688	1077861304
rejected	\N	\N	\N	697	1077861304
rejected	\N	\N	\N	663	1077861304
rejected	\N	\N	\N	662	1077861304
rejected	\N	\N	\N	692	1077861304
rejected	\N	\N	\N	665	1077861304
rejected	\N	\N	\N	674	1077861304
rejected	\N	\N	\N	706	1077861304
rejected	\N	\N	\N	693	1077861304
rejected	\N	\N	\N	694	1077861304
rejected	\N	\N	\N	678	1077861304
rejected	\N	\N	\N	672	1077861304
rejected	\N	\N	\N	698	1077861304
rejected	\N	\N	\N	711	1077861304
rejected	\N	\N	\N	695	1077861304
rejected	\N	\N	\N	679	1077861304
rejected	\N	\N	\N	699	1077861304
rejected	\N	\N	\N	703	1077861304
rejected	\N	\N	\N	667	1077861304
rejected	\N	\N	\N	687	1077861304
rejected	\N	\N	\N	676	1077861304
rejected	\N	\N	\N	700	1077861304
rejected	\N	\N	\N	717	1077861304
rejected	\N	\N	\N	671	1077861304
rejected	\N	\N	\N	710	1077861304
rejected	\N	\N	\N	691	1077861304
rejected	\N	\N	\N	716	1077861304
rejected	\N	\N	\N	668	1077861304
rejected	\N	\N	\N	713	1077861304
rejected	\N	\N	\N	702	1077861304
rejected	\N	\N	\N	719	1077861304
rejected	\N	\N	\N	714	1006258297
rejected	\N	\N	\N	675	1006258297
rejected	\N	\N	\N	696	1006258297
rejected	\N	\N	\N	715	1006258297
rejected	\N	\N	\N	684	1006258297
rejected	\N	\N	\N	670	1006258297
rejected	\N	\N	\N	704	1006258297
rejected	\N	\N	\N	712	1006258297
rejected	\N	\N	\N	683	1006258297
rejected	\N	\N	\N	709	1006258297
rejected	\N	\N	\N	680	1006258297
rejected	\N	\N	\N	682	1006258297
rejected	\N	\N	\N	689	1006258297
rejected	\N	\N	\N	718	1006258297
rejected	\N	\N	\N	708	1006258297
rejected	\N	\N	\N	685	1006258297
rejected	\N	\N	\N	690	1006258297
rejected	\N	\N	\N	673	1006258297
rejected	\N	\N	\N	688	1006258297
rejected	\N	\N	\N	697	1006258297
rejected	\N	\N	\N	663	1006258297
rejected	\N	\N	\N	662	1006258297
rejected	\N	\N	\N	692	1006258297
rejected	\N	\N	\N	665	1006258297
rejected	\N	\N	\N	674	1006258297
rejected	\N	\N	\N	706	1006258297
rejected	\N	\N	\N	693	1006258297
rejected	\N	\N	\N	694	1006258297
rejected	\N	\N	\N	678	1006258297
rejected	\N	\N	\N	672	1006258297
rejected	\N	\N	\N	698	1006258297
rejected	\N	\N	\N	711	1006258297
rejected	\N	\N	\N	695	1006258297
rejected	\N	\N	\N	679	1006258297
rejected	\N	\N	\N	699	1006258297
rejected	\N	\N	\N	703	1006258297
rejected	\N	\N	\N	667	1006258297
rejected	\N	\N	\N	687	1006258297
rejected	\N	\N	\N	676	1006258297
rejected	\N	\N	\N	700	1006258297
rejected	\N	\N	\N	717	1006258297
rejected	\N	\N	\N	671	1006258297
rejected	\N	\N	\N	710	1006258297
rejected	\N	\N	\N	691	1006258297
rejected	\N	\N	\N	716	1006258297
rejected	\N	\N	\N	668	1006258297
rejected	\N	\N	\N	713	1006258297
rejected	\N	\N	\N	702	1006258297
rejected	\N	\N	\N	719	1006258297
rejected	\N	\N	\N	714	5589427861
rejected	\N	\N	\N	675	5589427861
rejected	\N	\N	\N	696	5589427861
rejected	\N	\N	\N	715	5589427861
rejected	\N	\N	\N	684	5589427861
rejected	\N	\N	\N	670	5589427861
rejected	\N	\N	\N	704	5589427861
rejected	\N	\N	\N	712	5589427861
rejected	\N	\N	\N	683	5589427861
rejected	\N	\N	\N	709	5589427861
rejected	\N	\N	\N	680	5589427861
rejected	\N	\N	\N	682	5589427861
rejected	\N	\N	\N	689	5589427861
rejected	\N	\N	\N	718	5589427861
rejected	\N	\N	\N	708	5589427861
rejected	\N	\N	\N	685	5589427861
rejected	\N	\N	\N	690	5589427861
rejected	\N	\N	\N	673	5589427861
rejected	\N	\N	\N	688	5589427861
rejected	\N	\N	\N	697	5589427861
rejected	\N	\N	\N	663	5589427861
rejected	\N	\N	\N	662	5589427861
rejected	\N	\N	\N	692	5589427861
rejected	\N	\N	\N	665	5589427861
rejected	\N	\N	\N	674	5589427861
rejected	\N	\N	\N	706	5589427861
rejected	\N	\N	\N	693	5589427861
rejected	\N	\N	\N	694	5589427861
rejected	\N	\N	\N	678	5589427861
rejected	\N	\N	\N	672	5589427861
rejected	\N	\N	\N	698	5589427861
rejected	\N	\N	\N	711	5589427861
rejected	\N	\N	\N	695	5589427861
rejected	\N	\N	\N	679	5589427861
rejected	\N	\N	\N	699	5589427861
rejected	\N	\N	\N	703	5589427861
rejected	\N	\N	\N	667	5589427861
rejected	\N	\N	\N	687	5589427861
rejected	\N	\N	\N	676	5589427861
rejected	\N	\N	\N	700	5589427861
rejected	\N	\N	\N	717	5589427861
rejected	\N	\N	\N	671	5589427861
rejected	\N	\N	\N	710	5589427861
rejected	\N	\N	\N	691	5589427861
rejected	\N	\N	\N	716	5589427861
rejected	\N	\N	\N	668	5589427861
rejected	\N	\N	\N	713	5589427861
rejected	\N	\N	\N	702	5589427861
rejected	\N	\N	\N	719	5589427861
rejected	\N	\N	\N	714	5081927005
rejected	\N	\N	\N	675	5081927005
rejected	\N	\N	\N	696	5081927005
rejected	\N	\N	\N	715	5081927005
rejected	\N	\N	\N	684	5081927005
rejected	\N	\N	\N	670	5081927005
rejected	\N	\N	\N	704	5081927005
rejected	\N	\N	\N	712	5081927005
rejected	\N	\N	\N	683	5081927005
rejected	\N	\N	\N	709	5081927005
rejected	\N	\N	\N	680	5081927005
rejected	\N	\N	\N	682	5081927005
rejected	\N	\N	\N	689	5081927005
rejected	\N	\N	\N	718	5081927005
rejected	\N	\N	\N	708	5081927005
rejected	\N	\N	\N	685	5081927005
rejected	\N	\N	\N	690	5081927005
rejected	\N	\N	\N	673	5081927005
rejected	\N	\N	\N	688	5081927005
rejected	\N	\N	\N	697	5081927005
rejected	\N	\N	\N	663	5081927005
rejected	\N	\N	\N	662	5081927005
rejected	\N	\N	\N	692	5081927005
rejected	\N	\N	\N	665	5081927005
rejected	\N	\N	\N	674	5081927005
rejected	\N	\N	\N	706	5081927005
rejected	\N	\N	\N	693	5081927005
rejected	\N	\N	\N	694	5081927005
rejected	\N	\N	\N	678	5081927005
rejected	\N	\N	\N	672	5081927005
rejected	\N	\N	\N	698	5081927005
rejected	\N	\N	\N	711	5081927005
rejected	\N	\N	\N	695	5081927005
rejected	\N	\N	\N	679	5081927005
rejected	\N	\N	\N	699	5081927005
rejected	\N	\N	\N	703	5081927005
rejected	\N	\N	\N	667	5081927005
rejected	\N	\N	\N	687	5081927005
rejected	\N	\N	\N	676	5081927005
rejected	\N	\N	\N	700	5081927005
rejected	\N	\N	\N	717	5081927005
rejected	\N	\N	\N	671	5081927005
rejected	\N	\N	\N	710	5081927005
rejected	\N	\N	\N	691	5081927005
rejected	\N	\N	\N	716	5081927005
rejected	\N	\N	\N	668	5081927005
rejected	\N	\N	\N	713	5081927005
rejected	\N	\N	\N	702	5081927005
rejected	\N	\N	\N	719	5081927005
rejected	\N	\N	\N	695	6052931528
rejected	\N	\N	\N	684	6052931528
rejected	\N	\N	\N	696	6052931528
rejected	\N	\N	\N	719	6052931528
rejected	\N	\N	\N	693	6052931528
rejected	\N	\N	\N	694	6052931528
rejected	\N	\N	\N	700	6052931528
rejected	\N	\N	\N	678	6052931528
rejected	\N	\N	\N	698	6052931528
rejected	\N	\N	\N	683	6052931528
rejected	\N	\N	\N	691	6052931528
rejected	\N	\N	\N	697	6052931528
rejected	\N	\N	\N	663	6052931528
rejected	\N	\N	\N	662	6052931528
rejected	\N	\N	\N	695	7242749087
rejected	\N	\N	\N	684	7242749087
rejected	\N	\N	\N	696	7242749087
rejected	\N	\N	\N	719	7242749087
rejected	\N	\N	\N	693	7242749087
rejected	\N	\N	\N	694	7242749087
rejected	\N	\N	\N	700	7242749087
rejected	\N	\N	\N	678	7242749087
rejected	\N	\N	\N	698	7242749087
rejected	\N	\N	\N	683	7242749087
rejected	\N	\N	\N	691	7242749087
rejected	\N	\N	\N	697	7242749087
rejected	\N	\N	\N	663	7242749087
rejected	\N	\N	\N	662	7242749087
rejected	\N	\N	\N	695	6023433046
rejected	\N	\N	\N	684	6023433046
rejected	\N	\N	\N	696	6023433046
rejected	\N	\N	\N	719	6023433046
rejected	\N	\N	\N	693	6023433046
rejected	\N	\N	\N	694	6023433046
rejected	\N	\N	\N	700	6023433046
rejected	\N	\N	\N	678	6023433046
rejected	\N	\N	\N	698	6023433046
rejected	\N	\N	\N	683	6023433046
rejected	\N	\N	\N	691	6023433046
rejected	\N	\N	\N	697	6023433046
rejected	\N	\N	\N	663	6023433046
rejected	\N	\N	\N	662	6023433046
rejected	\N	\N	\N	695	3911487577
rejected	\N	\N	\N	684	3911487577
rejected	\N	\N	\N	696	3911487577
rejected	\N	\N	\N	719	3911487577
rejected	\N	\N	\N	693	3911487577
rejected	\N	\N	\N	694	3911487577
rejected	\N	\N	\N	700	3911487577
rejected	\N	\N	\N	678	3911487577
rejected	\N	\N	\N	698	3911487577
rejected	\N	\N	\N	683	3911487577
rejected	\N	\N	\N	691	3911487577
rejected	\N	\N	\N	697	3911487577
rejected	\N	\N	\N	663	3911487577
rejected	\N	\N	\N	662	3911487577
rejected	\N	\N	\N	695	9980820595
rejected	\N	\N	\N	684	9980820595
rejected	\N	\N	\N	696	9980820595
rejected	\N	\N	\N	719	9980820595
rejected	\N	\N	\N	693	9980820595
rejected	\N	\N	\N	694	9980820595
rejected	\N	\N	\N	700	9980820595
rejected	\N	\N	\N	678	9980820595
rejected	\N	\N	\N	698	9980820595
rejected	\N	\N	\N	683	9980820595
rejected	\N	\N	\N	691	9980820595
rejected	\N	\N	\N	697	9980820595
rejected	\N	\N	\N	663	9980820595
rejected	\N	\N	\N	662	9980820595
rejected	\N	\N	\N	695	9544567295
rejected	\N	\N	\N	684	9544567295
rejected	\N	\N	\N	696	9544567295
rejected	\N	\N	\N	719	9544567295
rejected	\N	\N	\N	693	9544567295
rejected	\N	\N	\N	694	9544567295
rejected	\N	\N	\N	700	9544567295
rejected	\N	\N	\N	678	9544567295
rejected	\N	\N	\N	698	9544567295
rejected	\N	\N	\N	683	9544567295
rejected	\N	\N	\N	691	9544567295
rejected	\N	\N	\N	697	9544567295
rejected	\N	\N	\N	663	9544567295
rejected	\N	\N	\N	662	9544567295
rejected	\N	\N	\N	695	1292902580
rejected	\N	\N	\N	684	1292902580
rejected	\N	\N	\N	696	1292902580
rejected	\N	\N	\N	719	1292902580
rejected	\N	\N	\N	693	1292902580
rejected	\N	\N	\N	694	1292902580
rejected	\N	\N	\N	700	1292902580
rejected	\N	\N	\N	678	1292902580
rejected	\N	\N	\N	698	1292902580
rejected	\N	\N	\N	683	1292902580
rejected	\N	\N	\N	691	1292902580
rejected	\N	\N	\N	697	1292902580
rejected	\N	\N	\N	663	1292902580
rejected	\N	\N	\N	662	1292902580
rejected	\N	\N	\N	695	3207392350
rejected	\N	\N	\N	684	3207392350
rejected	\N	\N	\N	696	3207392350
rejected	\N	\N	\N	719	3207392350
rejected	\N	\N	\N	693	3207392350
rejected	\N	\N	\N	694	3207392350
rejected	\N	\N	\N	700	3207392350
rejected	\N	\N	\N	678	3207392350
rejected	\N	\N	\N	698	3207392350
rejected	\N	\N	\N	683	3207392350
rejected	\N	\N	\N	691	3207392350
rejected	\N	\N	\N	697	3207392350
rejected	\N	\N	\N	663	3207392350
rejected	\N	\N	\N	662	3207392350
rejected	\N	\N	\N	695	2563337837
rejected	\N	\N	\N	684	2563337837
rejected	\N	\N	\N	696	2563337837
rejected	\N	\N	\N	719	2563337837
rejected	\N	\N	\N	693	2563337837
rejected	\N	\N	\N	694	2563337837
rejected	\N	\N	\N	700	2563337837
rejected	\N	\N	\N	678	2563337837
rejected	\N	\N	\N	698	2563337837
rejected	\N	\N	\N	683	2563337837
rejected	\N	\N	\N	691	2563337837
rejected	\N	\N	\N	697	2563337837
rejected	\N	\N	\N	663	2563337837
rejected	\N	\N	\N	662	2563337837
rejected	\N	\N	\N	695	6123973547
rejected	\N	\N	\N	684	6123973547
rejected	\N	\N	\N	696	6123973547
rejected	\N	\N	\N	719	6123973547
rejected	\N	\N	\N	693	6123973547
rejected	\N	\N	\N	694	6123973547
rejected	\N	\N	\N	700	6123973547
rejected	\N	\N	\N	678	6123973547
rejected	\N	\N	\N	698	6123973547
rejected	\N	\N	\N	683	6123973547
rejected	\N	\N	\N	691	6123973547
rejected	\N	\N	\N	697	6123973547
rejected	\N	\N	\N	663	6123973547
rejected	\N	\N	\N	662	6123973547
rejected	\N	\N	\N	695	8048161591
rejected	\N	\N	\N	684	8048161591
rejected	\N	\N	\N	696	8048161591
rejected	\N	\N	\N	719	8048161591
rejected	\N	\N	\N	693	8048161591
rejected	\N	\N	\N	694	8048161591
rejected	\N	\N	\N	700	8048161591
rejected	\N	\N	\N	678	8048161591
rejected	\N	\N	\N	698	8048161591
rejected	\N	\N	\N	683	8048161591
rejected	\N	\N	\N	691	8048161591
rejected	\N	\N	\N	697	8048161591
rejected	\N	\N	\N	663	8048161591
rejected	\N	\N	\N	662	8048161591
rejected	\N	\N	\N	695	3885371670
rejected	\N	\N	\N	684	3885371670
rejected	\N	\N	\N	696	3885371670
rejected	\N	\N	\N	719	3885371670
rejected	\N	\N	\N	693	3885371670
rejected	\N	\N	\N	694	3885371670
rejected	\N	\N	\N	700	3885371670
rejected	\N	\N	\N	678	3885371670
rejected	\N	\N	\N	698	3885371670
rejected	\N	\N	\N	683	3885371670
rejected	\N	\N	\N	691	3885371670
rejected	\N	\N	\N	697	3885371670
rejected	\N	\N	\N	663	3885371670
rejected	\N	\N	\N	662	3885371670
rejected	\N	\N	\N	695	1677623273
rejected	\N	\N	\N	684	1677623273
rejected	\N	\N	\N	696	1677623273
rejected	\N	\N	\N	719	1677623273
rejected	\N	\N	\N	693	1677623273
rejected	\N	\N	\N	694	1677623273
rejected	\N	\N	\N	700	1677623273
rejected	\N	\N	\N	678	1677623273
rejected	\N	\N	\N	698	1677623273
rejected	\N	\N	\N	683	1677623273
rejected	\N	\N	\N	691	1677623273
rejected	\N	\N	\N	697	1677623273
rejected	\N	\N	\N	663	1677623273
rejected	\N	\N	\N	662	1677623273
rejected	\N	\N	\N	695	7412729163
rejected	\N	\N	\N	684	7412729163
rejected	\N	\N	\N	696	7412729163
rejected	\N	\N	\N	719	7412729163
rejected	\N	\N	\N	693	7412729163
rejected	\N	\N	\N	694	7412729163
rejected	\N	\N	\N	700	7412729163
rejected	\N	\N	\N	678	7412729163
rejected	\N	\N	\N	698	7412729163
rejected	\N	\N	\N	683	7412729163
rejected	\N	\N	\N	691	7412729163
rejected	\N	\N	\N	697	7412729163
rejected	\N	\N	\N	663	7412729163
rejected	\N	\N	\N	662	7412729163
rejected	\N	\N	\N	695	1908920784
rejected	\N	\N	\N	684	1908920784
rejected	\N	\N	\N	696	1908920784
rejected	\N	\N	\N	719	1908920784
rejected	\N	\N	\N	693	1908920784
rejected	\N	\N	\N	694	1908920784
rejected	\N	\N	\N	700	1908920784
rejected	\N	\N	\N	678	1908920784
rejected	\N	\N	\N	698	1908920784
rejected	\N	\N	\N	683	1908920784
rejected	\N	\N	\N	691	1908920784
rejected	\N	\N	\N	697	1908920784
rejected	\N	\N	\N	663	1908920784
rejected	\N	\N	\N	662	1908920784
rejected	\N	\N	\N	695	7604634123
rejected	\N	\N	\N	684	7604634123
rejected	\N	\N	\N	696	7604634123
rejected	\N	\N	\N	719	7604634123
rejected	\N	\N	\N	693	7604634123
rejected	\N	\N	\N	694	7604634123
rejected	\N	\N	\N	700	7604634123
rejected	\N	\N	\N	678	7604634123
rejected	\N	\N	\N	698	7604634123
rejected	\N	\N	\N	683	7604634123
rejected	\N	\N	\N	691	7604634123
rejected	\N	\N	\N	697	7604634123
rejected	\N	\N	\N	663	7604634123
rejected	\N	\N	\N	662	7604634123
rejected	\N	\N	\N	695	2678213354
rejected	\N	\N	\N	684	2678213354
rejected	\N	\N	\N	696	2678213354
rejected	\N	\N	\N	719	2678213354
rejected	\N	\N	\N	693	2678213354
rejected	\N	\N	\N	694	2678213354
rejected	\N	\N	\N	700	2678213354
rejected	\N	\N	\N	678	2678213354
rejected	\N	\N	\N	698	2678213354
rejected	\N	\N	\N	683	2678213354
rejected	\N	\N	\N	691	2678213354
rejected	\N	\N	\N	697	2678213354
rejected	\N	\N	\N	663	2678213354
rejected	\N	\N	\N	662	2678213354
rejected	\N	\N	\N	695	8140626094
rejected	\N	\N	\N	684	8140626094
rejected	\N	\N	\N	696	8140626094
rejected	\N	\N	\N	719	8140626094
rejected	\N	\N	\N	693	8140626094
rejected	\N	\N	\N	694	8140626094
rejected	\N	\N	\N	700	8140626094
rejected	\N	\N	\N	678	8140626094
rejected	\N	\N	\N	698	8140626094
rejected	\N	\N	\N	683	8140626094
rejected	\N	\N	\N	691	8140626094
rejected	\N	\N	\N	697	8140626094
rejected	\N	\N	\N	663	8140626094
rejected	\N	\N	\N	662	8140626094
rejected	\N	\N	\N	695	9262628998
rejected	\N	\N	\N	684	9262628998
rejected	\N	\N	\N	696	9262628998
rejected	\N	\N	\N	719	9262628998
rejected	\N	\N	\N	693	9262628998
rejected	\N	\N	\N	694	9262628998
rejected	\N	\N	\N	700	9262628998
rejected	\N	\N	\N	678	9262628998
rejected	\N	\N	\N	698	9262628998
rejected	\N	\N	\N	683	9262628998
rejected	\N	\N	\N	691	9262628998
rejected	\N	\N	\N	697	9262628998
rejected	\N	\N	\N	663	9262628998
rejected	\N	\N	\N	662	9262628998
rejected	\N	\N	\N	695	6368086134
rejected	\N	\N	\N	684	6368086134
rejected	\N	\N	\N	696	6368086134
rejected	\N	\N	\N	719	6368086134
rejected	\N	\N	\N	693	6368086134
rejected	\N	\N	\N	694	6368086134
rejected	\N	\N	\N	700	6368086134
rejected	\N	\N	\N	678	6368086134
rejected	\N	\N	\N	698	6368086134
rejected	\N	\N	\N	683	6368086134
rejected	\N	\N	\N	691	6368086134
rejected	\N	\N	\N	697	6368086134
rejected	\N	\N	\N	663	6368086134
rejected	\N	\N	\N	662	6368086134
rejected	\N	\N	\N	695	4141651461
rejected	\N	\N	\N	684	4141651461
rejected	\N	\N	\N	696	4141651461
rejected	\N	\N	\N	719	4141651461
rejected	\N	\N	\N	693	4141651461
rejected	\N	\N	\N	694	4141651461
rejected	\N	\N	\N	700	4141651461
rejected	\N	\N	\N	678	4141651461
rejected	\N	\N	\N	698	4141651461
rejected	\N	\N	\N	683	4141651461
rejected	\N	\N	\N	691	4141651461
rejected	\N	\N	\N	697	4141651461
rejected	\N	\N	\N	663	4141651461
rejected	\N	\N	\N	662	4141651461
rejected	\N	\N	\N	695	7611391463
rejected	\N	\N	\N	684	7611391463
rejected	\N	\N	\N	696	7611391463
rejected	\N	\N	\N	719	7611391463
rejected	\N	\N	\N	693	7611391463
rejected	\N	\N	\N	694	7611391463
rejected	\N	\N	\N	700	7611391463
rejected	\N	\N	\N	678	7611391463
rejected	\N	\N	\N	698	7611391463
rejected	\N	\N	\N	683	7611391463
rejected	\N	\N	\N	691	7611391463
rejected	\N	\N	\N	697	7611391463
rejected	\N	\N	\N	663	7611391463
rejected	\N	\N	\N	662	7611391463
rejected	\N	\N	\N	695	1002017775
rejected	\N	\N	\N	684	1002017775
rejected	\N	\N	\N	696	1002017775
rejected	\N	\N	\N	719	1002017775
rejected	\N	\N	\N	693	1002017775
rejected	\N	\N	\N	694	1002017775
rejected	\N	\N	\N	700	1002017775
rejected	\N	\N	\N	678	1002017775
rejected	\N	\N	\N	698	1002017775
rejected	\N	\N	\N	683	1002017775
rejected	\N	\N	\N	691	1002017775
rejected	\N	\N	\N	697	1002017775
rejected	\N	\N	\N	663	1002017775
rejected	\N	\N	\N	662	1002017775
rejected	\N	\N	\N	695	2127379383
rejected	\N	\N	\N	684	2127379383
rejected	\N	\N	\N	696	2127379383
rejected	\N	\N	\N	719	2127379383
rejected	\N	\N	\N	693	2127379383
rejected	\N	\N	\N	694	2127379383
rejected	\N	\N	\N	700	2127379383
rejected	\N	\N	\N	678	2127379383
rejected	\N	\N	\N	698	2127379383
rejected	\N	\N	\N	683	2127379383
rejected	\N	\N	\N	691	2127379383
rejected	\N	\N	\N	697	2127379383
rejected	\N	\N	\N	663	2127379383
rejected	\N	\N	\N	662	2127379383
rejected	\N	\N	\N	695	5383048297
rejected	\N	\N	\N	684	5383048297
rejected	\N	\N	\N	696	5383048297
rejected	\N	\N	\N	719	5383048297
rejected	\N	\N	\N	693	5383048297
rejected	\N	\N	\N	694	5383048297
rejected	\N	\N	\N	700	5383048297
rejected	\N	\N	\N	678	5383048297
rejected	\N	\N	\N	698	5383048297
rejected	\N	\N	\N	683	5383048297
rejected	\N	\N	\N	691	5383048297
rejected	\N	\N	\N	697	5383048297
rejected	\N	\N	\N	663	5383048297
rejected	\N	\N	\N	662	5383048297
rejected	\N	\N	\N	695	2456626264
rejected	\N	\N	\N	684	2456626264
rejected	\N	\N	\N	696	2456626264
rejected	\N	\N	\N	719	2456626264
rejected	\N	\N	\N	693	2456626264
rejected	\N	\N	\N	694	2456626264
rejected	\N	\N	\N	700	2456626264
rejected	\N	\N	\N	678	2456626264
rejected	\N	\N	\N	698	2456626264
rejected	\N	\N	\N	683	2456626264
rejected	\N	\N	\N	691	2456626264
rejected	\N	\N	\N	697	2456626264
rejected	\N	\N	\N	663	2456626264
rejected	\N	\N	\N	662	2456626264
rejected	\N	\N	\N	695	5027772807
rejected	\N	\N	\N	684	5027772807
rejected	\N	\N	\N	696	5027772807
rejected	\N	\N	\N	719	5027772807
rejected	\N	\N	\N	693	5027772807
rejected	\N	\N	\N	694	5027772807
rejected	\N	\N	\N	700	5027772807
rejected	\N	\N	\N	678	5027772807
rejected	\N	\N	\N	698	5027772807
rejected	\N	\N	\N	683	5027772807
rejected	\N	\N	\N	691	5027772807
rejected	\N	\N	\N	697	5027772807
rejected	\N	\N	\N	663	5027772807
rejected	\N	\N	\N	662	5027772807
rejected	\N	\N	\N	695	2539403312
rejected	\N	\N	\N	684	2539403312
rejected	\N	\N	\N	696	2539403312
rejected	\N	\N	\N	719	2539403312
rejected	\N	\N	\N	693	2539403312
rejected	\N	\N	\N	694	2539403312
rejected	\N	\N	\N	700	2539403312
rejected	\N	\N	\N	678	2539403312
rejected	\N	\N	\N	698	2539403312
rejected	\N	\N	\N	683	2539403312
rejected	\N	\N	\N	691	2539403312
rejected	\N	\N	\N	697	2539403312
rejected	\N	\N	\N	663	2539403312
rejected	\N	\N	\N	662	2539403312
rejected	\N	\N	\N	695	3466969247
rejected	\N	\N	\N	684	3466969247
rejected	\N	\N	\N	696	3466969247
rejected	\N	\N	\N	719	3466969247
rejected	\N	\N	\N	693	3466969247
rejected	\N	\N	\N	694	3466969247
rejected	\N	\N	\N	700	3466969247
rejected	\N	\N	\N	678	3466969247
rejected	\N	\N	\N	698	3466969247
rejected	\N	\N	\N	683	3466969247
rejected	\N	\N	\N	691	3466969247
rejected	\N	\N	\N	697	3466969247
rejected	\N	\N	\N	663	3466969247
rejected	\N	\N	\N	662	3466969247
rejected	\N	\N	\N	695	5404276104
rejected	\N	\N	\N	684	5404276104
rejected	\N	\N	\N	696	5404276104
rejected	\N	\N	\N	719	5404276104
rejected	\N	\N	\N	693	5404276104
rejected	\N	\N	\N	694	5404276104
rejected	\N	\N	\N	700	5404276104
rejected	\N	\N	\N	678	5404276104
rejected	\N	\N	\N	698	5404276104
rejected	\N	\N	\N	683	5404276104
rejected	\N	\N	\N	691	5404276104
rejected	\N	\N	\N	697	5404276104
rejected	\N	\N	\N	663	5404276104
rejected	\N	\N	\N	662	5404276104
rejected	\N	\N	\N	695	5298653978
rejected	\N	\N	\N	684	5298653978
rejected	\N	\N	\N	696	5298653978
rejected	\N	\N	\N	719	5298653978
rejected	\N	\N	\N	693	5298653978
rejected	\N	\N	\N	694	5298653978
rejected	\N	\N	\N	700	5298653978
rejected	\N	\N	\N	678	5298653978
rejected	\N	\N	\N	698	5298653978
rejected	\N	\N	\N	683	5298653978
rejected	\N	\N	\N	691	5298653978
rejected	\N	\N	\N	697	5298653978
rejected	\N	\N	\N	663	5298653978
rejected	\N	\N	\N	662	5298653978
rejected	\N	\N	\N	695	8519900776
rejected	\N	\N	\N	684	8519900776
rejected	\N	\N	\N	696	8519900776
rejected	\N	\N	\N	719	8519900776
rejected	\N	\N	\N	693	8519900776
rejected	\N	\N	\N	694	8519900776
rejected	\N	\N	\N	700	8519900776
rejected	\N	\N	\N	678	8519900776
rejected	\N	\N	\N	698	8519900776
rejected	\N	\N	\N	683	8519900776
rejected	\N	\N	\N	691	8519900776
rejected	\N	\N	\N	697	8519900776
rejected	\N	\N	\N	663	8519900776
rejected	\N	\N	\N	662	8519900776
rejected	\N	\N	\N	695	2647025193
rejected	\N	\N	\N	684	2647025193
rejected	\N	\N	\N	696	2647025193
rejected	\N	\N	\N	719	2647025193
rejected	\N	\N	\N	693	2647025193
rejected	\N	\N	\N	694	2647025193
rejected	\N	\N	\N	700	2647025193
rejected	\N	\N	\N	678	2647025193
rejected	\N	\N	\N	698	2647025193
rejected	\N	\N	\N	683	2647025193
rejected	\N	\N	\N	691	2647025193
rejected	\N	\N	\N	697	2647025193
rejected	\N	\N	\N	663	2647025193
rejected	\N	\N	\N	662	2647025193
rejected	\N	\N	\N	695	1322087026
rejected	\N	\N	\N	684	1322087026
rejected	\N	\N	\N	696	1322087026
rejected	\N	\N	\N	719	1322087026
rejected	\N	\N	\N	693	1322087026
rejected	\N	\N	\N	694	1322087026
rejected	\N	\N	\N	700	1322087026
rejected	\N	\N	\N	678	1322087026
rejected	\N	\N	\N	698	1322087026
rejected	\N	\N	\N	683	1322087026
rejected	\N	\N	\N	691	1322087026
rejected	\N	\N	\N	697	1322087026
rejected	\N	\N	\N	663	1322087026
rejected	\N	\N	\N	662	1322087026
rejected	\N	\N	\N	695	2431388358
rejected	\N	\N	\N	684	2431388358
rejected	\N	\N	\N	696	2431388358
rejected	\N	\N	\N	719	2431388358
rejected	\N	\N	\N	693	2431388358
rejected	\N	\N	\N	694	2431388358
rejected	\N	\N	\N	700	2431388358
rejected	\N	\N	\N	678	2431388358
rejected	\N	\N	\N	698	2431388358
rejected	\N	\N	\N	683	2431388358
rejected	\N	\N	\N	691	2431388358
rejected	\N	\N	\N	697	2431388358
rejected	\N	\N	\N	663	2431388358
rejected	\N	\N	\N	662	2431388358
rejected	\N	\N	\N	695	2627845789
rejected	\N	\N	\N	684	2627845789
rejected	\N	\N	\N	696	2627845789
rejected	\N	\N	\N	719	2627845789
rejected	\N	\N	\N	693	2627845789
rejected	\N	\N	\N	694	2627845789
rejected	\N	\N	\N	700	2627845789
rejected	\N	\N	\N	678	2627845789
rejected	\N	\N	\N	698	2627845789
rejected	\N	\N	\N	683	2627845789
rejected	\N	\N	\N	691	2627845789
rejected	\N	\N	\N	697	2627845789
rejected	\N	\N	\N	663	2627845789
rejected	\N	\N	\N	662	2627845789
rejected	\N	\N	\N	695	9866654321
rejected	\N	\N	\N	684	9866654321
rejected	\N	\N	\N	696	9866654321
rejected	\N	\N	\N	719	9866654321
rejected	\N	\N	\N	693	9866654321
rejected	\N	\N	\N	694	9866654321
rejected	\N	\N	\N	700	9866654321
rejected	\N	\N	\N	678	9866654321
rejected	\N	\N	\N	698	9866654321
rejected	\N	\N	\N	683	9866654321
rejected	\N	\N	\N	691	9866654321
rejected	\N	\N	\N	697	9866654321
rejected	\N	\N	\N	663	9866654321
rejected	\N	\N	\N	662	9866654321
rejected	\N	\N	\N	695	2724290938
rejected	\N	\N	\N	684	2724290938
rejected	\N	\N	\N	696	2724290938
rejected	\N	\N	\N	719	2724290938
rejected	\N	\N	\N	693	2724290938
rejected	\N	\N	\N	694	2724290938
rejected	\N	\N	\N	700	2724290938
rejected	\N	\N	\N	678	2724290938
rejected	\N	\N	\N	698	2724290938
rejected	\N	\N	\N	683	2724290938
rejected	\N	\N	\N	691	2724290938
rejected	\N	\N	\N	697	2724290938
rejected	\N	\N	\N	663	2724290938
rejected	\N	\N	\N	662	2724290938
rejected	\N	\N	\N	695	4835238140
rejected	\N	\N	\N	684	4835238140
rejected	\N	\N	\N	696	4835238140
rejected	\N	\N	\N	719	4835238140
rejected	\N	\N	\N	693	4835238140
rejected	\N	\N	\N	694	4835238140
rejected	\N	\N	\N	700	4835238140
rejected	\N	\N	\N	678	4835238140
rejected	\N	\N	\N	698	4835238140
rejected	\N	\N	\N	683	4835238140
rejected	\N	\N	\N	691	4835238140
rejected	\N	\N	\N	697	4835238140
rejected	\N	\N	\N	663	4835238140
rejected	\N	\N	\N	662	4835238140
rejected	\N	\N	\N	695	2429992163
rejected	\N	\N	\N	684	2429992163
rejected	\N	\N	\N	696	2429992163
rejected	\N	\N	\N	719	2429992163
rejected	\N	\N	\N	693	2429992163
rejected	\N	\N	\N	694	2429992163
rejected	\N	\N	\N	700	2429992163
rejected	\N	\N	\N	678	2429992163
rejected	\N	\N	\N	698	2429992163
rejected	\N	\N	\N	683	2429992163
rejected	\N	\N	\N	691	2429992163
rejected	\N	\N	\N	697	2429992163
rejected	\N	\N	\N	663	2429992163
rejected	\N	\N	\N	662	2429992163
rejected	\N	\N	\N	695	7848264486
rejected	\N	\N	\N	684	7848264486
rejected	\N	\N	\N	696	7848264486
rejected	\N	\N	\N	719	7848264486
rejected	\N	\N	\N	693	7848264486
rejected	\N	\N	\N	694	7848264486
rejected	\N	\N	\N	700	7848264486
rejected	\N	\N	\N	678	7848264486
rejected	\N	\N	\N	698	7848264486
rejected	\N	\N	\N	683	7848264486
rejected	\N	\N	\N	691	7848264486
rejected	\N	\N	\N	697	7848264486
rejected	\N	\N	\N	663	7848264486
rejected	\N	\N	\N	662	7848264486
rejected	\N	\N	\N	695	2883399736
rejected	\N	\N	\N	684	2883399736
rejected	\N	\N	\N	696	2883399736
rejected	\N	\N	\N	719	2883399736
rejected	\N	\N	\N	693	2883399736
rejected	\N	\N	\N	694	2883399736
rejected	\N	\N	\N	700	2883399736
rejected	\N	\N	\N	678	2883399736
rejected	\N	\N	\N	698	2883399736
rejected	\N	\N	\N	683	2883399736
rejected	\N	\N	\N	691	2883399736
rejected	\N	\N	\N	697	2883399736
rejected	\N	\N	\N	663	2883399736
rejected	\N	\N	\N	662	2883399736
rejected	\N	\N	\N	695	5315363834
rejected	\N	\N	\N	684	5315363834
rejected	\N	\N	\N	696	5315363834
rejected	\N	\N	\N	719	5315363834
rejected	\N	\N	\N	693	5315363834
rejected	\N	\N	\N	694	5315363834
rejected	\N	\N	\N	700	5315363834
rejected	\N	\N	\N	678	5315363834
rejected	\N	\N	\N	698	5315363834
rejected	\N	\N	\N	683	5315363834
rejected	\N	\N	\N	691	5315363834
rejected	\N	\N	\N	697	5315363834
rejected	\N	\N	\N	663	5315363834
rejected	\N	\N	\N	662	5315363834
rejected	\N	\N	\N	695	8525887759
rejected	\N	\N	\N	684	8525887759
rejected	\N	\N	\N	696	8525887759
rejected	\N	\N	\N	719	8525887759
rejected	\N	\N	\N	693	8525887759
rejected	\N	\N	\N	694	8525887759
rejected	\N	\N	\N	700	8525887759
rejected	\N	\N	\N	678	8525887759
rejected	\N	\N	\N	698	8525887759
rejected	\N	\N	\N	683	8525887759
rejected	\N	\N	\N	691	8525887759
rejected	\N	\N	\N	697	8525887759
rejected	\N	\N	\N	663	8525887759
rejected	\N	\N	\N	662	8525887759
rejected	\N	\N	\N	695	9296128900
rejected	\N	\N	\N	684	9296128900
rejected	\N	\N	\N	696	9296128900
rejected	\N	\N	\N	719	9296128900
rejected	\N	\N	\N	693	9296128900
rejected	\N	\N	\N	694	9296128900
rejected	\N	\N	\N	700	9296128900
rejected	\N	\N	\N	678	9296128900
rejected	\N	\N	\N	698	9296128900
rejected	\N	\N	\N	683	9296128900
rejected	\N	\N	\N	691	9296128900
rejected	\N	\N	\N	697	9296128900
rejected	\N	\N	\N	663	9296128900
rejected	\N	\N	\N	662	9296128900
rejected	\N	\N	\N	695	6224284619
rejected	\N	\N	\N	684	6224284619
rejected	\N	\N	\N	696	6224284619
rejected	\N	\N	\N	719	6224284619
rejected	\N	\N	\N	693	6224284619
rejected	\N	\N	\N	694	6224284619
rejected	\N	\N	\N	700	6224284619
rejected	\N	\N	\N	678	6224284619
rejected	\N	\N	\N	698	6224284619
rejected	\N	\N	\N	683	6224284619
rejected	\N	\N	\N	691	6224284619
rejected	\N	\N	\N	697	6224284619
rejected	\N	\N	\N	663	6224284619
rejected	\N	\N	\N	662	6224284619
rejected	\N	\N	\N	695	6130521884
rejected	\N	\N	\N	684	6130521884
rejected	\N	\N	\N	696	6130521884
rejected	\N	\N	\N	719	6130521884
rejected	\N	\N	\N	693	6130521884
rejected	\N	\N	\N	694	6130521884
rejected	\N	\N	\N	700	6130521884
rejected	\N	\N	\N	678	6130521884
rejected	\N	\N	\N	698	6130521884
rejected	\N	\N	\N	683	6130521884
rejected	\N	\N	\N	691	6130521884
rejected	\N	\N	\N	697	6130521884
rejected	\N	\N	\N	663	6130521884
rejected	\N	\N	\N	662	6130521884
rejected	\N	\N	\N	695	1974342255
rejected	\N	\N	\N	684	1974342255
rejected	\N	\N	\N	696	1974342255
rejected	\N	\N	\N	719	1974342255
rejected	\N	\N	\N	693	1974342255
rejected	\N	\N	\N	694	1974342255
rejected	\N	\N	\N	700	1974342255
rejected	\N	\N	\N	678	1974342255
rejected	\N	\N	\N	698	1974342255
rejected	\N	\N	\N	683	1974342255
rejected	\N	\N	\N	691	1974342255
rejected	\N	\N	\N	697	1974342255
rejected	\N	\N	\N	663	1974342255
rejected	\N	\N	\N	662	1974342255
rejected	\N	\N	\N	695	4364910715
rejected	\N	\N	\N	684	4364910715
rejected	\N	\N	\N	696	4364910715
rejected	\N	\N	\N	719	4364910715
rejected	\N	\N	\N	693	4364910715
rejected	\N	\N	\N	694	4364910715
rejected	\N	\N	\N	700	4364910715
rejected	\N	\N	\N	678	4364910715
rejected	\N	\N	\N	698	4364910715
rejected	\N	\N	\N	683	4364910715
rejected	\N	\N	\N	691	4364910715
rejected	\N	\N	\N	697	4364910715
rejected	\N	\N	\N	663	4364910715
rejected	\N	\N	\N	662	4364910715
rejected	\N	\N	\N	695	5393150884
rejected	\N	\N	\N	684	5393150884
rejected	\N	\N	\N	696	5393150884
rejected	\N	\N	\N	719	5393150884
rejected	\N	\N	\N	693	5393150884
rejected	\N	\N	\N	694	5393150884
rejected	\N	\N	\N	700	5393150884
rejected	\N	\N	\N	678	5393150884
rejected	\N	\N	\N	698	5393150884
rejected	\N	\N	\N	683	5393150884
rejected	\N	\N	\N	691	5393150884
rejected	\N	\N	\N	697	5393150884
rejected	\N	\N	\N	663	5393150884
rejected	\N	\N	\N	662	5393150884
rejected	\N	\N	\N	695	7342428390
rejected	\N	\N	\N	684	7342428390
rejected	\N	\N	\N	696	7342428390
rejected	\N	\N	\N	719	7342428390
rejected	\N	\N	\N	693	7342428390
rejected	\N	\N	\N	694	7342428390
rejected	\N	\N	\N	700	7342428390
rejected	\N	\N	\N	678	7342428390
rejected	\N	\N	\N	698	7342428390
rejected	\N	\N	\N	683	7342428390
rejected	\N	\N	\N	691	7342428390
rejected	\N	\N	\N	697	7342428390
rejected	\N	\N	\N	663	7342428390
rejected	\N	\N	\N	662	7342428390
rejected	\N	\N	\N	695	7506562181
rejected	\N	\N	\N	684	7506562181
rejected	\N	\N	\N	696	7506562181
rejected	\N	\N	\N	719	7506562181
rejected	\N	\N	\N	693	7506562181
rejected	\N	\N	\N	694	7506562181
rejected	\N	\N	\N	700	7506562181
rejected	\N	\N	\N	678	7506562181
rejected	\N	\N	\N	698	7506562181
rejected	\N	\N	\N	683	7506562181
rejected	\N	\N	\N	691	7506562181
rejected	\N	\N	\N	697	7506562181
rejected	\N	\N	\N	663	7506562181
rejected	\N	\N	\N	662	7506562181
rejected	\N	\N	\N	695	3004542348
rejected	\N	\N	\N	684	3004542348
rejected	\N	\N	\N	696	3004542348
rejected	\N	\N	\N	719	3004542348
rejected	\N	\N	\N	693	3004542348
rejected	\N	\N	\N	694	3004542348
rejected	\N	\N	\N	700	3004542348
rejected	\N	\N	\N	678	3004542348
rejected	\N	\N	\N	698	3004542348
rejected	\N	\N	\N	683	3004542348
rejected	\N	\N	\N	691	3004542348
rejected	\N	\N	\N	697	3004542348
rejected	\N	\N	\N	663	3004542348
rejected	\N	\N	\N	662	3004542348
rejected	\N	\N	\N	695	7344446165
rejected	\N	\N	\N	684	7344446165
rejected	\N	\N	\N	696	7344446165
rejected	\N	\N	\N	719	7344446165
rejected	\N	\N	\N	693	7344446165
rejected	\N	\N	\N	694	7344446165
rejected	\N	\N	\N	700	7344446165
rejected	\N	\N	\N	678	7344446165
rejected	\N	\N	\N	698	7344446165
rejected	\N	\N	\N	683	7344446165
rejected	\N	\N	\N	691	7344446165
rejected	\N	\N	\N	697	7344446165
rejected	\N	\N	\N	663	7344446165
rejected	\N	\N	\N	662	7344446165
rejected	\N	\N	\N	695	8633941564
rejected	\N	\N	\N	684	8633941564
rejected	\N	\N	\N	696	8633941564
rejected	\N	\N	\N	719	8633941564
rejected	\N	\N	\N	693	8633941564
rejected	\N	\N	\N	694	8633941564
rejected	\N	\N	\N	700	8633941564
rejected	\N	\N	\N	678	8633941564
rejected	\N	\N	\N	698	8633941564
rejected	\N	\N	\N	683	8633941564
rejected	\N	\N	\N	691	8633941564
rejected	\N	\N	\N	697	8633941564
rejected	\N	\N	\N	663	8633941564
rejected	\N	\N	\N	662	8633941564
rejected	\N	\N	\N	695	7387590646
rejected	\N	\N	\N	684	7387590646
rejected	\N	\N	\N	696	7387590646
rejected	\N	\N	\N	719	7387590646
rejected	\N	\N	\N	693	7387590646
rejected	\N	\N	\N	694	7387590646
rejected	\N	\N	\N	700	7387590646
rejected	\N	\N	\N	678	7387590646
rejected	\N	\N	\N	698	7387590646
rejected	\N	\N	\N	683	7387590646
rejected	\N	\N	\N	691	7387590646
rejected	\N	\N	\N	697	7387590646
rejected	\N	\N	\N	663	7387590646
rejected	\N	\N	\N	662	7387590646
rejected	\N	\N	\N	695	8801072434
rejected	\N	\N	\N	684	8801072434
rejected	\N	\N	\N	696	8801072434
rejected	\N	\N	\N	719	8801072434
rejected	\N	\N	\N	693	8801072434
rejected	\N	\N	\N	694	8801072434
rejected	\N	\N	\N	700	8801072434
rejected	\N	\N	\N	678	8801072434
rejected	\N	\N	\N	698	8801072434
rejected	\N	\N	\N	683	8801072434
rejected	\N	\N	\N	691	8801072434
rejected	\N	\N	\N	697	8801072434
rejected	\N	\N	\N	663	8801072434
rejected	\N	\N	\N	662	8801072434
rejected	\N	\N	\N	695	3661714372
rejected	\N	\N	\N	684	3661714372
rejected	\N	\N	\N	696	3661714372
rejected	\N	\N	\N	719	3661714372
rejected	\N	\N	\N	693	3661714372
rejected	\N	\N	\N	694	3661714372
rejected	\N	\N	\N	700	3661714372
rejected	\N	\N	\N	678	3661714372
rejected	\N	\N	\N	698	3661714372
rejected	\N	\N	\N	683	3661714372
rejected	\N	\N	\N	691	3661714372
rejected	\N	\N	\N	697	3661714372
rejected	\N	\N	\N	663	3661714372
rejected	\N	\N	\N	662	3661714372
rejected	\N	\N	\N	695	8926993958
rejected	\N	\N	\N	684	8926993958
rejected	\N	\N	\N	696	8926993958
rejected	\N	\N	\N	719	8926993958
rejected	\N	\N	\N	693	8926993958
rejected	\N	\N	\N	694	8926993958
rejected	\N	\N	\N	700	8926993958
rejected	\N	\N	\N	678	8926993958
rejected	\N	\N	\N	698	8926993958
rejected	\N	\N	\N	683	8926993958
rejected	\N	\N	\N	691	8926993958
rejected	\N	\N	\N	697	8926993958
rejected	\N	\N	\N	663	8926993958
rejected	\N	\N	\N	662	8926993958
rejected	\N	\N	\N	695	2268041682
rejected	\N	\N	\N	684	2268041682
rejected	\N	\N	\N	696	2268041682
rejected	\N	\N	\N	719	2268041682
rejected	\N	\N	\N	693	2268041682
rejected	\N	\N	\N	694	2268041682
rejected	\N	\N	\N	700	2268041682
rejected	\N	\N	\N	678	2268041682
rejected	\N	\N	\N	698	2268041682
rejected	\N	\N	\N	683	2268041682
rejected	\N	\N	\N	691	2268041682
rejected	\N	\N	\N	697	2268041682
rejected	\N	\N	\N	663	2268041682
rejected	\N	\N	\N	662	2268041682
rejected	\N	\N	\N	695	8065990477
rejected	\N	\N	\N	684	8065990477
rejected	\N	\N	\N	696	8065990477
rejected	\N	\N	\N	719	8065990477
rejected	\N	\N	\N	693	8065990477
rejected	\N	\N	\N	694	8065990477
rejected	\N	\N	\N	700	8065990477
rejected	\N	\N	\N	678	8065990477
rejected	\N	\N	\N	698	8065990477
rejected	\N	\N	\N	683	8065990477
rejected	\N	\N	\N	691	8065990477
rejected	\N	\N	\N	697	8065990477
rejected	\N	\N	\N	663	8065990477
rejected	\N	\N	\N	662	8065990477
rejected	\N	\N	\N	695	4225647938
rejected	\N	\N	\N	684	4225647938
rejected	\N	\N	\N	696	4225647938
rejected	\N	\N	\N	719	4225647938
rejected	\N	\N	\N	693	4225647938
rejected	\N	\N	\N	694	4225647938
rejected	\N	\N	\N	700	4225647938
rejected	\N	\N	\N	678	4225647938
rejected	\N	\N	\N	698	4225647938
rejected	\N	\N	\N	683	4225647938
rejected	\N	\N	\N	691	4225647938
rejected	\N	\N	\N	697	4225647938
rejected	\N	\N	\N	663	4225647938
rejected	\N	\N	\N	662	4225647938
rejected	\N	\N	\N	695	9787942463
rejected	\N	\N	\N	684	9787942463
rejected	\N	\N	\N	696	9787942463
rejected	\N	\N	\N	719	9787942463
rejected	\N	\N	\N	693	9787942463
rejected	\N	\N	\N	694	9787942463
rejected	\N	\N	\N	700	9787942463
rejected	\N	\N	\N	678	9787942463
rejected	\N	\N	\N	698	9787942463
rejected	\N	\N	\N	683	9787942463
rejected	\N	\N	\N	691	9787942463
rejected	\N	\N	\N	697	9787942463
rejected	\N	\N	\N	663	9787942463
rejected	\N	\N	\N	662	9787942463
rejected	\N	\N	\N	695	9713015670
rejected	\N	\N	\N	684	9713015670
rejected	\N	\N	\N	696	9713015670
rejected	\N	\N	\N	719	9713015670
rejected	\N	\N	\N	693	9713015670
rejected	\N	\N	\N	694	9713015670
rejected	\N	\N	\N	700	9713015670
rejected	\N	\N	\N	678	9713015670
rejected	\N	\N	\N	698	9713015670
rejected	\N	\N	\N	683	9713015670
rejected	\N	\N	\N	691	9713015670
rejected	\N	\N	\N	697	9713015670
rejected	\N	\N	\N	663	9713015670
rejected	\N	\N	\N	662	9713015670
rejected	\N	\N	\N	695	4547734968
rejected	\N	\N	\N	684	4547734968
rejected	\N	\N	\N	696	4547734968
rejected	\N	\N	\N	719	4547734968
rejected	\N	\N	\N	693	4547734968
rejected	\N	\N	\N	694	4547734968
rejected	\N	\N	\N	700	4547734968
rejected	\N	\N	\N	678	4547734968
rejected	\N	\N	\N	698	4547734968
rejected	\N	\N	\N	683	4547734968
rejected	\N	\N	\N	691	4547734968
rejected	\N	\N	\N	697	4547734968
rejected	\N	\N	\N	663	4547734968
rejected	\N	\N	\N	662	4547734968
rejected	\N	\N	\N	695	2219330822
rejected	\N	\N	\N	684	2219330822
rejected	\N	\N	\N	696	2219330822
rejected	\N	\N	\N	719	2219330822
rejected	\N	\N	\N	693	2219330822
rejected	\N	\N	\N	694	2219330822
rejected	\N	\N	\N	700	2219330822
rejected	\N	\N	\N	678	2219330822
rejected	\N	\N	\N	698	2219330822
rejected	\N	\N	\N	683	2219330822
rejected	\N	\N	\N	691	2219330822
rejected	\N	\N	\N	697	2219330822
rejected	\N	\N	\N	663	2219330822
rejected	\N	\N	\N	662	2219330822
rejected	\N	\N	\N	695	2340861465
rejected	\N	\N	\N	684	2340861465
rejected	\N	\N	\N	696	2340861465
rejected	\N	\N	\N	719	2340861465
rejected	\N	\N	\N	693	2340861465
rejected	\N	\N	\N	694	2340861465
rejected	\N	\N	\N	700	2340861465
rejected	\N	\N	\N	678	2340861465
rejected	\N	\N	\N	698	2340861465
rejected	\N	\N	\N	683	2340861465
rejected	\N	\N	\N	691	2340861465
rejected	\N	\N	\N	697	2340861465
rejected	\N	\N	\N	663	2340861465
rejected	\N	\N	\N	662	2340861465
rejected	\N	\N	\N	695	4414389290
rejected	\N	\N	\N	684	4414389290
rejected	\N	\N	\N	696	4414389290
rejected	\N	\N	\N	719	4414389290
rejected	\N	\N	\N	693	4414389290
rejected	\N	\N	\N	694	4414389290
rejected	\N	\N	\N	700	4414389290
rejected	\N	\N	\N	678	4414389290
rejected	\N	\N	\N	698	4414389290
rejected	\N	\N	\N	683	4414389290
rejected	\N	\N	\N	691	4414389290
rejected	\N	\N	\N	697	4414389290
rejected	\N	\N	\N	663	4414389290
rejected	\N	\N	\N	662	4414389290
rejected	\N	\N	\N	695	3943621761
rejected	\N	\N	\N	684	3943621761
rejected	\N	\N	\N	696	3943621761
rejected	\N	\N	\N	719	3943621761
rejected	\N	\N	\N	693	3943621761
rejected	\N	\N	\N	694	3943621761
rejected	\N	\N	\N	700	3943621761
rejected	\N	\N	\N	678	3943621761
rejected	\N	\N	\N	698	3943621761
rejected	\N	\N	\N	683	3943621761
rejected	\N	\N	\N	691	3943621761
rejected	\N	\N	\N	697	3943621761
rejected	\N	\N	\N	663	3943621761
rejected	\N	\N	\N	662	3943621761
rejected	\N	\N	\N	695	6176099606
rejected	\N	\N	\N	684	6176099606
rejected	\N	\N	\N	696	6176099606
rejected	\N	\N	\N	719	6176099606
rejected	\N	\N	\N	693	6176099606
rejected	\N	\N	\N	694	6176099606
rejected	\N	\N	\N	700	6176099606
rejected	\N	\N	\N	678	6176099606
rejected	\N	\N	\N	698	6176099606
rejected	\N	\N	\N	683	6176099606
rejected	\N	\N	\N	691	6176099606
rejected	\N	\N	\N	697	6176099606
rejected	\N	\N	\N	663	6176099606
rejected	\N	\N	\N	662	6176099606
rejected	\N	\N	\N	695	5844381454
rejected	\N	\N	\N	684	5844381454
rejected	\N	\N	\N	696	5844381454
rejected	\N	\N	\N	719	5844381454
rejected	\N	\N	\N	693	5844381454
rejected	\N	\N	\N	694	5844381454
rejected	\N	\N	\N	700	5844381454
rejected	\N	\N	\N	678	5844381454
rejected	\N	\N	\N	698	5844381454
rejected	\N	\N	\N	683	5844381454
rejected	\N	\N	\N	691	5844381454
rejected	\N	\N	\N	697	5844381454
rejected	\N	\N	\N	663	5844381454
rejected	\N	\N	\N	662	5844381454
rejected	\N	\N	\N	695	1791886249
rejected	\N	\N	\N	684	1791886249
rejected	\N	\N	\N	696	1791886249
rejected	\N	\N	\N	719	1791886249
rejected	\N	\N	\N	693	1791886249
rejected	\N	\N	\N	694	1791886249
rejected	\N	\N	\N	700	1791886249
rejected	\N	\N	\N	678	1791886249
rejected	\N	\N	\N	698	1791886249
rejected	\N	\N	\N	683	1791886249
rejected	\N	\N	\N	691	1791886249
rejected	\N	\N	\N	697	1791886249
rejected	\N	\N	\N	663	1791886249
rejected	\N	\N	\N	662	1791886249
rejected	\N	\N	\N	695	8059499343
rejected	\N	\N	\N	684	8059499343
rejected	\N	\N	\N	696	8059499343
rejected	\N	\N	\N	719	8059499343
rejected	\N	\N	\N	693	8059499343
rejected	\N	\N	\N	694	8059499343
rejected	\N	\N	\N	700	8059499343
rejected	\N	\N	\N	678	8059499343
rejected	\N	\N	\N	698	8059499343
rejected	\N	\N	\N	683	8059499343
rejected	\N	\N	\N	691	8059499343
rejected	\N	\N	\N	697	8059499343
rejected	\N	\N	\N	663	8059499343
rejected	\N	\N	\N	662	8059499343
rejected	\N	\N	\N	695	1159745290
rejected	\N	\N	\N	684	1159745290
rejected	\N	\N	\N	696	1159745290
rejected	\N	\N	\N	719	1159745290
rejected	\N	\N	\N	693	1159745290
rejected	\N	\N	\N	694	1159745290
rejected	\N	\N	\N	700	1159745290
rejected	\N	\N	\N	678	1159745290
rejected	\N	\N	\N	698	1159745290
rejected	\N	\N	\N	683	1159745290
rejected	\N	\N	\N	691	1159745290
rejected	\N	\N	\N	697	1159745290
rejected	\N	\N	\N	663	1159745290
rejected	\N	\N	\N	662	1159745290
rejected	\N	\N	\N	695	9317774013
rejected	\N	\N	\N	684	9317774013
rejected	\N	\N	\N	696	9317774013
rejected	\N	\N	\N	719	9317774013
rejected	\N	\N	\N	693	9317774013
rejected	\N	\N	\N	694	9317774013
rejected	\N	\N	\N	700	9317774013
rejected	\N	\N	\N	678	9317774013
rejected	\N	\N	\N	698	9317774013
rejected	\N	\N	\N	683	9317774013
rejected	\N	\N	\N	691	9317774013
rejected	\N	\N	\N	697	9317774013
rejected	\N	\N	\N	663	9317774013
rejected	\N	\N	\N	662	9317774013
rejected	\N	\N	\N	695	7355628244
rejected	\N	\N	\N	684	7355628244
rejected	\N	\N	\N	696	7355628244
rejected	\N	\N	\N	719	7355628244
rejected	\N	\N	\N	693	7355628244
rejected	\N	\N	\N	694	7355628244
rejected	\N	\N	\N	700	7355628244
rejected	\N	\N	\N	678	7355628244
rejected	\N	\N	\N	698	7355628244
rejected	\N	\N	\N	683	7355628244
rejected	\N	\N	\N	691	7355628244
rejected	\N	\N	\N	697	7355628244
rejected	\N	\N	\N	663	7355628244
rejected	\N	\N	\N	662	7355628244
rejected	\N	\N	\N	695	6384029909
rejected	\N	\N	\N	684	6384029909
rejected	\N	\N	\N	696	6384029909
rejected	\N	\N	\N	719	6384029909
rejected	\N	\N	\N	693	6384029909
rejected	\N	\N	\N	694	6384029909
rejected	\N	\N	\N	700	6384029909
rejected	\N	\N	\N	678	6384029909
rejected	\N	\N	\N	698	6384029909
rejected	\N	\N	\N	683	6384029909
rejected	\N	\N	\N	691	6384029909
rejected	\N	\N	\N	697	6384029909
rejected	\N	\N	\N	663	6384029909
rejected	\N	\N	\N	662	6384029909
rejected	\N	\N	\N	695	5448295898
rejected	\N	\N	\N	684	5448295898
rejected	\N	\N	\N	696	5448295898
rejected	\N	\N	\N	719	5448295898
rejected	\N	\N	\N	693	5448295898
rejected	\N	\N	\N	694	5448295898
rejected	\N	\N	\N	700	5448295898
rejected	\N	\N	\N	678	5448295898
rejected	\N	\N	\N	698	5448295898
rejected	\N	\N	\N	683	5448295898
rejected	\N	\N	\N	691	5448295898
rejected	\N	\N	\N	697	5448295898
rejected	\N	\N	\N	663	5448295898
rejected	\N	\N	\N	662	5448295898
rejected	\N	\N	\N	695	8329970500
rejected	\N	\N	\N	684	8329970500
rejected	\N	\N	\N	696	8329970500
rejected	\N	\N	\N	719	8329970500
rejected	\N	\N	\N	693	8329970500
rejected	\N	\N	\N	694	8329970500
rejected	\N	\N	\N	700	8329970500
rejected	\N	\N	\N	678	8329970500
rejected	\N	\N	\N	698	8329970500
rejected	\N	\N	\N	683	8329970500
rejected	\N	\N	\N	691	8329970500
rejected	\N	\N	\N	697	8329970500
rejected	\N	\N	\N	663	8329970500
rejected	\N	\N	\N	662	8329970500
rejected	\N	\N	\N	695	9748940629
rejected	\N	\N	\N	684	9748940629
rejected	\N	\N	\N	696	9748940629
rejected	\N	\N	\N	719	9748940629
rejected	\N	\N	\N	693	9748940629
rejected	\N	\N	\N	694	9748940629
rejected	\N	\N	\N	700	9748940629
rejected	\N	\N	\N	678	9748940629
rejected	\N	\N	\N	698	9748940629
rejected	\N	\N	\N	683	9748940629
rejected	\N	\N	\N	691	9748940629
rejected	\N	\N	\N	697	9748940629
rejected	\N	\N	\N	663	9748940629
rejected	\N	\N	\N	662	9748940629
rejected	\N	\N	\N	695	9841446787
rejected	\N	\N	\N	684	9841446787
rejected	\N	\N	\N	696	9841446787
rejected	\N	\N	\N	719	9841446787
rejected	\N	\N	\N	693	9841446787
rejected	\N	\N	\N	694	9841446787
rejected	\N	\N	\N	700	9841446787
rejected	\N	\N	\N	678	9841446787
rejected	\N	\N	\N	698	9841446787
rejected	\N	\N	\N	683	9841446787
rejected	\N	\N	\N	691	9841446787
rejected	\N	\N	\N	697	9841446787
rejected	\N	\N	\N	663	9841446787
rejected	\N	\N	\N	662	9841446787
rejected	\N	\N	\N	695	5672398895
rejected	\N	\N	\N	684	5672398895
rejected	\N	\N	\N	696	5672398895
rejected	\N	\N	\N	719	5672398895
rejected	\N	\N	\N	693	5672398895
rejected	\N	\N	\N	694	5672398895
rejected	\N	\N	\N	700	5672398895
rejected	\N	\N	\N	678	5672398895
rejected	\N	\N	\N	698	5672398895
rejected	\N	\N	\N	683	5672398895
rejected	\N	\N	\N	691	5672398895
rejected	\N	\N	\N	697	5672398895
rejected	\N	\N	\N	663	5672398895
rejected	\N	\N	\N	662	5672398895
rejected	\N	\N	\N	695	7255502811
rejected	\N	\N	\N	684	7255502811
rejected	\N	\N	\N	696	7255502811
rejected	\N	\N	\N	719	7255502811
rejected	\N	\N	\N	693	7255502811
rejected	\N	\N	\N	694	7255502811
rejected	\N	\N	\N	700	7255502811
rejected	\N	\N	\N	678	7255502811
rejected	\N	\N	\N	698	7255502811
rejected	\N	\N	\N	683	7255502811
rejected	\N	\N	\N	691	7255502811
rejected	\N	\N	\N	697	7255502811
rejected	\N	\N	\N	663	7255502811
rejected	\N	\N	\N	662	7255502811
rejected	\N	\N	\N	695	2845989136
rejected	\N	\N	\N	684	2845989136
rejected	\N	\N	\N	696	2845989136
rejected	\N	\N	\N	719	2845989136
rejected	\N	\N	\N	693	2845989136
rejected	\N	\N	\N	694	2845989136
rejected	\N	\N	\N	700	2845989136
rejected	\N	\N	\N	678	2845989136
rejected	\N	\N	\N	698	2845989136
rejected	\N	\N	\N	683	2845989136
rejected	\N	\N	\N	691	2845989136
rejected	\N	\N	\N	697	2845989136
rejected	\N	\N	\N	663	2845989136
rejected	\N	\N	\N	662	2845989136
rejected	\N	\N	\N	695	3016845062
rejected	\N	\N	\N	684	3016845062
rejected	\N	\N	\N	696	3016845062
rejected	\N	\N	\N	719	3016845062
rejected	\N	\N	\N	693	3016845062
rejected	\N	\N	\N	694	3016845062
rejected	\N	\N	\N	700	3016845062
rejected	\N	\N	\N	678	3016845062
rejected	\N	\N	\N	698	3016845062
rejected	\N	\N	\N	683	3016845062
rejected	\N	\N	\N	691	3016845062
rejected	\N	\N	\N	697	3016845062
rejected	\N	\N	\N	663	3016845062
rejected	\N	\N	\N	662	3016845062
rejected	\N	\N	\N	695	5889444376
rejected	\N	\N	\N	684	5889444376
rejected	\N	\N	\N	696	5889444376
rejected	\N	\N	\N	719	5889444376
rejected	\N	\N	\N	693	5889444376
rejected	\N	\N	\N	694	5889444376
rejected	\N	\N	\N	700	5889444376
rejected	\N	\N	\N	678	5889444376
rejected	\N	\N	\N	698	5889444376
rejected	\N	\N	\N	683	5889444376
rejected	\N	\N	\N	691	5889444376
rejected	\N	\N	\N	697	5889444376
rejected	\N	\N	\N	663	5889444376
rejected	\N	\N	\N	662	5889444376
rejected	\N	\N	\N	695	9233579786
rejected	\N	\N	\N	684	9233579786
rejected	\N	\N	\N	696	9233579786
rejected	\N	\N	\N	719	9233579786
rejected	\N	\N	\N	693	9233579786
rejected	\N	\N	\N	694	9233579786
rejected	\N	\N	\N	700	9233579786
rejected	\N	\N	\N	678	9233579786
rejected	\N	\N	\N	698	9233579786
rejected	\N	\N	\N	683	9233579786
rejected	\N	\N	\N	691	9233579786
rejected	\N	\N	\N	697	9233579786
rejected	\N	\N	\N	663	9233579786
rejected	\N	\N	\N	662	9233579786
rejected	\N	\N	\N	695	1817917498
rejected	\N	\N	\N	684	1817917498
rejected	\N	\N	\N	696	1817917498
rejected	\N	\N	\N	719	1817917498
rejected	\N	\N	\N	693	1817917498
rejected	\N	\N	\N	694	1817917498
rejected	\N	\N	\N	700	1817917498
rejected	\N	\N	\N	678	1817917498
rejected	\N	\N	\N	698	1817917498
rejected	\N	\N	\N	683	1817917498
rejected	\N	\N	\N	691	1817917498
rejected	\N	\N	\N	697	1817917498
rejected	\N	\N	\N	663	1817917498
rejected	\N	\N	\N	662	1817917498
rejected	\N	\N	\N	695	8551158753
rejected	\N	\N	\N	684	8551158753
rejected	\N	\N	\N	696	8551158753
rejected	\N	\N	\N	719	8551158753
rejected	\N	\N	\N	693	8551158753
rejected	\N	\N	\N	694	8551158753
rejected	\N	\N	\N	700	8551158753
rejected	\N	\N	\N	678	8551158753
rejected	\N	\N	\N	698	8551158753
rejected	\N	\N	\N	683	8551158753
rejected	\N	\N	\N	691	8551158753
rejected	\N	\N	\N	697	8551158753
rejected	\N	\N	\N	663	8551158753
rejected	\N	\N	\N	662	8551158753
rejected	\N	\N	\N	695	8160573746
rejected	\N	\N	\N	684	8160573746
rejected	\N	\N	\N	696	8160573746
rejected	\N	\N	\N	719	8160573746
rejected	\N	\N	\N	693	8160573746
rejected	\N	\N	\N	694	8160573746
rejected	\N	\N	\N	700	8160573746
rejected	\N	\N	\N	678	8160573746
rejected	\N	\N	\N	698	8160573746
rejected	\N	\N	\N	683	8160573746
rejected	\N	\N	\N	691	8160573746
rejected	\N	\N	\N	697	8160573746
rejected	\N	\N	\N	663	8160573746
rejected	\N	\N	\N	662	8160573746
rejected	\N	\N	\N	695	3085959185
rejected	\N	\N	\N	684	3085959185
rejected	\N	\N	\N	696	3085959185
rejected	\N	\N	\N	719	3085959185
rejected	\N	\N	\N	693	3085959185
rejected	\N	\N	\N	694	3085959185
rejected	\N	\N	\N	700	3085959185
rejected	\N	\N	\N	678	3085959185
rejected	\N	\N	\N	698	3085959185
rejected	\N	\N	\N	683	3085959185
rejected	\N	\N	\N	691	3085959185
rejected	\N	\N	\N	697	3085959185
rejected	\N	\N	\N	663	3085959185
rejected	\N	\N	\N	662	3085959185
rejected	\N	\N	\N	695	6617149232
rejected	\N	\N	\N	684	6617149232
rejected	\N	\N	\N	696	6617149232
rejected	\N	\N	\N	719	6617149232
rejected	\N	\N	\N	693	6617149232
rejected	\N	\N	\N	694	6617149232
rejected	\N	\N	\N	700	6617149232
rejected	\N	\N	\N	678	6617149232
rejected	\N	\N	\N	698	6617149232
rejected	\N	\N	\N	683	6617149232
rejected	\N	\N	\N	691	6617149232
rejected	\N	\N	\N	697	6617149232
rejected	\N	\N	\N	663	6617149232
rejected	\N	\N	\N	662	6617149232
rejected	\N	\N	\N	695	2386221689
rejected	\N	\N	\N	684	2386221689
rejected	\N	\N	\N	696	2386221689
rejected	\N	\N	\N	719	2386221689
rejected	\N	\N	\N	693	2386221689
rejected	\N	\N	\N	694	2386221689
rejected	\N	\N	\N	700	2386221689
rejected	\N	\N	\N	678	2386221689
rejected	\N	\N	\N	698	2386221689
rejected	\N	\N	\N	683	2386221689
rejected	\N	\N	\N	691	2386221689
rejected	\N	\N	\N	697	2386221689
rejected	\N	\N	\N	663	2386221689
rejected	\N	\N	\N	662	2386221689
rejected	\N	\N	\N	695	2873901649
rejected	\N	\N	\N	684	2873901649
rejected	\N	\N	\N	696	2873901649
rejected	\N	\N	\N	719	2873901649
rejected	\N	\N	\N	693	2873901649
rejected	\N	\N	\N	694	2873901649
rejected	\N	\N	\N	700	2873901649
rejected	\N	\N	\N	678	2873901649
rejected	\N	\N	\N	698	2873901649
rejected	\N	\N	\N	683	2873901649
rejected	\N	\N	\N	691	2873901649
rejected	\N	\N	\N	697	2873901649
rejected	\N	\N	\N	663	2873901649
rejected	\N	\N	\N	662	2873901649
rejected	\N	\N	\N	695	6330164908
rejected	\N	\N	\N	684	6330164908
rejected	\N	\N	\N	696	6330164908
rejected	\N	\N	\N	719	6330164908
rejected	\N	\N	\N	693	6330164908
rejected	\N	\N	\N	694	6330164908
rejected	\N	\N	\N	700	6330164908
rejected	\N	\N	\N	678	6330164908
rejected	\N	\N	\N	698	6330164908
rejected	\N	\N	\N	683	6330164908
rejected	\N	\N	\N	691	6330164908
rejected	\N	\N	\N	697	6330164908
rejected	\N	\N	\N	663	6330164908
rejected	\N	\N	\N	662	6330164908
rejected	\N	\N	\N	695	5933956657
rejected	\N	\N	\N	684	5933956657
rejected	\N	\N	\N	696	5933956657
rejected	\N	\N	\N	719	5933956657
rejected	\N	\N	\N	693	5933956657
rejected	\N	\N	\N	694	5933956657
rejected	\N	\N	\N	700	5933956657
rejected	\N	\N	\N	678	5933956657
rejected	\N	\N	\N	698	5933956657
rejected	\N	\N	\N	683	5933956657
rejected	\N	\N	\N	691	5933956657
rejected	\N	\N	\N	697	5933956657
rejected	\N	\N	\N	663	5933956657
rejected	\N	\N	\N	662	5933956657
rejected	\N	\N	\N	695	4093232471
rejected	\N	\N	\N	684	4093232471
rejected	\N	\N	\N	696	4093232471
rejected	\N	\N	\N	719	4093232471
rejected	\N	\N	\N	693	4093232471
rejected	\N	\N	\N	694	4093232471
rejected	\N	\N	\N	700	4093232471
rejected	\N	\N	\N	678	4093232471
rejected	\N	\N	\N	698	4093232471
rejected	\N	\N	\N	683	4093232471
rejected	\N	\N	\N	691	4093232471
rejected	\N	\N	\N	697	4093232471
rejected	\N	\N	\N	663	4093232471
rejected	\N	\N	\N	662	4093232471
rejected	\N	\N	\N	695	7671026373
rejected	\N	\N	\N	684	7671026373
rejected	\N	\N	\N	696	7671026373
rejected	\N	\N	\N	719	7671026373
rejected	\N	\N	\N	693	7671026373
rejected	\N	\N	\N	694	7671026373
rejected	\N	\N	\N	700	7671026373
rejected	\N	\N	\N	678	7671026373
rejected	\N	\N	\N	698	7671026373
rejected	\N	\N	\N	683	7671026373
rejected	\N	\N	\N	691	7671026373
rejected	\N	\N	\N	697	7671026373
rejected	\N	\N	\N	663	7671026373
rejected	\N	\N	\N	662	7671026373
rejected	\N	\N	\N	695	9348345948
rejected	\N	\N	\N	684	9348345948
rejected	\N	\N	\N	696	9348345948
rejected	\N	\N	\N	719	9348345948
rejected	\N	\N	\N	693	9348345948
rejected	\N	\N	\N	694	9348345948
rejected	\N	\N	\N	700	9348345948
rejected	\N	\N	\N	678	9348345948
rejected	\N	\N	\N	698	9348345948
rejected	\N	\N	\N	683	9348345948
rejected	\N	\N	\N	691	9348345948
rejected	\N	\N	\N	697	9348345948
rejected	\N	\N	\N	663	9348345948
rejected	\N	\N	\N	662	9348345948
rejected	\N	\N	\N	695	7036854232
rejected	\N	\N	\N	684	7036854232
rejected	\N	\N	\N	696	7036854232
rejected	\N	\N	\N	719	7036854232
rejected	\N	\N	\N	693	7036854232
rejected	\N	\N	\N	694	7036854232
rejected	\N	\N	\N	700	7036854232
rejected	\N	\N	\N	678	7036854232
rejected	\N	\N	\N	698	7036854232
rejected	\N	\N	\N	683	7036854232
rejected	\N	\N	\N	691	7036854232
rejected	\N	\N	\N	697	7036854232
rejected	\N	\N	\N	663	7036854232
rejected	\N	\N	\N	662	7036854232
pass	5	\N	5	676	5027772807
pass	10	\N	10	676	3466969247
pass	6	\N	6	676	5404276104
pass	9	\N	9	676	2647025193
pass	8	\N	8	676	1322087026
pass	9	\N	9	676	2627845789
pass	8	\N	8	676	9866654321
pass	7	\N	7	676	2724290938
pass	6	\N	6	676	4835238140
pass	8	\N	8	676	5315363834
pass	8	\N	8	676	8525887759
pass	8	\N	8	676	9296128900
pass	6	\N	6	676	6224284619
pass	5	\N	5	676	6130521884
pass	7	\N	7	676	1974342255
pass	10	\N	10	676	4364910715
pass	9	\N	9	676	5393150884
pass	10	\N	10	676	7506562181
pass	6	\N	6	676	3004542348
pass	8	\N	8	676	7344446165
pass	5	\N	5	676	3661714372
pass	5	\N	5	676	8926993958
pass	6	\N	6	676	2268041682
pass	9	\N	9	676	8065990477
pass	6	\N	6	676	4547734968
pass	6	\N	6	676	2219330822
pass	9	\N	9	676	4414389290
pass	5	\N	5	676	3943621761
pass	5	\N	5	676	1791886249
pass	7	\N	7	676	9317774013
pass	8	\N	8	676	7355628244
pass	10	\N	10	676	9748940629
pass	9	\N	9	676	9841446787
pass	7	\N	7	676	5672398895
pass	9	\N	9	676	2845989136
pass	7	\N	7	677	9825289323
pass	9	\N	9	677	3391566195
pass	5	\N	5	677	1006258297
pass	5	\N	5	677	5589427861
pass	8	\N	8	677	5081927005
pass	7	\N	7	677	6052931528
pass	8	\N	8	677	7242749087
pass	6	\N	6	677	9980820595
pass	6	\N	6	677	2563337837
pass	6	\N	6	677	3885371670
pass	8	\N	8	677	1677623273
pass	10	\N	10	677	7412729163
pass	7	\N	7	677	1908920784
pass	9	\N	9	677	7604634123
pass	8	\N	8	677	2678213354
pass	5	\N	5	677	6368086134
pass	5	\N	5	677	4141651461
pass	8	\N	8	677	1002017775
pass	8	\N	8	677	5383048297
pass	9	\N	9	677	2456626264
pass	7	\N	7	677	5027772807
pass	7	\N	7	677	3466969247
pass	6	\N	6	677	5404276104
pass	7	\N	7	677	8519900776
pass	5	\N	5	677	2647025193
pass	5	\N	5	677	2627845789
pass	10	\N	10	677	9866654321
pass	6	\N	6	677	2724290938
pass	6	\N	6	677	4835238140
pass	9	\N	9	677	2429992163
pass	8	\N	8	677	7848264486
pass	7	\N	7	677	5315363834
pass	6	\N	6	677	9296128900
pass	5	\N	5	677	6224284619
pass	7	\N	7	677	1974342255
pass	5	\N	5	677	4364910715
pass	8	\N	8	677	7342428390
pass	10	\N	10	677	8633941564
pass	9	\N	9	677	8801072434
pass	8	\N	8	677	3661714372
pass	6	\N	6	677	8926993958
pass	8	\N	8	677	8065990477
pass	9	\N	9	677	4225647938
pass	7	\N	7	677	9787942463
pass	5	\N	5	677	9713015670
pass	7	\N	7	677	4547734968
pass	7	\N	7	677	4414389290
pass	9	\N	9	677	3943621761
pass	7	\N	7	677	6176099606
pass	6	\N	6	677	5844381454
pass	5	\N	5	677	8059499343
pass	10	\N	10	677	1159745290
pass	5	\N	5	677	9317774013
pass	8	\N	8	677	6384029909
pass	9	\N	9	677	5448295898
pass	7	\N	7	677	8329970500
pass	5	\N	5	677	9841446787
pass	6	\N	6	677	7255502811
pass	7	\N	7	677	2845989136
pass	9	\N	9	677	9233579786
pass	9	\N	9	677	1817917498
pass	8	\N	8	677	3085959185
pass	7	\N	7	677	6617149232
pass	8	\N	8	677	2386221689
pass	6	\N	6	677	2873901649
pass	7	\N	7	677	5933956657
pass	7	\N	7	677	9348345948
pass	6	\N	6	677	7036854232
pass	8	4	8	681	1006258297
pass	9	7	9	681	1077861304
pass	6	5	6	686	1006258297
pass	8	\N	8	687	6052931528
pass	6	\N	6	687	7242749087
pass	5	\N	5	687	3911487577
pass	10	\N	10	687	9980820595
pass	8	\N	8	687	3207392350
pass	9	\N	9	687	2563337837
pass	7	\N	7	687	6123973547
pass	6	\N	6	687	1677623273
pass	7	\N	7	687	7412729163
pass	7	\N	7	687	1908920784
pass	5	\N	5	687	7604634123
pass	7	\N	7	687	8140626094
pass	6	\N	6	687	9262628998
pass	6	\N	6	687	4141651461
pass	10	\N	10	687	1002017775
pass	6	\N	6	687	2127379383
pass	8	\N	8	687	5383048297
pass	6	\N	6	687	3466969247
pass	10	\N	10	687	5404276104
pass	6	\N	6	687	2647025193
pass	7	\N	7	687	1322087026
pass	5	\N	5	687	9866654321
pass	7	\N	7	687	2724290938
pass	7	\N	7	687	4835238140
pass	8	\N	8	687	2429992163
pass	5	\N	5	687	5315363834
pass	10	\N	10	687	6130521884
pass	5	\N	5	687	5393150884
pass	9	\N	9	687	7344446165
pass	7	\N	7	687	7387590646
pass	6	\N	6	687	8801072434
pass	9	\N	9	687	8926993958
pass	5	\N	5	687	8065990477
pass	6	\N	6	687	4225647938
pass	5	\N	5	687	9713015670
pass	5	\N	5	687	2219330822
pass	5	\N	5	687	2340861465
pass	7	\N	7	687	4414389290
pass	5	\N	5	687	3943621761
pass	5	\N	5	687	5844381454
pass	10	\N	10	687	8059499343
pass	5	\N	5	687	1159745290
pass	9	\N	9	687	6384029909
pass	6	\N	6	687	5448295898
pass	8	\N	8	687	8329970500
pass	5	\N	5	687	5672398895
pass	8	\N	8	687	7255502811
pass	7	\N	7	687	2845989136
pass	8	\N	8	687	5889444376
pass	5	\N	5	687	8551158753
pass	6	\N	6	687	6617149232
pass	8	\N	8	687	2386221689
pass	8	\N	8	687	6330164908
pass	9	\N	9	687	4093232471
pass	8	\N	8	687	9348345948
pass	8	\N	8	687	7036854232
pass	9	\N	9	692	6052931528
pass	8	\N	8	692	3911487577
pass	9	\N	9	692	9980820595
pass	6	\N	6	692	9544567295
pass	8	\N	8	692	1292902580
pass	9	\N	9	692	3207392350
pass	7	\N	7	692	6123973547
pass	8	\N	8	692	3885371670
pass	5	\N	5	692	7412729163
pass	5	\N	5	692	7604634123
pass	8	\N	8	692	2678213354
pass	5	\N	5	692	8140626094
pass	8	\N	8	692	6368086134
pass	8	\N	8	692	7611391463
pass	9	\N	9	692	2127379383
pass	7	\N	7	692	5383048297
pass	7	\N	7	692	2539403312
pass	6	\N	6	692	5404276104
pass	6	\N	6	692	2647025193
pass	6	\N	6	692	1322087026
pass	9	\N	9	692	2627845789
pass	7	\N	7	692	4835238140
pass	6	\N	6	692	2429992163
pass	8	\N	8	692	2883399736
pass	5	\N	5	692	5315363834
pass	9	\N	9	692	8525887759
pass	7	\N	7	692	9296128900
pass	9	\N	9	692	6224284619
pass	5	\N	5	692	6130521884
pass	10	\N	10	692	1974342255
pass	7	\N	7	692	7342428390
pass	5	\N	5	692	7506562181
pass	10	\N	10	692	7344446165
pass	7	\N	7	692	8633941564
pass	10	\N	10	692	7387590646
pass	9	\N	9	692	8801072434
pass	7	\N	7	692	3661714372
pass	5	\N	5	692	8926993958
pass	7	\N	7	692	4225647938
pass	7	\N	7	692	9713015670
pass	7	\N	7	692	4414389290
pass	7	\N	7	692	3943621761
pass	9	\N	9	692	6176099606
pass	5	\N	5	692	1791886249
pass	6	\N	6	692	1159745290
pass	5	\N	5	692	9317774013
pass	7	\N	7	692	7355628244
pass	7	\N	7	692	6384029909
pass	8	\N	8	692	9748940629
pass	7	\N	7	692	5672398895
pass	7	\N	7	692	7255502811
pass	10	\N	10	692	5889444376
pass	5	\N	5	692	9233579786
pass	7	\N	7	692	1817917498
pass	7	\N	7	692	8551158753
pass	8	\N	8	692	8160573746
pass	5	\N	5	692	6617149232
pass	5	\N	5	692	6330164908
pass	8	\N	8	692	5933956657
pass	6	\N	6	692	9348345948
pass	7	\N	7	699	3911487577
pass	9	\N	9	699	1292902580
pass	7	\N	7	699	3885371670
pass	9	\N	9	699	1677623273
pass	8	\N	8	699	7412729163
pass	7	\N	7	699	2678213354
pass	8	\N	8	699	8140626094
pass	9	\N	9	699	6368086134
pass	5	\N	5	699	7611391463
pass	9	\N	9	699	5383048297
pass	9	\N	9	699	5027772807
pass	8	\N	8	699	2539403312
pass	10	\N	10	699	5404276104
pass	6	\N	6	699	5298653978
pass	10	\N	10	699	8519900776
pass	7	\N	7	699	2724290938
pass	5	\N	5	699	7848264486
pass	9	\N	9	699	2883399736
pass	7	\N	7	699	8525887759
pass	7	\N	7	699	6224284619
pass	9	\N	9	699	6130521884
pass	9	\N	9	699	4364910715
pass	5	\N	5	699	5393150884
pass	9	\N	9	699	7506562181
pass	5	\N	5	699	3004542348
pass	5	\N	5	699	7344446165
pass	6	\N	6	699	8801072434
pass	6	\N	6	699	3661714372
pass	8	\N	8	699	2268041682
pass	10	\N	10	699	8065990477
pass	7	\N	7	699	4225647938
pass	9	\N	9	699	9787942463
pass	9	\N	9	699	2219330822
pass	9	\N	9	699	3943621761
pass	5	\N	5	699	6176099606
pass	10	\N	10	699	5844381454
pass	8	\N	8	699	1791886249
pass	6	\N	6	699	8059499343
pass	7	\N	7	699	1159745290
pass	7	\N	7	699	9317774013
pass	8	\N	8	699	7355628244
pass	8	\N	8	699	6384029909
pass	9	\N	9	699	9748940629
pass	8	\N	8	699	9841446787
pass	6	\N	6	699	7255502811
pass	10	\N	10	699	3016845062
pass	8	\N	8	699	9233579786
pass	5	\N	5	699	1817917498
pass	5	\N	5	699	8551158753
pass	5	\N	5	699	3085959185
pass	7	\N	7	699	6617149232
pass	10	\N	10	699	2386221689
pass	7	\N	7	699	2873901649
pass	5	\N	5	699	6330164908
pass	9	\N	9	699	9348345948
pass	9	5	9	701	9348345948
pass	6	3	6	701	4093232471
pass	7	2	7	701	5933956657
pass	10	4	10	701	8551158753
pass	6	3	6	701	2845989136
pass	7	1	7	701	9748940629
pass	8	5	8	701	5448295898
pass	8	3	8	701	7355628244
pass	8	5	8	701	3943621761
pass	8	4	8	701	4414389290
pass	9	2	9	701	2340861465
pass	5	5	5	701	4547734968
pass	5	5	5	701	2268041682
pass	5	3	5	701	3661714372
pass	5	3	5	701	8633941564
pass	9	2	9	701	5315363834
pass	8	5	8	701	2456626264
pass	6	2	6	701	5383048297
pass	5	1	5	701	7611391463
pass	5	4	5	701	4141651461
pass	7	3	7	701	6368086134
pass	5	2	5	701	8140626094
pass	5	5	5	701	8048161591
pass	6	4	6	701	3207392350
pass	8	5	8	701	1292902580
pass	6	4	6	701	1006258297
pass	9	1	9	701	1077861304
pass	5	2	5	701	5243886166
pass	7	\N	7	705	1006258297
pass	9	\N	9	705	5589427861
pass	5	\N	5	705	5081927005
pass	8	2	8	707	5081927005
pass	5	5	5	707	3391566195
pass	8	10	9	661	6176099606
pass	5	10	9	661	8801072434
pass	8	10	9	661	4835238140
pass	9	10	9	661	1002017775
pass	6	10	9	661	1908920784
pass	6	8	7	664	6330164908
pass	6	9	7	664	9348345948
pass	6	5	5	664	2386221689
pass	6	6	6	664	8551158753
pass	5	7	6	664	9233579786
pass	8	6	6	664	3016845062
pass	9	6	7	664	2845989136
pass	8	7	7	664	7255502811
pass	10	5	6	664	5448295898
pass	4	9	7	664	6384029909
pass	9	4	5	664	7355628244
pass	9	8	8	664	1159745290
pass	9	9	9	664	8059499343
pass	8	7	7	664	6176099606
pass	4	9	7	664	3943621761
pass	9	7	7	664	2340861465
pass	6	8	7	664	2219330822
pass	7	10	8	664	9787942463
pass	9	4	5	664	4225647938
pass	9	5	6	664	8926993958
pass	8	4	5	664	8801072434
pass	7	6	6	664	8633941564
pass	6	5	5	664	7344446165
pass	10	8	8	664	7342428390
pass	10	8	8	664	5393150884
pass	5	5	5	664	4364910715
pass	9	5	6	664	6130521884
pass	8	6	6	664	6224284619
pass	10	5	6	664	9296128900
pass	9	9	9	664	2883399736
pass	5	9	7	664	2429992163
pass	7	8	7	664	4835238140
pass	6	8	7	664	2724290938
pass	8	8	8	664	9866654321
pass	6	7	6	664	2627845789
pass	10	6	7	664	2647025193
pass	8	6	6	664	8519900776
pass	10	7	8	664	5298653978
pass	5	8	6	664	3466969247
pass	9	4	5	664	2539403312
pass	7	9	8	664	5027772807
pass	7	4	5	664	2127379383
pass	4	6	5	664	1002017775
pass	10	3	5	664	7611391463
pass	10	5	6	664	4141651461
pass	10	5	6	664	2678213354
pass	10	5	6	664	1908920784
pass	5	8	6	664	1677623273
pass	8	9	8	664	3885371670
pass	5	8	6	664	8048161591
pass	5	5	5	664	6123973547
pass	8	10	9	664	9544567295
pass	9	5	6	664	3911487577
pass	5	9	7	664	7242749087
pass	4	8	6	664	5081927005
pass	10	9	9	664	3391566195
pass	6	10	8	666	7036854232
pass	7	4	5	666	5933956657
pass	8	7	7	666	6330164908
pass	7	7	7	666	9233579786
pass	9	3	5	666	5889444376
pass	7	9	8	666	5448295898
pass	8	6	6	666	6384029909
pass	7	7	7	666	7355628244
pass	5	6	5	666	8059499343
pass	5	9	7	666	5844381454
pass	5	8	6	666	6176099606
pass	8	3	5	666	4414389290
pass	10	8	8	666	2219330822
pass	5	6	5	666	8065990477
pass	5	10	7	666	2268041682
pass	5	8	6	666	8926993958
pass	7	8	7	666	3661714372
pass	7	6	6	666	8801072434
pass	7	4	5	666	8633941564
pass	7	6	6	666	7344446165
pass	9	9	9	666	7506562181
pass	9	7	7	666	7342428390
pass	6	6	6	666	1974342255
pass	10	8	8	666	6224284619
pass	7	8	7	666	2883399736
pass	8	6	6	666	7848264486
pass	8	7	7	666	2429992163
pass	8	3	5	666	2627845789
pass	6	6	6	666	2431388358
pass	9	4	6	666	8519900776
pass	7	8	7	666	5404276104
pass	8	5	6	666	2539403312
pass	5	5	5	666	5027772807
pass	10	10	10	666	2456626264
pass	10	10	10	666	5383048297
pass	7	9	8	666	1002017775
pass	9	3	5	666	4141651461
pass	8	9	8	666	9262628998
pass	5	6	5	666	1677623273
pass	10	4	6	666	8048161591
pass	7	7	7	666	1292902580
pass	7	5	5	666	9544567295
pass	9	8	8	666	9980820595
pass	7	8	7	666	6023433046
pass	8	4	5	666	5589427861
pass	9	5	6	666	1077861304
pass	9	7	7	666	5243886166
pass	6	9	6	669	5589427861
pass	9	2	6	669	8163254157
pass	6	6	6	669	3391566195
pass	6	5	5	669	5243886166
pass	7	9	8	681	5081927005
pass	4	9	7	681	8163254157
pass	7	10	8	686	9825289323
pass	7	7	7	701	7671026373
pass	9	6	8	701	2873901649
pass	5	10	5	701	1817917498
pass	6	7	6	701	9841446787
pass	6	10	6	701	8329970500
pass	9	8	8	701	9317774013
pass	8	8	8	701	8059499343
pass	10	10	10	701	4225647938
pass	7	9	7	701	8065990477
pass	9	6	8	701	3004542348
pass	7	7	7	701	7342428390
pass	9	7	8	701	1974342255
pass	5	7	5	701	6130521884
pass	6	6	6	701	9296128900
pass	8	10	8	701	2429992163
pass	7	8	7	701	2627845789
pass	5	9	5	701	1322087026
pass	7	6	6	701	2647025193
pass	7	9	7	701	3466969247
pass	6	8	6	701	2539403312
pass	8	9	8	701	5027772807
pass	10	7	9	701	1002017775
pass	5	6	5	701	9262628998
pass	6	8	6	701	2678213354
pass	8	7	7	701	7604634123
pass	7	9	7	701	1908920784
pass	6	6	6	701	3885371670
pass	6	7	6	701	9544567295
pass	8	8	8	701	3911487577
pass	9	9	9	701	7242749087
pass	10	7	9	701	6052931528
pass	5	7	5	701	5081927005
pass	5	8	5	701	3391566195
pass	7	9	7	707	5589427861
pass	7	9	7	707	5243886166
pass	10	7	8	666	9825289323
pass	7	7	7	707	9825289323
fail	1	2	1	544	1077861304
fail	4	7	4	534	8163254157
fail	4	\N	4	539	3391566195
fail	4	8	4	661	6330164908
fail	1	3	1	661	4093232471
fail	3	9	3	661	7671026373
fail	1	8	1	661	7036854232
fail	1	7	1	661	5889444376
fail	3	5	3	661	3016845062
fail	3	3	3	661	7255502811
fail	4	2	4	661	9841446787
fail	3	1	3	661	5448295898
fail	1	8	1	661	6384029909
fail	2	2	2	661	8059499343
fail	2	5	2	661	1791886249
fail	2	9	2	661	3943621761
fail	2	3	2	661	2219330822
fail	4	5	4	661	9713015670
fail	3	6	3	661	9787942463
fail	3	5	3	661	2268041682
fail	4	9	4	661	3661714372
fail	4	6	4	661	8633941564
fail	3	8	3	661	7342428390
fail	2	4	2	661	4364910715
fail	2	7	2	661	6224284619
fail	1	2	1	661	2883399736
fail	2	7	2	661	2724290938
fail	2	1	2	661	9866654321
fail	3	7	3	661	2431388358
fail	2	2	2	661	1322087026
fail	2	4	2	661	2647025193
fail	1	3	1	661	5404276104
fail	4	8	4	661	2539403312
fail	4	5	4	661	5027772807
fail	3	3	3	661	2456626264
fail	3	8	3	661	5383048297
fail	4	8	4	661	4141651461
fail	2	4	2	661	6368086134
fail	1	2	1	661	2678213354
fail	4	4	4	661	3885371670
fail	1	4	1	661	2563337837
fail	3	9	3	661	9544567295
fail	4	5	4	661	6023433046
fail	3	7	3	661	6052931528
fail	3	9	3	661	5081927005
fail	1	3	1	661	1006258297
fail	2	9	2	661	8163254157
fail	3	3	3	661	3391566195
fail	2	6	2	661	2873901649
fail	1	4	1	661	3085959185
fail	3	5	3	661	1817917498
fail	1	5	1	664	5933956657
fail	3	5	3	664	4093232471
fail	2	8	2	664	7671026373
fail	2	8	2	664	7036854232
fail	3	1	3	664	2873901649
fail	2	8	2	664	6617149232
fail	2	2	2	664	3085959185
fail	1	10	1	664	1817917498
fail	2	4	2	664	9748940629
fail	2	4	2	664	8329970500
fail	1	4	1	664	9317774013
fail	3	4	3	664	1791886249
fail	3	5	3	664	4414389290
fail	2	4	2	664	3661714372
fail	3	4	3	664	3004542348
fail	2	2	2	664	1974342255
fail	3	8	3	664	7848264486
fail	1	9	1	664	2431388358
fail	2	7	2	664	1322087026
fail	2	3	2	664	2456626264
fail	3	9	3	664	6368086134
fail	3	8	3	664	8140626094
fail	3	4	3	664	2563337837
fail	3	7	3	664	3207392350
fail	3	3	3	664	1292902580
fail	2	8	2	664	9980820595
fail	2	8	2	664	6052931528
fail	1	2	1	664	1006258297
fail	3	7	3	664	5243886166
fail	2	\N	2	665	7242749087
fail	2	\N	2	665	8048161591
fail	2	\N	2	665	1677623273
fail	3	\N	3	665	7412729163
fail	3	\N	3	665	9262628998
fail	3	\N	3	665	6368086134
fail	4	\N	4	665	1002017775
fail	1	\N	1	665	2127379383
fail	3	\N	3	665	5383048297
fail	4	\N	4	665	5027772807
fail	3	\N	3	665	3466969247
fail	3	\N	3	665	5404276104
fail	2	\N	2	665	8519900776
fail	3	\N	3	665	1322087026
fail	2	\N	2	665	2627845789
fail	2	\N	2	665	9866654321
fail	4	\N	4	665	2724290938
fail	4	\N	4	665	4835238140
fail	4	\N	4	665	5315363834
fail	1	\N	1	665	6224284619
fail	1	\N	1	665	4364910715
fail	2	\N	2	665	3661714372
fail	1	\N	1	665	2268041682
fail	3	\N	3	665	9787942463
fail	2	\N	2	665	4547734968
fail	3	\N	3	665	4414389290
fail	4	\N	4	665	8059499343
fail	4	\N	4	665	1159745290
fail	1	\N	1	665	7355628244
fail	3	\N	3	665	5672398895
fail	3	\N	3	665	3016845062
fail	2	\N	2	665	6617149232
fail	4	\N	4	665	2386221689
fail	4	\N	4	665	7671026373
fail	4	6	4	666	9348345948
fail	2	9	2	666	7671026373
fail	2	10	2	666	4093232471
fail	4	3	4	666	2873901649
fail	2	6	2	666	6617149232
fail	2	9	2	666	3085959185
fail	3	5	3	666	8160573746
fail	3	1	3	666	8551158753
fail	4	9	4	666	1817917498
fail	1	5	1	666	3016845062
fail	3	3	3	666	2845989136
fail	3	9	3	666	7255502811
fail	2	9	2	666	5672398895
fail	1	9	1	666	9841446787
fail	4	2	4	666	9748940629
fail	4	8	4	666	9317774013
fail	4	7	4	666	1159745290
fail	3	7	3	666	1791886249
fail	4	4	4	666	9787942463
fail	3	7	3	666	4225647938
fail	3	4	3	666	7387590646
fail	2	6	2	666	4364910715
fail	2	2	2	666	6130521884
fail	3	2	3	666	9296128900
fail	4	8	4	666	5315363834
fail	2	6	2	666	4835238140
fail	2	6	2	666	1322087026
fail	3	5	3	666	2647025193
fail	4	8	4	666	5298653978
fail	3	5	3	666	3466969247
fail	2	5	2	666	2127379383
fail	2	8	2	666	8140626094
fail	2	4	2	666	2678213354
fail	1	10	1	666	1908920784
fail	4	4	4	666	7412729163
fail	4	2	4	666	3885371670
fail	2	4	2	666	6123973547
fail	2	7	2	666	2563337837
fail	2	4	2	666	3207392350
fail	3	2	3	666	3911487577
fail	2	7	2	666	7242749087
fail	2	9	2	666	6052931528
fail	2	4	2	666	5081927005
fail	4	5	4	666	1006258297
fail	3	1	3	666	8163254157
fail	4	2	4	666	3391566195
fail	3	7	3	669	5081927005
fail	3	4	3	669	1006258297
fail	1	2	1	669	1077861304
fail	4	\N	4	676	3085959185
fail	3	\N	3	676	6330164908
fail	4	\N	4	676	5933956657
fail	3	\N	3	676	4093232471
fail	4	\N	4	676	9348345948
fail	2	\N	2	676	7242749087
fail	1	\N	1	676	3911487577
fail	1	\N	1	676	3885371670
fail	2	\N	2	676	7412729163
fail	4	\N	4	676	1908920784
fail	2	\N	2	676	2678213354
fail	3	\N	3	676	8140626094
fail	1	\N	1	676	4141651461
fail	2	\N	2	676	1002017775
fail	4	\N	4	676	5383048297
fail	2	\N	2	676	2539403312
fail	2	\N	2	676	5298653978
fail	4	\N	4	676	8519900776
fail	2	\N	2	676	2431388358
fail	4	\N	4	676	2429992163
fail	2	\N	2	676	7848264486
fail	2	\N	2	676	2883399736
fail	3	\N	3	676	7342428390
fail	2	\N	2	676	8633941564
fail	2	\N	2	676	7387590646
fail	3	\N	3	676	8801072434
fail	2	\N	2	676	4225647938
fail	3	\N	3	676	9787942463
fail	2	\N	2	676	9713015670
fail	3	\N	3	676	2340861465
fail	4	\N	4	676	6176099606
fail	2	\N	2	676	5844381454
fail	4	\N	4	676	8059499343
fail	2	\N	2	676	1159745290
fail	2	\N	2	676	6384029909
fail	4	\N	4	676	5448295898
fail	4	\N	4	676	8329970500
fail	1	\N	1	676	7255502811
fail	3	\N	3	676	3016845062
fail	3	\N	3	677	5243886166
fail	2	\N	2	677	8163254157
fail	2	\N	2	677	1077861304
fail	2	\N	2	677	6023433046
fail	3	\N	3	677	3911487577
fail	1	\N	1	677	9544567295
fail	4	\N	4	677	1292902580
fail	2	\N	2	677	3207392350
fail	2	\N	2	677	6123973547
fail	4	\N	4	677	8048161591
fail	3	\N	3	677	8140626094
fail	3	\N	3	677	9262628998
fail	2	\N	2	677	7611391463
fail	1	\N	1	677	2127379383
fail	2	\N	2	677	2539403312
fail	4	\N	4	677	5298653978
fail	2	\N	2	677	1322087026
fail	3	\N	3	677	2431388358
fail	3	\N	3	677	2883399736
fail	3	\N	3	677	8525887759
fail	2	\N	2	677	6130521884
fail	4	\N	4	677	5393150884
fail	4	\N	4	677	7506562181
fail	4	\N	4	677	3004542348
fail	2	\N	2	677	7344446165
fail	4	\N	4	677	7387590646
fail	2	\N	2	677	2268041682
fail	1	\N	1	677	2219330822
fail	3	\N	3	677	2340861465
fail	1	\N	1	677	1791886249
fail	3	\N	3	677	7355628244
fail	1	\N	1	677	9748940629
fail	2	\N	2	677	5672398895
fail	3	\N	3	677	3016845062
fail	2	\N	2	677	5889444376
fail	1	\N	1	677	8551158753
fail	4	\N	4	677	8160573746
fail	4	\N	4	677	6330164908
fail	1	\N	1	677	4093232471
fail	3	\N	3	677	7671026373
fail	2	4	2	681	5589427861
fail	2	2	2	681	3391566195
fail	2	7	2	681	5243886166
fail	4	1	4	681	9825289323
fail	4	4	4	686	5081927005
fail	2	6	2	686	5589427861
fail	3	2	3	686	1077861304
fail	4	5	4	686	8163254157
fail	2	9	2	686	3391566195
fail	3	3	3	686	5243886166
fail	1	\N	1	687	6023433046
fail	4	\N	4	687	9544567295
fail	4	\N	4	687	1292902580
fail	2	\N	2	687	8048161591
fail	2	\N	2	687	3885371670
fail	4	\N	4	687	2678213354
fail	3	\N	3	687	6368086134
fail	2	\N	2	687	7611391463
fail	2	\N	2	687	2456626264
fail	3	\N	3	687	5027772807
fail	2	\N	2	687	2539403312
fail	3	\N	3	687	5298653978
fail	4	\N	4	687	8519900776
fail	2	\N	2	687	2431388358
fail	2	\N	2	687	2627845789
fail	2	\N	2	687	7848264486
fail	4	\N	4	687	2883399736
fail	2	\N	2	687	8525887759
fail	4	\N	4	687	9296128900
fail	1	\N	1	687	6224284619
fail	2	\N	2	687	1974342255
fail	2	\N	2	687	4364910715
fail	3	\N	3	687	7342428390
fail	1	\N	1	687	7506562181
fail	4	\N	4	687	3004542348
fail	3	\N	3	687	8633941564
fail	3	\N	3	687	3661714372
fail	3	\N	3	687	2268041682
fail	3	\N	3	687	9787942463
fail	3	\N	3	687	4547734968
fail	4	\N	4	687	6176099606
fail	2	\N	2	687	1791886249
fail	2	\N	2	687	9317774013
fail	4	\N	4	687	7355628244
fail	2	\N	2	687	9748940629
fail	1	\N	1	687	9841446787
fail	4	\N	4	687	3016845062
fail	3	\N	3	687	9233579786
fail	4	\N	4	687	1817917498
fail	4	\N	4	687	8160573746
fail	1	\N	1	687	3085959185
fail	4	\N	4	687	2873901649
fail	2	\N	2	687	5933956657
fail	2	\N	2	687	7671026373
fail	4	\N	4	692	7242749087
fail	2	\N	2	692	6023433046
fail	4	\N	4	692	2563337837
fail	3	\N	3	692	8048161591
fail	4	\N	4	692	1677623273
fail	4	\N	4	692	1908920784
fail	2	\N	2	692	9262628998
fail	3	\N	3	692	4141651461
fail	3	\N	3	692	1002017775
fail	3	\N	3	692	2456626264
fail	3	\N	3	692	5027772807
fail	4	\N	4	692	3466969247
fail	3	\N	3	692	5298653978
fail	2	\N	2	692	8519900776
fail	2	\N	2	692	2431388358
fail	3	\N	3	692	9866654321
fail	1	\N	1	692	2724290938
fail	4	\N	4	692	7848264486
fail	3	\N	3	692	4364910715
fail	4	\N	4	692	5393150884
fail	2	\N	2	692	3004542348
fail	3	\N	3	692	2268041682
fail	1	\N	1	692	8065990477
fail	2	\N	2	692	9787942463
fail	4	\N	4	692	4547734968
fail	1	\N	1	692	2219330822
fail	3	\N	3	692	2340861465
fail	2	\N	2	692	5844381454
fail	2	\N	2	692	8059499343
fail	2	\N	2	692	5448295898
fail	4	\N	4	692	8329970500
fail	3	\N	3	692	9841446787
fail	2	\N	2	692	2845989136
fail	2	\N	2	692	3016845062
fail	2	\N	2	692	3085959185
fail	3	\N	3	692	2386221689
fail	1	\N	1	692	2873901649
fail	4	\N	4	692	4093232471
fail	4	\N	4	692	7671026373
fail	3	\N	3	692	7036854232
fail	1	\N	1	699	6052931528
fail	4	\N	4	699	7242749087
fail	4	\N	4	699	6023433046
fail	1	\N	1	699	9980820595
fail	4	\N	4	699	9544567295
fail	1	\N	1	699	3207392350
fail	2	\N	2	699	2563337837
fail	3	\N	3	699	6123973547
fail	3	\N	3	699	8048161591
fail	4	\N	4	699	1908920784
fail	4	\N	4	699	7604634123
fail	2	\N	2	699	9262628998
fail	3	\N	3	699	4141651461
fail	1	\N	1	699	1002017775
fail	1	\N	1	699	2127379383
fail	2	\N	2	699	2456626264
fail	1	\N	1	699	3466969247
fail	2	\N	2	699	2647025193
fail	3	\N	3	699	1322087026
fail	4	\N	4	699	2431388358
fail	2	\N	2	699	2627845789
fail	3	\N	3	699	9866654321
fail	1	\N	1	699	4835238140
fail	3	\N	3	699	2429992163
fail	4	\N	4	699	5315363834
fail	2	\N	2	699	9296128900
fail	4	\N	4	699	1974342255
fail	4	\N	4	699	7342428390
fail	2	\N	2	699	8633941564
fail	4	\N	4	699	7387590646
fail	2	\N	2	699	8926993958
fail	3	\N	3	699	9713015670
fail	3	\N	3	699	4547734968
fail	2	\N	2	699	2340861465
fail	2	\N	2	699	4414389290
fail	2	\N	2	699	5448295898
fail	1	\N	1	699	8329970500
fail	4	\N	4	699	5672398895
fail	2	\N	2	699	2845989136
fail	3	\N	3	699	5889444376
fail	3	\N	3	699	8160573746
fail	2	\N	2	699	5933956657
fail	1	\N	1	699	4093232471
fail	3	\N	3	699	7671026373
fail	4	\N	4	699	7036854232
fail	2	6	2	701	7036854232
fail	2	6	2	701	6330164908
fail	2	8	2	701	2386221689
fail	4	3	4	701	6617149232
fail	4	4	4	701	3085959185
fail	3	8	3	701	8160573746
fail	2	6	2	701	9233579786
fail	3	2	3	701	5889444376
fail	1	7	1	701	5672398895
fail	1	5	1	701	1159745290
fail	2	8	2	701	1791886249
fail	3	4	3	701	5844381454
fail	2	2	2	701	6176099606
fail	1	7	1	701	2219330822
fail	2	5	2	701	9713015670
fail	2	2	2	701	9787942463
fail	2	3	2	701	8926993958
fail	2	5	2	701	8801072434
fail	1	4	1	701	7387590646
fail	3	9	3	701	7344446165
fail	3	9	3	701	7506562181
fail	1	3	1	701	5393150884
fail	2	3	2	701	4364910715
fail	3	4	3	701	6224284619
fail	3	9	3	701	8525887759
fail	4	5	4	701	7848264486
fail	3	8	3	701	4835238140
fail	4	5	4	701	9866654321
fail	1	7	1	701	2431388358
fail	3	4	3	701	8519900776
fail	4	4	4	701	5298653978
fail	4	1	4	701	5404276104
fail	3	7	3	701	2127379383
fail	2	8	2	701	7412729163
fail	1	8	1	701	1677623273
fail	4	2	4	701	6123973547
fail	3	3	3	701	9980820595
fail	1	8	1	701	6023433046
fail	3	3	3	701	5589427861
fail	2	4	2	701	8163254157
fail	2	\N	2	705	9825289323
fail	2	\N	2	705	3391566195
fail	3	\N	3	705	8163254157
fail	2	\N	2	705	1077861304
fail	2	2	2	707	1006258297
fail	4	4	4	707	1077861304
fail	2	6	2	707	8163254157
fail	10	2	4	664	8160573746
fail	6	3	4	664	5889444376
fail	4	2	2	664	5672398895
fail	7	3	4	664	9841446787
fail	8	3	4	664	5844381454
fail	4	5	4	664	4547734968
fail	6	4	4	664	8065990477
fail	8	2	4	664	2268041682
fail	4	2	2	664	7387590646
fail	4	4	4	664	7506562181
fail	6	2	3	664	5404276104
fail	8	3	4	664	9262628998
fail	9	2	4	664	6023433046
fail	4	4	4	664	5589427861
fail	4	4	4	664	1077861304
fail	4	5	4	664	8163254157
fail	7	3	4	666	8329970500
fail	7	3	4	666	2340861465
fail	6	3	4	666	4547734968
fail	5	4	4	666	3004542348
fail	6	3	4	666	2724290938
fail	5	4	4	666	7611391463
fail	4	6	4	701	3016845062
fail	4	9	4	701	7255502811
fail	4	8	4	701	6384029909
fail	4	7	4	701	2883399736
fail	4	7	4	701	2724290938
fail	4	7	4	701	2563337837
fail	2	3	2	664	9825289323
fail	1	3	1	669	9825289323
fail	4	9	4	701	9825289323
\.


--
-- Data for Name: Sector; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public."Sector" (sector_code, sector_title, sector_description) FROM stdin;
1	Τομέας Πληροφορικής                                                                                 	Ο τομέας καλύπτει γνώσεις σε βασικές αρχές της πληροφορικής (προγραμματισμός, λειτουργικάσυστήματα, βάσεις δεδομένων, αλγόριθμοι, τεχνολογία λογισμικού)
2	Τομέας Ηλεκτρονικής και Αρχιτεκτονικής των Υπολογιστών                                              	Ο τομέας καλύπτει γνώσεις σε σχεδιασμό, υλοποίηση και ανάλυση αναλογικών και ψηφιακών ηλεκτρικών, ηλεκτρονικών συστημάτων
3	Τομέας Συστημάτων                                                                                   	Ο τομέας καλύπτει γνώσεις σε θεωρία συστημάτων (αυτόματο και βέλτιστος έλεγχος, νευρωνικάδίκτυα, ασαφής λογική) και εφαρμογές τους (βιοϊατρική, έλεγχος ποιότητας)
4	Τομέας Τηλεπικοινωνιών                                                                              	Ο τομέας καλύπτει γνώσεις σε τηλεπικοινωνιακά συστήματα (τηλεφωνικά, δικτυακά, ασύρματα) και επεξεργασία πληροφορίας (ήχος, φωνή, εικόνα, δεδομένα) 
5	Τομέας Συστημάτων Ηλεκτρικής Ενέργειας                                                              	Ο τομέας καλύπτει γνώσεις σε συμβατικά και μοντέρνα συστήματα παραγωγής, αποθήκευσης, διανομής και διαχείρισης ενέργειας 
\.


--
-- Data for Name: Semester; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public."Semester" (semester_id, start_date, end_date, semester_status, academic_season, academic_year) FROM stdin;
1	2011-05-01	2011-05-28	past	winter	2011
5	2011-05-31	2012-05-31	past	spring	2011
6	2013-05-01	2013-05-30	past	winter	2013
7	2014-05-01	2014-05-09	past	spring	2014
8	2015-05-01	2015-05-30	past	winter	2015
9	2019-05-01	2019-05-31	past	spring	2016
10	2020-05-01	2020-05-30	past	winter	2020
11	2021-05-01	2021-05-12	past	spring	2021
12	2022-05-02	2022-05-25	past	winter	2022
13	2023-05-01	2023-05-31	present	spring	2023
\.


--
-- Data for Name: Students; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public."Students" (entry_date, am, amka) FROM stdin;
2012-10-10	2012100000	9825289323
2012-10-10	2012100001	5243886166
2012-10-10	2012100004	3391566195
2012-10-10	2012100006	8163254157
2012-10-10	2012100008	1077861304
2012-10-10	2012100009	1006258297
2013-10-11	2012100002	5589427861
2010-10-13	2012100003	5081927005
2019-07-01	2019100000	6052931528
2019-07-01	2019100001	7242749087
2019-07-01	2019100002	6023433046
2019-07-01	2019100003	3911487577
2019-07-01	2019100004	9980820595
2019-07-01	2019100005	9544567295
2019-07-01	2019100006	1292902580
2019-07-01	2019100007	3207392350
2019-07-01	2019100008	2563337837
2019-07-01	2019100009	6123973547
2019-07-01	2019100010	8048161591
2019-07-01	2019100011	3885371670
2019-07-01	2019100012	1677623273
2019-07-01	2019100013	7412729163
2019-07-01	2019100014	1908920784
2019-07-01	2019100015	7604634123
2019-07-01	2019100016	2678213354
2019-07-01	2019100017	8140626094
2019-07-01	2019100018	9262628998
2019-07-01	2019100019	6368086134
2019-07-01	2019100020	4141651461
2019-07-01	2019100021	7611391463
2019-07-01	2019100022	1002017775
2019-07-01	2019100023	2127379383
2019-07-01	2019100024	5383048297
2019-07-01	2019100025	2456626264
2019-07-01	2019100026	5027772807
2019-07-01	2019100027	2539403312
2019-07-01	2019100028	3466969247
2019-07-01	2019100029	5404276104
2019-07-01	2019100030	5298653978
2019-07-01	2019100031	8519900776
2019-07-01	2019100032	2647025193
2019-07-01	2019100033	1322087026
2019-07-01	2019100034	2431388358
2019-07-01	2019100035	2627845789
2019-07-01	2019100036	9866654321
2019-07-01	2019100037	2724290938
2019-07-01	2019100038	4835238140
2019-07-01	2019100039	2429992163
2019-07-01	2019100040	7848264486
2019-07-01	2019100041	2883399736
2019-07-01	2019100042	5315363834
2019-07-01	2019100043	8525887759
2019-07-01	2019100044	9296128900
2019-07-01	2019100045	6224284619
2019-07-01	2019100046	6130521884
2019-07-01	2019100047	1974342255
2019-07-01	2019100048	4364910715
2019-07-01	2019100049	5393150884
2019-07-01	2019100050	7342428390
2019-07-01	2019100051	7506562181
2019-07-01	2019100052	3004542348
2019-07-01	2019100053	7344446165
2019-07-01	2019100054	8633941564
2019-07-01	2019100055	7387590646
2019-07-01	2019100056	8801072434
2019-07-01	2019100057	3661714372
2019-07-01	2019100058	8926993958
2019-07-01	2019100059	2268041682
2019-07-01	2019100060	8065990477
2019-07-01	2019100061	4225647938
2019-07-01	2019100062	9787942463
2019-07-01	2019100063	9713015670
2019-07-01	2019100064	4547734968
2019-07-01	2019100065	2219330822
2019-07-01	2019100066	2340861465
2019-07-01	2019100067	4414389290
2019-07-01	2019100068	3943621761
2019-07-01	2019100069	6176099606
2019-07-01	2019100070	5844381454
2019-07-01	2019100071	1791886249
2019-07-01	2019100072	8059499343
2019-07-01	2019100073	1159745290
2019-07-01	2019100074	9317774013
2019-07-01	2019100075	7355628244
2019-07-01	2019100076	6384029909
2019-07-01	2019100077	5448295898
2019-07-01	2019100078	8329970500
2019-07-01	2019100079	9748940629
2019-07-01	2019100080	9841446787
2019-07-01	2019100081	5672398895
2019-07-01	2019100082	7255502811
2019-07-01	2019100083	2845989136
2019-07-01	2019100084	3016845062
2019-07-01	2019100085	5889444376
2019-07-01	2019100086	9233579786
2019-07-01	2019100087	1817917498
2019-07-01	2019100088	8551158753
2019-07-01	2019100089	8160573746
2019-07-01	2019100090	3085959185
2019-07-01	2019100091	6617149232
2019-07-01	2019100092	2386221689
2019-07-01	2019100093	2873901649
2019-07-01	2019100094	6330164908
2019-07-01	2019100095	5933956657
2019-07-01	2019100096	4093232471
2019-07-01	2019100097	7671026373
2019-07-01	2019100098	9348345948
2019-07-01	2019100099	7036854232
\.


--
-- Data for Name: Supports; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public."Supports" (courserun_serial_number, labstaff_amka) FROM stdin;
318	9237022162
319	5016674518
320	4244532307
321	2809479422
\.


--
-- Data for Name: Surname; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public."Surname" (surname) FROM stdin;
ΑΒΑΓΙΑΝΝΗΣ                                        
ΑΒΑΓΙΑΝΝΟΣ                                        
ΑΒΑΓΙΑΝΟΣ                                         
ΑΒΑΖΑΡΟΣ                                          
ΑΒΑΖΟΣ                                            
ΑΒΑΚΟΜΙΔΗΣ                                        
ΑΒΑΚΟΥΜΙΔΗΣ                                       
ΑΒΑΛΗΣ                                            
ΑΒΑΛΙΩΤΗΣ                                         
ΑΒΑΝΕΑΣ                                           
ΑΒΑΝΕΣΙΔΗΣ                                        
ΑΒΑΝΗΣ                                            
ΑΒΑΝΙΑΔΗΣ                                         
ΑΒΑΝΙΔΗΣ                                          
ΑΒΑΝΤΗΣ                                           
ΑΒΑΡΑΚΗΣ                                          
ΑΒΑΡΑΣ                                            
ΑΒΑΡΙΚΙΩΤΗΣ                                       
ΑΒΑΡΙΤΣΙΩΤΗΣ                                      
ΑΒΑΡΚΙΩΤΗΣ                                        
ΑΒΑΡΛΗΣ                                           
ΑΒΑΣΗΣ                                            
ΑΒΑΣΚΑΝΤΗΡΑΣ                                      
ΑΒΑΣΤΑΓΟΣ                                         
ΑΒΑΤΑΓΓΕΛΟΣ                                       
ΑΒΑΤΑΤΣΟΣ                                         
ΑΒΑΤΖΑΚΗΣ                                         
ΑΒΑΤΖΗΣ                                           
ΑΒΑΤΖΙΑΔΗΣ                                        
ΑΒΒΑΚΟΥΜΙΔΗΣ                                      
ΑΒΒΑΝΙΔΗΣ                                         
ΑΒΔΑΛΑΣ                                           
ΑΒΔΑΜΑΛΙΝΟΣ                                       
ΑΒΔΑΝΑΣ                                           
ΑΒΔΑΡΜΑΝΗΣ                                        
ΑΒΔΕΛΑΡΟΣ                                         
ΑΒΔΕΛΑΣ                                           
ΑΒΔΕΛΕΛΛΗΣ                                        
ΑΒΔΕΛΙΑΔΗΣ                                        
ΑΒΔΕΛΙΔΗΣ                                         
ΑΒΔΕΛΙΩΔΗΣ                                        
ΑΒΔΕΛΙΩΤΗΣ                                        
ΑΒΔΕΛΛΑΣ                                          
ΑΒΔΕΛΛΗΣ                                          
ΑΒΔΕΛΛΙΔΗΣ                                        
ΑΒΔΕΛΟΠΟΥΛΟΣ                                      
ΑΒΔΗΜΙΩΤΗΣ                                        
ΑΒΔΙΚΟΣ                                           
ΑΒΔΙΜΙΩΤΗΣ                                        
ΑΒΔΟΣ                                             
ΑΒΔΟΥΛΑΣ                                          
ΑΒΔΟΥΛΗΣ                                          
ΑΒΔΟΥΛΙΔΗΣ                                        
ΑΒΔΟΥΛΟΣ                                          
ΑΒΔΟΥΣΗΣ                                          
ΑΒΕΖΑΓΓΕΛΗΣ                                       
ΑΒΕΚΛΟΥΡΗΣ                                        
ΑΒΕΚΛΟΥΡΙΟΣ                                       
ΑΒΕΛΑΣ                                            
ΑΒΕΛΙΔΗΣ                                          
ΑΒΕΛΛΑΣ                                           
ΑΒΕΝΙΔΗΣ                                          
ΑΒΕΡΕΝΟΣ                                          
ΑΒΕΡΗΣ                                            
ΑΒΕΡΚΑΚΗΣ                                         
ΑΒΕΡΚΙΑΔΗΣ                                        
ΑΒΕΡΚΟΣ                                           
ΑΒΕΡΟΠΟΥΛΟΣ                                       
ΑΒΕΡΤΙΔΗΣ                                         
ΑΒΕΣΤΑΣ                                           
ΑΒΕΤΙΔΗΣ                                          
ΑΒΕΤΣΙΑΝΟΣ                                        
ΑΒΗΤΙΔΗΣ                                          
ΑΒΙΔΙΔΗΣ                                          
ΑΒΙΖΙΩΤΗΣ                                         
ΑΒΙΣΤΟΠΟΥΛΟΣ                                      
ΑΒΙΤΖΗΣ                                           
ΑΒΙΤΙΔΗΣ                                          
ΑΒΛΑΜΗΣ                                           
ΑΒΛΑΜΙΣΟΠΟΥΛΟΣ                                    
ΑΒΛΑΣΤΗΜΙΔΗΣ                                      
ΑΒΛΑΣΤΙΔΗΣ                                        
ΑΒΛΑΣΤΙΜΙΔΗΣ                                      
ΑΒΛΙΧΟΣ                                           
ΑΒΛΟΥΓΙΑΡΗΣ                                       
ΑΒΟΚΑΤΗΣ                                          
ΑΒΟΚΑΤΟΣ                                          
ΑΒΟΡΙΤΗΣ                                          
ΑΒΟΥΖΟΥΚΛΗΣ                                       
ΑΒΟΥΖΟΥΚΛΙΔΗΣ                                     
ΑΒΟΥΚΑΤΟΣ                                         
ΑΒΟΥΡΔΙΑΔΗΣ                                       
ΑΒΟΥΡΗΣ                                           
ΑΒΡΑΑΜΙΔΗΣ                                        
ΑΒΡΑΑΜΚΙΑΣ                                        
ΑΒΡΑΔΑΣ                                           
ΑΒΡΑΔΕΣ                                           
ΑΒΡΑΔΟΠΟΥΛΟΣ                                      
ΑΒΡΑΚΟΔΙΑΝΑΚΗΣ                                    
ΑΒΡΑΚΩΤΟΣ                                         
ΑΒΡΑΜΑΚΗΣ                                         
ΑΒΡΑΜΑΚΟΣ                                         
ΑΒΡΑΜΕΑΣ                                          
ΑΒΡΑΜΕΛΟΣ                                         
ΑΒΡΑΜΗΛΑΣ                                         
ΑΒΡΑΜΗΣ                                           
ΑΒΡΑΜΙΔΗΣ                                         
ΑΒΡΑΜΙΔΗΣ ΠΙΛΙΤΖΟΓΛΟΥ                             
ΑΒΡΑΜΙΔΟΠΟΥΛΟΣ                                    
ΑΒΡΑΜΙΚΑΣ                                         
ΑΒΡΑΜΙΚΟΣ                                         
ΑΒΡΑΜΙΩΤΗΣ                                        
ΑΒΡΑΜΜΙΔΗΣ                                        
ΑΒΡΑΜΟΠΟΥΛΟΣ                                      
ΑΒΡΑΜΟΥΔΑΣ                                        
ΑΒΡΑΜΟΥΔΗΣ                                        
ΑΒΡΑΜΟΥΛΗΣ                                        
ΑΒΡΑΜΟΥΣΗΣ                                        
ΑΒΡΑΜΠΑΚΗΣ                                        
ΑΒΡΑΜΠΟΣ                                          
ΑΒΡΑΝΑΣ                                           
ΑΒΡΑΝΤΑΣ                                          
ΑΒΡΑΝΤΙΝΗΣ                                        
ΑΒΡΑΣ                                             
ΑΒΡΑΤΙΔΗΣ                                         
ΑΒΡΕΛΗΣ                                           
ΑΒΡΕΝΛΗ ΧΑΣΑΝ                                     
ΑΒΡΙΘΗΣ                                           
ΑΒΡΙΩΝΙΔΗΣ                                        
ΑΒΡΟΝΙΔΑΚΗΣ                                       
ΑΒΡΥΩΝΙΔΗΣ                                        
ΑΒΤΖΗ ΑΜΕΤ                                        
ΑΒΤΖΗ ΙΣΜΑΗΛ                                      
ΑΒΤΖΗΓΙΑΝΝΗΣ                                      
ΑΒΤΖΗΚΟΛΙΟΣ                                       
ΑΒΤΖΗΣ                                            
ΑΒΤΖΙΓΙΑΝΝΗΣ                                      
ΑΒΤΖΙΔΗΣ                                          
ΑΒΤΣΙΔΗΣ                                          
ΑΒΥΔΙΑΝΟΣ                                         
ΑΒΨΗ ΑΜΕΤ                                         
ΑΓΑ ΑΓΟΥΔΗ                                        
ΑΓΑ ΧΟΥΣΕΙΝ                                       
ΑΓΑΓΙΩΡΓΗΣ                                        
ΑΓΑΓΙΩΤΗΣ                                         
ΑΓΑΔΑΚΗΣ                                          
ΑΓΑΔΑΚΟΣ                                          
ΑΓΑΔΕΛΗΣ                                          
ΑΓΑΔΕΛΛΗΣ                                         
ΑΓΑΔΗΣ                                            
ΑΓΑΖΑΝΗΣ                                          
ΑΓΑΘΑΓΓΕΛΑΚΗΣ                                     
ΑΓΑΘΑΓΓΕΛΙΔΗΣ                                     
ΑΓΑΘΑΓΓΕΛΟΣ                                       
ΑΓΑΘΑΚΗΣ                                          
ΑΓΑΘΑΝΑΣΗΣ                                        
ΑΓΑΘΑΝΙΔΗΣ                                        
ΑΓΑΘΗΣ                                            
ΑΓΑΘΙΑΔΗΣ                                         
ΑΓΑΘΙΑΣ                                           
ΑΓΑΘΙΔΗΣ                                          
ΑΓΑΘΟΚΛΕΟΥΣ                                       
ΑΓΑΘΟΚΛΗΣ                                         
ΑΓΑΘΟΝΙΑΔΗΣ                                       
ΑΓΑΘΟΝΙΔΗΣ                                        
ΑΓΑΘΟΝΙΚΙΑΔΗΣ                                     
ΑΓΑΘΟΝΙΚΙΔΗΣ                                      
ΑΓΑΘΟΝΙΚΟΠΟΥΛΟΣ                                   
ΑΓΑΘΟΝΙΚΟΣ                                        
ΑΓΑΘΟΠΟΛΙΤΗΣ                                      
ΑΓΑΘΟΠΟΥΛΟΣ                                       
ΑΓΑΘΟΣ                                            
ΑΓΑΘΟΥΛΕΣΗΣ                                       
ΑΓΑΘΩΝΙΔΗΣ                                        
ΑΓΑΘΩΝΟΣ                                          
ΑΓΑΙΤΣΗΣ                                          
ΑΓΑΚΕΧΑΓΙΑΣ                                       
ΑΓΑΚΙΔΗΣ                                          
ΑΓΑΚΟΣ                                            
ΑΓΑΛΑΝΙΩΤΗΣ                                       
ΑΓΑΛΕΡΙΔΗΣ                                        
ΑΓΑΛΗΣ                                            
ΑΓΑΛΙΑΝΟΣ                                         
ΑΓΑΛΙΑΣ                                           
ΑΓΑΛΙΔΗΣ                                          
ΑΓΑΛΙΩΤΗΣ                                         
ΑΓΑΛΛΙΑΔΗΣ                                        
ΑΓΑΛΛΙΑΝΟΣ                                        
ΑΓΑΛΛΟΠΟΥΛΟΣ                                      
ΑΓΑΛΛΟΣ                                           
ΑΓΑΛΟΠΟΥΛΟΣ                                       
ΑΓΑΛΟΣ                                            
ΑΓΑΜΑΛΗΣ                                          
ΑΓΑΝΑΚΗΣ                                          
ΑΓΑΝΑΝΗΣ                                          
ΑΓΑΝΙΔΗΣ                                          
ΑΓΑΝΙΚΟΛΑΣ                                        
ΑΓΑΝΤΑΣ                                           
ΑΓΑΠΑΚΗΣ                                          
ΑΓΑΠΑΛΙΔΗΣ                                        
ΑΓΑΠΑΝΑΓΗΣ                                        
ΑΓΑΠΑΝΑΓΙΩΤΗΣ                                     
ΑΓΑΠΑΠΑΣ                                          
ΑΓΑΠΗΔΑΚΗΣ                                        
ΑΓΑΠΗΝΑΚΗΣ                                        
ΑΓΑΠΗΝΟΣ                                          
ΑΓΑΠΗΣ                                            
ΑΓΑΠΗΤΑΚΗΣ                                        
ΑΓΑΠΗΤΙΔΗΣ                                        
ΑΓΑΠΗΤΟΣ                                          
ΑΓΑΠΙΑΔΗΣ                                         
ΑΓΑΠΙΔΗΣ                                          
ΑΓΑΠΙΟΣ                                           
ΑΓΑΠΙΤΗΣ                                          
ΑΓΑΠΟΠΟΥΛΟΣ                                       
ΑΓΑΠΟΥΔΑΣ                                         
ΑΓΑΠΟΥΛΑΚΗΣ                                       
ΑΓΑΠΟΥΣΗΣ                                         
ΑΓΑΡΤΖΙΔΗΣ                                        
ΑΓΑΣ                                              
ΑΓΑΤΖΙΩΤΗΣ                                        
ΑΓΑΤΙΑΝΟΣ                                         
ΑΓΑΤΣΑΣ                                           
ΑΓΑΤΣΙΔΗΣ                                         
ΑΓΑΤΣΙΩΤΗΣ                                        
ΑΓΑΦΩΝΙΔΗΣ                                        
ΑΓΓΑΘΕΡΗΣ                                         
ΑΓΓΑΝΑΚΗΣ                                         
ΑΓΓΑΝΗΣ                                           
ΑΓΓΑΡΙΔΗΣ                                         
ΑΓΓΑΡΙΤΗΣ                                         
ΑΓΓΑΣ                                             
ΑΓΓΕΙΑΔΗΣ                                         
ΑΓΓΕΙΟΠΛΑΣΤΗΣ                                     
ΑΓΓΕΛΑΔΑΚΗΣ                                       
ΑΓΓΕΛΑΔΑΣ                                         
ΑΓΓΕΛΑΙΝΑΣ                                        
ΑΓΓΕΛΑΚΑΚΗΣ                                       
ΑΓΓΕΛΑΚΑΡΗΣ                                       
ΑΓΓΕΛΑΚΑΡΟΣ                                       
ΑΓΓΕΛΑΚΑΣ                                         
ΑΓΓΕΛΑΚΗΣ                                         
ΑΓΓΕΛΑΚΙΔΗΣ                                       
ΑΓΓΕΛΑΚΙΣ                                         
ΑΓΓΕΛΑΚΟΠΟΥΛΟΣ                                    
ΑΓΓΕΛΑΚΟΣ                                         
ΑΓΓΕΛΑΚΟΥΔΗΣ                                      
ΑΓΓΕΛΑΚΟΥΛΗΣ                                      
ΑΓΓΕΛΑΡΑΣ                                         
ΑΓΓΕΛΑΡΗΣ                                         
ΑΓΓΕΛΑΡΙΔΗΣ                                       
ΑΓΓΕΛΑΡΟΣ                                         
ΑΓΓΕΛΑΣΟΠΟΥΛΟΣ                                    
ΑΓΓΕΛΑΤΟΣ                                         
ΑΓΓΕΛΕΑΣ                                          
ΑΓΓΕΛΕΒΙΤΣ                                        
ΑΓΓΕΛΕΙΔΑΚΗΣ                                      
ΑΓΓΕΛΕΛΗΣ                                         
ΑΓΓΕΛΕΛΛΗΣ                                        
ΑΓΓΕΛΕΡΟΣ                                         
ΑΓΓΕΛΕΤΑΚΗΣ                                       
ΑΓΓΕΛΕΤΑΣ                                         
ΑΓΓΕΛΕΤΑΤΟΣ                                       
ΑΓΓΕΛΕΤΟΠΟΥΛΟΣ                                    
ΑΓΓΕΛΕΤΟΣ                                         
ΑΓΓΕΛΗΣ                                           
ΑΓΓΕΛΙΑΔΗΣ                                        
ΑΓΓΕΛΙΔΑΚΗΣ                                       
ΑΓΓΕΛΙΔΕΛΛΗΣ                                      
ΑΓΓΕΛΙΔΗΣ                                         
ΑΓΓΕΛΙΚΑΚΗΣ                                       
ΑΓΓΕΛΙΚΑΣ                                         
ΑΓΓΕΛΙΚΟΠΟΥΛΟΣ                                    
ΑΓΓΕΛΙΚΟΣ                                         
ΑΓΓΕΛΙΚΟΥΣΗΣ                                      
ΑΓΓΕΛΙΝΑΚΗΣ                                       
ΑΓΓΕΛΙΝΑΡΑΣ                                       
ΑΓΓΕΛΙΝΑΣ                                         
ΑΓΓΕΛΙΝΗΣ                                         
ΑΓΓΕΛΙΝΙΑΔΗΣ                                      
ΑΓΓΕΛΙΝΙΟΣ                                        
ΑΓΓΕΛΙΝΟΠΟΥΛΟΣ                                    
ΑΓΓΕΛΙΝΟΣ                                         
ΑΓΓΕΛΙΝΟΥΔΗΣ                                      
ΑΓΓΕΛΙΟΥΔΑΚΗΣ                                     
ΑΓΓΕΛΙΤΣΑΣ                                        
ΑΓΓΕΛΙΤΣΗΣ                                        
ΑΓΓΕΛΚΟΣ                                          
ΑΓΓΕΛΛΗΣ                                          
ΑΓΓΕΛΟΒΙΑΣ                                        
ΑΓΓΕΛΟΓΕΩΡΓΟΣ                                     
ΑΓΓΕΛΟΓΙΑΝΝΑΚΗΣ                                   
ΑΓΓΕΛΟΓΙΑΝΝΗΣ                                     
ΑΓΓΕΛΟΓΙΑΝΝΟΠΟΥΛΟΣ                                
ΑΓΓΕΛΟΓΙΑΝΝΟΣ                                     
ΑΓΓΕΛΟΖΩΗΣ                                        
ΑΓΓΕΛΟΘΑΝΑΣΗΣ                                     
ΑΓΓΕΛΟΚΑΣΤΡΙΤΗΣ                                   
ΑΓΓΕΛΟΚΩΝΣΤΑΝΤΗΣ                                  
ΑΓΓΕΛΟΚΩΣΤΟΠΟΥΛΟΣ                                 
ΑΓΓΕΛΟΛΟΥΚΑΣ                                      
ΑΓΓΕΛΟΜΑΤΗΣ                                       
ΑΓΓΕΛΟΜΕΝΟΣ                                       
ΑΓΓΕΛΟΝΙΔΗΣ                                       
ΑΓΓΕΛΟΠΟΥΛΟΣ                                      
ΑΓΓΕΛΟΣ                                           
ΑΓΓΕΛΟΣΟΠΟΥΛΟΣ                                    
ΑΓΓΕΛΟΣΟΥΛΗΣ                                      
ΑΓΓΕΛΟΣΤΟΓΙΑΝΝΗΣ                                  
ΑΓΓΕΛΟΥΔΑΚΗΣ                                      
ΑΓΓΕΛΟΥΔΑΣ                                        
ΑΓΓΕΛΟΥΔΗΣ                                        
ΑΓΓΕΛΟΥΔΙΑΣ                                       
ΑΓΓΕΛΟΥΚΑΣ                                        
ΑΓΓΕΛΟΥΚΟΣ                                        
ΑΓΓΕΛΟΥΛΗΣ                                        
ΑΓΓΕΛΟΥΣΗΣ                                        
ΑΓΓΕΛΟΥΣΟΠΟΥΛΟΣ                                   
ΑΓΓΕΛΟΥΣΟΥΛΗΣ                                     
ΑΓΓΕΛΟΧΩΡΙΤΗΣ                                     
ΑΓΓΕΛΤΣΗΣ                                         
ΑΓΓΕΛΤΣΙΔΗΣ                                       
ΑΓΓΕΛΩΝΑΣ                                         
ΑΓΓΕΛΩΝΙΑΣ                                        
ΑΓΓΕΛΩΝΙΤΗΣ                                       
ΑΓΓΕΡΑΤΟΣ                                         
ΑΓΓΕΡΕΤΑΣ                                         
ΑΓΓΕΡΟΥΣ                                          
ΑΓΓΗΛΑΚΟΥΛΗΣ                                      
ΑΓΓΗΣ                                             
ΑΓΓΙΔΑΣ                                           
ΑΓΓΙΔΗΣ                                           
ΑΓΓΙΝΑΡΗΣ                                         
ΑΓΓΙΝΑΡΤΖΗΣ                                       
ΑΓΓΙΟΥΣ                                           
ΑΓΓΙΣΟΥΛΑΚΗΣ                                      
ΑΓΓΙΣΤΑΛΗΣ                                        
ΑΓΓΙΣΤΡΙΩΤΗΣ                                      
ΑΓΓΛΕΖΗΣ                                          
ΑΓΓΛΕΡΑΣ                                          
ΑΓΓΛΙΑΣ                                           
ΑΓΓΛΙΔΗΣ                                          
ΑΓΓΛΟΓΑΛΛΟΣ                                       
ΑΓΓΛΟΓΑΛΟΣ                                        
ΑΓΓΛΟΠΟΥΛΟΣ                                       
ΑΓΓΛΟΣ                                            
ΑΓΓΛΟΥΠΑΣ                                         
ΑΓΓΟ ΜΠΕΚΗΡ ΧΑΣΑΝ                                 
ΑΓΓΟΡΟΥΔΗΣ                                        
ΑΓΓΟΣ                                             
ΑΓΓΟΤΗΣ                                           
ΑΓΓΟΥΛΕΣ                                          
ΑΓΓΟΥΜΗΣ                                          
ΑΓΓΟΥΡΑΚΗΣ                                        
ΑΓΓΟΥΡΑΣ                                          
ΑΓΓΟΥΡΗΣ                                          
ΑΓΓΟΥΡΙΑΣ                                         
ΑΓΓΟΥΡΙΔΑΚΗΣ                                      
ΑΓΓΟΥΡΙΔΗΣ                                        
ΑΓΓΟΥΡΟΔΗΜΟΣ                                      
ΑΓΓΟΥΡΟΥΔΗΣ                                       
ΑΓΓΟΥΣ                                            
ΑΓΓΟΥΣΗΣ                                          
ΑΓΓΡΑΣ                                            
ΑΓΔΑΛΗΣ                                           
ΑΓΔΑΛΙΔΗΣ                                         
ΑΓΔΙΝΙΩΤΗΣ                                        
ΑΓΕΙΟΡΙΤΗΣ                                        
ΑΓΕΛΑΔΑΡΑΚΗΣ                                      
ΑΓΕΛΑΔΑΡΗΣ                                        
ΑΓΕΛΑΔΑΣ                                          
ΑΓΕΛΑΔΕΛΗΣ                                        
ΑΓΕΛΑΔΟΠΟΥΛΟΣ                                     
ΑΓΕΛΑΡΑΚΗΣ                                        
ΑΓΕΛΑΡΗΣ                                          
ΑΓΕΛΑΡΙΔΗΣ                                        
ΑΓΕΛΑΣΤΟΠΟΥΛΟΣ                                    
ΑΓΕΛΑΣΤΟΣ                                         
ΑΓΕΛΟΠΟΥΛΟΣ                                       
ΑΓΕΛΩΠΑΣ                                          
ΑΓΕΡΑΚΗΣ                                          
ΑΓΕΡΑΝΙΩΤΗΣ                                       
ΑΓΕΡΑΣ                                            
ΑΓΕΡΙΑΔΗΣ                                         
ΑΓΕΡΙΔΗΣ                                          
ΑΓΕΡΙΚΟΣ                                          
ΑΓΕΡΚΟΠ                                           
ΑΓΕΡΟΤΗΣ                                          
ΑΓΕΡΣ                                             
ΑΓΕΡΩΤΗΣ                                          
ΑΓΕΤΖΗΣ                                           
ΑΓΗΣ                                              
ΑΓΙΑΖΗΣ                                           
ΑΓΙΑΚΑΤΣΙΚΑΣ                                      
ΑΓΙΑΜΑΡΙΝΙΩΤΗΣ                                    
ΑΓΙΑΜΑΡΝΙΩΤΗΣ                                     
ΑΓΙΑΜΠΑΣΗΣ                                        
ΑΓΙΑΝΔΡΙΤΗΣ                                       
ΑΓΙΑΝΙΔΗΣ                                         
ΑΓΙΑΝΙΤΗΣ                                         
ΑΓΙΑΝΙΩΤΑΚΗΣ                                      
ΑΓΙΑΝΝΗΣ                                          
ΑΓΙΑΝΝΙΔΗΣ                                        
ΑΓΙΑΝΝΙΤΗΣ                                        
ΑΓΙΑΝΝΙΤΟΠΟΥΛΟΣ                                   
ΑΓΙΑΝΝΙΩΤΑΚΗΣ                                     
ΑΓΙΑΝΝΙΩΤΗΣ                                       
ΑΓΙΑΝΝΟΠΟΥΛΟΣ                                     
ΑΓΙΑΝΤΖΗΣ                                         
ΑΓΙΑΝΤΡΙΤΗΣ                                       
ΑΓΙΑΝΤΣΗΣ                                         
ΑΓΙΑΡΜΑΝΙΩΤΗΣ                                     
ΑΓΙΑΡΤΖΗΣ                                         
ΑΓΙΑΣ                                             
ΑΓΙΑΣΙΩΤΗΣ                                        
ΑΓΙΑΣΜΑΤΖΗΣ                                       
ΑΓΙΑΣΜΑΤΗΣ                                        
ΑΓΙΑΣΜΕΝΑΚΗΣ                                      
ΑΓΙΑΣΜΕΝΟΣ                                        
ΑΓΙΑΣΟΤΕΛΗΣ                                       
ΑΓΙΑΣΟΦΙΤΗΣ                                       
ΑΓΙΑΣΣΩΤΕΛΗΣ                                      
ΑΓΙΑΣΣΩΤΕΛΛΗΣ                                     
ΑΓΙΑΣΣΩΤΗΣ                                        
ΑΓΙΑΣΩΤΕΛΗΣ                                       
ΑΓΙΑΣΩΤΕΛΛΗΣ                                      
ΑΓΙΑΣΩΤΗΣ                                         
ΑΓΙΑΤΖΙΔΗΣ                                        
ΑΓΙΟΒΑΡΒΑΡΙΤΑΚΗΣ                                  
ΑΓΙΟΒΑΣΙΛΕΙΩΤΗΣ                                   
ΑΓΙΟΒΛΑΣΙΤΗΣ                                      
ΑΓΙΟΚΑΤΣΙΚΑΣ                                      
ΑΓΙΟΚΥΡΙΑΚΙΩΤΗΣ                                   
ΑΓΙΟΛΗΤΗΣ                                         
ΑΓΙΟΛΙΤΗΣ                                         
ΑΓΙΟΜΑΜΙΤΗΣ                                       
ΑΓΙΟΜΑΥΡΙΤΗΣ                                      
ΑΓΙΟΜΥΡΓΙΑΝΑΚΗΣ                                   
ΑΓΙΟΜΥΡΓΙΑΝΝΑΚΗΣ                                  
ΑΓΙΟΝΙΚΟΛΑΙΤΗΣ                                    
ΑΓΙΟΠΕΤΡΙΤΗΣ                                      
ΑΓΙΟΠΗΣ                                           
ΑΓΙΟΠΛΟΥΔΗΣ                                       
ΑΓΙΟΡΓΙΤΗΣ                                        
ΑΓΙΟΡΓΙΩΤΑΚΗΣ                                     
ΑΓΙΟΡΓΟΥΣΗΣ                                       
ΑΓΙΟΡΕΙΤΗΣ                                        
ΑΓΙΟΡΙΤΗΣ                                         
ΑΓΙΟΣ                                             
ΑΓΙΟΣΤΡΑΤΙΔΗΣ                                     
ΑΓΙΟΣΤΡΑΤΙΤΗΣ                                     
ΑΓΙΟΤΑΦΥΤΑΚΗΣ                                     
ΑΓΙΟΥΜΠ                                           
ΑΓΙΟΥΠ                                            
ΑΓΙΟΥΣ                                            
ΑΓΙΟΥΤΑΚΗΣ                                        
ΑΓΙΟΥΤΑΝΤΗΣ                                       
ΑΓΙΣ                                              
ΑΓΙΩΡΓΙΟΤΑΚΗΣ                                     
ΑΓΙΩΡΓΙΤΗΣ                                        
ΑΓΙΩΡΓΙΩΤΑΚΗΣ                                     
ΑΓΙΩΡΓΟΥΣΗΣ                                       
ΑΓΙΩΤΑΚΗΣ                                         
ΑΓΙΩΤΑΤΟΣ                                         
ΑΓΙΩΤΗΣ                                           
ΑΓΚΑ ΙΣΜΑΗΛ                                       
ΑΓΚΑ ΟΓΛΟΥ                                        
ΑΓΚΑΒΑΝΑΚΗΣ                                       
ΑΓΚΑΘΙΔΗΣ                                         
ΑΓΚΑΜΙΡΙΔΗΣ                                       
ΑΓΚΑΝΑΣ                                           
ΑΓΚΑΝΗΣ                                           
ΑΓΚΑΣ                                             
ΑΓΚΑΦΑΝΙΔΗΣ                                       
ΑΓΚΑΦΩΝΙΔΗΣ                                       
ΑΓΚΕΛΚΟΣ                                          
ΑΓΚΗΡ ΧΑΣΑΝ                                       
ΑΓΚΙΝΑΡΑΣΤΑΧΑΚΗΣ                                  
ΑΓΚΙΝΑΡΗΣ                                         
ΑΓΚΙΟΥΛΗΣ                                         
ΑΓΚΙΣΤΡΙΩΤΗΣ                                      
ΑΓΚΟ ΜΕΜΕΤ                                        
ΑΓΚΟ ΧΟΥΣΕΙΝ                                      
ΑΓΚΟΙΔΗΣ                                          
ΑΓΚΟΜΑΧΑΛΕΛΗΣ                                     
ΑΓΚΟΝΙΔΗΣ                                         
ΑΓΚΟΠ                                             
ΑΓΚΟΠΗΣ                                           
ΑΓΚΟΠΙΑΝΗΣ                                        
ΑΓΚΟΡΤΖΑΣ                                         
ΑΓΚΟΡΤΖΟΣ                                         
ΑΓΚΟΡΤΣΑΣ                                         
ΑΓΚΟΡΤΣΟΓΙΑΝΝΗΣ                                   
ΑΓΚΟΣ                                             
ΑΓΚΟΤΑΚΗΣ                                         
ΑΓΚΟΤΗΣ                                           
ΑΓΚΟΥΔΗΣ                                          
ΑΓΚΟΥΡΙΔΑΚΗΣ                                      
ΑΓΚΟΥΣ                                            
ΑΓΚΟΥΣΗΣ                                          
ΑΓΚΟΦΑΝΙΔΗΣ                                       
ΑΓΚΡΑΣ                                            
ΑΓΚΡΗΣ                                            
ΑΓΚΡΙΘΑΡΑΚΗΣ                                      
ΑΓΚΡΙΤΣΗΣ                                         
ΑΓΚΤΖΙΔΗΣ                                         
ΑΓΚΥΝΑΡΗΣ                                         
ΑΓΚΥΡΑΛΙΔΗΣ                                       
ΑΓΚΥΡΑΝΟΠΟΥΛΟΣ                                    
ΑΓΚΥΡΙΔΗΣ                                         
ΑΓΚΥΡΟΠΟΥΛΟΣ                                      
ΑΓΚΥΣΟΥΛΑΚΗΣ                                      
ΑΓΛΑΙΝΗΣ                                          
ΑΓΛΑΜΗΣΙΔΗΣ                                       
ΑΓΛΑΜΙΔΗΣ                                         
ΑΓΛΑΜΙΣΗΣ                                         
ΑΓΛΟΥΠΑΣ                                          
ΑΓΝΑΝΤΑΙΟΣ                                        
ΑΓΝΑΝΤΗΣ                                          
ΑΓΝΑΝΤΙΑΡΗΣ                                       
ΑΓΝΑΝΤΙΤΗΣ                                        
ΑΓΝΑΝΤΙΩΤΗΣ                                       
ΑΓΝΑΝΤΟΠΟΥΛΟΣ                                     
ΑΓΝΑΝΤΟΣ                                          
ΑΓΝΑΤΟΣ                                           
ΑΓΝΙΑΔΗΣ                                          
ΑΓΝΙΔΗΣ                                           
ΑΓΝΟΥΣΙΩΤΗΣ                                       
ΑΓΟΓΛΩΣΣΑΚΗΣ                                      
ΑΓΟΡΑΚΗΣ                                          
ΑΓΟΡΑΝΟΣ                                          
ΑΓΟΡΑΣ                                            
ΑΓΟΡΑΣΤΑΚΗΣ                                       
ΑΓΟΡΑΣΤΑΡΑΣ                                       
ΑΓΟΡΑΣΤΗΣ                                         
ΑΓΟΡΑΣΤΙΔΗΣ                                       
ΑΓΟΡΑΣΤΟΠΟΥΛΟΣ                                    
ΑΓΟΡΑΣΤΟΣ                                         
ΑΓΟΡΑΣΤΟΥΔΗΣ                                      
ΑΓΟΡΑΤΖΗΣ                                         
ΑΓΟΡΑΤΣΑΚΗΣ                                       
ΑΓΟΡΑΤΣΙΟΣ                                        
ΑΓΟΡΓΙΑΝΙΤΗΣ                                      
ΑΓΟΡΕΛΗΣ                                          
ΑΓΟΡΕΛΛΗΣ                                         
ΑΓΟΡΗΣ                                            
ΑΓΟΡΙΑΝΙΤΗΣ                                       
ΑΓΟΡΙΔΑΣ                                          
ΑΓΟΡΙΔΗΣ                                          
ΑΓΟΡΙΤΣΑΣ                                         
ΑΓΟΡΙΤΣΗΣ                                         
ΑΓΟΡΟΓΙΑΝΝΗΣ                                      
ΑΓΟΡΟΠΟΥΛΟΣ                                       
ΑΓΟΡΟΣ                                            
ΑΓΟΡΟΥΔΗΣ                                         
ΑΓΟΣ                                              
ΑΓΟΤΖΙΚΗΣ                                         
ΑΓΟΥΑΝΤ ΑΛΛΑ ΑΛΥ                                  
ΑΓΟΥΔΗΜΟΣ                                         
ΑΓΟΥΔΗΣ                                           
ΑΓΟΥΛΑΣ                                           
ΑΓΟΥΛΟΣ                                           
ΑΓΟΥΡΑΣΤΟΣ                                        
ΑΓΟΥΡΑΤΣΙΟΣ                                       
ΑΓΟΥΡΖΕΝΙΔΗΣ                                      
ΑΓΟΥΡΖΕΝΙΤΖΙΔΗΣ                                   
ΑΓΟΥΡΙΔΑΣ                                         
ΑΓΟΥΡΙΔΗΣ                                         
ΑΓΟΥΡΟΓΙΑΝΝΗΣ                                     
ΑΓΟΥΡΟΠΟΥΛΟΣ                                      
ΑΓΟΥΡΟΣ                                           
ΑΓΟΥΡΣΑΛΙΔΗΣ                                      
ΑΓΡΑΒΑΝΗΣ                                         
ΑΓΡΑΒΑΡΑΣ                                         
ΑΓΡΑΓΓΕΛΟΣ                                        
ΑΓΡΑΔΑΣ                                           
ΑΓΡΑΝΙΤΗΣ                                         
ΑΓΡΑΝΙΩΤΗΣ                                        
ΑΓΡΑΠΗΔΑΣ                                         
ΑΓΡΑΠΙΔΑΚΗΣ                                       
ΑΓΡΑΠΙΔΗΣ                                         
ΑΓΡΑΦΑΣ                                           
ΑΓΡΑΦΙΑΔΗΣ                                        
ΑΓΡΑΦΙΩΤΗΣ                                        
ΑΓΡΕΒΗΣ                                           
ΑΓΡΕΛΗΣ                                           
ΑΓΡΕΛΛΗΣ                                          
ΑΓΡΗΜΑΚΗΣ                                         
ΑΓΡΗΜΑΚΙΣ                                         
ΑΓΡΗΣ                                             
ΑΓΡΗΤΕΛΗΣ                                         
ΑΓΡΙΑΔΕΛΗΣ                                        
ΑΓΡΙΑΚΟΝΙΤΗΣ                                      
ΑΓΡΙΑΝΑΣ                                          
ΑΓΡΙΑΝΙΔΗΣ                                        
ΑΓΡΙΑΝΙΤΗΣ                                        
ΑΓΡΙΑΝΤΩΝΗΣ                                       
ΑΓΡΙΓΙΑΝΝΑΚΗΣ                                     
ΑΓΡΙΓΙΑΝΝΗΣ                                       
ΑΓΡΙΔΗΣ                                           
ΑΓΡΙΔΙΩΤΗΣ                                        
ΑΓΡΙΔΟΠΟΥΛΟΣ                                      
ΑΓΡΙΜΑΚΗΣ                                         
ΑΓΡΙΜΑΝΑΚΗΣ                                       
ΑΓΡΙΜΑΝΗΣ                                         
ΑΓΡΙΜΗΣ                                           
ΑΓΡΙΟΓΗΔΟΣ                                        
ΑΓΡΙΟΓΙΑΝΝΗΣ                                      
ΑΓΡΙΟΓΙΑΝΝΟΣ                                      
ΑΓΡΙΟΔΗΜΑΣ                                        
ΑΓΡΙΟΔΗΜΟΣ                                        
ΑΓΡΙΟΜΑΛΛΟΣ                                       
ΑΓΡΙΟΜΗΤΡΟΣ                                       
ΑΓΡΙΟΠΟΥΛΟΣ                                       
ΑΓΡΙΟΣ                                            
ΑΓΡΙΟΣΤΑΘΗΣ                                       
ΑΓΡΙΟΤΖΙΟΜΠΑΝΟΣ                                   
ΑΓΡΙΠΙΔΗΣ                                         
ΑΓΡΙΤΑΚΗΣ                                         
ΑΓΡΙΤΕΛΗΣ                                         
ΑΓΡΙΤΕΛΛΗΣ                                        
ΑΓΡΙΤΖΟΜΠΑΝΟΣ                                     
ΑΓΡΙΤΗΣ                                           
ΑΓΡΟΓΙΑΝΝΗΣ                                       
ΑΓΡΟΓΙΑΝΝΟΣ                                       
ΑΓΡΟΔΗΜΟΣ                                         
ΑΓΡΟΚΩΣΤΑΣ                                        
ΑΓΡΟΛΑΜΠΟΣ                                        
ΑΓΡΟΣ                                             
ΑΓΡΟΤΗΣ                                           
ΑΓΡΟΥΛΗΣ                                          
ΑΓΡΟΦΥΛΑΚΑΣ                                       
ΑΓΡΟΦΥΛΑΞ                                         
ΑΓΡΥΜΑΚΗΣ                                         
ΑΓΡΥΜΑΚΙΣ                                         
ΑΓΤΖΙΔΗΣ                                          
ΑΓΥΙΩΤΗΣ                                          
ΑΓΩΓΙΑΤΗΣ                                         
ΑΓΩΡΙΑΝΙΤΗΣ                                       
ΑΔΑΚΤΥΛΙΔΗΣ                                       
ΑΔΑΚΤΥΛΟΣ                                         
ΑΔΑΛΑΚΗΣ                                          
ΑΔΑΛΗ ΧΑΣΑΝ                                       
ΑΔΑΛΗΣ                                            
ΑΔΑΛΙΑΛΗΣ                                         
ΑΔΑΛΟΖΙΔΗΣ                                        
ΑΔΑΛΟΠΟΥΛΟΣ                                       
ΑΔΑΛΟΣ                                            
ΑΔΑΛΟΥΔΗΣ                                         
ΑΔΑΛΟΥΖΙΔΗΣ                                       
ΑΔΑΜΑΚΑΚΗΣ                                        
ΑΔΑΜΑΚΗΣ                                          
ΑΔΑΜΑΚΙΔΗΣ                                        
ΑΔΑΜΑΚΟΠΟΥΛΟΣ                                     
ΑΔΑΜΑΚΟΣ                                          
ΑΔΑΜΑΜΑΣ                                          
ΑΔΑΜΑΝΤΙΑΔΗΣ                                      
ΑΔΑΜΑΝΤΙΔΗΣ                                       
ΑΔΑΜΑΝΤΟΠΟΥΛΟΣ                                    
ΑΔΑΜΑΡΑΣ                                          
ΑΔΑΜΑΡΕΤΣΟΣ                                       
ΑΔΑΜΑΣ                                            
ΑΔΑΜΗΣ                                            
ΑΔΑΜΙΔΗΣ                                          
ΑΔΑΜΙΚΟΣ                                          
ΑΔΑΜΙΧΟΣ                                          
ΑΔΑΜΙΩΤΗΣ                                         
ΑΔΑΜΟΓΙΑΝΝΗΣ                                      
ΑΔΑΜΟΠΟΥΛΟΣ                                       
ΑΔΑΜΟΣ                                            
ΑΔΑΜΟΥΔΑΣ                                         
ΑΔΑΜΟΥΔΗΣ                                         
ΑΔΑΜΟΥΛΑΣ                                         
ΑΔΑΜΟΥΛΗΣ                                         
ΑΔΑΜΟΥΣΗΣ                                         
ΑΔΑΜΠΑΣ                                           
ΑΔΑΜΠΑΣΗΣ                                         
ΑΔΑΜΠΑΣΙΑΔΗΣ                                      
ΑΔΑΜΠΑΣΙΔΗΣ                                       
ΑΔΑΜΠΑΤΑΣ                                         
ΑΔΑΜΤΖΙΚΗΣ                                        
ΑΔΑΜΤΖΙΛΙΑΔΗΣ                                     
ΑΔΑΝΑΛΗΣ                                          
ΑΔΑΝΗΣ                                            
ΑΔΑΟΣ                                             
ΑΔΑΣΗΣ                                            
ΑΔΕΙΛΗΝΗΣ                                         
ΑΔΕΙΛΙΝΗΣ                                         
ΑΔΕΙΟΠΟΥΛΟΣ                                       
ΑΔΕΛΙΑΝΑΚΗΣ                                       
ΑΔΕΛΙΝΗΣ                                          
ΑΔΕΛΦΙΔΗΣ                                         
ΑΔΕΛΦΟΠΟΥΛΟΣ                                      
ΑΔΕΛΦΟΥΛΑΚΟΣ                                      
ΑΔΕΜ ΑΜΕΤ                                         
ΑΔΕΜ ΑΧΜΕΤ                                        
ΑΔΕΜ ΜΕΜΕΤ                                        
ΑΔΕΜ ΟΓΛΟΥ                                        
ΑΔΕΜΗΣ                                            
ΑΔΗΛ ΟΓΛΟΥ                                        
ΑΔΗΛΕΝΙΔΗΣ                                        
ΑΔΗΛΙΝΗΣ                                          
ΑΔΗΜΟΥΔΗΣ                                         
ΑΔΙΚΗΜΕΝΑΚΗΣ                                      
ΑΔΟΝΤΑΚΗΣ                                         
ΑΔΟΡΓΙΑΣΤΟΣ                                       
ΑΔΟΣΙΔΗΣ                                          
ΑΔΡΑΚΤΑΣ                                          
ΑΔΡΑΛΑΣ                                           
ΑΔΡΑΜΑΚΗΣ                                         
ΑΔΡΑΜΑΝΗΣ                                         
ΑΔΡΑΜΕΡΙΝΑΣ                                       
ΑΔΡΑΜΕΡΙΝΟΣ                                       
ΑΔΡΑΜΗΣ                                           
ΑΔΡΑΜΙΤΙΑΝΟΣ                                      
ΑΔΡΑΣΚΕΛΑΣ                                        
ΑΔΡΑΧΤΑΣ                                          
ΑΔΡΕΟΠΟΥΛΟΣ                                       
ΑΔΡΙΑΝΟΠΟΥΛΟΣ                                     
ΑΔΡΙΑΝΟΣ                                          
ΑΔΡΙΑΝΟΥΔΗΣ                                       
ΑΔΡΙΑΝΟΥΠΟΛΙΤΗΣ                                   
ΑΔΡΙΜΗΣ                                           
ΑΔΡΙΝΟΣ                                           
ΑΔΡΟΥΝΗΣ                                          
ΑΔΡΥΜΗΣ                                           
ΑΔΥΝΑΜΟΣ                                          
ΑΕΡΑΚΗΣ                                           
ΑΕΡΑΝΟΠΟΥΛΟΣ                                      
ΑΕΡΗΣ                                             
ΑΕΡΙΔΗΣ                                           
ΑΕΡΙΚΟΣ                                           
ΑΕΡΙΝΙΩΤΗΣ                                        
ΑΕΡΟΖΗΣ                                           
ΑΕΡΟΠΟΥΛΟΣ                                        
ΑΕΤΙΔΗΣ                                           
ΑΕΤΟΠΟΥΛΟΣ                                        
ΑΕΤΟΣ                                             
ΑΖΑΚΑΣ                                            
ΑΖΑΚΙΔΗΣ                                          
ΑΖΑΜΟΠΟΥΛΟΣ                                       
ΑΖΑΜΠ                                             
ΑΖΑΜΠΙΔΗΣ                                         
ΑΖΑΠΗΣ                                            
ΑΖΑΠΙΔΗΣ                                          
ΑΖΑΡΗΣ                                            
ΑΖΑΡΙΑΔΗΣ                                         
ΑΖΑΡΙΑΣ                                           
ΑΖΑΡΙΔΗΣ                                          
ΑΖΑΡΟΠΟΥΛΟΣ                                       
ΑΖΑΣ                                              
ΑΖΒΕΣΤΟΠΟΥΛΟΣ                                     
ΑΖΓΚΙΝΗΣ                                          
ΑΖΔΑΡΙΔΗΣ                                         
ΑΖΔΕΡΗΣ                                           
ΑΖΔΡΕΣ                                            
ΑΖΕΛΗΣ                                            
ΑΖΕΜΟΠΟΥΛΟΣ                                       
ΑΖΕΠΗΣ                                            
ΑΖΗΖ                                              
ΑΖΗΖ ΟΓΛΟΥ                                        
ΑΖΗΖ ΧΑΣΑΝ                                        
ΑΖΗΣ                                              
ΑΖΙΔΗΣ                                            
ΑΖΙΖ                                              
ΑΖΙΖ ΟΓΛΟΥ                                        
ΑΖΙΖΗΣ                                            
ΑΖΙΣ ΟΓΛΟΥ                                        
ΑΖΙΣΗΣ                                            
ΑΖΛΗΣ                                             
ΑΖΜΑΝΗΣ                                           
ΑΖΜΑΝΙΔΗΣ                                         
ΑΖΝΑΒΟΥΡΙΔΗΣ                                      
ΑΖΝΑΟΥΡΗΣ                                         
ΑΖΝΑΟΥΡΙΔΗΣ                                       
ΑΖΝΤΑΡΙΔΗΣ                                        
ΑΖΟΒΙΔΗΣ                                          
ΑΖΟΙΔΗΣ                                           
ΑΖΟΡΑΚΟΣ                                          
ΑΖΟΡΙΔΗΣ                                          
ΑΖΟΥΔΗΣ                                           
ΑΖΟΥΖ                                             
ΑΖΟΥΚΗΣ                                           
ΑΖΟΥΜΑΝΙΔΗΣ                                       
ΑΖΟΥΣ                                             
ΑΖΥΜΟΠΟΥΛΟΣ                                       
ΑΖΩΒΙΔΗΣ                                          
ΑΖΩΙΔΗΣ                                           
ΑΖΩΡΑΚΟΣ                                          
ΑΗΒΑΛΙΩΤΗΣ                                        
ΑΗΓΓΗΣ                                            
ΑΗΔΗΝΙΔΗΣ                                         
ΑΗΔΙΝΙΔΗΣ                                         
ΑΗΔΟΝΑΣ                                           
ΑΗΔΟΝΗΣ                                           
ΑΗΔΟΝΙΑΣ                                          
ΑΗΔΟΝΙΔΗΣ                                         
ΑΗΔΟΝΟΠΟΥΛΟΣ                                      
ΑΗΔΟΝΟΥΔΗΣ                                        
ΑΗΔΩΝΑΣ                                           
ΑΗΔΩΝΗΣ                                           
ΑΗΔΩΝΙΔΗΣ                                         
ΑΗΛΑΚΗΣ                                           
ΑΗΡΟΖΗΣ                                           
ΑΗΤΙΔΗΣ                                           
ΑΗΤΟΣ                                             
ΑΘΑΝΑΗΛΕΑΣ                                        
ΑΘΑΝΑΗΛΙΔΗΣ                                       
ΑΘΑΝΑΗΛΟΣ                                         
ΑΘΑΝΑΙΛΙΔΗΣ                                       
ΑΘΑΝΑΣ                                            
ΑΘΑΝΑΣΑΙΝΑΣ                                       
ΑΘΑΝΑΣΑΙΟΣ                                        
ΑΘΑΝΑΣΑΚΑΚΗΣ                                      
ΑΘΑΝΑΣΑΚΗΣ                                        
ΑΘΑΝΑΣΑΚΟΠΟΥΛΟΣ                                   
ΑΘΑΝΑΣΑΚΟΣ                                        
ΑΘΑΝΑΣΑΚΟΥΔΗΣ                                     
ΑΘΑΝΑΣΑΡΑΚΗΣ                                      
ΑΘΑΝΑΣΑΡΑΣ                                        
ΑΘΑΝΑΣΑΡΟΣ                                        
ΑΘΑΝΑΣΑΣ                                          
ΑΘΑΝΑΣΑΤΟΣ                                        
ΑΘΑΝΑΣΕΑΣ                                         
ΑΘΑΝΑΣΕΚΟΣ                                        
ΑΘΑΝΑΣΕΛΗΣ                                        
ΑΘΑΝΑΣΕΛΛΗΣ                                       
ΑΘΑΝΑΣΕΛΟΣ                                        
ΑΘΑΝΑΣΕΡΗΣ                                        
ΑΘΑΝΑΣΗΣ                                          
ΑΘΑΝΑΣΙΑΔΗΣ                                       
ΑΘΑΝΑΣΙΑΣ                                         
ΑΘΑΝΑΣΙΔΗΣ                                        
ΑΘΑΝΑΣΙΟΣ                                         
ΑΘΑΝΑΣΛΕΡΗΣ                                       
ΑΘΑΝΑΣΟΓΙΑΝΝΟΠΟΥΛΟΣ                               
ΑΘΑΝΑΣΟΔΗΜΗΤΡΟΠΟΥΛΟΣ                              
ΑΘΑΝΑΣΟΠΟΥΛΟΣ                                     
ΑΘΑΝΑΣΟΣ                                          
ΑΘΑΝΑΣΟΥΔΑΣ                                       
ΑΘΑΝΑΣΟΥΔΗΣ                                       
ΑΘΑΝΑΣΟΥΛΑΚΗΣ                                     
ΑΘΑΝΑΣΟΥΛΑΣ                                       
ΑΘΑΝΑΣΟΥΛΗΣ                                       
ΑΘΑΝΑΣΟΥΛΙΑΣ                                      
ΑΘΑΝΑΣΟΥΛΙΔΗΣ                                     
ΑΘΑΝΑΣΟΥΛΟΠΟΥΛΟΣ                                  
ΑΘΑΝΑΣΟΥΡΕΛΙΑΣ                                    
ΑΘΑΝΑΤΟΠΟΥΛΟΣ                                     
ΑΘΑΝΑΤΟΣ                                          
ΑΘΑΝΑΤΣΙΚΗΣ                                       
ΑΘΑΝΙΤΗΣ                                          
ΑΘΑΝΟΣ                                            
ΑΘΕΛΟΓΟΣ                                          
ΑΘΕΝΑΚΗΣ                                          
ΑΘΕΝΑΣ                                            
ΑΘΕΡΑΣ                                            
ΑΘΕΡΙΝΑΣ                                          
ΑΘΕΡΙΝΗΣ                                          
ΑΘΕΡΙΝΟΣ                                          
ΑΘΗΝΑΔΗΣ                                          
ΑΘΗΝΑΙΔΗΣ                                         
ΑΘΗΝΑΙΟΣ                                          
ΑΘΗΝΑΚΗΣ                                          
ΑΘΗΝΕΛΗΣ                                          
ΑΘΗΝΕΛΛΗΣ                                         
ΑΘΗΝΗΣ                                            
ΑΘΗΝΙΟΣ                                           
ΑΘΗΝΙΩΤΗΣ                                         
ΑΘΗΡΝΑΡΗΣ                                         
ΑΘΗΤΑΚΗΣ                                          
ΑΘΗΤΣΙΟΣ                                          
ΑΘΗΤΣΟΣ                                           
ΑΘΙΑΝΑΣ                                           
ΑΘΙΑΝΟΣ                                           
ΑΘΙΓΓΑΝΟΣ                                         
ΑΘΙΤΣΟΣ                                           
ΑΘΟΥΣΑΚΗΣ                                         
ΑΘΟΥΣΑΣ                                           
ΑΘΟΥΣΗΣ                                           
ΑΘΥΜΑΡΙΤΗΣ                                        
ΑΘΥΡΙΔΗΣ                                          
ΑΘΥΡΟΠΟΥΛΟΣ                                       
ΑΘΥΡΟΣ                                            
ΑΙΑΖ                                              
ΑΙΑΣ                                              
ΑΙΒΑΖ                                             
ΑΙΒΑΖΕΛΗΣ                                         
ΑΙΒΑΖΗΣ                                           
ΑΙΒΑΖΙΔΗΣ                                         
ΑΙΒΑΖΟΠΟΥΛΟΣ                                      
ΑΙΒΑΖΟΥΔΗΣ                                        
ΑΙΒΑΘΙΑΔΗΣ                                        
ΑΙΒΑΛΑΚΗΣ                                         
ΑΙΒΑΛΑΚΙΣ                                         
ΑΙΒΑΛΗΣ                                           
ΑΙΒΑΛΙΔΗΣ                                         
ΑΙΒΑΛΙΚΛΗΣ                                        
ΑΙΒΑΛΙΩΤΑΚΗΣ                                      
ΑΙΒΑΛΙΩΤΕΛΗΣ                                      
ΑΙΒΑΛΙΩΤΕΛΛΗΣ                                     
ΑΙΒΑΛΙΩΤΗΣ                                        
ΑΙΒΑΝΟΥΛΗΣ                                        
ΑΙΒΑΣΙΛΙΩΤΗΣ                                      
ΑΙΒΑΤΖΗΣ                                          
ΑΙΒΑΤΖΙΔΗΣ                                        
ΑΙΒΑΤΗΣ                                           
ΑΙΒΑΤΙΑΔΗΣ                                        
ΑΙΒΑΤΙΔΗΣ                                         
ΑΙΒΑΤΙΝΟΣ                                         
ΑΙΒΑΤΛΗΣ                                          
ΑΙΒΑΤΣΙΔΗΣ                                        
ΑΙΓΙΔΗΣ                                           
ΑΙΓΙΝΗΤΗΣ                                         
ΑΙΓΙΝΙΤΗΣ                                         
ΑΙΓΚΗΡ ΧΑΣΑΝ                                      
ΑΙΓΚΗΣ                                            
ΑΙΓΚΙΡ ΜΕΜΕΤ                                      
ΑΙΓΥΠΤΙΑΔΗΣ                                       
ΑΙΔΑΛΗΣ                                           
ΑΙΔΑΛΟΣ                                           
ΑΙΔΑΡΗΣ                                           
ΑΙΔΑΡΙΝΗΣ                                         
ΑΙΔΕΛΗΣ                                           
ΑΙΔΕΝΙΖ                                           
ΑΙΔΕΝΛΗΣ                                          
ΑΙΔΗΝ ΑΜΕΤ                                        
ΑΙΔΗΝ ΙΣΜΑΗΛ                                      
ΑΙΔΗΝΗΣ                                           
ΑΙΔΗΝΙΔΗΣ                                         
ΑΙΔΗΝΟΠΟΥΛΟΣ                                      
ΑΙΔΗΡΗΣ                                           
ΑΙΔΗΣ                                             
ΑΙΔΙΝ ΑΖΙΖ ΟΓΛΟΥ                                  
ΑΙΔΙΝ ΑΜΕΤ                                        
ΑΙΔΙΝ ΙΣΜΑΗΛ ΟΓΛΟΥ                                
ΑΙΔΙΝ ΣΑΛΗ                                        
ΑΙΔΙΝ ΧΟΥΣΕΙΝ                                     
ΑΙΔΙΝΗΣ                                           
ΑΙΔΙΝΙΔΗΣ                                         
ΑΙΔΙΝΙΩΤΗΣ                                        
ΑΙΔΙΝΛΗΣ                                          
ΑΙΔΙΝΟΠΟΥΛΟΣ                                      
ΑΙΔΟΝΗΣ                                           
ΑΙΔΟΝΙΔΗΣ                                         
ΑΙΔΟΝΟΠΟΥΛΟΣ                                      
ΑΙΔΩΝΗΣ                                           
ΑΙΔΩΝΙΔΗΣ                                         
ΑΙΘΩΜΙΑΝΑΚΗΣ                                      
ΑΙΚΑΤΕΡΙΝΑΚΗΣ                                     
ΑΙΚΑΤΕΡΙΝΑΡΗΣ                                     
ΑΙΚΑΤΕΡΙΝΗΣ                                       
ΑΙΚΑΤΕΡΙΝΙΑΔΗΣ                                    
ΑΙΚΑΤΕΡΙΝΙΔΗΣ                                     
ΑΙΚΑΤΕΡΙΝΟΠΟΥΛΟΣ                                  
ΑΙΚΗΣ                                             
ΑΙΚΟΣ                                             
ΑΙΛΑΜΑΚΗΣ                                         
ΑΙΛΑΡΟΥΔΗΣ                                        
ΑΙΛΕΡΣ                                            
ΑΙΛΙΑΝΟΣ                                          
ΑΙΛΙΑΤΣΗΣ                                         
ΑΙΜΑΛΙΩΤΗΣ                                        
ΑΙΜΑΤΙΔΗΣ                                         
ΑΙΜΕΛΙΔΗΣ                                         
ΑΙΜΕΡΣ                                            
ΑΙΜΙΛΙΑΝΟΣ                                        
ΑΙΜΙΛΙΟΣ                                          
ΑΙΜΟΝΙΩΤΗΣ                                        
ΑΙΜΟΥΧΙΔΗΣ                                        
ΑΙΜΠΑΤΜΑΖ                                         
ΑΙΜΣ                                              
ΑΙΝΑΓΚΟΖ                                          
ΑΙΝΑΓΟΖ                                           
ΑΙΝΑΛΑΚΗΣ                                         
ΑΙΝΑΛΗΣ                                           
ΑΙΝΑΛΙΔΗΣ                                         
ΑΙΝΑΡΟΖΙΔΗΣ                                       
ΑΙΝΑΤΖΗΣ                                          
ΑΙΝΑΤΖΙΔΗΣ                                        
ΑΙΝΑΤΖΟΠΟΥΛΟΣ                                     
ΑΙΝΑΤΙΔΗΣ                                         
ΑΙΝΑΤΣΙΔΗΣ                                        
ΑΙΝΔΕΛΗΣ                                          
ΑΙΝΔΙΛΗΣ                                          
ΑΙΝΗΣ                                             
ΑΙΝΙΖΛΗΣ                                          
ΑΙΝΙΤΗΣ                                           
ΑΙΝΤΕΝΙΖ                                          
ΑΙΝΤΖΗΣ                                           
ΑΙΝΤΙΝ ΟΓΛΟΥ                                      
ΑΙΝΤΙΝ ΧΑΣΑΝ                                      
ΑΙΝΤΙΝΙΔΗΣ                                        
ΑΙΡΑΝΤΖΗΣ                                         
ΑΙΡΑΠΕΤΙΔΗΣ                                       
ΑΙΡΙΚΤΣΙΔΗΣ                                       
ΑΙΡΙΣ                                             
ΑΙΣ                                               
ΑΙΣΙΟΠΟΥΛΟΣ                                       
ΑΙΣΩΠΑΚΗΣ                                         
ΑΙΣΩΠΟΣ                                           
ΑΙΤ ΝΤΑΧΜΑΝΕ                                      
ΑΙΤΑΚΗΣ                                           
ΑΙΤΑΣ                                             
ΑΙΤΖΗΣ                                            
ΑΙΤΖΙΔΗΣ                                          
ΑΙΤΙΑΡΙΔΗΣ                                        
ΑΙΤΙΔΗΣ                                           
ΑΙΤΙΝ ΟΓΛΟΥ                                       
ΑΙΤΙΝΙΔΗΣ                                         
ΑΙΤΣΙΔΗΣ                                          
ΑΙΤΣΙΝΗΣ                                          
ΑΙΦΑΝΤΗΣ                                          
ΑΙΦΑΝΤΙΔΗΣ                                        
ΑΙΧΜΑΛΩΤΙΔΗΣ                                      
ΑΚ ΣΑΒΒΑ                                          
ΑΚΑΒΑΛΟΣ                                          
ΑΚΑΚΙΟΣ                                           
ΑΚΑΛΕΣΤΟΣ                                         
ΑΚΑΛΙΔΗΣ                                          
ΑΚΑΜΑΤΗΣ                                          
ΑΚΑΜΙΩΤΑΚΗΣ                                       
ΑΚΑΜΠΑΛΗΣ                                         
ΑΚΑΜΩΤΑΚΗΣ                                        
ΑΚΑΝΘΟΠΟΥΛΟΣ                                      
ΑΚΑΝΤΖΕΛΙΩΤΗΣ                                     
ΑΚΑΝΤΖΗΛΙΩΤΗΣ                                     
ΑΚΑΝΤΖΙΛΙΩΤΗΣ                                     
ΑΚΑΡΕΠΗΣ                                          
ΑΚΑΡΙΔΗΣ                                          
ΑΚΑΣΗΣ                                            
ΑΚΑΣΙΑΔΗΣ                                         
ΑΚΑΣΙΔΗΣ                                          
ΑΚΑΣΜΑΣ                                           
ΑΚΑΤΖΕΛΙΩΤΗΣ                                      
ΑΚΑΤΗΣ                                            
ΑΚΕΖΙΔΗΣ                                          
ΑΚΕΡΜΑΝΙΔΗΣ                                       
ΑΚΕΣΤΟΡΙΔΗΣ                                       
ΑΚΕΨΙΜΑΙΔΗΣ                                       
ΑΚΕΨΙΜΑΣ                                          
ΑΚΕΨΙΜΙΔΗΣ                                        
ΑΚΕΨΩΜΑΙΔΗΣ                                       
ΑΚΖΙΩΤΗΣ                                          
ΑΚΖΩΤΗΣ                                           
ΑΚΗ ΟΓΛΟΥ                                         
ΑΚΗΣ                                              
ΑΚΗΦ ΟΓΛΟΥ                                        
ΑΚΙΑΝΙΔΗΣ                                         
ΑΚΙΔΗΣ                                            
ΑΚΙΛΙΔΗΣ                                          
ΑΚΙΛΛΑΣ                                           
ΑΚΙΜ ΟΓΛΟΥ                                        
ΑΚΙΝΗΤΟΣ                                          
ΑΚΙΟΥΖ                                            
ΑΚΙΣΚΑΛΟΣ                                         
ΑΚΙΦ ΟΓΛΟΥ                                        
ΑΚΚΑΔΗΣ                                           
ΑΚΚΑΣ                                             
ΑΚΚΑΣΙΑΔΗΣ                                        
ΑΚΚΙΖΙΔΗΣ                                         
ΑΚΚΟΣ                                             
ΑΚΚΟΤΣ                                            
ΑΚΚΟΥΡΗΣ                                          
ΑΚΚΥΛΑΣ                                           
ΑΚΛΑΝΤΙΟΣ                                         
ΑΚΛΑΣΗΣ                                           
ΑΚΛΗΡΟΣ                                           
ΑΚΛΙΔΑΚΗΣ                                         
ΑΚΛΙΔΗΣ                                           
ΑΚΜΑΝΙΔΗΣ                                         
ΑΚΜΟΥΤΣΟΣ                                         
ΑΚΜΠΑΜΠΑΣ                                         
ΑΚΜΠΑΣ                                            
ΑΚΜΠΑΤΖΑΚΗΣ                                       
ΑΚΟΒΙΤΙΩΤΗΣ                                       
ΑΚΟΓΛΑΝΗΣ                                         
ΑΚΟΚΑΛΙΔΗΣ                                        
ΑΚΟΚΚΑΛΙΔΗΣ                                       
ΑΚΟΛΑΝΙΔΗΣ                                        
ΑΚΟΝΑΚΟΣ                                          
ΑΚΟΝΗΣ                                            
ΑΚΟΝΙΔΗΣ                                          
ΑΚΟΝΤΙΔΗΣ                                         
ΑΚΟΥΔΗΣ                                           
ΑΚΟΥΙΛΑΝΟΣ                                        
ΑΚΟΥΜΙΑΝΑΚΗΣ                                      
ΑΚΟΥΡΗΣ                                           
ΑΚΟΥΡΟΣ                                           
ΑΚΟΥΤΑΣ                                           
ΑΚΟΥΤΕΣ                                           
ΑΚΟΥΤΗΣ                                           
ΑΚΠΑΠΑΣ                                           
ΑΚΠΑΡΙΔΗΣ                                         
ΑΚΠΑΣ                                             
ΑΚΠΑΣΙΔΗΣ                                         
ΑΚΡΑΜΠΑ ΑΜΕΤ                                      
ΑΚΡΑΜΠΑ ΜΕΜΕΤ ΟΓΛΟΥ                               
ΑΚΡΑΜΠΑ ΧΑΣΑΝ                                     
ΑΚΡΑΜΠΑ ΧΟΥΣΕΙΝ ΑΧΜΕΤ                             
ΑΚΡΑΝΑΣ                                           
ΑΚΡΑΝΗΣ                                           
ΑΚΡΑΝΙΔΗΣ                                         
ΑΚΡΑΣ                                             
ΑΚΡΑΣΑΚΗΣ                                         
ΑΚΡΑΤΑΣ                                           
ΑΚΡΑΤΟΠΟΥΛΟΣ                                      
ΑΚΡΑΤΟΣ                                           
ΑΚΡΙΒΑΚΗΣ                                         
ΑΚΡΙΒΑΣ                                           
ΑΚΡΙΒΗΣ                                           
ΑΚΡΙΒΙΑΔΗΣ                                        
ΑΚΡΙΒΙΔΗΣ                                         
ΑΚΡΙΒΛΕΛΗΣ                                        
ΑΚΡΙΒΛΕΛΛΗΣ                                       
ΑΚΡΙΒΟΓΙΑΝΝΗΣ                                     
ΑΚΡΙΒΟΠΟΥΛΟΣ                                      
ΑΚΡΙΒΟΣ                                           
ΑΚΡΙΒΟΣΟΥΛΗΣ                                      
ΑΚΡΙΒΟΥΛΗΣ                                        
ΑΚΡΙΒΟΥΣΗΣ                                        
ΑΚΡΙΔΑΣ                                           
ΑΚΡΙΔΕΛΗΣ                                         
ΑΚΡΙΔΗΣ                                           
ΑΚΡΙΔΟΠΟΥΛΟΣ                                      
ΑΚΡΙΜΗΣ                                           
ΑΚΡΙΝΟΠΟΥΛΟΣ                                      
ΑΚΡΙΣ                                             
ΑΚΡΙΤΑΝΑΚΗΣ                                       
ΑΚΡΙΤΑΣ                                           
ΑΚΡΙΤΙΑΔΗΣ                                        
ΑΚΡΙΤΙΔΗΣ                                         
ΑΚΡΙΤΟΠΟΥΛΟΣ                                      
ΑΚΡΙΩΤΗΣ                                          
ΑΚΡΩΤΗΡΙΑΝΑΚΗΣ                                    
ΑΚΣΑΡΙΔΗΣ                                         
ΑΚΣΑΤΣ                                            
ΑΚΣΕΧΕΡΛΙΔΗΣ                                      
ΑΚΤΑΣ                                             
ΑΚΤΙΔΗΣ                                           
ΑΚΤΙΝΑΚΗΣ                                         
ΑΚΤΙΠΗΣ                                           
ΑΚΤΟΥΔΙΑΝΑΚΗΣ                                     
ΑΚΤΣΑΛΗΣ                                          
ΑΚΤΣΕΛΗΣ                                          
ΑΚΤΣΙΑΛΗΣ                                         
ΑΚΤΥΠΗΣ                                           
ΑΚΥΛΑΣ                                            
ΑΚΥΛΙΔΗΣ                                          
ΑΚΥΡΟΣ                                            
ΑΚΩΝΗΣ                                            
ΑΛ ΑΖΑΟΥΙ                                         
ΑΛ ΑΚΑΙΛΑ                                         
ΑΛ ΑΛΗ                                            
ΑΛ ΑΛΙ                                            
ΑΛ ΑΜΠΑΝΤΛΑ                                       
ΑΛ ΑΜΠΑΣΙ                                         
ΑΛ ΑΜΠΙΑΝΤ                                        
ΑΛ ΑΜΠΝΤΙ                                         
ΑΛ ΑΜΠΟΝΤΑ                                        
ΑΛ ΑΝΤΑΣΗ                                         
ΑΛ ΑΟΥΑΝΤ                                         
ΑΛ ΑΟΥΝΤΑΤ                                        
ΑΛ ΑΡΑΤΖ                                          
ΑΛ ΑΣΑΝΤ                                          
ΑΛ ΑΣΚΑΡ                                          
ΑΛ ΑΣΜΑΡ                                          
ΑΛ ΑΣΜΠΑΝ                                         
ΑΛ ΑΣΣΑΑΝΤ                                        
ΑΛ ΑΤΖΟΥΡΙ ΝΑΧΜΙΑ                                 
ΑΛ ΑΤΙΚ                                           
ΑΛ ΑΤΡΑΣ                                          
ΑΛ ΑΧΜΑΡ                                          
ΑΛ ΑΧΟΥΑΛ                                         
ΑΛ ΑΧΡΑΣ                                          
ΑΛ ΓΙΟΥΝΕΣ                                        
ΑΛ ΓΙΟΥΝΙΝΤΙ                                      
ΑΛ ΓΙΟΥΣΕΦ                                        
ΑΛ ΓΚΑΝΤΑΡΙ                                       
ΑΛ ΓΚΑΝΤΡΙ                                        
ΑΛ ΓΚΙΝΤΥ                                         
ΑΛ ΓΚΙΣΑΝ                                         
ΑΛ ΓΚΟΥΕΙΡΙ                                       
ΑΛ ΖΑΧΕΜ                                          
ΑΛ ΖΕΡΚΛΗ                                         
ΑΛ ΖΟΥΜΠΕΙΝΤΙ                                     
ΑΛ ΖΡΕΚΑΤ                                         
ΑΛ ΙΜΑΝΤΙ                                         
ΑΛ ΙΣΣΑ                                           
ΑΛ ΚΑΓΙΕΤ                                         
ΑΛ ΚΑΙΑΛΙ                                         
ΑΛ ΚΑΚ                                            
ΑΛ ΚΑΜΦ                                           
ΑΛ ΚΑΡΑΙΝΗ                                        
ΑΛ ΚΟΔΑ                                           
ΑΛ ΚΟΖΒΙΝΙ                                        
ΑΛ ΚΟΥΡ                                           
ΑΛ ΚΟΥΡΑΑΝ                                        
ΑΛ ΚΣΟΥΣ                                          
ΑΛ ΛΑΚΙΣ                                          
ΑΛ ΛΟΖΙ                                           
ΑΛ ΜΑΛΕΧ                                          
ΑΛ ΜΑΝΤΜΠΑΚ                                       
ΑΛ ΜΑΝΤΦΑΙ                                        
ΑΛ ΜΕΣΑΤΑΤ                                        
ΑΛ ΜΕΣΡΙ                                          
ΑΛ ΜΙΝΣΑΟΥΙ                                       
ΑΛ ΜΟΥΑΣΕΡ                                        
ΑΛ ΜΟΥΜΑΝΙ                                        
ΑΛ ΜΟΥΣΟΥΙ                                        
ΑΛ ΜΟΥΤΖ                                          
ΑΛ ΜΟΧΑΜΑΝΤ                                       
ΑΛ ΜΠΑΓΙΑΛΙ                                       
ΑΛ ΜΠΑΚΡΙ                                         
ΑΛ ΜΠΑΝΤΑΚ                                        
ΑΛ ΜΠΑΝΤΙΝ                                        
ΑΛ ΜΠΑΣΑΜΠΙΣΑ                                     
ΑΛ ΜΠΑΧΡΙ                                         
ΑΛ ΜΠΕΑΙΝΙ                                        
ΑΛ ΜΠΕΙΑΤΙ                                        
ΑΛ ΜΠΙΤΑΡ                                         
ΑΛ ΜΠΟΥΣΤΑΝΙ                                      
ΑΛ ΜΠΟΥΧΑΡΑΛΗ                                     
ΑΛ ΝΑΚΑ                                           
ΑΛ ΝΑΣΑΡ                                          
ΑΛ ΝΑΣΙΡΙ                                         
ΑΛ ΝΑΣΣΕΡ                                         
ΑΛ ΝΑΤΖΑΡ                                         
ΑΛ ΝΕΙΜΙ                                          
ΑΛ ΝΕΙΡΑΤ                                         
ΑΛ ΝΙΜΕΡ                                          
ΑΛ ΝΟΜΑΝΙ                                         
ΑΛ ΝΟΦΑΛ                                          
ΑΛ ΝΤΑΕΝΙ                                         
ΑΛ ΝΤΕΧΕΝΤΙ                                       
ΑΛ ΝΤΙΡΑΝΙ                                        
ΑΛ ΝΤΡΟΥΜΠΙ                                       
ΑΛ ΟΜΑΡΙ                                          
ΑΛ ΟΥΑΝΤΙ                                         
ΑΛ ΟΥΑΡΝΤΙΝΙ                                      
ΑΛ ΟΥΡΕΙΚΑΤ                                       
ΑΛ ΡΑΜΑΧ                                          
ΑΛ ΡΑΜΑΧΙ                                         
ΑΛ ΡΑΤΖΛΕ                                         
ΑΛ ΡΑΧΑΜΠΙ                                        
ΑΛ ΣΑΑΓΙΑΧ                                        
ΑΛ ΣΑΓΙΕΝΤ                                        
ΑΛ ΣΑΓΟΥΡΙ                                        
ΑΛ ΣΑΕΓ                                           
ΑΛ ΣΑΙΕΝΤ                                         
ΑΛ ΣΑΙΝΤ                                          
ΑΛ ΣΑΛΕΜ                                          
ΑΛ ΣΑΛΕΧ                                          
ΑΛ ΣΑΜΙ                                           
ΑΛ ΣΑΜΙΣΤΙ                                        
ΑΛ ΣΑΜΠ                                           
ΑΛ ΣΑΜΠΑΓΚ                                        
ΑΛ ΣΑΜΠΑΙΛΕ                                       
ΑΛ ΣΑΜΡΑΝΙ                                        
ΑΛ ΣΑΝΑΑ                                          
ΑΛ ΣΑΡΑΧΕ                                         
ΑΛ ΣΑΡΜΠΑΤΙ                                       
ΑΛ ΣΑΧΙΔ                                          
ΑΛ ΣΕΙΧ                                           
ΑΛ ΣΕΧ                                            
ΑΛ ΣΟΜΠΧ                                          
ΑΛ ΣΟΥΦΙ                                          
ΑΛ ΤΑΜΠΡΟΥΡΙ                                      
ΑΛ ΤΑΡΑΟΥΝΕ                                       
ΑΛ ΤΖΑΜΠΟΥΡ                                       
ΑΛ ΤΖΑΧΜΑΝΙ                                       
ΑΛ ΤΖΕΧΑΙΕΜ                                       
ΑΛ ΤΖΟΜΠΕ                                         
ΑΛ ΤΟΥΡΚ                                          
ΑΛ ΦΑΝΤΕΛ                                         
ΑΛ ΦΟΝΤΕΡΙ                                        
ΑΛ ΧΑΓΙΑΝΙ                                        
ΑΛ ΧΑΖΖΕ                                          
ΑΛ ΧΑΙΕΚ                                          
ΑΛ ΧΑΚΙΜ                                          
ΑΛ ΧΑΜΑΝΤ                                         
ΑΛ ΧΑΜΟΥΣ                                         
ΑΛ ΧΑΜΠΑΡΙ                                        
ΑΛ ΧΑΝΑΚΤΕ                                        
ΑΛ ΧΑΝΤΑΝΤ                                        
ΑΛ ΧΑΡΦΟΥΣΙ                                       
ΑΛ ΧΑΣΑΝ                                          
ΑΛ ΧΑΣΑΟΥΝΕ                                       
ΑΛ ΧΑΣΛΟΚ                                         
ΑΛ ΧΑΣΟΥΝΤ                                        
ΑΛ ΧΑΤΙΜΠ                                         
ΑΛ ΧΕΛΟΥ                                          
ΑΛ ΧΕΝΤΙ                                          
ΑΛ ΧΙΛΑΛΗ                                         
ΑΛ ΧΙΛΛΙ                                          
ΑΛ ΧΙΛΟΟΥ                                         
ΑΛ ΧΟΣΜΠΑΝ                                        
ΑΛ ΧΟΥΡΙ                                          
ΑΛ ΧΟΥΣΕΙΝΙ                                       
ΑΛ ΧΟΥΣΣΕΙΝΙ                                      
ΑΛΑΒΑΚΗΣ                                          
ΑΛΑΒΑΝΟΣ                                          
ΑΛΑΒΑΝΤΑΣ                                         
ΑΛΑΒΑΝΤΗΣ                                         
ΑΛΑΒΕΡΑΣ                                          
ΑΛΑΒΙΔΗΣ                                          
ΑΛΑΓΑΝΤΑΚΗΣ                                       
ΑΛΑΓΑΣ                                            
ΑΛΑΓΙΑΛΗΣ                                         
ΑΛΑΓΙΑΝΝΗΣ                                        
ΑΛΑΓΙΟΖΙΔΗΣ                                       
ΑΛΑΓΙΩΖΗΣ                                         
ΑΛΑΓΚΙΟΖΙΔΗΣ                                      
ΑΛΑΓΛΗΣ                                           
ΑΛΑΙΑΔΗΣ                                          
ΑΛΑΙΔΗΣ                                           
ΑΛΑΙΜΑΛΑΗΣ                                        
ΑΛΑΙΣΚΑΣ                                          
ΑΛΑΙΤΣΗΣ                                          
ΑΛΑΚΑΣ                                            
ΑΛΑΚΙΑΣ                                           
ΑΛΑΚΙΟΖΗΣ                                         
ΑΛΑΚΙΟΖΙΔΗΣ                                       
ΑΛΑΚΙΩΤΗΣ                                         
ΑΛΑΚΟΖ                                            
ΑΛΑΛΕΟΠΟΥΛΟΣ                                      
ΑΛΑΜΑΓΚΟΣ                                         
ΑΛΑΜΑΝΑΣ                                          
ΑΛΑΜΑΝΗΣ                                          
ΑΛΑΜΑΝΙΔΗΣ                                        
ΑΛΑΜΑΝΙΩΤΗΣ                                       
ΑΛΑΜΑΝΟΣ                                          
ΑΛΑΜΑΝΤΑΡΓΙΩΤΗΣ                                   
ΑΛΑΜΑΝΤΑΡΙΩΤΗΣ                                    
ΑΛΑΜΑΡΑΣ                                          
ΑΛΑΜΑΤΙΔΗΣ                                        
ΑΛΑΜΕΝΗΣ                                          
ΑΛΑΜΕΝΟΣ                                          
ΑΛΑΜΙΔΗΣ                                          
ΑΛΑΜΙΣΗΣ                                          
ΑΛΑΜΟΛΑΣ                                          
ΑΛΑΜΠΑΚΗΣ                                         
ΑΛΑΜΠΑΚΟΠΟΥΛΟΣ                                    
ΑΛΑΜΠΑΝΟΣ                                         
ΑΛΑΜΠΑΣΗΣ                                         
ΑΛΑΜΠΑΣΙΝΗΣ                                       
ΑΛΑΜΠΑΣΥΝΗΣ                                       
ΑΛΑΜΠΑΤΖΙΑΣ                                       
ΑΛΑΜΠΕΗΣ                                          
ΑΛΑΜΠΟΡΙΝΟΣ                                       
ΑΛΑΜΠΟΥΡΙΝΟΣ                                      
ΑΛΑΜΠΟΥΡΝΟΣ                                       
ΑΛΑΜΠΟΥΡΤΖΙΔΗΣ                                    
ΑΛΑΜΠΟΥΡΤΣΙΔΗΣ                                    
ΑΛΑΝΕΛΛΗΣ                                         
ΑΛΑΝΗΣ                                            
ΑΛΑΝΙΑΔΗΣ                                         
ΑΛΑΝΙΖ                                            
ΑΛΑΝΤΑΛΑΣ                                         
ΑΛΑΝΤΖΑΣ                                          
ΑΛΑΟΥΝΗΣ                                          
ΑΛΑΠΑΝΗΣ                                          
ΑΛΑΠΑΝΤΑΣ                                         
ΑΛΑΠΟΥΛΙΟΣ                                        
ΑΛΑΡΛΗΣ                                           
ΑΛΑΣΕΙΡΛΗΣ                                        
ΑΛΑΣΗ ΙΣΜΑΗΛ                                      
ΑΛΑΣΗΣ                                            
ΑΛΑΣΣΑΣ                                           
ΑΛΑΣΩΝΑΣ                                          
ΑΛΑΣΩΝΙΤΗΣ                                        
ΑΛΑΤΑΚΗΣ                                          
ΑΛΑΤΑΡΗΣ                                          
ΑΛΑΤΑΣ                                            
ΑΛΑΤΕΛΗΣ                                          
ΑΛΑΤΕΡΑΣ                                          
ΑΛΑΤΕΡΟΣ                                          
ΑΛΑΤΖΑ ΑΛΗ                                        
ΑΛΑΤΖΑ ΑΜΕΤ                                       
ΑΛΑΤΖΑ ΟΓΛΟΥ                                      
ΑΛΑΤΖΑΔΑΚΗΣ                                       
ΑΛΑΤΖΑΚΗΣ                                         
ΑΛΑΤΖΑΣ                                           
ΑΛΑΤΖΑΤΖ                                          
ΑΛΑΤΖΑΤΙΑΝΟΣ                                      
ΑΛΑΤΖΕΛΗΣ                                         
ΑΛΑΤΖΗΝΙΩΤΑΚΗΣ                                    
ΑΛΑΤΖΗΣ                                           
ΑΛΑΤΖΙΑΣ                                          
ΑΛΑΤΖΙΔΗΣ                                         
ΑΛΑΤΖΟΓΙΑΝΝΗΣ                                     
ΑΛΑΤΖΟΠΟΥΛΟΣ                                      
ΑΛΑΤΗΣ                                            
ΑΛΑΤΙΝΗΣ                                          
ΑΛΑΤΟΠΟΥΛΟΣ                                       
ΑΛΑΤΣΑΘΙΑΝΟΣ                                      
ΑΛΑΤΣΑΚΗΣ                                         
ΑΛΑΤΣΑΡΗΣ                                         
ΑΛΑΤΣΑΣ                                           
ΑΛΑΤΣΑΤΙΑΝΟΣ                                      
ΑΛΑΤΣΕΡΑΚΗΣ                                       
ΑΛΑΤΣΗΣ                                           
ΑΛΑΤΣΙΔΗΣ                                         
ΑΛΑΤΣΟΠΟΥΛΟΣ                                      
ΑΛΑΦΑΚΗΣ                                          
ΑΛΑΦΑΣΟΣ                                          
ΑΛΑΦΑΤΖΑΝΗΣ                                       
ΑΛΑΦΗΣ                                            
ΑΛΑΦΙΝΑΣ                                          
ΑΛΑΦΟΓΙΑΝΝΗΣ                                      
ΑΛΑΦΟΓΙΩΡΓΟΣ                                      
ΑΛΑΦΟΔΗΜΟΣ                                        
ΑΛΑΦΟΣΤΕΡΓΙΟΣ                                     
ΑΛΑΦΟΥΖΟΣ                                         
ΑΛΑΦΡΑΓΚΗΣ                                        
ΑΛΑΦΡΗΣ                                           
ΑΛΑΦΡΟΠΑΤΗΣ                                       
ΑΛΑΧΑΔΑΜΗΣ                                        
ΑΛΑΧΑΙΝΤΙΜΠ                                       
ΑΛΑΧΒΕΡΤΗΣ                                        
ΑΛΑΧΙΩΤΗΣ                                         
ΑΛΑΧΜΑΝΕΤΗΣ                                       
ΑΛΑΧΟΥΖΑΚΗΣ                                       
ΑΛΑΧΟΥΖΟΣ                                         
ΑΛΑΧΟΥΤΗΣ                                         
ΑΛΒΑΝΑΚΗΣ                                         
ΑΛΒΑΝΙΔΗΣ                                         
ΑΛΒΑΝΙΤΗΣ                                         
ΑΛΒΑΝΙΤΟΠΟΥΛΟΣ                                    
ΑΛΒΑΝΟΠΟΥΛΟΣ                                      
ΑΛΒΑΝΟΣ                                           
ΑΛΒΑΝΟΥΔΗΣ                                        
ΑΛΒΑΡΕΖ                                           
ΑΛΒΑΡΕΣ                                           
ΑΛΒΑΣ                                             
ΑΛΒΕΝΙΩΤΗΣ                                        
ΑΛΒΕΡΑΤΣΙΔΗΣ                                      
ΑΛΒΕΡΤΗΣ                                          
ΑΛΒΕΡΤΟΣ                                          
ΑΛΒΕΣ                                             
ΑΛΒΕΣ ΝΤΟ ΡΟΖΑΡΙΟ                                 
ΑΛΒΙΖΟΣ                                           
ΑΛΓΕΡΙΝΟΣ                                         
ΑΛΓΙΑΝΝΑΚΗΣ                                       
ΑΛΓΙΑΝΝΑΚΙΔΗΣ                                     
ΑΛΓΟΥΙΣ                                           
ΑΛΔΑΚΟΣ                                           
ΑΛΕΑΝΙΔΗΣ                                         
ΑΛΕΒΑΝΤΗΣ                                         
ΑΛΕΒΕΡΣ                                           
ΑΛΕΒΕΤΣΟΒΙΤΗΣ                                     
ΑΛΕΒΙΖΑΚΗΣ                                        
ΑΛΕΒΙΖΑΚΟΣ                                        
ΑΛΕΒΙΖΑΤΟΣ                                        
ΑΛΕΒΙΖΗΣ                                          
ΑΛΕΒΙΖΟΠΟΥΛΟΣ                                     
ΑΛΕΒΙΖΟΣ                                          
ΑΛΕΒΡΟΝΤΑΣ                                        
ΑΛΕΒΥΖΑΚΗΣ                                        
ΑΛΕΓΙΑΝΝΗΣ                                        
ΑΛΕΓΙΖΑΚΗΣ                                        
ΑΛΕΓΚΑΚΗΣ                                         
ΑΛΕΓΚΟΖ                                           
ΑΛΕΓΡΑΣ                                           
ΑΛΕΓΡΗΣ                                           
ΑΛΕΖΙΔΗΣ                                          
ΑΛΕΙΦΕΡΑΚΗΣ                                       
ΑΛΕΙΦΕΡΑΚΟΣ                                       
ΑΛΕΙΦΕΡΗΣ                                         
ΑΛΕΙΦΕΡΟΠΟΥΛΟΣ                                    
ΑΛΕΙΦΤΗΡΑΣ                                        
ΑΛΕΚΑΚΗΣ                                          
ΑΛΕΚΑΤΟΣ                                          
ΑΛΕΚΙΔΗΣ                                          
ΑΛΕΚΚΟΣ                                           
ΑΛΕΚΟΖΗΣ                                          
ΑΛΕΚΟΖΙΔΗΣ                                        
ΑΛΕΚΟΠΟΥΛΟΣ                                       
ΑΛΕΚΟΣ                                            
ΑΛΕΚΟΥΔΗΣ                                         
ΑΛΕΚΠΕΡΗΣ                                         
ΑΛΕΚΣΙΕΒΙΤΣ                                       
ΑΛΕΚΤΟΡΙΔΗΣ                                       
ΑΛΕΚΤΩΡΙΔΗΣ                                       
ΑΛΕΛΗΣ                                            
ΑΛΕΜΔΑΡ ΜΕΜΕΤ                                     
ΑΛΕΜΔΑΡ ΧΑΣΑΝ                                     
ΑΛΕΜΗΣ                                            
ΑΛΕΜΙΔΗΣ                                          
ΑΛΕΜΝΑΣ                                           
ΑΛΕΜΟΣ                                            
ΑΛΕΜΠΑΚΗΣ                                         
ΑΛΕΜΠΑΚΟΣ                                         
ΑΛΕΜΠΟΥΜΠΑΣ                                       
ΑΛΕΝΓΚΟΖ                                          
ΑΛΕΝΤΑΣ                                           
ΑΛΕΞ                                              
ΑΛΕΞΑΚΗΣ                                          
ΑΛΕΞΑΚΙΔΗΣ                                        
ΑΛΕΞΑΚΟΣ                                          
ΑΛΕΞΑΚΟΥΔΗΣ                                       
ΑΛΕΞΑΛΗΣ                                          
ΑΛΕΞΑΝΔΡΑΚΗΣ                                      
ΑΛΕΞΑΝΔΡΑΚΙΣ                                      
ΑΛΕΞΑΝΔΡΑΚΟΣ                                      
ΑΛΕΞΑΝΔΡΑΤΟΣ                                      
ΑΛΕΞΑΝΔΡΕΑΣ                                       
ΑΛΕΞΑΝΔΡΕΣΚΟΣ                                     
ΑΛΕΞΑΝΔΡΗΣ                                        
ΑΛΕΞΑΝΔΡΙΔΑΚΗΣ                                    
ΑΛΕΞΑΝΔΡΙΔΗΣ                                      
ΑΛΕΞΑΝΔΡΙΝΑΚΗΣ                                    
ΑΛΕΞΑΝΔΡΙΝΟΣ                                      
ΑΛΕΞΑΝΔΡΟΠΟΥΛΟΣ                                   
ΑΛΕΞΑΝΔΡΟΣ                                        
ΑΛΕΞΑΝΔΡΟΥΛΗΣ                                     
ΑΛΕΞΑΝΗΣ                                          
ΑΛΕΞΑΝΙΔΗΣ                                        
ΑΛΕΞΑΝΤΡΟΒΙΤΣ                                     
ΑΛΕΞΑΝΤΩΝΑΚΗΣ                                     
ΑΛΕΞΑΡΟΣ                                          
ΑΛΕΞΑΣ                                            
ΑΛΕΞΑΤΟΣ                                          
ΑΛΕΞΕΑΣ                                           
ΑΛΕΞΕΛΗΣ                                          
ΑΛΕΞΕΛΛΗΣ                                         
ΑΛΕΞΕΡΗΣ                                          
ΑΛΕΞΗΣ                                            
ΑΛΕΞΙΑΔΗΣ                                         
ΑΛΕΞΙΑΣ                                           
ΑΛΕΞΙΔΗΣ                                          
ΑΛΕΞΙΚΟΣ                                          
ΑΛΕΞΙΝΑΚΗΣ                                        
ΑΛΕΞΙΤΣ                                           
ΑΛΕΞΟΓΙΑΝΝΗΣ                                      
ΑΛΕΞΟΓΙΑΝΝΟΠΟΥΛΟΣ                                 
ΑΛΕΞΟΓΛΙΔΗΣ                                       
ΑΛΕΞΟΜΑΝΩΛΑΚΗΣ                                    
ΑΛΕΞΟΠΟΥΛΟΣ                                       
ΑΛΕΞΟΣ                                            
ΑΛΕΞΟΥΔΑΚΗΣ                                       
ΑΛΕΞΟΥΔΑΣ                                         
ΑΛΕΞΟΥΔΗΣ                                         
ΑΛΕΞΟΥΛΗΣ                                         
ΑΛΕΞΟΥΡΔΗΣ                                        
ΑΛΕΠΑΚΗΣ                                          
ΑΛΕΠΑΚΟΣ                                          
ΑΛΕΠΑΣ                                            
ΑΛΕΠΗΣ                                            
ΑΛΕΠΙΔΑΣ                                          
ΑΛΕΠΙΔΗΣ                                          
ΑΛΕΠΙΖΑΚΗΣ                                        
ΑΛΕΠΛΙΩΤΗΣ                                        
ΑΛΕΠΟΔΑΣ                                          
ΑΛΕΠΟΠΟΥΛΟΣ                                       
ΑΛΕΠΟΡΟΣ                                          
ΑΛΕΠΟΥΔΑΚΗΣ                                       
ΑΛΕΠΟΥΔΑΣ                                         
ΑΛΕΠΟΥΔΕΑΣ                                        
ΑΛΕΠΟΥΔΕΛΗΣ                                       
ΑΛΕΠΟΥΔΕΛΛΗΣ                                      
ΑΛΕΠΟΥΔΗΣ                                         
ΑΛΕΠΟΥΣ                                           
ΑΛΕΠΟΧΩΡΙΤΗΣ                                      
ΑΛΕΡΤΑΣ                                           
ΑΛΕΣΙΟΣ                                           
ΑΛΕΣΤΑΣ                                           
ΑΛΕΤΟΥΡΑΚΟΣ                                       
ΑΛΕΤΡΑΚΗΣ                                         
ΑΛΕΤΡΑΡΗΣ                                         
ΑΛΕΤΡΑΣ                                           
ΑΛΕΤΡΗΣ                                           
ΑΛΕΥΡΑΚΗΣ                                         
ΑΛΕΥΡΑΣ                                           
ΑΛΕΥΡΕΑΣ                                          
ΑΛΕΥΡΗΣ                                           
ΑΛΕΥΡΙΑΔΗΣ                                        
ΑΛΕΥΡΙΔΗΣ                                         
ΑΛΕΥΡΙΤΗΣ                                         
ΑΛΕΥΡΟΓΙΑΝΝΗΣ                                     
ΑΛΕΥΡΟΜΑΓΕΙΡΑΣ                                    
ΑΛΕΥΡΟΜΑΓΕΙΡΟΣ                                    
ΑΛΕΥΡΟΜΥΤΗΣ                                       
ΑΛΕΥΡΟΝΤΑΣ                                        
ΑΛΕΥΡΟΠΟΥΛΟΣ                                      
ΑΛΕΥΡΟΥΔΗΣ                                        
ΑΛΕΥΡΟΦΑΣ                                         
ΑΛΕΦΑΝΤΑΚΗΣ                                       
ΑΛΕΦΑΝΤΖΗΣ                                        
ΑΛΕΦΑΝΤΗΣ                                         
ΑΛΕΦΑΝΤΙΝΟΣ                                       
ΑΛΕΦΑΝΤΟΠΟΥΛΟΣ                                    
ΑΛΕΦΑΝΤΟΣ                                         
ΑΛΕΦΑΣΙΔΗΣ                                        
ΑΛΕΦΡΑΓΓΗΣ                                        
ΑΛΕΦΡΑΓΚΗΣ                                        
ΑΛΕΧΑΝΙΔΗΣ                                        
ΑΛΕΩΝΗΣ                                           
ΑΛΗ ΑΓΑ                                           
ΑΛΗ ΑΓΑ ΜΟΥΣΤΑΦΑ ΧΟΥΣΕΙΝ                          
ΑΛΗ ΑΓΑ ΟΓΛΟΥ                                     
ΑΛΗ ΑΓΑ ΧΑΣΑΝ                                     
ΑΛΗ ΑΓΑ ΧΟΥΣΕΙΝ                                   
ΑΛΗ ΑΛΑΡ                                          
ΑΛΗ ΑΛΗ                                           
ΑΛΗ ΑΜΕΤ                                          
ΑΛΗ ΑΡΑΠ                                          
ΑΛΗ ΑΧΜΕΤ                                         
ΑΛΗ ΓΙΟΥΣΟΥΦ                                      
ΑΛΗ ΓΚΑΟΥΧΑΡ                                      
ΑΛΗ ΓΚΑΤΖΗ                                        
ΑΛΗ ΓΚΙΟΥΒΕΗ                                      
ΑΛΗ ΔΑΗ                                           
ΑΛΗ ΔΑΗ ΧΟΥΣΕΙΝ                                   
ΑΛΗ ΔΑΗ ΧΟΥΣΕΙΝ ΟΓΛΟΥ                             
ΑΛΗ ΕΛ ΣΕΡΙΦ                                      
ΑΛΗ ΕΦΕΝΤΗ                                        
ΑΛΗ ΕΦΕΝΤΗ ΧΑΣΑΝΟΓΛΟΥ                             
ΑΛΗ ΙΜΠΡΑΗΜ                                       
ΑΛΗ ΙΜΠΡΑΜ                                        
ΑΛΗ ΙΜΠΡΑΜ ΟΓΛΟΥ                                  
ΑΛΗ ΙΣΜΑΗΛ                                        
ΑΛΗ ΚΑΔΗΡ                                         
ΑΛΗ ΚΕΧΑΓΙΑ                                       
ΑΛΗ ΚΕΧΑΓΙΑ ΡΕΤΖΕΠ                                
ΑΛΗ ΚΕΧΑΓΙΑ ΧΑΣΑΝ                                 
ΑΛΗ ΚΕΧΑΧΙΑ                                       
ΑΛΗ ΚΙΟΥΒΕΓΗ                                      
ΑΛΗ ΚΙΟΥΤΣΟΥΚ                                     
ΑΛΗ ΜΕΜΕΤ                                         
ΑΛΗ ΜΟΛΛΑ                                         
ΑΛΗ ΜΟΥΜΙΝ                                        
ΑΛΗ ΜΟΥΣΤΑΦΑ                                      
ΑΛΗ ΜΠΑΣ                                          
ΑΛΗ ΜΠΑΣ ΟΓΛΟΥ                                    
ΑΛΗ ΜΠΑΣΗ                                         
ΑΛΗ ΜΠΑΣΗ ΙΣΜΑΗΛ                                  
ΑΛΗ ΜΠΑΣΙΑ                                        
ΑΛΗ ΜΠΑΣΟΓΛΟΥ                                     
ΑΛΗ ΝΑΛΜΠΑΝΤ                                      
ΑΛΗ ΝΤΑΗ                                          
ΑΛΗ ΝΤΑΗ ΟΓΛΟΥ                                    
ΑΛΗ ΝΤΑΗ ΧΑΣΑΝ                                    
ΑΛΗ ΝΤΟΥΡΜΟΥΣ                                     
ΑΛΗ ΟΒΑΛΗ ΑΛΗ                                     
ΑΛΗ ΟΓΛΟΥ                                         
ΑΛΗ ΟΓΛΟΥ ΙΣΜΑΗΛ                                  
ΑΛΗ ΟΓΛΟΥ ΚΙΟΥΤΣΟΥΚ                               
ΑΛΗ ΟΓΛΟΥ ΜΕΜΕΤ                                   
ΑΛΗ ΟΓΛΟΥ ΜΕΧΜΕΤ                                  
ΑΛΗ ΟΓΛΟΥ ΧΗ ΧΑΦΟΥΖ                               
ΑΛΗ ΟΣΜΑΝ                                         
ΑΛΗ ΟΣΜΑΝ ΙΣΜΑΗΛ                                  
ΑΛΗ ΟΣΜΑΝ ΟΓΛΟΥ                                   
ΑΛΗ ΟΣΜΑΝ ΣΑΔΗΚ                                   
ΑΛΗ ΟΣΜΑΝ ΧΑΣΑΝ                                   
ΑΛΗ ΟΥΣΣΑ                                         
ΑΛΗ ΟΥΣΤΑ                                         
ΑΛΗ ΠΑΣΑ ΜΕΜΕΤ                                    
ΑΛΗ ΠΑΣΣΑ                                         
ΑΛΗ ΠΕΧΛΕΒΑΝ                                      
ΑΛΗ ΠΕΧΛΙΒΑΝ                                      
ΑΛΗ ΠΟΡΓΙΑΖ                                       
ΑΛΗ ΡΑΗΦ                                          
ΑΛΗ ΡΕΜΖΗ ΟΓΛΟΥ                                   
ΑΛΗ ΡΕΤΖΕΠ                                        
ΑΛΗ ΡΕΦΙΚ                                         
ΑΛΗ ΡΙΖΑ                                          
ΑΛΗ ΡΙΖΑ-ΣΟΙΧΑΝ                                   
ΑΛΗ ΣΑΛΗ                                          
ΑΛΗ ΣΑΜΗ                                          
ΑΛΗ ΣΕΛΑΕΔΙΝ                                      
ΑΛΗ ΣΙΑΜ                                          
ΑΛΗ ΤΑΜΠΑΚ ΟΓΛΟΥ                                  
ΑΛΗ ΤΑΣΗΜ ΧΑΣΑΝ                                   
ΑΛΗ ΤΑΣΗΝ                                         
ΑΛΗ ΤΑΣΙΝ                                         
ΑΛΗ ΤΑΧΗΡ                                         
ΑΛΗ ΤΕΦΙΚ                                         
ΑΛΗ ΤΖΑΜΠΑΖ                                       
ΑΛΗ ΤΖΙΒΑΝ                                        
ΑΛΗ ΤΣΑΟΥΣ                                        
ΑΛΗ ΤΣΑΟΥΣ ΑΛΗ ΟΓΛΟΥ                              
ΑΛΗ ΤΣΑΟΥΣ ΑΠΤΟΥΛΑ                                
ΑΛΗ ΤΣΑΟΥΣ ΑΠΤΟΥΛΑ ΟΓΛΟΥ                          
ΑΛΗ ΤΣΑΟΥΣ ΟΓΛΟΥ                                  
ΑΛΗ ΤΣΑΟΥΣ ΧΑΣΑΝ                                  
ΑΛΗ ΤΣΑΟΥΣ ΧΟΥΣΕΙΝ                                
ΑΛΗ ΤΣΙΑΟΥΣ                                       
ΑΛΗ ΤΣΙΤΑΚ                                        
ΑΛΗ ΤΣΟΜΕΖ                                        
ΑΛΗ ΦΕΙΖ                                          
ΑΛΗ ΧΑΛΗΛ                                         
ΑΛΗ ΧΑΣΑΝ                                         
ΑΛΗ ΧΑΣΑΝ ΟΓΛΟΥ                                   
ΑΛΗ ΧΑΣΑΝ ΣΟΛΟΥΚΤΣΗ                               
ΑΛΗ ΧΑΣΗΜ                                         
ΑΛΗ ΧΑΣΣΑΝ                                        
ΑΛΗ ΧΑΤΖΗ ΣΟΜΠΑΤΖΗ                                
ΑΛΗ ΧΑΤΗΠ                                         
ΑΛΗ ΧΟΤΖΑ                                         
ΑΛΗ ΧΟΥΣΕΙΝ                                       
ΑΛΗΑΔΗΣ                                           
ΑΛΗΒΑΝΗΣ                                          
ΑΛΗΒΡΟΥΒΑΣ                                        
ΑΛΗΓΕΩΡΓΑΣ                                        
ΑΛΗΓΙΑΝΝΗΣ                                        
ΑΛΗΓΙΑΝΝΙΔΗΣ                                      
ΑΛΗΓΙΖΑΚΗΣ                                        
ΑΛΗΓΙΩΡΓΑΣ                                        
ΑΛΗΓΟΡΙΔΗΣ                                        
ΑΛΗΓΡΟΥΣ                                          
ΑΛΗΔΡΟΜΙΤΗΣ                                       
ΑΛΗΖΙΩΤΗΣ                                         
ΑΛΗΖΩΤΗΣ                                          
ΑΛΗΘΕΙΝΟΣ                                         
ΑΛΗΘΙΝΑΙΟΣ                                        
ΑΛΗΘΙΝΟΣ                                          
ΑΛΗΚΑΡΗΣ                                          
ΑΛΗΚΑΡΙΔΗΣ                                        
ΑΛΗΚΟΤΣΗΣ                                         
ΑΛΗΜ ΜΕΜΕΤ                                        
ΑΛΗΜ ΟΓΛΟΥ                                        
ΑΛΗΜΑΝ ΟΓΛΟΥ                                      
ΑΛΗΜΑΝ ΡΙΦΑΤ                                      
ΑΛΗΜΑΝΤΗΡΗΣ                                       
ΑΛΗΜΑΤΗΡΗΣ                                        
ΑΛΗΜΑΤΙΡΗΣ                                        
ΑΛΗΜΙΣΗΣ                                          
ΑΛΗΜΠΑΚΗΣ                                         
ΑΛΗΜΠΑΛΗΣ                                         
ΑΛΗΜΠΑΜΠΑ ΟΓΛΟΥ                                   
ΑΛΗΜΠΑΜΠΟΥΔΗΣ                                     
ΑΛΗΜΠΑΝΤΕΣ                                        
ΑΛΗΜΠΑΡΟΥΤΗΣ                                      
ΑΛΗΜΠΑΣ                                           
ΑΛΗΜΠΑΣ ΚΟΤΖΑ ΑΛΗ                                 
ΑΛΗΜΠΑΤΕΣ                                         
ΑΛΗΜΠΕΡΤΗΣ                                        
ΑΛΗΜΠΕΡΤΟΣ                                        
ΑΛΗΜΠΟΝΤΑΚΗΣ                                      
ΑΛΗΜΠΟΥΝΤΑΝΗΣ                                     
ΑΛΗΜΠΟΥΤΑΝΗΣ                                      
ΑΛΗΜΠΡΑΝΤΗΣ                                       
ΑΛΗΝΤΑΗ ΟΓΛΟΥ                                     
ΑΛΗΟΣΜΑΝ ΑΛΗ                                      
ΑΛΗΟΣΜΑΝ ΟΓΛΟΥ                                    
ΑΛΗΠΑΣΑΛΗΣ                                        
ΑΛΗΠΑΣΣΑΛΗΣ                                       
ΑΛΗΠΑΣΣΑΣ                                         
ΑΛΗΠΛΙΩΤΗΣ                                        
ΑΛΗΠΡΑΝΤΗΣ                                        
ΑΛΗΠΡΑΣΙΤΗΣ                                       
ΑΛΗΡΗΣ                                            
ΑΛΗΣ                                              
ΑΛΗΣΑ ΟΓΛΟΥ                                       
ΑΛΗΣΑΒΑΚΗΣ                                        
ΑΛΗΣΑΒΒΑΣ                                         
ΑΛΗΣΑΦΑΚΗΣ                                        
ΑΛΗΣΑΦΗΣ                                          
ΑΛΗΣΑΦΟΣ                                          
ΑΛΗΣΙΑΝΗΣ                                         
ΑΛΗΣΜΟΝΗΣ                                         
ΑΛΗΣΤΡΑΤΛΗΣ                                       
ΑΛΗΤΖΑΜΠΑΖ                                        
ΑΛΗΤΖΑΝΙΔΗΣ                                       
ΑΛΗΤΖΙΚ ΑΛΗ                                       
ΑΛΗΤΟΚΑΣ                                          
ΑΛΗΤΣΙΟΣ                                          
ΑΛΗΦΑΚΙΩΤΗΣ                                       
ΑΛΗΦΑΝΤΑΡΟΣ                                       
ΑΛΗΦΑΝΤΗΣ                                         
ΑΛΗΦΑΡΜΑΚΗΣ                                       
ΑΛΗΦΕΡΗΣ                                          
ΑΛΗΦΟΝΣΟΣ                                         
ΑΛΗΦΡΑΓΚΗΣ                                        
ΑΛΗΧΑΝΙΔΗΣ                                        
ΑΛΗΧΟΝΤΖΩΤΗΣ                                      
ΑΛΙ ΧΑΣΑΝ                                         
ΑΛΙΑΓΑΣ                                           
ΑΛΙΑΔΑΣ                                           
ΑΛΙΑΔΗΣ                                           
ΑΛΙΑΖΗΣ                                           
ΑΛΙΑΙΤΣΗΣ                                         
ΑΛΙΑΜΗΣ                                           
ΑΛΙΑΝΑΚΗΣ                                         
ΑΛΙΑΝΙΔΗΣ                                         
ΑΛΙΑΠΟΥΛΙΟΣ                                       
ΑΛΙΑΤΑΚΗΣ                                         
ΑΛΙΑΤΑΣ                                           
ΑΛΙΑΤΗΣ                                           
ΑΛΙΑΤΙΔΗΣ                                         
ΑΛΙΑΤΣΗΣ                                          
ΑΛΙΒΑΝΗΣ                                          
ΑΛΙΒΑΝΙΣΤΟΣ                                       
ΑΛΙΒΑΝΤΗΣ                                         
ΑΛΙΒΕΡΙΩΤΗΣ                                       
ΑΛΙΒΕΡΤΗΣ                                         
ΑΛΙΒΙΖΑΤΟΣ                                        
ΑΛΙΒΙΖΟΠΟΥΛΟΣ                                     
ΑΛΙΒΙΖΟΣ                                          
ΑΛΙΒΡΟΥΒΑΣ                                        
ΑΛΙΓΗΖΑΚΗΣ                                        
ΑΛΙΓΙΑΝΝΗΣ                                        
ΑΛΙΓΙΖΑΚΗΣ                                        
ΑΛΙΓΚΑΣ                                           
ΑΛΙΓΟΥΝΑΡΓΙΑΣ                                     
ΑΛΙΔΗΣ                                            
ΑΛΙΔΙΝΗΣ                                          
ΑΛΙΔΡΟΜΙΤΗΣ                                       
ΑΛΙΕΒΙΔΗΣ                                         
ΑΛΙΕΥΣ                                            
ΑΛΙΕΩΣ                                            
ΑΛΙΖΙΩΤΗΣ                                         
ΑΛΙΖΩΤΗΣ                                          
ΑΛΙΘΑΡΙΤΗΣ                                        
ΑΛΙΚΑΚΗΣ                                          
ΑΛΙΚΑΚΟΣ                                          
ΑΛΙΚΑΜΠΙΩΤΗΣ                                      
ΑΛΙΚΑΝΑΣ                                          
ΑΛΙΚΑΝΙΩΤΗΣ                                       
ΑΛΙΚΑΡΗΣ                                          
ΑΛΙΚΑΡΙΔΗΣ                                        
ΑΛΙΚΑΤΟΡΑΣ                                        
ΑΛΙΚΙΑΡΗΣ                                         
ΑΛΙΚΙΔΗΣ                                          
ΑΛΙΚΙΩΤΗΣ                                         
ΑΛΙΚΟΤΣΗΣ                                         
ΑΛΙΚΟΥΛΗΣ                                         
ΑΛΙΜΑΝ ΟΓΛΟΥ                                      
ΑΛΙΜΑΝΤΗΡΗΣ                                       
ΑΛΙΜΑΝΤΙΔΗΣ                                       
ΑΛΙΜΑΝΤΙΡΗΣ                                       
ΑΛΙΜΑΤΗΡΗΣ                                        
ΑΛΙΜΑΤΙΔΗΣ                                        
ΑΛΙΜΕΝΟΣ                                          
ΑΛΙΜΗΣ                                            
ΑΛΙΜΗΣΗΣ                                          
ΑΛΙΜΟΝΑΚΗΣ                                        
ΑΛΙΜΟΥΔΗΣ                                         
ΑΛΙΜΠΑΚΗΣ                                         
ΑΛΙΜΠΑΛΗΣ                                         
ΑΛΙΜΠΕΡΤΗΣ                                        
ΑΛΙΜΠΙΝΙΣΗΣ                                       
ΑΛΙΜΠΟΥΜΠΑΣ                                       
ΑΛΙΜΠΡΑΝΤΗΣ                                       
ΑΛΙΝΙΑΚΗΣ                                         
ΑΛΙΟΓΚΑΣ                                          
ΑΛΙΟΥΣΗΣ                                          
ΑΛΙΠΑΝΟΠΟΥΛΟΣ                                     
ΑΛΙΠΑΣ                                            
ΑΛΙΠΛΙΩΤΗΣ                                        
ΑΛΙΠΡΑΝΤΗΣ                                        
ΑΛΙΡΗΣ                                            
ΑΛΙΣΑΒΑΚΗΣ                                        
ΑΛΙΣΑΝΔΡΑΤΟΣ                                      
ΑΛΙΣΑΦΗΣ                                          
ΑΛΙΣΣΑΒΑΚΗΣ                                       
ΑΛΙΣΣΑΝΔΡΑΤΟΣ                                     
ΑΛΙΣΣΑΦΗΣ                                         
ΑΛΙΣΤΡΑΤΗΝΟΣ                                      
ΑΛΙΣΤΡΑΤΙΝΟΣ                                      
ΑΛΙΣΤΡΑΤΛΗΣ                                       
ΑΛΙΤΖΑΝΙΔΗΣ                                       
ΑΛΙΤΖΙΚ ΑΜΕΤ ΟΓΛΟΥ                                
ΑΛΙΤΣΑΝΙΔΗΣ                                       
ΑΛΙΤΣΗΣ                                           
ΑΛΙΤΣΙΚ ΑΧΜΕΤ                                     
ΑΛΙΤΣΙΚ ΟΓΛΟΥ                                     
ΑΛΙΦΑΝΤΑΚΗΣ                                       
ΑΛΙΦΑΝΤΑΡΟΣ                                       
ΑΛΙΦΑΝΤΗΣ                                         
ΑΛΙΦΑΡΜΑΚΗΣ                                       
ΑΛΙΦΑΣΙΔΗΣ                                        
ΑΛΙΦΕΡΑΚΗΣ                                        
ΑΛΙΦΕΡΗΣ                                          
ΑΛΙΦΕΡΟΠΟΥΛΟΣ                                     
ΑΛΙΦΙΕΡΑΚΗΣ                                       
ΑΛΙΦΙΕΡΗΣ                                         
ΑΛΙΦΟΝΣΟΣ                                         
ΑΛΙΦΡΑΓΚΗΣ                                        
ΑΛΙΦΤΗΡΑΣ                                         
ΑΛΙΧΑΝΙΔΗΣ                                        
ΑΛΙΧΟΣ                                            
ΑΛΙΩΖΗΣ                                           
ΑΛΙΩΠΗΣ                                           
ΑΛΙΩΡΗΣ                                           
ΑΛΙΩΣΗΣ                                           
ΑΛΙΩΤΗΣ                                           
ΑΛΚΑΛΑΗΣ                                          
ΑΛΚΑΛΑΚΗΣ                                         
ΑΛΚΑΜΠΕΣ                                          
ΑΛΚΑΡΑΖ                                           
ΑΛΚΙΒΙΑΔΗΣ                                        
ΑΛΚΙΔΗΣ                                           
ΑΛΚΙΜΟΣ                                           
ΑΛΚΟΣ                                             
ΑΛΚΟΥΣΑΚΗΣ                                        
ΑΛΚΟΥΣΗΣ                                          
ΑΛΛΑΓΙΑΝΝΗΣ                                       
ΑΛΛΑΓΙΩΤΗΣ                                        
ΑΛΛΑΜΑΝΗΣ                                         
ΑΛΛΑΝΤΑΛΑΣ                                        
ΑΛΛΑΣ                                             
ΑΛΛΗ ΟΓΛΟΥ                                        
ΑΛΛΗΓΙΑΝΝΗΣ                                       
ΑΛΛΗΛΕΓΓΟΣ                                        
ΑΛΛΗΛΕΓΚΟΣ                                        
ΑΛΛΗΛΟΜΗΣ                                         
ΑΛΛΙΟΣ                                            
ΑΛΛΟΙΜΟΝΟΣ                                        
ΑΛΛΟΥΣ                                            
ΑΛΜΑΖΙΔΗΣ                                         
ΑΛΜΑΚΙΔΗΣ                                         
ΑΛΜΑΛΗΣ                                           
ΑΛΜΑΛΙΩΤΗΣ                                        
ΑΛΜΑΝΑΚΗΣ                                         
ΑΛΜΑΝΙΔΗΣ                                         
ΑΛΜΑΝΛΗΣ                                          
ΑΛΜΑΝΤΑΡΙΩΤΗΣ                                     
ΑΛΜΑΣΙΔΗΣ                                         
ΑΛΜΑΤΖΗΣ                                          
ΑΛΜΕΤΙΔΗΣ                                         
ΑΛΜΙΡΑΝΤΗΣ                                        
ΑΛΜΠΑΚΡΗΣ                                         
ΑΛΜΠΑΛΑΣ                                          
ΑΛΜΠΑΝΑΚΗΣ                                        
ΑΛΜΠΑΝΕΖΟΣ                                        
ΑΛΜΠΑΝΕΛΛΗΣ                                       
ΑΛΜΠΑΝΗΣ                                          
ΑΛΜΠΑΝΙΔΗΣ                                        
ΑΛΜΠΑΝΟΠΟΥΛΟΣ                                     
ΑΛΜΠΑΝΟΥΔΗΣ                                       
ΑΛΜΠΑΝΤΑΚΗΣ                                       
ΑΛΜΠΑΝΤΗΣ                                         
ΑΛΜΠΑΝΤΙΔΗΣ                                       
ΑΛΜΠΑΝΤΟΠΟΥΛΟΣ                                    
ΑΛΜΠΑΡΕΖ                                          
ΑΛΜΠΑΤΗΣ                                          
ΑΛΜΠΕΡΗΣ                                          
ΑΛΜΠΕΡΣ                                           
ΑΛΜΠΕΡΤΗΣ                                         
ΑΛΜΠΕΡΤΟΣ                                         
ΑΛΜΠΟΥΝΙΩΤΗΣ                                      
ΑΛΜΠΟΥΡΑΣ                                         
ΑΛΜΥΡΑΚΗΣ                                         
ΑΛΜΥΡΑΝΤΕΣ                                        
ΑΛΜΥΡΑΝΤΗΣ                                        
ΑΛΜΥΡΑΣ                                           
ΑΛΜΥΡΙΩΤΗΣ                                        
ΑΛΜΥΡΟΣ                                           
ΑΛΜΥΡΟΥΔΗΣ                                        
ΑΛΜΥΡΟΥΛΗΣ                                        
ΑΛΝΤΑΝΗΣ                                          
ΑΛΝΤΟΥΣ                                           
ΑΛΟΒΟΣΕΛΗΣ                                        
ΑΛΟΓΑΚΟΣ                                          
ΑΛΟΓΑΡΑΣ                                          
ΑΛΟΓΑΡΗΣ                                          
ΑΛΟΓΑΡΙΑΣΤΟΣ                                      
ΑΛΟΓΑΣ                                            
ΑΛΟΓΔΕΛΛΗΣ                                        
ΑΛΟΓΔΙΑΝΑΚΗΣ                                      
ΑΛΟΓΟΓΙΑΝΝΗΣ                                      
ΑΛΟΓΟΜΙΑΣ                                         
ΑΛΟΓΟΣΚΟΥΦΗΣ                                      
ΑΛΟΔΙΑΝΑΚΗΣ                                       
ΑΛΟΙΔΗΣ                                           
ΑΛΟΙΖΟΣ                                           
ΑΛΟΙΜΕΝΟΣ                                         
ΑΛΟΙΜΟΝΑΚΗΣ                                       
ΑΛΟΙΜΟΝΟΣ                                         
ΑΛΟΚΡΙΟΣ                                          
ΑΛΟΣΚΟΦΗΣ                                         
ΑΛΟΤΡΙΑΔΗΣ                                        
ΑΛΟΥΓΔΕΛΗΣ                                        
ΑΛΟΥΚΟΣ                                           
ΑΛΟΥΜΑΝΗΣ                                         
ΑΛΟΥΜΠΗΣ                                          
ΑΛΟΥΠΗΣ                                           
ΑΛΟΥΠΟΓΙΑΝΝΗΣ                                     
ΑΛΟΥΡΔΑΣ                                          
ΑΛΟΥΡΗΣ                                           
ΑΛΟΥΣΗΣ                                           
ΑΛΟΥΤΖΑΝΙΔΗΣ                                      
ΑΛΟΥΤΣΑΝΙΔΗΣ                                      
ΑΛΠ                                               
ΑΛΠΑΚΗΣ                                           
ΑΛΠΑΝΑΚΗΣ                                         
ΑΛΠΑΝΕΖΟΣ                                         
ΑΛΠΑΝΗΣ                                           
ΑΛΠΑΝΙΔΗΣ                                         
ΑΛΠΑΝΤΑΚΗΣ                                        
ΑΛΠΑΝΤΗΣ                                          
ΑΛΠΑΣ                                             
ΑΛΠΕΝΤΖΟΣ                                         
ΑΛΠΕΡΤΗΣ                                          
ΑΛΠΕΤΖΟΣ                                          
ΑΛΠΗΣ                                             
ΑΛΠΙΔΗΣ                                           
ΑΛΠΙΤΣΗΣ                                          
ΑΛΠΟΓΙΑΝΝΗΣ                                       
ΑΛΠΟΣ                                             
ΑΛΠΟΥΣ                                            
ΑΛΠΟΧΩΡΙΤΗΣ                                       
ΑΛΣΟΥΕΙΣ                                          
ΑΛΣΩΝΑΣ                                           
ΑΛΤΑΚΗΣ                                           
ΑΛΤΑΛΙΚΗΣ                                         
ΑΛΤΑΝΗΣ                                           
ΑΛΤΑΝΟΠΟΥΛΟΣ                                      
ΑΛΤΑΝΤΖΗΣ                                         
ΑΛΤΑΝΤΣΙΔΗΣ                                       
ΑΛΤΑΣ                                             
ΑΛΤΑΤΖΙΔΗΣ                                        
ΑΛΤΖΕΡΙΝΗΣ                                        
ΑΛΤΗΠΑΡΜΑΚΗΣ                                      
ΑΛΤΗΣ                                             
ΑΛΤΙΔΗΣ                                           
ΑΛΤΙΚΑΤΗΣ                                         
ΑΛΤΙΚΑΤΙΔΗΣ                                       
ΑΛΤΙΚΗΣ                                           
ΑΛΤΙΚΟΛΑΤΣΗΣ                                      
ΑΛΤΙΚΟΥΛΑΚΗΣ                                      
ΑΛΤΙΚΟΥΛΑΤΣΗΣ                                     
ΑΛΤΙΛΙΚΗΣ                                         
ΑΛΤΙΜΗΣΗΣ                                         
ΑΛΤΙΜΗΣΙΣ                                         
ΑΛΤΙΜΙΣΗΣ                                         
ΑΛΤΙΜΠΑΡΜΑΚΗΣ                                     
ΑΛΤΙΜΠΑΣΗΣ                                        
ΑΛΤΙΝΑΚΗΣ                                         
ΑΛΤΙΝΑΛΜΑΖΗΣ                                      
ΑΛΤΙΝΗΣ                                           
ΑΛΤΙΝΙΔΗΣ                                         
ΑΛΤΙΝΜΠΑΣ                                         
ΑΛΤΙΝΟΣ                                           
ΑΛΤΙΝΤΑΣΙΩΤΗΣ                                     
ΑΛΤΙΝΤΖΗΣ                                         
ΑΛΤΙΝΤΗΣ                                          
ΑΛΤΙΝΤΟΠ                                          
ΑΛΤΙΝΤΟΠΗΣ                                        
ΑΛΤΙΟΚΑΣ                                          
ΑΛΤΙΠΑΡΗΣ                                         
ΑΛΤΙΠΑΡΜΑΚΗΣ                                      
ΑΛΤΙΠΑΡΜΑΚΙΔΗΣ                                    
ΑΛΤΟΚΑΣ                                           
ΑΛΤΟΚΙΔΗΣ                                         
ΑΛΤΟΜΑΡΙΑΝΟΣ                                      
ΑΛΤΟΜΥΡΙΑΝΟΣ                                      
ΑΛΤΟΥΒΑΣ                                          
ΑΛΤΟΥΝΗΣ                                          
ΑΛΤΟΥΝΙΑΤΗΣ                                       
ΑΛΤΟΥΝΤΑΣ                                         
ΑΛΤΣΑΝΤΖΗΣ                                        
ΑΛΤΣΑΤΖΗΣ                                         
ΑΛΤΣΙΑΔΗΣ                                         
ΑΛΤΣΙΤΣΙΑΔΗΣ                                      
ΑΛΥ ΜΑΡΣΑΚΗ                                       
ΑΛΥ ΜΑΣΡΑΚΗ                                       
ΑΛΥ ΝΟΥΡ                                          
ΑΛΥ ΦΑΧΜΙ                                         
ΑΛΥΓΙΖΑΚΗΣ                                        
ΑΛΥΓΙΖΟΣ                                          
ΑΛΥΚΑΡΗΣ                                          
ΑΛΥΚΑΡΙΔΗΣ                                        
ΑΛΥΚΑΤΟΡΑΣ                                        
ΑΛΥΚΙΩΤΗΣ                                         
ΑΛΥΜΑΝΤΗΡΗΣ                                       
ΑΛΥΜΑΡΑΣ                                          
ΑΛΥΜΑΤΗΡΗΣ                                        
ΑΛΥΜΟΣ                                            
ΑΛΥΜΠΑΚΗΣ                                         
ΑΛΥΜΠΕΡΤΗΣ                                        
ΑΛΥΠΟΣ                                            
ΑΛΥΣΑΒΑΚΗΣ                                        
ΑΛΥΣΑΝΔΡΑΚΗΣ                                      
ΑΛΥΣΑΝΔΡΑΤΟΣ                                      
ΑΛΥΣΑΝΔΡΟΣ                                        
ΑΛΥΣΣΑΒΑΚΗΣ                                       
ΑΛΥΣΣΑΝΔΡΑΚΗΣ                                     
ΑΛΥΣΣΑΝΔΡΑΤΟΣ                                     
ΑΛΥΦΑΝΤΑΡΟΣ                                       
ΑΛΥΦΑΝΤΗΣ                                         
ΑΛΥΧΟΣ                                            
ΑΛΦΑΝΤΑΚΗΣ                                        
ΑΛΦΑΝΤΖΗΣ                                         
ΑΛΦΑΝΤΗΣ                                          
ΑΛΦΑΡΑΣ                                           
ΑΛΦΑΡΙΣ                                           
ΑΛΦΑΣ                                             
ΑΛΦΑΤΖΗΣ                                          
ΑΛΦΕΑΣ                                            
ΑΛΦΙΕΡΗΣ                                          
ΑΛΦΟΝΣΟΣ                                          
ΑΛΧΑΖΑΣ                                           
ΑΛΧΑΖΙΔΗΣ                                         
ΑΛΧΑΝΑΤΗΣ                                         
ΑΛΧΑΤΖΙΔΗΣ                                        
ΑΛΩΝΑΡΗΣ                                          
ΑΛΩΝΑΡΙΤΗΣ                                        
ΑΛΩΝΕΥΤΗΣ                                         
ΑΛΩΝΙΑΤΗΣ                                         
ΑΛΩΝΙΔΗΣ                                          
ΑΛΩΝΙΝΟΣ                                          
ΑΛΩΝΙΣΙΩΤΗΣ                                       
ΑΛΩΝΙΣΤΙΩΤΗΣ                                      
ΑΛΩΠΟΥΔΗΣ                                         
ΑΜΑΔΗΣ                                            
ΑΜΑΗΣ                                             
ΑΜΑΛΑΝΤΗΣ                                         
ΑΜΑΛΑΡΓΙΩΤΗΣ                                      
ΑΜΑΛΙΑΔΗΣ                                         
ΑΜΑΛΙΔΗΣ                                          
ΑΜΑΛΛΟΣ                                           
ΑΜΑΝΑΚΗΣ                                          
ΑΜΑΝΑΤΙΑΔΗΣ                                       
ΑΜΑΝΑΤΙΔΗΣ                                        
ΑΜΑΝΑΤΟΠΟΥΛΟΣ                                     
ΑΜΑΝΕΣ                                            
ΑΜΑΝΕΤΖΗΣ                                         
ΑΜΑΝΕΤΙΔΗΣ                                        
ΑΜΑΝΕΤΟΠΟΥΛΟΣ                                     
ΑΜΑΝΙΔΗΣ                                          
ΑΜΑΝΙΟΣ                                           
ΑΜΑΝΙΤΗΣ                                          
ΑΜΑΝΤΟΣ                                           
ΑΜΑΝΤΣΙΤΣ                                         
ΑΜΑΞΑΣ                                            
ΑΜΑΞΗΛΑΤΗΣ                                        
ΑΜΑΞΗΣ                                            
ΑΜΑΞΙΔΗΣ                                          
ΑΜΑΞΙΤΖΙΔΗΣ                                       
ΑΜΑΞΟΠΟΙΟΣ                                        
ΑΜΑΞΟΠΟΥΛΟΣ                                       
ΑΜΑΡΑΝΤΗΓΟΣ                                       
ΑΜΑΡΑΝΤΙΔΗΣ                                       
ΑΜΑΡΑΝΤΙΝΗΣ                                       
ΑΜΑΡΑΝΤΟΣ                                         
ΑΜΑΡΓΙΑΝΑΚΗΣ                                      
ΑΜΑΡΓΙΑΝΙΤΑΚΗΣ                                    
ΑΜΑΡΓΙΑΝΝΙΤΑΚΗΣ                                   
ΑΜΑΡΓΙΑΝΟΣ                                        
ΑΜΑΡΓΙΩΤΑΚΗΣ                                      
ΑΜΑΡΓΙΩΤΑΚΙΣ                                      
ΑΜΑΡΓΙΩΤΗΣ                                        
ΑΜΑΡΙΑΝΑΚΗΣ                                       
ΑΜΑΡΙΑΝΟΣ                                         
ΑΜΑΡΙΩΤΑΚΗΣ                                       
ΑΜΑΡΙΩΤΗΣ                                         
ΑΜΑΡΛΑΡΙΩΤΗΣ                                      
ΑΜΑΡΤΩΛΟΣ                                         
ΑΜΑΣΑΛΙΔΗΣ                                        
ΑΜΑΣΕΥΣ                                           
ΑΜΑΣΙΑΔΗΣ                                         
ΑΜΑΣΙΑΛΙΔΗΣ                                       
ΑΜΑΣΛΗΣ                                           
ΑΜΑΣΛΙΔΗΣ                                         
ΑΜΑΦΗΣ                                            
ΑΜΒΑΖΑΣ                                           
ΑΜΒΑΤΖΗΣ                                          
ΑΜΒΟΣΙΑΔΗΣ                                        
ΑΜΒΡΑΖΑΣ                                          
ΑΜΒΡΑΖΗΣ                                          
ΑΜΒΡΑΖΙΑΔΗΣ                                       
ΑΜΒΡΑΚΙΔΗΣ                                        
ΑΜΒΡΑΣΗΣ                                          
ΑΜΒΡΙΚΙΔΗΣ                                        
ΑΜΒΡΟΣΙΑΔΗΣ                                       
ΑΜΒΡΟΣΙΑΤΟΣ                                       
ΑΜΒΡΟΣΙΔΗΣ                                        
ΑΜΒΡΟΣΙΟΣ                                         
ΑΜΒΡΟΥΔΗΣ                                         
ΑΜΔΑΚΗΣ                                           
ΑΜΔΑΡΗΣ                                           
ΑΜΔΙΤΗΣ                                           
ΑΜΕΔΑΡΜΑΝΗΣ                                       
ΑΜΕΛΑΔΙΩΤΗΣ                                       
ΑΜΕΛΙΔΗΣ                                          
ΑΜΕΛΙΝΙΔΗΣ                                        
ΑΜΕΛΙΟΣ                                           
ΑΜΕΛΤΩΝΗΣ                                         
ΑΜΕΝΤΑΣ                                           
ΑΜΕΞΗΣ                                            
ΑΜΕΞΙΖΙΔΗΣ                                        
ΑΜΕΡΑΛΗΣ                                          
ΑΜΕΡΑΝΗΣ                                          
ΑΜΕΡΙΑΔΗΣ                                         
ΑΜΕΡΙΑΝΟΣ                                         
ΑΜΕΡΙΔΗΣ                                          
ΑΜΕΡΙΚΑΝΑΣ                                        
ΑΜΕΡΙΚΑΝΗΣ                                        
ΑΜΕΡΙΚΑΝΟΣ                                        
ΑΜΕΡΙΚΑΣ                                          
ΑΜΕΡΙΚΟΣ                                          
ΑΜΕΡΙΝΟΣ                                          
ΑΜΕΡΣΩΝΗΣ                                         
ΑΜΕΣ                                              
ΑΜΕΣΙΝΟΠΟΥΛΟΣ                                     
ΑΜΕΤ ΑΛΗ                                          
ΑΜΕΤ ΑΡΗΦ                                         
ΑΜΕΤ ΓΙΟΥΣΟΥΦ                                     
ΑΜΕΤ ΔΙΚΜΕ ΣΑΛΗ                                   
ΑΜΕΤ ΕΜΙΝ                                         
ΑΜΕΤ ΙΜΠΡΑΜ                                       
ΑΜΕΤ ΙΜΠΡΑΜΟΓΛΟΥ                                  
ΑΜΕΤ ΚΕΧΑΓΙΑ                                      
ΑΜΕΤ ΜΕΜΕΤ                                        
ΑΜΕΤ ΜΕΜΕΤ ΑΜΕΤ                                   
ΑΜΕΤ ΜΟΥΜΙΝ                                       
ΑΜΕΤ ΜΟΥΣΤΑΦΑ                                     
ΑΜΕΤ ΜΟΥΣΤΑΦΑ ΟΓΛΟΥ                               
ΑΜΕΤ ΝΤΟΥΦΑΛΗ                                     
ΑΜΕΤ ΟΓΛΟΥ                                        
ΑΜΕΤ ΟΓΛΟΥ ΚΑΔΗΡ                                  
ΑΜΕΤ ΟΓΛΟΥ ΚΑΡΜΑΝ                                 
ΑΜΕΤ ΟΓΛΟΥ ΟΣΜΑΝ                                  
ΑΜΕΤ ΟΜΠΑΣΗ                                       
ΑΜΕΤ ΟΣΜΑΝ                                        
ΑΜΕΤ ΟΣΜΑΝΟΓΛΟΥ                                   
ΑΜΕΤ ΟΥΣΤΑ                                        
ΑΜΕΤ ΟΥΣΤΑ ΟΓΛΟΥ                                  
ΑΜΕΤ ΟΥΣΤΑ ΧΟΥΣΕΙΝ                                
ΑΜΕΤ ΠΕΛΕΒΑΝ                                      
ΑΜΕΤ ΡΕΤΖΕΠ                                       
ΑΜΕΤ ΡΕΦΗΚ                                        
ΑΜΕΤ ΣΕΡΗΦ                                        
ΑΜΕΤ ΤΖΙΒΑΝ                                       
ΑΜΕΤ ΤΣΑΟΥΣ                                       
ΑΜΕΤ ΤΣΙΛΙΓΓΙΡ                                    
ΑΜΕΤ ΤΣΟΛΑΚΟΓΛΟΥ                                  
ΑΜΕΤ ΧΑΛΗΛ                                        
ΑΜΕΤ ΧΑΣΑΝ                                        
ΑΜΕΤ ΧΑΤΖΗ ΑΜΠΙΠ                                  
ΑΜΕΤ ΧΟΥΣΕΙΝ                                      
ΑΜΕΤ ΧΟΥΣΕΙΝ ΟΓΛΟΥ                                
ΑΜΕΤ ΧΟΥΣΕΙΝΟΓΛΟΥ                                 
ΑΜΕΤΣΙΚ ΑΛΗ                                       
ΑΜΕΤΣΙΚ ΜΕΜΕΤ                                     
ΑΜΕΤΣΙΚ ΟΓΛΟΥ                                     
ΑΜΖΑΣ                                             
ΑΜΗΡΑΛΗΣ                                          
ΑΜΗΡΑΣ                                            
ΑΜΗΡΙΔΗΣ                                          
ΑΜΗΣΙΝΟΠΟΥΛΟΣ                                     
ΑΜΗΤΣΑΣ                                           
ΑΜΗΤΣΙΑΣ                                          
ΑΜΙΑΔΗΣ                                           
ΑΜΙΓΔΑΛΙΟΣ                                        
ΑΜΙΔΗΣ                                            
ΑΜΙΛΗΣ                                            
ΑΜΙΛΗΤΟΣ                                          
ΑΜΙΛΙΔΗΣ                                          
ΑΜΙΛΛΗΣ                                           
ΑΜΙΝΙΔΗΣ                                          
ΑΜΙΡΑΔΑΚΗΣ                                        
ΑΜΙΡΑΛΗΣ                                          
ΑΜΙΡΙΔΗΣ                                          
ΑΜΙΡΟΠΟΥΛΟΣ                                       
ΑΜΙΡΤΖΑΝΙΔΗΣ                                      
ΑΜΙΤΣΑΣ                                           
ΑΜΙΤΣΗΣ                                           
ΑΜΜΑΝΑΤΙΔΗΣ                                       
ΑΜΜΑΞΟΠΟΥΛΟΣ                                      
ΑΜΜΕΤ ΟΓΛΟΥ                                       
ΑΜΜΟΛΟΧΙΤΗΣ                                       
ΑΜΝΑΤΣΑΝΑΚΗΣ                                      
ΑΜΟΙΔΗΣ                                           
ΑΜΟΙΡΑΔΑΚΗΣ                                       
ΑΜΟΙΡΑΔΗΣ                                         
ΑΜΟΙΡΑΛΗΣ                                         
ΑΜΟΙΡΑΝΗΣ                                         
ΑΜΟΙΡΑΣ                                           
ΑΜΟΙΡΙΔΗΣ                                         
ΑΜΟΙΡΟΠΟΥΛΟΣ                                      
ΑΜΟΙΡΤΖΑΣ                                         
ΑΜΟΛΟΧΙΤΗΣ                                        
ΑΜΟΝΑΧΑΚΗΣ                                        
ΑΜΟΡΑΝΙΤΗΣ                                        
ΑΜΟΡΑΤΗΣ                                          
ΑΜΟΡΓΙΑΝΙΩΤΗΣ                                     
ΑΜΟΡΓΙΑΝΝΙΩΤΗΣ                                    
ΑΜΟΡΓΙΑΝΟΣ                                        
ΑΜΟΡΓΙΝΟΣ                                         
ΑΜΟΡΓΥΝΟΣ                                         
ΑΜΟΡΕΣ                                            
ΑΜΟΡΙΑΝΟΣ                                         
ΑΜΟΥΝΤΖΑΣ                                         
ΑΜΟΥΝΤΖΙΑΣ                                        
ΑΜΟΥΡΓΗΣ                                          
ΑΜΟΥΡΓΙΑΝΟΣ                                       
ΑΜΟΥΡΗΣ                                           
ΑΜΟΥΡΙΑΝΟΣ                                        
ΑΜΟΥΣ                                             
ΑΜΟΥΤΖΑΚΗΣ                                        
ΑΜΟΥΤΖΑΣ                                          
ΑΜΟΥΤΖΙΑΣ                                         
ΑΜΟΥΤΖΙΔΗΣ                                        
ΑΜΟΥΤΖΙΟΥΔΗΣ                                      
ΑΜΟΥΤΖΟΠΟΥΛΟΣ                                     
ΑΜΠΑΒΗΣ                                           
ΑΜΠΑΔΑΣ                                           
ΑΜΠΑΔΙΝΗΣ                                         
ΑΜΠΑΔΙΩΤΑΚΗΣ                                      
ΑΜΠΑΔΟΓΙΑΝΝΗΣ                                     
ΑΜΠΑΔΟΣ                                           
ΑΜΠΑΖ                                             
ΑΜΠΑΖ ΟΓΛΟΥ                                       
ΑΜΠΑΖΑΣ                                           
ΑΜΠΑΖΗΣ                                           
ΑΜΠΑΖΙΔΗΣ                                         
ΑΜΠΑΖΟΠΟΥΛΟΣ                                      
ΑΜΠΑΛΑΚΗΣ                                         
ΑΜΠΑΝΑΒΑΣ                                         
ΑΜΠΑΝΑΒΟΣ                                         
ΑΜΠΑΝΟΥΔΗΣ                                        
ΑΜΠΑΝΤΖΗΣ                                         
ΑΜΠΑΝΤΖΙΔΗΣ                                       
ΑΜΠΑΡΑΣ                                           
ΑΜΠΑΡΗΣ                                           
ΑΜΠΑΡΙΩΤΗΣ                                        
ΑΜΠΑΡΚΙΟΛΑΣ                                       
ΑΜΠΑΡΚΙΟΛΗΣ                                       
ΑΜΠΑΡΛΗΣ                                          
ΑΜΠΑΡΟΖΗΣ                                         
ΑΜΠΑΡΤΖΑΚΗΣ                                       
ΑΜΠΑΡΤΖΗΣ                                         
ΑΜΠΑΡΤΖΙΔΗΣ                                       
ΑΜΠΑΡΤΣΙΔΗΣ                                       
ΑΜΠΑΡΤΣΟΥΜΙΔΗΣ                                    
ΑΜΠΑΣ                                             
ΑΜΠΑΣΤΑΔΟΣ                                        
ΑΜΠΑΤΑΓΓΕΛΟΣ                                      
ΑΜΠΑΤΖΑΣ                                          
ΑΜΠΑΤΖΗΜΠΑΣΗΣ                                     
ΑΜΠΑΤΖΗΣ                                          
ΑΜΠΑΤΖΙΑΔΗΣ                                       
ΑΜΠΑΤΖΙΑΝΗΣ                                       
ΑΜΠΑΤΖΙΑΝΝΗΣ                                      
ΑΜΠΑΤΖΙΑΣ                                         
ΑΜΠΑΤΖΙΔΕΛΛΗΣ                                     
ΑΜΠΑΤΖΙΔΗΣ                                        
ΑΜΠΑΤΖΟΠΟΥΛΟΣ                                     
ΑΜΠΑΤΗΣ                                           
ΑΜΠΑΤΙΕΛΟΣ                                        
ΑΜΠΑΤΣΗΜΠΑΣΗΣ                                     
ΑΜΠΑΤΣΗΣ                                          
ΑΜΠΑΤΣΙΑΝΙΔΗΣ                                     
ΑΜΠΑΤΣΙΔΗΣ                                        
ΑΜΠΕΔΑΚΗΣ                                         
ΑΜΠΕΔΗΝ ΟΓΛΟΥ                                     
ΑΜΠΕΛΑΚΗΣ                                         
ΑΜΠΕΛΑΚΙΑΣ                                        
ΑΜΠΕΛΑΚΙΩΤΗΣ                                      
ΑΜΠΕΛΑΡΓΑΣ                                        
ΑΜΠΕΛΑΣ                                           
ΑΜΠΕΛΙΔΗΣ                                         
ΑΜΠΕΛΙΚΑΚΗΣ                                       
ΑΜΠΕΛΙΚΙΩΤΗΣ                                      
ΑΜΠΕΛΙΩΤΗΣ                                        
ΑΜΠΕΛΟΓΙΑΝΝΗΣ                                     
ΑΜΠΕΛΟΔΗΜΟΣ                                       
ΑΜΠΕΛΟΥΡΓΟΣ                                       
ΑΜΠΕΛΩΜΟΣ                                         
ΑΜΠΕΝΤ ΕΛ ΜΙΧΣΕΝ                                  
ΑΜΠΕΡΙΑΔΗΣ                                        
ΑΜΠΕΡΙΔΗΣ                                         
ΑΜΠΕΡΤΟΣ                                          
ΑΜΠΕΣΛΙΔΗΣ                                        
ΑΜΠΕΤΗΣ                                           
ΑΜΠΕΤΙΝ ΟΓΛΟΥ                                     
ΑΜΠΕΤΙΝ ΣΑΛΗ                                      
ΑΜΠΙΑΤΑΡΙΔΗΣ                                      
ΑΜΠΙΟΣ                                            
ΑΜΠΛΑΣ                                            
ΑΜΠΛΙΑΜΗΣ                                         
ΑΜΠΛΙΑΝΙΤΗΣ                                       
ΑΜΠΝΤΕΛ ΑΧΑΝΤ ΑΛ ΚΑΣΣ                             
ΑΜΠΝΤΕΛ ΟΥΑΧΕΝΤ ΧΑΣΣΑΝ                            
ΑΜΠΝΤΕΛ ΣΑΛΑΜ                                     
ΑΜΠΝΤΕΛΛΗΣ                                        
ΑΜΠΟΒΙΑΝΙΔΗΣ                                      
ΑΜΠΟΖΙΝΑΣ                                         
ΑΜΠΟΛΙΑΣΤΗΣ                                       
ΑΜΠΟΝΗΣ                                           
ΑΜΠΟΣ                                             
ΑΜΠΟΣΙΔΗΣ                                         
ΑΜΠΟΥ ΑΛ ΤΑΧΕΡ                                    
ΑΜΠΟΥ ΕΛ ΑΛΛΑ ΚΟΤΣΙΡΑΣ                            
ΑΜΠΟΥ ΕΛ ΕΛΑ                                      
ΑΜΠΟΥ ΕΛ ΣΕΟΥΝΤ                                   
ΑΜΠΟΥ ΕΛ ΣΟΥΟΥΝΤ                                  
ΑΜΠΟΥ ΕΛ ΦΕΤΟΥΧ                                   
ΑΜΠΟΥ ΧΑΣΑΝ                                       
ΑΜΠΟΥ ΧΟΥΣΕΙΝ                                     
ΑΜΠΟΥΓΓΕΛΗΣ                                       
ΑΜΠΟΥΓΙΑΝΝΗΣ                                      
ΑΜΠΟΥΓΚΙΔΗΣ                                       
ΑΜΠΟΥΚΕΛΗΣ                                        
ΑΜΠΟΥΚΟΝΙΕΣ                                       
ΑΜΠΟΥΛΕΡΗΣ                                        
ΑΜΠΟΥΛΙΔΗΣ                                        
ΑΜΠΟΥΛΟΣ                                          
ΑΜΠΟΥΝΤΑΡΑΣ                                       
ΑΜΠΟΥΝΤΟΛΑΣ                                       
ΑΜΠΟΥΝΤΩΛΑΣ                                       
ΑΜΠΟΥΡΑΝΤΗΣ                                       
ΑΜΠΟΥΡΙΔΗΣ                                        
ΑΜΠΟΥΣΙΔΗΣ                                        
ΑΜΠΟΥΤΗΣ                                          
ΑΜΠΟΥΧΑΝΗΣ                                        
ΑΜΠΡΑΖΗΣ                                          
ΑΜΠΡΑΜΙΑΝΤΣ                                       
ΑΜΠΡΑΣΗΣ                                          
ΑΜΠΡΑΣΙΔΗΣ                                        
ΑΜΠΡΙΚΙΔΗΣ                                        
ΑΜΠΡΟΙΚΙΔΗΣ                                       
ΑΜΠΡ                                              
ΑΜΠΤΗ ΧΑΛΗΛ ΧΑΣΑΝ                                 
ΑΜΠΤΗ ΧΟΥΣΕΙΝ                                     
ΑΜΤΖΟΠΟΥΛΟΣ                                       
ΑΜΥΓΔΑΛΑΚΗΣ                                       
ΑΜΥΓΔΑΛΑΡΗΣ                                       
ΑΜΥΓΔΑΛΑΣ                                         
ΑΜΥΓΔΑΛΗΣ                                         
ΑΜΥΓΔΑΛΙΑΣ                                        
ΑΜΥΓΔΑΛΙΔΗΣ                                       
ΑΜΥΓΔΑΛΙΟΣ                                        
ΑΜΥΓΔΑΛΙΤΣΗΣ                                      
ΑΜΥΓΔΑΛΟΠΟΥΛΟΣ                                    
ΑΜΥΓΔΑΛΟΣ                                         
ΑΜΥΓΔΑΛΟΥΔΗΣ                                      
ΑΜΥΛΙΔΗΣ                                          
ΑΜΥΝΔΑΣ                                           
ΑΜΥΝΤΑΣ                                           
ΑΜΥΡΑΔΑΚΗΣ                                        
ΑΜΥΡΑΛΗΣ                                          
ΑΜΥΡΑΝΗΣ                                          
ΑΜΥΡΑΣ                                            
ΑΜΥΡΙΔΗΣ                                          
ΑΜΥΡΣΑΚΗΣ                                         
ΑΜΥΡΣΩΝΗΣ                                         
ΑΜΦΙΛΟΧΙΑΔΗΣ                                      
ΑΜΦΙΛΟΧΙΟΣ                                        
ΑΜΨΕΦΙΔΗΣ                                         
ΑΜΩΡΑΝΙΤΗΣ                                        
ΑΜΩΡΑΤΗΣ                                          
ΑΝΑΒΑΙΝΗΣ                                         
ΑΝΑΒΑΝΙΔΗΣ                                        
ΑΝΑΒΕΛΑΝΟΣ                                        
ΑΝΑΒΕΝΙΔΗΣ                                        
ΑΝΑΒΗΣ                                            
ΑΝΑΒΛΑΒΗΣ                                         
ΑΝΑΓΙΑΝΝΗΣ                                        
ΑΝΑΓΙΩΤΟΣ                                         
ΑΝΑΓΝΟΠΟΥΛΟΣ                                      
ΑΝΑΓΝΟΣ                                           
ΑΝΑΓΝΩΠΟΥΛΟΣ                                      
ΑΝΑΓΝΩΣΤΑΚΗΣ                                      
ΑΝΑΓΝΩΣΤΑΚΙΣ                                      
ΑΝΑΓΝΩΣΤΑΚΟΣ                                      
ΑΝΑΓΝΩΣΤΑΛΑΚΗΣ                                    
ΑΝΑΓΝΩΣΤΑΡΑΣ                                      
ΑΝΑΓΝΩΣΤΑΡΟΣ                                      
ΑΝΑΓΝΩΣΤΑΤΟΣ                                      
ΑΝΑΓΝΩΣΤΕΑΣ                                       
ΑΝΑΓΝΩΣΤΕΛΗΣ                                      
ΑΝΑΓΝΩΣΤΕΛΙΑΣ                                     
ΑΝΑΓΝΩΣΤΕΛΛΗΣ                                     
ΑΝΑΓΝΩΣΤΕΛΟΣ                                      
ΑΝΑΓΝΩΣΤΗΣ                                        
ΑΝΑΓΝΩΣΤΙΑΔΗΣ                                     
ΑΝΑΓΝΩΣΤΙΔΗΣ                                      
ΑΝΑΓΝΩΣΤΟΠΟΥΛΟΣ                                   
ΑΝΑΓΝΩΣΤΟΠΟΥΛΟΥ ΠΑΡΑΣΚΕΥΟΠΟΥΛΟ                    
ΑΝΑΓΝΩΣΤΟΣ                                        
ΑΝΑΓΝΩΣΤΟΥΔΑΣ                                     
ΑΝΑΓΝΩΣΤΟΥΔΗΣ                                     
ΑΝΑΓΝΩΣΤΟΥΛΗΣ                                     
ΑΝΑΔΙΜΗΣ                                          
ΑΝΑΔΙΩΤΗΣ                                         
ΑΝΑΔΟΛΗΣ                                          
ΑΝΑΔΟΛΟΥΣ                                         
ΑΝΑΔΟΣ                                            
ΑΝΑΔΡΑΝΑΚΗΣ                                       
ΑΝΑΔΡΑΝΙΣΤΑΚΗΣ                                    
ΑΝΑΖΙΚΟΣ                                          
ΑΝΑΘΡΕΠΤΑΚΗΣ                                      
ΑΝΑΙΔΑΡΗΣ                                         
ΑΝΑΙΔΙΑΡΗΣ                                        
ΑΝΑΙΜΙΚΟΣ                                         
ΑΝΑΙΠΑΚΟΣ                                         
ΑΝΑΙΡΟΥΣΗΣ                                        
ΑΝΑΚΕΦΑΛΟΣ                                        
ΑΝΑΚΙΔΗΣ                                          
ΑΝΑΚΤΟΡΙΔΗΣ                                       
ΑΝΑΛΑΜΠΗΣ                                         
ΑΝΑΛΑΜΠΙΔΑΚΗΣ                                     
ΑΝΑΛΑΤΟΣ                                          
ΑΝΑΛΟΓΙΔΗΣ                                        
ΑΝΑΛΥΤΗΣ                                          
ΑΝΑΜΑΤΕΡΟΣ                                        
ΑΝΑΜΗΣΗΣ                                          
ΑΝΑΜΙΣΗΣ                                          
ΑΝΑΜΟΛΙΔΗΣ                                        
ΑΝΑΜΟΡΛΙΔΗΣ                                       
ΑΝΑΜΟΥΡΛΗΣ                                        
ΑΝΑΜΟΥΡΛΙΔΗΣ                                      
ΑΝΑΝΑΣ                                            
ΑΝΑΝΑΣΙΑΔΗΣ                                       
ΑΝΑΝΔΡΑΝΙΣΤΑΚΗΣ                                   
ΑΝΑΝΙΑΔΗΣ                                         
ΑΝΑΝΙΑΔΟΥ ΣΕΡΠΕΤΣΟΓΛΟΥ                            
ΑΝΑΝΙΑΣ                                           
ΑΝΑΝΙΔΑΚΗΣ                                        
ΑΝΑΝΙΔΑΣ                                          
ΑΝΑΝΙΔΗΣ                                          
ΑΝΑΝΙΚΑΣ                                          
ΑΝΑΝΙΚΙΔΗΣ                                        
ΑΝΑΝΤΙΟΣ                                          
ΑΝΑΝΤΡΑΝΙΣΤΑΚΗΣ                                   
ΑΝΑΟΥΝΗΣ                                          
ΑΝΑΠΑΛΗΣ                                          
ΑΝΑΠΑΛΙΔΗΣ                                        
ΑΝΑΠΑΣ                                            
ΑΝΑΠΛΙΩΤΗΣ                                        
ΑΝΑΠΝΙΩΤΗΣ                                        
ΑΝΑΠΟΛΙΔΗΣ                                        
ΑΝΑΠΟΛΙΟΤΑΚΗΣ                                     
ΑΝΑΠΟΛΙΤΑΚΗΣ                                      
ΑΝΑΠΟΛΙΤΑΝΟΣ                                      
ΑΝΑΠΟΛΙΩΤΑΚΗΣ                                     
ΑΝΑΡΓΥΡΙΔΗΣ                                       
ΑΝΑΡΓΥΡΟΠΟΥΛΟΣ                                    
ΑΝΑΡΓΥΡΟΣ                                         
ΑΝΑΡΜΟΛΙΟΣ                                        
ΑΝΑΡΟΥΣΟΣ                                         
ΑΝΑΣΗΣ                                            
ΑΝΑΣΙΔΗΣ                                          
ΑΝΑΣΙΤΟΥΔΗΣ                                       
ΑΝΑΣΟΝΤΖΗΣ                                        
ΑΝΑΣΟΠΟΥΛΟΣ                                       
ΑΝΑΣΟΥΤΖΗΣ                                        
ΑΝΑΣΣΗΣ                                           
ΑΝΑΣΤΑΓΚΑΣ                                        
ΑΝΑΣΤΑΚΟΣ                                         
ΑΝΑΣΤΑΣΑΚΗΣ                                       
ΑΝΑΣΤΑΣΑΚΙΣ                                       
ΑΝΑΣΤΑΣΑΚΟΣ                                       
ΑΝΑΣΤΑΣΑΣ                                         
ΑΝΑΣΤΑΣΑΤΟΣ                                       
ΑΝΑΣΤΑΣΕΑΣ                                        
ΑΝΑΣΤΑΣΕΛΗΣ                                       
ΑΝΑΣΤΑΣΕΛΛΗΣ                                      
ΑΝΑΣΤΑΣΕΛΛΟΣ                                      
ΑΝΑΣΤΑΣΕΛΟΣ                                       
ΑΝΑΣΤΑΣΗΣ                                         
ΑΝΑΣΤΑΣΙΑΔΗΣ                                      
ΑΝΑΣΤΑΣΙΑΚΟΣ                                      
ΑΝΑΣΤΑΣΙΑΣ                                        
ΑΝΑΣΤΑΣΙΔΗΣ                                       
ΑΝΑΣΤΑΣΙΛΑΚΗΣ                                     
ΑΝΑΣΤΑΣΙΝΗΣ                                       
ΑΝΑΣΤΑΣΟΒΙΤΗΣ                                     
ΑΝΑΣΤΑΣΟΠΟΥΛΟΣ                                    
ΑΝΑΣΤΑΣΟΥΔΗΣ                                      
ΑΝΑΣΤΑΣΟΥΛΑΚΗΣ                                    
ΑΝΑΣΤΑΣΟΥΛΑΣ                                      
ΑΝΑΣΤΑΣΟΥΛΗΣ                                      
ΑΝΑΣΤΑΧΑΣ                                         
ΑΝΑΣΤΟΓΙΑΝΝΗΣ                                     
ΑΝΑΣΤΟΠΟΥΛΟΣ                                      
ΑΝΑΣΤΟΣ                                           
ΑΝΑΣΤΟΥΛΗΣ                                        
ΑΝΑΤΖΟΥΤΖΟΥΛΑΣ                                    
ΑΝΑΤΖΟΥΤΣΟΥΛΑΣ                                    
ΑΝΑΤΟΛΑΚΗΣ                                        
ΑΝΑΤΟΛΑΣ                                          
ΑΝΑΤΟΛΗΣ                                          
ΑΝΑΤΟΛΙΑΝΟΣ                                       
ΑΝΑΤΟΛΙΤΑΚΗΣ                                      
ΑΝΑΤΟΛΙΤΗΣ                                        
ΑΝΑΤΟΛΙΩΤΑΚΗΣ                                     
ΑΝΑΤΟΛΙΩΤΗΣ                                       
ΑΝΑΤΟΛΟΥΔΗΣ                                       
ΑΝΑΤΟΛΟΥΣ                                         
ΑΝΑΤΣ                                             
ΑΝΑΤΣΕΛΟΠΟΥΛΟΣ                                    
ΑΝΑΤΣΕΛΟΣ                                         
ΑΝΑΤΣΙΤΟΣ                                         
ΑΝΑΤΣΟΥΤΣΟΛΑΣ                                     
ΑΝΑΤΣΟΥΤΣΟΥΛΑΣ                                    
ΑΝΑΥΠΛΙΩΤΗΣ                                       
ΑΝΑΦΑΡΤΑΛΗΣ                                       
ΑΝΑΧΟΡΛΗΣ                                         
ΑΝΑΧΟΥΡΛΗΣ                                        
ΑΝΑΧΩΡΛΗΣ                                         
ΑΝΓΚΟΥΣ                                           
ΑΝΔΑΛΗΣ                                           
ΑΝΔΑΡΑΚΗΣ                                         
ΑΝΔΗΡΑΣ                                           
ΑΝΔΙΑΡΗΣ                                          
ΑΝΔΡΑΒΙΔΙΩΤΗΣ                                     
ΑΝΔΡΑΒΙΖΟΣ                                        
ΑΝΔΡΑΓΑΘΗΣ                                        
ΑΝΔΡΑΔΟΠΟΥΛΟΣ                                     
ΑΝΔΡΑΚΑΚΗΣ                                        
ΑΝΔΡΑΚΑΚΟΣ                                        
ΑΝΔΡΑΚΗΣ                                          
ΑΝΔΡΑΛΑΣ                                          
ΑΝΔΡΑΛΗΣ                                          
ΑΝΔΡΑΝΗΣ                                          
ΑΝΔΡΑΣ                                            
ΑΝΔΡΕΑΔΑΚΗΣ                                       
ΑΝΔΡΕΑΔΕΛΗΣ                                       
ΑΝΔΡΕΑΔΕΛΛΗΣ                                      
ΑΝΔΡΕΑΔΗΣ                                         
ΑΝΔΡΕΑΚΕΝΑΣ                                       
ΑΝΔΡΕΑΚΗΣ                                         
ΑΝΔΡΕΑΚΟΣ                                         
ΑΝΔΡΕΑΝΑΚΗΣ                                       
ΑΝΔΡΕΑΝΗΣ                                         
ΑΝΔΡΕΑΝΙΔΗΣ                                       
ΑΝΔΡΕΑΝΟΣ                                         
ΑΝΔΡΕΑΝΟΥΔΗΣ                                      
ΑΝΔΡΕΑΣ                                           
ΑΝΔΡΕΑΣΗΜΑΚΗΣ                                     
ΑΝΔΡΕΑΣΙΔΗΣ                                       
ΑΝΔΡΕΑΤΙΔΗΣ                                       
ΑΝΔΡΕΑΤΟΣ                                         
ΑΝΔΡΕΓΑΚΗΣ                                        
ΑΝΔΡΕΔΑΚΗΣ                                        
ΑΝΔΡΕΔΑΚΙΣ                                        
ΑΝΔΡΕΙΑΔΕΛΛΗΣ                                     
ΑΝΔΡΕΙΔΗΣ                                         
ΑΝΔΡΕΙΚΟΣ                                         
ΑΝΔΡΕΙΤΣ                                          
ΑΝΔΡΕΙΩΜΕΝΟΣ                                      
ΑΝΔΡΕΙΩΤΗΣ                                        
ΑΝΔΡΕΛΛΟΣ                                         
ΑΝΔΡΕΛΟΣ                                          
ΑΝΔΡΕΟΒΙΤΣ                                        
ΑΝΔΡΕΟΛΑΣ                                         
ΑΝΔΡΕΟΛΑΤΟΣ                                       
ΑΝΔΡΕΟΠΟΥΛΗΣ                                      
ΑΝΔΡΕΟΠΟΥΛΟΣ                                      
ΑΝΔΡΕΟΣΑΤΟΣ                                       
ΑΝΔΡΕΟΣΟΠΟΥΛΟΣ                                    
ΑΝΔΡΕΟΥ ΓΙΑΝΝΟΓΛΟΥ                                
ΑΝΔΡΕΟΥΔΗΣ                                        
ΑΝΔΡΕΟΥΛΑΚΗΣ                                      
ΑΝΔΡΕΟΥΛΑΚΟΣ                                      
ΑΝΔΡΕΟΥΛΑΣ                                        
ΑΝΔΡΕΟΥΛΗΣ                                        
ΑΝΔΡΕΣΑΚΗΣ                                        
ΑΝΔΡΕΣΑΣ                                          
ΑΝΔΡΕΣΣΑΣ                                         
ΑΝΔΡΕΤΗΣ                                          
ΑΝΔΡΕΩΛΑΣ                                         
ΑΝΔΡΕΩΣΑΤΟΣ                                       
ΑΝΔΡΕΩΤΗΣ                                         
ΑΝΔΡΗΣ                                            
ΑΝΔΡΙΑΔΑΚΗΣ                                       
ΑΝΔΡΙΑΔΕΛΛΗΣ                                      
ΑΝΔΡΙΑΔΗΣ                                         
ΑΝΔΡΙΑΔΙΤΣΗΣ                                      
ΑΝΔΡΙΑΚΑΙΝΑΣ                                      
ΑΝΔΡΙΑΚΑΚΗΣ                                       
ΑΝΔΡΙΑΚΟΠΟΥΛΟΣ                                    
ΑΝΔΡΙΑΝΑΚΗΣ                                       
ΑΝΔΡΙΑΝΑΚΟΣ                                       
ΑΝΔΡΙΑΝΑΣ                                         
ΑΝΔΡΙΑΝΑΤΟΣ                                       
ΑΝΔΡΙΑΝΕΣΗΣ                                       
ΑΝΔΡΙΑΝΗΣ                                         
ΑΝΔΡΙΑΝΙΔΗΣ                                       
ΑΝΔΡΙΑΝΟΠΟΛΙΤΗΣ                                   
ΑΝΔΡΙΑΝΟΠΟΥΛΟΣ                                    
ΑΝΔΡΙΑΝΟΣ                                         
ΑΝΔΡΙΑΝΟΥΔΗΣ                                      
ΑΝΔΡΙΑΝΟΥΠΟΛΙΤΗΣ                                  
ΑΝΔΡΙΑΝΤΙΔΗΣ                                      
ΑΝΔΡΙΑΣ                                           
ΑΝΔΡΙΓΙΑΝΝΑΚΗΣ                                    
ΑΝΔΡΙΕΛΗΣ                                         
ΑΝΔΡΙΕΛΟΣ                                         
ΑΝΔΡΙΚΑΚΗΣ                                        
ΑΝΔΡΙΚΑΚΟΣ                                        
ΑΝΔΡΙΚΑΡΑΣ                                        
ΑΝΔΡΙΚΑΣ                                          
ΑΝΔΡΙΚΙΔΗΣ                                        
ΑΝΔΡΙΚΟΓΙΑΝΝΟΠΟΥΛΟΣ                               
ΑΝΔΡΙΚΟΠΟΥΛΟΣ                                     
ΑΝΔΡΙΚΟΣ                                          
ΑΝΔΡΙΚΟΥΔΗΣ                                       
ΑΝΔΡΙΚΟΥΛΑΣ                                       
ΑΝΔΡΙΝΟΠΟΥΛΟΣ                                     
ΑΝΔΡΙΝΟΣ                                          
ΑΝΔΡΙΟΓΙΑΝΝΗΣ                                     
ΑΝΔΡΙΟΛΑΣ                                         
ΑΝΔΡΙΟΛΑΤΟΣ                                       
ΑΝΔΡΙΟΠΟΥΛΟΣ                                      
ΑΝΔΡΙΟΣΑΤΟΣ                                       
ΑΝΔΡΙΟΣΟΠΟΥΛΟΣ                                    
ΑΝΔΡΙΟΥΣ                                          
ΑΝΔΡΙΣΚΟΣ                                         
ΑΝΔΡΙΤΣΑΚΗΣ                                       
ΑΝΔΡΙΤΣΑΚΟΣ                                       
ΑΝΔΡΙΤΣΑΝΟΣ                                       
ΑΝΔΡΙΤΣΑΣ                                         
ΑΝΔΡΙΤΣΗΣ                                         
ΑΝΔΡΙΤΣΙΟΣ                                        
ΑΝΔΡΙΤΣΟΓΙΑΝΝΗΣ                                   
ΑΝΔΡΙΤΣΟΓΙΑΝΝΟΣ                                   
ΑΝΔΡΙΤΣΟΠΟΥΛΟΣ                                    
ΑΝΔΡΙΤΣΟΣ                                         
ΑΝΔΡΙΤΣΟΥΔΗΣ                                      
ΑΝΔΡΙΩΜΕΝΟΣ                                       
ΑΝΔΡΙΩΣΑΤΟΣ                                       
ΑΝΔΡΙΩΤΑΚΗΣ                                       
ΑΝΔΡΙΩΤΕΛΗΣ                                       
ΑΝΔΡΙΩΤΕΛΛΗΣ                                      
ΑΝΔΡΙΩΤΗΣ                                         
ΑΝΔΡΟΒΙΤΣ                                         
ΑΝΔΡΟΒΙΤΣΑΝΕΑΣ                                    
ΑΝΔΡΟΓΙΑΝΝΗΣ                                      
ΑΝΔΡΟΓΙΩΡΓΗΣ                                      
ΑΝΔΡΟΓΛΗΣ                                         
ΑΝΔΡΟΜΑΛΟΣ                                        
ΑΝΔΡΟΜΑΝΑΚΟΣ                                      
ΑΝΔΡΟΜΑΝΕΣΚΟΣ                                     
ΑΝΔΡΟΜΑΝΕΤΣΙΚΟΣ                                   
ΑΝΔΡΟΜΕΔΑΣ                                        
ΑΝΔΡΟΜΗΔΑΣ                                        
ΑΝΔΡΟΜΙΔΑΣ                                        
ΑΝΔΡΟΝΑΔΗΣ                                        
ΑΝΔΡΟΝΑΚΗΣ                                        
ΑΝΔΡΟΝΑΚΟΣ                                        
ΑΝΔΡΟΝΑΣ                                          
ΑΝΔΡΟΝΗΣ                                          
ΑΝΔΡΟΝΙΑΔΗΣ                                       
ΑΝΔΡΟΝΙΔΗΣ                                        
ΑΝΔΡΟΝΙΚΑΚΗΣ                                      
ΑΝΔΡΟΝΙΚΗΣ                                        
ΑΝΔΡΟΝΙΚΙΔΗΣ                                      
ΑΝΔΡΟΝΙΚΟΠΟΥΛΟΣ                                   
ΑΝΔΡΟΝΙΚΟΣ                                        
ΑΝΔΡΟΝΙΩΤΗΣ                                       
ΑΝΔΡΟΝΟΠΟΥΛΟΣ                                     
ΑΝΔΡΟΝΟΥΔΗΣ                                       
ΑΝΔΡΟΠΟΥΛΟΣ                                       
ΑΝΔΡΟΤΣΑΚΗΣ                                       
ΑΝΔΡΟΥΔΗΣ                                         
ΑΝΔΡΟΥΛΑΚΑΚΗΣ                                     
ΑΝΔΡΟΥΛΑΚΗΣ                                       
ΑΝΔΡΟΥΛΑΚΙΣ                                       
ΑΝΔΡΟΥΛΑΣ                                         
ΑΝΔΡΟΥΛΗΣ                                         
ΑΝΔΡΟΥΛΙΑΚΟΣ                                      
ΑΝΔΡΟΥΛΙΔΑΚΗΣ                                     
ΑΝΔΡΟΥΛΛΗΣ                                        
ΑΝΔΡΟΥΣΗΣ                                         
ΑΝΔΡΟΥΣΟΣ                                         
ΑΝΔΡΟΥΤΖΗΣ                                        
ΑΝΔΡΟΥΤΣΑΚΗΣ                                      
ΑΝΔΡΟΥΤΣΑΚΟΣ                                      
ΑΝΔΡΟΥΤΣΕΛΗΣ                                      
ΑΝΔΡΟΥΤΣΕΛΛΗΣ                                     
ΑΝΔΡΟΥΤΣΗΣ                                        
ΑΝΔΡΟΥΤΣΟΠΟΥΛΟΣ                                   
ΑΝΔΡΟΥΤΣΟΣ                                        
ΑΝΔΡΟΦΙΛΟΣ                                        
ΑΝΔΡΩΝΑΣ                                          
ΑΝΔΡΩΝΗΣ                                          
ΑΝΔΡΩΝΙΔΗΣ                                        
ΑΝΔΡΩΝΙΩΤΗΣ                                       
ΑΝΔΡΩΝΟΣ                                          
ΑΝΕΒΛΑΒΗΣ                                         
ΑΝΕΓΡΟΝΟΣ                                         
ΑΝΕΖΑΚΗΣ                                          
ΑΝΕΖΗΡΗΣ                                          
ΑΝΕΖΗΣ                                            
ΑΝΕΖΙΑΣ                                           
ΑΝΕΖΙΝΗΣ                                          
ΑΝΕΖΙΝΟΣ                                          
ΑΝΕΖΙΡΗΣ                                          
ΑΝΕΖΟΥΛΑΚΗΣ                                       
ΑΝΕΖΟΥΛΗΣ                                         
ΑΝΕΖΥΡΗΣ                                          
ΑΝΕΘΡΕΠΤΑΚΗΣ                                      
ΑΝΕΛΛΟΣ                                           
ΑΝΕΜΑΣ                                            
ΑΝΕΜΕΛΛΗΣ                                         
ΑΝΕΜΕΛΟΣ                                          
ΑΝΕΜΗΣ                                            
ΑΝΕΜΙΔΗΣ                                          
ΑΝΕΜΙΚΟΣ                                          
ΑΝΕΜΟΓΙΑΝΝΗΣ                                      
ΑΝΕΜΟΔΟΡΑΣ                                        
ΑΝΕΜΟΔΟΥΡΑΣ                                       
ΑΝΕΜΟΔΟΥΡΗΣ                                       
ΑΝΕΜΟΔΟΥΡΙΩΤΗΣ                                    
ΑΝΕΜΟΔΩΡΑΣ                                        
ΑΝΕΜΟΖΑΛΗΣ                                        
ΑΝΕΜΟΠΟΥΛΟΣ                                       
ΑΝΕΜΟΣ                                            
ΑΝΕΜΟΥΔΗΣ                                         
ΑΝΕΜΟΥΛΗΣ                                         
ΑΝΕΞΗΣ                                            
ΑΝΕΠΛΑΣ                                           
ΑΝΕΠΟΛΙΩΤΑΚΗΣ                                     
ΑΝΕΡΓΑΣ                                           
ΑΝΕΡΟΥΣΗΣ                                         
ΑΝΕΡΟΥΣΟΣ                                         
ΑΝΕΡΡΑΨΗΣ                                         
ΑΝΕΣΙΑΔΗΣ                                         
ΑΝΕΣΙΔΗΣ                                          
ΑΝΕΣΤΑΚΗΣ                                         
ΑΝΕΣΤΑΚΟΣ                                         
ΑΝΕΣΤΑΣΑΚΗΣ                                       
ΑΝΕΣΤΗΣ                                           
ΑΝΕΣΤΙΑΔΗΣ                                        
ΑΝΕΣΤΙΔΗΣ                                         
ΑΝΕΣΤΟΠΟΥΛΟΣ                                      
ΑΝΕΣΤΟΣ                                           
ΑΝΕΣΤΟΥΔΗΣ                                        
ΑΝΕΤΑΚΗΣ                                          
ΑΝΕΤΑΣ                                            
ΑΝΕΤΟΠΟΥΛΟΣ                                       
ΑΝΕΤΟΥΔΗΣ                                         
ΑΝΕΤΣΕΛΗΣ                                         
ΑΝΕΥΛΑΒΗΣ                                         
ΑΝΕΦΑΛΟΣ                                          
ΑΝΕΦΟΣ                                            
ΑΝΖΑΡΙΔΗΣ                                         
ΑΝΖΙΟΠΑΡΔΗΣ                                       
ΑΝΗΛΙΑΔΗΣ                                         
ΑΝΗΛΙΩΤΗΣ                                         
ΑΝΗΠΑΡΟΠΟΥΛΟΣ                                     
ΑΝΗΦΟΡΟΣ                                          
ΑΝΗΨΗΤΑΚΗΣ                                        
ΑΝΘΑΚΗΣ                                           
ΑΝΘΕΜΙΔΗΣ                                         
ΑΝΘΗΜΙΑΔΗΣ                                        
ΑΝΘΗΡΟΠΟΥΛΟΣ                                      
ΑΝΘΗΣ                                             
ΑΝΘΙΑΣ                                            
ΑΝΘΙΔΗΣ                                           
ΑΝΘΙΜΑΡΙΤΗΣ                                       
ΑΝΘΙΜΙΑΔΗΣ                                        
ΑΝΘΙΜΙΔΗΣ                                         
ΑΝΘΙΜΟΠΟΥΛΟΣ                                      
ΑΝΘΙΜΟΣ                                           
ΑΝΘΙΤΗΣ                                           
ΑΝΘΙΤΣΑΣ                                          
ΑΝΘΙΤΣΗΣ                                          
ΑΝΘΙΤΣΙΟΣ                                         
ΑΝΘΙΤΣΟΣ                                          
ΑΝΘΟΓΑΛΙΔΗΣ                                       
ΑΝΘΟΛΙΔΗΣ                                         
ΑΝΘΟΜΕΛΙΔΗΣ                                       
ΑΝΘΟΠΟΥΛΟΣ                                        
ΑΝΘΟΣ                                             
ΑΝΘΟΥΛΑΚΗΣ                                        
ΑΝΘΟΥΛΑΣ                                          
ΑΝΘΟΥΛΗΣ                                          
ΑΝΘΟΥΛΙΑΣ                                         
ΑΝΘΟΥΛΙΔΗΣ                                        
ΑΝΘΟΥΛΛΗΣ                                         
ΑΝΘΟΥΛΟΥΔΗΣ                                       
ΑΝΘΟΥΣΑΣ                                          
ΑΝΘΟΥΣΗΣ                                          
ΑΝΘΟΥΣΙΔΗΣ                                        
ΑΝΘΡΑΚΕΑΣ                                         
ΑΝΘΡΑΚΕΥΣ                                         
ΑΝΘΡΑΚΙΔΗΣ                                        
ΑΝΘΡΑΚΟΠΟΥΛΟΣ                                     
ΑΝΘΡΩΠΑΚΗΣ                                        
ΑΝΘΡΩΠΑΣ                                          
ΑΝΘΡΩΠΕΛΟΣ                                        
ΑΝΘΡΩΠΟΠΟΥΛΟΣ                                     
ΑΝΘΥΜΙΑΔΗΣ                                        
ΑΝΘΥΜΙΔΗΣ                                         
ΑΝΘΥΠΑΤΟΠΟΥΛΟΣ                                    
ΑΝΙΚΑΤΖΗΣ                                         
ΑΝΙΚΛΙΔΗΣ                                         
ΑΝΙΚΟΛΑΙΤΗΣ                                       
ΑΝΙΚΟΥΛΑΣ                                         
ΑΝΙΝΟΣ                                            
ΑΝΙΣΕΓΚΟΣ                                         
ΑΝΙΣΗΣ                                            
ΑΝΙΣΙΜΙΔΗΣ                                        
ΑΝΙΣΣΑΣ                                           
ΑΝΙΤΟΠΟΥΛΟΣ                                       
ΑΝΙΤΣΑΚΗΣ                                         
ΑΝΙΤΣΑΣ                                           
ΑΝΙΤΣΗΣ                                           
ΑΝΙΤΣΟΣ                                           
ΑΝΙΦΑΝΤΗΣ                                         
ΑΝΙΨΗΣ                                            
ΑΝΙΨΗΤΑΚΗΣ                                        
ΑΝΜΠΟΥΡΤΖΗΣ                                       
ΑΝΝΑΚΗΣ                                           
ΑΝΝΑΝΙΔΑΣ                                         
ΑΝΝΑΣ                                             
ΑΝΝΕΤΑΚΗΣ                                         
ΑΝΝΕΤΗΣ                                           
ΑΝΝΕΤΟΥΔΗΣ                                        
ΑΝΝΗΣ                                             
ΑΝΝΙΑΣ                                            
ΑΝΝΙΒΑΣ                                           
ΑΝΝΙΝΟΣ                                           
ΑΝΝΙΣΗΣ                                           
ΑΝΝΙΤΣΑΚΗΣ                                        
ΑΝΝΙΤΣΗΣ                                          
ΑΝΝΟΠΟΥΛΟΣ                                        
ΑΝΝΟΥΛΙΔΗΣ                                        
ΑΝΝΟΥΣΑΚΗΣ                                        
ΑΝΝΟΥΣΑΣ                                          
ΑΝΝΟΥΣΗΣ                                          
ΑΝΟΖΙΔΗΣ                                          
ΑΝΟΙΚΤΟΜΑΤΗΣ                                      
ΑΝΟΙΝΟΣ                                           
ΑΝΟΙΞΑΣ                                           
ΑΝΟΙΞΗΣ                                           
ΑΝΟΙΞΙΑΔΗΣ                                        
ΑΝΟΙΞΟΥΔΗΣ                                        
ΑΝΟΙΧΤΟΜΑΤΗΣ                                      
ΑΝΟΜΙΤΡΗΣ                                         
ΑΝΟΠΟΥΛΟΣ                                         
ΑΝΟΡΗΣ                                            
ΑΝΟΥΔΗΣ                                           
ΑΝΟΥΛΙΔΗΣ                                         
ΑΝΟΥΣΑΚΗΣ                                         
ΑΝΟΥΣΑΣ                                           
ΑΝΟΥΣΗΣ                                           
ΑΝΟΥΣΟΣ                                           
ΑΝΟΥΣΤΗΣ                                          
ΑΝΣΟΥΡΑΣ                                          
ΑΝΤΑΒΑΚΗΣ                                         
ΑΝΤΑΒΑΛΗΣ                                         
ΑΝΤΑΒΙΔΗΣ                                         
ΑΝΤΑΒΟΛΟΣ                                         
ΑΝΤΑΔΑΚΗΣ                                         
ΑΝΤΑΖΟΠΟΥΛΟΣ                                      
ΑΝΤΑΚΗΣ                                           
ΑΝΤΑΛΑΚΗΣ                                         
ΑΝΤΑΛΕΤΗΣ                                         
ΑΝΤΑΛΗ ΜΟΥΣΤΑΦΑ                                   
ΑΝΤΑΛΗΣ                                           
ΑΝΤΑΛΙΑΛΗΣ                                        
ΑΝΤΑΛΙΔΗΣ                                         
ΑΝΤΑΛΛΑΚΗΣ                                        
ΑΝΤΑΛΛΟΠΟΥΛΟΣ                                     
ΑΝΤΑΛΟΠΟΥΛΟΣ                                      
ΑΝΤΑΛΟΥΔΑΚΗΣ                                      
ΑΝΤΑΜΑΛΗΣ                                         
ΑΝΤΑΜΗΣ                                           
ΑΝΤΑΜΙΔΗΣ                                         
ΑΝΤΑΜΟΒΙΤΣ                                        
ΑΝΤΑΜΠΟΥΦΗΣ                                       
ΑΝΤΑΜΣ                                            
ΑΝΤΑΝΑΣΙΩΤΗΣ                                      
ΑΝΤΑΝΗΣ                                           
ΑΝΤΑΠΑΣΗΣ                                         
ΑΝΤΑΡΑΚΗΣ                                         
ΑΝΤΑΡΑΣ                                           
ΑΝΤΑΡΑΧΑΣ                                         
ΑΝΤΑΡΕΛΗΣ                                         
ΑΝΤΑΡΗΣ                                           
ΑΝΤΑΡΛΗΣ                                          
ΑΝΤΑΡΤΕΛΛΗΣ                                       
ΑΝΤΑΡΤΗΣ                                          
ΑΝΤΑΣ                                             
ΑΝΤΑΣΟΥΡΑΣ                                        
ΑΝΤΑΧΟΠΟΥΛΟΣ                                      
ΑΝΤΕΔΑΚΗΣ                                         
ΑΝΤΕΚΕΛΙΔΗΣ                                       
ΑΝΤΕΛΗΣ                                           
ΑΝΤΕΛΙΔΗΣ                                         
ΑΝΤΕΛΛΗΣ                                          
ΑΝΤΕΜ ΟΓΛΟΥ                                       
ΑΝΤΕΜΗΣ                                           
ΑΝΤΕΜΙΣΑΡΗΣ                                       
ΑΝΤΕΝΑΣ                                           
ΑΝΤΕΠΛΗΣ                                          
ΑΝΤΕΠΟΒΙΤΣ                                        
ΑΝΤΕΡΑΣ                                           
ΑΝΤΕΡΙΩΤΗΣ                                        
ΑΝΤΕΡΡΙΩΤΗΣ                                       
ΑΝΤΕΡΣ                                            
ΑΝΤΕΣΧΟΣ                                          
ΑΝΤΖΑΚΑΣ                                          
ΑΝΤΖΑΚΗΣ                                          
ΑΝΤΖΑΚΛΗΣ                                         
ΑΝΤΖΑΜΙΔΗΣ                                        
ΑΝΤΖΑΡΑΣ                                          
ΑΝΤΖΑΣ                                            
ΑΝΤΖΕΛΕΤΟΣ                                        
ΑΝΤΖΕΜΗΣ                                          
ΑΝΤΖΗΛΕΤΟΣ                                        
ΑΝΤΖΙΑΣ                                           
ΑΝΤΖΙΚΑΣ                                          
ΑΝΤΖΙΝΑΣ                                          
ΑΝΤΖΟΠΟΥΛΟΣ                                       
ΑΝΤΖΟΣ                                            
ΑΝΤΖΟΥΛΑΚΟΣ                                       
ΑΝΤΖΟΥΛΑΣ                                         
ΑΝΤΖΟΥΛΑΤΟΣ                                       
ΑΝΤΖΟΥΛΗΣ                                         
ΑΝΤΖΟΥΛΙΔΗΣ                                       
ΑΝΤΖΟΥΡΗΣ                                         
ΑΝΤΖΟΥΣ                                           
ΑΝΤΗΣ                                             
ΑΝΤΙΑΡΗΣ                                          
ΑΝΤΙΑΡΤΗΣ                                         
ΑΝΤΙΒΑΚΗΣ                                         
ΑΝΤΙΒΑΛΙΔΗΣ                                       
ΑΝΤΙΒΑΣΗΣ                                         
ΑΝΤΙΒΑΧΗΣ                                         
ΑΝΤΙΖΑΣ                                           
ΑΝΤΙΚΑΣ                                           
ΑΝΤΙΚΑΤΖΙΔΗΣ                                      
ΑΝΤΙΚΙΔΗΣ                                         
ΑΝΤΙΛ ΟΓΛΟΥ                                       
ΑΝΤΙΛΗΣ                                           
ΑΝΤΙΛΟΧΟΣ                                         
ΑΝΤΙΜΑΧΙΤΗΣ                                       
ΑΝΤΙΜΗΣΑΡΗΣ                                       
ΑΝΤΙΜΗΣΙΑΡΗΣ                                      
ΑΝΤΙΜΙΣΑΡΗΣ                                       
ΑΝΤΙΜΙΣΙΑΡΗΣ                                      
ΑΝΤΙΜΠ                                            
ΑΝΤΙΝΑΣ                                           
ΑΝΤΙΝΟΣ                                           
ΑΝΤΙΟΠΟΥΛΟΣ                                       
ΑΝΤΙΟΧΟΣ                                          
ΑΝΤΙΠΑΡΙΩΤΗΣ                                      
ΑΝΤΙΠΑΣ                                           
ΑΝΤΙΠΑΤΗΣ                                         
ΑΝΤΙΠΠΑΣ                                          
ΑΝΤΙΤΣ                                            
ΑΝΤΙΦΑΚΟΣ                                         
ΑΝΤΙΦΑΛΟΣ                                         
ΑΝΤΙΦΙΛΙΩΤΗΣ                                      
ΑΝΤΙΦΛΙΩΤΗΣ                                       
ΑΝΤΙΦΥΛΙΩΤΗΣ                                      
ΑΝΤΙΨΩΜΑΣ                                         
ΑΝΤΙΩΤΗΣ                                          
ΑΝΤΟΒΑΣ                                           
ΑΝΤΟΛΟΒΙΤΣ                                        
ΑΝΤΟΣ                                             
ΑΝΤΟΣΙΔΗΣ                                         
ΑΝΤΟΥΒΑΣ                                          
ΑΝΤΟΥΛΑ ΧΑΛΗΛ ΟΓΛΟΥ                               
ΑΝΤΟΥΛΑΣ                                          
ΑΝΤΟΥΛΗΣ                                          
ΑΝΤΟΥΛΙΝΑΚΗΣ                                      
ΑΝΤΟΥΝΙΔΗΣ                                        
ΑΝΤΟΥΡΑΚΗΣ                                        
ΑΝΤΡΑΛΗΣ                                          
ΑΝΤΡΑΟΥΣ                                          
ΑΝΤΡΕΣ                                            
ΑΝΤΡΙΑΝΙΔΗΣ                                       
ΑΝΤΡΙΑΣ                                           
ΑΝΤΡΙΟΥΣ                                          
ΑΝΤΡΙΤΣ                                           
ΑΝΤΡΟΒΙΤΣ                                         
ΑΝΤΡΟΥΛΗΣ                                         
ΑΝΤΡΟΥΣ                                           
ΑΝΤΡΩΝΑΣ                                          
ΑΝΤΣΑΚΛΗΣ                                         
ΑΝΤΣΗΣ                                            
ΑΝΤΣΙΟΣ                                           
ΑΝΤΣΟΣ                                            
ΑΝΤΣΟΥΛΗΣ                                         
ΑΝΤΥΠΑΣ                                           
ΑΝΤΥΠΑΤΗΣ                                         
ΑΝΤΥΡΑΣ                                           
ΑΝΤΩΓΚΑΣ                                          
ΑΝΤΩΝΑΔΟΣ                                         
ΑΝΤΩΝΑΙΟΣ                                         
ΑΝΤΩΝΑΚΑΚΗΣ                                       
ΑΝΤΩΝΑΚΑΚΟΣ                                       
ΑΝΤΩΝΑΚΑΣ                                         
ΑΝΤΩΝΑΚΕΑΣ                                        
ΑΝΤΩΝΑΚΕΛΗΣ                                       
ΑΝΤΩΝΑΚΕΛΛΗΣ                                      
ΑΝΤΩΝΑΚΗΣ                                         
ΑΝΤΩΝΑΚΙΔΗΣ                                       
ΑΝΤΩΝΑΚΙΟΣ                                        
ΑΝΤΩΝΑΚΛΑΣ                                        
ΑΝΤΩΝΑΚΟΠΟΥΛΟΣ                                    
ΑΝΤΩΝΑΚΟΣ                                         
ΑΝΤΩΝΑΚΟΥΔΗΣ                                      
ΑΝΤΩΝΑΡΑΚΗΣ                                       
ΑΝΤΩΝΑΡΑΚΟΣ                                       
ΑΝΤΩΝΑΡΑΣ                                         
ΑΝΤΩΝΑΡΙΔΗΣ                                       
ΑΝΤΩΝΑΡΟΠΟΥΛΟΣ                                    
ΑΝΤΩΝΑΡΟΣ                                         
ΑΝΤΩΝΑΣ                                           
ΑΝΤΩΝΑΤΟΣ                                         
ΑΝΤΩΝΕΑΣ                                          
ΑΝΤΩΝΕΛΑΚΗΣ                                       
ΑΝΤΩΝΕΛΗΣ                                         
ΑΝΤΩΝΕΛΛΗΣ                                        
ΑΝΤΩΝΕΛΛΟΣ                                        
ΑΝΤΩΝΕΛΟΣ                                         
ΑΝΤΩΝΕΝΑΣ                                         
ΑΝΤΩΝΕΡΙΑΣ                                        
ΑΝΤΩΝΕΤΣΗΣ                                        
ΑΝΤΩΝΗΣ                                           
ΑΝΤΩΝΙΑΔΗΣ                                        
ΑΝΤΩΝΙΔΑΚΗΣ                                       
ΑΝΤΩΝΙΔΗΣ                                         
ΑΝΤΩΝΙΝΗΣ                                         
ΑΝΤΩΝΙΟΖΑΣ                                        
ΑΝΤΩΝΙΟΣ                                          
ΑΝΤΩΝΙΟΥΔΑΚΗΣ                                     
ΑΝΤΩΝΙΤΣΑΣ                                        
ΑΝΤΩΝΙΤΣΗΣ                                        
ΑΝΤΩΝΚΑΣ                                          
ΑΝΤΩΝΟΒΑΡΔΑΚΗΣ                                    
ΑΝΤΩΝΟΒΙΤΣ                                        
ΑΝΤΩΝΟΓΕΩΡΓΟΣ                                     
ΑΝΤΩΝΟΓΙΑΝΝΑΚΗΣ                                   
ΑΝΤΩΝΟΓΙΑΝΝΗΣ                                     
ΑΝΤΩΝΟΓΙΩΡΓΑΚΗΣ                                   
ΑΝΤΩΝΟΓΛΟΥΔΗΣ                                     
ΑΝΤΩΝΟΓΛΟΥΣ                                       
ΑΝΤΩΝΟΔΗΜΗΤΡΑΚΗΣ                                  
ΑΝΤΩΝΟΛΟΥΚΑΣ                                      
ΑΝΤΩΝΟΜΑΝΩΛΑΚΗΣ                                   
ΑΝΤΩΝΟΠΟΥΛΟΣ                                      
ΑΝΤΩΝΟΣ                                           
ΑΝΤΩΝΟΥΔΗΣ                                        
ΑΝΤΩΝΟΥΛΑΣ                                        
ΑΝΤΩΝΟΥΛΗΣ                                        
ΑΝΤΩΝΟΥΡΗΣ                                        
ΑΝΤΩΝΟΥΣΑΚΗΣ                                      
ΑΝΤΩΝΟΥΣΟΣ                                        
ΑΝΤΩΝΤΖΙΚΗΣ                                       
ΑΝΤΩΝΩΠΟΥΛΟΣ                                      
ΑΝΤΩΠΟΥΛΟΣ                                        
ΑΝΤΩΣΙΔΗΣ                                         
ΑΝΤΩΤΣΙΟΣ                                         
ΑΝΥΠΑΡΙΔΗΣ                                        
ΑΝΥΣΗΣ                                            
ΑΝΥΣΙΑΔΗΣ                                         
ΑΝΥΣΙΟΣ                                           
ΑΝΥΦΑΝΤΑΚΗΣ                                       
ΑΝΥΦΑΝΤΑΚΙΣ                                       
ΑΝΥΦΑΝΤΑΚΟΣ                                       
ΑΝΥΦΑΝΤΗΣ                                         
ΑΝΥΦΙΩΤΗΣ                                         
ΑΝΥΨΗΣ                                            
ΑΝΥΨΗΤΑΚΗΣ                                        
ΑΝΦΗΜΙΑΔΗΣ                                        
ΑΝΦΙΜΙΑΔΗΣ                                        
ΑΝΩΓΕΙΑΝΑΚΗΣ                                      
ΑΝΩΓΗΣ                                            
ΑΝΩΓΙΑΝΑΚΗΣ                                       
ΑΝΩΓΙΑΝΝΑΚΗΣ                                      
ΑΝΩΓΙΑΤΗΣ                                         
ΑΝΩΓΙΤΗΣ                                          
ΑΝΩΔΥΝΟΣ                                          
ΑΝΩΖΙΔΗΣ                                          
ΑΝΩΜΕΡΙΑΝΑΚΗΣ                                     
ΑΝΩΜΕΡΙΤΗΣ                                        
ΑΝΩΜΗΤΡΗΣ                                         
ΑΝΩΝΗΣ                                            
ΑΝΩΠΟΛΙΤΑΚΗΣ                                      
ΑΝΩΡΑΤΟΣ                                          
ΑΝΩΡΗΣ                                            
ΑΝΩΤΙΔΗΣ                                          
ΑΝΩΦΙΑΔΗΣ                                         
ΑΝΩΦΥΑΔΗΣ                                         
ΑΞ                                                
ΑΞΑΒΒΙΔΗΣ                                         
ΑΞΑΒΙΔΗΣ                                          
ΑΞΑΖΙΩΤΗΣ                                         
ΑΞΑΗΣ                                             
ΑΞΑΙΝΑΣ                                           
ΑΞΑΚΑΛΗΣ                                          
ΑΞΑΚΑΛΙΔΗΣ                                        
ΑΞΑΚΗΣ                                            
ΑΞΑΛΗΣ                                            
ΑΞΑΜΗΣ                                            
ΑΞΑΜΙΔΗΣ                                          
ΑΞΑΜΠΑΝΟΠΟΥΛΟΣ                                    
ΑΞΑΟΠΟΥΛΟΣ                                        
ΑΞΑΡΗΣ                                            
ΑΞΑΡΙΔΗΣ                                          
ΑΞΑΡΛΗΣ                                           
ΑΞΑΡΛΙΔΗΣ                                         
ΑΞΑΣ                                              
ΑΞΑΣΛΗΣ                                           
ΑΞΑΤΣΙΔΗΣ                                         
ΑΞΕΛΗΣ                                            
ΑΞΕΛΙΘΙΩΤΗΣ                                       
ΑΞΕΛΟΣ                                            
ΑΞΕΝΙΔΗΣ                                          
ΑΞΕΝΟΠΟΥΛΟΣ                                       
ΑΞΕΝΟΣ                                            
ΑΞΕΤΗΣ                                            
ΑΞΗΣ                                              
ΑΞΙΑΜΗΣ                                           
ΑΞΙΑΡΗΣ                                           
ΑΞΙΑΡΛΗΣ                                          
ΑΞΙΔΕΛΗΣ                                          
ΑΞΙΛΙΘΙΩΤΗΣ                                       
ΑΞΙΜΙΩΤΗΣ                                         
ΑΞΙΜΝΙΩΤΗΣ                                        
ΑΞΙΝΙΑΡΗΣ                                         
ΑΞΙΟΓΛΟΥ ΑΚΤΖΟΓΛΟΥ                                
ΑΞΙΟΜΑΚΑΡΟΣ                                       
ΑΞΙΟΠΟΥΛΟΣ                                        
ΑΞΙΟΣ                                             
ΑΞΙΟΤΙΔΗΣ                                         
ΑΞΙΟΤΟΠΟΥΛΟΣ                                      
ΑΞΙΟΥΡΓΟΣ                                         
ΑΞΙΣΑΣ                                            
ΑΞΙΩΤΑΚΗΣ                                         
ΑΞΙΩΤΕΛΗΣ                                         
ΑΞΙΩΤΕΛΛΗΣ                                        
ΑΞΙΩΤΗΣ                                           
ΑΞΙΩΤΙΑΔΗΣ                                        
ΑΞΙΩΤΙΔΗΣ                                         
ΑΞΙΩΤΟΠΟΥΛΟΣ                                      
ΑΞΟΝΙΔΗΣ                                          
ΑΞΟΠΟΥΛΟΣ                                         
ΑΞΟΥΓΓΑΣ                                          
ΑΞΟΥΓΚΑΣ                                          
ΑΞΟΥΡΓΟΣ                                          
ΑΞΟΥΡΙΣΤΟΣ                                        
ΑΞΥΓΙΑΝΝΗΣ                                        
ΑΞΥΠΟΛΗΤΟΣ                                        
ΑΞΥΠΟΛΙΤΟΣ                                        
ΑΞΥΠΟΛΥΤΟΣ                                        
ΑΞΩΝΙΔΗΣ                                          
ΑΞΩΤΑΚΗΣ                                          
ΑΟΥΑΝΤ ΑΜΠΟΥ ΜΟΧΑΡΙΜΠ                             
ΑΟΥΡΣΑΛΙΔΗΣ                                       
ΑΠΑΖΙΔΗΣ                                          
ΑΠΑΚΗΣ                                            
ΑΠΑΚΙΔΗΣ                                          
ΑΠΑΛΑΓΑΚΗΣ                                        
ΑΠΑΛΑΚΗΣ                                          
ΑΠΑΛΑΧΙΔΗΣ                                        
ΑΠΑΛΙΔΗΣ                                          
ΑΠΑΛΛΑΓΑΚΗΣ                                       
ΑΠΑΛΛΑΚΗΣ                                         
ΑΠΑΛΛΑΣ                                           
ΑΠΑΛΛΙΔΗΣ                                         
ΑΠΑΛΟΔΗΜΑΣ                                        
ΑΠΑΛΟΔΗΜΟΣ                                        
ΑΠΑΛΟΠΟΥΛΟΣ                                       
ΑΠΑΛΟΣ                                            
ΑΠΑΝΑΖΙΔΗΣ                                        
ΑΠΑΝΟΖΙΔΗΣ                                        
ΑΠΑΝΩΜΕΡΙΤΑΚΗΣ                                    
ΑΠΑΡΑΜΑΝΗΣ                                        
ΑΠΑΤΑΓΓΕΛΟΣ                                       
ΑΠΑΤΖΗΣ                                           
ΑΠΑΤΖΙΑΔΗΣ                                        
ΑΠΑΤΖΙΔΗΣ                                         
ΑΠΑΤΣΙΔΗΣ                                         
ΑΠΔΑΡΜΑΝΗΣ                                        
ΑΠΕΙΘΗΣ                                           
ΑΠΕΙΡΑΘΙΤΗΣ                                       
ΑΠΕΙΡΑΝΘΙΤΗΣ                                      
ΑΠΕΛΑΤΟΣ                                          
ΑΠΕΛΙΔΗΣ                                          
ΑΠΕΝΤΑΡΟΣ                                         
ΑΠΕΡΑΘΙΤΗΣ                                        
ΑΠΕΡΑΝΘΙΤΗΣ                                       
ΑΠΕΡΓΗΣ                                           
ΑΠΕΡΓΙΩΤΗΣ                                        
ΑΠΕΡΗΣ                                            
ΑΠΕΣΑΚΗΣ                                          
ΑΠΕΣΛΙΔΗΣ                                         
ΑΠΕΣΟΣ                                            
ΑΠΕΣΣΟΣ                                           
ΑΠΙΔΙΑΛΗΣ                                         
ΑΠΙΔΙΑΝΑΚΗΣ                                       
ΑΠΙΔΙΑΝΟΣ                                         
ΑΠΙΔΟΠΟΥΛΟΣ                                       
ΑΠΙΚΕΛΗΣ                                          
ΑΠΙΚΕΛΛΗΣ                                         
ΑΠΙΚΟΣ                                            
ΑΠΙΟΝΙΔΗΣ                                         
ΑΠΙΣΤΟΛΑΣ                                         
ΑΠΙΣΤΟΥΛΑΣ                                        
ΑΠΙΤΙΑΓΟΠΟΥΛΟΣ                                    
ΑΠΛΑΔΑΣ                                           
ΑΠΛΑΔΕΝΑΚΗΣ                                       
ΑΠΛΑΚΙΔΗΣ                                         
ΑΠΛΑΝΤΗΣ                                          
ΑΠΛΑΤΑΝΑΚΗΣ                                       
ΑΠΛΑΤΙΔΗΣ                                         
ΑΠΛΕΖΗΣ                                           
ΑΠΟΓΑΚΗΣ                                          
ΑΠΟΓΕΝΗΣ                                          
ΑΠΟΔΙΑΚΟΣ                                         
ΑΠΟΔΟΥΛΙΑΝΑΚΗΣ                                    
ΑΠΟΖΙΔΗΣ                                          
ΑΠΟΘΗΚΙΑΝΑΚΗΣ                                     
ΑΠΟΘΗΚΟΠΟΥΛΟΣ                                     
ΑΠΟΙΚΙΔΗΣ                                         
ΑΠΟΙΚΟΣ                                           
ΑΠΟΙΦΗΣ                                           
ΑΠΟΚΑΜΗΣ                                          
ΑΠΟΚΑΤΑΝΙΔΗΣ                                      
ΑΠΟΚΗΣ                                            
ΑΠΟΚΟΡΙΤΗΣ                                        
ΑΠΟΚΟΡΟΝΙΩΤΑΚΗΣ                                   
ΑΠΟΚΟΡΩΝΙΟΤΑΚΗΣ                                   
ΑΠΟΚΟΡΩΝΙΩΤΑΚΗΣ                                   
ΑΠΟΚΟΤΟΣ                                          
ΑΠΟΚΟΤΤΟΣ                                         
ΑΠΟΚΟΥΡΑΣΤΟΣ                                      
ΑΠΟΚΡΑΝΙΔΗΣ                                       
ΑΠΟΚΡΕΜΙΩΤΗΣ                                      
ΑΠΟΚΡΗΜΝΙΩΤΗΣ                                     
ΑΠΟΛΛΩΝΑΤΟΣ                                       
ΑΠΟΛΛΩΝΙΑΔΗΣ                                      
ΑΠΟΛΛΩΝΙΟΣ                                        
ΑΠΟΛΩΝΑΤΟΣ                                        
ΑΠΟΜΑΧΟΣ                                          
ΑΠΟΠΑΠΑΣ                                          
ΑΠΟΡΕΛΛΗΣ                                         
ΑΠΟΣΙΑΔΗΣ                                         
ΑΠΟΣΚΙΤΗΣ                                         
ΑΠΟΣΠΟΡΗΣ                                         
ΑΠΟΣΠΟΡΙΔΗΣ                                       
ΑΠΟΣΠΟΡΟΣ                                         
ΑΠΟΣΤΟΛΑΚΑΚΗΣ                                     
ΑΠΟΣΤΟΛΑΚΕΑΣ                                      
ΑΠΟΣΤΟΛΑΚΗΣ                                       
ΑΠΟΣΤΟΛΑΚΙΔΗΣ                                     
ΑΠΟΣΤΟΛΑΚΙΣ                                       
ΑΠΟΣΤΟΛΑΚΟΠΟΥΛΟΣ                                  
ΑΠΟΣΤΟΛΑΚΟΣ                                       
ΑΠΟΣΤΟΛΑΚΟΥΔΗΣ                                    
ΑΠΟΣΤΟΛΑΚΟΥΛΗΣ                                    
ΑΠΟΣΤΟΛΑΡΑΣ                                       
ΑΠΟΣΤΟΛΑΡΟΣ                                       
ΑΠΟΣΤΟΛΑΣ                                         
ΑΠΟΣΤΟΛΑΤΟΣ                                       
ΑΠΟΣΤΟΛΕΑΣ                                        
ΑΠΟΣΤΟΛΕΛΗΣ                                       
ΑΠΟΣΤΟΛΕΛΛΗΣ                                      
ΑΠΟΣΤΟΛΕΡΗΣ                                       
ΑΠΟΣΤΟΛΕΡΟΣ                                       
ΑΠΟΣΤΟΛΗΣ                                         
ΑΠΟΣΤΟΛΙΑΔΗΣ                                      
ΑΠΟΣΤΟΛΙΑΣ                                        
ΑΠΟΣΤΟΛΙΔΗΣ                                       
ΑΠΟΣΤΟΛΙΚΑΣ                                       
ΑΠΟΣΤΟΛΙΝΑΣ                                       
ΑΠΟΣΤΟΛΙΟΣ                                        
ΑΠΟΣΤΟΛΙΩΤΗΣ                                      
ΑΠΟΣΤΟΛΛΕΛΗΣ                                      
ΑΠΟΣΤΟΛΟΓΑΜΒΡΟΣ                                   
ΑΠΟΣΤΟΛΟΓΙΑΝΝΗΣ                                   
ΑΠΟΣΤΟΛΟΓΙΩΡΓΑΚΗΣ                                 
ΑΠΟΣΤΟΛΟΠΑΠΠΑΣ                                    
ΑΠΟΣΤΟΛΟΠΟΥΛΟΣ                                    
ΑΠΟΣΤΟΛΟΠΟΥΛΟΣΗΓΙΑΝΝΑΚΑΣ                          
ΑΠΟΣΤΟΛΟΣ                                         
ΑΠΟΣΤΟΛΟΥΔΑΣ                                      
ΑΠΟΣΤΟΛΟΥΔΗΣ                                      
ΑΠΟΣΤΟΛΟΥΔΙΑΣ                                     
ΑΠΟΣΤΟΛΟΥΛΗΣ                                      
ΑΠΟΣΤΟΛΟΥΜΗΣ                                      
ΑΠΟΣΤΟΛΤΖΙΚΗΣ                                     
ΑΠΟΣΤΡΑΓΓΗΣ                                       
ΑΠΟΣΤΡΑΚΗΣ                                        
ΑΠΟΤΑΣ                                            
ΑΠΟΤΟΡΗΣ                                          
ΑΠΟΤΡΙΑΣ                                          
ΑΠΟΤΣΗΣ                                           
ΑΠΟΤΣΟΣ                                           
ΑΠΟΥΚΡΑΝΙΔΗΣ                                      
ΑΠΟΥΛΚΙΔΗΣ                                        
ΑΠΟΥΛΤΣΗΣ                                         
ΑΠΟΥΣΙΔΗΣ                                         
ΑΠΟΧΑΣ                                            
ΑΠΠΑΖΙΔΗΣ                                         
ΑΠΠΑΣ                                             
ΑΠΡΑΣΙΔΗΣ                                         
ΑΠΡΙΑ ΧΑΣΑΝ                                       
ΑΠΡΙΑ ΧΑΣΑΝΟΓΛΟΥ                                  
ΑΠΡΙΛΑΚΗΣ                                         
ΑΠΡΙΛΗΣ                                           
ΑΠΡΟΙΚΙΔΗΣ                                        
ΑΠΤΑΛ ΟΓΛΟΥ                                       
ΑΠΤΑΛΙΔΗΣ                                         
ΑΠΤΕΣΛΗΣ                                          
ΑΠΤΗ ΜΕΜΕΤ                                        
ΑΠΤΗ ΜΟΥΜΙΝ ΧΟΥΣΕΙΝ                               
ΑΠΤΗ ΟΓΛΟΥ                                        
ΑΠΤΗ ΧΟΥΣΕΙΝ ΑΜΕΤ                                 
ΑΠΤΗ ΧΟΥΣΕΙΝ ΜΕΜΕΤ                                
ΑΠΤΗΛ ΟΓΛΟΥ                                       
ΑΠΤΗΣ                                             
ΑΠΤΙΔΗΣ                                           
ΑΠΤΙΛ ΟΓΛΟΥ                                       
ΑΠΤΟΣ                                             
ΑΠΤΟΥΛ ΜΠΑΚΗ ΟΓΛΟΥ                                
ΑΠΤΟΥΛ ΟΓΛΟΥ                                      
ΑΠΤΟΥΛΑ ΑΜΕΤ                                      
ΑΠΤΟΥΛΑ ΑΜΕΤ ΟΓΛΟΥ                                
ΑΠΤΟΥΛΑ ΑΧΜΕΤ                                     
ΑΠΤΟΥΛΑ ΕΜΟΥΡΛΑ ΑΧΜΕΤ                             
ΑΠΤΟΥΛΑ ΜΟΥΣΤΑΦΑ                                  
ΑΠΤΟΥΛΑ ΜΟΥΣΤΑΦΑ ΟΓΛΟΥ                            
ΑΠΤΟΥΛΑ ΟΓΛΟΥ                                     
ΑΠΤΟΥΛΑ ΧΑΣΑΝ                                     
ΑΠΤΟΥΛΑ ΧΑΣΑΝ ΟΓΛΟΥ                               
ΑΠΤΟΥΛΑ ΧΟΥΣΕΙΝ                                   
ΑΠΤΟΥΛΑΖΙΖ                                        
ΑΠΤΟΥΛΑΖΙΖ ΟΓΛΟΥ                                  
ΑΠΤΟΥΛΑΣ                                          
ΑΠΤΟΥΛΑΧ ΟΓΛΟΥ                                    
ΑΠΤΟΥΛΕΧΑΤ ΟΓΛΟΥ                                  
ΑΠΤΟΥΡΑΗΜ ΟΓΛΟΥ                                   
ΑΠΤΟΥΡΑΜΑΝ ΜΕΜΕΤ                                  
ΑΠΤΟΥΡΑΜΑΝ ΟΓΛΟΥ                                  
ΑΠΤΟΥΡΑΜΑΝ ΧΟΥΣΕΙΝ                                
ΑΠΤΟΥΡΑΧΗΜ ΟΓΛΟΥ                                  
ΑΠΤΟΥΡΑΧΜΑΝ ΑΛΗ                                   
ΑΠΤΟΥΡΑΧΜΑΝ ΜΟΥΣΤΑΦΑ                              
ΑΠΤΟΥΡΑΧΜΑΝ ΟΓΛΟΥ                                 
ΑΠΤΟΥΡΑΧΜΑΝ ΣΑΛΗ                                  
ΑΠΤΟΥΣ ΟΓΛΟΥ                                      
ΑΡΑΒΑΝΗΣ                                          
ΑΡΑΒΑΝΛΗΣ                                         
ΑΡΑΒΑΝΟΠΟΥΛΟΣ                                     
ΑΡΑΒΑΝΤΙΝΟΣ                                       
ΑΡΑΒΑΣ                                            
ΑΡΑΒΑΤΖΑΚΗΣ                                       
ΑΡΑΒΗΣ                                            
ΑΡΑΒΙΑΔΗΣ                                         
ΑΡΑΒΙΑΚΗΣ                                         
ΑΡΑΒΙΑΝΟΠΟΥΛΟΣ                                    
ΑΡΑΒΙΑΣ                                           
ΑΡΑΒΙΔΗΣ                                          
ΑΡΑΒΙΣΤΑΝΗΣ                                       
ΑΡΑΒΙΤΣΑΚΗΣ                                       
ΑΡΑΒΙΩΤΗΣ                                         
ΑΡΑΒΟΓΛΙΑΔΗΣ                                      
ΑΡΑΒΟΠΟΥΛΟΣ                                       
ΑΡΑΒΟΣ                                            
ΑΡΑΒΟΣΙΤΑΣ                                        
ΑΡΑΒΥΣΩΝΙΔΗΣ                                      
ΑΡΑΒΩΣΗΣ                                          
ΑΡΑΓΙΑΝΝΗΣ                                        
ΑΡΑΓΙΑΣ                                           
ΑΡΑΓΙΩΡΓΗΣ                                        
ΑΡΑΔΑΣ                                            
ΑΡΑΔΟΥΛΗΣ                                         
ΑΡΑΖ                                              
ΑΡΑΖΟΣ                                            
ΑΡΑΘΥΜΟΣ                                          
ΑΡΑΘΩΜΑΣ                                          
ΑΡΑΙΛΟΠΟΥΛΟΣ                                      
ΑΡΑΙΛΟΥΔΗΣ                                        
ΑΡΑΙΤΖΟΠΟΥΛΟΣ                                     
ΑΡΑΚΑΔΑΚΗΣ                                        
ΑΡΑΚΑΣ                                            
ΑΡΑΚΕΛΗΣ                                          
ΑΡΑΚΕΛΙΔΗΣ                                        
ΑΡΑΚΛΕΙΩΤΗΣ                                       
ΑΡΑΚΛΗΣΙΑΝΟΣ                                      
ΑΡΑΚΛΙΩΤΗΣ                                        
ΑΡΑΚΤΣΙΔΗΣ                                        
ΑΡΑΚΥΝΘΙΟΣ                                        
ΑΡΑΛΑΓΙΟΣ                                         
ΑΡΑΛΗΣ                                            
ΑΡΑΛΙΟΣ                                           
ΑΡΑΛΛΗΣ                                           
ΑΡΑΜ ΑΛΗ                                          
ΑΡΑΜΑΔΑΝΙΔΗΣ                                      
ΑΡΑΜΑΚΗΣ                                          
ΑΡΑΜΠ                                             
ΑΡΑΜΠΑΚΟΣ                                         
ΑΡΑΜΠΑΛΗΣ                                         
ΑΡΑΜΠΑΜΠΑΣΛΗΣ                                     
ΑΡΑΜΠΑΝΟΣ                                         
ΑΡΑΜΠΑΝΤΖΗΣ                                       
ΑΡΑΜΠΑΠΑΣΛΗΣ                                      
ΑΡΑΜΠΑΣ                                           
ΑΡΑΜΠΑΤΖΑΚΗΣ                                      
ΑΡΑΜΠΑΤΖΑΝΗΣ                                      
ΑΡΑΜΠΑΤΖΗ ΑΛΗ                                     
ΑΡΑΜΠΑΤΖΗ ΑΜΕΤ                                    
ΑΡΑΜΠΑΤΖΗ ΙΣΜΑΗΛ ΟΓΛΟΥ                            
ΑΡΑΜΠΑΤΖΗ ΜΕΜΕΤ                                   
ΑΡΑΜΠΑΤΖΗ ΜΕΜΕΤΟΓΛΟΥ                              
ΑΡΑΜΠΑΤΖΗ ΜΟΥΣΤΑΦΑ                                
ΑΡΑΜΠΑΤΖΗ ΟΓΛΟΥ                                   
ΑΡΑΜΠΑΤΖΗ ΣΑΛΗ                                    
ΑΡΑΜΠΑΤΖΗ ΧΑΣΑΝ ΜΕΜΕΤΟΓΛΟΥ                        
ΑΡΑΜΠΑΤΖΗΣ                                        
ΑΡΑΜΠΑΤΖΙΔΑΚΗΣ                                    
ΑΡΑΜΠΑΤΖΙΔΗΣ                                      
ΑΡΑΜΠΑΤΖΙΚΟΣ                                      
ΑΡΑΜΠΑΤΖΟΠΟΥΛΟΣ                                   
ΑΡΑΜΠΑΤΖΟΥΔΗΣ                                     
ΑΡΑΜΠΑΤΣΗΣ                                        
ΑΡΑΜΠΕΛΟΣ                                         
ΑΡΑΜΠΗΣ                                           
ΑΡΑΜΠΙΔΗΣ                                         
ΑΡΑΜΠΟΓΛΙΔΗΣ                                      
ΑΡΑΜΠΟΓΛΟΥΣ                                       
ΑΡΑΜΠΟΛΙΔΗΣ                                       
ΑΡΑΜΠΟΠΟΥΛΟΣ                                      
ΑΡΑΜΠΟΣ                                           
ΑΡΑΜΠΟΥΣΑΚΗΣ                                      
ΑΡΑΝΙΑΔΗΣ                                         
ΑΡΑΝΙΤΗΣ                                          
ΑΡΑΝΤΖΕΛΟΒΙΤΣ                                     
ΑΡΑΝΤΟΣ                                           
ΑΡΑΟΣ                                             
ΑΡΑΟΥΖΟΣ                                          
ΑΡΑΠ                                              
ΑΡΑΠ ΑΛΗ                                          
ΑΡΑΠ ΑΛΗ ΟΓΛΟΥ                                    
ΑΡΑΠ ΑΜΕΤ                                         
ΑΡΑΠ ΑΜΕΤ ΟΓΛΟΥ                                   
ΑΡΑΠ ΜΕΜΕΤ                                        
ΑΡΑΠ ΟΓΛΟΥ                                        
ΑΡΑΠ ΟΣΜΑΝ                                        
ΑΡΑΠ ΟΣΜΑΝ ΟΓΛΟΥ                                  
ΑΡΑΠ ΧΑΣΑΝ ΜΕΜΕΤ                                  
ΑΡΑΠ ΧΟΥΣΕΙΝ                                      
ΑΡΑΠΑΚΗΣ                                          
ΑΡΑΠΑΚΟΠΟΥΛΟΣ                                     
ΑΡΑΠΑΚΟΣ                                          
ΑΡΑΠΑΝΤΕΛΗΣ                                       
ΑΡΑΠΑΝΤΖΗΣ                                        
ΑΡΑΠΑΝΤΩΝΗΣ                                       
ΑΡΑΠΑΣ                                            
ΑΡΑΠΑΣΗΣ                                          
ΑΡΑΠΑΣΛΑΝΗΣ                                       
ΑΡΑΠΑΤΖΗΣ                                         
ΑΡΑΠΑΤΣΑΚΟΣ                                       
ΑΡΑΠΑΤΣΑΝΗΣ                                       
ΑΡΑΠΕΚΟΣ                                          
ΑΡΑΠΕΛΗΣ                                          
ΑΡΑΠΕΛΛΗΣ                                         
ΑΡΑΠΕΤΣΙΚΑΣ                                       
ΑΡΑΠΗΣ                                            
ΑΡΑΠΙΑΣ                                           
ΑΡΑΠΙΔΗΣ                                          
ΑΡΑΠΙΔΟΥ ΑΡΑΠΟΓΛΟΥ                                
ΑΡΑΠΙΚΟΣ                                          
ΑΡΑΠΙΝΗΣ                                          
ΑΡΑΠΙΤΣΑΣ                                         
ΑΡΑΠΚΙΛΗΣ                                         
ΑΡΑΠΚΟΥΛΕΣ                                        
ΑΡΑΠΛΗΣ                                           
ΑΡΑΠΟΓΙΑΝΝΗΣ                                      
ΑΡΑΠΟΓΙΩΡΓΗΣ                                      
ΑΡΑΠΟΓΛΙΔΗΣ                                       
ΑΡΑΠΟΓΛΟΥ ΑΡΑΜΒΟΓΛΟΥ                              
ΑΡΑΠΟΓΛΟΥΣ                                        
ΑΡΑΠΟΠΟΥΛΟΣ                                       
ΑΡΑΠΟΣ                                            
ΑΡΑΠΟΣΤΑΘΗΣ                                       
ΑΡΑΠΟΥΔΗΣ                                         
ΑΡΑΠΟΧΡΗΣΤΟΣ                                      
ΑΡΑΠΟΧΡΙΣΤΟΠΟΥΛΟΣ                                 
ΑΡΑΠΠΑΝΤΕΛΗΣ                                      
ΑΡΑΠΤΖΗΣ                                          
ΑΡΑΠΤΣΑΣ                                          
ΑΡΑΠΤΣΙΔΗΣ                                        
ΑΡΑΠΤΣΙΚΗΣ                                        
ΑΡΑΠΧΑΤΖΗΣ                                        
ΑΡΑΡΑΣ                                            
ΑΡΑΣ                                              
ΑΡΑΣΤΑΡΗΣ                                         
ΑΡΑΣΤΣΙΑΡΗΣ                                       
ΑΡΑΤΖΑΣ                                           
ΑΡΑΤΖΗΣ                                           
ΑΡΑΤΖΙΑΣ                                          
ΑΡΑΤΟΣ                                            
ΑΡΑΤΣ                                             
ΑΡΑΦΑΗΛΙΔΗΣ                                       
ΑΡΑΦΛΙΑΣ                                          
ΑΡΑΧΑΒΕΛΙΑΣ                                       
ΑΡΑΧΗΣ                                            
ΑΡΑΧΩΒΑΣ                                          
ΑΡΑΧΩΒΙΤΗΣ                                        
ΑΡΒΑΛΗΣ                                           
ΑΡΒΑΝΑΚΟΣ                                         
ΑΡΒΑΝΗΤΗΣ                                         
ΑΡΒΑΝΗΤΙΔΗΣ                                       
ΑΡΒΑΝΙΔΗΣ                                         
ΑΡΒΑΝΙΤΑΚΗΣ                                       
ΑΡΒΑΝΙΤΑΚΟΣ                                       
ΑΡΒΑΝΙΤΑΝΤΩΝΗΣ                                    
ΑΡΒΑΝΙΤΑΣ                                         
ΑΡΒΑΝΙΤΕΛΗΣ                                       
ΑΡΒΑΝΙΤΕΛΛΗΣ                                      
ΑΡΒΑΝΙΤΗΣ                                         
ΑΡΒΑΝΙΤΙΑΔΗΣ                                      
ΑΡΒΑΝΙΤΙΔΗΣ                                       
ΑΡΒΑΝΙΤΟΓΕΩΡΓΟΣ                                   
ΑΡΒΑΝΙΤΟΓΙΑΝΝΗΣ                                   
ΑΡΒΑΝΙΤΟΓΙΑΝΝΟΣ                                   
ΑΡΒΑΝΙΤΟΖΗΣΗΣ                                     
ΑΡΒΑΝΙΤΟΠΟΥΛΟΣ                                    
ΑΡΒΑΝΙΤΟΥΔΗΣ                                      
ΑΡΒΑΝΟΠΟΥΛΟΣ                                      
ΑΡΒΑΝΤΑΣ                                          
ΑΡΒΕΛΑΚΗΣ                                         
ΑΡΒΗΣ                                             
ΑΡΒΙΘΑΣ                                           
ΑΡΒΙΘΗΣ                                           
ΑΡΒΥΘΑΣ                                           
ΑΡΒΥΘΗΣ                                           
ΑΡΒΥΛΙΑΣ                                          
ΑΡΒΥΤΗΣ                                           
ΑΡΓΑΛΕΙΟΣ                                         
ΑΡΓΑΛΙΑΣ                                          
ΑΡΓΑΝΗΣ                                           
ΑΡΓΑΤΖΟΠΟΥΛΟΣ                                     
ΑΡΓΑΤΗΣ                                           
ΑΡΓΕΙΤΑΚΗΣ                                        
ΑΡΓΕΙΤΑΚΟΣ                                        
ΑΡΓΕΙΤΗΣ                                          
ΑΡΓΕΛΑΣ                                           
ΑΡΓΕΝΑΣ                                           
ΑΡΓΕΝΙΩΤΗΣ                                        
ΑΡΓΕΝΤΑΚΗΣ                                        
ΑΡΓΕΝΤΕΛΛΗΣ                                       
ΑΡΓΕΝΤΗΣ                                          
ΑΡΓΕΝΤΙΔΗΣ                                        
ΑΡΓΕΝΤΙΝΗΣ                                        
ΑΡΓΕΝΤΟΠΟΥΛΟΣ                                     
ΑΡΓΕΝΤΟΣ                                          
ΑΡΓΕΤΑΚΗΣ                                         
ΑΡΓΗΡΟΠΟΥΛΟΣ                                      
ΑΡΓΙΑΔΙΤΗΣ                                        
ΑΡΓΙΑΝΑΣ                                          
ΑΡΓΙΑΝΗΣ                                          
ΑΡΓΙΑΝΙΔΗΣ                                        
ΑΡΓΙΑΝΝΑΣ                                         
ΑΡΓΙΑΝΝΗΣ                                         
ΑΡΓΙΑΝΤΖΗΣ                                        
ΑΡΓΙΑΝΤΟΠΟΥΛΟΣ                                    
ΑΡΓΙΤΑΚΗΣ                                         
ΑΡΓΙΤΗΣ                                           
ΑΡΓΟΥΔΕΛΗΣ                                        
ΑΡΓΟΥΔΕΛΛΗΣ                                       
ΑΡΓΟΥΖΗΣ                                          
ΑΡΓΟΥΜΑΝΙΔΗΣ                                      
ΑΡΓΟΥΣΛΙΔΗΣ                                       
ΑΡΓΥΖΟΥΔΗΣ                                        
ΑΡΓΥΝΑΚΗΣ                                         
ΑΡΓΥΡΑΙΟΣ                                         
ΑΡΓΥΡΑΚΑΚΗΣ                                       
ΑΡΓΥΡΑΚΑΡΟΣ                                       
ΑΡΓΥΡΑΚΗΣ                                         
ΑΡΓΥΡΑΚΟΠΟΥΛΟΣ                                    
ΑΡΓΥΡΑΚΟΣ                                         
ΑΡΓΥΡΑΚΟΥΛΗΣ                                      
ΑΡΓΥΡΑΣ                                           
ΑΡΓΥΡΑΤΟΣ                                         
ΑΡΓΥΡΕΑΣ                                          
ΑΡΓΥΡΕΛΗΣ                                         
ΑΡΓΥΡΕΛΛΗΣ                                        
ΑΡΓΥΡΕΝΑΣ                                         
ΑΡΓΥΡΗΣ                                           
ΑΡΓΥΡΙΑΔΗΣ                                        
ΑΡΓΥΡΙΔΑΚΗΣ                                       
ΑΡΓΥΡΙΔΗΣ                                         
ΑΡΓΥΡΙΟΣ                                          
ΑΡΓΥΡΟΒΑΣΙΛΙΚΟΣ                                   
ΑΡΓΥΡΟΓΙΑΝΝΗΣ                                     
ΑΡΓΥΡΟΗΛΙΟΠΟΥΛΟΣ                                  
ΑΡΓΥΡΟΘΑΝΑΣΗΣ                                     
ΑΡΓΥΡΟΚΑΣΤΡΙΤΗΣ                                   
ΑΡΓΥΡΟΚΟΣ                                         
ΑΡΓΥΡΟΚΩΣΤΑΣ                                      
ΑΡΓΥΡΟΜΑΤΙΔΗΣ                                     
ΑΡΓΥΡΟΜΜΑΤΗΣ                                      
ΑΡΓΥΡΟΠΑΙΔΑΣ                                      
ΑΡΓΥΡΟΠΑΙΔΟΣ                                      
ΑΡΓΥΡΟΠΑΙΣ                                        
ΑΡΓΥΡΟΠΛΙΔΗΣ                                      
ΑΡΓΥΡΟΠΟΥΛΟΣ                                      
ΑΡΓΥΡΟΣ                                           
ΑΡΓΥΡΟΥΔΑΚΗΣ                                      
ΑΡΓΥΡΟΥΔΗΣ                                        
ΑΡΓΥΡΟΥΛΗΣ                                        
ΑΡΓΥΡΟΥΣΗΣ                                        
ΑΡΓΥΡΟΦΘΑΛΜΙΔΗΣ                                   
ΑΡΓΥΡΟΦΘΑΛΜΟΣ                                     
ΑΡΓΥΡΩΣ                                           
ΑΡΓΥΤΑΚΗΣ                                         
ΑΡΓΥΤΗΣ                                           
ΑΡΔΑΒΑΝΗΣ                                         
ΑΡΔΑΛΑΣ                                           
ΑΡΔΑΛΗΣ                                           
ΑΡΔΑΜΕΡΙΝΟΣ                                       
ΑΡΔΑΜΗΣ                                           
ΑΡΔΑΝΗΣ                                           
ΑΡΔΑΝΙΩΤΗΣ                                        
ΑΡΔΑΣ                                             
ΑΡΔΑΧΘΙΑΝΑΚΗΣ                                     
ΑΡΔΙΤΗΣ                                           
ΑΡΔΙΤΤΗΣ                                          
ΑΡΔΟΥΙΝΟΣ                                         
ΑΡΔΟΥΝΗΣ                                          
ΑΡΔΩΝΗΣ                                           
ΑΡΕΑΛΗΣ                                           
ΑΡΕΒΥΘΗΣ                                          
ΑΡΕΘΑΣ                                            
ΑΡΕΚΛΑΚΗΣ                                         
ΑΡΕΛΑΚΗΣ                                          
ΑΡΕΛΗΣ                                            
ΑΡΕΜΠΛΙΑΣ                                         
ΑΡΕΝ ΑΧΜΕΤ ΟΓΛΟΥ                                  
ΑΡΕΝ ΜΕΜΕΤ                                        
ΑΡΕΝ ΣΑΛΗ ΟΓΛΟΥ                                   
ΑΡΕΝ ΧΟΥΣΕΙΝ                                      
ΑΡΕΝ ΧΟΥΣΕΙΝ ΟΓΛΟΥ                                
ΑΡΕΝΑΣ                                            
ΑΡΕΝΙΚΗΣ                                          
ΑΡΕΝΟΣ                                            
ΑΡΕΟΒΗΜΑΤΑΣ                                       
ΑΡΕΟΠΟΥΛΟΣ                                        
ΑΡΕΠΑΝΤΗΣ                                         
ΑΡΕΣ                                              
ΑΡΕΣΒΟΥΡΤΣΗΣ                                      
ΑΡΕΣΤΕΙΔΗΣ                                        
ΑΡΕΣΤΗΣ                                           
ΑΡΕΣΤΟΠΟΥΛΟΣ                                      
ΑΡΕΤΑΙΟΣ                                          
ΑΡΕΤΑΚΗΣ                                          
ΑΡΕΤΑΣ                                            
ΑΡΕΤΖΗΣ                                           
ΑΡΕΤΗΣ                                            
ΑΡΕΤΙΝΗΣ                                          
ΑΡΕΤΟΠΟΥΛΟΣ                                       
ΑΡΕΤΟΣ                                            
ΑΡΕΤΟΥΛΑΚΗΣ                                       
ΑΡΕΤΟΥΛΗΣ                                         
ΑΡΕΤΣΙΑΝΟΠΟΥΛΟΣ                                   
ΑΡΕΤΣΙΝΗΣ                                         
ΑΡΕΦΕΤΖ                                           
ΑΡΖΑΝΑΣ                                           
ΑΡΖΑΝΗΣ                                           
ΑΡΖΑΝΙΔΗΣ                                         
ΑΡΖΕΝΗΣ                                           
ΑΡΖΙΑΝΗΣ                                          
ΑΡΖΙΑΝΙΔΗΣ                                        
ΑΡΖΙΔΗΣ                                           
ΑΡΖΙΝΟΣ                                           
ΑΡΖΟΜΑΝΙΔΗΣ                                       
ΑΡΖΟΥΜΑΝΙΔΗΣ                                      
ΑΡΖΟΥΧΑΛΤΖΗΣ                                      
ΑΡΖΩΜΑΝΙΔΗΣ                                       
ΑΡΗΣ                                              
ΑΡΗΦ ΜΕΜΕΤ                                        
ΑΡΗΦ ΝΤΑΜΑΤ ΧΟΥΣΕΙΝ                               
ΑΡΗΦ ΟΓΛΟΥ                                        
ΑΡΗΦ ΟΣΜΑΝ                                        
ΑΡΗΦ ΧΑΣΑΝ                                        
ΑΡΗΦ ΧΟΥΣΕΙΝ                                      
ΑΡΘΟΥΝΑΣ                                          
ΑΡΘΟΥΡΣ                                           
ΑΡΙΑΝΑΣ                                           
ΑΡΙΑΝΟΣ                                           
ΑΡΙΑΝΟΥΤΣΟΣ                                       
ΑΡΙΑΝΤΖΗΣ                                         
ΑΡΙΑΝΤΖΙΔΗΣ                                       
ΑΡΙΑΝΤΣΗΣ                                         
ΑΡΙΑΣ                                             
ΑΡΙΑΤΖΗΣ                                          
ΑΡΙΓΚΩΝΗΣ                                         
ΑΡΙΔΑΚΗΣ                                          
ΑΡΙΔΑΣ                                            
ΑΡΙΔΗΣ                                            
ΑΡΙΖΑΝΗΣ                                          
ΑΡΙΖΟΣ                                            
ΑΡΙΚΑΣ                                            
ΑΡΙΚΙΔΗΣ                                          
ΑΡΙΛΑΚΗΣ                                          
ΑΡΙΜΗΣ                                            
ΑΡΙΜΠΛΙΑΣ                                         
ΑΡΙΝΤΖΗΣ                                          
ΑΡΙΣΜΑΝΗΣ                                         
ΑΡΙΣΤΑΔΗΣ                                         
ΑΡΙΣΤΑΡΧΗΣ                                        
ΑΡΙΣΤΕΙΑΔΗΣ                                       
ΑΡΙΣΤΕΙΔΑΚΗΣ                                      
ΑΡΙΣΤΕΙΔΗΣ                                        
ΑΡΙΣΤΕΙΔΟΠΟΥΛΟΣ                                   
ΑΡΙΣΤΕΙΔΟΥΣ                                       
ΑΡΙΣΤΕΙΝΙΔΗΣ                                      
ΑΡΙΣΤΕΡΑΚΗΣ                                       
ΑΡΙΣΤΕΡΗΣ                                         
ΑΡΙΣΤΕΡΙΔΗΣ                                       
ΑΡΙΣΤΕΡΟΠΟΥΛΟΣ                                    
ΑΡΙΣΤΗΑΔΗΣ                                        
ΑΡΙΣΤΙΑΔΗΣ                                        
ΑΡΙΣΤΙΝΙΔΗΣ                                       
ΑΡΙΣΤΟΒΟΥΛΙΔΗΣ                                    
ΑΡΙΣΤΟΒΟΥΛΟΣ                                      
ΑΡΙΣΤΟΓΕΝΗΣ                                       
ΑΡΙΣΤΟΚΛΕΟΥΣ                                      
ΑΡΙΣΤΟΜΕΝΟΠΟΥΛΟΣ                                  
ΑΡΙΣΤΟΜΕΝΟΥΣ                                      
ΑΡΙΣΤΟΠΑΝΟΣ                                       
ΑΡΙΣΤΟΠΟΥΛΟΣ                                      
ΑΡΙΣΤΟΣ                                           
ΑΡΙΣΤΟΤΕΛΗΣ                                       
ΑΡΙΣΤΟΤΕΛΙΔΗΣ                                     
ΑΡΙΣΤΟΤΕΛΟΥΣ                                      
ΑΡΙΣΤΟΦΑΝΟΥΣ                                      
ΑΡΙΤΖΑΚΗΣ                                         
ΑΡΙΤΖΑΝΟΠΟΥΛΟΣ                                    
ΑΡΙΤΖΗΣ                                           
ΑΡΙΤΖΙΔΗΣ                                         
ΑΡΙΤΟΓΛΙΔΗΣ                                       
ΑΡΙΤΣΗΣ                                           
ΑΡΙΤΣΙΔΗΣ                                         
ΑΡΙΦ ΜΕΜΕΤ                                        
ΑΡΙΦ ΜΟΥΣΤΑΦΑ                                     
ΑΡΙΦ ΟΓΛΟΥ                                        
ΑΡΙΦ ΟΣΜΑΝ                                        
ΑΡΙΦ ΧΟΥΣΕΙΝ                                      
ΑΡΙΦΑΚΗΣ                                          
ΑΡΙΦΑΚΟΣ                                          
ΑΡΙΦΗΣ                                            
ΑΡΚΑΔΑΚΗΣ                                         
ΑΡΚΑΔΑΣ                                           
ΑΡΚΑΔΗΣ                                           
ΑΡΚΑΔΙΑΝΟΣ                                        
ΑΡΚΑΔΙΝΟΣ                                         
ΑΡΚΑΔΟΠΟΥΛΟΣ                                      
ΑΡΚΑΛΑΚΗΣ                                         
ΑΡΚΑΛΗΣ                                           
ΑΡΚΑΛΙΔΗΣ                                         
ΑΡΚΑΜΟΥΖΑΣ                                        
ΑΡΚΑΜΟΥΖΗΣ                                        
ΑΡΚΑΣ                                             
ΑΡΚΕΛΕΣ                                           
ΑΡΚΕΛΙΔΗΣ                                         
ΑΡΚΕΝΣ                                            
ΑΡΚΕΝΤΗΣ                                          
ΑΡΚΙΤΣΑΙΟΣ                                        
ΑΡΚΛΕΣ                                            
ΑΡΚΟΛΑΚΗΣ                                         
ΑΡΚΟΜΑΝΗΣ                                         
ΑΡΚΟΠΟΥΛΟΣ                                        
ΑΡΚΟΥΔΑΚΗΣ                                        
ΑΡΚΟΥΔΑΚΟΣ                                        
ΑΡΚΟΥΔΑΡΗΣ                                        
ΑΡΚΟΥΔΑΣ                                          
ΑΡΚΟΥΔΕΑΣ                                         
ΑΡΚΟΥΔΕΛΗΣ                                        
ΑΡΚΟΥΔΗΛΟΣ                                        
ΑΡΚΟΥΔΗΣ                                          
ΑΡΚΟΥΔΟΓΙΑΝΝΗΣ                                    
ΑΡΚΟΥΔΟΠΟΥΛΟΣ                                     
ΑΡΚΟΥΔΟΧΩΡΙΤΗΣ                                    
ΑΡΚΟΥΖΗΣ                                          
ΑΡΚΟΥΛΑΚΗΣ                                        
ΑΡΚΟΥΛΕΑΣ                                         
ΑΡΚΟΥΛΗΣ                                          
ΑΡΚΟΥΜΑΝΕΑΣ                                       
ΑΡΚΟΥΜΑΝΗΣ                                        
ΑΡΚΟΥΤΖΙΔΗΣ                                       
ΑΡΚΥΡΗΣ                                           
ΑΡΛΑΚΙΔΗΣ                                         
ΑΡΛΑΠΑΝΟΣ                                         
ΑΡΛΕΤΗΣ                                           
ΑΡΛΕΤΟΣ                                           
ΑΡΜΑΑΝΙΔΗΣ                                        
ΑΡΜΑΓΑΝΙΔΗΣ                                       
ΑΡΜΑΓΙΑΝΙΔΗΣ                                      
ΑΡΜΑΓΟΣ                                           
ΑΡΜΑΔΑΣ                                           
ΑΡΜΑΔΟΣ                                           
ΑΡΜΑΔΟΥΡΟΣ                                        
ΑΡΜΑΔΩΡΟΣ                                         
ΑΡΜΑΚΑΣ                                           
ΑΡΜΑΚΟΛΑΣ                                         
ΑΡΜΑΚΟΛΛΑΣ                                        
ΑΡΜΑΛΗΣ                                           
ΑΡΜΑΜΕΝΤΟΣ                                        
ΑΡΜΑΝΑΣ                                           
ΑΡΜΑΝΗΣ                                           
ΑΡΜΑΝΙΔΗΣ                                         
ΑΡΜΑΝΙΟΣ                                          
ΑΡΜΑΟΣ                                            
ΑΡΜΑΡΑΣ                                           
ΑΡΜΑΡΙΩΤΗΣ                                        
ΑΡΜΑΣΗΣ                                           
ΑΡΜΑΤΑΚΗΣ                                         
ΑΡΜΑΤΑΣ                                           
ΑΡΜΑΤΙΔΗΣ                                         
ΑΡΜΑΤΩΛΟΣ                                         
ΑΡΜΕΛΙΔΗΣ                                         
ΑΡΜΕΛΙΝΙΟΣ                                        
ΑΡΜΕΛΙΝΟΣ                                         
ΑΡΜΕΝΑΚΑΣ                                         
ΑΡΜΕΝΑΚΗΣ                                         
ΑΡΜΕΝΑΚΟΣ                                         
ΑΡΜΕΝΗΣ                                           
ΑΡΜΕΝΙΑΚΟΣ                                        
ΑΡΜΕΝΙΝΗΣ                                         
ΑΡΜΕΝΟΠΟΥΛΟΣ                                      
ΑΡΜΕΝΟΣ                                           
ΑΡΜΕΝΤΖΙΔΗΣ                                       
ΑΡΜΕΝΤΖΙΟΣ                                        
ΑΡΜΕΝΤΖΟΣ                                         
ΑΡΜΕΝΤΣΟΥΔΗΣ                                      
ΑΡΜΙΤΣΩΤΗΣ                                        
ΑΡΜΟΓΕΝΗΣ                                         
ΑΡΜΟΔΩΡΟΣ                                         
ΑΡΜΟΝΗΣ                                           
ΑΡΜΟΝΤΕΛΛΗΣ                                       
ΑΡΜΟΥΔΗΣ                                          
ΑΡΜΟΥΝΤΑΣ                                         
ΑΡΜΟΥΤΑΚΗΣ                                        
ΑΡΜΟΥΤΖΙΔΗΣ                                       
ΑΡΜΟΥΤΗΣ                                          
ΑΡΜΟΥΤΙΔΗΣ                                        
ΑΡΜΟΥΤΛΗΣ                                         
ΑΡΜΟΥΤΣΗΣ                                         
ΑΡΜΟΥΤΣΙΔΗΣ                                       
ΑΡΜΠΑΛΗΣ                                          
ΑΡΜΠΑΡΑΣ                                          
ΑΡΜΠΑΡΓΙΩΤΗΣ                                      
ΑΡΜΠΑΤΣΗΣ                                         
ΑΡΜΠΕΛΙΑΣ                                         
ΑΡΜΠΕΡΟΡΗΣ                                        
ΑΡΜΠΕΡΩΡΗΣ                                        
ΑΡΜΠΕΤΙΝΟΣ                                        
ΑΡΜΠΗΛΙΑΣ                                         
ΑΡΜΠΗΣ                                            
ΑΡΜΠΙΛΙΑΣ                                         
ΑΡΜΠΙΡΟΣ                                          
ΑΡΜΠΛΙΑΣ                                          
ΑΡΜΠΟΥΖΗΣ                                         
ΑΡΜΠΟΥΝΙΩΤΗΣ                                      
ΑΡΜΠΟΥΤΗΣ                                         
ΑΡΜΠΥΡΟΣ                                          
ΑΡΜΥΛΑΓΟΣ                                         
ΑΡΜΥΡΑΝΤΗΣ                                        
ΑΡΜΥΡΑΣ                                           
ΑΡΜΥΡΙΩΤΗΣ                                        
ΑΡΜΥΡΟΣ                                           
ΑΡΝΑΔΟΠΟΥΛΟΣ                                      
ΑΡΝΑΚΗΣ                                           
ΑΡΝΑΝΤΩΝΑΚΗΣ                                      
ΑΡΝΑΟΥΝΤΙΔΗΣ                                      
ΑΡΝΑΟΥΤ ΑΛΗ                                       
ΑΡΝΑΟΥΤ ΓΙΟΥΣΟΥΦ ΟΓΛΟΥ                            
ΑΡΝΑΟΥΤ ΔΑΜΑΔΗ ΧΟΥΣΕΙΝ                            
ΑΡΝΑΟΥΤ ΜΕΜΕΤ                                     
ΑΡΝΑΟΥΤ ΜΕΜΕΤ ΟΓΛΟΥ                               
ΑΡΝΑΟΥΤ ΜΕΜΕΤ ΣΑΔΙΚ                               
ΑΡΝΑΟΥΤ ΜΟΥΣΤΑΦΑ                                  
ΑΡΝΑΟΥΤ ΜΟΥΣΤΑΦΑ ΜΟΥΜΙΝ                           
ΑΡΝΑΟΥΤ ΜΟΥΣΤΑΦΑ ΣΑΛΗΜ                            
ΑΡΝΑΟΥΤ ΟΓΛΟΥ                                     
ΑΡΝΑΟΥΤ ΣΕΡΙΦ                                     
ΑΡΝΑΟΥΤΑΚΗΣ                                       
ΑΡΝΑΟΥΤΕΛΗΣ                                       
ΑΡΝΑΟΥΤΕΛΛΗΣ                                      
ΑΡΝΑΟΥΤΗΣ                                         
ΑΡΝΑΟΥΤΙΔΗΣ                                       
ΑΡΝΑΟΥΤΟΒΙΤΣ                                      
ΑΡΝΑΟΥΤΟΓΛΟΥΣ                                     
ΑΡΝΑΟΥΤΟΠΟΥΛΟΣ                                    
ΑΡΝΑΟΥΤΟΣ                                         
ΑΡΝΑΡΕΛΛΗΣ                                        
ΑΡΝΑΡΗΣ                                           
ΑΡΝΑΣ                                             
ΑΡΝΕΛΛΟΣ                                          
ΑΡΝΗΣ                                             
ΑΡΝΙΑΚΟΣ                                          
ΑΡΝΙΔΗΣ                                           
ΑΡΝΙΘΕΝΟΣ                                         
ΑΡΝΙΤΣΗΣ                                          
ΑΡΝΙΤΤΑΛΗΣ                                        
ΑΡΝΙΩΤΑΚΗΣ                                        
ΑΡΝΙΩΤΗΣ                                          
ΑΡΝΟΓΙΑΝΝΑΚΗΣ                                     
ΑΡΝΟΚΟΥΡΟΣ                                        
ΑΡΝΟΜΑΛΛΗΣ                                        
ΑΡΝΟΠΟΥΛΟΣ                                        
ΑΡΝΟΣ                                             
ΑΡΝΤΖΑΝΙΑΔΗΣ                                      
ΑΡΝΤΖΑΝΙΔΗΣ                                       
ΑΡΝ                                               
ΑΡΟΓΛΙΔΗΣ                                         
ΑΡΟΛΙΘΙΑΝΑΚΗΣ                                     
ΑΡΟΝΙΔΗΣ                                          
ΑΡΟΤΣΙΔΗΣ                                         
ΑΡΟΤΣΙΟΣ                                          
ΑΡΟΥΖΜΑΝΙΔΗΣ                                      
ΑΡΟΥΙΔΗΣ                                          
ΑΡΟΥΚΑΤΟΣ                                         
ΑΡΟΥΝΗΣ                                           
ΑΡΟΥΝΤΙΔΗΣ                                        
ΑΡΟΥΣΑΛΙΔΗΣ                                       
ΑΡΟΥΤΖΙΔΗΣ                                        
ΑΡΟΥΤΙΔΗΣ                                         
ΑΡΟΥΤΙΟΥΝΙΔΗΣ                                     
ΑΡΟΥΤΣ                                            
ΑΡΟΥΤΣΙΔΗΣ                                        
ΑΡΠΑΖΟΠΟΥΛΟΣ                                      
ΑΡΠΑΚΙΑΣ                                          
ΑΡΠΑΚΟΥΛΑΚΗΣ                                      
ΑΡΠΑΤΖΑΝΗΣ                                        
ΑΡΠΑΤΖΗΣ                                          
ΑΡΠΑΤΖΙΚΗΣ                                        
ΑΡΠΑΤΣΙΚΗΣ                                        
ΑΡΠΛΙΑΣ                                           
ΑΡΠΟΥΔΗΣ                                          
ΑΡΡΑΛΗΣ                                           
ΑΡΡΕΝΟΠΟΥΛΟΣ                                      
ΑΡΡΕΣ                                             
ΑΡΡΙΑΝΑΣ                                          
ΑΡΡΙΑΝΟΣ                                          
ΑΡΡΩΝΗΣ                                           
ΑΡΣΑΛΙΔΗΣ                                         
ΑΡΣΕΝΑΚΗΣ                                         
ΑΡΣΕΝΑΚΟΣ                                         
ΑΡΣΕΝΑΣ                                           
ΑΡΣΕΝΗΣ                                           
ΑΡΣΕΝΙΑΔΗΣ                                        
ΑΡΣΕΝΙΔΗΣ                                         
ΑΡΣΕΝΙΚΑΚΗΣ                                       
ΑΡΣΕΝΙΚΟΣ                                         
ΑΡΣΕΝΙΟΣ                                          
ΑΡΣΕΝΛΗΣ                                          
ΑΡΣΕΝΟΠΟΥΛΟΣ                                      
ΑΡΣΕΝΟΣ                                           
ΑΡΣΕΝΟΥΔΗΣ                                        
ΑΡΣΕΝΟΥΛΗΣ                                        
ΑΡΣΛΑΝΗΣ                                          
ΑΡΣΛΑΝΙΔΗΣ                                        
ΑΡΣΟΝΙΑΔΗΣ                                        
ΑΡΣΟΣ                                             
ΑΡΤΑΒΑΝΗΣ                                         
ΑΡΤΑΓΑΝΙΔΗΣ                                       
ΑΡΤΑΚΙΑΝΟΣ                                        
ΑΡΤΑΠΥΡΙΔΗΣ                                       
ΑΡΤΑΣ                                             
ΑΡΤΑΧΑΝΙΔΗΣ                                       
ΑΡΤΕΛΑΡΗΣ                                         
ΑΡΤΕΜΑΚΗΣ                                         
ΑΡΤΕΜΗΣ                                           
ΑΡΤΕΜΙΑΔΗΣ                                        
ΑΡΤΕΜΙΔΗΣ                                         
ΑΡΤΕΜΙΣΙΑΔΗΣ                                      
ΑΡΤΕΜΙΣΙΟΣ                                        
ΑΡΤΕΜΟΠΟΥΛΟΣ                                      
ΑΡΤΖΑΝΙΔΗΣ                                        
ΑΡΤΖΙΔΗΣ                                          
ΑΡΤΖΟΥΜΑΝΗΣ                                       
ΑΡΤΖΟΥΧΑΛΤΖΗΣ                                     
ΑΡΤΗΝΙΟΣ                                          
ΑΡΤΗΝΟΣ                                           
ΑΡΤΗΣ                                             
ΑΡΤΙΚΗΣ                                           
ΑΡΤΙΚΟΠΟΥΛΟΣ                                      
ΑΡΤΙΚΟΣ                                           
ΑΡΤΙΝΙΟΣ                                          
ΑΡΤΙΝΟΠΟΥΛΟΣ                                      
ΑΡΤΙΝΟΣ                                           
ΑΡΤΙΣ                                             
ΑΡΤΙΤΣΩΝΗΣ                                        
ΑΡΤΟΠΙΑΔΗΣ                                        
ΑΡΤΟΠΟΙΑΔΗΣ                                       
ΑΡΤΟΠΟΙΟΣ                                         
ΑΡΤΟΠΟΥΛΟΣ                                        
ΑΡΤΟΥΜΑΣ                                          
ΑΡΤΟΥΤΖΙΔΗΣ                                       
ΑΡΤΟΥΤΣΙΔΗΣ                                       
ΑΡΤΣ                                              
ΑΡΤΣΑΝΙΔΗΣ                                        
ΑΡΤΣΑΝΟΣ                                          
ΑΡΤΣΕΤΟΣ                                          
ΑΡΤΣΙΒΟΥΡΤΣΗΣ                                     
ΑΡΤΣΙΔΑΚΗΣ                                        
ΑΡΤΣΙΤΑΣ                                          
ΑΡΥΛΑΚΗΣ                                          
ΑΡΥΜΠΛΙΑΣ                                         
ΑΡΥΦΑΚΗΣ                                          
ΑΡΦΑΝΑΚΗΣ                                         
ΑΡΦΑΝΑΚΟΣ                                         
ΑΡΦΑΝΗΣ                                           
ΑΡΦΑΡΑΣ                                           
ΑΡΦΑΡΙΩΤΗΣ                                        
ΑΡΧΑΒΛΑΚΗΣ                                        
ΑΡΧΑΒΛΗΣ                                          
ΑΡΧΑΓΓΕΛΑΚΗΣ                                      
ΑΡΧΑΓΓΕΛΙΔΗΣ                                      
ΑΡΧΑΓΓΕΛΙΤΗΣ                                      
ΑΡΧΑΓΓΕΛΟΣ                                        
ΑΡΧΑΚΗΣ                                           
ΑΡΧΑΚΟΣ                                           
ΑΡΧΑΝΙΩΤΑΚΗΣ                                      
ΑΡΧΑΝΙΩΤΗΣ                                        
ΑΡΧΑΝΤΙΔΗΣ                                        
ΑΡΧΑΝΤΟΠΟΥΛΟΣ                                     
ΑΡΧΑΡΙΔΗΣ                                         
ΑΡΧΑΤΖΗΚΑΚΗΣ                                      
ΑΡΧΑΤΖΙΚΑΚΗΣ                                      
ΑΡΧΑΥΛΑΚΗΣ                                        
ΑΡΧΑΥΛΗΣ                                          
ΑΡΧΙΓΕΝΗΣ                                         
ΑΡΧΙΜΑΝΔΡΙΤΗΣ                                     
ΑΡΧΙΤΕΚΤΟΝΙΔΗΣ                                    
ΑΡΧΟΛΕΚΑΣ                                         
ΑΡΧΟΝΤΑΚΑΚΗΣ                                      
ΑΡΧΟΝΤΑΚΗΣ                                        
ΑΡΧΟΝΤΑΚΟΣ                                        
ΑΡΧΟΝΤΑΡΑΣ                                        
ΑΡΧΟΝΤΑΣ                                          
ΑΡΧΟΝΤΕΛΗΣ                                        
ΑΡΧΟΝΤΗΣ                                          
ΑΡΧΟΝΤΙΑΔΗΣ                                       
ΑΡΧΟΝΤΙΔΗΣ                                        
ΑΡΧΟΝΤΙΚΗΣ                                        
ΑΡΧΟΝΤΙΣΑΣ                                        
ΑΡΧΟΝΤΙΣΣΑΣ                                       
ΑΡΧΟΝΤΙΤΣΗΣ                                       
ΑΡΧΟΝΤΟΒΑΣΙΛΗΣ                                    
ΑΡΧΟΝΤΟΓΕΩΡΓΗΣ                                    
ΑΡΧΟΝΤΟΓΙΑΝΝΗΣ                                    
ΑΡΧΟΝΤΟΓΙΩΡΓΗΣ                                    
ΑΡΧΟΝΤΟΠΟΥΛΟΣ                                     
ΑΡΧΟΝΤΟΣ                                          
ΑΡΧΟΝΤΟΥΔΗΣ                                       
ΑΡΧΟΝΤΟΥΛΑΚΗΣ                                     
ΑΡΧΟΝΤΟΥΛΗΣ                                       
ΑΡΧΟΝΤΟΥΛΛΗΣ                                      
ΑΡΧΟΝΤΟΥΣ                                         
ΑΡΧΟΝΤΩΝΗΣ                                        
ΑΡΧΟΠΟΥΛΟΣ                                        
ΑΡΧΟΣ                                             
ΑΡΧΩΝΙΔΗΣ                                         
ΑΡΧΩΝΤΟΠΟΥΛΟΣ                                     
ΑΡΩΛΙΑΣ                                           
ΑΡΩΛΙΘΙΑΝΑΚΗΣ                                     
ΑΡΩΝΑΚΗΣ                                          
ΑΡΩΝΕΣ                                            
ΑΡΩΝΗΣ                                            
ΑΡΩΝΙΑΔΑΣ                                         
ΑΡΩΝΙΑΔΗΣ                                         
ΑΡΩΝΙΔΗΣ                                          
ΑΣ                                                
ΑΣΑΖΗΣ                                            
ΑΣΑΛΕΑΣ                                           
ΑΣΑΛΟΥΜΙΔΗΣ                                       
ΑΣΑΝΑΚΗΣ                                          
ΑΣΑΝΑΚΙΔΗΣ                                        
ΑΣΑΝΙΝΑΣ                                          
ΑΣΑΝΙΩΤΗΣ                                         
ΑΣΑΝΟΠΟΥΛΟΣ                                       
ΑΣΑΡΒΕΛΗΣ                                         
ΑΣΑΡΓΙΩΤΑΚΗΣ                                      
ΑΣΑΡΓΙΩΤΗΣ                                        
ΑΣΑΡΙΔΗΣ                                          
ΑΣΑΡΙΩΤΑΚΗΣ                                       
ΑΣΑΡΙΩΤΗΣ                                         
ΑΣΑΡΛΙΔΗΣ                                         
ΑΣΑΡΤΖΗΣ                                          
ΑΣΑΤΙΔΗΣ                                          
ΑΣΑΤΙΡΙΔΗΣ                                        
ΑΣΑΤΟΥΡΙΔΗΣ                                       
ΑΣΑΦ ΟΓΛΟΥ                                        
ΑΣΒΕΣΤΑΔΕΛΛΗΣ                                     
ΑΣΒΕΣΤΑΡΑΣ                                        
ΑΣΒΕΣΤΑΡΗΣ                                        
ΑΣΒΕΣΤΑΣ                                          
ΑΣΒΕΣΤΗΣ                                          
ΑΣΒΕΣΤΟΠΟΥΛΟΣ                                     
ΑΣΒΟΣ                                             
ΑΣΓΚΙΝΗΣ                                          
ΑΣΓΟΥΔΑΚΗΣ                                        
ΑΣΔΑΡΙΔΗΣ                                         
ΑΣΔΕΡΑΚΗΣ                                         
ΑΣΔΕΡΗΣ                                           
ΑΣΔΡΑΝΙΑΣ                                         
ΑΣΔΡΑΧΑΣ                                          
ΑΣΔΡΕΣ                                            
ΑΣΕΚΙΔΗΣ                                          
ΑΣΕΛΑΣ                                            
ΑΣΕΜΗΣ                                            
ΑΣΕΝΙΔΗΣ                                          
ΑΣΗΖ ΟΓΛΟΥ                                        
ΑΣΗΘΙΑΝΑΚΗΣ                                       
ΑΣΗΚ ΑΜΕΤ                                         
ΑΣΗΚΑΚΗΣ                                          
ΑΣΗΚΑΝΤΩΝΗΣ                                       
ΑΣΗΚΕΛΗΣ                                          
ΑΣΗΚΙΔΗΣ                                          
ΑΣΗΚΛΑΡΗΣ                                         
ΑΣΗΚΟΠΟΥΛΟΣ                                       
ΑΣΗΛΑΝΗΣ                                          
ΑΣΗΜ ΑΜΕΤ                                         
ΑΣΗΜ ΟΓΛΟΥ                                        
ΑΣΗΜΑΚΑΚΗΣ                                        
ΑΣΗΜΑΚΗΣ                                          
ΑΣΗΜΑΚΙΔΗΣ                                        
ΑΣΗΜΑΚΛΗΣ                                         
ΑΣΗΜΑΚΟΠΟΥΛΟΣ                                     
ΑΣΗΜΑΚΟΣ                                          
ΑΣΗΜΑΚΟΥΛΑΣ                                       
ΑΣΗΜΑΝΤΩΝΗΣ                                       
ΑΣΗΜΕΛΗΣ                                          
ΑΣΗΜΕΛΛΗΣ                                         
ΑΣΗΜΕΝΙΑΣ                                         
ΑΣΗΜΕΝΙΔΗΣ                                        
ΑΣΗΜΕΝΙΟΣ                                         
ΑΣΗΜΕΝΟΣ                                          
ΑΣΗΜΗΣ                                            
ΑΣΗΜΙΑΔΗΣ                                         
ΑΣΗΜΙΑΝΑΚΗΣ                                       
ΑΣΗΜΙΔΗΣ                                          
ΑΣΗΜΙΝΑΚΗΣ                                        
ΑΣΗΜΙΝΑΡΗΣ                                        
ΑΣΗΜΙΝΑΣ                                          
ΑΣΗΜΙΝΗΣ                                          
ΑΣΗΜΙΝΙΔΗΣ                                        
ΑΣΗΜΙΝΙΟΣ                                         
ΑΣΗΜΙΝΟΣ                                          
ΑΣΗΜΟΓΙΩΡΓΟΣ                                      
ΑΣΗΜΟΜΙΤΗΣ                                        
ΑΣΗΜΟΜΥΤΗΣ                                        
ΑΣΗΜΟΠΟΥΛΟΣ                                       
ΑΣΗΜΟΣ                                            
ΑΣΗΜΟΥΔΗΣ                                         
ΑΣΗΜΟΥΛΑΣ                                         
ΑΣΗΜΟΥΛΗΣ                                         
ΑΣΗΜΩΝΗΣ                                          
ΑΣΗΜΩΡΗΣ                                          
ΑΣΗΜΩΣΗΣ                                          
ΑΣΗΜΩΤΟΣ                                          
ΑΣΘΕΝΙΔΗΣ                                         
ΑΣΘΕΝΟΠΟΥΛΟΣ                                      
ΑΣΙΑΝΟΣ                                           
ΑΣΙΑΤΙΔΗΣ                                         
ΑΣΙΓΚΙΔΗΣ                                         
ΑΣΙΔΕΡΗΣ                                          
ΑΣΙΘΙΑΝΑΚΗΣ                                       
ΑΣΙΚΕΛΗΣ                                          
ΑΣΙΚΗΣ                                            
ΑΣΙΚΙΔΗΣ                                          
ΑΣΙΚΛΑΡΗΣ                                         
ΑΣΙΚΟΣ                                            
ΑΣΙΜΑΚΗΣ                                          
ΑΣΙΜΗΔΑΚΗΣ                                        
ΑΣΙΜΗΝΑΣ                                          
ΑΣΙΜΗΣ                                            
ΑΣΙΜΟΜΗΤΗΣ                                        
ΑΣΙΜΟΜΙΤΗΣ                                        
ΑΣΙΜΟΠΟΥΛΟΣ                                       
ΑΣΙΝΑΝΟΓΛΟΥΣ                                      
ΑΣΙΞΑΡΙΔΗΣ                                        
ΑΣΙΟΥΡΑΣ                                          
ΑΣΚΑΛΙΔΗΣ                                         
ΑΣΚΑΡΙΔΗΣ                                         
ΑΣΚΕΛΗΣ                                           
ΑΣΚΕΠΙΔΗΣ                                         
ΑΣΚΕΡΗΣ                                           
ΑΣΚΕΡΙΔΗΣ                                         
ΑΣΚΗΤΑΚΗΣ                                         
ΑΣΚΗΤΑΣ                                           
ΑΣΚΗΤΗΣ                                           
ΑΣΚΗΤΙΔΗΣ                                         
ΑΣΚΗΤΟΠΟΥΛΟΣ                                      
ΑΣΚΙΑΝΑΚΗΣ                                        
ΑΣΚΙΔΗΣ                                           
ΑΣΚΙΤΗΣ                                           
ΑΣΚΛΗΠΙΑΔΗΣ                                       
ΑΣΚΛΗΠΙΟΣ                                         
ΑΣΚΟΛΙΔΗΣ                                         
ΑΣΚΟΝΙΔΗΣ                                         
ΑΣΚΟΝΙΤΗΣ                                         
ΑΣΚΟΞΥΛΑΚΗΣ                                       
ΑΣΚΟΠΟΥΛΟΣ                                        
ΑΣΚΟΡΔΑΛΑΚΗΣ                                      
ΑΣΚΟΤΙΡΗΣ                                         
ΑΣΚΟΤΥΡΗΣ                                         
ΑΣΚΟΥΝΑΚΗΣ                                        
ΑΣΚΟΥΝΗΣ                                          
ΑΣΛΑΚΗΣ                                           
ΑΣΛΑΜΑΖΗΣ                                         
ΑΣΛΑΜΑΖΙΔΗΣ                                       
ΑΣΛΑΜΑΙΔΗΣ                                        
ΑΣΛΑΜΑΝΤΖΙΔΗΣ                                     
ΑΣΛΑΜΑΣ                                           
ΑΣΛΑΜΑΤΖΙΔΗΣ                                      
ΑΣΛΑΜΑΤΣΙΔΗΣ                                      
ΑΣΛΑΜΗΣ                                           
ΑΣΛΑΝΑΚΗΣ                                         
ΑΣΛΑΝΗΣ                                           
ΑΣΛΑΝΙΔΗΣ                                         
ΑΣΛΑΝΛΗΣ                                          
ΑΣΛΑΝΟΠΟΥΛΟΣ                                      
ΑΣΛΑΟΥΡΙΔΗΣ                                       
ΑΣΛΗΣ                                             
ΑΣΛΗΧΑΝΙΔΗΣ                                       
ΑΣΛΙΔΗΣ                                           
ΑΣΛΙΧΑΝΙΔΗΣ                                       
ΑΣΜΑΚΙΔΗΣ                                         
ΑΣΜΑΚΛΗΣ                                          
ΑΣΜΑΝΗΣ                                           
ΑΣΜΑΝΙΔΗΣ                                         
ΑΣΜΑΡΓΙΑΝΑΚΗΣ                                     
ΑΣΜΑΡΓΙΑΝΝΑΚΗΣ                                    
ΑΣΜΑΡΙΑΝΑΚΗΣ                                      
ΑΣΜΑΣ                                             
ΑΣΜΑΤΖΗΣ                                          
ΑΣΜΑΦΥΛΙΔΗΣ                                       
ΑΣΜΕΛΗΣ                                           
ΑΣΜΕΝΙΑΔΗΣ                                        
ΑΣΜΕΝΟΥΔΗΣ                                        
ΑΣΜΕΤΗΣ                                           
ΑΣΜΗΣ                                             
ΑΣΜΙΔΗΣ                                           
ΑΣΜΙΝΗΣ                                           
ΑΣΝΑΒΟΥΡΙΔΗΣ                                      
ΑΣΝΑΗΣ                                            
ΑΣΝΑΟΥΡΙΔΗΣ                                       
ΑΣΟΝΙΤΗΣ                                          
ΑΣΟΥΚΙΔΗΣ                                         
ΑΣΟΥΜΑΝΑΚΗΣ                                       
ΑΣΟΥΜΑΝΑΚΙΣ                                       
ΑΣΟΥΤΗΣ                                           
ΑΣΟΥΧΙΔΗΣ                                         
ΑΣΠΑΛΗΣ                                           
ΑΣΠΑΝΙΔΗΣ                                         
ΑΣΠΑΣΙΑΣ                                          
ΑΣΠΑΣΙΔΗΣ                                         
ΑΣΠΑΣΙΟΣ                                          
ΑΣΠΕΤΑΚΗΣ                                         
ΑΣΠΙΡΤΑΚΗΣ                                        
ΑΣΠΙΩΤΗΣ                                          
ΑΣΠΟΥΓΑΛΗΣ                                        
ΑΣΠΡΑΓΚΑΘΟΣ                                       
ΑΣΠΡΑΔΑΚΗΣ                                        
ΑΣΠΡΑΚΗΣ                                          
ΑΣΠΡΑΣ                                            
ΑΣΠΡΕΑΣ                                           
ΑΣΠΡΗΣ                                            
ΑΣΠΡΙΑΔΗΣ                                         
ΑΣΠΡΙΔΗΣ                                          
ΑΣΠΡΙΩΤΗΣ                                         
ΑΣΠΡΟΓΕΝΗΣ                                        
ΑΣΠΡΟΓΕΝΙΔΗΣ                                      
ΑΣΠΡΟΓΕΡΑΚΑΣ                                      
ΑΣΠΡΟΓΙΑΝΝΗΣ                                      
ΑΣΠΡΟΓΙΑΝΝΙΔΗΣ                                    
ΑΣΠΡΟΓΙΤΗΣ                                        
ΑΣΠΡΟΔΙΝΗΣ                                        
ΑΣΠΡΟΙΤΗΣ                                         
ΑΣΠΡΟΚΑΜΠΙΤΗΣ                                     
ΑΣΠΡΟΚΚΛΗΣΙΩΤΗΣ                                   
ΑΣΠΡΟΚΟΛΑΣ                                        
ΑΣΠΡΟΚΟΥΤΕΛΑΚΗΣ                                   
ΑΣΠΡΟΛΟΥΠΑΚΗΣ                                     
ΑΣΠΡΟΛΟΥΠΟΣ                                       
ΑΣΠΡΟΜΑΛΗΣ                                        
ΑΣΠΡΟΜΑΛΛΗΣ                                       
ΑΣΠΡΟΜΑΤΗΣ                                        
ΑΣΠΡΟΜΜΑΤΗΣ                                       
ΑΣΠΡΟΜΟΥΓΓΟΣ                                      
ΑΣΠΡΟΜΟΥΓΚΟΣ                                      
ΑΣΠΡΟΜΟΥΡΓΟΣ                                      
ΑΣΠΡΟΜΟΥΣΤΑΚΑΣ                                    
ΑΣΠΡΟΜΟΥΣΤΑΚΟΣ                                    
ΑΣΠΡΟΠΟΤΑΜΙΤΗΣ                                    
ΑΣΠΡΟΠΟΥΛΗΣ                                       
ΑΣΠΡΟΠΟΥΛΟΣ                                       
ΑΣΠΡΟΣ                                            
ΑΣΠΡΟΥΔΑΣ                                         
ΑΣΠΡΟΥΔΗΣ                                         
ΑΣΠΡΟΥΚΟΣ                                         
ΑΣΠΡΟΥΛΑΚΗΣ                                       
ΑΣΠΡΟΥΛΗΣ                                         
ΑΣΠΡΟΥΛΙΑΣ                                        
ΑΣΠΡΟΥΛΟΠΟΥΛΟΣ                                    
ΑΣΠΡΟΥΤΣΟΣ                                        
ΑΣΠΡΟΦΡΙΔΗΣ                                       
ΑΣΠΡΟΦΡΥΔΗΣ                                       
ΑΣΡΕΜΠ                                            
ΑΣΣΑΝΑΚΗΣ                                         
ΑΣΣΑΝΑΚΙΔΗΣ                                       
ΑΣΣΑΝΑΣ                                           
ΑΣΣΑΝΗΣ                                           
ΑΣΣΑΡΓΙΩΤΑΚΗΣ                                     
ΑΣΣΑΡΓΙΩΤΗΣ                                       
ΑΣΣΑΡΙΩΤΑΚΗΣ                                      
ΑΣΣΑΡΙΩΤΗΣ                                        
ΑΣΣΙΒΑΝΗΣ                                         
ΑΣΣΙΟΥΡΑΣ                                         
ΑΣΣΙΧΙΔΗΣ                                         
ΑΣΣΟΝΙΤΗΣ                                         
ΑΣΣΟΡΙΔΗΣ                                         
ΑΣΣΟΣ                                             
ΑΣΣΥΧΙΔΗΣ                                         
ΑΣΤΑΛΑΚΗΣ                                         
ΑΣΤΑΝΑΣΤΑΣ                                        
ΑΣΤΑΡΑΚΙΔΗΣ                                       
ΑΣΤΑΡΑΣ                                           
ΑΣΤΑΡΗΣ                                           
ΑΣΤΑΡΛΗΣ                                          
ΑΣΤΑΡΤΖΗΣ                                         
ΑΣΤΕΙΟΠΟΥΛΟΣ                                      
ΑΣΤΕΡΑΚΗΣ                                         
ΑΣΤΕΡΑΤΑΚΗΣ                                       
ΑΣΤΕΡΑΤΟΣ                                         
ΑΣΤΕΡΗΣ                                           
ΑΣΤΕΡΙΑΔΗΣ                                        
ΑΣΤΕΡΙΔΗΣ                                         
ΑΣΤΕΡΙΝΟΣ                                         
ΑΣΤΕΡΙΩΤΗΣ                                        
ΑΣΤΕΡΟΠΟΥΛΟΣ                                      
ΑΣΤΕΡΟΣ                                           
ΑΣΤΗΘΑΣ                                           
ΑΣΤΙΘΑΣ                                           
ΑΣΤΙΡΟΠΟΥΛΟΣ                                      
ΑΣΤΡΑΙΟΣ                                          
ΑΣΤΡΑΚΑΣ                                          
ΑΣΤΡΑΚΗΣ                                          
ΑΣΤΡΑΚΙΑΝΑΚΗΣ                                     
ΑΣΤΡΑΚΙΔΗΣ                                        
ΑΣΤΡΑΚΟΣ                                          
ΑΣΤΡΑΝΤΙΝΗΣ                                       
ΑΣΤΡΑΠΑΙΟΣ                                        
ΑΣΤΡΑΠΕΛΛΟΣ                                       
ΑΣΤΡΑΠΕΛΟΣ                                        
ΑΣΤΡΑΣ                                            
ΑΣΤΡΑΤΣΑΝΑΚΗΣ                                     
ΑΣΤΡΕΙΔΗΣ                                         
ΑΣΤΡΕΙΝΙΔΗΣ                                       
ΑΣΤΡΕΧΑΣ                                          
ΑΣΤΡΙΔΑΚΗΣ                                        
ΑΣΤΡΙΔΗΣ                                          
ΑΣΤΡΙΝΑΚΗΣ                                        
ΑΣΤΡΙΝΗΣ                                          
ΑΣΤΡΙΝΙΔΗΣ                                        
ΑΣΤΡΙΝΟΣ                                          
ΑΣΤΡΙΤΑΚΗΣ                                        
ΑΣΤΡΙΤΗΣ                                          
ΑΣΤΡΟΠΑΛΙΤΗΣ                                      
ΑΣΤΡΟΠΑΛΙΩΤΗΣ                                     
ΑΣΤΡΟΠΕΚΑΚΗΣ                                      
ΑΣΤΡΟΥΔΗΣ                                         
ΑΣΤΡΟΥΛΑΚΗΣ                                       
ΑΣΤΡΟΥΛΛΑΚΗΣ                                      
ΑΣΤΥΑΚΟΠΟΥΛΟΣ                                     
ΑΣΤΥΠΑΛΙΤΗΣ                                       
ΑΣΤΥΠΑΛΙΩΤΗΣ                                      
ΑΣΤΥΡΑΚΑΚΗΣ                                       
ΑΣΤΥΦΙΔΗΣ                                         
ΑΣΥΛΛΟΓΙΣΤΟΣ                                      
ΑΣΥΛΟΓΙΣΤΑΚΗΣ                                     
ΑΣΥΛΟΓΙΣΤΟΣ                                       
ΑΣΥΜΟΜΥΤΗΣ                                        
ΑΣΦΑΛΤΙΔΗΣ                                        
ΑΣΦΕΝΤΑΓΑΚΗΣ                                      
ΑΣΦΗΣ                                             
ΑΣΧΑΡΙΔΗΣ                                         
ΑΣΧΟΝΙΤΗΣ                                         
ΑΣΩΜΑΤΙΑΝΟΣ                                       
ΑΣΩΜΑΤΟΣ                                          
ΑΣΩΝΙΤΗΣ                                          
ΑΣΩΤΗΣ                                            
ΑΤΑΚΤΙΔΗΣ                                         
ΑΤΑΛΑΛΗΣ                                          
ΑΤΑΛΑΣΙΔΗΣ                                        
ΑΤΑΛΕΙΩΤΗΣ                                        
ΑΤΑΛΗΣ                                            
ΑΤΑΛΙΑΛΗΣ                                         
ΑΤΑΛΙΑΝΗΣ                                         
ΑΤΑΛΙΔΗΣ                                          
ΑΤΑΛΙΩΤΗΣ                                         
ΑΤΑΛΛΑΣ                                           
ΑΤΑΛΛΙΑΛΟΣ                                        
ΑΤΑΛΛΙΩΤΗΣ                                        
ΑΤΑΜΕΓΚΟΣ                                         
ΑΤΑΜΠΑΣΙΔΗΣ                                       
ΑΤΑΝΑΛΗΣ                                          
ΑΤΑΝΙΔΗΣ                                          
ΑΤΑΡΤΗΣ                                           
ΑΤΑΣ                                              
ΑΤΕΜ ΟΓΛΟΥ                                        
ΑΤΕΣ                                              
ΑΤΕΣΗΣ                                            
ΑΤΕΣΙΔΗΣ                                          
ΑΤΕΣΛΗΣ                                           
ΑΤΖΑΚΑΣ                                           
ΑΤΖΑΚΛΗΣ                                          
ΑΤΖΑΜΑΛΙΔΗΣ                                       
ΑΤΖΑΜΗΣ                                           
ΑΤΖΑΜΙΔΑΚΗΣ                                       
ΑΤΖΑΜΙΔΗΣ                                         
ΑΤΖΑΜΠΟΣ                                          
ΑΤΖΑΝΟΣ                                           
ΑΤΖΑΡΑΚΗΣ                                         
ΑΤΖΑΡΑΣ                                           
ΑΤΖΑΡΗΣ                                           
ΑΤΖΑΣ                                             
ΑΤΖΕΛΙΔΗΣ                                         
ΑΤΖΕΜΑΚΗΣ                                         
ΑΤΖΕΜΗΣ                                           
ΑΤΖΕΜΙΔΑΚΗΣ                                       
ΑΤΖΕΜΙΔΗΣ                                         
ΑΤΖΕΜΟΠΟΥΛΟΣ                                      
ΑΤΖΗΜΑΚΗΣ                                         
ΑΤΖΗΣ                                             
ΑΤΖΙΑΜΗΣ                                          
ΑΤΖΙΑΡΑΣ                                          
ΑΤΖΙΔΗΣ                                           
ΑΤΖΙΜΑΚΗΣ                                         
ΑΤΖΙΜΠ                                            
ΑΤΖΙΝΑΣ                                           
ΑΤΖΙΟΣ                                            
ΑΤΖΙΤΗΡΗΣ                                         
ΑΤΖΟΛΕΤΑΚΗΣ                                       
ΑΤΖΟΛΙΔΑΚΗΣ                                       
ΑΤΖΟΣ                                             
ΑΤΖΟΥΛΑΤΟΣ                                        
ΑΤΖΟΥΛΗΣ                                          
ΑΤΖΟΥΤΖΟΥΛΑΣ                                      
ΑΤΗΛ ΟΓΛΟΥ                                        
ΑΤΗΣ                                              
ΑΤΙΣΕΛΛΗΣ                                         
ΑΤΙΣΗΣ                                            
ΑΤΙΣΣΗΣ                                           
ΑΤΛΑΖ                                             
ΑΤΛΑΖΗΣ                                           
ΑΤΛΑΣ                                             
ΑΤΛΑΣΗΣ                                           
ΑΤΛΙΔΑΚΗΣ                                         
ΑΤΜΑΚΙΔΗΣ                                         
ΑΤΜΑΤΖΑΚΗΣ                                        
ΑΤΜΑΤΖΑΣ                                          
ΑΤΜΑΤΖΙΔΗΣ                                        
ΑΤΜΑΤΣΙΑΔΗΣ                                       
ΑΤΜΑΤΣΙΔΗΣ                                        
ΑΤΜΕΤΖΙΔΗΣ                                        
ΑΤΜΗΝΗΣ                                           
ΑΤΡΑΙΔΑΣ                                          
ΑΤΡΑΙΔΗΣ                                          
ΑΤΡΑΠΟΠΟΥΛΟΣ                                      
ΑΤΡΑΣ                                             
ΑΤΡΑΧΑΛΗΣ                                         
ΑΤΡΕΑΣ                                            
ΑΤΡΕΙΔΗΣ                                          
ΑΤΡΙΔΗΣ                                           
ΑΤΡΙΧΟΠΟΥΛΟΣ                                      
ΑΤΣΑΒΕΣ                                           
ΑΤΣΑΙΔΗΣ                                          
ΑΤΣΑΛΑΚΗΣ                                         
ΑΤΣΑΛΑΣ                                           
ΑΤΣΑΛΗΣ                                           
ΑΤΣΑΛΙΝΟΣ                                         
ΑΤΣΑΛΟΣ                                           
ΑΤΣΑΜΕΤΑΚΗΣ                                       
ΑΤΣΑΡΟΣ                                           
ΑΤΣΑΣ                                             
ΑΤΣΕΛΕΣ                                           
ΑΤΣΕΡΠΗΣ                                          
ΑΤΣΗΣ                                             
ΑΤΣΙΓΚΙΟΖ                                         
ΑΤΣΙΔΑΚΟΣ                                         
ΑΤΣΙΔΑΥΤΗΣ                                        
ΑΤΣΙΔΑΦΤΗΣ                                        
ΑΤΣΙΔΗΣ                                           
ΑΤΣΙΚΑΚΑΝΗΣ                                       
ΑΤΣΙΚΑΚΑΝΙΔΗΣ                                     
ΑΤΣΙΚΑΝΙΔΗΣ                                       
ΑΤΣΙΚΒΑΣΗΣ                                        
ΑΤΣΙΚΕΛΗΣ                                         
ΑΤΣΙΚΙΔΗΣ                                         
ΑΤΣΙΚΜΑΣΗΣ                                        
ΑΤΣΙΚΜΠΑΣΗΣ                                       
ΑΤΣΙΚΝΟΥΔΑΣ                                       
ΑΤΣΙΚΠΑΣΗΣ                                        
ΑΤΣΙΜΟΒΙΤΣ                                        
ΑΤΣΙΟΣ                                            
ΑΤΣΙΠΑΠΑΣ                                         
ΑΤΣΙΠΟΥΛΙΑΝΑΚΗΣ                                   
ΑΤΣΙΠΟΥΛΙΑΝΟΣ                                     
ΑΤΣΚΑΚΑΝΗΣ                                        
ΑΤΣΚΑΚΑΝΙΔΗΣ                                      
ΑΤΣΟΝΙΟΣ                                          
ΑΤΣΟΠΑΡΔΗΣ                                        
ΑΤΣΟΣ                                             
ΑΤΣΩΝΙΟΣ                                          
ΑΤΤΑΛΑΣ                                           
ΑΤΤΑΛΕΙΑΔΗΣ                                       
ΑΤΤΑΛΕΙΩΤΗΣ                                       
ΑΤΤΑΛΙΑΛΗΣ                                        
ΑΤΤΑΛΙΔΗΣ                                         
ΑΤΤΑΛΙΩΤΗΣ                                        
ΑΤΤΑΛΛΑΣ                                          
ΑΤΤΑΡΑΣ                                           
ΑΤΤΑΣ                                             
ΑΤΤΗΣ                                             
ΑΤΤΙΑΣ                                            
ΑΤΤΙΚΗΣ                                           
ΑΤΤΙΚΟΣ                                           
ΑΤΤΙΛΑΚΟΣ                                         
ΑΤΤΙΤΗΣ                                           
ΑΤΤΟΝΗΣ                                           
ΑΤΤΩΝΗΣ                                           
ΑΥΓΕΑΣ                                            
ΑΥΓΕΙΤΑΣ                                          
ΑΥΓΕΛΗΣ                                           
ΑΥΓΕΝΑΚΗΣ                                         
ΑΥΓΕΝΑΚΙΣ                                         
ΑΥΓΕΝΗΣ                                           
ΑΥΓΕΝΙΚΟΣ                                         
ΑΥΓΕΝΟΣ                                           
ΑΥΓΕΝΟΥΔΗΣ                                        
ΑΥΓΕΡΑΚΗΣ                                         
ΑΥΓΕΡΑΝΤΩΝΗΣ                                      
ΑΥΓΕΡΗΣ                                           
ΑΥΓΕΡΙΔΗΣ                                         
ΑΥΓΕΡΙΚΟΣ                                         
ΑΥΓΕΡΙΝΑΚΗΣ                                       
ΑΥΓΕΡΙΝΑΚΟΣ                                       
ΑΥΓΕΡΙΝΑΣ                                         
ΑΥΓΕΡΙΝΙΔΗΣ                                       
ΑΥΓΕΡΙΝΟΠΟΥΛΟΣ                                    
ΑΥΓΕΡΙΝΟΣ                                         
ΑΥΓΕΡΙΝΟΥΔΗΣ                                      
ΑΥΓΕΡΟΔΗΜΟΣ                                       
ΑΥΓΕΡΟΠΟΥΛΟΣ                                      
ΑΥΓΕΡΟΣ                                           
ΑΥΓΕΤΙΔΗΣ                                         
ΑΥΓΗΡΕΛΛΗΣ                                        
ΑΥΓΗΡΗΣ                                           
ΑΥΓΗΤΑΣ                                           
ΑΥΓΗΤΙΔΗΣ                                         
ΑΥΓΗΤΟΠΟΥΛΟΣ                                      
ΑΥΓΙΑΣ                                            
ΑΥΓΙΔΗΣ                                           
ΑΥΓΙΚΟΣ                                           
ΑΥΓΙΤΙΔΗΣ                                         
ΑΥΓΙΤΣΗΣ                                          
ΑΥΓΟΚΛΟΥΡΗΣ                                       
ΑΥΓΟΛΟΥΠΗΣ                                        
ΑΥΓΟΠΟΥΛΟΣ                                        
ΑΥΓΟΣ                                             
ΑΥΓΟΥΔΟΠΟΥΛΟΣ                                     
ΑΥΓΟΥΛΑΔΑΚΗΣ                                      
ΑΥΓΟΥΛΑΣ                                          
ΑΥΓΟΥΛΕΑΣ                                         
ΑΥΓΟΥΛΗΣ                                          
ΑΥΓΟΥΛΙΔΗΣ                                        
ΑΥΓΟΥΛΛΑΣ                                         
ΑΥΓΟΥΛΛΗΣ                                         
ΑΥΓΟΥΡΟΠΟΥΛΟΣ                                     
ΑΥΓΟΥΣΙΑΝΑΚΗΣ                                     
ΑΥΓΟΥΣΤΑΚΗΣ                                       
ΑΥΓΟΥΣΤΑΤΟΣ                                       
ΑΥΓΟΥΣΤΗΣ                                         
ΑΥΓΟΥΣΤΙΑΔΗΣ                                      
ΑΥΓΟΥΣΤΙΑΝΑΚΗΣ                                    
ΑΥΓΟΥΣΤΙΑΝΟΣ                                      
ΑΥΓΟΥΣΤΙΔΗΣ                                       
ΑΥΓΟΥΣΤΙΝΑΚΗΣ                                     
ΑΥΓΟΥΣΤΙΝΑΣ                                       
ΑΥΓΟΥΣΤΙΝΑΤΟΣ                                     
ΑΥΓΟΥΣΤΙΝΙΑΤΟΣ                                    
ΑΥΓΟΥΣΤΙΝΟΣ                                       
ΑΥΓΟΥΣΤΟΠΟΥΛΟΣ                                    
ΑΥΔΑΙΜΙΩΤΗΣ                                       
ΑΥΔΑΛΑΣ                                           
ΑΥΔΑΛΗΣ                                           
ΑΥΔΑΝΑΣ                                           
ΑΥΔΗΣ                                             
ΑΥΔΙΚΟΣ                                           
ΑΥΔΟΚΗΣ                                           
ΑΥΔΟΥΛΗΣ                                          
ΑΥΔΟΥΣΗΣ                                          
ΑΥΖΩΤΗΣ                                           
ΑΥΘΕΝΤΟΠΟΥΛΟΣ                                     
ΑΥΘΙΝΟΣ                                           
ΑΥΚΟΣ                                             
ΑΥΚΟΥΔΙΑΣ                                         
ΑΥΛΑΚΑΣ                                           
ΑΥΛΑΚΙΩΤΗΣ                                        
ΑΥΛΑΜΗΣ                                           
ΑΥΛΑΣΤΙΜΙΔΗΣ                                      
ΑΥΛΗΤΗΣ                                           
ΑΥΛΙΑΝΟΣ                                          
ΑΥΛΙΔΗΣ                                           
ΑΥΛΙΧΟΣ                                           
ΑΥΛΙΩΤΗΣ                                          
ΑΥΛΟΓΗΤΟΣ                                         
ΑΥΛΟΓΙΑΡΗΣ                                        
ΑΥΛΩΝΑΡΙΤΗΣ                                       
ΑΥΛΩΝΑΣ                                           
ΑΥΛΩΝΙΤΗΣ                                         
ΑΥΞΕΝΤΗΣ                                          
ΑΥΞΕΝΤΙΑΔΗΣ                                       
ΑΥΞΕΝΤΙΔΗΣ                                        
ΑΥΞΩΝΙΔΗΣ                                         
ΑΥΡΑΜΕΑΣ                                          
ΑΥΡΗΛΙΩΝΗΣ                                        
ΑΥΣΑΡΙΔΗΣ                                         
ΑΥΣΤΗΡΟΠΟΥΛΟΣ                                     
ΑΥΤΑΝΤΙΛΙΔΗΣ                                      
ΑΥΤΑΡΑΣ                                           
ΑΥΤΖΑΓΓΕΛΗΣ                                       
ΑΥΤΖΑΚΗΣ                                          
ΑΥΤΖΑΛΑΝΙΔΗΣ                                      
ΑΥΤΖΕΛΑΝΙΔΗΣ                                      
ΑΥΤΖΗΓΙΑΝΝΗΣ                                      
ΑΥΤΖΗΣ                                            
ΑΥΤΖΙΔΗΣ                                          
ΑΥΤΙΑΣ                                            
ΑΥΤΟΣΜΙΔΗΣ                                        
ΑΥΤΟΥΣΜΗΣ                                         
ΑΥΤΟΦΟΡΙΔΗΣ                                       
ΑΥΤΣΙΔΗΣ                                          
ΑΥΦΑΝΤΗΣ                                          
ΑΥΦΑΝΤΟΠΟΥΛΟΣ                                     
ΑΥΧΙΑΝΕΣ                                          
ΑΥΧΟΥΔΙΑΣ                                         
ΑΦΑΛΕΑΣ                                           
ΑΦΑΛΗΣ                                            
ΑΦΑΛΙΔΗΣ                                          
ΑΦΑΛΩΝΙΑΤΗΣ                                       
ΑΦΑΝΑΣΙΑΔΗΣ                                       
ΑΦΑΝΑΣΙΔΗΣ                                        
ΑΦΑΝΤΕΝΟΣ                                         
ΑΦΑΝΤΙΤΗΣ                                         
ΑΦΑΡΑΣ                                            
ΑΦΑΣ                                              
ΑΦΑΤΖΑΝΗΣ                                         
ΑΦΑΤΖΑΝΙΔΗΣ                                       
ΑΦΑΤΖΙΑΝΗΣ                                        
ΑΦΑΤΙΔΗΣ                                          
ΑΦΕΖΟΛΗΣ                                          
ΑΦΕΙΔΗΣ                                           
ΑΦΕΝΔΗΣ                                           
ΑΦΕΝΔΟΠΟΥΛΟΣ                                      
ΑΦΕΝΔΟΥΛΗΣ                                        
ΑΦΕΝΔΡΑΚΗΣ                                        
ΑΦΕΝΔΡΑΣ                                          
ΑΦΕΝΔΡΗΣ                                          
ΑΦΕΝΔΡΟΥΛΗΣ                                       
ΑΦΕΝΤΑΚΗΣ                                         
ΑΦΕΝΤΗΣ                                           
ΑΦΕΝΤΙΔΗΣ                                         
ΑΦΕΝΤΙΤΣΑΣ                                        
ΑΦΕΝΤΟΚΛΕΑΣ                                       
ΑΦΕΝΤΟΛΟΠΟΥΛΟΣ                                    
ΑΦΕΝΤΟΠΟΥΛΟΣ                                      
ΑΦΕΝΤΟΣ                                           
ΑΦΕΝΤΟΥΔΗΣ                                        
ΑΦΕΝΤΟΥΛΗΣ                                        
ΑΦΕΝΤΟΥΛΙΔΗΣ                                      
ΑΦΕΝΤΡΑΣ                                          
ΑΦΕΝΤΡΙΑΣ                                         
ΑΦΕΣΙΑΔΗΣ                                         
ΑΦΕΤΖΟΠΟΥΛΟΣ                                      
ΑΦΕΤΗΣ                                            
ΑΦΗΣΙΑΔΗΣ                                         
ΑΦΘΟΝΙΑΔΗΣ                                        
ΑΦΘΟΝΙΑΤΗΣ                                        
ΑΦΘΟΝΙΔΗΣ                                         
ΑΦΙΑΝΕΣ                                           
ΑΦΙΑΝΟΣ                                           
ΑΦΙΑΣ                                             
ΑΦΙΟΝΤΖΗΣ                                         
ΑΦΙΣΙΑΔΗΣ                                         
ΑΦΙΣΙΔΗΣ                                          
ΑΦΙΣΟΠΟΥΛΟΣ                                       
ΑΦΙΦΗΣ                                            
ΑΦΙΩΝΗΣ                                           
ΑΦΚΟΣ                                             
ΑΦΚΟΥΔΙΑΣ                                         
ΑΦΟΚΑΤΗΣ                                          
ΑΦΟΝΙΔΗΣ                                          
ΑΦΟΞΕΝΙΔΗΣ                                        
ΑΦΟΡΔΑΚΟΣ                                         
ΑΦΟΡΕΣΜΕΝΟΣ                                       
ΑΦΟΡΟΖΗΣ                                          
ΑΦΟΡΥΖΗΣ                                          
ΑΦΟΥΚΑΤΟΥΔΗΣ                                      
ΑΦΟΥΞΕΝΙΔΗΣ                                       
ΑΦΟΥΡΑΣ                                           
ΑΦΡΑΘΙΑΝΑΚΗΣ                                      
ΑΦΡΑΝΤΗΣ                                          
ΑΦΡΑΝΤΟΣ                                          
ΑΦΡΑΤΑΙΟΣ                                         
ΑΦΡΑΤΗΣ                                           
ΑΦΡΙΔΗΣ                                           
ΑΦΡΟΔΟΠΟΥΛΟΣ                                      
ΑΦΡΟΥΔΑΚΗΣ                                        
ΑΦΡΟΥΔΑΣ                                          
ΑΦΣΑΡΙΔΗΣ                                         
ΑΦΤΑΝΔΙΛΙΔΗΣ                                      
ΑΦΤΑΝΤΙΛΙΔΗΣ                                      
ΑΦΤΙΤΣΗΣ                                          
ΑΦΤΟΠΟΥΛΟΣ                                        
ΑΦΧΙΑΝΕΣ                                          
ΑΧΑΓΙΩΤΗΣ                                         
ΑΧΑΛΙΝΟΠΟΥΛΟΣ                                     
ΑΧΑΜΝΟΣ                                           
ΑΧΑΝΙΩΤΗΣ                                         
ΑΧΑΡΙΔΗΣ                                          
ΑΧΒΕΡΤΙΔΗΣ                                        
ΑΧΒΛΕΝΤΙΑΝΗΣ                                      
ΑΧΕΙΛΑΡΑΣ                                         
ΑΧΕΙΛΑΣ                                           
ΑΧΕΙΛΙΑΣ                                          
ΑΧΕΙΜΑΣΤΟΣ                                        
ΑΧΕΛΑΡΟΥΔΗΣ                                       
ΑΧΕΛΩΝΟΥΔΗΣ                                       
ΑΧΗΣ                                              
ΑΧΘΟΦΟΡΙΔΗΣ                                       
ΑΧΙΑΝΙΩΤΗΣ                                        
ΑΧΙΛΑΔΕΛΛΗΣ                                       
ΑΧΙΛΑΡΑΣ                                          
ΑΧΙΛΕΟΠΟΥΛΟΣ                                      
ΑΧΙΛΙΑΣ                                           
ΑΧΙΛΛΑΔΕΛΗΣ                                       
ΑΧΙΛΛΑΣ                                           
ΑΧΙΛΛΕΙΑΔΗΣ                                       
ΑΧΙΛΛΕΙΔΗΣ                                        
ΑΧΙΛΛΕΟΠΟΥΛΟΣ                                     
ΑΧΙΛΛΕΟΥΔΗΣ                                       
ΑΧΙΛΛΕΥΣ                                          
ΑΧΙΛΛΕΩΣ                                          
ΑΧΙΛΛΗΣ                                           
ΑΧΙΛΛΙΑΣ                                          
ΑΧΙΛΛΟΠΟΥΛΟΣ                                      
ΑΧΙΝΑΣ                                            
ΑΧΙΝΙΩΤΗΣ                                         
ΑΧΙΟΛΑΣ                                           
ΑΧΙΡΚΙΔΗΣ                                         
ΑΧΚΟΖΙΔΗΣ                                         
ΑΧΛΑΔΑΣ                                           
ΑΧΛΑΔΗΣ                                           
ΑΧΛΑΔΙΑΝΑΚΗΣ                                      
ΑΧΛΑΔΙΤΗΣ                                         
ΑΧΛΑΔΙΩΤΗΣ                                        
ΑΧΛΑΤΖΗΣ                                          
ΑΧΛΑΤΗΣ                                           
ΑΧΛΑΤΛΗΣ                                          
ΑΧΛΙΟΠΤΑΣ                                         
ΑΧΛΙΟΣ                                            
ΑΧΛΙΩΠΑΣ                                          
ΑΧΜΑΚΗΣ                                           
ΑΧΜΑΚΙΔΗΣ                                         
ΑΧΜΑΝΙΔΗΣ                                         
ΑΧΜΑΤΑΣ                                           
ΑΧΜΑΤΙΩΤΗΣ                                        
ΑΧΜΕΝΤ ΑΛΗ                                        
ΑΧΜΕΝΤ ΧΑΣΑΝ                                      
ΑΧΜΕΤ ΑΛΗ ΟΓΛΟΥ                                   
ΑΧΜΕΤ ΑΧΜΕΤ                                       
ΑΧΜΕΤ ΑΧΜΕΤ ΧΑΣΑΝ                                 
ΑΧΜΕΤ ΓΙΟΥΣΟΥΦ                                    
ΑΧΜΕΤ ΔΙΚΜΕ                                       
ΑΧΜΕΤ ΕΜΙΝ                                        
ΑΧΜΕΤ ΙΛΙΑΖ                                       
ΑΧΜΕΤ ΙΣΜΑΗΛ                                      
ΑΧΜΕΤ ΚΕΧΑΓΙΑ                                     
ΑΧΜΕΤ ΚΕΧΑΓΙΑ ΙΣΜΑΗΛ                              
ΑΧΜΕΤ ΜΕΜΕΤ                                       
ΑΧΜΕΤ ΜΕΜΕΤ ΟΓΛΟΥ                                 
ΑΧΜΕΤ ΜΕΧΜΕΤ                                      
ΑΧΜΕΤ ΜΟΛΛΑ ΟΓΛΟΥ                                 
ΑΧΜΕΤ ΜΟΥΡΜΟΥΡ ΧΑΣΑΝ                              
ΑΧΜΕΤ ΜΟΥΣΤΑΦΑ                                    
ΑΧΜΕΤ ΜΠΑΛ ΟΓΛΑΡΗ                                 
ΑΧΜΕΤ ΜΠΑΣΑ                                       
ΑΧΜΕΤ ΜΠΑΧΡΗ                                      
ΑΧΜΕΤ ΜΠΕΗ ΟΓΛΟΥ                                  
ΑΧΜΕΤ ΝΤΑΗ                                        
ΑΧΜΕΤ ΟΓΛΟΥ                                       
ΑΧΜΕΤ ΟΓΛΟΥ ΗΛΙΑΖ                                 
ΑΧΜΕΤ ΟΣΜΑΝ ΑΧΜΕΤ                                 
ΑΧΜΕΤ ΟΥΖΟΥΝ                                      
ΑΧΜΕΤ ΟΥΣΤΑ                                       
ΑΧΜΕΤ ΠΙΣ                                         
ΑΧΜΕΤ ΡΕΤΖΕΠ                                      
ΑΧΜΕΤ ΣΑΙΤ                                        
ΑΧΜΕΤ ΣΑΛΗ                                        
ΑΧΜΕΤ ΣΕΛΗΜ                                       
ΑΧΜΕΤ ΣΕΡΗΦ                                       
ΑΧΜΕΤ ΣΙΑΜΠΑΝ                                     
ΑΧΜΕΤ ΣΟΥΚΡΗ                                      
ΑΧΜΕΤ ΣΟΥΛΕΙΜΑΝ                                   
ΑΧΜΕΤ ΤΟΠΑΛ                                       
ΑΧΜΕΤ ΤΣΑΟΥΣ                                      
ΑΧΜΕΤ ΤΣΑΟΥΣ ΟΓΛΟΥ                                
ΑΧΜΕΤ ΤΣΙΑΟΥΣ                                     
ΑΧΜΕΤ ΤΣΟΜΠΑΝ                                     
ΑΧΜΕΤ ΧΑΛΗΛ                                       
ΑΧΜΕΤ ΧΑΛΗΛ ΙΜΠΡΑΜ                                
ΑΧΜΕΤ ΧΑΜΑΛ                                       
ΑΧΜΕΤ ΧΑΜΔΗ ΟΓΛΟΥ                                 
ΑΧΜΕΤ ΧΑΣΑΝ                                       
ΑΧΜΕΤ ΧΑΣΑΝΟΓΛΟΥ                                  
ΑΧΜΕΤ ΧΟΤΖΑ                                       
ΑΧΜΕΤΖΙΚ ΑΧΜΕΤ                                    
ΑΧΜΕΤΖΙΚ ΜΕΜΕΤ                                    
ΑΧΜΕΤΗΣ                                           
ΑΧΜΕΤΣΙΚ ΑΛΗ ΟΓΛΟΥ                                
ΑΧΜΕΤΣΙΚ ΜΕΜΕΤ                                    
ΑΧΜΕΤΣΙΚ ΟΓΛΟΥ                                    
ΑΧΝΑΖΙΔΗΣ                                         
ΑΧΝΟΥΛΑΣ                                          
ΑΧΝΤΑΜΠ                                           
ΑΧΟΛΟΣ                                            
ΑΧΟΥΖΑΡΙΔΗΣ                                       
ΑΧΟΥΛΗΣ                                           
ΑΧΟΥΛΙΑΣ                                          
ΑΧΟΥΡΙΩΤΗΣ                                        
ΑΧΠΑΖ                                             
ΑΧΠΑΡΑΚΗΣ                                         
ΑΧΠΑΡΙΔΗΣ                                         
ΑΧΠΑΣ                                             
ΑΧΠΑΤΖΙΔΗΣ                                        
ΑΧΡΑΜΟΒΙΤΣ                                        
ΑΧΡΑΝΗΣ                                           
ΑΧΡΑΣ                                             
ΑΧΡΕΝ ΜΕΜΕΤ                                       
ΑΧΡΕΤΗΣ                                           
ΑΧΡΙΑΝ ΑΜΕΤ                                       
ΑΧΡΙΑΝ ΜΟΥΣΤΑΦΑ                                   
ΑΧΡΙΑΝΗΣ                                          
ΑΧΡΙΚΙΔΗΣ                                         
ΑΧΤΑΡΗΣ                                           
ΑΧΤΑΡΙΔΗΣ                                         
ΑΧΤΑΡΟΠΟΥΛΟΣ                                      
ΑΧΤΖΑΛΩΤΙΔΗΣ                                      
ΑΧΤΙΔΑΣ                                           
ΑΧΤΙΝΟΥΔΗΣ                                        
ΑΧΤΙΠΗΣ                                           
ΑΧΤΣΑΛΩΤΙΔΗΣ                                      
ΑΧΤΣΕΛΙΔΗΣ                                        
ΑΧΤΣΗΒΑΣΙΛΗΣ                                      
ΑΧΤΣΗΣ                                            
ΑΧΤΣΙΔΗΣ                                          
ΑΧΤΥΠΗΣ                                           
ΑΧΥΛΑΡΟΥΔΗΣ                                       
ΑΧΥΡΑΚΗΣ                                          
ΑΧΥΡΓΙΑΤΗΣ                                        
ΑΧΥΡΙΑΤΗΣ                                         
ΑΧΥΡΙΔΗΣ                                          
ΑΧΥΡΚΙΔΗΣ                                         
ΑΧΥΡΟΠΟΥΛΟΣ                                       
ΑΧΩΝΕΥΤΟΣ                                         
ΑΧΩΝΗΣ                                            
ΑΨΑΘΑΣ                                            
ΑΨΕΜΙΔΗΣ                                          
ΑΨΗΛΙΔΗΣ                                          
ΑΨΗΛΟΣ                                            
ΑΨΗΣ                                              
ΑΨΟΚΑΡΔΟΣ                                         
ΑΨΟΜΩΤΟΣ                                          
ΑΨΟΥΡΗΣ                                           
ΑΨΥΧΟΣ                                            
ΑΨΩΚΑΡΔΟΣ                                         
ΑΩΤΙΔΗΣ                                           
ΑΪΒΑΖΗ                                            
ΑΪΒΑΖΗΣ                                           
ΑΪΒΑΖΙΑΝ                                          
ΑΪΒΑΖΟΠΟΥΛΟΣ                                      
ΑΪΒΑΛΗΣ                                           
ΑΪΒΑΛΙΩΤΗΣ                                        
ΑΪΝΑΤΖΟΓΛΟΥ                                       
ΑΫΦΑΝΤΗ                                           
ΑΫΦΑΝΤΗΣ                                          
ΒΑΒΑΓΙΑΚΗΣ                                        
ΒΑΒΑΓΙΑΝΝΗΣ                                       
ΒΑΒΑΔΑΚΗΣ                                         
ΒΑΒΑΔΕΡΗΣ                                         
ΒΑΒΑΘΑΣ                                           
ΒΑΒΑΙΤΗΣ                                          
ΒΑΒΑΚΑΛΙΝΑΣ                                       
ΒΑΒΑΚΑΣ                                           
ΒΑΒΑΚΗΣ                                           
ΒΑΒΑΚΟΣ                                           
ΒΑΒΑΛΑΣ                                           
ΒΑΒΑΛΕΑΣ                                          
ΒΑΒΑΛΕΚΑΣ                                         
ΒΑΒΑΛΕΡΟΣ                                         
ΒΑΒΑΛΕΣΚΟΣ                                        
ΒΑΒΑΛΕΤΣΚΟΣ                                       
ΒΑΒΑΛΗΣ                                           
ΒΑΒΑΛΙΑΓΚΑΚΗΣ                                     
ΒΑΒΑΛΙΑΡΗΣ                                        
ΒΑΒΑΛΙΑΡΟΣ                                        
ΒΑΒΑΛΙΑΣ                                          
ΒΑΒΑΛΙΔΗΣ                                         
ΒΑΒΑΛΙΚΟΥΔΗΣ                                      
ΒΑΒΑΛΙΟΣ                                          
ΒΑΒΑΛΟΣ                                           
ΒΑΒΑΜΗΣ                                           
ΒΑΒΑΝΑΚΟΣ                                         
ΒΑΒΑΝΑΤΣΟΣ                                        
ΒΑΒΑΝΕΛΛΟΣ                                        
ΒΑΒΑΝΟΣ                                           
ΒΑΒΑΡΑΠΗΣ                                         
ΒΑΒΑΡΕΤΟΣ                                         
ΒΑΒΑΡΗΣ                                           
ΒΑΒΑΡΙΝΗΣ                                         
ΒΑΒΑΡΙΝΟΣ                                         
ΒΑΒΑΡΟΥΤΑΣ                                        
ΒΑΒΑΡΟΥΤΣΟΣ                                       
ΒΑΒΑΣ                                             
ΒΑΒΑΣΗΣ                                           
ΒΑΒΑΣΙΑΣ                                          
ΒΑΒΑΤΖΑΝΗΣ                                        
ΒΑΒΑΤΖΑΝΙΔΗΣ                                      
ΒΑΒΑΤΖΑΝΟΣ                                        
ΒΑΒΑΤΖΙΑΝΗΣ                                       
ΒΑΒΑΤΗΣ                                           
ΒΑΒΑΤΣΗΣ                                          
ΒΑΒΑΤΣΙΚΑΣ                                        
ΒΑΒΑΤΣΙΚΛΗΣ                                       
ΒΑΒΑΤΣΙΚΟΣ                                        
ΒΑΒΑΤΣΙΟΥΛΑΣ                                      
ΒΑΒΑΤΣΟΥΛΑΣ                                       
ΒΑΒΑΦΙΓΚΟΣ                                        
ΒΑΒΒΑΣ                                            
ΒΑΒΒΟΣ                                            
ΒΑΒΒΟΥΚΟΣ                                         
ΒΑΒΒΟΥΡΑΣ                                         
ΒΑΒΔΙΑΝΟΣ                                         
ΒΑΒΔΙΝΟΣ                                          
ΒΑΒΔΙΝΟΥΔΗΣ                                       
ΒΑΒΔΟΣ                                            
ΒΑΒΔΥΝΟΣ                                          
ΒΑΒΕΚΗΣ                                           
ΒΑΒΕΛΙΔΗΣ                                         
ΒΑΒΕΣΟΣ                                           
ΒΑΒΕΤΣΗΣ                                          
ΒΑΒΗΣ                                             
ΒΑΒΙΑΚΟΣ                                          
ΒΑΒΙΑΣ                                            
ΒΑΒΙΖΟΣ                                           
ΒΑΒΙΘΗΣ                                           
ΒΑΒΙΚΗΣ                                           
ΒΑΒΙΛΗΣ                                           
ΒΑΒΙΤΗΣ                                           
ΒΑΒΙΤΣΑΣ                                          
ΒΑΒΛΑΔΕΛΗΣ                                        
ΒΑΒΛΑΔΕΛΛΗΣ                                       
ΒΑΒΛΑΣ                                            
ΒΑΒΛΕΚΑΣ                                          
ΒΑΒΛΕΚΗΣ                                          
ΒΑΒΛΗΣ                                            
ΒΑΒΛΙΑΚΗΣ                                         
ΒΑΒΛΙΑΡΑΣ                                         
ΒΑΒΛΙΔΑΣ                                          
ΒΑΒΛΟΥΚΗΣ                                         
ΒΑΒΟΛΑΣ                                           
ΒΑΒΟΣ                                             
ΒΑΒΟΥΓΙΟΣ                                         
ΒΑΒΟΥΓΥΙΟΣ                                        
ΒΑΒΟΥΔΑΚΗΣ                                        
ΒΑΒΟΥΔΗΣ                                          
ΒΑΒΟΥΖΑΣ                                          
ΒΑΒΟΥΛΑΚΗΣ                                        
ΒΑΒΟΥΛΑΡΗΣ                                        
ΒΑΒΟΥΛΑΣ                                          
ΒΑΒΟΥΛΕΑΣ                                         
ΒΑΒΟΥΛΕΣ                                          
ΒΑΒΟΥΛΗΣ                                          
ΒΑΒΟΥΛΙΔΗΣ                                        
ΒΑΒΟΥΛΙΩΤΗΣ                                       
ΒΑΒΟΥΛΟΓΙΑΝΝΗΣ                                    
ΒΑΒΟΥΡΑΚΗΣ                                        
ΒΑΒΟΥΡΑΝΑΚΗΣ                                      
ΒΑΒΟΥΡΑΣ                                          
ΒΑΒΟΥΡΗΣ                                          
ΒΑΒΟΥΣ                                            
ΒΑΒΟΥΣΗΣ                                          
ΒΑΒΟΥΤΑΚΗΣ                                        
ΒΑΒΟΥΤΗΣ                                          
ΒΑΒΡΙΝΟΒΙΤΣ                                       
ΒΑΒΡΙΤΣΑΣ                                         
ΒΑΒΥΛΑΣ                                           
ΒΑΒΥΛΗΣ                                           
ΒΑΒΥΛΟΥΣΑΚΗΣ                                      
ΒΑΒΥΛΩΝΗΣ                                         
ΒΑΒΩΝΗΣ                                           
ΒΑΓΑΒΑΝΙΔΗΣ                                       
ΒΑΓΑΚΗΣ                                           
ΒΑΓΑΝΑΚΗΣ                                         
ΒΑΓΑΝΙΔΗΣ                                         
ΒΑΓΑΡΑΛΗΣ                                         
ΒΑΓΓΑΛΑΤΗΣ                                        
ΒΑΓΓΑΛΗΣ                                          
ΒΑΓΓΑΣ                                            
ΒΑΓΓΕΛΑΚΑΚΗΣ                                      
ΒΑΓΓΕΛΑΚΗΣ                                        
ΒΑΓΓΕΛΑΚΟΣ                                        
ΒΑΓΓΕΛΑΚΟΥΔΗΣ                                     
ΒΑΓΓΕΛΑΡΑΣ                                        
ΒΑΓΓΕΛΑΣ                                          
ΒΑΓΓΕΛΑΤΟΣ                                        
ΒΑΓΓΕΛΗΣ                                          
ΒΑΓΓΕΛΙΑΣ                                         
ΒΑΓΓΕΛΙΔΗΣ                                        
ΒΑΓΓΕΛΙΝΟΣ                                        
ΒΑΓΓΕΛΟΓΙΑΝΝΗΣ                                    
ΒΑΓΓΕΛΟΚΩΣΤΑΣ                                     
ΒΑΓΓΕΛΟΠΟΥΛΟΣ                                     
ΒΑΓΓΕΛΟΣ                                          
ΒΑΓΓΕΛΟΥΔΗΣ                                       
ΒΑΓΓΕΛΟΥΣΗΣ                                       
ΒΑΓΓΕΛΤΖΙΚΗΣ                                      
ΒΑΓΓΕΛΤΣΙΚΟΥΔΗΣ                                   
ΒΑΓΓΕΣ                                            
ΒΑΓΓΗΣ                                            
ΒΑΓΓΙΑΣ                                           
ΒΑΓΓΙΔΗΣ                                          
ΒΑΓΓΙΟΣ                                           
ΒΑΓΓΛΗΣ                                           
ΒΑΓΓΟΠΟΥΛΟΣ                                       
ΒΑΓΓΟΣ                                            
ΒΑΓΓΟΥΣΗΣ                                         
ΒΑΓΔΑΣ                                            
ΒΑΓΔΑΤΗΣ                                          
ΒΑΓΔΑΤΛΗΣ                                         
ΒΑΓΔΑΤΟΠΟΥΛΟΣ                                     
ΒΑΓΔΟΥΤΗΣ                                         
ΒΑΓΕΝΑΚΗΣ                                         
ΒΑΓΕΝΑΣ                                           
ΒΑΓΕΝΙΔΗΣ                                         
ΒΑΓΕΝΟΣ                                           
ΒΑΓΕΝΟΥΔΗΣ                                        
ΒΑΓΕΡΑΚΑΣ                                         
ΒΑΓΕΤΑΣ                                           
ΒΑΓΗΣ                                             
ΒΑΓΙΑΒΟΥΣΗΣ                                       
ΒΑΓΙΑΖΙΔΗΣ                                        
ΒΑΓΙΑΚΑΚΟΣ                                        
ΒΑΓΙΑΚΑΣ                                          
ΒΑΓΙΑΚΗΣ                                          
ΒΑΓΙΑΚΟΣ                                          
ΒΑΓΙΑΝΑΚΗΣ                                        
ΒΑΓΙΑΝΑΣ                                          
ΒΑΓΙΑΝΔΕΡΗΣ                                       
ΒΑΓΙΑΝΕΛΗΣ                                        
ΒΑΓΙΑΝΗΣ                                          
ΒΑΓΙΑΝΙΔΗΣ                                        
ΒΑΓΙΑΝΝΑΚΗΣ                                       
ΒΑΓΙΑΝΝΑΚΙΣ                                       
ΒΑΓΙΑΝΝΗΣ                                         
ΒΑΓΙΑΝΝΙΔΗΣ                                       
ΒΑΓΙΑΝΝΟΠΟΥΛΟΣ                                    
ΒΑΓΙΑΝΝΟΣ                                         
ΒΑΓΙΑΝΟΠΟΥΛΟΣ                                     
ΒΑΓΙΑΝΟΣ                                          
ΒΑΓΙΑΡΗΣ                                          
ΒΑΓΙΑΣ                                            
ΒΑΓΙΑΤΑΣ                                          
ΒΑΓΙΑΤΗΣ                                          
ΒΑΓΙΑΤΙΔΗΣ                                        
ΒΑΓΙΑΤΛΑΚΗΣ                                       
ΒΑΓΙΟΚΑΣ                                          
ΒΑΓΙΟΝΑΚΗΣ                                        
ΒΑΓΙΟΝΑΣ                                          
ΒΑΓΙΟΝΕΤΑΣ                                        
ΒΑΓΙΟΝΗΣ                                          
ΒΑΓΙΟΝΙΤΗΣ                                        
ΒΑΓΙΟΠΟΥΛΟΣ                                       
ΒΑΓΙΟΣ                                            
ΒΑΓΙΟΥΛΗΣ                                         
ΒΑΓΙΤΣΗΣ                                          
ΒΑΓΙΩΚΑΣ                                          
ΒΑΓΙΩΝΑΚΗΣ                                        
ΒΑΓΙΩΝΑΣ                                          
ΒΑΓΙΩΝΗΣ                                          
ΒΑΓΙΩΝΙΤΗΣ                                        
ΒΑΓΙΩΡΓΑΚΗΣ                                       
ΒΑΓΙΩΤΑΚΗΣ                                        
ΒΑΓΙΩΤΑΣ                                          
ΒΑΓΙΩΤΗΣ                                          
ΒΑΓΚΑΚΗΣ                                          
ΒΑΓΚΑΛΗΣ                                          
ΒΑΓΚΑΛΙΩΤΗΣ                                       
ΒΑΓΚΑΣ                                            
ΒΑΓΚΕΣ                                            
ΒΑΓΚΙΔΑΣ                                          
ΒΑΓΚΙΔΗΣ                                          
ΒΑΓΚΛΗΣ                                           
ΒΑΓΚΟΠΟΥΛΟΣ                                       
ΒΑΓΚΟΣ                                            
ΒΑΓΚΟΥΣΗΣ                                         
ΒΑΓΛΑΣ                                            
ΒΑΓΛΗΣ                                            
ΒΑΓΟΠΟΥΛΟΣ                                        
ΒΑΓΟΣ                                             
ΒΑΓΟΥΡΔΗΣ                                         
ΒΑΓΡΟΠΟΥΛΟΣ                                       
ΒΑΔΑΚΗΣ                                           
ΒΑΔΑΛΑΣ                                           
ΒΑΔΑΛΟΥΚΑΣ                                        
ΒΑΔΑΡΛΗΣ                                          
ΒΑΔΑΣ                                             
ΒΑΔΑΣΗΣ                                           
ΒΑΔΕΒΟΥΛΗΣ                                        
ΒΑΔΕΚΑΣ                                           
ΒΑΔΕΛΗΣ                                           
ΒΑΔΕΣΚΑΣ                                          
ΒΑΔΕΤΣΗΣ                                          
ΒΑΔΗΜΑΣ                                           
ΒΑΔΗΣ                                             
ΒΑΔΙΑΚΑΣ                                          
ΒΑΔΙΒΟΥΛΗΣ                                        
ΒΑΔΙΚΟΛΙΑΣ                                        
ΒΑΔΙΚΟΛΙΟΣ                                        
ΒΑΔΙΝΑΣ                                           
ΒΑΔΙΤΗΣ                                           
ΒΑΔΟΚΑΣ                                           
ΒΑΔΟΛΑΣ                                           
ΒΑΔΟΥΛΗΣ                                          
ΒΑΔΟΥΡΙΔΗΣ                                        
ΒΑΔΡΑΣΚΑΣ                                         
ΒΑΔΡΑΤΣΙΚΑΣ                                       
ΒΑΔΡΑΤΣΚΑΣ                                        
ΒΑΔΡΑΧΑΝΗΣ                                        
ΒΑΕΝΑΣ                                            
ΒΑΕΝΗΣ                                            
ΒΑΕΝΝΗΣ                                           
ΒΑΖΑΙΟΣ                                           
ΒΑΖΑΚΑΣ                                           
ΒΑΖΑΚΗΣ                                           
ΒΑΖΑΚΙΔΗΣ                                         
ΒΑΖΑΚΟΠΟΥΛΟΣ                                      
ΒΑΖΑΛΙΔΗΣ                                         
ΒΑΖΑΛΟΥΚΑΣ                                        
ΒΑΖΑΝΑΣ                                           
ΒΑΖΑΝΕΛΗΣ                                         
ΒΑΖΑΝΕΛΛΗΣ                                        
ΒΑΖΑΡΛΗΣ                                          
ΒΑΖΑΣ                                             
ΒΑΖΑΤΗΣ                                           
ΒΑΖΓΙΟΥΡΑΚΗΣ                                      
ΒΑΖΓΙΟΥΡΟΥΚΟΣ                                     
ΒΑΖΕΛΑΚΗΣ                                         
ΒΑΖΕΝΙΟΣ                                          
ΒΑΖΕΟΣ                                            
ΒΑΖΗΣ                                             
ΒΑΖΙΑΝΟΣ                                          
ΒΑΖΙΚΑΣ                                           
ΒΑΖΙΜΑΣ                                           
ΒΑΖΙΜΟΠΟΥΛΟΣ                                      
ΒΑΖΙΝΤΑΡΗΣ                                        
ΒΑΖΙΟΥΡΑΚΗΣ                                       
ΒΑΖΙΡΓΙΑΝΝΗΣ                                      
ΒΑΖΙΡΓΙΑΝΤΖΙΚΗΣ                                   
ΒΑΖΙΤΑΡΗΣ                                         
ΒΑΖΙΩΤΑΣ                                          
ΒΑΖΛΑΔΕΛΗΣ                                        
ΒΑΖΛΑΜΑΤΖΗΣ                                       
ΒΑΖΛΑΣ                                            
ΒΑΖΟΓΙΑΝΝΗΣ                                       
ΒΑΖΟΠΟΥΛΟΣ                                        
ΒΑΖΟΣ                                             
ΒΑΖΟΥΒΙΑΔΗΣ                                       
ΒΑΖΟΥΚΗΣ                                          
ΒΑΖΟΥΡΑΚΗΣ                                        
ΒΑΖΟΥΡΑΣ                                          
ΒΑΖΟΥΡΟΥΚΗΣ                                       
ΒΑΖΥΡΙΑΝΗΣ                                        
ΒΑΗΝΑΣ                                            
ΒΑΗΣ                                              
ΒΑΘΑΚΟΣ                                           
ΒΑΘΕΙΑΣ                                           
ΒΑΘΕΙΩΤΗΣ                                         
ΒΑΘΗΣ                                             
ΒΑΘΙΑΝΑΚΗΣ                                        
ΒΑΘΙΣΤΑΣ                                          
ΒΑΘΙΩΤΑΚΗΣ                                        
ΒΑΘΙΩΤΗΣ                                          
ΒΑΘΡΑΚΑΣ                                          
ΒΑΘΡΑΚΕΑΣ                                         
ΒΑΘΡΑΚΗΣ                                          
ΒΑΘΡΑΚΙΔΗΣ                                        
ΒΑΘΡΑΚΟΓΙΑΝΝΗΣ                                    
ΒΑΘΡΑΚΟΚΟΙΛΗΣ                                     
ΒΑΘΡΑΚΟΥΛΗΣ                                       
ΒΑΘΥΚΙΩΤΗΣ                                        
ΒΑΘΥΛΑΚΗΣ                                         
ΒΑΘΥΠΟΥΛΙΑΣ                                       
ΒΑΙΑΚΗΣ                                           
ΒΑΙΑΚΟΠΟΥΛΟΣ                                      
ΒΑΙΑΝΝΗΣ                                          
ΒΑΙΑΝΟΣ                                           
ΒΑΙΑΣ                                             
ΒΑΙΒΑΚΑΝΙΔΗΣ                                      
ΒΑΙΒΑΟΣ                                           
ΒΑΙΒΟΔΑΣ                                          
ΒΑΙΓΚΟΥΣΗΣ                                        
ΒΑΙΔΑΚΗΣ                                          
ΒΑΙΔΑΝΗΣ                                          
ΒΑΙΔΗΣ                                            
ΒΑΙΔΟΜΑΡΚΑΚΗΣ                                     
ΒΑΙΔΟΥΛΗΣ                                         
ΒΑΙΖΙΔΗΣ                                          
ΒΑΙΚΟΣ                                            
ΒΑΙΚΟΥΖΗΣ                                         
ΒΑΙΚΟΥΣΗΣ                                         
ΒΑΙΛΑΚΑΚΗΣ                                        
ΒΑΙΛΑΚΗΣ                                          
ΒΑΙΛΑΣ                                            
ΒΑΙΛΕΖΟΥΔΗΣ                                       
ΒΑΙΛΟΣ                                            
ΒΑΙΜΑΚΗΣ                                          
ΒΑΙΜΠΗΣ                                           
ΒΑΙΝΑΚΗΣ                                          
ΒΑΙΝΑΛΗΣ                                          
ΒΑΙΝΑΝΙΔΗΣ                                        
ΒΑΙΝΑΣ                                            
ΒΑΙΝΔΕΡΛΗΣ                                        
ΒΑΙΝΔΗΡΛΗΣ                                        
ΒΑΙΝΔΙΡΛΗΣ                                        
ΒΑΙΝΙΚΟΣ                                          
ΒΑΙΝΟΒΙΤΣ                                         
ΒΑΙΝΟΠΟΥΛΟΣ                                       
ΒΑΙΝΤΕΡΛΗΣ                                        
ΒΑΙΝΤΙΡΛΗΣ                                        
ΒΑΙΟΠΟΥΛΟΣ                                        
ΒΑΙΟΣ                                             
ΒΑΙΟΥΛΗΣ                                          
ΒΑΙΡΑΚΛΙΩΤΗΣ                                      
ΒΑΙΡΑΚΤΑΡΑΚΗΣ                                     
ΒΑΙΡΑΚΤΑΡΗΣ                                       
ΒΑΙΡΑΚΤΑΡΙΔΗΣ                                     
ΒΑΙΡΑΜΑΚΗΣ                                        
ΒΑΙΡΑΜΗΣ                                          
ΒΑΙΡΑΜΙΔΗΣ                                        
ΒΑΙΡΑΜΙΤΣΛΗΣ                                      
ΒΑΙΡΑΣ                                            
ΒΑΙΡΗΣ                                            
ΒΑΙΡΙΝΟΣ                                          
ΒΑΙΡΛΗΣ                                           
ΒΑΙΣ                                              
ΒΑΙΣΙΔΗΣ                                          
ΒΑΙΣΜΕΝΟΣ                                         
ΒΑΙΣΣ                                             
ΒΑΙΤΕΡΛΗΣ                                         
ΒΑΙΤΗΣ                                            
ΒΑΙΤΟΥΔΗΣ                                         
ΒΑΙΤΣΑΚΗΣ                                         
ΒΑΙΤΣΑΡΑΣ                                         
ΒΑΙΤΣΑΣ                                           
ΒΑΙΤΣΗΣ                                           
ΒΑΙΤΣΙΔΗΣ                                         
ΒΑΙΤΣΟΠΟΥΛΟΣ                                      
ΒΑΙΤΣΟΣ                                           
ΒΑΙΤΣΟΥΔΗΣ                                        
ΒΑΚΑΔΑΡΗΣ                                         
ΒΑΚΑΔΗΜΑΣ                                         
ΒΑΚΑΔΗΜΟΠΟΥΛΟΣ                                    
ΒΑΚΑΚΗΣ                                           
ΒΑΚΑΛΑΚΗΣ                                         
ΒΑΚΑΛΑΚΟΣ                                         
ΒΑΚΑΛΑΣ                                           
ΒΑΚΑΛΒΑΣΗΣ                                        
ΒΑΚΑΛΓΙΑΝΝΗΣ                                      
ΒΑΚΑΛΕΛΗΣ                                         
ΒΑΚΑΛΕΛΛΗΣ                                        
ΒΑΚΑΛΕΡΗΣ                                         
ΒΑΚΑΛΗΣ                                           
ΒΑΚΑΛΙΑΡΕΛΗΣ                                      
ΒΑΚΑΛΙΔΗΣ                                         
ΒΑΚΑΛΙΚΟΣ                                         
ΒΑΚΑΛΙΟΣ                                          
ΒΑΚΑΛΟΠΟΥΛΟΣ                                      
ΒΑΚΑΛΟΣ                                           
ΒΑΚΑΛΟΥΔΗΣ                                        
ΒΑΚΑΛΟΥΛΗΣ                                        
ΒΑΚΑΛΟΥΜΗΣ                                        
ΒΑΚΑΛΟΥΝΑΚΗΣ                                      
ΒΑΚΑΛΦΩΤΗΣ                                        
ΒΑΚΑΜΗΣ                                           
ΒΑΚΑΝΗΣ                                           
ΒΑΚΑΝΤΗΣ                                          
ΒΑΚΑΡΕΛΗΣ                                         
ΒΑΚΑΡΗΣ                                           
ΒΑΚΑΡΟΠΟΥΛΟΣ                                      
ΒΑΚΑΡΟΣ                                           
ΒΑΚΑΡΤΖΗΣ                                         
ΒΑΚΑΡΤΣΗΣ                                         
ΒΑΚΑΣ                                             
ΒΑΚΑΣΗΣ                                           
ΒΑΚΑΣΙΡΑΣ                                         
ΒΑΚΑΣΙΡΗΣ                                         
ΒΑΚΑΣΟΥΛΗΣ                                        
ΒΑΚΑΤΑΡΗΣ                                         
ΒΑΚΑΤΑΣΗΣ                                         
ΒΑΚΑΤΑΤΣΗΣ                                        
ΒΑΚΑΤΙΝΑΚΗΣ                                       
ΒΑΚΑΤΣΑΣ                                          
ΒΑΚΕΝΤΗΣ                                          
ΒΑΚΕΡΛΗΣ                                          
ΒΑΚΕΡΟΥΔΗΣ                                        
ΒΑΚΕΡΣ                                            
ΒΑΚΕΡΤΖΗΣ                                         
ΒΑΚΕΤΑΤΖΗΣ                                        
ΒΑΚΕΤΟΠΟΥΛΟΣ                                      
ΒΑΚΗΡΛΗΣ                                          
ΒΑΚΗΡΤΖΗΣ                                         
ΒΑΚΗΣ                                             
ΒΑΚΙΑΝΗΣ                                          
ΒΑΚΙΑΡΗΣ                                          
ΒΑΚΙΑΡΟΣ                                          
ΒΑΚΙΑΣ                                            
ΒΑΚΙΔΗΣ                                           
ΒΑΚΙΝΤΗΣ                                          
ΒΑΚΙΠΟΥΛΟΣ                                        
ΒΑΚΙΡΗΣ                                           
ΒΑΚΙΡΛΗΣ                                          
ΒΑΚΙΡΤΖΗΣ                                         
ΒΑΚΙΡΤΖΙΔΕΛΗΣ                                     
ΒΑΚΙΡΤΖΙΔΕΛΛΗΣ                                    
ΒΑΚΙΡΤΖΙΔΗΣ                                       
ΒΑΚΙΤΣΙΔΗΣ                                        
ΒΑΚΚΑΣ                                            
ΒΑΚΚΟΣ                                            
ΒΑΚΛΑΒΑΣ                                          
ΒΑΚΛΑΙΔΗΣ                                         
ΒΑΚΛΑΡΗΣ                                          
ΒΑΚΛΑΣ                                            
ΒΑΚΛΑΤΖΗΣ                                         
ΒΑΚΛΑΪΔΗ                                          
ΒΑΚΛΑΪΔΗΣ                                         
ΒΑΚΟΓΙΑΝΝΗΣ                                       
ΒΑΚΟΛΑΣ                                           
ΒΑΚΟΛΕΤΟΣ                                         
ΒΑΚΟΛΙΔΗΣ                                         
ΒΑΚΟΝΔΙΟΣ                                         
ΒΑΚΟΝΤΙΟΣ                                         
ΒΑΚΟΠΟΥΛΟΣ                                        
ΒΑΚΟΣ                                             
ΒΑΚΟΤΟΥΖΗΣ                                        
ΒΑΚΟΥΔΗΣ                                          
ΒΑΚΟΥΛΑΣ                                          
ΒΑΚΟΥΛΗΣ                                          
ΒΑΚΟΥΛΙΔΗΣ                                        
ΒΑΚΟΥΝΤΟΥΖΗΣ                                      
ΒΑΚΟΥΡΑΣ                                          
ΒΑΚΟΥΡΟΣ                                          
ΒΑΚΟΥΣΙΔΗΣ                                        
ΒΑΚΟΥΤΗΣ                                          
ΒΑΚΟΥΦΑΡΗΣ                                        
ΒΑΚΟΥΦΗΣ                                          
ΒΑΚΟΥΦΤΣΗΣ                                        
ΒΑΚΟΦΤΣΗΣ                                         
ΒΑΚΡΑΚΗΣ                                          
ΒΑΚΡΑΚΟΣ                                          
ΒΑΚΡΑΣ                                            
ΒΑΚΡΑΤΣΑΣ                                         
ΒΑΚΡΑΤΣΗΣ                                         
ΒΑΚΡΙΝΑΚΗΣ                                        
ΒΑΚΡΙΝΑΣ                                          
ΒΑΚΡΙΝΟΣ                                          
ΒΑΚΡΟΠΟΥΛΟΣ                                       
ΒΑΚΡΟΣ                                            
ΒΑΚΥΡΗΣ                                           
ΒΑΚΥΡΤΣΗΣ                                         
ΒΑΚΦΑΡΗΣ                                          
ΒΑΚΩΝΑΚΗΣ                                         
ΒΑΛΑΒΑΝΑΚΗΣ                                       
ΒΑΛΑΒΑΝΗΣ                                         
ΒΑΛΑΒΑΝΙΔΗΣ                                       
ΒΑΛΑΒΑΝΙΩΤΗΣ                                      
ΒΑΛΑΒΑΝΟΠΟΥΛΟΣ                                    
ΒΑΛΑΒΑΝΟΣ                                         
ΒΑΛΑΒΕΡΗΣ                                         
ΒΑΛΑΒΟΣΙΚΗΣ                                       
ΒΑΛΑΓΙΑΝΝΗΣ                                       
ΒΑΛΑΓΙΑΝΝΟΠΟΥΛΟΣ                                  
ΒΑΛΑΓΙΑΝΟΠΟΥΛΟΣ                                   
ΒΑΛΑΓΚΙΤΣΗΣ                                       
ΒΑΛΑΓΚΟΥΤΗΣ                                       
ΒΑΛΑΔΑΚΗΣ                                         
ΒΑΛΑΔΗΜΑΣ                                         
ΒΑΛΑΔΟΥΚΑΣ                                        
ΒΑΛΑΖΙΩΤΗΣ                                        
ΒΑΛΑΗΣ                                            
ΒΑΛΑΚΑΣ                                           
ΒΑΛΑΚΕΛΗΣ                                         
ΒΑΛΑΚΗΣ                                           
ΒΑΛΑΚΙΔΗΣ                                         
ΒΑΛΑΚΙΤΣΗΣ                                        
ΒΑΛΑΚΟΠΟΥΛΟΣ                                      
ΒΑΛΑΚΟΣ                                           
ΒΑΛΑΚΟΥΔΟΥΝΑΣ                                     
ΒΑΛΑΚΤΣΗΣ                                         
ΒΑΛΑΚΩΣΤΑΣ                                        
ΒΑΛΑΛΑΚΗΣ                                         
ΒΑΛΑΛΑΣ                                           
ΒΑΛΑΛΗΣ                                           
ΒΑΛΑΛΙΑΣ                                          
ΒΑΛΑΜΑΤΣΑΣ                                        
ΒΑΛΑΜΑΤΣΗΣ                                        
ΒΑΛΑΜΒΑΝΗΣ                                        
ΒΑΛΑΜΒΑΝΟΣ                                        
ΒΑΛΑΜΒΟΣ                                          
ΒΑΛΑΜΙΟΣ                                          
ΒΑΛΑΜΝΙΟΣ                                         
ΒΑΛΑΜΟΝΤΕΣ                                        
ΒΑΛΑΜΟΝΤΗΣ                                        
ΒΑΛΑΜΟΥΤΗΣ                                        
ΒΑΛΑΜΟΥΤΟΠΟΥΛΟΣ                                   
ΒΑΛΑΜΟΥΤΣΟΥΝΟΣ                                    
ΒΑΛΑΜΠΟΥΣ                                         
ΒΑΛΑΜΩΝΤΗΣ                                        
ΒΑΛΑΜΩΤΗΣ                                         
ΒΑΛΑΝΑΣ                                           
ΒΑΛΑΝΔΡΕΑΣ                                        
ΒΑΛΑΝΗΣ                                           
ΒΑΛΑΝΙΔΑΣ                                         
ΒΑΛΑΝΙΔΗΣ                                         
ΒΑΛΑΝΙΚΑΣ                                         
ΒΑΛΑΝΟΣ                                           
ΒΑΛΑΝΤΑΣΗΣ                                        
ΒΑΛΑΝΤΗΣ                                          
ΒΑΛΑΞΗΣ                                           
ΒΑΛΑΟΥΡΑΣ                                         
ΒΑΛΑΟΥΡΗΣ                                         
ΒΑΛΑΡΑΚΗΣ                                         
ΒΑΛΑΡΑΚΟΣ                                         
ΒΑΛΑΡΕΛΛΗΣ                                        
ΒΑΛΑΡΗΣ                                           
ΒΑΛΑΡΙΣΤΟΣ                                        
ΒΑΛΑΡΟΣ                                           
ΒΑΛΑΡΟΥΤΣΟΣ                                       
ΒΑΛΑΣ                                             
ΒΑΛΑΣΑΚΗΣ                                         
ΒΑΛΑΣΑΚΟΣ                                         
ΒΑΛΑΣΑΣ                                           
ΒΑΛΑΣΕΛΗΣ                                         
ΒΑΛΑΣΕΛΛΗΣ                                        
ΒΑΛΑΣΗΣ                                           
ΒΑΛΑΣΙΑΔΗΣ                                        
ΒΑΛΑΣΙΔΗΣ                                         
ΒΑΛΑΣΙΩΤΗΣ                                        
ΒΑΛΑΣΚΑΚΗΣ                                        
ΒΑΛΑΣΚΑΣ                                          
ΒΑΛΑΣΚΑΤΖΗΣ                                       
ΒΑΛΑΣΚΟΠΟΥΛΟΣ                                     
ΒΑΛΑΣΟΠΟΥΛΟΣ                                      
ΒΑΛΑΣΟΥΔΗΣ                                        
ΒΑΛΑΣΟΥΛΗΣ                                        
ΒΑΛΑΣΣΑΚΗΣ                                        
ΒΑΛΑΣΣΑΣ                                          
ΒΑΛΑΣΣΗΣ                                          
ΒΑΛΑΣΣΟΠΟΥΛΟΣ                                     
ΒΑΛΑΣΣΟΣ                                          
ΒΑΛΑΣΩΤΗΡΗΣ                                       
ΒΑΛΑΤΑΣ                                           
ΒΑΛΑΤΙΑΔΗΣ                                        
ΒΑΛΑΤΙΔΗΣ                                         
ΒΑΛΑΤΟΣ                                           
ΒΑΛΑΤΣΑΣ                                          
ΒΑΛΑΤΣΟΣ                                          
ΒΑΛΑΤΣΟΥΚΗΣ                                       
ΒΑΛΑΦΑΣ                                           
ΒΑΛΑΧΑΣ                                           
ΒΑΛΑΧΕΑΣ                                          
ΒΑΛΑΧΗΣ                                           
ΒΑΛΑΩΡΑΣ                                          
ΒΑΛΑΩΡΙΤΗΣ                                        
ΒΑΛΒΑΖΑΝΗΣ                                        
ΒΑΛΒΑΝΗΣ                                          
ΒΑΛΒΗΣ                                            
ΒΑΛΔΕΡΑΝΗΣ                                        
ΒΑΛΔΕΡΑΝΟΣ                                        
ΒΑΛΔΕΣ                                            
ΒΑΛΔΗΡΑΣ                                          
ΒΑΛΔΙΡΗΣ                                          
ΒΑΛΔΙΡΚΑΣ                                         
ΒΑΛΔΟΥΜΑΣ                                         
ΒΑΛΔΟΥΡΑΝΗΣ                                       
ΒΑΛΔΡΑΜΙΔΗΣ                                       
ΒΑΛΕΚΑΡΔΑΣ                                        
ΒΑΛΕΛΗΣ                                           
ΒΑΛΕΛΛΗΣ                                          
ΒΑΛΕΝΤΑΚΗΣ                                        
ΒΑΛΕΝΤΑΣ                                          
ΒΑΛΕΝΤΖΗΣ                                         
ΒΑΛΕΝΤΗΣ                                          
ΒΑΛΕΝΤΙΝΟΒΙΤΣ                                     
ΒΑΛΕΝΤΙΝΟΣ                                        
ΒΑΛΕΟΝΤΗΣ                                         
ΒΑΛΕΟΥΓΑΣ                                         
ΒΑΛΕΡΑΣ                                           
ΒΑΛΕΡΓΑΚΗΣ                                        
ΒΑΛΕΡΓΑΣ                                          
ΒΑΛΕΡΗΣ                                           
ΒΑΛΕΡΙΑΝΟΣ                                        
ΒΑΛΕΡΙΟΣ                                          
ΒΑΛΕΣ                                             
ΒΑΛΕΣΗΣ                                           
ΒΑΛΕΤΑΣ                                           
ΒΑΛΕΤΕΛΗΣ                                         
ΒΑΛΕΤΕΛΛΗΣ                                        
ΒΑΛΕΤΟΠΟΥΛΟΣ                                      
ΒΑΛΕΤΤΑΣ                                          
ΒΑΛΕΧΑΣ                                           
ΒΑΛΗΚΕΣΕΡΛΗΣ                                      
ΒΑΛΗΛΑΣ                                           
ΒΑΛΗΛΗΣ                                           
ΒΑΛΗΜΙΤΗΣ                                         
ΒΑΛΗΝΑΚΗΣ                                         
ΒΑΛΗΝΔΡΑΣ                                         
ΒΑΛΗΡΑΚΗΣ                                         
ΒΑΛΗΣ                                             
ΒΑΛΙΑΓΑΣ                                          
ΒΑΛΙΑΔΗΣ                                          
ΒΑΛΙΑΖΗΣ                                          
ΒΑΛΙΑΚΑΣ                                          
ΒΑΛΙΑΚΟΣ                                          
ΒΑΛΙΑΝΑΤΟΣ                                        
ΒΑΛΙΑΝΗΣ                                          
ΒΑΛΙΑΝΟΣ                                          
ΒΑΛΙΑΝΤΖΑΣ                                        
ΒΑΛΙΑΣΗΣ                                          
ΒΑΛΙΑΤΖΑΣ                                         
ΒΑΛΙΔΑΚΗΣ                                         
ΒΑΛΙΔΑΣ                                           
ΒΑΛΙΔΗΣ                                           
ΒΑΛΙΕΡΟΣ                                          
ΒΑΛΙΚΑΚΗΣ                                         
ΒΑΛΙΚΑΚΙΣ                                         
ΒΑΛΙΚΙΔΗΣ                                         
ΒΑΛΙΚΤΣΗΣ                                         
ΒΑΛΙΛΑΣ                                           
ΒΑΛΙΛΗΣ                                           
ΒΑΛΙΜΗΤΗΣ                                         
ΒΑΛΙΜΙΤΗΣ                                         
ΒΑΛΙΜΥΤΗΣ                                         
ΒΑΛΙΝΑΚΗΣ                                         
ΒΑΛΙΝΔΟΜΑΚΗΣ                                      
ΒΑΛΙΝΔΡΑΣ                                         
ΒΑΛΙΝΗΣ                                           
ΒΑΛΙΝΟΣ                                           
ΒΑΛΙΟΝΤΗΣ                                         
ΒΑΛΙΟΣ                                            
ΒΑΛΙΟΥΓΑΣ                                         
ΒΑΛΙΟΥΔΗΣ                                         
ΒΑΛΙΟΥΛΗΣ                                         
ΒΑΛΙΟΥΤΗΣ                                         
ΒΑΛΙΡΑΚΗΣ                                         
ΒΑΛΙΡΗΣ                                           
ΒΑΛΙΩΖΗΣ                                          
ΒΑΛΙΩΚΗΣ                                          
ΒΑΛΙΩΤΗΣ                                          
ΒΑΛΚΑΜΕΛΗΣ                                        
ΒΑΛΚΑΜΛΗΣ                                         
ΒΑΛΚΑΝΑΣ                                          
ΒΑΛΚΑΝΗΣ                                          
ΒΑΛΚΑΝΙΔΗΣ                                        
ΒΑΛΚΑΝΙΩΤΗΣ                                       
ΒΑΛΚΑΝΟΣ                                          
ΒΑΛΚΙΜΑΔΗΣ                                        
ΒΑΛΚΟΣ                                            
ΒΑΛΚΟΥΜΑΣ                                         
ΒΑΛΛΑΓΙΑΝΝΗΣ                                      
ΒΑΛΛΑΡΗΣ                                          
ΒΑΛΛΑΣ                                            
ΒΑΛΛΑΤΟΣ                                          
ΒΑΛΛΑΧΗΣ                                          
ΒΑΛΛΕΛΗΣ                                          
ΒΑΛΛΕΡΑΣ                                          
ΒΑΛΛΗΝΔΑΣ                                         
ΒΑΛΛΗΝΔΡΑΣ                                        
ΒΑΛΛΗΣ                                            
ΒΑΛΛΙΑΝΑΤΟΣ                                       
ΒΑΛΛΙΑΝΟΣ                                         
ΒΑΛΛΙΔΗΣ                                          
ΒΑΛΛΙΕΡΟΣ                                         
ΒΑΛΛΙΛΑΣ                                          
ΒΑΛΛΙΝΑΣ                                          
ΒΑΛΛΙΝΗΣ                                          
ΒΑΛΛΙΟΣ                                           
ΒΑΛΛΙΤΣ                                           
ΒΑΛΛΟΓΙΑΝΝΗΣ                                      
ΒΑΛΛΟΝΑΣΗΣ                                        
ΒΑΛΛΟΥΣ                                           
ΒΑΛΜΑΝΤΩΝΗΣ                                       
ΒΑΛΜΑΣ                                            
ΒΑΛΜΗΣ                                            
ΒΑΛΝΑΡΗΣ                                          
ΒΑΛΝΕΑΣ                                           
ΒΑΛΝΤΕΣ                                           
ΒΑΛΟΓΙΑΝΝΗΣ                                       
ΒΑΛΟΓΙΩΡΓΗΣ                                       
ΒΑΛΟΔΗΜΟΣ                                         
ΒΑΛΟΖΟΣ                                           
ΒΑΛΟΚΗΣ                                           
ΒΑΛΟΜΑΝΔΡΑΣ                                       
ΒΑΛΟΝΑΣΗΣ                                         
ΒΑΛΟΠΕΤΡΟΠΟΥΛΟΣ                                   
ΒΑΛΟΠΗΤΑΣ                                         
ΒΑΛΟΣΗΣ                                           
ΒΑΛΟΣΤΕΡΓΙΟΣ                                      
ΒΑΛΟΤΑΣΙΟΣ                                        
ΒΑΛΟΥΓΕΩΡΓΗΣ                                      
ΒΑΛΟΥΔΗΣ                                          
ΒΑΛΟΥΚΑΣ                                          
ΒΑΛΟΥΚΟΣ                                          
ΒΑΛΟΥΚΤΣΗΣ                                        
ΒΑΛΟΥΚΤΣΙΔΗΣ                                      
ΒΑΛΟΥΜΑΣ                                          
ΒΑΛΟΥΝΤΟΣ                                         
ΒΑΛΟΥΞΗΣ                                          
ΒΑΛΟΥΞΙΔΗΣ                                        
ΒΑΛΟΥΡΔΟΣ                                         
ΒΑΛΟΥΣ                                            
ΒΑΛΟΥΣΗΣ                                          
ΒΑΛΣΑΚΗΣ                                          
ΒΑΛΣΑΜΑΚΗΣ                                        
ΒΑΛΣΑΜΑΡΑΣ                                        
ΒΑΛΣΑΜΑΣ                                          
ΒΑΛΣΑΜΗΣ                                          
ΒΑΛΣΑΜΙΔΗΣ                                        
ΒΑΛΣΑΜΟΠΟΥΛΟΣ                                     
ΒΑΛΣΑΜΟΣ                                          
ΒΑΛΣΑΜΟΥΛΗΣ                                       
ΒΑΛΣΑΡΑΣ                                          
ΒΑΛΣΑΡΗΣ                                          
ΒΑΛΣΑΡΙΑΔΗΣ                                       
ΒΑΛΣΟΜΑΤΖΗΣ                                       
ΒΑΛΤΑΔΩΡΟΣ                                        
ΒΑΛΤΑΖΑΝΟΣ                                        
ΒΑΛΤΑΚΗΣ                                          
ΒΑΛΤΑΛΗΣ                                          
ΒΑΛΤΑΡΑΣ                                          
ΒΑΛΤΑΣ                                            
ΒΑΛΤΑΣΑΡΗΣ                                        
ΒΑΛΤΑΣΑΡΟΣ                                        
ΒΑΛΤΑΤΖΗΣ                                         
ΒΑΛΤΕΡΣ                                           
ΒΑΛΤΕΣΗΝΙΩΤΗΣ                                     
ΒΑΛΤΕΣΙΝΙΩΤΗΣ                                     
ΒΑΛΤΕΤΣΙΩΤΗΣ                                      
ΒΑΛΤΖΑΚΗΣ                                         
ΒΑΛΤΖΗΣ                                           
ΒΑΛΤΖΙΔΗΣ                                         
ΒΑΛΤΗΣ                                            
ΒΑΛΤΙΚΟΣ                                          
ΒΑΛΤΙΝΟΣ                                          
ΒΑΛΤΙΣΤΑΣ                                         
ΒΑΛΤΟΓΙΑΝΝΗΣ                                      
ΒΑΛΤΟΠΟΥΛΟΣ                                       
ΒΑΛΤΟΣ                                            
ΒΑΛΤΟΥΔΗΣ                                         
ΒΑΛΤΟΥΜΗΣ                                         
ΒΑΛΤΣ                                             
ΒΑΛΤΣΑΝΗΣ                                         
ΒΑΛΤΣΗΣ                                           
ΒΑΛΤΣΙΑΝΗΣ                                        
ΒΑΛΤΣΙΔΗΣ                                         
ΒΑΛΤΣΙΟΓΗΣ                                        
ΒΑΛΤΣΙΟΣ                                          
ΒΑΛΤΣΙΩΚΑΣ                                        
ΒΑΛΤΣΙΩΤΗΣ                                        
ΒΑΛΤΣΟΓΗΣ                                         
ΒΑΛΥΡΑΚΗΣ                                         
ΒΑΛΥΡΑΣ                                           
ΒΑΛΧΟΣ                                            
ΒΑΛΩΖΟΣ                                           
ΒΑΛΩΜΕΝΟΣ                                         
ΒΑΛΩΣΗΣ                                           
ΒΑΛΩΤΗΣ                                           
ΒΑΜΒΑΔΕΛΗΣ                                        
ΒΑΜΒΑΔΛΙΩΤΗΣ                                      
ΒΑΜΒΑΚΑΚΗΣ                                        
ΒΑΜΒΑΚΑΡΗΣ                                        
ΒΑΜΒΑΚΑΡΟΣ                                        
ΒΑΜΒΑΚΑΣ                                          
ΒΑΜΒΑΚΕΛΛΗΣ                                       
ΒΑΜΒΑΚΕΡΗΣ                                        
ΒΑΜΒΑΚΕΡΟΣ                                        
ΒΑΜΒΑΚΗΣ                                          
ΒΑΜΒΑΚΙΑΝΟΣ                                       
ΒΑΜΒΑΚΙΑΣ                                         
ΒΑΜΒΑΚΙΔΗΣ                                        
ΒΑΜΒΑΚΙΝΟΣ                                        
ΒΑΜΒΑΚΙΤΗΣ                                        
ΒΑΜΒΑΚΟΠΟΥΛΟΣ                                     
ΒΑΜΒΑΚΟΣ                                          
ΒΑΜΒΑΚΟΥΔΗΣ                                       
ΒΑΜΒΑΚΟΥΛΑΣ                                       
ΒΑΜΒΑΚΟΥΛΗΣ                                       
ΒΑΜΒΑΚΟΥΛΙΑΣ                                      
ΒΑΜΒΑΚΟΥΡΑΣ                                       
ΒΑΜΒΑΚΟΥΡΗΣ                                       
ΒΑΜΒΑΚΟΥΣΑΣ                                       
ΒΑΜΒΑΚΟΥΣΗΣ                                       
ΒΑΜΒΑΛΕΛΗΣ                                        
ΒΑΜΒΑΛΕΛΛΗΣ                                       
ΒΑΜΒΑΛΕΡΟΣ                                        
ΒΑΜΒΑΛΗΣ                                          
ΒΑΜΒΑΡΑΠΗΣ                                        
ΒΑΜΒΑΡΕΚΟΣ                                        
ΒΑΜΒΑΣ                                            
ΒΑΜΒΑΣΑΚΗΣ                                        
ΒΑΜΒΑΤΖΑΝΗΣ                                       
ΒΑΜΒΑΤΖΟΥΛΗΣ                                      
ΒΑΜΒΑΤΗΡΑΣ                                        
ΒΑΜΒΑΤΣΙΚΟΣ                                       
ΒΑΜΒΑΤΣΟΥΛΗΣ                                      
ΒΑΜΒΕΣΟΣ                                          
ΒΑΜΒΙΛΗΣ                                          
ΒΑΜΒΙΝΗΣ                                          
ΒΑΜΒΛΑΣ                                           
ΒΑΜΒΟΛΗΣ                                          
ΒΑΜΒΟΥΔΑΚΗΣ                                       
ΒΑΜΒΟΥΚΑΚΗΣ                                       
ΒΑΜΒΟΥΚΑΣ                                         
ΒΑΜΒΟΥΚΗΣ                                         
ΒΑΜΒΟΥΚΛΗΣ                                        
ΒΑΜΒΟΥΚΟΣ                                         
ΒΑΜΒΟΥΛΗΣ                                         
ΒΑΜΒΟΥΛΙΔΗΣ                                       
ΒΑΜΒΟΥΝΑΚΗΣ                                       
ΒΑΜΒΟΥΝΗΣ                                         
ΒΑΜΒΟΥΡΑΣ                                         
ΒΑΜΒΟΥΡΕΛΗΣ                                       
ΒΑΜΒΟΥΡΕΛΛΗΣ                                      
ΒΑΜΒΟΥΡΗΣ                                         
ΒΑΜΕΝΟΣ                                           
ΒΑΜΙΑΔΑΚΗΣ                                        
ΒΑΜΙΑΛΗΣ                                          
ΒΑΜΙΑΝΑΚΗΣ                                        
ΒΑΜΙΕΔΑΚΗΣ                                        
ΒΑΜΜΕΝΟΣ                                          
ΒΑΜΠΑΡΗΣ                                          
ΒΑΜΠΑΣ                                            
ΒΑΜΠΕΡΤΖΗΣ                                        
ΒΑΜΠΙΡΗΣ                                          
ΒΑΜΠΟΒΑΤΣ                                         
ΒΑΜΠΟΡΑΚΗΣ                                        
ΒΑΜΠΟΡΙΔΗΣ                                        
ΒΑΜΠΟΣ                                            
ΒΑΜΠΟΥΛΑΣ                                         
ΒΑΜΠΟΥΛΗΣ                                         
ΒΑΝ ΓΚΕΛΝΤΕΡ                                      
ΒΑΝ ΓΚΙΛΝΤΕΡ                                      
ΒΑΝ ΓΟΥΤΕΝΜΠΕΡΓΚ                                  
ΒΑΝ ΕΓΚΕ                                          
ΒΑΝ ΕΣΣΕΝ                                         
ΒΑΝ ΚΕΤΣ                                          
ΒΑΝ ΛΙΝΤΟΥΤ                                       
ΒΑΝ ΜΠΟΓΚΑΡΤ                                      
ΒΑΝ ΝΤΕ ΓΚΟΡ                                      
ΒΑΝ ΝΤΕ ΧΟΥΦ                                      
ΒΑΝ ΝΤΕΡ ΣΤΕΙΝΧΟΒΕΝ                               
ΒΑΝ ΝΤΙΛΕΝ                                        
ΒΑΝ ΝΤΡΕΝΤ                                        
ΒΑΝ ΟΛΣΤ                                          
ΒΑΝ ΟΥΙΝΓΚΕ                                       
ΒΑΝ ΡΙΕΤ                                          
ΒΑΝ ΡΟΣΣΟΥΜ                                       
ΒΑΝΑΒΑΚΗΣ                                         
ΒΑΝΑΚΑΚΗΣ                                         
ΒΑΝΑΚΑΡΑΣ                                         
ΒΑΝΑΚΑΡΗΣ                                         
ΒΑΝΑΚΑΣ                                           
ΒΑΝΑΚΗΣ                                           
ΒΑΝΑΚΛΙΩΤΗΣ                                       
ΒΑΝΑΚΟΣ                                           
ΒΑΝΑΡΓΙΩΤΗΣ                                       
ΒΑΝΑΡΟΥΔΗΣ                                        
ΒΑΝΑΣ                                             
ΒΑΝΑΣΑΣ                                           
ΒΑΝΑΣΙΚΑΣ                                         
ΒΑΝΔΑΡΑΚΗΣ                                        
ΒΑΝΔΕΛΑΣ                                          
ΒΑΝΔΕΡΑΣ                                          
ΒΑΝΔΗΡΑΣ                                          
ΒΑΝΔΗΣ                                            
ΒΑΝΔΙΚΑΣ                                          
ΒΑΝΔΟΛΑΣ                                          
ΒΑΝΔΟΡΑΣ                                          
ΒΑΝΔΟΥΛΑΚΗΣ                                       
ΒΑΝΔΟΥΛΑΣ                                         
ΒΑΝΔΡΗΣ                                           
ΒΑΝΔΩΛΑΣ                                          
ΒΑΝΔΩΡΟΣ                                          
ΒΑΝΕΖΗΣ                                           
ΒΑΝΕΖΙΑΔΗΣ                                        
ΒΑΝΕΖΟΣ                                           
ΒΑΝΗΣ                                             
ΒΑΝΙΑΣ                                            
ΒΑΝΙΔΗΣ                                           
ΒΑΝΙΚΑΚΗΣ                                         
ΒΑΝΙΚΙΩΤΗΣ                                        
ΒΑΝΙΛΑΣ                                           
ΒΑΝΙΟΣΙΔΗΣ                                        
ΒΑΝΙΤΣΑΡΗΣ                                        
ΒΑΝΙΤΣΙΔΗΣ                                        
ΒΑΝΙΩΤΗΣ                                          
ΒΑΝΝΑΣ                                            
ΒΑΝΝΗΣ                                            
ΒΑΝΟΠΟΥΛΟΣ                                        
ΒΑΝΟΣ                                             
ΒΑΝΟΥΣΗΣ                                          
ΒΑΝΟΥΤΣΗΣ                                         
ΒΑΝΤΑΛΗΣ                                          
ΒΑΝΤΑΝΑΣ                                          
ΒΑΝΤΑΡΑΚΗΣ                                        
ΒΑΝΤΑΡΗΣ                                          
ΒΑΝΤΑΣ                                            
ΒΑΝΤΕΛΑΣ                                          
ΒΑΝΤΖΙΟΣ                                          
ΒΑΝΤΖΟΣ                                           
ΒΑΝΤΗΣ                                            
ΒΑΝΤΟΛΑΣ                                          
ΒΑΝΤΟΥΛΗΣ                                         
ΒΑΝΤΣΗΣ                                           
ΒΑΝΤΣΙΑΣ                                          
ΒΑΝΤΣΙΔΗΣ                                         
ΒΑΝΤΣΙΟΣ                                          
ΒΑΝΤΣΙΟΥΛΗΣ                                       
ΒΑΝΤΣΙΟΥΡΗΣ                                       
ΒΑΝΤΣΙΩΤΗΣ                                        
ΒΑΝΤΣΟΣ                                           
ΒΑΝΤΣΟΥΚΗΣ                                        
ΒΑΝΤΣΟΥΡΗΣ                                        
ΒΑΝΤΩΛΑΣ                                          
ΒΑΝΩΚΑΣ                                           
ΒΑΞΑΒΑΝΕΛΗΣ                                       
ΒΑΞΑΒΑΝΕΛΛΗΣ                                      
ΒΑΞΑΒΑΝΗΣ                                         
ΒΑΞΑΛΗΣ                                           
ΒΑΞΕΒΑΝΑΚΗΣ                                       
ΒΑΞΕΒΑΝΕΛΛΗΣ                                      
ΒΑΞΕΒΑΝΕΡΗΣ                                       
ΒΑΞΕΒΑΝΗΣ                                         
ΒΑΞΕΒΑΝΙΔΗΣ                                       
ΒΑΞΕΒΑΝΟΠΟΥΛΟΣ                                    
ΒΑΞΕΒΑΝΟΣ                                         
ΒΑΞΙΟΒΑΝΟΣ                                        
ΒΑΞΟΒΑΝΟΣ                                         
ΒΑΟΝΑΚΗΣ                                          
ΒΑΟΣ                                              
ΒΑΟΥΛΑΣ                                           
ΒΑΟΥΤΗΣ                                           
ΒΑΟΥΤΣΗΣ                                          
ΒΑΠΕΛΑΣ                                           
ΒΑΠΟΡΑΚΗΣ                                         
ΒΑΠΟΡΗΣ                                           
ΒΑΠΟΡΙΔΗΣ                                         
ΒΑΠΟΡΤΖΗΣ                                         
ΒΑΠΟΥΡΤΖΗΣ                                        
ΒΑΠΠΑΣ                                            
ΒΑΠΤΙΣΜΑΣ                                         
ΒΑΡΑΒΑΡΗΣ                                         
ΒΑΡΑΒΒΑΣ                                          
ΒΑΡΑΒΕΡΗΣ                                         
ΒΑΡΑΒΙΩΤΗΣ                                        
ΒΑΡΑΓΓΑΣ                                          
ΒΑΡΑΓΓΗΣ                                          
ΒΑΡΑΓΓΟΥΛΗΣ                                       
ΒΑΡΑΓΙΑΝΝΗΣ                                       
ΒΑΡΑΓΚΑΣ                                          
ΒΑΡΑΓΚΗΣ                                          
ΒΑΡΑΓΚΟΥΛΗΣ                                       
ΒΑΡΑΔΑΣ                                           
ΒΑΡΑΔΙΝΗΣ                                         
ΒΑΡΑΚΑΣ                                           
ΒΑΡΑΚΗΣ                                           
ΒΑΡΑΚΛΑΣ                                          
ΒΑΡΑΚΛΗΣ                                          
ΒΑΡΑΚΛΙΩΤΗΣ                                       
ΒΑΡΑΛΕΞΗΣ                                         
ΒΑΡΑΛΗΣ                                           
ΒΑΡΑΜΕΝΤΕΣ                                        
ΒΑΡΑΜΕΝΤΗΣ                                        
ΒΑΡΑΜΙΛΗΣ                                         
ΒΑΡΑΜΟΓΙΑΝΝΗΣ                                     
ΒΑΡΑΜΠΟΥΤΗΣ                                       
ΒΑΡΑΝΑΚΗΣ                                         
ΒΑΡΑΝΙΚΑΣ                                         
ΒΑΡΑΝΟΣ                                           
ΒΑΡΑΣ                                             
ΒΑΡΑΣΑΣ                                           
ΒΑΡΑΣΗΣ                                           
ΒΑΡΑΣΙΑΣ                                          
ΒΑΡΑΣΣΑΣ                                          
ΒΑΡΑΤΑΣΗΣ                                         
ΒΑΡΑΤΖ                                            
ΒΑΡΑΤΗΣ                                           
ΒΑΡΑΤΣΟΣ                                          
ΒΑΡΑΧΙΔΗΣ                                         
ΒΑΡΒΑΓΙΑΝΝΗΣ                                      
ΒΑΡΒΑΓΚΑΝΗΣ                                       
ΒΑΡΒΑΓΚΑΣ                                         
ΒΑΡΒΑΔΟΥΚΑΣ                                       
ΒΑΡΒΑΖΑΣ                                          
ΒΑΡΒΑΚΗΣ                                          
ΒΑΡΒΑΚΙΔΗΣ                                        
ΒΑΡΒΑΛΑΣ                                          
ΒΑΡΒΑΛΙΟΣ                                         
ΒΑΡΒΑΛΟΥΚΑΣ                                       
ΒΑΡΒΑΝΗΣ                                          
ΒΑΡΒΑΝΤΑΚΗΣ                                       
ΒΑΡΒΑΡΑΚΗΣ                                        
ΒΑΡΒΑΡΑΣ                                          
ΒΑΡΒΑΡΕΖΗΣ                                        
ΒΑΡΒΑΡΕΖΟΣ                                        
ΒΑΡΒΑΡΕΚΟΣ                                        
ΒΑΡΒΑΡΕΛΗΣ                                        
ΒΑΡΒΑΡΕΣΟΣ                                        
ΒΑΡΒΑΡΕΣΣΟΣ                                       
ΒΑΡΒΑΡΗΓΟΣ                                        
ΒΑΡΒΑΡΗΣ                                          
ΒΑΡΒΑΡΙΓΓΟΣ                                       
ΒΑΡΒΑΡΙΓΟΣ                                        
ΒΑΡΒΑΡΙΔΗΣ                                        
ΒΑΡΒΑΡΙΚΗΣ                                        
ΒΑΡΒΑΡΙΝΟΣ                                        
ΒΑΡΒΑΡΙΤΗΣ                                        
ΒΑΡΒΑΡΙΩΤΗΣ                                       
ΒΑΡΒΑΡΟΠΟΥΛΟΣ                                     
ΒΑΡΒΑΡΟΣ                                          
ΒΑΡΒΑΡΟΥΛΑΣ                                       
ΒΑΡΒΑΡΟΥΣΗΣ                                       
ΒΑΡΒΑΡΡΗΓΟΣ                                       
ΒΑΡΒΑΣΑΙΝΙΤΗΣ                                     
ΒΑΡΒΑΣΟΥΔΗΣ                                       
ΒΑΡΒΑΤΑΚΗΣ                                        
ΒΑΡΒΑΤΑΚΟΣ                                        
ΒΑΡΒΑΤΑΣ                                          
ΒΑΡΒΑΤΕΣ                                          
ΒΑΡΒΑΤΖΙΚΗΣ                                       
ΒΑΡΒΑΤΗΣ                                          
ΒΑΡΒΑΤΟΣ                                          
ΒΑΡΒΑΤΣΕΛΗΣ                                       
ΒΑΡΒΑΤΣΗΣ                                         
ΒΑΡΒΑΤΣΟΣ                                         
ΒΑΡΒΑΤΣΟΥΛΑΚΗΣ                                    
ΒΑΡΒΑΤΣΟΥΛΗΣ                                      
ΒΑΡΒΑΤΣΟΥΛΙΑΣ                                     
ΒΑΡΒΕΚΗΣ                                          
ΒΑΡΒΕΛΗΣ                                          
ΒΑΡΒΕΡΑΚΗΣ                                        
ΒΑΡΒΕΡΗΣ                                          
ΒΑΡΒΕΡΙΔΗΣ                                        
ΒΑΡΒΕΡΟΠΟΥΛΟΣ                                     
ΒΑΡΒΕΣΙΩΤΗΣ                                       
ΒΑΡΒΕΤΑΚΗΣ                                        
ΒΑΡΒΗΣ                                            
ΒΑΡΒΙΑΝΗΣ                                         
ΒΑΡΒΙΑΣ                                           
ΒΑΡΒΙΔΗΣ                                          
ΒΑΡΒΙΣΙΩΤΗΣ                                       
ΒΑΡΒΙΤΣΙΩΤΗΣ                                      
ΒΑΡΒΟΓΛΗΣ                                         
ΒΑΡΒΟΥΖΑΝΗΣ                                       
ΒΑΡΒΟΥΖΟΣ                                         
ΒΑΡΒΟΥΛΕΤΟΣ                                       
ΒΑΡΒΟΥΝΗΣ                                         
ΒΑΡΒΟΥΝΙΩΤΗΣ                                      
ΒΑΡΒΟΥΡΗΣ                                         
ΒΑΡΒΟΥΤΑΣ                                         
ΒΑΡΒΟΥΤΗΣ                                         
ΒΑΡΒΟΥΤΣΗΣ                                        
ΒΑΡΓΑΛΗΣ                                          
ΒΑΡΓΑΣ                                            
ΒΑΡΓΕΜΕΖΗΣ                                        
ΒΑΡΓΕΜΕΤΖΙΔΗΣ                                     
ΒΑΡΓΕΜΙΔΗΣ                                        
ΒΑΡΓΕΜΙΤΖΙΔΗΣ                                     
ΒΑΡΓΕΜΤΖΙΔΗΣ                                      
ΒΑΡΓΙΑΚΑΚΗΣ                                       
ΒΑΡΓΙΑΜΕΖΗΣ                                       
ΒΑΡΓΙΑΜΗΣ                                         
ΒΑΡΓΙΑΜΙΔΗΣ                                       
ΒΑΡΓΙΑΝΙΤΗΣ                                       
ΒΑΡΓΙΑΣ                                           
ΒΑΡΓΙΕΜΕΖΗΣ                                       
ΒΑΡΓΚΑΣ                                           
ΒΑΡΔΑΒΑΚΗΣ                                        
ΒΑΡΔΑΒΑΣ                                          
ΒΑΡΔΑΒΙΛΙΑΣ                                       
ΒΑΡΔΑΒΟΥΛΙΑΣ                                      
ΒΑΡΔΑΓΓΑΛΟΣ                                       
ΒΑΡΔΑΚΑΡΗΣ                                        
ΒΑΡΔΑΚΑΣ                                          
ΒΑΡΔΑΚΑΣΤΑΝΗΣ                                     
ΒΑΡΔΑΚΗΣ                                          
ΒΑΡΔΑΚΙΔΗΣ                                        
ΒΑΡΔΑΚΙΣ                                          
ΒΑΡΔΑΚΟΠΟΥΛΟΣ                                     
ΒΑΡΔΑΚΟΣ                                          
ΒΑΡΔΑΚΟΥΛΗΣ                                       
ΒΑΡΔΑΚΟΥΛΙΑΣ                                      
ΒΑΡΔΑΚΤΣΗΣ                                        
ΒΑΡΔΑΚΩΣΤΑΣ                                       
ΒΑΡΔΑΛΑΚΗΣ                                        
ΒΑΡΔΑΛΑΚΟΣ                                        
ΒΑΡΔΑΛΑΣ                                          
ΒΑΡΔΑΛΑΧΑΚΗΣ                                      
ΒΑΡΔΑΛΑΧΟΣ                                        
ΒΑΡΔΑΛΗΣ                                          
ΒΑΡΔΑΛΟΠΑΝΟΣ                                      
ΒΑΡΔΑΛΟΣ                                          
ΒΑΡΔΑΜΑΣΚΟΣ                                       
ΒΑΡΔΑΜΙΔΗΣ                                        
ΒΑΡΔΑΝΗΣ                                          
ΒΑΡΔΑΝΙΔΗΣ                                        
ΒΑΡΔΑΝΙΚΑΣ                                        
ΒΑΡΔΑΞΗΣ                                          
ΒΑΡΔΑΞΟΠΟΥΛΟΣ                                     
ΒΑΡΔΑΟΥΛΗΣ                                        
ΒΑΡΔΑΟΥΛΛΗΣ                                       
ΒΑΡΔΑΡΑΜΑΤΟΣ                                      
ΒΑΡΔΑΡΕΝΤΖΗΣ                                      
ΒΑΡΔΑΡΕΤΖΗΣ                                       
ΒΑΡΔΑΡΗΣ                                          
ΒΑΡΔΑΡΙΝΟΣ                                        
ΒΑΡΔΑΡΟΣ                                          
ΒΑΡΔΑΣ                                            
ΒΑΡΔΑΤΣΙΚΟΣ                                       
ΒΑΡΔΕΓΚΑΣ                                         
ΒΑΡΔΕΛΛΗΣ                                         
ΒΑΡΔΗΣ                                            
ΒΑΡΔΙΑΜΠΑΣΗΣ                                      
ΒΑΡΔΙΑΝΙΔΗΣ                                       
ΒΑΡΔΙΑΝΟΣ                                         
ΒΑΡΔΙΑΣ                                           
ΒΑΡΔΙΑΤΖΑΚΗΣ                                      
ΒΑΡΔΙΔΑΚΗΣ                                        
ΒΑΡΔΙΔΗΣ                                          
ΒΑΡΔΙΚΑΣ                                          
ΒΑΡΔΙΚΙΑΔΗΣ                                       
ΒΑΡΔΙΚΙΔΗΣ                                        
ΒΑΡΔΙΚΛΗΣ                                         
ΒΑΡΔΙΚΟΣ                                          
ΒΑΡΔΙΜΗΣ                                          
ΒΑΡΔΙΜΙΑΔΗΣ                                       
ΒΑΡΔΙΝΟΓΙΑΝΝΗΣ                                    
ΒΑΡΔΙΟΠΟΥΛΟΣ                                      
ΒΑΡΔΟΝΙΚΟΛΑΚΗΣ                                    
ΒΑΡΔΟΠΟΥΛΟΣ                                       
ΒΑΡΔΟΣΗΣ                                          
ΒΑΡΔΟΥΛΑΚΗΣ                                       
ΒΑΡΔΟΥΛΗΣ                                         
ΒΑΡΔΟΥΛΙΑΣ                                        
ΒΑΡΔΟΥΝΙΩΤΗΣ                                      
ΒΑΡΕΔΑΚΗΣ                                         
ΒΑΡΕΖΗΣ                                           
ΒΑΡΕΙΑΣ                                           
ΒΑΡΕΚΑΣ                                           
ΒΑΡΕΛΑΚΗΣ                                         
ΒΑΡΕΛΑΣ                                           
ΒΑΡΕΛΕΤΖΗΣ                                        
ΒΑΡΕΛΗΣ                                           
ΒΑΡΕΛΙΑΣ                                          
ΒΑΡΕΛΙΔΗΣ                                         
ΒΑΡΕΛΙΤΖΗΣ                                        
ΒΑΡΕΛΛΑΣ                                          
ΒΑΡΕΛΛΗΣ                                          
ΒΑΡΕΛΟΓΙΑΝΝΗΣ                                     
ΒΑΡΕΛΟΠΟΙΟΣ                                       
ΒΑΡΕΛΟΠΟΥΛΟΣ                                      
ΒΑΡΕΛΤΖΑΚΗΣ                                       
ΒΑΡΕΛΤΖΗΣ                                         
ΒΑΡΕΛΤΖΙΔΗΣ                                       
ΒΑΡΕΜΕΝΟΣ                                         
ΒΑΡΕΜΜΕΝΟΣ                                        
ΒΑΡΕΝΑΣ                                           
ΒΑΡΕΝΙΔΗΣ                                         
ΒΑΡΕΝΤΖΗΣ                                         
ΒΑΡΕΣΗΣ                                           
ΒΑΡΕΤΑΙΟΣ                                         
ΒΑΡΕΤΑΣ                                           
ΒΑΡΕΤΙΔΗΣ                                         
ΒΑΡΕΤΙΜΙΔΗΣ                                       
ΒΑΡΕΤΤΑΣ                                          
ΒΑΡΖΑΚΑΚΟΣ                                        
ΒΑΡΖΑΚΑΝΟΣ                                        
ΒΑΡΖΑΚΑΣ                                          
ΒΑΡΖΑΚΗΣ                                          
ΒΑΡΖΑΝΙΔΗΣ                                        
ΒΑΡΖΕΛΗΣ                                          
ΒΑΡΖΕΛΙΩΤΗΣ                                       
ΒΑΡΖΗΣ                                            
ΒΑΡΖΙΔΗΣ                                          
ΒΑΡΖΟΠΟΥΛΟΣ                                       
ΒΑΡΖΟΣ                                            
ΒΑΡΖΩΚΑΣ                                          
ΒΑΡΗΑΣ                                            
ΒΑΡΗΣ                                             
ΒΑΡΗΤΙΜΙΑΔΗΣ                                      
ΒΑΡΘΑΚΟΥΡΗΣ                                       
ΒΑΡΘΑΛΑΜΗΣ                                        
ΒΑΡΘΑΛΗΣ                                          
ΒΑΡΘΑΛΙΤΗΣ                                        
ΒΑΡΘΗΣ                                            
ΒΑΡΘΟΛΟΜΑΙΟΣ                                      
ΒΑΡΘΟΛΟΜΑΤΟΣ                                      
ΒΑΡΘΟΛΟΜΗΣ                                        
ΒΑΡΘΟΛΟΜΙΔΗΣ                                      
ΒΑΡΘΟΛΟΜΟΣ                                        
ΒΑΡΘΟΠΟΥΛΟΣ                                       
ΒΑΡΙΑΔΑΚΗΣ                                        
ΒΑΡΙΑΔΗΣ                                          
ΒΑΡΙΑΚΤΑΡΗΣ                                       
ΒΑΡΙΑΜΗΣ                                          
ΒΑΡΙΑΜΙΔΗΣ                                        
ΒΑΡΙΑΝΙΤΗΣ                                        
ΒΑΡΙΑΝΤΖΑΣ                                        
ΒΑΡΙΑΞΗΣ                                          
ΒΑΡΙΑΣ                                            
ΒΑΡΙΑΤΖΑΣ                                         
ΒΑΡΙΔΑΚΗΣ                                         
ΒΑΡΙΔΗΣ                                           
ΒΑΡΙΚΑΣ                                           
ΒΑΡΙΚΟΣ                                           
ΒΑΡΙΛΙΔΗΣ                                         
ΒΑΡΙΝΟΣ                                           
ΒΑΡΙΟΖΙΔΗΣ                                        
ΒΑΡΙΟΠΟΥΛΟΣ                                       
ΒΑΡΙΣΤΕΑΣ                                         
ΒΑΡΙΤΑΚΗΣ                                         
ΒΑΡΙΤΗΣ                                           
ΒΑΡΚΑΔΟΣ                                          
ΒΑΡΚΑΚΗΣ                                          
ΒΑΡΚΑΝΗΣ                                          
ΒΑΡΚΑΝΙΤΣΑΣ                                       
ΒΑΡΚΑΝΝΗΣ                                         
ΒΑΡΚΑΡΑΚΗΣ                                        
ΒΑΡΚΑΡΗΣ                                          
ΒΑΡΚΑΡΟΛΗΣ                                        
ΒΑΡΚΑΡΟΤΟΣ                                        
ΒΑΡΚΑΡΩΤΑΣ                                        
ΒΑΡΚΑΡΩΤΟΣ                                        
ΒΑΡΚΑΣ                                            
ΒΑΡΚΑΤΖΑΣ                                         
ΒΑΡΚΙΑΝΟΣ                                         
ΒΑΡΚΙΤΖΗΣ                                         
ΒΑΡΚΟΠΟΥΛΟΣ                                       
ΒΑΡΚΟΥΛΗΣ                                         
ΒΑΡΚΟΥΤΑΣ                                         
ΒΑΡΚΟΥΤΣΑΣ                                        
ΒΑΡΚΟΥΤΣΟΣ                                        
ΒΑΡΛΑΓΚΑΣ                                         
ΒΑΡΛΑΜΗΣ                                          
ΒΑΡΛΑΜΙΔΗΣ                                        
ΒΑΡΛΑΜΙΤΗΣ                                        
ΒΑΡΛΑΜΟΣ                                          
ΒΑΡΛΑΝΤΣΑΝΗΣ                                      
ΒΑΡΛΑΣ                                            
ΒΑΡΛΑΤΖΙΔΗΣ                                       
ΒΑΡΛΕΤΖΙΔΗΣ                                       
ΒΑΡΛΗΣ                                            
ΒΑΡΛΙΑΓΚΑΣ                                        
ΒΑΡΛΟΚΩΣΤΑΣ                                       
ΒΑΡΜΑΖΗΣ                                          
ΒΑΡΜΑΞΙΔΗΣ                                        
ΒΑΡΜΑΞΙΖΗΣ                                        
ΒΑΡΜΠΕΝΗΣ                                         
ΒΑΡΜΠΟΜΠΙΤΗΣ                                      
ΒΑΡΝΑΒΑΣ                                          
ΒΑΡΝΑΒΕΛΙΑΣ                                       
ΒΑΡΝΑΒΙΔΗΣ                                        
ΒΑΡΝΑΒΟΠΟΥΛΟΣ                                     
ΒΑΡΝΑΚΑΣ                                          
ΒΑΡΝΑΚΙΩΤΗΣ                                       
ΒΑΡΝΑΛΗΣ                                          
ΒΑΡΝΑΛΙΔΗΣ                                        
ΒΑΡΝΑΣ                                            
ΒΑΡΝΑΣΙΔΗΣ                                        
ΒΑΡΝΕΛΗΣ                                          
ΒΑΡΝΗΣ                                            
ΒΑΡΝΙΔΗΣ                                          
ΒΑΡΝΙΤΖΙΩΤΗΣ                                      
ΒΑΡΝΙΤΣΙΩΤΗΣ                                      
ΒΑΡΝΙΤΣΩΤΗΣ                                       
ΒΑΡΝΤΑΝΙΔΗΣ                                       
ΒΑΡΝΤΙΚΙΔΗΣ                                       
ΒΑΡΝΤΜΑΝΙΔΗΣ                                      
ΒΑΡΟΖΑΚΗΣ                                         
ΒΑΡΟΠΟΥΛΟΣ                                        
ΒΑΡΟΣ                                             
ΒΑΡΟΤΖΑΚΗΣ                                        
ΒΑΡΟΤΣΑΚΗΣ                                        
ΒΑΡΟΤΣΗΣ                                          
ΒΑΡΟΤΣΟΣ                                          
ΒΑΡΟΥΔΑΚΗΣ                                        
ΒΑΡΟΥΔΗΣ                                          
ΒΑΡΟΥΚΤΣΗΣ                                        
ΒΑΡΟΥΜΑΣ                                          
ΒΑΡΟΥΝΑΣ                                          
ΒΑΡΟΥΝΗΣ                                          
ΒΑΡΟΥΝΤΖΑΚΗΣ                                      
ΒΑΡΟΥΞΑΚΗΣ                                        
ΒΑΡΟΥΞΗΣ                                          
ΒΑΡΟΥΣΗΣ                                          
ΒΑΡΟΥΣΙΑΔΗΣ                                       
ΒΑΡΟΥΤΑΚΗΣ                                        
ΒΑΡΟΥΤΑΣ                                          
ΒΑΡΟΥΤΕΛΗΣ                                        
ΒΑΡΟΥΤΕΛΛΗΣ                                       
ΒΑΡΟΥΤΖΑΚΗΣ                                       
ΒΑΡΟΥΤΗΣ                                          
ΒΑΡΟΥΤΣΑΣ                                         
ΒΑΡΟΥΤΣΗΣ                                         
ΒΑΡΟΥΤΣΙΔΗΣ                                       
ΒΑΡΟΥΤΣΙΚΟΣ                                       
ΒΑΡΟΥΤΣΟΣ                                         
ΒΑΡΟΥΦΑΚΗΣ                                        
ΒΑΡΟΥΦΗΣ                                          
ΒΑΡΟΥΧΑΚΗΣ                                        
ΒΑΡΟΥΧΑΣ                                          
ΒΑΡΟΥΧΗΣ                                          
ΒΑΡΟΥΧΟΣ                                          
ΒΑΡΡΑΣ                                            
ΒΑΡΡΗΣ                                            
ΒΑΡΡΙΑΣ                                           
ΒΑΡΣΑΓΑΚΗΣ                                        
ΒΑΡΣΑΚΕΛΗΣ                                        
ΒΑΡΣΑΚΗΣ                                          
ΒΑΡΣΑΚΟΠΟΥΛΟΣ                                     
ΒΑΡΣΑΜΑΚΗΣ                                        
ΒΑΡΣΑΜΑΚΙΔΗΣ                                      
ΒΑΡΣΑΜΑΣ                                          
ΒΑΡΣΑΜΗΣ                                          
ΒΑΡΣΑΜΙΔΑΚΗΣ                                      
ΒΑΡΣΑΜΙΔΗΣ                                        
ΒΑΡΣΑΜΟΓΙΑΝΝΗΣ                                    
ΒΑΡΣΑΜΟΠΟΥΛΟΣ                                     
ΒΑΡΣΑΜΟΣ                                          
ΒΑΡΣΑΜΟΥΔΗΣ                                       
ΒΑΡΣΑΜΟΥΛΗΣ                                       
ΒΑΡΣΑΝΗΣ                                          
ΒΑΡΣΟΠΟΥΛΟΣ                                       
ΒΑΡΣΟΣ                                            
ΒΑΡΤΑΛΑΜΗΣ                                        
ΒΑΡΤΑΛΑΜΙΔΗΣ                                      
ΒΑΡΤΑΛΑΣ                                          
ΒΑΡΤΑΛΙΤΗΣ                                        
ΒΑΡΤΑΜΤΖΙΔΗΣ                                      
ΒΑΡΤΑΝΑΚΗΣ                                        
ΒΑΡΤΑΝΗΣ                                          
ΒΑΡΤΑΝΙΔΗΣ                                        
ΒΑΡΤΕΛΑΣ                                          
ΒΑΡΤΕΛΑΤΟΣ                                        
ΒΑΡΤΕΣΚΑΣ                                         
ΒΑΡΤΖΑΚΗΣ                                         
ΒΑΡΤΖΑΣ                                           
ΒΑΡΤΖΕΛΗΣ                                         
ΒΑΡΤΖΕΛΙΩΤΗΣ                                      
ΒΑΡΤΖΗΣ                                           
ΒΑΡΤΖΙΑΣ                                          
ΒΑΡΤΖΙΔΗΣ                                         
ΒΑΡΤΖΙΚΟΣ                                         
ΒΑΡΤΖΙΟΥΚΑΣ                                       
ΒΑΡΤΖΙΟΥΜΑΣ                                       
ΒΑΡΤΖΙΩΤΗΣ                                        
ΒΑΡΤΖΟΠΟΥΛΟΣ                                      
ΒΑΡΤΖΩΚΑΣ                                         
ΒΑΡΤΗΣ                                            
ΒΑΡΤΟΣΗΣ                                          
ΒΑΡΤΣΑΚΗΣ                                         
ΒΑΡΤΣΑΝΕΛΗΣ                                       
ΒΑΡΤΣΙΚΟΣ                                         
ΒΑΡΤΣΟΠΟΥΛΟΣ                                      
ΒΑΡΤΣΟΣ                                           
ΒΑΡΤΣΟΥΚΗΣ                                        
ΒΑΡΥΓΙΑΝΝΗΣ                                       
ΒΑΡΥΔΑΚΗΣ                                         
ΒΑΡΥΔΗΜΟΣ                                         
ΒΑΡΥΘΥΜΙΑΔΗΣ                                      
ΒΑΡΥΜΠΟΜΠΙΤΗΣ                                     
ΒΑΡΥΜΠΟΜΠΙΩΤΗΣ                                    
ΒΑΡΥΜΠΟΠΗΣ                                        
ΒΑΡΥΜΠΟΠΙΩΤΗΣ                                     
ΒΑΡΥΠΑΤΑΚΗΣ                                       
ΒΑΡΥΠΑΤΑΡΗΣ                                       
ΒΑΡΥΠΑΤΗΣ                                         
ΒΑΡΥΤΗΜΙΑΔΗΣ                                      
ΒΑΡΥΤΗΜΙΔΗΣ                                       
ΒΑΡΥΤΗΣ                                           
ΒΑΡΥΤΙΔΗΣ                                         
ΒΑΡΥΤΙΜΙΑΔΗΣ                                      
ΒΑΡΥΤΙΜΙΔΗΣ                                       
ΒΑΡΥΤΙΜΟΣ                                         
ΒΑΡΦΗΣ                                            
ΒΑΡΧΑΛΑΜΑΣ                                        
ΒΑΡΧΑΝΗΣ                                          
ΒΑΡΧΑΡΙΔΗΣ                                        
ΒΑΡΩΝΑΚΗΣ                                         
ΒΑΡΩΝΑΣ                                           
ΒΑΡΩΝΗΣ                                           
ΒΑΡΩΝΟΣ                                           
ΒΑΡΩΣΗΣ                                           
ΒΑΡΩΤΑΣ                                           
ΒΑΡΩΤΣΗΣ                                          
ΒΑΡΩΤΣΟΣ                                          
ΒΑΣΑΓΙΑΝΝΗΣ                                       
ΒΑΣΑΓΙΩΡΓΗΣ                                       
ΒΑΣΑΔΑΚΗΣ                                         
ΒΑΣΑΔΗΣ                                           
ΒΑΣΑΙΤΗΣ                                          
ΒΑΣΑΚΑΚΗΣ                                         
ΒΑΣΑΚΗΣ                                           
ΒΑΣΑΚΟΣ                                           
ΒΑΣΑΛΑΚΗΣ                                         
ΒΑΣΑΛΑΣ                                           
ΒΑΣΑΛΙΟΣ                                          
ΒΑΣΑΛΛΟΣ                                          
ΒΑΣΑΛΟΣ                                           
ΒΑΣΑΜΑΝΙΔΗΣ                                       
ΒΑΣΑΝΙΔΗΣ                                         
ΒΑΣΑΡΑΜΒΑΣ                                        
ΒΑΣΑΡΑΣ                                           
ΒΑΣΑΡΔΑΝΗΣ                                        
ΒΑΣΑΡΙΩΤΗΣ                                        
ΒΑΣΑΡΜΙΔΑΚΗΣ                                      
ΒΑΣΑΡΜΙΔΗΣ                                        
ΒΑΣΑΤΗΣ                                           
ΒΑΣΒΑΝΑΣ                                          
ΒΑΣΒΑΝΗΣ                                          
ΒΑΣΒΑΤΕΚΗΣ                                        
ΒΑΣΓΟΥΤΗΣ                                         
ΒΑΣΔΑΒΑΝΟΣ                                        
ΒΑΣΔΑΡΗΣ                                          
ΒΑΣΔΕΚΑΣ                                          
ΒΑΣΔΕΚΗΣ                                          
ΒΑΣΔΟΚΑΣ                                          
ΒΑΣΔΡΑΒΑΝΙΔΗΣ                                     
ΒΑΣΔΡΑΒΕΛΛΗΣ                                      
ΒΑΣΔΡΑΓΙΑΝΝΗΣ                                     
ΒΑΣΕΙΑΔΗΣ                                         
ΒΑΣΗΣ                                             
ΒΑΣΙΑΓΕΩΡΓΗΣ                                      
ΒΑΣΙΑΔΗΣ                                          
ΒΑΣΙΑΚΑΚΗΣ                                        
ΒΑΣΙΑΚΟΣ                                          
ΒΑΣΙΑΚΩΣΤΑΣ                                       
ΒΑΣΙΑΝΑΣ                                          
ΒΑΣΙΑΝΟΣ                                          
ΒΑΣΙΑΡΑΣ                                          
ΒΑΣΙΑΡΔΑΝΗΣ                                       
ΒΑΣΙΑΣ                                            
ΒΑΣΙΑΤΗΣ                                          
ΒΑΣΙΒΑΓΛΗΣ                                        
ΒΑΣΙΒΟΥΖΟΥΚΗΣ                                     
ΒΑΣΙΓΙΑΝΝΗΣ                                       
ΒΑΣΙΚΑΡΙΔΗΣ                                       
ΒΑΣΙΚΕΡΗΣ                                         
ΒΑΣΙΚΩΣΤΑΣ                                        
ΒΑΣΙΛΑΓΑΣ                                         
ΒΑΣΙΛΑΓΚΟΣ                                        
ΒΑΣΙΛΑΓΟΡΗΣ                                       
ΒΑΣΙΛΑΔΙΩΤΗΣ                                      
ΒΑΣΙΛΑΙΝΑΣ                                        
ΒΑΣΙΛΑΚΑΚΗΣ                                       
ΒΑΣΙΛΑΚΑΚΟΣ                                       
ΒΑΣΙΛΑΚΑΣ                                         
ΒΑΣΙΛΑΚΕΡΗΣ                                       
ΒΑΣΙΛΑΚΗΣ                                         
ΒΑΣΙΛΑΚΙΔΗΣ                                       
ΒΑΣΙΛΑΚΙΣ                                         
ΒΑΣΙΛΑΚΟΠΟΥΛΟΣ                                    
ΒΑΣΙΛΑΚΟΣ                                         
ΒΑΣΙΛΑΚΟΥΔΗΣ                                      
ΒΑΣΙΛΑΝΤΩΝΑΚΗΣ                                    
ΒΑΣΙΛΑΝΤΩΝΟΠΟΥΛΟΣ                                 
ΒΑΣΙΛΑΠΟΣΤΟΛΗΣ                                    
ΒΑΣΙΛΑΡΑΚΗΣ                                       
ΒΑΣΙΛΑΡΑΚΟΣ                                       
ΒΑΣΙΛΑΡΑΣ                                         
ΒΑΣΙΛΑΡΕΑΣ                                        
ΒΑΣΙΛΑΡΗΣ                                         
ΒΑΣΙΛΑΡΙΔΗΣ                                       
ΒΑΣΙΛΑΡΟΠΟΥΛΟΣ                                    
ΒΑΣΙΛΑΡΟΣ                                         
ΒΑΣΙΛΑΣ                                           
ΒΑΣΙΛΑΤΗΣ                                         
ΒΑΣΙΛΑΤΟΣ                                         
ΒΑΣΙΛΕΔΑΚΗΣ                                       
ΒΑΣΙΛΕΔΑΚΙΣ                                       
ΒΑΣΙΛΕΙΑΔΗΣ                                       
ΒΑΣΙΛΕΙΑΣ                                         
ΒΑΣΙΛΕΙΔΗΣ                                        
ΒΑΣΙΛΕΙΚΟΣ                                        
ΒΑΣΙΛΕΙΜΗΣ                                        
ΒΑΣΙΛΕΙΟΠΟΥΛΟΣ                                    
ΒΑΣΙΛΕΙΟΥ ΑΥΓΟΥΣΤΟΓΛΟΥ                            
ΒΑΣΙΛΕΙΟΥ ΔΕΡΒΙΣΟΓΛΟΥ                             
ΒΑΣΙΛΕΙΩΡΗΣ                                       
ΒΑΣΙΛΕΙΩΤΗΣ                                       
ΒΑΣΙΛΕΚΑΣ                                         
ΒΑΣΙΛΕΛΗΣ                                         
ΒΑΣΙΛΕΛΛΗΣ                                        
ΒΑΣΙΛΕΛΟΣ                                         
ΒΑΣΙΛΕΝΑΣ                                         
ΒΑΣΙΛΕΡΗΣ                                         
ΒΑΣΙΛΕΣ                                           
ΒΑΣΙΛΗΑΣ                                          
ΒΑΣΙΛΗΓΙΑΝΝΗΣ                                     
ΒΑΣΙΛΗΣ                                           
ΒΑΣΙΛΙΑΓΚΟΣ                                       
ΒΑΣΙΛΙΑΔΗΣ                                        
ΒΑΣΙΛΙΑΣ                                          
ΒΑΣΙΛΙΔΗΣ                                         
ΒΑΣΙΛΙΚΑΔΗΣ                                       
ΒΑΣΙΛΙΚΑΚΗΣ                                       
ΒΑΣΙΛΙΚΑΡΗΣ                                       
ΒΑΣΙΛΙΚΑΣ                                         
ΒΑΣΙΛΙΚΗΣ                                         
ΒΑΣΙΛΙΚΙΑΣ                                        
ΒΑΣΙΛΙΚΙΩΤΗΣ                                      
ΒΑΣΙΛΙΚΟΓΙΑΝΝΑΚΗΣ                                 
ΒΑΣΙΛΙΚΟΠΟΥΛΟΣ                                    
ΒΑΣΙΛΙΚΟΣ                                         
ΒΑΣΙΛΙΚΟΥΔΗΣ                                      
ΒΑΣΙΛΙΚΩΣΤΑΣ                                      
ΒΑΣΙΛΙΜΗΣ                                         
ΒΑΣΙΛΙΜΝΗΣ                                        
ΒΑΣΙΛΙΟΠΟΥΛΟΣ                                     
ΒΑΣΙΛΙΩΡΗΣ                                        
ΒΑΣΙΛΚΑΡΙΔΗΣ                                      
ΒΑΣΙΛΟΒΙΤΣ                                        
ΒΑΣΙΛΟΓΑΜΒΡΑΚΗΣ                                   
ΒΑΣΙΛΟΓΑΜΒΡΟΣ                                     
ΒΑΣΙΛΟΓΕΩΡΓΗΣ                                     
ΒΑΣΙΛΟΓΙΑΝΝΑΚΗΣ                                   
ΒΑΣΙΛΟΓΙΑΝΝΑΚΟΠΟΥΛΟΣ                              
ΒΑΣΙΛΟΓΙΑΝΝΗΣ                                     
ΒΑΣΙΛΟΓΙΑΝΝΟΣ                                     
ΒΑΣΙΛΟΓΙΩΡΓΑΚΗΣ                                   
ΒΑΣΙΛΟΓΙΩΡΓΗΣ                                     
ΒΑΣΙΛΟΔΗΜΗΤΡΑΚΗΣ                                  
ΒΑΣΙΛΟΘΑΝΑΣΟΠΟΥΛΟΣ                                
ΒΑΣΙΛΟΚΩΝΣΤΑΝΤΑΚΗΣ                                
ΒΑΣΙΛΟΚΩΣΤΑΣ                                      
ΒΑΣΙΛΟΚΩΣΤΟΠΟΥΛΟΣ                                 
ΒΑΣΙΛΟΜΑΝΩΛΑΚΗΣ                                   
ΒΑΣΙΛΟΜΑΝΩΛΗΣ                                     
ΒΑΣΙΛΟΜΙΧΕΛΑΚΗΣ                                   
ΒΑΣΙΛΟΜΟΤΣΑΚΟΣ                                    
ΒΑΣΙΛΟΝΙΚΟΛΙΔΑΚΗΣ                                 
ΒΑΣΙΛΟΝΙΚΟΛΟΣ                                     
ΒΑΣΙΛΟΠΑΝΑΓΗΣ                                     
ΒΑΣΙΛΟΠΑΝΑΓΟΣ                                     
ΒΑΣΙΛΟΠΟΥΛΟΣ                                      
ΒΑΣΙΛΟΡΕΙΖΗΣ                                      
ΒΑΣΙΛΟΣ                                           
ΒΑΣΙΛΟΥΔΑΣ                                        
ΒΑΣΙΛΟΥΔΗΣ                                        
ΒΑΣΙΛΟΥΔΙΑΣ                                       
ΒΑΣΙΛΟΥΛΗΣ                                        
ΒΑΣΙΛΟΥΝΗΣ                                        
ΒΑΣΙΛΟΧΡΗΣΤΟΣ                                     
ΒΑΣΙΛΤΖΙΚΗΣ                                       
ΒΑΣΙΛΤΣΗΣ                                         
ΒΑΣΙΛΤΣΩΤΕΛΗΣ                                     
ΒΑΣΙΛΩΤΤΟΣ                                        
ΒΑΣΙΜΒΟΣΗΣ                                        
ΒΑΣΙΜΙΔΗΣ                                         
ΒΑΣΙΜΠΟΣΗΣ                                        
ΒΑΣΙΝΙΩΤΗΣ                                        
ΒΑΣΙΟΠΟΥΛΟΣ                                       
ΒΑΣΙΟΣ                                            
ΒΑΣΙΟΥΛΑΣ                                         
ΒΑΣΙΟΥΡΗΣ                                         
ΒΑΣΙΩΤΗΣ                                          
ΒΑΣΚΑΝΤΗΡΑΣ                                       
ΒΑΣΚΑΡΟΥΔΗΣ                                       
ΒΑΣΚΑΣ                                            
ΒΑΣΚΕΖ                                            
ΒΑΣΚΕΣ                                            
ΒΑΣΚΙΩΤΗΣ                                         
ΒΑΣΚΟΝΣΕΛΟΣ                                       
ΒΑΣΚΟΣ                                            
ΒΑΣΚΟΥΔΗΣ                                         
ΒΑΣΚΟΥΕΖ                                          
ΒΑΣΛΑΜΑΤΖΗΣ                                       
ΒΑΣΛΑΣ                                            
ΒΑΣΛΗΣ                                            
ΒΑΣΛΙΝΑΣ                                          
ΒΑΣΜΑΝΩΛΗΣ                                        
ΒΑΣΜΑΡΗΣ                                          
ΒΑΣΜΑΡΙΔΑΚΗΣ                                      
ΒΑΣΜΑΤΖΗΣ                                         
ΒΑΣΜΑΤΖΙΔΗΣ                                       
ΒΑΣΜΟΥΛΑΚΗΣ                                       
ΒΑΣΟΛΑΡΙΔΗΣ                                       
ΒΑΣΟΠΟΥΛΟΣ                                        
ΒΑΣΟΣ                                             
ΒΑΣΟΥΡΗΣ                                          
ΒΑΣΣΑΚΗΣ                                          
ΒΑΣΣΑΚΟΣ                                          
ΒΑΣΣΑΛΑΚΗΣ                                        
ΒΑΣΣΑΛΑΣ                                          
ΒΑΣΣΑΛΟΣ                                          
ΒΑΣΣΑΡΑΣ                                          
ΒΑΣΣΑΡΔΑΝΗΣ                                       
ΒΑΣΣΑΣ                                            
ΒΑΣΣΑΤΗΣ                                          
ΒΑΣΣΗΣ                                            
ΒΑΣΣΙΑΣ                                           
ΒΑΣΣΙΟΣ                                           
ΒΑΣΣΟΣ                                            
ΒΑΣΤΑΓΟΣ                                          
ΒΑΣΤΑΖΟΣ                                          
ΒΑΣΤΑΚΗΣ                                          
ΒΑΣΤΑΟΥΡΑΣ                                        
ΒΑΣΤΑΡΔΕΛΗΣ                                       
ΒΑΣΤΑΡΔΗΣ                                         
ΒΑΣΤΑΡΔΟΣ                                         
ΒΑΣΤΑΡΚΟΥΣ                                        
ΒΑΣΤΑΡΟΥΧΑΣ                                       
ΒΑΣΤΑΣ                                            
ΒΑΣΤΑΤΖΙΔΗΣ                                       
ΒΑΣΤΕΑΣ                                           
ΒΑΣΤΗΣ                                            
ΒΑΣΤΙΑΝΟΣ                                         
ΒΑΣΤΟΠΟΥΛΟΣ                                       
ΒΑΣΤΡΑΓΙΑΝΝΗΣ                                     
ΒΑΣΩΝΗΣ                                           
ΒΑΤΑΒΑΛΗΣ                                         
ΒΑΤΑΚΑΣ                                           
ΒΑΤΑΚΗΣ                                           
ΒΑΤΑΚΙΔΗΣ                                         
ΒΑΤΑΛΑΚΗΣ                                         
ΒΑΤΑΛΑΣ                                           
ΒΑΤΑΛΑΧΟΣ                                         
ΒΑΤΑΛΗΣ                                           
ΒΑΤΑΛΙΔΗΣ                                         
ΒΑΤΑΜΗΣ                                           
ΒΑΤΑΜΙΔΗΣ                                         
ΒΑΤΑΜΟΣ                                           
ΒΑΤΑΝΙΔΗΣ                                         
ΒΑΤΑΝΤΖΗΣ                                         
ΒΑΤΑΣ                                             
ΒΑΤΑΧΟΣ                                           
ΒΑΤΕΛΛΗΣ                                          
ΒΑΤΕΝΟΣ                                           
ΒΑΤΖΑΚΑΣ                                          
ΒΑΤΖΑΚΗΣ                                          
ΒΑΤΖΑΚΛΗΣ                                         
ΒΑΤΖΑΛΗΣ                                          
ΒΑΤΖΑΛΙΔΗΣ                                        
ΒΑΤΖΕΔΑΚΗΣ                                        
ΒΑΤΖΕΛΗΣ                                          
ΒΑΤΖΕΡΗΣ                                          
ΒΑΤΖΗΚΑΣ                                          
ΒΑΤΖΗΣ                                            
ΒΑΤΖΙΑΝΙΔΗΣ                                       
ΒΑΤΖΙΑΣ                                           
ΒΑΤΖΙΚΑΣ                                          
ΒΑΤΖΙΟΛΗΣ                                         
ΒΑΤΖΙΟΣ                                           
ΒΑΤΖΙΠ                                            
ΒΑΤΖΙΠ ΟΓΛΟΥ                                      
ΒΑΤΖΟΛΑΣ                                          
ΒΑΤΖΟΛΗΣ                                          
ΒΑΤΗΣ                                             
ΒΑΤΙΑΝΗΣ                                          
ΒΑΤΙΑΝΟΣ                                          
ΒΑΤΙΔΗΣ                                           
ΒΑΤΙΚΑΛΟΣ                                         
ΒΑΤΙΚΙΩΤΗΣ                                        
ΒΑΤΙΛΙΔΗΣ                                         
ΒΑΤΙΜΠΕΛΑΣ                                        
ΒΑΤΙΡΙΔΗΣ                                         
ΒΑΤΙΣΤΑΣ                                          
ΒΑΤΙΤΣΗΣ                                          
ΒΑΤΚΑΛΗΣ                                          
ΒΑΤΜΑΝΙΔΗΣ                                        
ΒΑΤΟΛΙΑΣ                                          
ΒΑΤΟΠΟΥΛΟΣ                                        
ΒΑΤΟΣ                                             
ΒΑΤΟΥΓΙΑΣ                                         
ΒΑΤΟΥΓΙΟΣ                                         
ΒΑΤΟΥΣΗΣ                                          
ΒΑΤΟΥΣΙΑΔΗΣ                                       
ΒΑΤΟΥΣΙΑΝΟΣ                                       
ΒΑΤΟΥΣΙΟΣ                                         
ΒΑΤΡΑΝΗΣ                                          
ΒΑΤΡΙΚΑΣ                                          
ΒΑΤΣΑΚΗΣ                                          
ΒΑΤΣΑΚΛΗΣ                                         
ΒΑΤΣΑΚΤΣΗΣ                                        
ΒΑΤΣΑΛΗΣ                                          
ΒΑΤΣΑΛΙΔΗΣ                                        
ΒΑΤΣΑΝΗΣ                                          
ΒΑΤΣΑΝΙΔΗΣ                                        
ΒΑΤΣΑΡΕΑΣ                                         
ΒΑΤΣΑΣ                                            
ΒΑΤΣΑΧΑΣ                                          
ΒΑΤΣΕΛΑΣ                                          
ΒΑΤΣΕΛΗΣ                                          
ΒΑΤΣΕΛΙΑΣ                                         
ΒΑΤΣΕΛΛΑΣ                                         
ΒΑΤΣΕΡΗΣ                                          
ΒΑΤΣΗΣ                                            
ΒΑΤΣΙΑΣ                                           
ΒΑΤΣΙΘΙΑΝΟΣ                                       
ΒΑΤΣΙΚΑΣ                                          
ΒΑΤΣΙΚΟΠΟΥΛΟΣ                                     
ΒΑΤΣΙΚΟΥΡΑΣ                                       
ΒΑΤΣΙΚΟΥΡΙΔΗΣ                                     
ΒΑΤΣΙΛΑΣ                                          
ΒΑΤΣΙΛΙΔΗΣ                                        
ΒΑΤΣΙΝΑΚΗΣ                                        
ΒΑΤΣΙΝΑΡΑΣ                                        
ΒΑΤΣΙΝΑΡΗΣ                                        
ΒΑΤΣΙΝΑΣ                                          
ΒΑΤΣΙΝΕΑΣ                                         
ΒΑΤΣΙΟΣ                                           
ΒΑΤΣΙΟΥΡΑΣ                                        
ΒΑΤΣΙΤΣΕΣ                                         
ΒΑΤΣΙΤΣΗΣ                                         
ΒΑΤΣΙΩΑΝΝΙΔΗΣ                                     
ΒΑΤΣΚΑΛΗΣ                                         
ΒΑΤΣΟΛΑΚΗΣ                                        
ΒΑΤΣΟΣ                                            
ΒΑΤΣΟΥΡΑΣ                                         
ΒΑΤΣΟΥΡΗΣ                                         
ΒΑΤΤΕΣ                                            
ΒΑΤΤΗΣ                                            
ΒΑΤΤΟΣ                                            
ΒΑΤΩΝΙΑΣ                                          
ΒΑΦΑΚΗΣ                                           
ΒΑΦΑΚΟΣ                                           
ΒΑΦΕΑΣ                                            
ΒΑΦΕΙΑΔΑΚΗΣ                                       
ΒΑΦΕΙΑΔΗΣ                                         
ΒΑΦΕΙΑΔΗΣ ΣΙΝΟΓΛΟΥ                                
ΒΑΦΕΙΑΣ                                           
ΒΑΦΕΙΔΗΣ                                          
ΒΑΦΕΙΟΠΟΥΛΟΣ                                      
ΒΑΦΕΙΩΤΗΣ                                         
ΒΑΦΕΥΣ                                            
ΒΑΦΙΑΔΑΚΗΣ                                        
ΒΑΦΙΑΔΗΣ                                          
ΒΑΦΙΑΣ                                            
ΒΑΦΙΔΗΣ                                           
ΒΑΦΙΝΗΣ                                           
ΒΑΦΙΟΠΟΥΛΟΣ                                       
ΒΑΦΟΠΟΥΛΟΣ                                        
ΒΑΧΑΒΙΟΛΟΣ                                        
ΒΑΧΑΒΙΩΛΟΣ                                        
ΒΑΧΑΜΙΔΗΣ                                         
ΒΑΧΑΝΕΛΙΔΗΣ                                       
ΒΑΧΑΝΙΔΗΣ                                         
ΒΑΧΑΡ ΟΓΛΟΥ                                       
ΒΑΧΑΡΑΚΗΣ                                         
ΒΑΧΑΡΑΚΙΔΗΣ                                       
ΒΑΧΑΡΕΛΗΣ                                         
ΒΑΧΑΡΗΣ                                           
ΒΑΧΑΡΙΑΣ                                          
ΒΑΧΑΡΙΔΗΣ                                         
ΒΑΧΑΡΙΚΟΣ                                         
ΒΑΧΑΡΟΛΙΔΗΣ                                       
ΒΑΧΑΡΟΠΟΥΛΟΣ                                      
ΒΑΧΑΤΕΛΑΣ                                         
ΒΑΧΑΤΖΑΚΗΣ                                        
ΒΑΧΑΤΟΥΡΑΣ                                        
ΒΑΧΑΤΣΑΚΗΣ                                        
ΒΑΧΑΤΩΡΗΣ                                         
ΒΑΧΛΑΣ                                            
ΒΑΧΛΗΣ                                            
ΒΑΧΛΙΩΤΗΣ                                         
ΒΑΧΟΣ                                             
ΒΑΧΟΥΔΙΑΝΑΚΗΣ                                     
ΒΑΧΟΥΘΙΑΝΑΚΗΣ                                     
ΒΑΧΟΥΜΗΣ                                          
ΒΑΧΡΑΤΙΔΗΣ                                        
ΒΑΧΤΑΝΓΙΔΗΣ                                       
ΒΑΧΤΑΝΓΚΙΔΗΣ                                      
ΒΑΧΤΑΝΙΔΗΣ                                        
ΒΑΧΤΣΑΒΑΝΗΣ                                       
ΒΑΧΤΣΕΒΑΝΗΣ                                       
ΒΑΧΤΣΕΒΑΝΙΔΗΣ                                     
ΒΑΧΤΣΕΒΑΝΟΣ                                       
ΒΑΧΤΣΕΤΖΗΣ                                        
ΒΑΧΤΣΙΑΒΑΝΟΣ                                      
ΒΑΧΤΣΙΟΛΗΣ                                        
ΒΑΪΔΑΝΗ                                           
ΒΑΪΔΑΝΗΣ                                          
ΒΑΪΝΑ                                             
ΒΑΪΝΑΣ                                            
ΒΑΪΝΟΥ                                            
ΒΑΪΟΣ                                             
ΒΑΪΟΥ                                             
ΒΑΪΡΑΜΗ                                           
ΒΑΪΡΑΜΗΣ                                          
ΒΓΑΓΚΕΣ                                           
ΒΓΕΝΑΣ                                            
ΒΓΕΝΗΣ                                            
ΒΓΕΝΝΑΣ                                           
ΒΓΕΝΟΠΟΥΛΟΣ                                       
ΒΓΙΕΣ                                             
ΒΓΟΝΤΖΑΣ                                          
ΒΔΕΛΙΔΗΣ                                          
ΒΔΕΛΛΑΣ                                           
ΒΔΟΚΑΚΗΣ                                          
ΒΔΟΥΚΑΚΗΣ                                         
ΒΕΑΣ                                              
ΒΕΒΑΙΑΚΗΣ                                         
ΒΕΒΑΣ                                             
ΒΕΒΕΚΛΗΣ                                          
ΒΕΒΕΛΑΚΗΣ                                         
ΒΕΒΕΛΕΚΟΣ                                         
ΒΕΒΕΛΟΓΙΑΝΝΗΣ                                     
ΒΕΒΕΛΟΣ                                           
ΒΕΒΕΝΙΑΣ                                          
ΒΕΒΕΣ                                             
ΒΕΒΕΤΖΙΚΗΣ                                        
ΒΕΒΖΗ ΟΓΛΟΥ                                       
ΒΕΒΗΣ                                             
ΒΕΒΟΠΟΥΛΟΣ                                        
ΒΕΓΓΕΛΗΣ                                          
ΒΕΓΓΟΠΟΥΛΟΣ                                       
ΒΕΓΓΟΣ                                            
ΒΕΓΕΛΛΗΣ                                          
ΒΕΓΕΡΤΖΗΣ                                         
ΒΕΓΗΡΗΣ                                           
ΒΕΓΙΑΝΝΗΣ                                         
ΒΕΓΙΝΑΣ                                           
ΒΕΓΙΟΠΟΥΛΟΣ                                       
ΒΕΓΙΡΗΣ                                           
ΒΕΓΙΡΤΖΗΣ                                         
ΒΕΓΚΑΣ                                            
ΒΕΓΚΟΣ                                            
ΒΕΓΛΕΚΤΣΗΣ                                        
ΒΕΓΛΗΣ                                            
ΒΕΓΛΙΡΗΣ                                          
ΒΕΓΛΙΤΣΙΔΗΣ                                       
ΒΕΓΝΙΔΗΣ                                          
ΒΕΓΟΠΟΥΛΟΣ                                        
ΒΕΓΟΥΔΑΚΗΣ                                        
ΒΕΓΟΥΔΗΣ                                          
ΒΕΔΕΡΑΚΗΣ                                         
ΒΕΔΕΡΓΙΩΤΑΚΗΣ                                     
ΒΕΔΕΣ                                             
ΒΕΔΟΥΖΗΣ                                          
ΒΕΔΟΥΡΑΣ                                          
ΒΕΔΟΥΡΗΣ                                          
ΒΕΔΡΟΥΜΙΑΝΟΣ                                      
ΒΕΖΑΖΗΣ                                           
ΒΕΖΑΚΗΣ                                           
ΒΕΖΑΚΙΑΔΗΣ                                        
ΒΕΖΑΛΗΣ                                           
ΒΕΖΑΝΗΣ                                           
ΒΕΖΑΝΚΟΣ                                          
ΒΕΖΑΡΗΣ                                           
ΒΕΖΑΣ                                             
ΒΕΖΑΣΗΣ                                           
ΒΕΖΔΡΕΒΑΝΗΣ                                       
ΒΕΖΕΡΓΙΑΝΝΙΔΗΣ                                    
ΒΕΖΕΡΗΣ                                           
ΒΕΖΕΡΙΔΗΣ                                         
ΒΕΖΕΡΤΖΗΣ                                         
ΒΕΖΕΣΤΕΝΤΖΗΣ                                      
ΒΕΖΙΑΝΟΣ                                          
ΒΕΖΙΡΓΙΑΝΝΗΣ                                      
ΒΕΖΙΡΓΙΑΝΝΙΔΗΣ                                    
ΒΕΖΙΡΙΔΗΣ                                         
ΒΕΖΙΡΚΙΑΝΙΔΗΣ                                     
ΒΕΖΙΡΤΖΗΣ                                         
ΒΕΖΝΙΚΑΣ                                          
ΒΕΖΟΝΙΑΡΑΚΗΣ                                      
ΒΕΖΟΣ                                             
ΒΕΖΟΥΡΗΣ                                          
ΒΕΖΥΝΙΑΣ                                          
ΒΕΖΥΡΑΚΗΣ                                         
ΒΕΖΥΡΑΣ                                           
ΒΕΖΥΡΓΙΑΝΙΔΗΣ                                     
ΒΕΖΥΡΓΙΑΝΝΗΣ                                      
ΒΕΖΥΡΓΙΑΝΝΙΔΗΣ                                    
ΒΕΖΥΡΓΙΑΝΝΟΠΟΥΛΟΣ                                 
ΒΕΖΥΡΓΙΑΝΟΠΟΥΛΟΣ                                  
ΒΕΖΥΡΕΑΣ                                          
ΒΕΖΥΡΕΛΛΗΣ                                        
ΒΕΖΥΡΗΣ                                           
ΒΕΖΥΡΙΑΝΑΣ                                        
ΒΕΖΥΡΙΑΝΗΣ                                        
ΒΕΖΥΡΙΑΝΙΔΗΣ                                      
ΒΕΖΥΡΙΑΝΝΙΔΗΣ                                     
ΒΕΖΥΡΙΑΝΟΠΟΥΛΟΣ                                   
ΒΕΖΥΡΙΑΝΟΣ                                        
ΒΕΖΥΡΙΔΗΣ                                         
ΒΕΖΥΡΟΠΟΥΛΟΣ                                      
ΒΕΖΥΡΤΖΗΣ                                         
ΒΕΗΚΩΝΤΗΣ                                         
ΒΕΗΣ                                              
ΒΕΙΔΑΜΕΝΙΔΗΣ                                      
ΒΕΙΖ                                              
ΒΕΙΖ ΟΓΛΟΥ                                        
ΒΕΙΖΑΔΕΣ                                          
ΒΕΙΖΗΣ                                            
ΒΕΙΚΟΠΟΥΛΟΣ                                       
ΒΕΙΚΟΣ                                            
ΒΕΙΛΕΚΤΣΗΣ                                        
ΒΕΙΛΗΣ                                            
ΒΕΙΜΟΣ                                            
ΒΕΙΝΑΣ                                            
ΒΕΙΝΗΣ                                            
ΒΕΙΝΙΔΗΣ                                          
ΒΕΙΟΓΛΑΝΗΣ                                        
ΒΕΙΟΠΟΥΛΟΣ                                        
ΒΕΙΟΣ                                             
ΒΕΙΣ                                              
ΒΕΙΣΑΚΗΣ                                          
ΒΕΙΣΑΛ ΟΓΛΟΥ                                      
ΒΕΙΣΣΑΚΗΣ                                         
ΒΕΙΤΖΑΤ ΟΓΛΟΥ                                     
ΒΕΙΤΗΣ                                            
ΒΕΙΤΟΣ                                            
ΒΕΚΑΚΗΣ                                           
ΒΕΚΑΡΗΣ                                           
ΒΕΚΑΣ                                             
ΒΕΚΕΛΙΔΗΣ                                         
ΒΕΚΕΡΙΔΗΣ                                         
ΒΕΚΗΔΗΜΗΤΡΙΑΔΗΣ                                   
ΒΕΚΗΙΩΑΝΝΙΔΗΣ                                     
ΒΕΚΗΣ                                             
ΒΕΚΙΑΡΕΛΗΣ                                        
ΒΕΚΙΑΡΕΛΛΗΣ                                       
ΒΕΚΙΑΡΗΣ                                          
ΒΕΚΙΑΡΙΔΗΣ                                        
ΒΕΚΙΔΗΣ                                           
ΒΕΚΙΛΗΣ                                           
ΒΕΚΙΝΗΣ                                           
ΒΕΚΙΟΣ                                            
ΒΕΚΙΡΗΣ                                           
ΒΕΚΙΡΤΖΗΣ                                         
ΒΕΚΚΙΟΣ                                           
ΒΕΚΚΟΣ                                            
ΒΕΚΟΠΟΥΛΟΣ                                        
ΒΕΚΟΣ                                             
ΒΕΚΟΥΣΗΣ                                          
ΒΕΚΡΑΚΗΣ                                          
ΒΕΚΡΑΚΟΣ                                          
ΒΕΚΡΕΛΛΗΣ                                         
ΒΕΚΡΗΣ                                            
ΒΕΚΤΕΣ                                            
ΒΕΚΤΕΣΗΣ                                          
ΒΕΚΥΡΗΣ                                           
ΒΕΛΑΓΙΑΣ                                          
ΒΕΛΑΓΚΟΣ                                          
ΒΕΛΑΕΤΗΣ                                          
ΒΕΛΑΙΤΗΣ                                          
ΒΕΛΑΚΗΣ                                           
ΒΕΛΑΚΟΥΛΗΣ                                        
ΒΕΛΑΛΗΣ                                           
ΒΕΛΑΛΟΠΟΥΛΟΣ                                      
ΒΕΛΑΝΑΚΗΣ                                         
ΒΕΛΑΝΑΣ                                           
ΒΕΛΑΝΔΑΚΗΣ                                        
ΒΕΛΑΝΗΣ                                           
ΒΕΛΑΝΟΠΟΥΛΟΣ                                      
ΒΕΛΑΣ                                             
ΒΕΛΑΣΚΕΣ                                          
ΒΕΛΑΧΟΥΤΑΚΟΣ                                      
ΒΕΛΑΩΡΑΣ                                          
ΒΕΛΒΕΛΙΔΗΣ                                        
ΒΕΛΒΕΣ                                            
ΒΕΛΒΙΤΣΑΝΟΣ                                       
ΒΕΛΓΑΚΗΣ                                          
ΒΕΛΓΟΣ                                            
ΒΕΛΔΕΚΗΣ                                          
ΒΕΛΕΓΚΑΣ                                          
ΒΕΛΕΓΡΑΚΗΣ                                        
ΒΕΛΕΓΡΗΣ                                          
ΒΕΛΕΓΡΙΝΗΣ                                        
ΒΕΛΕΓΡΙΝΟΣ                                        
ΒΕΛΕΖΗΣ                                           
ΒΕΛΕΗΣ                                            
ΒΕΛΕΚΑΚΟΣ                                         
ΒΕΛΕΚΑΡΔΑΣ                                        
ΒΕΛΕΚΗΣ                                           
ΒΕΛΕΚΟΣ                                           
ΒΕΛΕΛΕΚΟΣ                                         
ΒΕΛΕΛΗΣ                                           
ΒΕΛΕΜΒΕΤΣΟΣ                                       
ΒΕΛΕΜΗΣ                                           
ΒΕΛΕΝΖΑΣ                                          
ΒΕΛΕΝΗΣ                                           
ΒΕΛΕΝΙΔΗΣ                                         
ΒΕΛΕΝΤΑΚΗΣ                                        
ΒΕΛΕΝΤΖΑΣ                                         
ΒΕΛΕΝΤΗΣ                                          
ΒΕΛΕΝΤΣΑΣ                                         
ΒΕΛΕΡΗΣ                                           
ΒΕΛΕΣΙΩΤΗΣ                                        
ΒΕΛΕΣΤΙΝΙΩΤΗΣ                                     
ΒΕΛΕΤΑΚΗΣ                                         
ΒΕΛΕΤΑΚΟΣ                                         
ΒΕΛΕΤΑΝΗΣ                                         
ΒΕΛΕΤΑΣ                                           
ΒΕΛΕΤΖΑΚΟΣ                                        
ΒΕΛΕΤΖΑΣ                                          
ΒΕΛΕΤΖΕΚΗΣ                                        
ΒΕΛΕΤΖΕΛΟΣ                                        
ΒΕΛΕΤΗΣ                                           
ΒΕΛΕΤΣΗΣ                                          
ΒΕΛΕΤΣΟΣ                                          
ΒΕΛΕΧΕΡΗΣ                                         
ΒΕΛΗ ΑΜΕΤ                                         
ΒΕΛΗ ΜΕΜΕΤ                                        
ΒΕΛΗ ΜΕΜΕΤ ΟΓΛΟΥ                                  
ΒΕΛΗ ΟΓΛΟΥ                                        
ΒΕΛΗ ΟΣΜΑΝ                                        
ΒΕΛΗ ΧΑΣΑΝ                                        
ΒΕΛΗ ΧΑΣΑΝ ΑΜΕΤ                                   
ΒΕΛΗΒΑΣΑΚΗΣ                                       
ΒΕΛΗΒΑΣΗΣ                                         
ΒΕΛΗΓΙΑΝΤΣΟΣ                                      
ΒΕΛΗΓΚΕΚΑΣ                                        
ΒΕΛΗΓΚΙΚΑΣ                                        
ΒΕΛΗΓΡΑΔΙΩΤΗΣ                                     
ΒΕΛΗΖΙΩΤΗΣ                                        
ΒΕΛΗΚΑΔΗΣ                                         
ΒΕΛΗΚΑΡΗΣ                                         
ΒΕΛΗΜΒΑΣΑΚΗΣ                                      
ΒΕΛΗΜΠΑΣΑΚΗΣ                                      
ΒΕΛΗΝΙΑΤΗΣ                                        
ΒΕΛΗΝΟΠΟΥΛΟΣ                                      
ΒΕΛΗΝΤΣΙΑΗΣ                                       
ΒΕΛΗΣ                                             
ΒΕΛΗΣΑΡΗΣ                                         
ΒΕΛΗΣΙΩΤΗΣ                                        
ΒΕΛΗΣΣΑΡΗΣ                                        
ΒΕΛΗΣΣΑΡΙΔΗΣ                                      
ΒΕΛΗΣΣΑΡΟΠΟΥΛΟΣ                                   
ΒΕΛΗΤΣΚΑΚΗΣ                                       
ΒΕΛΙΑΔΗΣ                                          
ΒΕΛΙΑΝΗΣ                                          
ΒΕΛΙΑΝΙΤΗΣ                                        
ΒΕΛΙΑΝΟΣ                                          
ΒΕΛΙΑΡΗΣ                                          
ΒΕΛΙΑΡΟΥΤΗΣ                                       
ΒΕΛΙΑΣ                                            
ΒΕΛΙΒΑΣΑΚΗΣ                                       
ΒΕΛΙΒΑΣΗΣ                                         
ΒΕΛΙΓΓΟΣ                                          
ΒΕΛΙΓΔΕΝΗΣ                                        
ΒΕΛΙΓΙΑΝΝΟΠΟΥΛΟΣ                                  
ΒΕΛΙΓΙΑΝΤΣΟΣ                                      
ΒΕΛΙΓΚΟΣ                                          
ΒΕΛΙΓΡΑΔΗΣ                                        
ΒΕΛΙΓΡΑΔΙΩΤΗΣ                                     
ΒΕΛΙΓΡΑΚΗΣ                                        
ΒΕΛΙΓΡΑΝΤΑΚΗΣ                                     
ΒΕΛΙΓΡΑΝΤΗΣ                                       
ΒΕΛΙΓΡΑΤΛΗΣ                                       
ΒΕΛΙΔΑΚΗΣ                                         
ΒΕΛΙΔΗΣ                                           
ΒΕΛΙΖΕΛΟΣ                                         
ΒΕΛΙΖΙΩΤΗΣ                                        
ΒΕΛΙΚΑΣ                                           
ΒΕΛΙΚΗΣ                                           
ΒΕΛΙΚΟΒΙΤΣ                                        
ΒΕΛΙΚΟΣ                                           
ΒΕΛΙΚΟΥΔΗΣ                                        
ΒΕΛΙΜΑΧΗΤΗΣ                                       
ΒΕΛΙΜΑΧΙΤΗΣ                                       
ΒΕΛΙΜΒΑΣΑΚΗΣ                                      
ΒΕΛΙΜΕΖΑΚΗΣ                                       
ΒΕΛΙΜΕΖΗΣ                                         
ΒΕΛΙΜΠΑΣΑΚΗΣ                                      
ΒΕΛΙΜΠΑΣΗΣ                                        
ΒΕΛΙΝΗΣ                                           
ΒΕΛΙΝΟΣ                                           
ΒΕΛΙΟΒΙΤΣ                                         
ΒΕΛΙΟΠΟΥΛΟΣ                                       
ΒΕΛΙΟΣ                                            
ΒΕΛΙΟΥΛΗΣ                                         
ΒΕΛΙΟΥΡΗΣ                                         
ΒΕΛΙΣΑΡΑΚΟΣ                                       
ΒΕΛΙΣΑΡΑΤΟΣ                                       
ΒΕΛΙΣΑΡΗΣ                                         
ΒΕΛΙΣΑΡΙΔΗΣ                                       
ΒΕΛΙΣΑΡΙΟΣ                                        
ΒΕΛΙΣΚΑΚΗΣ                                        
ΒΕΛΙΣΚΙΩΤΗΣ                                       
ΒΕΛΙΣΚΟΣ                                          
ΒΕΛΙΣΣΑΡΑΚΟΣ                                      
ΒΕΛΙΣΣΑΡΑΤΟΣ                                      
ΒΕΛΙΣΣΑΡΗΣ                                        
ΒΕΛΙΣΣΑΡΙΔΗΣ                                      
ΒΕΛΙΣΣΑΡΙΟΣ                                       
ΒΕΛΙΣΣΑΡΟΠΟΥΛΟΣ                                   
ΒΕΛΙΣΣΑΡΟΥΛΗΣ                                     
ΒΕΛΙΤΖΑΝΙΔΗΣ                                      
ΒΕΛΙΤΖΕΛΟΣ                                        
ΒΕΛΙΤΣΙΑΝΟΣ                                       
ΒΕΛΙΤΣΙΚΑΚΗΣ                                      
ΒΕΛΙΤΣΙΣΤΑΣ                                       
ΒΕΛΙΤΣΚΟΣ                                         
ΒΕΛΙΤΣΟΣ                                          
ΒΕΛΙΩΤΗΣ                                          
ΒΕΛΚΙΑΔΗΣ                                         
ΒΕΛΚΙΔΗΣ                                          
ΒΕΛΚΟΓΙΑΝΝΙΔΗΣ                                    
ΒΕΛΚΟΠΟΥΛΟΣ                                       
ΒΕΛΚΟΣ                                            
ΒΕΛΛΑΣ                                            
ΒΕΛΛΕΛΗΣ                                          
ΒΕΛΛΕΣ                                            
ΒΕΛΛΗΣ                                            
ΒΕΛΛΙΑΔΗΣ                                         
ΒΕΛΛΙΑΝΗΣ                                         
ΒΕΛΛΙΑΝΙΤΗΣ                                       
ΒΕΛΛΙΑΡΗΣ                                         
ΒΕΛΛΙΑΣ                                           
ΒΕΛΛΙΔΗΣ                                          
ΒΕΛΛΙΚΗΣ                                          
ΒΕΛΛΙΝΗΣ                                          
ΒΕΛΛΙΝΙΑΤΗΣ                                       
ΒΕΛΛΙΟΠΟΥΛΟΣ                                      
ΒΕΛΛΙΟΣ                                           
ΒΕΛΛΙΣΑΡΑΚΟΣ                                      
ΒΕΛΛΙΩΤΗΣ                                         
ΒΕΛΛΟΠΟΥΛΟΣ                                       
ΒΕΛΛΟΣ                                            
ΒΕΛΜΑΧΟΣ                                          
ΒΕΛΝΙΔΗΣ                                          
ΒΕΛΝΤΕΣ                                           
ΒΕΛΟΓΙΑΝΝΗΣ                                       
ΒΕΛΟΝΑΚΗΣ                                         
ΒΕΛΟΝΑΚΙΣ                                         
ΒΕΛΟΝΑΣ                                           
ΒΕΛΟΝΗΣ                                           
ΒΕΛΟΝΙΑΣ                                          
ΒΕΛΟΝΙΔΗΣ                                         
ΒΕΛΟΠΕΤΡΟΠΟΥΛΟΣ                                   
ΒΕΛΟΠΟΥΛΟΣ                                        
ΒΕΛΟΣ                                             
ΒΕΛΟΥΔΑΚΗΣ                                        
ΒΕΛΟΥΔΑΣ                                          
ΒΕΛΟΥΔΗΣ                                          
ΒΕΛΟΥΔΙΟΣ                                         
ΒΕΛΟΥΔΟΣ                                          
ΒΕΛΟΥΖΟΣ                                          
ΒΕΛΟΥΚΑΣ                                          
ΒΕΛΟΥΛΑΣ                                          
ΒΕΛΟΥΣΗΣ                                          
ΒΕΛΟΥΤΣΟΣ                                         
ΒΕΛΟΥΧΑΚΗΣ                                        
ΒΕΛΠ                                              
ΒΕΛΣ                                              
ΒΕΛΣΕΜΕΣ                                          
ΒΕΛΤΑΚΗΣ                                          
ΒΕΛΤΑΝΙΩΤΗΣ                                       
ΒΕΛΤΕΒΙΝΟΣ                                        
ΒΕΛΤΙΔΗΣ                                          
ΒΕΛΤΟΠΟΥΛΟΣ                                       
ΒΕΛΤΡΑΣ                                           
ΒΕΛΤΣΗΣ                                           
ΒΕΛΤΣΙΔΗΣ                                         
ΒΕΛΤΣΙΟΣ                                          
ΒΕΛΤΣΙΣΤΑΣ                                        
ΒΕΛΤΣΟΣ                                           
ΒΕΛΩΚΑΣ                                           
ΒΕΛΩΝΑΚΗΣ                                         
ΒΕΛΩΝΑΣ                                           
ΒΕΛΩΝΗΣ                                           
ΒΕΛΩΝΙΑΣ                                          
ΒΕΛΩΤΑΣ                                           
ΒΕΜΒΕΤΣΟΣ                                         
ΒΕΜΗΣ                                             
ΒΕΜΜΟΣ                                            
ΒΕΜΟΓΙΑΝΝΗΣ                                       
ΒΕΜΟΣ                                             
ΒΕΜΠΟΣ                                            
ΒΕΜΥΣ                                             
ΒΕΝΑΓΑΣ                                           
ΒΕΝΑΚΗΣ                                           
ΒΕΝΑΞΙΔΗΣ                                         
ΒΕΝΑΡΔΑΚΗΣ                                        
ΒΕΝΑΡΔΑΤΟΣ                                        
ΒΕΝΑΡΔΗΣ                                          
ΒΕΝΑΡΔΟΣ                                          
ΒΕΝΑΡΡΟΤΣ                                         
ΒΕΝΔΙΣΤΑΣ                                         
ΒΕΝΔΡΑΣ                                           
ΒΕΝΕΓΓΑΣ                                          
ΒΕΝΕΔΙΚΗΣ                                         
ΒΕΝΕΖΗΣ                                           
ΒΕΝΕΚΑΣ                                           
ΒΕΝΕΚΕΣ                                           
ΒΕΝΕΡΑΚΗΣ                                         
ΒΕΝΕΡΗΣ                                           
ΒΕΝΕΡΟΣ                                           
ΒΕΝΕΣΗΣ                                           
ΒΕΝΕΤΑΚΗΣ                                         
ΒΕΝΕΤΑΝΗΣ                                         
ΒΕΝΕΤΑΝΤΕΣ                                        
ΒΕΝΕΤΑΝΤΗΣ                                        
ΒΕΝΕΤΑΣ                                           
ΒΕΝΕΤΕΤΟΣ                                         
ΒΕΝΕΤΗΣ                                           
ΒΕΝΕΤΙΑΔΗΣ                                        
ΒΕΝΕΤΙΔΗΣ                                         
ΒΕΝΕΤΙΚΑΚΗΣ                                       
ΒΕΝΕΤΙΚΑΣ                                         
ΒΕΝΕΤΙΚΙΔΗΣ                                       
ΒΕΝΕΤΙΚΟΣ                                         
ΒΕΝΕΤΟΚΛΗΣ                                        
ΒΕΝΕΤΟΠΟΥΛΟΣ                                      
ΒΕΝΕΤΟΣ                                           
ΒΕΝΕΤΟΥΛΗΣ                                        
ΒΕΝΕΤΟΥΛΙΑΣ                                       
ΒΕΝΕΤΣΑΝΑΚΗΣ                                      
ΒΕΝΕΤΣΑΝΑΚΟΣ                                      
ΒΕΝΕΤΣΑΝΕΑΣ                                       
ΒΕΝΕΤΣΑΝΗΣ                                        
ΒΕΝΕΤΣΑΝΟΠΟΥΛΟΣ                                   
ΒΕΝΕΤΣΑΝΟΣ                                        
ΒΕΝΕΤΣΕΝΑΚΟΣ                                      
ΒΕΝΕΤΣΙΑΝΑΚΗΣ                                     
ΒΕΝΕΤΣΙΑΝΟΣ                                       
ΒΕΝΖΙΝΑΚΑΚΗΣ                                      
ΒΕΝΗΣ                                             
ΒΕΝΙΑΔΗΣ                                          
ΒΕΝΙΑΜΑΚΗΣ                                        
ΒΕΝΙΑΜΗΣ                                          
ΒΕΝΙΑΜΙΔΗΣ                                        
ΒΕΝΙΑΜΙΝΙΔΗΣ                                      
ΒΕΝΙΑΝΑΚΗΣ                                        
ΒΕΝΙΔΗΣ                                           
ΒΕΝΙΔΙΩΤΗΣ                                        
ΒΕΝΙΕΡΑΚΗΣ                                        
ΒΕΝΙΕΡΑΤΟΣ                                        
ΒΕΝΙΕΡΗΣ                                          
ΒΕΝΙΖΑΣ                                           
ΒΕΝΙΖΕΛΑΚΟΣ                                       
ΒΕΝΙΖΕΛΕΑΣ                                        
ΒΕΝΙΖΕΛΗΣ                                         
ΒΕΝΙΖΕΛΟΣ                                         
ΒΕΝΙΚΟΥΑΣ                                         
ΒΕΝΙΟΠΟΥΛΟΣ                                       
ΒΕΝΙΟΣ                                            
ΒΕΝΙΡΑΚΗΣ                                         
ΒΕΝΙΤΗΣ                                           
ΒΕΝΙΤΙΚΙΔΗΣ                                       
ΒΕΝΙΤΟΥΡΑΚΗΣ                                      
ΒΕΝΙΤΣΑΝΟΠΟΥΛΟΣ                                   
ΒΕΝΙΧΑΚΗΣ                                         
ΒΕΝΙΩΤΑΣ                                          
ΒΕΝΙΩΤΗΣ                                          
ΒΕΝΝΕΡΟΣ                                          
ΒΕΝΝΕΣ                                            
ΒΕΝΝΗΣ                                            
ΒΕΝΝΙΑΝΑΚΗΣ                                       
ΒΕΝΝΙΟΠΟΥΛΟΣ                                      
ΒΕΝΝΟΣ                                            
ΒΕΝΟΛΙΑΣ                                          
ΒΕΝΟΣ                                             
ΒΕΝΟΥΤΣΟΣ                                         
ΒΕΝΤΑΣ                                            
ΒΕΝΤΑΤ ΟΓΛΟΥ                                      
ΒΕΝΤΑΦΡΙΝΤΑΣ                                      
ΒΕΝΤΖΗΣ                                           
ΒΕΝΤΖΙΑΛΑΣ                                        
ΒΕΝΤΖΙΛΗΣ                                         
ΒΕΝΤΖΙΟΣ                                          
ΒΕΝΤΖΟΣ                                           
ΒΕΝΤΗΡΗΣ                                          
ΒΕΝΤΗΡΟΖΟΣ                                        
ΒΕΝΤΗΣ                                            
ΒΕΝΤΗΣΤΑΣ                                         
ΒΕΝΤΙΑΔΗΣ                                         
ΒΕΝΤΙΚΟΣ                                          
ΒΕΝΤΙΡΩΖΟΣ                                        
ΒΕΝΤΙΣΤΑΣ                                         
ΒΕΝΤΜΙΤΣ                                          
ΒΕΝΤΟΣ                                            
ΒΕΝΤΟΥΔΗΣ                                         
ΒΕΝΤΟΥΖΑΣ                                         
ΒΕΝΤΟΥΖΗΣ                                         
ΒΕΝΤΟΥΛΗΣ                                         
ΒΕΝΤΟΥΛΙΔΗΣ                                       
ΒΕΝΤΟΥΡΑΚΗΣ                                       
ΒΕΝΤΟΥΡΑΣ                                         
ΒΕΝΤΟΥΡΑΤΟΣ                                       
ΒΕΝΤΟΥΡΓΕΡΗΣ                                      
ΒΕΝΤΟΥΡΗΣ                                         
ΒΕΝΤΟΥΡΟΣ                                         
ΒΕΝΤΡΑΣ                                           
ΒΕΝΤΣΙΔΗΣ                                         
ΒΕΝΤΣΟΣ                                           
ΒΕΝΥΤΗΣ                                           
ΒΕΝΥΧΑΚΗΣ                                         
ΒΕΟΓΛΑΝΗΣ                                         
ΒΕΟΠΟΥΛΟΣ                                         
ΒΕΟΣ                                              
ΒΕΡΑΓΚΟΣ                                          
ΒΕΡΑΚΗΣ                                           
ΒΕΡΑΜΗΣ                                           
ΒΕΡΑΝ ΣΑΛΗ                                        
ΒΕΡΑΝΗΣ                                           
ΒΕΡΑΝΟΠΟΥΛΟΣ                                      
ΒΕΡΑΝΟΥΔΗΣ                                        
ΒΕΡΑΝΤΑΚΟΣ                                        
ΒΕΡΑΡΟΣ                                           
ΒΕΡΑΣ                                             
ΒΕΡΑΣΔΑΝΗΣ                                        
ΒΕΡΑΤΛΗΣ                                          
ΒΕΡΒΑΙΝΙΩΤΗΣ                                      
ΒΕΡΒΑΝΤΙΔΗΣ                                       
ΒΕΡΒΑΤΗΣ                                          
ΒΕΡΒΑΤΙΔΗΣ                                        
ΒΕΡΒΕΛΑΚΗΣ                                        
ΒΕΡΒΕΛΕΣ                                          
ΒΕΡΒΕΛΙΔΗΣ                                        
ΒΕΡΒΕΛΙΘΑΚΗΣ                                      
ΒΕΡΒΕΛΙΘΑΝΟΣ                                      
ΒΕΡΒΕΛΙΟΣ                                         
ΒΕΡΒΕΝΙΩΤΗΣ                                       
ΒΕΡΒΕΡΑΚΗΣ                                        
ΒΕΡΒΕΡΑΣ                                          
ΒΕΡΒΕΡΕΛΗΣ                                        
ΒΕΡΒΕΡΕΛΛΗΣ                                       
ΒΕΡΒΕΡΗΣ                                          
ΒΕΡΒΕΡΙΑΔΗΣ                                       
ΒΕΡΒΕΡΙΔΗΣ                                        
ΒΕΡΒΕΡΟΠΟΥΛΟΣ                                     
ΒΕΡΒΕΡΟΥΔΗΣ                                       
ΒΕΡΒΕΡΣΑΒΒΑΣ                                      
ΒΕΡΒΕΣΟΣ                                          
ΒΕΡΒΕΤΗΣ                                          
ΒΕΡΒΙΑΔΗΣ                                         
ΒΕΡΒΙΛΗΣ                                          
ΒΕΡΒΙΡΗΣ                                          
ΒΕΡΒΙΤΑΣ                                          
ΒΕΡΒΙΤΗΣ                                          
ΒΕΡΒΙΤΣΑΝΟΣ                                       
ΒΕΡΒΙΤΣΙΩΤΗΣ                                      
ΒΕΡΒΥΤΑΣ                                          
ΒΕΡΓΑΔΗΣ                                          
ΒΕΡΓΑΔΟΣ                                          
ΒΕΡΓΑΚΗΣ                                          
ΒΕΡΓΑΜΑΛΗΣ                                        
ΒΕΡΓΑΝΕΛΑΚΗΣ                                      
ΒΕΡΓΑΣ                                            
ΒΕΡΓΑΤΟΣ                                          
ΒΕΡΓΕΑΔΗΣ                                         
ΒΕΡΓΕΛΗΣ                                          
ΒΕΡΓΕΝΑΚΗΣ                                        
ΒΕΡΓΕΡΑΚΗΣ                                        
ΒΕΡΓΕΤΑΚΗΣ                                        
ΒΕΡΓΕΤΖΗΣ                                         
ΒΕΡΓΕΤΗΣ                                          
ΒΕΡΓΕΤΙΔΗΣ                                        
ΒΕΡΓΕΤΟΠΟΥΛΟΣ                                     
ΒΕΡΓΗΣ                                            
ΒΕΡΓΙΑΔΗΣ                                         
ΒΕΡΓΙΑΝΑΚΗΣ                                       
ΒΕΡΓΙΑΝΕΛΟΣ                                       
ΒΕΡΓΙΑΝΙΤΗΣ                                       
ΒΕΡΓΙΑΝΝΑΚΗΣ                                      
ΒΕΡΓΙΑΝΝΗΣ                                        
ΒΕΡΓΙΑΝΝΙΔΗΣ                                      
ΒΕΡΓΙΑΝΝΙΤΗΣ                                      
ΒΕΡΓΙΑΝΟΣ                                         
ΒΕΡΓΙΔΗΣ                                          
ΒΕΡΓΙΝΑΔΗΣ                                        
ΒΕΡΓΙΝΑΣ                                          
ΒΕΡΓΙΝΗΣ                                          
ΒΕΡΓΙΟΠΟΥΛΟΣ                                      
ΒΕΡΓΙΟΣ                                           
ΒΕΡΓΙΡΗΣ                                          
ΒΕΡΓΙΤΣΑΚΗΣ                                       
ΒΕΡΓΙΤΣΗΣ                                         
ΒΕΡΓΙΩΤΗΣ                                         
ΒΕΡΓΟΒΙΤΣ                                         
ΒΕΡΓΟΓΙΑΝΝΗΣ                                      
ΒΕΡΓΟΖΗΣΗΣ                                        
ΒΕΡΓΟΛΙΑΣ                                         
ΒΕΡΓΟΠΟΥΛΟΣ                                       
ΒΕΡΓΟΠΟΥΛΟΥ ΜΠΑΚΛΑΤΖΟΓΛΟΥ                         
ΒΕΡΓΟΣ                                            
ΒΕΡΓΟΤΙΔΗΣ                                        
ΒΕΡΓΟΥΔΗΣ                                         
ΒΕΡΓΟΥΛΑΚΗΣ                                       
ΒΕΡΓΟΥΛΑΣ                                         
ΒΕΡΓΟΥΛΗΣ                                         
ΒΕΡΓΟΥΛΙΑΔΗΣ                                      
ΒΕΡΓΟΥΛΙΑΣ                                        
ΒΕΡΓΟΥΛΙΔΗΣ                                       
ΒΕΡΓΟΥΛΛΗΣ                                        
ΒΕΡΓΟΥΝΗΣ                                         
ΒΕΡΓΟΥΡΟΣ                                         
ΒΕΡΓΥΡΗΣ                                          
ΒΕΡΓΩΝΗΣ                                          
ΒΕΡΓΩΤΗΣ                                          
ΒΕΡΔΑΡΗΣ                                          
ΒΕΡΔΕΓΚΑΣ                                         
ΒΕΡΔΕΛΗΣ                                          
ΒΕΡΔΕΛΛΗΣ                                         
ΒΕΡΔΕΣ                                            
ΒΕΡΔΕΣΗΣ                                          
ΒΕΡΔΕΣΟΠΟΥΛΟΣ                                     
ΒΕΡΔΗΛΟΣ                                          
ΒΕΡΔΗΣ                                            
ΒΕΡΔΙΑΚΗΣ                                         
ΒΕΡΔΙΚΟΠΛΗΣ                                       
ΒΕΡΔΙΝΑΚΗΣ                                        
ΒΕΡΔΟΣ                                            
ΒΕΡΔΟΥΚΑΣ                                         
ΒΕΡΔΟΥΛΗΣ                                         
ΒΕΡΕΒΗΣ                                           
ΒΕΡΕΚΕΤΗΣ                                         
ΒΕΡΕΚΟΣ                                           
ΒΕΡΕΛΗΣ                                           
ΒΕΡΕΜΗΣ                                           
ΒΕΡΕΝΑΚΗΣ                                         
ΒΕΡΕΝΗΣ                                           
ΒΕΡΕΝΙΔΗΣ                                         
ΒΕΡΕΝΤΖΗΣ                                         
ΒΕΡΕΝΤΖΙΩΤΗΣ                                      
ΒΕΡΕΡΑΚΗΣ                                         
ΒΕΡΕΡΟΥΔΑΚΗΣ                                      
ΒΕΡΕΣΕΣ                                           
ΒΕΡΕΣΕΤΖΙΔΗΣ                                      
ΒΕΡΕΣΟΓΛΑΚΗΣ                                      
ΒΕΡΕΤΑΝΟΣ                                         
ΒΕΡΕΤΕΚΝΙΔΗΣ                                      
ΒΕΡΕΤΙΜΗΣ                                         
ΒΕΡΕΤΣΟΣ                                          
ΒΕΡΕΤΤΑΣ                                          
ΒΕΡΖΑΜΑΝΗΣ                                        
ΒΕΡΖΑΝΛΗΣ                                         
ΒΕΡΖΑΤΟΣ                                          
ΒΕΡΖΟΒΙΔΗΣ                                        
ΒΕΡΖΟΒΙΤΗΣ                                        
ΒΕΡΖ                                              
ΒΕΡΗΣ                                             
ΒΕΡΙΒΑΚΗΣ                                         
ΒΕΡΙΒΙΑΔΗΣ                                        
ΒΕΡΙΓΑΚΗΣ                                         
ΒΕΡΙΓΚΑΣ                                          
ΒΕΡΙΓΟΣ                                           
ΒΕΡΙΔΑΚΗΣ                                         
ΒΕΡΙΚΑΚΗΣ                                         
ΒΕΡΙΚΕΤΗΣ                                         
ΒΕΡΙΚΗΣ                                           
ΒΕΡΙΚΙΟΣ                                          
ΒΕΡΙΚΟΚΟΣ                                         
ΒΕΡΙΚΟΥΚΗΣ                                        
ΒΕΡΙΛΛΗΣ                                          
ΒΕΡΙΟΠΟΥΛΟΣ                                       
ΒΕΡΙΟΣ                                            
ΒΕΡΙΣΟΓΛΑΚΗΣ                                      
ΒΕΡΙΤΣΗΣ                                          
ΒΕΡΙΩΝΗΣ                                          
ΒΕΡΙΩΤΗΣ                                          
ΒΕΡΛΕΚΗΣ                                          
ΒΕΡΛΕΤΑΣ                                          
ΒΕΡΛΕΤΗΣ                                          
ΒΕΡΛΗΣ                                            
ΒΕΡΛΙΓΚΑΣ                                         
ΒΕΡΛΙΟΣ                                           
ΒΕΡΛΟΥΤΗΣ                                         
ΒΕΡΜΕΖ                                            
ΒΕΡΜΕΣ                                            
ΒΕΡΜΙΔΗΣ                                          
ΒΕΡΜΙΣΣ                                           
ΒΕΡΜΙΣ                                            
ΒΕΡΜΠΕΛΗΣ                                         
ΒΕΡΜΠΗΣ                                           
ΒΕΡΝΑΔΑΚΗΣ                                        
ΒΕΡΝΑΔΕΣΚΗΣ                                       
ΒΕΡΝΑΔΟΣ                                          
ΒΕΡΝΑΡΔΑΚΗΣ                                       
ΒΕΡΝΑΡΔΗΣ                                         
ΒΕΡΝΑΡΔΟΣ                                         
ΒΕΡΝΑΡΛΗΣ                                         
ΒΕΡΝΕΖΗΣ                                          
ΒΕΡΝΕΖΟΣ                                          
ΒΕΡΝΗΣ                                            
ΒΕΡΝΙΔΑΚΗΣ                                        
ΒΕΡΝΙΚΙΩΤΗΣ                                       
ΒΕΡΝΙΚΟΣ                                          
ΒΕΡΝΙΩΤΗΣ                                         
ΒΕΡΝΤΖΑΓΙΑΣ                                       
ΒΕΡΟΓΚΟΣ                                          
ΒΕΡΟΖΙΝΗΣ                                         
ΒΕΡΟΖΟΥΜΠ                                         
ΒΕΡΟΙΟΠΟΥΛΟΣ                                      
ΒΕΡΟΙΩΤΗΣ                                         
ΒΕΡΟΝΙΚΗΣ                                         
ΒΕΡΟΝΙΚΙΑΤΗΣ                                      
ΒΕΡΟΠΛΙΔΗΣ                                        
ΒΕΡΟΠΟΥΛΙΔΗΣ                                      
ΒΕΡΟΠΟΥΛΟΣ                                        
ΒΕΡΟΣ                                             
ΒΕΡΟΥΔΑΚΗΣ                                        
ΒΕΡΟΥΚΑΣ                                          
ΒΕΡΟΥΚΗΣ                                          
ΒΕΡΟΥΛΗΣ                                          
ΒΕΡΟΥΝΤΗΣ                                         
ΒΕΡΟΥΣΗΣ                                          
ΒΕΡΟΥΤΑΣ                                          
ΒΕΡΟΥΤΗΣ                                          
ΒΕΡΟΥΤΣΟΣ                                         
ΒΕΡΟΥΧΗΣ                                          
ΒΕΡΡΑΡΟΣ                                          
ΒΕΡΡΑΣ                                            
ΒΕΡΡΗΣ                                            
ΒΕΡΡΙΟΠΟΥΛΟΣ                                      
ΒΕΡΡΟΙΑΣ                                          
ΒΕΡΡΟΙΟΠΟΥΛΟΣ                                     
ΒΕΡΡΟΙΟΣ                                          
ΒΕΡΡΟΙΩΤΗΣ                                        
ΒΕΡΡΟΠΟΥΛΟΣ                                       
ΒΕΡΡΟΣ                                            
ΒΕΡΣΑΚΗΣ                                          
ΒΕΡΣΑΚΟΣ                                          
ΒΕΡΣΑΛΗΣ                                          
ΒΕΡΣΗΣ                                            
ΒΕΡΣΟΚΟΛΙΔΗΣ                                      
ΒΕΡΤΑΛΙΔΗΣ                                        
ΒΕΡΤΑΣ                                            
ΒΕΡΤΕΓΚΟΣ                                         
ΒΕΡΤΕΛΗΣ                                          
ΒΕΡΤΕΛΛΗΣ                                         
ΒΕΡΤΕΟΥΡΗΣ                                        
ΒΕΡΤΖΑΓΙΑΣ                                        
ΒΕΡΤΖΑΗΣ                                          
ΒΕΡΤΖΕΒΟΥΛΙΑΣ                                     
ΒΕΡΤΖΙΖΗΣ                                         
ΒΕΡΤΖΙΝΗΣ                                         
ΒΕΡΤΖΟΒΙΤΗΣ                                       
ΒΕΡΤΖΟΣ                                           
ΒΕΡΤΖΩΝΗΣ                                         
ΒΕΡΤΗΣ                                            
ΒΕΡΤΙΚΟΠΛΗΣ                                       
ΒΕΡΤΚΑΣ                                           
ΒΕΡΤΟΔΟΥΛΟΣ                                       
ΒΕΡΤΟΠΟΥΛΟΣ                                       
ΒΕΡΤΟΣ                                            
ΒΕΡΤΟΥΔΑΚΗΣ                                       
ΒΕΡΤΟΥΔΟΣ                                         
ΒΕΡΤΟΥΜΗΣ                                         
ΒΕΡΤΣΕΚΟΣ                                         
ΒΕΡΤΣΕΤΗΣ                                         
ΒΕΡΤΣΙΩΝΗΣ                                        
ΒΕΡΤΣΙΩΤΗΣ                                        
ΒΕΡΤΣΩΝΗΣ                                         
ΒΕΡΥΒΑΚΗΣ                                         
ΒΕΡΥΓΑΚΗΣ                                         
ΒΕΡΥΚΑΚΗΣ                                         
ΒΕΡΥΚΑΚΙΣ                                         
ΒΕΡΥΚΙΟΣ                                          
ΒΕΡΥΚΚΟΚΟΣ                                        
ΒΕΡΥΚΟΚΑΚΗΣ                                       
ΒΕΡΥΚΟΚΙΔΗΣ                                       
ΒΕΡΥΚΟΚΚΑΚΗΣ                                      
ΒΕΡΥΚΟΚΚΟΣ                                        
ΒΕΡΥΚΟΚΟΣ                                         
ΒΕΡΥΚΟΥΚΗΣ                                        
ΒΕΡΥΚΟΥΚΙΑΣ                                       
ΒΕΡΩΝΑΣ                                           
ΒΕΡΩΝΗΣ                                           
ΒΕΣ                                               
ΒΕΣΑΛΑΣ                                           
ΒΕΣΔΕΚΗΣ                                          
ΒΕΣΔΡΑΒΑΝΗΣ                                       
ΒΕΣΔΡΕΒΑΝΗΣ                                       
ΒΕΣΕΛΕΜΕΣ                                         
ΒΕΣΕΛΙΝΟΒΙΤΣ                                      
ΒΕΣΕΞΙΔΗΣ                                         
ΒΕΣΗΣ                                             
ΒΕΣΙΡΗΣ                                           
ΒΕΣΙΡΟΠΟΥΛΟΣ                                      
ΒΕΣΚΑΣ                                            
ΒΕΣΚΟΣ                                            
ΒΕΣΚΟΥΚΗΣ                                         
ΒΕΣΛΕΜΕΣ                                          
ΒΕΣΜΕΛΗΣ                                          
ΒΕΣΠΑΧΑΣ                                          
ΒΕΣΣΑΛΑΣ                                          
ΒΕΣΣΗΣ                                            
ΒΕΣΣΟΣ                                            
ΒΕΣΤΑΚΗΣ                                          
ΒΕΣΤΑΡΚΗΣ                                         
ΒΕΣΤΑΡΧΗΣ                                         
ΒΕΣΤΗΣ                                            
ΒΕΣΤΙΑΡΗΣ                                         
ΒΕΣΥΡΗΣ                                           
ΒΕΣΥΡΟΠΟΥΛΟΣ                                      
ΒΕΤΑΣ                                             
ΒΕΤΗΣ                                             
ΒΕΤΙΔΗΣ                                           
ΒΕΤΙΜΗΣ                                           
ΒΕΤΚΑΣ                                            
ΒΕΤΛΗΣ                                            
ΒΕΤΟΠΟΥΛΟΣ                                        
ΒΕΤΟΣ                                             
ΒΕΤΟΥΛΑΔΙΤΗΣ                                      
ΒΕΤΟΥΛΑΚΗΣ                                        
ΒΕΤΟΥΛΑΣ                                          
ΒΕΤΟΥΛΗΣ                                          
ΒΕΤΣΑΣ                                            
ΒΕΤΣΕΡΗΣ                                          
ΒΕΤΣΕΡΙΔΗΣ                                        
ΒΕΤΣΗΣ                                            
ΒΕΤΣΙΚΑΣ                                          
ΒΕΤΣΙΚΟΠΟΥΛΟΣ                                     
ΒΕΤΣΙΚΟΣ                                          
ΒΕΤΣΙΝΟΥΡΗΣ                                       
ΒΕΤΣΙΟΣ                                           
ΒΕΤΣΙΩΑΝΝΙΔΗΣ                                     
ΒΕΤΣΟΠΟΥΛΟΣ                                       
ΒΕΤΣΟΣ                                            
ΒΕΤΤΑΣ                                            
ΒΕΤΤΗΣ                                            
ΒΕΤΤΟΣ                                            
ΒΕΧΙΛΗΣ                                           
ΒΕΧΛΙΒΑΝΟΣ                                        
ΒΕΧΛΙΔΗΣ                                          
ΒΕΧΜΠΗ ΟΓΛΟΥ                                      
ΒΕΧΠΗ ΟΓΛΟΥ                                       
ΒΕΧΤΣΑΛΗΣ                                         
ΒΖΙΒΖΗΣ                                           
ΒΗΔΑΣ                                             
ΒΗΔΗΝΟΠΟΥΛΟΣ                                      
ΒΗΘΛΕΕΜΙΔΗΣ                                       
ΒΗΚΑΣ                                             
ΒΗΚΟΣ                                             
ΒΗΛΑΡΑΣ                                           
ΒΗΛΙΟΣ                                            
ΒΗΛΛΟΣ                                            
ΒΗΛΟΣ                                             
ΒΗΡΙΔΗΣ                                           
ΒΗΣΑΡΗΣ                                           
ΒΗΣΑΡΙΤΗΣ                                         
ΒΗΣΑΡΟΠΟΥΛΟΣ                                      
ΒΗΣΣΑΡΑΚΗΣ                                        
ΒΗΣΣΑΡΑΚΟΣ                                        
ΒΗΣΣΑΡΙΔΗΣ                                        
ΒΗΣΣΑΡΙΤΗΣ                                        
ΒΗΣΣΑΡΟΠΟΥΛΟΣ                                     
ΒΗΤΑΣ                                             
ΒΗΤΗΣ                                             
ΒΗΤΟΒΑΡΗΣ                                         
ΒΗΤΟΠΟΥΛΟΣ                                        
ΒΗΤΟΣ                                             
ΒΗΤΟΥΡΑΤΟΣ                                        
ΒΗΤΤΑΣ                                            
ΒΗΤΤΟΣ                                            
ΒΗΧΑΣ                                             
ΒΗΧΟΣ                                             
ΒΗΧΟΥΔΗΣ                                          
ΒΙΑΓΚΙΝΗΣ                                         
ΒΙΑΔΗΣ                                            
ΒΙΑΖΗΣ                                            
ΒΙΑΝΑΣ                                            
ΒΙΑΝΕΛΛΗΣ                                         
ΒΙΑΝΙΤΑΚΗΣ                                        
ΒΙΑΝΝΗΣ                                           
ΒΙΑΝΝΙΤΑΚΗΣ                                       
ΒΙΑΝΟΣ                                            
ΒΙΑΡΟΠΟΥΛΟΣ                                       
ΒΙΑΡΟΣ                                            
ΒΙΑΡΡΟΣ                                           
ΒΙΑΣΤΙΚΟΠΟΥΛΟΣ                                    
ΒΙΒΑΝΤΕΣ                                          
ΒΙΒΑΣ                                             
ΒΙΒΕΛΗΣ                                           
ΒΙΒΕΣ                                             
ΒΙΒΗΣ                                             
ΒΙΒΙΚΙΔΗΣ                                         
ΒΙΒΙΛΑΚΗΣ                                         
ΒΙΒΛΑΚΗΣ                                          
ΒΙΒΛΙΟΔΕΤΗΣ                                       
ΒΙΒΛΙΟΣ                                           
ΒΙΒΛΙΩΤΗΣ                                         
ΒΙΒΟΣ                                             
ΒΙΒΡΟΠΟΥΛΟΣ                                       
ΒΙΒΤΑΣ                                            
ΒΙΓΓΑΣ                                            
ΒΙΓΓΛΑΣ                                           
ΒΙΓΓΟΠΟΥΛΟΣ                                       
ΒΙΓΓΟΣ                                            
ΒΙΓΔΙΔΕΛΗΣ                                        
ΒΙΓΔΙΝΑΚΗΣ                                        
ΒΙΓΕΛΛΗΣ                                          
ΒΙΓΕΣ                                             
ΒΙΓΙΚΑΚΗΣ                                         
ΒΙΓΚΑΚΗΣ                                          
ΒΙΓΚΑΣ                                            
ΒΙΓΚΛΑΣ                                           
ΒΙΓΚΛΗΣ                                           
ΒΙΓΚΛΙΑΡΗΣ                                        
ΒΙΓΚΟΠΟΥΛΟΣ                                       
ΒΙΓΚΟΣ                                            
ΒΙΓΛΑΚΗΣ                                          
ΒΙΓΛΑΝΤΖΗΣ                                        
ΒΙΓΛΑΣ                                            
ΒΙΓΛΑΤΖΗΣ                                         
ΒΙΓΛΗΣ                                            
ΒΙΓΛΙΑΡΗΣ                                         
ΒΙΓΛΙΡΑΚΗΣ                                        
ΒΙΔΑΚΗΣ                                           
ΒΙΔΑΛΑΚΗΣ                                         
ΒΙΔΑΛΗΣ                                           
ΒΙΔΑΝΟΠΟΥΛΟΣ                                      
ΒΙΔΑΡΗΣ                                           
ΒΙΔΑΣ                                             
ΒΙΔΗΣ                                             
ΒΙΔΙΑΔΑΚΗΣ                                        
ΒΙΔΙΑΚΙΤΗΣ                                        
ΒΙΔΙΑΝΟΣ                                          
ΒΙΔΙΜΗΣ                                           
ΒΙΔΙΝΗΣ                                           
ΒΙΔΙΝΙΩΤΗΣ                                        
ΒΙΔΙΝΟΠΟΥΛΟΣ                                      
ΒΙΔΙΡΙΚΗΣ                                         
ΒΙΔΟΒΑΡΗΣ                                         
ΒΙΔΟΖΑΧΑΡΑΚΗΣ                                     
ΒΙΔΟΠΟΥΛΟΣ                                        
ΒΙΔΟΣ                                             
ΒΙΔΟΥΡΑΣ                                          
ΒΙΔΟΥΡΗΣ                                          
ΒΙΔΡΑΣ                                            
ΒΙΔΡΟΣ                                            
ΒΙΔΩΡΗΣ                                           
ΒΙΕΙΡΑ ΝΤΑ ΣΙΛΒΑ ΝΤΑΟΤΡΟ                          
ΒΙΕΝΑΣ                                            
ΒΙΕΝΝΑΚΟΣ                                         
ΒΙΕΝΝΑΣ                                           
ΒΙΕΝΟΠΟΥΛΟΣ                                       
ΒΙΕΡΑΚΗΣ                                          
ΒΙΕΡΗΣ                                            
ΒΙΕΡΟΣ                                            
ΒΙΕΡΡΟΣ                                           
ΒΙΕΣ                                              
ΒΙΖΑΚΟΠΟΥΛΟΣ                                      
ΒΙΖΒΙΖΗΣ                                          
ΒΙΖΒΙΚΗΣ                                          
ΒΙΖΓΑΣ                                            
ΒΙΖΕΛΗΣ                                           
ΒΙΖΗΛΗΣ                                           
ΒΙΖΗΡΑΚΗΣ                                         
ΒΙΖΙΝΤΗΣ                                          
ΒΙΖΙΡΑΚΗΣ                                         
ΒΙΖΙΡΓΙΑΝΑΚΗΣ                                     
ΒΙΖΙΡΙΑΝΝΑΚΗΣ                                     
ΒΙΖΙΡΙΔΗΣ                                         
ΒΙΖΙΩΤΗΣ                                          
ΒΙΖΜΠΑΣ                                           
ΒΙΖΟΛΙΔΗΣ                                         
ΒΙΖΟΣ                                             
ΒΙΖΟΥΡΗΣ                                          
ΒΙΖΥΗΝΟΣ                                          
ΒΙΖΥΡΑΚΗΣ                                         
ΒΙΘΥΝΟΣ                                           
ΒΙΚΑΣ                                             
ΒΙΚΑΤΟΣ                                           
ΒΙΚΕΛΑΣ                                           
ΒΙΚΕΛΗΣ                                           
ΒΙΚΕΛΙΔΗΣ                                         
ΒΙΚΕΛΟΥΔΑΣ                                        
ΒΙΚΕΛΟΥΔΗΣ                                        
ΒΙΚΕΝΤΙΟΣ                                         
ΒΙΚΕΤΟΣ                                           
ΒΙΚΗΣ                                             
ΒΙΚΙΑΡΗΣ                                          
ΒΙΚΙΑΣ                                            
ΒΙΚΙΩΤΗΣ                                          
ΒΙΚΟΠΟΥΛΟΣ                                        
ΒΙΚΟΣ                                             
ΒΙΚΡΟΠΟΥΛΟΣ                                       
ΒΙΚΤΟΡΙΔΗΣ                                        
ΒΙΚΤΩΡΑΣ                                          
ΒΙΚΤΩΡΑΤΟΣ                                        
ΒΙΚΤΩΡΙΑΔΗΣ                                       
ΒΙΚΤΩΡΙΔΗΣ                                        
ΒΙΚΤΩΡΙΟΣ                                         
ΒΙΚΤΩΡΟΣ                                          
ΒΙΛΑΔΕΡΗΣ                                         
ΒΙΛΑΕΤΗΣ                                          
ΒΙΛΑΖΕΡΟΠΟΥΛΟΣ                                    
ΒΙΛΑΚΟΣ                                           
ΒΙΛΑΝΑΚΗΣ                                         
ΒΙΛΑΝΔΟΣ                                          
ΒΙΛΑΝΟΣ                                           
ΒΙΛΑΝΤΖΑΚΗΣ                                       
ΒΙΛΑΝΤΩΝΗΣ                                        
ΒΙΛΑΠΛΑΓΚΑΣ                                       
ΒΙΛΑΣ                                             
ΒΙΛΑΩΡΑΣ                                          
ΒΙΛΑΩΡΗΣ                                          
ΒΙΛΔΕΡΗΣ                                          
ΒΙΛΔΙΡΗΣ                                          
ΒΙΛΔΙΡΙΔΗΣ                                        
ΒΙΛΔΟΣ                                            
ΒΙΛΕΛΗΣ                                           
ΒΙΛΗΣ                                             
ΒΙΛΙΑΓΚΑΣ                                         
ΒΙΛΙΑΝΙΩΤΗΣ                                       
ΒΙΛΙΑΡΔΟΣ                                         
ΒΙΛΙΑΣ                                            
ΒΙΛΙΣΚΟΣ                                          
ΒΙΛΙΤΣΚΟΣ                                         
ΒΙΛΙΩΤΗΣ                                          
ΒΙΛΛΑΝΤΖΑΚΗΣ                                      
ΒΙΛΛΑΣ                                            
ΒΙΛΛΕΜΣ                                           
ΒΙΛΛΗΣ                                            
ΒΙΛΛΙΑΣ                                           
ΒΙΛΛΙΟΣ                                           
ΒΙΛΛΙΩΤΗΣ                                         
ΒΙΛΛΜΣ                                            
ΒΙΛΜΕΖΗΣ                                          
ΒΙΛΝΤΙΡΗΣ                                         
ΒΙΛΟΥΡΑΣ                                          
ΒΙΛΤΑΝΙΩΤΗΣ                                       
ΒΙΜΠΛΗΣ                                           
ΒΙΝΑΚΟΣ                                           
ΒΙΝΑΣ                                             
ΒΙΝΑΤΣΕΛΑΣ                                        
ΒΙΝΓΚΣ                                            
ΒΙΝΔΕΝΑΣ                                          
ΒΙΝΕΣ                                             
ΒΙΝΗΡΗΣ                                           
ΒΙΝΗΣ                                             
ΒΙΝΙΑΔΗΣ                                          
ΒΙΝΙΑΣ                                            
ΒΙΝΙΕΡΑΤΟΣ                                        
ΒΙΝΙΕΡΗΣ                                          
ΒΙΝΙΟΣ                                            
ΒΙΝΙΡΗΣ                                           
ΒΙΝΙΤΗΚΙΔΗΣ                                       
ΒΙΝΙΧΑΚΗΣ                                         
ΒΙΝΝΗΣ                                            
ΒΙΝΟΣ                                             
ΒΙΝΤΖΗΛΑΙΟΣ                                       
ΒΙΝΤΖΗΣ                                           
ΒΙΝΤΖΙΛΑΙΟΣ                                       
ΒΙΝΤΖΙΛΕΟΣ                                        
ΒΙΝΤΙΑΔΗΣ                                         
ΒΙΝΤΙΛΗ ΙΣΜΑΗΛ                                    
ΒΙΝΤΙΝΗΣ                                          
ΒΙΝΤΙΤΣ                                           
ΒΙΝΤΟΣ                                            
ΒΙΝΤΣΕΝΤΣΟΣ                                       
ΒΙΝΤΣΗΣ                                           
ΒΙΝΤΣΟΣ                                           
ΒΙΝΤΩΚΗΣ                                          
ΒΙΝΥΧΑΚΗΣ                                         
ΒΙΟΛΑΚΗΣ                                          
ΒΙΟΛΑΝΤΖΗΣ                                        
ΒΙΟΛΑΝΤΗΣ                                         
ΒΙΟΛΑΡΗΣ                                          
ΒΙΟΛΑΤΖΗΣ                                         
ΒΙΟΛΑΤΟΣ                                          
ΒΙΟΛΕΝΤΗΣ                                         
ΒΙΟΛΕΣΤΗΣ                                         
ΒΙΟΛΕΤΗΣ                                          
ΒΙΟΛΕΤΤΑΣ                                         
ΒΙΟΛΗΣ                                            
ΒΙΟΛΙΔΑΚΗΣ                                        
ΒΙΟΛΙΔΗΣ                                          
ΒΙΟΛΙΝΤΖΗΣ                                        
ΒΙΟΛΙΣΤΗΣ                                         
ΒΙΟΛΙΤΖΗΣ                                         
ΒΙΟΛΙΤΖΟΠΟΥΛΟΣ                                    
ΒΙΟΛΝΤΖΗΣ                                         
ΒΙΟΛΟΣ                                            
ΒΙΟΛΤΖΗΣ                                          
ΒΙΟΝΙΔΗΣ                                          
ΒΙΟΠΟΥΛΟΣ                                         
ΒΙΟΡΕΣ                                            
ΒΙΟΡΡΕΣ                                           
ΒΙΟΣ                                              
ΒΙΡΑΝΗΣ                                           
ΒΙΡΑΣ                                             
ΒΙΡΒΗΛΟΣ                                          
ΒΙΡΒΙΔΑΚΗΣ                                        
ΒΙΡΒΙΛΗΣ                                          
ΒΙΡΒΙΛΙΔΗΣ                                        
ΒΙΡΒΙΛΙΟΣ                                         
ΒΙΡΒΙΛΛΗΣ                                         
ΒΙΡΒΙΡΟΠΟΥΛΟΣ                                     
ΒΙΡΒΟΥΤΣΑΚΗΣ                                      
ΒΙΡΒΟΥΤΣΟΥΚΗΣ                                     
ΒΙΡΙΔΑΚΗΣ                                         
ΒΙΡΙΔΗΣ                                           
ΒΙΡΙΡΑΚΗΣ                                         
ΒΙΡΛΑΣ                                            
ΒΙΡΛΗΣ                                            
ΒΙΡΤΣ                                             
ΒΙΡΤΣΙΩΝΗΣ                                        
ΒΙΡΤΣΩΝΗΣ                                         
ΒΙΣ                                               
ΒΙΣΑΚΗΣ                                           
ΒΙΣΑΞΗΣ                                           
ΒΙΣΒΑΡΔΗΣ                                         
ΒΙΣΒΑΣΟΠΟΥΛΟΣ                                     
ΒΙΣΒΗΣ                                            
ΒΙΣΒΙΖΗΣ                                          
ΒΙΣΒΙΚΗΣ                                          
ΒΙΣΒΙΚΟΣ                                          
ΒΙΣΒΙΝΗΣ                                          
ΒΙΣΒΙΡΟΠΟΥΛΟΣ                                     
ΒΙΣΕΡΗΣ                                           
ΒΙΣΙΛΙΑΣ                                          
ΒΙΣΚΑΔΟΥΡΑΚΗΣ                                     
ΒΙΣΚΑΔΟΥΡΟΣ                                       
ΒΙΣΚΑΣ                                            
ΒΙΣΚΟΒΙΤΣ                                         
ΒΙΣΚΟΣ                                            
ΒΙΣΜΠΑΣ                                           
ΒΙΣΝΑΣ                                            
ΒΙΣΟΚΑΛΗΣ                                         
ΒΙΣΣΑΡΗΣ                                          
ΒΙΣΣΙΑΣ                                           
ΒΙΣΤΑΓΙΑΝΝΑΚΗΣ                                    
ΒΙΣΤΑΚΗΣ                                          
ΒΙΣΤΑΚΙΣ                                          
ΒΙΣΤΑΣ                                            
ΒΙΣΤΗΣ                                            
ΒΙΤΑΚΗΣ                                           
ΒΙΤΑΛΑΚΗΣ                                         
ΒΙΤΑΛΗΣ                                           
ΒΙΤΑΛΙΩΤΗΣ                                        
ΒΙΤΑΝΗΣ                                           
ΒΙΤΑΝΙΔΗΣ                                         
ΒΙΤΑΝΙΩΤΗΣ                                        
ΒΙΤΑΝΟΠΟΥΛΟΣ                                      
ΒΙΤΑΝΟΣ                                           
ΒΙΤΑΝΤΖΑΚΗΣ                                       
ΒΙΤΑΣΙΝΟΣ                                         
ΒΙΤΑΣΚΟΣ                                          
ΒΙΤΑΣΤΑΛΗΣ                                        
ΒΙΤΑΣΤΙΝΟΣ                                        
ΒΙΤΕΒΗΣ                                           
ΒΙΤΕΛΗΣ                                           
ΒΙΤΕΛΛΑΣ                                          
ΒΙΤΕΝΤΖΑΚΗΣ                                       
ΒΙΤΕΤΖΑΚΗΣ                                        
ΒΙΤΖΕΚΑΣ                                          
ΒΙΤΖΗΛΑΙΟΣ                                        
ΒΙΤΖΗΛΟΣ                                          
ΒΙΤΖΙΛΑΙΟΣ                                        
ΒΙΤΖΙΤΖΑΝΗΣ                                       
ΒΙΤΗΣ                                             
ΒΙΤΙΑΔΗΣ                                          
ΒΙΤΙΝΙΩΤΗΣ                                        
ΒΙΤΚΑΣ                                            
ΒΙΤΚΟΣ                                            
ΒΙΤΛΑΡΗΣ                                          
ΒΙΤΛΗΣ                                            
ΒΙΤΟΓΙΑΝΝΗΣ                                       
ΒΙΤΟΛΑΡΗΣ                                         
ΒΙΤΟΛΙΑΝΟΣ                                        
ΒΙΤΟΛΙΔΗΣ                                         
ΒΙΤΟΠΟΥΛΟΣ                                        
ΒΙΤΟΡΟΠΟΥΛΟΣ                                      
ΒΙΤΟΣ                                             
ΒΙΤΟΥΛΑΔΙΤΗΣ                                      
ΒΙΤΟΥΛΑΣ                                          
ΒΙΤΟΥΛΗΣ                                          
ΒΙΤΟΥΝΗΣ                                          
ΒΙΤΣΑΔΑΚΗΣ                                        
ΒΙΤΣΑΚΑΣ                                          
ΒΙΤΣΑΚΗΣ                                          
ΒΙΤΣΑΚΤΣΗΣ                                        
ΒΙΤΣΑΞΑΚΗΣ                                        
ΒΙΤΣΑΞΗΣ                                          
ΒΙΤΣΑΡΑΣ                                          
ΒΙΤΣΑΡΗΣ                                          
ΒΙΤΣΑΡΙΔΗΣ                                        
ΒΙΤΣΑΡΟΠΟΥΛΟΣ                                     
ΒΙΤΣΑΣ                                            
ΒΙΤΣΕΛΑΣ                                          
ΒΙΤΣΕΛΗΣ                                          
ΒΙΤΣΕΝΤΖΑΚΗΣ                                      
ΒΙΤΣΕΝΤΖΑΤΟΣ                                      
ΒΙΤΣΕΝΤΖΟΣ                                        
ΒΙΤΣΕΝΤΙΝΗΣ                                       
ΒΙΤΣΕΝΤΟΣ                                         
ΒΙΤΣΕΝΤΣΑΤΟΣ                                      
ΒΙΤΣΕΝΤΣΟΣ                                        
ΒΙΤΣΕΤΖΑΤΟΣ                                       
ΒΙΤΣΕΤΣΑΝΤΟΣ                                      
ΒΙΤΣΗΣ                                            
ΒΙΤΣΙΚΑΝΟΣ                                        
ΒΙΤΣΙΚΑΣ                                          
ΒΙΤΣΙΚΟΥΝΑΚΗΣ                                     
ΒΙΤΣΙΛΑΚΗΣ                                        
ΒΙΤΣΙΛΗΣ                                          
ΒΙΤΣΙΛΟΓΙΑΝΝΗΣ                                    
ΒΙΤΣΙΟΣ                                           
ΒΙΤΣΙΡΗΣ                                          
ΒΙΤΣΙΩΤΗΣ                                         
ΒΙΤΣΟΒΙΤΣ                                         
ΒΙΤΣΟΣ                                            
ΒΙΤΣΟΥΝΗΣ                                         
ΒΙΤΤΑΚΗΣ                                          
ΒΙΤΤΗΣ                                            
ΒΙΤΤΩΡΑΚΗΣ                                        
ΒΙΤΤΩΡΑΤΟΣ                                        
ΒΙΤΤΩΡΗΣ                                          
ΒΙΤΤΩΡΙΑΣ                                         
ΒΙΤΤΩΡΙΟΣ                                         
ΒΙΤΤΩΡΟΥΛΗΣ                                       
ΒΙΤΩΛΙΑΝΟΣ                                        
ΒΙΤΩΡΑΚΗΣ                                         
ΒΙΤΩΡΑΤΟΣ                                         
ΒΙΤΩΡΗΣ                                           
ΒΙΤΩΡΙΟΣ                                          
ΒΙΤΩΡΟΣ                                           
ΒΙΤΩΡΟΥΛΗΣ                                        
ΒΙΩΚΑΚΗΣ                                          
ΒΙΩΝΗΣ                                            
ΒΛΑΒΑΚΗΣ                                          
ΒΛΑΒΗΣ                                            
ΒΛΑΒΙΑΝΟΣ                                         
ΒΛΑΒΟΓΕΛΑΚΗΣ                                      
ΒΛΑΒΟΓΙΛΑΚΗΣ                                      
ΒΛΑΓΓΑΣ                                           
ΒΛΑΓΓΟΣ                                           
ΒΛΑΓΚΑΚΟΣ                                         
ΒΛΑΓΚΑΣ                                           
ΒΛΑΓΚΟΓΙΑΣ                                        
ΒΛΑΓΚΟΠΟΥΛΟΣ                                      
ΒΛΑΓΚΟΣ                                           
ΒΛΑΓΚΟΥΛΗΣ                                        
ΒΛΑΓΟΙΔΗΣ                                         
ΒΛΑΔΕΜΗΣ                                          
ΒΛΑΔΕΝΗΣ                                          
ΒΛΑΔΕΝΙΔΗΣ                                        
ΒΛΑΔΕΣ                                            
ΒΛΑΔΗΚΑΣ                                          
ΒΛΑΔΗΜΗΡΟΣ                                        
ΒΛΑΔΙΚΑΣ                                          
ΒΛΑΔΙΜΗΡΙΔΗΣ                                      
ΒΛΑΔΙΜΗΡΟΒΙΤΣ                                     
ΒΛΑΔΙΜΗΡΟΣ                                        
ΒΛΑΔΙΝΟΒΙΤΣ                                       
ΒΛΑΔΙΤΣΗΣ                                         
ΒΛΑΔΟΒΙΤΗΣ                                        
ΒΛΑΔΟΣ                                            
ΒΛΑΔΟΥΛΑΚΗΣ                                       
ΒΛΑΖΑΚΗΣ                                          
ΒΛΑΙΔΗΣ                                           
ΒΛΑΙΚΙΔΗΣ                                         
ΒΛΑΙΚΟΣ                                           
ΒΛΑΙΚΟΥΔΗΣ                                        
ΒΛΑΚΟΣ                                            
ΒΛΑΜΑΚΗΣ                                          
ΒΛΑΜΗΣ                                            
ΒΛΑΜΙΔΗΣ                                          
ΒΛΑΜΟΠΟΥΛΟΣ                                       
ΒΛΑΜΟΣ                                            
ΒΛΑΜΟΥΛΗΣ                                         
ΒΛΑΜΠΕΖΑΚΗΣ                                       
ΒΛΑΝΔΟΣ                                           
ΒΛΑΝΗΣ                                            
ΒΛΑΝΙΑΔΗΣ                                         
ΒΛΑΝΙΔΗΣ                                          
ΒΛΑΝΟΠΟΥΛΟΣ                                       
ΒΛΑΝΟΣ                                            
ΒΛΑΝΤΑΚΗΣ                                         
ΒΛΑΝΤΑΡΙΔΗΣ                                       
ΒΛΑΝΤΑΡΙΤΗΣ                                       
ΒΛΑΝΤΑΣ                                           
ΒΛΑΝΤΕΝΙΔΗΣ                                       
ΒΛΑΝΤΗΣ                                           
ΒΛΑΝΤΙΔΗΣ                                         
ΒΛΑΝΤΙΚΑΣ                                         
ΒΛΑΝΤΟΣ                                           
ΒΛΑΝΤΟΥΣΗΣ                                        
ΒΛΑΝΤΟΥΤΣ                                         
ΒΛΑΝΤΩΝΗΣ                                         
ΒΛΑΝΤΩΝΟΠΟΥΛΟΣ                                    
ΒΛΑΡΑΣ                                            
ΒΛΑΣΑΚΑΚΗΣ                                        
ΒΛΑΣΑΚΗΣ                                          
ΒΛΑΣΑΚΙΔΗΣ                                        
ΒΛΑΣΑΚΟΣ                                          
ΒΛΑΣΑΚΟΥΔΗΣ                                       
ΒΛΑΣΕΡΟΣ                                          
ΒΛΑΣΗΣ                                            
ΒΛΑΣΙΑΔΗΣ                                         
ΒΛΑΣΙΔΗΣ                                          
ΒΛΑΣΙΟΣ                                           
ΒΛΑΣΙΣ                                            
ΒΛΑΣΙΩΤΗΣ                                         
ΒΛΑΣΚΗΣ                                           
ΒΛΑΣΚΙΔΗΣ                                         
ΒΛΑΣΚΟΣ                                           
ΒΛΑΣΟΓΙΑΝΝΗΣ                                      
ΒΛΑΣΟΠΟΥΛΟΣ                                       
ΒΛΑΣΣΑΚΗΣ                                         
ΒΛΑΣΣΑΣ                                           
ΒΛΑΣΣΗΣ                                           
ΒΛΑΣΣΙΩΤΗΣ                                        
ΒΛΑΣΣΟΠΟΥΛΟΣ                                      
ΒΛΑΣΤΑΚΗΣ                                         
ΒΛΑΣΤΑΡΑΚΗΣ                                       
ΒΛΑΣΤΑΡΑΚΟΣ                                       
ΒΛΑΣΤΑΡΑΣ                                         
ΒΛΑΣΤΑΡΗΣ                                         
ΒΛΑΣΤΑΡΙΔΗΣ                                       
ΒΛΑΣΤΕΛΙΤΣΙΤΣ                                     
ΒΛΑΣΤΕΛΛΗΣ                                        
ΒΛΑΣΤΟΠΟΥΛΟΣ                                      
ΒΛΑΣΤΟΣ                                           
ΒΛΑΣΤΟΥΔΑΚΗΣ                                      
ΒΛΑΤΑΚΗΣ                                          
ΒΛΑΤΑΝΗΣ                                          
ΒΛΑΤΑΣ                                            
ΒΛΑΤΗΣ                                            
ΒΛΑΤΙΤΣΗΣ                                         
ΒΛΑΤΣΑΣ                                           
ΒΛΑΤΣΕΑΣ                                          
ΒΛΑΤΣΙΟΣ                                          
ΒΛΑΤΣΙΩΤΗΣ                                        
ΒΛΑΤΤΑΣ                                           
ΒΛΑΧΑΒΑΣ                                          
ΒΛΑΧΑΓΓΕΛΗΣ                                       
ΒΛΑΧΑΔΑΜΗΣ                                        
ΒΛΑΧΑΔΗΣ                                          
ΒΛΑΧΑΙΤΗΣ                                         
ΒΛΑΧΑΚΗΣ                                          
ΒΛΑΧΑΚΟΣ                                          
ΒΛΑΧΑΝΑΣΤΑΣΗΣ                                     
ΒΛΑΧΑΝΔΡΕΑΣ                                       
ΒΛΑΧΑΝΤΩΝΗΣ                                       
ΒΛΑΧΑΣ                                            
ΒΛΑΧΑΤΗΣ                                          
ΒΛΑΧΑΤΣΗΣ                                         
ΒΛΑΧΑΤΣΙΟΣ                                        
ΒΛΑΧΑΤΣΟΣ                                         
ΒΛΑΧΒΕΗΣ                                          
ΒΛΑΧΕΑΣ                                           
ΒΛΑΧΙΑΝΟΣ                                         
ΒΛΑΧΙΑΣ                                           
ΒΛΑΧΙΔΗΣ                                          
ΒΛΑΧΙΝΟΣ                                          
ΒΛΑΧΙΩΤΗΣ                                         
ΒΛΑΧΛΗΣ                                           
ΒΛΑΧΜΠΕΗΣ                                         
ΒΛΑΧΟΒΑΣΙΛΗΣ                                      
ΒΛΑΧΟΒΙΤΣ                                         
ΒΛΑΧΟΓΕΝΗΣ                                        
ΒΛΑΧΟΓΕΩΡΓΑΚΗΣ                                    
ΒΛΑΧΟΓΕΩΡΓΑΚΟΠΟΥΛΟΣ                               
ΒΛΑΧΟΓΕΩΡΓΗΣ                                      
ΒΛΑΧΟΓΕΩΡΓΟΣ                                      
ΒΛΑΧΟΓΙΑΝΑΚΗΣ                                     
ΒΛΑΧΟΓΙΑΝΝΑΚΗΣ                                    
ΒΛΑΧΟΓΙΑΝΝΑΚΟΣ                                    
ΒΛΑΧΟΓΙΑΝΝΑΤΟΣ                                    
ΒΛΑΧΟΓΙΑΝΝΗΣ                                      
ΒΛΑΧΟΓΙΑΝΝΟΠΟΥΛΟΣ                                 
ΒΛΑΧΟΓΙΝΝΗΣ                                       
ΒΛΑΧΟΓΙΩΡΓΗΣ                                      
ΒΛΑΧΟΓΙΩΡΓΟΣ                                      
ΒΛΑΧΟΓΚΟΥΝΤΗΣ                                     
ΒΛΑΧΟΔΗΜΑΣ                                        
ΒΛΑΧΟΔΗΜΗΤΡΑΚΟΣ                                   
ΒΛΑΧΟΔΗΜΗΤΡΗΣ                                     
ΒΛΑΧΟΔΗΜΗΤΡΟΠΟΥΛΟΣ                                
ΒΛΑΧΟΔΗΜΟΣ                                        
ΒΛΑΧΟΔΙΑΜΑΝΤΗΣ                                    
ΒΛΑΧΟΔΙΟΝΥΣΟΠΟΥΛΟΣ                                
ΒΛΑΧΟΘΑΝΑΣΗΣ                                      
ΒΛΑΧΟΘΕΟΔΩΡΟΣ                                     
ΒΛΑΧΟΚΑΚΑΒΟΣ                                      
ΒΛΑΧΟΚΥΡΙΑΖΗΣ                                     
ΒΛΑΧΟΚΥΡΙΑΚΟΣ                                     
ΒΛΑΧΟΚΩΝΣΤΑΝΤΗΣ                                   
ΒΛΑΧΟΚΩΣΤΑΣ                                       
ΒΛΑΧΟΛΙΑΣ                                         
ΒΛΑΧΟΜΗΤΡΟΣ                                       
ΒΛΑΧΟΜΙΧΑΛΗΣ                                      
ΒΛΑΧΟΝΑΣΙΟΣ                                       
ΒΛΑΧΟΝΑΤΣΙΟΣ                                      
ΒΛΑΧΟΝΙΚΟΛΑΣ                                      
ΒΛΑΧΟΝΙΚΟΛΕΑΣ                                     
ΒΛΑΧΟΝΙΚΟΛΗΣ                                      
ΒΛΑΧΟΝΙΚΟΛΟΠΟΥΛΟΣ                                 
ΒΛΑΧΟΝΙΚΟΛΟΣ                                      
ΒΛΑΧΟΠΑΝΑΓΙΩΤΗΣ                                   
ΒΛΑΧΟΠΑΝΑΓΟΣ                                      
ΒΛΑΧΟΠΑΝΟΣ                                        
ΒΛΑΧΟΠΙΩΤΗΣ                                       
ΒΛΑΧΟΠΟΥΛΙΩΤΗΣ                                    
ΒΛΑΧΟΠΟΥΛΟΣ                                       
ΒΛΑΧΟΣ                                            
ΒΛΑΧΟΣΠΥΡΟΣ                                       
ΒΛΑΧΟΣΤΑΘΗΣ                                       
ΒΛΑΧΟΣΤΑΘΟΠΟΥΛΟΣ                                  
ΒΛΑΧΟΣΤΑΜΑΤΗΣ                                     
ΒΛΑΧΟΣΤΕΡΓΙΟΣ                                     
ΒΛΑΧΟΣΩΤΗΡΟΣ                                      
ΒΛΑΧΟΤΑΣΙΟΣ                                       
ΒΛΑΧΟΤΣΙΜΤΣΙΡΗΣ                                   
ΒΛΑΧΟΥΔΗΣ                                         
ΒΛΑΧΟΥΛΗΣ                                         
ΒΛΑΧΟΥΣΗΣ                                         
ΒΛΑΧΟΥΤΑΣ                                         
ΒΛΑΧΟΥΤΣΑΚΟΣ                                      
ΒΛΑΧΟΥΤΣΗΣ                                        
ΒΛΑΧΟΥΤΣΙΚΟΣ                                      
ΒΛΑΧΟΥΤΣΟΣ                                        
ΒΛΑΧΟΧΡΗΣΤΑΣ                                      
ΒΛΑΧΟΧΡΗΣΤΟΣ                                      
ΒΛΑΧΟΧΡΙΣΤΟΠΟΥΛΟΣ                                 
ΒΛΑΧΤΑΣΗΣ                                         
ΒΛΑΧΤΣΗΣ                                          
ΒΛΑΧΩΝΗΣ                                          
ΒΛΕΙΩΡΑΣ                                          
ΒΛΕΜΜΑΣ                                           
ΒΛΕΠΑΚΗΣ                                          
ΒΛΕΣΗΣ                                            
ΒΛΕΣΣΑΣ                                           
ΒΛΕΣΣΙΔΗΣ                                         
ΒΛΕΤΣΑΣ                                           
ΒΛΕΤΣΗΣ                                           
ΒΛΕΤΣΟΣ                                           
ΒΛΗΓΟΡΟΥΔΗΣ                                       
ΒΛΗΓΟΥΡΙΔΗΣ                                       
ΒΛΗΚΙΔΗΣ                                          
ΒΛΗΣ                                              
ΒΛΗΣΑΡΟΥΛΗΣ                                       
ΒΛΗΣΙΔΗΣ                                          
ΒΛΗΣΜΑΣ                                           
ΒΛΗΣΣΑΡΗΣ                                         
ΒΛΗΣΣΑΡΟΥΛΗΣ                                      
ΒΛΗΣΣΙΔΗΣ                                         
ΒΛΗΤΑΚΗΣ                                          
ΒΛΗΤΑΣ                                            
ΒΛΗΤΙΔΗΣ                                          
ΒΛΗΤΣΑΚΗΣ                                         
ΒΛΗΤΣΙΟΣ                                          
ΒΛΗΤΤΑΣ                                           
ΒΛΗΤΤΟΣ                                           
ΒΛΗΧΙΝΗΣ                                          
ΒΛΙΑΓΚΟΦΤΗΣ                                       
ΒΛΙΑΛΗΣ                                           
ΒΛΙΑΜΟΣ                                           
ΒΛΙΖΝΑΚΗΣ                                         
ΒΛΙΖΟΣ                                            
ΒΛΙΟΥΡΑΣ                                          
ΒΛΙΣΙΔΗΣ                                          
ΒΛΙΤΣΗΣ                                           
ΒΛΙΧΙΝΗΣ                                          
ΒΛΙΩΡΑΣ                                           
ΒΛΟΓΙΑΝΙΤΗΣ                                       
ΒΛΟΓΙΑΝΝΙΤΗΣ                                      
ΒΛΟΓΙΑΡΗΣ                                         
ΒΛΟΙΤΟΣ                                           
ΒΛΟΝΤΑΚΗΣ                                         
ΒΛΟΝΤΖΟΣ                                          
ΒΛΟΣΤΟΣ                                           
ΒΛΟΤΙΔΗΣ                                          
ΒΛΟΤΙΝΟΣ                                          
ΒΛΟΤΟΔΕΛΗΣ                                        
ΒΛΟΤΟΥΔΕΛΗΣ                                       
ΒΛΟΤΣΟΣ                                           
ΒΛΟΥΤΕΛΛΗΣ                                        
ΒΛΟΥΤΗΣ                                           
ΒΛΟΥΧΑΚΗΣ                                         
ΒΛΟΥΧΟΣ                                           
ΒΛΟΧΑΙΤΗΣ                                         
ΒΛΟΧΑΙΤΟΠΟΥΛΟΣ                                    
ΒΛΥΖΙΩΤΗΣ                                         
ΒΛΥΣΙΔΗΣ                                          
ΒΛΥΣΜΑΣ                                           
ΒΛΥΣΝΑΚΗΣ                                         
ΒΛΥΣΣΙΔΗΣ                                         
ΒΛΥΤΣΗΣ                                           
ΒΛΩΤΑΡΟΣ                                          
ΒΛΩΤΕΛΛΗΣ                                         
ΒΛΩΤΗΣ                                            
ΒΛΩΤΙΔΕΛΛΗΣ                                       
ΒΛΩΤΙΝΟΣ                                          
ΒΝΑΤΣΙΟΣ                                          
ΒΟΑΣ                                              
ΒΟΒΑΤΖΑΚΗΣ                                        
ΒΟΒΙΔΗΣ                                           
ΒΟΒΛΑΣ                                            
ΒΟΒΟΛΑΣ                                           
ΒΟΒΟΛΗΣ                                           
ΒΟΒΟΛΙΝΗΣ                                         
ΒΟΒΟΠΟΥΛΟΣ                                        
ΒΟΒΟΡΑΣ                                           
ΒΟΒΟΣ                                             
ΒΟΒΟΤΗΣ                                           
ΒΟΒΟΥΡΑΣ                                          
ΒΟΒΩΝΗΣ                                           
ΒΟΓΑΖΙΑΝΟΣ                                        
ΒΟΓΑΖΙΩΤΗΣ                                        
ΒΟΓΑΝΑΤΣΗΣ                                        
ΒΟΓΑΣ                                             
ΒΟΓΑΣΑΡΗΣ                                         
ΒΟΓΑΤΖΑΣ                                          
ΒΟΓΑΤΣΑΣ                                          
ΒΟΓΓΑΛΗΣ                                          
ΒΟΓΓΑΣ                                            
ΒΟΓΓΕΛΗΣ                                          
ΒΟΓΓΛΗΣ                                           
ΒΟΓΓΟΛΗΣ                                          
ΒΟΓΓΟΣ                                            
ΒΟΓΔΑΚΗΣ                                          
ΒΟΓΔΑΝΑΚΗΣ                                        
ΒΟΓΔΑΝΕΡΗΣ                                        
ΒΟΓΔΑΝΗΣ                                          
ΒΟΓΔΑΝΙΔΗΣ                                        
ΒΟΓΔΑΝΟΣ                                          
ΒΟΓΔΑΝΤΣΑΛΗΣ                                      
ΒΟΓΔΗΣ                                            
ΒΟΓΔΟΠΟΥΛΟΣ                                       
ΒΟΓΔΟΣ                                            
ΒΟΓΕΑΣ                                            
ΒΟΓΙΑΖΑΣ                                          
ΒΟΓΙΑΖΗΝΟΣ                                        
ΒΟΓΙΑΖΗΣ                                          
ΒΟΓΙΑΖΙΔΗΣ                                        
ΒΟΓΙΑΖΙΝΟΣ                                        
ΒΟΓΙΑΖΟΣ                                          
ΒΟΓΙΑΚΕΛΗΣ                                        
ΒΟΓΙΑΚΗΣ                                          
ΒΟΓΙΑΝΝΗΣ                                         
ΒΟΓΙΑΝΝΙΔΗΣ                                       
ΒΟΓΙΑΝΝΟΠΟΥΛΟΣ                                    
ΒΟΓΙΑΝΝΟΣ                                         
ΒΟΓΙΑΝΤΖΑΚΗΣ                                      
ΒΟΓΙΑΝΤΖΗΣ                                        
ΒΟΓΙΑΡΗΣ                                          
ΒΟΓΙΑΡΙΔΗΣ                                        
ΒΟΓΙΑΡΟΣ                                          
ΒΟΓΙΑΣ                                            
ΒΟΓΙΑΤΖΑΚΗΣ                                       
ΒΟΓΙΑΤΖΑΚΟΣ                                       
ΒΟΓΙΑΤΖΑΡΑΣ                                       
ΒΟΓΙΑΤΖΗΔΑΚΗΣ                                     
ΒΟΓΙΑΤΖΗΣ                                         
ΒΟΓΙΑΤΖΙΔΑΚΗΣ                                     
ΒΟΓΙΑΤΖΙΔΑΚΙΣ                                     
ΒΟΓΙΑΤΖΙΔΗΣ                                       
ΒΟΓΙΑΤΖΙΔΟΠΟΥΛΟΣ                                  
ΒΟΓΙΑΤΖΙΝΗΣ                                       
ΒΟΓΙΑΤΖΟΠΟΥΛΟΣ                                    
ΒΟΓΙΑΤΖΟΥΔΗΣ                                      
ΒΟΓΙΑΤΖΟΥΛΗΣ                                      
ΒΟΓΙΑΤΣΗΣ                                         
ΒΟΓΙΝΔΡΟΥΚΑΣ                                      
ΒΟΓΙΟΒΙΤΣ                                         
ΒΟΓΙΟΚΑΛΑΚΗΣ                                      
ΒΟΓΚΑΣ                                            
ΒΟΓΚΛΗΣ                                           
ΒΟΓΚΟΛΗΣ                                          
ΒΟΓΚΟΣ                                            
ΒΟΓΛΕΣ                                            
ΒΟΓΛΗΣ                                            
ΒΟΓΛΙΔΗΣ                                          
ΒΟΓΛΙΤΣΗΣ                                         
ΒΟΓΛΟΥΔΗΣ                                         
ΒΟΓΟΓΙΑΔΗΣ                                        
ΒΟΓΟΓΙΑΣ                                          
ΒΟΓΟΠΟΥΛΟΣ                                        
ΒΟΔΑΝΙΚΗΣ                                         
ΒΟΔΑΣ                                             
ΒΟΔΕΝΑΛΗΣ                                         
ΒΟΔΕΝΑΣ                                           
ΒΟΔΕΝΗΣ                                           
ΒΟΔΕΝΙΩΤΗΣ                                        
ΒΟΔΕΝΛΗΣ                                          
ΒΟΔΕΝΟΠΟΥΛΟΣ                                      
ΒΟΔΕΝΤΣΗΣ                                         
ΒΟΔΕΝΤΣΙΩΤΗΣ                                      
ΒΟΔΙΝΑΣ                                           
ΒΟΔΙΝΟΣ                                           
ΒΟΔΟΛΑΣ                                           
ΒΟΔΟΥΡΗΣ                                          
ΒΟΕΒΟΔΑΣ                                          
ΒΟΕΙΔΗΣ                                           
ΒΟΕΡΑΚΟΣ                                          
ΒΟΖΑΙΤΗΣ                                          
ΒΟΖΑΛΗΣ                                           
ΒΟΖΑΝΑΣ                                           
ΒΟΖΑΝΗΣ                                           
ΒΟΖΑΣ                                             
ΒΟΖΑΤΖΙΔΗΣ                                        
ΒΟΖΒΟΤΕΚΑΣ                                        
ΒΟΖΔΟΓΙΑΝΝΗΣ                                      
ΒΟΖΗΣ                                             
ΒΟΖΙΑΝΗΣ                                          
ΒΟΖΙΑΝΟΣ                                          
ΒΟΖΙΑΝΟΥΔΗΣ                                       
ΒΟΖΙΔΗΣ                                           
ΒΟΖΙΚΑΚΗΣ                                         
ΒΟΖΙΚΑΣ                                           
ΒΟΖΙΚΗΣ                                           
ΒΟΖΙΝΑΚΗΣ                                         
ΒΟΖΙΝΗΣ                                           
ΒΟΖΙΝΙΔΗΣ                                         
ΒΟΖΙΝΟΣ                                           
ΒΟΖΙΟΛΑΣ                                          
ΒΟΖΙΟΣ                                            
ΒΟΖΟΓΛΑΝΗΣ                                        
ΒΟΖΟΛΑΣ                                           
ΒΟΖΟΣ                                             
ΒΟΖΩΡΑΣ                                           
ΒΟΖΩΡΗΣ                                           
ΒΟΗΘΟΠΟΥΛΟΣ                                       
ΒΟΗΚΛΗΣ                                           
ΒΟΙΒΟΔΑΣ                                          
ΒΟΙΒΟΛΑΣ                                          
ΒΟΙΒΟΝΔΑΣ                                         
ΒΟΙΒΟΝΤΑΣ                                         
ΒΟΙΒΟΤΙΔΗΣ                                        
ΒΟΙΒΟΥΝΤΟΥΔΗΣ                                     
ΒΟΙΔΑΚΗΣ                                          
ΒΟΙΔΑΚΟΣ                                          
ΒΟΙΔΑΝΙΔΗΣ                                        
ΒΟΙΔΑΡΟΣ                                          
ΒΟΙΔΗΛΑΣ                                          
ΒΟΙΔΗΛΟΣ                                          
ΒΟΙΔΗΣ                                            
ΒΟΙΔΟΚΟΛΑΚΟΣ                                      
ΒΟΙΔΟΜΑΤΗΣ                                        
ΒΟΙΔΟΜΜΑΤΗΣ                                       
ΒΟΙΔΟΝΙΚΟΛΑΣ                                      
ΒΟΙΔΟΝΙΚΟΛΟΠΟΥΛΟΣ                                 
ΒΟΙΖΟΛΑΣ                                          
ΒΟΙΚΑΣ                                            
ΒΟΙΚΛΗΣ                                           
ΒΟΙΚΟΠΟΥΛΟΣ                                       
ΒΟΙΚΟΣ                                            
ΒΟΙΛΑΚΗΣ                                          
ΒΟΙΛΑΚΟΣ                                          
ΒΟΙΛΑΣ                                            
ΒΟΙΛΗΣ                                            
ΒΟΙΜΑΚΗΣ                                          
ΒΟΙΝΑΣ                                            
ΒΟΙΝΕΣΚΟΣ                                         
ΒΟΙΝΗΣ                                            
ΒΟΙΝΙΑΔΗΣ                                         
ΒΟΙΝΙΔΗΣ                                          
ΒΟΙΝΙΚΑΣ                                          
ΒΟΙΝΟΒΙΤΣ                                         
ΒΟΙΝΟΣ                                            
ΒΟΙΡΑΚΟΣ                                          
ΒΟΙΣΧΟΣ                                           
ΒΟΙΤΙΧΟΒΙΤΣ                                       
ΒΟΙΤΣΕΣ                                           
ΒΟΙΤΣΗΣ                                           
ΒΟΙΤΣΙΔΗΣ                                         
ΒΟΙΤΣΟΣ                                           
ΒΟΚΑΛΗΣ                                           
ΒΟΚΑΣ                                             
ΒΟΚΟΒΙΤΣ                                          
ΒΟΚΟΛΙΔΗΣ                                         
ΒΟΚΟΛΟΣ                                           
ΒΟΚΟΡΟΚΟΣ                                         
ΒΟΚΟΣ                                             
ΒΟΚΟΤΑΣ                                           
ΒΟΚΟΤΟΠΟΥΛΟΣ                                      
ΒΟΚΟΤΟΥΖΗΣ                                        
ΒΟΚΟΥΡΑΣ                                          
ΒΟΛΑΓΚΑΣ                                          
ΒΟΛΑΚΑΚΗΣ                                         
ΒΟΛΑΚΑΣ                                           
ΒΟΛΑΚΗΣ                                           
ΒΟΛΑΚΛΗΣ                                          
ΒΟΛΑΚΟΣ                                           
ΒΟΛΑΝΑΚΗΣ                                         
ΒΟΛΑΝΗΣ                                           
ΒΟΛΑΝΙΟΣ                                          
ΒΟΛΑΡΗΣ                                           
ΒΟΛΑΣ                                             
ΒΟΛΑΤΣΑΚΑΣ                                        
ΒΟΛΓΑΡΗΣ                                          
ΒΟΛΓΟΣ                                            
ΒΟΛΕΛΗΣ                                           
ΒΟΛΕΛΛΗΣ                                          
ΒΟΛΕΣΗΣ                                           
ΒΟΛΗΣ                                             
ΒΟΛΙΑΝΑΚΗΣ                                        
ΒΟΛΙΑΝΙΤΗΣ                                        
ΒΟΛΙΔΗΣ                                           
ΒΟΛΙΚΑΚΗΣ                                         
ΒΟΛΙΚΑΣ                                           
ΒΟΛΙΚΗΣ                                           
ΒΟΛΙΚΟΣ                                           
ΒΟΛΙΟΤΟΠΟΥΛΟΣ                                     
ΒΟΛΙΣΣΙΑΝΟΣ                                       
ΒΟΛΙΤΑΚΗΣ                                         
ΒΟΛΙΩΝΙΤΑΚΗΣ                                      
ΒΟΛΙΩΤΗΣ                                          
ΒΟΛΙΩΤΙΔΗΣ                                        
ΒΟΛΙΩΤΟΠΟΥΛΟΣ                                     
ΒΟΛΚΑΣ                                            
ΒΟΛΚΙΔΗΣ                                          
ΒΟΛΚΟΣ                                            
ΒΟΛΛΑΡΗΣ                                          
ΒΟΛΛΑΣ                                            
ΒΟΛΛΕΛΗΣ                                          
ΒΟΛΛΗΣ                                            
ΒΟΛΝΑΣ                                            
ΒΟΛΟΒΙΝΗΣ                                         
ΒΟΛΟΒΟΤΣΗΣ                                        
ΒΟΛΟΓΙΑΝΝΗΣ                                       
ΒΟΛΟΓΙΑΝΝΙΔΗΣ                                     
ΒΟΛΟΓΚΑΣ                                          
ΒΟΛΟΝΑΚΗΣ                                         
ΒΟΛΟΝΑΣΗΣ                                         
ΒΟΛΟΣ                                             
ΒΟΛΟΣΥΡΑΚΗΣ                                       
ΒΟΛΟΤΟΠΟΥΛΟΣ                                      
ΒΟΛΟΤΣΑΚΑΣ                                        
ΒΟΛΟΥΔΑΚΗΣ                                        
ΒΟΛΠΗΣ                                            
ΒΟΛΤΑΙΡΑΣ                                         
ΒΟΛΤΑΙΡΟΣ                                         
ΒΟΛΤΑΡΗΣ                                          
ΒΟΛΤΑΤΖΗΣ                                         
ΒΟΛΤΕΑΣ                                           
ΒΟΛΤΕΖΟΣ                                          
ΒΟΛΤΕΡΑΣ                                          
ΒΟΛΤΕΡΣ                                           
ΒΟΛΤΖΗΣ                                           
ΒΟΛΤΗΣ                                            
ΒΟΛΤΙΔΗΣ                                          
ΒΟΛΤΣ                                             
ΒΟΛΤΣΑΚΗΣ                                         
ΒΟΛΤΣΗΣ                                           
ΒΟΛΤΣΙΔΗΣ                                         
ΒΟΛΤΣΙΝΗΣ                                         
ΒΟΛΤΣΙΟΣ                                          
ΒΟΛΤΣΟΣ                                           
ΒΟΛΤΥΡΑΚΗΣ                                        
ΒΟΛΥΡΑΚΗΣ                                         
ΒΟΛΦΗΣ                                            
ΒΟΛΩΝΑΚΗΣ                                         
ΒΟΛΩΝΗΣ                                           
ΒΟΛΩΤΑΣ                                           
ΒΟΜΒΑΡΔΑΣ                                         
ΒΟΜΒΑΣ                                            
ΒΟΜΒΕΛΛΗΣ                                         
ΒΟΜΒΙΛΑΣ                                          
ΒΟΜΒΟΓΙΑΝΝΗΣ                                      
ΒΟΜΒΟΛΑΚΗΣ                                        
ΒΟΜΒΟΝΗΣ                                          
ΒΟΜΒΟΡΗΣ                                          
ΒΟΜΒΟΡΙΔΗΣ                                        
ΒΟΜΒΡΑΣ                                           
ΒΟΜΒΥΛΑΣ                                          
ΒΟΜΒΥΛΗΣ                                          
ΒΟΜΒΥΡΑΣ                                          
ΒΟΜΠΙΡΑΚΗΣ                                        
ΒΟΜΠΙΡΗΣ                                          
ΒΟΜΠΟΣ                                            
ΒΟΜΠΡΑΣ                                           
ΒΟΝΑΖΟΥΝΤΑΣ                                       
ΒΟΝΑΚΗΣ                                           
ΒΟΝΑΠΑΡΤΗΣ                                        
ΒΟΝΑΣ                                             
ΒΟΝΑΤΣΟΣ                                          
ΒΟΝΓΚΟΣ                                           
ΒΟΝΔΙΚΑΚΗΣ                                        
ΒΟΝΙΑΝΟΣ                                          
ΒΟΝΙΔΗΣ                                           
ΒΟΝΙΚΑΚΗΣ                                         
ΒΟΝΙΚΟΠΟΥΛΟΣ                                      
ΒΟΝΙΣΑΚΟΣ                                         
ΒΟΝΙΤΣΑΝΟΣ                                        
ΒΟΝΟΠΑΡΤΗΣ                                        
ΒΟΝΟΡΤΑΣ                                          
ΒΟΝΟΦΑΚΙΔΗΣ                                       
ΒΟΝΟΦΑΚΟΣ                                         
ΒΟΝΤΑΣ                                            
ΒΟΝΤΕΛΑΣ                                          
ΒΟΝΤΕΛΙΔΗΣ                                        
ΒΟΝΤΕΤΣΙΑΝΟΣ                                      
ΒΟΝΤΖΑΛΙΔΗΣ                                       
ΒΟΝΤΖΙΔΗΣ                                         
ΒΟΝΤΖΟΛΟΣ                                         
ΒΟΝΤΖΟΡΙΔΗΣ                                       
ΒΟΝΤΖΟΣ                                           
ΒΟΝΤΙΚΑΚΗΣ                                        
ΒΟΝΤΙΝΑΣ                                          
ΒΟΝΤΙΤΣΑΣ                                         
ΒΟΝΤΙΤΣΟΣ                                         
ΒΟΝΤΣΑΣ                                           
ΒΟΝΤΣΗΣ                                           
ΒΟΝΩΡΤΑΣ                                          
ΒΟΞΑΚΗΣ                                           
ΒΟΞΒΟΤΕΚΑΣ                                        
ΒΟΠΗΣ                                             
ΒΟΠΟΠΟΥΛΟΣ                                        
ΒΟΡΑΔΑΚΗΣ                                         
ΒΟΡΑΔΑΣ                                           
ΒΟΡΒΗΣ                                            
ΒΟΡΒΙΛΑΣ                                          
ΒΟΡΒΟΛΑΚΟΣ                                        
ΒΟΡΒΥΛΑΣ                                          
ΒΟΡΒΩΤΑΣ                                          
ΒΟΡΓΑΖΛΗΣ                                         
ΒΟΡΓΙΑΔΗΣ                                         
ΒΟΡΓΙΑΖΙΔΗΣ                                       
ΒΟΡΓΙΑΝΙΤΗΣ                                       
ΒΟΡΓΙΑΣ                                           
ΒΟΡΓΙΑΤΖΙΔΗΣ                                      
ΒΟΡΓΙΔΗΣ                                          
ΒΟΡΓΙΟΠΟΥΛΟΣ                                      
ΒΟΡΔΑΚΗΣ                                          
ΒΟΡΔΑΝΟΣ                                          
ΒΟΡΔΗΣ                                            
ΒΟΡΔΟΓΙΑΝΝΗΣ                                      
ΒΟΡΔΟΚΑΣ                                          
ΒΟΡΔΟΝΑΡΑΚΗΣ                                      
ΒΟΡΔΟΝΑΣ                                          
ΒΟΡΔΟΣ                                            
ΒΟΡΔΟΥΝΑΣ                                         
ΒΟΡΔΟΧΕΙΛΑΣ                                       
ΒΟΡΔΩΝΑΣ                                          
ΒΟΡΔΩΝΗΣ                                          
ΒΟΡΕΑΔΗΣ                                          
ΒΟΡΕΑΚΗΣ                                          
ΒΟΡΕΑΚΟΣ                                          
ΒΟΡΕΑΣ                                            
ΒΟΡΕΙΝΑΚΗΣ                                        
ΒΟΡΕΙΝΟΣ                                          
ΒΟΡΕΟΠΟΥΛΟΣ                                       
ΒΟΡΗΑΣ                                            
ΒΟΡΗΝΟΣ                                           
ΒΟΡΗΣ                                             
ΒΟΡΙΑΔΑΚΗΣ                                        
ΒΟΡΙΑΖΙΔΗΣ                                        
ΒΟΡΙΑΣ                                            
ΒΟΡΙΑΤΖΙΔΗΣ                                       
ΒΟΡΙΔΗΣ                                           
ΒΟΡΙΖΑΝΑΚΗΣ                                       
ΒΟΡΙΖΑΝΟΣ                                         
ΒΟΡΙΛΑΣ                                           
ΒΟΡΙΛΛΑΣ                                          
ΒΟΡΙΝΑΚΗΣ                                         
ΒΟΡΙΝΑΣ                                           
ΒΟΡΙΝΙΩΤΗΣ                                        
ΒΟΡΙΝΟΣ                                           
ΒΟΡΙΣΗΣ                                           
ΒΟΡΙΣΙΟΣ                                          
ΒΟΡΙΣΣΗΣ                                          
ΒΟΡΙΤΣΗΣ                                          
ΒΟΡΚΑΠΙΤΣ                                         
ΒΟΡΚΙΝΑΚΗΣ                                        
ΒΟΡΛΟΚΑΣ                                          
ΒΟΡΜΠΙΝΟΣ                                         
ΒΟΡΝΙΤΗΣ                                          
ΒΟΡΝΙΩΤΑΚΗΣ                                       
ΒΟΡΟΔΗΜΟΣ                                         
ΒΟΡΟΝΖΕΡΗΣ                                        
ΒΟΡΟΠΟΥΛΟΣ                                        
ΒΟΡΟΣ                                             
ΒΟΡΡΑΔΑΚΗΣ                                        
ΒΟΡΡΑΣ                                            
ΒΟΡΡΕΑΔΗΣ                                         
ΒΟΡΡΕΑΚΟΣ                                         
ΒΟΡΡΕΑΣ                                           
ΒΟΡΡΕΣ                                            
ΒΟΡΡΗΑΣ                                           
ΒΟΡΡΗΣ                                            
ΒΟΡΡΙΑΣ                                           
ΒΟΡΡΙΖΑΝΑΚΗΣ                                      
ΒΟΡΡΙΝΑΣ                                          
ΒΟΡΡΙΣΗΣ                                          
ΒΟΡΡΟΠΟΥΛΟΣ                                       
ΒΟΡΣΑΣ                                            
ΒΟΡΣΙΑΣ                                           
ΒΟΡΣΟΥΚΑΣ                                         
ΒΟΡΤΕΛΙΝΑΣ                                        
ΒΟΡΤΕΛΙΝΟΣ                                        
ΒΟΡΤΣΕΛΑΣ                                         
ΒΟΡΤΣΟΣ                                           
ΒΟΡΥΛΛΑΣ                                          
ΒΟΣ                                               
ΒΟΣΒΟΛΗΣ                                          
ΒΟΣΒΟΛΙΔΗΣ                                        
ΒΟΣΒΟΤΕΚΑΣ                                        
ΒΟΣΔΑΓΑΛΗΣ                                        
ΒΟΣΔΑΝΙΚΗΣ                                        
ΒΟΣΔΙΚΗΣ                                          
ΒΟΣΔΟΓΑΛΗΣ                                        
ΒΟΣΔΟΓΑΝΗΣ                                        
ΒΟΣΔΟΓΑΝΝΗΣ                                       
ΒΟΣΔΟΓΙΑΝΝΗΣ                                      
ΒΟΣΗΣ                                             
ΒΟΣΙΚΑΣ                                           
ΒΟΣΙΝΑΚΗΣ                                         
ΒΟΣΙΝΑΣ                                           
ΒΟΣΙΝΗΣ                                           
ΒΟΣΙΝΙΩΤΗΣ                                        
ΒΟΣΙΟΣ                                            
ΒΟΣΚΑΚΗΣ                                          
ΒΟΣΚΑΚΙΣ                                          
ΒΟΣΚΑΝΙΔΗΣ                                        
ΒΟΣΚΑΣ                                            
ΒΟΣΚΙΔΗΣ                                          
ΒΟΣΚΟΠΟΥΛΑΚΗΣ                                     
ΒΟΣΚΟΠΟΥΛΟΣ                                       
ΒΟΣΚΟΣ                                            
ΒΟΣΚΟΥΔΑΚΗΣ                                       
ΒΟΣΜΑΝΔΡΟΣ                                        
ΒΟΣΝΑΚΗΣ                                          
ΒΟΣΝΑΚΙΔΗΣ                                        
ΒΟΣΝΑΚΟΣ                                          
ΒΟΣΝΙΑΔΗΣ                                         
ΒΟΣΝΙΑΚΟΣ                                         
ΒΟΣΝΙΔΗΣ                                          
ΒΟΣΝΟΣ                                            
ΒΟΣΟΣ                                             
ΒΟΣΣΙΟΣ                                           
ΒΟΣΣΟΣ                                            
ΒΟΣΤΑΝΗΣ                                          
ΒΟΣΤΑΝΤΑΣ                                         
ΒΟΣΤΑΝΤΖΗΣ                                        
ΒΟΣΤΙΤΣΑΝΟΣ                                       
ΒΟΣΥΝΙΩΤΗΣ                                        
ΒΟΤΑΝΗΣ                                           
ΒΟΤΑΝΙΚΗΣ                                         
ΒΟΤΑΝΟΠΟΥΛΟΣ                                      
ΒΟΤΑΝΟΣ                                           
ΒΟΤΑΡΗΣ                                           
ΒΟΤΖΑΚΗΣ                                          
ΒΟΤΖΗΣ                                            
ΒΟΤΖΟΥΡΑΚΗΣ                                       
ΒΟΤΗΣ                                             
ΒΟΤΙΚΑΣ                                           
ΒΟΤΣΑΙΤΗΣ                                         
ΒΟΤΣΑΡΗΣ                                          
ΒΟΤΣΑΡΙΔΗΣ                                        
ΒΟΤΣΗΣ                                            
ΒΟΤΣΙΔΗΣ                                          
ΒΟΤΣΙΚΑΣ                                          
ΒΟΤΣΙΝΟΣ                                          
ΒΟΤΣΙΟΣ                                           
ΒΟΤΣΚΑΡΗΣ                                         
ΒΟΤΣΚΗΣ                                           
ΒΟΤΣΚΟΣ                                           
ΒΟΤΣΟΣ                                            
ΒΟΤΤΑΣ                                            
ΒΟΤΤΕΑΣ                                           
ΒΟΥΒΑΚΗΣ                                          
ΒΟΥΒΑΛΑΚΗΣ                                        
ΒΟΥΒΑΛΑΡΗΣ                                        
ΒΟΥΒΑΛΑΣ                                          
ΒΟΥΒΑΛΗΣ                                          
ΒΟΥΒΑΛΙΔΗΣ                                        
ΒΟΥΒΑΛΙΚΗΣ                                        
ΒΟΥΒΑΛΟΥΔΗΣ                                       
ΒΟΥΒΑΡΗΣ                                          
ΒΟΥΒΑΣ                                            
ΒΟΥΒΕΛΗΣ                                          
ΒΟΥΒΕΛΛΗΣ                                         
ΒΟΥΒΗΣ                                            
ΒΟΥΒΙΔΗΣ                                          
ΒΟΥΒΛΙΑΣ                                          
ΒΟΥΒΟΛΑΣ                                          
ΒΟΥΒΟΝΙΚΟΣ                                        
ΒΟΥΒΟΠΟΥΛΟΣ                                       
ΒΟΥΒΟΣ                                            
ΒΟΥΒΟΥΔΑΚΗΣ                                       
ΒΟΥΒΟΥΔΗΣ                                         
ΒΟΥΒΟΥΚΗΣ                                         
ΒΟΥΒΟΥΛΗΣ                                         
ΒΟΥΒΟΥΛΙΔΗΣ                                       
ΒΟΥΒΟΥΛΟΥΔΑΣ                                      
ΒΟΥΒΟΥΛΟΥΔΗΣ                                      
ΒΟΥΒΟΥΝΑΣ                                         
ΒΟΥΒΟΥΝΙΚΟΣ                                       
ΒΟΥΒΟΥΝΟΣ                                         
ΒΟΥΒΟΥΡΑΣ                                         
ΒΟΥΒΟΥΣΑΣ                                         
ΒΟΥΒΟΥΣΗΣ                                         
ΒΟΥΒΟΥΣΙΡΑΣ                                       
ΒΟΥΒΟΥΣΙΩΤΗΣ                                      
ΒΟΥΒΟΥΤΑΣ                                         
ΒΟΥΒΟΥΤΣΗΣ                                        
ΒΟΥΒΩΛΗΣ                                          
ΒΟΥΓΑΔΑΚΗΣ                                        
ΒΟΥΓΑΔΗΣ                                          
ΒΟΥΓΑΔΙΩΤΗΣ                                       
ΒΟΥΓΑΖΙΑΝΟΣ                                       
ΒΟΥΓΑΛΕΡΗΣ                                        
ΒΟΥΓΑΜΑΛΗΣ                                        
ΒΟΥΓΑΝΗΣ                                          
ΒΟΥΓΑΣ                                            
ΒΟΥΓΑΤΣΙΩΤΗΣ                                      
ΒΟΥΓΓΟΔΗΜΟΣ                                       
ΒΟΥΓΔΗΣ                                           
ΒΟΥΓΕΛΕΚΑΣ                                        
ΒΟΥΓΕΛΛΗΣ                                         
ΒΟΥΓΕΣΗΣ                                          
ΒΟΥΓΙΑΛΙΩΤΗΣ                                      
ΒΟΥΓΙΑΝΤΖΗΣ                                       
ΒΟΥΓΙΑΣ                                           
ΒΟΥΓΙΑΤΖΗΣ                                        
ΒΟΥΓΙΔΗΣ                                          
ΒΟΥΓΙΕΛΛΗΣ                                        
ΒΟΥΓΙΚΛΑΚΗΣ                                       
ΒΟΥΓΙΟΒΙΤΣ                                        
ΒΟΥΓΙΟΥΚΑΚΗΣ                                      
ΒΟΥΓΙΟΥΚΑΛΑΚΗΣ                                    
ΒΟΥΓΙΟΥΚΑΛΑΚΙΣ                                    
ΒΟΥΓΙΟΥΚΑΛΟΣ                                      
ΒΟΥΓΙΟΥΚΑΣ                                        
ΒΟΥΓΙΟΥΚΕΛΛΗΣ                                     
ΒΟΥΓΙΟΥΚΗΣ                                        
ΒΟΥΓΙΟΥΚΛΑΚΗΣ                                     
ΒΟΥΓΙΟΥΚΛΑΡΑΚΗΣ                                   
ΒΟΥΓΙΟΥΚΛΕΡΗΣ                                     
ΒΟΥΓΙΟΥΚΛΗΣ                                       
ΒΟΥΓΙΟΥΚΛΙΔΗΣ                                     
ΒΟΥΓΙΟΥΚΛΙΩΤΗΣ                                    
ΒΟΥΓΙΟΥΚΛΟΥΔΗΣ                                    
ΒΟΥΓΙΟΥΚΟΣ                                        
ΒΟΥΓΙΟΥΝΔΡΟΥΚΑΣ                                   
ΒΟΥΓΙΟΥΡΔΗΣ                                       
ΒΟΥΓΙΟΥΣ                                          
ΒΟΥΓΙΤΣ                                           
ΒΟΥΓΙΤΣΙΤΣ                                        
ΒΟΥΓΚΑΣ                                           
ΒΟΥΓΚΟΔΗΜΟΣ                                       
ΒΟΥΓΛΑΝΗΣ                                         
ΒΟΥΓΛΑΡΗΣ                                         
ΒΟΥΓΛΟΣ                                           
ΒΟΥΓΟΓΙΑΝΝΟΠΟΥΛΟΣ                                 
ΒΟΥΓΟΓΙΑΣ                                         
ΒΟΥΔΑΚΑΚΗΣ                                        
ΒΟΥΔΑΚΗΣ                                          
ΒΟΥΔΑΛΙΚΑΚΗΣ                                      
ΒΟΥΔΑΛΙΚΑΣ                                        
ΒΟΥΔΑΝΙΔΗΣ                                        
ΒΟΥΔΑΝΤΑΣ                                         
ΒΟΥΔΑΣ                                            
ΒΟΥΔΔΑΣ                                           
ΒΟΥΔΕΝΙΩΤΗΣ                                       
ΒΟΥΔΗΜΟΣ                                          
ΒΟΥΔΗΣ                                            
ΒΟΥΔΙΑΔΟΣ                                         
ΒΟΥΔΙΑΣ                                           
ΒΟΥΔΙΓΑΡΗΣ                                        
ΒΟΥΔΙΚΛΑΡΗΣ                                       
ΒΟΥΔΙΩΤΗΣ                                         
ΒΟΥΔΛΙΑΚΗΣ                                        
ΒΟΥΔΟΓΕΩΡΓΗΣ                                      
ΒΟΥΔΟΓΙΩΡΓΗΣ                                      
ΒΟΥΔΟΜΜΑΤΗΣ                                       
ΒΟΥΔΟΥΚΗΣ                                         
ΒΟΥΔΟΥΛΑΚΗΣ                                       
ΒΟΥΔΟΥΡΑΓΚΑΚΗΣ                                    
ΒΟΥΔΟΥΡΑΚΗΣ                                       
ΒΟΥΔΟΥΡΕΛΛΗΣ                                      
ΒΟΥΔΟΥΡΗΣ                                         
ΒΟΥΔΟΥΡΙΔΗΣ                                       
ΒΟΥΔΟΥΡΟΠΟΥΛΟΣ                                    
ΒΟΥΔΡΕΣΛΗΣ                                        
ΒΟΥΔΡΗΣ                                           
ΒΟΥΔΡΙΑΣ                                          
ΒΟΥΔΡΙΣΛΗΣ                                        
ΒΟΥΔΡΟΜΝΙΑΝΟΣ                                     
ΒΟΥΔΡΟΥΜΙΑΝΟΣ                                     
ΒΟΥΔΡΥΑΣ                                          
ΒΟΥΖΑΒΑΛΗΣ                                        
ΒΟΥΖΑΚΗΣ                                          
ΒΟΥΖΑΛΗΣ                                          
ΒΟΥΖΑΜΠΕΡΗΣ                                       
ΒΟΥΖΑΝΗΣ                                          
ΒΟΥΖΑΝΙΔΗΣ                                        
ΒΟΥΖΑΞΑΚΗΣ                                        
ΒΟΥΖΑΡΑΣ                                          
ΒΟΥΖΑΣ                                            
ΒΟΥΖΑΤΟΣ                                          
ΒΟΥΖΒΟΥΡΗΣ                                        
ΒΟΥΖΔΟΥΚΑΣ                                        
ΒΟΥΖΕΚΗΣ                                          
ΒΟΥΖΕΛΑΚΗΣ                                        
ΒΟΥΖΕΛΑΚΟΣ                                        
ΒΟΥΖΗΣ                                            
ΒΟΥΖΙΑΝΑΣ                                         
ΒΟΥΖΙΑΝΗΣ                                         
ΒΟΥΖΙΚΑΣ                                          
ΒΟΥΖΙΚΗΣ                                          
ΒΟΥΖΙΚΙΔΗΣ                                        
ΒΟΥΖΙΝΑΣ                                          
ΒΟΥΖΙΟΣ                                           
ΒΟΥΖΙΟΥΚΟΣ                                        
ΒΟΥΖΙΟΥΡΗΣ                                        
ΒΟΥΖΙΤΑΣ                                          
ΒΟΥΖΙΩΤΗΣ                                         
ΒΟΥΖΝΑΣ                                           
ΒΟΥΖΟΓΛΑΝΗΣ                                       
ΒΟΥΖΟΝΗΣ                                          
ΒΟΥΖΟΝΙΚΟΣ                                        
ΒΟΥΖΟΠΛΗΣ                                         
ΒΟΥΖΟΣ                                            
ΒΟΥΖΟΥΚΑΣ                                         
ΒΟΥΖΟΥΚΙΔΗΣ                                       
ΒΟΥΖΟΥΚΛΑΣ                                        
ΒΟΥΖΟΥΚΟΣ                                         
ΒΟΥΖΟΥΛΙΑΣ                                        
ΒΟΥΖΟΥΛΙΔΗΣ                                       
ΒΟΥΖΟΥΝΑΡΑΣ                                       
ΒΟΥΖΟΥΝΕΡΑΚΗΣ                                     
ΒΟΥΖΟΥΝΕΡΗΣ                                       
ΒΟΥΖΟΥΝΙΚΟΣ                                       
ΒΟΥΖΩΝΗΣ                                          
ΒΟΥΗΣ                                             
ΒΟΥΘΑΣ                                            
ΒΟΥΘΟΥΝΗΣ                                         
ΒΟΥΙΒΟΥΝΤΟΥΔΗΣ                                    
ΒΟΥΙΔΑΣΚΗΣ                                        
ΒΟΥΙΚΛΗΣ                                          
ΒΟΥΙΜΤΑΣ                                          
ΒΟΥΙΤΣΗΣ                                          
ΒΟΥΚΑΙΛΑΤΟΣ                                       
ΒΟΥΚΑΚΗΣ                                          
ΒΟΥΚΑΛΕΛΗΣ                                        
ΒΟΥΚΑΛΕΛΛΗΣ                                       
ΒΟΥΚΑΛΗΣ                                          
ΒΟΥΚΑΛΙΔΗΣ                                        
ΒΟΥΚΑΝΟΣ                                          
ΒΟΥΚΑΝΤΣΗΣ                                        
ΒΟΥΚΑΣ                                            
ΒΟΥΚΑΣΙΝΟΒΙΤΣ                                     
ΒΟΥΚΑΣΟΒΙΤΣ                                       
ΒΟΥΚΑΤΑΣ                                          
ΒΟΥΚΑΤΖΗΣ                                         
ΒΟΥΚΑΤΙΔΗΣ                                        
ΒΟΥΚΑΤΟΝΑΣΙΟΣ                                     
ΒΟΥΚΑΤΟΣ                                          
ΒΟΥΚΕΛΑΤΟΣ                                        
ΒΟΥΚΕΝΑΣ                                          
ΒΟΥΚΙΑΣ                                           
ΒΟΥΚΙΔΗΣ                                          
ΒΟΥΚΙΚΛΑΚΗΣ                                       
ΒΟΥΚΙΚΛΑΡΗΣ                                       
ΒΟΥΚΚΗΣ                                           
ΒΟΥΚΛΑΡΗΣ                                         
ΒΟΥΚΛΙΖΑΣ                                         
ΒΟΥΚΛΟΥΤΖΗΣ                                       
ΒΟΥΚΟΒΙΝΟΣ                                        
ΒΟΥΚΟΒΙΤΣ                                         
ΒΟΥΚΟΛΑΣ                                          
ΒΟΥΚΟΛΟΣ                                          
ΒΟΥΚΟΥΒΑΛΑΣ                                       
ΒΟΥΚΟΥΒΑΛΙΔΗΣ                                     
ΒΟΥΚΟΥΝΑΣ                                         
ΒΟΥΚΟΥΝΗΣ                                         
ΒΟΥΚΟΥΡΑΚΟΣ                                       
ΒΟΥΚΟΥΡΕΣΛΗΣ                                      
ΒΟΥΚΟΥΡΗΣ                                         
ΒΟΥΚΟΥΤΑΣ                                         
ΒΟΥΚΟΥΤΗΣ                                         
ΒΟΥΚΟΥΤΟΣ                                         
ΒΟΥΚΤΗΣ                                           
ΒΟΥΚΥΔΗΣ                                          
ΒΟΥΚΥΚΛΑΚΗΣ                                       
ΒΟΥΚΥΚΛΑΡΑΚΗΣ                                     
ΒΟΥΚΥΚΛΑΡΗΣ                                       
ΒΟΥΛΑΓΓΑΣ                                         
ΒΟΥΛΑΓΚΑΣ                                         
ΒΟΥΛΑΔΑΚΗΣ                                        
ΒΟΥΛΑΔΑΣ                                          
ΒΟΥΛΑΔΕΛΗΣ                                        
ΒΟΥΛΑΖΕΡΗΣ                                        
ΒΟΥΛΑΚΑΚΗΣ                                        
ΒΟΥΛΑΚΗΣ                                          
ΒΟΥΛΑΚΙΔΗΣ                                        
ΒΟΥΛΑΛΑΣ                                          
ΒΟΥΛΑΛΗΣ                                          
ΒΟΥΛΑΜΑΚΗΣ                                        
ΒΟΥΛΑΜΑΝΔΗΣ                                       
ΒΟΥΛΑΜΑΝΤΗΣ                                       
ΒΟΥΛΑΝΑΣ                                          
ΒΟΥΛΑΡΙΝΟΣ                                        
ΒΟΥΛΑΣ                                            
ΒΟΥΛΑΣΙΚΗΣ                                        
ΒΟΥΛΒΟΥΚΕΛΗΣ                                      
ΒΟΥΛΒΟΥΛΗΣ                                        
ΒΟΥΛΒΟΥΤΖΗΣ                                       
ΒΟΥΛΒΟΥΤΖΙΔΗΣ                                     
ΒΟΥΛΓΑΡΑΚΗΣ                                       
ΒΟΥΛΓΑΡΑΚΟΣ                                       
ΒΟΥΛΓΑΡΑΣ                                         
ΒΟΥΛΓΑΡΕΛΗΣ                                       
ΒΟΥΛΓΑΡΕΛΛΗΣ                                      
ΒΟΥΛΓΑΡΕΤΣΙΟΣ                                     
ΒΟΥΛΓΑΡΗΣ                                         
ΒΟΥΛΓΑΡΙΔΗΣ                                       
ΒΟΥΛΓΑΡΙΝΑΣ                                       
ΒΟΥΛΓΑΡΟΠΟΥΛΟΣ                                    
ΒΟΥΛΓΑΡΟΣ                                         
ΒΟΥΛΓΑΡΟΥΔΗΣ                                      
ΒΟΥΛΓΑΡΟΥΛΗΣ                                      
ΒΟΥΛΓΑΡΩΝΗΣ                                       
ΒΟΥΛΓΕΛΛΗΣ                                        
ΒΟΥΛΔΗΣ                                           
ΒΟΥΛΔΟΥΚΗΣ                                        
ΒΟΥΛΔΟΥΡΚΗΣ                                       
ΒΟΥΛΔΟΥΡΟΠΟΥΛΟΣ                                   
ΒΟΥΛΕΒΙΤΣ                                         
ΒΟΥΛΕΛΑΚΗΣ                                        
ΒΟΥΛΕΛΗΣ                                          
ΒΟΥΛΕΛΙΚΑΣ                                        
ΒΟΥΛΕΛΛΗΣ                                         
ΒΟΥΛΕΡΗΣ                                          
ΒΟΥΛΕΣ                                            
ΒΟΥΛΕΤΑΚΗΣ                                        
ΒΟΥΛΗΜΕΝΕΑΣ                                       
ΒΟΥΛΗΣ                                            
ΒΟΥΛΙΑΚΗΣ                                         
ΒΟΥΛΙΑΜΗΣ                                         
ΒΟΥΛΙΒΑΣΗΣ                                        
ΒΟΥΛΙΓΕΑΣ                                         
ΒΟΥΛΙΕΡΗΣ                                         
ΒΟΥΛΙΚΑΣ                                          
ΒΟΥΛΙΚΗΣ                                          
ΒΟΥΛΙΜΙΩΤΗΣ                                       
ΒΟΥΛΙΝΟΣ                                          
ΒΟΥΛΙΟΣ                                           
ΒΟΥΛΙΟΥΒΑΣΗΣ                                      
ΒΟΥΛΙΟΥΡΗΣ                                        
ΒΟΥΛΙΣΜΑΣ                                         
ΒΟΥΛΙΣΤΗΣ                                         
ΒΟΥΛΙΣΤΙΩΤΗΣ                                      
ΒΟΥΛΙΩΤΗΣ                                         
ΒΟΥΛΚΑΚΗΣ                                         
ΒΟΥΛΚΑΣ                                           
ΒΟΥΛΚΙΔΗΣ                                         
ΒΟΥΛΚΟΓΙΑΝΤΣΗΣ                                    
ΒΟΥΛΚΟΠΟΥΛΟΣ                                      
ΒΟΥΛΚΟΣ                                           
ΒΟΥΛΚΟΥΔΗΣ                                        
ΒΟΥΛΜΕΣ                                           
ΒΟΥΛΟΑΓΚΑΣ                                        
ΒΟΥΛΟΓΕΩΡΓΟΣ                                      
ΒΟΥΛΟΓΙΑΝΝΗΣ                                      
ΒΟΥΛΟΓΙΩΡΓΟΣ                                      
ΒΟΥΛΟΓΚΑΣ                                         
ΒΟΥΛΟΓΚΙΤΣΑΣ                                      
ΒΟΥΛΟΔΗΜΟΣ                                        
ΒΟΥΛΟΜΕΝΟΣ                                        
ΒΟΥΛΟΤΑΚΗΣ                                        
ΒΟΥΛΟΥΒΟΥΤΗΣ                                      
ΒΟΥΛΟΥΓΡΑΣ                                        
ΒΟΥΛΟΥΔΑΚΗΣ                                       
ΒΟΥΛΟΥΔΗΣ                                         
ΒΟΥΛΟΥΚΟΣ                                         
ΒΟΥΛΟΥΜΑΝΟΣ                                       
ΒΟΥΛΟΥΜΒΑΣΑΚΗΣ                                    
ΒΟΥΛΟΥΜΠΑΣΑΚΗΣ                                    
ΒΟΥΛΟΥΞΗΣ                                         
ΒΟΥΛΟΥΤΑΚΗΣ                                       
ΒΟΥΛΟΥΤΗΣ                                         
ΒΟΥΛΟΥΤΙΑΔΗΣ                                      
ΒΟΥΛΟΥΤΙΔΗΣ                                       
ΒΟΥΛΟΥΤΣΗΣ                                        
ΒΟΥΛΠΙΩΤΗΣ                                        
ΒΟΥΛΤΕΨΗΣ                                         
ΒΟΥΛΤΖΑΤΗΣ                                        
ΒΟΥΛΤΟΥΡΚΗΣ                                       
ΒΟΥΛΤΣΑΚΗΣ                                        
ΒΟΥΛΤΣΑΝΗΣ                                        
ΒΟΥΛΤΣΗΣ                                          
ΒΟΥΛΤΣΙΑΔΗΣ                                       
ΒΟΥΛΤΣΙΔΗΣ                                        
ΒΟΥΛΤΣΙΝΗΣ                                        
ΒΟΥΛΤΣΙΝΟΣ                                        
ΒΟΥΛΤΣΙΟΣ                                         
ΒΟΥΛΤΣΙΟΥΔΗΣ                                      
ΒΟΥΛΤΣΟΠΟΥΛΟΣ                                     
ΒΟΥΛΤΣΟΣ                                          
ΒΟΥΛΩΜΕΝΟΣ                                        
ΒΟΥΛΩΝΗΣ                                          
ΒΟΥΛΩΤΑΣ                                          
ΒΟΥΜΒΑΚΗΣ                                         
ΒΟΥΜΒΑΡΛΗΣ                                        
ΒΟΥΜΒΑΣ                                           
ΒΟΥΜΒΛΙΝΟΠΟΥΛΟΣ                                   
ΒΟΥΜΒΟΥΛΑΚΗΣ                                      
ΒΟΥΜΒΟΥΝΙΔΗΣ                                      
ΒΟΥΜΒΟΥΡΑΚΗΣ                                      
ΒΟΥΜΕΛΗΣ                                          
ΒΟΥΜΕΛΛΗΣ                                         
ΒΟΥΜΠΑΡΗΣ                                         
ΒΟΥΝΑΚΗΣ                                          
ΒΟΥΝΑΝΙΩΤΗΣ                                       
ΒΟΥΝΑΡΙΔΗΣ                                        
ΒΟΥΝΑΣΗΣ                                          
ΒΟΥΝΑΤΣΑΣ                                         
ΒΟΥΝΑΤΣΗΣ                                         
ΒΟΥΝΑΤΣΟΣ                                         
ΒΟΥΝΒΟΥΛΑΚΗΣ                                      
ΒΟΥΝΔΡΗΣ                                          
ΒΟΥΝΕΛΑΚΗΣ                                        
ΒΟΥΝΕΛΑΚΟΣ                                        
ΒΟΥΝΖΟΥΛΑΚΗΣ                                      
ΒΟΥΝΗΣΙΟΣ                                         
ΒΟΥΝΙΔΗΣ                                          
ΒΟΥΝΙΚΑΚΗΣ                                        
ΒΟΥΝΙΝΟΣ                                          
ΒΟΥΝΙΟΖΟΣ                                         
ΒΟΥΝΙΣΕΑΣ                                         
ΒΟΥΝΙΣΙΟΣ                                         
ΒΟΥΝΙΩΖΟΣ                                         
ΒΟΥΝΟΣ                                            
ΒΟΥΝΟΤΡΑΠΙΔΗΣ                                     
ΒΟΥΝΟΤΡΟΠΙΔΗΣ                                     
ΒΟΥΝΟΤΡΥΠΙΔΗΣ                                     
ΒΟΥΝΟΥΣΑΚΗΣ                                       
ΒΟΥΝΤΑΓΙΑΣ                                        
ΒΟΥΝΤΑΣ                                           
ΒΟΥΝΤΖΟΥΚΛΗΣ                                      
ΒΟΥΝΤΖΟΥΛΑΚΗΣ                                     
ΒΟΥΝΤΙΔΗΣ                                         
ΒΟΥΝΤΟΥΚΗΣ                                        
ΒΟΥΝΤΟΥΡΑΚΗΣ                                      
ΒΟΥΝΤΟΥΡΗΣ                                        
ΒΟΥΞΙΝΟΣ                                          
ΒΟΥΠΟΥΡΑΣ                                         
ΒΟΥΡΑΖΑΝΗΣ                                        
ΒΟΥΡΑΖΑΝΙΔΗΣ                                      
ΒΟΥΡΑΖΕΛΗΣ                                        
ΒΟΥΡΑΖΕΛΙΑΣ                                       
ΒΟΥΡΑΖΕΡΗΣ                                        
ΒΟΥΡΑΚΗΣ                                          
ΒΟΥΡΑΚΙΔΗΣ                                        
ΒΟΥΡΑΝΗΣ                                          
ΒΟΥΡΑΝΤΑΣ                                         
ΒΟΥΡΑΝΤΩΝΗΣ                                       
ΒΟΥΡΑΣ                                            
ΒΟΥΡΒΑΣ                                           
ΒΟΥΡΒΑΧΑΚΗΣ                                       
ΒΟΥΡΒΑΧΑΚΙΣ                                       
ΒΟΥΡΒΑΧΗΣ                                         
ΒΟΥΡΒΟΠΟΥΛΟΣ                                      
ΒΟΥΡΒΟΣ                                           
ΒΟΥΡΒΟΥΚΑΣ                                        
ΒΟΥΡΒΟΥΚΕΛΗΣ                                      
ΒΟΥΡΒΟΥΛΑΚΑΣ                                      
ΒΟΥΡΒΟΥΛΑΚΗΣ                                      
ΒΟΥΡΒΟΥΛΑΣ                                        
ΒΟΥΡΒΟΥΛΗΣ                                        
ΒΟΥΡΒΟΥΛΙΑΣ                                       
ΒΟΥΡΒΟΥΝΑΚΗΣ                                      
ΒΟΥΡΒΟΥΡΗΣ                                        
ΒΟΥΡΒΟΥΡΙΩΤΗΣ                                     
ΒΟΥΡΒΟΥΤΣΕΛΗΣ                                     
ΒΟΥΡΒΟΥΤΣΙΩΤΗΣ                                    
ΒΟΥΡΓΑΖΑΚΗΣ                                       
ΒΟΥΡΓΑΖΛΗΣ                                        
ΒΟΥΡΓΑΖΟΠΟΥΛΟΣ                                    
ΒΟΥΡΓΑΚΗΣ                                         
ΒΟΥΡΓΑΛΗΣ                                         
ΒΟΥΡΓΑΝΑΣ                                         
ΒΟΥΡΓΑΡΗΣ                                         
ΒΟΥΡΓΑΡΙΔΗΣ                                       
ΒΟΥΡΓΑΣ                                           
ΒΟΥΡΓΑΣΛΗΣ                                        
ΒΟΥΡΓΕΝΤΗΣ                                        
ΒΟΥΡΓΙΑΣ                                          
ΒΟΥΡΓΙΔΗΣ                                         
ΒΟΥΡΓΙΩΤΗΣ                                        
ΒΟΥΡΓΟΣ                                           
ΒΟΥΡΓΟΥΝΤΖΗΣ                                      
ΒΟΥΡΓΟΥΡΑΚΗΣ                                      
ΒΟΥΡΓΟΥΤΖΗΣ                                       
ΒΟΥΡΓΟΥΤΣΗΣ                                       
ΒΟΥΡΔΑΚΗΣ                                         
ΒΟΥΡΔΑΛΟΣ                                         
ΒΟΥΡΔΑΜΗΣ                                         
ΒΟΥΡΔΑΝΟΣ                                         
ΒΟΥΡΔΑΣ                                           
ΒΟΥΡΔΑΧΑΣ                                         
ΒΟΥΡΔΕΛΗΣ                                         
ΒΟΥΡΔΕΡΗΣ                                         
ΒΟΥΡΔΟΓΙΑΝΝΗΣ                                     
ΒΟΥΡΔΟΛΗΣ                                         
ΒΟΥΡΔΟΝΙΚΟΛΑΣ                                     
ΒΟΥΡΔΟΥΓΙΑΝΝΗΣ                                    
ΒΟΥΡΔΟΥΚΑΣ                                        
ΒΟΥΡΔΟΥΚΗΣ                                        
ΒΟΥΡΔΟΥΛΑΣ                                        
ΒΟΥΡΔΟΥΜΠΑΚΗΣ                                     
ΒΟΥΡΔΟΥΜΠΑΣ                                       
ΒΟΥΡΔΟΥΝΑΣ                                        
ΒΟΥΡΔΟΥΝΗΣ                                        
ΒΟΥΡΔΟΥΡΙΔΗΣ                                      
ΒΟΥΡΔΟΥΡΚΗΣ                                       
ΒΟΥΡΔΟΥΣΗΣ                                        
ΒΟΥΡΕΚΑΣ                                          
ΒΟΥΡΕΛΙΑΣ                                         
ΒΟΥΡΕΛΛΗΣ                                         
ΒΟΥΡΕΞΑΚΗΣ                                        
ΒΟΥΡΕΞΗΣ                                          
ΒΟΥΡΗΣ                                            
ΒΟΥΡΘΗΣ                                           
ΒΟΥΡΙΚΗΣ                                          
ΒΟΥΡΙΝΑΡΗΣ                                        
ΒΟΥΡΙΩΤΗΣ                                         
ΒΟΥΡΚΑΣ                                           
ΒΟΥΡΚΙΔΗΣ                                         
ΒΟΥΡΚΟΣ                                           
ΒΟΥΡΚΟΤΙΩΤΗΣ                                      
ΒΟΥΡΚΟΥΔΗΣ                                        
ΒΟΥΡΚΟΥΤΙΩΤΗΣ                                     
ΒΟΥΡΛΑΚΗΣ                                         
ΒΟΥΡΛΑΚΟΣ                                         
ΒΟΥΡΛΑΜΗΣ                                         
ΒΟΥΡΛΑΣ                                           
ΒΟΥΡΛΑΤΟΣ                                         
ΒΟΥΡΛΕΓΚΑΣ                                        
ΒΟΥΡΛΕΤΣΗΣ                                        
ΒΟΥΡΛΗΣ                                           
ΒΟΥΡΛΙΑΚΗΣ                                        
ΒΟΥΡΛΙΑΣ                                          
ΒΟΥΡΛΙΔΑΚΗΣ                                       
ΒΟΥΡΛΙΔΑΣ                                         
ΒΟΥΡΛΙΔΗΣ                                         
ΒΟΥΡΛΙΟΓΚΑΣ                                       
ΒΟΥΡΛΙΤΗΣ                                         
ΒΟΥΡΛΙΤΣΗΣ                                        
ΒΟΥΡΛΙΩΤΑΚΗΣ                                      
ΒΟΥΡΛΙΩΤΗΣ                                        
ΒΟΥΡΛΟΒΙΤΗΣ                                       
ΒΟΥΡΛΟΓΙΑΝΝΗΣ                                     
ΒΟΥΡΛΟΚΑΣ                                         
ΒΟΥΡΛΟΣ                                           
ΒΟΥΡΛΟΥΜΗΣ                                        
ΒΟΥΡΛΩΤΑΣ                                         
ΒΟΥΡΜΑΣ                                           
ΒΟΥΡΝΑΒΑΚΗΣ                                       
ΒΟΥΡΝΑΔΑΚΗΣ                                       
ΒΟΥΡΝΑΖΗΣ                                         
ΒΟΥΡΝΑΖΙΔΗΣ                                       
ΒΟΥΡΝΑΖΟΣ                                         
ΒΟΥΡΝΑΚΗΣ                                         
ΒΟΥΡΝΑΣ                                           
ΒΟΥΡΝΕΛΗΣ                                         
ΒΟΥΡΝΕΤΑΣ                                         
ΒΟΥΡΝΙΑΣ                                          
ΒΟΥΡΝΙΤΗΣ                                         
ΒΟΥΡΝΟΒΑΛΛΗΣ                                      
ΒΟΥΡΝΟΒΑΣ                                         
ΒΟΥΡΝΟΥΚΑΣ                                        
ΒΟΥΡΝΟΥΞΟΥΖΗΣ                                     
ΒΟΥΡΝΟΥΣ                                          
ΒΟΥΡΟΔΗΜΟΣ                                        
ΒΟΥΡΟΛΙΑΣ                                         
ΒΟΥΡΟΝΙΚΟΣ                                        
ΒΟΥΡΟΠΟΥΛΟΣ                                       
ΒΟΥΡΟΣ                                            
ΒΟΥΡΟΥΔΗΣ                                         
ΒΟΥΡΟΥΚΟΣ                                         
ΒΟΥΡΟΥΤΖΗΣ                                        
ΒΟΥΡΡΟΣ                                           
ΒΟΥΡΣΟΥΚΑΚΗΣ                                      
ΒΟΥΡΣΟΥΚΗΣ                                        
ΒΟΥΡΤΑΣ                                           
ΒΟΥΡΤΖΙΑΔΗΣ                                       
ΒΟΥΡΤΖΟΥΜΗΣ                                       
ΒΟΥΡΤΗΣ                                           
ΒΟΥΡΤΟΣ                                           
ΒΟΥΡΤΟΥΡΑΣ                                        
ΒΟΥΡΤΣΑΚΗΣ                                        
ΒΟΥΡΤΣΑΝΗΣ                                        
ΒΟΥΡΤΣΑΣ                                          
ΒΟΥΡΤΣΕΛΑΣ                                        
ΒΟΥΡΤΣΗΣ                                          
ΒΟΥΡΤΣΙΑΝΗΣ                                       
ΒΟΥΡΤΣΟΣ                                          
ΒΟΥΣΒΟΥΚΗΣ                                        
ΒΟΥΣΒΟΥΚΙΔΗΣ                                      
ΒΟΥΣΒΟΥΝΗΣ                                        
ΒΟΥΣΒΟΥΡΑΣ                                        
ΒΟΥΣΔΑΛΕΚΙΔΗΣ                                     
ΒΟΥΣΔΟΥΚΑΣ                                        
ΒΟΥΣΔΟΥΚΟΣ                                        
ΒΟΥΣΙΝΑΣ                                          
ΒΟΥΣΙΟΠΟΥΛΟΣ                                      
ΒΟΥΣΚΑΣ                                           
ΒΟΥΣΚΙΔΗΣ                                         
ΒΟΥΣΚΟΥΔΑΚΗΣ                                      
ΒΟΥΣΝΑΚΗΣ                                         
ΒΟΥΣΟΛΙΝΟΣ                                        
ΒΟΥΣΟΥΛΑΣ                                         
ΒΟΥΣΟΥΡΑΣ                                         
ΒΟΥΣΟΥΡΕΛΗΣ                                       
ΒΟΥΣΤΑΝΤΑΣ                                        
ΒΟΥΣΤΡΟΣ                                          
ΒΟΥΤΑΒΙΩΤΗΣ                                       
ΒΟΥΤΑΚΑΣ                                          
ΒΟΥΤΑΚΟΣ                                          
ΒΟΥΤΑΚΤΑΚΗΣ                                       
ΒΟΥΤΑΝΗΣ                                          
ΒΟΥΤΑΣ                                            
ΒΟΥΤΕΓΚΟΣ                                         
ΒΟΥΤΕΛΗΣ                                          
ΒΟΥΤΕΝΙΩΤΗΣ                                       
ΒΟΥΤΕΡΑΚΟΣ                                        
ΒΟΥΤΕΡΗΣ                                          
ΒΟΥΤΕΡΟΣ                                          
ΒΟΥΤΕΤΑΚΗΣ                                        
ΒΟΥΤΖΑΛΗΣ                                         
ΒΟΥΤΖΑΡΑΝΑΣ                                       
ΒΟΥΤΖΗΣ                                           
ΒΟΥΤΖΙΖΗΣ                                         
ΒΟΥΤΖΟΥΛΙΑΣ                                       
ΒΟΥΤΖΟΥΛΙΔΗΣ                                      
ΒΟΥΤΖΟΥΡΑΚΗΣ                                      
ΒΟΥΤΗΡΑΚΗΣ                                        
ΒΟΥΤΗΣ                                            
ΒΟΥΤΗΧΤΗΣ                                         
ΒΟΥΤΙΑΝΑΚΗΣ                                       
ΒΟΥΤΙΑΝΙΤΗΣ                                       
ΒΟΥΤΙΔΗΣ                                          
ΒΟΥΤΙΕΡΙΔΗΣ                                       
ΒΟΥΤΙΕΡΟΣ                                         
ΒΟΥΤΙΚΤΗΣ                                         
ΒΟΥΤΙΝΟΠΟΥΛΟΣ                                     
ΒΟΥΤΚΑΣ                                           
ΒΟΥΤΟΠΟΥΛΟΣ                                       
ΒΟΥΤΟΣ                                            
ΒΟΥΤΟΥΡΑΣ                                         
ΒΟΥΤΟΥΡΗΣ                                         
ΒΟΥΤΟΥΡΛΗΣ                                        
ΒΟΥΤΟΥΦΙΑΝΑΚΗΣ                                    
ΒΟΥΤΡΑΤΖΗΣ                                        
ΒΟΥΤΡΙΑΡΙΔΗΣ                                      
ΒΟΥΤΡΙΑΣ                                          
ΒΟΥΤΡΥΑΣ                                          
ΒΟΥΤΣΑΔΑΚΗΣ                                       
ΒΟΥΤΣΑΔΟΠΟΥΛΟΣ                                    
ΒΟΥΤΣΑΚΕΛΗΣ                                       
ΒΟΥΤΣΑΚΗΣ                                         
ΒΟΥΤΣΑΚΟΠΟΥΛΟΣ                                    
ΒΟΥΤΣΑΛΑΣ                                         
ΒΟΥΤΣΑΛΗΣ                                         
ΒΟΥΤΣΑΝΗΣ                                         
ΒΟΥΤΣΑΡΑΚΗΣ                                       
ΒΟΥΤΣΑΡΑΣ                                         
ΒΟΥΤΣΑΡΔΕΛΛΗΣ                                     
ΒΟΥΤΣΑΡΙΔΗΣ                                       
ΒΟΥΤΣΑΣ                                           
ΒΟΥΤΣΕΛΑΚΟΣ                                       
ΒΟΥΤΣΕΛΑΣ                                         
ΒΟΥΤΣΕΛΗΣ                                         
ΒΟΥΤΣΗΛΑΣ                                         
ΒΟΥΤΣΗΣ                                           
ΒΟΥΤΣΙΑΔΗΣ                                        
ΒΟΥΤΣΙΑΣ                                          
ΒΟΥΤΣΙΔΗΣ                                         
ΒΟΥΤΣΙΚΑΚΗΣ                                       
ΒΟΥΤΣΙΚΑΣ                                         
ΒΟΥΤΣΙΚΙΔΗΣ                                       
ΒΟΥΤΣΙΛΑΚΟΣ                                       
ΒΟΥΤΣΙΛΑΣ                                         
ΒΟΥΤΣΙΝΑΚΗΣ                                       
ΒΟΥΤΣΙΝΑΣ                                         
ΒΟΥΤΣΙΝΙΤΣ                                        
ΒΟΥΤΣΙΝΟΣ                                         
ΒΟΥΤΣΙΩΤΗΣ                                        
ΒΟΥΤΣΚΙΔΗΣ                                        
ΒΟΥΤΣΚΟΣ                                          
ΒΟΥΤΣΟΓΙΑΝΝΑΚΗΣ                                   
ΒΟΥΤΣΟΠΟΥΛΟΣ                                      
ΒΟΥΤΣΟΣ                                           
ΒΟΥΤΣΟΥΚΑΚΗΣ                                      
ΒΟΥΤΣΟΥΛΙΔΗΣ                                      
ΒΟΥΤΥΡΑΚΗΣ                                        
ΒΟΥΤΥΡΑΚΟΣ                                        
ΒΟΥΤΥΡΑΣ                                          
ΒΟΥΤΥΡΕΑΣ                                         
ΒΟΥΤΥΡΗΣ                                          
ΒΟΥΤΥΡΙΑΔΗΣ                                       
ΒΟΥΤΥΡΙΤΣΑΣ                                       
ΒΟΥΤΥΡΟΠΟΥΛΟΣ                                     
ΒΟΥΤΥΧΤΗΣ                                         
ΒΟΥΦΙΔΗΣ                                          
ΒΟΥΧΑΡΑΣ                                          
ΒΟΥΧΙΟΥΝΗΣ                                        
ΒΟΥΧΛΗΣ                                           
ΒΟΥΧΟΥΡΑΣ                                         
ΒΟΧΑΙΤΗΣ                                          
ΒΟΧΑΛΗΣ                                           
ΒΟΪΒΟΔΑΣ                                          
ΒΟΪΚΟΣ                                            
ΒΡΑΒΑΣ                                            
ΒΡΑΒΟΡΙΤΗΣ                                        
ΒΡΑΒΟΣΙΝΟΣ                                        
ΒΡΑΓΑΛΗΣ                                          
ΒΡΑΓΓΑΛΑΣ                                         
ΒΡΑΓΓΑΛΗΣ                                         
ΒΡΑΓΓΑΛΙΔΗΣ                                       
ΒΡΑΓΓΑΣ                                           
ΒΡΑΓΙΩΡΓΟΣ                                        
ΒΡΑΓΚΑΖΗ ΣΑΔΙΚ ΟΓΛΟΥ                              
ΒΡΑΓΚΑΛΑΣ                                         
ΒΡΑΓΚΑΛΗΣ                                         
ΒΡΑΓΚΑΛΙΔΑΣ                                       
ΒΡΑΓΚΑΣ                                           
ΒΡΑΓΚΑΤΖΗ ΣΑΔΗΚ ΟΓΛΟΥ                             
ΒΡΑΓΚΟΣ                                           
ΒΡΑΓΟΤΕΡΗΣ                                        
ΒΡΑΔΕΛΗΣ                                          
ΒΡΑΔΗΣ                                            
ΒΡΑΖΑΛΗΣ                                          
ΒΡΑΖΑΝΗΣ                                          
ΒΡΑΖΑΣ                                            
ΒΡΑΖΕΛΗΣ                                          
ΒΡΑΖΙΟΣ                                           
ΒΡΑΖΙΤΙΚΟΣ                                        
ΒΡΑΖΙΤΟΥΛΗΣ                                       
ΒΡΑΖΙΩΤΗΣ                                         
ΒΡΑΖΟΠΟΥΛΟΣ                                       
ΒΡΑΖΟΣ                                            
ΒΡΑΙΚΟΣ                                           
ΒΡΑΙΛΑΣ                                           
ΒΡΑΙΜΑΚΗΣ                                         
ΒΡΑΚΑΣ                                            
ΒΡΑΚΑΤΟΣ                                          
ΒΡΑΚΑΤΣΕΛΗΣ                                       
ΒΡΑΚΙΔΗΣ                                          
ΒΡΑΚΟΖΩΝΗΣ                                        
ΒΡΑΚΟΠΟΥΛΟΣ                                       
ΒΡΑΚΟΣ                                            
ΒΡΑΚΟΤΑΣ                                          
ΒΡΑΚΟΤΣΙΩΛΗΣ                                      
ΒΡΑΚΟΤΣΩΛΗΣ                                       
ΒΡΑΚΟΥΡΑΚΗΣ                                       
ΒΡΑΜΕΝΤΣΑΛΗΣ                                      
ΒΡΑΜΗΣ                                            
ΒΡΑΜΠΑΚΗΣ                                         
ΒΡΑΜΠΑΣ                                           
ΒΡΑΝΑΚΗΣ                                          
ΒΡΑΝΑΛΗΣ                                          
ΒΡΑΝΑΣ                                            
ΒΡΑΝΓΚΑΛΛΑΣ                                       
ΒΡΑΝΗΣ                                            
ΒΡΑΝΙΑΛΗΣ                                         
ΒΡΑΝΙΑΣ                                           
ΒΡΑΝΙΔΗΣ                                          
ΒΡΑΝΙΚΑΣ                                          
ΒΡΑΝΙΚΟΣ                                          
ΒΡΑΝΙΣΤΑΣ                                         
ΒΡΑΝΙΤΗΣ                                          
ΒΡΑΝΙΤΣ                                           
ΒΡΑΝΙΩΤΗΣ                                         
ΒΡΑΝΝΑΣ                                           
ΒΡΑΝΟΠΟΥΛΟΣ                                       
ΒΡΑΝΟΣ                                            
ΒΡΑΝΤΖΑΣ                                          
ΒΡΑΝΤΖΙΔΗΣ                                        
ΒΡΑΝΤΗΣ                                           
ΒΡΑΝΤΟΥΛΗΣ                                        
ΒΡΑΝΤΣΕΣ                                          
ΒΡΑΝΤΣΗΣ                                          
ΒΡΑΝΤΣΙΔΗΣ                                        
ΒΡΑΠΤΣΗΣ                                          
ΒΡΑΣΕΝΙΚΗΣ                                        
ΒΡΑΣΙΒΑΝΟΠΟΥΛΟΣ                                   
ΒΡΑΣΙΔΑΣ                                          
ΒΡΑΣΙΔΗΣ                                          
ΒΡΑΣΚΙΔΗΣ                                         
ΒΡΑΣΜΑΤΑΣ                                         
ΒΡΑΣΝΑΚΗΣ                                         
ΒΡΑΣΝΟΣ                                           
ΒΡΑΣΣΑΣ                                           
ΒΡΑΣΤΑΛΗΣ                                         
ΒΡΑΣΤΑΜΗΝΟΣ                                       
ΒΡΑΣΤΑΜΙΝΟΣ                                       
ΒΡΑΣΤΑΜΝΟΣ                                        
ΒΡΑΣΤΙΝΙΩΤΗΣ                                      
ΒΡΑΣΤΟΓΑΛΑΚΗΣ                                     
ΒΡΑΣΤΟΣ                                           
ΒΡΑΤΑΚΗΣ                                          
ΒΡΑΤΖΑΣ                                           
ΒΡΑΤΖΙΑΣ                                          
ΒΡΑΤΖΙΔΗΣ                                         
ΒΡΑΤΙΔΗΣ                                          
ΒΡΑΤΙΜΟΣ                                          
ΒΡΑΤΙΤΣ                                           
ΒΡΑΤΜΗΡΑΣ                                         
ΒΡΑΤΟΛΗΣ                                          
ΒΡΑΤΟΣ                                            
ΒΡΑΤΣΑΛΗΣ                                         
ΒΡΑΤΣΑΜΗΣ                                         
ΒΡΑΤΣΑΝΟΣ                                         
ΒΡΑΤΣΑΣ                                           
ΒΡΑΤΣΑΦΟΛΗΣ                                       
ΒΡΑΤΣΑΦΟΛΛΗΣ                                      
ΒΡΑΤΣΗΣ                                           
ΒΡΑΤΣΙΔΑΣ                                         
ΒΡΑΤΣΙΔΗΣ                                         
ΒΡΑΤΣΙΚΙΔΗΣ                                       
ΒΡΑΤΣΙΝΗΣ                                         
ΒΡΑΤΣΙΟΣ                                          
ΒΡΑΤΣΙΣΤΑΣ                                        
ΒΡΑΤΣΙΩΤΗΣ                                        
ΒΡΑΤΣΚΙΔΗΣ                                        
ΒΡΑΤΣΟΣ                                           
ΒΡΑΤΤΗΣ                                           
ΒΡΑΧΑΛΗΣ                                          
ΒΡΑΧΑΜΗΣ                                          
ΒΡΑΧΑΣ                                            
ΒΡΑΧΑΣΩΤΑΚΗΣ                                      
ΒΡΑΧΑΤΗΣ                                          
ΒΡΑΧΙΔΗΣ                                          
ΒΡΑΧΙΝΟΠΟΥΛΟΣ                                     
ΒΡΑΧΙΟΛΑΣ                                         
ΒΡΑΧΙΟΛΗΣ                                         
ΒΡΑΧΙΟΛΙΑΣ                                        
ΒΡΑΧΙΟΛΙΔΗΣ                                       
ΒΡΑΧΙΟΝΙΔΗΣ                                       
ΒΡΑΧΙΩΛΗΣ                                         
ΒΡΑΧΙΩΛΙΑΣ                                        
ΒΡΑΧΙΩΝΗΣ                                         
ΒΡΑΧΙΩΤΗΣ                                         
ΒΡΑΧΛΙΩΤΗΣ                                        
ΒΡΑΧΝΑΚΗΣ                                         
ΒΡΑΧΝΑΡΗΣ                                         
ΒΡΑΧΝΑΣ                                           
ΒΡΑΧΝΕΛΗΣ                                         
ΒΡΑΧΝΗΣ                                           
ΒΡΑΧΝΙΑΡΗΣ                                        
ΒΡΑΧΝΙΑΣ                                          
ΒΡΑΧΝΙΔΗΣ                                         
ΒΡΑΧΝΟΓΙΑΝΝΗΣ                                     
ΒΡΑΧΝΟΣ                                           
ΒΡΑΧΝΟΥΛΑΣ                                        
ΒΡΑΧΟΠΟΥΛΟΣ                                       
ΒΡΑΧΟΥΛΑΚΗΣ                                       
ΒΡΑΧΥΠΕΔΗΣ                                        
ΒΡΑΧΩΡΙΤΗΣ                                        
ΒΡΑΪΛΑΣ                                           
ΒΡΕΓΚΑΣ                                           
ΒΡΕΖΑΣ                                            
ΒΡΕΚΑΣ                                            
ΒΡΕΚΟΣ                                            
ΒΡΕΚΟΥΛΟΣ                                         
ΒΡΕΚΟΥΣΗΣ                                         
ΒΡΕΛΙΑΝΑΚΗΣ                                       
ΒΡΕΛΛΑΣ                                           
ΒΡΕΛΛΗΣ                                           
ΒΡΕΛΛΙΟΣ                                          
ΒΡΕΛΛΟΣ                                           
ΒΡΕΛΟΣ                                            
ΒΡΕΝΑΣ                                            
ΒΡΕΝΗΣ                                            
ΒΡΕΝΟΣ                                            
ΒΡΕΝΤΑΣ                                           
ΒΡΕΝΤΖΑΚΗΣ                                        
ΒΡΕΝΤΖΙΟΣ                                         
ΒΡΕΝΤΖΟΣ                                          
ΒΡΕΣΚΑΣ                                           
ΒΡΕΣΚΟΣ                                           
ΒΡΕΤΑΚΑΚΟΣ                                        
ΒΡΕΤΑΚΟΣ                                          
ΒΡΕΤΑΡΟΣ                                          
ΒΡΕΤΑΣ                                            
ΒΡΕΤΕΑΣ                                           
ΒΡΕΤΖΑΚΗΣ                                         
ΒΡΕΤΖΟΣ                                           
ΒΡΕΤΗΝΑΡΗΣ                                        
ΒΡΕΤΙΝΑΡΗΣ                                        
ΒΡΕΤΟΠΟΥΛΟΣ                                       
ΒΡΕΤΟΣ                                            
ΒΡΕΤΟΥΔΑΚΗΣ                                       
ΒΡΕΤΤΑΚΗΣ                                         
ΒΡΕΤΤΑΚΟΣ                                         
ΒΡΕΤΤΑΝΙΔΗΣ                                       
ΒΡΕΤΤΑΝΟΣ                                         
ΒΡΕΤΤΑΡΟΣ                                         
ΒΡΕΤΤΑΣ                                           
ΒΡΕΤΤΕΑΣ                                          
ΒΡΕΤΤΗΣ                                           
ΒΡΕΤΤΟΠΟΥΛΟΣ                                      
ΒΡΕΤΤΟΣ                                           
ΒΡΕΦΙΔΗΣ                                          
ΒΡΕΧΑΣ                                            
ΒΡΕΧΟΠΟΥΛΟΣ                                       
ΒΡΗΣ                                              
ΒΡΗΤΑΚΑΚΟΣ                                        
ΒΡΙΑΒΑΣ                                           
ΒΡΙΑΜΗΣ                                           
ΒΡΙΓΓΑΣ                                           
ΒΡΙΓΚΑΣ                                           
ΒΡΙΓΚΟΣ                                           
ΒΡΙΖΑΣ                                            
ΒΡΙΖΩΝΗΣ                                          
ΒΡΙΘΙΑΣ                                           
ΒΡΙΚΕΛΛΗΣ                                         
ΒΡΙΚΟΣ                                            
ΒΡΙΛΛΗΣ                                           
ΒΡΙΣΙΜΙΤΖΑΚΗΣ                                     
ΒΡΙΣΙΜΤΖΗΣ                                        
ΒΡΙΣΚΑΣ                                           
ΒΡΙΤΕΓΚΟΣ                                         
ΒΡΙΤΖΑΛΗΣ                                         
ΒΡΙΤΚΑΣ                                           
ΒΡΙΤΣΙΟΣ                                          
ΒΡΟΓΓΙΣΤΙΝΟΣ                                      
ΒΡΟΓΚΙΣΤΙΝΟΣ                                      
ΒΡΟΙΚΟΣ                                           
ΒΡΟΝΓΙΣΤΙΝΟΣ                                      
ΒΡΟΝΤΑΓΙΑΣ                                        
ΒΡΟΝΤΑΚΗΣ                                         
ΒΡΟΝΤΑΚΙΣ                                         
ΒΡΟΝΤΑΜΙΤΗΣ                                       
ΒΡΟΝΤΑΝΗΣ                                         
ΒΡΟΝΤΑΡΑΣ                                         
ΒΡΟΝΤΑΣ                                           
ΒΡΟΝΤΕΛΗΣ                                         
ΒΡΟΝΤΖΑΚΗΣ                                        
ΒΡΟΝΤΖΟΣ                                          
ΒΡΟΝΤΗΛΑΣ                                         
ΒΡΟΝΤΗΣ                                           
ΒΡΟΝΤΙΛΗΣ                                         
ΒΡΟΝΤΙΝΑΚΗΣ                                       
ΒΡΟΝΤΙΝΟΣ                                         
ΒΡΟΝΤΙΣΗΣ                                         
ΒΡΟΝΤΟΛΑΛΟΣ                                       
ΒΡΟΝΤΟΡΙΝΑΚΗΣ                                     
ΒΡΟΝΤΟΣ                                           
ΒΡΟΝΤΟΥΛΑΚΗΣ                                      
ΒΡΟΝΤΟΥΛΗΣ                                        
ΒΡΟΣΓΟΣ                                           
ΒΡΟΣΤΟΠΟΥΛΟΣ                                      
ΒΡΟΤΣΑΚΟΣ                                         
ΒΡΟΤΣΗΣ                                           
ΒΡΟΤΣΟΣ                                           
ΒΡΟΥΒΑΚΗΣ                                         
ΒΡΟΥΒΑΣ                                           
ΒΡΟΥΒΗΣ                                           
ΒΡΟΥΒΙΔΗΣ                                         
ΒΡΟΥΒΛΙΑΝΗΣ                                       
ΒΡΟΥΖΑΣ                                           
ΒΡΟΥΖΕΛΗΣ                                         
ΒΡΟΥΖΗΣ                                           
ΒΡΟΥΖΟΣ                                           
ΒΡΟΥΚΙΑΣ                                          
ΒΡΟΥΚΛΑΣ                                          
ΒΡΟΥΛΑΚΗΣ                                         
ΒΡΟΥΛΑΚΟΣ                                         
ΒΡΟΥΛΗΣ                                           
ΒΡΟΥΛΙΑΣ                                          
ΒΡΟΥΛΙΔΑΚΗΣ                                       
ΒΡΟΥΛΙΤΗΣ                                         
ΒΡΟΥΛΙΩΤΗΣ                                        
ΒΡΟΥΛΛΗΣ                                          
ΒΡΟΥΛΟΣ                                           
ΒΡΟΥΝΤΑΣ                                          
ΒΡΟΥΝΤΖΑΚΗΣ                                       
ΒΡΟΥΝΤΖΟΣ                                         
ΒΡΟΥΣΑΛΗΣ                                         
ΒΡΟΥΣΓΟΣ                                          
ΒΡΟΥΣΗΣ                                           
ΒΡΟΥΣΙΑΣ                                          
ΒΡΟΥΣΙΟΣ                                          
ΒΡΟΥΣΟΥΚΙΔΗΣ                                      
ΒΡΟΥΣΤΗΣ                                          
ΒΡΟΥΣΤΟΥΡΗΣ                                       
ΒΡΟΥΤΑΚΗΣ                                         
ΒΡΟΥΤΟΣ                                           
ΒΡΟΥΤΣΑΚΟΣ                                        
ΒΡΟΥΤΣΗΣ                                          
ΒΡΟΥΦΤΣΗΣ                                         
ΒΡΟΥΧΑΚΗΣ                                         
ΒΡΟΥΧΑΣ                                           
ΒΡΟΥΧΟΣ                                           
ΒΡΟΧΑΡΗΣ                                          
ΒΡΟΧΑΡΙΔΗΣ                                        
ΒΡΟΧΙΔΗΣ                                          
ΒΡΟΧΟΠΟΥΛΟΣ                                       
ΒΡΥΑΚΟΣ                                           
ΒΡΥΓΙΩΝΑΚΗΣ                                       
ΒΡΥΕΝΝΙΟΣ                                         
ΒΡΥΖΑΚΗΣ                                          
ΒΡΥΖΑΛΑΣ                                          
ΒΡΥΖΑΣ                                            
ΒΡΥΖΙΔΗΣ                                          
ΒΡΥΖΩΝΗΣ                                          
ΒΡΥΘΙΑΣ                                           
ΒΡΥΚΟΣ                                            
ΒΡΥΛΑΚΗΣ                                          
ΒΡΥΛΙΩΤΗΣ                                         
ΒΡΥΛΛΑΚΗΣ                                         
ΒΡΥΛΛΗΣ                                           
ΒΡΥΝΑΣ                                            
ΒΡΥΝΙΑΣ                                           
ΒΡΥΝΙΟΣ                                           
ΒΡΥΝΙΩΤΗΣ                                         
ΒΡΥΣΑΓΩΤΗΣ                                        
ΒΡΥΣΑΚΗΣ                                          
ΒΡΥΣΑΛΗΣ                                          
ΒΡΥΣΑΝΑΚΗΣ                                        
ΒΡΥΣΑΣ                                            
ΒΡΥΣΑΩΤΗΣ                                         
ΒΡΥΣΕΛΛΑΣ                                         
ΒΡΥΣΗΣ                                            
ΒΡΥΣΙΜΙΤΖΑΚΗΣ                                     
ΒΡΥΣΙΩΤΗΣ                                         
ΒΡΥΣΟΠΟΥΛΟΣ                                       
ΒΡΥΣΟΥΛΗΣ                                         
ΒΡΥΣΣΑΣ                                           
ΒΡΥΣΣΗΣ                                           
ΒΡΥΤΖΑΛΗΣ                                         
ΒΡΥΤΤΙΑΣ                                          
ΒΡΥΧΕΑΣ                                           
ΒΡΥΩΝΑΚΗΣ                                         
ΒΡΥΩΝΗΣ                                           
ΒΡΥΩΝΙΔΗΣ                                         
ΒΡΩΜΟΒΡΥΣΙΩΤΗΣ                                    
ΒΡΩΣΤΟΣ                                           
ΒΡΩΤΣΟΣ                                           
ΒΥΒΙΛΑΚΗΣ                                         
ΒΥΒΥΛΑΚΗΣ                                         
ΒΥΓΑΣ                                             
ΒΥΔΑΚΗΣ                                           
ΒΥΔΙΝΙΩΤΗΣ                                        
ΒΥΔΟΥΡΑΣ                                          
ΒΥΔΡΑΣ                                            
ΒΥΖΑΙΤΗΣ                                          
ΒΥΖΑΚΗΣ                                           
ΒΥΖΑΚΟΠΟΥΛΟΣ                                      
ΒΥΖΑΛΗΣ                                           
ΒΥΖΑΝΙΑΡΗΣ                                        
ΒΥΖΑΝΤΖΙΚΗΣ                                       
ΒΥΖΑΝΤΗΣ                                          
ΒΥΖΑΝΤΙΑΔΗΣ                                       
ΒΥΖΑΝΤΙΝΟΠΟΥΛΟΣ                                   
ΒΥΖΑΝΤΙΝΟΣ                                        
ΒΥΖΑΝΤΙΟΣ                                         
ΒΥΖΑΡΕΛΗΣ                                         
ΒΥΖΑΣ                                             
ΒΥΖΑΤΗΣ                                           
ΒΥΖΒΙΖΗΣ                                          
ΒΥΖΕΓΚΟΣ                                          
ΒΥΖΕΛΗΣ                                           
ΒΥΖΕΝΤΙΝΗΣ                                        
ΒΥΖΗΡΑΚΗΣ                                         
ΒΥΖΗΣ                                             
ΒΥΖΙΗΝΟΣ                                          
ΒΥΖΙΚΑΣ                                           
ΒΥΖΙΚΙΔΗΣ                                         
ΒΥΖΙΡΑΚΗΣ                                         
ΒΥΖΙΡΓΙΑΝΑΚΗΣ                                     
ΒΥΖΙΡΓΙΑΝΝΑΚΗΣ                                    
ΒΥΖΙΡΙΑΝΑΚΗΣ                                      
ΒΥΖΙΡΙΑΝΝΑΚΗΣ                                     
ΒΥΖΙΡΙΑΝΝΗΣ                                       
ΒΥΖΙΩΤΗΣ                                          
ΒΥΖΙΩΤΙΔΗΣ                                        
ΒΥΖΟΒΙΤΗΣ                                         
ΒΥΖΟΠΟΥΛΟΣ                                        
ΒΥΖΟΥΚΑΚΗΣ                                        
ΒΥΖΟΥΚΗΣ                                          
ΒΥΖΟΥΡΗΣ                                          
ΒΥΖΥΡΓΙΑΝΝΗΣ                                      
ΒΥΘΟΠΟΥΛΟΣ                                        
ΒΥΘΟΥΚΛΑΣ                                         
ΒΥΘΟΥΛΚΑΣ                                         
ΒΥΛΗΣ                                             
ΒΥΛΛΙΩΤΗΣ                                         
ΒΥΛΤΑΝΙΩΤΗΣ                                       
ΒΥΜΠΡΑΝΙΕΤΣ                                       
ΒΥΝΑΚΟΣ                                           
ΒΥΝΗΡΗΣ                                           
ΒΥΝΙΑΣ                                            
ΒΥΝΙΟΣ                                            
ΒΥΝΙΧΑΚΗΣ                                         
ΒΥΡΑΝΟΥΔΗΣ                                        
ΒΥΡΑΣ                                             
ΒΥΡΓΙΩΤΗΣ                                         
ΒΥΡΗΣ                                             
ΒΥΡΙΑΝΟΥΔΗΣ                                       
ΒΥΡΙΔΑΚΗΣ                                         
ΒΥΡΙΔΗΣ                                           
ΒΥΡΙΛΗΣ                                           
ΒΥΡΙΝΗΣ                                           
ΒΥΡΙΝΤΖΑΚΗΣ                                       
ΒΥΡΙΩΤΗΣ                                          
ΒΥΡΚΟΣ                                            
ΒΥΡΛΑΣ                                            
ΒΥΡΛΗΣ                                            
ΒΥΡΛΙΟΣ                                           
ΒΥΡΛΟΣ                                            
ΒΥΡΟΖΗΣ                                           
ΒΥΡΟΠΟΥΛΟΣ                                        
ΒΥΡΟΣ                                             
ΒΥΡΟΥΡΑΚΗΣ                                        
ΒΥΡΡΑΣ                                            
ΒΥΡΡΟΣ                                            
ΒΥΡΣΩΚΙΝΟΣ                                        
ΒΥΡΤΣΙΩΝΗΣ                                        
ΒΥΡΤΣΩΝΗΣ                                         
ΒΥΡΩΖΗΣ                                           
ΒΥΡΩΝΑΣ                                           
ΒΥΣΑΝΛΗΣ                                          
ΒΥΣΑΝΣΙΩΤΗΣ                                       
ΒΥΣΑΡΙΤΗΣ                                         
ΒΥΣΙΑΝΛΗΣ                                         
ΒΥΣΙΛΙΑΣ                                          
ΒΥΣΙΝΗΣ                                           
ΒΥΣΙΝΙΩΤΗΣ                                        
ΒΥΣΙΟΣ                                            
ΒΥΣΟΚΑΛΗΣ                                         
ΒΥΣΟΥΛΗΣ                                          
ΒΥΣΣΑΣ                                            
ΒΥΣΣΙΑΣ                                           
ΒΥΣΣΙΝΗΣ                                          
ΒΥΣΣΙΟΣ                                           
ΒΥΣΣΟΥΛΗΣ                                         
ΒΥΣΤΑΚΟΣ                                          
ΒΥΤΑΚΗΣ                                           
ΒΥΤΑΝΙΔΗΣ                                         
ΒΥΤΑΝΙΩΤΗΣ                                        
ΒΥΤΑΝΟΣ                                           
ΒΥΤΕΡΟΥΛΗΣ                                        
ΒΥΤΙΜΑΣ                                           
ΒΥΤΙΝΑΡΟΣ                                         
ΒΥΤΙΝΙΔΗΣ                                         
ΒΥΤΙΝΙΩΤΗΣ                                        
ΒΥΤΟΓΙΑΝΝΗΣ                                       
ΒΥΤΟΠΟΥΛΟΣ                                        
ΒΥΤΟΥΡΑΤΟΣ                                        
ΒΥΤΣΑΡΑΣ                                          
ΒΥΤΤΑΣ                                            
ΒΥΩΝΗΣ                                            
ΒΩΒΕΛΗΣ                                           
ΒΩΒΟΣ                                             
ΒΩΒΟΥΣΑΣ                                          
ΒΩΒΟΥΣΗΣ                                          
ΒΩΔΙΝΑΣ                                           
ΒΩΚΟΣ                                             
ΒΩΛΚΟΣ                                            
ΒΩΛΟΣ                                             
ΒΩΝΙΑΤΗΣ                                          
ΒΩΝΟΣ                                             
ΒΩΠΗΣ                                             
ΒΩΡΟΣ                                             
ΒΩΡΡΟΣ                                            
ΒΩΣΙΚΑΣ                                           
ΒΩΣΟΣ                                             
ΒΩΣΣΟΣ                                            
ΒΩΤΑΣ                                             
ΒΩΤΤΑΣ                                            
ΒΩΤΤΗΣ                                            
ΓΑΒΑΘΑΣ                                           
ΓΑΒΑΘΙΩΤΗΣ                                        
ΓΑΒΑΘΟΠΟΥΛΟΣ                                      
ΓΑΒΑΚΗΣ                                           
ΓΑΒΑΛΑΚΗΣ                                         
ΓΑΒΑΛΑΣ                                           
ΓΑΒΑΛΕΤΑΚΗΣ                                       
ΓΑΒΑΛΙΑΣ                                          
ΓΑΒΑΛΙΑΤΣΗΣ                                       
ΓΑΒΑΛΙΔΗΣ                                         
ΓΑΒΑΛΛΑΣ                                          
ΓΑΒΑΛΛΙΑΣ                                         
ΓΑΒΑΝΑΣ                                           
ΓΑΒΑΝΕΛΛΗΣ                                        
ΓΑΒΑΝΗΣ                                           
ΓΑΒΑΝΙΔΗΣ                                         
ΓΑΒΑΝΟΖΗΣ                                         
ΓΑΒΑΝΟΣ                                           
ΓΑΒΑΝΟΥΔΗΣ                                        
ΓΑΒΑΡΗΣ                                           
ΓΑΒΑΤΙΔΗΣ                                         
ΓΑΒΒΑΘΑΣ                                          
ΓΑΒΒΑΛΑΣ                                          
ΓΑΒΒΑΡΗΣ                                          
ΓΑΒΒΕΣ                                            
ΓΑΒΒΟΒΙΔΗΣ                                        
ΓΑΒΖΙΑΣ                                           
ΓΑΒΗΣ                                             
ΓΑΒΙΔΗΣ                                           
ΓΑΒΙΖΙΔΗΣ                                         
ΓΑΒΙΩΤΗΣ                                          
ΓΑΒΟΤΣΗΣ                                          
ΓΑΒΟΥΝΕΛΗΣ                                        
ΓΑΒΟΥΡΑΣ                                          
ΓΑΒΟΥΧΙΔΗΣ                                        
ΓΑΒΡΑΛΙΔΗΣ                                        
ΓΑΒΡΑΝΗΣ                                          
ΓΑΒΡΑΝΙΔΗΣ                                        
ΓΑΒΡΑΝΟΠΟΥΛΟΣ                                     
ΓΑΒΡΑΣ                                            
ΓΑΒΡΕΑΣ                                           
ΓΑΒΡΕΗΛΙΔΗΣ                                       
ΓΑΒΡΕΛΑΣ                                          
ΓΑΒΡΕΛΗΣ                                          
ΓΑΒΡΕΣΕΑΣ                                         
ΓΑΒΡΕΣΗΣ                                          
ΓΑΒΡΕΣΛΗΣ                                         
ΓΑΒΡΗΛΑΚΗΣ                                        
ΓΑΒΡΗΛΙΔΗΣ                                        
ΓΑΒΡΗΛΟΣ                                          
ΓΑΒΡΗΣ                                            
ΓΑΒΡΙΑΝΗΣ                                         
ΓΑΒΡΙΑΝΟΣ                                         
ΓΑΒΡΙΑΣ                                           
ΓΑΒΡΙΑΤΟΠΟΥΛΟΣ                                    
ΓΑΒΡΙΔΑΚΗΣ                                        
ΓΑΒΡΙΔΗΣ                                          
ΓΑΒΡΙΕΛΑΤΟΣ                                       
ΓΑΒΡΙΕΛΗΣ                                         
ΓΑΒΡΙΕΛΛΗΣ                                        
ΓΑΒΡΙΗΛΑΚΗΣ                                       
ΓΑΒΡΙΗΛΑΤΟΣ                                       
ΓΑΒΡΙΗΛΕΛΛΗΣ                                      
ΓΑΒΡΙΗΛΗΣ                                         
ΓΑΒΡΙΗΛΙΔΗΣ                                       
ΓΑΒΡΙΗΛΙΩΤΗΣ                                      
ΓΑΒΡΙΗΛΟΠΟΥΛΟΣ                                    
ΓΑΒΡΙΚΙΔΗΣ                                        
ΓΑΒΡΙΚΟΥΔΗΣ                                       
ΓΑΒΡΙΛΑΚΗΣ                                        
ΓΑΒΡΙΛΑΣ                                          
ΓΑΒΡΙΛΕΛΛΗΣ                                       
ΓΑΒΡΙΛΗΣ                                          
ΓΑΒΡΙΛΙΑΔΗΣ                                       
ΓΑΒΡΙΛΙΔΗΣ                                        
ΓΑΒΡΙΛΙΩΤΗΣ                                       
ΓΑΒΡΙΛΟΠΟΥΛΟΣ                                     
ΓΑΒΡΙΛΟΣ                                          
ΓΑΒΡΙΝΑΣ                                          
ΓΑΒΡΙΝΗΣ                                          
ΓΑΒΡΙΝΙΩΤΗΣ               