# Запуск проекта

## Зависимости
1. Установить [Node.js LTS](https://nodejs.org/en/download/). На момент написания документации это версия 12.18.0
2. Установить [Yarn](https://yarnpkg.com/lang/en/docs/install/)
3. Установить [Git](https://git-scm.com/download)
4. Выполнить [инструкцию](./GIT.md#пакеты-зависимостей)

## Что нужно для работы над блогом
Для начала нужно [скачать код проекта из репозитория](http://s.csssr.ru/U31J879TR/20200526180041.jpg), 
далее рекомендуем поставить [VSCode](https://code.visualstudio.com/).
В нём есть всё что вам нужно: редактор кода, терминал, графический интерфейс для работы с git.
Рекомендуем включить [авто сохранение при изменении файлов](https://stackoverflow.com/a/59500985). 
Далее мы будем описывать работу с проектом на примере VSCode.

## Как запустить проект
Открываем папку с проектом в VSCode. 
Для запуска проекта [нужно открыть терминал](https://code.visualstudio.com/docs/editor/integrated-terminal) 
и выполнить в нём следующие команды
```cmd
yarn
```
Эта команда установит все зависимости, нужные проекту.

> Возможная проблема: установка зависимостей падает с ошибкой
> ```
> error An unexpected error occurred: "https://npm.pkg.github.com/download/@csssr/[...]: Request failed
> "401 Unauthorized"
> ```
> Решение: убедись, что правильно выполнил п. 4 из [зависимостей](#зависимости)

После этого можно запускать проект:
```cmd
yarn dev
```

> Возможная проблема: запуск проекта падает с ошибкой
> ```
> {
>    code: 'EACCES',
>    errno: -4092,
>    syscall: 'listen',
>    address: '0.0.0.0',
>    port: 3000
> }
> ```
> Решение 1: если 3000-ый порт занят другим проектом, который тебе сейчас не нужен, останови его и снова выполни `yarn dev`
> 
> Решение 2: если нет возможности освободить 3000-ый порт, запусти блог на другом порту командой `yarn dev -p 8080`, где вместо 8080 укажи желаемый порт

Команду `yarn` достаточно выполнить всего один раз, команду `yarn dev` надо выполнять каждый раз, когда вы начинаете работу над блогом.

> *Локальный хост* - это адрес сервера, который вы запускаете у себя на компьютере, 
по дефолту это http://localhost:3000/. Доступ до этого адреса будет только у вас.

После того, как вы увидите [сообщение об удачной сборке проекта](http://s.csssr.ru/U02D248T6/2020-06-29-16-50-52-ks3q4_.jpg)
вы можете перейти перейти на адрес локального хоста и перед вами предстанет сайт блога.

После сохранения файла статьи достаточно обновить страницу в браузере и вы увидите изменения.

## Ну запустили проект, а дальше то что?
А дальше читаем про [работу с git](./GIT.md)
