# Создание новой статьи

## Генератор шаблона статьи

Для создания новой статьи используй команду в терминале `yarn article ru my-article-name`,
где ru это язык (возможные варианты en или ru), а `my-article-name` – это название новой статьи.
Эта команда создаст новую шаблонную статью, картинки для неё и добавит её на главную.

## Файлы статьи

Статьи находятся в папке [`_posts`](../_posts).
Название файла соответствует `url` статьи, т.e. если создать файл с именем `new-awesome-post.md` в `_posts/ru`,
то будьте уверены что сможете найти его по адресу `http://localhost:3000/ru/article/new-awesome-post`.

### Изображения

Картинки для статей находятся в папке [public/images](../public/images/). Мы можете вставлять изображения в статьи несколькими способами:

```jsx
<Img src='/foo.png' alt='Описание того что изображено на foo.png' withOutProcessing>
```

или же

```jsx
<Img imageName="foo" alt="Описание того что изображено на foo.png" />
```

В первом случае изображение не будет проходить никакую обработку и будет одинаковым на всех разрешениях. Такой вариант подходит для картинок, которые изначально были плохого качества или маленького размера и вы на это никак не можете повлиять.
Во втором случае у вас появляется возможность указать разные версии изображения для разных брейкпоинтов. Мы рекомендуем всегда использовать второй вариант синтаксиса и подготавливать разные версии изображений для разных брейкпоинтов. У нас есть следующие брейкпоинты:

| Название брейкпоинта | Границы брейкпоинта |
| -------------------- | ------------------- |
| mobile.all           | 0 - 767px           |
| tablet.s             | 768px - 1023px      |
| tablet.m             | 1024px - 1279px     |
| tablet.all           | 768px - 1279px      |
| desktop.s            | 1280px - 1359px     |
| desktop.m            | 1360px - 1919px     |
| desktop.l            | 1920px - ∞          |
| desktop.all          | 1280px - ∞          |
| all                  | 0 - ∞               |

Разные версии одного и того же изображения для разных брейкпоинтов следуют складывать в одну папку и называть согласно брейкпоинтам, на которых вы хотите их отображать. Например, у вас есть изображении `foo` и у оно у вас выглядит немного по разному на десктопе, таблете и мобилке, тогда вам нужно создать папку `foo` и положить в неё 3 изображения, каждое из которых будет названо так же как и брейкпоинт, на котором оно будет использоваться:

```
└─ foo
    ├─ mobile.all.png
    ├─ tablet.all.png
    └─ desktop.all.png
```

У нас так же есть возможность подготавливать разные изображения для экранов с разными dpi. Мы готовим три версии изображения, для экранов с 1x, 2x и 3x dpi. Так, если вы хотите, что бы ваши изображения при обработке ресайзились, то разместите исходное изображение 3x размера от его размера в статье в папке [public/images/resize](../public/images/resize).

Если не хотите ресайзить изображения при обработке, то разместите исходное изображение 1x размера его следует в папке [public/images/dont-resize](../public/images/dont-resize). Это может пригодится, когда у вас нет возможности получить исходное изображение 3x размера от его размера в статье.

Мы рекомендуем всегда ресайзить изображения.

SVG и GIF изображения всегда размещаются в папке [public/images/dont-resize](../public/images/dont-resize) и подключаются с помощью синтаксиса `<Img src='/foo.gif' alt='Описание того что изображено на foo.gif' withOutProcessing>`.

Для каждой статьи обязательно должны быть созданы картинки postCover ([Скриншот изображения «postCover» в заголовке статьи](http://s.csssr.ru/U31J879TR/20200527101626.jpg)).

## Порядок статей

Статьи сортируются по дате публикации. От ранней к поздней.

## Выделенные статьи

Для того что бы статья появилась на главной в блоке ["Выделенные статьи"](http://s.csssr.ru/UJ4QCUXM4/2021-06-11-17-33-45.jpg), нужно добавить название статьи в файл `selectedPostsByLanguage.json`. Порядок и количество определяет порядок и количество статей в блоке.
