
# Наполнение статьи

## Как писать статью
Любая статья содержит в себе мета-информацию и контент.

### Мета-информация
Мета находится в самом вверху статьи между двумя тройными тире `---`
```md
---
title: 'Это <i>пример</i> использования компонентов'
coverImageAlt: 'Описание изображения'
date: '2019-03-16T05:35:07.322Z'
tag: 'web-development'
---
```
, где

#### `title`
Заголовок статьи. Символы заключенные в тег `<i>` на страничке статьи будут отображены в шрифте Sweet Mavka Script.
Также, этот title используется для SEO и Open Graph.

#### `description`
Краткое описание статьи для SEO и Open Graph. Если не указан то для статей по умолчанию подставляется лид (первый абзац) очищенный от html тегов и MD ссылок а для новостей title новости.

#### `coverImageAlt`
Alt-текст для основного изображения статьи. Alt-текст должен описывать словами то, что изображено на картинке.
Это очень полезно для скрин ридеров.

#### `date`
Дата создания статьи в формате [ISO-8601](https://ru.wikipedia.org/wiki/ISO_8601)

#### `tag`
Раздел в блоге, к которому относится статья

### Контент
Контент статьи это [маркдаун](https://www.markdownguide.org/getting-started/#whats-markdown), но с апгрейдами.
Помимо [стандартного синтаксиса маркдауна](https://www.markdownguide.org/basic-syntax/)
в нём можно использовать специально подготовленные кастомные компоненты, которые мы разработали для нашего блога.

[Подробнее о кастомных компонентах](./COMPONENTS.md).
