---
title: 'Итоги <i>2019</i></br> от CSSSR'
coverImageAlt: 'Преображение фронтенда в 2019'
author: 'Максим Вислогуров'
date: '2019-12-26T00:00:00.000Z'
tag: 'web-development'
---

## Пролог

---

**Ж**иву один в сталинке в ЦАО. Звукоизоляция от внешнего мира потрясающая, ибо стены из кирпича больше метра толщиной (где снаружи пилястры идут — больше полутора). От соседей звукоизоляция так себе, но это компенсируется их малой активностью, доходящей до незаметности. Неважно. Не суть.

<Img imageName='zann' alt='image'/>

Часто я сижу в полнейшей тишине такого масштаба, что начинает казаться, что на десятки метров вокруг меня нет ничего живого в доме. Совершенная, абсолютная, полная тишина. Я выключаю свет, зажигаю свечи в канделябрах моего дореволюционного Мюльбаха и в густом бархатном охристом полумраке играю на гитаре, импровизируя в недобрых модальных ладах с недобрыми интервалами. Ощущения охуенные, чувствую себя мамкиным Эрихом Цанном. А если серьезно, тишина и общий антураж таковы, что реально ощущение, будто за окном Москва <span class="no-wrap">1919-го</span>, и как раз только что Осоргина посадили в корабль смерти, а <span class="no-wrap">кого-то</span> ведут под Варсонофьевский гараж.

И в этой циклопической, почти хтонической тишине, в ставшей уже аметистовой комнате, ты видишь его...

## 10 лет немого крика...

...кажется, подходят к концу. Всё началось в мае 2009 года с первым релизом Ноды, потом через год релиз AngularJS, потом были knockout, meteor и backbone. Наконец релиз React в мае <span class="no-wrap">2013-го</span>. Рывок JavaScript от jQuery до полноценных фреймворков оказался таким сильным, что в тот момент в сознании <span class="no-wrap">IT-индустрии</span> появилось понятие «фронтенд разработка».

Нет, конечно, такое понятие было и раньше, но тогда речь не шла о полноценной разработке ПО, с полноценным релизным циклом. Интерфейсы пилили те же бэкендеры, но с каждым годом сидеть на двух стульях становилось всё сложнее. Ибо, повторяюсь, качественный рывок JS был таким сильным и таким быстрым, что появилась потребность в новой профессии разработчиков софта.

## Всё JavaScript

10 лет насмешек над «снежинками» и «наследование не на классах? Ха-ха», «вот так просто взять и создать объект? Умора!».

Но что мы имеем сейчас? Всё JavaScript. Не только веб-интерфейсы. Игровые тоже, и это не «индюшатина», а <a href="https://www.youtube.com/watch?v=Pkf9H3XEMoE" target="_blank">Battlefield</a>. Electron и React Native — для устройств. Даже TensorFlow имеет порт на JavaScript.

Посмотрите на ТОП-50 гитхаба. JavaScript стал символом опенсорс-разработки, раскатистым гимном того, что программирование доступно каждому пользователю Интернета.

На этом, думаю, с ретроспективой покончено. Самое время перейти к «широко известным в узких кругах» событиям, не вошедшим в новогодний <span class="no-wrap">хит-парад</span> подкаста «Новости 512».

## Deno

<Img imageName='deno' alt='deno'/>

Это новый (альтернативный?) виток эволюции Node, за авторством всё того же Райана Дала.

Помните скандал c <a href="https://habr.com/ru/post/431360/" target="_blank">event-stream в ноябре прошлого года?</a> Тогда малварь утекла на тысячи машин. Возможность достучаться к файловой системе — ахиллесова пята Node.

В отличие от Node, Deno, по умолчанию, выполняет код в «песочнице». Это означает, что у среды выполнения нет возможности выполнить «посторонние» скрипты или работать с файловой системой. (На самом деле доступ есть и к файловой системе, и переменным окружения, но для этого нужно передать специальные ключи)

Вторая киллер фича — TypeScript из коробки, никаких конфигов, никаких лоадеров. По сути получается, что Deno — это рантайм для TS.

## Мультиязычность GraalVM

У GraalVM в этом году <a href="https://github.com/oracle/graal/releases/tag/vm-19.0.0" target="_blank"> первый стаблильный релиз</a>

Всё в лучших библейских традициях. Вместо воды и вина интерпретаторы и компиляторы. GraalVM не даст возникнуть «вавилонскому столпотворению» в коде. Да, все по-прежнему будут «говорить» на разных языках, но при этом понимать друг друга.

По сути это универсальная виртуальная машина для выполнения разных языков, в том числе и JS. Мы можем запускать приложения на разных языках в одной среде с возможностью шаринга данных между ними. Соответственно, можно юзать разные библиотеки (из разных ЯП) в одном проекте.

## CommonJS -> AMD -> UMD -> «It don’t matter if you’re black or white»

<Img imageName='mjs' alt='mjs'/>

Да-да, это те самые michael-jackson-файлы (`.mjs`). А если говорить общепринятым языком, <a href="https://nodejs.org/api/esm.html#esm_ecmascript_modules" target="_blank">ECMAScript Modules</a>.

В этом году был 12-й мажорный релиз Ноды, который ускорил доставку новой модульной системы в наши светлые репозитории. Фича пока экспериментальная, и всё не так радужно до сих пор, но работа активно ведется, и по сути это один из первых больших шагов на пути к стандартизации модульной системы в JS.

## BigInt

Математика больших чисел в этом году <a href="https://developer.mozilla.org/ru/docs/Web/JavaScript/Reference/Global_Objects/BigInt" target="_blank">заехала</a> во все популярные браузеры, за исключением Egde. Но Edge простительно, сами понимаете <a href="https://www.theverge.com/2019/11/4/20942038/microsoft-edge-chromium-release-date-new-logo-features" target="_blank">из-за чего</a>.

В финтехе часто приходится работать с большими числами. Для тех же арифметических операций над числами с плавающей точкой теперь можно эмулировать <span class="no-wrap">какой-нибудь</span> BigDecimal, используя BigInt. До этого такие механики создавались с помощью сторонних библиотек.

Очевидно, что нативная реализация должна быть существенно производительней текущих <span class="no-wrap">third-party</span> решений.

## Нет виртуального DOM. Нет фреймворков поверх фреймворков. Нет фреймворка в рантайме. Есть Svelte. И тот <a href="https://www.youtube.com/watch?v=NvNe4nKmZT0&feature=emb_title" target="_blank">«исчезающий»</a>.

Строго говоря, само существование Svelte не ново. В этом году был релиз аж третьей версии. Но именно после третьей версии о <a href="https://habr.com/ru/post/446026/" target="_blank">Svelte</a> <a href="https://habr.com/ru/post/449450/" target="_blank">заговорили</a>. Да как заговорили! Сотни комментов только к статьям-переводам. И речь не про косяки Реакта или очередной «You don’t need Redux».

А <span class="no-wrap">добавить-то</span> и нечего. Основные понятия я уже вынес в подзаголовок. А для поленившихся тогда, но желающих «потыкать или хотя бы одним глазом глянуть» — вот образцовый интерактивный <a href="https://svelte.dev/tutorial/basics" target="_blank">учебник</a>.

## Logux

Ещё одно детище отечественного опенсорса, собранного под эгидой Андрея Ситника и его алчущих «ваших мозгов» <a href="https://cultofmartians.com/done.html" target="_blank">марсиан</a>. Тут ситуация сродни Svelte: о технологии знают достаточно давно. Среди киллер-фич были замечены:

- offline first,
- синхронизация между вкладками,
- упрощение (и часто _замещение_) клиентского Redux.

Но только в этом году Logux сошёл с ярких страниц гитхаба и получил отдельный <a href="https://logux.io/guide/architecture/core/" target="_blank">ресурс с документацией</a>.

По словам Андрея:

<Quote>
Само собой, сайт построен не на популярных <span class="no-wrap">реакт-решениях</span>. В треде расскажу об экспериментах, которые удалось в нём реализовать. 17 килобайт веса, 100 очков на Lighthouse, никаких фреймворков. Фокус на DX и UX.
</Quote>

Помимо исходников в твите все могут изучить <a href="https://evilmartians.com/chronicles/new-home-for-logux-pouring-love-into-an-oss-documentation-website" target="_blank">развёрнутый пост</a> Андрея о разработке доки, чтобы «заглянуть под капот новому лицу Logux».

## Эпилог

Мы заигрались за 10 лет становления JavaScript и фронтенда. Да так успешно, что все в награду получили аметистового протодракона. Сейчас покажу, как это вышло:

<div class='grid-element wow'>
  <Img imageName='wow1' alt='wow1'/>
  <Img imageName='wow2' alt='wow2'/>
  <Img imageName='wow3' alt='wow3'/>
  <Img imageName='wow4' alt='wow4'/>
  <Img imageName='wow5' alt='wow5'/>
  <Img imageName='wow6' alt='wow6'/>
  <Img imageName='wow7' alt='wow7'/>
  <Img imageName='wow8' alt='wow8'/>
  <Img imageName='wow9' alt='wow9'/>
</div>

<style type="text/css">
  .wow picture:not(:first-of-type) {
    margin-top: 0;
  }
</style>

Ну было же? Было?

С ежегодной речью выступил Максон «Черная Борода» Вислогуров. До новых встреч в новом десятилетии! Все по драконам!

<Img imageName='outro' alt='outro'/>
