---
title: "Стимуляторы работы программиста. <br/><i>Мотивация</i>"
coverImageAlt: "Личный опыт борьбы с прокрастинацией"
author: 'Евгений Вецель'
date: '2019-03-18T00:00:00.000Z'
tag: 'culture'
---

<Subtitle>Ведущий JS-разработчик CSSSR Евгений Вецель — о том, как повысить производительность, развить суперспособности и получать от работы больше удовольствия.</Subtitle>

---

**И**так, вы обставили свой домашний офис, выбрали клавиатуру, настроили высоту кресла, поставили фотку любимого кота на рабочий стол (ещё нет? Тогда вам сюда: <a href="/ru/article/work-better">Глава 1. Обстановка</a>). Пора приступать к работе. Но... не хочется!

## Глава 2. Мотивация

Представим, что будущее уже наступило и каждый человек — немного киборг. Удобно: чтобы выполнять свою задачу более эффективно, достаточно что-то подкрутить, что-то перепрошить, а в особых случаях нажать кнопку «Boost». В настоящем, к сожалению, всё сложнее. Чтобы начать что-то делать и довести это до конца, нам всегда нужно, пусть и минимальное, волевое усилие. Вот об этих тонких материях мы и поговорим в этой главе.

<div class='grid-element hr text_regular_m'>\* \* \*</div>

Мозг человека так устроен, что в нём, на самом деле, тоже есть кнопка, которая умеет включать на сто процентов память, внимание и высокую производительность. За таким состоянием закрепилось название «потока», и оно относится не только к программированию, но к любой деятельности. Другое дело, что нажимать эту кнопку умеют далеко не все. В деле мотивации нужно найти то, что вас «зажигает». Это может быть похвала и оценка окружающих: человек — существо социальное, и в этом нет ничего страшного. В таком случае постарайтесь не предупреждать, что вы задумали грандиозный проект. То, что вы будете делать его втайне и ожидать похвалу, нужно именно вам.

Если мы говорим о более общих закономерностях, то, думаю, ни для кого не секрет, что память и работа мозга улучшаются, если информация интересна. Прокрастинация и производительность тоже напрямую зависят от интересности задачи.

Но суровая реальность такова, что, несмотря на корону, никто не обязан давать вам только интересные задачи. Скучные проекты не означают, что руководство вас особенно не любит. Просто то, что интересно другим, не всегда интересно вам, и наоборот. Все люди разные.

<Img imageName='motivation1' alt='motivation'/>

Если хотите быть полезным универсалом, учитесь делать любую задачу интересной для себя. Очень многие люди ждут музу и вдохновение, ждут понедельника или начала года, а некоторые — переезда или появления отдельного кабинета, тем самым оправдывая своё безделье и прокрастинацию.

Как унылую задачу сделать интересной? Для запоминания скучной информации, вроде списка покупок, часто используют мнемонические приёмы (например, придумывают смешные образы, ассоциирующиеся с тем, что нужно запомнить). Но что делать с полноценной задачей? Ответ: рассмотреть её повнимательнее, оценить опыт, который можно получить, выбрать другой способ выполнения, чтобы превратить её из скучной в увлекательную. Вам дали задачу оцифровать целую тонну xls файлов и превратить в таблицы БД с вложенностью, а сделать это больше некому? Напишите автоимпорт с ручным принятием решения там, где программа затрудняется с ответом. И, чтобы снизить градус нудности задачи, всю редактуру текста делайте в vim, попутно изучая его горячие клавиши. Научитесь хитрить.

Даже если вы не можете заставить себя взяться за задачу и постоянно откладываете её выполнение, просто сядьте за компьютер, откройте текстовый редактор и начните делать подготовительную работу. Постепенно втянетесь. Наверняка вы помните моменты, когда начинали скучную задачу и вам тут же хотелось пойти сделать мелкие дела, устроить небольшой перерыв, покушать, налить чай, постирать носки. Возьмите в такой момент большой фонарь и осветите преступника, осознайте, что вы намеренно пытаетесь улизнуть.

Если вы будете читать статьи про прокрастинацию (вместо работы, конечно же), то в них обычно всего два вывода. Первый — прокрастинация усиливается, когда вы предъявляете к себе и к ожидаемому результату завышенные требования, боитесь ошибок и провала. Перфекционизм — самая часто встречающаяся причина прокрастинации.

<Img imageName='motivation2' alt='sculptor'/>

Второй вывод — проблема усиливается, когда вы испытываете чувство вины и стыда за то, что не можете себя заставить работать. Именно ощущение вины, вечное чувство долга и боязнь добавить в копилку ещё один долг могут заставить вас откладывать дело. Вывод: вам стоит научиться говорить «стоп» самому себе. Идеал недостижим, а чувство вины никуда не приведёт, поэтому давайте переходить к действиям.

<div class='grid-element hr'>\* \* \*</div>

Итак, поговорим о состоянии потока. Об этом легко ускользающем состоянии, когда всё получается и делается легко, когда ты проваливаешься в задачу и выполняешь её с упоением. Для начала напомню, что работать можно и без состояния потока. Не думайте о потоке, просто работайте работу. Если вам тяжело сконцентрироваться, вы чувствуете, что сегодня не тот день, вы устали, не выспались, объелись, глаза слипаются — займитесь простыми делами, не требующими гениальных решений.

Если вы не в настроении — можете сделать полезное дело для себя же. Поступайте как опытные столяры: достаньте все необходимые материалы, инструменты, метизы и крепежи, почистите все свои фуганки, рейсмусы, подключите стружкоотсос. Когда все подготовительные работы проведены, приступите к задаче. Если всё под рукой, вы легко сделаете ту самую универсальную модалку, даже не заметив, как прошёл всего час, а вы выполнили задачу, которую планировали делать весь прошлый год.

Как ещё помочь себе войти в состояние потока? Вспомните фильм «Начало». Используйте триггер. Я люблю один простой приём: включать определённую музыку только во время работы. У меня есть плейлист, который я прослушал уже более тысячи раз. Если начал отвлекаться — открыл новостной сайт, социальные сети или приступил к чтению книги — выключаю плейлист. Должен вырабатываться рефлекс: конкретная музыка = работа. Можно придумать и другой ритуал, который поможет вам включиться в процесс.

Есть ещё один момент: мозг может отказываться садиться за работу, если знает, что сейчас будет непредсказуемый по времени сеанс. Ему нужно выспаться, приготовить все необходимые химические вещества, морально подготовиться. Если вы регулярно работаете запоями и истощаете все ресурсы, не предупреждая мозг о том, сколько продлится работа, то в следующий раз он обязательно подберёт приёмы, которые позволят отложить эти выматывающие сеансы самоистязания. Именно поэтому нужны регулярные перерывы.

<div class='grid-element hr text_regular_m'>\* \* \*</div>

Для организации рабочих интервалов есть различные техники, например «Pomodoro». Это когда вы заводите будильник на 25 или 52 минуты (или другой индивидуально подобранный промежуток). А после того, как он прозвонил, сбегаете с рабочего места отдохнуть. Отдых длится, соответственно, 5 или 17 минут. Во время перерыва у вас тоже тикает таймер, чтобы не появилось соблазна удлинить отдых. Лично у меня в это время идет процесс обдумывания прошлой «помидорки», и после перерыва я зачастую или переписываю, или вообще удаляю код, который написал, не подумав.

Человеку свойственно зацикливаться, поэтому важно уметь выходить из этого состояния, отвлекаться и смотреть на свою работу со стороны. Так вы легко обнаружите, что занялись «копипастом», уже четыре «помидорки» подряд изобретаете велосипед, забыли учесть ещё одно состояние алгоритма или не обработали ошибки.

<Img imageName='motivation3' alt='pomodoro'/>

Техника Pomodoro помогает не отвлекаться. Вы отключаете все уведомления, кроме самых важных, и предупреждаете коллег, что работаете по этой системе. Тогда все сообщения будут накапливаться и вы сможете перед окончанием «помидорки» просмотреть уведомления и начать на них отвечать. Как проверить, нужно ли вам отключать уведомления? Если по выходным, рано утром или поздно вечером, когда все ушли с работы и не отвлекают, вам работается лучше и вы успеваете за эти пару часов сделать больше, чем за весь день — бинго. 25 минут без вас спокойно обойдутся, поэтому заводите таймер.

Человек многозадачен лишь в теории, он как JavaScript в браузере. Кажется, что можно выполнять задачу и смотреть фильм в фоне. На самом же деле, мозг будет постоянно переключаться между фильмом и программированием, а потом ты удивляешься, как так вымотался, делая простейшую задачу. Делайте одно дело за раз, а остальные забывайте, а лучше записывайте.

Сейчас вообще процветает <a target="_blank" href="https://ru.wikipedia.org/wiki/Клиповая_культура">«клиповое мышление»</a> — всё должно мелькать, мы потребляем информацию быстро, не жуя, на огромной скорости. Мы перестаём читать длинные книги, большие статьи, вести собственную базу знаний. Через нас проходит сотня уведомлений, новостей, проектов, задач, дел, и мы впадаем в панику, если пару часов телефон лежит в стороне и молчит. Мы ощущаем себя оторванными от мира, боимся, что за день без интернета отстанем от жизни и уже никогда не догоним. Это не так.

Опять же, возьмите большой фонарик и осветите преступника «уведомление». Он вас отвлекает. Он вам мешает. Он поглощает всё ваше внимание. Вы превращаетесь в short messages поколение. Всё это незаметно, по грамму, по десять тратит ваше внимание.

Я люблю представлять, что вся моя мотивация, желание работать, действовать, думать, читать — это «мыслетопливо» (ёмкий термин, который ввёл Максим Дорофеев в книге <a target="_blank" href="https://www.mann-ivanov-ferber.ru/books/dzhedajskie-texniki/">«Джедайские техники»</a>). Работая, ты его тратишь. Отдыхая — накапливаешь. Многие думают, что, когда они прокрастинируют, мыслетопливо накапливается. На самом деле, оно только тратится на все те мелкие дела, которые выдумывает прокрастинирующий. Сесть на диван, закрыть глаза и ничего не делать — вот это верный путь накопления. Вся идея мыслетоплива в том, что нужно уметь анализировать себя и понимать, что конкретно в вашем случае его потребляет, а что производит. И постарайтесь расходовать его продуктивно. Доставайте большой фонарь и освещайте все свои попытки потратить энергию на всякую ерунду.

Да, и напоследок: не забывайте похвалить себя в конце работы. Если вас критикуют — подумайте, прислушайтесь, поправьте корону на голове, ухмыльнитесь и продолжите быть крутым.
