---
title: 'Стимуляторы работы программиста. <br/><i>Обстановка</i>'
coverImageAlt: 'Личный опыт борьбы с помехами'
author: 'Евгений Вецель'
date: '2019-02-28T00:00:00.000Z'
tag: 'culture'
---

<Subtitle>Ведущий JS-разработчик CSSSR Евгений Вецель — о том, как повысить производительность, развить суперспособности и получать от работы больше удовольствия.</Subtitle>

---

**В**се хотят написать гениальный код на одном дыхании и после рабочего дня удовлетворенно смотреть на уменьшившийся список задач. Но у одних это получается регулярно, у других только пока Луна в Козероге, а у кого-то практически никогда. Как же себе помочь?

В интернете на каждом шагу встречаются книги, курсы и вебинары по личной эффективности и повышению производительности. Как показывает практика, волшебного рецепта нет. Зато есть много, казалось бы, мелочей, из которых можно сделать неплохой бодрящий коктейль. В этом цикле статей я не буду давать готовых решений, а поделюсь своим практическим опытом и выводами, полученными в результате многолетних экспериментов над собой. Буду рад, если что-то из этого окажется полезным и сделает вашу жизнь качественно лучше.

## Глава 1. Обстановка

Как ни «революционно» это звучит, но условия труда влияют на производительность не только на фабриках. Для тех, кто работает в офисе, этот вопрос частично уже решен. Удалённые сотрудники сталкиваются, с одной стороны, с необходимостью самостоятельно обеспечивать себе все условия, с другой — с полной свободой действий.

Как я себе представляю программирование большой сложной системы: ты в голове выстраиваешь из хрустальных игральных карт дворец, учитываешь все коммуникации, удобство интерфейсов, просчитываешь вес конструкции, делаешь запас прочности, стараешься не забыть про все требования, пытаешься интегрироваться с чужим полцарством... Так, стоп, кувалдой в центральную башню — Бах! — Пусть осколки тут полежат, потом соберёшь, что случилось? А это всего лишь короткий вопрос от семейства: «Кушать будешь?», а для тех, кто работает в офисе, сообщение: «Молоко, яйца, хлеб и вкусненькое». Про то, как бороться с отвлечением, мы ещё поговорим в дальнейших статьях, а сейчас — о самой обстановке.

<div class='grid-element hr'>\* \* \*</div>

Многие успешные стартапы начинались в <a target="_blank" href="https://www.blog.google/products/maps/inside-googles-original-garage-1998-style/">гараже</a>. В гараже много хлама, помещение не похоже на офис, а чтобы начать работу, приходится выгонять автомобиль. Вместо стола — доски, зимой холодно, летом жарко. Обстановка вроде бы не способствует созданию шедевров... Ан нет, я всё же думаю, что именно гараж, в немалой степени, идеальный образ офиса для многих. В нём нет близких, которые отвлекают, зовут покушать, заходят задать якобы не сильно отвлекающий вопрос: «Ты просто скажи — да или нет». При отключенных мессенджерах даже летящий к гаражу метеорит не сможет вас отвлечь от процесса создания универсальной модалки.

<Img imageName='place' alt='place'/>

«Подожди, парень, — скажете вы, — то были другие времена. Вот давай мы тебя сейчас посадим за самый дешёвый ноутбук Acer с TFT экраном с разрешением 1024 пикселей и заставим собирать при помощи webpack тяжёлый проект — как ты запоёшь? Какая будет производительность? Давай мы ещё тебя посадим на табурет, вместо стола будет пара картонных коробок, а позади тебя рабочие будут усердно грузить чеснок».
«Сложно будет», — отвечу я. Но нормальный программист должен воспринимать такие условия как хороший повод потренировать свою помехозащищённость. Профи могут выйти с такого ноутбука в облако, настроить там среду разработки и комфортно работать, попутно обучившись новому навыку настройки серверов.

Ок, палку не перегибаем, в крайности не впадаем. На картоне не работаем, Windows 95 не используем, неудобные стулья, мышки, клавиатуры обходим стороной. Пока вы ещё джуниор и не имеете большого стажа сидения за компьютером, ваш организм не подаёт сигналов. Чуть позже от коллег, из статей, а, не дай Бог, и от своих кистей или поясницы вы услышите: «Друг, купил бы ты хороших инструментов, а то мы скоро тебе покажем прелести остеохондроза, туннельного синдрома и прочих радостей, которые при определённой настойчивости могут сделать тебя инвалидом!»

<div class='grid-element hr text_regular_m'>\* \* \*</div>

Я много лет экспериментировал со своим рабочим местом, оно менялось многократно и самым разным и диким образом, и в итоге сделал для себя вывод, что лучше всего — классическое рабочее место с эргономичным креслом и удобным столом, хорошей вентиляцией и изоляцией от внешнего шума.

Всё это я организовал у себя на балконе с тройным зеркальным остеклением, кондиционером и теплым полом. Главный плюс балкона — полная изоляция от квартиры. Я могу слушать музыку без наушников, никому не мешая, и мне, в свою очередь, тоже никто не мешает. Можно сказать, это такой современный аналог гаража в российской действительности. Главный минус — внутренний резко континентальный климат: солнце может превратить балкон в 40-градусную теплицу (даже ноутбук чуть вздулся от жары). Поэтому задумывать балкон как постоянный кабинет означает запланировать приобретение кондиционера.

Один из самых актуальных вопросов — мониторы. Сколько их должно быть? Какого размера? Может, хватит экрана ноутбука? Как это влияет на производительность? Путём долгих экспериментов я выяснил, что если у вас достаточно большой монитор, то производительность при добавлении ещё одного монитора может и упасть. Ведь есть вероятность, что вы расположите там чат или будете тратить время на дирижирование окнами. Кстати, отвлекитесь, поставьте менеджер окон, который умеет двигать окна горячими клавишами. Вы никогда не ставили запись своего экрана и не смотрели таймлапсом за своей работой? Попробуйте, вы удивитесь и сделаете полезные выводы. Так сколько мониторов нужно для высокой производительности? Ответ: не меньше одного. Дальше уже вопрос практики и личных предпочтений.
Лично я обожаю повернутый на 90 градусов экран — почти все статьи, сайты, код, чаты, да практически всё, кроме видео, удобнее смотреть на таком экране. Скроллинг почти не нужен, и глаза находят информацию мгновенно.

Что ещё помогает мне каждый день?
Механическая <a target="_blank" href="https://geekboards.ru/product/leopold-fc660c-gray">клавиатура Leopold</a> на topre клавишах. <a target="_blank" href="https://www.youtube.com/watch?v=e9QxYYGPhjA">Беспроводной трекбол</a> — спасение от профболезней программистов. <a target="_blank" href="https://www.apple.com/shop/product/MMEF2AM/A/airpods">Apple-наушники</a> с микрофоном.

В понятие обстановки я бы также включил звуки при работе. Это может быть музыка, звуки природы, звук кафе, шум дороги, ролики с обучением на фоне, работающий телевизор. Как они влияют на производительность? Сильно. Но всё это индивидуально. Когда далее будем говорить о прокрастинации и психологии производительности, я выскажу своё мнение на тему влияния этих звуков. Если коротко, фоновый звук можно превратить в триггер включения в работу, главное правильно им распорядиться.

<div class='grid-element hr text_regular_m'>\* \* \*</div>

Ну вот, неплохое рабочее место мы устроили, но, может быть, что-то забыли и его можно сделать ещё лучше? Тут, главное, не впадать в крайности. Организовывая своё рабочее место, очень многие попадают в западню, которую я называю _инструментальная прокрастинация_. Если вместо того, чтобы доделать модалку для Джарвиса, вам захотелось подвигать стул, отрегулировать стол, закрыть окно, протереть клавиатуру, поменять разрешение монитора или добавить новый — поздравляю! Вы сейчас инструментально прокрастинируете.

<Img imageName='cave' alt='cave'/>

Стол, стул, большое количество мониторов, лучшая в мире клавиатура, мышка с трекпадом, рядом беговая дорожка, массажное кресло, доставка еды по расписанию, кресло-мешок, переговорка и спортзал, где можно вздремнуть, отдельный кабинет, коллеги, с которыми можно посоветоваться... Многие думают, что именно этого не хватает, чтобы быть производительным: «Вот сейчас у меня этого всего нет, поэтому я отложу сложную задачу с развитием своего домашнего проекта, так как не хватает ни времени, ни обстановки. Да и спал я не очень, так что завтра...»
Но западня как раз в том, что чем больше у вас будет денег, тем больше вы будете инструментально прокрастинировать. Вы будете сливать все ваши доходы на эксперименты, вы будете улучшать ваше рабочее место. Вы будете доводить его до идеала, а производительность будет вырастать только на недельку-две, а потом снова падать.

Вот теперь я открою секрет, который от вас скрывали всю вашу жизнь. Будь у вас деньги, кабинет, всё оборудование и знания железного человека, вы бы не сделали эту универсальную модалку быстро, без боли и не устав. Вы точно так же будете отвлекаться, вам тяжело будет сконцентрироваться, вы будете нервничать на тему нечёткого ТЗ и нелюбимого фреймворка. Так и будете летать и спасать мир с неправильно работающей модалкой в вашем железном шлеме.

Для меня однажды было откровением, что задача программиста не всегда будет интересной. Язык, на котором нужно написать код, не должен быть хорошим. Фреймворк, который выбрал заказчик, не обязан быть модным. Хороший программист при наличии альтернатив, конечно, выбирает оптимальные инструменты, но он должен уметь выполнить свою задачу и при «военном положении». Нужно уметь захотеть выполнить задачу. Как захотеть? Ответ в следующей <a href="/ru/article/work-harder">главе «Мотивация»</a>.
