---
title: 'Алгоритм чтения<br/> книг по <i>программированию</i>'
coverImageAlt: 'Описание изображения'
author: 'Борис Ванюшин'
date: '2016-10-11T00:00:00.000Z'
tag: 'culture'
---

---

**В**сем привет. Меня зовут Борис, я JavaScript-разработчик в команде Вега. Уже несколько лет я увлекаюсь теорией обучения и запоминания — тем, как работает мозг с новой информацией. Сегодня я поделюсь своим способом читать книги.

Возможно вы слышали про алгоритм чтения книг, который позволяет сохранить в голове максимум информации. Про него мне рассказал тренер по скорочтению, а позднее я увидел этот алгоритм у Бюзана в книге «Супермышление».

## Алгоритм для обычных книг

Всё очень просто:

1. Читаем автора и название;
2. Задаем вопросы, ответы на которые мы хотим найти в книге;
3. Пролистываем: разглядываем картинки, цитаты;
4. Читаем содержание, оглавление, аннотации;
5. Читаем книгу (чем быстрее, тем лучше);
6. Выделяем основную тему;
7. Выделяем факты и новизну;
8. Пролистываем книгу;
9. Опционально: записываем в табличку в экселе, о чем книга, кто ее посоветовал, стоит ли перечитывать и почему.

Если через полгода нужно будет вспомнить, что было в той книге, ее можно будет просто пролистать — этого будет достаточно. Работает отлично с книгами по психологии, переговорам, маркетингу, etc.

Увы, читать таким способом книгу Дэвида Флэнэгэна «JavaScript. Подробное руководство, 6-е издание» или ng-book бессмысленно и бесполезно. В голове не останется ничего, а время потеряется. И вообще, техника скорочтения для подобных книг скорее вредна, чем полезна.

Когда-то я занимался по книжке «Learn Ruby the hard way» (когда она еще была бесплатной). Главный ее принцип в том, что вам нужно перепечатать 100 программ. Конечно, часть из них нужно улучшить, но главное — это перепечатать 100 листингов. В процессе перепечатки неизбежны ошибки. А в процессе поиска и исправления ошибок приходит понимание того, что собственно в программе делается. Чуть позже я посмотрел курс на Coursera про то, как правильно выстроить процесс собственного обучения, и постепенно у меня сформировался собственный алгоритм чтения технической литературы.

## Алгоритм для технической литературы

Выглядит он так:

1. Формулируем задачу, которую мы хотим решить, прочитав книгу;
2. Начинаем читать медленно и внимательно, перепечатывая каждый из приведенных листингов;
3. Регулярно — раз в полчаса-час — делаем паузу и вспоминаем, что именно мы делали предыдущий час;
4. Заканчивая очередную тему, смотрим, достаточно ли мы узнали для того, чтобы решить задачу;
5. Медленно, но верно дочитываем до конца;
6. Еще раз вспоминаем, про что была книга;
7. Пишем программу, используя максимум того, что было в книге.

**Формулируем задачу, которую мы хотим решить, прочитав книгу**

Мозг наш устроен таким образом, что гораздо лучше ищет и сохраняет информацию, если понимает, что и зачем он ищет. Задачи могут быть разными, но чем лучше вы представляете, что вам надо, тем эффективней будет чтение.

**Начинаем читать медленно и внимательно, перепечатывая каждый из приведенных листингов**

Ключевое слово «медленно» — не нужно торопиться, особенно если в этой теме вы еще ничего не понимаете или понимаете не все. Здесь принцип тот же, что и с книжкой по ruby: ручной труд порождает ошибки —> ошибки порождают задачи —> решение задач тренирует мозг и добавляет понимания.

**Регулярно — раз в полчаса-час — делаем паузу и вспоминаем, что именно мы делали предыдущий час**

Как ни странно, пауза в 5-10 минут позволяет мозгу структурировать информацию, а значит лучше ее сохранить и оперативней доставать, если понадобится.

**Заканчивая очередную тему, смотрим, достаточно ли мы узнали для того, чтобы решить задачу**

И если достаточно, то либо заканчиваем чтение (вернемся к этой книге, когда появится в этом необходимость), либо дополняем и расширяем задачу. Важно, что сделать это нужно до того, как вы начнете читать дальше: попробуйте дополнить задачу и придумать, как ее можно было бы решить в идеальном мире.

**Медленно, но верно дочитываем до конца**

Ну или перестаем читать, потому что узнали все, что было нужно.

**Еще раз вспоминаем, про что была книга**

Я смотрю оглавление и воспроизвожу в голове, о чем шла речь, потом просматриваю листинги и вспоминаю, какие там ошибки были у меня. Если встречаются очень объемные и сложные программы, то можно в самых сложных местах в каждой строке прокомментировать, что и зачем там происходит.

**Важно! Пишем программу, используя максимум того, что было в книге**

Наш мозг крайне рациональная штука и то, что не используется, очень быстро отмирает и забывается. Чтобы новые знания улеглись на свои места, нужно применить их сразу.

На этом мой алгоритм заканчивается. Если ему следовать, то можно извлечь из каждой книги максимум пользы. Но все же главное — это не забывать, что читать книгу хоть как-нибудь в 100500 раз полезнее, чем откладывать прочтение, чтобы все сделать правильно, но потом.

## Полезные ссылки

- [Супермышление](http://www.ozon.ru/context/detail/id/2678641)
- [Флэнэган. Javascript подробное руководство](http://www.ozon.ru/context/detail/id/19677670)
- [ng-book](https://www.ng-book.com)
- [Learn Ruby the hard way](http://learnrubythehardway.org)
- [Coursera Learning how to learn](https://www.coursera.org/learn/learning-how-to-learn/home/welcome)
