---
title: 'Группы в <i>Slack</i>'
coverImageAlt: 'Иллюстрация переписки людей в чатах'
author: 'Феликс Экстер'
date: '2016-02-18T16:01:00.000Z'
tag: 'management'
---

---

**В** [Slack](https://slack.com/), как и в любом другом чатике, есть удобная возможность обратиться к кому-либо через `@user` по имени или нику. Для всех ник становится ссылкой и при клике открывается меню для это пользователя. А самому пользователю ник подсвечивается и автоматически отправляется&nbsp;уведомление.

Но что, если нужно обратиться сразу к нескольким пользователям? Есть несколько способов это сделать.

<Img imageName='slack' alt='Логотип Slack'>

## Первый способ: переход на [платный&nbsp;Slack](https://slack.com/pricing)

### Плюсы платного Slack

- Есть встроенная возможность разделение на группы.
- Неограниченные интеграции.
- Неограниченный файловый хостинг.
- Неограниченная история сообщений и поиск по ним.
- Подробная статистика.
- Доступ гостям.
- И прочее.

### Минусы платного Slack

Не смотря на большое количество плюсов, для платной версии есть и минусы:

- Дорого. Минимальный тарифный план — $6.67 за человека в первый месяц и $8 — в последующие.
- Кастомизируемость интерфейса не предусмотрена, кроме цветовой схемы.
- Нет встроенных видеозвонков (скоро&nbsp;появится).

## Второй способ: имитация групп через подсвечивание слов

Для этого в [настройках уведомлений](https://slack.com/account/notifications#highlight_words_div) в поле Highlight words можно перечислить через запятую все необходимые группы.

<Img imageName='highlight' alt='Страница настроек slack, с выделенными ключевыми словами'>

Чтобы узнать, какие группы существуют или добавить новую, можно использовать [встроенного бота](https://slack.com/customize/slackbot), добавив ключевые слова, чтобы он на них реагировал и постил справку об этом.

<Img imageName='bot-settings' alt='Страница настроек бота, с выделенными группами'>

Ответ от бота для `-groups`:

```js
Type `@` with one of these groups: `manager`, `react`, `js`. Example: `@example`. It will send notifications automatically when you add necessary groups in Highlight Words: https://slack.com/account/notifications#highlight_words_div
```

Ответ от бота для `-channels`:

```js
Type `#` with one of channels in Slack. Example: `#example`. It will send notifications automatically when you add necessary channels in Highlight Words: https://slack.com/account/notifications#highlight_words_div
```

Так бот отвечает в чате.

<Img imageName='bot' alt='Пример сообщения бота в slack'>

### Различие групп

Группа, начинающаяся с:

- `@` — независимая группа, выглядит как обычный текст, но может быть и ссылкой, если уже занят чьим-то никнеймом.
- `#` — группа с людьми из этого канала, становится ссылкой на канал, обычно используется для обращения в других&nbsp;каналах.

### Плюсы от подсвечивания слов

- Бесплатно.
- Можно разделять на группы пользователей из каналов.

### Минусы от подсвечивания слов

- Необходимо каждому пользователю самому прописывать все нужные&nbsp;группы.

## Третий способ: делегирование всей рутины боту

Если чего-то не хватает в бесплатном Slack, на помощь приходит бот.

Группы можно хранить любым удобным способом, например, в конфиге или, если нужно добавлять из чата через команды, то в&nbsp;базе&nbsp;данных.

При обращении к определённой группе, если такая есть в словаре, бот ищет её в описании профиля всех пользователей и постит сообщение со списком ников, и всем этим пользователям приходит уведомление уже на уровне самого слака.

### Плюсы бота

- Бесплатно. Можно реализовывать платные&nbsp;фичи.
- Расширенная кастомизируемость сообщений.
- Можно реализовать любые фичи и даже&nbsp;помощнее.

### Минусы бота

- Необходимо написать бота (даже с использованием готовых решений).
- Заспамляет чат промежуточными сообщениями. Можно, конечно, удалять сообщение сразу же, но это будет только раздражать.
- Зависит от содержимого описания профиля с ограниченной длиной в 249 символов.

## Заключение

Когда в Slack пользователей становится много, приходит необходимость разделения на группы для тех, кто более компетентен и узко специализируется в какой-либо области. Фичи из платного Slack всегда можно реализовать альтернативными способами: как через встроенные возможности, так и через&nbsp;бота.

## Опрос на Geektimes

<Img imageName='poll' alt='Список вопросов с несколькими вариантами ответов'>

[Оригинальный пост на Geektimes](https://geektimes.ru/post/271292/).
