---
title: 'Кодекс</br> <i>тестировщика</i>'
coverImageAlt: 'В CSSSR тестировщик — это не просто собиратель чужих багов, он отличается высокой степенью самостоятельности и отвечает за качество разрабатываемого продукта'
author: 'HR-Team'
date: '2020-04-08T00:00:00.000Z'
tag: 'web-development'
---

---

**Р**азработка — это хорошо, но без тестирования — никуда. Количество проектов в&nbsp;CSSSR постоянно увеличивается. Растет штат разработки, а&nbsp;значит, растет и&nbsp;потребность в&nbsp;квалифицированных QA-инженерах. Чтобы ускорить процесс отбора, мы, аналогично вакансиям для разработчиков, придумали тестовый квест для&nbsp;QA.

Как и в случае с разработкой, только небольшая часть кандидатов справляется на достойном уровне, а значит, общему уровню тестирования точно есть куда расти. Мы дадим пару подсказок, в чём может быть дело, и как прокачать себя, а заодно получить шанс присоединиться к профессиональной команде CSSSR.

<Img src='/images/dont-resize/ru/qa-codex/art_1/all.gif' alt='Багз Банни в куче моркови' withOutProcessing>

Нет, речь не о чит-кодах :) Мы разработали своеобразный «кодекс тестировщика», следуя которому, вы сможете решать тестовые квесты (а затем и рабочие задачи) намного эффективнее. Ниже вы увидите много слов «должен». Но это вы должны не нам, а профессии, когда выбрали свой путь в тестировании.

### Тестировщик должен быть внимательным

Это, в принципе, краеугольный камень профессии — замечать то, что не заметил никто другой. Для этого наш квест наводнен подводными камнями. Иногда камни настолько мелкие, что их непросто заметить. А иногда баги настолько бросаются в глаза, что воспринимаются как должное. Так что обо всем, что вызывает у вас подозрение, стоит подумать дважды и обсудить это поведение с <a href="https://ru.wikipedia.org/wiki/%D0%9C%D0%B5%D1%82%D0%BE%D0%B4_%D1%83%D1%82%D1%91%D0%BD%D0%BA%D0%B0" target="_blank">уточкой</a>.

<Img src='/images/dont-resize/ru/qa-codex/art_2/all.gif' alt='Даффи Дак спорит со своим двойником' withOutProcessing>

### Тестировщик должен быть азартным

Не надо останавливаться на очевидных дефектах. Часто возникают ситуации, когда наиболее критичные ошибки находятся в результате выполнения нестандартных кейсов. Даже если дефект не критичен — в любом процессе важно зафиксировать его. Хороший QA не боится зайти далеко в своих проверках и зарепортить всё, что можно зарепортить.

<Img src='/images/dont-resize/ru/qa-codex/art_3/all.gif' alt='Даффи Дак с ружьём у дерева' withOutProcessing>

### Тестировщик должен думать как пользователь

Нужно уметь думать и действовать как пользователь. А лучше — как разные, и не всегда логически мыслящие, пользователи. При тестировании QA должен учитывать не только соответствие требованиям и макету, но и удобство для пользователя, и сообщать, если с этим могут возникнуть проблемы.

<Img src='/images/dont-resize/ru/qa-codex/art_4/all.gif' alt='Даффи Дак изображает лося перед поросёнком Порки' withOutProcessing>

### Тестировщик должен быть изобретательным

Никакие препятствия не должны останавливать вас на пути ловли багов. Не можете найти android определенной версии или отсмотреть Safari? Внимание! Именно для таких случаев в природе существуют онлайн-эмуляторы, и не онлайн тоже есть, есть платные версии, есть абсолютно бесплатные. <a href="https://quality-lab.ru/blog/cross-browser-compatibility-testing/" target="_blank">Вот эта статья</a> должна помочь.

<Img src='/images/dont-resize/ru/qa-codex/art_5/all.gif' alt='Даффи Дак печатает на компьютере' withOutProcessing>

### Тестировщик должен быть ловким

Познавайте науку владения инструментами. Изучайте новый инструментарий, периодически проводите ревизию старого, придумывайте новые способы, но не забывайте и про стандартные решения. Подсказка в два слова: Dev Tools.

<Img src='/images/dont-resize/ru/qa-codex/art_6/all.gif' alt='У Даффи Дака взрывается ксилофон' withOutProcessing>

### Тестировщик должен быть командным игроком

Тестировщик не работает в гордом одиночестве. Он должен уметь конструктивно общаться с командой, не бояться сообщать о проблемах и думать не только о багах, но и о тех, кто их будет чинить.

<Img src='/images/dont-resize/ru/qa-codex/art_7/all.gif' alt='Багз Банни и Даффи Дак по очереди срывают листы календаря' withOutProcessing>

Правильно оформленные репорты важны не столько проверяющим тестовый кейс, сколько самим разработчикам — ведь в итоге это делается для них. Часто нам присылают отчеты в виде тест-ранов. Задумайтесь, кому из команды, кроме лида тестирования, нужны раны на проекте? Разработчику совершенно некогда сидеть и вычитывать оттуда баги. Поэтому не лишним будет изучить или освежить в памяти принципы грамотного багтрекинга. <a href="https://habr.com/ru/company/docsvision/blog/264163/" target="_blank">Вот тут</a> собрана полезная информация по оформлению баг репортов.

### Тестировщик должен уметь оптимизировать

Даже если вы подаетесь на вакансию ручного тестировщика, навыки автоматизации рутинных задач крайне необходимы в условиях дефицита времени. Не стесняйтесь выделиться из толпы и прислать автотест. Пусть он будет максимально простым, но важно, что вы хотя бы попробовали.

<Img src='/images/dont-resize/ru/qa-codex/art_8/all.gif' alt='Багз Банни и Даффи Дак удивляются' withOutProcessing>

### Тестировщик должен быть чист умом и помыслами

Наш человек умеет аккуратно оформлять свои мысли и доносить их. Он структурирует своё решение и раскладывает его по полочкам: вёрстка, кроссбраузерность, юзабилити. Каша в работе означает кашу в голове, поэтому таких кандидатов мы отправляем доучиваться мастерству.

<Img src='/images/dont-resize/ru/qa-codex/art_9/all.gif' alt='У Даффи Дака "бегают" зрачки' withOutProcessing>

### Тестировщик должен быть немного больше, чем тестировщиком

<Img src='/images/dont-resize/ru/qa-codex/art_10/all.gif' alt='Кот Сильвестр играет на всех музыкальных инструментах сразу' withOutProcessing>

Тестировщику нужно разбираться в предмете деятельности основной команды. К примеру, мы разрабатываем фронтовую часть веб приложений. Для нас важно, когда пользователю красиво и понятно. Поэтому от своих тестировщиков мы ожидаем понимания UX и желания улучшить его <a href="https://habr.com/ru/company/jugru/blog/436196/" target="_blank">всеми возможными способами</a>.

<Img src='/images/dont-resize/ru/qa-codex/art_11/all.gif' alt='Глаза Даффи Дака крупным планом' withOutProcessing>

В CSSSR тестировщик — это не просто собиратель чужих багов, он отличается высокой степенью самостоятельности и отвечает за качество разрабатываемого продукта. QA инженеру важно понимать, что тестирование — это важная часть разработки продукта, а не какая-то отдельная стадия после. Без тестировщика не обсуждаются фичи, без апрува тестировщика запрещено идти в прод с релизом. Тестировщик — это еще и кладезь знаний о проекте. По выверенной тестовой документации можно писать спеку, а при личном общении тестировщик может рассказать всю подноготную проекта.

Если вы обладаете вышеперечисленными качествами и не боитесь принять на себя ответственность за качество продукта, то смело откликайтесь на вакансию. Мы очень вас ждем!

### Список полезных ссылок

<p><a href="http://okiseleva.blogspot.com/2014/02/blog-post_6.html" target="_blank">Список полезных книг для тестировщика</a></p>

<p><a href="https://dou.ua/lenta/articles/scheme-for-qa/" target="_blank">Универсальная схема для тестирования веб-приложения</a></p>

<p><a href="https://quality-lab.ru/blog/key-principles-of-web-testing/" target="_blank">Особенности тестирования веб-приложения</a></p>

<p><a href="http://testingchallenges.thetestingmap.org/index.php" target="_blank">Потренить свои скиллы</a></p>

Познавательные ресурсы: <a href="http://radio-qa.com/" target="_blank">Radio QA</a> <a href="https://qablog.practitest.com/" target="_blank">PractiTest</a>

Про автоматизацию: [Webdriver](https://webdriver.ru/) [Selenium](https://selenium.dev/documentation/en)

[Если вы хотите быть модным автотестером :)](https://trello.com/b/2hvbzg9y/nightwatchjs)

[Почувствуй себя автоматизатором](https://medium.com/javascript-testing/setup-javascript-based-qa-automation-testing-framework-with-nightwatch-js-selenium-web-driver-4a1b845c0a6d)

<Img src='/images/dont-resize/ru/qa-codex/art_12/all.gif' alt='Финальная заставка мультсериала Looney Tunes' withOutProcessing>
