---
title: 'Задачи аналитика на IT проекте'
coverImageAlt: 'Задачи аналитика на IT проекте'
author: 'Александра Легостаева и Юлия Гашева'
date: '2021-11-25T00:00:00.000Z'
tag: 'management'
description: 'Возьмем среднестатистический IT проект, на котором есть несколько разработчиков, QA-инженер, менеджер проектов и аналитик. Разработчики пишут код. QA-инженер обеспечивает качество. Менеджер контролирует работы по проекту. А аналитик...'
---

---

**В**озьмем среднестатистический IT проект, на котором есть несколько разработчиков, QA-инженер, менеджер проектов и аналитик. Разработчики пишут код. QA-инженер обеспечивает качество. Менеджер контролирует работы по проекту. А аналитик... что-то анализирует?

Ну, примерно. Мы попросили аналитиков **CSSSR** рассказать о своей профессии и задачах, чтобы всё, наконец, встало на свои места.

## Зачем нужен аналитик в IT

Аналитик занимается переводом с языка бизнеса на технический и наоборот. Проще говоря, это человек, превращающий «хотелку» в конкретную задачу. Так, если бизнес хочет поэкспериментировать с анализом моделей причинно-следственных связей, аналитик сформулирует это желание в функциональные требования, т.е. задачи на разработку таблиц для хранения элементов, методов редактирования и форм просмотра.

В целом процесс выглядит следующим образом:

Аналитик собирает бизнес-требования заказчика. Если это бизнес-требования, то они потребуют согласования через тернистый путь правок. После того, как требования собраны, аналитик переводит бизнес-требования в функциональные, т.е. набор конкретных изменений в системе, отвечает на возникающие вопросы разработчиков и QA-инженеров. После реализации он может подключаться к бизнес-тестированию и сдачи системы заказчику. Аналитик также может анализировать последствия введения нового функционала. Наконец, аналитик помогает менеджеру проекта и продакт оунеру вести бэклог продукта: расставлять приоритеты и управлять рисками.

## Виды аналитики

### Системный аналитик

Задача системного аналитика — анализ предметной области и формулирование требований к системам. Требования, которые чаще всего звучат довольно размыто, тщательно анализируются, переводятся на технический язык и на выходе превращаются в конкретные задачи для команды разработки.

Пример: заказчик просит добавить два дополнительных поля в отчет. На первый взгляд кажется, что задача готова к передаче в разработку, однако таких полей нет в базе данных. Системный аналитик должен выяснить, откуда брать данные для новых полей и в каком формате они должны будут выводиться, и описать все необходимые доработки в системе.

Постановка задач требует технических знаний и понимания процессов. Неудивительно, что в эту профессию чаще всего приходят люди с бэкграундом разработки, техподдержки или тестирования.

### Бизнес-аналитик

Бизнес-аналитик работает в связке с заказчиком и занимается улучшением бизнеса, используя IT-методы (но не ограничиваясь ими). Основная деятельность: анализ предметной области и перевод размытых целей бизнеса в формализованные бизнес-требования.

Бизнес-аналитик решает задачи на более высоком уровне абстракции, нежели системный аналитик. Он конвертирует в задачи на разработку глобальные цели бизнеса, а не «хотелки» отдельных заказчиков.

Пример: процесс производства изделия — от поставки сырья до конечного продукта — контролируется программным обеспечением. Главный технолог хотел бы получать детальную информацию о потерях сырья в ходе производства. Бизнес-аналитик может предложить маркировать каждое изделие штрих-кодом, взвешивать готовый продукт и передавать данные в систему.

На эту роль чаще всего приходят люди с пониманием того, как работает бизнес.

### Продуктовый аналитик

Продуктовый аналитик (он же ПА) занимается анализом использования продукта его пользователями. Он работает с пользовательскими метриками, выявляет причины различных явлений — оттока, возврата, эффекта от внедрения фич. А также придумывает А/Б тесты, воронки, ставит эксперименты и собирает предпосылки для формирования новых требований к системе, при этом не принимая участия в их разработке.

Продуктовые аналитики часто сталкиваются с анализом big data. Иногда data scientist и ПА — один и тот же человек, работающий с массивом данных компании, выгруженном в отдельное хранилище. Так или иначе, он находится на стыке бизнес-анализа и разработки, потому как хорошо понимает предметную область и разбирается в методах анализа данных.

Пример: владелец интернет-магазина хочет увеличить количество заказов. Продуктовый аналитик выясняет, что покупатели часто бросают оформление покупки на полпути. Почему? Потому что, чтобы сделать заказ, нужно заполнить множество полей в форме и подтвердить согласие с политикой конфиденциальности. Возможно, форма заказа должна быть упрощена, или стоит добавить покупку «в один клик», как у конкурентов. Аналитик проверяет гипотезы, готовит требования к доработкам и анализирует влияние нововведений на количество заказов в магазине.

## Наш опыт

Необходимость в аналитике и аналитиках назревает, когда компания достигает определенного уровня зрелости: стартуют долгоиграющие проекты, либо начинается работа в сложной предметной области. В какой-то момент у CSSSR появилось желание и возможность браться за большие проекты с бэкендом.

Раньше мы работали с аналитиками со стороны клиента, и это сказывалось на скорости разработки: результаты анализа, которые были нужны здесь и сейчас, иногда задерживались, замедляя весь процесс работы. CSSSR решила нарастить мощность, наняв в штат собственных аналитиков — это позволило команде разработки получать ответы практически мгновенно, что значительно ускорило процесс принятия решений и разработки. Стало проще и заказчикам — теперь в команде есть человек, который все объяснит на понятном бизнесу языке. Стало легче тестировать и поддерживать уже готовые решения, так как они были задокументированы не только со стороны разработки, но и со стороны бизнес-целей и задач продукта.

## Советы о документации для начинающих руководителей проекта

### Когда документация не нужна

Редкие случаи, когда документация не нужна:

- вы планируете закончить проект за месяц;
- команда проекта состоит из одного разработчика, с которым вы находитесь в тесном контакте.

Во всех остальных случаях документация нужна **на каждом проекте**.

Для заказчика это вопрос финансов. Продукт с документацией легче и дешевле поддерживать, продавать, отдавать на доработку или поддержку другому подрядчику.

Менеджеру проекта документация обеспечивает душевное спокойствие: при смене разработчика или целой команды возникает куда меньше проблем.

Разработчика документация освобождает от необходимости объяснять клиенту и менеджеру, что он делает и почему.

QA-инженерам документация необходима для подготовки тест-кейсов и понимания бизнес-требований, помогая обеспечивать более качественный подход к тестированию.

Наконец, самому аналитику документация позволяет быстро найти ответ на вопрос клиента, разработчика или другого члена команды, особенно когда проектов много. Нет смысла держать всё в голове.

### Как составить документацию

#### Пишите так, словно вы объясняете сложные вещи пятилетнему ребенку

Учтите, что этот ребенок будет задавать по три уточняющих вопроса на каждое утверждение, при этом он не знает матчасти.

#### Выбирайте самый простой язык повествования

Без деепричастных оборотов и сложноподчиненных предложений. Никто не даст вам гарантии, что через месяц вам не придется вспоминать, что вы хотели сказать этой красивой словесной конструкцией. Пишите лаконично и по делу.

#### Используйте сокращения с умом

Если человек впервые на проекте, или еще интереснее — впервые в предметной области, то ему сложно понять что таится за этими короткими словами. Место сэкономлено, а смысл не понятен. Если используете сокращения, то не забывайте добавлять их в глоссарий (-справочник проекта).

#### Используйте ссылки на требования

При написании кода мы стараемся переиспользовать уже реализованные на функции — функция перевода времени пишется один раз и повторно используется в остальных участках кода. То же самое и в документации: если требование зафиксировано в одном месте, то во всей остальной документации нужно дать на него ссылку. Это избавляет от необходимости вносить правки в каждую страницу при малейшем изменении требований.

#### Задавайте вопросы

Ответ на вопрос «зачем вам это нужно» может изменить весь подход к реализации требований. Например, заказчик считает, что ему нужно выгружать отчеты в Excel. После вопроса «зачем вам это нужно», оказывается что заказчик хочет ежедневно сравнивать показатели. Выходит, что Excel — это не главное, ведь на самом деле заказчику нужен удобный инструмент для сверки данных, который в реализации может оказаться проще и изящнее, чем обычная выгрузка отчетов в Excel.

### Как управлять изменениями и правками

Придется принять тот факт, что изменения в проект будут вноситься постоянно, поэтому вам заранее стоит обдумать процессы управления изменениями. Самый простой вариант укладывается в четыре шага:

- зафиксировать изменения в реестре (или в Jira, или в книге учета изменений), указав автора предлагаемого изменения и дату получения изменения;
- провести предварительный анализ изменений и назначить им приоритет;
- принять решение — правим, не правим, или правим, но позже;
- запланировать работу по изменениям по стандартным процессам: проектируем, реализуем, тестируем, выкатываем.

Чаще всего изменения на проектах начинаются с четвертого пункта — это вводит некоторый беспорядок в проект. В менее запущенных случаях всё-таки заводится таска в Jira.

Реестр изменений позволяет не только избавиться от необходимости держать в голове хотелки, правки и планы на будущее, но и находить слабые места в процессе разработки.

Бывает, что колоссальное количество правок по уже реализованному функционалу приходит от человека, который не был обозначен как главный контакт со стороны заказчика в части проработки требований. Скорее всего, вы пропустили еще одно заинтересованное лицо, мнение которого обязательно стоит учитывать при написании и согласовании требований. Поговорите с заказчиком: возможно, стоит подключать этого человека как можно раньше — например, на этапе проработки требований.

Реестр изменений позволяет контролировать поток правок и запросов на дополнительный функционал со стороны заказчика — он наглядно показывает, сколько времени (а значит, и денег) потребуется на реализацию всех идей. А также позволяет приоритезировать доработки.
