---
title: '<i>История фронтенда</i>. Браузер, который умел всё'
coverImageAlt: 'Супергерой в красном плаще'
author: 'CSSSR team'
date: '2021-03-03T00:00:00.000Z'
tag: 'culture'
---

<Subtitle>В первом выпуске видеосерии «История фронтенда» мы попробовали погрузиться в атмосферу середины 1993 года — времени, когда в вебе ещё не было Microsoft, рекламы и JavaScript, а было порядка 130 веб-сайтов и дюжина разных браузеров, написанных энтузиастами в свободное время.</Subtitle>

<Video width="560" height="315">
    <iframe
        width="100%"
        height="100%"
        src="https://www.youtube.com/embed/7nrDctGYOIk"
        frameborder="0"
        allow="accelerometer clipboard-write; encrypted-media; gyroscope; picture-in-picture"
        allowfullscreen
    />
</Video>
<Caption size='l'>
    Этот пост — статья-компаньон к видеоролику об истории фронтенд-разработки. Если вы его ещё не смотрели, сделайте это <a href="https://www.youtube.com/watch?v=7nrDctGYOIk" target="_blank">сейчас</a>.
</Caption>

---

**М**ы выяснили, что некоторые из вещей, которые кажутся нам куда более поздним изобретением (например, таблицы стилей, встроенный в HTML-страницу JavaScript-код, вкладки, отображение PDF и многое другое), в начале 90-х не только обсуждались, но и были реализованы на практике. Мало того, оказалось, что рядом с корявым юным вебом процветал мир «офлайн-гипермедиа». И царил в нём HyperCard — система, где можно было создавать нечто вроде media-rich веб-сайтов, со сложнейшими встроенными скриптами и анимацией… только вот доступных лишь с местного носителя. Именно HyperCard вдохновил вундеркинда по имени Пэй-Юань Вэй создать такой же могучий гипермедиа-браузер со скриптами, только в Интернете. Но тут ошеломляющий успех браузера Mosaic похоронил всех конкурентов — и история веба пошла своим путём, снова вернувшись к подобным технологиям лишь в следующие 10 лет.

**Мы поподробнее расскажем о некоторых вопросах, затронутых в ролике, — а заодно приведём цитаты из источников и ссылки на интересные материалы.**


## Реконструкция двух первых браузеров: LMB и WWW

Внимательный зритель, возможно, обратил внимание на качественную эмуляцию в видео двух первых браузеров, разработанных в ЦЕРН — графического WorldWideWeb (позже его переименовали в Nexus, по понятным причинам) и текстового Line Mode Browser. Зачастую программы из того времени не то что сложно сэмулировать — их вообще уже не найти!

<Video width="560" height="315">
    <iframe
        width="100%"
        height="100%"
        src="https://www.youtube.com/embed/3c3Rt6QbHDw?start=5"
        frameborder="0"
        allow="accelerometer clipboard-write; encrypted-media; gyroscope; picture-in-picture"
        allowfullscreen
    />
</Video>
<Caption size='s'>
    Для сравнения — вот запись настоящего WorldWideWeb на «живом» NeXT Cube.
</Caption>

Это погружение в историю стало возможным благодаря проекту WorldWideWeb Rebuild Project, организованного в честь тридцатилетия первого браузера (а вместе с ним и Веба). В 2019 году <a href="https://worldwideweb.cern.ch/colophon/" target="_blank">десяток волонтёров-«хакеров»</a> (в классическом смысле) со всего мира съехались в Швейцарию, где за пять дней штурмовки и прототипирования воссоздали эти браузеры с помощью JavaScript и React — а вдобавок сопроводили их наглядной исторической справкой и другими плюшками (вроде <a href="https://worldwideweb.cern.ch/timeline/" target="_blank">анимированной инфографики</a>: на ней видно, как несколько технологических направлений пересеклись в 1990 году в той самой судьбоносной точке).

На сайтах двух подпроектов можно прочитать про <a href="https://worldwideweb.cern.ch/code/" target="_blank">приключения команды с исходниками</a> (спойлер: единственный сохранившийся образец не удалось скомпилировать), узнать, как они воссоздали <a href="https://worldwideweb.cern.ch/typography/" target="_blank">«пиксельную» Гельветику</a> в векторе и как реализовали <a href="https://line-mode.cern.ch/makingof/" target="_blank">посимвольный вывод</a> старого терминала (с помощью чёрного «занавеса», который приоткрывается по квадратику).

А здесь можно прочитать <a href="https://adactio.com/articles/15975" target="_blank">расшифровку доклада</a> этой рабочей группы, где они рассказывают об историческом контексте своего проекта и о трудностях, которые им пришлось преодолеть, а также осмысляют историю Веба.

## NeXT умер, но дело его живёт

Заслуживает внимания и сама машина, на которой Тиму Бернерсу-Ли удалось так быстро и сравнительно легко разработать свой браузер. Он сам это не раз отмечает — мол, именно благодаря простой и удобной экосистеме NeXTSTEP он смог быстро реализовать свою идею, не тратя драгоценное время на написание собственного интерфейса или текстового движка

<Quote
    type='black'
    author="Тим Бернерс-Ли"
    linkText="Записка о браузере WorldWideWeb"
    linkHref="https://www.w3.org/People/Berners-Lee/WorldWideWeb.html"
>
  Я написал программу на компьютере NeXT. Это дало мне преимущество в виде замечательных инструментов — классная была среда в целом. По сути, я мог за пару месяцев сделать то, что пришлось бы делать около года на других платформах, потому что на NeXT многое уже было сделано за меня. Там был конструктор приложений, где можно было делать меню быстрее, чем ты их придумываешь. Были все компоненты, чтобы сделать WYSIWYG («что вижу, то и будет», то есть прямое редактирование текста на экране, как он будет печататься или выводиться) текстовый процессор. Мне оставалось лишь добавить гипертекст (добавив подкласс объекта Text)
</Quote>

Инструменты, о которых говорит Бернерс-Ли — это NeXTSTEP, программный комплекс, поставлявшийся вместе с компьютером NeXT. В него входила не только операционная система (имевшая собственное название, Mach) и приложения вроде часов, почтового клиента и органайзера, но и полный комплекс средств разработки ПО. Задумка была в том, что владелец компьютера NeXT мог разработать на нём абсолютно любые приложения для того же NeXT (об этом прямо сказано во вступлении к <a href="http://vtda.org/docs/computing/NeXT/NeXT%200.9-1.0%20Release%20Description.pdf" target="_blank">Release Notes</a> к версии 0.9–1.0 системы).

Для этого, кроме языка Objective-C, в NeXTSTEP были встроены разнообразные «киты»: например, конструктор интерфейса и модуль текстового процессора с редактором стилей и WYSIWYG-редактированием.


<Video width="560" height="315">
    <iframe
        width="100%"
        height="100%"
        src="https://www.youtube.com/embed/J36lUowZn8A?start=36"
        frameborder="0"
        allow="accelerometer clipboard-write; encrypted-media; gyroscope; picture-in-picture"
        allowfullscreen
    />
</Video>
<Caption size='s'>
    Стив Джобс задвигает речь про всесильность своего компьютера для телезрителей (в которой мудро не упоминает ни одно из его реальных преимуществ). Фигурирует скрипач.
</Caption>

Так как идеологом всей этой системы был Стив Джобс, её наработки никуда не пропали: наоборот, её ноги до сих пор торчат из самых последних версий macOS.

Например, самый базовый класс для создания текста в macOS до сих пор <a href="https://developer.apple.com/documentation/appkit/nstext" target="_blank">называется NSText</a> (так же назывался стилевой движок, использованный Бернерсом-Ли). А входит он… правильно, в класс <a href="https://developer.apple.com/documentation/appkit/nsview" target="_blank">NSView</a>. И так далее — приставку NS довольно часто можно обнаружить в документации для разработки под Mac. И преемственность не только внешняя: так, <a href="https://developer.apple.com/library/archive/documentation/TextFonts/Conceptual/CocoaTextArchitecture/Introduction/Introduction.html" target="_blank">Cocoa text system</a>, система работы с текстом macOS, <a href="https://en.wikipedia.org/wiki/Cocoa_text_system" target="_blank">произошла</a> напрямую от NSText (посредством <a href="https://en.wikipedia.org/wiki/OpenStep" target="_blank">OpenStep</a> — официальной адаптации NeXTSTEP к другим платформам, которая в итоге сама <a href="https://en.wikipedia.org/wiki/Rhapsody_(operating_system)" target="_blank">легла в основу</a> Mac OS X).

<Video width="560" height="315">
    <iframe
        width="100%"
        height="100%"
        src="https://www.youtube.com/embed/0sOyuiPtlok"
        frameborder="0"
        allow="accelerometer clipboard-write; encrypted-media; gyroscope; picture-in-picture"
        allowfullscreen
    />
</Video>

А вот подробное видеосравнение интерфейса и возможностей NeXTSTEP с современным macOS. Тут уже лес торчащих ног застилает горизонт: от <a href="https://upload.wikimedia.org/wikipedia/en/1/1d/NeXTSTEP_desktop.png" target="_blank">стандартных менюшек и «док-панели»</a> до встроенных в систему шахмат и словаря. В современном macOS даже <a href="https://www.youtube.com/watch?t=394&v=0sOyuiPtlok&feature=youtu.be&ab_channel=ComputerClan" target="_blank">сохранилась одна gif-анимация</a> из NeXTSTEP!

**Да, а ещё на машинах NeXT разработали Doom и Quake.**

<Img
    src='/images/dont-resize/ru/frontend-history-the-browser-that-could-do-everything/obama/all.gif'
    alt='Барак Обама дропает микрофон'
    withOutProcessing
    align='left'
>

## Многообраузие–1993: почему ЦЕРН не участвовал?

Что имел в виду Кайю, когда говорил про эту эпоху «Мы хотели от браузеров большего»? Если процитировать точнее, то он <a href="https://www.youtube.com/watch?t=283&v=x2GylLq59rI&feature=youtu.be&ab_channel=ChuckSeverance" target="_blank">выразился так</a>:

<Quote
    type='black'
>
  ...Вот так же и с Mosaic. Он был довольно дрянной —  но его легче было установить. И он сразу обошёл то, что мы пытались сделать, — он просто нас на корню убил в части браузеров! Потому что мы пытались сделать более сложные вещи с браузером, чем Mosaic. Вот вам пример, что порой лучшее решение задавливают — или оно появляется гораздо позже, потому что лёгкое решение… Ну, оно как вирус, растёт быстрее всех.
</Quote>

Звучит немного непонятно: кто такие «мы» и что эти «мы» пытались сделать?

<Img imageName='photo_1' alt='Фотография Бернерса-Ли и Кайю' align='left'/>

Ведь Бернерса-Ли и Кайю нет среди создателей тогдашних популярных графических браузеров. Да, Кайю в какой-то момент написал первый простенький браузер для Macintosh (Samba), но в остальном был скорее менеджером, опытным ЦЕРНовским бюрократом, улаживающим дела; а браузер Бернерса-Ли для NeXT (Nexus) так никуда и не портировали.

То есть, если читать краткую версию истории Веба, всё выглядит так: изобретатели предложили стандарт, выложили базовый фреймворк, сделали Веб общественным достоянием (кстати, как раз в результате многомесячного бодания Кайю с юридическим отделом ЦЕРН) — а потом умыли руки и уступили сцену молодым.

На самом деле у Бернерса-Ли было крайне чёткое и масштабное видение Веба как проекта — и очень сильные мнения по поводу того, какими должны быть веб-сайты, серверы и браузеры. Он крайне хотел «рулить» развитием Веба и пытался это делать.

Но увы, размер его команды никогда не превышал 3-4 человек: сам Тим, Кайю и по одному практиканту у каждого (именно таким студентом был Жан-Франсуа Грофф, который упоминался в видео, — он написал библиотеки libwww, на которых были построены почти все ранние браузеры). У них просто не было людей, времени и денег на разработку сложных продуктов. Да, ЦЕРН обладал уникальным интернет-оборудованием (он был центром первого в Европе <a href="https://cerncourier.com/a/gigabits-the-grid-and-the-guinness-book-of-records/" target="_blank">мегабитного</a> бэкбона, первым установил мегабитную связь с США, а в 1991 году пропускал через себя <a href="https://information-technology.web.cern.ch/sites/information-technology.web.cern.ch/files/02_The%20role%20of%20CERN%20is%20the%20Internet-v6-Timing%2010-Museum.pptx" target="_blank">80% мирового интернет-трафика</a>) — но Веб оставался личным проектом Бернерса-Ли (как бы побочным продуктом его деятельности по улучшению интранета ЦЕРН и созданию удобной адресной книги для сотрудников).

<Video width="560" height="315">
    <iframe
        width="100%"
        height="100%"
        src="https://www.youtube.com/embed/sBkY5NG3tck"
        frameborder="0"
        allow="accelerometer clipboard-write; encrypted-media; gyroscope; picture-in-picture"
        allowfullscreen
    />
</Video>
<Caption size='s'>
    В этом видео Жан-Франсуа Грофф рассказывает, как встроил в рабочий церновский NeXT «хак», который открыл доступ гостевым пользователям по телнету: так они могли впервые запустить браузер и скачать свой (специалисты по безопасности пробивают лоб рукой).
</Caption>

<Video width="560" height="315">
    <iframe
        width="100%"
        height="100%"
        src="https://www.youtube.com/embed/rKaAVobE-3k?start=1562"
        frameborder="0"
        allow="accelerometer clipboard-write; encrypted-media; gyroscope; picture-in-picture"
        allowfullscreen
    />
</Video>
<Caption size='s'>
    А в этом <a href="https://www.youtube.com/watch?t=1561&v=rKaAVobE-3k&feature=youtu.be&ab_channel=ComputerHistoryMuseum" target="_blank">полуторачасовом интервью</a> Музею компьютерных технологий  Жан-Франсуа Грофф вспоминает об инструментах, которые тогда использовал, и вообще о своей жизни в ЦЕРНе. Например: «У меня тогда вся жизнь была в emacs, такой текстовый редактор, который мог всё, только разве что кофе не варил». А ещё он ночами работал, а днём катался на лыжах! Полную расшифровку видео см. <a href="https://computerhistory.org/wp-content/uploads/2016/08/CHM-Oral-History-Groff-102702210-05-01.pdf" target="_blank">здесь</a>.
</Caption>

Поэтому Бернерс-Ли тратил всё своё время и силы, пытаясь повлиять на тех, кто мог «раскрутить» Веб и стать его первыми «звёздами». —  Так, в 1992 году он выторговал у начальства командировку в США и объехал там всех людей, которые разрабатывали тогда браузеры (про его полный надежд визит к Пэй-Юань Вэю см. ниже).
Но большинство тогдашних веб-разработчиков так и остались «любителями».
Конечно, в отличие от одержимого Бернерса-Ли, им трудно было представить новый мир, где Вебом пользуется каждый, а веб-разработчики влияют на все сферы жизни. Поэтому, хотя они и работали в свободное время и не за страх, а за совесть, они не возлагали больших надежд на это хобби.


> **Бесполезный факт:** из всех ранних браузеров только один не базировался на библиотеке Гроффа libwww: это был Cello. Его автор Том Брюс написал интерпретатор и движок своего браузера с нуля. Вот тут Грофф слегка <a href="https://youtu.be/rKaAVobE-3k?t=1647" target="_blank">впечатляется</a>, узнав об этом в 2009 году.

К примеру, финские студенты, которые разработали один из первых браузеров Erwise, забросили свою программу после первой же версии и разбежались после выпуска. Другие, как Дэйв Рэггетт и Пэй-Юань Вэй, воспринимали свои браузеры прежде всего как научные инструменты для отработки новых технологий — **им не приходила в голову мысль сделать свой браузер коммерческим продуктом и прославиться**.

А тщеславному и общительному Марку Андриссену — пришла: как известно, он первым стал воспринимать свой браузер как продукт, а его разработку и поддержку — как работу. Но об этом в следующий раз — когда начнутся браузерные войны, а сам Андриссен станет одной из влиятельных сил, диктующих пути развития фронтенда.

## Неслучайная простота HTML

<Img imageName='photo_2' alt='Скриншот из редактора кода с тегами html' align='left'/>
<Caption size='s'>
    У первой версии HTML никогда не было номера; обычно её называют «0.9».
    <div>Впрочем, сразу после неё вышла версия 2.0.</div>
</Caption>

Язык разметки HTML за много лет претерпел много изменений, малых и больших. Но в нашем ролике можно увидеть, насколько радикально, даже шокирующе простым он был в самый момент своего появления.
И если вчитаться в историю работы его создателя Бернерса-Ли, можно понять, что это неслучайно. Он намеренно сделал HTML настолько простым и компактным, насколько мог, — и подчеркивал, что фокус в развитии Веба не должен идти по пути усложнения HTML, который он воспринимал лишь как связку, «клей» для других компонентов (исполняемого кода, медиаконтента и т. п.). Сам Бернерс-Ли сравнивал Веб с рыночной экономикой, а HTTP и HTML — с валютой, то есть единой конвенцией взаимодействия при бесконечном разнообразии товаров и услуг.

<Img imageName='photo_3' alt='Скриншот из редактора кода с тегами html' align='left'/>

**Мало того, простота HTML имела стратегические и дипломатические цели**. Так Бернерс-Ли надеялся снизить «боль адаптации» внутри ЦЕРНа — то есть на первом рубеже внедрения технологии. А на более широком уровне — максимально устранить «боль» от потребления веб-контента на любых комбинациях «железа», операционных систем и программ.

<Quote
    type='black'
    linkText="Weaving the Web, T. Berners-Lee, 2000, p. 41"
    linkHref="https://www.w3.org/People/Berners-Lee/Weaving/Overview.html"
>
  Так как я знал, что будет сложно убедить весь мир использовать новую информационную систему, я хотел перетянуть на свою сторону всех, кого мог.
</Quote>

Именно поэтому он сделал HTML внешне похожим на SGML (которым в виде SGML GUID пользовались в ЦЕРНе; <a href="https://www.w3.org/History/1992/nfs_dxcern_mirror/rpc/doc/User/rpcuser.sgml" target="_blank">пример</a>). Благодаря этому ЦЕРН столь безболезненно перешёл на WWW: порой уже существующие рабочие SGML-документы можно было превратить в читабельный HTML, просто <a href="https://www.w3.org/2012/08/history-of-the-web/origins.htm#c6p3" target="_blank">сменив</a> расширение файла с .sgml на .html!

Поэтому же HTML так легко прощал ошибки: в отличие от идеологии SGML, он вообще не требовал строгого оформления документа (например, тегов `<body>` и `<head>` тогда ещё просто не было); а его интерпретатор просто обрабатывал знакомые теги, игнорировал и не отображал незнакомые — а всё, что осталось, выводил текстом.

Брайан Карделл (<a href="https://dev.opera.com/authors/brian-kardell/" target="_blank">Brian Kardell</a>) в своей «Крат(ень)кой истории Вселенной Веба» <a href="https://bkardell.com/blog/Brief-ish-History-of-The-Web-Part-2.html" target="_blank">приводит</a> красноречивый пример — самый старый из сохранившихся HTML-документов от 3 декабря 1990 года (<a href="https://www.w3.org/2012/08/history-of-the-web/origins.htm#c6p3" target="_blank">ссылка</a>).

В нём нет ни `doctype`, ни `<html>`, ни `<head>`, ни `<title>`, ни `<body>`. А в конце — закрывающий тег с перепутанными буквами (`</lo>` вместо `</ol>`). И ничего: он отображался тогда, и легко отобразится на любой машине сейчас, в 2020 году! **Вот поэтому HTML и был задуман столь простым**.

## Баллада про HyperCard

<Video width="560" height="315">
    <iframe
        width="100%"
        height="100%"
        src="https://www.youtube.com/embed/v9o5Ld8hpug"
        frameborder="0"
        allow="accelerometer clipboard-write; encrypted-media; gyroscope; picture-in-picture"
        allowfullscreen
    />
</Video>

В видео не упоминается об этом прямо, но HyperCard был в США по-настоящему популярным. Сейчас читать об этом очень странно — настолько успела забыться эта система. Но она породила массу интересных и колоритных проектов, которые ощущаются как какой-то альтернативный, ретрофутуристический веб-до-веба. Перечислим некоторые из них.

### Whole Earth Catalog

Один из самых знаковых HyperCard-продуктов, идеальная встреча двух идей и концепций — это оцифрованная гипертекстовая версия <a href="https://en.wikipedia.org/wiki/Whole_Earth_Catalog" target="_blank">Whole Earth Catalog</a>. Этот справочник продвинутого искателя (хиппи, анархиста, мейкера, сторонника жизни off-the-grid — словом, человека контркультуры) сам по себе был предтечей интернета. Стив Джобс <a href="https://news.stanford.edu/news/2005/june15/jobs-061505.html" target="_blank">назвал</a> его «одной из библий моего поколения, ’Гуглом’ за 35 лет до создания ‘Гугла’».

<Img imageName='photo_4' alt='Скриншот HyperCard-продукта Whole Earth Catalog' align='left'/>

Cоздатель WEC, <a href="https://en.wikipedia.org/wiki/Stewart_Brand" target="_blank">Стюарт Бренд</a>, в конце шестидесятых задумал его как всемирную базу знаний и инструментов для продвинутых людей будущего — от полезных товаров и способов построить дом или перегнать брагу до книг по самоорганизации и финансовой независимости. Его девиз, с которого каталог начинался: «Мы стали подобны богам — стоит научиться делать это хорошо» (We are as gods and might as well get good at it).

<Img imageName='photo_5' alt='Фото диска и скриншот интерфейса Whole Earth Catalog' align='left'/>

Ну а в 1988 году WEC был в виде уже <a href="https://www.nngroup.com/articles/cdrom/" target="_blank">настоящего, всамделишного гипертекста</a>, на 9742 карточках и одном компакт-диске, всего за $150. Весило всё это 413 MB (из которых звук занимал 344 MB). Монументальная вещь.

<Img imageName='photo_6' alt='Cкриншоты интерфейса Whole Earth Catalog' align='left'/>
<Caption size='s'>
    Благодаря Internet Archive теперь его можно запустить <a href="https://blog.archive.org/2020/07/08/the-whole-earth-on-cd-rom-in-hypercard-in-your-browser/" target="_blank">прямо в браузере</a>
.
</Caption>

### Beyond Cyberpunk

Ещё одна культовая энциклопедия, на этот раз попытка собрать в одном месте всё про киберпанк, и сделать это круто — так же круто, как тогда ощущался сам этот… жанр? стиль? культура?

Пока журналы вроде Mondo 2000 <a href="https://aphelis.net/wp-content/uploads/2012/06/Mondo_2000_magazine_issue_10_1993_RU_a_Cyberpunk_p30.jpg" target="_blank">шутили про несуществующую субкультуру «киберпанков»</a> (нет, эта фотография — <a href="https://www.mondo2000.com/2017/08/30/r-u-a-cyberpunk-well-r-u-punk/" target="_blank">не всерьёз</a>), коллектив гиковской BBS (электронной доски объявлений) под названием The Well решил создать своё «гипермедиа» про любимый жанр: со списком главных и новых произведений, подборкой статей и эссе, рецензиями на книги и фильмы. И, конечно, с крутейшей анимацией, звучками, случайными глитчами и прочими эффектами киберпространства.

<Img imageName='photo_7' alt='Фото диска Beyond Cyberpunk' align='left'/>

Результат превзошёл их самые дикие мечты. Во-первых, в качестве участников и авторов текстов отметилась вся элита тусовки (включая <a href="https://ru.wikipedia.org/wiki/%D0%A1%D1%82%D0%B5%D1%80%D0%BB%D0%B8%D0%BD%D0%B3,_%D0%91%D1%80%D1%8E%D1%81" target="_blank">Брюса Стерлинга</a>, <a href="https://ru.wikipedia.org/wiki/%D0%A0%D1%8E%D0%BA%D0%B5%D1%80,_%D0%A0%D1%83%D0%B4%D0%B8" target="_blank">Руди Ракера</a> и <a href="https://ru.wikipedia.org/wiki/%D0%9B%D1%8D%D0%B9%D0%B4%D0%BB%D0%BE%D1%83,_%D0%9C%D0%B0%D1%80%D0%BA" target="_blank">Марка Лейдлоу</a>). Во-вторых, сам получившийся продукт стал невероятно вирусным: о нём рассказывали, им восхищались, его переписывали, с его персонажами носили мерч, его представляли в галереях и на страницах газет.

<Img imageName='photo_8' alt='Изображение логотипа Beyond Cyberpunk’а' align='left'/>
<Caption size='s'>
    А вот и сама стопка <a href="https://archive.org/details/BeyondCyberpunkMacintosh" target="_blank">в эмуляторе на archive.org</a>.
</Caption>

Среди знаменитых фанатов BCP были Робин Уильямс, Лили Томлин, Уильям Шетнер и Билли Айдол (его киберпанк так впечатлил, что он записал про это <a href="https://www.youtube.com/watch?v=IKFPdf8-Uew" target="_blank">целый альбом</a>, которого до сих пор стесняются все поклонники киберпанка), а также режиссёр «Военных игр» Джон Бэдхем:; его футболка с девочкой-маскотом BCP Kata Sutra так понравилась актрисе Бриджит Фонда, что та <a href="https://boingboing.net/2014/09/12/into-the-future-the-making-of.html" target="_blank">выклянчила её себе</a>.

**Сегодня в сети существует <a href="http://www.streettech.com/bcp/" target="_blank">веб-версия Beyond Cyberpunk</a>: расширенная, дополненная… но совсем не такая волшебная.**

### Myst и Cyan

Даже если бы в HyperCard, программе для создания презентаций и картотек, просто создали хоть сколько-то популярную игру — это уже было бы интересно. Но в ней создали Myst — самую успешно продаваемую в истории игру для PC (лишь через 9 лет её обошли The Sims), первый игровой killer app для CD-дисководов и одну из самых важных PC-игр в принципе.

<Img imageName='photo_9' alt='Фото содержания издания Myst' align='left'/>

Это был не первый опыт Cyan Inc. с HyperCard: до этого её основатели братья Миллер создали в программе целых три псевдоквеста. «Псевдо» они не потому, что плохие: идеей Миллеров было создавать «игры-игрушки» для детей, без концовки и условий победы. В этих играх (<a href="https://store.steampowered.com/app/63630/The_Manhole_Masterpiece_Edition/" target="_blank">The Manhole</a>, <a href="https://store.steampowered.com/app/63620/Cosmic_Osmo_and_the_Worlds_Beyond_the_Mackerel/" target="_blank">Cosmic Osmo and the Worlds Beyond the Mackerel</a> и <a href="https://store.steampowered.com/app/63640/Spelunx_and_the_Caves_of_Mr_Seudo/" target="_blank">Spelunx</a>) игрок просто путешествовал по забавным и сюрреалистичным закольцованным мирам, тыкал в предметы и персонажей и наблюдал за эффектом.

<Video width="560" height="315">
    <iframe
        width="100%"
        height="100%"
        src="https://www.youtube.com/embed/t4wqbzb1xc0"
        frameborder="0"
        allow="accelerometer clipboard-write; encrypted-media; gyroscope; picture-in-picture"
        allowfullscreen
    />
</Video>
<Caption size='s'>
    Ремастер-версия игры The Manhole — с закадровой озвучкой и цветной графикой.
</Caption>

Делая Myst, Миллеры сохранили фирменную любовь к сюру, но добавили в рецепт сложные головоломки и более взрослую эстетику (и лишь потом, со скрипом — куцый сюжет). Игра нагрузила HyperCard до предела: из программы <a href="http://myst.patchallel.com/myst_fl.html" target="_blank">вырезали</a> все лишние модули и управляли ей через XCMD-команды. Всего в игре было больше 2500 карточек, с отдельными стопками для каждой из «Эпох» (миров).

<Video width="560" height="315">
    <iframe
        width="100%"
        height="100%"
        src="https://www.youtube.com/embed/94pzx_9LkVI?start=666"
        frameborder="0"
        allow="accelerometer clipboard-write; encrypted-media; gyroscope; picture-in-picture"
        allowfullscreen
    />
</Video>
<Caption size='s'>
    Ролик о создании Myst. Можно видеть окно со скриптом на HyperTalk.
</Caption>

Создатели <a href="http://myst.patchallel.com/myst_fl.html" target="_blank">говорили</a>, что благодаря HyperCard они имели возможность быстро менять в программе что угодно до самого релиза — ведь HyperCard не компилировался, а содержимое карточек и стопок можно было в любой момент отредактировать напрямую.

<Quote
    type='black'
    author="Рэнд Миллер"
>
  Чувствую, если бы мы писали Myst на C или Pascal, мы бы до сих пор над ним сидели.
</Quote>

### Сожаления Аткинсона

В ролике упоминается, что Билл Аткинсон, создатель HyperCard, жалел о том, что не догадался сделать его сетевым. Об этом можно прочесть в <a href="https://www.wired.com/2002/08/hypercard-what-could-have-been/" target="_blank">статье</a> о нём в Wired:

<Quote
    type='black'
    author="Билл Аткинсон"
    linkText="интервью WIRED, 2002"
    linkHref="https://www.wired.com/2002/08/hypercard-what-could-have-been/"
>
  Со временем я осознал, что промахнулся с HyperCard. Я вырос в «Эпл», в «культуре коробочек». Если бы вырос бы в фирме Sun с её «культурой сетей», быть может, HyperCard стал бы первым веб-браузером. <...> Я думал, что связать всех людей по сети — это фантазёрство. Как же я ошибался.
</Quote>

Кто знает? Выйди HyperCard в интернет — может быть, Apple смог бы определить всю инфраструктуру и форматы будущего веба; а потом, используя это как рычаг, всё-таки опрокинул бы «Майкрософт»! Но вышло иначе.

<Video width="560" height="315">
    <iframe
        width="100%"
        height="100%"
        src="https://www.youtube.com/embed/ejdgTVj7ZG8?start=402"
        frameborder="0"
        allow="accelerometer clipboard-write; encrypted-media; gyroscope; picture-in-picture"
        allowfullscreen
    />
</Video>

А вот творческий вечер Аткинсона, где он сравнивает HyperCard с open source и «гитхабом до гитхаба» — потому что сами скрипты стопок были читаемыми и открытыми: ими обменивались подобно свободному ПО или панк-зинам.

>**Тёплый, ламповый апп**
>
>Сегодня создатель HyperCard Билл Аткинсон — фотограф дикой природы. Он создал <a href="https://apps.apple.com/us/app/photocard-by-bill-atkinson/id333208430" target="_blank">собственное приложение для AppStore</a>, которое позволяет создать, распечатать и послать почтовую открытку по почте прямо из iPhone или iPad: внутри можно выбрать одну из фотографий Билла или загрузить свою, украсить это дело стикерами и шаблонами (его собственного дизайна) и написать послание.
>
>Самое странное, что после этого макет отправляется на почту самому Аткинсону — тот каждый день встаёт в 5 утра, отсылает макеты в типографию, а потом рассылает конверты по почте. Он говорит, что больше всего в жизни гордится этим приложением и его возможностями. Такие дела.
>
>И сам Билл, и его жена <a href="https://www.wired.com/2002/08/hypercard-what-could-have-been/" target="_blank">до сих пор используют</a> HyperCard. Он написал себе адресную книгу и приложения для работы и обновления веб-сайта; а его жена, Сиу полностью управляет семейным бизнесом через большую стопку HyperCard собственной разработки..

### HyperCard сегодня

Множество случайно сохранившихся стопок можно найти в специальной коллекции на <a href="https://archive.org/details/hypercardstacks" target="_blank">archive.org</a>. Нет-нет и вспомнят о системе на YouTube:

<Video width="560" height="315">
    <iframe
        width="100%"
        height="100%"
        src="https://www.youtube.com/embed/_h92eJI33Gk"
        frameborder="0"
        allow="accelerometer clipboard-write; encrypted-media; gyroscope; picture-in-picture"
        allowfullscreen
    />
</Video>
<Caption size='s'>
    Усидчивый блогер обозревает различные игры под HyperCard
</Caption>

А на инди-игровой платформе Itch.io даже провели тематический игровой джем, <a href="https://itch.io/jam/merveilles-hyperjam/entries" target="_blank">Merveilles HyperJam</a>. Одной из созданных игр стал стильный «демейк» культового Silent Hill P. T.:

<Video width="560" height="315">
    <iframe
        width="100%"
        height="100%"
        src="https://www.youtube.com/embed/f2ft1uovxaQ"
        frameborder="0"
        allow="accelerometer clipboard-write; encrypted-media; gyroscope; picture-in-picture"
        allowfullscreen
    />
</Video>

## Ещё больше про Пэй-Юань Вэя и его «Виолу»!

**Казалось бы, видео и так целиком посвящено восхвалению браузера ViolaWWW — куда уж дальше? Но поверьте,: там действительно есть ещё о чём поговорить.**

<Img imageName='photo_10' alt='Фотография Пэй-Юань Вэй' align='left'/>
<Caption size='s'>
    Одна из двух фотографий Вэя,
    <div>которые получается найти в «гугле».</div>
</Caption>

Начнём с мимоходом брошенной ремарки, из которой следует, что Пэй-Юань Вэй тогда чуть было не создал собственный Веб (т. е. инфраструктуру для сетевого гипертекста). Конкретно об этом пишут Р. Кайю и Ж. Жильи в книге «Как зарождался Веб»:

<Quote
    type='black'
    linkText="How the Web Was Born, R. Cailliau & J. Gillies, 2000, p. 214"
    linkHref="https://books.google.ru/books?id=pIH-JijUNS0C&pg=PA214&redir_esc=y#v=onepage&q&f=false"
>
  Оболочка X Window была системой на базе Unix, поэтому TCP/IP в неё уже был встроен, и использовать Интернет было вполне логично. Теперь вопрос был в том, как пересылать его «Viola-страницы» через Интернет. [Вэй] был на грани того, чтобы независимо изобрести сетевой гипертекст. “И тут я читаю e-mail Тима про World Wide Web”, вспоминает он. “URL — это было очень, очень умно; это было точно то, что мне нужно”. Он послал Тиму письмо, мол, “хочу написать браузер под иксы”. “Хорошая идея”, ответил ему Тим в рассылке www-talk 9 декабря [1991 г.]. Через четыре дня Пэй Вэй объявил на www-talk о том, что создал браузер.
</Quote>

Эта догадка может показаться натянутой. Но, вчитываясь в историю Вэя и оценивая амбициозность его идей, становится даже странно — насколько резко и полностью он исчез из публичного пространства интернет-разработки.

<Img imageName='photo_11' alt='Фотография Тим Бернерс-Ли' align='left'/>

Тот же Тим Бернерс-Ли был в прямом смысле его фанатом. Он буквально осыпал Вэя похвалами при любой возможности, и постоянно напоминал о его важной роли в развитии Веба. В 1998 году, принимая почётное членство в академии ЦЕРН, Бернерс-Ли в своей речи <a href="https://bkardell.com/blog/Brief-ish-History-of-The-Web-Part-3.html" target="_blank">сказал</a>:

<Quote type='black'>
  Должен сказать, что мне даже как-то неловко получать это почётное звание, когда есть такие люди, как Пэй Вэй… [который] прочитал о World Wide Web в рассылке и сразу создал очень интересный программный продукт — интерпретируемый язык, который мог посылать код по сети и общаться с экраном (sic)… Вообще, всё то, что он делал, далеко опередило своё время
</Quote>

<Img imageName='photo_12' alt='Фото книги Weaving the Web' align='left' withBigMargin/>

Глубину пиетета можно оценить и в книге «Сплетая Паутину» (Weaving the Web), где в рассказе о своём «паломничестве» в американские центры развития Веба (см. выше) Бернерс-Ли пишет следующее:

<Quote
    type='black'
    linkText="Weaving the Web, T. Berners-Lee, 2000, p. 63"
    linkHref="https://www.w3.org/People/Berners-Lee/Weaving/Overview.html"
>
    ...Также я встретился с Пэй Вэем, он всё ещё учился в U.C. Berkeley. Хотя Viola уже привлекла к себе внимание, сложность в её установке мешала её популярности. Мы встретились в кафе близ Сан-Франциско: моей целью было убедить его сделать установку удобнее* и внедрить функцию редактирования (я всё держался за этот идеал). Но Вэя прежде всего интересовала Viola как язык программирования; Веб для него был лишь одной из сфер применения. Я пытался подбодрить его, но без нажима. В конце концов, Viola тогда невероятно активно расширяла охват Веба. Отчасти я хотел встретить его просто чтобы сказать: “Спасибо, ты молодец”.

    Меня удивило, насколько скромно он держался и без зазнайства относился к своим идеям — учитывая, насколько классный у него был продукт. Когда я поздравил его и сказал, что, если «Виолу» развивать, она станет флагманом мира браузеров, Вэй улыбнулся и возразил, что лучше оставит свою программу личным инструментом для исследований. Позже он станет членом Digital Media Group в O’Reilly & Associates… под началом Дейла Доэрти — одного из апологетов раннего веба, который тогда создавал кучу новых интернет-продуктов. Там Вэй использовал «Виолу», чтобы демонстрировать новые онлайн-продукты с использованием разных стилей
</Quote>

На первый взгляд кажется, что Бернерс-Ли ослеплён необъяснимой любовью. Но, скорее всего, он просто ясно видел, куда должны двигаться браузеры, и хотел, чтобы их развивал именно визионер Вэй, а не прагматичный Марк Андриссен с его Mosaic (с ним Бернерс-Ли в эту поездку тоже встречался).

<Img imageName='photo_13' alt='Фото книг O’Reilly & Associates' align='left' />
<Caption size='s'>
    Кстати: O’Reilly & Associates, куда захантили Вэя, — это то самое легендарное издательство книг по программированию со <a href="https://www.oreilly.com/animals.csp" target="_blank">зверюшками</a>! (ну или <a href="https://www.reddit.com/r/shittyprogramming/comments/a6w124/rare_oreilly_books/" target="_blank">так</a>) Их начальник Дейл Доэрти прославился своим чутьём: он помогал популяризовать Unix, стоял у истоков консорциума W3C и придумал термин «Веб 2.0». Именно издательство O’Reilly создало первый в мире коммерческий веб-портал Global Network Navigator (он же первый сайт с платной рекламой) — в том же 1993 году.
</Caption>

Трагичность ситуации заключалась в том, что Вэй полностью отдавал себе отчёт в своих инновациях: он прямо говорил, что в будущем можно будет встроить функционал любых программ в браузер (как мы и делаем сегодня), полностью забыть о вопросе несовместимости форматов и об установке программ. Он также очень упорно шёл к реализации своих идей: после диплома устроился в вычислительный центр, чтобы продолжить работу над Viola, а позже развивал этот комплекс в компании O'Reilly.

<Img imageName='photo_14' alt='Фото книг O’Reilly & Associates' align='left' />

Но он не внял мольбам Бернерса-Ли, который уже тогда понимал: лишь масштабный народный успех ViolaWWW мог бы запустить Вэя на вершину, с которой он смог бы диктовать Вебу свои идеи. И всё, что для этого было нужно — сосредоточиться на самом браузере: облегчить установку* и портировать на другие платформы. А Вэй «улыбнулся и возразил».

>\* ViolaWWW действительно был крайне неудобен для новых пользователей: нужно было скачать runtime языка Viola, установить (при этом возникало немало багов и проблем), а уже в нём запускать сам браузер. И это не говоря об отсутствии портов на любые системы, кроме X Window.

**Вместо Viola «взлетел» Mosaic Марка Андриссена, чьи представления о развитии Веба резко расходились с идеями Бернерса-Ли. О его презрении к самой идее веб-стилей и «борьбе со стандартами» мы расскажем в следующих выпусках сериала, посвящённых CSS и последствиям «войны браузеров» для фронтенд-разработки.**

На этом всё. До следующей серии.

### P. S.: дополнительные источники и материалы по ViolaWWW

Вот <a href="https://web.archive.org/web/20060820145711/http://www.xcf.berkeley.edu/~wei/viola/violaHome.html" target="_blank">здесь</a> (через архив зеркала архива!) можно увидеть старый сайт ViolaWWW, где автор демонстрирует его различные уникальные особенности — включая скриншоты работающих приложений-в-странице и других важных фич. Для особенно любопытных — <a href="https://web.archive.org/web/19990127141653/http://www-pcd.stanford.edu/workshop/slides/wei/talk.html" target="_blank">конспект доклада Вэя о расширяемости браузеров</a>, который он зачитал в Стэнфорде в 1994 году. Также <a href="https://en.wikipedia.org/wiki/ViolaWWW#Firsts" target="_blank">на странице браузера в «Википедии»</a> есть несколько примеров кода на Viola для самых инновационных функций ViolaWWW.

<Video width="560" height="315">
    <iframe
        width="100%"
        height="100%"
        src="https://www.youtube.com/embed/sbK8PNhDRVM?start=516"
        frameborder="0"
        allow="accelerometer clipboard-write; encrypted-media; gyroscope; picture-in-picture"
        allowfullscreen
    />
</Video>
<Caption size='s'>
    А вот смелый товарищ запускает раннюю версию ViolaWWW на виртуальной машине; в том числе можно увидеть демо-апплеты на сайте браузера.
</Caption>

>Напоследок проясним вопрос с хронологией: почему именно 1993 год? Внимательный зритель может отметить, что Пэй-Юань Вэй <a href="https://lists.w3.org/Archives/Public/www-talk/1991NovDec/0023.html" target="_blank">написал</a> в www-talk о том, что собрал демо браузера, в декабре 1991 года; а версия 1.0 ViolaWWW вышла весной 1992 г. Уже в январе 1992 Бернерс-Ли вслух <a href="https://lists.w3.org/Archives/Public/www-talk/1992JanFeb/0002.html" target="_blank">поражается</a>, насколько браузер быстрый. А в первой релизной версии уже было большинство удачных UI-решений.
>
>Но настоящей зрелости (включая полную поддержку встроенных скриптов) ViolaWWW достиг именно весной 1993 года. Это своего рода ключевой момент: только что вышла самая первая версия Mosaic, но пока ещё активно развиваются все упомянутые браузеры. Этот переломный момент мы и выбрали.
>
>И последняя нестыковка: официальная дата публикации библиотеки libwww — ноябрь 1992 г. Как же Вэй мог на неё опираться в конце 1991? Ответ простой: в интервью Музею компьютерных технологий Жан-Франсуа Грофф <a href="https://computerhistory.org/wp-content/uploads/2016/08/CHM-Oral-History-Groff-102702210-05-01.pdf" target="_blank">уточняет</a>, что ранние версии библиотек были доступны ещё с весны 1991, просто у них не было названия. Ими и воспользовался Вэй.
