---
title: 'В этом выпуске мы поговорим о функциональном программировании в JS, работе с AbortController и об управлении памятью. Также мы коснёмся глоссария по system design и других подборок, истории бандлинга и решения Райана Дала отойти от Node.js и начать заниматься Deno. В этом выпуске, кстати, будет небольшой обзор релиза-кандидата Deno 2.0, релизы Express 5 и Firefox 131, анонс старта разработки тулчейна void(0) и основания одноимённой компании Эваном Ю, а также старт Hacktoberfest 2024.'
soundcloudLink: 'https://soundcloud.com/csssr/deno-20-rc-express-5-firefox-131-void0-ot-evana-yu-fp-v-js-hacktoberfest-2024'
date: '2024-10-08T00:00:00.000Z'
episodeNumber: 263
tag: 'news'
author: 'Ислам Виндижев'
---

Всем привет, это «Новости 512» от CSSSR. В этом выпуске мы поговорим о функциональном программировании в JS, работе с AbortController и об управлении памятью. Также мы коснёмся глоссария по system design и других подборок, истории бандлинга и решения Райана Дала отойти от Node.js и начать заниматься Deno. В этом выпуске, кстати, будет небольшой обзор релиза-кандидата Deno 2.0, релизы Express 5 и Firefox 131, анонс старта разработки тулчейна void(0) и основания одноимённой компании Эваном Ю, а также старт Hacktoberfest 2024.

<ParagraphWithImage imageName="laptopNews" >
  ### Интересные публикации

Артём Захарченко (Artem Zakharchenko) в своём блоге написал [статью](https://kettanaito.com/blog/dont-sleep-on-abort-controller) об `AbortController`. Это глобальный класс JS, который был создан для того, чтобы отменять разные операции. Это может быть запрос, какая-то другая асинхронная операция, событие и так далее. Артём в своей статье рассказывает, как пользоваться контроллером, в каких случаях его чаще всего применяют и как с его помощью отменить, в принципе, что угодно, кроме кого-нибудь в соцсетях. Есть и небольшой раздел, посвящённый обработке ошибок.
</ParagraphWithImage>

Ян Хестерс (Jan Hesters) в своём блоге поделился [опытом применения функционального программирования в JavaScript](https://janhesters.com/blog/unleash-javascripts-potential-with-functional-programming). В статье он рассказывает и показывает, как писать в функциональном стиле, как проще манипулировать данными, зачем вообще это делать. Особенно приятно, что он рассматривает азы: что такое функциональное программирование, какие в нём есть важные понятия, как они применяются к JavaScript и другие. В общем, получилось интересно и достаточно подробно. Если вы только иногда пишете стрелочные функции и не знаете о ФП, стоит почитать. Если вы уже знакомы с ФП, тоже стоит глянуть — возможно, вы будете понимать его несколько лучше.

Следующая статья посвящена ещё двум объектам — [WeakRef и FinalizationRegistry](https://habr.com/ru/companies/otus/articles/843812/), которые помогают управлять памятью. WeakRef может быть очень полезен, если нужно что-то кешировать, а FinalizationRegistry пригодится для высвобождения ресурсов, например закрытия файлов или сетевых соединений. В статье есть немного базовых сведений, примеры применения и подводные камни, с которыми можно столкнуться.

Деструктуризация — прекрасная фича, которая облегчила жизнь многих разработчиков. Именно об этой, уже привычной нам, фиче, написал [статью](https://piccalil.li/blog/a-guide-to-destructuring-in-javascript/) Мэт Маркус (Mat “Wilto” Marquis). Он затрагивает простые кейсы и постепенно двигается к продвинутым. Рассказывает о том, как работают spread и rest, которыми вы наверняка уже часто пользуетесь. И самое интересное — показывает более сложные кейсы работы с объектами. Получилась интересно: внутри много примеров, есть новые приёмчики, которые можно почерпнуть.

Фронтенд-тимлид Данила Реутов на Хабре рассказал [об опыте внедрения Playwright](https://habr.com/ru/companies/kts/articles/843054/) для тестирования Next.js проекта. Он рассказывает о том, как было принято решение писать именно интеграционные тесты, как проходило внедрение, почему выбрали именно Playwright и какие плюсы и минусы можно выделить после внедрения. Кейс не повышенной сложности, но никогда не мешает познакомиться с опытом коллег и поддержать их плюсиком на Хабре.

Следующая статья тоже о Playwright. Она посвящена [фикстурам](https://habr.com/ru/articles/848434/). Фикстуры — это объекты, которые могут быть использованы в разных тестах и помогают определить тестовое окружение (например, использовать какие-то данные, передавать объекты, настраивать предусловия). Существуют встроенные фикстуры, которые поставляются с Playwright, а бывают пользовательские, которые можно создать самостоятельно. Этот материал как раз с примерами эффективного использования фикстур. Если вы работаете с Playwright, познакомиться будет очень невредно.

Казалось, что Webpack уже доживает своё. Тем не менее он по-прежнему используется на большом количестве проектов и так просто свои позиции не сдаёт. Поэтому вот вам [гайд о создании своих Webpack-плагинов](https://habr.com/ru/articles/846022/). Он довольно базовый, но охватывает все основные аспекты разработки плагинов. В статье рассматривается их структура, основные компоненты и создаётся небольшой тестовый плагин для демонстрации. 

Теперь несколько подборок. [50 терминов системного дизайна](https://habr.com/ru/companies/timeweb/articles/846420/) вы найдёте по ссылке на следующую статью. Это скорее справочник-глоссарий, чем что-то для обучения, но хорошая отправная точка, если вы хотите начать понимать, что это такое. Внутри будут и понятные термины, и такие, с которыми вы не сталкивались. Довольно полезно: можно сразу окунуться в понятия системного дизайна, разобраться, что вам незнакомо, и изучать определённые разделы целенаправленно.

Ещё один своего рода сборник, но теперь уже о Node.js. [Принципы разработки на Node.js в энтерпрайзе](https://www.platformatichq.com/node-principles). Внутри вы найдёте довольно простые рекомендации в духе «не блокируй Event Loop» или «используйте последнюю LTS-версию», а также более продвинутые, которые касаются безопасности, работы с зависимостями и работы с API. Тоже неплохая подборочка.

Как-то давно, летом, я рассказывал о статье, собравшей в себе [более 60 приёмов отладки в девтулзах](https://habr.com/ru/companies/ruvds/articles/842428/), которые не так очевидны, полезны и могут здорово облегчить работу. Так вот, на Хабре появился перевод этого материала, так что если вы не дружите с английским — он как раз для вас. На всякий случай приложу [ссылочку и на оригинал](https://alan.norbauer.com/articles/browser-debugging-tricks).

Завершат рубрику два видео. [Первое](https://www.youtube.com/watch?v=JUS6EPMbk0U) — о прошлом, настоящем и будущем бандлинга, а [второе](https://www.youtube.com/watch?v=zxitJn9MwYs) — небольшое видео о том, как Райан Дал пришёл от Node.js к идее создания Deno.

<ParagraphWithImage imageName="manWithLaptop">
  ### Новости релизов

Доступен браузер [Firefox 131](https://developer.mozilla.org/en-US/docs/Mozilla/Firefox/Releases/131). В этой версии CSS-свойство inset-area было переименовано в position-area для подготовки к реализации якорного позиционирования (Anchor Positioning). В JS добавили поддержку ряда вспомогательных методов для итераторов. HTTP-хидер Set-Cookie теперь должен содержать атрибут Secured, если атрибут SameSite имеет значение None. Помимо этого, была добавлена поддержка сегментированных cookies.
</ParagraphWithImage>

На финишной прямой находится вторая мажорная версия Deno. Появился [релиз-кандидат версии 2.0](https://deno.com/blog/v2.0-release-candidate). В новой версии не будет глобального объекта `windows`, но будет объект `process`, что поможет проще использовать Node.js-библиотеки и код. Были представлены улучшения управления зависимостями, изменения системы разрешений. Конечно, продолжилась работа над поддержкой Node.js API — она ещё не завершена, но поддерживается уже большинством нужных и популярных API. Кроме этого добавили возможность проверки JSDoc-документации. Новая версия будет поставляться с TypeScript 5.6. Ждём полноценного релиза.

Аж 10 лет команда Express не выпускала мажорных релизов. Вышла [5-я версия фреймворка](https://www.trevorlasn.com/blog/whats-new-in-express-5), в которой дропнули поддержку старых версий Node.js, отрефакторили API и удалили некоторые старые методы. Снова представили объект `router`, добавили возможность сложного сравнения адресов в роутере с более строгими правилами применения регулярных выражений. Поработали также над обработкой ошибок и добавили проверку HTTP-кодов ответа на валидность. Больше подробностей — в release notes.

Помимо Express 5, [вышел Fastify 5](https://openjsf.org/blog/fastifys-growth-and-success). Целью этого релиза было закрытие техдолга и очистка кодовой базы от накопившихся устаревших API, а также поддержка современных версий Node.js от 20 и выше.

Не совсем релиз, но новость про ESLint. Линтер теперь [официально поддерживает JSON и Markdown](https://eslint.org/blog/2024/10/eslint-json-markdown-support/). Команда проекта делает ещё один шаг в сторону создания языконезависимой платформы. Помимо этого, можно добавить поддержку и своих языков, а плагины для Markdown и JSON были в том числе плагинами, которые должны стать примерами для остальных.

В конце рубрики отмечу релизы [Node v22.9.0](https://nodejs.org/en/blog/release/v22.9.0), [ESLint 9.12.0](https://eslint.org/blog/2024/10/eslint-v9.12.0-released/), [pnpm 9.12.0](https://github.com/pnpm/pnpm/releases/tag/v9.12.0) и веб-сервера [nginx 1.27.2](https://mailman.nginx.org/pipermail/nginx-announce/2024/XTDQ5IH4IFLPVWJSHPAVGO6BHRN76GAS.html).

<ParagraphWithImage imageName="laptopNews" >
    ### Другие новости

Эван Ю [объявил](https://voidzero.dev/posts/announcing-voidzero-inc) об основании компании VoidZero Inc. Компания займётся созданием и развитием универсального тулчейна `void(0)` для экосистемы JavaScript. Идея напоминает тулчейн Rome, Biome и другие похожие проекты. Компания подняла 4,6 миллиона долларов как посевную инвестицию. Планы пока далеко идущие. Также есть планы на 2025 год, которые в основном связаны с новым бандлеров Rolldown, который начнёт работать с Vite. Новость интересная, я определённо буду следить за судьбой этого тулчейна дальше. На мой взгляд, у него больше потенциала, чем в своё время у Rome и Biome сейчас. Дополнительно приложу ссылку на [перевод анонса на Хабре](https://habr.com/ru/companies/first/articles/847514/).
</ParagraphWithImage>

Стартанул [Hacktoberfest](https://hacktoberfest.com/). Если помните, это ежегодное мероприятие, которое проводит Digital Ocean. Оно посвящено open-source. В течение октября нужно сделать четыре полезных пулл-реквеста в open-source проекты, которые участвуют в Hacktoberfest. Прекрасная возможность начать контрибьютить и получить красивый цифровой значок. Сделать пулл-реквесты можно до 31 октября.

Видные представители JS-сообщества [обратились](https://javascript.tm/) к Oracle, для того чтобы освободить JavaScript от статуса одной из торговых марок компании. Они мотивируют это тем, что JavaScript уже давно широко используемое понятие и у Oracle нет какого-либо реального бизнес-интереса. Например, мы говорим “стандарт ECMAScript”, потому что JavaScript — торговая марка Oracle. Это немного путает и является в том числе одной из причин такой просьбы. Такая попытка уже была, посмотрим, что получится из этой.

На сегодня это всё. Всем пока и до встречи в следующем выпуске.

  ### Пишите нам и читайте
  [Telegram—канал CSSSR](https://t.me/csssr)

  [Twitter CSSSR](https://twitter.com/csssr_dev)

  [Twitter новостей](https://twitter.com/csssr_news)

  [Telegram ведущего](https://t.me/Vindizh)

  [Twitter ведущего](https://twitter.com/Vindizh)
