---
title: 'В этом выпуске мы поговорим об утечках памяти, новом пропозале для ECMAScript, экспериментальной поддержке TypeScript в Node.js. Мы погрузимся в Svelte 5, покрутим алгоритмические деревья и поздравим Puppeteer с поддержкой Firefox. Также мы посмотрим на релизы Firefox 129, React Native 0.75 и другие.'
soundcloudLink: 'https://soundcloud.com/csssr/utechki-svelte-5-derevya-puppeteer-s-podderzhkoy-firefox-firefox-129-react-native-075'
date: '2024-08-20T00:00:00.000Z'
episodeNumber: 260
tag: 'news'
author: 'Ислам Виндижев'
---

Всем привет, это «Новости 512» от CSSSR. В этом выпуске мы поговорим об утечках памяти, новом пропозале для EcmaScript, Svelte 5, экспериментальной поддержке TypeScript в Node.js. Мы погрузимся в Svelte 5, покрутим алгоритмические деревья и поздравим Puppeteer с поддержкой Firefox. Также мы посмотрим на релизы Firefox 129, React Native 0.75 и другие.

<ParagraphWithImage imageName="laptopNews" >
  ### Интересные публикации

Тревор Ласн (Trevor Lasn) в своей статье собрал [большинство наиболее распространённых причин возникновения утечек памяти](https://www.trevorlasn.com/blog/common-causes-of-memory-leaks-in-javascript). Внутри короткое введение в утечки памяти, разновидности памяти, с которыми работает V8, и непосредственно проблемы, вызывающие утечки. Речь пойдёт о неправильном обращении с переменными и глобальными объектами, замыканиях, неудалённых обработчиках событий и других проблемах. В статье также можно найти советы о том, как избежать этих проблем и как выявить утечки памяти. Получилась компактная и очень полезная статья.
</ParagraphWithImage>

Продолжая тему утечек. Джейк Арчибальд и компания [выяснили](https://jakearchibald.com/2024/garbage-collection-and-closures/), что в некоторых случаях сборщик мусора работает не вполне так, как ожидается, и это приводит к утечкам памяти. Оказалось, что проблема кросс-браузерная и были заведены соответствующие Issue. Больше подробностей — в блоге Джейка Арчибальда.

[Новый пропозал для ECMAScript](https://github.com/arthurfiorette/proposal-safe-assignment-operator) привлёк моё внимание. Это оператор безопасного присваивания, который выглядит, согласно предложению, как `?=`. По идее этот оператор разбивает результат на ошибку и результат. В зависимости от результата будет заполнена переменная либо с ошибкой, либо с результатом — это если коротко и обобщённо. Пропозал по идее должен помочь эффективнее обрабатывать ошибки. Идея интересная, вызвала споры о том, насколько это вообще нужно и насколько удобно. Ссылка прилагается.

Svelte 5 вышел уже довольно давно, и было проведено приличное количество самых разных обзоров его фич. Эта небольшая серия из трёх частей от команды Frontend Masters. В [первой части](https://frontendmasters.com/blog/introducing-svelte-5/) общее, обзорное введение в Svelte 5, во [второй](https://frontendmasters.com/blog/snippets-in-svelte-5/) обсуждаются сниппеты — новая фича Svelte 5, а в [третьей](https://frontendmasters.com/blog/fine-grained-reactivity-in-svelte-5/) — модель реактивности, которая применяется в пятой версии фреймворка. В каждой части есть теория и примеры.

[Экспериментальная поддержка TypeScript](https://socket.dev/blog/node-js-adds-experimental-support-for-typescript) появилась в Node.js с использованием флага `--experimental-strip-types`. Здесь есть нюанс: код на TS будет транспилироваться в JS, но типы не применятся и не будет происходить то, к чему вы привыкли. Эта фича нужна для того, чтобы TypeScript-код в принципе работал без установки дополнительных зависимостей. Фича будет развиваться — вряд ли она будет полностью поддерживать TS, но в планах есть оптимизация и добавление некоторых новых фич. Больше подробностей — по ссылке в описании.

Ещё немного о TypeScript. [Следующая статья](https://www.rob.directory/blog/a-different-way-to-think-about-typescript) предлагает взгляд на TS с другой точки зрения, а именно через множества. Типы сами по себе являются множествами, и через операции над множествами довольно наглядно можно представить, как работают некоторые операторы TypeScript. Такие статьи иногда попадаются, и через множества, на мой взгляд, правда намного нагляднее и понятнее.

На Хабре подъехала [третья часть обзора репозитория с алгоритмами и структурами данных на JS](https://habr.com/ru/companies/timeweb/articles/832402/). В этой части серии будем крутить деревья, разбираться в разных видах и их применении, их эффективности и сложности.

Теперь немного поговорим о тестировании. Я представляю вашему вниманию небольшую [подборку подсказок для использования React Testing Library](https://spin.atomicobject.com/react-testing-library-unit-tests/). Здесь вы найдёте советы о том, как выбрать правильный запрос для выбора элемента, как стоит использовать сравнения, как корректно экспортировать функции, а также узнаете, чем поможет линтер.

Следующий материал посвящён [основам тестирования React-приложений с Cypress](https://habr.com/ru/companies/otus/articles/831904/). Гайд базовый, он касается первичной настройки, структуры тестов, а также написания  простейших тестов и использования различных плагинов. Для базового ознакомления вполне подойдёт.

Также я хочу упомянуть релиз Puppeteer 23. Он примечателен тем, что в этом релизе [была добавлена официальная поддержка Firefox](https://hacks.mozilla.org/2024/08/puppeteer-support-for-firefox/) (раньше он поддерживал только Chrome).

Дмитрий Лукьяненко на Хабре [поделился своим опытом сертификации по Vue.js](https://habr.com/ru/articles/832992/). Он рассказал о том, как ему помог подготовиться к сертификации пакет за 200$, из чего состоит тест, что из себя представляли теоретическая и практическая части и какие в целом у него остались впечатления.

И в конце рубрики [статья](https://habr.com/ru/articles/834184/) на Хабре от Михаила Бронникова, в которой он рассказывает о критических этапах рендеринга, оптимизациях и аппаратном ускорении в браузере.

<ParagraphWithImage imageName="manWithLaptop">
  ### Новости релизов

Доступен [Firefox 129](https://developer.mozilla.org/en-US/docs/Mozilla/Firefox/Releases/129). В этой версии доступно CSS-правило @starting-style. Пока оно не поддерживает переход из состояния display: none;. Помимо этого, была добавлена поддержка transition-behaviour. Теперь доступны типизированные массивы с типом `Float16Array` и сопутствующими методами, которые полезны для обмена данными с GPU. Больше подробностей — в release notes.
</ParagraphWithImage>

Chrome 127 получил [патч](https://chromereleases.googleblog.com/2024/07/stable-channel-update-for-desktop_30.html) с устранением критической уязвимости. Не забудьте накатить обновление.

Есть такой инструмент — [Volta](https://volta.sh/). Он помогает работать с JS-зависимостями, написан на Rust, поддерживает все популярные операционные системы и несколько пакетных менеджеров. Ребята выпустили версию 2.0 своего инструмента. Это прекрасная возможность посмотреть на него — возможно, он пригодится на вашем проекте.

[React Native 0.75](https://reactnative.dev/blog/2024/08/12/release-0.75) уже доступен. Начиная с этой версии рекомендуемым способом разработки будет применение дополнительного фреймворка, например Expo. Для React Native это примерно как Next.js для React. Кстати, в прошлом выпуске я упоминал статью, в которой Кади Краман (Kadi Kraman) делает экскурс в React Native для React-разработчиков, и о самом Expo — эту [ссылку](https://expo.dev/blog/from-web-to-native-with-react) я тоже приложу к описанию выпуска.

Также в этом выпуске отмечу релизы [Angular 18.2](https://github.com/angular/angular/releases/tag/18.2.0), ESLint [9.8.0](https://eslint.org/blog/2024/07/eslint-v9.8.0-released/) и [9.9.0](https://eslint.org/blog/2024/07/eslint-v9.9.0-released/).

  ### Пишите нам и читайте
  [Telegram—канал CSSSR](https://t.me/csssr)

  [Twitter CSSSR](https://twitter.com/csssr_dev)

  [Twitter новостей](https://twitter.com/csssr_news)

  [Telegram ведущего](https://t.me/Vindizh)

  [Twitter ведущего](https://twitter.com/Vindizh)
