---
title: 'В этом выпуске мы поговорим о релизах Chrome, Firefox и выходе браузера Arc для Windows 10. Мы узнаем, как не выстрелить себе в ногу при использовании `localStorage`, как не блокировать Event Loop, сделать свои unit-тесты лучше и стоит ли приобщаться к алгоритмам и структурам данных. Помимо этого, мы посмотрим на обновления безопасности разных продуктов, коснёмся результатов опроса State of React 2023 и затронем другие интересные материалы и релизы.'
soundcloudLink: 'https://soundcloud.com/csssr/chrome-127-firefox-128-arc-dlya-win10-pnpm-95-localstorage-event-loop-state-of-react-2023'
date: '2024-08-05T00:00:00.000Z'
episodeNumber: 259
tag: 'news'
author: 'Ислам Виндижев'
---

Всем привет, это «Новости 512» от CSSSR. Я немного задержал выпуск, чтобы поставить на ноги график выхода эпизодов после отпуска. Извините за небольшую задержку. В этом выпуске мы поговорим о релизах Chrome, Firefox и выходе браузера Arc для Windows 10. Мы узнаем, как не выстрелить себе в ногу при использовании `localStorage`, как не блокировать Event Loop, сделать свои unit-тесты лучше и стоит ли приобщаться к алгоритмам и структурам данных. Помимо этого, мы посмотрим на обновления безопасности разных продуктов, коснёмся результатов опроса State of React 2023 и затронем другие интересные материалы и релизы.

Перед началом выпуска хочу передать привет своему слушателю Булату из Казани, с которым мы встретились, пока я был там. Спасибо за небольшую прогулку и знакомство! Надеюсь, что суровая непогода в Казани не застала тебя врасплох.

Теперь к новостям.

<ParagraphWithImage imageName="laptopNews" >
  ### Интересные публикации

Первая статья в этом выпуске — от команды Frontend Masters. Она посвящена [серверным компонентам React и их комбинации с react-query](https://frontendmasters.com/blog/combining-react-server-components-with-react-query-for-easy-data-management/). Суть комбинации в том, чтобы удобнее манипулировать данными. Внутри статьи вы найдёте не только экскурс в серверные компоненты, но и в проблемы, которые решат фреймворки. В материале показаны примеры того, как можно запрашивать данные для серверных компонентов, как можно сделать работу с данными лаконичнее и оптимальнее. Конечно, описываются и минусы подхода. Здесь вам уже нужно будет решать самим, насколько это подходит вам на конкретном проекте.
</ParagraphWithImage>

Уже не один раз мы с вами обсуждали разного рода хранилища, которые мы можем использовать для своих приложений. В [этом материале](https://habr.com/ru/articles/828912/) речь пойдёт конкретно о localStorage. Оказывается, при работе с ним можно выстрелить себе в ногу сразу несколькими способами. Об этом в своей статье рассказывает Владимир Клепов. Он рассказывает аж о шести способах усложнить себе жизнь при использовании localStorage и упоминает свою библиотеку, которая должна уберечь от этих проблем. Статья небольшая, но указывает на важные проблемы.

Всегда хотели попробовать сделать мобильное приложение на React Native? Вы попали по адресу. Кади Краман (Kadi Kraman) [написала статью](https://expo.dev/blog/from-web-to-native-with-react), которая будет полезна для React-разработчиков, желающих приобщиться к разработке на React Native. Она описывает навыки, которые пригодятся из React-разработки, рассказывает про специфику React Native. Она рекомендует Expo (проще говоря, аналог Next.js для React) и говорит о том, чем он может быть полезен. Параллельно с этим она рассказывает о полезных библиотеках и распространённых ошибках.

Как вам известно, JS однопоточный и работает на Event Loop. Было бы хорошо не блокировать Event Loop для того, чтобы ваше приложение не тормозило, нормально работало и не пило кровь пользователей. Слава Князев опубликовал в своём блоге [статью](https://www.bbss.dev/posts/eventloop/) как раз об этом. Он рассказывает о трёх подходах, которые помогут решить эту проблему. Гайд практический, стоит вдумчиво и внимательно прочитать, порешать примерчики.

Об алгоритмы и структуры данных сломано много копий, но тема всё ещё важная и актуальная. Далее [две части разбора](https://habr.com/ru/companies/timeweb/articles/826424/) от Игоря Агапова на Хабре. Думаю, вы уже поняли, что в них разбираются алгоритмы и структуры данных. Реализация на JS, а разбирается конкретный репозиторий, ссылка на который тоже прилагается.

Продолжая тему алгоритмов и структур данных. Стоит ли решать задачки на тематических ресурсах? Моё личное мнение: стоит. Следующая заметка об этом. Автор [рассказывает о своём опыте](https://habr.com/ru/articles/828048/), рассуждает о том, что ему дало решение задач на CodeWars и чем это может быть полезно. Если вы ещё сомневаетесь — попробуйте, отличная разминка для ума и очень пригодится в работе в будущем.

Теперь разбор [небольшого челленджа](https://dgerrells.com/blog/how-fast-is-javascript-simulating-20-000-000-particles). Суть челленджа заключается в том, чтобы симулировать 1 000 000 частиц на чистом JavaScript на телефоне, используя именно CPU. Задача была бы не особенно сложной, если бы это было в браузере на компьютере и с использованием GPU, а это несколько другой случай. Рекомендую всем, кто интересуется вопросами производительности на мобильных устройствах.

Одна из распространённых задач в нашей работе — это создание форм. В этом материале речь пойдёт [о создании сложных пошаговых форм](https://habr.com/ru/companies/otus/articles/829326/). Здесь обсуждаются вопросы разделения формы на компоненты, связи шагов формы через React Router, валидации и оптимизации производительности форм.

Теперь небольшой блиц.
Алексей Иванов на Хабре [описал](https://habr.com/ru/articles/830962/) принципы F.I.R.S.T для написания unit-тестов. Внутри статьи — примеры «правильных» и «неправильных» тестов, коротко и доступно.

Также на Хабре Катерина Трунспли, опираясь на свой опыт, [рассказывает](https://habr.com/ru/articles/831726/) о том, какой фреймворк из «большой тройки» она выбрала и почему.

Следующий материал — [плейлист с записями докладов с конференции dotJS](https://www.youtube.com/playlist?list=PLMW8Xq7bXrG7fOUOLJQw9I7ygJCbue9zO#dotjs2024). Внутри 15 небанальных докладов на самые разные темы, которые касаются JS.

Завершает рубрику статья Николаса Закаса о [будущем ESLint](https://eslint.org/blog/2024/07/whats-coming-next-for-eslint/). Новая система конфигурации была только началом, а в этой небольшой заметке он рассказывает о планах на будущее.

<ParagraphWithImage imageName="manWithLaptop">
  ### Новости релизов

Вышел Chrome 127. В этом релизе добавили CSS-свойство `font-size-adjust`, которое помогает сохранять одинаковый размер текста независимо от шрифта, который появляется до загрузки основного. Контейнеры со скроллом теперь по умолчанию фокусятся с клавиатуры для доступности. Альтернативный текст, генерируемый CSS-свойством `content`, теперь поддерживает несколько аргументов. В DevTools появилась фича для дебага якорного позиционирования на панели Elements. Во вкладке Performance теперь отображаются события отправки и получения WebSocket-сообщений, также они отображаются в трассировке. Больше подробностей о релизе в обзорах [Chrome](https://developer.chrome.com/blog/new-in-chrome-127) и [DevTools](https://developer.chrome.com/blog/new-in-devtools-127) от Google.
</ParagraphWithImage>

Доступен [Firefox 128](https://developer.mozilla.org/en-US/docs/Mozilla/Firefox/Releases/128). Теперь синтаксис относительных цветов включён по умолчанию, свойство `content` стало поддерживать альтернативный текст для контента с изображениями. JS теперь поддерживает `ArrayBuffer` с изменением размера и увеличивающийся `SharedArrayBuffer`, которые не требуют выделения новых буферов и копирования данных в них. Больше подробностей — в release notes.

Ещё одна новость про браузеры. [Браузер Arc](https://arc.net/), про который вы наверняка слышали, теперь доступен для Windows 10. Напомню, это браузер, у которого под капотом Chromium. Он предлагает безопасность и приватность из коробки, обладает широкими возможностями кастомизации и большим набором интересных и пока уникальных фич. Так что, если вы давно хотели его попробовать, но не могли, ваш час настал.

В [Deno 1.45](https://deno.com/blog/v1.45) появилась поддержка воркспейсов для удобного и эффективного управления монорепозиториями. Это обновление также включает в себя порцию улучшений совместимости с Node.js и обновления команды `deno install`. Были и другие изменения, больше о них — в блоге Deno.

[Astro 4.12](https://astro.build/blog/astro-4120/) отметился экспериментальным релизом серверных островов. Это решение для сочетания высокопроизводительного, статичного HTML с динамическими компонентами, сгенерированными на сервере. Помимо этого, новая версия получила улучшения пагинации и компонента с подсветкой кода.

Команда pnpm представила новую фичу каталогов в [версии 9.5](https://socket.dev/blog/pnpm-9-5-introduces-catalogs-shareable-dependency-version-specifiers). Эта фича позволяет шарить спецификаторы версий зависимостей в пределах воркспейса. Она будет полезна при работе с зависимостями в пределах монорепозиториев и потенциально уменьшит количество merge-конфликтов. Помимо этого, отмечу также [обновление pnpm 9.6](https://github.com/pnpm/pnpm/releases/tag/v9.6.0).

[Storybook 8.2](https://storybook.js.org/blog/storybook-8-2/) подъехал с новыми хуками для тестов, зависимостями, которые консолидировали в один core-пакет, чтобы уменьшить конфликты зависимостей и обновлённым сайтом с документацией. Помимо этого, представили онбординг для разработчиков и ряд других улучшений.

Теперь минутка безопасности. Current и LTS-версии Node.js получили security-обновление. Это версии [22.4.1](https://nodejs.org/en/blog/release/v22.4.1), [20.15.1](https://nodejs.org/en/blog/release/v20.15.1) и [18.20.4](https://nodejs.org/en/blog/release/v18.20.4), в которых было устранено от 2 до 6 уязвимостей разной степени опасности.

В Gitlab была найдена критическая уязвимость, которая позволяет запускать процессы в пайплайнах от имени произвольного пользователя. Были выпущены [корректирующие релизы](https://about.gitlab.com/releases/2024/07/10/patch-release-gitlab-17-1-2-released/) для всех поддерживаемых веток продукта.

В [релизе Apache 2.4.62](https://github.com/apache/httpd/releases/tag/2.4.62) устранены две уязвимости. Первая позволяла совершить SSRF-атаку на `mod_rewrite`, а вторая — просмотреть код скриптов, обработка которых настроена при помощи директивы AddType.

Oracle выпустила очередное регулярное [security-обновление](https://blogs.oracle.com/security/post/jul2024-cpu-released) своих продуктов. Не забывайте вовремя обновляться.

Также в этом выпуске отмечу релизы [Rust 1.80](https://blog.rust-lang.org/2024/07/25/Rust-1.80.0.html), [Preact 10.23.0](https://github.com/preactjs/preact/releases/tag/10.23.0), [ESLint 9.7.0](https://eslint.org/blog/2024/07/eslint-v9.7.0-released/) и [TypeScript 5.6 Beta](https://devblogs.microsoft.com/typescript/announcing-typescript-5-6-beta/). К TypeScript мы вернёмся поближе к релизу.

<ParagraphWithImage imageName="laptopNews" >
    ### Другие новости

Всё-таки прибыли [результаты опроса State of React 2023](https://2023.stateofreact.com/en-US/). Хуки окончательно прижились, но `useEffect` по-прежнему вызывает проблемы и боли у React-разработчиков. Ещё несколько болей — это `forwardRef`, `memo` и `Context API`. Используют React по-прежнему в основном для создания SPA, применения серверного рендеринга и генерации статических сайтов. И, конечно же, все ожидают северных компонентов, но с некоторой опаской, потому что их нужно будет внедрять в проекты, что может обернуться неожиданными сложностями. В опросе много и другой интересной статистики, подробности — по ссылке в описании.
</ParagraphWithImage>

Новость из серии «Вот это поворот!». Gitlab [рассматривает](https://www.reuters.com/markets/deals/google-backed-software-developer-gitlab-explores-sale-sources-say-2024-07-17/) возможность продажи бизнеса. В качестве потенциального покупателя называется компания Datadog. Рыночная стоимость Gitlab оценивается в 8 миллиардов долларов. Непонятно, как изменится курс развития платформы, если сделка состоится, но новости про покупки-продажи всегда вызывают немного опасений.

На сегодня это всё. Всем пока и до встречи в следующем выпуске.

  ### Пишите нам и читайте
  [Telegram—канал CSSSR](https://t.me/csssr)

  [Twitter CSSSR](https://twitter.com/csssr_dev)

  [Twitter новостей](https://twitter.com/csssr_news)

  [Telegram ведущего](https://t.me/Vindizh)

  [Twitter ведущего](https://twitter.com/Vindizh)
