---
title: 'В этом выпуске: ES2024 был одобрен, мы ещё раз коснёмся React Compiler, посмотрим, нужен ли сейчас Lodash, поговорим о множествах и их методах, а также о релизе MySQL 9. Ещё мы посмотрим на `SharedArrayBuffer` и чат-ботов прямо в Firefox.'
soundcloudLink: 'https://soundcloud.com/csssr/es2024-react-compiler-nodejs-20150-playwright-i-allure-mysql-90'
date: '2024-07-09T00:00:00.000Z'
episodeNumber: 258
tag: 'news'
author: 'Ислам Виндижев'
---

Всем привет, это «Новости 512» от CSSSR. Видимо, сезон отпусков здорово сказывается на количестве контента. Этот выпуск даже чуть не отменился совсем. Но вот о чём мы в нём поговорим: ES2024 был одобрен, мы ещё раз коснёмся React Compiler, посмотрим, нужен ли сейчас Lodash, поговорим о множествах и их методах, а также о релизе MySQL 9. Ещё мы посмотрим на `SharedArrayBuffer` и чат-ботов прямо в Firefox.

Небольшое отступление. 21 июля, как раз после следующего выпуска новостей, я улетаю на неделю в Казань. Если у меня есть слушатели из Казани, я буду очень рад советам и рекомендациям мест, да и вообще встретиться и развиртуализироваться. Если вы в Казани или просто много о ней знаете, не стесняйтесь и пишите мне в телегу — она есть в описании каждого выпуска.

<ParagraphWithImage imageName="laptopNews" >
  ### Интересные публикации

Я давно не упоминал доктора Акселя Раушмаера, сегодня время пришло. Был одобрен новый стандарт ES2024. Доктор Аксель [коротко рассказал о новых фичах](https://2ality.com/2024/06/ecmascript-2024.html). Размер `ArrayBuffer` и `Shared ArrayBuffer` теперь можно менять на месте, но только в большую сторону, а `ArrayBuffer` получил метод для перемещения между контекстами. Можно будет группировать итерируемые объекты. Атомики получили неблокирующий метод `.waitAsync()`. В новом стандарте у регулярных выражений появился новый флаг, а также ещё пара фич. Подробнее — в статье Акселя, а к стандарту мы вернёмся ещё в следующих выпусках. Кстати, он обновил свою бесплатную онлайн-книгу «[Exploring JavaScript](https://exploringjs.com/js/book/ch_new-javascript-features.html#new-in-es2024)», в которой есть стандарты и за прошлые годы, а также много интересного.
</ParagraphWithImage>

Вот [ещё одна статья о React Compiler](https://tonyalicea.dev/blog/understanding-react-compiler/), которую в своём блоге написал Тони Алисеа. Чем она мне понравилась: он коротко проходится по React в целом и показывает предпосылки к появлению компилятора. Он разбирает важные для понимания новой фичи аспекты React и показывает пример. Компилятор меняет процессорное время на память, и это нужно иметь в виду. И хочу напомнить, что пока React Compiler не покрывает довольно много случаев.

Кевин Шинер (Kevin Schiener) в своём блоге рассказал о потрясающем коварстве `useCallback` и замыканий. Если конкретно, он рассказывает о случае, когда встретился со [страшнейшей утечкой памяти](https://habr.com/ru/companies/piter/articles/824454/) в React-приложении, как он исследовал и решал эту проблему. Получилось интересненько. Я бы сказал, что это статья о том, как не стоит писать хуки.

Я уже рассказывал про методы для множеств в JS в Firefox и что их поддерживают уже, в общем-то, все мажорные браузеры. Брайан Смит (Brian Smith) на MDN написал статью о самой структуре данных [Set и методах для работы с ней](https://developer.mozilla.org/en-US/blog/javascript-set-methods/). Если вы не совсем знакомы с множествами, это прекрасный повод. В статье есть и примерчики.

Следующий материал — из блога Otus. Он посвящён `SharedArrayBuffer` и `Atomics`. `SharedArrayBuffer` — это тип буффера, к которому могут обращаться разные потоки, а атомики — API для атомарных операций. В [статье](https://habr.com/ru/companies/otus/articles/821805/) рассматриваются их основы и пример совместного применения. Материал простенький, хорошо подойдёт для первого ознакомления.

Алексей Кузьмин на Хабре опубликовал [гайд по UI-китам](https://habr.com/ru/companies/agima/articles/825080/). Он старается охватить множество аспектов: от того, зачем вообще нужны UI-киты, до разных стратегий реализации тех или иных нюансов. Внутри хорошая сравнительная таблица стратегий написания компонентов, способы добавления гибкости в UI-кит и разбор примера.

Многим командам и их QA-инженерам хороши известны такие инструменты, как Playwright и Allure. Если вы не знаете, бегло напомню: Playwright нужен для тестирования, а Allure — для отчётов, визуализации и анализа. [Кейс их базовой интеграции](https://habr.com/ru/companies/clevertec/articles/822583/) описали ребята из Clevertec на Хабре. Внутри мотивация выбора Playwright, примеры конфигурации интеграций и примеры работы их связки. Дело хорошее, а заметка — хорошая стартовая точка для их освоения.

В конце рубрики мнение. [Мнение о Lodash](https://habr.com/ru/articles/823484/). Как оказалось после опроса State of JS, им пользуется много людей, хотя с ним много проблем. Данила Родичкин написал именно об этом. Он рассказал о проблемах с установкой, подключением, отсутствием обновлений и обратил внимание на то, что из него используется всего несколько методов и он мешает изучению действительно современных библиотек и инструментов.

<ParagraphWithImage imageName="manWithLaptop">
  ### Новости релизов

В [Node.js 20.15.0 LTS](https://nodejs.org/en/blog/release/v20.15.0) test runner теперь поддерживает тест-планы. Inspector получил новый флаг `--inspect-wait` — он заставляет дебаггер ждать приложения и будет полезен, если хочется дебажить код с самого начала.
</ParagraphWithImage>

[Astro 4.11](https://astro.build/blog/astro-4110/) не то чтобы порадовал огромным количеством изменений, но они были. Шаблон страницы пятисотой ошибки теперь получает `error` как пропс, что позволит дать больше контекста об ошибке и кастомизировать страницу. Компонент для отображения кода, который использует хайлайтер `Shiki`, теперь поддерживает его трансформеры, которые позволяют точечно применять стили и показывать, например, диффы.

Доступна [9-я мажорная версия MySQL](https://dev.mysql.com/doc/refman/9.0/en/mysql-nutshell.html). В этом релизе исполнилась мечта JS-фуллстеков: теперь можно писать хранимки на JavaSctipt. Помимо этого, появилась поддержка векторов, результат выражения `EXPLAIN ANALYZE` можно выводить в виде JSON в пользовательскую переменную. Больше подробностей — в release notes.

Кстати, отдельно для фанатов PostgreSQL: в свободном доступе появилась книга «[PostgreSQL 16 изнутри](https://postgrespro.ru/education/books/internals». Очень зайдёт тем, кто хочет понимать, как работает технология под капотом, и знать все нюансы.

Также в этом выпуске стоит отметить [линейку патчей Gitlab](https://about.gitlab.com/releases/2024/06/26/patch-release-gitlab-17-1-1-released/), устраняющих серьёзную уязвимость, обновление [Playwright 1.45.0](https://github.com/microsoft/playwright/releases/tag/v1.45.0), патч [Firefox 127.0.2](https://www.mozilla.org/en-US/firefox/127.0.2/releasenotes/), устраняющий проблему с YouTube, и выход [альфы PHP 8.4](https://www.php.net/index.php#2024-07-05-1).

<ParagraphWithImage imageName="laptopNews" >
    ### Другие новости

Mozilla анонсировала тестирование [встроенного интерфейса для чат-ботов прямо в браузере](https://blog.mozilla.org/en/products/firefox/firefox-news/ai-services-on-firefox/). По идее это будет боковая колоночка, в которой будет чат-бот. Можно будет задавать ему вопросы, попросить что-то поискать, выдать короткое изложение или суть текста на странице. Можно будет выбрать определённый сервис-провайдер языковой модели — со временем этот перечень планируется расширять. Тестирование фичи уже должно было начаться в ночных сборках Firefox. Я очень надеюсь, что через 10 лет люди не будут спрашивать у ботов суть предложений в духе «Маша съела красное яблоко». Я утрирую, но всё равно немного страшно.
</ParagraphWithImage>

  ### Пишите нам и читайте
  [Telegram—канал CSSSR](https://t.me/csssr)

  [Twitter CSSSR](https://twitter.com/csssr_dev)

  [Twitter новостей](https://twitter.com/csssr_news)

  [Telegram ведущего](https://t.me/Vindizh)

  [Twitter ведущего](https://twitter.com/Vindizh)
