---
title: 'В этом выпуске: релизы Chrome 124 и Firefox 125, новый тестовый фреймворк от Netflix SafeTest, выбор между Qwik и Next.js, создание CLI для библиотек, публикация пакетов, и немного про подводные камни опенсорса. В этом же выпуске и другие релизы прошедших недель, а в конце — немного юмора.'
soundcloudLink: 'https://soundcloud.com/csssr/chrome-124-firefox-125-netflix-safetest-sozdanie-cli-vnutri-htmx-opensors-grabli'
date: '2024-04-20T00:00:00.000Z'
episodeNumber: 253
tag: 'news'
author: 'Ислам Виндижев'
---

Всем привет, это «Новости 512» от CSSSR. Этот эпизод неожиданно для меня оказался несколько меньше, чем я думал. Тем не менее нам есть о чём поговорить. В этом выпуске мы поговорим о релизах Chrome 124 и Firefox 125, новом тестовом фреймворке от Netflix SafeTest, выберем между Qwik и Next.js, узнаем, как создавать CLI для библиотек, публиковать пакеты, и подумаем, так ли добр и красочен опенсорс, как кажется. В этом же выпуске и другие релизы прошедших недель, а в конце — немного юмора.

<ParagraphWithImage imageName="laptopNews" >
  ### Интересные публикации

Команда Netflix в своём блоге рассказала о новом [тестовом фреймворке SafeTest](https://habr.com/ru/companies/otus/articles/803049/), который призван устранить недостатки текущих подходов к тестированию фронтенд-приложений. Идея в том, чтобы специальный кусочек кода мог внедрять в приложение хуки для запуска тестов. В комбинации можно использовать Playwright для полного контроля над приложением. SafeTest, конечно, умеет в статистику и отчёты, обещает сделать написание тестов более простым и интуитивным, не влиять на приложение в целом и избавить от болей привычного E2E-тестирования. Я уверен, что серебряной пули не получится, но уделить внимание и взглянуть стоит.
</ParagraphWithImage>

Далее [сравнение Qwik и Next.js](https://outshift.cisco.com/blog/qwik-vs-nextjs) как выборов для старта нового приложения. Сэмюель Менденхол (Samuel Mendenhall) рассуждает о том, на каком фреймворке он бы стартовал. Не буду нагнетать интригу: он на стороне Qwik. Он немного рассказывает о каждом из фреймворков, сравнивает их по ряду параметров и подводит итоги. Он считает, что Qwik гораздо удобнее в разработке, его подход к рендерингу лучше и что он лучше дружит с React-экосистемой. В некоторых местах он отдаёт первенство Next.js, например в кэшировании. Больше подробностей — в самой статье.

В последнее время я довольно часто упоминаю htmx, потому что о нём довольно часто пишут. Вот и этот материал не исключение. Он посвящён погружению в его [устройство и анатомию](https://habr.com/ru/companies/timeweb/articles/799555/). Внутри код проекта-примера и разбор работы htmx-атрибутов. Если вам интересно разбираться в устройстве таких штук, то эта статья определённо для вас.

Кому в опенсорсе жить хорошо? Ходит молва, что всем, что это прекрасно и вообще опенсорс мастхэв для каждого уважающего себя разраба. Так ли это на самом деле? Артём Захарченко [рассказывает](https://habr.com/ru/articles/802845/) о своём опыте и граблях, которые были не так уж заметны со стороны. Он рассказывает о том, каким иногда может быть коммьюнити, что вокруг в общем-то не совсем альтруисты и как спланировать всё так, чтобы сберечь свои нервы. При этом Артём (и я с ним полностью согласен) говорит о том, что опенсорс полезен для обучения, поиска друзей и просто причинения пользы. Но к этому стоит подходить осознанно, соблюдать баланс и отдавать себе отчёт в том, что опенсорс не состоит из фей, пони и единорогов.

Немного продолжая тему опенсорса. Вы наверняка слышали или знаете библиотечку Husky, которая позволяет делать разные git-хуки на проекте. В следующей заметке демонстрируется, что библиотека пользуется командами, собственно, git-а, и Husky можно было бы и не использовать. И действительно, есть довольно много пакетов, которые выполняют какой-то минимум, из-за чего зависимость в проект может и не стоит тащить? В общем, подробности в заметке «[Выкиньте свой husky](https://habr.com/ru/articles/807763/)».

Теперь чуточку о CLI-приложениях. Давайте представим, что вы пишете библиотеку и вам нужно общаться с пользователем. Конечно, надо придумывать интерфейс в командной строке или CLI. Джош Каннигхэм (Josh Cunningham) в своём блоге рассказал о [создании CLI при помощи фреймворка oclif](https://www.joshcanhelp.com/oclif/), который был создан специально для этого. Это буквально туториал с созданием CLI: его просто нужно взять и сделать. А oclif выглядит как удобная и функциональная штучка.

Хорошо, теперь вы умеете создавать CLI. Но он же должен быть не каким-нибудь, а удобным и информативным для пользователя. Чтобы узнать, как сделать свой CLI таким, вы можете в дополнение прочитать [статью](https://evilmartians.com/chronicles/cli-ux-best-practices-3-patterns-for-improving-progress-displays) дизайнера-инженера Романа Шамина. В своей статье он говорит о таком аспекте, как визуализация прогресса, и приводит три практики, которые помогут понять пользователю, что приложение не висит, а работает.

Хорошо, теперь вы умеете создавать CLI и делать его чуточку информативнее. А что теперь делать с этой прекрасной библиотекой и CLI, которые вы разработали? Конечно же, опубликовать в npm. Дмитрий Прохоров на Хабре написал развёрнутый гайд [по работе с npm и публикации библиотек](https://habr.com/ru/articles/804403/), он охватывает практически все аспекты и многим поможет найти ответы на свои вопросы или восполнить пробелы.

Теперь к релизам.

<ParagraphWithImage imageName="manWithLaptop">
  ### Новости релизов

Chrome 124 увидел свет. В этом релизе были добавлены два новых API — setHTMLUnsafe() и parseHTMLUnsafe(), — которые позволяют работать с декларативным shadow DOM из JavaScript. Как вы можете понять из названия, методы небезопасные, но по идее подвезут и безопасные версии. Был представлен WebSocket Stream API, который позволяет справляться с обратным давлением без дополнительных накладных расходов. Помимо этого, добавили немного улучшений для View Transition API. В DevTools добавилась фича автозаполнения форм, было улучшено замедление скорости сети для WebRTC, а в панели анимаций теперь поддерживаются scroll-driven анимации. В этот раз в DevTools вообще довольно много улучшений. Больше подробностей в обзорах новых версий [Chrome](https://developer.chrome.com/blog/new-in-chrome-124) и [DevTools](https://developer.chrome.com/blog/new-in-devtools-124) от Google.
</ParagraphWithImage>

Доступен [Firefox 125](https://developer.mozilla.org/en-US/docs/Mozilla/Firefox/Releases/125). В этой версии полностью поддерживается Popover API, что приятно. Добавлена поддержка метода `Intl.Segmenter`, который позволяет разбивать строки в зависимости от языка. CSS-свойство transform-box теперь поддерживает значения content-box и stroke-box. Помимо этого, свойство `align-content` теперь работает с блочными разметками.

Вышел [Next.js 14.2](https://nextjs.org/blog/next-14-2). В этом релизе Turbopack стал доступен в dev-режиме — пока как RC, но всё же. Помимо этого, подвезли сокращение использования памяти при билде и оптимизации CSS. Также были представлены и некоторые улучшения для DX.

Тулчейн Biome порадовал нас [версией 1.7](https://biomejs.dev/blog/biome-v1-7/). В этой версии стало проще перейти на Biome с ESLint и Prettier, тулчейн научился генерировать машиночитаемые JSON-отчёты, также были обновлены некоторые правила.

Вышла [девятая версия ESLint](https://eslint.org/blog/2024/04/eslint-v9.0.0-released/). В ней плоский конфиг стал конфигом по умолчанию, было добавлено новое правило `no-useless-assignment`. Помимо этого, минимально поддерживаемая версия Node.js теперь 20. Конечно, были и апдейты существующих правил и багфиксы. Дополнительно я прикладываю ссылку на [ESLint Config Inspector](https://eslint.org/blog/2024/04/eslint-config-inspector/). Это приложение от ESLint, которое визуально показывает ваш плоский конфиг и помогает его отладить.

Есть такая библиотечка zx, которая позволяет попроще писать сложные консольные скрипты для Node.js. В ней есть полезные обёрточки для child_process, фичи для работы с аргументами и прочее. Вышла [версия 8](https://github.com/google/zx/releases/tag/8.0.0): она в 20 раз меньше, побыстрее, с новыми фичами и багфиксами.

Подбираясь к концу рубрики, хочу обратить ваше внимание на WYSIWYG-редактор [Quill](https://quilljs.com/), у которого недавно вышла вторая мажорная версия. Он опенсорсный, с понятным API, дружит с формами и React. Если вы искали редактор для своего проекта — возможно, это именно он.

Также в этом выпуске отмечу [апрельское security-обновление продуктов Oracle](https://blogs.oracle.com/security/post/april-2024-cpu-released) и релиз языка программирования [Rust 1.77](https://blog.rust-lang.org/2024/03/21/Rust-1.77.0.html).

<ParagraphWithImage imageName="laptopNews" >
    ### Другие новости

В конце этого выпуска не будет глобальных новостей из мира разработки, но неожиданно будет немного юмора.

[Первая зарисовка](https://www.youtube.com/watch?v=aWfYxg-Ypm4) посвящена Senior фронтенд-разработчику в 2024 году. Я горячо рекомендую посмотреть это короткое видео на 10 минут, в котором абстрактный сеньор рассуждает о технологиях, которые нужны для начала нового проекта. Многие могут узнать себя или своих коллег — не в плохом ключе, а в том смысле, что время такое. В общем, посмотрите, получилось очень весело.
</ParagraphWithImage>

[Вторая зарисовочка](https://habr.com/ru/articles/808179/) о новичке, который захотел решить задачку на JavaScript и начал изучать таинства нашего любимого языка программирования. Тёплая мини-история, которая лично мне напомнила самого себя во времена самоучества. В конце, кстати, есть и ссылка на детище автора.

На сегодня это всё. Всем пока и до встречи в следующем выпуске.

  ### Пишите нам и читайте
  [Telegram—канал CSSSR](https://t.me/csssr)

  [Twitter CSSSR](https://twitter.com/csssr_dev)

  [Twitter новостей](https://twitter.com/csssr_news)

  [Telegram ведущего](https://t.me/Vindizh)

  [Twitter ведущего](https://twitter.com/Vindizh)
