---
title: 'В этом выпуске: релизы Chrome 122 и Firefox 123, Angular 17.2 и Astro 4.4. Дружба React и Angular, работа Strict Mode, цикл про git и итоги года команд рантаймов, введение в Google Apps Script и другие материалы.'
soundcloudLink: 'https://soundcloud.com/csssr/chrome-122-firefox-123-astro-44-strict-mode-2023-god-dlya-raznykh-instrumentov'
date: '2024-03-01T00:00:00.000Z'
episodeNumber: 251
tag: 'news'
author: 'Ислам Виндижев'
---

Всем привет, это «Новости 512» от CSSSR. В этом выпуске мы посмотрим на релизы Chrome 122 и Firefox 123, Angular 17.2 и Astro 4.4. Мы коснёмся того, как подружить React и Angular, посмотрим на статью-шпаргалку по работе Strict Mode, хороший цикл про git и несколько статей о том, как команды разных популярных инструментов поработали в 2023 году. Здесь же несколько практических гайдов, снова современные фишки CSS и другие интересные материалы.

<ParagraphWithImage imageName="laptopNews" >
  ### Интересные публикации

Первый материал очень классный. Это [подборка](https://youtu.be/TEMKKfQpY94?si=v8ixjBxiB6ndXoKD) практически всех современных фич CSS в одном видео. За примерно 30 минут разбирается подборка фич 2023. По сути, это разбор статьи Адама Аргайла (Adam Argyle) CSS Wrapped 2023. Так что если вы любите смотреть больше, чем читать — это видео как раз для вас. Здесь будет и про тригонометрические функции, про анимации по скроллу, сложные селекторы, фишки для цвета и текста, Container Queries — в общем, всё, что было крутого в 2023, с объяснениями. Если вы не видели статью, то стоит заглянуть в видео. Прекрасно подойдёт тем, кто слишком занят, чтобы быть в курсе новых фич.
</ParagraphWithImage>

Как раз одной из новых фич был псевдоселектор :has(). Многие с энтузиазмом экспериментируют с фичей, внедряют в свои проекты, она показывает себя очень полезной и крутой. Ахмад Шадид (Ahmad Shadeed) в своём блоге опубликовал [интерактивный гайд](https://ishadeed.com/article/css-has-guide) для изучения работы псевдоселектора. Получилось здорово и наглядно. Внутри большое количество случаев, в которых он может быть полезен, а интерактив заключается в том, что в каждом случае наглядно демонстрируется результат работы псевдоселектора. Даже если вы уже используете `:has()` в своей повседневной работе, обязательно загляните — вы найдёте для себя что-то полезное.

Далее две статьи от Романа Максимова на Хабре. Первая касается [Strict Mode](https://habr.com/ru/articles/791978/). Все мы про строгий режим знаем, но иногда не всё, и он может подкинуть неожиданный сюрприз. Роман постарался помочь нам с этой проблемой и написал прекрасную справочную статью, которая описывает особенности работы кода в Strict Mode. Не поленитесь и почитайте, а лучше сложите в закладки как справочную штуку.

Вторая статья автора посвящена Event Loop и называется «[Event Loop. Мифы и реальность](https://habr.com/ru/articles/789572/)». В ней Роман пытается разобраться, где искать спецификацию Event Loop, что о нём правда, а что нет. Например, из неё я узнал, что Event Loop не имеет отношения к спецификации JS. Внутри статьи ещё несколько интересных фактов.

Следующий материал про дружбу. Если конкретно, то про [дружбу между React и Angular](https://habr.com/ru/articles/794082/) на одном проекте. В целом такие статьи попадали в новости довольно часто, потому что опыт других команд в решении задач таких интеграций может быть очень полезен. Эта статья не исключение. Здесь речь пойдёт о применении Module Federation для решения этой проблемы. По ходу статьи будут рассмотрены микрофронтенды и их организация, особенности сборки таких проектов и взаимодействие между React- и Angular-кодом. Module Federation не совершенен, но помогает решить ряд задач, что демонстрируется в статье. Она длинная и подробная — как раз для любителей лонгридов.

Дальше пост от команды V8. Если вы любите разбираться в технических подробностях работы движка и копать вглубь — их блог как раз для вас. В этот раз они написали [небольшую статью](https://v8.dev/blog/static-roots) о том, как базовые объекты JS выглядят внутри движка, как хранятся и как обеспечен быстрый доступ к ним, который всегда нужен. Заметка небольшая, но интересная.

Пока в фокусе серверные компоненты React, команда фреймворка работает и по другим направлениям. Одно из них — [новые хуки](https://habr.com/ru/companies/timeweb/articles/793660/), которые появятся в React 19. В основном они направлены на работу с формами и выборку данных. Например, будет хук для оптимистичного обновления формы, ожидания данных и другие. Обо всех этих хуках с примерами рассказал Франсуа Занинотто (François Zaninotto), а к новостям я приложу перевод его статьи на Хабре от Игоря Агапова. Дополнительно отмечу, что хуки в принципе можно попробовать, но пока только в canary-версии React.

Ещё немного про хуки. Артур Агаджанян в своей статье рассказывает о том, как можно выстрелить себе в ногу при использовании useEffect. Идея простая: нужно правильно разделять ответственность, выносить логику и внимательно структурировать компоненты. Чтобы как раз не выстрелить себе в ногу, естественно. Внутри [статьи](https://habr.com/ru/articles/796143/) много примеров, в том числе с применением библиотеки React Query.

Нам постоянно нужно хранить какие-то данные для наших приложений. В прошлом выпуске мы обсуждали кэширование, а сегодня поговорим про localStorage. В блоге RxDB появилась заметка о localStorage API. Она посвящена [использованию localStorage в современных приложениях](https://rxdb.info/articles/localstorage.html). Ценность заметки в том, что она компактная и в ней есть сравнение с большим количеством других хранилищ буквально в нескольких предложениях с описанием того, в каких случаях какое хранилище подходит.

В JS есть такая структура данных, как Set или множество. Напомню, это структура данных, в которой каждый элемент может быть только в одном экземпляре. Структура есть довольно давно, но всегда казалась не завершённой функционально. Со временем над этим поработали браузерные вендоры, и теперь есть все нужные для работы с ними методы. Об этом в своей статье [рассказал](https://www.sonarsource.com/blog/union-intersection-difference-javascript-sets/) Фил Нэш (Phil Nash): он описал саму структуру данных и рассказал про поддерживаемые методы. Это характерные для множеств операции типа пересечения, определения подмножества и других. Если вы не знакомы с этой структурой данных — добро пожаловать под кат.

Иногда возникает задача обновления массива без изменения исходного. Как раз для этой задачи и был разработан [метод](https://web.dev/blog/array-with) `Array.prototype.with`. Он работает довольно прямолинейно: передаётся индекс и значение, которое заменит текущее значение на этой позиции. Теперь он поддерживается во всех браузерах. Подробнее о самом методе с примерами — в блоге web.dev.

Теперь немного практики. Следующая статья о том, как при помощи тригонометрических функций CSS создать [часы на чистом CSS](https://habr.com/ru/articles/796639/). Хороший пример использования новых функций CSS, а те, кто неравнодушен к математике, с удовольствием поэкспериментируют с ними.

Сооснователь GitHub Скотт Чейкон (Scott Chacon) написал [серию статей про git](https://blog.gitbutler.com/git-tips-and-tricks/). Как пишет он сам, это серия о том, что люди уже не помнят или ещё не знают. Первая часть про старые, но нужные вещи. Вторая — про новые. А третья, на мой взгляд, самая интересная: она посвящена работе с большими репозиториями, например с репозиторием Windows размером в 300 Гб. Серия интересная, горячо рекомендую.

Есть такой прекрасный инструмент, как Google Apps Script. Прекрасная штука, сам иногда писал простенькие скрипты для облегчения работы, но у этих скриптов много больше возможностей. Для тех, кто совсем не сталкивался с этой технологией, Алексей Штанько написал [обзор возможностей](https://habr.com/ru/companies/agima/articles/796677/) с примерчиками. Попробуйте —  возможно, вы найдёте где применить скриптики для облегчения своей работы.

Дальше несколько материалов, которые будут интересны тем, кто следит за развитием фреймворков и технологий или хочет начать. Сразу несколько команд поделились результатами своей работы за 2023 год или планами.

Рич Харрис, создатель Svelte, дал [интервью](https://www.youtube.com/watch?v=z7n17ajJpCo), в котором рассказал про фреймворк, поделился планами, своим видением проблем веба и их возможными решениями. 

Команда React немного [рассказала](https://react.dev/blog/2024/02/15/react-labs-what-we-have-been-working-on-february-2024) о своей текущей работе и преподнесла неплохую новость о том, что скоро мы увидем новую мажорную версию React 19.

Рефлексировали над своей работой в 2023 году команды рантаймов [Node.js](https://blog.rafaelgss.dev/nodejs-2023-year-in-review) и [Deno](https://deno.com/blog/deno-in-2023). Тоже интересно почитать.

В конце рубрики ещё несколько интересностей, ссылки на которые я приложу к описанию. Это библиотека для работы с датой и временем [Tempo](https://tempo.formkit.com/), [шаблон для старта React Native приложения](https://github.com/WrathChaos/react-native-typescript-boilerplate) с TypeScript и [шаблон для старта современного серверного  приложения на Node.js](https://www.learnwithjason.dev/blog/modern-node-server-typescript-2024) (тоже с поддержкой TypeScript).

<ParagraphWithImage imageName="manWithLaptop">
  ### Новости релизов

Доступен Chrome 122. В этом релизе был добавлен `Storage Buckets API`. Его идея в том, чтобы создавать отдельные мини-хранилища данных, которым можно задавать приоритет удаления, по мере того как у пользователя заканчивается необходимое пространство для данных. В DevTools на панели Performance появилась классная фича: теперь там можно ставить хлебные крошки и перемещаться по ним во время сеанса дебага (крошки могут быть в том числе и вложенные). Также на главной шкале таймлайна теперь появились инициаторы событий. По умолчанию инициаторы соединяются стрелками с событиями, которые вызвали. Больше подробностей — в официальных обзорах [Chrome](https://developer.chrome.com/blog/new-in-chrome-122) и [DevTools](https://developer.chrome.com/blog/new-in-devtools-122) от Google.
</ParagraphWithImage>

Firefox начал обгонять Chrome по номерам версий. [Новая версия 123](https://www.mozilla.org/en-US/firefox/123.0/releasenotes/) порадовала нас экспериментальным превью вкладок, пока фича включается специальным флагом. Элемент <template> теперь поддерживает атрибут `shadowrootmode`. Было добавлено много фиксов для корректной работы Date.parse(). Больше подробностей — в [release notes](https://developer.mozilla.org/en-US/docs/Mozilla/Firefox/Releases/123).

В [Angular 17.2](https://blog.ninja-squad.com/2024/02/14/what-is-new-angular-17.2/) появилась экспериментальная поддержка Material 3 от Google, продолжилась работа над сигналами и были добавлены некоторые улучшения для CLI. Релиз не очень большой, но он случился.

Фреймворк Astro обзавёлся [свежей версией 4.4](https://astro.build/blog/astro-440/). Представили новую интересную фичу аудита производительности: в девтулзах фреймворка будут появляться подсказки по улучшению производительности, помимо этого будет отображаться список проблем, которые смогли обнаружить девтулзы. Также была улучшена производительность стриминга.

Вышел [Deno 1.41](https://deno.com/blog/v1.41). Наверное, самая заметная фича — поддержка архитектуры ARM64 и Linux, об этом многие просили. Также в этом релизе значительно оптимизировали размер скомпилированных бинарников. Например, размер «Hello, World!»-приложения уменьшился в два раза. Продолжается работа над совместимостью с Node.js.

[Vite 5.1](https://vitejs.dev/blog/announcing-vite5-1.html) после нескольких месяцев разработки увидел свет. В этом релизе был добавлен экспериментальный Vite Runtime API, который позволит авторам библиотек создавать свою прослойку между сервером и своим кодом. Был стабилизирован импорт CSS-файлов как URL. Немного прокачали HMR при наличии циклических импортов: теперь изменения в коде не всегда будут триггерить полную перезагрузку страницы. Также показали некоторые улучшения для увеличения производительности.

Хорошие новости для тех, кто работает с Vue. Вышла версия [Vue Devtools 6.6.0](https://github.com/vuejs/devtools/releases/tag/v6.6.0). В этой версии полностью обновили интерфейс, мигрировали фронт на Vue 3 и перевели плагин для Chrome на третью версию манифеста. В этом же релизе много фиксов багов и улучшений.

Несколько хорошо известных вам инструментов скоро придут к полноценным релизам. Это [релиз-кандидат TypeScript 5.4](https://devblogs.microsoft.com/typescript/announcing-typescript-5-4-rc/), [Storybook 8 Beta](https://storybook.js.org/blog/storybook-8-beta/) и — похлопайте старичку — [jQuery 4.0 Beta](https://blog.jquery.com/2024/02/06/jquery-4-0-0-beta/). Мы вернёмся к ним после полноценных релизов, а сейчас я прикладываю ссылки на них к этому выпуску для самых нетерпеливых.

Также в этом выпуске отмечу релизы [git 2.44](https://lkml.org/lkml/2024/2/23/1055) и языка программирования [Rust 1.76.0](https://blog.rust-lang.org/2024/02/08/Rust-1.76.0.html).

<ParagraphWithImage imageName="laptopNews" >
    ### Другие новости

До вас наверняка доходили новости о сокращениях в геймдеве. Так вот, Mozilla что-то тоже собралась [уволить около 60 сотрудников](https://techcrunch.com/2024/02/13/mozilla-downsizes-as-it-refocuses-on-firefox-and-ai-read-the-memo/) и сосредоточиться на развитии технологий искусственного интеллекта в своих продуктах. Хочется надеяться, что это единичный случай, а не начало новой волны сокращений в IT. Как бы там ни было, не волнуйтесь, всё будет хорошо.
</ParagraphWithImage>

  ### Пишите нам и читайте
  [Telegram—канал CSSSR](https://t.me/csssr)

  [Twitter CSSSR](https://twitter.com/csssr_dev)

  [Twitter новостей](https://twitter.com/csssr_news)

  [Telegram ведущего](https://t.me/Vindizh)

  [Twitter ведущего](https://twitter.com/Vindizh)
