---
title: 'В этом выпуске: CSS в 2023 году, релизы браузеров, гайд по IndexedDB, как писать правильные тесты, что со спорами вокруг однопоточности JS. Снова о htmx, удобный API файловой системы, ряд подборок и обновление рейтинга TIOBE.'
soundcloudLink: 'https://soundcloud.com/csssr/chrome-121-firefox-122-css-2023-indexeddb-poleznye-podborki-obnovlenie-tiobe'
date: '2024-01-27T00:00:00.000Z'
episodeNumber: 249
tag: 'news'
author: 'Ислам Виндижев'
---

Всем привет, это «Новости 512» от CSSSR. В этом выпуске мы поговорим о том, каким был 2023 год для CSS, посмотрим на релизы браузеров, узнаем, как работать с IndexedDB, как писать правильные тесты и что там со спорами вокруг однопоточности JS. Мы снова поговорим про htmx, узнаем, как может выглядеть хороший API файловой системы, а потом посмотрим на подборки: инструментов и библиотек на этот год, ресурсов для обучения, классных CSS-снипетов и другие. В конце выпуска мы быстренько глянем на обновление рейтинга языков программирования TIOBE.

<ParagraphWithImage imageName="laptopNews" >
  ### Интересные публикации

В блоге Chrome вышел пост о том, [как менялся CSS в 2023 году](https://developer.chrome.com/blog/css-wrapped-2023). И правда, мы увидели немало новых фич. Мы много обсуждали запросы к контейнеру или Container Queries. Одной из самых внедряемых фич стал псевдоселектор :has(), про который мы позже ещё поговорим. Крутыми фичами, конечно, стали директива `@scope` и нативная вложенность стилей. Была добавлена куча новых API, например View Transitions API, `Popover API` и другие. В общем, год у CSS был горячий. Даже если вам кажется, что вы ничего не пропустили, загляните: пост классный и собирает все важные новинки CSS прошедшего года.
</ParagraphWithImage>

Ник Мостовой написал [статью об IndexedDB](https://blog.xnim.me/indexeddb-guide). У него большой опыт работы с ней, и он решил изложить его в виде гайда от основ до транзакций и курсоров. Внутри статьи примеры, объяснение и описание фич, а также полезные подсказки для работы. Если вы не работали с IndexedDB, то это как раз отличный гайд, с которого можно начать и которым можно пользоваться как предметным указателем.

Артём Захарченко сформулировал для себя правило, по которому он отделяет хорошие автотесты от плохих. Вообще он начал с того, что задался вопросом: «[Для чего на самом деле нужны тесты?](https://www.epicweb.dev/the-true-purpose-of-testing)». Он считает, что они нужны для того, чтобы проверять, правильно ли работают нужные функции, которые запрограммированы, а не какие-то детали реализации. Так он вывел [правило хорошего теста](https://www.epicweb.dev/the-golden-rule-of-assertions): тест должен падать тогда и только тогда, когда неправильно работает какая-то функция. В статье о правиле есть пример того, как тестировать то, что действительно нужно тестировать. Получилось небольшое размышление о природе тестов.

JS однопоточный или нет? Вы можете уверенно ответить на этот вопрос или нет? На Хабре в комментариях к [следующей статье](https://habr.com/ru/articles/786330/) поднялась дискуссия по этому поводу. Автор материала считает, что JS уже не такой уж однопоточный, и в своей статье пытается показать, что среды выполнения JS уже увели язык от его однопоточной природы. В статье разбираются нюансы языка и некоторые понятия, связанные с параллельным выполнением каких-то задач в коде. А если вы любитель комментов — тоже заглядывайте: дискуссия набрала обороты.

View Transtitons API в этом выпуске я уже упоминал. Он помогает без JS создать переход элементов страницы между разными состояниями. Но как быть с примерами и в каких случаях это наиболее применимо? Адриан Бис (Adrian Bece) в двух частях статьи на Smashing Magazine показывает как раз целый ряд примеров работы нового API. В [первой](https://www.smashingmagazine.com/2023/12/view-transitions-api-ui-animations-part1/) он рассказывает о самом API и реализует несколько примеров с объяснениями, а [вторая](https://www.smashingmagazine.com/2024/01/view-transitions-api-ui-animations-part2/) полностью посвящена практике работы с API. Статьи получились довольно объёмными, но стоит потратить время и покодить примеры ручками.

Николас Закас Nicholas C. Zakas, создатель ESLint, написал [заметку](https://humanwhocodes.com/blog/2024/01/fsx-modern-filesystem-api-javascript/) о том, как создал пакет с удобным API файловой системы. В заметке он рассуждает о том, каким должен быть хороший и простой в использовании API для файловых систем, и рассказывает о своём новом детище. В статье много примеров. Пока он начал со своих частых кейсов, но планирует развивать библиотеку. Пакет должен был называться fsx, но Amazon выпустила продукт с таким названием. Николас ждёт обратной связи и приглашает к обсуждению нового названия для своей библиотеки.

В блоге SimbirSoft на Хабре была опубликована заметка о [личном опыте перехода с Redux на Effector](https://habr.com/ru/companies/simbirsoft/articles/787244/) от фронтенд-специалиста Ани. Если коротко, ей понравился Effector, потому что показался сильно проще Redux: кода нужно писать меньше, и в целом с точки зрения именно developer experience ей было поприятнее. Если вы любите личные истории смены технологий — заглядывайте.

Про htmx стали говорить довольно часто. А о чём часто пишут, к тому много вопросиков. htmx исключением не стал. Его обвиняют в мнимой простоте и в том, что на самом деле это такой же JS-фреймворк, который просто красиво обернули в слова. Александр Петрос (Alexander Petros) в блоге htmx [пояснил](https://htmx.org/essays/is-htmx-another-javascript-framework/), фреймворк это всё-таки или нет. Он считает, что да, но только в некотором смысле, потому что в htmx нужно писать всё-таки HTML, а не JSX и кучу другого обвеса. Такие вот аргументы. Подробнее можно почитать по ссылке в описании выпуска, правда интересно. Бонусом к этой статье я приложу видео «[htmx для разработчиков за 10 минут](https://www.youtube.com/watch?v=r0XBULqzsT0)» — наслаждайтесь.

Как понять, что у вас получается хорошая дизайн-система? Составить чек-лист и пройтись по нему. Но составить такой чек-лист — задача тоже непростая. Не волнуйтесь, он уже сделан за вас. Хочу обратить ваше внимание на open-source [чек-лист для дизайн-систем](https://www.designsystemchecklist.com/), в котором собрано и удобно сгруппировано множество аспектов разработки дизайн-систем. В разделах также есть ссылки на дизайн-системы и гайды от других компаний, которые могут быть полезны. Ссылка будет прикреплена к выпуску.

Ещё один [список](https://www.designprinciplesftw.com/collections/ibm-design-principles), но на этот раз от IBM. Он описывает общие принципы разработки ПО, которых придерживается компания. Это общие концепции, которые говорят, как создавать ПО разработчикам и как следует заботиться о пользователях своего ПО. Почитайте — возможно, вы найдёте для себя полезные пункты.

Не могу сказать, насколько популярно сейчас применение прогрессивных веб-приложений (PWA), но точно будет не вредно знать, что они сейчас могут. Быстро ознакомиться с текущими возможностями технологии поможет ресурс [whatpwacando.today](https://whatpwacando.today/), который представляет из себя демо-приложение всех фич PWA. Удобный способ быстро ознакомиться с поддерживаемыми функциями.

Далее [список 33 концепции JS](https://github.com/leonardomso/33-js-concepts), которые должен знать каждый. Это, конечно, не просто список, а репозиторий, в котором сформулирован список концепций с полезными ссылками, которые помогут в этих самых концепциях разобраться. Кстати, репозиторий [переведён и на русский язык](https://github.com/gumennii/33-js-concepts), ссылка также будет в описании.

Теперь подборка новостей покороче.

[5 предсказаний для SRE](https://www.codereliant.io/5-sre-predictions-for-2024/) пророчат более суровый рынок SRE, продолжение доминирования Kubernetes и больше крупных неполадок из-за кода, который написали с использованием ИИ.

Адам Аргайл (Adam Argyle) собрал [5 CSS-сниппетов](https://web.dev/articles/5-css-snippets-every-front-end-developer-should-know-in-2024), которые должен знать каждый разработчик в 2024 году. Они касаются в основном новых возможностей, таких как нестинг, сабгриды и псевдоселектор :has(). Сюда же приложу сборник [5 топовых сценариев использования :has()](https://bejamas.io/blog/learn-css-has-selector-by-examples-top-use-cases/).

Немного о библиотеках и инструментах. В прошлом выпуске я говорил, что Робин Урих (Robin Wierich) собирал список библиотек для React 2023. Недавно он выпустил [список на 2024 год](https://www.robinwieruch.de/react-libraries/), его я к этому выпуску и приложу.

Ещё один список собрал Луи Лазарис (Louis Lazaris). Это [список фронтенд-инструментов](https://www.smashingmagazine.com/2024/01/top-frontend-tools-2023/), которые чаще всего просматривали в рассылке, которую он курирует. Интересная подборка с самыми разными инструментами.

Парад подборок закрывает сборник ресурсов для [бесплатного изучения фронтенда в 2024 году](https://habr.com/ru/articles/788308/). В сборнике сгруппированы ссылки на ресурсы для разных навыков. Кстати, есть разделы про безопасность и даже контейнеризацию с мониторингом.

В конце рубрики парочка интересных штучек. Библиотека компонентов для Vue 3 [Element Plus](https://element-plus.org/en-US/) и open-source-альтернатива Postman, которая называется [Bruno](https://github.com/usebruno/bruno). Ссылки вы найдёте в описании выпуска.

<ParagraphWithImage imageName="manWithLaptop">
  ### Новости релизов

Вышел Chrome 121. В этом релизе добавили поддержку свойств CSS scrollbar-color и scrollbar-width. Свойство font-palette позволит задавать палитру для цветных шрифтов и делать плавные переходы между палитрами, а псевдоэлементы ::spelling-error и ::grammar-error дают возможность кастомизировать цвет выделения соответствующих ошибок. В DevTools переменные теперь по умолчанию отображаются с использованием source map везде в девтулзах, эту опцию можно отключить. В панели Performance раздел Interactions более информативно отображает задержки взаимодействия с пользователем, а во вкладках добавили возможность продвинутой фильтрации с использование регулярок. Больше подробностей — в официальных обзорах релизов [Chrome](https://developer.chrome.com/blog/new-in-chrome-121) и [DevTools](https://developer.chrome.com/blog/new-in-devtools-121) от Google.
</ParagraphWithImage>

Доступен браузер [Firefox 122](https://developer.mozilla.org/en-US/docs/Mozilla/Firefox/Releases/122). Теперь внутри селектов можно использовать горизонтальную линию. Маркеры списков больше не стилизуются через атрибут `type` — только при помощи CSS-свойства list-style-type. Также добавили возможность программно открывать селекты при помощи метода showPicker(). Кроме того, в эту версию ввели несколько экспериментальных API. Как и всегда, был представлен ряд багфиксов.

Вышел [Angular 17.1](https://github.com/angular/angular/releases/tag/17.1.0). В этой версии добавили инпуты на сигналах — работает похоже на директиву @Input, просто читабельнее и проще. Также в этом релизе завершили переход с Karma на Jest и Test Runner, а также добавили опциональный переход на esbuild для уже существующих проектов.

У [Next.js](https://nextjs.org/blog/next-14-1) номер версии похожий — 14.1. В этом релизе продолжили работать над надёжностью `Turbopack`: он уже проходит практически все тесты, его надеются стабилизировать к следующему релизу. Помимо этого, прокачали его производительность. Для sekf-hosted проектов расширили документацию и добавили поддержку своего обработчика кеша. Конечно, не обошлось без небольших улучшений для разработчиков, например улучшений вывода ошибок и фиксов багов.

[Node.js 21.6.0](https://nodejs.org/en/blog/release/v21.6.0) привнесла сразу несколько фич. В пакет net были добавлены методы для новых попыток соединения, была добавлена поддержка конфигурируемых снапшотов со специальным флагом, также были представлены некоторые доработки экспериментальной модели разрешений. Чуть позже вышел [патч 21.6.1](https://nodejs.org/en/blog/release/v21.6.1) с устранением небольшой регрессии.

Вышло [важное security-обновление GitLab](https://about.gitlab.com/releases/2024/01/11/critical-security-release-gitlab-16-7-2-released/) с устранением двух критических уязвимостей. Первая позволяла захватить контроль над аккаунтом пользователя через манипуляции с формой восстановления пароля, а вторая выполнять слэш-команды через интеграции со Slack и Mattermost от имени другого пользователя. Не забывайте вовремя обновляться.

Доступна [пятая мажорная версия библиотеки Chai](https://github.com/chaijs/chai/releases/tag/v5.0.0). Отмечу, что библиотека теперь поддерживает только ESM, минимальная версия Node.js теперь 18-я, а Internet Explorer больше не поддерживается.

Также отмечу релизы [Prettier 3.2](https://prettier.io/blog/2024/01/12/3.2.0.html), [React Icons 5.0](https://github.com/react-icons/react-icons/releases/tag/v5.0.0) и [VirtualBox 7.0.14](https://www.mail-archive.com/vbox-announce@virtualbox.org/msg00229.html).

<ParagraphWithImage imageName="laptopNews" >
    ### Другие новости

В очередной раз [обновился индекс популярности языков программирования TIOBE](https://www.tiobe.com/tiobe-index/). Напомню: это индекс, который формируется по результатам запросов к поисковым системам. C# стал языком года, потому что стал гораздо популярнее, чем раньше в вебе, и показал самый большой рост популярности в 2023 году. JavaScript подтянулся на одно место вверх и, очевидно, продолжает быть популярным. PHP подтянулся аж на три места вверх: с 10 на 7. Первое место по-прежнему уверенно держит Python и, между прочим, не только в этом индексе: только в индексе, который строится на GitHub-активности, он занимает второе место после JavaScript.
</ParagraphWithImage>

  ### Пишите нам и читайте
  [Telegram—канал CSSSR](https://t.me/csssr)

  [Twitter CSSSR](https://twitter.com/csssr_dev)

  [Twitter новостей](https://twitter.com/csssr_news)

  [Telegram ведущего](https://t.me/Vindizh)

  [Twitter ведущего](https://twitter.com/Vindizh)
