---
title: 'В этом выпуске: планы фреймворков на 2024, критика серверных компонентов в Next.js, StyleX от Facebook и релиз Vue 3.4. Также мы обсудим релизы Firefox 121, Safari 17.2 и Deno 1.39. В конце: восходящие звёзды JS и обновлённый рейтинг баз данных.'
soundcloudLink: 'https://soundcloud.com/csssr/firefox-121-safari-172-vue-34-deno-139-stylex-klonirovanie-voprosy-s-sobesov-kritika-rsc'
date: '2024-01-15T00:00:00.000Z'
episodeNumber: 248
tag: 'news'
author: 'Ислам Виндижев'
---

Всем привет, это «Новости 512» от CSSSR. Надеюсь, вы хорошо встретили Новый год и он будет для вас лучше предыдущего. В этом выпуске мы постараемся нагнать темп и поговорим о некоторых событиях, которые произошли примерно с середины декабря. Мы поговорим про планы некоторых фреймворков на 2024, покритикуем серверные компоненты в Next.js, узнаем, что за StyleX явил нам Facebook и что нового во Vue 3.4. Также мы обсудим релизы Firefox 121, Safari 17.2 и Deno 1.39. В конце выпуска будет о восходящих звёздах JS и обновлённом рейтинге баз данных.

<ParagraphWithImage imageName="laptopNews" >
  ### Интересные публикации

Первый материал этого выпуска — [критика серверных компонентов React](https://www.mayank.co/blog/react-server-components/). Автор успел плотно поработать с ними в контексте Next.js. Он отмечает, что концепция выглядит хорошо и в некоторых кейсах хорошо работает. Также понравились серверные действия, которые позволяют на сервере исполнять код в ответ на взаимодействия с пользователем. Что совсем не понравилось — больше беспорядка в коде и плохо читаемая структура компонентов внутри проекта. Ещё одна негативная сторона: решения команды Next.js относительно расширения API запутывают и иногда кажутся избыточными. В статье есть примеры, и анализ сторон серверных компонентов разделён на блоки. У меня есть ощущение, что серверные компоненты стали долгостроем, который в конечном итоге к релизу будет иметь множество конкурентов в лице других подходов и фреймворков.
</ParagraphWithImage>

Тем временем команды разных фреймворков поделились [планами на год](https://thenewstack.io/2024-predictions-by-javascript-frontend-framework-maintainers/). Команда Angular анонсировала новый глобальный объект `Zone`, который поможет управлять асинхронными операциями и обрабатывать ошибки, которые возникают в процессе их выполнения. Next.js планирует продолжать развивать поддержку серверных компонентов и серверных действий, также планируется выпустить новый компилятор. У React не было каких-то новых планов, но продолжится работа над некоторыми идеями из 2023. Например, над автомемоизирующим компилятором `React Forget`, который позволит больше не пользоваться `useMemo` или `useCallback`. Ещё одна идея — дополнить `React Native` девтулзами, сопоставимыми с девтулзами Chrome. Команда Solid напомнила о `SolidStart` — по сути его можно сравнить со `SvelteKit`. В Solid продолжат улучшать и переосмысливать систему реактивности и сигналов. Больше подробностей — по ссылке.

Facebook в конце прошлого года [выпустил своё CSS-in-JS решение](https://habr.com/ru/articles/781000/) `StyleX`. Хочется шутить, что теперь продукты занимают все имена, в которых есть большая X. По идее StyleX обещает удобное переиспользование, типизацию, создание настоящих однофайловых компонентов. Предполагается, что он принесёт большую пользу большим проектам и, вероятно, будет продвигаться как лучшая практика для React. Добавлю также, что StyleX не зависит от фреймворка и его можно использовать с любым из них. Дополнительно к анонсу я приложу [один из первых обзоров](https://habr.com/ru/articles/781166/) на StyleX.

Стив Сьюел (Steve Sewell) написал [заметку о глубоком клонировании объектов в JavaScript](https://www.builder.io/blog/structured-clone). Вы можете догадаться, что он рассказывает о методе `structuredClone()`. Вы про него, скорее всего, слышали, но ценность заметки в том, что он показывает старые решения проблемы копирования объектов и объясняет, почему от них пора отказаться. Помимо этого, он отмечает, что structuredClone не может копировать функции, узлы DOM, прототипы объектов и некоторые другие объекты.

Всем нам приходится выбирать библиотеки. Конечно, мы хотим, чтобы они были меньше, быстрее и так далее. Но как оптимизировать выбранную? Энтузиаст оптимизации и профайлинга Стефан Гойц (Stéphane Goetz) [рассказал об этом](https://calendar.perfplanet.com/2023/benchmarking-profiling-and-optimizing-javascript-libraries/) на примере кейса с работы, когда нужно было выбрать библиотеку для какой-то задачи. Он проводит читателя через разные методы профайлинга и оптимизации библиотек целиком или их частей, а в конце делится некоторыми мыслями о том, как понять, когда уже пора остановиться на пути оптимизации.

Далее статья в двух частях. Это подборка вопросов для собеседований фронтендеров с ответами. Вы скажете «очередная» и будете правы, но вопросов с собеседований много не бывает. [Первая часть](https://habr.com/ru/articles/784548/) посвящена вопросам по JavaScript: от работы `Event Loop` до сборки мусора и других продвинутых тем. [Вторая часть](https://habr.com/ru/articles/785596/) посвящена вопросам по TypeScript, так же с ответами.

Робин Урих (Robin Wierich) в начале прошлого года собрал [большую коллекцию библиотек](https://www.robinwieruch.de/react-libraries/) для самых разных задач в React-разработке. Я про неё уже рассказывал, но подумал, что можно напомнить. Набор покрывает кучу сфер: от банального старта React-проекта до AR/VR-решений. Возможно, что-то вам пригодится.

Правда ли, что для любого проекта с JS нужна система сборки? Хороший вопрос. Джулия Эванс (Julia Evans) считает, что нет. В [своей заметке](https://jvns.ca/blog/2023/02/16/writing-javascript-without-a-build-system/) она рассказывает о своём опыте создания маленьких проектов или поддержки небольших сайтов, которые редко радикально меняются. Основная мысль в том, что оно не стоит того для небольших или личных проектов. Также она поделилась своим небольшим шаблоном для использования Vue без билда. Если что, она не топит за веб без билдов, просто говорит, что иногда это не нужно.

Закроет рубрику [введение](https://refine.dev/blog/what-is-htmx/) в `htmx`. Если вы ещё не работали с ним, то это прекрасный способ познакомиться с технологией и поковырять примерчики.

<ParagraphWithImage imageName="manWithLaptop">
  ### Новости релизов

Вышел [Firefox 121](https://www.mozilla.org/en-US/firefox/121.0/releasenotes/). В этой версии поддерживается ленивая загрузка `<iframe>`, наконец была добавлена поддержка псевдоселектора `:has()`, также CSS-свойство `text-wrap` стала поддерживать значения `balance` и `stable`. JS без внимания тоже не оставили: появилась поддержка статического метода `Promise.withResolvers()`, а `Date.parse()` стал поддерживать ещё больше форматов и получил парочку багфиксов. Из фич для пользователей я, наверное, отмечу только управление голосовыми командами на macOS и настройку для принудительного подчёркивания ссылок независимо от CSS страницы. Больше подробностей — в [release notes](https://developer.mozilla.org/en-US/docs/Mozilla/Firefox/Releases/121).
</ParagraphWithImage>

Релиз [Safari 17.2](https://webkit.org/blog/14787/webkit-features-in-safari-17-2/) случился относительно давно, но до Нового года мы о нём не говорили. Итак, новая версия поддерживает аккордеоны, которые получаются при добавлении атрибута `name` тэгу `<details>`, поддержка вложенного CSS теперь полноценная, без оговорок, также были добавлены новые единицы измерения для символов. Была проделана работа над способами анимации, также были добавлены математические функции CSS. В части JS добавили поддержку атрибутов импортов и поддержку формата чисел для интернационализации. Больше подробностей — в блоге WebKit.

Vue отметился [версией 3.4](https://blog.vuejs.org/posts/vue-3-4). Релиз включает в себя новый парсер шаблонов, который работает в два раза быстрее, рефакторинг системы реактивности, благодаря которому эффекты срабатывают точнее и эффективнее. Также в новой версии есть ряд улучшений API для удобства разработки. Также в release notes есть небольшая инструкция по обновлению: нужно апнуть некоторые зависимости.

[Deno 1.39](https://deno.com/blog/v1.39) возвестил о возвращении `Web GPU`. Напомню, это API, который позволяет использовать ресурсы GPU для вычислений, это расширяет возможности для гейминга, машинного обучения — в общем, для всего, где нужны вычислительные мощности. Фича была отключена в Deno с 2021 года, теперь она снова в деле. `deno compile` теперь ещё лучше работает с `node_modules`, также были представлены улучшения анализатора кода и LSP. Подробнее — в блоге Deno.

Также в этом выпуске отмечу релизы рантайма [Node.js 21.5.0](https://nodejs.org/en/blog/release/v21.5.0) и [20.11.0 (LTS)](https://nodejs.org/en/blog/release/v20.11.0), фреймворков [Remix 2.4.0](https://github.com/remix-run/remix/blob/main/CHANGELOG.md#v240) и [Ember 5.5](https://github.com/emberjs/ember.js/releases/tag/v5.5.0), бандлеров [Rollup 4.9.5](https://github.com/rollup/rollup/releases/tag/v4.9.5) и [Parcel 2.11](https://github.com/parcel-bundler/parcel/releases/tag/v2.11.0), а также [ядра Linux 6.7](https://lore.kernel.org/lkml/CAHk-=widprp4XoHUcsDe7e16YZjLYJWra-dK0hE1MnfPMf6C3Q@mail.gmail.com/).

<ParagraphWithImage imageName="laptopNews" >
    ### Другие новости

Результатов опросов из серии `State of…` ещё нет, но есть один любопытный рейтинг, который я обязательно просматриваю каждый год. Это `JavaScript Rising Stars`, он составляется по звёздам, которые проекты собирают на GitHub. Он разделён на категории, но все проекты относятся к JS. Например, самым популярным стал `shadcn/ui` — набор React-компонентов, которые можно кастомизировать с Tailwind CSS. `StyleX` от Facebook ворвался с ноги в сектор CSS-in-JS решений, набрав все свои звёзды за декабрь. `Expo` и `React Native` бегут нос к носу среди решений для разработки мобильных приложений. `Playwright` уверенно набирал популярность в 2023, а `Tauri` сильно задвинул `Electron` как инструмент для desktop-решений. Среди фреймворков и их экосистем особых сюрпризов не было. В любом [случае советую заглянуть](https://risingstars.js.org/2023/en) и посмотреть самим — так можно узнать о какой-то технологии или найти новую, которую захочется изучить.
</ParagraphWithImage>

Mozilla анонсировала [начало работы каталога дополнений Firefox на Android](https://blog.mozilla.org/addons/2023/12/14/a-new-world-of-open-extensions-on-firefox-for-android-has-arrived/). Какие-то расширения можно было использовать и раньше, а это куда более широкий список дополнений. Авторы расширений к определённому времени должны были адаптировать их для мобильных устройств. План был перевыполнен во много раз, и теперь пользователи Mozilla на Android могут использовать более 450 дополнений. В ближайшее время планирую заценить.

В конце выпуска хочу упомянуть рейтинг баз данных. Он был обновлён, в этом году четвёрка лидеров особенно не изменилась, но примечателен факт, что [PostgreSQL стала СУБД 2023 года](https://db-engines.com/en/blog_post/106) за самый большой рост популярности. [Рейтинг](https://db-engines.com/en/ranking) сам по себе тоже довольно интересный, рекомендую заглянуть.

  ### Пишите нам и читайте
  [Telegram—канал CSSSR](https://t.me/csssr)

  [Twitter CSSSR](https://twitter.com/csssr_dev)

  [Twitter новостей](https://twitter.com/csssr_news)

  [Telegram ведущего](https://t.me/Vindizh)

  [Twitter ведущего](https://twitter.com/Vindizh)
