---
title: 'В этом выпуске: Chrome 120, Firefox 120, PHP 8.3 и Astro 4, современные фреймворки через создание своего собственного, элемент `<dialog>`, новый оптимизирующий компилятор V8 Maglev, прокачка PM2 и на другие интересные материалы.'
soundcloudLink: 'https://soundcloud.com/csssr/chrome-120-firefox-120-php-83-astro-4-sozday-freymvork-reyting-superkompyuterov'
date: '2023-12-15T00:00:00.000Z'
episodeNumber: 246
tag: 'news'
author: 'Ислам Виндижев'
---

Всем привет, это «Новости 512» от CSSSR. В этом выпуске мы поговорим о релизах Chrome 120, Firefox 120, PHP 8.3 и Astro 4, изучим современные фреймворки через создание своего собственного, разберёмся с элементом `<dialog>`, посмотрим на новый оптимизирующий компилятор V8 Maglev, глянем, как можно прокачать PM2 и на другие интересные материалы. В конце выпуска мы немного поговорим о конкурсе от Prettier, нашем спасении от восстания машин и чуть-чуть о суперкомпьютерах.

<ParagraphWithImage imageName="laptopNews" >
  ### Интересные публикации

Одна из моих любимых категорий статей — это те, в которых что-то изучается через создание. Это как раз тот случай. Нолан Лоусон (Nolan Lawson) в своём блоге [предлагает](https://nolanlawson.com/2023/12/02/lets-learn-how-modern-javascript-frameworks-work-by-building-one/) разобраться в том, как работают современные JS-фреймворки через создание своего собственного. Что такое современный? Он имеет в виду, что фреймворк должен уметь в реактивность, использовать клонированные шаблоны для рендера DOM и использовать современные JavaScript API. Собственно, все эти фичи он и реализует по очереди в своём небольшом фреймворке. Понятно, что это просто пример для разбора концепций, статья не очень большая. Но разобраться вполне себе можно. Рекомендую поделать руками и внимательно почитать.
</ParagraphWithImage>

Джейк Лазароф (Jake Lazaroff) задался вопросом: можно ли не зацикливаться на JS-фреймворках? Его точка зрения такова: можно вообще не париться. Доказывает он это довольно [интересным способом](https://jakelazaroff.com/words/web-components-eliminate-javascript-framework-lock-in/). Он реализует простое TODO-приложение, в котором каждый компонент реализует при помощи разного JS-фреймворка. Он пытается показать, что такой подход возможен, а веб-компоненты в этом очень помогут. Он оговаривается, что вряд ли вы действительно напишете такое приложение, но такая ситуация может возникнуть, например, при миграции с одного фреймворка на другой.

Про элемент `<dialog>` многим уже вполне себе известно. Это нативное диалоговое окно в HTML, которое может работать как в режиме диалогового, так и в режиме модального. Александр Григоренко на Хабре написал [статью](https://habr.com/ru/articles/778542/) про работу с новым элементом. Помимо общих сведений, он рассматривает особенности и тонкости работы нового элемента, а также решение ряда проблем, которые могут возникать при его использовании.

Команда V8 в своём блоге [рассказала](https://v8.dev/blog/maglev) о новом оптимизирующем компиляторе движка Maglev. Вы наверняка слышали про Sparkplug и TurboFan, Maglev находится примерно между ними. В статье раскрывается мотивация создания ещё одного оптимизирующего компилятора (если коротко — сделать нечто среднее между двумя существующими для определённых случаев) и технические подробности. Работа существующих элементов V8 вместе с новым компилятором улучшила бенчмарки и уменьшила потребление энергии устройствами. Цифры и подробности — в блоге V8.

Даниель Лемире (Daniel Lemire) [задался вопросом](https://lemire.me/blog/2023/11/25/a-simple-websocket-benchmark-in-javascript-node-js-versus-bun/), какой рантайм лучше работает с WebSocket. Он сравнил Node.js и Bun. Сейчас вообще частенько сравнивают Bun с чем-нибудь, сами понимаете почему. В итоге пришёл к выводу, что Bun быстрее на 40%. В статье вы найдёте ссылки на код и описание самого бенчмарка. Кейс был довольно простой, но заслуживает немного внимания.

Если вы работали с мало-мальски реальным Node.js-приложением из реального мира, вы наверняка сталкивались с управлением процессами приложений и менеджером PM2. Если нет, коротко скажу, что это менеджер процессов, который позволяет кластеризовать и распределять нагрузку на сервер. В некоторых случаях его возможностей не хватает. Именно о таком случае [рассказал на Хабре](https://habr.com/ru/articles/778316/) Вячеслав Волков. В его случае нужно было научить PM2 автоматически масштабировать приложение при различных нагрузках. Для этого он написал свой плагин `pm2-autoscale`, который доступен любому желающему для установки и участия в разработке. Автор будет рад вашей помощи и отзывам.

К выходу готовится [обновлённое CLI-приложение форматтера Prettier](https://prettier.io/blog/2023/11/30/cli-deep-dive.html). Фабио Спампинато (Fabio Spampinato), который как раз над ним работал, рассказал о том, что изменилось. Если упрощать, его основной задачей была оптимизация. Он погрузился в детали, рассказал о том, как поработал над кэшированием, самим форматированием и другими частями приложения. Если вы любите разбираться в том, как работают ваши любимые инструменты, вам обязательно понравится.

Следующая пара материалов посвящена тестам. Представьте себе «прекрасную» ситуацию, в которой ваш фронтенд, который вы гоняете по тестам в Playwright, вообще-то выбросил исключение и упал, а тест всё равно прошёл. Неприятненько. Стефан Юдис (Stefan Judis) рассказал о том, как избежать таких ситуаций с ложно-позитивными тестами [при помощи фикстур](https://www.checklyhq.com/blog/track-frontend-javascript-exceptions-with-playwright/). Он рассказывает о самой фиче, приводит примеры и рассказывает, в каких ещё случаях это может быть полезно.

Ещё один материал — исчерпывающая [шпаргалка по Puppeteer](https://proxiesapi.com/articles/the-complete-puppeteer-cheatsheet). Это именно шпаргалка без детального описания API и методов, только задача и кусочки кода. Возможно, вам пригодится.

Санми Аканде (Sanmi Akande) в Smashing Magazine поделился [способами восстановления утраченных данных в git](https://www.smashingmagazine.com/2023/12/recovering-deleted-files-git-working-tree/). Он коротко рассказывает о том, как git вообще работает с файлами и изменениями, а также как могут быть удалены файлы и данные из них. Затем он рассматривает большое количество разных ситуаций, в которых можно либо, наоборот, нельзя восстановить утерянное.

Завершит рубрику парочка видео. [Первое видео](https://www.youtube.com/watch?v=Hz_zCR28oKE) от всем известного Эвана Ю: примерно за час он рассказал о текущем состоянии фреймворка Vue и Vite.

Второе [видео о 10 новых фичах JS](https://www.youtube.com/watch?v=ANCm3oG7htM), которые вы могли пропустить в 2023 году. Оно совсем короткое, идёт чуть меньше 6 минут.

<ParagraphWithImage imageName="manWithLaptop">
  ### Новости релизов

Вышел Chrome 120. Был добавлен новый `CloseWatcher API`, который предоставляет разработчикам способ прослушивать и отвечать на запросы закрытия всплывающих и модальных компонентов. Для элемента `<details>` добавили поддержку атрибута `name`. Элементы `<details>` с одинаковым значением атрибута группируются, а одновременно можно открыть только один элемент — получается аккордеончик. Также продолжается работа над прекращением поддержки сторонних файлов cookie, в январе начнётся эксперимент на эту тему. DevTools также получил пару изменений, связанных с cookies, расширенный список игнорирования для дебаггера и ряд других небольших изменений. Больше подробностей — в официальных обзорах [Chrome](https://developer.chrome.com/blog/new-in-chrome-120) и [DevTools](https://developer.chrome.com/blog/new-in-devtools-120) от Google.
</ParagraphWithImage>

Firefox также отметился [версией 120](https://developer.mozilla.org/en-US/docs/Mozilla/Firefox/Releases/120). Теперь поддерживается атрибут `media` в элементе `<source>`, вложенном в элементы `<picture>`, `<audio>` и `<video>`. Была добавлена поддержка CSS-функции `light-dark()`, а также единиц измерения высоты строки `lh` и `rlh`. Метод JavaScript `Date.parse()` теперь принимает несколько дополнительных форматов дат. Для пользователей подъехала киллер-фича: появилась кнопка копирования ссылок без информации для отслеживания вроде меток и прочего. Как и всегда, был устранен ряд багов и уязвимостей.

LTS-версии Node.js получили обновления. [Версия 20.10.0](https://nodejs.org/en/blog/release/v20.10.0) получила экспериментальный клиент WebSocket и экспериментальный флаг для автоопределения ES-модулей. [Node.js 18.19.0](https://nodejs.org/en/blog/release/v18.19.0) разжилась npm 10 и небольшими доработками кастомизации хуков и лоадеров.

Обновилась и current-ветка рантайма. В [версии 21.3.0](https://nodejs.org/en/blog/release/v21.3.0) добавили флаг `--disable-warning` для отключения определённых предупреждений, а также ускорили метод `fs.writeFileSync()` в два с половиной раза в некоторых условиях. Следом прилетела [версия 21.4.0](https://nodejs.org/en/blog/release/v21.4.0), в которой починили небольшую регрессию, которую привнесли, пока ускоряли `fs.writeFileSync()`.

Доступна [четвёртая мажорная версия фреймворка Astro](https://astro.build/blog/astro-4/). Главная фишка релиза — Astro DevToolbar. Это плашечка, которая будет появляться только в dev-режиме и позволит смотреть, что у вас там с компонентами, дебажить приложение и многое другое. Помимо этого, добавили поддержку мультиязычного роутинга, сделали логи в консоли более лаконичными и чистыми, а также представили редизайн документации.

Вышло [обновление фреймворка Fresh](https://deno.com/blog/fresh-1.6) от команды Deno за версией 1.6. В новой версии добавили плагин для Tailwind CSS, упростили тайпинги, а также добавили поддержку фрагментов для форм.

Кстати, был ещё один анонс от Deno. Команда [анонсировала](https://deno.com/blog/cron) `Deno Cron`. По названию вы могли догадаться, что это `cron`. Ссылку на анонс я также приложу к выпуску.

Вышла версия [PHP 8.3](https://www.php.net/archive/2023.php#2023-11-23-2). Это довольно большое обновление, в котором добавили глубокое клонирование readonly-свойств, явную типизацию констант классов и улучшения для класса Randomizer. Выкатили, конечно, и исправления багов, а также поработали над производительностью. Подробнее — по ссылке на страницу релиза. Пользуясь случаем, добавлю, что ветку PHP 8.0 перестали поддерживать. Это значит, что она не будет получать обновления безопасности, так что не забывайте вовремя обновляться.

В релизе [Storybook 7.6](https://storybook.js.org/blog/storybook-7-6/) улучшили поддержку SWC или `Speedy Web Copmpilier`, добавили новые тестовые утилиты и режим быстрого билда, диагностику ошибок в CLI, а также выкатили обновлённый и дополненный сайт с документацией. Были и другие изменения, подробнее — в блоге Storybook.

Отдельно хочу отметить релиз [ядра Linux 6.6.6](https://lkml.org/lkml/2023/12/11/226). Знаково, не правда ли? Патч важный, он затрагивает беспроводной стек и исправляет блокировку сетевых менеджеров.

Также в этом выпуске я отмечу релизы [Mongoose 8](https://thecodebarbarian.com/introducing-mongoose-8.html), [React Native 0.73](https://reactnative.dev/blog/2023/12/06/0.73-debugging-improvements-stable-symlinks), фреймворка [Electron 28](https://www.electronjs.org/blog/electron-28-0) и операционки [FreeBSD 14](https://www.freebsd.org/releases/14.0R/announce/). Рядом шутка о том, как пропатчить KDE2 под FreeBSD и аниме (если вы поняли, то нам вместе пора закрашивать седину).

<ParagraphWithImage imageName="laptopNews" >
    ### Другие новости

Ещё немного про Prettier. Команда тула объявила о [состязании форматтеров](https://biomejs.dev/blog/biome-wins-prettier-challenge/), написанных на Rust. В этом состязании поучаствовал Biome — напомню, идейный преемник фронтенд-тула Rome, который прошёл большее 95% JS-тестов и забрал тот самый приз, который составил 25 тысяч долларов. Команда Prettier посчитала, что расслабилась из-за отсутствия конкуренции в своей нише, что замедляет развитие инструмента. В итоге конкуренция всё-таки есть; думаю, это подтолкнет проекты к дальнейшему развитию.
</ParagraphWithImage>

В интернетах много разговоров про апокалипсис из-за искусственного интеллекта. Крупные компании решили, что Skynet нужно усмирять ещё на этапе гипотезы, и [создали](https://www.redhat.com/en/blog/ai-alliance-launches-international-community-leading-technology-developers-researchers-and-adopters-collaborating-together-advance-open-safe-responsible-ai) `AI Alliance` — организацию, которая по идее будет совместно развивать технологии искусственного интеллекта и связанных технологий. Её основали IBM и Meta, в альянс вошло порядка 50 крупных компаний, университетов и исследовательских организаций. Надеюсь, что за ними не вышлют Терминатора из будущего.

В конце выпуска расскажу вам о [свежем рейтинге 500 самых производительных компьютеров мира](https://www.top500.org/lists/top500/2023/11/). Первое место за собой сохранил кластер Frontier, а больше всего суперкомпьютеров в США, Китае и Германии. Для интересующихся больше подробностей по ссылке на рейтинг.

  ### Пишите нам и читайте
  [Telegram—канал CSSSR](https://t.me/csssr)

  [Twitter CSSSR](https://twitter.com/csssr_dev)

  [Twitter новостей](https://twitter.com/csssr_news)

  [Telegram ведущего](https://t.me/Vindizh)

  [Twitter ведущего](https://twitter.com/Vindizh)
