---
title: 'В этом выпуске мы поговорим о релизах Safari 17 и Firefox 118, рунах в Svelte 5, векторных базах данных и немного об Event Loop. Также в этом выпуске ещё один материал про архитекторов ПО, документалка про TypeScript, генерация BDD-тестов с ChatGPT, а также Remix 2 и Next.js 13.5.'
soundcloudLink: 'https://soundcloud.com/csssr/safari-17-firefox-118-runy-svelte-5-arkhitektory-bdd-testy-s-chatgpt-remix-2-nextjs-135'
date: '2023-09-30T00:00:00.000Z'
episodeNumber: 241
tag: 'news'
author: 'Ислам Виндижев'
---

Всем привет, это «Новости 512» от CSSSR. В этом выпуске мы поговорим о релизах Safari 17 и Firefox 118, рунах в Svelte 5, векторных базах данных и немного об Event Loop. Также в этом выпуске ещё один материал про архитекторов ПО, документалка про TypeScript, генерация BDD-тестов с ChatGPT, а также Remix 2 и Next.js 13.5.

<ParagraphWithImage imageName="laptopNews" >
  ### Интересные публикации

Команда Svelte анонсировала новую фичу Svelte 5, которую назвала [рунами](https://svelte.dev/blog/runes). Если коротко, то они решили переделать работу с реактивностью через синтаксис с функциями. Это объясняется тем, что будет проще писать, понимать и поддерживать реактивный код. История не новая; как пишут в самом посте, вдохновением послужил фреймворк `Knockout` и его `signals` по состоянию аж на 2010 год. Сообщество видит в этом шаг в сторону похожести на Vue и расхождение с оригинальной концепцией Svelte. Лично я так не думаю. Svelte 5 ещё не вышел, но фичу можно попробовать в первых сборках новой версии. Также доступен [перевод поста на Хабре](https://habr.com/ru/articles/763256/).
</ParagraphWithImage>

Следующая статья посвящена [Event Loop](https://habr.com/ru/articles/762618/). Это одна из наших любимых тем, я в этом просто уверен. Здесь также раскрывается работа очереди, категории тасков и нюансы работы. Этот материал отличается от армии статей на эту тему тем, что написан просто, понятно и в нём понятные, последовательные примеры. Получилось здорово, а в конце статьи есть ещё и полезные ссылки для дополнительного чтения.

Следующая статья [о векторных базах данных](https://dev.to/pavanbelagatti/wtf-is-a-vector-database-a-beginners-guide-16p). Это базы данных, которые хранят информацию в виде точек в многомерном пространстве и векторов, которые к ним ведут. Звучит путано, но статья как раз для начинающих. Здесь разбираются базовые понятия и принцип хранения данных в таких БД, также приводятся понятные примеры. В основном они полезны в области AI и ML, в задачах поиска похожих данных, а сферы применения ограничены только вашей фантазией.

Виктор Василенко в блоге Яндекс.Практикума опубликовал статью «[Кто такой архитектор ПО и как им стать](https://habr.com/ru/companies/yandex_praktikum/articles/762610/)». Я бы не сказал, что она совсем четко отвечает на вопрос, как им стать, но в ней хорошо расписано, что архитектор должен уметь и какие виды архитекторов бывают. Мы уже обсуждали похожую статью, но эта более подробная и конкретная: здесь описаны виды архитекторов, чем они отличаются от инженеров, какие обычно перед ними стоят задачи и какие компетенции им нужны. Если вы стремитесь в архитекторы — стоит прочесть.

Дмитрий Глазков на Хабре опубликовал [статью о React Fiber](https://habr.com/ru/articles/763534/). Новая реализация ключевого алгоритма React доступна уже кучу времени, и, по мнению Дмитрия, сведения в сети по ней довольно устарели. Он взял исходники, отладчик и разобрался в механизме его работы. Это первая часть, в которой он рассказывает об инкрементальном рендеринге. Во второй части будут подробности о неблокирующем рендеринге или `concurrency`.

Как вы уже знаете, будущее наступило, и теперь ChatGPT и похожие инструменты могут помочь с решением большого количества задач. Но можно ли перестать писать тесты и переложить это на плечи искусственного интеллекта? Виталий Потапов задался этим вопросом и попробовал [генерировать BDD end-to-end тесты](https://habr.com/ru/articles/758980/) при помощи машины. В статье он рассказывает про подход, задание параметров генерации и запуск тестов в Playwright. Пока это очень «узкий» кейс, но посмотрим — возможно когда-нибудь разработчикам вообще не надо будет писать тесты.

Теперь парочка материалов о новом рантайме Bun. Разработчик Эмиль Привер (Emil Privér) в своём блоге опубликовал [результат своего сравнения производительности](https://priver.dev/blog/benchmark/go-vs-rust-vs-bun-vs-node-http-benchmark/) Bun c Rust, Node.js и Go в контексте обработки HTTP-запросов. Он приводит разные сценарии тестирования и результаты. В некоторых из них Bun справляется с задачей хуже, чем Rust и Go, но всегда обгоняет Node.js. Больше подробностей в блоге Эмиля.

Второй материал посвящён [базовой реализации серверного рендеринга с Bun](https://habr.com/ru/articles/761756/). Пример очень простой: здесь базовая настройка и генерация проекта, создание простого сервера и реализация SSR с React. Вы не увидите здесь более сложных кейсов, она предназначена для базового ознакомления с Bun.

Специально для тех, кто застал TypeScript как данность и неотъемлемую часть мира веб-разработки, я представляю [документальный фильм о рождении и разработке TypeScript](https://www.youtube.com/watch?v=U6s2pdxebSo). Я заранее предупреждаю, что его продолжительность, как продолжительность полнометражного фильма, составляет час и двадцать минут. Получилось довольно интересно; если вам нравятся документалки — это для вас.

Продолжая тему TypeScript. Андрей Маслов на Хабре собрал [короткий конспект по фичам TS](https://habr.com/ru/articles/762902/), которые могут пригодиться всем в повседневной работе. Материал предназначен и как обучающий, и как справочный. В конце есть и полезные ссылки, например шпаргалка по TS в картинках.

Многопоточность — ещё одна наша любимая тема. Примерно в июле я рассказывал о материале, в котором раскрывались основные понятия, связанные с многопоточностью, как это работает и зачем вообще это всё нужно. Вышло её продолжение-разъяснение по результатам дискуссии в комментариях. Автор считает, что многие не совсем верно понимают концепцию многопоточности и что её изначально придумывали не для увеличения производительности. Об этом, собственно, и обзор. Если вас интересует тема многопоточности или вы ещё не сталкивались с ней — загляните. Я приложу к выпуску [ссылку на первый материал](https://habr.com/ru/articles/748684/) и это [продолжение](https://habr.com/ru/articles/761424/).

Закроет рубрику статья из блога ВК о том, [как правильно произносить на английском языке разные IT-термины](https://habr.com/ru/companies/vk/articles/761856/). В ней собрано 135 терминов с транскрипцией и озвучкой. В целом интересно; если вас интересует работа в зарубежной компании или изучение языка в целом, то будет вполне полезно. В комменты тоже загляните, потому что там есть немного языковых дискуссий и правок.

<ParagraphWithImage imageName="manWithLaptop">
  ### Новости релизов

Вышел [Safari 17](https://webkit.org/blog/14445/webkit-features-in-safari-17-0/). В новой версии добавили поддержку HTML-элемента `<search>`, ряда ARIA-ролей и атрибута `popover`. По части CSS добавили свойство `font-size-adjust`, значения `full-width` и `full-size-kana` для свойства `text-transform`, а также `@supports font-format()` и `@supports font-tech()`. Кроме этого была добавлена поддержка стандарта `Media Queries` 4-го уровня и полная поддержка `Storage API`. Больше подробностей в [release notes](https://developer.apple.com/documentation/safari-release-notes/safari-17-release-notes).
</ParagraphWithImage>

В [Firefox 118](https://www.mozilla.org/en-US/firefox/118.0/releasenotes/) также добавили поддержку HTML-элемента `<search>`. Был добавлен ряд математических функций для CSS: `abs()`, `sign()`, `round()`, `mod()`, `rem()`, `pow()`, `sqrt()`, `hypot()`, `log()`, and `exp()`. Для пользователей добавили систему машинного перевода, которая не обращается к облачным сервисам, а делает перевод локально. И теперь Firefox поддерживает размытие фона и визуальные эффекты в Google Meet. Был добавлен ряд изменений для защиты от косвенной идентификации пользователя. Как и всегда, был устранён ряд багов и уязвимостей. ([Release notes](https://developer.mozilla.org/en-US/docs/Mozilla/Firefox/Releases/118))

Вышла [вторая мажорная версия фреймворка Remix](https://remix.run/blog/remix-v2). Как основную фичу ребята отмечают новую CLI-команду `create-remix`, которая упрощает создание проекта по шаблону из списка. Кроме этого были повышены требования к версиям React и Node.js до 18-х версий. Поддержку RSC или серверных компонентов они решили не добавлять и думают добавить в третьей версии, когда серверные компоненты будут стабильными. И, кажется, ребята подкололи сами себя на тему `react-router`: они сказали, что список ломающих изменений очень маленький. ([Release notes](https://github.com/remix-run/remix/releases/tag/remix%402.0.0))

[Next.js 13.5](https://nextjs.org/blog/next-13-5) порадовал нас оптимизациями: локальный сервер стартует на 22% быстрее, обновление работает на 29% шустрее, а памяти потребляется теперь на 40% меньше. Помимо этого, оптимизировали импорт пакетов и исправили много багов.

В [Node.js 20.7.0](https://nodejs.org/en/blog/release/v20.7.0) после добавления `.env`-файлов из коробки добавили поддержку сразу нескольких `.env`-файлов. Также вышло плановое [обновление LTS-версии 18.18.0](https://nodejs.org/en/blog/release/v18.18.0).

Bun 1.0 вышел и, конечно же, не обошлось без патчей. В патче [Bun 1.0.2](https://bun.sh/blog/bun-v1.0.2) представили большое количество багфиксов и ускоренный `–watch`-режим.

Также в этом выпуске отмечу [релизы GitLab 16.3.4 и 16.2.7](https://about.gitlab.com/releases/2023/09/18/security-release-gitlab-16-3-4-released/) с исправлением критической уязвимости. Она позволяла запускать сценарии в пайплайне от имени произвольного пользователя. Это позволяло получить доступ к внутренним репозиториям и закрытым проектам пользователя.

<ParagraphWithImage imageName="laptopNews" >
    ### Другие новости

Запущен опрос [Interop 2024](https://web.dev/interop-2024-proposals/). Напомню, это инициатива и договоренность крупнейших браузерных вендоров о том, какие фичи в первую очередь нужно реализовать в браузерах. Придумали это для того, чтобы веб-стандарты развивались равномерно и разные фичи максимально консистентно поддерживались разными браузерами. Так, например, в 2023 мы увидели поддержу `:has()`, `Container Queries`, кастомных CSS-свойств и нескольких других фич. Сейчас собирают предложения на 2024 год. Это шанс всех разработчиков немного повлиять на развитие веба, так что не проходите мимо.
</ParagraphWithImage>

В прошлом выпуске мы говорили о результатах `State of CSS 2023`. После него открылся [State of HTML 2023](https://stateofhtml.com/ru-RU/). Резоны поучаствовать всё те же: расскажите о своем взгляде на HTML и узнайте подробно о текущем состоянии HTML. О результатах этого опроса я тоже обязательно расскажу.

26-го октября пройдёт [Next.js Conf](https://nextjs.org/conf). Проходить она будет в гибридном формате, но нужно зарегистрироваться и создать себе аккаунт Vercel, чтобы забрать виртуальный билет. Ребята, очевидно, наращивают пользовательскую базу и будут рассказывать о своих продуктах, но, я думаю, в программе будут и интересные доклады.

Команда JetBrains [представила новую IDE RustRover](https://blog.jetbrains.com/rust/2023/09/13/introducing-rustrover-a-standalone-rust-ide-by-jetbrains/). По названию вы могли догадаться, что она для разработки на Rust. Раньше похожую среду можно было сформировать на основе открытого плагина `intellij-rust`. После анонса IDE его пометили как устаревший, но по идее он всё ещё вполне работает. Это вызвало некоторую волну возмущения и негатива. Стоит помнить, что JetBrains — компания, которая хочет зарабатывать деньги. Это она и делает. Помните об этом, и негативных мыслей сразу станет меньше.

  ### Пишите нам и читайте
  [Telegram—канал CSSSR](https://t.me/csssr)

  [Twitter CSSSR](https://twitter.com/csssr_dev)

  [Twitter новостей](https://twitter.com/csssr_news)

  [Telegram ведущего](https://t.me/Vindizh)

  [Twitter ведущего](https://twitter.com/Vindizh)
