---
title: 'В этом выпуске: цена JS, библиотека htmx, почему стоит решать задачи на LeetCode, релизы Chrome 115 и Firefox 115, популярных рантаймов и инструментов, а также начало опроса State of CSS 2023.'
soundcloudLink: 'https://soundcloud.com/csssr/chrome-115-firefox-115-tsena-js-htmx-relizy-js-rantaymov-state-of-css-2023'
date: '2023-07-24T00:00:00.000Z'
episodeNumber: 237
tag: 'news'
author: 'Ислам Виндижев'
---

Всем привет, это «Новости 512» от CSSSR. В этом выпуске мы поговорим о цене JS, библиотеке `htmx`, новых API, внезапно об интерфейсах для телевизоров и о том, почему стоит решать задачки на LeetCode. Мы обсудим релизы Chrome 115 и Firefox 115, популярных рантаймов и инструментов, а также начало опроса `State of CSS 2023` и песочницу кода на MDN.

К следующему эпизоду я подготовлю небольшой опросник для слушателей и очень прошу вас его заполнить. Заранее спасибо. Теперь новости.

<ParagraphWithImage imageName="laptopNews" >
  ### Интересные публикации

Эдди Османи продолжает напоминать нам о [цене использования JavaScript](https://www.youtube.com/watch?v=ZKH3DLT4BKw). Если вы не знакомы с его работой, он топит за производительность сайтов и стабильную работу сервисов в регионах с медленным интернетом. Примерно раз в год он делает обзорное видео о текущем состоянии JS и его влиянии на производительность сайтов. В новом видео он касается всё того же круга вопросов: как JS «утяжеляет» приложения, какой может быть производительность на разном железе, как оптимизировать JS, что с этим пытаются сделать браузеры и фреймворки и как всё это влияет на пользовательский опыт. Определённо стоит быть в курсе и держать в голове, что использовать JS желательно поменьше.
</ParagraphWithImage>

Продолжая тему «тяжёлого» JS. В итоговый бандл кроме самого JS может попасть и CSS, и даже SVG. В начале подход CSS-in-JS, а потом и что-угодно-in-JS казался революцией и очень классной штукой, но, конечно, были и трейдоффы. Якоб Гросс (Jacob Groß) написал статью о том, [почему стоит отказаться от SVG внутри JS](https://kurtextrem.de/posts/svg-in-js). В статье он объясняет, как вообще SVG попадают внутрь бандла, почему они негативно сказываются на рендеринге и потреблении памяти, а также приводит ряд лучших практик для устранения этой проблемы. Кстати, в начале есть ссылка на пост о том, почему, возможно, стоило бы отказаться и от CSS-in-JS.

[Web Streams API](https://habr.com/ru/articles/744656/) постепенно становится стандартом потоковой передачи данных. Deno, Node.js и браузеры вовсю адаптируют его, а тем, кто о нём не слышал, пора с ним познакомиться. Это основанный на веб-стандартах способ асинхронной потоковой передачи данных по сети. Данные могут разбиваться на чанки, разработчики — гибко работать с данными и управлять перегрузкой сети. Об основах технологии рассказала Лидия Хэлли (Lydia Hallie) в блоге Vercel, а я принёс вам перевод на Хабре. Там будет немного и о самой платформе Vercel, но в самом конце. Что касается раздела про Web Streams, то там всё описано коротенько и достаточно понятно — наслаждайтесь.

Все мы так или иначе пользуемся на проектах переменными окружения. Иногда они могут быть простыми, иногда сложными, а иногда приводить к ошибкам в итоговом приложении. Части неприятностей можно избежать, если типизировать и валидировать их. О том, [зачем и как это сделать](https://habr.com/ru/articles/743798/) при помощи библиотеки `Zod`, следующая статья на Хабре. В статье постановка проблемы, пример решения попроще и более сложные кейсы.

Библиотека `htmx` начинает привлекать к себе всё больше внимания. Цель библиотеки сделать гипертекстовый HTML действительно гипертекстовым. Библиотека расширяет возможности HTML при помощи дополнительных атрибутов, мало весит и вообще обещает золотые горы. Как и многое в наше время, это хорошо забытый старый подход. Если вы ещё не слышали про библиотеку, посмотрите видео «[htmx за 100 секунд](https://www.youtube.com/watch?v=r-GSGH2RxJs)». Также к выпуску я приложу ссылку на [страницу библиотеки](https://htmx.org/) и [дополнительные материалы](https://htmx.org/essays/hypermedia-driven-applications/). Вполне себе стоит познакомиться.

Следующая статья о [тестировании Node.js-приложений](https://practica.dev/blog/testing-the-dark-scenarios-of-your-nodejs-application/). Йони Голдберг (Yoni Goldberg) приготовил в своей статье ряд кейсов, которые чаще всего не учитываются во время написания тестов. Например, ситуация, когда сервис не смог стартануть, или когда возникло необрабатываемое исключение, или, например, когда медленно отвечают какие-то другие сервисы. Он привёл и несколько других примеров. Кейсы интересные и действительно не так чтобы часто проверяются. Это взгляд немного с другого угла, советую заглянуть.

Следующие два материала про новые API. `View Transitions API` предлагает более простой и плавный способ анимации перехода DOM в разные состояния. Крейг Баклер (Craig Buckler) написал [вводную статью о новом API](https://www.sitepoint.com/view-transitions-api-introduction/) и показал разные случаи его применения. Здесь и анимации внутри страницы, и между разными страницами, и комбинация с другими API. Смысл в том, что это CSS и никакого JavaScript. Также к выпуску я приложу и [перевод на Хабре](https://habr.com/ru/articles/745708/).

Следующий API, который я хочу упомянуть, — это `scroll-driven animations`. Раньше, когда нам нужно анимировать что-то, пока идёт скролл, нужно было писать JavaScript. В целом это всё ещё так, но новый API позволяет делать это без JS. Подробнее об этом в блоге Chrome рассказала Юрико Хирота (Yuriko Hirota). В [статье](https://developer.chrome.com/blog/scroll-animation-performance-case-study/) сравнение анимации при помощи JS и нового API, а также небольшой обзор возможностей. API уже доступен в свежей версии Chrome, о которой мы ещё поговорим в этом выпуске.

Мы все спокойно выдохнули, когда в прошлое ушёл старый IE и разного рода хаки, которые нужно было применять при разработке интерфейсов для него. Но есть область, о которой я как-то даже и не задумывался. Это интерфейсы приложений для SmartTV-устройств. Лена Жукова, разработчик в Яндекс.Музыке, [рассказала](https://habr.com/ru/companies/yandex/articles/743104/) об особенностях таких интерфейсов и о том, чем работа отличается от привычного веба. В статье вы увидите как верстать под телек, как управлять приложением в браузере через пульт во время тестирования и другие интересности, о которых вы вряд ли услышали бы где-нибудь ещё.

Для того чтобы сильно не раздувать выпуск о следующих материалах, я постараюсь рассказать покороче.

Вы наверняка помните про `optional chaining`, который уже есть в JS. Появился [новый пропозал](https://github.com/tc39/proposal-optional-chaining-assignment), который предлагает ввести присваивание с использованием опционального оператора. Звучит логично, но, кажется, я понимаю, почему так не сделали сразу: код может стать весьма запутанным и хуже читаться. Но судить вам — ссылка в описании выпуска.

Выбираете себе фреймворк и не знаете как сравнить? Вам на помощь придёт [Component Party](https://component-party.dev/). Это ресурс, на котором сравниваются фичи разных фреймворков с примерами кода. И там не только «большая тройка» — много и других. Мне очень понравилась идея и как в итоге получилось.

[Следующий материал](https://habr.com/ru/articles/745012/) тоже про сравнение, но популярных UI-библиотек для Vue.js. В принципе я уже объяснил суть. Добавлю, что сравниваются порядка 10 позиций и небольшие выводы о том, в каком случае какую библиотеку лучше взять.

Лабать алгоритмы или нет? От себя скажу, что да. Порешайте на LeetCode или аналогичном сервисе. Это сделает вас смелыми, ловкими и умелыми. А если серьёзно, это правда расширяет кругозор и позволяет решать задачи иначе, выбирать лучшие пути, вертеть и рассматривать задачки с разных сторон. Если не верите, прочитайте [статью Нины Торгунаковой](https://evilmartians.com/chronicles/how-a-year-long-leetcode-habit-upped-my-professional-game) об этом — она прорешала примерно 400 задачек за год и поделилась своими мыслями по этому поводу.

Завершат рубрику два инструмента. [driver.js](https://driverjs.com/) для создания интерактивных туров по веб-страницам и [radash](https://github.com/rayepps/radash) — набор утилит, который наверняка напомнит вам `lodash`.

<ParagraphWithImage imageName="manWithLaptop">
  ### Новости релизов

Доступен Chrome 115. Как я уже говорил, в новой версии доступны `scroll-driven animations` — обязательно попробуйте. Пару новых штук подвезли для `Privacy Sandbox`. Напомню, это инициатива, призванная одновременно сохранять приватность пользователей и давать разработчикам достаточное количество информации для работы полезных сервисов. Новыми фичами стали `Topics API` и ограждённые фреймы. DevTools научились отмечать сабгриды специальным значком, отображать вес специфичности элементов тултипом, а также показывать значения кастомных CSS-свойств. Подробнее обо всех изменениях в официальных обзорах релизов [Chrome](https://developer.chrome.com/blog/new-in-chrome-115/) и [DevTools](https://developer.chrome.com/blog/new-in-devtools-115/) от Google.
</ParagraphWithImage>

Вышел [Firefox 115](https://www.mozilla.org/en-US/firefox/115.0/releasenotes/). Встроенный редактор кода теперь будет вести себя более предсказуемо и как в других браузерах — я имею в виду хоткеи, просмотр и редактирование нод и другие мелочи. Были добавлены методы работы с массивами, возвращающие их копии и не изменяющие исходные массивы. Также была добавлена поддержка методов `URL.canParse()` и свойства `animation-composition`. Были и новые приятности для пользователей: обновленный интерфейс импорта данных из других браузеров, нормальный перенос платежной информации из Chromium-браузеров, кнопки закрытия вкладок в менеджере вкладок и другие. Больше подробностей в release notes.

От браузеров перейдём к рантаймам. [Node.js 20.4.0](https://nodejs.org/en/blog/release/v20.4.0) порадовала нас новой фичей — моками таймеров. Как вы догадались, фича позволяет мокать разные таймеры и писать более стабильные, предсказуемые тесты для функциональности, использующей время. [Node.js 18.17.0](https://nodejs.org/en/blog/release/v18.17.0) получил новую, более производительную версию парсера URL Ada 2.0 и реализацию `Web Crypto API`, более согласованную с другими реализациями этого API в вебе.

В [Deno 1.35](https://deno.com/blog/v1.35) был стабилизирован метод `Deno.serve()`. Теперь создать веб-сервер на Deno ещё проще, а сама платформа обещает высокую производительность таких серверов. При этом обеспечена совместимость с другими стандартизированными в вебе API. Продолжились работы по расширению поддержки npm, были представлены улучшения языкового сервера и API самого Deno. Больше подробностей в официальном блоге.

В релизе [Bun 0.6.13](https://bun.sh/blog/bun-v0.6.13) появилась возможность мокать даты в тестах, поддержка пакета `nodemailer` и ряд других небольших улучшений.

Теперь немного об инструментах. Вышла версия `Prettier 3.0`. [Новая версия](https://prettier.io/blog/2023/07/05/3.0.0.html) поддерживает ES-модули и асинхронные парсеры. Также на ES-модули перевели и всю кодовую базу, тем не менее в качестве библиотеки Prettier можно использовать и как CommonJS-модуль. Были и ломающие изменения — подробнее о них в описании релиза.

`styled-components` тоже отметились [мажорной версией 6.0.0](https://github.com/styled-components/styled-components/releases/tag/v6.0.0). В ней починили серьёзный баг, связанный со смешиванием типов. Был и ряд ломающих изменений — [гайд по миграции](https://styled-components.com/docs/faqs#what-do-i-need-to-do-to-migrate-to-v6) вы найдёте в описании выпуска.

В версии [Vite 4.4.0](https://github.com/vitejs/vite/blob/main/packages/vite/CHANGELOG.md#440-2023-07-06) добавили экспериментальную поддержку Lightning CSS, шаблоны для фреймворков Solid и Qwik, а также обновили версию esbuild до 0.18.
 
Также в этом выпуске отмечу релизы бандлера [esbuild 0.18.16](https://github.com/evanw/esbuild/releases), языка программирования [Rust 1.71.0](https://blog.rust-lang.org/2023/07/13/Rust-1.71.0.html) и [VirtualBox 7.0.10](https://www.virtualbox.org/wiki/Changelog-7.0#v10).

<ParagraphWithImage imageName="laptopNews" >
    ### Другие новости

Пришло время опросить разработчиков о CSS в 2023 году. Стартовал опрос [State of CSS 2023](https://stateofcss.com/en-us/). Всё как и в предыдущие годы: в опросе будут вопросы о технологиях, их применении и немного о самих разработчиках. Опрос открыт, а я призываю вас поучаствовать, потому что в итоге получится полезная информация, отображающая текущий CSS-рельеф, тренды развития технологии и куда движемся мы сами. Не пожалейте времени и примите участие.
</ParagraphWithImage>

GitHub продолжает развивать безопасность аккаунтов. Первым шагом была 2FA-инициатива, о которой я как-то говорил. Следующий шаг — аутентификация при помощи специальных ключей. [Новая возможность](https://github.blog/2023-07-12-introducing-passwordless-authentication-on-github-com/) позволяет аутентифицироваться без пароля, в том числе и с использованием другого устройства. Фича уже в открытой бете, больше подробностей в блоге GitHub.

На MDN появилась [собственная песочница для кода](https://developer.mozilla.org/en-US/blog/introducing-the-mdn-playground/). Новость прекрасная, потому что лично моей мечтой была родная песочница прямо в той самой документации. Ну и это правда супер-удобно. Наверняка можно было запартнёриться с какой-нибудь песочницей, но почему этого не было сделано — читайте в блоге MDN.

На сегодня это всё. Ссылки как обычно приложены к эпизоду, до встречи в следующем выпуске.

  ### Пишите нам и читайте
  [Telegram—канал CSSSR](https://t.me/csssr)

  [Twitter CSSSR](https://twitter.com/csssr_dev)

  [Twitter новостей](https://twitter.com/csssr_news)

  [Telegram ведущего](https://t.me/Vindizh)

  [Twitter ведущего](https://twitter.com/Vindizh)
