---
title: 'В этом выпуске: серверные компоненты React, разработка JavaScript-рантаймов, кастомные правила ESLint, Svelte 4, Nest.js 10, Chrome для тестирования и security-обновления Node.js.'
soundcloudLink: 'https://soundcloud.com/csssr/svelte-4-nestjs-10-rsc-eshchyo-ob-arkhitekture-kurs-po-linux-chrome-dlya-testirovaniya'
date: '2023-06-30T00:00:00.000Z'
episodeNumber: 236
tag: 'news'
author: 'Ислам Виндижев'
---

Всем привет, это «Новости 512» от CSSSR. В этом выпуске мы поговорим о продолжении нового цикла Саши Беспоясова, серверных компонентах React, разработке JavaScript-рантаймов, создании кастомных правил линтера, бесплатном курсе по Linux и не только. Мы обсудим релизы Svelte 4, Nest.js 10, специальную версию Chrome для тестирования и security-обновления Node.js.

Перед началом рубрики небольшое объявление. Следующий выпуск новостей также переносится на неделю вперёд. На ближайшую пару недель я ухожу в отпуск и мне надо будет спокойно отдохнуть.

После отпуска я наконец проведу опрос среди слушателей, чтобы понять, что можно улучшить для вас — любимых слушателей. Очень рассчитываю на ваше мнение и обратную связь, спасибо. Теперь к новостям.

<ParagraphWithImage imageName="laptopNews" >
  ### Интересные публикации

Продолжается серия Саши Беспоясова «Явный дизайн в разработке приложений». Вышли ещё три части. В седьмой речь идёт о фичах, которые не относятся напрямую к бизнес-логике, и расширении инфраструктуры. В восьмой и [девятой](https://bespoyasov.ru/blog/explicit-design-9/) — о создании новой фичи, придании фичам большей независимости при помощи событий и том, в каких случаях это нужно. Серия уже плавно приближается к концу, если вы за ней не следите — самое время начать и желательно поэтапно закодить приложение-пример.
</ParagraphWithImage>

Буквально в прошлом выпуске я упоминал видео, в котором разработчики из Core Team React рассказывали о серверных компонентах. Кажется, полноценный релиз фичи приближается, а значит, пора поговорит об этом подробнее. Сегодня материалов об этом целых два.

Первый — [перевод глубокого технического погружения в серверные компоненты](https://habr.com/ru/articles/741604/) от Дэна Абрамова на Хабре. Эта статья не поможет начать пользоваться серверными компонентами или использовать их на своем проекте, но даёт хорошее представление о том, зачем это вообще нужно. Подход через экскурс в прошлое и поэтапное переизобретение собственной версии серверных компонентов. Получилось интересно, а будет ещё две части.

Второй материал — это видео на YouTube «[Серверные компоненты React за 7 минут](https://www.youtube.com/watch?v=1YCccF3Bu3Q)». Так что если вы не очень отличаетесь терпением или только начали интересоваться серверными компонентами, то это ваш выбор и отправная точка.

Давайте посмотрим на рантаймы. Эрик Уендел (Erick Wendel) попробовал разобраться в том, зачем разные команды продолжают делать новые рантаймы и какая между ними разница. В результате получился [доклад](https://www.youtube.com/watch?v=UdTdBknk23A), в котором он рассказывает о том, как Node.js использует `libuv` и как разные рантаймы работают с V8, в частности Deno и Bun. Получилось неплохое введение в то, как в принципе создаются рантаймы и чем они могут отличаться. Если вы интересуетесь вопросом — добро пожаловать по ссылке.

Далее [иллюстрированный гайд по Event Loop](https://www.builder.io/blog/visual-guide-to-nodejs-event-loop). Этот гайд хорош тем, что он лаконичный, быстро и понятно объясняет, почему Event Loop в принципе существует, раскрывает все понятия, которыми хорошо предварительно владеть, чтобы разобраться. Гайды вроде этого я называю «разобраться раз и навсегда». Самое классное не это — это цикл, в котором разбираются с иллюстрациями и другие аспекты: тики и промисы, очереди и ввод-вывод. Если вы чувствуете некоторые пробелы в знании этих нюансов, эта серия — самое то.

Мы уже немного касались нового атрибута `popover`. Вместе с новыми фичами приходят и новые нюансы. Например, [как позиционировать это всплывающее окно](https://hidde.blog/positioning-anchored-popovers/)? Решить эту задачу поможет новая спецификация `Anchor Positioning`, но пока она недоступна повсеместно. На сегодняшний день позицию можно вычислить и при помощи скрипта позиционировать «всплывашку». Подробности и пример — по ссылке на материал.

У всех браузеров есть какие-то дефолтные стили, которые в итоге могут сделать ваш CSS не вполне кроссбраузерным и вызвать путанницу, сложности при тестировании и другие неприятности. Поэтому строители египетских пирамид подарили нам сброс CSS или CSS reset, который сбрасывает дефолтные стили браузеров и позволяет нам жить лучше и писать CSS без больших опасений. Сейчас классический ресет не так уж необходим, и Джош Комо (Josh Comeau) предложил [свой вариант ресета](https://www.joshwcomeau.com/css/custom-css-reset/), который будет актуальным на сегодняшний день. Это скорее даже базовая настройка, чем ресет. Он объясняет каждый пункт и призывает попробовать создать свой собственный ресет. 

Писать код — это хорошо, но ухаживать за ним надо, и новых людей к нему подключать — тоже. С этим нам очень помогают разнообразные линтеры, в частности ESLint. В нём есть много реализованных правил, можно создавать конфиги и даже писать собственные правила. Анастасия Щедрина на Хабре написала [статью как раз об этом](https://habr.com/ru/companies/domclick/articles/743384/). Она рассказала о том, как в принципе работает линтер, какая анатомия у правил, как создавать собственные и как протестировать их после создания. Получился классный, подробный гайд.

Я уже пару раз говорил о ES2023 и ещё раз принёс материал о разных версиях EcmaScript. Ирина Мельникова на Хабре написала [заметку](https://habr.com/ru/articles/741372/) не только о том, какие фичи войдут в ES2023, но и какие вошли в 2021 и 2022 году. Хорошая заметка, чтобы накануне выхода новой версии поднять парочку предыдущих. Если вы не совсем в теме развития стандарта в принципе, у Ирины есть [статья и об этом](https://habr.com/ru/articles/740934/): она охватывает развитие стандарта с 2015 года и ES6. Если вы хотите узнать, когда появился спред оператор, то вам как раз во вторую статью.

Практически каждый день мы используем DevTools при разработке и тестировании приложений. И лично я очень люблю подборки с подсказками, хоткеями и другими интересностями по DevTools. Патрик Бросcет (Patrick Brosset) в своей заметке для SmashingMagazine собрал [целых 15 пунктов](https://www.smashingmagazine.com/2023/06/popular-devtools-tips/). Здесь всего понемногу: и симуляция устройств, и работа со стилями, шрифтами и дебаггером. Ещё там был пункт про представление страницы в 3D — я не знал, что так можно, и всё ещё думаю зачем.

В конце рубрики несколько материалов, которые лежат в области обучения и интересностей.

Если вы всегда мечтали освоить Linux и работу с командной строкой, решать типовые задачи и разобраться в том, какие есть утилиты и как админить Linux, — вам сюда. На `KillerKoda` доступен [бесплатный курс](https://killercoda.com/kodxxl/course/Linux) именно об этом. Выглядит достаточно неплохо, тут есть что почерпнуть и уже уверенным пользователям, которые повседневно работают на Linux.

Если вы присматриваетесь к фреймворку Nuxt — следующий материал для вас. Это видео «[Nuxt.js за 100 секунд](https://www.youtube.com/watch?v=dCxSsr5xuL8)». Это вводный гайд, который коротко рассказывает об основных возможностях фреймворка с небольшим сравнением с другими технологиями. Быстро, компактно, поможет принять решение, пробовать или нет.

А вот парочка небольших интересностей. Сервис [Vuetelescope](https://www.vuetelescope.com/), который позволяет проверить, сделан ли какой-то сайт на Vue или нет, и библиотека [knip](https://github.com/webpro/knip), которая находит неиспользуемые файлы, зависимости и экспорты.

Теперь к релизам.

<ParagraphWithImage imageName="manWithLaptop">
  ### Новости релизов

Рубрика начнётся с релиза новой мажорной версии фреймворка Svelte. Спустя 4 года вышла [четвёртая мажорная версия](https://svelte.dev/blog/svelte-4). В этом релизе поработали над производительностью, переработали раздел с документацией и привнесли ряд улучшений и удобств для разработчиков. Эта версия — подготовка к пятой версии, в которой собираются переписать рантайм и компилятор, что должно вывести фреймворк на новый уровень производительности. Больше подробностей — в анонсе релиза, также обязательно посмотрите на гайд по миграции.
</ParagraphWithImage>

Доступен [Angular 16.1](https://github.com/angular/angular/releases/tag/16.1.0). В этом релизе добавили поддержку TypeScript 5.1 и две фичи в статусе Ready for comment: встроенную декларативную ленивую загрузку и экспериментальный синтаксис управления потоком.

Команда Chrome анонсировала [Chrome для тестирования](https://developer.chrome.com/blog/chrome-for-testing/). Это специальная версия, которая предназначена для тестирования и автоматизации. Основное отличие в том, что у неё нет автообновления и она позволяет скачать любую конкретную версию Chrome для воспроизведения багов. Подробности — в блоге Chrome.

Нечастые гости в моих выпусках — инструменты, связанные с функциональными языками, но сегодня как раз тот день. Вышла [версия 1.0 библиотеки Melange](https://buttondown.email/anmonteiro/archive/melange-hits-v10/). Это библиотека, которая компилирует OCaml и ReasonML код в JavaScript. Если это в вашей области интересов, то библиотека готова к использованию. Осторожно, от неё могут появиться видения и посинеть глаза.

Команда Node.js представила [июньские security-релизы](https://nodejs.org/en/blog/vulnerability/june-2023-security-releases). Обновления безопасности вышли под номерами версий 16.20.1, 18.16.1 и 20.3.1. Релизы включают в себя обновления безопасности OpenSSL, устранение нескольких багов высокой и средней степени опасности. Это довольно большое обновление безопасности, не забывайте вовремя обновляться.

Рантайм Bun тоже отличился релизом [версии 0.6.9](https://bun.sh/blog/bun-v0.6.9). В этом релизе было оптимизировано потребление памяти, исправлен ряд багов бандлера, загрузки модулей CommonJS, а также команд `bun run` и `bun install`.

Вышла [десятая мажорная версия фреймворка Nest.js](https://trilon.io/blog/nestjs-10-is-now-available). Теперь фреймворк может работать с компилятором SWC, перегружать модули в тестах и подписываться на сообщения от Redis по паттерну. Также в этой версии исправили пару багов миддлвар, представили несколько улучшений для работы с вебсокетами и микросервисами. Изменились минимальные требования к версии Node.js: версия 12 больше не поддерживается, минимально необходимая — 16-ая. А CLI-плагины теперь требуют версию TypeScript 4.8 и выше. К выпуску я также приложу [гайд по миграции](https://docs.nestjs.com/migration-guide).

Доступно [Early Access Preview WebStorm 2023.2](https://blog.jetbrains.com/webstorm/2023/06/webstorm-2023-2-eap6/). Подвезли много интересного: появилась поддержка Emmet для Preact и SolidJS, поддержка нестинга в CSS, было улучшено форматирование ошибок типов TS, и, куда же без этого сейчас, ассистент с искусственным интеллектом — пока он помогает генерить коммиты и ещё пару мелочей. Удобным может показаться коммит определённых строк кода и подсказки для JSON. Полный список изменений доступен по ссылке.

Также отмечу в этом выпуске релизы [ESLint 8.43.0](https://eslint.org/blog/2023/06/eslint-v8.43.0-released/), операционной ситемы [Debian 12](https://www.debian.org/News/2023/20230610) и [ядра Linux версии 6.4](https://lkml.org/lkml/2023/6/25/453).

<ParagraphWithImage imageName="laptopNews" >
    ### Другие новости

Завершился [опрос StackOverflow 2023](https://survey.stackoverflow.co/2023/). Наша любимая платформа с вопросами и ответами проводит его уже много лет. Я попробую коротко изложить интересности из опроса. JS был самым популярным языком среди респондентов, рядом были замечены Python и Java. Топ веб-фреймворков и технологий состоит из React, Node.js и jQuery (здорово, старичок!). Распространенные СУБД не изменились: это PostgreSQL, MySQL и MSSQL, также рядышком MongoDB. Небольшое отличие в том, что PostgreSQL заняла лидирующую позицию, обойдя MySQL. Среди прочих технологий лидируют Docker, npm, редактор VSCode, AWS, ChatGPT, Slack и Microsoft Teams, а также Jira и Confluence. Также в опросе затрагивались аспекты коммьюнити, обучения, адаптации технологий и другие. В результатах много и других интересных ответов, рекомендую посмотреть.
</ParagraphWithImage>

Закончит выпуск небольшая новость про процессор «Эльбрус». Газпромбанк [анонсировал](http://mcst.ru/2023-06-15_gazprombank_processing_elbrus) перевод процессинга на системы под управлением процессоров российского производства. К 2025 году планируется перевести процессинг, банкоматы и другие критичные системы на «Эльбрусы». Лично мне интересно, как скоро эти процессоры смогут всерьёз составить конкуренцию другим. Посмотрим.

На сегодня это всё, ссылки, как и всегда, приложены к выпуску. Всем пока и до встречи через 3 недели.

  ### Пишите нам и читайте
  [Telegram—канал CSSSR](https://t.me/csssr)

  [Twitter CSSSR](https://twitter.com/csssr_dev)

  [Twitter новостей](https://twitter.com/csssr_news)

  [Telegram ведущего](https://t.me/Vindizh)

  [Twitter ведущего](https://twitter.com/Vindizh)
