---
title: 'В этом выпуске: релизы Chrome 114, Firefox 114, TypeScript 5.1 и другие. Новая архитектурная серия Саши Беспоясова, создание бандлера, методы для работы с массивами и ещё раз фичи ES2023. В этом же выпуске материалы о написании ChatGPT-плагина на JS, безопасности фронтенда и работе карт.'
soundcloudLink: 'https://soundcloud.com/csssr/chrome-114-firefox-114-typescript-51-razrabotka-bandlera-nyuansy-js-react-10-let'
date: '2023-06-10T00:00:00.000Z'
episodeNumber: 235
tag: 'news'
author: 'Ислам Виндижев'
---

Всем привет. В этом выпуске мы поговорим про новую серию Саши Беспоясова о проектировании приложений, попробуем написать свой бандлер, разберём методы для работы с массивами и ещё раз глянем на фичи ES2023. В этом же выпуске материалы о написании ChatGPT-плагина на JS, безопасности фронтенда и работе карт. Были и релизы: Chrome 114, Firefox 114, TypeScript 5.1 и другие.

<ParagraphWithImage imageName="laptopNews" >
  ### Интересные публикации

Первый материал выпуска касается JS-инфраструктуры. Кристоф Наказава (Christoph Nakazawa) написал [небольшую серию](https://cpojer.net/posts/building-a-javascript-bundler), в которой рассуждает о текущих проблемах и устройстве JS-экосистемы. В серии не только рассуждения, но и два интересных упражнения: автор предлагает реализовать свой тестовый фреймворк и бандлер. Тестовый фреймворк будет уметь прогонять тесты параллельно, изолировать их, и у него будет свой assertion-фреймворк. Бандлер в свою очередь тоже будет базово уметь всё, что ему положено: работать с зависимостями, компилировать их, запускать бандл. А читатель по идее поймёт, как эти фичи реализованы в современных инструментах, которыми мы пользуемся каждый день. Получилось неплохо и должно хорошо прокачать понимание устройства этих инструментов.
</ParagraphWithImage>

Давненько в моих выпусках не было новостей от доктора Акселя. В своём блоге он опубликовал [статью](https://2ality.com/2022/05/processing-arrays-non-destructively.html) о том, при помощи каких инструментов лучше обрабатывать массивы. Он разбирает разницу между циклом `for-of`, методами `reduce()` и `flatMap()`. Для разбора он реализует один и тот же набор задач при помощи трёх фич и по каждой даёт рекомендации, в каком случае их использовать. Короткие выводы: `for-of` наиболее универсальный, `reduce()` хорош в вычислениях сумм без мутации аккумулятора, а `flatMap()` отжигает в фильтрации, обходе массива и производстве какого-то количества производных, результирующих из исходного. По каждому пункту есть более подробный комментарий, очень советую заглянуть.

Ещё в апреле Саша Беспоясов начал крутую серию, которую назвал «[Явный дизайн в разработке приложений](https://bespoyasov.ru/blog/explicit-design-series/)». На примере приложения-конвертера вымышленных валют Саша в течение серии постарается применить разные архитектурные приёмы, идеи и  подходы, о которых пишут в книгах, говорят на конференциях и на барных фронтенд-посиделках. Цель серии — проверить, насколько полезны эти самые подходы, а заодно вдохновить читателей на новые идеи для своих приложений и их развития. В первой части есть дисклеймер, что это не инструкция, а именно пища для размышлений. Очень рекомендую читать и вникать, следуя за реализацией приложения. Сейчас готово чуть больше половины серии, а Саша хочет написать ещё ряд постов на смежные темы. Бонусом есть довольно много ссылок на дополнительные материалы для чтения.

Что может быть хуже, чем блокировка действий пользователя на странице из-за «тяжёлого» скрипта или по другой причине? Оказалось, что такая проблема была и у Википедии. Николас Рей (Nicholas Ray) поделился в [статье](https://www.nray.dev/blog/300ms-faster-reducing-wikipedias-total-blocking-time/) тем, что такое Total Blocking Time и почему этот параметр важен. В итоге он описывает конкретный кейс мобильной версии Википедии. При клике скрипт блокировал действия пользователя почти на 600 миллисекунд. В итоге оказалось, что часть JS нужно было удалить, а оставшуюся — оптимизировать. Таким образом, время блокирования сократилось на 300 миллисекунд, или в 2 раза.

В блоге рантайма Bun появилась [статья о «родном» бандлере](https://bun.sh/blog/bun-bundler). Он перешёл в статус беты, и его уже можно попробовать. Команда разработки обещает минималистичный API, отсутствие лишних операций, удобную работу с плагинами и самую быструю скорость работы среди сборщиков на сегодняшний день. Скорость надо проверять на разных кейсах, дело понятное, но в целом это неплохой шаг в сторону того, чтобы растопить сердца разработчиков и привлечь больше внимания к инструменту. Больше подробностей — в блоге Bun.

Следующий материал для начинающих и продолжающих JS-разработчиков. Это целый [цикл о нюансах работы JS](https://dev.to/codecraftjs/demystifying-the-javascript-event-loop-15f1), об которые на старте спотыкаются все. В нём разбираются и области видимости, и прототипное наследование, замыкания и функции первого класса. Также разбирается работа Event Loop и контекста `this`. Неплохой цикл, если нужно поднять какие-то знания или разобрать один конкретный нюанс.

Самуэль Окануме (Samuel C. Okanume) на dev.to тоже решил погрузить читателя в JS. Но в его [заметке](https://dev.to/sammychris/master-javascript-functions-unraveling-function-closures-first-class-higher-order-functions-342n) идёт речь о конкретном аспекте — функциях. Он разбирает понятие функций первого класса и функций высшего порядка, передачу функций как аргументов и как в разных случаях работает контекст. Всё это уместилось в компактную памятку, которую можно прочесть буквально за пару минут.

Продолжая тему JS. Я уже рассказывал о новых фичах, которые войдут в ES2023, и что, на мой взгляд, этот год получился довольно скромным. Мне попалась [короткая заметка](https://h3manth.com/ES2023/), где все фичи описаны примерами кода. Напомню, что в новой версии стандарта появится возможность использовать символы как ключи WeakMap, методы для преобразования массивов без мутации и методы поиска с конца массива. Ещё будет унифицировано описание среды выполнения для JS-скриптов. Ссылка — в описании выпуска.

Уна Кравец (Una Kravets) написала [статью](https://developer.chrome.com/blog/introducing-popover-api/) о `popover API`. Это API, который позволит просто создавать всплывающие элементы. Уна приводит примеры использования API, пример стилизации всплывающих элементов и рассказывает о некоторых нюансах работы. Важно отметить, что `popover` или «всплывающий элемент» — это не то же самое, что диалоговое окно. Разница в том, что диалоговое окно или `dialog` требует явного закрытия окна пользователем. Фича уже доступна в 114-м релизе Chromium. О выходе Chrome 114 мы поговорим чуть позже.

Дальше пойдут несколько материалов покороче и из смежных сфер.

В техническом блоге Тинькофф на Хабре была опубликована [статья о взаимодействии микрофронтендов](https://habr.com/ru/companies/tinkoff/articles/736352/). В статье описывается паттерн «Шина событий» или «Event bus». Это не подробная инструкция, но если это ваш случай, вы будете знать, куда гуглить дальше.

Итак, восстание машин предсказали уже много-много раз, а мы с вами вернёмся к ChatGPT. Для ChatGPT можно писать плагины, но официальная документация довольно скудная и вся написана с примерами на Python. Марк О’Нил (Mark O'Neill) решил исправить эту несправедливость и написал инструкцию о том, [как написать ChatGPT-плагин на JavaScript](https://www.sitepoint.com/javascript-chatgpt-plugin/). Он рассказывает об экосистеме плагинов, их структуре и ограничениях. Если вы хотели попробовать создать собственный плагин, это именно то.

Следующая статья о картах. Все мы так или иначе работали с картами на проектах, но как они выглядят изнутри и как работают? На этот вопрос в своей [статье на Хабре](https://habr.com/ru/articles/737592/) пытается ответить Роман Варламов. Он рассказал о том, как хранятся данные карт, как работают маршруты и другие функции карт. Там ещё больше информации и интересностей о картах, но надо читать. Очень советую.

Немного о безопасности фронтенда. Михаил Федотов на Хабре собрал в статье самые разные [потенциальные уязвимости фронтенд-приложения](https://habr.com/ru/articles/736866/). Здесь и инъекционные атаки, и перехваты, и атаки через зависимости — в общем, много. Есть и ссылки для дополнительного чтения. По статье можно составить хорошую общую картину по видам разных атак.

Завершит рубрику статья Джорана Куинтета (Joran Quinten) о его опыте [обновления инструментов в крупных организациях](https://www.smashingmagazine.com/2023/05/big-tooling-upgrades-large-organizations/). Он рассказывает, как не запутаться, когда вовремя договориться между подразделениями и как правильно начать внедрение новых инструментов или их версий.

<ParagraphWithImage imageName="manWithLaptop">
  ### Новости релизов

Вышел Chrome 114. Появилась поддержка нового значения свойства `text-wrap: balance`, кукис с независимым сегментированным состоянием и `Popover API`, который я уже упоминал. В DevTools появилась возможность дебажить WASM-приложения на C и С++, Lighthouse был обновлён до версии 10.1.1, был добавлен ряд улучшений вкладки `Performance`. Подробнее — в официальных обзорах новых [Chrome](https://developer.chrome.com/blog/new-in-chrome-114/) и [DevTools](https://developer.chrome.com/blog/new-in-devtools-114/) от Google.
</ParagraphWithImage>

Под тем же номером 114 подъехало и [обновление Firefox](https://developer.mozilla.org/en-US/docs/Mozilla/Firefox/Releases/114). `Workers` теперь поддерживают загрузку ES-модулей. Была добавлена поддержка `Web Transport API` и исправлен ряд багов.

В слоупок-режиме о фичах [Safari 16.5](https://webkit.org/blog/14154/webkit-features-in-safari-16-5/). Эта версия поддерживает `CSS nesting`, который доступен, например, в Chrome с версией 112. Также добавили поддержку псевдоклассов `:user-valid` и `:user-invalid`, а также отложенной оплаты и предзаказов через Apple Pay в вебе. Был представлен и ряд багфиксов.

Доступен [TypeScript 5.1](https://devblogs.microsoft.com/typescript/announcing-typescript-5-1/). Невероятных, глобальных изменений не случилось: всё-таки это не такой крупный релиз, как релиз пятой мажорной версии. При этом добавилось приятностей. Например, TS теперь сам может выводить `undefined`, `get` и `set` могут быть совсем несвязанных типов, улучшения для `JSX` и некоторые оптимизации. Больше подробностей — в блоге TypeScript.

Рантайм Deno продолжает двигаться ко второй мажорной версии, но пока вышла [версия 1.34.0](https://deno.com/blog/v1.34). Наверное, самое важное в этом релизе — поддержка компиляции npm-пакетов через `deno compile`. В этом релизе основным фокусом было улучшение взаимодействия с npm и Node.js, а также подготовка к будущим работам для улучшений производительности рантайма.

В [Rome 12.1.0](https://rome.tools/blog/2023/05/10/rome12_1/) появилась возможность интеграции с системами контроля версий, поддержка декораторов и много новых правил для линтера.

Вышел важный [security-релиз Gitlab 16.0.1](https://about.gitlab.com/releases/2023/05/23/critical-security-release-gitlab-16-0-1-released/). В версии 16.0.0 была обнаружена уязвимость, которая позволяла читать файлы на сервере неаутентифицированному пользователю при определённых условиях. Команда Gitlab рекомендует немедленно обновиться. Больше подробностей — в release notes.

Также отмечу релизы [git 2.41.0](https://www.spinics.net/lists/git/msg461506.html), бандлера [Parcel 2.9.0](https://parceljs.org/blog/v2-9-0/), языка программирования [Rust 1.70.0](https://blog.rust-lang.org/2023/06/01/Rust-1.70.0.html) и фреймворка [Electron 25.0](https://www.electronjs.org/blog/electron-25-0).

<ParagraphWithImage imageName="laptopNews" >
    ### Другие новости

[React исполнилось 10 лет](https://vercel.com/blog/10-years-of-react). Празднуя это событие, ребята из Vercel [пригласили пообщаться двух разработчиков из Core-команды React](https://www.youtube.com/watch?v=g5BGoLyGjY0): рассказать о перспективах развития библиотеки, новых фичах и дать советы начинающим. Затрагивались архитектура, серверные компоненты и другие фичи. Получилась довольно интересная беседа, ссылка на запись — в описании выпуска.
</ParagraphWithImage>

Ещё один день рождения конца мая — день рождения Node.js. Рантайму исполнилось 14 лет, он продолжает развиваться, хоть у него и появилось много конкурентов. Пользуясь случаем, напомню, что 19-ая версия достигла стадии `End-of-Life`, ближайшая стабильная версия — 20-ая, не забывайте обновляться.

  ### Пишите нам и читайте
  [Telegram—канал CSSSR](https://t.me/csssr)

  [Twitter CSSSR](https://twitter.com/csssr_dev)

  [Twitter новостей](https://twitter.com/csssr_news)

  [Telegram ведущего](https://t.me/Vindizh)

  [Twitter ведущего](https://twitter.com/Vindizh)
