---
title: 'В этом выпуске: релизы Firefox 113, Next.js 13.4 и Vue 3.3. Мы поговорим о регулярных выражениях, взаимодействии микрофронтендов и оптимизации компилятора TypeScript. Мы немного поговорим о браузерной версии «Героев 3», redux-saga и потенциальном сопернике Copilot от Google.'
soundcloudLink: 'https://soundcloud.com/csssr/firefox-113-nextjs-134-vue-33-vzaimodeystvie-mikrofrontendovov-google-codey'
date: '2023-05-19T00:00:00.000Z'
episodeNumber: 234
tag: 'news'
author: 'Ислам Виндижев'
---

Всем привет, это «Новости 512» от CSSSR. В этом выпуске мы поговорим о регулярных выражениях, взаимодействии микрофронтендов и оптимизации компилятора TypeScript. Мы немного поговорим о браузерной версии «Героев 3», redux-saga и потенциальном сопернике Copilot от Google. В этом же выпуске: релизы Firefox 113, Next.js 13.4 и Vue 3.3.

<ParagraphWithImage imageName="laptopNews" >
  ### Интересные публикации

Регулярные выражения помогают нам работать со строками и текстами. Они очень полезные, но освоить их достаточно сложно. Адебайо Адамс (Adebayo Adams) в [своей статье](https://www.honeybadger.io/blog/javascript-regular-expressions/) постарался собрать всё, что нужно знать о регулярных выражениях в JavaScript. Начиная с основ и постепенно усложняя материал, он рассказывает о базовых конструкциях, разных нотациях, методах, квантификаторах и всех других важных аспектах работы регулярных выражений. В конце статьи ещё и несколько примеров реальных задач. Получился хороший, подробный обзор. Даже если вы чувствуете себя уверенно в работе с регулярками, загляните освежить знания.
</ParagraphWithImage>

Про микрофронтенды говорят много и часто, все уже видели миллионы схем со стрелочками и прочими делами, но как организовать обмен данными по этим самым стрелочкам? Об этом [следующая статья](https://habr.com/ru/companies/simbirsoft/articles/734342/). В материале описываются несколько способов организации взаимодействия между микрофронтами. Здесь и старые знакомые (например, iFrame), и относительно новые технологии (например, BroadcastChannel API). Помимо них рассматриваются событийные CustomEvent API и Storage event. У каждого метода есть свои преимущества, недостатки и ограничения, о них коротко для каждой технологии и рассказывает автор.

Писать сложные типы на TypeScript непросто, но ещё сложнее найти какой-то более понятный, реальный пример. В [следующей статье](https://habr.com/ru/articles/735542/) пример написания типов на примере роутинга в React. В гайде используется react-router, сам React и набор TS-утилит. Конечно, типы для роутера и так уже написаны, но в этом материале изобретается велосипед в исключительно образовательных целях. Рекомендую: получился пример реальной проблемы, а разбор процесса написания сложных типов получился очень подробный.

Следующий материал довольно сложный, по крайней мере для меня. В блоге TypeScript Рон Бактон (Ron Buckton) рассказал о новом VS Code-плагине [Deopt Explorer](https://devblogs.microsoft.com/typescript/introducing-deopt-explorer/), при помощи которого оптимизировали компилятор TypeScript. Речь идёт об исследовании встроенного кеширования, или Inline caching — технике оптимизации, которая применяется в разных движках. В некоторых условиях она становится менее  эффективной или даже деоптимизирует работу движка. Для исследования проблемных мест и пригодится новое расширение. Также в статье Рон показывает пример поиска и устранения подобной деоптимизации. Пригодится всем, кто так или иначе имеет дело с работой V8 и интересуется работой движков.

Redux-saga практически стандарт индустрии при работе с Redux. Она помогает работать с сайд-эффектами и упрощает их тестирование. Именно о «саге» рассказывает в своей статье на Хабре Станислав Быков. Это [обзорный материал](https://habr.com/ru/companies/usetech/articles/735914/), который проводит читателя по всем основным возможностям библиотеки и объясняет основные концепции. Также в статье есть и примеры работы с библиотекой.

В CI/CD-пайплайне много чего может пойти не так, а узких мест может быть предостаточно. Это один из кейсов, когда установка зависимостей «ела» кучу времени и тормозила пайплайн. Федор Биличенко рассказал о том, [как удалось ускорить пайплайн за счет оптимизации установки зависимостей](https://habr.com/ru/companies/kts/articles/735104/). Помог Yarn и его философия Zero-Installs. Проще говоря, зависимости будут храниться в репе в виде архива — по сути это оффлайн-кэш зависимостей. В итоге пайплайн ускорился в три раза. Больше подробностей о кейсе по ссылке в описании выпуска.

Немного о тестировании. Cypress — прекрасный инструмент для тестирования. Часто он используется и при автоматизированном тестировании. Для «чистого» тестирования может быть очень важно изолированное окружение, имитирующее правильные условия. О том, как использовать Cypress в связке с Docker, на Хабре [рассказал](https://habr.com/ru/articles/734820/) Алексей Санжанов. Он показал примеры использования официальных образов Cypress и некоторые приёмы работы с контейнерами на небольшом тестовом проекте. Если вы хотите подружить Docker и Cypress на своих проектах, это хорошая стартовая точка.

Иногда тесты Jest могут падать ложно. В тесты может просачиваться состояние, они могут быть зависимы от порядка выполнения, и это не полный список причин. Джейми Мэги (Jamie Magee) в своём блоге [рассказал](https://jamiemagee.co.uk/blog/your-jest-tests-might-be-wrong/) о настройках Jest clearMocks, resetMocks, restoreMocks и resetModules, которые стоит включить, чтобы среда ресетилась перед прогонами. В статье более подробно рассказывается о самих настройках и есть примеры того, как тесты могут быть ложнонегативными.

В блоге web.dev появилась [статья о новой спецификации Scroll-driven animations](https://developer.chrome.com/articles/scroll-driven-animations/). В статье вы найдёте небольшой рекап о том, как анимации работают сейчас, и много демок новой спецификации. Есть даже отдельный [мини-сайт с демками](https://scroll-driven-animations.style/). Если я всё правильно понял, то этот API будет доступен уже в Chrome 115.

Что вы делаете, когда веб-страницу нужно сохранить как PDF-файл? Правильно, берёте браузер и выбираете «Печать в PDF». Но что, если по какой-то причине этого делать нельзя? Например, из-за требований к безопасности, как [в следующем кейсе в Лаборатории Касперского](https://habr.com/ru/companies/kaspersky/articles/734144/). Разработчик Алексей Сингур рассказал о том, как задача решалась при помощи библиотеки React-PDF. Тут разбор кейса, самой библиотеки и обзор преимуществ с недостатками.

Если вы уже давно не писали на «ванильном» JS, то загляните в [эту статью](https://habr.com/ru/articles/733570/). Это перевод статьи Пола Кнулста (Paul Knulst) об основных особенностях JS. Здесь о замыканиях, прототипном наследовании, Event Loop, приведении типов и других особенностях. Если вы собираетесь готовиться к собесу или просто хотите поднять базу ещё раз — добро пожаловать по ссылке.

В конце статья на Хабре о ни много ни мало [браузерной версии «Герои 3»](https://habr.com/ru/companies/soletude/articles/726416/). Разработка заняла три года, кучу строк кода, нервов и времени на тесты. В ней есть мультиплеер на веб-сокетах, возможность создания модов и другие фичи. Посмотрите,  суперинтересно. В проекте достаточно багов — автор будет рад баг-репортам и помощи.

<ParagraphWithImage imageName="manWithLaptop">
  ### Новости релизов

Firefox догоняет Chrome с номером [версии 113](https://www.mozilla.org/en-US/firefox/113.0/releasenotes/). В этом релизе по умолчанию включена поддержка новых цветовых спецификаций и функций. Это значит, что `oklch()` теперь поддерживается всеми мажорными браузерами. Был добавлен Compression Streams API, который может сжимать и распаковывать `gzip` и `deflate`. В DevTools прокачали поиск по JS-файлам, доступным в отладчике. Также был представлен ряд исправлений багов и устранён ряд уязвимостей.
</ParagraphWithImage>

Вышла версия [Next.js 13.4](https://nextjs.org/blog/next-13-4). В этом релиза App Router вышел как уже стабилизированная часть фреймворка. Кроме того, бандлер Turbopack получил статус беты, и его уже можно попробовать. Больше подробностей о релизе — в блоге Next.js.

Доступен [Vue версии 3.3](https://blog.vuejs.org/posts/vue-3-3). Эту версию назвали в честь Бродяги Кенсина, если вы смотрели это аниме и понимаете, о чем я. В этом релизе разработчики сосредоточились на улучшении DX при использовании Vue с TypeScript. Была анонсирована экспериментальная фича реактивной деструктуризации пропсов, а также ряд небольших инфраструктурных апдейтов.

Тестовый фреймворк Jasmine отметился релизом [пятой мажорной версии](https://github.com/jasmine/jasmine/blob/main/release_notes/5.0.0.md). Главная фича релиза — поддержка параллельного исполнения тестов. Кроме этого появилась поддержка 20-ой версии Node.js.

Вышел важный [security-релиз Gitlab](https://about.gitlab.com/releases/2023/05/05/critical-security-release-gitlab-15-11-2-released/#malicious-runner-attachment-via-graphql), который устраняет критическую уязвимость. В определённых условиях через GraphQL-эндпоинт к любому проекту инстанса может быть приложен вредоносный раннер. Только в мае security-релизов было уже три. Не забывайте вовремя обновляться.

Также в этом эпизоде отмечу релизы [pnpm 8.5.1](https://github.com/pnpm/pnpm/releases/tag/v8.5.1) и фреймворка [Electron 24.2.0](https://github.com/electron/electron/releases/tag/v24.2.0).

<ParagraphWithImage imageName="laptopNews" >
    ### Другие новости

На главном для Google событии года Google I/O помимо новых устройств и презентации новой версии Android был представлен сервис [Google Codey](https://9to5google.com/2023/05/10/google-codey-programming-generative-ai/). Codey — это основанный на языковой модели PaLM 2 ассистент в написании кода. Пока он может работать с двадцатью языками, умеет писать и объяснять строчки кода. Конечно, его видят как конкурента Copilot от Microsoft и GitHub. Пока непонятно, сколько это будет стоить и в каком виде сервис будет доступен для пользователей. Посмотрим, увидим ли мы битву битву искусственных интеллектов в обозримом будущем.
</ParagraphWithImage>

  ### Пишите нам и читайте
  [Telegram—канал CSSSR](https://t.me/csssr)

  [Twitter CSSSR](https://twitter.com/csssr_dev)

  [Twitter новостей](https://twitter.com/csssr_news)

  [Telegram ведущего](https://t.me/Vindizh)

  [Twitter ведущего](https://twitter.com/Vindizh)
