---
title: 'В этом выпуске: релизы Chrome 112 и Firefox 112, Node.js 20, «родной» тест-раннер Node.js, стрим о серверных компонентах React и новая фича Signals для Angular. Также: что войдёт в ECMAScript 2023 и исследование руководителей разработки в 2023 году.'
soundcloudLink: 'https://soundcloud.com/csssr/chrome-112-firefox-112-ecmascript-2023-nodejs-20-nodetest-angular-signals'
date: '2023-04-21T00:00:00.000Z'
episodeNumber: 232
tag: 'news'
author: 'Ислам Виндижев'
---

Всем привет, это «Новости 512» от CSSSR. В этом выпуске мы поговорим про релизы Chrome 112 и Firefox 112, Node.js 20, «родной» тест-раннер Node.js, взглянем на стрим с Дэном Абрамовым о серверных компонентах React и новую фичу Signals для Angular. Сегодня же мы бегло глянем, что войдёт в ECMAScript 2023, хакнем браузер, посмотрим на другие релизы и узнаем, как выглядит и чем занимается руководитель разработки в 2023 году.

<ParagraphWithImage imageName="laptopNews" >
  ### Интересные публикации

Я уже рассказывал о том, что в Node.js появился свой тест-раннер. Работа над ним продолжается, и появляются более полные обзоры его возможностей. [Один из таких разборов](https://glebbahmutov.com/blog/trying-node-test-runner/) написал Глеб Бахмутов. Он проходится по возможностям раннера от базового исполнения тестов последовательно или параллельно до отчетов по покрытию, CI и поддержки TypeScript. В конце статьи небольшая табличка-сравнение раннера с уже известными популярными технологиями: Jest, Ava и Mocha. Если вам очень лениво открыть и прочитать, то короткий итог такой: тест-раннер хорош, но кое-чего пока не хватает. Глеб не рекомендует пытаться применить его на проектах, где уже есть тестовая инфраструктура и тесты, но советует вернуться к раннеру Node.js примерно через полгода, потому что он очень быстро развивается.
</ParagraphWithImage>

Немного о фреймворках. Дэн Абрамов был в гостях у Бэна Холмса, который расспрашивал его о [серверных компонентах React](https://www.youtube.com/watch?v=Fctw7WjmxpU). Получился четырёхчасовой стрим, во время которого Дэн рассказал о том, как команда фреймворка пришла к идее и почему это не возвращение к эпохе PHP, какие проблемы решают серверные компоненты и как они работают. Во время стрима это разбирается и на примерах реализованных в live-режиме демок, получилось доступно и интересно.

Команда Angular опубликовала RFC или ready-for-comment документ по [новой фиче Signals](https://github.com/angular/angular/discussions/49685). По сути это предложение о реализации реактивного примитива и прикручиванию к Angular реактивности «из коробки». Внедрение сигналов поможет улучшить производительность отслеживания изменений, лучше интегрировать код со сторонними реактивными библиотеками, проще управлять потоками данных внутри приложения. По крайней мере, идея такая. Если вас интересует этот вопрос, то сейчас самое время познакомиться с RFC и оставить свои комментарии.

Как вы помните, уже 2023 год, а значит, пора обновлять стандарт ECMAScript. Черновик уже заморожен, и известно, какие фичи попадут в [новый стандарт](https://pawelgrzybek.com/whats-new-in-ecmascript-2023/). У массивов появятся методы `toReversed()`, `toSorted()` и `toSpliced()` — это такие же методы, как `reverse()`, `sort()` и `splice()`, но они не мутируют исходный массив, а возвращают копию. Также появятся новые методы `findLastIndex()` и `findLast`. Символы можно будет использовать как ключи для `WeakMap()`, также будет унифицировано описание среды выполнения для JS-скриптов. Ощущение, что в этом году новенького поменьше, чем обычно. Больше подробностей — по ссылке в описании.

Джек Хэйлон (Jack Halon) дописал свою статью об исследовании браузерных уязвимостей. В первых двух частях он рассказывал о том, как работают JS и движок V8, делал обзор внутреннего устройства движка. [В третьей части](https://jhalon.github.io/chrome-browser-exploitation-3/) уже совсем практический пример: здесь эксплуатируется уязвимость JIT-компилятора внутри TurboFan вплоть до запуска своего кода при помощи V8. При всём желании в двух словах не объяснить, пример нужно разобрать самому, вдумчиво и детально. В описании выпуска вы найдёте и [перевод на Хабре](https://habr.com/ru/companies/bastion/articles/716640/).

Менеджмент зависимостей. Вроде бы все мы знаем, как устанавливать пакеты, какие есть менеджеры и так далее. Но как вообще развивались менеджеры зависимостей и подходы к управлению зависимостями? Именно об этом [статья Никиты Балихина на Хабре](https://habr.com/ru/companies/gazprombank/articles/725992/). Начиная с подключения скриптов в теге `<script>` и появления Bower Никита рассказывает, какие проблемы в области управления зависимостями решались и как. В этой же статье есть разделы по NPM, Yarn и, наверное, самом популярном сейчас pnpm. Получился хороший обзор, который улучшает понимание того, почему фронтенд такой сложный и что с этим можно сделать.

Кстати, о зависимостях. Если у вас есть своя библиотека или вы только начинаете её создавать, то вам точно пригодится [современный гайд по оформлению библиотек](https://github.com/frehner/modern-guide-to-packaging-js-library). Он охватывает в общем-то всё, что нужно знать для оформления. Например, какой формат стоит выбрать для модуля и почему, как написать для него типы, минифицировать, как правильно оформить `package.json`, стоит ли транспилировать и так далее. Обязательно возьмите на заметку.

Следующая статья — [обзор некоторых фич JavaScript и TypeScript](https://betterprogramming.pub/all-javascript-and-typescript-features-of-the-last-3-years-629c57e73e42), которые, возможно, могли пройти мимо вас по той или иной причине. Это обзор фич за последние три года от Линуса Шлюбмергера (Linus Schlumberger). Конечно, многие из них довольно известные, например про `Optional Chaining`, `Nullish Coalescing` и динамические импорты было слышно из каждого утюга. Тем не менее проведите ревизию своих знаний современных языковых фич и посмотрите — возможно, что-то пора начать использовать на постоянной основе. То же самое касается и раздела по TypeScript в этой же статье.

Если вы верстали или верстаете рассылки, то вы наверняка знаете о болях табличной вёрстки для отображения рассылок в разных почтовых клиентах. [Как дела обстоят сейчас](https://fullystacked.net/posts/modern-html-email/)? На этот вопрос в своём блоге старается ответить Олли Уильямс (Ollie Williams). Если коротко, то почтовые клиенты сейчас проходят примерно тот же путь, что и браузеры, постепенно расширяя поддержку разных фич. Примечательно то, что теперь за рендер в Outlook будет отвечать новый Explorer на Chromium, что немного упрощает жизнь. Автор говорит о том, что рассылки можно делать на `<div>`-ах, рассказывает про некоторые поддерживаемые свойства и как жить с AMP. Ещё он напоминает о Litmus и ресурсе «[Can I Email](https://www.caniemail.com/clients/)» для почтовых клиентов — аналоге «Can I Use» для браузеров. 

Далее продолжение статьи об использовании гугл-таблицы как БД для телеграм-бота. Надежда Ситдикова на Хабре опубликовала [вторую](https://habr.com/ru/articles/725420/) и [третью](https://habr.com/ru/articles/727248/) части статьи, о которой я говорил в прошлом выпуске. В следующих частях она продолжает добавлять боту функциональность: передаёт данные между ботом и таблицей, формирует кнопки с надписями из таблицы. Кроме того, в статье есть ответы на вопросы из комментариев по поводу деталей работы бота и обмена данными бота с таблицей. Так что, если вы начали интересоваться телеграм-ботами, обязательно загляните.

Следующий материал — перевод статьи команды библиотеки AnyCharts на Хабре. В статье при помощи AnyCharts создаются диаграммы на карте мира. Например, это могут быть линии перемещения или какие-то связи. Это [практический пример](https://habr.com/ru/company/ruvds/blog/724454/), в котором демонстрируются возможности библиотеки. Если у вас есть похожие задачи, то можно посмотреть.

В конце рубрики ещё пара материалов. [Первый](https://react.gg/visualized) — визуализированный гайд по React. А [второй](https://technically.dev/database-database) — база баз данных: в таблице известные базы, разбитые на категории по разным признакам. Полезная табличка.

<ParagraphWithImage imageName="manWithLaptop">
  ### Новости релизов

Доступен [Chrome 112](https://developer.chrome.com/blog/new-in-chrome-112/). Основное нововведение — это nesting или вложенность CSS-правил. Понятно, что какое-то время мы ещё будем пользоваться SCSS и другими инструментами, но круто, что нестинг теперь нативный. Кроме того, сменили алгоритм фокуса для тега `<dialog>`. [DevTools](https://developer.chrome.com/blog/new-in-devtools-112/) теперь, соответственно, обновили для работы с нестингом, а ещё научили показывать подсказки из CSS-документации на MDN. Кроме того, DevTools теперь работает с 10-ой версией Lighthouse. Больше подробностей — в официальных обзорах новых Chrome и DevTools от Google.
</ParagraphWithImage>

Вышел и [Firefox 112](https://www.mozilla.org/en-US/firefox/112.0/releasenotes/). В этом релизе атрибут `inert` получил полную поддержку, в CSS были добавлены некоторые математические функции, теперь поддерживается значение `overflow: overlay`, а также метод `navigator.getAutoplayPolicy()`. Кроме того, появились методы для рендера прямоугольников со скругленными углами в `canvas`. В DevTools был добавлен вывод дополнительных сведений о соединениях. Как и всегда, был устранен ряд багов и уязвимостей.

Вышла [20-ая мажорная версия Node.js](https://nodejs.org/en/blog/announcements/v20-release-announce). Эта версия пока получит статус Current, а через полгода перейдет в категорию LTS. В этом релизе тест-раннер был помечен как стабильный, приближаются к стабилизации кастомные хуки загрузчика ES-модулей. В этом выпуске была добавлена экспериментальная модель разрешений, которая позволяет ограничивать доступ к определенным ресурсам в процессе выполнения программ. Например, к воркер тредам, процессам или чтению/записи файлов. Получили обновление и другие поддерживаемые ветки: вышли версии [19.9.0](https://nodejs.org/en/blog/release/v19.9.0), [18.16.0](https://nodejs.org/en/blog/release/v18.16.0) и [16.20.0](https://nodejs.org/en/blog/release/v16.20.0).

Давненько не было ничего про PHP-фреймворки, я надеюсь в ближайшее время исправиться в этом плане. А сегодня о релизе [десятой мажорной версии Laravel](https://laravel-news.com/laravel-10). Десятая версия научилась запускать внешние процессы, можно даже несколько одновременно. Появился новый пакет Pennant, который позволяет условно выполнять те или иные функции, что может быть полезно для A/B-тестов и в других ситуациях. Тест-раннер получил возможность профилирования тестов, чего, честно говоря, частенько не хватало. Отмечу, что для работы с 10-ой версией Laravel нужно обновиться до PHP 8.1 или 8.2, 8.0 уже не поддерживается. Больше подробностей — на странице релиза или [на русском языке](https://ru.hexlet.io/blog/posts/vyshel-laravel-10-glavnye-izmeneniya) в обзоре релиза от Хекслета.

Вышла [седьмая версия Storybook](https://storybook.js.org/blog/storybook-7-0/). В этом обновлении Vite получил поддержку первого класса, а Next.js и SvelteKit теперь могут использовать Storybook без особой настройки. Был освежен интерфейс. Изменений было анонсировано довольно много, больше подробностей — на странице релиза.

[Vite 4.3](https://vitejs.dev/blog/announcing-vite4-3.html) принёс нам огромное количество багфиксов. Недавно я даже видел твит счастливого разраба, который обновился, и ушло порядка 10 назойливых проблем. Также в этом релизе продолжили работать над производительностью.

[Rome 12](https://rome.tools/blog/2023/03/28/rome12/) начал поддерживать TypeScript 4.7 и 5.0. Кроме того, была добавлена поддержка JSON-файлов. Было анонсировано также много небольших улучшений конфигурации.

Ещё в этом выпуске я скажу [о первом релизе WebStorm в этом году](https://www.jetbrains.com/webstorm/whatsnew/). Теперь поддерживается TypeScript во Vue-шаблонах. Была добавлена поддержка фреймворка Astro. Анонсировали и другие улучшения для TypeScript с поддержкой пятой версии, а также улучшения интерфейса. Больше подробностей — на странице релиза.

Вышла [седьмая версия фреймворка Ionic](https://ionic.io/blog/ionic-7-is-here). В новой версии был упрощен синтаксис некоторых управляющих элементов форм, была прокачана производительность и поддержка Vite.

Также отмечу релизы [Electron 24.0.0](https://www.electronjs.org/blog/electron-24-0), [Cypress 12.10.0](https://docs.cypress.io/guides/references/changelog#12-10-0), [Puppeteer 19.9.0](https://github.com/puppeteer/puppeteer/releases/tag/puppeteer-core-v19.9.0), [pnpm 8.2.0](https://github.com/pnpm/pnpm/releases/tag/v8.2.0) и [ESLint 8.38.0](https://eslint.org/blog/2023/04/eslint-v8.38.0-released/).

<ParagraphWithImage imageName="laptopNews" >
    ### Другие новости

Для начала [исследование руководителей разработки 2023 года](https://devcrowd.ru/tl23/). Команда Dev Crowd провела опрос среди 570 руководителей разработки из разных компаний. По результатам был сформирован портрет руководителя разработки, раскрыты основные обязанности, как оценивается работа руководителей и многое другое. Результаты получились очень интересными, рекомендую ознакомиться. Помимо этого есть разделы о сообществе, топ ресурсов, которые используют руководители для прокачки, и другие полезные материалы.
</ParagraphWithImage>

И парочка новостей от GitHub. Не успел взлететь Copilot, как запустилось [техническое превью Copilot X](https://github.com/features/preview/copilot-x). Обещают абсолютные чудеса: кодинг голосом, чат с ИИ, в котором можно посоветоваться вплоть до разбора кода, генерация PR и другие плюшки, связанные с искусственным интеллектом. Звучит как Джарвис Тони Старка, вы не находите? Посмотрим, пока попробовать не получится, но можно записаться в список ожидания.

Акселератор GitHub [выбрал первую партию проектов](https://github.blog/2023-04-12-github-accelerator-our-first-cohort-and-whats-next/), которые финансово поддержит. Это 20 open-source проектов, которые были отобраны из примерно тысячи претендентов. Они получат по 20 тысяч долларов, которые по идее рассчитаны на финансирование 10 недель разработки. Интересно, что в список попал и фреймворк Nuxt.js. Через 10 недель планируется оценить результаты и определить, что делать дальше. Полный список вы найдёте по ссылке в описании выпуска.

  ### Пишите нам и читайте
  [Telegram—канал CSSSR](https://t.me/csssr)

  [Twitter CSSSR](https://twitter.com/csssr_dev)

  [Twitter новостей](https://twitter.com/csssr_news)

  [Telegram ведущего](https://t.me/Vindizh)

  [Twitter ведущего](https://twitter.com/Vindizh)
