---
title: 'В этом выпуске: Chrome 111, Firefox 111 и релиз TypeScript 5.0. Мы пройдёмся по публикациям: посмотрим на статьи о микрофронтендах, устроим минутку CSS, поразбираемся в мемоизации и трёхмерной графике, подружим телеграм-бота с гугл-таблицей и посмотрим на блиц-подборку других интересных материалов.'
soundcloudLink: 'https://soundcloud.com/csssr/chrome-111-firefox-111-typescript-50-mikrofrontendy-memoizatsiya-local-first-bagkhanting'
date: '2023-03-30T00:00:00.000Z'
episodeNumber: 231
tag: 'news'
author: 'Ислам Виндижев'
---

Всем привет, это «Новости 512» от CSSSR. Это расширенный выпуск новостей, который я обещал вам перед отпуском. Он получился довольно большим, но я постарался сделать его покороче. В этом выпуске мы поговорим про Chrome 111, Firefox 111 и релиз TypeScript 5.0. Пройдёмся и по публикациям: посмотрим на статьи о микрофронтендах, устроим минутку CSS, поразбираемся в мемоизации и трёхмерной графике, подружим телеграм-бота с гугл-таблицей и посмотрим на блиц-подборку других интересных материалов.

Прежде чем мы начнём: в предыдущем выпуске есть довольно грубая фактическая ошибка. Архитектурный подход Feature Layered Design на самом деле называется не так. Верное название — Feature-Sliced Design, прошу прощения за эту неточность. И спасибо большое Владу Камотину, который обратил моё внимание на эту ошибку.

<ParagraphWithImage imageName="laptopNews" >
  ### Интересные публикации

Первые три статьи в этом выпуске будут так или иначе посвящены микрофронтендам, преимущественно речь пойдёт о Module Federation или федерации модулей. 

В [первой статье](https://habr.com/ru/post/721762/) рассматривается понятие микрофронтендов и то, какую проблему они решают. Статья скорее для тех, кто начинает разбираться в этом вопросе. Здесь есть и обзор некоторых технологий для реализации такой архитектуры, в итоге автор подробнее останавливается на федерации модулей и случаях, когда стоит её применять.
</ParagraphWithImage>

[Вторая статья](https://habr.com/ru/post/720560/) — более продвинутого уровня: в ней больше практики и больше акцента на проблемах Module Federation. Здесь рассматриваются такие проблемы, как общие зависимости, коллизии хешей чанков и само разбиение на чанки. Есть пример локального и продового конфигов, немного про выбор архитектуры.

[Третий материал](https://habr.com/ru/company/ncloudtech/blog/722396/) — про кейс поэтапного перехода и внедрения микрофронтендов в монолитное приложение на гугловском нейрополимере — в смысле просто Polymer, извините. Статья о клиентской части почтового сервиса Mailion, и это скорее только начало цикла. Автор говорит о том, что в итоге было решено использовать Module Federation и монорепозиторий. Будем ждать продолжение цикла, а бонусом внутри можно посмотреть на устройство клиентской части Mailion.

Современные приложения очень сильно зависят от интернет-соединения. Существует не новый, но, кажется, подзабытый подход `local-first`. Это приложение, в котором пользователь может работать при плохом или какое-то время отсутствующем соединении. Звучит прекрасно, но это дело тонкое. Для реализации подхода нужно правильно работать с данными, синхронизировать их и разрешать конфликты. Об этих аспектах и рассказывает в блоге «Злых Марсиан» Павел Гринченко. В [статье](https://evilmartians.com/chronicles/cool-front-end-arts-of-local-first-storage-sync-and-conflicts) вы найдёте разбор этих нюансов, примеры с библиотеками для реализации local-first подхода (RxDB, Replicache и WatermelonDB) и ссылки на дополнительное чтиво по теме.

Как вы могли слышать, один из лучших способов разобраться в чём-то — сделать это своими руками. Вот и Эдгар Абгарян на Хабре предлагает [разобраться в мемоизации](https://habr.com/ru/post/720594/). Получился пошаговый гайд с постепенным усложнением механизма мемоизации. Разбирается много разных нюансов, например стратегии сравнения аргументов, инвалидация кэша, ограничение потребляемой памяти и другие. Будьте готовы потратить часик времени — получилось хорошо, и стоит повозиться, если хочется разобраться раз и навсегда.

Мы верстали, мы верстали — наши пальчики устали. Специально для уставших — статья о [применении Three.js на веб-страницах](https://habr.com/ru/company/simbirsoft/blog/721912/). Если не знаете, это библиотека для работы с 3D-графикой, у которой под капотом WebGL. В статье — пример реализации изображений с 3D-эффектами и синхронизацией при прокрутке. Сразу скажу, статья не для совсем начинающих — перед прочтением и практикой лучше ознакомиться с основами на сайте библиотеки. Кстати, загляните на [страничку с примерами](https://threejs.org/) — очень вдохновляет.

Следующая статья как бы продолжает рубрику «очумелые ручки». В этой статье автор [рисует на JavaScript верёвку в формате SVG](https://habr.com/ru/company/nmg/blog/719822/) вдоль произвольного контура. В чём суть: берётся кривая, которая делится скриптом на прямоугольные сегменты; они постепенно искривляются до формы волокон верёвки — и вуаля! Хороший вопрос, насколько вы захотите заниматься этим в реальном проекте, но ценно не это — ценен подход автора к решению задачи, создание самого процесса, который сначала был описан буквально на бумаге. Внутри, конечно, есть и работающий пример. Очень рекомендую.

Теперь минутка CSS. Джош Колинсворт (Josh Collinsworth) поделился своим опытом работы с CSS-анимациями. [Советы](https://joshcollinsworth.com/blog/great-transitions) интересны тем, что они находятся на стыке UX и CSS. Например, Джош рассказывает, как выбрать длительность анимации для определённого действия, почему не стоит использовать дефолтные анимации, как стоит ускорять и замедлять анимации и так далее. Мне понравилось, как минимум наводит на какие-то мысли.

Мадс Стоуманн (Mads Stoumann) на CSS Tricks опубликовал статью о том, как при помощи новых тригонометрических функций CSS [создать часы](https://css-tricks.com/creating-a-clock-with-the-new-css-sin-and-cos-trigonometry-functions/). Всё по классике: поэтапная реализация примера, разбор незамысловатой математики, размышления автора.

Теперь поговорим о пончиках. А точнее, [круговых диаграммах](https://www.smashingmagazine.com/2023/03/dynamic-donut-charts-tailwind-css-react/). Пол Скэнлон (Paul Scanlon) в SmashingMagazine предложил легковесную реализацию диаграмм-пончиков при помощи конических градиентов. Конечно, это не какая-то инновация, но хороший пример, который можно просмотреть и поковырять.

Джулс Блом (Jules Blom) в своём блоге опубликовал заметку [о реакт-хуке useSyncExternalStore](https://julesblom.com/writing/usesyncexternalstore). Этот хук позиционировался как хук для библиотек, но это не единственное его применение. Автор показывает, как через этот хук работать с подписками на внешнее состояние, и рассказывает о нюансах его работы.

Есть много неоднозначных выборов: Nikon или Canon, Visa или MasterCard, квас или кефир. Но мы попробуем ответить на вопрос «[Playwright или Puppeteer](https://habr.com/ru/company/otus/blog/721740/)». Эта статья — небольшое сравнение этих двух «безголовых» браузеров. Давайте сразу спойлерну: Puppeteer — быстрый, но работает только с Chromium, а Playwright работает с Chromium, Firefox и Webkit, но чуть медленнее. Так что если вам нужно тестировать что-то кроссбраузерно, то ваш выбор — скорее Playwright. Больше подробностей их сравнения — по ссылке в описании.

Сейчас будет интересное [комбо телеграм-бота и гугл-таблицы](https://habr.com/ru/post/722952/). Надежда Ситдикова на Хабре опубликовала статью о том, как использовать таблицы в качестве базы данных. В примере телеграм-бот получает вопросы для квиза из таблицы. Это неплохой пример того, как можно подружить разные сервисы. Если у вас нет такого опыта — попробуйте. Кстати, область интересов авторки — телеграм-боты и их интеграция с другими сервисами (пока Google). Есть и другие статьи, приобщайтесь.

Следующие материалы пойдут в формате блица. Причин две: во-первых, выпуск большой, во-вторых, их сложно описать подробно в формате эпизода, короткое описание мне показалось более подходящим.

Сначала видео о том, [как работает компилятор TypeScript](https://www.youtube.com/watch?v=X8k_4tZ16qU). Здесь разбор синтаксических деревьев, графов, трансформеров и других страшных слов.

В блоге PTSecurity интересный материал о том, как начать заниматься багхантингом в браузерах. В [первой части](https://habr.com/ru/company/pt/blog/690716/) больше информации для начинающих, а [вторая](https://habr.com/ru/company/pt/blog/721978/) уже с практикой и примерами поиска уязвимостей.

Следующий материал тоже о безопасности. На этот раз речь о [социальной инженерии и эксплойте PDF-файлов](https://habr.com/ru/company/ussc/blog/723032/). В статье разбирается структура PDF и способ внедрения в файл JS-скрипта.

Теперь не про хакинг. Всегда мечтали разработать Chrome-расширение и побыстрее? Прекрасно, в этой статье разбирается [создание плагина-поисковика по MDN](https://habr.com/ru/company/timeweb/blog/720646/) с применением фреймворка Plasmo.

В конце рубрики немного вдохновения.

Первый материал — [подборка вдохновляющих примеров веб-дизайна и UX](https://www.smashingmagazine.com/2023/03/inspiring-web-design-ux-showcases/) от Косьмы Милке (Cosima Mielke).

Второй — серия статей о [создании мини-стартапа в соло](https://habr.com/ru/post/720456/). Ростислав Дугин, автор серии, описывает свой опыт в четырёх частях на Хабре. Цикл продолжается.

<ParagraphWithImage imageName="manWithLaptop">
  ### Новости релизов

Вышел Chrome 111. В новой версии появился View Transitions API, который упрощает создание плавных переходов с изменением DOM без дублирования состояний. Была добавлена реализация спецификации CSS color четвёртого уровня: это функция color() и новые цветовые пространства. В итоге цветов для веба стало на 50% больше. Также были добавлены тригонометрические функции CSS.
</ParagraphWithImage>

DevTools, конечно, тоже получил обновление. Появились соответствующие инструменты для работы с новыми цветовыми пространствами и фичами, в итоге это поддержка новых 12 цветовых пространств. Помимо этого был проработан UX брейкпоинтов в дебаггере и улучшена подсветка синтаксиса для Angular. Больше подробностей — в официальных обзорах [Chrome](https://developer.chrome.com/blog/new-in-chrome-111/) и [DevTools](https://developer.chrome.com/blog/new-in-devtools-111/) от Google.

[Firefox](https://www.mozilla.org/en-US/firefox/111.0/releasenotes/) с таким же номером 111 тоже увидел свет. Здесь мы тоже можем увидеть реализацию CSS color четвёртого уровня и поддержку новых цветовых пространств с соответствующими инструментами в DevTools. Тег `<form>` теперь поддерживает атрибут `rel`. Помимо этого было устранено порядка 20 уязвимостей.

Вышел [TypeScript 5.0](https://devblogs.microsoft.com/typescript/announcing-typescript-5-0/). Как и ожидалось, декораторы получили поддержку первого класса, появилась поддержка `export type *`, `enums` теперь работают как объединения или `unions`. Помимо этого команда отмечает упрощение конфигурации, улучшение поддержки ES-модулей, расширение функциональности для JSDoc. Также поработали над производительностью и размером бандла.

Доступна новая версия платформы [Java 20 SE](https://mail.openjdk.org/pipermail/jdk-dev/2023-March/007517.html). В этом релизе — фичи разной степени экспериментальности, например виртуальные потоки, API для векторных вычилсений, использование гибких шаблонов в `switch … case`, Scoped Values и другие. Больше подробностей — в release notes.

cURL или по-свойски [курлу исполнилось 25 лет](https://daniel.haxx.se/blog/2023/03/20/twenty-five-years-of-curl/). По этому поводу вышла его восьмая мажорная версия, ровно в его день рождения — 20го марта. Особых изменений не было, это был своеобразный способ отметить дату и избавиться от большого номера минорных версий.

Также отмечу релизы [njs 0.7.11](http://nginx.org/en/docs/njs/changes.html#njs0.7.11) и [Ubuntu 20.04.6 LTS](https://lists.ubuntu.com/archives/ubuntu-announce/2023-March/000287.html).

<ParagraphWithImage imageName="laptopNews" >
    ### Другие новости

Многие скажут, что трендом этого года стал искусственный интеллект. Только ленивый не сгенерировал себе аватарку через Midjourney и не поболтал о смысле жизни с ChatGPT. Не исключение и Mozilla. Компания [объявила](https://blog.mozilla.org/en/mozilla/introducing-mozilla-ai-investing-in-trustworthy-ai/) о том, что организует стартап по разработке открытых, независимых и заслуживающих доверия сервисов на основе технологий искусственного интеллекта. Пока о конкретных проектах не сообщается, а компания обещает сфокусироваться на прозрачности и безопасности генеративных ИИ, а также действительно полезных и достоверных рекомендательных системах. Стартовые инвестиции составят 30 миллионов долларов.
</ParagraphWithImage>

Docker объявила о [сворачивании программы «Free Team»](https://news.ycombinator.com/item?id=35166317). Напомню, это тариф для open-source проектов. Возникли опасения, что образы начнут удалять и это навредит инфраструктуре, зависящей от образов разработчиков на этом тарифе. Компания заверила всех, что образы не будут принудительно удаляться без участия владельца, а также предложили перевод на платный тариф или другую программу для open-source проектов. У всех пользователей этого тарифа есть время до 14-го апреля — после этого доступ к платным фичам таких аккаунтов будет приостановлен.

В конце эпизода хочу обратить ваше внимание на [новый сайт React](https://react.dev/), который, собственно, демонстрирует всю мощь React. Всё быстро, лаконично, а разделы про изучение фреймфорка и документация были освежены.

На сегодня это всё, все ссылки в тексте выпуска. Текст выпуска написал я сам — живой человек, а не ChatGPT, честное слово.

  ### Пишите нам и читайте
  [Telegram—канал CSSSR](https://t.me/csssr)

  [Twitter CSSSR](https://twitter.com/csssr_dev)

  [Twitter новостей](https://twitter.com/csssr_news)

  [Telegram ведущего](https://t.me/Vindizh)

  [Twitter ведущего](https://twitter.com/Vindizh)
