---
title: 'В этом выпуске мы поговорим о вышедших версиях TypeScript, новых фреймворках и инструментах, и посмотрим на несколько интересных статей.'
soundcloudLink: 'https://soundcloud.com/csssr/typescript-46-i-47-vite-3-bun-fresh-i-ultra-mnogopotochnost-v-nodejs-deno-123-i-124'
date: '2022-07-29T00:00:00.000Z'
episodeNumber: 211
tag: 'news'
author: 'Ислам Виндижев'
---

Всем привет! Это «Новости 512» от CSSSR. В новом выпуске мы вернёмся к насущным новостям, но я всё равно я закончу отдавать вам долги материалом про TS 4.6 и 4.7: там вас будет ждать небольшой сюрприз, но я не буду спойлерить. Потом мы поговорим про несколько новых штук, интересные публикации и другие релизы. Выпуск начнётся с рубрики «Интересные публикации».

<ParagraphWithImage imageName="laptopNews" >
  ### Интересные публикации

Как вы думаете, нужен ли был нам ещё один JavaScript-рантайм? Я не знаю, но тем не менее он есть. Его назвали [Bun](https://bun.sh/) (в переводе — “булочка”). В нём есть бандлер, транспилятор, таск-раннер и NPM-клиент. Что ещё о нём сказать? Он поддерживает TypeScript и JSX из коробки, содержит реализацию модулей из ядра Node.js для совместимости и позиционируется как высокоскоростная история. Написан инструмент на [языке Zig](https://ziglang.org/), что, по словам авторов, и позволило добиться околосветовых скоростей работы рантайма. Хм, Zig, только у меня в голове заиграла песня из Shaman King? На сам язык, кстати, я тоже приложу ссылку — кому-то это может показаться очень интересным. Надеюсь вы простите меня за небольшую иронию, когда я говорю о скорости: просто каждый первый инструмент обвешивается бенчмарками и утверждает, что невероятно быстр.
</ParagraphWithImage>

Быстр ли Bun и как он соотносится с Node.js? [Ответ на этот вопрос](https://techsparx.com/nodejs/bun/speed-test.html) попытался найти Дэвид Херрон (David Herron). В своей статье он даёт небольшую вводную и делает сравнение рантаймов, затем он пытается проверить Bun на чём-то посерьёзнее, чем «Hello, World!» и проверяет производительность на AkashaCMS. Помимо этого он исследует совместимость Node.js и Bun, которая заявлена из коробки. Так вот, результаты закономерные и не то чтобы очень удивляют: Bun быстр в зависимости от конкретной задачи, а совместимость с Node.js пока далеко не идеальная. Интересно, но Bun вышел меньше месяца назад, а его уже называют убийцей Node.js и Deno. Open-source маркетинг в действии, и лично у меня ощущение, что мне что-то впаривают. Ссылку на статью Дэвида вы найдёте в описании выпуска, а сам Bun и правда может оказаться полезным, хотя лично меня больше заинтересовал язык, на котором он написан.

В блоге Deno появился пост о том, что вышел новый full-stack фреймворк для Deno. Фреймворк называется [Fresh](https://deno.com/blog/fresh-is-stable), и вышла его первая стабильная версия. Естественно, он очень быстрый (это снова минутка иронии), но здесь это может быть и правда… правдой. Fresh обещает zero-JavaScript на клиенте. Каким же таким чудесным образом? Решение о серверном или клиентском рендере принимает разработчик на уровне компонента: предполагается, что большая часть приложения будет рендериться на сервере. Модель, которая лежит в основе, называется Island Architecture — не невероятно сложная идея, я приложу к выпуску ссылку об этом. Кроме того, сами страницы будут собираться на манер just-in-time компиляции по запросу, то же самое происходит с транспиляциями, компиляциями TS и так далее. Это позволяет фреймворку не иметь этапа сборки и, соответственно, ускорить деплои. Ну и, забыл упомянуть, это по сути React-фреймворк, который использует Preact и JSX/TSX, так что начать довольно просто.

Звучит слишком хорошо, чтобы быть правдой, но если вам интересно, загляните на YouTube по приложенной ссылке. Там Джек Херрингтон (Jack Herrington) делает [небольшое интро](https://www.youtube.com/watch?v=Q4dos7-gX68&ab_channel=JackHerrington) в фреймворк и реализует приложение с карточками покемонов, небольшим API и запросом данных с сервера. Он касается и основных фич фреймворка, и того самого принципа островов, и того самого молниеносного деплоя. Всё это в 45 минутах, так что полюбопытствуйте и попробуйте сами.

Ну хорошо, Deno и React, этот невероятный союз, созданный на небесах, наверняка породит ещё немало фреймворков. Речь пойдёт о следующем таком, который называется [Ultra.js](https://ultrajs.dev/). Этот фреймворк фокусируется на нативных веб-фичах, ES-модулях, Import Maps и Web Streams. Кроме того, потоковый серверный рендеринг — это визитная карточка фреймворка, а первоочередная целевая платформа для деплоя — Deno Deploy. Плюс ко всему фреймворк позиционируется как фреймворк без шага билда. У ребят есть и свой шаблон create-ultra-app. Чувствуете игру слов? Только создал приложение, а оно уже ультра. Вы опять могли заметить иронию: это потому, что я немного скептично настроен, и, как уже говорил, думаю, что таких фрейворков мы увидим ещё много. Но я ни в коем случае не критикую фреймворк раньше времени, а вы можете попробовать.

Материалы про разные фреймворки завершит [статья-сравнение двух full-stack фреймворков Redwood.js и Blitz](https://blog.risingstack.com/redwoodjs-vs-blitzjs-comparison/). В статье вы найдёте небольшой рассказ о каждом фреймворке, сравнительный анализ фич и выводы по каждому из них. Для ленивых в начале статьи есть TL;DR в виде удобной и компактной таблички, но советую прочитать статью целиком.

Райан Питерсон (Ryan J. Peterson) рассказал о [десяти типичных ошибках при написании кода на JavaScript](https://www.toptal.com/javascript/10-most-common-javascript-mistakes). Он актуализировал свою старую статью для 2022 года и затронул такие моменты, как ссылки на this, утечки памяти, манипуляции DOM, работу с проектным наследованием и другие. Если вам кажется, что вы уже профи и гуру, всё равно загляните — лишним не будет.

Следующий материал посвящён [введению в многопоточность в Node.js](https://blog.appsignal.com/2022/07/20/an-introduction-to-multithreading-in-nodejs.html). Многопоточность — это способность процесса работать в несколько потоков, которые будут выполнять разные задачи в конкурентном режиме. В статье вы найдете краткую справку о том, как это работает в Node.js, как работать с дочерними процессами и что такое Worker Threads. Статья совсем базовая: если вы никогда не сталкивались с многопоточностью — обязательно загляните.

Следующий материал от команды всем вам известного логгера Sentry. Абиджет Прасад (Abhejeet Prasad) в блоге Sentry поделился [кейсом оптимизации](https://blog.sentry.io/2022/07/19/javascript-sdk-package-reduced) JavaScript SDK Sentry. Он рассказал о том, что взяли за критерии успеха, как добавили tree shaking для фич логгера, поработали над абстракциями, что в итоге привело к уменьшению размера на 29%.

На dev.to Джейкоб Смит (Jacob Smith) опубликовал [статью о кастомных загрузчиках ES-модулей в Node.js](https://dev.to/jakobjingleheimer/custom-esm-loaders-who-what-when-where-why-how-4i1o). Загрузчики или лоадеры сами по себе обрабатывают файлы или данные тем или иным способом. Кастомные лоадеры — это экспериментальная фича, которая позволяет определить лоадер самостоятельно. Джейкоб показывает несколько случаев, в которых фича может быть полезна, например работа с TS или CSS.

<ParagraphWithImage imageName="manWithLaptop">
  ### Новости релизов

Как я уже говорил, в этот раз рубрика начнётся с небольшого сюрприза. Я обещал рассказать про TypeScript 4.6 и TypeScript 4.7 — это получилось только отчасти. Впервые в подкасте — приглашённый гость, который вам о них и расскажет. Любезно согласился сделать небольшой обзор Андрей Старовойт, тимлид продукта WebStorm.
</ParagraphWithImage>

__Андрей Старовойт__: «Всем привет, это Старовойт Андрей, и я расскажу вам, что нового появилось в TypeScript 4.6 и TypeScript 4.7. Начнём с [TypeScript 4.6](https://devblogs.microsoft.com/typescript/announcing-typescript-4-6/).
На мой взгляд, самое интересное в этой версии — это улучшенный control flow analysis для дестракторинг переменных. Теперь компилятор тайпскрипта умеет связывать задистракченные переменные из одного объекта и понимает, что если одна из переменных может быть использована как дискриминатор для discriminated union types, то тип второй переменной должен быть сужен в соответствии с типом этого дискриминатора. Это не совсем фича, а скорее улучшение существующего анализа кода. Меня довольно сильно раздражало, когда в одном стиле написания кода компилятор может правильно вывести типы, а при другом стиле написания кода с использованием дистракторинга ничего не компилируется. Сейчас для этого случая поведение выровнено, и можно использовать дистракторинг, не опасаясь, что что-то сломается.
Следующий пункт в моём списке — это возможность делать вычисления в конструкторе класса перед вызовом super(). Вообще довольно часто при написании возникает ситуация, когда нужно что-то вычислить и передать результаты вычислений в вызов super(). Раньше для этого приходилось как-то изворачиваться, например писать функции-хелперы. Теперь это можно делать прямо в конструкторе, что довольно удобно. Ещё в TypeScript 4.6 появился новый таргет для компиляции ES2022. Это понятное изменение: каждый год команда TypeScript добавляет новый таргет согласно новой версии спецификации JavaScript.
Последняя вещь, которую я хотел упомянуть здесь, — это trace analizer, который был зарелизен одновременно с TypeScript 4.6, и это тул, который позволяет анализировать  вывод типов в TypeScript. Так что если у вас что-то тормозит при сборке проекта, вы можете понять, какое именно место в коде компилируется медленно, и, допустим, переписать его или зарепортить проблему команде TS.

Окей, с TS 4.6 мы закончили, переходим к [TypeScript 4.7](https://devblogs.microsoft.com/typescript/announcing-typescript-4-7/).
В 4.7 так много улучшений, что его можно было назвать 5.0, но давайте пройдемся по самым интересным, ключевым. На мой взгляд, самое важное — это поддержка ES-модулей из Node.js. Сами ES-модули появились в Node.js довольно давно (насколько я помню, несколько лет назад) в Node 12 или Node 14. С тех пор команду TypeScript просили поддержать их в языке. Команда TS попыталась зарелизить эту фичу в версии 4.5, но что-то пошло не так, и до 4.7 поддержка была доступна только в nightly-билдах. В рамках этих изменений в TS была добавлена новая опция module resolution node 16 и node next. Кроме того, теперь можно использовать новые расширения .mts и .cts, которые компилируются соответственно в .mjs и .cjs. Была также добавлена поддержка exports и imports в package.json. Exports позволяет вам заредиректить импорт пакета на какую-то конкретную директорию или конкретный набор файлов внутри этого пакета. Поэтому, если у вас исходники компилируются в dist-директорию, вы можете просто на уровне exports сказать, что обращения к пакету будут идти напрямую в dist, а не в корень этого пакета. Очень удобно, позволяет распространять пакет просто как есть. Теперь TypeScript понимает exports и imports свойства и умеет искать соответствующие dts-файлы рядом с исходными js-файлами, и, кроме того, есть дополнительная опция types, которую можно добавить в exports, если вы хотите каким-то специальным образом заредиректить тайпинги в вашем пакете. В TypeScript 4.7 появилось несколько новых языковых конструкций. Первая — это так называемый Instantiation Expressions. Если вы хотите сузить generic-функцию на какой-то определённый тип, то вам не нужно объявлять и прописывать полный тип этой функции у переменной — достаточно просто присвоить в переменную нужную функцию с явным указанием типа аргумента, который вы теперь ожидаете. Вторая новая языковая конструкция — это extense для infer-параметров. Теперь для infer-параметров можно явно прописывать ограничения. Раньше добиться этого поведения можно было, написав двухэтажный conditional-тип, но новая конструкция гораздо удобнее и позволяет немного облегчить жизнь писателям тайпингов. Кроме того, эта фича, на мой взгляд, значительно повышает читаемость. Ещё в 4.7 добавили новый параметр module-suffix для tsconfig, который позволяет указать некоторый набор суффиксов, который будет понимать компилятор TypeScript. Понятно, что основной сценарий использования — это React Native с суффиксами .android и .ios. Теперь можно заставить компилятор TypeScript понимать импорты таких файлов —  раньше этого поведения можно было добиться с помощью past mappings, но суффиксы — это явно гораздо простая концепция. Последняя фича, про которую я хотел бы поговорить, — это возможность указывать вариантность generic-параметров у классов, интерфейсов и типовых алиасов с помощью ключевых слов in/out.

Поскольку концепция вариантностей довольно сложна, я представляю вам вариантность на котиках. Допустим, у нас есть 3 множества: множество животных, множество млекопитающих и множество котиков. Понятно, что множество котиков вкладывается в множество млекопитающих, а множество млекопитающих вкладывается в множество животных. И пусть у нас есть функция, которая принимает на вход массив млекопитающих. Что мы можем с этим массивом внутри функции сделать? Первое, что приходит в голову, — это пройтись по всем элементам массива и вызвать у каждого элемента какой-то общий метод. Допустим, метод Саунд. Наблюдение номер один: в эту функцию можно передать массив котиков. Потому что, ну, котики — это более частный случай, чем млекопитающие, и кажется, что в целом у котиков должен быть метод sound(). Наблюдение номер два: в эту функцию нельзя передать массив животных, потому что не у каждого животного может быть этот метод sound(). В этом случае говорят о ковариантности. Из того, что котики – это подмножество млекопитающих, следует, что массив котиков – это подмножество массива млекопитающих. Что ещё мы можем сделать с нашим массивом внутри функции? Ну мы можем взять и положить в него собачку. Наблюдение номер один: в этом случае массив котиков передать в функцию нельзя, потому что будет странно, если мы возьмём массив котиков и положим туда собачку. Наблюдение номер два: а вот массив животных в эту функцию можно передавать смело, потому что нам в целом без разницы – мы возьмём массив млекопитающих и положим туда собачку, или возьмём массив более общих вещей (животных) и положим туда собачку. Это операция примерно одного уровня. В этом случае говорят о контрвариантности. Из того, что млекопитающие – это подмножество животных, следует, что массив животных – это подмножество массива млекопитающих. Ну и третий случай – это когда мы внутри нашей функции делаем и первое, и второе, то есть проходим по всем элементам, вызываем метод sound() и кладём в этот массив собачку. Понятно, что такая функция на вход может принимать только массив млекопитающих. И здесь говорят об инвариантности.
Возвращаясь к TypeScript, теперь для дженерик параметров классов, интерфейсов и типовых алиасов можно указывать, как этот параметр ведёт себя ковариантно с помощью out, контрвариантно с помощью in либо инвариантно с помощью in/out. На этой ноте я хочу закончить свой обзор. Всем спасибо.»

Андрей, спасибо большое. А вы, дорогие слушатели, дайте мне знать, понравился ли вам этот небольшой эксперимент или нет. И поехали дальше.

Один из крупных релизов недавнего времени — это релиз [Vite 3](https://vitejs.dev/blog/announcing-vite3.html). В новой версии изменились дефолтные порты, была обновлена документация, холодный старт был оптимизирован, а ES-модули стали дефолтным форматом для SSR-билдов. Также была улучшена стратегия соединения по веб-сокетам. Были и другие приятности, например шаблоны для старта проектов с Vite, экспериментальные фичи и уменьшение размера бандла. Дополнительно отмечу, что команда проекта решила выпускать один мажорный релиз в год, для того чтобы следовать циклу вывода из эксплуатации версий Node.js и регулярно проводить ревизию API.

[Предпоследний релиз Deno](https://deno.com/blog/v1.23) принёс немало изменений. Команды deno run, deno eval и deno cache больше не делают проверку типов. Проверку всё ещё можно делать, но для этого нужно использовать флаг –check или отдельную команду deno check. Была добавлена поддержка TypeScript 4.7, а в режиме –watch Deno теперь можно отслеживать изменения в файлах, которые были импортированы динамически.

Есть и [более новая версия 1.24](https://deno.com/blog/v1.24), которая вышла 21 июля. В этой версии была несколько ускорена проверка типов за счёт использования SWC или Speedy Web Compilier во всех случаях, т.е. компилятор TS больше не используется в режиме –check. Улучшили поддержку LSP, поддержку API подпроцессов, также в число стандартных был добавлен модуль semver.

Другие релизы этой недели — обновление [Angular 14.1](https://github.com/angular/angular/releases/tag/14.1.0), [Vue 2.7.8](https://github.com/vuejs/vue/blob/main/CHANGELOG.md) и [ESLint 8.20.0](https://eslint.org/blog/2022/07/eslint-v8.20.0-released/).

<ParagraphWithImage imageName="laptopNews" >
  ### Другие новости

В этом выпуске других новостей особенно нет, но к следующему выпуску я хочу узнать, что сейчас происходит с [Rome](https://rome.tools/blog/). Напомню, это фронтенд-тулчейн, который по идее должен решать все обычные служебные задачи при разработке приложений: от форматирования до линтинга и прогона тестов. Идея благородная: избавиться от зоопарка библиотек и заменить всё одним швейцарским ножом. В прошлом году команда проекта приняла решение переписать его полностью на Rust. В рамках этой инициативы в апреле был выпущен Rome Formatter. А вот что происходит прямо сейчас — отличный вопрос, на который я постараюсь найти для вас ответ.
</ParagraphWithImage>

В конце выпуска я хочу сказать вам пару слов. Будьте внимательны при выборе инструментов и фреймворков: как я уже говорил, open-source маркетинг в действии, и велик шанс, что вы попадётесь в ловушку плохого, но хорошо разрекламированного софта. В open-source приходят инвестиции, а значит, и банальная реклама, как по телевизору, и некачественные продукты с красивой этикеткой. Живите долго и процветайте, и ваши проекты тоже.

Все ссылки и публикации вы найдете в описании выпуска. Всем пока и до встречи в следующую пятницу.


  ### Пишите нам и читайте
  [Telegram—канал CSSSR](https://t.me/csssr)

  [Twitter CSSSR](https://twitter.com/csssr_dev)

  [Twitter новостей](https://twitter.com/csssr_news)

  [Telegram ведущего](https://t.me/Vindizh)

  [Twitter ведущего](https://twitter.com/Vindizh)
