---
title: 'В этом выпуске: Firefox 97, Vite 2.8.0, нужен ли pipe-оператор, можно ли обойтись без фреймворков, сравнение разных сборок и результаты The State of JS 2021. '
soundcloudLink: 'https://soundcloud.com/csssr/firefox-97-vite-280-pipe-operator-mozhno-li-bez-freymvorkov-rezultaty-the-state-of-js-2021'
date: '2022-02-18T00:00:00.000Z'
episodeNumber: 208
tag: 'news'
author: 'Ислам Виндижев'
---

<ParagraphWithImage imageName="manWithLaptop">
  ### Интересные публикации

Аксель Раушмайер в своем блоге написал статью об одном из пропозалов для ES — [pipe-операторе](https://2ality.com/2022/01/pipe-operator.html). В статье он рассказывает, какими языками была вдохновлена фича (F# и Hack), как оператор работает в этих языках и по какому пути пошел pipe-оператор для JavaScript. Он приводит юз-кейсы применения оператора: вложенные вызовы функций, разного рода чейнинг и другие. Также Аксель рассуждает, действительно ли pipe-оператор нужен в JavaScript и какие есть альтернативы.
</ParagraphWithImage>

Как вы знаете, проверка данных в формах часто может обернуться болью и сложностями в поддержке. Саша Беспоясов поделился своим [подходом к валидации данных форм](https://bespoyasov.ru/blog/declarative-rule-based-validation/) с использованием функционального подхода с валидацией правилами. Как он сам коротко описал содержание в своем твите: для описания критериев нужно использовать чистые функции, для составления сложных правил нужно использовать композицию, для декларативности нужно составить правильные абстракции, а доменную, интерфейсную и инфраструктурную логики стоит держать отдельно. Как это все реализовать — Саша подробно рассказывает в своей статье, там же есть пример формы, к которой применяется подход.

Поговорим о фреймворках и около. Алекс Рикабо (Alex Rickabaugh) рассказал в блоге Angular [о работе компилятора](https://blog.angular.io/how-the-angular-compiler-works-42111f9d2549) фреймворка. Компилятор ngc построен поверх компилятора TypeScript, или tsc, а его главные задачи — это компиляция декораторов Angular, применение проверки типов для шаблонов компонентов и рекомпиляция при внесении изменений разработчиком. Компилятор Angular служит мостом между удобством разработки и производительностью, а Алекс рассказывает обо всех этапах работы компилятора и о том, как именно он выполняет свои задачи.

В блоге Better Programming на Medium была опубликована статья [об эволюции фронтенда, фреймворках и их отличиях](https://betterprogramming.pub/from-jquery-to-react-vue-angular-the-evolution-of-frontend-frameworks-and-there-difference-3e6b6fcc6200). В статье кратко описывается, что было «в начале», даже до AJAX, как мы поняли, что пора придумывать фреймворки, и какой принцип лежит в основе каждого — если коротко, состояние должно меняться вслед за интерфейсом, и интерфейс — при изменении состояния. Но у фреймворков есть разница в деталях реализации, которые тоже коротко описываются в статье.

Ноам Розенталь (Noam Rosenthal) написал вторую часть своей статьи о веб-фреймворках. Напомню, в первой части он рассказывал о том, какие проблемы они решают. Вторая — о том, [можно ли обойтись чистым JavaScript](https://www.smashingmagazine.com/2022/02/web-frameworks-guide-part2/), как можно использовать веб-платформу саму по себе для решения задач фреймворков. Ноам демонстрирует, как использовать реактивность, работать с формами и их данными, как на чистом HTML можно делать шаблоны и ещё несколько приемов. Сложно сказать, насколько это применимо на больших проектах с длительной поддержкой, но автор раскрывает свою точку зрения: многие задачи, которые решают фреймворки, уже можно решать и без них.

Также на Smashing Magazine появилась расшифровка доклада Сергея Мелюкова [об анализе Webpack-бандлов](https://www.smashingmagazine.com/2022/02/statoscope-course-intensive-therapy-bundle/). Он рассказывает о своем инструменте Statoscope, который позволяет сравнить две сборки и проанализировать отличия. Это может быть и время сборки, и дубли библиотек, размер и другие параметры. Он же может быть использован в CI для блокирования пулл-реквестов и умеет генерировать отчеты. Довольно [интересный тул](https://www.youtube.com/watch?v=aAkmZ0gMYQ8).

Всё больше и больше нативных элементов появляется в вебе, один из примеров — элемент диалога с пользователем. В Chrome он есть уже давно, но такой, что пока лучше и не трогать, а теперь его планируют внедрить Safari и Firefox. Как раз об этом [теге <dialog>](https://webkit.org/blog/12209/introducing-the-dialog-element/) пишет в блоге WebKit Тим Нгуен (Tim Nguyen). Он рассказывает, как им пользоваться, в том числе вместе с формами, как его стилизовать, и о наработках по доступности. Есть договоренность с другими браузерными вендорами о развитии фичи и её поддержке.

Продолжая тему элементов. Следующий материал — об элементе <details>, который решил прокачать Зак Лезерман (Zach Leatherman). Он подумал, что элемент мог бы уметь и побольше, а прокачку завернул в веб-компонент, который назвал [<details-utils>](https://www.zachleat.com/web/details-utils/). На момент написания статьи добавились такие фичи, как закрытие по клику вне элемента и нажатию на Esc, принудительное и анимированное закрытие/открытие элемента и переключение класса корневого элемента. В статье вы найдете демо и ссылку на репозиторий, возможно, наработки Зака пригодятся и на вашем проекте.

Далее хочу обратить ваше внимание на два материала о фавиконках. Первый — всё еще актуальная статья Андрея Ситника [о фавиконках](https://evilmartians.com/chronicles/how-to-favicon-in-2021-six-files-that-fit-most-needs), которую немного обновили для 2022 года. Если коротко, то 5 изображений фавикинок и одного JSON будет достаточно почти для всех случаев, кроме каких-то уникальных и невероятно специфичных. Второй материал от Адама Аргайла (Adam Argyle). На web.dev он рассказывает [о реализации адаптивной svg-фавиконки](https://web.dev/building-an-adaptive-favicon/).

Алекс Трост (Alex Trost) написал статью [о генерации svg-сеток](https://frontend.horse/articles/generative-grids/). Для чего это может быть нужно? Клевый и креативный дизайн, генерация NFT чего-нибудь, в общем, на что хватит фантазии. Собственно, процесс реализации генератора Алекс и описывает — пошагово, с объяснениями и, конечно же, кодом.

Давайте заглянем в будущее. Настоящий киберпанк — это нейроинтерфейсы. Но мы пока поговорим [о голосовых](https://www.smashingmagazine.com/2022/02/voice-user-interfaces-guide/). Именно о них написали статью Ник Бабич и Глеб Кузнецов. Почему это актуально? Потому что голосовые интерфейсы уже проникают и в веб, а гонка User Experience никогда не прекращается. Авторы делают небольшой экскурс в историю голосовых интерфейсов, рассказывают о шести основополагающих принципах и дают рекомендации по разработке таких интерфейсов. Киберпанк уже совсем близко.

Адриан Болонио (Adrian Bolonio) в своем блоге опубликовал статью [об автоматизации проверок доступности](https://www.adrianbolonio.com/en/accessibility-github-actions/) на проекте при помощи GitHub Actions. Он использует пакеты axe и pa11y для выявления проблем с доступностью, рассказывает, как заблокировать pull request при возникновении проблем, и показывает, как автоматизировать отчеты по проверкам при помощи Lighthouse.

Завершит рубрику [учебник по кривым Безье](https://pomax.github.io/bezierinfo/) — тем самым, при помощи которых устанавливаются законы для изменения CSS-анимаций. Учебник посвящен как математике кривых, так и их практическому применению в программировании.

<ParagraphWithImage imageName="laptopNews" >
  ### Новости релизов

Вышел [Firefox 97](https://developer.mozilla.org/en-US/docs/Mozilla/Firefox/Releases/97). В этой версии добавили поддержку каскадных слоев CSS, о которых сейчас довольно много говорят. Была добавлена поддержка CSS-свойства scrollbar-gutter. Оно помогает избежать глитчей при появлении скроллбара. Также в CSS добавили новые единицы измерения cap и ic, директивы @scroll-timeline и @animation-timeline для создания анимаций, привязанных к позиции скролла. JavaScript тоже с обновлениями. requestAnimationFrame и cancelAnimationFrame теперь можно использовать внутри веб-воркеров. Также была расширена поддержка AbortController.
</ParagraphWithImage>

[Google Chrome](https://chromereleases.googleblog.com/2022/02/stable-channel-update-for-desktop_14.html) отметился патчем 98 версии с устранением уязвимости нулевого дня. Что-то их становится все больше и больше. Подробности пока не раскрываются, известно, что она связана с Web Animations API. Помимо этой уязвимости было устранено ещё 10 менее опасных.

Состоялись релизы версий Node.js. В версии [17.5.0](https://nodejs.org/en/blog/release/v17.5.0/) была добавлена экспериментальная поддержка fetch API. В LTS-версии [16.14.0](https://nodejs.org/en/blog/release/v16.14.0/) была добавлена также экспериментальная поддержка import assertions.

[Vite 2.8.0](https://github.com/vitejs/vite/blob/main/packages/vite/CHANGELOG.md#280-2022-02-09) с новым релизом стал на 35% меньше после установки и на 75% меньше после публикации. Кроме того, в нем появилась возможность настраивать сборку воркеров и был представлен ряд багфиксов.

Также отмечу релизы [Electron 17](https://www.electronjs.org/blog/electron-17-0), [Ember.js 4.2.0](https://github.com/emberjs/ember.js/releases/tag/v4.2.0) и [npm 8.5.0](https://github.com/npm/cli/releases/tag/v8.5.0).

<ParagraphWithImage imageName="laptopNews" >
  ### Другие новости

До Нового года я приглашал всех поучаствовать в опросе [The State of JS 2021](https://2021.stateofjs.com/en-US/), теперь известны его результаты. В прошедшем году высший рейтинг удовлетворенности был у таких библиотек, как Next.js, esbuild, Vite, Cypress и Jest. Не отстают и React, Vue и Svelte, они в рейтинге дальше, но почему-то совсем упал Angular. Самыми большими болями были названы менеджмент зависимостей, архитектура кода и стейт-менеджмент. Vite взял целых два золота в этом году — по тому, насколько им интересуются, и по удовлетворенности. Nullish Coalescing стал самой принятой сообществом новой фичей, esbuild — самой принятой технологией, а Elm — самым популярным кастомным ответом. Отмечу, что увеличилось количество людей, которые начинают учиться по бесплатным ресурсам и своими силами, а Stackoverflow и MDN, ожидаемо, по-прежнему самые популярные справочные ресурсы.
</ParagraphWithImage>

Тревожные известия. Мы приближаемся к [сотой версии браузеров Chrome и Firefox](https://hacks.mozilla.org/2022/02/version-100-in-chrome-and-firefox/). Что же с этим не так? Сотня и сотня. Но проблема в том, что огромное количество сайтов и ресурсов полагаются на версию браузера в своей бизнес-логике, а многие библиотеки или код могут пока просто-напросто не учитывать при парсинге то, что версия может стать трехзначной. Это может привести к багам и ошибкам в большом масштабе, а может и не привести. У Chrome и Firefox есть запасной план на случай, если сотые версии сломают интернет, но, будем надеяться, этого не произойдет.

  ### Пишите нам и читайте
  [Telegram—канал CSSSR](https://t.me/csssr)

  [Twitter CSSSR](https://twitter.com/csssr_dev)

  [Twitter новостей](https://twitter.com/csssr_news)

  [Telegram ведущего](https://t.me/Vindizh)

  [Twitter ведущего](https://twitter.com/Vindizh)
