---
title: 'В этом выпуске: запись ReactConf 2021, ускорение комментариев на Хабре, оптимизация производительности кода, первый релиз-кандидат Ruby on Rails 7, а также релизы Dart, Flutter и Tailwind CSS 3.0.'
soundcloudLink: 'https://soundcloud.com/csssr/reactconf-2021-optimizatsii-koda-ruby-on-rails-7-rc-dart-215-flutter-28-tailwind-css-30'
date: '2021-12-13T00:00:00.000Z'
episodeNumber: 202
tag: 'news'
author: 'Ислам Виндижев'
---

<ParagraphWithImage imageName="manWithLaptop">
  ### Интересные публикации

8 декабря состоялась React Conf 2021, доступна [запись конференции](https://www.youtube.com/watch?v=FZ0cG47msEk&list=PLNG_1j3cPCaZZ7etkzWA7JfdmKWT0pMsa). Посмотреть однозначно стоит, как минимум потому, что анонсировали релиз React 18, который запланирован на первый квартал 2022 года. Обсуждали и другие интересные вещи — работу над мемоизацией, стриминговый серверный рендеринг, React Native для десктопа, рабочую группу React и другое.
</ParagraphWithImage>

Вышла большая техническая статья на Хабре от самого Хабра. Она посвящена [ускорению комментариев на платформе](https://habr.com/ru/company/habr/blog/590111/). Работы продолжались полгода, перепробовали много подходов — принудительный серверный рендеринг, рендеринг на клиенте, стрим-рендеринг, — рассказали и о совсем неудачных решениях. О каждом подходе и результатах рассказано достаточно подробно, конечно же, упомянуты и проблемы, которые возникали в процессе работы над комментариями. Интересный и непростой кейс.

Есть множество способов оптимизации производительности кода, про какие-то мы знаем, про какие-то нет, а про некоторые просто иногда забываем. Доколе? Хватит. Виктор Хомяков из Яндекса на Хабре попытался собрать [способы оптимизации](https://habr.com/ru/company/yandex/blog/570914/), многие из которых применимы не только для JS. Их довольно много, и они разделены на категории: организационные, не зависящие от языка оптимизации, специфичные для JS и другие. Советую посмотреть.

Как увеличить производительность Node.js в масштабе? На этот вопрос в своей статье пытается ответить Айолува Исайя (Ayooluwa Isaiah). Он формирует 7 рекомендаций, которые помогут следить за [производительностью Node.js](https://blog.appsignal.com/2021/11/24/7-ways-to-improve-nodejs-performance-at-scale.html) приложений и вовремя замечать проблемы. Стоит централизованно мониторить производительность, использовать кеширование, следить за операциями ввода-вывода и использовать кластеризацию. Также автор упоминает балансировщики нагрузки, Worker Threads и не советует использовать Node.js для доставки статики.

Ахмад Шадид (Ahmad Shadeed) написал статью [о защитном CSS](https://ishadeed.com/article/defensive-css/). Он указывает ряд практик и приемов при написании CSS, позволяющих предупредить ошибки и проблемы с разметкой, которые могут возникнуть в будущем. Ахмад собрал много распространенных ситуаций, среди которых правильная работа в флексами и гридами, использование разных значений ширины и высоты, особенности работы разных свойств и элементов. Получилось довольно длинно, потому что пунктов много, зато есть удобная навигация. Рекомендую к прочтению.

Максим Васянович написал статью о суперсилах, которые даруют [псевдоэлементы ::before и ::after](https://habr.com/ru/company/skillbox/blog/592643/). Он собрал 10 вещей, которые они позволяют делать верстальщику: иконки, кастомные чекбоксы и кнопки, стилизацию цитат и атрибута alt, геометрические эффекты, эффекты для состояний элементов и другое.

Алексей Черкасов из FunBox на Хабре написал статью об актуальных форматах изображений в вебе — [WebP и AVIF](https://habr.com/ru/post/594211/). Он поделился небольшим экскурсом в историю форматов и рассказал, как компания внедрила их в свои проекты. Как результат, на некоторых страницах экономия трафика составила до 50%. В статье содержатся рекомендации, как применять новые форматы и безболезненно на них перейти. Если вы их еще не используете — присмотритесь.

Виктория Ло (Victoria Lo) написала [о конечных автоматах](https://blog.openreplay.com/state-machines-for-javascript-developers-how-to-use-them-in-your-apps) и их использовании в разработке. Конечный автомат — это математическая модель, которая представляет некую систему в виде конечного ряда состояний и способов перехода из одних состояний в другие. Виктория показывает простой пример с использованием библиотеки XState, а сами автоматы вы можете применять в работе, главное, ухватить суть концепции.

Недавно мы узнали о выходе Remix — нового фреймворка, прямого конкурента Next.js. А вот и небольшое [сравнение двух фреймворков](https://medium.com/wayf/next-js-and-remixa-brief-comparison-8b542cb2e4f4) от Кацпера Лукавски (Kacper Łukawski) . Автор сопоставляет роутинг, стратегии рендеринга, получение и работу с данными. Пока что Next.js выглядит всё-таки получше. Использование react-router не добавляет Remix привлекательности, а будет ли настоящая конкуренция — непонятно. Лично я сомневаюсь, но время покажет.

Завершит рубрику статья с проектами, которые круто попробовать [начинающим работать с Vue](https://the-nerdy-dev.com/8-vue-projects-every-beginner-should-try/). Здесь есть такие проекты, как приложение с погодой, COVID-трекер, портфолио и даже сайт для электронной коммерции. К каждому проекту есть гайд, а используется не только Vue, но и другие технологии — например, Firebase, Django, Tailwind CSS. Отличная возможность потренироваться или начать работу с Vue.

<ParagraphWithImage imageName="laptopNews" >
  ### Новости релизов

Первый релиз — [Firefox 95](https://hacks.mozilla.org/2021/12/webassembly-and-back-again-fine-grained-sandboxing-in-firefox-95/). В этом релизе был реализован дополнительный слой изоляции c использованием технологии RLBox — это нужно для усиления безопасности, и работы в этом направлении будут продолжаться. Также для пользователей по умолчанию активировали режим строгой изоляции веб-сайтов. Был представлен ряд оптимизаций производительности. Ещё одна небольшая новость: Firefox теперь доступен в магазине приложений Windows. Больше подробностей — в release notes.
</ParagraphWithImage>

Вышел [первый релиз-кандидат Ruby on Rails 7](https://weblog.rubyonrails.org/2021/12/6/Rails-7-0-rc-1-released/). Обещают новый подход к работе с JavaScript: сборщик можно будет выбрать из Webpack, Rollup или esbuild, или обойтись без сборщика вообще и использовать ES-модули, Hotwire или Turbo. Кроме того, можно будет выбрать и подходящий для проекта CSS-фреймворк. Отмечу также возможность делать несколько параллельных запросов к БД и инструменты для логирования этих запросов. Будем ждать релиза.

Следующее обновление — от команды Dart. Главная фича [Dart 2.15](https://medium.com/dartlang/dart-2-15-7e7a598e508a) — это Isolates, независимые изолированные единицы, в которых исполняется код на Dart. Изоляция позволяет избежать проблем конкурентного исполнения кода — таких, как состояние гонки. Также была улучшена поддержка перечислений, добавлено сжатие указателей и представлено небольшое обновление DevTools.

Фреймворк Flutter тоже отметился релизом. В [выпуске 2.8](https://medium.com/flutter/whats-new-in-flutter-2-8-d085b763d181) поработали над временем старта приложений и потреблением памяти на устройствах с небольшим количеством ресурсов. Ещё одна крутость — новые способы более подробного профилирования и соответствующее обновление Flutter DevTools.

Завершит рубрику релиз [Tailwind CSS 3](https://tailwindcss.com/blog/tailwindcss-v3). В этой версии продолжилась работа над движком Just-in-Time и производительностью. Добавили цвета из расширенной палитры, Scroll snap API, поддержку лейаутов с несколькими колонками и новый способ стилизации элементов форм.

<ParagraphWithImage imageName="laptopNews" >
  ### Другие новости

Разработчик из Oracle Стайнар Гундерсон (Steinar H. Gunderson) покинул компанию и команду MySQL. Всё бы ничего, но он написал открытое письмо о том, что [от MySQL пора отказываться](https://blog.sesse.net/blog/tech/2021-12-05-16-41_leaving_mysql.html) и она довольно отсталая по сравнению с другими СУБД в своем классе. Вот это поворот. А советует он переходить на PostgreSQL. В письме он обосновывает свою точку зрения, но отказываться ли от MySQL — решать вам.
</ParagraphWithImage>

Завершит рубрику [веб-альманах 2021](https://almanac.httparchive.org/en/2021/). Команда HTTP Archive традиционно проанализировала веб-сайты и собрала статистику по CSS, JavaScript, WebAssembly и другим аспектам работы веб-ресурсов. Из нее вы можете узнать, например, что контент в вебе становится более структурированным, WebAssembly используют всё больше и многое другое.

  ### Пишите нам и читайте
  [Telegram—канал CSSSR](https://t.me/csssr)

  [Twitter CSSSR](https://twitter.com/csssr_dev)

  [Twitter новостей](https://twitter.com/csssr_news)

  [Telegram ведущего](https://t.me/Vindizh)

  [Twitter ведущего](https://twitter.com/Vindizh)
