---
title: 'В этом выпуске: Fleet и Compose Multiplatform, PHP 8.1, адвент-календари, гайд по JWT, статьи о цепях Маркова и фонетических алгоритмах, роадмапы по разным профессиям в IT.'
soundcloudLink: 'https://soundcloud.com/csssr/fleet-i-compose-multiplatform-php-81-gayd-po-jwt-tsepi-markova-roadmapy-po-it-professiyam'
date: '2021-12-03T00:00:00.000Z'
episodeNumber: 201
tag: 'news'
author: 'Ислам Виндижев'
---

<ParagraphWithImage imageName="manWithLaptop">
  ### Интересные публикации

2021 год подходит к концу, социальные сети заполонили адвент-календари с косметикой, лего и вообще всем, чем угодно. Но так как мы программисты, то и адвент-календари у нас свои. Их также огромное множество, но я представлю вашему вниманию три. Наверное, самый известный — это [Advent of Code](https://adventofcode.com/). В нем собраны задачки, которые можно решать на любом языке программирования, достаточно залогиниться и присоединиться к движухе. Ещё два календаря относятся уже непосредственно к фронтенду. Первый — [Advent of CSS](https://www.adventofcss.com/), в нем вы найдете задания в виде макета в Figma и инструкции. Второй — [Advent of JavaScript](https://www.adventofjs.com/), здесь в каждом задании будут готовые HTML и CSS, что позволит сосредоточиться на JavaScript. Все адвент-календари кода начались 1 декабря, но присоединиться никогда не поздно. Попробуйте, это хорошая возможность весело поучиться чему-то новому или поддержать форму.
</ParagraphWithImage>

Следующие два материала будут не вполне типичными, но интересными. Антон Жиянов в своем блоге написал статью [о быстром поиске похожих слов на SQL](https://antonz.ru/similar-words/). Зачем это может быть нужно? Например, для замены слов с опечатками на их исправленные версии. На примере этой задачи Антон показывает, как работают фонетические алгоритмы кодирования, как может происходить замена и как учесть не фонетические, а механические опечатки. Если вы всегда задавались вопросом, как работают замены, например, в Google Docs, то вам определенно стоит посмотреть. И для расширения кругозора лишним однозначно не будет.

Слышали когда-нибудь о цепях Маркова? Это одно из математических понятий, прошу вас, не гуглите и не пытайтесь вдаваться в математические подробности. Если грубо, это цепочки событий, в которых каждое событие зависит только от предыдущего. Саша Беспоясов написал статью [о применении цепей Маркова для генерации текста](https://bespoyasov.ru/blog/text-generation-with-markov-chains/). В итоге Саша генерирует текст, а потом пытается сгенерировать и код. Спойлер: код нерабочий, зато сгенерированный. Получилось интересно, а самим цепям Маркова можно найти применение, была бы фантазия.

Бывают ситуации, когда нужно фоновое изображение для какой-то страницы, а добровольца дизайнера нет и креативить не хочется. Что делать? Решать задачу как программисты! [Фон можно сгенерировать](https://css-tricks.com/creating-generative-patterns-with-the-css-paint-api/). Джордж Френсис (George Francis) на css-tricks рассказывает, как это можно сделать с использованием CSS Paint API. В статье он делится азами работы с этим API и реализует три генеративных фона.

На Хабре Степан Зубашев обращает внимание на то, что мы все расслабились из-за функциональных элементов в JavaScript. Между тем красивые и лаконичные декларативные методы часто могут привести к просадкам в производительности. На примере методов reduce() и concat() Степан показывает, [к каким проблемам может привести погоня за лаконичностью](https://habr.com/ru/post/590663/). Не скажу, что нам нужно немедленно переписать все на циклы for, да и автор к этому не призывает. Важно во время написания кода принимать осознанные решения и понимать, как работает то, что вы пишете. Если вы никогда не задумывались, что происходит при использовании тех или иных конструкций в коде, — стоит начать.

WebGPU — новая технология и API для работы с графическим ускорителем, то бишь видеокартой, в браузере. Она появится в Chrome в первом квартале 2022 года. Технология обещает лучшую совместимость с GPU и специальную функциональность для расчетов на GPU из коробки. Денис Радин с своей заметке сравнивает [производительность WebGPU и WebGL](https://pixelscommander.com/ru/javascript/webgpu-computations-performance-in-comparison-to-webgl/). Приводится краткое объяснения ключевых отличий технологий и бенчмарки. Согласно статье, WebGL быстрее в три раза и инициализируется быстрее чем WebGL. Если вы интересуетесь темой — загляните, заметка небольшая, на 5-7 минут чтения.

Давненько в новостях не было материалов, связанных с аутентификацией и авторизацией. Мартин Новак (Martin Novak) на Medium опубликовал ультимейт [гайд по JWT или JSON Web Token](https://betterprogramming.pub/jwt-ultimate-how-to-guide-with-best-practices-in-javascript-f7ba4c48dfbd). Это довольно подробный и одновременно доступный материал о технологии, в нем есть сравнение с сессиями и лучшие практики по работе с JWT на JavaScript. Хочу отметить, что ни одна стратегия аутентификации и авторизации, как и любая другая технология, не является серебряной пулей и хороша в той или иной ситуации на конкретном проекте, никогда не забывайте об этом.

Нирмалья Гош (Nirmalya Ghosh) на SmashingMagazine поделился своим опытом [поддержки больших Next.js-приложений](https://www.smashingmagazine.com/2021/11/maintain-large-nextjs-application/). В числе его рекомендаций — использование TypeScript, монорепозиториев и генераторов шаблонного кода. Он упоминает написание поддерживаемых тестов со старта проекта, некоторые библиотеки и обновление пакетов. В статье он также рассказывает, с какими проблемами это все помогло бороться. Рекомендации, конечно, субъективные и зависят от проекта, но в них можно почерпнуть что-то полезное для себя.

Штефан Баумгартнер (Stefan Baumgartner) в своем блоге опубликовал небольшую заметку [о перегрузке функций в TypeScript](https://fettblog.eu/typescript-function-overload/). Напомню, в прошлом выпуске была заметка на эту же тему от Дмитрия Павлютина. В статье Штефана больше примеров, и она чуть более подробная, также в конце можно найти ссылки для продолжения изучения темы.

Завершат рубрику материалы, связанные с развитием и обучением. Первый — ресурс [roadmap.sh](https://roadmap.sh/). Как вы могли догадаться по домену, на нем можно найти роадмапы по разным профессиям в разработке. Здесь вы найдете карты по изучению фронтенда, бэкенда, DevOps, разных языков программирования и другое. На подходе роадмапы по AWS и QA. Второй ресурс посвящен [изучению регулярных выражений](https://github.com/aykutkardas/regexlearn.com): это небольшой интерактивный курс, который подойдет для освоения регулярок с самых азов без предварительной подготовки.

<ParagraphWithImage imageName="laptopNews" >
  ### Новости релизов

Рубрика начнется с релиза [PHP 8.1](https://www.php.net/releases/8.1/en.php). Обновление довольно большое, и в нем много новых фич: перечисления, свойства только для чтения, обновления инициализаторов и синтаксис вызовов первого класса, пересекающиеся типы и другие. Еще одна заметная фича — Fibers, примитив для реализации конкурентности. По ссылке можно посмотреть на все нововведения и примеры их использования в коде буквально за 5-10 минут.
</ParagraphWithImage>

Несколько релизов разных версий Node.js состоялось на этой неделе. В версии [17.2.0](https://nodejs.org/en/blog/release/v17.2.0/) обновили версию V8 и добавили поле reason в AbortController. В версии [16.13.1](https://nodejs.org/en/blog/release/v16.13.1/) обновили версию npm и починили баг с распознаванием разных слешей в регулярных выражениях. Также была устранена регрессия, связанная с CNAMES и именами, содержащими знак нижнего подчеркивания, в релизе LTS-ветки [14.18.2](https://nodejs.org/en/blog/release/v14.18.2/).

Немного о редакторах и IDE. [WebStorm 2021.3](https://www.jetbrains.com/webstorm/whatsnew/) теперь поддерживает приватные поля классов из спецификации ES2022 и language server protocol для Deno. Также была улучшена поддержка монорепозиториев, добавлена проверка типов в шаблонах Vue, были представлены новые возможности для удаленной разработки.

Редактор кода [neovim](https://github.com/neovim/neovim/releases/tag/v0.6.0) отличился релизом 0.6.0. В vim-скрипты добавили локальные переменные, расширили возможности встроенного клиента language server protocol, был представлен ряд оптимизаций. Также улучшили поддержку языка Lua для создания плагинов и управления конфигурацией.

Следующий релиз — [SQLite 3.37.0](https://www.sqlite.org/releaselog/3_37_0.html). Добавили строгий режим для таблиц. В этом режиме СУБД может следить за тем, чтобы данные в ячейках соответствовали типу. Также появился новый тип ANY. Есть и другие изменения, с полным списком можно ознакомиться на странице релиза.

Также отмечу выход [первого релиз-кандидата фреймворка Django 4.0](https://www.djangoproject.com/weblog/2021/nov/22/django-40-rc1/) и [ChromeOS 96](https://chromereleases.googleblog.com/2021/11/stable-channel-update-for-chrome-os_30.html).

<ParagraphWithImage imageName="laptopNews" >
  ### Другие новости

Ещё одна новость от JetBrains, которая подогрела сообщество разработчиков. Вышло [превью Fleet](https://www.jetbrains.com/fleet/) — легковесного редактора наподобие VS Code. Архитектура распределенная, редактор поддерживает совместное редактирование файлов, терминалы, language server protocol и умеет переключаться между режимами «Редактор» и «IDE». Проект не на браузерных технологиях и написан с нуля. Мы уже видели и слышали про разные облачные редакторы, и, по моему мнению, JetBrains делает серьезную заявку на победу в этой нише, но не буду загадывать — идет бета по приглашениям, время покажет, что из этого получится. Кстати, о бете: в первые сутки поступило 80 тысяч заявок на участие. Лично мне ещё интересно, сколько в итоге он будет стоить и как монетизация Fleet будет соотноситься с монетизацией существующих продуктов JetBrains.
</ParagraphWithImage>

Менее резонансный, но не менее важный анонс — тоже от JetBrains. Был анонсирован [Compose Multiplatform](https://www.jetbrains.com/ru-ru/lp/compose-mpp/) — фреймворк для построения интерфейсов десктопных и веб-приложений на Kotlin. Могу предположить, что Fleet был написан как раз с применением этого фреймворка, который определенно заслуживает внимания.

  ### Пишите нам и читайте
  [Telegram—канал CSSSR](https://t.me/csssr)

  [Twitter CSSSR](https://twitter.com/csssr_dev)

  [Twitter новостей](https://twitter.com/csssr_news)

  [Telegram ведущего](https://t.me/Vindizh)

  [Twitter ведущего](https://twitter.com/Vindizh)
