---
title: 'В этом выпуске: Next.js 12, Error Boundaries, правила Node.js и Event Loop, борьба со скроллом, алгоритмы и структуры данных на JavaScript, а также веб-версии Adobe Photoshop и VSCode.'
soundcloudLink: 'https://soundcloud.com/csssr/nextjs-12-error-boundaries-nodejs-i-event-loop-algoritmy-na-javascript-veb-photoshop-i-vscode'
date: '2021-10-29T00:00:00.000Z'
episodeNumber: 196
tag: 'news'
author: 'Ислам Виндижев'
---

<ParagraphWithImage imageName="manWithLaptop">
  ### Интересные публикации

Представьте, что ваше приложение на React упало. Взяло и упало, полностью, из-за одной единственной ошибки. Но подождите, у нас же есть try/catch, или можно просто вернуть объект ошибки? Это всё, к сожалению, не работает. Поэтому в React 16 появились [Error Boundaries](https://habr.com/ru/company/2gis/blog/583894/), или предохранители. Они отлавливают ошибки в разных местах — методах жизненного цикла, деревьях компонентов — логируют их и выводят запасной UI, не давая упасть всему приложению. Подробнее о том, как работают предохранители и как их применить на практике, написал Артём Малько в блоге 2ГИС.
</ParagraphWithImage>

Орел Балилти (Orel Balilti) на Medium пытается создать [порядок из хаоса микрофронтендов](https://o-b-one.medium.com/the-micro-frontend-chaos-and-how-to-solve-it-960b0a90c58). В своей статье он рассказывает, для чего микрофронтенды нужны и по каким принципам строятся такие приложения. Затем при помощи нескольких паттернов он пробует навести порядок, в заключение приводит плюсы и минусы подхода, а также делится ссылкой на репозиторий с демопроектом.

Недавно в одном из выпусков новостей была статья Фернандо Дольо (Fernando Doglio) о плохих практиках в JavaScript. Сегодня я представляю вам его статью [о плохих практиках в TypeScript](https://blog.openreplay.com/typescript-done-wrong). Конечно, здесь есть наказы о том, что не стоит злоупотреблять типом any и типом Function вместо сигнатуры. Также Фернандо пишет, что не так с перечислениями и как корректно пользоваться ключевым словом private. Всё с примерами.

Илья Горкун на Хабре опубликовал статью о том, где на самом деле может на практике пригодиться [знание Event Loop и работы Node.js](https://habr.com/ru/company/lineate/blog/585050/). Чтобы раскрыть вопрос, он обращается к основам, рассказывает о паттернах и о работе Event Loop в деталях. В конце статьи он подводит краткий итог, есть и небольшое демоприложение. Отличная статья, чтобы разобраться в работе Event Loop в Node.js.

Следующий материал — более практический. Алекс Деверо (Alex Devero) написал статью о [реализации зоны для загрузки файла с перетаскиванием](https://blog.alexdevero.com/react-file-dropzone/). Для реализации Алекс использует create-react-app и шаблон TypeScript. Он поэтапно реализует компонент, стараясь использовать как можно меньше зависимостей. Хорошая возможность попрактиковаться в работе с событиями перетаскивания.

Как давно вы работали с OAuth2? Работали ли вообще? OAuth — это протокол авторизации. Если совсем просто, кнопки «продолжить с Google», «войти через Facebook» работают как раз с этим протоколом. Диогу Соуза (Diogo Souza) написал статью, в которой рассказывает, [как работать с протоколом OAuth2](https://www.honeybadger.io/blog/oauth-nodejs-javascript/) на примере простейшего приложения. Если вы ни разу не имели дел с OAuth, это неплохой повод с ним познакомиться.

В разработке фронтенда есть множество типовых задач, которые часто встречаются в работе. В статье Яна Тсишко (Yan Tsishko) речь пойдет [о тротлинге и дебаунсе](https://itnext.io/solving-javascript-problems-from-bigfrontend-bfe-throttle-and-debounce-87a809e5952b). Тротлинг позволяет выполнять какую-то функцию через равные промежутки времени, а дебаунс — через определенное время после завершения какого-то события. Ян приводит практические примеры и способы применения этих приемов.

Александр Шатилов на Хабре опубликовал статью [о работе с доступностью в Angular](https://habr.com/ru/company/europlan/blog/578856/). Как вы знаете, Angular предоставляет очень много инструментов, библиотек и наборов для разработки. В этой статье речь идет о SDK по доступности. В частности, Александр обращает внимание на сервисы FocusTrap и FocusMonitor. Конечно, он рассказывает и то, в каких случаях их стоит применять.

На css-tricks продолжает выходить серия Темани Афифа (Temani Afif) о CSS Paint API. В четвертой части мы будем [скруглять формы](https://css-tricks.com/exploring-the-css-paint-api-rounding-shapes/) сложных многоугольников. Темани сразу оговаривается, что эту задачу можно решить и другими способами: svg-полигонами, с помощью clip-path или даже чистым CSS. Но эти подходы могут не помочь в более сложных ситуациях. В статье он также показывает много примеров, когда может понадобиться скругление.

Следующий материал — о скролле, а именно о перекрытии скроллов. Например, когда вы скроллите модальное окно и доходите до конца, продолжает скроллиться страница под окном, что часто неудобно для пользователя после закрытия модалки. Этим поведением теперь можно управлять [при помощи свойства overscroll-behavior](https://ishadeed.com/article/prevent-scroll-chaining-overscroll-behavior/). О нем в своем блоге рассказал Ахмад Шадид (Ahmad Shadeed). Он показал старое костыльное решение, продемонстрировал, как работает новое свойство, и привел несколько примеров: скролл сайдбара, горизонтальный скролл и другие.

Инженеры Amazon поделились своим [опытом оптимизации размера библиотеки AWS SDK на JavaScript](https://aws.amazon.com/blogs/developer/how-we-halved-the-publish-size-of-modular-aws-sdk-for-javascript-clients/). После анализа SDK при помощи сервиса packagephobia размер удалось сократить в среднем на 50%. Детальнее о том, как этого удалось достичь, читайте в блоге AWS.

Ещё немного практики. Таня Рашиа (Tania Rascia) в своем блоге опубликовала небольшой [гайд по реализации таблицы с сортировками, фильтрами и пагинацией](https://www.taniarascia.com/front-end-tables-sort-filter-paginate/). Не знаю как сейчас, но раньше это часто было больновато, особенно делать самому с нуля. Таня использует React, но подход в принципе применим к любому фреймворку.

Давайте коротенько про переменные в JavaScript. Что использовать: [let, const или var](https://javascript.plainenglish.io/javascript-const-vs-var-vs-let-a-comprehensive-guide-for-all-time-d6d836c8bbd7)? Точку в этом вопросе пытается поставить Арнольд Абрахам (Arnold Abraham). Истина, как всегда, где-то посередине — у каждого вида объявления свои особенности и область применения. Подробнее — в статье Арнольда.

Закроет рубрику [репозиторий с алгоритмами и структурами данных на JavaScript](https://github.com/trekhleb/javascript-algorithms/blob/master/README.ru-RU.md). Мы как-то уже говорили про этот репозиторий, я решил про него напомнить. В нем вы найдете реализацию разных алгоритмов и структур данных на JS, сможете почитать теорию и посмотреть на примеры области применения. Не учите алгоритмы наизусть, хотя бы знайте, где их найти и для чего они могут быть нужны.

<ParagraphWithImage imageName="laptopNews" >
  ### Новости релизов

Зарелизился [Next.js 12](https://nextjs.org/blog/next-12). В этой версии подвезли написанный на Rust компилятор, который позволил ускорить сборку в 5 раз, а обновление — в 3 раза. Появилась поддержка React 18, React Server Components в статусе альфы и поддержка URL-импортов в статусе беты. Кроме того, Next.js теперь поддерживает ES-модули и AVIF-изображения.
</ParagraphWithImage>

Интересно выглядит релиз [Gatsby 4](https://www.gatsbyjs.com/blog/whats-new-in-gatsby-4/). Теперь Gatsby поддерживает серверный рендеринг или SSR, умеет параллельно обрабатывать запросы и обладает улучшенной инфраструктурой деплоев. Это не всё, команда Gatsby также начала реализовывать поддержку React 18 и обновила API для взаимодействия с системами управления контентом.

Вышла версия [Node.js 16.13.0](https://nodejs.org/en/blog/release/v16.13.0/). Это как раз та версия, которая переводит 16 версию Node.js в категорию LTS. До октября 2022 года она будет считаться активной LTS-версией, после чего перейдет в категорию поддерживаемой LTS-версии до апреля 2024 года. На эту версию пора обновляться на проде.

Также отмечу два грядущих мажорных релиза фреймворков. Появился [первый релиз-кандидат Angular 13](https://github.com/angular/angular/blob/master/CHANGELOG.md#1300-rc1-2021-10-20) и [первая бета-версия фреймворка Django 4.0](https://www.djangoproject.com/weblog/2021/oct/25/django-40-beta-1-released/). Подробнее я расскажу о них в следующих выпусках.

<ParagraphWithImage imageName="laptopNews" >
  ### Другие новости

  Сегодня в рубрике других новостей: один маленький шаг для двух всем хорошо известных продуктов и большой шаг для всех, кто занимается вебом.
</ParagraphWithImage>

Появились веб-версии Adobe Photoshop и Adobe Illustrator. В блоге web.dev Томас Натестад (Thomas Nattestad) и Набиль Аль-Шамма (Nabeel Al-Shamma) рассказали о том, как это удалось. [Веб-версия Photoshop](https://web.dev/ps-on-the-web/) — отличный пример использования современных технологий. Код скомпилировали из Emscripten в WebAssembly, используется многопоточность, SIMD, обработка исключений. Также приложение поддерживает цветовое пространство P3. Интерфейс построен на веб-компонентах и немного на React. В общем, если вы похоронили продукты Adobe, то, возможно, их светлое будущее в вебе еще впереди. Отмечу, что пока Photoshop работает только в Chrome 95 и Edge 95 и старше, а Illustrator для веба станет доступен позже.

Еще один продукт, который выбился в люди, в смысле, в онлайн — это [редактор VSCode](https://code.visualstudio.com/blogs/2021/10/20/vscode-dev). По адресу vscode.dev вы найдете легковесную версию редактора, которая может работать с вашими локальными файлами. Никакой установки, только онлайн. Также онлайн-версия поддерживает синхронизацию настроек, и их вполне можно подтянуть из вашего локального редактора. Помимо этого можно будет пользоваться и своими любимыми плагинами. Это неплохие новости, но интереснее перспектива. Онлайн-версия означает, что мы сможем увидеть полноценную online IDE и глубокую интеграцию со всевозможными сервисами и экосистемами. Интересно, что из этого получится, а больше подробностей вы найдете в блоге VSCode.

  ### Пишите нам и читайте
  [Telegram—канал CSSSR](https://t.me/csssr)

  [Twitter CSSSR](https://twitter.com/csssr_dev)

  [Twitter новостей](https://twitter.com/csssr_news)

  [Telegram ведущего](https://t.me/Vindizh)

  [Twitter ведущего](https://twitter.com/Vindizh)
