---
title: 'В этом выпуске: Firefox 93, TypeScript 4.5 Beta, разновидности DOM, дебаггинг CSS, стратегии работы с ветками в git, XSS-атаки, security-релизы Node.js и Redis, а также первые результаты внедрения RenderingNG в Google Chrome.'
soundcloudLink: 'https://soundcloud.com/csssr/firefox-93-typescript-45-beta-vidy-dom-debagging-css-xss-security-relizy-nodejs-i-redis'
date: '2021-10-12T00:00:00.000Z'
episodeNumber: 193
tag: 'news'
author: 'Ислам Виндижев'
---

<ParagraphWithImage imageName="manWithLaptop">
  ### Интересные публикации

Макс Кравец из Holyweb написал статью [о DOM](https://habr.com/ru/post/580336/). Если когда-то давно DOM был у нас один, то теперь есть и его разновидности, которые решают разные задачи, например, виртуальный DOM и теневой, или «shadow», DOM. Именно об этом Макс и рассказывает. Он начинает с построения самого DOM, а потом раскрывает, как и почему появились его братья. Получилось лаконично и очень доступно, так что если у вас в голове существовало запутанное определение — вот вам простая и понятная альтернатива.
</ParagraphWithImage>

Стефани Эклз (Stephanie Eckles) на Smashing Magazine опубликовала [гайд по дебаггингу CSS](https://www.smashingmagazine.com/2021/10/guide-debugging-css/). Она говорит о четырех наиболее частых проблемах CSS: переполнении контента, проблемах из-за специфических особенностей браузеров, неожиданных проблемах с наследованием стилей от каскада, а также неполадках в CSS из-за изменения DOM. Сначала Стефани делится общими рекомендациями, а затем пишет адресно по каждой из перечисленных проблем. По каждому пункту есть пример, подробное объяснение и скрины из DevTools с нужными инструментами и процессом дебаггинга.

Ахмад Шадид (Ahmad Shadeed) в своем блоге опубликовал статью о том, [как задать border-radius элементу по условию](https://ishadeed.com/article/conditional-border-radius/). Вы скажете: «Ислам, постой, мы же все умеем это делать медиа-запросами, в чем смысл?». Смысл в том, что Ахмад сделал это без медиа-запросов и дополнительных классов для разных случаев. По сути, он вычисляет border-radius в CSS-выражении, используя свойства max() и min(). Возможно, это не самый интуитивно понятный пример, но тоже решение, которое показывает, как можно проявить, скажем так, «смекалочку» и использовать возможности CSS нетривиальным способом.

Существуют разные стратегии работы с ветками в git, это зависит от многих факторов, и в каждой компании думают, что их подход — самый верный. Тобиас Гюнтер (Tobias Günther) на css-tricks опубликовал небольшую статью о том, что стоит держать в голове при определении [стратегии работы с ветками](https://css-tricks.com/branching-strategies-in-git/), и сделал обзор двух популярных конвенций работы с ветками: Git Flow и GitHub Flow. Вы могли про них слышать, но если нет — обязательно поинтересуйтесь.

Поговорим о безопасности. Речь пойдет [о XSS, или кросс-сайтовом скриптинге](https://habr.com/ru/company/oleg-bunin/blog/570040/). На Хабре была опубликована текстовая версия доклада Татьяны Новиковой о XSS. В статье есть и теория, и примеры последствий, а также защитные меры. Татьяна напоминает, что стоит следить за новостями безопасности и обновлять программное обеспечение.

Юрий Голубев из Mail.ru опубликовал на Хабре статью с интригующим названием — [«Как переверстать весь проект, не переверстывая его»](https://habr.com/ru/company/mailru/blog/579798/). Он рассказывает о кейсе на проекте почты, в котором нужно было реализовать изменение контента в зависимости от размера боковой колонки. Звучит просто, а на деле оказалось, что нет. В итоге задача решилась при помощи флексов, CSS-переменных и Resize Observer API.

Относительно недавно похожий материал уже был, но я хочу обратить ваше внимание на [обзор браузерных хранилищ](https://antonz.ru/browser-storage/) данных от Антона Жиянова. В своем блоге автор коротко, но ясно описывает разные виду браузерных хранилищ и прикладывает ссылки на более подробное чтиво. Он говорит и о куках, и о штуках поновее, как IndexedDB, а в заключение делится своими выводами.

В нашем с вами любимом IT-инфополе регулярно возникают споры о том, нужно ли знание алгоритмов. Вот вам пример задачи, в которой без алгоритмов не обойтись. Разработчики VS Code рассказали, [как ускорили алгоритм раскраски скобок в 10 тысяч раз](https://code.visualstudio.com/blogs/2021/09/29/bracket-pair-colorization). Раньше фича была реализована в расширении, его функциональность, как особо полезную, решили перенести в ядро редактора. В статье есть подробный обзор алгоритма, процесса переработки и демо проблемы с производительностью. Осторожно, внутри оценка алгоритмической сложности, диаграммы и разбор итогового алгоритма. Между прочим, сложность итогового алгоритма — логарифмическая.

Закроет рубрику небольшой блиц интересных ссылок.

Серия [«Визуализированный JavaScript»](https://dev.to/lydiahallie/series/3341) от Лидии Халли (Lydia Hallie) показывает важные концепции языка, такие как области видимости и hoisting, промисы, Event Loop, генераторы и итераторы, а также прототипное наследование. Получилось подробно и информативно, поможет разложить по полочкам в голове, рекомендую.

Интересуетесь [текущим состоянием React и движением к React 18](https://github.com/reactwg/react-18/discussions/98#discussioncomment-1318753)? В issue на GitHub Дэн Абрамов делится текущим восприятием и деталями работы над будущим релизом. Внимание, Дэн отмечает, что это только промежуточные идеи, а до релиза React 18 ещё достаточно далеко.

Далее — [список ресурсов для изучения доступности](https://web-standards.ru/articles/a11y-links/) и доступной разработки от Татьяны Фокиной.

Закроет блок [официальная дизайн-система W3C](https://design-system.w3.org/). Непременно взгляните.

<ParagraphWithImage imageName="laptopNews" >
  ### Новости релизов

Первый релиз этого выпуска — [Firefox 93](https://hacks.mozilla.org/2021/10/lots-to-see-in-firefox-93/). Теперь браузер поддерживает формат изображений AVIF, а новый движок WebRender включен по умолчанию и не отключается. Браузер научили выгружать тяжелые вкладки из памяти и блокировать небезопасные загрузки файлов. Кроме того, подвезли много дополнений к DOM API, оптимизацию потребления памяти DevTools и улучшения приватности. Подробности — в блоге Mozilla и [release notes](https://www.mozilla.org/en-US/firefox/93.0/releasenotes/).
</ParagraphWithImage>

Вышла бета [TypeScript 4.5](https://devblogs.microsoft.com/typescript/announcing-typescript-4-5-beta/). Релиз многообещающий: в новой версии появится поддержка компиляции в ES-модули, а из файлов можно будет импортировать типы и функции через один порт, добавив к типу идентификатор type. Также была представлена оптимизация условных типов, которая позволяет уменьшить потребление памяти. Релиз запланирован на 16 ноября. Это, конечно, не все изменения, подробнее о нововведениях можно прочитать в блоге TypeScript.

Доступна версия [Python 3.10](https://www.mail-archive.com/python-announce-list@python.org/msg09308.html). В этом релизе подвезли паттерн матчинг и реализовали операторы case и match. Еще одно значимое нововведение — намного более информативные сообщения об ошибках: даже появилась шутка, что фича оставила миллионы преподавателей Python без работы. Отличный релиз, полный список изменений вы найдете в release notes.

Вернемся к безопасности.

Запланирована [серия security-релизов Node.js](https://nodejs.org/en/blog/vulnerability/oct-2021-security-releases/). На этот раз без серьезных проблем. Релиз должен быть доступен уже сегодня и затронет версии 12, 14 и 16 популярного рантайма. Были исправлены 2 уязвимости средней опасности, о более серьезных ошибках не сообщалось.

Также серией релизов отметилась СУБД [Redis](https://github.com/redis/redis/releases/tag/6.2.6). Здесь уязвимостей было довольно много, целых 8 штук. Большая часть из них связана с переполнением буфера и манипуляциями при помощи Lua-скриптов. Разработчики проекта рекомендуют обновиться как можно скорее.

Ещё одна уязвимость была замечена в [PHP](https://github.com/mm0r1/exploits/tree/master/php-filter-bypass). Оказалось, что есть способ обойти директиву disable_functions в php.ini. Подробности можно прочитать в issue на GitHub.

Также на этой неделе отмечу релиз мобильной ОС [Android 12](https://android-developers.googleblog.com/2021/10/android-12-is-live-in-aosp.html) и веб-сервера [Lighttpd 1.4.60](https://www.lighttpd.net/2021/10/3/1.4.60/).

<ParagraphWithImage imageName="laptopNews" >
  ### Другие новости

В блоге разработки Google Chrome появилась статья [о первых результатах внедрения нового движка рендеринга RenderingNG](https://blog.chromium.org/2021/10/renderingng.html) и его компонентов. Пока речь, конечно, не идёт о полном внедрении — переход готовят постепенно, включая отдельные части и оптимизации. Собственно, результаты: графика рендерится в 6 раз быстрее, задержки при обработке страниц сократились на 8%, а время работы от аккумулятора увеличилось на полпроцента. Пока речь идет об оптимизациях, которые позволяют эффективнее использовать современные возможности процессоров, например, многоядерность. Были реализованы некоторые механизмы оптимизации растеризации и рендеринга разметки. Часть изменений будет доступна в Chrome уже в этом году.
</ParagraphWithImage>

Вы уже могли слышать, что в России появится [свой Фонд свободного программного обеспечения](https://www.rbc.ru/technology_and_media/04/10/2021/615757b29a7947a3df10e734). Некоммерческая организация призвана объединить крупнейшие компании и разработчиков свободного ПО, координировать деятельность разработчиков, научных и образовательных организаций. Идея, конечно, хорошая: развивать open source, привлекать студентов и устраивать конференции, не изобретать велосипед для разных проектов и инициатив. Но посмотрим, что из этого получится, потому что частенько выходит не «как лучше», а «как всегда». Увидим ли мы российский GitHub и прочие радости — покажет время, будем следить за развитием событий.

  ### Пишите нам и читайте
  [Telegram—канал CSSSR](https://t.me/csssr)

  [Twitter CSSSR](https://twitter.com/csssr_dev)

  [Twitter новостей](https://twitter.com/csssr_news)

  [Telegram ведущего](https://t.me/Vindizh)

  [Twitter ведущего](https://twitter.com/Vindizh)
