---
title: 'В этом выпуске: обзор ES2022, Java SE 17, оптимизация JS-бандла, работа с ArrayBuffer, CSS-свойство gap, тени, рендеринг видео в VideoNG, а также WebKit под капотом у других браузеров на iOS.'
soundcloudLink: 'https://soundcloud.com/csssr/es2022-java-se-17-optimizatsiya-js-bandla-arraybuffer-gap-teni-webkit-v-drugikh-brauzerakh-na-ios'
date: '2021-09-21T00:00:00.000Z'
episodeNumber: 191
tag: 'news'
author: 'Ислам Виндижев'
---

<ParagraphWithImage imageName="manWithLaptop">
  ### Интересные публикации

В блоге Timeweb Игорь Агапов рассказал, [что нас ждёт в новом стандарте JavaScript ES2022](https://habr.com/ru/company/timeweb/blog/577760/). Я освещал новые возможности стандарта, и если вы следили за новостями, то можете знать, что многие из новых фич уже поддерживаются движком V8 и браузерами. Итак, что же нас ждёт: await верхнего уровня, метод hasOwn(), метод at() для индексируемых объектов, флаг d для регулярных выражений и несколько новых фич для классов. Подробнее о каждой новой возможности с примерами и объяснением читайте в статье Игоря на Хабре.
</ParagraphWithImage>

Александр Шатилов в блоге компании Европлан опубликовал статью [о построении библиотек компонентов и их организации](https://habr.com/ru/company/europlan/blog/563464/). Кейс следующий: несколько приложений написаны на React, а несколько — на Angular, и встает вопрос, как обновлять компоненты. Решили разрабатывать компоненты на React, добавлять Angular-прослойку, публиковать пакет для React и для Angular, а после обновлять приложения целиком. Такой подход позволяет дорабатывать бизнес-логику только в одном месте.

Дейл Кёртис (Dale Curtis) из Google продолжил серию статей [о движке рендеринга RenderingNG](https://developer.chrome.com/blog/videong/). Новая статья касается части, которая отвечает за воспроизведение видео — VideoNG. Дейл рассказывает об эволюции и нахождении оптимального способа доставки видео, о том, как теперь выбираются аудио и видео-кодеки, и непосредственно о рендеринге видео для пользователя.

Егор Ермолаев в блоге Райффайзен банка опубликовал статью [о бинарных данных в JavaScript и типизированных массивах](https://habr.com/ru/company/raiffeisenbank/blog/578284/). На примере изображения формата BMP он показывает, как работает ArrayBuffer. Это не самый простой, но достаточно базовый пример. Егор отмечает, что типизированные массивы могут быть полезны во многих других задачах: например, для добавления водяного знака на изображение или видео, расчета размера изображения перед выводом на экран или чтения файлов из zip-архива.

Бен Шварц (Ben Schwarz) затронул тему [оптимизации JavaScript-бандла](https://calibreapp.com/blog/bundle-size-optimization). В своей статье он рассказывает, как размер бандла влияет на производительность, как понять, что бандл слишком большой, и на какие метрики производительности влияет размер бандла. Кроме того, он делится инструментами для автоматизации и мониторинга, касается серверного рендеринга, ленивой загрузки и бюджета производительности.

Ещё один материал про производительность и JavaScript. Нилант (Nilanth) на Medium опубликовал заметку [про code splitting](https://javascript.plainenglish.io/speed-up-your-react-app-initial-load-using-code-splitting-f2de58c01ed2). На примере дашборда он показывает, как можно разделить его компоненты по роутам, и оборачивает в suspense, а для каждого компонента собирается отдельный бандл. Этим он добивается улучшения метрики First Contentful Paint. Хочу напомнить, что применение code splitting — это не всегда хорошо и зависит от конкретного проекта.

Темани Афиф (Temani Afif) завершил свою серию статей на css-tricks о CSS Paint API. Третья часть посвящена [добавлению рамок для сложных фигур](https://css-tricks.com/exploring-the-css-paint-api-polygon-border/). При помощи clip-path сейчас можно довольно просто создать сложную фигуру, но по-прежнему очень больно сделать для нее рамку. Темани использует clip-path для создания самой фигуры, а потом при помощи Paint API создает маску такой же формы и накладывает на фигуру. Подробности — на css-tricks.

Патрик Броссе (Patrick Brosset) написал статью [о CSS-свойстве gap](https://css-tricks.com/minding-the-gap/). Свойство, конечно же, не новое, но дело в том, что теперь gap есть и у флексов. В статье Патрик рассказывает, как работает gap и связанные с ним свойства в гридах и флексах, какие есть особенности работы вертикальных и горизонтальных гэпов и как это всё сочетается с построением интерфейсов. Автор отмечает, что у gap очень хорошая поддержка в браузерах и пользоваться всеми возможностями очень даже можно. Получился крепкий гайд.

Новая статья от Джоша Комо (Josh Comeau). На этот раз она посвящена [теням](https://www.joshwcomeau.com/css/designing-shadows/). Вообще статьи Джоша нравятся мне тем, что они комплексные. Очень просто взять и реализовать фичу, а вот объяснить, для чего это нужно и как ложится на реальный мир, — совсем другое. Основных тем здесь три: зачем нужны тени для создания консистентной среды, как создавать более реалистичные тени, используя слои, и как задать тени правильный цвет. Конечно же, в статье есть примеры кода и несколько лайфхаков.

Сэм Тор (Sam Thor) в своем блоге опубликовал статью [об анимации при помощи CSS](https://whistlr.info/2021/box-model-animation/). Сэм обычно придерживается двух правил для анимации: использовать свойства, которые ускоряются графическим процессором, и использовать свойство will-change. Это позволяет анимациям быть «дешевыми» в смысле производительности. В этой статье же он рассуждает о том, что, возможно, иногда не так уж и страшно от этих правил отойти, и демонстрирует это на примере аккордеона.

В завершение рубрики хочу обратить ваше внимание на [КОД](http://designsystemsclub.ru/) или Клуб Отечественных Дизайн-систем. На страничке проекта вы можете увидеть дизайн-системы таких компаний, как Яндекс, ВКонтакте, Mail.ru, Газпром Нефть и других.

<ParagraphWithImage imageName="laptopNews" >
  ### Новости релизов

Доступно [Safari Technology Preview 132](https://webkit.org/blog/11971/release-notes-for-safari-technology-preview-132/). Здесь можно увидеть поддержку метода at(), о котором я говорил выше, генерацию ID при помощи Crypto, несколько новых методов API интернационализации. Также были представлены багфиксы веб-инспектора, доработки по CSS и Web API.
</ParagraphWithImage>

Oracle представила [Java SE 17](https://www.oracle.com/news/announcement/oracle-releases-java-17-2021-09-14/). В этой версии была стабилизирована поддержка запечатанных (sealed) классов, можно определять фильтры для десериализации данных, также была представлена более строгая инкапсуляция элементов JDK. Ещё одна и, наверное, самая интересная фича — улучшение паттерн матчинга: в case теперь может быть не точное значение, а шаблон, который охватывает какой-то диапазон. Больше подробностей — в release notes.

Завершат рубрику релизы [Ubuntu 18.04.6 LTS](https://lists.ubuntu.com/archives/ubuntu-announce/2021-September/000272.html) и [Kali Linux 2021.3](https://www.kali.org/blog/kali-linux-2021-3-release/).

<ParagraphWithImage imageName="laptopNews" >
  ### Другие новости

Нильс Леенхер (Niels Leenheer) в своем блоге опубликовал статью [о работе браузеров, отличных от Safari, в экосистеме Apple](https://nielsleenheer.com/articles/2021/chrome-is-the-new-safari-and-so-are-edge-and-firefox/). Эта статья находится в этом разделе потому, что больше касается вопросов политики Apple по отношению к другим браузерам на своей платформе. Нильс утверждает, что какой бы браузер вы ни запускали на iOS, он всё равно использует WebKit как движок, согласно одному из пунктов соглашения с Apple. Автор видит в этом много проблем. Во-первых, некоторые фичи, которые по идее должны работать в браузере, могут работать не так или не работать вовсе — например, вы запускаете Chrome, который поддерживает какую-то фичу, а WebKit не поддерживает, Chrome использует WebKit, в итоге это может привести к багам и нестабильной работе приложений. Во-вторых, вопрос монополии: другие браузеры никак не могут повлиять на то, как быстро будут появляться новые фичи в WebKit, но при этом не могут использовать свой движок рендеринга. Мне, честно говоря, даже в голову такое не приходило и стало интересно проверить, так ли это, как говорит Нильс. Подробнее с его рассуждениями и выводами можно ознакомиться в статье.
</ParagraphWithImage>

Ещё одна новость от Oracle. Компания представила [новую лицензию JDK](https://blogs.oracle.com/java/post/free-java-license), согласно которой JDK можно бесплатно использовать в коммерческих целях. Старая лицензия разрешала бесплатное применение только для разработки программ лично для себя, тестирования, создания прототипов и демонстрации приложений.

  ### Пишите нам и читайте
  [Telegram—канал CSSSR](https://t.me/csssr)

  [Twitter CSSSR](https://twitter.com/csssr_dev)

  [Twitter новостей](https://twitter.com/csssr_news)

  [Telegram ведущего](https://t.me/Vindizh)

  [Twitter ведущего](https://twitter.com/Vindizh)
