---
title: 'В этом выпуске: Chrome 93, TypeScript 4.4, чистая архитектура и гексагональная архитектура SPA, карго-культ TypeScript, Deno на MDN и 30 лет Linux.'
soundcloudLink: 'https://soundcloud.com/csssr/chrome-93-firefox-92-typescript-44-chistaya-arkhitektura-i-spa-geksagon-deno-na-mdn-30-let-linux'
date: '2021-09-10T00:00:00.000Z'
episodeNumber: 188
tag: 'news'
author: 'Ислам Виндижев'
---

Небольшое объявление: после всеобщих отпусков мы возвращаемся к старому графику и продолжим делать два выпуска новостей в неделю. В планах также провести опрос среди слушателей и читателей для улучшения подкаста, и я очень рассчитываю на вашу помощь. Спасибо, что остаетесь с нами!

<ParagraphWithImage imageName="manWithLaptop">
  ### Интересные публикации

Саша Беспоясов по мотивам своего [доклада](https://www.youtube.com/watch?v=h4WQRqNjmX0) о чистой архитектуре во фронтенде написал [развернутую статью](https://bespoyasov.ru/blog/clean-architecture-on-frontend/). Сначала он раскрывает понятие «чистая архитектура», рассказывает о разных слоях приложения, а также плюсах и минусах чистой архитектуры, а затем переходит к практике. В качестве упражнения предлагается спроектировать архитектуру онлайн-магазина печенек. В статье вы увидите пример разделения приложения на слои, использование паттернов, а также заметки о том, что можно улучшить и что может оказаться более сложным в реальном production-приложении. Помимо этого есть ссылки на доклад, исходники приложения и работающий пример.
</ParagraphWithImage>

Ещё один пост об архитектуре. Александр Мадьянкин из Злых Марсиан написал статью [о гексагональной архитектуре SPA-приложения](https://evilmartians.com/chronicles/spa-hexagon-robust-app-architecture-for-mobile-and-web), которое работало как в вебе, так и на мобильных устройствах. Здесь вы тоже можете увидеть пример разделения приложения на слои, подключение к нему разных сервисов по граням гексагона и узнаете, как и почему можно обойтись без Apollo в таких проектах. Естественно, это уже кейс реального приложения, было интересно.

Инженеры Shopify [отказались от Sass](https://github.com/Shopify/polaris/discussions/44) в своей дизайн-системе Polaris. В процессе разработки появилось множество болей, о которых и рассказал автор дизайн-системы Алекс Пейдж (Alex Page). Он также сравнил альтернативы: TailwindCSS, CSS-модули, Stitches и vanilla-extract. В итоге выбор пал на vanilla-extract, это примерно CSS в TypeScript без рантайм оверхеда. Штука интересная, можно присмотреться.

В одном из предыдущих выпусков я рассказывал о новом проекте по рендерингу в браузере RenderingNG от Google. Разработчики продолжают приоткрывать завесу тайны и написали [статью о структурах данных](https://developer.chrome.com/blog/renderingng-data-structures/), которые будут нужны для рендеринга. Всего этих структур 5: дерево фреймов, иммутабельное дерево фрагментов, списки отображения и области заливки и композиционные фреймы. Как все эти структуры данных будут работать и взаимодействовать, а также за что каждая структура будет отвечать, коллектив авторов подробно описал текстом и понятными схемами. Будем ждать следующих статей.

[«Карго-культ TypeScript в украинских аутсорсерах»](https://youtu.be/H9-F8uhKMRk) — именно так называется новый доклад Ильи Климова. Чтобы вы в полной мере ощутили масштаб трагедии, я немного окунусь в историю и расскажу, откуда взялся термин карго-культ. Карго-культы — это культы «самолетопоклонников». Культисты (в основном, островитяне) считали, что всё, что сбрасывают с самолетов, и другие привычные нам предметы — магические и приходят из мира духов. Широкое распространение культы получили во время Второй мировой, когда военные организовывали базы на островах и поставляли местным жителям товары. После окончания войны и разгруппировки баз грузы с неба падать перестали, и островитяне имитировали действия военных и моряков в надежде, что это привлечет самолёты обратно. Сейчас мы говорим так, когда хотим сказать, что кто-то использует что-то без понимания. Именно об этом доклад Ильи. Он рассказывает, что TS — не панацея, и какие-то задачи он решает, а какие-то — нет. Кроме того, Илья упоминает, как отказаться от TypeScript, чтобы действительно повысить надежность и снизить издержки.

Робин Маркс (Robin Marx) завершил свою серию статей об HTTP/3 на SmashingMagazine. Успели выйти вторая и третья части. Вторая часть посвящена [производительности HTTP/3](https://www.smashingmagazine.com/2021/08/http3-performance-improvements-part2/): если вкратце, новый протокол существенно поможет улучшить производительность для медленных сетей. В третьей части Робин рассказывает о том, что может измениться для наших приложений с приходом нового протокола и [как подготовиться к грядущим изменениям](https://www.smashingmagazine.com/2021/09/http3-practical-deployment-options-part3/).

Также на SmashingMagazine Адриан Беце (Adrian Bece) выложил третью статью о рефакторинге CSS. Эта часть — [об оптимизации размера и производительности](https://www.smashingmagazine.com/2021/08/refactoring-css-optimizing-size-performance-part3/). Адриан пишет о минификации и оптимизации медиа-запросов, устранении блокирования рендера и других узких местах. Он касается и сервера, говоря о том, как закешировать CSS и как выбрать между CDN и самостоятельным хостингом ресурсов.

Давайте представим себе огромную форму, которую можно скроллить до бесконечности. Что делать, чтобы пользователь не умер от старости или не покинул страницу? Правильно, разбить на шаги. Именно такой компонент в своей [новой статье](https://ishadeed.com/article/stepper-component-html-css/) создает Ахмад Шадид (Ahmad Shadeed). Он реализует вертикальную и горизонтальную версии компонента, а также подробно разбирает, как без лишних усилий сделать его респонсивным, и пошагово проводит через реализацию.

Закроют рубрику [список лучших книг по TypeScript](https://reconshell.com/best-typescript-books/) и [набор интерактивных инструментов для изучения фронтенда](https://www.smashingmagazine.com/2021/09/interactive-learning-tools-front-end-developers/) от Луи Лазариса (Louis Lazaris), в котором найдутся ресурсы по JS и TypeScript, регулярным выражениям, SQL, git и другим технологиям.

<ParagraphWithImage imageName="laptopNews" >
  ### Новости релизов

Вышел [Chrome 93](https://developer.chrome.com/blog/new-in-chrome-93/). Была добавлена поддержка CSS-модулей в JavaScript. Прогрессивные веб-приложения теперь могут быть зарегистрированы в качестве обработчиков URL, а окно PWA и элементы управления можно кастомизировать. В DevTools добавлена поддержка отладки выражений от контейнера или Container Query. Появилась поддержка отображения содержимого веб-бандла во вкладке Network. Добавлены новые опции для копирования строк из консоли. Lighthouse обновили до версии 8.1. И это ещё не всё. Как было объявлено ранее, Chrome переходит на новый релизный цикл. Новая версия будет выходить раз в 4 недели. Подробнее о релизе и новинках DevTools — в обзорах [Пита Ле Пейджа](https://www.youtube.com/watch?v=R5RUVO_g2NI) и [Джеселин Ин](https://www.youtube.com/watch?v=1VaPAnUGRz8) на YouTube.
</ParagraphWithImage>

Вышел [Mozilla Firefox 92](https://hacks.mozilla.org/2021/09/time-for-a-review-of-firefox-92/). В JS-движок была добавлена поддержка метода Object.hasOwn(). Больше всего дополнений было для CSS: теперь Firefox поддерживает свойство accent-color для кастомизации нативных элементов форм, кроме того, апгреднули работу со шрифтами свойствами font-adjust и font-size-adjust.

Доступен [TypeScript 4.4](https://devblogs.microsoft.com/typescript/announcing-typescript-4-4/). Наверное, лучшее из нововведений касается проверки типов. Теперь проверку, или тайпгард, можно вынести в переменную и гораздо лаконичнее использовать далее в коде — позволяет писать чище, экономит время и нервы, но раньше это было ошибкой компиляции. Catch блоки теперь будут немного более предсказуемыми, потому что по умолчанию они будут неявно приводиться к Unknown. С этой версии появилась поддержка inlay hints — это подсказка типов и имен аргументов. В редакторах это уже давно реализовано, теперь есть и на уровне компилятора. Были и другие, более мелкие нововведения. Примеры применения новых фич в коде и больше подробностей — в анонсе.

Подъехали [августовские security-релизы Node.js](https://nodejs.org/en/blog/vulnerability/aug-2021-security-releases2/). Релизы затронули версии 12 и 14. В обеих версиях были исправлены три особо опасных уязвимости и две средней тяжести. Они были связаны с модулями arborist и npm cli и позволяли создавать и перезаписывать файлы, а также исполнять произвольный код в определенных условиях. Команда проекта рекомендует срочно обновиться.

Экспресс-новость из мира PHP. Доступен [первый релиз-кандидат PHP 8.1](https://laravel-news.com/php-8-1-release-candidate-1). Команда разработки напоминает, что пользоваться этой версией ещё рано. Больше подробностей будет ближе к финальному релизу.

Также отмечу релизы [Cypress 8.3.0](https://github.com/cypress-io/cypress/releases/tag/v8.3.0), [Mocha 9.1.0](https://github.com/mochajs/mocha/releases/tag/v9.1.0), [Laravel 8.58](https://laravel-news.com/laravel-8-58-0), [nginx 1.21.2](https://mailman.nginx.org/pipermail/nginx-announce/2021/000306.html) и ядра [Linux 5.14](https://lkml.org/lkml/2021/8/29/382).

<ParagraphWithImage imageName="laptopNews" >
  ### Другие новости

Запоздало, но [о тридцатилетии Linux](https://www.opennet.ru/opennews/art.shtml?num=55678). 25 августа 1991 года был анонсирован рабочий прототип — тогда ещё студент Линус Торвальдс за 5 месяцев разработал ядро операционной системы. В сентябре того же года состоялся первый релиз. Линус был вдохновлен операционной системой MINIX, проблема которой была в ограниченной лицензии. С этого началось развитие ядра и рождение бесчисленного количества разных операционных систем с одним и тем же ядром: Ubuntu, Debian, Arch Linux и многих других. Немного цифр: в кодовой базе ядра — почти 30 миллионов строк, в версии ядра 5.13 были коммиты от рекордного числа разработчиков — 2150. Мысленно похлопайте этому событию и одному из крупнейших элементов фундамента свободного ПО.
</ParagraphWithImage>

Продолжается развитие проекта Deno. Напомню, это рантайм JavaScript и TypeScript от создателя Node.js Райана Дала. Теперь Deno можно увидеть [на страницах MDN](https://deno.com/blog/deno-on-mdn) в таблицах совместимости фич. Это связано с тем, что Deno проходит тесты Web Platform Test и поэтому занял свое место в пантеоне веб-технологий. Для проекта это достаточно серьезный шаг вперед.

  ### Пишите нам и читайте
  [Telegram—канал CSSSR](https://t.me/csssr)

  [Twitter CSSSR](https://twitter.com/csssr_dev)

  [Twitter новостей](https://twitter.com/csssr_news)

  [Telegram ведущего](https://t.me/Vindizh)

  [Twitter ведущего](https://twitter.com/Vindizh)
